% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRihw.R
\name{MRihw,fitZigResults-method}
\alias{MRihw,fitZigResults-method}
\title{MRihw runs IHW within a MRcoefs() call}
\usage{
\S4method{MRihw}{fitZigResults}(obj, p, adjustMethod, alpha)
}
\arguments{
\item{obj}{Either a fitFeatureModelResults or fitZigResults object}

\item{p}{a vector of pvalues extracted from obj}

\item{adjustMethod}{Value specifying which adjustment method and which covariate to use for IHW pvalue adjustment. 
For obj of class \code{\link{fitFeatureModelResults-class}}, options are "ihw-abundance" (median feature count per row) 
and "ihw-ubiquity" (number of non-zero features per row). For obj of class \code{\link{fitZigResults-class}}, 
options are "ihw-abundance" (weighted mean per feature) and "ihw-ubiquity" (number of non-zero features per row).}

\item{alpha}{pvalue significance level specified for IHW call. Default is 0.1}
}
\description{
Function used in MRcoefs() when "IHW" is set as the p value adjustment method
}
