% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSample.R
\name{collapseNoMismatch}
\alias{collapseNoMismatch}
\title{Combine together sequences that are identical up to shifts and/or length.}
\usage{
collapseNoMismatch(
  seqtab,
  minOverlap = 20,
  orderBy = "abundance",
  identicalOnly = FALSE,
  vec = TRUE,
  band = -1,
  verbose = FALSE
)
}
\arguments{
\item{seqtab}{(Required). A sample by sequence matrix, the return of \code{\link{makeSequenceTable}}.}

\item{minOverlap}{(Optional). \code{numeric(1)}. Default 20.
The minimum amount of overlap between sequences required to collapse them together.}

\item{orderBy}{(Optional). \code{character(1)}. Default "abundance".
Specifies how the sequences (columns) of the returned table should be ordered (decreasing).
Valid values: "abundance", "nsamples", NULL.}

\item{identicalOnly}{(Optional). \code{logical(1)}. Default FALSE.
If TRUE, only identical sequences (i.e. duplicates) are collapsed together.}

\item{vec}{(Optional). \code{logical(1)}. Default TRUE.
Use the vectorized aligner. Should be turned off if sequences exceed 2kb in length.}

\item{band}{(Optional). \code{numeric(1)}. Default -1 (no banding). The Needleman-Wunsch 
alignment can be banded. This value specifies the radius of that band. Set band = -1 
to turn off banding.}

\item{verbose}{(Optional). \code{logical(1)}. Default FALSE.
If TRUE, a summary of the function results are printed to standard output.}
}
\value{
Named integer matrix.
A row for each sample, and a column for each collapsed sequence across all the samples.
Note that the columns are named by the sequence which can make display a little unwieldy.
Columns are in the same order (modulo the removed columns) as in the input matrix.
}
\description{
This function takes as input a sequence table and returns a sequence table in which
any sequences that are identical up to shifts or length variation, i.e. that have
no mismatches or internal indels when aligned, are collapsed together. The most abundant
sequence is chosen as the representative of the collapsed sequences. This function can
be thought of as implementing greedy 100\% OTU clustering with end-gapping ignored.
}
\examples{
derep1 <- derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
derep2 <- derepFastq(system.file("extdata", "sam2F.fastq.gz", package="dada2"))
dada1 <- dada(derep1, tperr1)
dada2 <- dada(derep2, tperr1)
seqtab <- makeSequenceTable(list(sample1=dada1, sample2=dada2))
collapseNoMismatch(seqtab)

}
\seealso{
\code{\link{makeSequenceTable}}
}
