# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class NotificationTestCase(IntegrationTestCase):

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .configuration \
                                        .notifications().update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://conversations.twilio.com/v1/Services/ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Configuration/Notifications',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "chat_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "log_enabled": true,
                "added_to_conversation": {
                    "enabled": false,
                    "template": "You have been added to a Conversation: ${CONVERSATION}",
                    "sound": "ring"
                },
                "new_message": {
                    "enabled": false,
                    "template": "You have a new message in ${CONVERSATION} from ${PARTICIPANT}: ${MESSAGE}",
                    "badge_count_enabled": true,
                    "sound": "ring",
                    "with_media": {
                        "enabled": false,
                        "template": "You have a new message in ${CONVERSATION} with ${MEDIA_COUNT} media files: ${MEDIA}"
                    }
                },
                "removed_from_conversation": {
                    "enabled": false,
                    "template": "You have been removed from a Conversation: ${CONVERSATION}",
                    "sound": "ring"
                },
                "url": "https://conversations.twilio.com/v1/Services/ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Configuration/Notifications"
            }
            '''
        ))

        actual = self.client.conversations.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                             .configuration \
                                             .notifications().update()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.conversations.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .configuration \
                                        .notifications().fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://conversations.twilio.com/v1/Services/ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Configuration/Notifications',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "chat_service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "log_enabled": false,
                "added_to_conversation": {
                    "enabled": true,
                    "template": "You have been added to a Conversation: ${CONVERSATION}",
                    "sound": "ring"
                },
                "new_message": {
                    "enabled": true,
                    "template": "You have a new message in ${CONVERSATION} from ${PARTICIPANT}: ${MESSAGE}",
                    "badge_count_enabled": false,
                    "sound": "ring",
                    "with_media": {
                        "enabled": false,
                        "template": "You have a new message in ${CONVERSATION} with ${MEDIA_COUNT} media files: ${MEDIA}"
                    }
                },
                "removed_from_conversation": {
                    "enabled": true,
                    "template": "You have been removed from a Conversation: ${CONVERSATION}",
                    "sound": "ring"
                },
                "url": "https://conversations.twilio.com/v1/Services/ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Configuration/Notifications"
            }
            '''
        ))

        actual = self.client.conversations.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                             .configuration \
                                             .notifications().fetch()

        self.assertIsNotNone(actual)
