from typing import Iterable, Collection, List, Set, Mapping, Tuple, TypeVar, Iterator, Generator, Union, overload

E = TypeVar('E')
K = TypeVar('K')
V = TypeVar('V')


class _JIterable(Iterable[E]):
    def __iter__(self) -> Iterator[E]: ...


class _JCollection(Collection[E]):
    def __len__(self) -> int: ...

    def __delitem__(self, i: E) -> None: ...

    def __contains__(self, i: E) -> bool: ...


class _JList(List[E]):
    @overload
    def __getitem__(self, ndx: int) -> E: ...

    @overload
    def __getitem__(self, ndx: slice) -> E: ...

    def __setitem__(self, ndx: int, v: E) -> None: ...

    def __delitem__(self, ndx: int) -> E: ...

    def __reversed__(self) -> Generator[E, None, None]: ...

    def index(self, obj: E) -> int: ...

    def count(self, obj: E) -> int: ...

    def insert(self, idx: int, obj: E) -> '_JList'[E]: ...

    def append(self, obj: E) -> '_JList'[E]: ...

    def reverse(self) -> None: ...

    def extend(self, lst: Iterable[E]) -> None: ...

    def pop(self, idx: int = ...) -> E: ...

    def __iadd__(self, obj: List[E]) -> '_JList'[E]: ...

    def __add__(self, obj: List[E]) -> '_JList'[E]: ...

    def remove(self, obj: E) -> None: ...


class _JMap(Mapping[K, V]):
    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[K]: ...

    def __delitem__(self, i: K) -> V: ...

    def __getitem__(self, ndx: K) -> V: ...

    def __setitem__(self, ndx: K, v: V) -> None: ...

    def items(self) -> Set['_JMapEntry'[K, V]]: ...

    def keys(self) -> Set[K]: ...

    def __contains__(self, item: V) -> bool: ...


class _JSet(Set[E]):
    def __delitem__(self, i: E): ...


class _JMapEntry(Tuple[K, V]):
    def __len__(self) -> int: ...

    def __getitem__(self, x: int) -> Union[K, V]: ...


class _JIterator(Iterator[E]):
    def __next__(self) -> E: ...

    def __iter__(self) -> Iterator[E]: ...


class _JEnumeration(Iterator[E]):
    def __next__(self) -> E: ...

    def __iter__(self) -> Iterator[E]: ...

    def next(self) -> E: ...
