#!/usr/bin/env python
# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0
from __future__ import annotations

'''Test cases for implicit conversion generated by conversion operator.'''

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from shiboken_paths import init_paths
init_paths()

from sample import Time, StrList


class ConversionOperatorTest(unittest.TestCase):
    '''Test cases for implicit conversion generated by conversion operator.'''

    def testConversionOperator(self):
        '''Time defined an conversion operator for Str, so passing a Time object
           to a method expecting a Str should work.'''
        t = Time(1, 2, 3)
        t_str = t.toString()
        sl = StrList()

        # StrList.append expects a Str object.
        sl.append(t)

        self.assertEqual(len(sl), 1)
        self.assertEqual(sl[0], t_str)


if __name__ == '__main__':
    unittest.main()
