/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QMainWindow>
#include <QTimer>
#include <QDialog>


/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/jsclassregistrar.h"

namespace Ui
{
class DecimalPlacesOptionsDlg;
}

namespace MsXpS
{
namespace libXpertMassGui
{


  /*  BEGIN CLASS JS REFERENCE
   *  namespace: MsXpS::libXpertMassGui
   *  class name: DecimalPlacesOptionsDlg
   *
   * BEGIN DESCRIPTION
   * This class allows the user to configure the number of decimals
   * to be used when textually representing the mass values of various
   * chemical entities.
   * END DESCRIPTION
   */

class DECLSPEC DecimalPlacesOptionsDlg: public QDialog
{
  Q_OBJECT

  Q_PROPERTY(int atomDecPlaces MEMBER m_atomDecPlaces)
  Q_PROPERTY(int oligomerDecPlaces MEMBER m_oligomerDecPlaces)
  Q_PROPERTY(int polymerDecPlaces MEMBER m_polymerDecPlaces)
  Q_PROPERTY(int pkaPhPiDecPlaces MEMBER m_pkaPhPiDecPlaces)

  public:
  DecimalPlacesOptionsDlg(QWidget *, const QString &configSettingsFilePath);

  ~DecimalPlacesOptionsDlg();

  Q_INVOKABLE void
  updateDecimalPlaces(int atom, int oligo, int poly, int pka_ph);

  static void registerJsConstructor(QJSEngine *engine);

  public slots:
  void validate();

  signals:
  void decimalPlacesOptionsChangedSignal();

  private:
  Ui::DecimalPlacesOptionsDlg *mp_ui;

  QString m_configSettingsFilePath;

  int m_atomDecPlaces     = 10;
  int m_oligomerDecPlaces = 6;
  int m_polymerDecPlaces  = 3;
  int m_pkaPhPiDecPlaces  = 2;

  void closeEvent(QCloseEvent *event);

  bool fetchValidateInputData();
};


  /*  END CLASS JS REFERENCE
   *  namespace: MsXpS::libXpertMassGui
   *  class name: DecimalPlacesOptionsDlg
   */

} // namespace libXpertMassGui
MSXPS_REGISTER_JS_CLASS(MsXpS::libXpertMassGui, DecimalPlacesOptionsDlg)
} // namespace MsXpS

