/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_msb.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  double t645, t655, t656, t657, t658, t659, t665, t667;
  double t668, t669, t670, t671, t672, t673, t674, t675;
  double t677, t678, t694, t698, t700, t704, t706, t710;
  double t711, t712, t716, t718, t719, t725, t726, t734;
  double t735, t736, t737, t741, t744, t747, t748, t751;
  double t754, t763, t766, t769, t770, t779, t780, t784;
  double t785, t788, t789, t799, t802, t803, t806, t809;
  double t812, t817, t820, t823, t836, t837, t846, t847;
  double t852, tv3rho30, t862, t863, t867, t870, t872, t875;
  double t876, t879, t880, t883, t884, t887, t888, t891;
  double t894, t897, t898, t901, t904, t905, t908, t910;
  double t913, t915, t920, t925, t931, t933, t934, t935;
  double t936, t938, t939, t941, t942, t944, t945, t947;
  double t948, t949, t951, t953, t954, t955, t957, t958;
  double t960, t962, t964, t966, t968, t971, t973, t974;
  double t976, t979, t981, t987, t1013, t1015, t1016, t1018;
  double t1022, t1025, t1026, t1027, t1028, t1031, t1033, t1034;
  double t1039, t1040, t1043, t1048, t1051, t1055, t1057, t1058;
  double t1059, t1068, t1070, t1072, t1077, tv3rho2sigma0, tv3rho2lapl0, t1087;
  double t1088, t1089, t1098, t1099, t1119, t1125, t1147, t1149;
  double t1150, t1153, t1158, t1165, t1168, t1172, t1176, t1180;
  double t1190, t1191, t1193, t1201, t1208, t1209, t1210, t1212;
  double t1215, t1220, t1226, t1236, t1237, t1240, t1242, t1245;
  double t1246, t1251, tv3rho2tau0, t1258, t1261, t1263, t1267, t1285;
  double t1286, t1287, t1288, t1291, t1295, t1297, t1298, t1306;
  double t1311, t1312, t1317, t1318, t1321, t1324, t1325, t1328;
  double t1329, t1334, t1335, t1338, t1339, t1340, t1343, t1346;
  double t1347, t1348, t1349, t1352, t1359, t1360, t1364, t1365;
  double t1368, t1371, t1374, t1375, t1378, t1381, t1384, t1387;
  double t1389, t1391, t1393, t1395, t1396, t1398, t1400, t1403;
  double t1405, t1406, t1408, t1413, t1415, t1420, tv3rhosigma20, tv3rhosigmalapl0;
  double t1426, t1427, t1428, t1433, t1434, t1435, t1438, t1485;
  double t1486, t1487, t1490, t1491, t1492, t1495, t1498, t1501;
  double t1503, t1504, t1507, t1508, t1510, t1513, t1515, t1517;
  double t1520, t1523, t1526, t1528, t1529, t1531, t1533, t1535;
  double t1539, t1540, t1545, t1546, t1549, t1551, t1554, t1561;
  double t1564, t1567, t1572, t1575, t1580, t1581, t1586, tv3rhosigmatau0;
  double tv3rholapl20, tv3rholapltau0, t1594, t1597, t1600, t1603, t1604, t1607;
  double t1626, t1630, t1631, t1634, t1636, t1637, t1640, t1641;
  double t1643, t1646, t1647, t1656, t1668, t1684, t1691, t1698;
  double t1705, t1706, t1708, t1709, t1714, tv3rhotau20, t1717, t1722;
  double t1724, t1726, t1728, t1732, t1733, t1739, t1740, t1744;
  double t1747, t1750, t1754, t1755, t1757, t1758, t1760, t1763;
  double t1764, t1767, t1770, t1775, t1776, t1779, t1783, tv3sigma30;
  double tv3sigma2lapl0, t1813, t1816, t1819, t1822, t1823, t1828, t1830;
  double t1834, t1836, t1837, t1839, t1841, t1842, t1844, t1847;
  double t1850, t1851, t1856, t1857, t1861, t1862, t1863, t1866;
  double t1867, t1870, t1871, t1875, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1877;
  double t1878, t1879, t1882, t1885, t1888, t1891, t1892, t1893;
  double t1896, t1908, t1915, t1919, t1921, t1922, t1925, t1931;
  double t1937, t1943, t1947, t1949, t1950, t1952, t1954, t1956;
  double t1957, t1959, t1960, t1964, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t1966, t1967, t1970, t1973, t1985, t1987, t1988, t1990;
  double t1992, t1993, t1996, t1997, t2007, t2010, t2013, t2016;
  double t2019, t2020, t2022, t2026, tv3tau30;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t645 = t18 * t33;
  t655 = t122 * t122;
  t656 = 0.1e1 / t655;
  t657 = t59 * t656;
  t658 = t289 * t141;
  t659 = t81 * t658;
  t665 = t94 * t94;
  t667 = t93 / t665;
  t668 = t22 * t22;
  t669 = 0.1e1 / t668;
  t670 = t229 * sigma[0];
  t671 = t669 * t670;
  t672 = t231 * t231;
  t673 = t672 * t99;
  t674 = 0.1e1 / t673;
  t675 = t671 * t674;
  t677 = 0.16e5 / 0.43046721e8 * t667 * t675;
  t678 = t57 * t123;
  t694 = t58 * t287;
  t698 = t144 * t144;
  t700 = t93 / t698;
  t704 = 0.1e1 / t19 / t672;
  t706 = t230 * t27 * t704;
  t710 = 0.1e1 / t31 / t274;
  t711 = t28 * t710;
  t712 = t98 * t711;
  t716 = 0.44e4 / 0.531441e6 * t226 * t706;
  t718 = 0.154e4 / 0.6561e4 * t97 * t712;
  t719 = -0.16e5 / 0.43046721e8 * t700 * t675 + 0.44e4 / 0.531441e6 * t335 * t706 - 0.154e4 / 0.6561e4 * t147 * t712 + t677 - t716 + t718;
  t725 = params->b * t60;
  t726 = t257 * t112;
  t734 = 0.1e1 / t322 / t52;
  t735 = t272 * tau[0];
  t736 = t734 * t735;
  t737 = 0.1e1 / t672;
  t741 = t273 * t356;
  t744 = t42 * t240;
  t747 = t47 * t127;
  t748 = t747 * t257;
  t751 = t271 * t268;
  t754 = t48 * t304;
  t763 = -0.44e3 / 0.27e2 * t744 + 0.154e3 / 0.27e2 * t29 * t710;
  t766 = t112 * t268;
  t769 = t60 * t70;
  t770 = t735 * t737;
  t779 = t310 * t137;
  t780 = t257 * tau[0];
  t784 = t268 * tau[0];
  t785 = t784 * t165;
  t788 = t132 * t323;
  t789 = t112 * t272;
  t799 = 0.768e4 * t725 * t70 * t726 + 0.576e4 * t310 * t133 * t268 + 0.3584e7 / 0.9e1 * t67 * t736 * t737 - 0.128e5 / 0.3e1 * t305 * t741 + 0.352e4 / 0.9e1 * t128 * t744 + 0.72e3 * t748 * t108 + 0.36e3 * t751 * t108 + 0.48e4 * t754 * t112 * t277 + 0.48e2 * t726 * t62 + 0.24e2 * t115 * t763 + 0.144e3 * t260 * t766 + 0.8e5 / 0.9e1 * t769 * t770 + 0.384e3 * t132 * t70 * t763 - 0.3072e5 * t314 * t315 * t102 + 0.576e5 * t779 * t780 * t165 + 0.1152e5 * t314 * t785 + 0.2688e6 * t788 * t789 * t403 - 0.3584e6 / 0.3e1 * t324 * t741 + 0.5632e5 / 0.9e1 * t138 * t744 - 0.96e3 * t298 * t264;
  t802 = t246 * t118;
  t803 = t802 * t74;
  t806 = t150 * t246;
  t809 = t340 * t118;
  t812 = t150 * t282;
  t817 = t257 * t62;
  t820 = t747 * t112;
  t823 = t260 * t268;
  t836 = -0.24e2 * t379 * t268 - 0.8e2 * t817 * t108 - 0.8e3 * t820 * t277 - 0.8e2 * t823 * t108 + 0.64e3 / 0.3e1 * t261 * t264 - 0.8e1 * t107 * t763 - 0.16e5 / 0.9e1 * t754 * t770 + 0.32e4 / 0.3e1 * t271 * t741 - 0.352e4 / 0.27e2 * t115 * t744;
  t837 = t81 * t836;
  t846 = -0.3e1 * t124 * t340 * t141 - 0.3e1 * t124 * t150 * t329 - t124 * t81 * t799 + 0.6e1 * t288 * t150 * t289 + 0.9e1 * t106 * t809 + 0.9e1 * t106 * t812 + 0.3e1 * t106 * t837 + 0.18e2 * t245 * t806 + 0.6e1 * t803 * t81 + t716 - t718;
  t847 = 0.18e2 * t245 * t119 * t282 - 0.9e1 * t250 * t119 * t329 + 0.18e2 * t694 * t119 * t289 - 0.18e2 * t678 * t247 * t141 - 0.18e2 * t250 * t254 * t141 - 0.9e1 * t250 * t283 * t141 + 0.6e1 * t288 * t142 * t329 - 0.6e1 * t657 * t659 + t75 * t719 - t677 + t846;
  t852 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t83 + t7 * t216 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t342 - 0.3e1 / 0.8e1 * t7 * t20 * t847);
  tv3rho30 = 0.2e1 * rho[0] * t852 + 0.6e1 * t347;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t862 = t356 * tau[0];
  t863 = t384 * t862;
  t867 = t366 * t101 * t118;
  t870 = t694 * t364;
  t872 = t366 * t33 * t289;
  t875 = t101 * t141;
  t876 = t366 * t875;
  t879 = t33 * t329;
  t880 = t366 * t879;
  t883 = t150 * t47;
  t884 = t106 * t883;
  t887 = t81 * t112;
  t888 = t106 * t887;
  t891 = t245 * t883;
  t894 = t245 * t887;
  t897 = t33 * t282;
  t898 = t366 * t897;
  t901 = t250 * t883;
  t904 = -0.32e2 * t365 * t867 + 0.6e1 * t365 * t898 + 0.12e2 * t891 * t368 + 0.12e2 * t894 * t368 + 0.16e2 * t371 * t876 - 0.3e1 * t371 * t880 - 0.6e1 * t901 * t373 - 0.16e3 * t383 * t863 + 0.4e2 * t884 * t386 + 0.4e2 * t888 * t386 + 0.6e1 * t870 * t872;
  t905 = t250 * t887;
  t908 = t276 * t141;
  t910 = t384 * t908 * tau[0];
  t913 = t678 * t364;
  t915 = t366 * t367 * t141;
  t920 = t384 * t276 * t118 * tau[0];
  t925 = t180 * t282;
  t931 = t817 * t165;
  t933 = t747 * t27;
  t934 = t276 * t112;
  t935 = t934 * tau[0];
  t936 = t933 * t935;
  t938 = t102 * t112;
  t939 = t260 * t938;
  t941 = t165 * t268;
  t942 = t260 * t941;
  t944 = t737 * t272;
  t945 = t754 * t944;
  t947 = t27 * t356;
  t948 = t947 * tau[0];
  t949 = t271 * t948;
  t951 = t115 * t241;
  t953 = t725 * t70;
  t954 = t165 * t257;
  t955 = t953 * t954;
  t957 = t403 * t315;
  t958 = t779 * t957;
  t960 = t409 * t938;
  t962 = t409 * t941;
  t964 = t323 * t737;
  t966 = t132 * t964 * t272;
  t968 = t314 * t948;
  t971 = t132 * t171 * t240;
  t973 = -0.6e1 * t931 - 0.12e3 * t936 + 0.32e2 * t939 - 0.6e1 * t942 - 0.4e3 * t945 + 0.24e3 * t949 - 0.88e2 / 0.3e1 * t951 - 0.96e3 * t955 - 0.96e4 * t958 + 0.128e4 * t960 - 0.24e3 * t962 - 0.224e5 * t966 + 0.768e4 * t968 - 0.1408e4 / 0.3e1 * t971;
  t974 = t81 * t973;
  t976 = t429 * t118;
  t979 = t340 * t175;
  t981 = t150 * t417;
  t987 = -0.2e1 * t124 * t429 * t141 - t124 * t180 * t329 - 0.6e1 * t657 * t176 * t289 + 0.3e1 * t106 * t925 + 0.6e1 * t106 * t976 - t124 * t974 - t124 * t979 - 0.2e1 * t124 * t981 + 0.8e2 * t365 * t920 - 0.4e2 * t371 * t910 - 0.6e1 * t905 * t373 - 0.12e2 * t913 * t915;
  t1013 = t672 * t30;
  t1015 = t669 / t1013;
  t1016 = t1015 * t229;
  t1018 = 0.2e4 / 0.14348907e8 * t667 * t1016;
  t1022 = t180 * t246;
  t1025 = -0.6e1 * t250 * t398 * t118 - 0.6e1 * t250 * t418 * t118 - 0.6e1 * t250 * t420 * t141 + 0.4e1 * t288 * t398 * t141 + 0.4e1 * t288 * t418 * t141 - 0.6e1 * t678 * t176 * t246 - 0.3e1 * t250 * t176 * t282 + 0.2e1 * t288 * t176 * t329 + 0.2e1 * t288 * t180 * t289 + 0.6e1 * t245 * t1022 + t1018;
  t1026 = t694 * t81;
  t1027 = t175 * t118;
  t1028 = t1027 * t141;
  t1031 = t160 * t240;
  t1033 = 0.11e3 / 0.2187e4 * t97 * t1031;
  t1034 = t106 * t340;
  t1039 = t268 * t54;
  t1040 = t1039 * t165;
  t1043 = t747 * t944;
  t1048 = t379 * t102;
  t1051 = t107 * t241;
  t1055 = t353 * t234 * sigma[0];
  t1057 = 0.5e2 / 0.19683e5 * t226 * t1055;
  t1058 = t246 * t74;
  t1059 = t1058 * t81;
  t1068 = 0.2e4 / 0.14348907e8 * t700 * t1016 - 0.5e2 / 0.19683e5 * t335 * t1055 + 0.11e3 / 0.2187e4 * t147 * t1031 - t1018 + t1057 - t1033;
  t1070 = 0.12e2 * t1026 * t1028 + t1033 + 0.3e1 * t1034 * t166 + 0.6e1 * t376 * t380 + 0.3e1 * t164 * t1040 + 0.2e3 * t164 * t1043 - 0.16e2 * t376 * t389 - 0.16e2 * t164 * t1048 + 0.88e2 / 0.3e1 * t164 * t1051 - t1057 + 0.6e1 * t1059 * t166 + t75 * t1068;
  t1072 = t904 + t987 + t1025 + t1070;
  t1077 = my_piecewise3(t3, 0, t7 * t216 * t182 / 0.12e2 - t7 * t89 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1072);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t436;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1087 = t678 * t81;
  t1088 = t192 * t118;
  t1089 = t1088 * t141;
  t1098 = t206 * t118;
  t1099 = t1098 * t141;
  t1119 = t193 * t282;
  t1125 = 0.12e2 * t245 * t448 * t118 + 0.12e2 * t245 * t467 * t118 - 0.6e1 * t250 * t448 * t141 + 0.4e1 * t288 * t500 * t141 + 0.6e1 * t694 * t193 * t289 - 0.6e1 * t678 * t207 * t246 + 0.2e1 * t288 * t207 * t329 - 0.6e1 * t657 * t207 * t289 + 0.12e2 * t1026 * t1099 + 0.6e1 * t1058 * t193 - 0.12e2 * t1087 * t1089 + 0.6e1 * t245 * t1119;
  t1147 = t817 * t188;
  t1149 = 0.1e1 / t232;
  t1150 = t1149 * t272;
  t1153 = t754 * t1150;
  t1158 = t188 * t257;
  t1165 = t188 * t268;
  t1168 = t323 * t1149;
  t1172 = t734 * t1149;
  t1176 = t260 * t1165;
  t1180 = 0.32e3 / 0.3e1 * t407 - 0.32e3 / 0.3e1 * t128 * t102 + 0.48e2 * t1147 - 0.16e5 / 0.3e1 * t769 * t1150 + 0.32e4 * t1153 - 0.512e4 / 0.3e1 * t67 * t202 * t101 - 0.144e3 * t747 * t1158 + 0.24e3 * t271 * t400 + 0.192e4 * t305 * t404 - 0.72e2 * t271 * t1165 + 0.1792e6 * t132 * t1168 * t272 - 0.7168e6 / 0.3e1 * t67 * t1172 * t272 + 0.48e2 * t1176 - 0.1152e5 * t779 * t1158;
  t1190 = t454 * t112 * tau[0];
  t1191 = t933 * t1190;
  t1193 = t754 * t27;
  t1201 = t455 * t315;
  t1208 = 0.768e4 * t314 * t400 + 0.5376e5 * t324 * t404 + 0.192e4 * t409 * t1165 - 0.2304e4 * t314 * t1165 + 0.96e3 * t1191 - 0.192e4 * t1193 * t1190 + 0.768e4 * t953 * t1158 - 0.16e3 * t401 - 0.144e4 * t405 + 0.512e4 / 0.3e1 * t415 + 0.768e5 * t779 * t1201 - 0.10752e6 * t788 * t1201 - 0.64e4 * t410 - 0.4608e5 * t412;
  t1209 = t1180 + t1208;
  t1210 = t81 * t1209;
  t1212 = t340 * t192;
  t1215 = t150 * t466;
  t1220 = t112 * t62;
  t1226 = t260 * t404;
  t1236 = -0.8e1 * t1039 * t188 - 0.32e3 / 0.3e1 * t1220 * t456 + 0.8e2 / 0.3e1 * t380 - 0.16e4 / 0.3e1 * t747 * t1150 + 0.32e3 * t1226 - 0.32e3 / 0.9e1 * t389 + 0.16e2 * t1147 + 0.32e3 * t1191 - 0.16e3 / 0.3e1 * t401 + 0.16e2 * t1176 + 0.32e4 / 0.3e1 * t1153 - 0.48e3 * t405 + 0.32e3 / 0.9e1 * t407;
  t1237 = t81 * t1236;
  t1240 = t340 * t206;
  t1242 = t150 * t499;
  t1245 = -0.6e1 * t250 * t476 * t118 - 0.6e1 * t250 * t500 * t118 - 0.6e1 * t250 * t467 * t141 + 0.4e1 * t288 * t476 * t141 - 0.3e1 * t250 * t193 * t329 - 0.3e1 * t250 * t207 * t282 + 0.3e1 * t106 * t1212 + 0.6e1 * t106 * t1215 + 0.3e1 * t106 * t1237 - t124 * t1210 - t124 * t1240 - 0.2e1 * t124 * t1242;
  t1246 = t1125 + t1245;
  t1251 = my_piecewise3(t3, 0, t7 * t216 * t209 / 0.12e2 - t7 * t89 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1246);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1251 + 0.4e1 * t507;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1258 = t366 * t517 * t141;
  t1261 = t276 * t175;
  t1263 = t384 * t1261 * tau[0];
  t1267 = t366 * t517 * t118;
  t1285 = t672 * rho[0];
  t1286 = 0.1e1 / t1285;
  t1287 = t669 * t1286;
  t1288 = t1287 * sigma[0];
  t1291 = t353 * t356;
  t1295 = 0.25e3 / 0.4782969e7 * t667 * t1288;
  t1297 = 0.1e3 / 0.177147e6 * t226 * t1291;
  t1298 = -0.25e3 / 0.4782969e7 * t700 * t1288 + 0.1e3 / 0.177147e6 * t335 * t1291 + t1295 - t1297;
  t1306 = t947 * t54;
  t1311 = t737 * t62;
  t1312 = t1311 * tau[0];
  t1317 = t118 * t74;
  t1318 = t1317 * t81;
  t1321 = t245 * t150;
  t1324 = t737 * tau[0];
  t1325 = t754 * t1324;
  t1328 = 0.12e2 * t870 * t1258 - 0.4e2 * t371 * t1263 - 0.12e2 * t913 * t1267 + 0.4e1 * t288 * t176 * t417 - 0.6e1 * t250 * t531 * t118 + 0.4e1 * t288 * t531 * t141 - 0.3e1 * t250 * t541 * t118 + 0.2e1 * t288 * t541 * t141 + t75 * t1298 + 0.6e1 * t694 * t528 * t118 - 0.6e1 * t657 * t528 * t141 - t1295 + 0.4e1 * t164 * t1306 - 0.3e1 / 0.4e1 * t376 * t524 - 0.5e1 * t164 * t1312 + t1297 - 0.16e2 * t521 * t389 + 0.12e2 * t1318 * t514 + 0.12e2 * t1321 * t514 + 0.16e3 * t513 * t1325;
  t1329 = t106 * t429;
  t1334 = t54 * t118;
  t1335 = t403 * t1334;
  t1338 = t250 * t81;
  t1339 = t54 * t141;
  t1340 = t403 * t1339;
  t1343 = t271 * t947;
  t1346 = t81 * t48;
  t1347 = t678 * t1346;
  t1348 = t127 * t27;
  t1349 = t1348 * t908;
  t1352 = t1348 * t934;
  t1359 = t33 * t417;
  t1360 = t366 * t1359;
  t1364 = t180 * t47;
  t1365 = t245 * t1364;
  t1368 = t250 * t1364;
  t1371 = t106 * t1364;
  t1374 = t101 * t175;
  t1375 = t366 * t1374;
  t1378 = t150 * t527;
  t1381 = t429 * t175;
  t1384 = t180 * t417;
  t1387 = t150 * t540;
  t1389 = t1220 * t403;
  t1391 = t747 * t1324;
  t1393 = t260 * t947;
  t1395 = t403 * t112;
  t1396 = t953 * t1395;
  t1398 = t137 * t737;
  t1400 = t310 * t1398 * tau[0];
  t1403 = t310 * t536 * t356;
  t1405 = 0.3e1 / 0.2e1 * t1389 + 0.15e2 * t1391 - 0.8e1 * t1393 + 0.24e3 * t1396 + 0.12e4 * t1400 - 0.32e3 * t1403;
  t1406 = t81 * t1405;
  t1408 = t545 * t118;
  t1413 = -t124 * t545 * t141 + 0.3e1 * t106 * t1408 - 0.2e1 * t124 * t1381 - 0.2e1 * t124 * t1384 - t124 * t1387 - t124 * t1406 + 0.12e2 * t1365 * t368 - 0.6e1 * t1368 * t373 + 0.4e2 * t1371 * t386 + 0.16e2 * t371 * t1375 + 0.2e1 * t288 * t1378;
  t1415 = t1328 + 0.6e1 * t1329 * t166 + 0.6e1 * t521 * t380 - 0.3e1 / 0.2e1 * t513 * t1335 + 0.3e1 / 0.4e1 * t1338 * t1340 - 0.64e2 * t513 * t1343 - 0.12e2 * t1347 * t1349 + 0.24e2 * t365 * t1352 - 0.6e1 * t901 * t518 - 0.6e1 * t905 * t518 - 0.6e1 * t371 * t1360 + t1413;
  t1420 = my_piecewise3(t3, 0, -t7 * t89 * t547 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1415);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1420 + 0.2e1 * t551;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1426 = t678 * t193;
  t1427 = t165 * t141;
  t1428 = t107 * t1427;
  t1433 = t678 * t207;
  t1434 = t165 * t118;
  t1435 = t107 * t1434;
  t1438 = t694 * t207;
  t1485 = t657 * t81;
  t1486 = t206 * t175;
  t1487 = t1486 * t141;
  t1490 = 0.6e1 * t245 * t559 * t118 + 0.6e1 * t245 * t567 * t118 - 0.3e1 * t250 * t576 * t118 - 0.3e1 * t250 * t589 * t118 - 0.3e1 * t250 * t559 * t141 - 0.3e1 * t250 * t567 * t141 + 0.2e1 * t288 * t576 * t141 + 0.2e1 * t288 * t589 * t141 - 0.3e1 * t250 * t448 * t175 - 0.3e1 * t250 * t467 * t175 + 0.2e1 * t288 * t476 * t175 + 0.2e1 * t288 * t500 * t175 - 0.3e1 * t250 * t193 * t417 + 0.2e1 * t288 * t207 * t417 + 0.4e2 * t553 * t1226 - 0.2e2 * t570 * t1226 - 0.6e1 * t1426 * t1428 + 0.6e1 * t1438 * t1428 - 0.6e1 * t1433 * t1435 - 0.6e1 * t1485 * t1487;
  t1491 = t192 * t175;
  t1492 = t1491 * t118;
  t1495 = t1491 * t141;
  t1498 = t1486 * t118;
  t1501 = t1220 * t455;
  t1503 = t1149 * tau[0];
  t1504 = t747 * t1503;
  t1507 = t455 * t112;
  t1508 = t747 * t1507;
  t1510 = t754 * t1503;
  t1513 = t953 * t1507;
  t1515 = t137 * t1149;
  t1517 = t310 * t1515 * tau[0];
  t1520 = t779 * t1507;
  t1523 = t132 * t1168 * tau[0];
  t1526 = t132 * t584 * t276;
  t1528 = -0.12e2 * t1501 - 0.12e3 * t1504 + 0.52e2 * t534 + 0.36e2 * t1508 + 0.24e3 * t1510 - 0.78e2 * t514 - 0.192e4 * t1513 - 0.96e4 * t1517 + 0.208e4 * t538 + 0.288e4 * t1520 + 0.1344e5 * t1523 - 0.2496e4 * t1526;
  t1529 = t81 * t1528;
  t1531 = t180 * t499;
  t1533 = t150 * t588;
  t1535 = t150 * t566;
  t1539 = t1149 * t62;
  t1540 = t1539 * tau[0];
  t1545 = -0.26e2 / 0.3e1 * t524 + 0.4e2 / 0.3e1 * t1540 - 0.4e1 * t1501 - 0.4e2 * t1504 + 0.52e2 / 0.3e1 * t534;
  t1546 = t81 * t1545;
  t1549 = t429 * t206;
  t1551 = t429 * t192;
  t1554 = t180 * t466;
  t1561 = t1317 * t193;
  t1564 = t245 * t448;
  t1567 = t245 * t467;
  t1572 = t250 * t476;
  t1575 = t250 * t500;
  t1580 = 0.6e1 * t1026 * t1495 + 0.6e1 * t1026 * t1498 + 0.3e1 * t106 * t1535 + 0.3e1 * t106 * t1546 + 0.3e1 * t106 * t1551 + 0.3e1 * t106 * t1554 - 0.6e1 * t1087 * t1492 - t124 * t1529 - t124 * t1531 - t124 * t1533 - t124 * t1549 + 0.6e1 * t1561 * t166 + 0.6e1 * t1564 * t166 + 0.6e1 * t1567 * t166 - 0.3e1 * t1572 * t166 - 0.3e1 * t1575 * t166 + 0.6e1 * t553 * t380 - 0.3e1 * t570 * t380 - 0.16e2 * t553 * t389 + 0.8e1 * t570 * t389;
  t1581 = t1490 + t1580;
  t1586 = my_piecewise3(t3, 0, -t7 * t89 * t591 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1581);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1586 + 0.2e1 * t595;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1594 = t598 * t141;
  t1597 = t150 * t597;
  t1600 = t193 * t466;
  t1603 = t192 * t206;
  t1604 = t1603 * t118;
  t1607 = t1603 * t141;
  t1626 = t150 * t613;
  t1630 = 0.1e1 / t354;
  t1631 = t1630 * t62;
  t1634 = t1220 * t606;
  t1636 = t1630 * tau[0];
  t1637 = t747 * t1636;
  t1640 = t606 * t112;
  t1641 = t747 * t1640;
  t1643 = t754 * t1636;
  t1646 = 0.16e3 / 0.3e1 * t562 - 0.32e3 / 0.3e1 * t1631 * tau[0] + 0.64e2 * t1634 + 0.64e3 * t1637 - 0.64e3 / 0.3e1 * t564 - 0.96e2 * t1641 - 0.64e3 * t1643 + 0.16e3 * t579;
  t1647 = t81 * t1646;
  t1656 = t150 * t617;
  t1668 = t150 * t635;
  t1684 = t137 * t1630;
  t1691 = t323 * t1630;
  t1698 = t734 * t1630;
  t1705 = -0.21504e6 * t132 * t1691 * tau[0] + 0.768e5 * t310 * t1684 * tau[0] + 0.14336e6 * t67 * t1698 * tau[0] - 0.1792e5 * t67 * t631 * t454 + 0.32e4 * t769 * t1636 + 0.576e3 * t754 * t1640 - 0.4608e5 * t779 * t1640 + 0.32256e5 * t788 * t1640 + 0.1536e5 * t953 * t1640 - 0.64e3 * t305 * t455 + 0.96e2 * t1634 + 0.96e3 * t1637 - 0.576e3 * t1641 - 0.384e4 * t1643 - 0.32e3 * t564 + 0.96e3 * t579 - 0.128e5 * t582 + 0.3072e5 * t586;
  t1706 = t81 * t1705;
  t1708 = -0.3e1 * t250 * t636 * t118 + 0.6e1 * t694 * t618 * t118 - 0.3e1 * t250 * t614 * t141 + 0.2e1 * t288 * t636 * t141 - 0.6e1 * t657 * t618 * t141 + 0.4e1 * t288 * t207 * t499 + 0.3e1 * t106 * t1626 + 0.3e1 * t106 * t1647 - t124 * t1668 - t124 * t1706 + 0.2e1 * t288 * t1656;
  t1709 = 0.6e1 * t245 * t614 * t118 - 0.6e1 * t250 * t193 * t499 - 0.6e1 * t250 * t448 * t206 - 0.6e1 * t250 * t467 * t206 + 0.12e2 * t1026 * t1607 - 0.12e2 * t1087 * t1604 + 0.6e1 * t1317 * t598 - 0.6e1 * t678 * t1594 + 0.6e1 * t245 * t1597 + 0.12e2 * t245 * t1600 + t1708;
  t1714 = my_piecewise3(t3, 0, -t7 * t89 * t638 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1709);
  tv3rhotau20 = 0.2e1 * rho[0] * t1714 + 0.2e1 * t642;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1717 = t747 * t737;
  t1722 = t669 * t737;
  t1724 = t667 * t1722;
  t1726 = 0.125e3 / 0.6377292e7 * t700 * t1722 - 0.125e3 / 0.6377292e7 * t1724;
  t1728 = t737 * t74;
  t1732 = t527 * t175;
  t1733 = t81 * t1732;
  t1739 = t33 * t527;
  t1740 = t366 * t1739;
  t1744 = t180 * t527;
  t1747 = t545 * t175;
  t1750 = t180 * t540;
  t1754 = t70 * t737;
  t1755 = t725 * t1754;
  t1757 = -0.3e1 / 0.8e1 * t1311 - 0.6e2 * t1755;
  t1758 = t81 * t1757;
  t1760 = t245 * t180;
  t1763 = t54 * t175;
  t1764 = t403 * t1763;
  t1767 = t106 * t545;
  t1770 = t1348 * t1261;
  t1775 = t33 * t540;
  t1776 = t366 * t1775;
  t1779 = -0.9e1 * t513 * t1717 - 0.9e1 / 0.4e1 * t521 * t524 + t75 * t1726 + 0.24e2 * t769 * t1728 * t81 - 0.6e1 * t657 * t1733 + 0.6e1 * t288 * t176 * t540 + 0.18e2 * t870 * t1740 + 0.125e3 / 0.6377292e7 * t1724 + 0.6e1 * t288 * t1744 - 0.3e1 * t124 * t1747 - 0.3e1 * t124 * t1750 - t124 * t1758 + 0.36e2 * t1760 * t514 + 0.9e1 / 0.4e1 * t1338 * t1764 + 0.9e1 * t1767 * t166 - 0.36e2 * t1347 * t1770 - 0.18e2 * t1368 * t518 - 0.9e1 * t371 * t1776;
  t1783 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1779);
  tv3sigma30 = 0.2e1 * rho[0] * t1783;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1813 = t245 * t559;
  t1816 = t245 * t567;
  t1819 = t250 * t576;
  t1822 = 0.3e1 * t106 * t81 * t1149 * t62 - 0.6e1 * t250 * t559 * t175 - 0.6e1 * t250 * t567 * t175 + 0.4e1 * t288 * t576 * t175 + 0.4e1 * t288 * t589 * t175 - 0.3e1 * t250 * t193 * t540 + 0.6e1 * t694 * t193 * t527 + 0.2e1 * t288 * t207 * t540 - 0.6e1 * t657 * t207 * t527 + 0.12e2 * t1813 * t166 + 0.12e2 * t1816 * t166 - 0.6e1 * t1819 * t166;
  t1823 = t250 * t589;
  t1828 = t545 * t206;
  t1830 = t180 * t588;
  t1834 = t747 * t1149;
  t1836 = t70 * t1149;
  t1837 = t725 * t1836;
  t1839 = t310 * t1515;
  t1841 = 0.3e1 * t1539 - 0.9e1 * t1834 + 0.48e3 * t1837 - 0.72e3 * t1839;
  t1842 = t81 * t1841;
  t1844 = t545 * t192;
  t1847 = t180 * t566;
  t1850 = t165 * t175;
  t1851 = t107 * t1850;
  t1856 = t271 * t27;
  t1857 = t276 * t74;
  t1861 = t192 * t27;
  t1862 = t276 * t54;
  t1863 = t1861 * t1862;
  t1866 = t206 * t27;
  t1867 = t1866 * t1862;
  t1870 = -0.6e1 * t1823 * t166 - 0.12e2 * t1433 * t514 - t124 * t1828 - 0.2e1 * t124 * t1830 - t124 * t1842 + 0.3e1 * t106 * t1844 + 0.6e1 * t106 * t1847 + 0.12e2 * t1438 * t1851 - 0.12e2 * t1426 * t1851 + 0.12e2 * t1856 * t1857 * t193 - 0.3e1 / 0.2e1 * t513 * t1863 + 0.3e1 / 0.4e1 * t1338 * t1867;
  t1871 = t1822 + t1870;
  t1875 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1871);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1875;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1877 = t107 * t28;
  t1878 = t33 * t74;
  t1879 = t1878 * t598;
  t1882 = t598 * t175;
  t1885 = t180 * t597;
  t1888 = t193 * t566;
  t1891 = t206 * t47;
  t1892 = t366 * t33;
  t1893 = t1891 * t1892;
  t1896 = t1603 * t175;
  t1908 = t245 * t614;
  t1915 = t180 * t613;
  t1919 = t747 * t1630;
  t1921 = -0.16e2 * t1631 + 0.24e2 * t1919;
  t1922 = t81 * t1921;
  t1925 = t694 * t618;
  t1931 = t180 * t617;
  t1937 = t250 * t636;
  t1943 = t180 * t635;
  t1947 = t754 * t1630;
  t1949 = t70 * t1630;
  t1950 = t725 * t1949;
  t1952 = t310 * t1684;
  t1954 = t132 * t1691;
  t1956 = -0.24e2 * t1631 + 0.144e3 * t1919 - 0.144e3 * t1947 - 0.384e4 * t1950 + 0.1152e5 * t1952 - 0.8064e4 * t1954;
  t1957 = t81 * t1956;
  t1959 = -0.3e1 * t250 * t614 * t175 + 0.2e1 * t288 * t636 * t175 - 0.6e1 * t657 * t618 * t175 + 0.4e1 * t288 * t207 * t588 + 0.3e1 * t106 * t1915 + 0.3e1 * t106 * t1922 - t124 * t1943 - t124 * t1957 + 0.6e1 * t1925 * t166 - 0.3e1 * t1937 * t166 + 0.2e1 * t288 * t1931;
  t1960 = -0.6e1 * t250 * t193 * t588 - 0.6e1 * t250 * t559 * t206 - 0.6e1 * t250 * t567 * t206 + 0.12e2 * t1026 * t1896 - 0.12e2 * t1426 * t1893 + 0.6e1 * t1908 * t166 + 0.6e1 * t1877 * t1879 - 0.6e1 * t678 * t1882 + 0.6e1 * t245 * t1885 + 0.12e2 * t245 * t1888 + t1959;
  t1964 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1960);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1964;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1966 = t597 * t192;
  t1967 = t1966 * t74;
  t1970 = t598 * t206;
  t1973 = t193 * t613;
  t1985 = 0.1e1 / t274;
  t1987 = 0.192e3 * t1985 * t62;
  t1988 = t747 * t1985;
  t1990 = t754 * t1985;
  t1992 = t1987 - 0.576e3 * t1988 + 0.384e3 * t1990;
  t1993 = t81 * t1992;
  t1996 = t617 * t206;
  t1997 = t81 * t1996;
  t2007 = t70 * t1985;
  t2010 = t137 * t1985;
  t2013 = t323 * t1985;
  t2016 = t734 * t1985;
  t2019 = 0.193536e6 * t132 * t2013 - 0.192e4 * t769 * t1985 + 0.3072e5 * t725 * t2007 - 0.13824e6 * t310 * t2010 - 0.86016e5 * t67 * t2016 + t1987 - 0.1728e4 * t1988 + 0.3456e4 * t1990;
  t2020 = t81 * t2019;
  t2022 = -0.9e1 * t250 * t193 * t635 + 0.18e2 * t694 * t193 * t617 - 0.9e1 * t250 * t614 * t206 + 0.6e1 * t288 * t207 * t635 + 0.3e1 * t106 * t1993 - t124 * t2020 + 0.6e1 * t1967 * t81 - 0.18e2 * t678 * t1970 + 0.18e2 * t245 * t1973 - 0.6e1 * t657 * t1997;
  t2026 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t2022);
  tv3tau30 = 0.2e1 * rho[0] * t2026;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  double t645, t655, t656, t657, t658, t659, t665, t667;
  double t668, t669, t670, t671, t672, t673, t674, t675;
  double t677, t678, t694, t698, t700, t704, t706, t710;
  double t711, t712, t716, t718, t719, t725, t726, t734;
  double t735, t736, t737, t741, t744, t747, t748, t751;
  double t754, t763, t766, t769, t770, t779, t780, t784;
  double t785, t788, t789, t799, t802, t803, t806, t809;
  double t812, t817, t820, t823, t836, t837, t846, t847;
  double t852, tv3rho30, t862, t863, t867, t870, t872, t875;
  double t876, t879, t880, t883, t884, t887, t888, t891;
  double t894, t897, t898, t901, t904, t905, t908, t910;
  double t913, t915, t920, t925, t931, t933, t934, t935;
  double t936, t938, t939, t941, t942, t944, t945, t947;
  double t948, t949, t951, t953, t954, t955, t957, t958;
  double t960, t962, t964, t966, t968, t971, t973, t974;
  double t976, t979, t981, t987, t1013, t1015, t1016, t1018;
  double t1022, t1025, t1026, t1027, t1028, t1031, t1033, t1034;
  double t1039, t1040, t1043, t1048, t1051, t1055, t1057, t1058;
  double t1059, t1068, t1070, t1072, t1077, tv3rho2sigma0, tv3rho2lapl0, t1087;
  double t1088, t1089, t1098, t1099, t1119, t1125, t1147, t1149;
  double t1150, t1153, t1158, t1165, t1168, t1172, t1176, t1180;
  double t1190, t1191, t1193, t1201, t1208, t1209, t1210, t1212;
  double t1215, t1220, t1226, t1236, t1237, t1240, t1242, t1245;
  double t1246, t1251, tv3rho2tau0, t1258, t1261, t1263, t1267, t1285;
  double t1286, t1287, t1288, t1291, t1295, t1297, t1298, t1306;
  double t1311, t1312, t1317, t1318, t1321, t1324, t1325, t1328;
  double t1329, t1334, t1335, t1338, t1339, t1340, t1343, t1346;
  double t1347, t1348, t1349, t1352, t1359, t1360, t1364, t1365;
  double t1368, t1371, t1374, t1375, t1378, t1381, t1384, t1387;
  double t1389, t1391, t1393, t1395, t1396, t1398, t1400, t1403;
  double t1405, t1406, t1408, t1413, t1415, t1420, tv3rhosigma20, tv3rhosigmalapl0;
  double t1426, t1427, t1428, t1433, t1434, t1435, t1438, t1485;
  double t1486, t1487, t1490, t1491, t1492, t1495, t1498, t1501;
  double t1503, t1504, t1507, t1508, t1510, t1513, t1515, t1517;
  double t1520, t1523, t1526, t1528, t1529, t1531, t1533, t1535;
  double t1539, t1540, t1545, t1546, t1549, t1551, t1554, t1561;
  double t1564, t1567, t1572, t1575, t1580, t1581, t1586, tv3rhosigmatau0;
  double tv3rholapl20, tv3rholapltau0, t1594, t1597, t1600, t1603, t1604, t1607;
  double t1626, t1630, t1631, t1634, t1636, t1637, t1640, t1641;
  double t1643, t1646, t1647, t1656, t1668, t1684, t1691, t1698;
  double t1705, t1706, t1708, t1709, t1714, tv3rhotau20, t1717, t1722;
  double t1724, t1726, t1728, t1732, t1733, t1739, t1740, t1744;
  double t1747, t1750, t1754, t1755, t1757, t1758, t1760, t1763;
  double t1764, t1767, t1770, t1775, t1776, t1779, t1783, tv3sigma30;
  double tv3sigma2lapl0, t1813, t1816, t1819, t1822, t1823, t1828, t1830;
  double t1834, t1836, t1837, t1839, t1841, t1842, t1844, t1847;
  double t1850, t1851, t1856, t1857, t1861, t1862, t1863, t1866;
  double t1867, t1870, t1871, t1875, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1877;
  double t1878, t1879, t1882, t1885, t1888, t1891, t1892, t1893;
  double t1896, t1908, t1915, t1919, t1921, t1922, t1925, t1931;
  double t1937, t1943, t1947, t1949, t1950, t1952, t1954, t1956;
  double t1957, t1959, t1960, t1964, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t1966, t1967, t1970, t1973, t1985, t1987, t1988, t1990;
  double t1992, t1993, t1996, t1997, t2007, t2010, t2013, t2016;
  double t2019, t2020, t2022, t2026, tv3tau30;

  double t2044, t2058, t2059, t2060, t2066, t2069, t2071, t2077;
  double t2081, t2082, t2083, t2088, t2091, t2093, t2095, t2097;
  double t2102, t2108, t2109, t2113, t2147, t2148, t2154, t2158;
  double t2161, t2167, t2172, t2175, t2176, t2178, t2180, t2189;
  double t2191, t2204, t2213, t2221, t2230, t2231, t2238, t2244;
  double t2248, t2249, t2253, t2257, t2260, t2282, t2326, t2341;
  double t2360, t2368, t2372, t2379, tv4rho40, t2396, t2405, t2408;
  double t2428, t2441, t2446, t2447, t2452, t2453, t2454, t2460;
  double t2462, t2499, t2532, t2534, t2541, t2545, t2549, t2550;
  double t2552, t2553, t2557, t2564, t2568, t2598, t2609, t2612;
  double t2623, t2636, t2637, t2640, t2643, t2647, t2650, t2671;
  double t2677, t2681, t2692, t2708, t2724, t2736, t2739, t2760;
  double t2769, t2774, t2778, t2784, t2786, t2796, t2799, t2802;
  double t2805, t2818, t2821, t2833, t2853, t2856, t2857, t2880;
  double t2888, tv4rho3sigma0, tv4rho3lapl0, t2908, t2910, t2912, t2915, t2916;
  double t2921, t2923, t2927, t2929, t2930, t2931, t2933, t2936;
  double t2939, t2940, t2941, t2950, t2988, t3034, t3071, t3083;
  double t3103, t3107, t3146, t3151, t3156, t3159, t3168, t3175;
  double t3210, t3228, t3239, t3246, tv4rho3tau0, t3258, t3261, t3264;
  double t3267, t3272, t3274, t3276, t3315, t3324, t3329, t3332;
  double t3342, t3375, t3384, t3403, t3430, t3469, t3474, t3484;
  double t3503, t3504, t3510, t3520, t3525, t3528, t3542, t3551;
  double t3555, t3561, t3565, t3571, t3572, t3576, t3577, t3584;
  double t3610, t3634, t3667, t3691, t3731, t3739, t3747, tv4rho2sigma20;
  double tv4rho2sigmalapl0, t3757, t3759, t3763, t3766, t3775, t3778, t3788;
  double t3791, t3794, t3798, t3809, t3810, t3813, t3816, t3833;
  double t3834, t3837, t3838, t3841, t3856, t3877, t3908, t3930;
  double t3934, t3938, t3942, t3963, t4005, t4059, t4098, t4114;
  double t4117, t4120, t4124, t4133, t4135, t4144, t4151, t4161;
  double t4163, t4169, t4208, t4233, t4241, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0;
  double t4253, t4257, t4261, t4276, t4279, t4280, t4284, t4286;
  double t4295, t4300, t4302, t4304, t4306, t4311, t4343, t4345;
  double t4347, t4350, t4375, t4385, t4439, t4487, t4526, t4542;
  double t4554, t4561, tv4rho2tau20, t4577, t4594, t4609, t4645, t4648;
  double t4670, t4672, t4679, t4689, t4694, t4709, t4713, t4727;
  double t4735, t4761, t4778, t4793, t4813, t4814, t4818, t4827;
  double t4874, t4882, tv4rhosigma30, tv4rhosigma2lapl0, t4895, t4900, t4917, t4938;
  double t4955, t4958, t4968, t5005, t5047, t5061, t5065, t5094;
  double t5117, t5165, t5207, t5229, t5233, t5236, t5241, t5246;
  double t5249, t5254, t5257, t5258, t5263, t5270, t5283, t5291;
  double t5306, t5314, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, t5323, t5326, t5336;
  double t5343, t5347, t5356, t5363, t5364, t5375, t5377, t5380;
  double t5381, t5409, t5445, t5485, t5528, t5558, t5567, t5568;
  double t5611, t5655, t5661, t5668, t5673, t5676, t5683, t5686;
  double t5695, t5703, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, t5741, t5773;
  double t5787, t5791, t5801, t5811, t5812, t5816, t5823, t5830;
  double t5832, t5835, t5836, t5839, t5840, t5843, t5844, t5846;
  double t5855, t5881, t5890, t5906, t5909, t5916, tv4rhotau30, t5936;
  double t5971, t5997, t5998, t6015, t6019, t6030, t6033, t6038;
  double tv4sigma40, tv4sigma3lapl0, t6083, t6122, t6178, t6193, t6216, t6222;
  double tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, t6227, t6228, t6268, t6286, t6303;
  double t6340, t6367, t6385, t6437, t6443, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0;
  double tv4sigmalapltau20, t6447, t6448, t6450, t6500, t6534, t6569, t6571;
  double t6606, t6612, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, t6614;
  double t6622, t6624, t6626, t6679, t6698, t6705, t6709, tv4tau40;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t645 = t18 * t33;
  t655 = t122 * t122;
  t656 = 0.1e1 / t655;
  t657 = t59 * t656;
  t658 = t289 * t141;
  t659 = t81 * t658;
  t665 = t94 * t94;
  t667 = t93 / t665;
  t668 = t22 * t22;
  t669 = 0.1e1 / t668;
  t670 = t229 * sigma[0];
  t671 = t669 * t670;
  t672 = t231 * t231;
  t673 = t672 * t99;
  t674 = 0.1e1 / t673;
  t675 = t671 * t674;
  t677 = 0.16e5 / 0.43046721e8 * t667 * t675;
  t678 = t57 * t123;
  t694 = t58 * t287;
  t698 = t144 * t144;
  t700 = t93 / t698;
  t704 = 0.1e1 / t19 / t672;
  t706 = t230 * t27 * t704;
  t710 = 0.1e1 / t31 / t274;
  t711 = t28 * t710;
  t712 = t98 * t711;
  t716 = 0.44e4 / 0.531441e6 * t226 * t706;
  t718 = 0.154e4 / 0.6561e4 * t97 * t712;
  t719 = -0.16e5 / 0.43046721e8 * t700 * t675 + 0.44e4 / 0.531441e6 * t335 * t706 - 0.154e4 / 0.6561e4 * t147 * t712 + t677 - t716 + t718;
  t725 = params->b * t60;
  t726 = t257 * t112;
  t734 = 0.1e1 / t322 / t52;
  t735 = t272 * tau[0];
  t736 = t734 * t735;
  t737 = 0.1e1 / t672;
  t741 = t273 * t356;
  t744 = t42 * t240;
  t747 = t47 * t127;
  t748 = t747 * t257;
  t751 = t271 * t268;
  t754 = t48 * t304;
  t763 = -0.44e3 / 0.27e2 * t744 + 0.154e3 / 0.27e2 * t29 * t710;
  t766 = t112 * t268;
  t769 = t60 * t70;
  t770 = t735 * t737;
  t779 = t310 * t137;
  t780 = t257 * tau[0];
  t784 = t268 * tau[0];
  t785 = t784 * t165;
  t788 = t132 * t323;
  t789 = t112 * t272;
  t799 = 0.768e4 * t725 * t70 * t726 + 0.576e4 * t310 * t133 * t268 + 0.3584e7 / 0.9e1 * t67 * t736 * t737 - 0.128e5 / 0.3e1 * t305 * t741 + 0.352e4 / 0.9e1 * t128 * t744 + 0.72e3 * t748 * t108 + 0.36e3 * t751 * t108 + 0.48e4 * t754 * t112 * t277 + 0.48e2 * t726 * t62 + 0.24e2 * t115 * t763 + 0.144e3 * t260 * t766 + 0.8e5 / 0.9e1 * t769 * t770 + 0.384e3 * t132 * t70 * t763 - 0.3072e5 * t314 * t315 * t102 + 0.576e5 * t779 * t780 * t165 + 0.1152e5 * t314 * t785 + 0.2688e6 * t788 * t789 * t403 - 0.3584e6 / 0.3e1 * t324 * t741 + 0.5632e5 / 0.9e1 * t138 * t744 - 0.96e3 * t298 * t264;
  t802 = t246 * t118;
  t803 = t802 * t74;
  t806 = t150 * t246;
  t809 = t340 * t118;
  t812 = t150 * t282;
  t817 = t257 * t62;
  t820 = t747 * t112;
  t823 = t260 * t268;
  t836 = -0.24e2 * t379 * t268 - 0.8e2 * t817 * t108 - 0.8e3 * t820 * t277 - 0.8e2 * t823 * t108 + 0.64e3 / 0.3e1 * t261 * t264 - 0.8e1 * t107 * t763 - 0.16e5 / 0.9e1 * t754 * t770 + 0.32e4 / 0.3e1 * t271 * t741 - 0.352e4 / 0.27e2 * t115 * t744;
  t837 = t81 * t836;
  t846 = -0.3e1 * t124 * t340 * t141 - 0.3e1 * t124 * t150 * t329 - t124 * t81 * t799 + 0.6e1 * t288 * t150 * t289 + 0.9e1 * t106 * t809 + 0.9e1 * t106 * t812 + 0.3e1 * t106 * t837 + 0.18e2 * t245 * t806 + 0.6e1 * t803 * t81 + t716 - t718;
  t847 = 0.18e2 * t245 * t119 * t282 - 0.9e1 * t250 * t119 * t329 + 0.18e2 * t694 * t119 * t289 - 0.18e2 * t678 * t247 * t141 - 0.18e2 * t250 * t254 * t141 - 0.9e1 * t250 * t283 * t141 + 0.6e1 * t288 * t142 * t329 - 0.6e1 * t657 * t659 + t75 * t719 - t677 + t846;
  t852 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t83 + t7 * t216 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t342 - 0.3e1 / 0.8e1 * t7 * t20 * t847);
  tv3rho30 = 0.2e1 * rho[0] * t852 + 0.6e1 * t347;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t862 = t356 * tau[0];
  t863 = t384 * t862;
  t867 = t366 * t101 * t118;
  t870 = t694 * t364;
  t872 = t366 * t33 * t289;
  t875 = t101 * t141;
  t876 = t366 * t875;
  t879 = t33 * t329;
  t880 = t366 * t879;
  t883 = t150 * t47;
  t884 = t106 * t883;
  t887 = t81 * t112;
  t888 = t106 * t887;
  t891 = t245 * t883;
  t894 = t245 * t887;
  t897 = t33 * t282;
  t898 = t366 * t897;
  t901 = t250 * t883;
  t904 = -0.32e2 * t365 * t867 + 0.6e1 * t365 * t898 + 0.12e2 * t891 * t368 + 0.12e2 * t894 * t368 + 0.16e2 * t371 * t876 - 0.3e1 * t371 * t880 - 0.6e1 * t901 * t373 - 0.16e3 * t383 * t863 + 0.4e2 * t884 * t386 + 0.4e2 * t888 * t386 + 0.6e1 * t870 * t872;
  t905 = t250 * t887;
  t908 = t276 * t141;
  t910 = t384 * t908 * tau[0];
  t913 = t678 * t364;
  t915 = t366 * t367 * t141;
  t920 = t384 * t276 * t118 * tau[0];
  t925 = t180 * t282;
  t931 = t817 * t165;
  t933 = t747 * t27;
  t934 = t276 * t112;
  t935 = t934 * tau[0];
  t936 = t933 * t935;
  t938 = t102 * t112;
  t939 = t260 * t938;
  t941 = t165 * t268;
  t942 = t260 * t941;
  t944 = t737 * t272;
  t945 = t754 * t944;
  t947 = t27 * t356;
  t948 = t947 * tau[0];
  t949 = t271 * t948;
  t951 = t115 * t241;
  t953 = t725 * t70;
  t954 = t165 * t257;
  t955 = t953 * t954;
  t957 = t403 * t315;
  t958 = t779 * t957;
  t960 = t409 * t938;
  t962 = t409 * t941;
  t964 = t323 * t737;
  t966 = t132 * t964 * t272;
  t968 = t314 * t948;
  t971 = t132 * t171 * t240;
  t973 = -0.6e1 * t931 - 0.12e3 * t936 + 0.32e2 * t939 - 0.6e1 * t942 - 0.4e3 * t945 + 0.24e3 * t949 - 0.88e2 / 0.3e1 * t951 - 0.96e3 * t955 - 0.96e4 * t958 + 0.128e4 * t960 - 0.24e3 * t962 - 0.224e5 * t966 + 0.768e4 * t968 - 0.1408e4 / 0.3e1 * t971;
  t974 = t81 * t973;
  t976 = t429 * t118;
  t979 = t340 * t175;
  t981 = t150 * t417;
  t987 = -0.2e1 * t124 * t429 * t141 - t124 * t180 * t329 - 0.6e1 * t657 * t176 * t289 + 0.3e1 * t106 * t925 + 0.6e1 * t106 * t976 - t124 * t974 - t124 * t979 - 0.2e1 * t124 * t981 + 0.8e2 * t365 * t920 - 0.4e2 * t371 * t910 - 0.6e1 * t905 * t373 - 0.12e2 * t913 * t915;
  t1013 = t672 * t30;
  t1015 = t669 / t1013;
  t1016 = t1015 * t229;
  t1018 = 0.2e4 / 0.14348907e8 * t667 * t1016;
  t1022 = t180 * t246;
  t1025 = -0.6e1 * t250 * t398 * t118 - 0.6e1 * t250 * t418 * t118 - 0.6e1 * t250 * t420 * t141 + 0.4e1 * t288 * t398 * t141 + 0.4e1 * t288 * t418 * t141 - 0.6e1 * t678 * t176 * t246 - 0.3e1 * t250 * t176 * t282 + 0.2e1 * t288 * t176 * t329 + 0.2e1 * t288 * t180 * t289 + 0.6e1 * t245 * t1022 + t1018;
  t1026 = t694 * t81;
  t1027 = t175 * t118;
  t1028 = t1027 * t141;
  t1031 = t160 * t240;
  t1033 = 0.11e3 / 0.2187e4 * t97 * t1031;
  t1034 = t106 * t340;
  t1039 = t268 * t54;
  t1040 = t1039 * t165;
  t1043 = t747 * t944;
  t1048 = t379 * t102;
  t1051 = t107 * t241;
  t1055 = t353 * t234 * sigma[0];
  t1057 = 0.5e2 / 0.19683e5 * t226 * t1055;
  t1058 = t246 * t74;
  t1059 = t1058 * t81;
  t1068 = 0.2e4 / 0.14348907e8 * t700 * t1016 - 0.5e2 / 0.19683e5 * t335 * t1055 + 0.11e3 / 0.2187e4 * t147 * t1031 - t1018 + t1057 - t1033;
  t1070 = 0.12e2 * t1026 * t1028 + t1033 + 0.3e1 * t1034 * t166 + 0.6e1 * t376 * t380 + 0.3e1 * t164 * t1040 + 0.2e3 * t164 * t1043 - 0.16e2 * t376 * t389 - 0.16e2 * t164 * t1048 + 0.88e2 / 0.3e1 * t164 * t1051 - t1057 + 0.6e1 * t1059 * t166 + t75 * t1068;
  t1072 = t904 + t987 + t1025 + t1070;
  t1077 = my_piecewise3(t3, 0, t7 * t216 * t182 / 0.12e2 - t7 * t89 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1072);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t436;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1087 = t678 * t81;
  t1088 = t192 * t118;
  t1089 = t1088 * t141;
  t1098 = t206 * t118;
  t1099 = t1098 * t141;
  t1119 = t193 * t282;
  t1125 = 0.12e2 * t245 * t448 * t118 + 0.12e2 * t245 * t467 * t118 - 0.6e1 * t250 * t448 * t141 + 0.4e1 * t288 * t500 * t141 + 0.6e1 * t694 * t193 * t289 - 0.6e1 * t678 * t207 * t246 + 0.2e1 * t288 * t207 * t329 - 0.6e1 * t657 * t207 * t289 + 0.12e2 * t1026 * t1099 + 0.6e1 * t1058 * t193 - 0.12e2 * t1087 * t1089 + 0.6e1 * t245 * t1119;
  t1147 = t817 * t188;
  t1149 = 0.1e1 / t232;
  t1150 = t1149 * t272;
  t1153 = t754 * t1150;
  t1158 = t188 * t257;
  t1165 = t188 * t268;
  t1168 = t323 * t1149;
  t1172 = t734 * t1149;
  t1176 = t260 * t1165;
  t1180 = 0.32e3 / 0.3e1 * t407 - 0.32e3 / 0.3e1 * t128 * t102 + 0.48e2 * t1147 - 0.16e5 / 0.3e1 * t769 * t1150 + 0.32e4 * t1153 - 0.512e4 / 0.3e1 * t67 * t202 * t101 - 0.144e3 * t747 * t1158 + 0.24e3 * t271 * t400 + 0.192e4 * t305 * t404 - 0.72e2 * t271 * t1165 + 0.1792e6 * t132 * t1168 * t272 - 0.7168e6 / 0.3e1 * t67 * t1172 * t272 + 0.48e2 * t1176 - 0.1152e5 * t779 * t1158;
  t1190 = t454 * t112 * tau[0];
  t1191 = t933 * t1190;
  t1193 = t754 * t27;
  t1201 = t455 * t315;
  t1208 = 0.768e4 * t314 * t400 + 0.5376e5 * t324 * t404 + 0.192e4 * t409 * t1165 - 0.2304e4 * t314 * t1165 + 0.96e3 * t1191 - 0.192e4 * t1193 * t1190 + 0.768e4 * t953 * t1158 - 0.16e3 * t401 - 0.144e4 * t405 + 0.512e4 / 0.3e1 * t415 + 0.768e5 * t779 * t1201 - 0.10752e6 * t788 * t1201 - 0.64e4 * t410 - 0.4608e5 * t412;
  t1209 = t1180 + t1208;
  t1210 = t81 * t1209;
  t1212 = t340 * t192;
  t1215 = t150 * t466;
  t1220 = t112 * t62;
  t1226 = t260 * t404;
  t1236 = -0.8e1 * t1039 * t188 - 0.32e3 / 0.3e1 * t1220 * t456 + 0.8e2 / 0.3e1 * t380 - 0.16e4 / 0.3e1 * t747 * t1150 + 0.32e3 * t1226 - 0.32e3 / 0.9e1 * t389 + 0.16e2 * t1147 + 0.32e3 * t1191 - 0.16e3 / 0.3e1 * t401 + 0.16e2 * t1176 + 0.32e4 / 0.3e1 * t1153 - 0.48e3 * t405 + 0.32e3 / 0.9e1 * t407;
  t1237 = t81 * t1236;
  t1240 = t340 * t206;
  t1242 = t150 * t499;
  t1245 = -0.6e1 * t250 * t476 * t118 - 0.6e1 * t250 * t500 * t118 - 0.6e1 * t250 * t467 * t141 + 0.4e1 * t288 * t476 * t141 - 0.3e1 * t250 * t193 * t329 - 0.3e1 * t250 * t207 * t282 + 0.3e1 * t106 * t1212 + 0.6e1 * t106 * t1215 + 0.3e1 * t106 * t1237 - t124 * t1210 - t124 * t1240 - 0.2e1 * t124 * t1242;
  t1246 = t1125 + t1245;
  t1251 = my_piecewise3(t3, 0, t7 * t216 * t209 / 0.12e2 - t7 * t89 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1246);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1251 + 0.4e1 * t507;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1258 = t366 * t517 * t141;
  t1261 = t276 * t175;
  t1263 = t384 * t1261 * tau[0];
  t1267 = t366 * t517 * t118;
  t1285 = t672 * rho[0];
  t1286 = 0.1e1 / t1285;
  t1287 = t669 * t1286;
  t1288 = t1287 * sigma[0];
  t1291 = t353 * t356;
  t1295 = 0.25e3 / 0.4782969e7 * t667 * t1288;
  t1297 = 0.1e3 / 0.177147e6 * t226 * t1291;
  t1298 = -0.25e3 / 0.4782969e7 * t700 * t1288 + 0.1e3 / 0.177147e6 * t335 * t1291 + t1295 - t1297;
  t1306 = t947 * t54;
  t1311 = t737 * t62;
  t1312 = t1311 * tau[0];
  t1317 = t118 * t74;
  t1318 = t1317 * t81;
  t1321 = t245 * t150;
  t1324 = t737 * tau[0];
  t1325 = t754 * t1324;
  t1328 = 0.12e2 * t870 * t1258 - 0.4e2 * t371 * t1263 - 0.12e2 * t913 * t1267 + 0.4e1 * t288 * t176 * t417 - 0.6e1 * t250 * t531 * t118 + 0.4e1 * t288 * t531 * t141 - 0.3e1 * t250 * t541 * t118 + 0.2e1 * t288 * t541 * t141 + t75 * t1298 + 0.6e1 * t694 * t528 * t118 - 0.6e1 * t657 * t528 * t141 - t1295 + 0.4e1 * t164 * t1306 - 0.3e1 / 0.4e1 * t376 * t524 - 0.5e1 * t164 * t1312 + t1297 - 0.16e2 * t521 * t389 + 0.12e2 * t1318 * t514 + 0.12e2 * t1321 * t514 + 0.16e3 * t513 * t1325;
  t1329 = t106 * t429;
  t1334 = t54 * t118;
  t1335 = t403 * t1334;
  t1338 = t250 * t81;
  t1339 = t54 * t141;
  t1340 = t403 * t1339;
  t1343 = t271 * t947;
  t1346 = t81 * t48;
  t1347 = t678 * t1346;
  t1348 = t127 * t27;
  t1349 = t1348 * t908;
  t1352 = t1348 * t934;
  t1359 = t33 * t417;
  t1360 = t366 * t1359;
  t1364 = t180 * t47;
  t1365 = t245 * t1364;
  t1368 = t250 * t1364;
  t1371 = t106 * t1364;
  t1374 = t101 * t175;
  t1375 = t366 * t1374;
  t1378 = t150 * t527;
  t1381 = t429 * t175;
  t1384 = t180 * t417;
  t1387 = t150 * t540;
  t1389 = t1220 * t403;
  t1391 = t747 * t1324;
  t1393 = t260 * t947;
  t1395 = t403 * t112;
  t1396 = t953 * t1395;
  t1398 = t137 * t737;
  t1400 = t310 * t1398 * tau[0];
  t1403 = t310 * t536 * t356;
  t1405 = 0.3e1 / 0.2e1 * t1389 + 0.15e2 * t1391 - 0.8e1 * t1393 + 0.24e3 * t1396 + 0.12e4 * t1400 - 0.32e3 * t1403;
  t1406 = t81 * t1405;
  t1408 = t545 * t118;
  t1413 = -t124 * t545 * t141 + 0.3e1 * t106 * t1408 - 0.2e1 * t124 * t1381 - 0.2e1 * t124 * t1384 - t124 * t1387 - t124 * t1406 + 0.12e2 * t1365 * t368 - 0.6e1 * t1368 * t373 + 0.4e2 * t1371 * t386 + 0.16e2 * t371 * t1375 + 0.2e1 * t288 * t1378;
  t1415 = t1328 + 0.6e1 * t1329 * t166 + 0.6e1 * t521 * t380 - 0.3e1 / 0.2e1 * t513 * t1335 + 0.3e1 / 0.4e1 * t1338 * t1340 - 0.64e2 * t513 * t1343 - 0.12e2 * t1347 * t1349 + 0.24e2 * t365 * t1352 - 0.6e1 * t901 * t518 - 0.6e1 * t905 * t518 - 0.6e1 * t371 * t1360 + t1413;
  t1420 = my_piecewise3(t3, 0, -t7 * t89 * t547 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1415);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1420 + 0.2e1 * t551;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1426 = t678 * t193;
  t1427 = t165 * t141;
  t1428 = t107 * t1427;
  t1433 = t678 * t207;
  t1434 = t165 * t118;
  t1435 = t107 * t1434;
  t1438 = t694 * t207;
  t1485 = t657 * t81;
  t1486 = t206 * t175;
  t1487 = t1486 * t141;
  t1490 = 0.6e1 * t245 * t559 * t118 + 0.6e1 * t245 * t567 * t118 - 0.3e1 * t250 * t576 * t118 - 0.3e1 * t250 * t589 * t118 - 0.3e1 * t250 * t559 * t141 - 0.3e1 * t250 * t567 * t141 + 0.2e1 * t288 * t576 * t141 + 0.2e1 * t288 * t589 * t141 - 0.3e1 * t250 * t448 * t175 - 0.3e1 * t250 * t467 * t175 + 0.2e1 * t288 * t476 * t175 + 0.2e1 * t288 * t500 * t175 - 0.3e1 * t250 * t193 * t417 + 0.2e1 * t288 * t207 * t417 + 0.4e2 * t553 * t1226 - 0.2e2 * t570 * t1226 - 0.6e1 * t1426 * t1428 + 0.6e1 * t1438 * t1428 - 0.6e1 * t1433 * t1435 - 0.6e1 * t1485 * t1487;
  t1491 = t192 * t175;
  t1492 = t1491 * t118;
  t1495 = t1491 * t141;
  t1498 = t1486 * t118;
  t1501 = t1220 * t455;
  t1503 = t1149 * tau[0];
  t1504 = t747 * t1503;
  t1507 = t455 * t112;
  t1508 = t747 * t1507;
  t1510 = t754 * t1503;
  t1513 = t953 * t1507;
  t1515 = t137 * t1149;
  t1517 = t310 * t1515 * tau[0];
  t1520 = t779 * t1507;
  t1523 = t132 * t1168 * tau[0];
  t1526 = t132 * t584 * t276;
  t1528 = -0.12e2 * t1501 - 0.12e3 * t1504 + 0.52e2 * t534 + 0.36e2 * t1508 + 0.24e3 * t1510 - 0.78e2 * t514 - 0.192e4 * t1513 - 0.96e4 * t1517 + 0.208e4 * t538 + 0.288e4 * t1520 + 0.1344e5 * t1523 - 0.2496e4 * t1526;
  t1529 = t81 * t1528;
  t1531 = t180 * t499;
  t1533 = t150 * t588;
  t1535 = t150 * t566;
  t1539 = t1149 * t62;
  t1540 = t1539 * tau[0];
  t1545 = -0.26e2 / 0.3e1 * t524 + 0.4e2 / 0.3e1 * t1540 - 0.4e1 * t1501 - 0.4e2 * t1504 + 0.52e2 / 0.3e1 * t534;
  t1546 = t81 * t1545;
  t1549 = t429 * t206;
  t1551 = t429 * t192;
  t1554 = t180 * t466;
  t1561 = t1317 * t193;
  t1564 = t245 * t448;
  t1567 = t245 * t467;
  t1572 = t250 * t476;
  t1575 = t250 * t500;
  t1580 = 0.6e1 * t1026 * t1495 + 0.6e1 * t1026 * t1498 + 0.3e1 * t106 * t1535 + 0.3e1 * t106 * t1546 + 0.3e1 * t106 * t1551 + 0.3e1 * t106 * t1554 - 0.6e1 * t1087 * t1492 - t124 * t1529 - t124 * t1531 - t124 * t1533 - t124 * t1549 + 0.6e1 * t1561 * t166 + 0.6e1 * t1564 * t166 + 0.6e1 * t1567 * t166 - 0.3e1 * t1572 * t166 - 0.3e1 * t1575 * t166 + 0.6e1 * t553 * t380 - 0.3e1 * t570 * t380 - 0.16e2 * t553 * t389 + 0.8e1 * t570 * t389;
  t1581 = t1490 + t1580;
  t1586 = my_piecewise3(t3, 0, -t7 * t89 * t591 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1581);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1586 + 0.2e1 * t595;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1594 = t598 * t141;
  t1597 = t150 * t597;
  t1600 = t193 * t466;
  t1603 = t192 * t206;
  t1604 = t1603 * t118;
  t1607 = t1603 * t141;
  t1626 = t150 * t613;
  t1630 = 0.1e1 / t354;
  t1631 = t1630 * t62;
  t1634 = t1220 * t606;
  t1636 = t1630 * tau[0];
  t1637 = t747 * t1636;
  t1640 = t606 * t112;
  t1641 = t747 * t1640;
  t1643 = t754 * t1636;
  t1646 = 0.16e3 / 0.3e1 * t562 - 0.32e3 / 0.3e1 * t1631 * tau[0] + 0.64e2 * t1634 + 0.64e3 * t1637 - 0.64e3 / 0.3e1 * t564 - 0.96e2 * t1641 - 0.64e3 * t1643 + 0.16e3 * t579;
  t1647 = t81 * t1646;
  t1656 = t150 * t617;
  t1668 = t150 * t635;
  t1684 = t137 * t1630;
  t1691 = t323 * t1630;
  t1698 = t734 * t1630;
  t1705 = -0.21504e6 * t132 * t1691 * tau[0] + 0.768e5 * t310 * t1684 * tau[0] + 0.14336e6 * t67 * t1698 * tau[0] - 0.1792e5 * t67 * t631 * t454 + 0.32e4 * t769 * t1636 + 0.576e3 * t754 * t1640 - 0.4608e5 * t779 * t1640 + 0.32256e5 * t788 * t1640 + 0.1536e5 * t953 * t1640 - 0.64e3 * t305 * t455 + 0.96e2 * t1634 + 0.96e3 * t1637 - 0.576e3 * t1641 - 0.384e4 * t1643 - 0.32e3 * t564 + 0.96e3 * t579 - 0.128e5 * t582 + 0.3072e5 * t586;
  t1706 = t81 * t1705;
  t1708 = -0.3e1 * t250 * t636 * t118 + 0.6e1 * t694 * t618 * t118 - 0.3e1 * t250 * t614 * t141 + 0.2e1 * t288 * t636 * t141 - 0.6e1 * t657 * t618 * t141 + 0.4e1 * t288 * t207 * t499 + 0.3e1 * t106 * t1626 + 0.3e1 * t106 * t1647 - t124 * t1668 - t124 * t1706 + 0.2e1 * t288 * t1656;
  t1709 = 0.6e1 * t245 * t614 * t118 - 0.6e1 * t250 * t193 * t499 - 0.6e1 * t250 * t448 * t206 - 0.6e1 * t250 * t467 * t206 + 0.12e2 * t1026 * t1607 - 0.12e2 * t1087 * t1604 + 0.6e1 * t1317 * t598 - 0.6e1 * t678 * t1594 + 0.6e1 * t245 * t1597 + 0.12e2 * t245 * t1600 + t1708;
  t1714 = my_piecewise3(t3, 0, -t7 * t89 * t638 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1709);
  tv3rhotau20 = 0.2e1 * rho[0] * t1714 + 0.2e1 * t642;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1717 = t747 * t737;
  t1722 = t669 * t737;
  t1724 = t667 * t1722;
  t1726 = 0.125e3 / 0.6377292e7 * t700 * t1722 - 0.125e3 / 0.6377292e7 * t1724;
  t1728 = t737 * t74;
  t1732 = t527 * t175;
  t1733 = t81 * t1732;
  t1739 = t33 * t527;
  t1740 = t366 * t1739;
  t1744 = t180 * t527;
  t1747 = t545 * t175;
  t1750 = t180 * t540;
  t1754 = t70 * t737;
  t1755 = t725 * t1754;
  t1757 = -0.3e1 / 0.8e1 * t1311 - 0.6e2 * t1755;
  t1758 = t81 * t1757;
  t1760 = t245 * t180;
  t1763 = t54 * t175;
  t1764 = t403 * t1763;
  t1767 = t106 * t545;
  t1770 = t1348 * t1261;
  t1775 = t33 * t540;
  t1776 = t366 * t1775;
  t1779 = -0.9e1 * t513 * t1717 - 0.9e1 / 0.4e1 * t521 * t524 + t75 * t1726 + 0.24e2 * t769 * t1728 * t81 - 0.6e1 * t657 * t1733 + 0.6e1 * t288 * t176 * t540 + 0.18e2 * t870 * t1740 + 0.125e3 / 0.6377292e7 * t1724 + 0.6e1 * t288 * t1744 - 0.3e1 * t124 * t1747 - 0.3e1 * t124 * t1750 - t124 * t1758 + 0.36e2 * t1760 * t514 + 0.9e1 / 0.4e1 * t1338 * t1764 + 0.9e1 * t1767 * t166 - 0.36e2 * t1347 * t1770 - 0.18e2 * t1368 * t518 - 0.9e1 * t371 * t1776;
  t1783 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1779);
  tv3sigma30 = 0.2e1 * rho[0] * t1783;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1813 = t245 * t559;
  t1816 = t245 * t567;
  t1819 = t250 * t576;
  t1822 = 0.3e1 * t106 * t81 * t1149 * t62 - 0.6e1 * t250 * t559 * t175 - 0.6e1 * t250 * t567 * t175 + 0.4e1 * t288 * t576 * t175 + 0.4e1 * t288 * t589 * t175 - 0.3e1 * t250 * t193 * t540 + 0.6e1 * t694 * t193 * t527 + 0.2e1 * t288 * t207 * t540 - 0.6e1 * t657 * t207 * t527 + 0.12e2 * t1813 * t166 + 0.12e2 * t1816 * t166 - 0.6e1 * t1819 * t166;
  t1823 = t250 * t589;
  t1828 = t545 * t206;
  t1830 = t180 * t588;
  t1834 = t747 * t1149;
  t1836 = t70 * t1149;
  t1837 = t725 * t1836;
  t1839 = t310 * t1515;
  t1841 = 0.3e1 * t1539 - 0.9e1 * t1834 + 0.48e3 * t1837 - 0.72e3 * t1839;
  t1842 = t81 * t1841;
  t1844 = t545 * t192;
  t1847 = t180 * t566;
  t1850 = t165 * t175;
  t1851 = t107 * t1850;
  t1856 = t271 * t27;
  t1857 = t276 * t74;
  t1861 = t192 * t27;
  t1862 = t276 * t54;
  t1863 = t1861 * t1862;
  t1866 = t206 * t27;
  t1867 = t1866 * t1862;
  t1870 = -0.6e1 * t1823 * t166 - 0.12e2 * t1433 * t514 - t124 * t1828 - 0.2e1 * t124 * t1830 - t124 * t1842 + 0.3e1 * t106 * t1844 + 0.6e1 * t106 * t1847 + 0.12e2 * t1438 * t1851 - 0.12e2 * t1426 * t1851 + 0.12e2 * t1856 * t1857 * t193 - 0.3e1 / 0.2e1 * t513 * t1863 + 0.3e1 / 0.4e1 * t1338 * t1867;
  t1871 = t1822 + t1870;
  t1875 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1871);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1875;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1877 = t107 * t28;
  t1878 = t33 * t74;
  t1879 = t1878 * t598;
  t1882 = t598 * t175;
  t1885 = t180 * t597;
  t1888 = t193 * t566;
  t1891 = t206 * t47;
  t1892 = t366 * t33;
  t1893 = t1891 * t1892;
  t1896 = t1603 * t175;
  t1908 = t245 * t614;
  t1915 = t180 * t613;
  t1919 = t747 * t1630;
  t1921 = -0.16e2 * t1631 + 0.24e2 * t1919;
  t1922 = t81 * t1921;
  t1925 = t694 * t618;
  t1931 = t180 * t617;
  t1937 = t250 * t636;
  t1943 = t180 * t635;
  t1947 = t754 * t1630;
  t1949 = t70 * t1630;
  t1950 = t725 * t1949;
  t1952 = t310 * t1684;
  t1954 = t132 * t1691;
  t1956 = -0.24e2 * t1631 + 0.144e3 * t1919 - 0.144e3 * t1947 - 0.384e4 * t1950 + 0.1152e5 * t1952 - 0.8064e4 * t1954;
  t1957 = t81 * t1956;
  t1959 = -0.3e1 * t250 * t614 * t175 + 0.2e1 * t288 * t636 * t175 - 0.6e1 * t657 * t618 * t175 + 0.4e1 * t288 * t207 * t588 + 0.3e1 * t106 * t1915 + 0.3e1 * t106 * t1922 - t124 * t1943 - t124 * t1957 + 0.6e1 * t1925 * t166 - 0.3e1 * t1937 * t166 + 0.2e1 * t288 * t1931;
  t1960 = -0.6e1 * t250 * t193 * t588 - 0.6e1 * t250 * t559 * t206 - 0.6e1 * t250 * t567 * t206 + 0.12e2 * t1026 * t1896 - 0.12e2 * t1426 * t1893 + 0.6e1 * t1908 * t166 + 0.6e1 * t1877 * t1879 - 0.6e1 * t678 * t1882 + 0.6e1 * t245 * t1885 + 0.12e2 * t245 * t1888 + t1959;
  t1964 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1960);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1964;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1966 = t597 * t192;
  t1967 = t1966 * t74;
  t1970 = t598 * t206;
  t1973 = t193 * t613;
  t1985 = 0.1e1 / t274;
  t1987 = 0.192e3 * t1985 * t62;
  t1988 = t747 * t1985;
  t1990 = t754 * t1985;
  t1992 = t1987 - 0.576e3 * t1988 + 0.384e3 * t1990;
  t1993 = t81 * t1992;
  t1996 = t617 * t206;
  t1997 = t81 * t1996;
  t2007 = t70 * t1985;
  t2010 = t137 * t1985;
  t2013 = t323 * t1985;
  t2016 = t734 * t1985;
  t2019 = 0.193536e6 * t132 * t2013 - 0.192e4 * t769 * t1985 + 0.3072e5 * t725 * t2007 - 0.13824e6 * t310 * t2010 - 0.86016e5 * t67 * t2016 + t1987 - 0.1728e4 * t1988 + 0.3456e4 * t1990;
  t2020 = t81 * t2019;
  t2022 = -0.9e1 * t250 * t193 * t635 + 0.18e2 * t694 * t193 * t617 - 0.9e1 * t250 * t614 * t206 + 0.6e1 * t288 * t207 * t635 + 0.3e1 * t106 * t1993 - t124 * t2020 + 0.6e1 * t1967 * t81 - 0.18e2 * t678 * t1970 + 0.18e2 * t245 * t1973 - 0.6e1 * t657 * t1997;
  t2026 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t2022);
  tv3tau30 = 0.2e1 * rho[0] * t2026;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t2044 = t802 * t123;
  t2058 = t93 / t698 / t76;
  t2059 = t229 * t229;
  t2060 = t669 * t2059;
  t2066 = 0.1e1 / t31 / t672 / t354 * t21 * t160;
  t2069 = t672 * t231;
  t2071 = t671 / t2069;
  t2077 = t230 * t27 / t19 / t1285;
  t2081 = 0.1e1 / t31 / t354;
  t2082 = t28 * t2081;
  t2083 = t98 * t2082;
  t2088 = t93 / t665 / t37;
  t2091 = 0.64e6 / 0.31381059609e11 * t2088 * t2060 * t2066;
  t2093 = 0.352e6 / 0.43046721e8 * t667 * t2071;
  t2095 = 0.3916e6 / 0.4782969e7 * t226 * t2077;
  t2097 = 0.2618e5 / 0.19683e5 * t97 * t2083;
  t2102 = t329 * t329;
  t2108 = t59 / t655 / t73;
  t2109 = t289 * t289;
  t2113 = t58 * t656;
  t2147 = 0.36e2 * t1058 * t283 - 0.24e2 * t2044 * t142 + 0.8e1 * t288 * t142 * t799 - 0.72e2 * t678 * t806 * t141 - 0.36e2 * t678 * t247 * t329 + t75 * (-0.64e6 / 0.31381059609e11 * t2058 * t2060 * t2066 + 0.352e6 / 0.43046721e8 * t700 * t2071 - 0.3916e6 / 0.4782969e7 * t335 * t2077 + 0.2618e5 / 0.19683e5 * t147 * t2083 + t2091 - t2093 + t2095 - t2097) + 0.24e2 * t803 * t150 + 0.6e1 * t288 * t81 * t2102 + 0.24e2 * t2108 * t81 * t2109 - 0.72e2 * t2113 * t659 * t118 - 0.36e2 * t657 * t290 * t329 + 0.24e2 * t288 * t293 * t329 - 0.12e2 * t250 * t837 * t141 - 0.18e2 * t250 * t283 * t329 - 0.12e2 * t250 * t119 * t799 - 0.36e2 * t250 * t809 * t141 - 0.36e2 * t250 * t812 * t141 - 0.36e2 * t250 * t254 * t329 + 0.72e2 * t245 * t254 * t282 + 0.24e2 * t245 * t119 * t836;
  t2148 = t282 * t282;
  t2154 = t42 * t710;
  t2158 = 0.616e4 / 0.81e2 * t2154 - 0.2618e4 / 0.81e2 * t29 * t2081;
  t2161 = t268 * t268;
  t2167 = t273 * t234;
  t2172 = t726 * t127;
  t2175 = t60 * t137;
  t2176 = t272 * t272;
  t2178 = 0.1e1 / t31 / t1013;
  t2180 = t2176 * t2178 * t28;
  t2189 = t48 * t70;
  t2191 = t112 * t735 * t737;
  t2204 = t310 * t323;
  t2213 = t725 * t137;
  t2221 = 0.288e3 * t817 * t268 + 0.24e2 * t115 * t2158 + 0.144e3 * t260 * t2161 - 0.57344e8 / 0.9e1 * t67 * t736 * t1286 + 0.8704e6 / 0.27e2 * t305 * t2167 - 0.4928e5 / 0.27e2 * t128 * t2154 + 0.96e3 * t2172 * t108 + 0.8e6 / 0.9e1 * t2175 * t2180 + 0.4608e5 * t725 * t311 * t268 + 0.768e4 * t310 * t133 * t763 + 0.32e6 / 0.3e1 * t2189 * t2191 + 0.1536e5 * t314 * t763 * tau[0] * t165 - 0.6144e5 * t314 * t784 * t102 - 0.28672e7 * t788 * t789 * t947 + 0.2688e7 * t2204 * t257 * t272 * t403 + 0.5376e6 * t788 * t268 * t272 * t403 + 0.3072e6 * t2213 * t726 * tau[0] * t165 - 0.3072e6 * t779 * t780 * t102;
  t2230 = params->b * t48;
  t2231 = t257 * t257;
  t2238 = t735 * t1286;
  t2244 = t132 * t734;
  t2248 = 0.1e1 / t322 / t53;
  t2249 = t67 * t2248;
  t2253 = t947 * t112;
  t2257 = t241 * t112;
  t2260 = t47 * t304;
  t2282 = 0.45056e6 / 0.3e1 * t314 * t315 * t241 + 0.288e4 * t820 * t785 + 0.384e3 * t132 * t70 * t2158 + 0.2304e5 * t2230 * t70 * t2231 + 0.576e4 * t310 * t70 * t2161 - 0.128e7 / 0.9e1 * t769 * t2238 + 0.192e3 * t260 * t763 * t112 + 0.28672e8 / 0.3e1 * t2244 * t2191 + 0.1792e8 / 0.3e1 * t2249 * t2180 - 0.512e5 * t754 * t272 * t2253 + 0.1408e5 / 0.3e1 * t271 * tau[0] * t2257 + 0.192e5 * t2260 * t257 * t277 + 0.48e3 * t271 * t763 * t108 + 0.96e4 * t754 * t268 * t277 + 0.243712e8 / 0.27e2 * t324 * t2167 - 0.78848e6 / 0.27e2 * t138 * t2154 - 0.384e4 * t748 * t264 - 0.192e4 * t751 * t264 + 0.2304e6 * t310 * t137 * t112 * t785;
  t2326 = t257 * t127;
  t2341 = -0.2176e6 / 0.27e2 * t271 * t2167 + 0.4928e5 / 0.81e2 * t115 * t2154 - 0.32e3 * t1220 * t268 * t108 + 0.128e4 / 0.3e1 * t817 * t264 - 0.16e4 * t747 * t268 * t277 - 0.32e3 / 0.3e1 * t260 * t763 * t108 - 0.24e2 * t2161 * t54 - 0.32e2 * t379 * t763 - 0.8e1 * t107 * t2158 - 0.16e4 * t2326 * t277 - 0.128e6 / 0.9e1 * t2260 * t2191 + 0.256e6 / 0.9e1 * t754 * t2238 - 0.4e6 / 0.27e2 * t2189 * t2180 + 0.256e5 / 0.3e1 * t820 * t741 + 0.128e4 / 0.3e1 * t823 * t264 - 0.2816e5 / 0.27e2 * t261 * t744;
  t2360 = t57 * t287;
  t2368 = t118 * t141;
  t2372 = 0.72e2 * t1026 * t141 * t329 * t118 + 0.12e2 * t106 * t150 * t836 + 0.3e1 * t106 * t81 * t2341 + 0.18e2 * t106 * t340 * t282 - 0.72e2 * t1087 * t2368 * t282 + 0.72e2 * t2360 * t247 * t289 + 0.36e2 * t245 * t340 * t246 + 0.72e2 * t694 * t254 * t289 + 0.36e2 * t694 * t283 * t289 - t2091 + t2093;
  t2379 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t101 * t83 - 0.5e1 / 0.9e1 * t7 * t645 * t152 + t7 * t216 * t342 / 0.2e1 - t7 * t89 * t847 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2147 + t2097 - t2095 + 0.18e2 * t245 * t81 * t2148 - t124 * t81 * (t2221 + t2282) - 0.4e1 * t124 * t150 * t799 - 0.4e1 * t124 * t719 * t141 - 0.6e1 * t124 * t340 * t329 + 0.12e2 * t288 * t340 * t289 - 0.24e2 * t657 * t150 * t658 + 0.12e2 * t106 * t719 * t118 + t2372));
  tv4rho40 = 0.2e1 * rho[0] * t2379 + 0.8e1 * t852;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t2396 = t356 * t141;
  t2405 = t678 * t883;
  t2408 = t678 * t887;
  t2428 = t276 * t329;
  t2441 = t276 * t289;
  t2446 = 0.12e3 * t365 * t384 * t276 * t282 * tau[0] - 0.96e3 * t365 * t384 * t862 * t118 + 0.96e2 * t913 * t366 * t875 * t118 - 0.18e2 * t913 * t366 * t879 * t118 + 0.18e2 * t870 * t366 * t879 * t141 - 0.18e2 * t913 * t366 * t897 * t141 + 0.48e3 * t371 * t384 * t2396 * tau[0] - 0.6e2 * t371 * t384 * t2428 * tau[0] + 0.12e3 * t870 * t384 * t2441 * tau[0] - 0.36e2 * t2405 * t915 - 0.36e2 * t2408 * t915 + 0.24e3 * t891 * t920 + 0.24e3 * t894 * t920 - 0.12e3 * t901 * t910 - 0.12e3 * t905 * t910;
  t2447 = t2360 * t364;
  t2452 = t364 * t62;
  t2453 = t678 * t2452;
  t2454 = t141 * tau[0];
  t2460 = t353 * t704 * sigma[0];
  t2462 = 0.341e5 / 0.1594323e7 * t226 * t2460;
  t2499 = -0.24e3 * t2453 * t403 * t2454 * t118 + 0.36e2 * t2447 * t366 * t367 * t289 - 0.9e1 * t250 * t925 * t141 - 0.18e2 * t250 * t976 * t141 + 0.24e2 * t2108 * t176 * t658 + 0.18e2 * t245 * t420 * t282 - 0.18e2 * t678 * t398 * t246 - 0.18e2 * t678 * t418 * t246 - 0.9e1 * t250 * t420 * t329 + 0.6e1 * t288 * t418 * t329 + 0.6e1 * t288 * t423 * t329 - 0.18e2 * t657 * t398 * t289 - 0.18e2 * t657 * t418 * t289 + 0.18e2 * t694 * t420 * t289 + t2462;
  t2532 = t669 * t674 * t229;
  t2534 = 0.38e5 / 0.14348907e8 * t667 * t2532;
  t2541 = t2113 * t81;
  t2545 = t1286 * t272;
  t2549 = -0.18e2 * t678 * t1022 * t141 - 0.54e2 * t2541 * t1027 * t289 - 0.9e1 * t250 * t974 * t118 - 0.9e1 * t250 * t979 * t118 - 0.18e2 * t250 * t981 * t118 + 0.6e1 * t288 * t974 * t141 + 0.6e1 * t288 * t979 * t141 + 0.12e2 * t288 * t981 * t141 - 0.32e4 * t164 * t747 * t2545 - 0.3e1 * t250 * t176 * t836 + 0.2e1 * t288 * t176 * t799 - 0.9e1 * t250 * t398 * t282 - 0.9e1 * t250 * t418 * t282 + 0.6e1 * t288 * t398 * t329 - t2534;
  t2550 = t160 * t710;
  t2552 = 0.154e4 / 0.6561e4 * t97 * t2550;
  t2553 = t175 * t282;
  t2557 = t694 * t150;
  t2564 = t175 * t329;
  t2568 = t2360 * t81;
  t2598 = 0.36e2 * t1026 * t417 * t118 * t141 + 0.36e2 * t2568 * t175 * t246 * t141 + 0.18e2 * t1026 * t2564 * t118 + 0.18e2 * t1026 * t2553 * t141 + 0.9e1 * t106 * t1068 * t118 - 0.3e1 * t124 * t1068 * t141 - 0.18e2 * t1087 * t2553 * t118 - 0.3e1 * t124 * t150 * t973 - t124 * t719 * t175 - 0.3e1 * t124 * t340 * t417 - 0.18e2 * t1485 * t2564 * t141 + 0.6e1 * t288 * t429 * t289 + 0.36e2 * t2557 * t1028 + 0.6e1 * t803 * t180 - t2552;
  t2609 = t669 / t31 / t672 / t274;
  t2612 = t670 * t21 * t160;
  t2623 = 0.8e5 / 0.10460353203e11 * t2088 * t2609 * t2612;
  t2636 = t737 * t112;
  t2637 = t2636 * t272;
  t2640 = t102 * t268;
  t2643 = t165 * t763;
  t2647 = t2178 * t735 * t28;
  t2650 = t235 * tau[0];
  t2671 = -0.18e2 * t1220 * t941 - 0.18e3 * t2326 * t404 - 0.24e4 * t2260 * t2637 + 0.48e2 * t260 * t2640 - 0.6e1 * t260 * t2643 - 0.1e5 / 0.3e1 * t2189 * t2647 - 0.544e4 / 0.3e1 * t271 * t2650 + 0.3584e6 * t132 * t323 * t1286 * t272 + 0.19712e5 / 0.9e1 * t132 * t171 * t710 - 0.176e3 * t260 * t2257 + 0.1152e6 * t779 * t947 * t315 - 0.288e4 * t953 * t165 * t766 - 0.576e5 * t2213 * t403 * t780;
  t2677 = t276 * t268;
  t2681 = t2230 * t70;
  t2692 = t356 * t112;
  t2708 = -0.144e5 * t779 * t403 * t784 - 0.896e6 / 0.3e1 * t2244 * t2647 - 0.18e3 * t933 * t2677 * tau[0] - 0.288e4 * t2681 * t165 * t726 + 0.768e4 * t953 * t102 * t257 - 0.704e4 * t409 * t2257 - 0.17408e6 / 0.3e1 * t314 * t2650 + 0.144e4 * t933 * t2692 * tau[0] - 0.336e6 * t2204 * t2637 + 0.192e4 * t409 * t2640 - 0.24e3 * t409 * t2643 + 0.48e2 * t817 * t102 + 0.64e4 * t754 * t2545 + 0.1232e4 / 0.9e1 * t115 * t711;
  t2724 = t112 * t127;
  t2736 = -t124 * t180 * t799 + 0.18e2 * t245 * t429 * t246 + t75 * (0.8e5 / 0.10460353203e11 * t2058 * t2609 * t2612 - 0.38e5 / 0.14348907e8 * t700 * t2532 + 0.341e5 / 0.1594323e7 * t335 * t2460 - 0.154e4 / 0.6561e4 * t147 * t2550 - t2623 + t2534 - t2462 + t2552) - 0.3e1 * t124 * t429 * t329 + 0.3e1 * t106 * t180 * t836 - t124 * t81 * (t2671 + t2708) + 0.9e1 * t106 * t429 * t282 + 0.88e2 * t376 * t1051 - 0.48e2 * t376 * t1048 + 0.6e3 * t376 * t1043 - 0.24e2 * t164 * t1039 * t102 + 0.6e3 * t164 * t2724 * t944 + 0.88e2 * t164 * t379 * t241 - 0.1232e4 / 0.9e1 * t164 * t107 * t711 - 0.48e2 * t1059 * t389;
  t2739 = t763 * t54;
  t2760 = t127 * t737;
  t2769 = t304 * t2178;
  t2774 = t340 * t47;
  t2778 = t150 * t112;
  t2784 = 0.9e1 * t376 * t1040 + 0.3e1 * t164 * t2739 * t165 + 0.3e1 * t106 * t719 * t166 + 0.9e1 * t1034 * t380 + 0.18e2 * t1058 * t150 * t166 + 0.18e2 * t1059 * t380 - 0.24e2 * t1034 * t389 - 0.6e1 * t657 * t180 * t658 - 0.6e1 * t2044 * t176 + 0.12e4 * t365 * t2760 * t272 * t118 - 0.6e3 * t371 * t2760 * t272 * t141 + 0.4e4 / 0.3e1 * t383 * t2769 * t735 * t28 + 0.18e2 * t245 * t2774 * t368 + 0.36e2 * t245 * t2778 * t368 + 0.18e2 * t891 * t898;
  t2786 = t81 * t268;
  t2796 = t250 * t2774;
  t2799 = t250 * t2778;
  t2802 = t250 * t2786;
  t2805 = t2113 * t364;
  t2818 = t694 * t883;
  t2821 = t694 * t887;
  t2833 = -0.48e2 * t365 * t366 * t101 * t282 - 0.48e2 * t870 * t366 * t101 * t289 + 0.24e2 * t371 * t366 * t101 * t329 - 0.18e2 * t2805 * t366 * t33 * t658 + 0.6e1 * t365 * t366 * t33 * t836 + 0.12e3 * t106 * t2778 * t386 + 0.18e2 * t245 * t2786 * t368 - 0.9e1 * t2796 * t373 - 0.18e2 * t2799 * t373 - 0.9e1 * t2802 * t373 + 0.18e2 * t2818 * t872 + 0.18e2 * t2821 * t872 - 0.96e2 * t894 * t867 + 0.18e2 * t894 * t898 + t2623;
  t2853 = t1317 * t364;
  t2856 = t246 * t123;
  t2857 = t2856 * t364;
  t2880 = 0.48e2 * t905 * t876 - 0.48e3 * t888 * t863 + 0.6e2 * t106 * t2786 * t386 + 0.176e3 * t365 * t366 * t240 * t118 - 0.88e2 * t371 * t366 * t240 * t141 + 0.1088e5 / 0.9e1 * t383 * t384 * t234 * tau[0] + 0.18e2 * t2853 * t898 - 0.18e2 * t2857 * t373 + 0.12e3 * t1058 * t364 * t386 - 0.9e1 * t901 * t880 - 0.9e1 * t905 * t880 - 0.3e1 * t371 * t366 * t33 * t799 - 0.96e2 * t891 * t867 + 0.48e2 * t901 * t876 - 0.48e3 * t884 * t863 + 0.6e2 * t106 * t2774 * t386;
  t2888 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t182 + t7 * t216 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t1072 - 0.3e1 / 0.8e1 * t7 * t20 * (t2446 + t2499 + t2549 + t2598 + t2736 + t2784 + t2833 + t2880));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2888 + 0.6e1 * t1077;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2908 = t1220 * t404;
  t2910 = t260 * t948;
  t2912 = t2326 * t456;
  t2915 = t454 * t268 * tau[0];
  t2916 = t933 * t2915;
  t2921 = 0.1e1 / t31 / t1285;
  t2923 = t2921 * t735 * t28;
  t2927 = t1220 * t1165;
  t2929 = -0.8e1 * t2739 * t188 - 0.16e4 * t2724 * t1150 + 0.96e3 * t2908 - 0.5248e5 / 0.27e2 * t2910 + 0.48e3 * t2912 + 0.48e3 * t2916 - 0.32e3 / 0.3e1 * t1048 + 0.208e5 / 0.3e1 * t1043 - 0.32e5 / 0.9e1 * t2260 * t2923 + 0.352e4 / 0.27e2 * t1051 + 0.48e2 * t2927;
  t2930 = t188 * t763;
  t2931 = t260 * t2930;
  t2933 = t2189 * t2923;
  t2936 = t268 * t62;
  t2939 = t1149 * t112;
  t2940 = t2939 * t272;
  t2941 = t2260 * t2940;
  t2950 = 0.16e2 * t2931 + 0.8e5 / 0.9e1 * t2933 + 0.4e2 * t1040 - 0.16e3 * t2936 * t456 + 0.64e4 * t2941 - 0.8e2 * t931 - 0.8e2 * t942 - 0.352e4 / 0.27e2 * t951 + 0.64e3 / 0.3e1 * t939 - 0.288e4 * t936 + 0.2624e5 / 0.9e1 * t949 - 0.416e5 / 0.3e1 * t945;
  t2988 = -0.3e1 * t124 * t340 * t499 + 0.3e1 * t106 * t81 * (t2929 + t2950) - t124 * t719 * t206 + 0.9e1 * t106 * t150 * t1236 - 0.6e1 * t2044 * t207 + 0.36e2 * t245 * t1215 * t118 + 0.18e2 * t245 * t448 * t282 + 0.6e1 * t288 * t476 * t329 + 0.2e1 * t288 * t207 * t799 + 0.18e2 * t1317 * t1119 + 0.18e2 * t245 * t1212 * t118 + 0.6e1 * t288 * t500 * t329 - 0.18e2 * t657 * t500 * t289 + 0.12e2 * t288 * t1242 * t141;
  t3034 = -0.9e1 * t250 * t1210 * t118 - 0.9e1 * t250 * t1240 * t118 - 0.18e2 * t250 * t1242 * t118 + 0.6e1 * t288 * t1210 * t141 - 0.9e1 * t250 * t1237 * t141 + 0.6e1 * t288 * t1240 * t141 - 0.3e1 * t250 * t207 * t836 - 0.18e2 * t678 * t476 * t246 - 0.18e2 * t678 * t500 * t246 - 0.9e1 * t250 * t476 * t282 - 0.9e1 * t250 * t500 * t282 - 0.9e1 * t250 * t467 * t329 + 0.18e2 * t694 * t448 * t289 + 0.18e2 * t694 * t467 * t289 - 0.18e2 * t657 * t476 * t289;
  t3071 = t206 * t141;
  t3083 = 0.36e2 * t1026 * t499 * t118 * t141 + 0.18e2 * t1026 * t206 * t282 * t141 + 0.36e2 * t2568 * t1088 * t289 - 0.54e2 * t2541 * t1098 * t289 + 0.18e2 * t245 * t1237 * t118 - 0.9e1 * t250 * t1212 * t141 - 0.18e2 * t250 * t1215 * t141 - 0.18e2 * t1485 * t3071 * t329 - 0.18e2 * t2113 * t193 * t658 + 0.6e1 * t245 * t193 * t836 - 0.3e1 * t250 * t193 * t799 + 0.24e2 * t2108 * t207 * t658 + 0.18e2 * t245 * t467 * t282 - 0.9e1 * t250 * t448 * t329 - 0.18e2 * t2856 * t445;
  t3103 = t192 * t141;
  t3107 = t678 * t150;
  t3146 = 0.72e3 * t747 * t954 - 0.96e3 * t271 * t938 - 0.10496e6 / 0.9e1 * t305 * t948 + 0.5632e5 / 0.9e1 * t67 * t202 * t240 + 0.36e3 * t271 * t941 - 0.48e5 * t2189 * t2940 - 0.72e2 * t271 * t2930 - 0.16e6 / 0.3e1 * t2175 * t2923 + 0.93184e7 / 0.3e1 * t67 * t734 * t737 * t272 - 0.416e5 * t945 - 0.352e4 / 0.9e1 * t951 - 0.24e3 * t931 - 0.24e3 * t942;
  t3151 = t455 * t780;
  t3156 = t455 * t784;
  t3159 = t188 * t766;
  t3168 = t188 * t726;
  t3175 = 0.2624e5 / 0.3e1 * t949 - 0.23296e7 * t966 - 0.5632e5 / 0.9e1 * t971 + 0.64e3 * t939 + 0.4608e6 * t2213 * t3151 + 0.96768e6 * t788 * t957 - 0.16128e6 * t788 * t3156 + 0.2304e5 * t953 * t3159 + 0.1152e6 * t779 * t3156 - 0.3456e5 * t779 * t3159 - 0.8064e6 * t2204 * t3151 + 0.2304e5 * t2681 * t3168 - 0.3072e5 * t314 * t938 - 0.293888e7 / 0.9e1 * t324 * t948;
  t3210 = -0.4608e5 * t2213 * t3168 + 0.576e5 * t779 * t954 - 0.432e3 * t747 * t28 * t44 * t112 * t268 - 0.576e4 * t2260 * t27 * t454 * t257 * tau[0] + 0.1728e5 * t1193 * t935 - 0.288e4 * t1193 * t2915 + 0.2688e7 * t2204 * t2940 + 0.7168e7 / 0.3e1 * t2244 * t2923 - 0.3584e7 * t2249 * t2923 + 0.1152e5 * t314 * t941 - 0.43008e7 * t2244 * t2940 + 0.192e4 * t409 * t2930 - 0.2304e4 * t314 * t2930 - 0.864e4 * t936;
  t3228 = -0.384e5 * t955 + 0.256e5 * t960 - 0.96e4 * t962 + 0.83968e6 / 0.3e1 * t968 + 0.144e4 * t2912 + 0.144e3 * t2927 + 0.48e2 * t2931 + 0.8e5 / 0.3e1 * t2933 + 0.192e5 * t2941 - 0.6912e6 * t958 + 0.144e4 * t2916 + 0.352e4 / 0.9e1 * t128 * t241 - 0.144e3 * t2172 * t188 + 0.208e6 / 0.3e1 * t769 * t944;
  t3239 = 0.18e2 * t1026 * t1098 * t329 + 0.36e2 * t2568 * t206 * t246 * t141 - 0.18e2 * t1087 * t1098 * t282 + 0.36e2 * t2557 * t1099 - 0.18e2 * t1087 * t192 * t282 * t141 - 0.18e2 * t1087 * t1088 * t329 + 0.18e2 * t1026 * t3103 * t329 - 0.36e2 * t3107 * t1089 - 0.36e2 * t1087 * t466 * t118 * t141 + 0.18e2 * t1058 * t448 + 0.18e2 * t1058 * t467 - 0.3e1 * t124 * t150 * t1209 - t124 * t81 * (t3146 + t3175 + t3210 + t3228) + 0.3e1 * t106 * t719 * t192 + 0.9e1 * t106 * t340 * t466;
  t3246 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t209 + t7 * t216 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t1246 - 0.3e1 / 0.8e1 * t7 * t20 * (t2988 + t3034 + t3083 + t3239));
  tv4rho3tau0 = 0.2e1 * rho[0] * t3246 + 0.6e1 * t1251;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t3258 = t669 / t31 / t2069;
  t3261 = t229 * t21 * t160;
  t3264 = t1015 * sigma[0];
  t3267 = t353 * t234;
  t3272 = 0.1e5 / 0.3486784401e10 * t2088 * t3258 * t3261;
  t3274 = 0.1075e5 / 0.14348907e8 * t667 * t3264;
  t3276 = 0.19e4 / 0.531441e6 * t226 * t3267;
  t3315 = t356 * t175;
  t3324 = t276 * t417;
  t3329 = t678 * t1364;
  t3332 = t75 * (-0.1e5 / 0.3486784401e10 * t2058 * t3258 * t3261 + 0.1075e5 / 0.14348907e8 * t700 * t3264 - 0.19e4 / 0.531441e6 * t335 * t3267 + t3272 - t3274 + t3276) - 0.24e2 * t2405 * t1267 + 0.24e2 * t2818 * t1258 - 0.8e2 * t901 * t1263 - 0.24e2 * t2408 * t1267 + 0.24e2 * t2821 * t1258 - 0.8e2 * t905 * t1263 - 0.24e2 * t913 * t366 * t1359 * t118 + 0.64e2 * t913 * t366 * t1374 * t118 - 0.36e2 * t2805 * t366 * t517 * t289 - 0.64e2 * t870 * t366 * t1374 * t141 - 0.12e2 * t913 * t366 * t517 * t282 + 0.12e2 * t870 * t366 * t517 * t329 + 0.32e3 * t371 * t384 * t3315 * tau[0] + 0.24e2 * t870 * t366 * t1359 * t141 - 0.8e2 * t371 * t384 * t3324 * tau[0] - 0.24e2 * t3329 * t915;
  t3342 = t175 * t141;
  t3375 = t1286 * tau[0];
  t3384 = 0.16e3 * t1365 * t920 - 0.8e2 * t1368 * t910 - 0.48e2 * t913 * t1348 * t908 * t112 + 0.16e3 * t694 * t2452 * t403 * t3342 * tau[0] + 0.48e2 * t2360 * t364 * t54 * t165 * t1028 - 0.16e3 * t2453 * t403 * t1027 * tau[0] - 0.76e2 / 0.3e1 * t164 * t235 * t54 - t3276 - 0.3e1 / 0.2e1 * t1059 * t524 - 0.32e2 * t1329 * t389 - 0.32e2 * t521 * t1048 + 0.16e2 * t513 * t947 * t1334 + 0.24e2 * t513 * t2326 * t403 - 0.128e3 * t1318 * t1343 - 0.128e3 * t1321 * t1343 - 0.64e4 / 0.3e1 * t513 * t754 * t3375 + 0.12e2 * t1058 * t180 * t166 + 0.176e3 / 0.3e1 * t521 * t1051;
  t3403 = t2178 * t272 * t28;
  t3430 = 0.3e1 / 0.2e1 * t2936 * t403 + 0.3e2 * t2724 * t1324 - 0.16e2 * t1220 * t947 + 0.1e3 * t2260 * t3403 - 0.2e3 * t747 * t3375 + 0.152e3 / 0.3e1 * t260 * t235 + 0.72e3 * t2681 * t403 * t257 + 0.96e4 * t2213 * t2636 * tau[0] - 0.256e4 * t953 * t2253 + 0.24e3 * t953 * t403 * t268 + 0.14e5 * t2204 * t3403 - 0.16e5 * t310 * t137 * t1286 * tau[0] + 0.608e4 / 0.3e1 * t310 * t536 * t234;
  t3469 = -0.3e1 / 0.2e1 * t1026 * t403 * t54 * t289 - 0.8e1 * t1338 * t947 * t1339 - 0.2e1 * t124 * t150 * t1405 - t124 * t81 * t3430 - 0.2e1 * t124 * t180 * t973 - t124 * t340 * t540 - 0.2e1 * t124 * t1298 * t141 + 0.2e1 * t288 * t340 * t527 - 0.2e1 * t124 * t1068 * t175 - 0.4e1 * t124 * t429 * t417 - t124 * t545 * t329 + 0.6e1 * t106 * t1298 * t118 + 0.3e1 * t106 * t545 * t282 + 0.1216e4 / 0.3e1 * t513 * t271 * t235 + 0.6e1 * t521 * t1040 - 0.3e1 * t1321 * t1335 - 0.3e1 / 0.2e1 * t513 * t403 * t54 * t282;
  t3474 = t250 * t150;
  t3484 = t282 * t74;
  t3503 = t2178 * t127;
  t3504 = t272 * t28;
  t3510 = t417 * t417;
  t3520 = t694 * t1364;
  t3525 = -0.2e2 * t513 * t1311 * t118 * tau[0] + 0.3e1 / 0.2e1 * t3474 * t1340 + 0.3e1 / 0.4e1 * t1338 * t403 * t54 * t329 + 0.1e2 * t1338 * t1311 * t2454 + 0.12e2 * t3484 * t81 * t514 + 0.24e2 * t1317 * t150 * t514 + 0.32e3 * t1318 * t1325 + 0.12e2 * t245 * t340 * t514 + 0.32e3 * t1321 * t1325 + 0.6e1 * t106 * t1068 * t166 + 0.12e2 * t1329 * t380 - 0.25e2 * t164 * t3503 * t3504 + 0.4e3 * t521 * t1043 + 0.4e1 * t288 * t81 * t3510 + 0.2e1 * t288 * t545 * t289 + 0.6e1 * t245 * t545 * t246 + 0.12e2 * t3520 * t872 + 0.32e2 * t1368 * t876;
  t3528 = t2360 * t1346;
  t3542 = t304 * t737;
  t3551 = t429 * t47;
  t3555 = t250 * t3551;
  t3561 = t180 * t112;
  t3565 = t250 * t3561;
  t3571 = t81 * t27;
  t3572 = t678 * t3571;
  t3576 = t118 * t123;
  t3577 = t3576 * t1346;
  t3584 = 0.24e2 * t3528 * t1348 * t2441 + 0.128e3 * t1347 * t1348 * t2396 - 0.256e3 * t365 * t1348 * t2692 + 0.32e2 * t901 * t1375 + 0.32e2 * t905 * t1375 + 0.64e3 * t365 * t3542 * t315 + 0.4e4 / 0.3e1 * t245 * t1346 * t70 * t2178 * t3504 + 0.24e2 * t245 * t3551 * t368 - 0.12e2 * t3555 * t373 + 0.8e2 * t106 * t3551 * t386 + 0.24e2 * t245 * t3561 * t368 - 0.12e2 * t3565 * t373 + 0.8e2 * t106 * t3561 * t386 + 0.3e1 * t3572 * t1862 * t2368 - 0.24e2 * t3577 * t1349 + 0.48e2 * t2853 * t1352 - 0.12e2 * t2857 * t518;
  t3610 = t678 * t150 * t48;
  t3634 = -0.176e3 / 0.3e1 * t371 * t366 * t240 * t175 + 0.32e2 * t371 * t366 * t101 * t417 - 0.64e2 * t1365 * t867 - 0.6e1 * t371 * t366 * t33 * t973 + 0.12e2 * t1365 * t898 - 0.6e1 * t1368 * t880 - 0.12e2 * t1347 * t1348 * t2428 + 0.24e2 * t365 * t1348 * t2677 - 0.24e2 * t3610 * t1349 + 0.48e2 * t891 * t1352 - 0.32e3 * t1347 * t3542 * t2454 - 0.32e3 * t1371 * t863 - 0.4e3 * t371 * t2760 * t175 * t272 - 0.6e1 * t2796 * t518 - 0.12e2 * t2799 * t518 - 0.12e2 * t901 * t1360 - 0.6e1 * t2802 * t518 - 0.12e2 * t905 * t1360;
  t3667 = t694 * t180;
  t3691 = 0.12e2 * t1026 * t540 * t118 * t141 - 0.12e2 * t250 * t1381 * t118 - 0.12e2 * t250 * t1384 * t118 - 0.6e1 * t250 * t1387 * t118 - 0.6e1 * t250 * t1406 * t118 + 0.4e1 * t288 * t1387 * t141 + 0.4e1 * t288 * t1406 * t141 + 0.24e2 * t2108 * t528 * t289 + 0.12e2 * t2360 * t528 * t246 - 0.12e2 * t678 * t531 * t246 - 0.6e1 * t678 * t541 * t246 - 0.6e1 * t250 * t531 * t282 - 0.3e1 * t250 * t541 * t282 + 0.4e1 * t288 * t531 * t329 + 0.2e1 * t288 * t541 * t329 - 0.12e2 * t657 * t531 * t289 - 0.6e1 * t657 * t541 * t289 + 0.24e2 * t3667 * t1028;
  t3731 = t1286 * t62;
  t3739 = 0.8e1 * t288 * t1381 * t141 + 0.8e1 * t288 * t1384 * t141 + 0.8e1 * t288 * t398 * t417 + 0.4e1 * t288 * t176 * t973 + 0.12e2 * t694 * t1378 * t118 + 0.6e1 * t694 * t528 * t282 - 0.12e2 * t657 * t1378 * t141 - 0.6e1 * t657 * t528 * t329 - 0.6e1 * t250 * t1408 * t141 - t3272 - 0.36e2 * t2541 * t527 * t118 * t141 + 0.24e2 * t1026 * t1027 * t417 - 0.24e2 * t1485 * t3342 * t417 + 0.8e1 * t376 * t1306 + 0.2e3 / 0.3e1 * t164 * t3731 * tau[0] - 0.3e1 / 0.4e1 * t1034 * t524 - 0.1e2 * t376 * t1312 + t3274;
  t3747 = my_piecewise3(t3, 0, t7 * t216 * t547 / 0.12e2 - t7 * t89 * t1415 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3332 + t3384 + t3469 + t3525 + t3584 + t3634 + t3691 + t3739));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t3747 + 0.4e1 * t1420;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t3757 = t2113 * t207;
  t3759 = t107 * t165 * t289;
  t3763 = t107 * t102 * t141;
  t3766 = t2360 * t193;
  t3775 = t678 * t476;
  t3778 = t678 * t500;
  t3788 = t694 * t476;
  t3791 = t694 * t500;
  t3794 = t379 * t1427;
  t3798 = t107 * t165 * t329;
  t3809 = 0.32e2 * t1433 * t107 * t102 * t118 - 0.6e1 * t1433 * t107 * t165 * t282 - 0.12e2 * t1433 * t379 * t1434 - 0.4e2 * t1572 * t1226 - 0.4e2 * t1575 * t1226 + 0.32e2 * t1426 * t3763 + 0.12e2 * t3788 * t1428 + 0.12e2 * t3791 * t1428 - 0.12e2 * t3775 * t1435 - 0.12e2 * t3778 * t1435 - 0.32e2 * t1438 * t3763 + 0.12e2 * t1438 * t3794 + 0.6e1 * t1438 * t3798 - 0.4e2 * t570 * t2908 + 0.16e3 * t570 * t2910 - 0.18e2 * t3757 * t3759 + 0.12e2 * t3766 * t3759;
  t3810 = t3576 * t193;
  t3813 = t678 * t448;
  t3816 = t678 * t467;
  t3833 = t207 * t47;
  t3834 = t694 * t3833;
  t3837 = t193 * t47;
  t3838 = t678 * t3837;
  t3841 = t2360 * t3833;
  t3856 = -0.6e1 * t657 * t589 * t289 - 0.8e2 * t678 * t3833 * t920 + 0.6e1 * t1058 * t559 + 0.6e1 * t1058 * t567 + 0.8e2 * t1561 * t1226 + 0.8e2 * t1564 * t1226 + 0.8e2 * t1567 * t1226 - 0.12e2 * t1426 * t3794 - 0.6e1 * t1426 * t3798 - 0.12e2 * t3810 * t1428 - 0.12e2 * t3813 * t1428 - 0.12e2 * t3816 * t1428 - 0.6e1 * t2856 * t556 + 0.8e2 * t553 * t2908 - 0.32e3 * t553 * t2910 + 0.8e2 * t3834 * t910 - 0.8e2 * t3838 * t910 + 0.24e2 * t3841 * t915;
  t3877 = t2108 * t81;
  t3908 = -0.6e1 * t657 * t576 * t289 - 0.6e1 * t678 * t589 * t246 + 0.6e1 * t694 * t559 * t289 + 0.6e1 * t694 * t567 * t289 - 0.6e1 * t678 * t576 * t246 - 0.88e2 / 0.3e1 * t570 * t1051 + 0.176e3 / 0.3e1 * t553 * t1051 + 0.24e2 * t3877 * t1486 * t289 - 0.18e2 * t2541 * t1491 * t289 + 0.12e2 * t2568 * t1486 * t246 + 0.12e2 * t245 * t1535 * t118 + 0.12e2 * t245 * t1546 * t118 + 0.6e1 * t245 * t567 * t282 - 0.6e1 * t250 * t1551 * t141 - 0.6e1 * t250 * t1554 * t141 - 0.3e1 * t250 * t559 * t329 + 0.12e2 * t245 * t1551 * t118;
  t3930 = t499 * t175;
  t3934 = t206 * t417;
  t3938 = t466 * t175;
  t3942 = t192 * t417;
  t3963 = 0.12e2 * t245 * t1554 * t118 + 0.6e1 * t245 * t559 * t282 - 0.6e1 * t250 * t467 * t417 - 0.3e1 * t250 * t193 * t973 - 0.36e2 * t2541 * t1486 * t2368 + 0.6e1 * t1026 * t1486 * t282 - 0.12e2 * t657 * t150 * t1487 + 0.12e2 * t1026 * t3930 * t118 + 0.12e2 * t1026 * t3934 * t118 + 0.12e2 * t1026 * t3938 * t141 + 0.12e2 * t1026 * t3942 * t141 + 0.6e1 * t1026 * t1491 * t329 + 0.12e2 * t2557 * t1498 - 0.6e1 * t2856 * t207 * t166 + 0.12e2 * t1564 * t380 + 0.6e1 * t245 * t1237 * t166 + 0.12e2 * t1567 * t380 + 0.6e1 * t553 * t1040;
  t4005 = -0.3e1 * t250 * t1210 * t166 - 0.3e1 * t250 * t1240 * t166 - 0.6e1 * t250 * t1242 * t166 + 0.12e2 * t1317 * t448 * t166 + 0.6e1 * t3484 * t193 * t166 - 0.3e1 * t570 * t1040 + 0.4e3 * t553 * t1043 - 0.2e3 * t570 * t1043 - 0.32e2 * t553 * t1048 + 0.16e2 * t570 * t1048 - 0.32e2 * t1561 * t389 - 0.32e2 * t1564 * t389 - 0.32e2 * t1567 * t389 - 0.6e1 * t1572 * t380 + 0.16e2 * t1572 * t389 - 0.6e1 * t1575 * t380 + 0.16e2 * t1575 * t389;
  t4059 = -0.6e1 * t250 * t1529 * t118 - 0.6e1 * t250 * t1533 * t118 + 0.6e1 * t245 * t1212 * t166 - 0.3e1 * t250 * t1212 * t175 + 0.12e2 * t245 * t1215 * t166 - 0.6e1 * t250 * t1215 * t175 - 0.3e1 * t250 * t1237 * t175 + 0.12e2 * t1317 * t467 * t166 + 0.4e1 * t288 * t1529 * t141 + 0.4e1 * t288 * t1531 * t141 + 0.4e1 * t288 * t1533 * t141 + 0.4e1 * t288 * t1549 * t141 - 0.3e1 * t250 * t576 * t282 - 0.3e1 * t250 * t589 * t282 - 0.6e1 * t250 * t448 * t417 + 0.2e1 * t288 * t576 * t329 + 0.2e1 * t288 * t589 * t329 + 0.12e2 * t1561 * t380;
  t4098 = t678 * t180;
  t4114 = 0.2e1 * t288 * t207 * t973 - 0.6e1 * t250 * t1549 * t118 - 0.6e1 * t250 * t1531 * t118 + 0.2e1 * t288 * t1210 * t175 + 0.4e1 * t288 * t500 * t417 - 0.12e2 * t1087 * t3938 * t118 - 0.12e2 * t1087 * t3942 * t118 - 0.6e1 * t1087 * t1491 * t282 + 0.12e2 * t2557 * t1495 + 0.12e2 * t1026 * t588 * t118 * t141 - 0.12e2 * t3107 * t1492 + 0.12e2 * t3667 * t1099 - 0.6e1 * t1485 * t1486 * t329 - 0.12e2 * t4098 * t1089 - 0.12e2 * t1087 * t566 * t118 * t141 + 0.3e1 * t106 * t340 * t566 + 0.6e1 * t106 * t429 * t466 + 0.3e1 * t106 * t180 * t1236;
  t4117 = t455 * t268;
  t4120 = t2939 * tau[0];
  t4124 = t2921 * t272 * t28;
  t4133 = t747 * t1395;
  t4135 = t2260 * t4124;
  t4144 = 0.1088e6 * t1400 - 0.3328e5 / 0.3e1 * t1403 + 0.36e2 * t747 * t4117 + 0.96e3 * t2260 * t4120 + 0.2e4 * t2189 * t4124 - 0.15232e6 * t132 * t964 * tau[0] + 0.13312e5 * t132 * t584 * t356 - 0.312e3 * t4133 - 0.8e3 * t4135 + 0.1664e5 * t1396 - 0.192e4 * t953 * t4117 - 0.768e5 * t2213 * t4120 - 0.112e6 * t2204 * t4124;
  t4151 = t455 * t257;
  t4161 = t2936 * t455;
  t4163 = t2724 * t1503;
  t4169 = 0.288e4 * t779 * t4117 + 0.1344e6 * t2204 * t4120 + 0.1792e6 * t2244 * t4124 - 0.576e4 * t2681 * t4151 + 0.1152e5 * t2213 * t4151 - 0.2496e5 * t779 * t1395 + 0.104e3 * t1389 + 0.136e4 * t1391 - 0.832e3 / 0.3e1 * t1393 - 0.12e2 * t4161 - 0.24e3 * t4163 + 0.36e2 * t2326 * t455 - 0.272e4 * t1325 + 0.416e3 * t1343;
  t4208 = t2921 * t127;
  t4233 = -t124 * t81 * (t4144 + t4169) + 0.3e1 * t106 * t1068 * t192 - 0.12e2 * t1485 * t3930 * t141 - 0.12e2 * t1485 * t3934 * t141 + 0.4e1 * t288 * t1242 * t175 + 0.4e1 * t288 * t476 * t417 - 0.6e1 * t250 * t1546 * t141 - 0.3e1 * t250 * t567 * t329 + 0.2e1 * t288 * t1240 * t175 - 0.6e1 * t250 * t1535 * t141 + 0.24e2 * t2568 * t1491 * t2368 + 0.6e1 * t106 * t150 * t1545 + 0.3e1 * t106 * t81 * (0.416e3 / 0.9e1 * t1306 - 0.136e4 / 0.9e1 * t1312 + 0.2e3 / 0.3e1 * t4208 * t3504 - 0.4e1 * t4161 - 0.8e2 * t4163 + 0.104e3 / 0.3e1 * t1389 - 0.8e3 / 0.3e1 * t4135 + 0.136e4 / 0.3e1 * t1391 - 0.832e3 / 0.9e1 * t1393) - t124 * t1068 * t206 - 0.2e1 * t124 * t429 * t499 - t124 * t180 * t1209 - t124 * t340 * t588 - 0.2e1 * t124 * t150 * t1528;
  t4241 = my_piecewise3(t3, 0, t7 * t216 * t591 / 0.12e2 - t7 * t89 * t1581 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3809 + t3856 + t3908 + t3963 + t4005 + t4059 + t4114 + t4233));
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t4241 + 0.4e1 * t1586;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t4253 = t466 * t466;
  t4257 = t466 * t206;
  t4261 = t192 * t499;
  t4276 = t606 * t268;
  t4279 = t1630 * t112;
  t4280 = t4279 * tau[0];
  t4284 = 0.1e1 / t31 / t672;
  t4286 = t4284 * t272 * t28;
  t4295 = t606 * t257;
  t4300 = t747 * t4276;
  t4302 = t2189 * t4286;
  t4304 = t2260 * t4286;
  t4306 = t2260 * t4280;
  t4311 = -0.896e5 / 0.3e1 * t769 * t1503 + 0.832e4 / 0.3e1 * t305 * t403 + 0.384e4 * t1508 - 0.7168e6 * t1517 + 0.200704e7 * t1523 - 0.13312e6 * t1526 + 0.576e3 * t754 * t4276 + 0.192e5 * t2189 * t4280 + 0.32e5 * t2175 * t4286 - 0.401408e7 / 0.3e1 * t67 * t1172 * tau[0] + 0.23296e6 / 0.3e1 * t67 * t631 * t276 + 0.1152e4 * t2260 * t4295 - 0.384e4 * t754 * t1507 - 0.576e3 * t4300 - 0.32e5 * t4302 + 0.64e4 * t4304 - 0.1536e5 * t4306 + 0.3072e6 * t1520 - 0.1024e6 * t1513 + 0.1664e6 / 0.3e1 * t538;
  t4343 = t2936 * t606;
  t4345 = t2724 * t1636;
  t4347 = t2326 * t606;
  t4350 = -0.21504e6 * t788 * t1507 + 0.4608e5 * t2681 * t4295 - 0.18432e6 * t2213 * t4295 + 0.3584e5 * t1510 - 0.416e4 * t514 - 0.64e3 * t1501 - 0.896e4 * t1504 + 0.96e2 * t4343 + 0.192e4 * t4345 - 0.576e3 * t4347 + 0.416e4 / 0.3e1 * t534;
  t4375 = t499 * t499;
  t4385 = 0.6e1 * t1058 * t614 + 0.12e2 * t245 * t81 * t4253 + 0.24e2 * t1026 * t4257 * t141 + 0.24e2 * t1026 * t4261 * t141 + 0.12e2 * t1026 * t1603 * t329 - t124 * t81 * (-0.21504e7 * t2204 * t4280 + 0.896e6 * t2204 * t4286 + 0.16128e6 * t2204 * t4295 + 0.6144e6 * t2213 * t4280 + 0.172032e7 * t2244 * t4280 - 0.28672e7 * t2244 * t4286 + 0.21504e7 * t2249 * t4286 - 0.4608e5 * t779 * t4276 + 0.32256e5 * t788 * t4276 + 0.1536e5 * t953 * t4276 + t4311 + t4350) - 0.24e2 * t1087 * t4261 * t118 - 0.12e2 * t1087 * t1603 * t282 + 0.24e2 * t2557 * t1607 - 0.24e2 * t1087 * t3103 * t466 - 0.24e2 * t3107 * t1604 - 0.24e2 * t1087 * t4257 * t118 + 0.12e2 * t1026 * t635 * t118 * t141 + 0.4e1 * t288 * t81 * t4375 + 0.24e2 * t1026 * t1098 * t499 - 0.24e2 * t1485 * t3071 * t499;
  t4439 = -0.12e2 * t1087 * t613 * t118 * t141 - 0.36e2 * t2541 * t617 * t118 * t141 + 0.12e2 * t245 * t1626 * t118 + 0.12e2 * t245 * t1647 * t118 - 0.6e1 * t250 * t193 * t1209 - 0.6e1 * t250 * t1212 * t206 - 0.12e2 * t250 * t1215 * t206 + 0.12e2 * t245 * t193 * t1236 - 0.6e1 * t250 * t1237 * t206 - 0.12e2 * t678 * t1597 * t141 - 0.6e1 * t250 * t1626 * t141 - 0.6e1 * t250 * t1647 * t141 + 0.6e1 * t245 * t614 * t282 - 0.3e1 * t250 * t614 * t329 - 0.12e2 * t250 * t448 * t499 - 0.12e2 * t250 * t467 * t499 - 0.6e1 * t678 * t598 * t329;
  t4487 = 0.12e2 * t694 * t1656 * t118 - 0.6e1 * t250 * t1668 * t118 - 0.6e1 * t250 * t1706 * t118 + 0.4e1 * t288 * t207 * t1209 - 0.12e2 * t657 * t1656 * t141 + 0.4e1 * t288 * t1668 * t141 + 0.4e1 * t288 * t1706 * t141 + 0.48e2 * t2568 * t1603 * t2368 + 0.24e2 * t245 * t448 * t466 - 0.3e1 * t250 * t636 * t282 + 0.6e1 * t694 * t618 * t282 + 0.2e1 * t288 * t636 * t329 + 0.8e1 * t288 * t476 * t499 - 0.6e1 * t657 * t618 * t329 + 0.24e2 * t1317 * t1600 - 0.12e2 * t3576 * t1594;
  t4526 = t4284 * t127;
  t4542 = -0.208e4 / 0.9e1 * t524 + 0.896e4 / 0.9e1 * t1540 - 0.16e4 / 0.3e1 * t4526 * t3504 + 0.64e2 * t4343 + 0.128e4 * t4345 - 0.128e4 / 0.3e1 * t1501 + 0.128e5 / 0.3e1 * t4304 - 0.1792e5 / 0.3e1 * t1504 + 0.832e4 / 0.9e1 * t534 - 0.96e2 * t4347 - 0.256e4 * t4306 + 0.64e3 * t1508 - 0.96e2 * t4300 - 0.16e5 / 0.3e1 * t4302 + 0.1792e5 / 0.3e1 * t1510 - 0.208e4 / 0.3e1 * t514;
  t4554 = -0.12e2 * t2856 * t601 - 0.6e1 * t657 * t636 * t289 + 0.12e2 * t2360 * t598 * t289 - 0.6e1 * t678 * t636 * t246 + 0.24e2 * t2108 * t618 * t289 + 0.6e1 * t694 * t614 * t289 + 0.12e2 * t2360 * t618 * t246 - 0.36e2 * t2541 * t1603 * t289 + 0.6e1 * t3484 * t598 + 0.12e2 * t1317 * t1597 + 0.6e1 * t245 * t340 * t597 + 0.3e1 * t106 * t340 * t613 + 0.6e1 * t106 * t150 * t1646 + 0.3e1 * t106 * t81 * t4542 + 0.2e1 * t288 * t340 * t617 - t124 * t340 * t635 - 0.2e1 * t124 * t150 * t1705;
  t4561 = my_piecewise3(t3, 0, t7 * t216 * t638 / 0.12e2 - t7 * t89 * t1709 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4385 + t4439 + t4487 + t4554));
  tv4rho2tau20 = 0.2e1 * rho[0] * t4561 + 0.4e1 * t1714;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t4577 = t276 * t540;
  t4594 = t276 * t527;
  t4609 = -0.72e2 * t913 * t1348 * t1261 * t112 + 0.36e2 * t2447 * t366 * t1739 * t118 - 0.18e2 * t913 * t366 * t1775 * t118 + 0.72e2 * t3528 * t1348 * t1261 * t141 - 0.54e2 * t2805 * t366 * t1739 * t141 + 0.18e2 * t870 * t366 * t1775 * t141 + 0.36e2 * t870 * t366 * t517 * t417 - 0.6e2 * t371 * t384 * t4577 * tau[0] + 0.12e3 * t870 * t384 * t4594 * tau[0] - 0.12e3 * t1368 * t1263 - 0.36e2 * t3329 * t1267;
  t4645 = 0.18e2 * t694 * t1744 * t118 - 0.9e1 * t250 * t1747 * t118 - 0.9e1 * t250 * t1750 * t118 - 0.3e1 * t250 * t1758 * t118 + 0.6e1 * t288 * t176 * t1405 - 0.18e2 * t657 * t1744 * t141 + 0.6e1 * t288 * t1747 * t141 + 0.6e1 * t288 * t1750 * t141 + 0.2e1 * t288 * t1758 * t141 + 0.12e2 * t288 * t531 * t417 + 0.6e1 * t288 * t418 * t540 + 0.36e2 * t3520 * t1258;
  t4648 = 0.25e3 / 0.1594323e7 * t667 * t1287;
  t4670 = t669 / t31 / t673;
  t4672 = t26 * t29;
  t4679 = 0.125e4 / 0.1162261467e10 * t2088 * t4670 * t4672;
  t4689 = -t4648 + 0.24e2 * t769 * t1728 * t150 - 0.18e2 * t2113 * t1733 * t118 + 0.24e2 * t2108 * t1733 * t141 - 0.18e2 * t657 * t528 * t417 + 0.6e1 * t288 * t398 * t540 - 0.192e3 * t769 * t1286 * t74 * t81 + t75 * (0.125e4 / 0.1162261467e10 * t2058 * t4670 * t4672 - 0.25e3 / 0.1594323e7 * t700 * t1287 - t4679 + t4648) + 0.72e2 * t513 * t747 * t1286 + 0.12e2 * t521 * t1306 + 0.9e1 / 0.4e1 * t3474 * t1764;
  t4694 = t175 * tau[0];
  t4709 = t250 * t180;
  t4713 = t74 * t81;
  t4727 = 0.9e1 / 0.4e1 * t1338 * t403 * t54 * t417 + 0.15e2 * t1338 * t1311 * t4694 + 0.9e1 * t106 * t1298 * t166 + 0.9e1 * t1767 * t380 + 0.9e1 * t1087 * t747 * t737 * t141 - 0.9e1 / 0.2e1 * t1760 * t1335 + 0.9e1 / 0.4e1 * t4709 * t1340 + 0.24e3 * t2175 * t2178 * t4713 * t42 + 0.36e2 * t1317 * t180 * t514 + 0.36e2 * t245 * t429 * t514 + 0.48e3 * t1760 * t1325 - 0.192e3 * t1760 * t1343;
  t4735 = t545 * t47;
  t4761 = 0.24e2 * t371 * t366 * t101 * t540 - 0.48e2 * t870 * t366 * t101 * t527 - 0.12e2 * t1338 * t947 * t1763 + 0.192e3 * t1347 * t1348 * t3315 + 0.18e2 * t245 * t4735 * t368 - 0.9e1 * t250 * t4735 * t373 - 0.18e2 * t1368 * t1360 + 0.48e2 * t1368 * t1375 - 0.24e2 * t1767 * t389 - 0.18e2 * t3555 * t518 - 0.18e2 * t3565 * t518;
  t4778 = t678 * t180 * t48;
  t4793 = -0.9e1 * t901 * t1776 - 0.9e1 * t905 * t1776 - 0.9e1 * t371 * t366 * t33 * t1405 - 0.6e2 * t365 * t2769 * t42 + 0.18e2 * t2818 * t1740 + 0.18e2 * t2821 * t1740 - 0.36e2 * t4778 * t1349 + 0.72e2 * t1365 * t1352 + 0.9e1 / 0.2e1 * t3572 * t1862 * t1027 - 0.9e1 / 0.2e1 * t694 * t3571 * t1862 * t3342 + t4679 + 0.6e2 * t106 * t4735 * t386;
  t4813 = t769 * t737;
  t4814 = t123 * t81;
  t4818 = t175 * t540;
  t4827 = -0.36e2 * t3577 * t1770 - 0.36e2 * t3610 * t1770 - 0.36e2 * t1347 * t1348 * t3324 - 0.48e3 * t1347 * t3542 * t4694 - 0.9e1 / 0.4e1 * t1329 * t524 - 0.15e2 * t521 * t1312 + 0.72e2 * t2189 * t737 * t4713 * t112 - 0.24e2 * t4813 * t4814 * t141 + 0.18e2 * t1026 * t4818 * t118 - 0.18e2 * t1485 * t4818 * t141 - 0.9e1 * t1318 * t1717;
  t4874 = -0.9e1 * t1321 * t1717 - 0.9e1 * t513 * t2724 * t737 + 0.3e1 * t106 * t1726 * t118 - t124 * t1726 * t141 - 0.6e1 * t657 * t150 * t1732 + 0.6e1 * t288 * t429 * t527 - 0.3e1 * t124 * t1298 * t175 - 0.3e1 * t124 * t545 * t417 - 0.3e1 * t124 * t429 * t540 - 0.3e1 * t124 * t180 * t1405 - t124 * t150 * t1757 - t124 * t81 * (0.3e1 * t3731 - 0.15e2 / 0.8e1 * t3503 * t42 - 0.18e3 * t2230 * t1754 * t112 - 0.6e3 * t2213 * t2178 * tau[0] * t28 + 0.48e3 * t725 * t70 * t1286);
  t4882 = my_piecewise3(t3, 0, -t7 * t89 * t1779 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4609 + t4645 + t4689 + t4727 + t4761 + t4793 + t4827 + t4874));
  tv4rhosigma30 = 0.2e1 * rho[0] * t4882 + 0.2e1 * t1783;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t4895 = t4208 * t42;
  t4900 = t2921 * tau[0] * t28;
  t4917 = -0.288e4 * t725 * t1515 * t112 + 0.144e4 * t2230 * t1836 * t112 - 0.9e1 * t2724 * t1149 + 0.504e4 * t310 * t1398 - 0.84e4 * t2204 * t4900 + 0.48e4 * t2213 * t4900 - 0.6e2 * t2260 * t4900 - 0.21e2 * t1311 + 0.63e2 * t1717 - 0.336e4 * t1755 + 0.15e2 * t4895;
  t4938 = t192 * t540;
  t4955 = 0.6e1 * t106 * t429 * t566 + 0.6e1 * t106 * t180 * t1545 - t124 * t81 * t4917 + 0.3e1 * t106 * t1298 * t192 + 0.3e1 * t106 * t545 * t466 - 0.2e1 * t124 * t180 * t1528 - t124 * t150 * t1841 - 0.2e1 * t124 * t429 * t588 - t124 * t1298 * t206 - t124 * t545 * t499 + 0.6e1 * t1026 * t4938 * t141 + 0.6e1 * t513 * t1539 * t118 - 0.3e1 * t1338 * t1539 * t141 + 0.12e2 * t3667 * t1498 - 0.12e2 * t1485 * t1486 * t417 - 0.12e2 * t4098 * t1492;
  t4958 = t566 * t175;
  t4968 = t206 * t527;
  t5005 = 0.12e2 * t1026 * t4958 * t141 - 0.6e1 * t1087 * t4938 * t118 - 0.12e2 * t1087 * t4958 * t118 - 0.6e1 * t250 * t1830 * t118 - 0.3e1 * t250 * t1842 * t118 - 0.18e2 * t2541 * t4968 * t118 - 0.36e2 * t2113 * t3833 * t1258 + 0.24e2 * t2360 * t3837 * t1258 + 0.4e1 * t288 * t1830 * t141 + 0.2e1 * t288 * t1842 * t141 + 0.24e2 * t3877 * t4968 * t141 - 0.6e1 * t657 * t476 * t527 - 0.6e1 * t657 * t500 * t527 + 0.8e2 * t3834 * t1263 - 0.8e2 * t3838 * t1263 + 0.24e2 * t3841 * t1267 + 0.12e2 * t3667 * t1495;
  t5047 = t62 * tau[0];
  t5061 = -0.3e1 * t250 * t1828 * t118 + 0.2e1 * t288 * t1828 * t141 + 0.2e1 * t288 * t207 * t1405 + 0.6e1 * t694 * t448 * t527 + 0.6e1 * t694 * t467 * t527 + 0.2e1 * t288 * t500 * t540 + 0.15e2 * t164 * t4895 + 0.12e2 * t1856 * t1857 * t448 + 0.12e2 * t1856 * t1857 * t467 + 0.16e3 * t754 * t737 * t4713 * t192 * tau[0] - 0.3e1 / 0.2e1 * t1318 * t1863 - 0.3e1 / 0.2e1 * t1321 * t1863 - 0.3e1 / 0.2e1 * t513 * t466 * t27 * t1862 - 0.1e2 * t513 * t192 * t737 * t5047 + 0.3e1 / 0.4e1 * t3474 * t1867 + 0.3e1 / 0.4e1 * t1338 * t499 * t27 * t1862 + 0.5e1 * t1338 * t206 * t737 * t5047;
  t5065 = t192 * t527;
  t5094 = t356 * t54;
  t5117 = 0.12e2 * t1026 * t1491 * t417 - 0.18e2 * t2541 * t5065 * t141 + 0.4e1 * t288 * t589 * t417 + 0.2e1 * t288 * t476 * t540 + 0.4e1 * t288 * t1529 * t175 + 0.4e1 * t288 * t1549 * t175 + 0.4e1 * t288 * t1531 * t175 + 0.4e1 * t288 * t576 * t417 + 0.4e1 * t288 * t1533 * t175 - 0.64e2 * t1856 * t356 * t74 * t193 + 0.8e1 * t513 * t1861 * t5094 - 0.4e1 * t1338 * t1866 * t5094 + 0.3e1 * t106 * t150 * t1149 * t62 - 0.6e1 * t250 * t567 * t417 - 0.3e1 * t250 * t448 * t540 - 0.3e1 * t250 * t467 * t540 - 0.3e1 * t250 * t193 * t1405;
  t5165 = 0.12e2 * t1317 * t559 * t166 + 0.12e2 * t1317 * t567 * t166 - 0.6e1 * t250 * t1531 * t166 + 0.12e2 * t245 * t1535 * t166 - 0.6e1 * t250 * t1535 * t175 + 0.12e2 * t245 * t1546 * t166 - 0.6e1 * t250 * t1546 * t175 - 0.6e1 * t250 * t1549 * t166 + 0.12e2 * t245 * t1551 * t166 - 0.6e1 * t250 * t1551 * t175 + 0.12e2 * t245 * t1554 * t166 - 0.6e1 * t250 * t1554 * t175 - 0.6e1 * t250 * t559 * t417 + 0.12e2 * t1813 * t380 + 0.12e2 * t1816 * t380 - 0.6e1 * t1819 * t380;
  t5207 = -0.6e1 * t250 * t1533 * t166 - 0.6e1 * t250 * t1529 * t166 - 0.6e1 * t1823 * t380 - 0.12e2 * t514 * t4814 * t3103 + 0.3e1 / 0.2e1 * t1426 * t1340 + 0.3e1 / 0.2e1 * t1433 * t1335 - 0.3e1 / 0.2e1 * t1438 * t1340 + 0.64e2 * t1433 * t1343 - 0.32e2 * t1813 * t389 - 0.32e2 * t1816 * t389 + 0.16e2 * t1819 * t389 + 0.16e2 * t1823 * t389 - 0.12e2 * t3576 * t207 * t514 - 0.12e2 * t3775 * t514 - 0.12e2 * t3778 * t514 - 0.16e3 * t1433 * t1325 + 0.24e2 * t747 * t403 * t4713 * t192 * t112;
  t5229 = t379 * t1850;
  t5233 = t107 * t165 * t417;
  t5236 = t678 * t559;
  t5241 = t678 * t567;
  t5246 = t678 * t576;
  t5249 = t694 * t576;
  t5254 = t678 * t589;
  t5257 = -0.21e2 * t106 * t81 * t737 * t62 + 0.6e1 * t245 * t1844 * t118 + 0.12e2 * t245 * t1847 * t118 - 0.3e1 * t250 * t1844 * t141 - 0.6e1 * t250 * t1847 * t141 + 0.8e2 * t1813 * t1226 + 0.8e2 * t1816 * t1226 - 0.4e2 * t1819 * t1226 - 0.12e2 * t1426 * t5229 - 0.12e2 * t1426 * t5233 - 0.12e2 * t5236 * t1428 - 0.12e2 * t5241 * t1428 + 0.12e2 * t5249 * t1428 - 0.12e2 * t5246 * t1435 - 0.12e2 * t5254 * t1435 - 0.12e2 * t3813 * t1851 - 0.12e2 * t3816 * t1851;
  t5258 = t694 * t589;
  t5263 = t2360 * t207;
  t5270 = t206 * t540;
  t5283 = t588 * t175;
  t5291 = t107 * t102 * t175;
  t5306 = 0.24e2 * t5263 * t271 * t403 * t141 + 0.6e1 * t1026 * t5270 * t118 + 0.12e2 * t1026 * t5283 * t118 + 0.12e2 * t2568 * t5065 * t118 - 0.6e1 * t1485 * t5270 * t141 - 0.12e2 * t1485 * t5283 * t141 - 0.12e2 * t657 * t180 * t1487 - 0.4e2 * t1823 * t1226 + 0.32e2 * t1426 * t5291 + 0.12e2 * t5258 * t1428 - 0.24e2 * t1433 * t4133 + 0.12e2 * t1438 * t5229 + 0.12e2 * t1438 * t5233 - 0.32e2 * t1438 * t5291 + 0.12e2 * t3788 * t1851 + 0.12e2 * t3791 * t1851 - 0.12e2 * t3810 * t1851;
  t5314 = my_piecewise3(t3, 0, -t7 * t89 * t1871 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4955 + t5005 + t5061 + t5117 + t5165 + t5207 + t5257 + t5306));
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t5314 + 0.2e1 * t1875;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t5323 = t2360 * t601;
  t5326 = t635 * t175;
  t5336 = t206 * t588;
  t5343 = t613 * t175;
  t5347 = t617 * t175;
  t5356 = t566 * t206;
  t5363 = 0.6e1 * t1026 * t5326 * t118 + 0.12e2 * t1026 * t5336 * t118 + 0.6e1 * t1026 * t5343 * t141 + 0.12e2 * t1026 * t5356 * t141 - 0.12e2 * t1087 * t5356 * t118 - 0.18e2 * t2541 * t5347 * t118 - 0.8e2 * t678 * t601 * t1226 - 0.6e1 * t1485 * t5326 * t141 - 0.12e2 * t1485 * t5336 * t141 + 0.24e2 * t3877 * t5347 * t141 - 0.12e2 * t1485 * t1486 * t499 + 0.24e2 * t5323 * t1428 + 0.12e2 * t3667 * t1607;
  t5364 = t192 * t588;
  t5375 = t4526 * t42;
  t5377 = t2724 * t1630;
  t5380 = t4284 * tau[0] * t28;
  t5381 = t2260 * t5380;
  t5409 = 0.4608e5 * t725 * t1684 * t112 - 0.4032e5 * t310 * t1691 * t112 - 0.1152e5 * t2230 * t1949 * t112 + 0.864e3 * t754 * t1149 + 0.48384e5 * t132 * t1168 - 0.12e4 * t2189 * t5380 + 0.1344e6 * t2204 * t5380 - 0.384e5 * t2213 * t5380 - 0.10752e6 * t2244 * t5380 - 0.288e3 * t2260 * t4279 + 0.144e3 * t1539 - 0.864e3 * t1834 + 0.2304e5 * t1837 - 0.6912e5 * t1839 - 0.12e3 * t5375 + 0.144e3 * t5377 + 0.96e3 * t5381;
  t5445 = -0.12e2 * t1087 * t5364 * t118 + 0.12e2 * t1026 * t5364 * t141 - 0.6e1 * t1087 * t5343 * t118 - t124 * t81 * t5409 - 0.3e1 * t250 * t1647 * t175 - t124 * t180 * t1705 - t124 * t150 * t1956 + 0.3e1 * t106 * t81 * (0.96e2 * t1539 - 0.8e2 * t5375 + 0.24e2 * t5377 + 0.16e3 * t5381 - 0.144e3 * t1834) + 0.2e1 * t288 * t429 * t617 - t124 * t429 * t635 + 0.6e1 * t245 * t429 * t597 + 0.3e1 * t106 * t429 * t613 + 0.3e1 * t106 * t180 * t1646 + 0.3e1 * t106 * t150 * t1921;
  t5485 = 0.12e2 * t166 * t4713 * t192 * t466 + 0.4e2 * t534 * t4713 * t597 * tau[0] + 0.6e1 * t1317 * t614 * t166 + 0.6e1 * t245 * t1626 * t166 + 0.6e1 * t245 * t1647 * t166 + 0.6e1 * t694 * t1656 * t166 - 0.3e1 * t250 * t1668 * t166 - 0.3e1 * t250 * t1706 * t166 + 0.6e1 * t1317 * t1885 + 0.6e1 * t1908 * t380 - 0.16e2 * t1908 * t389 + 0.6e1 * t1925 * t380 - 0.16e2 * t1925 * t389 + 0.8e1 * t1937 * t389;
  t5528 = -0.6e1 * t166 * t4814 * t597 * t141 - 0.6e1 * t250 * t193 * t1528 - 0.6e1 * t250 * t1535 * t206 - 0.6e1 * t250 * t1546 * t206 - 0.6e1 * t250 * t1551 * t206 - 0.6e1 * t250 * t1554 * t206 - 0.3e1 * t250 * t1626 * t175 + 0.12e2 * t245 * t448 * t566 + 0.12e2 * t245 * t467 * t566 - 0.6e1 * t250 * t448 * t588 - 0.6e1 * t250 * t467 * t588 - 0.6e1 * t250 * t559 * t499 - 0.6e1 * t250 * t567 * t499 - 0.3e1 * t1937 * t380;
  t5558 = t192 * t566;
  t5567 = 0.12e2 * t1026 * t1603 * t417 + 0.12e2 * t1026 * t4257 * t175 + 0.12e2 * t1026 * t4261 * t175 - 0.12e2 * t1087 * t5558 * t141 - 0.6e1 * t678 * t1885 * t141 + 0.12e2 * t245 * t193 * t1545 - 0.6e1 * t678 * t1597 * t175 + 0.12e2 * t245 * t559 * t466 - 0.6e1 * t678 * t598 * t417 + 0.12e2 * t1317 * t1888 - 0.12e2 * t4098 * t1604 - 0.6e1 * t3576 * t1882 + 0.12e2 * t2557 * t1896;
  t5568 = t597 * t175;
  t5611 = -0.12e2 * t1087 * t1491 * t466 + 0.6e1 * t694 * t1931 * t118 - 0.3e1 * t250 * t1943 * t118 - 0.3e1 * t250 * t1957 * t118 - 0.6e1 * t657 * t1931 * t141 + 0.2e1 * t288 * t1943 * t141 + 0.2e1 * t288 * t1957 * t141 + 0.12e2 * t2568 * t5568 * t141 + 0.4e1 * t288 * t207 * t1528 + 0.2e1 * t288 * t1668 * t175 + 0.2e1 * t288 * t1706 * t175 + 0.2e1 * t288 * t636 * t417 + 0.4e1 * t288 * t476 * t588 + 0.4e1 * t288 * t500 * t588;
  t5655 = 0.4e1 * t288 * t576 * t499 - 0.3e1 * t250 * t1922 * t141 - 0.6e1 * t657 * t1656 * t175 - 0.6e1 * t657 * t618 * t417 - 0.3e1 * t250 * t614 * t417 + 0.6e1 * t245 * t1915 * t118 - 0.3e1 * t250 * t1915 * t141 + 0.6e1 * t245 * t1922 * t118 + 0.6e1 * t379 * t28 * t1879 + 0.6e1 * t1877 * t1878 * t1597 + 0.24e2 * t2568 * t1603 * t1027 - 0.36e2 * t2541 * t1603 * t3342 - 0.16e2 * t1877 * t101 * t74 * t598 - 0.12e2 * t3810 * t1893;
  t5661 = t499 * t47 * t1892;
  t5668 = t678 * t614;
  t5673 = t2360 * t618;
  t5676 = t2113 * t618;
  t5683 = t678 * t636;
  t5686 = t694 * t636;
  t5695 = 0.32e2 * t1426 * t1891 * t366 * t101 - 0.12e2 * t1426 * t206 * t112 * t1892 + 0.4e2 * t1908 * t1226 + 0.4e2 * t1925 * t1226 - 0.2e2 * t1937 * t1226 - 0.12e2 * t1426 * t5661 - 0.6e1 * t5668 * t1428 - 0.18e2 * t5676 * t1428 + 0.6e1 * t5686 * t1428 + 0.12e2 * t5673 * t1435 - 0.6e1 * t5683 * t1435 + 0.12e2 * t1438 * t5661 - 0.12e2 * t3813 * t1893 - 0.12e2 * t3816 * t1893;
  t5703 = my_piecewise3(t3, 0, -t7 * t89 * t1960 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t5363 + t5445 + t5485 + t5528 + t5567 + t5611 + t5655 + t5695));
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t5703 + 0.2e1 * t1964;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t5741 = 0.6e1 * t245 * t1993 * t118 - 0.18e2 * t2113 * t1997 * t118 - 0.3e1 * t250 * t1993 * t141 + 0.24e2 * t2108 * t1997 * t141 + 0.18e2 * t245 * t193 * t1646 - 0.9e1 * t250 * t193 * t1705 + 0.18e2 * t245 * t467 * t613 - 0.9e1 * t250 * t467 * t635 + 0.6e1 * t288 * t476 * t635 - 0.18e2 * t657 * t618 * t499 + 0.6e1 * t1967 * t150;
  t5773 = -0.3e1 * t250 * t2020 * t118 + 0.2e1 * t288 * t2020 * t141 - 0.18e2 * t678 * t1597 * t206 + 0.6e1 * t288 * t207 * t1705 + 0.18e2 * t245 * t448 * t613 + 0.6e1 * t288 * t500 * t635 + 0.18e2 * t694 * t448 * t617 + 0.18e2 * t694 * t467 * t617 - 0.18e2 * t678 * t598 * t499 + 0.18e2 * t1317 * t1973 - 0.18e2 * t3576 * t1970;
  t5787 = t206 * t635;
  t5791 = t192 * t635;
  t5801 = t613 * t206;
  t5811 = 0.18e2 * t1026 * t5787 * t118 + 0.18e2 * t1026 * t5791 * t141 + 0.18e2 * t1026 * t5801 * t141 + 0.36e2 * t1026 * t1603 * t499 - 0.18e2 * t1087 * t5791 * t118 - 0.18e2 * t1087 * t5801 * t118 - 0.18e2 * t1485 * t5787 * t141 - 0.9e1 * t250 * t1626 * t206 - 0.9e1 * t250 * t1647 * t206 - 0.9e1 * t250 * t448 * t635 - 0.9e1 * t250 * t614 * t499;
  t5812 = t192 * t613;
  t5816 = t192 * t617;
  t5823 = t597 * t206;
  t5830 = 0.96e3 * t1631;
  t5832 = 0.1e1 / t31 / t232;
  t5835 = 0.96e3 * t5832 * t127 * t42;
  t5836 = t2724 * t1985;
  t5839 = t5832 * tau[0] * t28;
  t5840 = t2260 * t5839;
  t5843 = t1985 * t112;
  t5844 = t2260 * t5843;
  t5846 = t2189 * t5839;
  t5855 = 0.96e4 * t769 * t1630 - 0.192e5 * t2175 * t5839 - 0.576e4 * t2189 * t5843 + 0.864e4 * t1919 - 0.1728e5 * t1947 - t5830 + t5835 - 0.1728e4 * t5836 - 0.1152e5 * t5840 + 0.6912e4 * t5844 + 0.288e5 * t5846;
  t5881 = -0.516096e6 * t132 * t2016 * t112 + 0.9216e5 * t2230 * t2007 * t112 - 0.55296e6 * t725 * t2010 * t112 + 0.96768e6 * t310 * t2013 * t112 + 0.43008e6 * t67 * t1698 - 0.16128e7 * t2204 * t5839 + 0.3072e6 * t2213 * t5839 + 0.258048e7 * t2244 * t5839 - 0.129024e7 * t2249 * t5839 - 0.1536e6 * t1950 + 0.6912e6 * t1952 - 0.96768e6 * t1954;
  t5890 = t1966 * t123;
  t5906 = t597 * t74;
  t5909 = -0.18e2 * t1087 * t5812 * t141 + 0.36e2 * t2568 * t5816 * t118 - 0.54e2 * t2541 * t5816 * t141 + 0.36e2 * t2568 * t5823 * t141 - 0.36e2 * t1087 * t1603 * t466 - t124 * t81 * (t5855 + t5881) - 0.6e1 * t657 * t150 * t1996 - t124 * t150 * t2019 - 0.6e1 * t5890 * t142 + 0.3e1 * t106 * t150 * t1992 + 0.3e1 * t106 * t81 * (-t5830 + t5835 - 0.576e3 * t5836 - 0.384e4 * t5840 + 0.288e4 * t1919 + 0.768e3 * t5844 + 0.32e4 * t5846 - 0.192e4 * t1947) + 0.18e2 * t5906 * t467;
  t5916 = my_piecewise3(t3, 0, -t7 * t89 * t2022 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t5741 + t5773 + t5811 + t5909));
  tv4rhotau30 = 0.2e1 * rho[0] * t5916 + 0.2e1 * t2026;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t5936 = t2178 * t28;
  t5971 = -0.36e2 * t657 * t528 * t540 + 0.24e2 * t288 * t531 * t540 + 0.8e1 * t288 * t176 * t1757 + 0.96e2 * t769 * t1728 * t180 - 0.12e2 * t250 * t1758 * t166 - 0.45e2 / 0.2e1 * t124 * t81 * params->b * t2189 * t5936 - 0.144e3 * t4778 * t1770 - 0.18e2 * t2189 * t28 * t2178 * t74 * t81 - 0.36e2 * t1760 * t1717 + 0.9e1 / 0.8e1 * t513 * t5936 * t127 - 0.9e1 / 0.2e1 * t1767 * t524 - 0.96e2 * t4813 * t4814 * t175 - 0.72e2 * t1347 * t1348 * t4577 - 0.72e2 * t2113 * t1733 * t166 + 0.72e2 * t3520 * t1740 + 0.144e3 * t3528 * t1348 * t4594 - 0.36e2 * t250 * t1747 * t166;
  t5997 = t2178 * t21 * t160;
  t5998 = t2088 * t669 * t5997;
  t6015 = t540 * t540;
  t6019 = t527 * t527;
  t6030 = t540 * t47 * t1892;
  t6033 = -0.36e2 * t250 * t1750 * t166 + 0.72e2 * t245 * t545 * t514 + 0.9e1 / 0.2e1 * t1338 * t403 * t54 * t540 + 0.36e2 * t1087 * t747 * t737 * t175 + 0.9e1 * t4709 * t1764 + 0.12e2 * t106 * t1726 * t166 - 0.9e1 * t1026 * t403 * t54 * t527 - 0.625e3 / 0.1549681956e10 * t5998 - 0.4e1 * t124 * t1726 * t175 - 0.24e2 * t657 * t180 * t1732 + 0.12e2 * t288 * t545 * t527 - 0.6e1 * t124 * t545 * t540 - 0.4e1 * t124 * t180 * t1757 + 0.6e1 * t288 * t81 * t6015 + 0.24e2 * t2108 * t81 * t6019 + t75 * (-0.625e3 / 0.1549681956e10 * t2058 * t669 * t5997 + 0.625e3 / 0.1549681956e10 * t5998) + 0.72e2 * t694 * t176 * t6030;
  t6038 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t5971 + t6033));
  tv4sigma40 = 0.2e1 * rho[0] * t6038;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t6083 = 0.9e1 * t106 * t180 * t1149 * t62 - 0.18e2 * t2113 * t193 * t1732 + 0.24e2 * t2108 * t207 * t1732 + 0.6e1 * t288 * t1828 * t175 + 0.12e2 * t288 * t1830 * t175 - 0.9e1 * t250 * t1844 * t175 - 0.18e2 * t250 * t1847 * t175 - 0.3e1 * t250 * t193 * t1757 - 0.9e1 * t250 * t559 * t540 - 0.9e1 * t250 * t567 * t540 + 0.18e2 * t694 * t559 * t527 + 0.18e2 * t694 * t567 * t527 - 0.18e2 * t657 * t576 * t527 - 0.18e2 * t657 * t589 * t527;
  t6122 = 0.6e1 * t288 * t576 * t540 + 0.18e2 * t1026 * t4938 * t175 - 0.18e2 * t1485 * t5270 * t175 - 0.36e2 * t5246 * t514 - 0.9e1 * t250 * t1842 * t166 - 0.36e2 * t5254 * t514 - 0.9e1 / 0.2e1 * t1438 * t1764 - 0.36e2 * t514 * t4814 * t1491 + 0.9e1 / 0.2e1 * t1426 * t1764 + 0.18e2 * t245 * t1844 * t166 + 0.36e2 * t245 * t1847 * t166 - 0.9e1 * t250 * t1828 * t166 - 0.18e2 * t250 * t1830 * t166 - 0.24e2 * t4813 * t4814 * t206;
  t6178 = -0.9e1 * t1717 * t4713 * t192 - 0.9e1 * t1338 * t1539 * t175 - 0.9e1 / 0.2e1 * t1760 * t1863 + 0.36e2 * t1856 * t1857 * t567 - 0.9e1 / 0.2e1 * t513 * t566 * t27 * t1862 + 0.9e1 / 0.4e1 * t4709 * t1867 + 0.9e1 / 0.4e1 * t1338 * t588 * t27 * t1862 + 0.9e1 * t1087 * t1891 * t2760 + 0.18e2 * t513 * t2921 * t304 * t47 * t28 - 0.3e1 * t124 * t180 * t1841 - t124 * t81 * (0.9e1 / 0.8e1 * t28 * t2921 * t127 - 0.18e3 * t2230 * t70 * t2921 * t28 + 0.36e3 * t725 * t137 * t2921 * t28) + 0.3e1 * t106 * t1726 * t192 + 0.9e1 * t106 * t545 * t566 - t124 * t1726 * t206;
  t6193 = t527 * t47 * t1892;
  t6216 = 0.72e2 * t5263 * t271 * t403 * t175 - 0.3e1 * t124 * t545 * t588 + 0.6e1 * t288 * t1842 * t175 + 0.2e1 * t288 * t207 * t1757 + 0.36e2 * t1856 * t1857 * t559 + 0.6e1 * t288 * t589 * t540 - 0.18e2 * t1426 * t6030 + 0.18e2 * t1438 * t6030 - 0.36e2 * t5236 * t1851 - 0.36e2 * t5241 * t1851 + 0.36e2 * t5249 * t1851 + 0.36e2 * t5258 * t1851 - 0.54e2 * t3757 * t6193 + 0.36e2 * t3766 * t6193;
  t6222 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6083 + t6122 + t6178 + t6216));
  tv4sigma3tau0 = 0.2e1 * rho[0] * t6222;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t6227 = t28 * t4284;
  t6228 = t6227 * t127;
  t6268 = t588 * t588;
  t6286 = -0.24e2 * t1485 * t1486 * t588 - 0.9e1 * t164 * t6228 + 0.48e2 * t5323 * t1851 + 0.3e1 * t106 * t545 * t613 + 0.6e1 * t106 * t180 * t1921 + 0.2e1 * t288 * t545 * t617 - t124 * t545 * t635 - 0.2e1 * t124 * t180 * t1956 - t124 * t81 * (-0.576e4 * t725 * t137 * t4284 * t28 + 0.144e4 * t2230 * t70 * t4284 * t28 + 0.504e4 * t310 * t323 * t4284 * t28 + 0.36e2 * t2260 * t6227 - 0.18e2 * t6228) + 0.6e1 * t245 * t545 * t597 + 0.4e1 * t288 * t81 * t6268 - 0.12e2 * t166 * t4814 * t5568 + 0.24e2 * t166 * t4713 * t5558 - 0.24e2 * t514 * t4814 * t1603 + 0.3e1 * t1426 * t1867 + 0.12e2 * t245 * t1915 * t166;
  t6303 = t566 * t566;
  t6340 = 0.12e2 * t245 * t1922 * t166 + 0.12e2 * t694 * t1931 * t166 + 0.24e2 * t5673 * t514 - 0.6e1 * t250 * t1943 * t166 - 0.6e1 * t250 * t1957 * t166 - 0.12e2 * t5683 * t514 + 0.12e2 * t245 * t81 * t6303 + 0.12e2 * t2360 * t598 * t527 + 0.12e2 * t1877 * t1878 * t1885 + 0.12e2 * t1856 * t1857 * t614 - 0.3e1 / 0.2e1 * t513 * t613 * t27 * t1862 - 0.3e1 / 0.2e1 * t1026 * t617 * t27 * t1862 + 0.3e1 / 0.4e1 * t1338 * t635 * t27 * t1862 + 0.4e1 * t288 * t207 * t1841 - 0.6e1 * t657 * t618 * t540 + 0.8e1 * t288 * t576 * t588 - 0.6e1 * t250 * t1915 * t175;
  t6367 = t107 * t165 * t588;
  t6385 = -0.12e2 * t678 * t1885 * t175 - 0.6e1 * t250 * t1922 * t175 - 0.12e2 * t657 * t1931 * t175 - 0.6e1 * t250 * t193 * t1841 - 0.6e1 * t250 * t1844 * t206 - 0.12e2 * t250 * t1847 * t206 - 0.3e1 * t250 * t614 * t540 - 0.12e2 * t250 * t559 * t588 - 0.12e2 * t250 * t567 * t588 - 0.24e2 * t1426 * t6367 + 0.24e2 * t1438 * t6367 - 0.12e2 * t5668 * t1851 - 0.36e2 * t5676 * t1851 + 0.12e2 * t5686 * t1851 - 0.24e2 * t5236 * t1893 - 0.24e2 * t5241 * t1893;
  t6437 = -0.6e1 * t678 * t598 * t540 + 0.24e2 * t245 * t559 * t566 + 0.4e1 * t288 * t1943 * t175 + 0.4e1 * t288 * t1957 * t175 + 0.2e1 * t288 * t636 * t540 - 0.6e1 * t657 * t636 * t527 + 0.6e1 * t694 * t614 * t527 + 0.24e2 * t2108 * t618 * t527 - 0.36e2 * t2541 * t1603 * t527 + 0.24e2 * t3667 * t1896 + 0.24e2 * t1026 * t5356 * t175 + 0.24e2 * t1026 * t5364 * t175 + 0.12e2 * t1026 * t1603 * t540 - 0.6e1 * t1338 * t1539 * t206 - 0.3e1 / 0.2e1 * t524 * t4713 * t597 - 0.24e2 * t1087 * t1491 * t566 + 0.12e2 * t513 * t192 * t1149 * t62;
  t6443 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6286 + t6340 + t6385 + t6437));
  tv4sigma2tau20 = 0.2e1 * rho[0] * t6443;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t6447 = t28 * t5832;
  t6448 = t6447 * t127;
  t6450 = t2260 * t6447;
  t6500 = -t124 * t180 * t2019 - t124 * t81 * (0.64512e5 * t132 * t734 * t5832 * t28 + 0.6912e5 * t725 * t137 * t5832 * t28 - 0.1152e5 * t2230 * t70 * t5832 * t28 - 0.12096e6 * t310 * t323 * t5832 * t28 + 0.72e3 * t2189 * t6447 + 0.216e3 * t6448 - 0.864e3 * t6450) + 0.18e2 * t5906 * t567 - 0.6e1 * t5890 * t176 + 0.3e1 * t106 * t180 * t1992 + 0.3e1 * t106 * t81 * (0.72e2 * t6448 - 0.96e2 * t6450) - 0.6e1 * t657 * t180 * t1996 + 0.6e1 * t1967 * t180 + 0.18e2 * t245 * t193 * t1921 + 0.18e2 * t245 * t559 * t613 + 0.18e2 * t245 * t567 * t613;
  t6534 = -0.3e1 * t250 * t1993 * t175 + 0.24e2 * t2108 * t1997 * t175 + 0.2e1 * t288 * t2020 * t175 - 0.18e2 * t678 * t1885 * t206 - 0.9e1 * t250 * t193 * t1956 + 0.6e1 * t288 * t207 * t1956 - 0.9e1 * t250 * t559 * t635 + 0.6e1 * t288 * t576 * t635 + 0.6e1 * t288 * t589 * t635 - 0.18e2 * t678 * t598 * t588 - 0.18e2 * t657 * t618 * t588;
  t6569 = 0.6e1 * t245 * t1993 * t166 - 0.18e2 * t2113 * t1997 * t166 - 0.3e1 * t250 * t2020 * t166 + 0.18e2 * t166 * t4713 * t5812 - 0.18e2 * t166 * t4814 * t5823 - 0.9e1 * t250 * t1915 * t206 - 0.9e1 * t250 * t1922 * t206 - 0.9e1 * t250 * t567 * t635 - 0.9e1 * t250 * t614 * t588 + 0.18e2 * t694 * t559 * t617 + 0.18e2 * t694 * t567 * t617;
  t6571 = t635 * t47 * t1892;
  t6606 = 0.36e2 * t3766 * t617 * t47 * t1892 + 0.36e2 * t1026 * t1603 * t588 + 0.18e2 * t1026 * t5791 * t175 + 0.18e2 * t1026 * t5801 * t175 - 0.36e2 * t1087 * t1603 * t566 - 0.18e2 * t1087 * t5812 * t175 - 0.18e2 * t1485 * t5787 * t175 - 0.54e2 * t2541 * t5816 * t175 + 0.36e2 * t2568 * t5823 * t175 - 0.18e2 * t1426 * t6571 + 0.18e2 * t1438 * t6571 - 0.18e2 * t5668 * t1893;
  t6612 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6500 + t6534 + t6569 + t6606));
  tv4sigmatau30 = 0.2e1 * rho[0] * t6612;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t6614 = t635 * t635;
  t6622 = t2081 * t127 * t28;
  t6624 = t2260 * t2082;
  t6626 = t2189 * t2082;
  t6679 = t613 * t613;
  t6698 = t617 * t617;
  t6705 = 0.6e1 * t288 * t81 * t6614 + 0.8e1 * t288 * t207 * t2019 - t124 * t81 * (-0.2064384e7 * t132 * t734 * t2081 * t28 - 0.73728e6 * t725 * t137 * t2081 * t28 + 0.9216e5 * t2230 * t70 * t2081 * t28 + 0.774144e6 * t67 * t2248 * t2081 * t28 + 0.193536e7 * t310 * t323 * t2081 * t28 + 0.1152e5 * t2175 * t2082 - 0.2304e4 * t6622 + 0.13824e5 * t6624 - 0.2304e5 * t6626) + 0.36e2 * t5906 * t614 - 0.24e2 * t5890 * t207 + 0.3e1 * t106 * t81 * (-0.1152e4 * t6622 + 0.3072e4 * t6624 - 0.192e4 * t6626) + 0.72e2 * t2360 * t598 * t617 - 0.72e2 * t1087 * t1603 * t613 - 0.72e2 * t2113 * t193 * t1996 + 0.72e2 * t1026 * t1603 * t635 - 0.36e2 * t678 * t598 * t635 + 0.18e2 * t245 * t81 * t6679 + 0.24e2 * t245 * t193 * t1992 + 0.36e2 * t694 * t614 * t617 - 0.12e2 * t250 * t1993 * t206 - 0.18e2 * t250 * t614 * t635 - 0.12e2 * t250 * t193 * t2019 + 0.24e2 * t2108 * t81 * t6698 - 0.36e2 * t657 * t618 * t635;
  t6709 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t6705);
  tv4tau40 = 0.2e1 * rho[0] * t6709;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t795, t796, t801, t802, t805, t811, t812;
  double t813, t820, t825, t826, t831, t833, t838, tv2rho22;
  double t846, t847, t849, t851, t853, t854, t856, t857;
  double t858, t859, t862, t863, t864, t867, t870, t871;
  double t874, t875, t878, t887, t889, t890, t892, t894;
  double t897, t899, t901, t903, t904, t906, t907, t909;
  double t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934, tv2rhosigma2;
  double t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951, t952;
  double t954, t955, t956, t957, t960, t961, t962, t965;
  double t968, t969, t972, t973, t976, t985, t987, t988;
  double t990, t992, t995, t997, t999, t1001, t1002, t1004;
  double t1005, t1007, t1010, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 - 0.2e1 * t308 * t335 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1010 = t386 * t326;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 - t308 * t1010 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t795, t796, t801, t802, t805, t811, t812;
  double t813, t820, t825, t826, t831, t833, t838, tv2rho22;
  double t846, t847, t849, t851, t853, t854, t856, t857;
  double t858, t859, t862, t863, t864, t867, t870, t871;
  double t874, t875, t878, t887, t889, t890, t892, t894;
  double t897, t899, t901, t903, t904, t906, t907, t909;
  double t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934, tv2rhosigma2;
  double t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951, t952;
  double t954, t955, t956, t957, t960, t961, t962, t965;
  double t968, t969, t972, t973, t976, t985, t987, t988;
  double t990, t992, t995, t997, t999, t1001, t1002, t1004;
  double t1005, t1007, t1010, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  double t1453, t1454, t1457, t1460, t1461, t1462, t1465, t1469;
  double t1470, t1474, t1476, t1481, t1483, t1486, t1492, t1493;
  double t1496, t1498, t1501, t1503, t1506, t1509, t1512, t1515;
  double t1516, t1517, t1518, t1519, t1522, t1525, t1528, t1529;
  double t1532, t1533, t1534, t1537, t1538, t1541, t1542, t1543;
  double t1546, t1551, t1552, t1560, t1561, t1571, t1580, t1583;
  double t1588, t1589, t1591, t1592, t1595, t1601, t1606, t1623;
  double t1624, t1627, t1628, t1629, t1630, t1631, t1638, t1640;
  double t1641, t1642, t1643, t1644, t1645, t1646, t1647, t1649;
  double t1650, t1666, t1668, t1672, t1673, t1676, t1680, t1682;
  double t1683, t1685, t1689, t1690, t1695, t1697, t1698, t1701;
  double t1704, t1707, t1711, t1712, t1716, t1718, t1720, t1722;
  double t1724, t1727, t1729, tv3rho30, t1732, t1733, t1734, t1737;
  double t1742, t1743, t1745, t1749, t1750, t1754, t1757, t1761;
  double t1763, t1767, t1776, t1777, t1778, t1781, t1786, t1788;
  double t1792, t1793, t1797, t1800, t1801, t1803, t1812, t1814;
  double t1817, tv3rho31, t1820, t1825, t1829, t1833, t1834, t1838;
  double t1840, t1849, t1850, t1855, t1859, t1863, t1864, t1868;
  double t1870, t1877, t1885, t1887, t1888, tv3rho32, t1893, t1900;
  double t1904, t1905, t1912, t1913, t1920, t1924, t1925, t1940;
  double t1942, t1943, t1944, t1945, t1946, t1947, t1948, t1952;
  double t1953, t1957, t1958, t1961, t1963, t1965, t1967, t1969;
  double t1970, t1972, t1975, t1978, t1979, t1980, t1989, t1993;
  double t1996, t1999, t2002, t2003, t2004, t2005, t2008, t2012;
  double t2013, t2017, t2018, t2019, t2022, t2023, t2026, t2029;
  double t2034, t2041, t2044, t2051, t2052, t2054, t2055, t2058;
  double t2064, t2069, t2086, t2087, t2090, t2094, t2095, t2096;
  double t2097, t2098, t2104, t2120, t2124, t2125, t2130, tv3rho33;
  double t2138, t2145, t2147, t2149, t2155, t2157, t2159, t2162;
  double t2164, t2165, t2166, t2168, t2169, t2171, t2172, t2174;
  double t2175, t2177, t2178, t2180, t2183, t2185, t2188, t2191;
  double t2193, t2195, t2197, t2199, t2201, t2202, t2204, t2205;
  double t2207, t2210, t2222, t2238, t2240, t2241, t2243, t2244;
  double t2246, t2253, t2254, t2255, t2258, t2259, t2262, t2265;
  double t2267, t2268, t2273, t2276, t2277, t2282, t2287, t2288;
  double t2291, t2292, t2295, t2298, t2301, t2303, t2305, t2306;
  double t2307, t2316, t2318, t2319, t2322, t2325, t2328, t2331;
  double t2332, t2335, t2338, t2339, t2340, t2341, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2352, t2355, t2357, t2362;
  double tv3rho2sigma0, tv3rho2sigma1, t2369, t2373, t2375, tv3rho2sigma2, t2381, t2389;
  double tv3rho2sigma3, tv3rho2sigma4, t2395, t2402, t2405, tv3rho2sigma5, t2413, tv3rho2sigma6;
  double tv3rho2sigma7, t2424, t2427, t2435, t2437, t2440, t2442, t2443;
  double t2444, t2446, t2447, t2449, t2450, t2452, t2453, t2455;
  double t2456, t2458, t2461, t2463, t2466, t2469, t2471, t2473;
  double t2475, t2477, t2479, t2480, t2482, t2483, t2485, t2497;
  double t2498, t2500, t2504, t2506, t2507, t2509, t2530, t2535;
  double t2537, t2538, t2541, t2542, t2543, t2546, t2549, t2553;
  double t2555, t2556, t2557, t2562, t2563, t2566, t2569, t2572;
  double t2573, t2576, t2577, t2578, t2581, t2582, t2585, t2588;
  double t2591, t2592, t2595, t2598, t2601, t2602, t2605, t2606;
  double t2607, t2608, t2611, t2612, t2613, t2614, t2617, t2618;
  double t2619, t2628, t2630, t2632, t2637, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2644, t2651, t2653, t2681;
  double t2690, t2694, t2695, t2696, t2705, t2706, t2712, t2714;
  double t2724, t2727, t2728, t2730, t2731, t2732, t2738, t2742;
  double t2743, t2744, t2752, t2759, t2765, t2782, t2786, t2787;
  double t2788, t2790, t2793, t2812, t2813, t2816, t2817, t2822;
  double tv3rho2tau0, t2829, t2833, t2835, tv3rho2tau1, t2841, t2849, tv3rho2tau2;
  double t2855, t2862, t2865, tv3rho2tau3, t2873, tv3rho2tau4, t2910, t2919;
  double t2923, t2924, t2925, t2934, t2935, t2941, t2944, t2952;
  double t2953, t2958, t2960, t2961, t2962, t2965, t2966, t2968;
  double t2972, t2973, t2976, t2978, t2984, t2991, t3004, t3018;
  double t3034, t3041, t3042, t3043, t3045, t3046, t3051, tv3rho2tau5;
  double t3058, t3063, t3065, t3081, t3082, t3083, t3084, t3086;
  double t3101, t3103, t3108, t3109, t3114, t3119, t3120, t3123;
  double t3126, t3127, t3128, t3131, t3132, t3135, t3136, t3139;
  double t3142, t3143, t3148, t3151, t3152, t3155, t3158, t3164;
  double t3169, t3172, t3175, t3178, t3180, t3182, t3184, t3187;
  double t3189, t3191, t3193, t3194, t3196, t3197, t3199, t3202;
  double t3203, t3204, t3207, t3208, t3211, t3213, t3218, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3225, t3227, tv3rhosigma25, t3233;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t3251, t3253, t3254;
  double t3255, t3256, t3257, t3259, t3278, t3279, t3282, t3285;
  double t3286, t3291, t3296, t3297, t3300, t3303, t3304, t3307;
  double t3308, t3313, t3316, t3317, t3320, t3323, t3328, t3329;
  double t3332, t3333, t3337, t3340, t3343, t3345, t3347, t3349;
  double t3352, t3354, t3356, t3358, t3359, t3361, t3362, t3364;
  double t3369, t3372, t3375, t3376, t3377, t3380, t3381, t3388;
  double t3390, t3392, t3397, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3;
  double tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11;
  double t3404, t3411, t3412, t3415, t3416, t3419, t3420, t3423;
  double t3426, t3427, t3434, t3435, t3438, t3439, t3444, t3445;
  double t3448, t3449, t3452, t3455, t3457, t3458, t3461, t3463;
  double t3467, t3469, t3471, t3475, t3478, t3480, t3482, t3483;
  double t3485, t3487, t3489, t3491, t3494, t3495, t3498, t3502;
  double t3503, t3508, t3509, t3545, t3548, t3551, t3554, t3557;
  double t3563, t3564, t3569, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double t3576, t3578, tv3rhosigmatau5, t3584, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, t3589, t3590, t3593, t3594, t3597, t3598, t3601;
  double t3604, t3606, t3608, t3610, t3611, t3614, t3616, t3620;
  double t3622, t3624, t3628, t3631, t3633, t3635, t3636, t3638;
  double t3641, t3644, t3648, t3649, t3654, t3655, t3658, t3664;
  double t3665, t3668, t3669, t3674, t3675, t3678, t3679, t3682;
  double t3685, t3686, t3687, t3732, t3735, t3738, t3741, t3744;
  double t3747, t3748, t3753, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23;
  double tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5;
  double tv3rholapltau6, tv3rholapltau7, t3760, t3763, t3766, t3769, t3772, t3773;
  double t3776, t3795, t3799, t3800, t3803, t3805, t3806, t3809;
  double t3810, t3812, t3815, t3816, t3825, t3837, t3854, t3862;
  double t3870, t3876, t3877, t3879, t3880, t3885, tv3rhotau20, tv3rhotau21;
  double t3892, t3894, tv3rhotau22, t3900, tv3rhotau23, tv3rhotau24, t3907, t3910;
  double t3913, t3916, t3917, t3920, t3939, t3943, t3944, t3947;
  double t3949, t3950, t3953, t3954, t3956, t3959, t3960, t3969;
  double t3981, t3998, t4006, t4014, t4020, t4021, t4023, t4024;
  double t4029, tv3rhotau25, t4033, t4034, t4037, t4038, t4040, t4043;
  double t4046, t4050, t4051, t4053, t4054, t4058, t4061, t4064;
  double t4071, t4072, t4080, t4082, t4083, t4086, t4090, t4091;
  double t4094, t4098, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t4099, t4101, t4103, t4105, t4109;
  double t4110, t4113, t4114, t4119, t4120, t4124, t4127, t4130;
  double t4134, t4135, t4137, t4138, t4142, t4145, t4148, t4158;
  double t4159, t4162, t4166, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11;
  double t4195, t4196, t4201, t4202, t4203, t4206, t4208, t4212;
  double t4214, t4215, t4217, t4219, t4220, t4222, t4225, t4228;
  double t4229, t4235, t4236, t4242, t4243, t4246, t4247, t4248;
  double t4251, t4252, t4256, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4;
  double tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t4257, t4260;
  double t4263, t4265, t4269, t4271, t4272, t4274, t4276, t4277;
  double t4279, t4280, t4286, t4287, t4302, t4322, t4323, t4328;
  double t4329, t4332, t4333, t4336, t4337, t4338, t4341, t4342;
  double t4346, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4;
  double tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t4347;
  double t4350, t4353, t4356, t4361, t4373, t4374, t4381, t4385;
  double t4387, t4388, t4391, t4392, t4398, t4404, t4405, t4411;
  double t4415, t4417, t4418, t4420, t4422, t4424, t4425, t4427;
  double t4428, t4432, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, t4433, t4436, t4439, t4442, t4447, t4459;
  double t4460, t4467, t4471, t4473, t4474, t4477, t4478, t4484;
  double t4490, t4491, t4497, t4501, t4503, t4504, t4506, t4508;
  double t4510, t4511, t4513, t4514, t4518, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t4519, t4520;
  double t4523, t4526, t4538, t4540, t4541, t4543, t4545, t4546;
  double t4549, t4550, t4560, t4563, t4566, t4569, t4572, t4573;
  double t4575, t4579, tv3tau30, tv3tau31, tv3tau32, t4580, t4581, t4584;
  double t4587, t4599, t4601, t4602, t4604, t4606, t4607, t4610;
  double t4611, t4621, t4624, t4627, t4630, t4633, t4634, t4636;
  double t4640, tv3tau33;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 - 0.2e1 * t308 * t335 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1010 = t386 * t326;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 - t308 * t1010 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1453 = 0.1e1 / t443 / t20;
  t1454 = t445 * t162;
  t1457 = t444 * t162;
  t1460 = t158 * t158;
  t1461 = 0.1e1 / t1460;
  t1462 = t17 * t1461;
  t1465 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t449 - 0.6e1 * t1462);
  t1469 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1454 + 0.4e1 / 0.3e1 * t1457 * t453 + 0.4e1 / 0.3e1 * t24 * t1465);
  t1470 = t1469 * t27;
  t1474 = t457 * t171;
  t1476 = t6 * t1474 * t88;
  t1481 = t165 * t470;
  t1483 = t6 * t1481 * t88;
  t1486 = t6 * t462 * t235;
  t1492 = 0.1e1 / t170 / t158;
  t1493 = t26 * t1492;
  t1496 = 0.5e1 / 0.36e2 * t6 * t1493 * t88;
  t1498 = t6 * t471 * t235;
  t1501 = t6 * t172 * t594;
  t1503 = t233 * t542;
  t1506 = t592 * t224;
  t1509 = t233 * t581;
  t1512 = t194 * t522;
  t1515 = t65 * t75;
  t1516 = t526 * tau[0];
  t1517 = t486 * t486;
  t1518 = 0.1e1 / t1517;
  t1519 = t1516 * t1518;
  t1522 = tau[0] * t494;
  t1525 = 0.1e1 / t37 / t527;
  t1528 = -0.44e3 / 0.27e2 * t1522 + 0.154e3 / 0.27e2 * sigma[0] * t1525;
  t1529 = t75 * t1528;
  t1532 = t52 * t209;
  t1533 = t510 * tau[0];
  t1534 = t1533 * t39;
  t1537 = t522 * tau[0];
  t1538 = t1537 * t39;
  t1541 = t53 * t556;
  t1542 = t194 * t526;
  t1543 = t1542 * t529;
  t1546 = t526 * t849;
  t1551 = params->b * t65;
  t1552 = t510 * t194;
  t1560 = 0.1e1 / t572 / t57;
  t1561 = t1560 * t1516;
  t1571 = t214 * t573;
  t1580 = t514 * t184;
  t1583 = t562 * t219;
  t1588 = 0.144e3 * t513 * t1512 + 0.2e5 / 0.9e1 * t1515 * t1519 + 0.384e3 * t214 * t1529 + 0.72e3 * t1532 * t1534 + 0.36e3 * t525 * t1538 + 0.24e4 * t1541 * t1543 - 0.64e4 / 0.3e1 * t557 * t1546 + 0.352e4 / 0.9e1 * t210 * t1522 + 0.768e4 * t1551 * t75 * t1552 + 0.576e4 * t562 * t215 * t522 + 0.896e6 / 0.9e1 * t72 * t1561 * t1518 + 0.48e2 * t1552 * t67 + 0.24e2 * t197 * t1528 + 0.1152e5 * t566 * t1538 + 0.1344e6 * t1571 * t1543 - 0.1792e6 / 0.3e1 * t72 * t574 * t849 + 0.5632e5 / 0.9e1 * t72 * t220 * t494 - 0.96e3 * t525 * t1580 + 0.576e5 * t1583 * t1534 - 0.3072e5 * t566 * t1580;
  t1589 = t86 * t1588;
  t1591 = t499 * t200;
  t1592 = t1591 * t79;
  t1595 = t233 * t499;
  t1601 = t233 * t535;
  t1606 = t510 * t67;
  t1623 = -0.24e2 * t870 * t522 - 0.8e2 * t1606 * t190 - 0.4e3 * t1532 * t1543 - 0.8e2 * t513 * t1538 + 0.64e3 / 0.3e1 * t513 * t1580 - 0.8e1 * t189 * t1528 - 0.4e4 / 0.9e1 * t1541 * t1519 + 0.16e4 / 0.3e1 * t525 * t1546 - 0.352e4 / 0.27e2 * t197 * t1522;
  t1624 = t86 * t1623;
  t1627 = t204 * t204;
  t1628 = 0.1e1 / t1627;
  t1629 = t64 * t1628;
  t1630 = t542 * t224;
  t1631 = t86 * t1630;
  t1638 = t177 * t177;
  t1640 = t176 / t1638;
  t1641 = t30 * t30;
  t1642 = 0.1e1 / t1641;
  t1643 = t484 * sigma[0];
  t1644 = t1642 * t1643;
  t1645 = t1517 * t182;
  t1646 = 0.1e1 / t1645;
  t1647 = t1644 * t1646;
  t1649 = 0.4e4 / 0.43046721e8 * t1640 * t1647;
  t1650 = t62 * t205;
  t1666 = t227 * t227;
  t1668 = t176 / t1666;
  t1672 = 0.1e1 / t36 / t1517;
  t1673 = t485 * t1672;
  t1676 = t181 * t1525;
  t1680 = 0.22e4 / 0.531441e6 * t481 * t1673;
  t1682 = 0.154e4 / 0.6561e4 * t180 * t1676;
  t1683 = -0.4e4 / 0.43046721e8 * t1668 * t1647 + 0.22e4 / 0.531441e6 * t587 * t1673 - 0.154e4 / 0.6561e4 * t230 * t1676 + t1649 - t1680 + t1682;
  t1685 = t63 * t540;
  t1689 = -0.18e2 * t1650 * t500 * t224 + 0.18e2 * t1685 * t201 * t542 + 0.18e2 * t498 * t201 * t535 - 0.9e1 * t503 * t201 * t581 - 0.18e2 * t503 * t507 * t224 - 0.9e1 * t503 * t536 * t224 + 0.6e1 * t541 * t225 * t581 + t80 * t1683 - t1649 + t1680 - t1682;
  t1690 = 0.9e1 * t188 * t592 * t200 + 0.6e1 * t541 * t1503 - 0.3e1 * t206 * t1506 - 0.3e1 * t206 * t1509 - t206 * t1589 + 0.6e1 * t1592 * t86 + 0.18e2 * t498 * t1595 + 0.9e1 * t188 * t1601 + 0.3e1 * t188 * t1624 - 0.6e1 * t1629 * t1631 + t1689;
  t1695 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t88 - 0.3e1 / 0.8e1 * t1476 - 0.9e1 / 0.8e1 * t6 * t458 * t235 + t1483 / 0.4e1 - 0.3e1 / 0.4e1 * t1486 - 0.9e1 / 0.8e1 * t6 * t166 * t594 - t1496 + t1498 / 0.4e1 - 0.3e1 / 0.8e1 * t1501 - 0.3e1 / 0.8e1 * t6 * t28 * t1690);
  t1697 = 0.1e1 / t600 / t97;
  t1698 = t602 * t243;
  t1701 = t601 * t243;
  t1704 = t94 * t1461;
  t1707 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t449 - 0.6e1 * t1704);
  t1711 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1698 + 0.4e1 / 0.3e1 * t1701 * t608 + 0.4e1 / 0.3e1 * t99 * t1707);
  t1712 = t1711 * t27;
  t1716 = t612 * t171;
  t1718 = t6 * t1716 * t153;
  t1720 = t246 * t470;
  t1722 = t6 * t1720 * t153;
  t1724 = t101 * t1492;
  t1727 = 0.5e1 / 0.36e2 * t6 * t1724 * t153;
  t1729 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t153 - 0.3e1 / 0.8e1 * t1718 + t1722 / 0.4e1 - t1727);
  tv3rho30 = 0.3e1 * t599 + 0.3e1 * t626 + t7 * (t1695 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1732 = 0.2e1 * t652;
  t1733 = 0.2e1 * t678;
  t1734 = t1453 * t260;
  t1737 = t444 * t633;
  t1742 = 0.2e1 * t449;
  t1743 = 0.6e1 * t1462;
  t1745 = my_piecewise5(t11, 0, t15, 0, t1742 - t1743);
  t1749 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1734 * t445 + 0.8e1 / 0.9e1 * t1737 * t162 + 0.4e1 / 0.9e1 * t629 * t453 + 0.4e1 / 0.3e1 * t24 * t1745);
  t1750 = t1749 * t27;
  t1754 = t637 * t171;
  t1757 = t6 * t1754 * t88 / 0.4e1;
  t1761 = t263 * t470;
  t1763 = t6 * t1761 * t88;
  t1767 = t6 * t642 * t235 / 0.4e1;
  t1776 = -0.3e1 / 0.8e1 * t6 * t1750 * t88 - t1757 - 0.3e1 / 0.4e1 * t6 * t638 * t235 + t1763 / 0.12e2 - t1767 - 0.3e1 / 0.8e1 * t6 * t264 * t594 - t1476 / 0.8e1 + t1483 / 0.6e1 - t1486 / 0.4e1 - t1496 + t1498 / 0.6e1 - t1501 / 0.8e1;
  t1777 = my_piecewise3(t2, 0, t1776);
  t1778 = t1697 * t271;
  t1781 = t601 * t657;
  t1786 = 0.6e1 * t1704;
  t1788 = my_piecewise5(t15, 0, t11, 0, -t1742 - t1786);
  t1792 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1778 * t602 + 0.8e1 / 0.9e1 * t1781 * t243 + 0.4e1 / 0.9e1 * t653 * t608 + 0.4e1 / 0.3e1 * t99 * t1788);
  t1793 = t1792 * t27;
  t1797 = t661 * t171;
  t1800 = t6 * t1797 * t153 / 0.4e1;
  t1801 = t274 * t470;
  t1803 = t6 * t1801 * t153;
  t1812 = t6 * t617 * t337 / 0.4e1;
  t1814 = t6 * t621 * t337;
  t1817 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t153 - t1800 + t1803 / 0.12e2 - t1718 / 0.8e1 + t1722 / 0.6e1 - t1727 - 0.3e1 / 0.8e1 * t6 * t613 * t337 - t1812 + t1814 / 0.12e2);
  tv3rho31 = t599 + t626 + t1732 + t1733 + t7 * (t1777 + t1817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1820 = t1453 * t683;
  t1825 = t444 * t688;
  t1829 = my_piecewise5(t11, 0, t15, 0, -t1742 - t1743);
  t1833 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1820 * t162 + 0.8e1 / 0.9e1 * t629 * t633 + 0.4e1 / 0.9e1 * t1825 * t162 + 0.4e1 / 0.3e1 * t24 * t1829);
  t1834 = t1833 * t27;
  t1838 = t692 * t171;
  t1840 = t6 * t1838 * t88;
  t1849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t88 - t1840 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t235 - t1757 + t1763 / 0.6e1 - t1767 + t1483 / 0.12e2 - t1496 + t1498 / 0.12e2);
  t1850 = t1697 * t700;
  t1855 = t601 * t705;
  t1859 = my_piecewise5(t15, 0, t11, 0, t1742 - t1786);
  t1863 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1850 * t243 + 0.8e1 / 0.9e1 * t653 * t657 + 0.4e1 / 0.9e1 * t1855 * t243 + 0.4e1 / 0.3e1 * t99 * t1859);
  t1864 = t1863 * t27;
  t1868 = t709 * t171;
  t1870 = t6 * t1868 * t153;
  t1877 = t6 * t666 * t337;
  t1885 = t6 * t251 * t833;
  t1887 = -0.3e1 / 0.8e1 * t6 * t1864 * t153 - t1870 / 0.8e1 - t1800 + t1803 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t337 - t1877 / 0.4e1 + t1722 / 0.12e2 - t1727 - t1812 + t1814 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t833 - t1885 / 0.8e1;
  t1888 = my_piecewise3(t93, 0, t1887);
  tv3rho32 = t1732 + t1733 + t699 + t838 + t7 * (t1849 + t1888);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1893 = t683 * t260;
  t1900 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t449 - 0.6e1 * t1462);
  t1904 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1893 + 0.4e1 / 0.3e1 * t629 * t688 + 0.4e1 / 0.3e1 * t24 * t1900);
  t1905 = t1904 * t27;
  t1912 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t88 - 0.3e1 / 0.8e1 * t1840 + t1763 / 0.4e1 - t1496);
  t1913 = t700 * t271;
  t1920 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t449 - 0.6e1 * t1704);
  t1924 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1913 + 0.4e1 / 0.3e1 * t653 * t705 + 0.4e1 / 0.3e1 * t99 * t1920);
  t1925 = t1924 * t27;
  t1940 = t329 * t329;
  t1942 = t176 / t1940;
  t1943 = t723 * sigma[2];
  t1944 = t1642 * t1943;
  t1945 = t725 * t725;
  t1946 = t1945 * t284;
  t1947 = 0.1e1 / t1946;
  t1948 = t1944 * t1947;
  t1952 = 0.1e1 / t104 / t1945;
  t1953 = t724 * t1952;
  t1957 = 0.1e1 / t105 / t766;
  t1958 = t283 * t1957;
  t1961 = t279 * t279;
  t1963 = t176 / t1961;
  t1965 = 0.4e4 / 0.43046721e8 * t1963 * t1948;
  t1967 = 0.22e4 / 0.531441e6 * t722 * t1953;
  t1969 = 0.154e4 / 0.6561e4 * t282 * t1958;
  t1970 = -0.4e4 / 0.43046721e8 * t1942 * t1948 + 0.22e4 / 0.531441e6 * t826 * t1953 - 0.154e4 / 0.6561e4 * t332 * t1958 + t1965 - t1967 + t1969;
  t1972 = t831 * t326;
  t1975 = t335 * t820;
  t1978 = t316 * t812;
  t1979 = t296 * t765;
  t1980 = t1979 * t768;
  t1989 = tau[1] * t733;
  t1993 = -0.44e3 / 0.27e2 * t1989 + 0.154e3 / 0.27e2 * sigma[2] * t1957;
  t1996 = t749 * t296;
  t1999 = t296 * t761;
  t2002 = t130 * t140;
  t2003 = t765 * tau[1];
  t2004 = 0.1e1 / t1945;
  t2005 = t2003 * t2004;
  t2008 = t140 * t1993;
  t2012 = 0.1e1 / t811 / t122;
  t2013 = t2012 * t2003;
  t2017 = t120 * t311;
  t2018 = t749 * tau[1];
  t2019 = t2018 * t107;
  t2022 = t761 * tau[1];
  t2023 = t2022 * t107;
  t2026 = t121 * t795;
  t2029 = t765 * t947;
  t2034 = params->b * t130;
  t2041 = t753 * t286;
  t2044 = t801 * t321;
  t2051 = 0.1344e6 * t1978 * t1980 - 0.1792e6 / 0.3e1 * t137 * t813 * t947 + 0.5632e5 / 0.9e1 * t137 * t322 * t733 + 0.24e2 * t299 * t1993 + 0.48e2 * t1996 * t132 + 0.144e3 * t752 * t1999 + 0.2e5 / 0.9e1 * t2002 * t2005 + 0.384e3 * t316 * t2008 + 0.896e6 / 0.9e1 * t137 * t2013 * t2004 + 0.72e3 * t2017 * t2019 + 0.36e3 * t764 * t2023 + 0.24e4 * t2026 * t1980 - 0.64e4 / 0.3e1 * t796 * t2029 + 0.352e4 / 0.9e1 * t312 * t1989 + 0.768e4 * t2034 * t140 * t1996 + 0.576e4 * t801 * t317 * t761 - 0.96e3 * t764 * t2041 + 0.576e5 * t2044 * t2019 + 0.1152e5 * t805 * t2023 - 0.3072e5 * t805 * t2041;
  t2052 = t151 * t2051;
  t2054 = t738 * t302;
  t2055 = t2054 * t144;
  t2058 = t335 * t738;
  t2064 = t335 * t774;
  t2069 = t749 * t132;
  t2086 = -0.24e2 * t968 * t761 - 0.8e2 * t2069 * t292 - 0.4e3 * t2017 * t1980 - 0.8e2 * t752 * t2023 + 0.64e3 / 0.3e1 * t752 * t2041 - 0.8e1 * t291 * t1993 - 0.4e4 / 0.9e1 * t2026 * t2005 + 0.16e4 / 0.3e1 * t764 * t2029 - 0.352e4 / 0.27e2 * t299 * t1989;
  t2087 = t151 * t2086;
  t2090 = t335 * t781;
  t2094 = t306 * t306;
  t2095 = 0.1e1 / t2094;
  t2096 = t129 * t2095;
  t2097 = t781 * t326;
  t2098 = t151 * t2097;
  t2104 = t127 * t307;
  t2120 = t128 * t779;
  t2124 = -0.18e2 * t2104 * t739 * t326 + 0.18e2 * t2120 * t303 * t781 + 0.18e2 * t737 * t303 * t774 - 0.9e1 * t742 * t303 * t820 - 0.18e2 * t742 * t746 * t326 - 0.9e1 * t742 * t775 * t326 + 0.6e1 * t780 * t327 * t820 - 0.6e1 * t2096 * t2098 - t1965 + t1967 - t1969;
  t2125 = 0.9e1 * t290 * t831 * t302 + t145 * t1970 + 0.6e1 * t2055 * t151 - 0.3e1 * t308 * t1972 - 0.3e1 * t308 * t1975 - t308 * t2052 + 0.18e2 * t737 * t2058 + 0.9e1 * t290 * t2064 + 0.3e1 * t290 * t2087 + 0.6e1 * t780 * t2090 + t2124;
  t2130 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t153 - 0.3e1 / 0.8e1 * t1870 - 0.9e1 / 0.8e1 * t6 * t710 * t337 + t1803 / 0.4e1 - 0.3e1 / 0.4e1 * t1877 - 0.9e1 / 0.8e1 * t6 * t275 * t833 - t1727 + t1814 / 0.4e1 - 0.3e1 / 0.8e1 * t1885 - 0.3e1 / 0.8e1 * t6 * t102 * t2125);
  tv3rho33 = 0.3e1 * t699 + 0.3e1 * t838 + t7 * (t1912 + t2130);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2138 = t6 * t462 * t364;
  t2145 = t6 * t471 * t364 / 0.12e2;
  t2147 = t6 * t172 * t920;
  t2149 = t362 * t499;
  t2155 = t362 * t581;
  t2157 = t592 * t357;
  t2159 = t233 * t906;
  t2162 = t1606 * t39;
  t2164 = t529 * t194;
  t2165 = t2164 * tau[0];
  t2166 = t1532 * t2165;
  t2168 = t184 * t194;
  t2169 = t513 * t2168;
  t2171 = t39 * t522;
  t2172 = t513 * t2171;
  t2174 = t1518 * t526;
  t2175 = t1541 * t2174;
  t2177 = t849 * tau[0];
  t2178 = t525 * t2177;
  t2180 = t197 * t494;
  t2183 = t1551 * t354 * t510;
  t2185 = t1583 * t2165;
  t2188 = t562 * t903 * t194;
  t2191 = t562 * t354 * t522;
  t2193 = t573 * t1518;
  t2195 = t214 * t2193 * t526;
  t2197 = t219 * t849;
  t2199 = t214 * t2197 * tau[0];
  t2201 = t75 * t494;
  t2202 = t214 * t2201;
  t2204 = -0.6e1 * t2162 - 0.6e2 * t2166 + 0.32e2 * t2169 - 0.6e1 * t2172 - 0.1e3 * t2175 + 0.12e3 * t2178 - 0.88e2 / 0.3e1 * t2180 - 0.96e3 * t2183 - 0.48e4 * t2185 + 0.128e4 * t2188 - 0.24e3 * t2191 - 0.56e4 * t2195 + 0.384e4 * t2199 - 0.1408e4 / 0.3e1 * t2202;
  t2205 = t86 * t2204;
  t2207 = t918 * t200;
  t2210 = t362 * t535;
  t2222 = -0.2e1 * t206 * t918 * t224 + 0.4e1 * t541 * t887 * t224 - 0.3e1 * t503 * t358 * t535 + 0.2e1 * t541 * t362 * t542 + 0.6e1 * t188 * t2207 + 0.3e1 * t188 * t2210 - t206 * t2155 - t206 * t2157 - 0.2e1 * t206 * t2159 - t206 * t2205 + 0.6e1 * t498 * t2149;
  t2238 = t1517 * t35;
  t2240 = t1642 / t2238;
  t2241 = t2240 * t484;
  t2243 = 0.5e3 / 0.14348907e8 * t1640 * t2241;
  t2244 = t34 * t494;
  t2246 = 0.11e3 / 0.2187e4 * t179 * t2244;
  t2253 = t1685 * t86;
  t2254 = t39 * t542;
  t2255 = t189 * t2254;
  t2258 = t184 * t224;
  t2259 = t189 * t2258;
  t2262 = t870 * t863;
  t2265 = -0.6e1 * t1629 * t358 * t542 - 0.6e1 * t1650 * t358 * t499 - 0.6e1 * t503 * t887 * t200 - 0.6e1 * t503 * t907 * t200 - 0.6e1 * t503 * t909 * t224 + 0.4e1 * t541 * t907 * t224 + 0.2e1 * t541 * t358 * t581 + 0.6e1 * t2253 * t2255 + 0.16e2 * t862 * t2259 - 0.6e1 * t862 * t2262 + t2243 + t2246;
  t2267 = t39 * t581;
  t2268 = t189 * t2267;
  t2273 = t513 * t2177;
  t2276 = t184 * t200;
  t2277 = t189 * t2276;
  t2282 = t188 * t592;
  t2287 = t522 * t59;
  t2288 = t2287 * t39;
  t2291 = t357 * t200;
  t2292 = t2291 * t224;
  t2295 = t870 * t184;
  t2298 = t189 * t494;
  t2301 = -0.3e1 * t862 * t2268 + 0.2e2 * t867 * t875 - 0.8e2 * t348 * t2273 - 0.32e2 * t857 * t2277 - 0.16e2 * t867 * t878 + 0.3e1 * t2282 * t349 + 0.6e1 * t867 * t871 + 0.3e1 * t348 * t2288 + 0.12e2 * t2253 * t2292 - 0.16e2 * t348 * t2295 + 0.88e2 / 0.3e1 * t348 * t2298;
  t2303 = t483 * t489 * sigma[0];
  t2305 = 0.25e2 / 0.19683e5 * t481 * t2303;
  t2306 = t499 * t79;
  t2307 = t2306 * t86;
  t2316 = 0.5e3 / 0.14348907e8 * t1668 * t2241 - 0.25e2 / 0.19683e5 * t587 * t2303 + 0.11e3 / 0.2187e4 * t229 * t2244 - t2243 + t2305 - t2246;
  t2318 = t194 * t67;
  t2319 = t2318 * t874;
  t2322 = t1532 * t2174;
  t2325 = t498 * t233;
  t2328 = t870 * t858;
  t2331 = t39 * t535;
  t2332 = t189 * t2331;
  t2335 = t503 * t233;
  t2338 = t86 * t52;
  t2339 = t1650 * t2338;
  t2340 = t200 * t224;
  t2341 = t1277 * t2340;
  t2344 = t498 * t2338;
  t2345 = t67 * t529;
  t2346 = t200 * tau[0];
  t2347 = t2345 * t2346;
  t2350 = t503 * t2338;
  t2351 = t224 * tau[0];
  t2352 = t2345 * t2351;
  t2355 = 0.6e1 * t2307 * t349 + t80 * t2316 + 0.2e2 * t348 * t2319 + 0.5e2 * t348 * t2322 + 0.12e2 * t2325 * t859 + 0.12e2 * t857 * t2328 + 0.6e1 * t857 * t2332 - 0.6e1 * t2335 * t864 - 0.12e2 * t2339 * t2341 + 0.4e2 * t2344 * t2347 - 0.2e2 * t2350 * t2352 - t2305;
  t2357 = t2222 + t2265 + t2301 + t2355;
  t2362 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t364 - t2138 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t920 + t2145 - t2147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2357);
  tv3rho2sigma0 = t7 * t2362 + 0.2e1 * t925;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2369 = t6 * t617 * t388;
  t2373 = t6 * t621 * t388 / 0.12e2;
  t2375 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t388 - t2369 / 0.4e1 + t2373);
  tv3rho2sigma2 = t7 * t2375 + 0.2e1 * t934;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2381 = t6 * t642 * t364;
  t2389 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t364 - t2381 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t920 - t2138 / 0.8e1 + t2145 - t2147 / 0.8e1);
  tv3rho2sigma3 = t7 * t2389 + t925 + t940;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2395 = t6 * t666 * t388;
  t2402 = t6 * t251 * t1018;
  t2405 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t388 - t2395 / 0.8e1 - t2369 / 0.8e1 + t2373 - 0.3e1 / 0.8e1 * t6 * t247 * t1018 - t2402 / 0.8e1);
  tv3rho2sigma5 = t7 * t2405 + t1023 + t934;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2413 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t364 - t2381 / 0.4e1 + t2145);
  tv3rho2sigma6 = t7 * t2413 + 0.2e1 * t940;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2424 = t1016 * t302;
  t2427 = t386 * t774;
  t2435 = t831 * t381;
  t2437 = t335 * t1004;
  t2440 = t2069 * t107;
  t2442 = t768 * t296;
  t2443 = t2442 * tau[1];
  t2444 = t2017 * t2443;
  t2446 = t286 * t296;
  t2447 = t752 * t2446;
  t2449 = t107 * t761;
  t2450 = t752 * t2449;
  t2452 = t2004 * t765;
  t2453 = t2026 * t2452;
  t2455 = t947 * tau[1];
  t2456 = t764 * t2455;
  t2458 = t299 * t733;
  t2461 = t2034 * t378 * t749;
  t2463 = t2044 * t2443;
  t2466 = t801 * t1001 * t296;
  t2469 = t801 * t378 * t761;
  t2471 = t812 * t2004;
  t2473 = t316 * t2471 * t765;
  t2475 = t321 * t947;
  t2477 = t316 * t2475 * tau[1];
  t2479 = t140 * t733;
  t2480 = t316 * t2479;
  t2482 = -0.6e1 * t2440 - 0.6e2 * t2444 + 0.32e2 * t2447 - 0.6e1 * t2450 - 0.1e3 * t2453 + 0.12e3 * t2456 - 0.88e2 / 0.3e1 * t2458 - 0.96e3 * t2461 - 0.48e4 * t2463 + 0.128e4 * t2466 - 0.24e3 * t2469 - 0.56e4 * t2473 + 0.384e4 * t2477 - 0.1408e4 / 0.3e1 * t2480;
  t2483 = t151 * t2482;
  t2485 = t386 * t738;
  t2497 = -0.2e1 * t308 * t1016 * t326 - 0.6e1 * t2096 * t382 * t781 - 0.6e1 * t2104 * t382 * t738 - t308 * t386 * t820 + 0.2e1 * t780 * t386 * t781 + 0.6e1 * t290 * t2424 + 0.3e1 * t290 * t2427 - t308 * t2435 - 0.2e1 * t308 * t2437 - t308 * t2483 + 0.6e1 * t737 * t2485;
  t2498 = t34 * t733;
  t2500 = 0.11e3 / 0.2187e4 * t281 * t2498;
  t2504 = t1945 * t103;
  t2506 = t1642 / t2504;
  t2507 = t2506 * t723;
  t2509 = 0.5e3 / 0.14348907e8 * t1963 * t2507;
  t2530 = t968 * t286;
  t2535 = -0.6e1 * t742 * t1005 * t302 + 0.4e1 * t780 * t1005 * t326 - 0.6e1 * t742 * t1007 * t326 - 0.6e1 * t742 * t985 * t302 + 0.4e1 * t780 * t985 * t326 - 0.3e1 * t742 * t382 * t774 + 0.2e1 * t780 * t382 * t820 - 0.16e2 * t372 * t2530 + 0.6e1 * t965 * t969 - 0.16e2 * t965 * t976 + t2500 + t2509;
  t2537 = t761 * t124;
  t2538 = t2537 * t107;
  t2541 = t2120 * t151;
  t2542 = t381 * t302;
  t2543 = t2542 * t326;
  t2546 = t290 * t831;
  t2549 = t291 * t733;
  t2553 = t483 * t728 * sigma[2];
  t2555 = 0.25e2 / 0.19683e5 * t722 * t2553;
  t2556 = t738 * t144;
  t2557 = t2556 * t151;
  t2562 = t296 * t132;
  t2563 = t2562 * t972;
  t2566 = t2017 * t2452;
  t2569 = t752 * t2455;
  t2572 = t286 * t302;
  t2573 = t291 * t2572;
  t2576 = 0.3e1 * t372 * t2538 + 0.12e2 * t2541 * t2543 + 0.3e1 * t2546 * t373 + 0.88e2 / 0.3e1 * t372 * t2549 - t2555 + 0.6e1 * t2557 * t373 + 0.2e2 * t965 * t973 + 0.2e2 * t372 * t2563 + 0.5e2 * t372 * t2566 - 0.8e2 * t372 * t2569 - 0.32e2 * t955 * t2573;
  t2577 = t107 * t781;
  t2578 = t291 * t2577;
  t2581 = t286 * t326;
  t2582 = t291 * t2581;
  t2585 = t737 * t335;
  t2588 = t968 * t956;
  t2591 = t107 * t774;
  t2592 = t291 * t2591;
  t2595 = t742 * t335;
  t2598 = t968 * t961;
  t2601 = t107 * t820;
  t2602 = t291 * t2601;
  t2605 = t151 * t120;
  t2606 = t2104 * t2605;
  t2607 = t302 * t326;
  t2608 = t1320 * t2607;
  t2611 = t737 * t2605;
  t2612 = t132 * t768;
  t2613 = t302 * tau[1];
  t2614 = t2612 * t2613;
  t2617 = t742 * t2605;
  t2618 = t326 * tau[1];
  t2619 = t2612 * t2618;
  t2628 = 0.5e3 / 0.14348907e8 * t1942 * t2507 - 0.25e2 / 0.19683e5 * t826 * t2553 + 0.11e3 / 0.2187e4 * t331 * t2498 - t2509 + t2555 - t2500;
  t2630 = t145 * t2628 + 0.6e1 * t2541 * t2578 + 0.16e2 * t960 * t2582 + 0.12e2 * t2585 * t957 + 0.12e2 * t955 * t2588 + 0.6e1 * t955 * t2592 - 0.6e1 * t2595 * t962 - 0.6e1 * t960 * t2598 - 0.3e1 * t960 * t2602 - 0.12e2 * t2606 * t2608 + 0.4e2 * t2611 * t2614 - 0.2e2 * t2617 * t2619;
  t2632 = t2497 + t2535 + t2576 + t2630;
  t2637 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t388 - t2395 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1018 + t2373 - t2402 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t2632);
  tv3rho2sigma8 = t7 * t2637 + 0.2e1 * t1023;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2644 = t6 * t462 * t412;
  t2651 = t6 * t471 * t412 / 0.12e2;
  t2653 = t6 * t172 * t1096;
  t2681 = t397 * t535;
  t2690 = 0.12e2 * t498 * t1037 * t200 - 0.6e1 * t503 * t1037 * t224 + 0.12e2 * t498 * t1055 * t200 - 0.6e1 * t503 * t1055 * t224 - 0.6e1 * t503 * t1064 * t200 + 0.4e1 * t541 * t1064 * t224 - 0.6e1 * t503 * t1094 * t200 + 0.4e1 * t541 * t1094 * t224 - 0.3e1 * t503 * t410 * t535 + 0.2e1 * t541 * t410 * t581 + 0.6e1 * t2306 * t397 + 0.6e1 * t498 * t2681;
  t2694 = t1650 * t86;
  t2695 = t396 * t200;
  t2696 = t2695 * t224;
  t2705 = t409 * t200;
  t2706 = t2705 * t224;
  t2712 = t592 * t409;
  t2714 = t233 * t1093;
  t2724 = t219 * t184;
  t2727 = t49 * t522;
  t2728 = t513 * t2727;
  t2730 = 0.1e1 / t487;
  t2731 = t2730 * t526;
  t2732 = t1541 * t2731;
  t2738 = t1560 * t2730;
  t2742 = t1043 * t194;
  t2743 = t2742 * tau[0];
  t2744 = t1532 * t2743;
  t2752 = t573 * t529;
  t2759 = -0.144e3 * t1532 * t49 * t510 + 0.24e3 * t525 * t889 + 0.96e3 * t557 * t874 - 0.512e4 / 0.3e1 * t72 * t2724 + 0.48e2 * t2728 + 0.8e3 * t2732 - 0.72e2 * t525 * t2727 - 0.4e4 / 0.3e1 * t1515 * t2731 - 0.1792e6 / 0.3e1 * t72 * t2738 * t526 + 0.48e3 * t2744 - 0.1152e5 * t562 * t406 * t510 + 0.768e4 * t214 * t1090 * t194 + 0.2688e5 * t72 * t2752 * tau[0] + 0.768e4 * t1551 * t403 * t510;
  t2765 = t573 * t2730;
  t2782 = t1606 * t49;
  t2786 = -0.96e3 * t1541 * t2743 + 0.192e4 * t562 * t403 * t522 + 0.448e5 * t214 * t2765 * t526 - 0.2304e4 * t214 * t406 * t522 + 0.384e5 * t1583 * t2743 - 0.5376e5 * t1571 * t2743 - 0.64e4 * t897 - 0.2304e5 * t901 + 0.32e3 / 0.3e1 * t894 - 0.16e3 * t890 - 0.72e3 * t892 + 0.512e4 / 0.3e1 * t904 + 0.48e2 * t2782 - 0.32e3 / 0.3e1 * t210 * t184;
  t2787 = t2759 + t2786;
  t2788 = t86 * t2787;
  t2790 = t592 * t396;
  t2793 = t233 * t1054;
  t2812 = -0.8e1 * t2287 * t49 - 0.16e3 / 0.3e1 * t2318 * t1044 + 0.8e2 / 0.3e1 * t871 - 0.4e3 / 0.3e1 * t1532 * t2731 + 0.16e3 * t875 - 0.32e3 / 0.9e1 * t878 + 0.16e2 * t2782 + 0.16e3 * t2744 - 0.16e3 / 0.3e1 * t890 + 0.16e2 * t2728 + 0.8e3 / 0.3e1 * t2732 - 0.24e3 * t892 + 0.32e3 / 0.9e1 * t894;
  t2813 = t86 * t2812;
  t2816 = -0.6e1 * t1629 * t410 * t542 - 0.6e1 * t1650 * t410 * t499 + 0.6e1 * t1685 * t397 * t542 - 0.3e1 * t503 * t397 * t581 + 0.3e1 * t188 * t2790 + 0.6e1 * t188 * t2793 + 0.3e1 * t188 * t2813 - t206 * t2712 - 0.2e1 * t206 * t2714 - t206 * t2788 + 0.12e2 * t2253 * t2706 - 0.12e2 * t2694 * t2696;
  t2817 = t2690 + t2816;
  t2822 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t412 - t2644 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t1096 + t2651 - t2653 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2817);
  tv3rho2tau0 = t7 * t2822 + 0.2e1 * t1101;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2829 = t6 * t617 * t436;
  t2833 = t6 * t621 * t436 / 0.12e2;
  t2835 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t436 - t2829 / 0.4e1 + t2833);
  tv3rho2tau1 = t7 * t2835 + 0.2e1 * t1110;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2841 = t6 * t642 * t412;
  t2849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t412 - t2841 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t1096 - t2644 / 0.8e1 + t2651 - t2653 / 0.8e1);
  tv3rho2tau2 = t7 * t2849 + t1101 + t1116;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2855 = t6 * t666 * t436;
  t2862 = t6 * t251 * t1186;
  t2865 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t436 - t2855 / 0.8e1 - t2829 / 0.8e1 + t2833 - 0.3e1 / 0.8e1 * t6 * t247 * t1186 - t2862 / 0.8e1);
  tv3rho2tau3 = t7 * t2865 + t1110 + t1191;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2873 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t412 - t2841 / 0.4e1 + t2651);
  tv3rho2tau4 = t7 * t2873 + 0.2e1 * t1116;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2910 = t421 * t774;
  t2919 = 0.12e2 * t737 * t1127 * t302 - 0.6e1 * t742 * t1127 * t326 + 0.12e2 * t737 * t1145 * t302 - 0.6e1 * t742 * t1145 * t326 - 0.6e1 * t742 * t1154 * t302 + 0.4e1 * t780 * t1154 * t326 - 0.6e1 * t742 * t1184 * t302 + 0.4e1 * t780 * t1184 * t326 - 0.3e1 * t742 * t434 * t774 + 0.2e1 * t780 * t434 * t820 + 0.6e1 * t2556 * t421 + 0.6e1 * t737 * t2910;
  t2923 = t2104 * t151;
  t2924 = t420 * t302;
  t2925 = t2924 * t326;
  t2934 = t433 * t302;
  t2935 = t2934 * t326;
  t2941 = t831 * t420;
  t2944 = t335 * t1144;
  t2952 = 0.1e1 / t726;
  t2953 = t2952 * t765;
  t2958 = t2069 * t117;
  t2960 = t1133 * t296;
  t2961 = t2960 * tau[1];
  t2962 = t2017 * t2961;
  t2965 = t117 * t761;
  t2966 = t752 * t2965;
  t2968 = t2026 * t2953;
  t2972 = -0.8e1 * t2537 * t117 - 0.16e3 / 0.3e1 * t2562 * t1134 + 0.8e2 / 0.3e1 * t969 - 0.4e3 / 0.3e1 * t2017 * t2953 + 0.16e3 * t973 - 0.32e3 / 0.9e1 * t976 + 0.16e2 * t2958 + 0.16e3 * t2962 - 0.16e3 / 0.3e1 * t988 + 0.16e2 * t2966 + 0.8e3 / 0.3e1 * t2968 - 0.24e3 * t990 + 0.32e3 / 0.9e1 * t992;
  t2973 = t151 * t2972;
  t2976 = t831 * t433;
  t2978 = t335 * t1183;
  t2984 = t812 * t2952;
  t2991 = t2012 * t2952;
  t3004 = t812 * t768;
  t3018 = 0.192e4 * t801 * t427 * t761 + 0.448e5 * t316 * t2984 * t765 - 0.2304e4 * t316 * t430 * t761 - 0.1792e6 / 0.3e1 * t137 * t2991 * t765 + 0.768e4 * t2034 * t427 * t749 - 0.1152e5 * t801 * t430 * t749 + 0.768e4 * t316 * t1180 * t296 + 0.2688e5 * t137 * t3004 * tau[1] - 0.96e3 * t2026 * t2961 + 0.48e3 * t2962 - 0.32e3 / 0.3e1 * t312 * t286 + 0.48e2 * t2958 + 0.384e5 * t2044 * t2961 - 0.5376e5 * t1978 * t2961;
  t3034 = t321 * t286;
  t3041 = -0.64e4 * t995 - 0.2304e5 * t999 + 0.32e3 / 0.3e1 * t992 - 0.72e3 * t990 + 0.512e4 / 0.3e1 * t1002 - 0.16e3 * t988 + 0.48e2 * t2966 + 0.8e3 * t2968 - 0.144e3 * t2017 * t117 * t749 + 0.24e3 * t764 * t987 + 0.96e3 * t796 * t972 - 0.512e4 / 0.3e1 * t137 * t3034 - 0.72e2 * t764 * t2965 - 0.4e4 / 0.3e1 * t2002 * t2953;
  t3042 = t3018 + t3041;
  t3043 = t151 * t3042;
  t3045 = -0.6e1 * t2096 * t434 * t781 - 0.6e1 * t2104 * t434 * t738 + 0.6e1 * t2120 * t421 * t781 - 0.3e1 * t742 * t421 * t820 + 0.12e2 * t2541 * t2935 + 0.3e1 * t290 * t2941 + 0.6e1 * t290 * t2944 + 0.3e1 * t290 * t2973 - 0.12e2 * t2923 * t2925 - t308 * t2976 - 0.2e1 * t308 * t2978 - t308 * t3043;
  t3046 = t2919 + t3045;
  t3051 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t436 - t2855 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1186 + t2833 - t2862 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t3046);
  tv3rho2tau5 = t7 * t3051 + 0.2e1 * t1191;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3058 = t6 * t172 * t1230 / 0.8e1;
  t3063 = t1193 * t849;
  t3065 = 0.5e2 / 0.177147e6 * t480 * t3063;
  t3081 = t1517 * rho[0];
  t3082 = 0.1e1 / t3081;
  t3083 = t1642 * t3082;
  t3084 = t3083 * sigma[0];
  t3086 = 0.125e3 / 0.9565938e7 * t1640 * t3084;
  t3101 = -0.125e3 / 0.9565938e7 * t1668 * t3084 + 0.5e2 / 0.177147e6 * t586 * t3063 + t3086 - t3065;
  t3103 = t525 * t849;
  t3108 = t200 * t79;
  t3109 = t3108 * t86;
  t3114 = t188 * t918;
  t3119 = t529 * t59;
  t3120 = t3119 * t200;
  t3123 = t3119 * t224;
  t3126 = 0.2e1 * t188 * t86 * t849 * t59 + t3065 + 0.4e1 * t541 * t1215 * t224 - 0.3e1 * t503 * t1224 * t200 + 0.2e1 * t541 * t1224 * t224 + 0.4e1 * t541 * t358 * t906 - 0.6e1 * t503 * t1215 * t200 - t3086 - 0.3e1 / 0.8e1 * t188 * t233 * t529 * t59 + 0.6e1 * t1685 * t1212 * t200 - 0.6e1 * t1629 * t1212 * t224 + t80 * t3101 - 0.32e2 * t857 * t3103 - 0.16e2 * t1204 * t878 + 0.6e1 * t3109 * t1197 + 0.6e1 * t2325 * t1197 + 0.6e1 * t3114 * t349 + 0.6e1 * t1204 * t871 - 0.3e1 / 0.4e1 * t857 * t3120 + 0.3e1 / 0.8e1 * t862 * t3123;
  t3127 = t1518 * t67;
  t3128 = t3127 * tau[0];
  t3131 = t184 * t357;
  t3132 = t189 * t3131;
  t3135 = t529 * t224;
  t3136 = t525 * t3135;
  t3139 = t1532 * t2164;
  t3142 = t1518 * tau[0];
  t3143 = t1541 * t3142;
  t3148 = t870 * t1200;
  t3151 = t39 * t906;
  t3152 = t189 * t3151;
  t3155 = t498 * t362;
  t3158 = t503 * t362;
  t3164 = t1228 * t200;
  t3169 = t233 * t1211;
  t3172 = t918 * t357;
  t3175 = t362 * t906;
  t3178 = t233 * t1223;
  t3180 = t2318 * t529;
  t3182 = t1532 * t3142;
  t3184 = t513 * t849;
  t3187 = t1551 * t1220 * t194;
  t3189 = t219 * t1518;
  t3191 = t562 * t3189 * tau[0];
  t3193 = t75 * t849;
  t3194 = t562 * t3193;
  t3196 = 0.3e1 / 0.4e1 * t3180 + 0.15e2 / 0.4e1 * t3182 - 0.4e1 * t3184 + 0.12e3 * t3187 + 0.3e3 * t3191 - 0.16e3 * t3194;
  t3197 = t86 * t3196;
  t3199 = t1277 * t2291;
  t3202 = t1685 * t2338;
  t3203 = t357 * t224;
  t3204 = t1277 * t3203;
  t3207 = t357 * tau[0];
  t3208 = t2345 * t3207;
  t3211 = -t206 * t1228 * t224 + 0.2e2 * t1204 * t875 + 0.3e1 * t188 * t3164 - 0.2e1 * t206 * t3172 - 0.2e1 * t206 * t3175 - t206 * t3178 - t206 * t3197 - 0.12e2 * t2339 * t3199 - 0.2e2 * t2350 * t3208 + 0.2e1 * t541 * t3169 + 0.12e2 * t3202 * t3204;
  t3213 = t3126 - 0.5e1 / 0.4e1 * t348 * t3128 + 0.16e2 * t862 * t3132 - 0.6e1 * t2694 * t3136 + 0.12e2 * t857 * t3139 + 0.4e2 * t857 * t3143 - 0.6e1 * t2335 * t1201 - 0.6e1 * t862 * t3148 - 0.6e1 * t862 * t3152 + 0.12e2 * t3155 * t859 - 0.6e1 * t3158 * t864 + t3211;
  t3218 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1230 - t3058 - 0.3e1 / 0.8e1 * t6 * t28 * t3213);
  tv3rhosigma20 = t7 * t3218 + t1234;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3225 = t6 * t251 * t1271 / 0.8e1;
  t3227 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1271 - t3225);
  tv3rhosigma25 = t7 * t3227 + t1275;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3233 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1230 - t3058);
  tv3rhosigma26 = t7 * t3233 + t1234;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3251 = t1193 * t947;
  t3253 = 0.5e2 / 0.177147e6 * t721 * t3251;
  t3254 = t1945 * rho[1];
  t3255 = 0.1e1 / t3254;
  t3256 = t1642 * t3255;
  t3257 = t3256 * sigma[2];
  t3259 = 0.125e3 / 0.9565938e7 * t1963 * t3257;
  t3278 = t2004 * t132;
  t3279 = t3278 * tau[1];
  t3282 = t764 * t947;
  t3285 = t302 * t144;
  t3286 = t3285 * t151;
  t3291 = t290 * t1016;
  t3296 = t768 * t124;
  t3297 = t3296 * t302;
  t3300 = t3296 * t326;
  t3303 = 0.2e1 * t290 * t151 * t947 * t124 + 0.4e1 * t780 * t1256 * t326 - 0.3e1 * t742 * t1265 * t302 + 0.2e1 * t780 * t1265 * t326 + t3253 - t3259 - 0.3e1 / 0.8e1 * t290 * t335 * t768 * t124 + 0.6e1 * t2120 * t1253 * t302 - 0.6e1 * t2096 * t1253 * t326 + 0.4e1 * t780 * t382 * t1004 - 0.6e1 * t742 * t1256 * t302 - 0.16e2 * t1245 * t976 - 0.5e1 / 0.4e1 * t372 * t3279 - 0.32e2 * t955 * t3282 + 0.6e1 * t3286 * t1238 + 0.6e1 * t2585 * t1238 + 0.6e1 * t3291 * t373 + 0.6e1 * t1245 * t969 - 0.3e1 / 0.4e1 * t955 * t3297 + 0.3e1 / 0.8e1 * t960 * t3300;
  t3304 = t2017 * t2442;
  t3307 = t2004 * tau[1];
  t3308 = t2026 * t3307;
  t3313 = t968 * t1241;
  t3316 = t107 * t1004;
  t3317 = t291 * t3316;
  t3320 = t737 * t386;
  t3323 = t742 * t386;
  t3328 = t768 * t326;
  t3329 = t764 * t3328;
  t3332 = t286 * t381;
  t3333 = t291 * t3332;
  t3337 = t1016 * t381;
  t3340 = t386 * t1004;
  t3343 = t335 * t1264;
  t3345 = t2562 * t768;
  t3347 = t2017 * t3307;
  t3349 = t752 * t947;
  t3352 = t2034 * t1261 * t296;
  t3354 = t321 * t2004;
  t3356 = t801 * t3354 * tau[1];
  t3358 = t140 * t947;
  t3359 = t801 * t3358;
  t3361 = 0.3e1 / 0.4e1 * t3345 + 0.15e2 / 0.4e1 * t3347 - 0.4e1 * t3349 + 0.12e3 * t3352 + 0.3e3 * t3356 - 0.16e3 * t3359;
  t3362 = t151 * t3361;
  t3364 = t1269 * t302;
  t3369 = t335 * t1252;
  t3372 = t1320 * t2542;
  t3375 = t2120 * t2605;
  t3376 = t381 * t326;
  t3377 = t1320 * t3376;
  t3380 = t381 * tau[1];
  t3381 = t2612 * t3380;
  t3388 = -0.125e3 / 0.9565938e7 * t1942 * t3257 + 0.5e2 / 0.177147e6 * t825 * t3251 + t3259 - t3253;
  t3390 = -t308 * t1269 * t326 + t145 * t3388 - 0.12e2 * t2606 * t3372 - 0.2e2 * t2617 * t3381 + 0.3e1 * t290 * t3364 - 0.2e1 * t308 * t3337 - 0.2e1 * t308 * t3340 - t308 * t3343 - t308 * t3362 + 0.2e1 * t780 * t3369 + 0.12e2 * t3375 * t3377;
  t3392 = -0.6e1 * t2595 * t1242 + 0.2e2 * t1245 * t973 - 0.6e1 * t2923 * t3329 + 0.12e2 * t955 * t3304 + 0.4e2 * t955 * t3308 - 0.6e1 * t960 * t3313 - 0.6e1 * t960 * t3317 + 0.12e2 * t3320 * t957 - 0.6e1 * t3323 * t962 + 0.16e2 * t960 * t3333 + t3303 + t3390;
  t3397 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1271 - t3225 - 0.3e1 / 0.8e1 * t6 * t102 * t3392);
  tv3rhosigma211 = t7 * t3397 + t1275;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3404 = t6 * t172 * t1314 / 0.8e1;
  t3411 = t396 * t357;
  t3412 = t3411 * t224;
  t3415 = t409 * t357;
  t3416 = t3415 * t200;
  t3419 = t1629 * t86;
  t3420 = t3415 * t224;
  t3423 = t3411 * t200;
  t3426 = t59 * t184;
  t3427 = t1294 * t3426;
  t3434 = t1054 * t52;
  t3435 = t3434 * t1277;
  t3438 = t396 * t194;
  t3439 = t3438 * t1277;
  t3444 = t1093 * t52;
  t3445 = t3444 * t1277;
  t3448 = t409 * t194;
  t3449 = t3448 * t1277;
  t3452 = t1276 * t3426;
  t3455 = t2318 * t1043;
  t3457 = t2730 * tau[0];
  t3458 = t1532 * t3457;
  t3461 = t1532 * t2742;
  t3463 = t1541 * t3457;
  t3467 = t1551 * t1306 * t194;
  t3469 = t219 * t2730;
  t3471 = t562 * t3469 * tau[0];
  t3475 = t562 * t1078 * t194;
  t3478 = t214 * t2765 * tau[0];
  t3480 = t214 * t899;
  t3482 = -0.6e1 * t3455 - 0.3e2 * t3458 + 0.26e2 * t1218 + 0.18e2 * t3461 + 0.6e2 * t3463 - 0.39e2 * t1197 - 0.96e3 * t3467 - 0.24e4 * t3471 + 0.104e4 * t1221 + 0.144e4 * t3475 + 0.336e4 * t3478 - 0.1248e4 * t3480;
  t3483 = t86 * t3482;
  t3485 = t918 * t409;
  t3487 = t362 * t1093;
  t3489 = t233 * t1311;
  t3491 = t918 * t396;
  t3494 = -0.3e1 * t503 * t1037 * t357 - 0.3e1 * t503 * t1055 * t357 + 0.6e1 * t2325 * t1278 + 0.6e1 * t3109 * t1278 - 0.3e1 * t2335 * t1295 + 0.3e1 * t188 * t3491 - t206 * t3483 - t206 * t3485 - t206 * t3487 - t206 * t3489 + 0.6e1 * t2253 * t3412 + 0.6e1 * t2253 * t3416 - 0.6e1 * t2694 * t3423 - 0.6e1 * t3419 * t3420 + 0.8e1 * t862 * t3427 + 0.6e1 * t857 * t3435 + 0.6e1 * t857 * t3439 - 0.3e1 * t862 * t3445 - 0.3e1 * t862 * t3449 - 0.16e2 * t857 * t3452;
  t3495 = t362 * t1054;
  t3498 = t233 * t1290;
  t3502 = t2730 * t67;
  t3503 = t3502 * tau[0];
  t3508 = -0.13e2 / 0.3e1 * t3119 + 0.1e2 / 0.3e1 * t3503 - 0.2e1 * t3455 - 0.1e2 * t3458 + 0.26e2 / 0.3e1 * t1218;
  t3509 = t86 * t3508;
  t3545 = t1650 * t397;
  t3548 = t498 * t397;
  t3551 = t1650 * t410;
  t3554 = t1685 * t410;
  t3557 = t503 * t410;
  t3563 = 0.2e1 * t541 * t1064 * t357 + 0.2e1 * t541 * t1094 * t357 + 0.6e1 * t498 * t1284 * t200 - 0.3e1 * t503 * t1284 * t224 + 0.6e1 * t498 * t1291 * t200 - 0.3e1 * t503 * t1291 * t224 - 0.3e1 * t503 * t1301 * t200 + 0.2e1 * t541 * t1301 * t224 - 0.3e1 * t503 * t1312 * t200 + 0.2e1 * t541 * t1312 * t224 - 0.3e1 * t503 * t397 * t906 + 0.2e1 * t541 * t410 * t906 + 0.3e1 * t188 * t3495 + 0.3e1 * t188 * t3498 + 0.3e1 * t188 * t3509 - 0.6e1 * t3545 * t864 + 0.2e2 * t3548 * t875 - 0.6e1 * t3551 * t859 + 0.6e1 * t3554 * t864 - 0.1e2 * t3557 * t875;
  t3564 = t3494 + t3563;
  t3569 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1314 - t3404 - 0.3e1 / 0.8e1 * t6 * t28 * t3564);
  tv3rhosigmatau0 = t7 * t3569 + t1318;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3576 = t6 * t251 * t1357 / 0.8e1;
  t3578 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1357 - t3576);
  tv3rhosigmatau5 = t7 * t3578 + t1361;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3584 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1314 - t3404);
  tv3rhosigmatau6 = t7 * t3584 + t1318;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3589 = t420 * t381;
  t3590 = t3589 * t326;
  t3593 = t433 * t381;
  t3594 = t3593 * t302;
  t3597 = t2096 * t151;
  t3598 = t3593 * t326;
  t3601 = t3589 * t302;
  t3604 = t386 * t1183;
  t3606 = t335 * t1354;
  t3608 = t2562 * t1133;
  t3610 = t2952 * tau[1];
  t3611 = t2017 * t3610;
  t3614 = t2017 * t2960;
  t3616 = t2026 * t3610;
  t3620 = t2034 * t1349 * t296;
  t3622 = t321 * t2952;
  t3624 = t801 * t3622 * tau[1];
  t3628 = t801 * t1168 * t296;
  t3631 = t316 * t2984 * tau[1];
  t3633 = t316 * t997;
  t3635 = -0.6e1 * t3608 - 0.3e2 * t3611 + 0.26e2 * t1259 + 0.18e2 * t3614 + 0.6e2 * t3616 - 0.39e2 * t1238 - 0.96e3 * t3620 - 0.24e4 * t3624 + 0.104e4 * t1262 + 0.144e4 * t3628 + 0.336e4 * t3631 - 0.1248e4 * t3633;
  t3636 = t151 * t3635;
  t3638 = t1016 * t420;
  t3641 = t386 * t1144;
  t3644 = t335 * t1333;
  t3648 = t2952 * t132;
  t3649 = t3648 * tau[1];
  t3654 = -0.13e2 / 0.3e1 * t3296 + 0.1e2 / 0.3e1 * t3649 - 0.2e1 * t3608 - 0.1e2 * t3611 + 0.26e2 / 0.3e1 * t1259;
  t3655 = t151 * t3654;
  t3658 = t1016 * t433;
  t3664 = t1144 * t120;
  t3665 = t3664 * t1320;
  t3668 = t420 * t296;
  t3669 = t3668 * t1320;
  t3674 = t1183 * t120;
  t3675 = t3674 * t1320;
  t3678 = t124 * t286;
  t3679 = t1319 * t3678;
  t3682 = t1337 * t3678;
  t3685 = 0.6e1 * t2585 * t1321 + 0.6e1 * t3286 * t1321 - 0.3e1 * t2595 * t1338 + 0.6e1 * t2541 * t3590 + 0.6e1 * t2541 * t3594 + 0.3e1 * t290 * t3638 + 0.3e1 * t290 * t3641 + 0.3e1 * t290 * t3644 + 0.3e1 * t290 * t3655 - 0.6e1 * t2923 * t3601 - t308 * t3604 - t308 * t3606 - t308 * t3636 - t308 * t3658 - 0.6e1 * t3597 * t3598 + 0.6e1 * t955 * t3665 + 0.6e1 * t955 * t3669 - 0.3e1 * t960 * t3675 - 0.16e2 * t955 * t3679 + 0.8e1 * t960 * t3682;
  t3686 = t433 * t296;
  t3687 = t3686 * t1320;
  t3732 = t2104 * t421;
  t3735 = t737 * t421;
  t3738 = t2104 * t434;
  t3741 = t2120 * t434;
  t3744 = t742 * t434;
  t3747 = -0.3e1 * t742 * t421 * t1004 + 0.2e1 * t780 * t434 * t1004 - 0.3e1 * t742 * t1127 * t381 - 0.3e1 * t742 * t1145 * t381 + 0.2e1 * t780 * t1154 * t381 + 0.2e1 * t780 * t1184 * t381 + 0.6e1 * t737 * t1327 * t302 - 0.3e1 * t742 * t1327 * t326 + 0.6e1 * t737 * t1334 * t302 - 0.3e1 * t742 * t1334 * t326 - 0.3e1 * t742 * t1344 * t302 + 0.2e1 * t780 * t1344 * t326 - 0.3e1 * t742 * t1355 * t302 + 0.2e1 * t780 * t1355 * t326 - 0.3e1 * t960 * t3687 - 0.6e1 * t3732 * t962 + 0.2e2 * t3735 * t973 - 0.6e1 * t3738 * t957 + 0.6e1 * t3741 * t962 - 0.1e2 * t3744 * t973;
  t3748 = t3685 + t3747;
  t3753 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1357 - t3576 - 0.3e1 / 0.8e1 * t6 * t102 * t3748);
  tv3rhosigmatau11 = t7 * t3753 + t1361;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3760 = t6 * t172 * t1401 / 0.8e1;
  t3763 = t1363 * t224;
  t3766 = t233 * t1362;
  t3769 = t397 * t1054;
  t3772 = t396 * t409;
  t3773 = t3772 * t200;
  t3776 = t3772 * t224;
  t3795 = t233 * t1377;
  t3799 = 0.1e1 / t847;
  t3800 = t3799 * t67;
  t3803 = t2318 * t1370;
  t3805 = t3799 * tau[0];
  t3806 = t1532 * t3805;
  t3809 = t1370 * t194;
  t3810 = t1532 * t3809;
  t3812 = t1541 * t3805;
  t3815 = 0.8e2 / 0.3e1 * t1287 - 0.8e2 / 0.3e1 * t3800 * tau[0] + 0.32e2 * t3803 + 0.16e3 * t3806 - 0.32e3 / 0.3e1 * t1288 - 0.48e2 * t3810 - 0.16e3 * t3812 + 0.8e2 * t1304;
  t3816 = t86 * t3815;
  t3825 = t233 * t1381;
  t3837 = t233 * t1398;
  t3854 = t219 * t3799;
  t3862 = t573 * t3799;
  t3870 = t1560 * t3799;
  t3876 = 0.768e4 * t1551 * t1389 * t194 - 0.2304e5 * t562 * t1392 * t194 + 0.16128e5 * t214 * t1395 * t194 - 0.5376e5 * t214 * t3862 * tau[0] + 0.192e5 * t562 * t3854 * tau[0] + 0.3584e5 * t72 * t3870 * tau[0] - 0.32e3 * t557 * t1043 - 0.896e4 * t72 * t1086 + 0.8e3 * t1515 * t3805 + 0.288e3 * t1541 * t3809 - 0.16e3 * t1288 + 0.48e3 * t1304 - 0.64e4 * t1307 + 0.1536e5 * t1309 + 0.48e2 * t3803 + 0.24e3 * t3806 - 0.288e3 * t3810 - 0.96e3 * t3812;
  t3877 = t86 * t3876;
  t3879 = 0.4e1 * t541 * t410 * t1093 - 0.3e1 * t503 * t1378 * t224 - 0.6e1 * t1629 * t1382 * t224 + 0.6e1 * t1685 * t1382 * t200 - 0.3e1 * t503 * t1399 * t200 + 0.2e1 * t541 * t1399 * t224 + 0.3e1 * t188 * t3795 + 0.3e1 * t188 * t3816 - t206 * t3837 - t206 * t3877 + 0.2e1 * t541 * t3825;
  t3880 = -0.6e1 * t503 * t1037 * t409 - 0.6e1 * t503 * t1055 * t409 - 0.6e1 * t503 * t397 * t1093 + 0.6e1 * t498 * t1378 * t200 + 0.6e1 * t3108 * t1363 - 0.6e1 * t1650 * t3763 + 0.12e2 * t2253 * t3776 - 0.12e2 * t2694 * t3773 + 0.6e1 * t498 * t3766 + 0.12e2 * t498 * t3769 + t3879;
  t3885 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1401 - t3760 - 0.3e1 / 0.8e1 * t6 * t28 * t3880);
  tv3rhotau20 = t7 * t3885 + t1405;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3892 = t6 * t251 * t1445 / 0.8e1;
  t3894 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1445 - t3892);
  tv3rhotau22 = t7 * t3894 + t1449;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3900 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1401 - t3760);
  tv3rhotau23 = t7 * t3900 + t1405;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3907 = t1407 * t326;
  t3910 = t335 * t1406;
  t3913 = t421 * t1144;
  t3916 = t420 * t433;
  t3917 = t3916 * t302;
  t3920 = t3916 * t326;
  t3939 = t335 * t1421;
  t3943 = 0.1e1 / t945;
  t3944 = t3943 * t132;
  t3947 = t2562 * t1414;
  t3949 = t3943 * tau[1];
  t3950 = t2017 * t3949;
  t3953 = t1414 * t296;
  t3954 = t2017 * t3953;
  t3956 = t2026 * t3949;
  t3959 = 0.8e2 / 0.3e1 * t1330 - 0.8e2 / 0.3e1 * t3944 * tau[1] + 0.32e2 * t3947 + 0.16e3 * t3950 - 0.32e3 / 0.3e1 * t1331 - 0.48e2 * t3954 - 0.16e3 * t3956 + 0.8e2 * t1347;
  t3960 = t151 * t3959;
  t3969 = t335 * t1425;
  t3981 = t335 * t1442;
  t3998 = t321 * t3943;
  t4006 = t812 * t3943;
  t4014 = t2012 * t3943;
  t4020 = 0.3584e5 * t137 * t4014 * tau[1] + 0.768e4 * t2034 * t1433 * t296 - 0.2304e5 * t801 * t1436 * t296 + 0.16128e5 * t316 * t1439 * t296 - 0.5376e5 * t316 * t4006 * tau[1] + 0.192e5 * t801 * t3998 * tau[1] - 0.32e3 * t796 * t1133 - 0.896e4 * t137 * t1176 + 0.8e3 * t2002 * t3949 + 0.288e3 * t2026 * t3953 - 0.16e3 * t1331 + 0.48e3 * t1347 - 0.64e4 * t1350 + 0.1536e5 * t1352 + 0.48e2 * t3947 + 0.24e3 * t3950 - 0.288e3 * t3954 - 0.96e3 * t3956;
  t4021 = t151 * t4020;
  t4023 = 0.4e1 * t780 * t434 * t1183 - 0.3e1 * t742 * t1422 * t326 - 0.6e1 * t2096 * t1426 * t326 + 0.6e1 * t2120 * t1426 * t302 - 0.3e1 * t742 * t1443 * t302 + 0.2e1 * t780 * t1443 * t326 + 0.3e1 * t290 * t3939 + 0.3e1 * t290 * t3960 - t308 * t3981 - t308 * t4021 + 0.2e1 * t780 * t3969;
  t4024 = -0.6e1 * t742 * t1127 * t433 - 0.6e1 * t742 * t1145 * t433 - 0.6e1 * t742 * t421 * t1183 + 0.6e1 * t737 * t1422 * t302 + 0.6e1 * t3285 * t1407 - 0.6e1 * t2104 * t3907 + 0.12e2 * t2541 * t3920 - 0.12e2 * t2923 * t3917 + 0.6e1 * t737 * t3910 + 0.12e2 * t737 * t3913 + t4023;
  t4029 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1445 - t3892 - 0.3e1 / 0.8e1 * t6 * t102 * t4024);
  tv3rhotau25 = t7 * t4029 + t1449;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4033 = t39 * t1223;
  t4034 = t189 * t4033;
  t4037 = t1642 * t1518;
  t4038 = t1640 * t4037;
  t4040 = t362 * t1211;
  t4043 = t1228 * t357;
  t4046 = t362 * t1223;
  t4050 = t75 * t1518;
  t4051 = t1551 * t4050;
  t4053 = -0.3e1 / 0.32e2 * t3127 - 0.15e2 * t4051;
  t4054 = t86 * t4053;
  t4058 = t1532 * t1518;
  t4061 = t3119 * t357;
  t4064 = t188 * t1228;
  t4071 = t1211 * t357;
  t4072 = t86 * t4071;
  t4080 = 0.125e3 / 0.25509168e8 * t1668 * t4037 - 0.125e3 / 0.25509168e8 * t4038;
  t4082 = t529 * t357;
  t4083 = t525 * t4082;
  t4086 = t1518 * t79;
  t4090 = t39 * t1211;
  t4091 = t189 * t4090;
  t4094 = -0.18e2 * t3158 * t1201 - 0.9e1 * t862 * t4034 + 0.125e3 / 0.25509168e8 * t4038 + 0.6e1 * t541 * t4040 - 0.3e1 * t206 * t4043 - 0.3e1 * t206 * t4046 - t206 * t4054 + 0.18e2 * t3155 * t1197 - 0.9e1 / 0.4e1 * t857 * t4058 + 0.9e1 / 0.8e1 * t862 * t4061 + 0.9e1 * t4064 * t349 - 0.9e1 / 0.8e1 * t188 * t362 * t529 * t59 - 0.6e1 * t1629 * t4072 + 0.6e1 * t541 * t358 * t1223 + t80 * t4080 - 0.18e2 * t2694 * t4083 + 0.6e1 * t1515 * t4086 * t86 + 0.18e2 * t2253 * t4091;
  t4098 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4094);
  tv3sigma30 = t7 * t4098;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4099 = t1642 * t2004;
  t4101 = t1963 * t4099;
  t4103 = 0.125e3 / 0.25509168e8 * t1942 * t4099 - 0.125e3 / 0.25509168e8 * t4101;
  t4105 = t2004 * t144;
  t4109 = t107 * t1252;
  t4110 = t291 * t4109;
  t4113 = t768 * t381;
  t4114 = t764 * t4113;
  t4119 = t107 * t1264;
  t4120 = t291 * t4119;
  t4124 = t386 * t1252;
  t4127 = t1269 * t381;
  t4130 = t386 * t1264;
  t4134 = t140 * t2004;
  t4135 = t2034 * t4134;
  t4137 = -0.3e1 / 0.32e2 * t3278 - 0.15e2 * t4135;
  t4138 = t151 * t4137;
  t4142 = t2017 * t2004;
  t4145 = t3296 * t381;
  t4148 = t290 * t1269;
  t4158 = t1252 * t381;
  t4159 = t151 * t4158;
  t4162 = t145 * t4103 + 0.6e1 * t2002 * t4105 * t151 + 0.18e2 * t2541 * t4110 - 0.18e2 * t2923 * t4114 - 0.18e2 * t3323 * t1242 - 0.9e1 * t960 * t4120 + 0.125e3 / 0.25509168e8 * t4101 + 0.6e1 * t780 * t4124 - 0.3e1 * t308 * t4127 - 0.3e1 * t308 * t4130 - t308 * t4138 + 0.18e2 * t3320 * t1238 - 0.9e1 / 0.4e1 * t955 * t4142 + 0.9e1 / 0.8e1 * t960 * t4145 + 0.9e1 * t4148 * t373 + 0.6e1 * t780 * t382 * t1264 - 0.9e1 / 0.8e1 * t290 * t386 * t768 * t124 - 0.6e1 * t2096 * t4159;
  t4166 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4162);
  tv3sigma39 = t7 * t4166;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4195 = t1290 * t52;
  t4196 = t4195 * t1277;
  t4201 = -0.6e1 * t503 * t1284 * t357 - 0.6e1 * t503 * t1291 * t357 - 0.3e1 * t503 * t397 * t1223 + 0.3e1 / 0.4e1 * t188 * t86 * t2730 * t67 + 0.4e1 * t541 * t1301 * t357 + 0.4e1 * t541 * t1312 * t357 + 0.2e1 * t541 * t410 * t1223 - 0.12e2 * t3545 * t1201 + 0.12e2 * t3554 * t1201 + 0.12e2 * t3155 * t1278 + 0.12e2 * t857 * t4196 - 0.6e1 * t3158 * t1295;
  t4202 = t1311 * t52;
  t4203 = t4202 * t1277;
  t4206 = t1228 * t409;
  t4208 = t362 * t1311;
  t4212 = t1532 * t2730;
  t4214 = t75 * t2730;
  t4215 = t1551 * t4214;
  t4217 = t562 * t3469;
  t4219 = 0.3e1 / 0.4e1 * t3502 - 0.9e1 / 0.4e1 * t4212 + 0.12e3 * t4215 - 0.18e3 * t4217;
  t4220 = t86 * t4219;
  t4222 = t1228 * t396;
  t4225 = t362 * t1290;
  t4228 = t396 * t529;
  t4229 = t4228 * t59;
  t4235 = t409 * t529;
  t4236 = t4235 * t59;
  t4242 = t79 * t86;
  t4243 = t4242 * t396;
  t4246 = t409 * t53;
  t4247 = t209 * t529;
  t4248 = t4246 * t4247;
  t4251 = -0.6e1 * t862 * t4203 - t206 * t4206 - 0.2e1 * t206 * t4208 - t206 * t4220 + 0.3e1 * t188 * t4222 + 0.6e1 * t188 * t4225 - 0.3e1 / 0.4e1 * t857 * t4229 + 0.6e1 * t1685 * t397 * t1211 + 0.3e1 / 0.8e1 * t862 * t4236 - 0.6e1 * t1629 * t410 * t1211 + 0.6e1 * t1197 * t4243 - 0.6e1 * t2694 * t4248;
  t4252 = t4201 + t4251;
  t4256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4252);
  tv3sigma2tau0 = t7 * t4256;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4257 = t1269 * t420;
  t4260 = t386 * t1333;
  t4263 = t1269 * t433;
  t4265 = t386 * t1354;
  t4269 = t2017 * t2952;
  t4271 = t140 * t2952;
  t4272 = t2034 * t4271;
  t4274 = t801 * t3622;
  t4276 = 0.3e1 / 0.4e1 * t3648 - 0.9e1 / 0.4e1 * t4269 + 0.12e3 * t4272 - 0.18e3 * t4274;
  t4277 = t151 * t4276;
  t4279 = t433 * t768;
  t4280 = t4279 * t124;
  t4286 = t420 * t768;
  t4287 = t4286 * t124;
  t4302 = 0.3e1 * t290 * t4257 + 0.6e1 * t290 * t4260 - t308 * t4263 - 0.2e1 * t308 * t4265 - t308 * t4277 + 0.3e1 / 0.8e1 * t960 * t4280 - 0.6e1 * t2096 * t434 * t1252 - 0.3e1 / 0.4e1 * t955 * t4287 + 0.6e1 * t2120 * t421 * t1252 + 0.4e1 * t780 * t1344 * t381 + 0.4e1 * t780 * t1355 * t381 + 0.2e1 * t780 * t434 * t1264;
  t4322 = t1333 * t120;
  t4323 = t4322 * t1320;
  t4328 = t1354 * t120;
  t4329 = t4328 * t1320;
  t4332 = t144 * t151;
  t4333 = t4332 * t420;
  t4336 = t433 * t121;
  t4337 = t311 * t768;
  t4338 = t4336 * t4337;
  t4341 = -0.6e1 * t742 * t1327 * t381 - 0.6e1 * t742 * t1334 * t381 - 0.3e1 * t742 * t421 * t1264 + 0.3e1 / 0.4e1 * t290 * t151 * t2952 * t132 + 0.12e2 * t3741 * t1242 - 0.12e2 * t3732 * t1242 + 0.12e2 * t3320 * t1321 + 0.12e2 * t955 * t4323 - 0.6e1 * t3323 * t1338 - 0.6e1 * t960 * t4329 + 0.6e1 * t1238 * t4333 - 0.6e1 * t2923 * t4338;
  t4342 = t4302 + t4341;
  t4346 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4342);
  tv3sigma2tau11 = t7 * t4346;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4347 = t4242 * t1362;
  t4350 = t1363 * t357;
  t4353 = t362 * t1362;
  t4356 = t397 * t1290;
  t4361 = t3772 * t357;
  t4373 = t1377 * t52;
  t4374 = t4373 * t1277;
  t4381 = t362 * t1377;
  t4385 = t1532 * t3799;
  t4387 = -0.4e1 * t3800 + 0.6e1 * t4385;
  t4388 = t86 * t4387;
  t4391 = t1381 * t52;
  t4392 = t4391 * t1277;
  t4398 = t362 * t1381;
  t4404 = t1398 * t52;
  t4405 = t4404 * t1277;
  t4411 = t362 * t1398;
  t4415 = t1541 * t3799;
  t4417 = t75 * t3799;
  t4418 = t1551 * t4417;
  t4420 = t562 * t3854;
  t4422 = t214 * t3862;
  t4424 = -0.6e1 * t3800 + 0.36e2 * t4385 - 0.36e2 * t4415 - 0.96e3 * t4418 + 0.288e4 * t4420 - 0.2016e4 * t4422;
  t4425 = t86 * t4424;
  t4427 = 0.4e1 * t541 * t410 * t1311 - 0.3e1 * t503 * t1378 * t357 - 0.6e1 * t1629 * t1382 * t357 + 0.2e1 * t541 * t1399 * t357 + 0.3e1 * t188 * t4381 + 0.3e1 * t188 * t4388 - t206 * t4411 - t206 * t4425 + 0.6e1 * t2253 * t4392 + 0.2e1 * t541 * t4398 - 0.3e1 * t862 * t4405;
  t4428 = -0.6e1 * t503 * t1284 * t409 - 0.6e1 * t503 * t1291 * t409 - 0.6e1 * t503 * t397 * t1311 - 0.12e2 * t3545 * t1295 - 0.6e1 * t1650 * t4350 + 0.12e2 * t2253 * t4361 + 0.6e1 * t349 * t4347 + 0.6e1 * t498 * t4353 + 0.12e2 * t498 * t4356 + 0.6e1 * t857 * t4374 + t4427;
  t4432 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4428);
  tv3sigmatau20 = t7 * t4432;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4433 = t4332 * t1406;
  t4436 = t1407 * t381;
  t4439 = t386 * t1406;
  t4442 = t421 * t1333;
  t4447 = t3916 * t381;
  t4459 = t1421 * t120;
  t4460 = t4459 * t1320;
  t4467 = t386 * t1421;
  t4471 = t2017 * t3943;
  t4473 = -0.4e1 * t3944 + 0.6e1 * t4471;
  t4474 = t151 * t4473;
  t4477 = t1425 * t120;
  t4478 = t4477 * t1320;
  t4484 = t386 * t1425;
  t4490 = t1442 * t120;
  t4491 = t4490 * t1320;
  t4497 = t386 * t1442;
  t4501 = t2026 * t3943;
  t4503 = t140 * t3943;
  t4504 = t2034 * t4503;
  t4506 = t801 * t3998;
  t4508 = t316 * t4006;
  t4510 = -0.6e1 * t3944 + 0.36e2 * t4471 - 0.36e2 * t4501 - 0.96e3 * t4504 + 0.288e4 * t4506 - 0.2016e4 * t4508;
  t4511 = t151 * t4510;
  t4513 = 0.4e1 * t780 * t434 * t1354 - 0.3e1 * t742 * t1422 * t381 - 0.6e1 * t2096 * t1426 * t381 + 0.2e1 * t780 * t1443 * t381 + 0.6e1 * t2541 * t4478 + 0.3e1 * t290 * t4467 + 0.3e1 * t290 * t4474 - t308 * t4497 - t308 * t4511 + 0.2e1 * t780 * t4484 - 0.3e1 * t960 * t4491;
  t4514 = -0.6e1 * t742 * t1327 * t433 - 0.6e1 * t742 * t1334 * t433 - 0.6e1 * t742 * t421 * t1354 - 0.12e2 * t3732 * t1338 - 0.6e1 * t2104 * t4436 + 0.12e2 * t2541 * t4447 + 0.6e1 * t373 * t4433 + 0.6e1 * t737 * t4439 + 0.12e2 * t737 * t4442 + 0.6e1 * t955 * t4460 + t4513;
  t4518 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4514);
  tv3sigmatau28 = t7 * t4518;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4519 = t1362 * t396;
  t4520 = t4519 * t79;
  t4523 = t1363 * t409;
  t4526 = t397 * t1377;
  t4538 = 0.1e1 / t527;
  t4540 = 0.48e2 * t4538 * t67;
  t4541 = t1532 * t4538;
  t4543 = t1541 * t4538;
  t4545 = t4540 - 0.144e3 * t4541 + 0.96e2 * t4543;
  t4546 = t86 * t4545;
  t4549 = t1381 * t409;
  t4550 = t86 * t4549;
  t4560 = t75 * t4538;
  t4563 = t219 * t4538;
  t4566 = t573 * t4538;
  t4569 = t1560 * t4538;
  t4572 = -0.48e3 * t1515 * t4538 + 0.768e4 * t1551 * t4560 + 0.48384e5 * t214 * t4566 - 0.3456e5 * t562 * t4563 - 0.21504e5 * t72 * t4569 + t4540 - 0.432e3 * t4541 + 0.864e3 * t4543;
  t4573 = t86 * t4572;
  t4575 = -0.9e1 * t503 * t1378 * t409 + 0.18e2 * t1685 * t397 * t1381 - 0.9e1 * t503 * t397 * t1398 + 0.6e1 * t541 * t410 * t1398 - 0.6e1 * t1629 * t4550 - 0.18e2 * t1650 * t4523 + 0.3e1 * t188 * t4546 - t206 * t4573 + 0.6e1 * t4520 * t86 + 0.18e2 * t498 * t4526;
  t4579 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4575);
  tv3tau30 = t7 * t4579;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4580 = t1406 * t420;
  t4581 = t4580 * t144;
  t4584 = t1407 * t433;
  t4587 = t421 * t1421;
  t4599 = 0.1e1 / t766;
  t4601 = 0.48e2 * t4599 * t132;
  t4602 = t2017 * t4599;
  t4604 = t2026 * t4599;
  t4606 = t4601 - 0.144e3 * t4602 + 0.96e2 * t4604;
  t4607 = t151 * t4606;
  t4610 = t1425 * t433;
  t4611 = t151 * t4610;
  t4621 = t140 * t4599;
  t4624 = t321 * t4599;
  t4627 = t812 * t4599;
  t4630 = t2012 * t4599;
  t4633 = -0.21504e5 * t137 * t4630 - 0.48e3 * t2002 * t4599 + 0.768e4 * t2034 * t4621 + 0.48384e5 * t316 * t4627 - 0.3456e5 * t801 * t4624 + t4601 - 0.432e3 * t4602 + 0.864e3 * t4604;
  t4634 = t151 * t4633;
  t4636 = -0.9e1 * t742 * t1422 * t433 + 0.18e2 * t2120 * t421 * t1425 - 0.9e1 * t742 * t421 * t1442 + 0.6e1 * t780 * t434 * t1442 + 0.6e1 * t4581 * t151 - 0.6e1 * t2096 * t4611 - 0.18e2 * t2104 * t4584 + 0.3e1 * t290 * t4607 - t308 * t4634 + 0.18e2 * t737 * t4587;
  t4640 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4636);
  tv3tau33 = t7 * t4640;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t795, t796, t801, t802, t805, t811, t812;
  double t813, t820, t825, t826, t831, t833, t838, tv2rho22;
  double t846, t847, t849, t851, t853, t854, t856, t857;
  double t858, t859, t862, t863, t864, t867, t870, t871;
  double t874, t875, t878, t887, t889, t890, t892, t894;
  double t897, t899, t901, t903, t904, t906, t907, t909;
  double t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934, tv2rhosigma2;
  double t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951, t952;
  double t954, t955, t956, t957, t960, t961, t962, t965;
  double t968, t969, t972, t973, t976, t985, t987, t988;
  double t990, t992, t995, t997, t999, t1001, t1002, t1004;
  double t1005, t1007, t1010, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  double t1453, t1454, t1457, t1460, t1461, t1462, t1465, t1469;
  double t1470, t1474, t1476, t1481, t1483, t1486, t1492, t1493;
  double t1496, t1498, t1501, t1503, t1506, t1509, t1512, t1515;
  double t1516, t1517, t1518, t1519, t1522, t1525, t1528, t1529;
  double t1532, t1533, t1534, t1537, t1538, t1541, t1542, t1543;
  double t1546, t1551, t1552, t1560, t1561, t1571, t1580, t1583;
  double t1588, t1589, t1591, t1592, t1595, t1601, t1606, t1623;
  double t1624, t1627, t1628, t1629, t1630, t1631, t1638, t1640;
  double t1641, t1642, t1643, t1644, t1645, t1646, t1647, t1649;
  double t1650, t1666, t1668, t1672, t1673, t1676, t1680, t1682;
  double t1683, t1685, t1689, t1690, t1695, t1697, t1698, t1701;
  double t1704, t1707, t1711, t1712, t1716, t1718, t1720, t1722;
  double t1724, t1727, t1729, tv3rho30, t1732, t1733, t1734, t1737;
  double t1742, t1743, t1745, t1749, t1750, t1754, t1757, t1761;
  double t1763, t1767, t1776, t1777, t1778, t1781, t1786, t1788;
  double t1792, t1793, t1797, t1800, t1801, t1803, t1812, t1814;
  double t1817, tv3rho31, t1820, t1825, t1829, t1833, t1834, t1838;
  double t1840, t1849, t1850, t1855, t1859, t1863, t1864, t1868;
  double t1870, t1877, t1885, t1887, t1888, tv3rho32, t1893, t1900;
  double t1904, t1905, t1912, t1913, t1920, t1924, t1925, t1940;
  double t1942, t1943, t1944, t1945, t1946, t1947, t1948, t1952;
  double t1953, t1957, t1958, t1961, t1963, t1965, t1967, t1969;
  double t1970, t1972, t1975, t1978, t1979, t1980, t1989, t1993;
  double t1996, t1999, t2002, t2003, t2004, t2005, t2008, t2012;
  double t2013, t2017, t2018, t2019, t2022, t2023, t2026, t2029;
  double t2034, t2041, t2044, t2051, t2052, t2054, t2055, t2058;
  double t2064, t2069, t2086, t2087, t2090, t2094, t2095, t2096;
  double t2097, t2098, t2104, t2120, t2124, t2125, t2130, tv3rho33;
  double t2138, t2145, t2147, t2149, t2155, t2157, t2159, t2162;
  double t2164, t2165, t2166, t2168, t2169, t2171, t2172, t2174;
  double t2175, t2177, t2178, t2180, t2183, t2185, t2188, t2191;
  double t2193, t2195, t2197, t2199, t2201, t2202, t2204, t2205;
  double t2207, t2210, t2222, t2238, t2240, t2241, t2243, t2244;
  double t2246, t2253, t2254, t2255, t2258, t2259, t2262, t2265;
  double t2267, t2268, t2273, t2276, t2277, t2282, t2287, t2288;
  double t2291, t2292, t2295, t2298, t2301, t2303, t2305, t2306;
  double t2307, t2316, t2318, t2319, t2322, t2325, t2328, t2331;
  double t2332, t2335, t2338, t2339, t2340, t2341, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2352, t2355, t2357, t2362;
  double tv3rho2sigma0, tv3rho2sigma1, t2369, t2373, t2375, tv3rho2sigma2, t2381, t2389;
  double tv3rho2sigma3, tv3rho2sigma4, t2395, t2402, t2405, tv3rho2sigma5, t2413, tv3rho2sigma6;
  double tv3rho2sigma7, t2424, t2427, t2435, t2437, t2440, t2442, t2443;
  double t2444, t2446, t2447, t2449, t2450, t2452, t2453, t2455;
  double t2456, t2458, t2461, t2463, t2466, t2469, t2471, t2473;
  double t2475, t2477, t2479, t2480, t2482, t2483, t2485, t2497;
  double t2498, t2500, t2504, t2506, t2507, t2509, t2530, t2535;
  double t2537, t2538, t2541, t2542, t2543, t2546, t2549, t2553;
  double t2555, t2556, t2557, t2562, t2563, t2566, t2569, t2572;
  double t2573, t2576, t2577, t2578, t2581, t2582, t2585, t2588;
  double t2591, t2592, t2595, t2598, t2601, t2602, t2605, t2606;
  double t2607, t2608, t2611, t2612, t2613, t2614, t2617, t2618;
  double t2619, t2628, t2630, t2632, t2637, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2644, t2651, t2653, t2681;
  double t2690, t2694, t2695, t2696, t2705, t2706, t2712, t2714;
  double t2724, t2727, t2728, t2730, t2731, t2732, t2738, t2742;
  double t2743, t2744, t2752, t2759, t2765, t2782, t2786, t2787;
  double t2788, t2790, t2793, t2812, t2813, t2816, t2817, t2822;
  double tv3rho2tau0, t2829, t2833, t2835, tv3rho2tau1, t2841, t2849, tv3rho2tau2;
  double t2855, t2862, t2865, tv3rho2tau3, t2873, tv3rho2tau4, t2910, t2919;
  double t2923, t2924, t2925, t2934, t2935, t2941, t2944, t2952;
  double t2953, t2958, t2960, t2961, t2962, t2965, t2966, t2968;
  double t2972, t2973, t2976, t2978, t2984, t2991, t3004, t3018;
  double t3034, t3041, t3042, t3043, t3045, t3046, t3051, tv3rho2tau5;
  double t3058, t3063, t3065, t3081, t3082, t3083, t3084, t3086;
  double t3101, t3103, t3108, t3109, t3114, t3119, t3120, t3123;
  double t3126, t3127, t3128, t3131, t3132, t3135, t3136, t3139;
  double t3142, t3143, t3148, t3151, t3152, t3155, t3158, t3164;
  double t3169, t3172, t3175, t3178, t3180, t3182, t3184, t3187;
  double t3189, t3191, t3193, t3194, t3196, t3197, t3199, t3202;
  double t3203, t3204, t3207, t3208, t3211, t3213, t3218, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3225, t3227, tv3rhosigma25, t3233;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t3251, t3253, t3254;
  double t3255, t3256, t3257, t3259, t3278, t3279, t3282, t3285;
  double t3286, t3291, t3296, t3297, t3300, t3303, t3304, t3307;
  double t3308, t3313, t3316, t3317, t3320, t3323, t3328, t3329;
  double t3332, t3333, t3337, t3340, t3343, t3345, t3347, t3349;
  double t3352, t3354, t3356, t3358, t3359, t3361, t3362, t3364;
  double t3369, t3372, t3375, t3376, t3377, t3380, t3381, t3388;
  double t3390, t3392, t3397, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3;
  double tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11;
  double t3404, t3411, t3412, t3415, t3416, t3419, t3420, t3423;
  double t3426, t3427, t3434, t3435, t3438, t3439, t3444, t3445;
  double t3448, t3449, t3452, t3455, t3457, t3458, t3461, t3463;
  double t3467, t3469, t3471, t3475, t3478, t3480, t3482, t3483;
  double t3485, t3487, t3489, t3491, t3494, t3495, t3498, t3502;
  double t3503, t3508, t3509, t3545, t3548, t3551, t3554, t3557;
  double t3563, t3564, t3569, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double t3576, t3578, tv3rhosigmatau5, t3584, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, t3589, t3590, t3593, t3594, t3597, t3598, t3601;
  double t3604, t3606, t3608, t3610, t3611, t3614, t3616, t3620;
  double t3622, t3624, t3628, t3631, t3633, t3635, t3636, t3638;
  double t3641, t3644, t3648, t3649, t3654, t3655, t3658, t3664;
  double t3665, t3668, t3669, t3674, t3675, t3678, t3679, t3682;
  double t3685, t3686, t3687, t3732, t3735, t3738, t3741, t3744;
  double t3747, t3748, t3753, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23;
  double tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5;
  double tv3rholapltau6, tv3rholapltau7, t3760, t3763, t3766, t3769, t3772, t3773;
  double t3776, t3795, t3799, t3800, t3803, t3805, t3806, t3809;
  double t3810, t3812, t3815, t3816, t3825, t3837, t3854, t3862;
  double t3870, t3876, t3877, t3879, t3880, t3885, tv3rhotau20, tv3rhotau21;
  double t3892, t3894, tv3rhotau22, t3900, tv3rhotau23, tv3rhotau24, t3907, t3910;
  double t3913, t3916, t3917, t3920, t3939, t3943, t3944, t3947;
  double t3949, t3950, t3953, t3954, t3956, t3959, t3960, t3969;
  double t3981, t3998, t4006, t4014, t4020, t4021, t4023, t4024;
  double t4029, tv3rhotau25, t4033, t4034, t4037, t4038, t4040, t4043;
  double t4046, t4050, t4051, t4053, t4054, t4058, t4061, t4064;
  double t4071, t4072, t4080, t4082, t4083, t4086, t4090, t4091;
  double t4094, t4098, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t4099, t4101, t4103, t4105, t4109;
  double t4110, t4113, t4114, t4119, t4120, t4124, t4127, t4130;
  double t4134, t4135, t4137, t4138, t4142, t4145, t4148, t4158;
  double t4159, t4162, t4166, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11;
  double t4195, t4196, t4201, t4202, t4203, t4206, t4208, t4212;
  double t4214, t4215, t4217, t4219, t4220, t4222, t4225, t4228;
  double t4229, t4235, t4236, t4242, t4243, t4246, t4247, t4248;
  double t4251, t4252, t4256, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4;
  double tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t4257, t4260;
  double t4263, t4265, t4269, t4271, t4272, t4274, t4276, t4277;
  double t4279, t4280, t4286, t4287, t4302, t4322, t4323, t4328;
  double t4329, t4332, t4333, t4336, t4337, t4338, t4341, t4342;
  double t4346, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4;
  double tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t4347;
  double t4350, t4353, t4356, t4361, t4373, t4374, t4381, t4385;
  double t4387, t4388, t4391, t4392, t4398, t4404, t4405, t4411;
  double t4415, t4417, t4418, t4420, t4422, t4424, t4425, t4427;
  double t4428, t4432, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, t4433, t4436, t4439, t4442, t4447, t4459;
  double t4460, t4467, t4471, t4473, t4474, t4477, t4478, t4484;
  double t4490, t4491, t4497, t4501, t4503, t4504, t4506, t4508;
  double t4510, t4511, t4513, t4514, t4518, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t4519, t4520;
  double t4523, t4526, t4538, t4540, t4541, t4543, t4545, t4546;
  double t4549, t4550, t4560, t4563, t4566, t4569, t4572, t4573;
  double t4575, t4579, tv3tau30, tv3tau31, tv3tau32, t4580, t4581, t4584;
  double t4587, t4599, t4601, t4602, t4604, t4606, t4607, t4610;
  double t4611, t4621, t4624, t4627, t4630, t4633, t4634, t4636;
  double t4640, tv3tau33;

  double t4644, t4646, t4652, t4655, t4658, t4665, t4666, t4671;
  double t4674, t4676, t4681, t4685, t4686, t4692, t4694, t4696;
  double t4698, t4700, t4706, t4710, t4750, t4754, t4764, t4768;
  double t4773, t4776, t4783, t4786, t4791, t4792, t4796, t4799;
  double t4802, t4805, t4807, t4810, t4813, t4819, t4826, t4848;
  double t4849, t4852, t4859, t4862, t4868, t4869, t4875, t4880;
  double t4881, t4888, t4921, t4938, t4945, t4962, t4966, t4972;
  double t4973, t4977, t4985, t4989, t4993, t4996, t5000, t5001;
  double t5003, t5004, t5010, t5016, t5017, t5020, t5024, t5033;
  double t5038, t5039, t5040, t5042, t5043, t5049, t5054, t5057;
  double t5061, t5068, t5072, t5076, t5081, t5083, tv4rho40, t5104;
  double t5105, t5107, t5111, t5120, t5126, t5127, t5129, t5141;
  double t5145, t5146, t5149, t5155, t5156, t5173, t5175, t5179;
  double t5186, t5190, t5191, t5194, t5203, t5206, t5207, t5209;
  double t5211, t5212, tv4rho41, t5227, t5240, t5244, t5253, t5266;
  double t5270, t5277, t5278, t5287, t5300, t5304, t5311, t5315;
  double t5324, t5327, t5338, t5341, t5343, t5344, tv4rho42, t5365;
  double t5369, t5376, t5387, t5388, t5405, t5409, t5416, t5424;
  double t5433, t5443, t5445, t5446, tv4rho43, t5451, t5456, t5463;
  double t5467, t5476, t5477, t5482, t5489, t5493, t5512, t5514;
  double t5516, t5517, t5519, t5520, t5527, t5528, t5533, t5535;
  double t5541, t5544, t5546, t5554, t5593, t5600, t5604, t5620;
  double t5622, t5625, t5632, t5635, t5641, t5644, t5647, t5650;
  double t5653, t5655, t5661, t5665, t5670, t5681, t5684, t5689;
  double t5690, t5693, t5697, t5716, t5717, t5724, t5727, t5732;
  double t5735, t5736, t5745, t5755, t5756, t5760, t5764, t5773;
  double t5807, t5818, t5825, t5839, t5840, tv4rho44, t5848, t5854;
  double t5857, t5864, t5866, t5869, t5891, t5903, t5907, t5916;
  double t5917, t5921, t5927, t5939, t5953, t5966, t5985, t5987;
  double t5994, t5995, t6000, t6014, t6025, t6027, t6061, t6088;
  double t6090, t6102, t6103, t6115, t6116, t6119, t6120, t6139;
  double t6160, t6174, t6188, t6220, t6226, t6231, t6232, t6246;
  double t6248, t6252, t6255, t6277, t6281, t6293, t6299, t6303;
  double t6317, t6325, t6332, t6338, t6349, t6357, tv4rho3sigma0, tv4rho3sigma1;
  double t6364, t6367, t6371, t6373, tv4rho3sigma2, t6375, t6381, t6386;
  double t6390, t6399, t6400, tv4rho3sigma3, tv4rho3sigma4, t6402, t6408, t6410;
  double t6419, t6421, t6424, tv4rho3sigma5, t6430, t6439, tv4rho3sigma6, tv4rho3sigma7;
  double t6445, t6452, t6460, t6462, t6463, tv4rho3sigma8, t6472, tv4rho3sigma9;
  double tv4rho3sigma10, t6509, t6512, t6525, t6528, t6536, t6537, t6540;
  double t6541, t6544, t6545, t6546, t6586, t6612, t6616, t6617;
  double t6624, t6632, t6636, t6641, t6661, t6665, t6691, t6693;
  double t6704, t6708, t6713, t6717, t6719, t6721, t6727, t6770;
  double t6782, t6814, t6815, t6819, t6836, t6837, t6845, t6860;
  double t6894, t6902, t6906, t6907, t6910, t6922, t6929, t6943;
  double t6952, t6959, t6968, t6976, tv4rho3sigma11, tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2;
  double tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7, t6983, t6989, t6992;
  double t6999, t7001, t7004, t7048, t7092, t7098, t7109, t7116;
  double t7129, t7143, t7148, t7150, t7151, t7154, t7155, t7156;
  double t7168, t7170, t7172, t7173, t7174, t7176, t7177, t7178;
  double t7189, t7214, t7218, t7230, t7244, t7275, t7293, t7318;
  double t7347, t7354, tv4rho3tau0, t7361, t7364, t7368, t7370, tv4rho3tau1;
  double t7372, t7378, t7383, t7387, t7396, t7397, tv4rho3tau2, t7399;
  double t7405, t7407, t7416, t7418, t7421, tv4rho3tau3, t7427, t7436;
  double tv4rho3tau4, t7442, t7449, t7457, t7459, t7460, tv4rho3tau5, t7469;
  double tv4rho3tau6, t7528, t7574, t7595, t7599, t7606, t7622, t7627;
  double t7644, t7645, t7646, t7648, t7649, t7650, t7656, t7657;
  double t7661, t7663, t7665, t7666, t7667, t7669, t7683, t7696;
  double t7716, t7720, t7732, t7767, t7785, t7810, t7827, t7834;
  double tv4rho3tau7, t7841, t7848, t7850, t7863, t7884, t7902, t7910;
  double t7924, t7931, t7947, t7949, t7950, t7951, t7956, t7981;
  double t8026, t8037, t8058, t8070, t8073, t8077, t8079, t8097;
  double t8152, t8175, t8176, t8177, t8189, t8214, t8236, t8237;
  double t8243, t8254, t8269, t8284, t8296, t8297, t8300, t8303;
  double t8307, t8322, t8330, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24;
  double t8337, t8341, t8343, tv4rho2sigma25, t8349, t8357, tv4rho2sigma26, tv4rho2sigma27;
  double tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t8363, t8370, t8373, tv4rho2sigma211, t8381;
  double tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t8409, t8432, t8435;
  double t8440, t8457, t8458, t8474, t8476, t8489, t8498, t8502;
  double t8512, t8515, t8519, t8521, t8540, t8541, t8547, t8554;
  double t8558, t8559, t8560, t8564, t8630, t8645, t8649, t8689;
  double t8693, t8694, t8697, t8698, t8711, t8715, t8719, t8752;
  double t8754, t8804, t8861, t8869, tv4rho2sigma217, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2;
  double tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10;
  double tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, tv4rho2sigmalapl17, t8876;
  double t8883, t8885, t8894, t8933, t8988, t9041, t9056, t9062;
  double t9075, t9087, t9092, t9094, t9096, t9104, t9135, t9153;
  double t9163, t9178, t9185, t9192, t9199, t9219, t9222, t9229;
  double t9234, t9249, t9255, t9261, t9267, t9286, t9295, t9315;
  double t9354, t9365, t9370, t9378, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3;
  double tv4rho2sigmatau4, t9385, t9389, t9391, tv4rho2sigmatau5, t9397, t9405, tv4rho2sigmatau6;
  double tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t9411, t9418, t9421, tv4rho2sigmatau11;
  double t9429, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t9443, t9455;
  double t9462, t9471, t9475, t9494, t9497, t9548, t9598, t9605;
  double t9611, t9617, t9625, t9632, t9643, t9648, t9657, t9695;
  double t9748, t9760, t9797, t9803, t9806, t9808, t9811, t9812;
  double t9824, t9834, t9856, t9875, t9904, t9907, t9923, t9931;
  double tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26;
  double tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5;
  double tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t9938, t9945;
  double t9947, t9952, t9958, t9962, t9999, t10003, t10013, t10014;
  double t10017, t10019, t10022, t10023, t10027, t10029, t10030, t10031;
  double t10034, t10035, t10037, t10041, t10079, t10083, t10113, t10128;
  double t10145, t10166, t10213, t10265, t10272, tv4rho2tau20, tv4rho2tau21, t10279;
  double t10283, t10285, tv4rho2tau22, t10291, t10299, tv4rho2tau23, tv4rho2tau24, t10305;
  double t10312, t10315, tv4rho2tau25, t10323, tv4rho2tau26, tv4rho2tau27, t10379, t10431;
  double t10448, t10449, t10456, t10457, t10464, t10490, t10498, t10500;
  double t10502, t10520, t10523, t10526, t10528, t10530, t10532, t10541;
  double t10567, t10583, t10591, t10592, t10596, t10610, t10619, t10641;
  double t10650, t10657, tv4rho2tau28, t10664, t10698, t10712, t10718, t10720;
  double t10749, t10798, t10829, t10865, t10866, t10869, t10899, t10922;
  double t10929, t10934, t10935, t10943, t10966, t10974, tv4rhosigma30, tv4rhosigma31;
  double tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t10981;
  double t10983, tv4rhosigma39, t10989, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314;
  double tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t11043, t11053, t11080, t11116;
  double t11144, t11146, t11150, t11153, t11156, t11185, t11224, t11256;
  double t11270, t11283, t11284, t11292, t11295, t11303, tv4rhosigma319, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16;
  double tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, t11310;
  double t11334, t11345, t11358, t11375, t11378, t11384, t11393, t11402;
  double t11420, t11473, t11525, t11558, t11563, t11574, t11582, t11631;
  double t11635, t11642, t11653, t11660, t11678, t11685, t11686, t11701;
  double t11723, t11727, t11738, t11746, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3;
  double tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t11753;
  double t11755, tv4rhosigma2tau11, t11761, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16;
  double tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, t11772, t11778;
  double t11787, t11796, t11808, t11847, t11899, t11903, t11904, t11905;
  double t11918, t11926, t11933, t11946, t11959, t11973, t11986, t12017;
  double t12031, t12036, t12051, t12061, t12085, t12139, t12178, t12182;
  double t12193, t12201, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24;
  double tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212;
  double tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2;
  double tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10;
  double tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18;
  double tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t12208, t12210, t12212;
  double t12214, t12215, t12227, t12247, t12286, t12287, t12296, t12307;
  double t12323, t12372, t12414, t12454, t12497, t12505, t12509, t12516;
  double t12535, t12542, t12546, t12550, t12560, t12567, t12590, t12598;
  double tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27;
  double t12605, t12607, tv4rhosigmatau28, t12613, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212;
  double tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t12657, t12700, t12742, t12755;
  double t12764, t12775, t12778, t12824, t12848, t12855, t12867, t12869;
  double t12876, t12889, t12896, t12903, t12910, t12914, t12927, t12929;
  double t12931, t12932, t12973, t12993, t12999, t13007, tv4rhosigmatau217, tv4rholapl30;
  double tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0;
  double tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8;
  double tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24;
  double tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t13014;
  double t13015, t13022, t13026, t13036, t13043, t13053, t13054, t13058;
  double t13060, t13061, t13063, t13064, t13066, t13067, t13070, t13071;
  double t13073, t13082, t13086, t13094, t13102, t13116, t13120, t13123;
  double t13153, t13188, t13222, t13229, tv4rhotau30, tv4rhotau31, tv4rhotau32, t13236;
  double t13238, tv4rhotau33, t13244, tv4rhotau34, tv4rhotau35, tv4rhotau36, t13249, t13251;
  double t13252, t13254, t13255, t13257, t13258, t13261, t13262, t13264;
  double t13273, t13277, t13285, t13293, t13307, t13311, t13314, t13335;
  double t13342, t13346, t13350, t13357, t13364, t13371, t13387, t13422;
  double t13456, t13463, tv4rhotau37, t13469, t13471, t13520, t13567, t13571;
  double t13575, t13580, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45;
  double tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413;
  double t13630, t13631, t13633, t13680, t13684, t13691, t13696, tv4sigma414;
  double tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7;
  double tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15;
  double tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t13722, t13731, t13762, t13772;
  double t13816, t13865, t13871, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4;
  double tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12;
  double tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t13904, t13913;
  double t13945, t13951, t13991, t14040, t14046, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21;
  double tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29;
  double tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217;
  double tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7;
  double tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15;
  double tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23;
  double t14088, t14142, t14195, t14250, t14254, t14258, t14264, tv4sigma2tau20;
  double tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28;
  double tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216;
  double t14317, t14370, t14395, t14399, t14424, t14476, t14482, tv4sigma2tau217;
  double tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37;
  double tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3;
  double tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11;
  double tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21;
  double tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29;
  double tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217;
  double t14514, t14542, t14560, t14597, t14634, t14640, tv4sigmatau30, tv4sigmatau31;
  double tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39;
  double tv4sigmatau310, t14673, t14696, t14723, t14756, t14792, t14798, tv4sigmatau311;
  double tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2;
  double tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22;
  double tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31;
  double tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, t14808, t14815;
  double t14825, t14847, t14849, t14851, t14884, t14888, tv4tau40, tv4tau41;
  double tv4tau42, tv4tau43, t14889, t14899, t14918, t14941, t14943, t14945;
  double t14974, t14978, tv4tau44;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 - 0.2e1 * t308 * t335 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1010 = t386 * t326;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 - t308 * t1010 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1453 = 0.1e1 / t443 / t20;
  t1454 = t445 * t162;
  t1457 = t444 * t162;
  t1460 = t158 * t158;
  t1461 = 0.1e1 / t1460;
  t1462 = t17 * t1461;
  t1465 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t449 - 0.6e1 * t1462);
  t1469 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1454 + 0.4e1 / 0.3e1 * t1457 * t453 + 0.4e1 / 0.3e1 * t24 * t1465);
  t1470 = t1469 * t27;
  t1474 = t457 * t171;
  t1476 = t6 * t1474 * t88;
  t1481 = t165 * t470;
  t1483 = t6 * t1481 * t88;
  t1486 = t6 * t462 * t235;
  t1492 = 0.1e1 / t170 / t158;
  t1493 = t26 * t1492;
  t1496 = 0.5e1 / 0.36e2 * t6 * t1493 * t88;
  t1498 = t6 * t471 * t235;
  t1501 = t6 * t172 * t594;
  t1503 = t233 * t542;
  t1506 = t592 * t224;
  t1509 = t233 * t581;
  t1512 = t194 * t522;
  t1515 = t65 * t75;
  t1516 = t526 * tau[0];
  t1517 = t486 * t486;
  t1518 = 0.1e1 / t1517;
  t1519 = t1516 * t1518;
  t1522 = tau[0] * t494;
  t1525 = 0.1e1 / t37 / t527;
  t1528 = -0.44e3 / 0.27e2 * t1522 + 0.154e3 / 0.27e2 * sigma[0] * t1525;
  t1529 = t75 * t1528;
  t1532 = t52 * t209;
  t1533 = t510 * tau[0];
  t1534 = t1533 * t39;
  t1537 = t522 * tau[0];
  t1538 = t1537 * t39;
  t1541 = t53 * t556;
  t1542 = t194 * t526;
  t1543 = t1542 * t529;
  t1546 = t526 * t849;
  t1551 = params->b * t65;
  t1552 = t510 * t194;
  t1560 = 0.1e1 / t572 / t57;
  t1561 = t1560 * t1516;
  t1571 = t214 * t573;
  t1580 = t514 * t184;
  t1583 = t562 * t219;
  t1588 = 0.144e3 * t513 * t1512 + 0.2e5 / 0.9e1 * t1515 * t1519 + 0.384e3 * t214 * t1529 + 0.72e3 * t1532 * t1534 + 0.36e3 * t525 * t1538 + 0.24e4 * t1541 * t1543 - 0.64e4 / 0.3e1 * t557 * t1546 + 0.352e4 / 0.9e1 * t210 * t1522 + 0.768e4 * t1551 * t75 * t1552 + 0.576e4 * t562 * t215 * t522 + 0.896e6 / 0.9e1 * t72 * t1561 * t1518 + 0.48e2 * t1552 * t67 + 0.24e2 * t197 * t1528 + 0.1152e5 * t566 * t1538 + 0.1344e6 * t1571 * t1543 - 0.1792e6 / 0.3e1 * t72 * t574 * t849 + 0.5632e5 / 0.9e1 * t72 * t220 * t494 - 0.96e3 * t525 * t1580 + 0.576e5 * t1583 * t1534 - 0.3072e5 * t566 * t1580;
  t1589 = t86 * t1588;
  t1591 = t499 * t200;
  t1592 = t1591 * t79;
  t1595 = t233 * t499;
  t1601 = t233 * t535;
  t1606 = t510 * t67;
  t1623 = -0.24e2 * t870 * t522 - 0.8e2 * t1606 * t190 - 0.4e3 * t1532 * t1543 - 0.8e2 * t513 * t1538 + 0.64e3 / 0.3e1 * t513 * t1580 - 0.8e1 * t189 * t1528 - 0.4e4 / 0.9e1 * t1541 * t1519 + 0.16e4 / 0.3e1 * t525 * t1546 - 0.352e4 / 0.27e2 * t197 * t1522;
  t1624 = t86 * t1623;
  t1627 = t204 * t204;
  t1628 = 0.1e1 / t1627;
  t1629 = t64 * t1628;
  t1630 = t542 * t224;
  t1631 = t86 * t1630;
  t1638 = t177 * t177;
  t1640 = t176 / t1638;
  t1641 = t30 * t30;
  t1642 = 0.1e1 / t1641;
  t1643 = t484 * sigma[0];
  t1644 = t1642 * t1643;
  t1645 = t1517 * t182;
  t1646 = 0.1e1 / t1645;
  t1647 = t1644 * t1646;
  t1649 = 0.4e4 / 0.43046721e8 * t1640 * t1647;
  t1650 = t62 * t205;
  t1666 = t227 * t227;
  t1668 = t176 / t1666;
  t1672 = 0.1e1 / t36 / t1517;
  t1673 = t485 * t1672;
  t1676 = t181 * t1525;
  t1680 = 0.22e4 / 0.531441e6 * t481 * t1673;
  t1682 = 0.154e4 / 0.6561e4 * t180 * t1676;
  t1683 = -0.4e4 / 0.43046721e8 * t1668 * t1647 + 0.22e4 / 0.531441e6 * t587 * t1673 - 0.154e4 / 0.6561e4 * t230 * t1676 + t1649 - t1680 + t1682;
  t1685 = t63 * t540;
  t1689 = -0.18e2 * t1650 * t500 * t224 + 0.18e2 * t1685 * t201 * t542 + 0.18e2 * t498 * t201 * t535 - 0.9e1 * t503 * t201 * t581 - 0.18e2 * t503 * t507 * t224 - 0.9e1 * t503 * t536 * t224 + 0.6e1 * t541 * t225 * t581 + t80 * t1683 - t1649 + t1680 - t1682;
  t1690 = 0.9e1 * t188 * t592 * t200 + 0.6e1 * t541 * t1503 - 0.3e1 * t206 * t1506 - 0.3e1 * t206 * t1509 - t206 * t1589 + 0.6e1 * t1592 * t86 + 0.18e2 * t498 * t1595 + 0.9e1 * t188 * t1601 + 0.3e1 * t188 * t1624 - 0.6e1 * t1629 * t1631 + t1689;
  t1695 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t88 - 0.3e1 / 0.8e1 * t1476 - 0.9e1 / 0.8e1 * t6 * t458 * t235 + t1483 / 0.4e1 - 0.3e1 / 0.4e1 * t1486 - 0.9e1 / 0.8e1 * t6 * t166 * t594 - t1496 + t1498 / 0.4e1 - 0.3e1 / 0.8e1 * t1501 - 0.3e1 / 0.8e1 * t6 * t28 * t1690);
  t1697 = 0.1e1 / t600 / t97;
  t1698 = t602 * t243;
  t1701 = t601 * t243;
  t1704 = t94 * t1461;
  t1707 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t449 - 0.6e1 * t1704);
  t1711 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1698 + 0.4e1 / 0.3e1 * t1701 * t608 + 0.4e1 / 0.3e1 * t99 * t1707);
  t1712 = t1711 * t27;
  t1716 = t612 * t171;
  t1718 = t6 * t1716 * t153;
  t1720 = t246 * t470;
  t1722 = t6 * t1720 * t153;
  t1724 = t101 * t1492;
  t1727 = 0.5e1 / 0.36e2 * t6 * t1724 * t153;
  t1729 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t153 - 0.3e1 / 0.8e1 * t1718 + t1722 / 0.4e1 - t1727);
  tv3rho30 = 0.3e1 * t599 + 0.3e1 * t626 + t7 * (t1695 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1732 = 0.2e1 * t652;
  t1733 = 0.2e1 * t678;
  t1734 = t1453 * t260;
  t1737 = t444 * t633;
  t1742 = 0.2e1 * t449;
  t1743 = 0.6e1 * t1462;
  t1745 = my_piecewise5(t11, 0, t15, 0, t1742 - t1743);
  t1749 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1734 * t445 + 0.8e1 / 0.9e1 * t1737 * t162 + 0.4e1 / 0.9e1 * t629 * t453 + 0.4e1 / 0.3e1 * t24 * t1745);
  t1750 = t1749 * t27;
  t1754 = t637 * t171;
  t1757 = t6 * t1754 * t88 / 0.4e1;
  t1761 = t263 * t470;
  t1763 = t6 * t1761 * t88;
  t1767 = t6 * t642 * t235 / 0.4e1;
  t1776 = -0.3e1 / 0.8e1 * t6 * t1750 * t88 - t1757 - 0.3e1 / 0.4e1 * t6 * t638 * t235 + t1763 / 0.12e2 - t1767 - 0.3e1 / 0.8e1 * t6 * t264 * t594 - t1476 / 0.8e1 + t1483 / 0.6e1 - t1486 / 0.4e1 - t1496 + t1498 / 0.6e1 - t1501 / 0.8e1;
  t1777 = my_piecewise3(t2, 0, t1776);
  t1778 = t1697 * t271;
  t1781 = t601 * t657;
  t1786 = 0.6e1 * t1704;
  t1788 = my_piecewise5(t15, 0, t11, 0, -t1742 - t1786);
  t1792 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1778 * t602 + 0.8e1 / 0.9e1 * t1781 * t243 + 0.4e1 / 0.9e1 * t653 * t608 + 0.4e1 / 0.3e1 * t99 * t1788);
  t1793 = t1792 * t27;
  t1797 = t661 * t171;
  t1800 = t6 * t1797 * t153 / 0.4e1;
  t1801 = t274 * t470;
  t1803 = t6 * t1801 * t153;
  t1812 = t6 * t617 * t337 / 0.4e1;
  t1814 = t6 * t621 * t337;
  t1817 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t153 - t1800 + t1803 / 0.12e2 - t1718 / 0.8e1 + t1722 / 0.6e1 - t1727 - 0.3e1 / 0.8e1 * t6 * t613 * t337 - t1812 + t1814 / 0.12e2);
  tv3rho31 = t599 + t626 + t1732 + t1733 + t7 * (t1777 + t1817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1820 = t1453 * t683;
  t1825 = t444 * t688;
  t1829 = my_piecewise5(t11, 0, t15, 0, -t1742 - t1743);
  t1833 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1820 * t162 + 0.8e1 / 0.9e1 * t629 * t633 + 0.4e1 / 0.9e1 * t1825 * t162 + 0.4e1 / 0.3e1 * t24 * t1829);
  t1834 = t1833 * t27;
  t1838 = t692 * t171;
  t1840 = t6 * t1838 * t88;
  t1849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t88 - t1840 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t235 - t1757 + t1763 / 0.6e1 - t1767 + t1483 / 0.12e2 - t1496 + t1498 / 0.12e2);
  t1850 = t1697 * t700;
  t1855 = t601 * t705;
  t1859 = my_piecewise5(t15, 0, t11, 0, t1742 - t1786);
  t1863 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1850 * t243 + 0.8e1 / 0.9e1 * t653 * t657 + 0.4e1 / 0.9e1 * t1855 * t243 + 0.4e1 / 0.3e1 * t99 * t1859);
  t1864 = t1863 * t27;
  t1868 = t709 * t171;
  t1870 = t6 * t1868 * t153;
  t1877 = t6 * t666 * t337;
  t1885 = t6 * t251 * t833;
  t1887 = -0.3e1 / 0.8e1 * t6 * t1864 * t153 - t1870 / 0.8e1 - t1800 + t1803 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t337 - t1877 / 0.4e1 + t1722 / 0.12e2 - t1727 - t1812 + t1814 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t833 - t1885 / 0.8e1;
  t1888 = my_piecewise3(t93, 0, t1887);
  tv3rho32 = t1732 + t1733 + t699 + t838 + t7 * (t1849 + t1888);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1893 = t683 * t260;
  t1900 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t449 - 0.6e1 * t1462);
  t1904 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1893 + 0.4e1 / 0.3e1 * t629 * t688 + 0.4e1 / 0.3e1 * t24 * t1900);
  t1905 = t1904 * t27;
  t1912 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t88 - 0.3e1 / 0.8e1 * t1840 + t1763 / 0.4e1 - t1496);
  t1913 = t700 * t271;
  t1920 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t449 - 0.6e1 * t1704);
  t1924 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1913 + 0.4e1 / 0.3e1 * t653 * t705 + 0.4e1 / 0.3e1 * t99 * t1920);
  t1925 = t1924 * t27;
  t1940 = t329 * t329;
  t1942 = t176 / t1940;
  t1943 = t723 * sigma[2];
  t1944 = t1642 * t1943;
  t1945 = t725 * t725;
  t1946 = t1945 * t284;
  t1947 = 0.1e1 / t1946;
  t1948 = t1944 * t1947;
  t1952 = 0.1e1 / t104 / t1945;
  t1953 = t724 * t1952;
  t1957 = 0.1e1 / t105 / t766;
  t1958 = t283 * t1957;
  t1961 = t279 * t279;
  t1963 = t176 / t1961;
  t1965 = 0.4e4 / 0.43046721e8 * t1963 * t1948;
  t1967 = 0.22e4 / 0.531441e6 * t722 * t1953;
  t1969 = 0.154e4 / 0.6561e4 * t282 * t1958;
  t1970 = -0.4e4 / 0.43046721e8 * t1942 * t1948 + 0.22e4 / 0.531441e6 * t826 * t1953 - 0.154e4 / 0.6561e4 * t332 * t1958 + t1965 - t1967 + t1969;
  t1972 = t831 * t326;
  t1975 = t335 * t820;
  t1978 = t316 * t812;
  t1979 = t296 * t765;
  t1980 = t1979 * t768;
  t1989 = tau[1] * t733;
  t1993 = -0.44e3 / 0.27e2 * t1989 + 0.154e3 / 0.27e2 * sigma[2] * t1957;
  t1996 = t749 * t296;
  t1999 = t296 * t761;
  t2002 = t130 * t140;
  t2003 = t765 * tau[1];
  t2004 = 0.1e1 / t1945;
  t2005 = t2003 * t2004;
  t2008 = t140 * t1993;
  t2012 = 0.1e1 / t811 / t122;
  t2013 = t2012 * t2003;
  t2017 = t120 * t311;
  t2018 = t749 * tau[1];
  t2019 = t2018 * t107;
  t2022 = t761 * tau[1];
  t2023 = t2022 * t107;
  t2026 = t121 * t795;
  t2029 = t765 * t947;
  t2034 = params->b * t130;
  t2041 = t753 * t286;
  t2044 = t801 * t321;
  t2051 = 0.1344e6 * t1978 * t1980 - 0.1792e6 / 0.3e1 * t137 * t813 * t947 + 0.5632e5 / 0.9e1 * t137 * t322 * t733 + 0.24e2 * t299 * t1993 + 0.48e2 * t1996 * t132 + 0.144e3 * t752 * t1999 + 0.2e5 / 0.9e1 * t2002 * t2005 + 0.384e3 * t316 * t2008 + 0.896e6 / 0.9e1 * t137 * t2013 * t2004 + 0.72e3 * t2017 * t2019 + 0.36e3 * t764 * t2023 + 0.24e4 * t2026 * t1980 - 0.64e4 / 0.3e1 * t796 * t2029 + 0.352e4 / 0.9e1 * t312 * t1989 + 0.768e4 * t2034 * t140 * t1996 + 0.576e4 * t801 * t317 * t761 - 0.96e3 * t764 * t2041 + 0.576e5 * t2044 * t2019 + 0.1152e5 * t805 * t2023 - 0.3072e5 * t805 * t2041;
  t2052 = t151 * t2051;
  t2054 = t738 * t302;
  t2055 = t2054 * t144;
  t2058 = t335 * t738;
  t2064 = t335 * t774;
  t2069 = t749 * t132;
  t2086 = -0.24e2 * t968 * t761 - 0.8e2 * t2069 * t292 - 0.4e3 * t2017 * t1980 - 0.8e2 * t752 * t2023 + 0.64e3 / 0.3e1 * t752 * t2041 - 0.8e1 * t291 * t1993 - 0.4e4 / 0.9e1 * t2026 * t2005 + 0.16e4 / 0.3e1 * t764 * t2029 - 0.352e4 / 0.27e2 * t299 * t1989;
  t2087 = t151 * t2086;
  t2090 = t335 * t781;
  t2094 = t306 * t306;
  t2095 = 0.1e1 / t2094;
  t2096 = t129 * t2095;
  t2097 = t781 * t326;
  t2098 = t151 * t2097;
  t2104 = t127 * t307;
  t2120 = t128 * t779;
  t2124 = -0.18e2 * t2104 * t739 * t326 + 0.18e2 * t2120 * t303 * t781 + 0.18e2 * t737 * t303 * t774 - 0.9e1 * t742 * t303 * t820 - 0.18e2 * t742 * t746 * t326 - 0.9e1 * t742 * t775 * t326 + 0.6e1 * t780 * t327 * t820 - 0.6e1 * t2096 * t2098 - t1965 + t1967 - t1969;
  t2125 = 0.9e1 * t290 * t831 * t302 + t145 * t1970 + 0.6e1 * t2055 * t151 - 0.3e1 * t308 * t1972 - 0.3e1 * t308 * t1975 - t308 * t2052 + 0.18e2 * t737 * t2058 + 0.9e1 * t290 * t2064 + 0.3e1 * t290 * t2087 + 0.6e1 * t780 * t2090 + t2124;
  t2130 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t153 - 0.3e1 / 0.8e1 * t1870 - 0.9e1 / 0.8e1 * t6 * t710 * t337 + t1803 / 0.4e1 - 0.3e1 / 0.4e1 * t1877 - 0.9e1 / 0.8e1 * t6 * t275 * t833 - t1727 + t1814 / 0.4e1 - 0.3e1 / 0.8e1 * t1885 - 0.3e1 / 0.8e1 * t6 * t102 * t2125);
  tv3rho33 = 0.3e1 * t699 + 0.3e1 * t838 + t7 * (t1912 + t2130);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2138 = t6 * t462 * t364;
  t2145 = t6 * t471 * t364 / 0.12e2;
  t2147 = t6 * t172 * t920;
  t2149 = t362 * t499;
  t2155 = t362 * t581;
  t2157 = t592 * t357;
  t2159 = t233 * t906;
  t2162 = t1606 * t39;
  t2164 = t529 * t194;
  t2165 = t2164 * tau[0];
  t2166 = t1532 * t2165;
  t2168 = t184 * t194;
  t2169 = t513 * t2168;
  t2171 = t39 * t522;
  t2172 = t513 * t2171;
  t2174 = t1518 * t526;
  t2175 = t1541 * t2174;
  t2177 = t849 * tau[0];
  t2178 = t525 * t2177;
  t2180 = t197 * t494;
  t2183 = t1551 * t354 * t510;
  t2185 = t1583 * t2165;
  t2188 = t562 * t903 * t194;
  t2191 = t562 * t354 * t522;
  t2193 = t573 * t1518;
  t2195 = t214 * t2193 * t526;
  t2197 = t219 * t849;
  t2199 = t214 * t2197 * tau[0];
  t2201 = t75 * t494;
  t2202 = t214 * t2201;
  t2204 = -0.6e1 * t2162 - 0.6e2 * t2166 + 0.32e2 * t2169 - 0.6e1 * t2172 - 0.1e3 * t2175 + 0.12e3 * t2178 - 0.88e2 / 0.3e1 * t2180 - 0.96e3 * t2183 - 0.48e4 * t2185 + 0.128e4 * t2188 - 0.24e3 * t2191 - 0.56e4 * t2195 + 0.384e4 * t2199 - 0.1408e4 / 0.3e1 * t2202;
  t2205 = t86 * t2204;
  t2207 = t918 * t200;
  t2210 = t362 * t535;
  t2222 = -0.2e1 * t206 * t918 * t224 + 0.4e1 * t541 * t887 * t224 - 0.3e1 * t503 * t358 * t535 + 0.2e1 * t541 * t362 * t542 + 0.6e1 * t188 * t2207 + 0.3e1 * t188 * t2210 - t206 * t2155 - t206 * t2157 - 0.2e1 * t206 * t2159 - t206 * t2205 + 0.6e1 * t498 * t2149;
  t2238 = t1517 * t35;
  t2240 = t1642 / t2238;
  t2241 = t2240 * t484;
  t2243 = 0.5e3 / 0.14348907e8 * t1640 * t2241;
  t2244 = t34 * t494;
  t2246 = 0.11e3 / 0.2187e4 * t179 * t2244;
  t2253 = t1685 * t86;
  t2254 = t39 * t542;
  t2255 = t189 * t2254;
  t2258 = t184 * t224;
  t2259 = t189 * t2258;
  t2262 = t870 * t863;
  t2265 = -0.6e1 * t1629 * t358 * t542 - 0.6e1 * t1650 * t358 * t499 - 0.6e1 * t503 * t887 * t200 - 0.6e1 * t503 * t907 * t200 - 0.6e1 * t503 * t909 * t224 + 0.4e1 * t541 * t907 * t224 + 0.2e1 * t541 * t358 * t581 + 0.6e1 * t2253 * t2255 + 0.16e2 * t862 * t2259 - 0.6e1 * t862 * t2262 + t2243 + t2246;
  t2267 = t39 * t581;
  t2268 = t189 * t2267;
  t2273 = t513 * t2177;
  t2276 = t184 * t200;
  t2277 = t189 * t2276;
  t2282 = t188 * t592;
  t2287 = t522 * t59;
  t2288 = t2287 * t39;
  t2291 = t357 * t200;
  t2292 = t2291 * t224;
  t2295 = t870 * t184;
  t2298 = t189 * t494;
  t2301 = -0.3e1 * t862 * t2268 + 0.2e2 * t867 * t875 - 0.8e2 * t348 * t2273 - 0.32e2 * t857 * t2277 - 0.16e2 * t867 * t878 + 0.3e1 * t2282 * t349 + 0.6e1 * t867 * t871 + 0.3e1 * t348 * t2288 + 0.12e2 * t2253 * t2292 - 0.16e2 * t348 * t2295 + 0.88e2 / 0.3e1 * t348 * t2298;
  t2303 = t483 * t489 * sigma[0];
  t2305 = 0.25e2 / 0.19683e5 * t481 * t2303;
  t2306 = t499 * t79;
  t2307 = t2306 * t86;
  t2316 = 0.5e3 / 0.14348907e8 * t1668 * t2241 - 0.25e2 / 0.19683e5 * t587 * t2303 + 0.11e3 / 0.2187e4 * t229 * t2244 - t2243 + t2305 - t2246;
  t2318 = t194 * t67;
  t2319 = t2318 * t874;
  t2322 = t1532 * t2174;
  t2325 = t498 * t233;
  t2328 = t870 * t858;
  t2331 = t39 * t535;
  t2332 = t189 * t2331;
  t2335 = t503 * t233;
  t2338 = t86 * t52;
  t2339 = t1650 * t2338;
  t2340 = t200 * t224;
  t2341 = t1277 * t2340;
  t2344 = t498 * t2338;
  t2345 = t67 * t529;
  t2346 = t200 * tau[0];
  t2347 = t2345 * t2346;
  t2350 = t503 * t2338;
  t2351 = t224 * tau[0];
  t2352 = t2345 * t2351;
  t2355 = 0.6e1 * t2307 * t349 + t80 * t2316 + 0.2e2 * t348 * t2319 + 0.5e2 * t348 * t2322 + 0.12e2 * t2325 * t859 + 0.12e2 * t857 * t2328 + 0.6e1 * t857 * t2332 - 0.6e1 * t2335 * t864 - 0.12e2 * t2339 * t2341 + 0.4e2 * t2344 * t2347 - 0.2e2 * t2350 * t2352 - t2305;
  t2357 = t2222 + t2265 + t2301 + t2355;
  t2362 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t364 - t2138 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t920 + t2145 - t2147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2357);
  tv3rho2sigma0 = t7 * t2362 + 0.2e1 * t925;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2369 = t6 * t617 * t388;
  t2373 = t6 * t621 * t388 / 0.12e2;
  t2375 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t388 - t2369 / 0.4e1 + t2373);
  tv3rho2sigma2 = t7 * t2375 + 0.2e1 * t934;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2381 = t6 * t642 * t364;
  t2389 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t364 - t2381 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t920 - t2138 / 0.8e1 + t2145 - t2147 / 0.8e1);
  tv3rho2sigma3 = t7 * t2389 + t925 + t940;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2395 = t6 * t666 * t388;
  t2402 = t6 * t251 * t1018;
  t2405 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t388 - t2395 / 0.8e1 - t2369 / 0.8e1 + t2373 - 0.3e1 / 0.8e1 * t6 * t247 * t1018 - t2402 / 0.8e1);
  tv3rho2sigma5 = t7 * t2405 + t1023 + t934;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2413 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t364 - t2381 / 0.4e1 + t2145);
  tv3rho2sigma6 = t7 * t2413 + 0.2e1 * t940;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2424 = t1016 * t302;
  t2427 = t386 * t774;
  t2435 = t831 * t381;
  t2437 = t335 * t1004;
  t2440 = t2069 * t107;
  t2442 = t768 * t296;
  t2443 = t2442 * tau[1];
  t2444 = t2017 * t2443;
  t2446 = t286 * t296;
  t2447 = t752 * t2446;
  t2449 = t107 * t761;
  t2450 = t752 * t2449;
  t2452 = t2004 * t765;
  t2453 = t2026 * t2452;
  t2455 = t947 * tau[1];
  t2456 = t764 * t2455;
  t2458 = t299 * t733;
  t2461 = t2034 * t378 * t749;
  t2463 = t2044 * t2443;
  t2466 = t801 * t1001 * t296;
  t2469 = t801 * t378 * t761;
  t2471 = t812 * t2004;
  t2473 = t316 * t2471 * t765;
  t2475 = t321 * t947;
  t2477 = t316 * t2475 * tau[1];
  t2479 = t140 * t733;
  t2480 = t316 * t2479;
  t2482 = -0.6e1 * t2440 - 0.6e2 * t2444 + 0.32e2 * t2447 - 0.6e1 * t2450 - 0.1e3 * t2453 + 0.12e3 * t2456 - 0.88e2 / 0.3e1 * t2458 - 0.96e3 * t2461 - 0.48e4 * t2463 + 0.128e4 * t2466 - 0.24e3 * t2469 - 0.56e4 * t2473 + 0.384e4 * t2477 - 0.1408e4 / 0.3e1 * t2480;
  t2483 = t151 * t2482;
  t2485 = t386 * t738;
  t2497 = -0.2e1 * t308 * t1016 * t326 - 0.6e1 * t2096 * t382 * t781 - 0.6e1 * t2104 * t382 * t738 - t308 * t386 * t820 + 0.2e1 * t780 * t386 * t781 + 0.6e1 * t290 * t2424 + 0.3e1 * t290 * t2427 - t308 * t2435 - 0.2e1 * t308 * t2437 - t308 * t2483 + 0.6e1 * t737 * t2485;
  t2498 = t34 * t733;
  t2500 = 0.11e3 / 0.2187e4 * t281 * t2498;
  t2504 = t1945 * t103;
  t2506 = t1642 / t2504;
  t2507 = t2506 * t723;
  t2509 = 0.5e3 / 0.14348907e8 * t1963 * t2507;
  t2530 = t968 * t286;
  t2535 = -0.6e1 * t742 * t1005 * t302 + 0.4e1 * t780 * t1005 * t326 - 0.6e1 * t742 * t1007 * t326 - 0.6e1 * t742 * t985 * t302 + 0.4e1 * t780 * t985 * t326 - 0.3e1 * t742 * t382 * t774 + 0.2e1 * t780 * t382 * t820 - 0.16e2 * t372 * t2530 + 0.6e1 * t965 * t969 - 0.16e2 * t965 * t976 + t2500 + t2509;
  t2537 = t761 * t124;
  t2538 = t2537 * t107;
  t2541 = t2120 * t151;
  t2542 = t381 * t302;
  t2543 = t2542 * t326;
  t2546 = t290 * t831;
  t2549 = t291 * t733;
  t2553 = t483 * t728 * sigma[2];
  t2555 = 0.25e2 / 0.19683e5 * t722 * t2553;
  t2556 = t738 * t144;
  t2557 = t2556 * t151;
  t2562 = t296 * t132;
  t2563 = t2562 * t972;
  t2566 = t2017 * t2452;
  t2569 = t752 * t2455;
  t2572 = t286 * t302;
  t2573 = t291 * t2572;
  t2576 = 0.3e1 * t372 * t2538 + 0.12e2 * t2541 * t2543 + 0.3e1 * t2546 * t373 + 0.88e2 / 0.3e1 * t372 * t2549 - t2555 + 0.6e1 * t2557 * t373 + 0.2e2 * t965 * t973 + 0.2e2 * t372 * t2563 + 0.5e2 * t372 * t2566 - 0.8e2 * t372 * t2569 - 0.32e2 * t955 * t2573;
  t2577 = t107 * t781;
  t2578 = t291 * t2577;
  t2581 = t286 * t326;
  t2582 = t291 * t2581;
  t2585 = t737 * t335;
  t2588 = t968 * t956;
  t2591 = t107 * t774;
  t2592 = t291 * t2591;
  t2595 = t742 * t335;
  t2598 = t968 * t961;
  t2601 = t107 * t820;
  t2602 = t291 * t2601;
  t2605 = t151 * t120;
  t2606 = t2104 * t2605;
  t2607 = t302 * t326;
  t2608 = t1320 * t2607;
  t2611 = t737 * t2605;
  t2612 = t132 * t768;
  t2613 = t302 * tau[1];
  t2614 = t2612 * t2613;
  t2617 = t742 * t2605;
  t2618 = t326 * tau[1];
  t2619 = t2612 * t2618;
  t2628 = 0.5e3 / 0.14348907e8 * t1942 * t2507 - 0.25e2 / 0.19683e5 * t826 * t2553 + 0.11e3 / 0.2187e4 * t331 * t2498 - t2509 + t2555 - t2500;
  t2630 = t145 * t2628 + 0.6e1 * t2541 * t2578 + 0.16e2 * t960 * t2582 + 0.12e2 * t2585 * t957 + 0.12e2 * t955 * t2588 + 0.6e1 * t955 * t2592 - 0.6e1 * t2595 * t962 - 0.6e1 * t960 * t2598 - 0.3e1 * t960 * t2602 - 0.12e2 * t2606 * t2608 + 0.4e2 * t2611 * t2614 - 0.2e2 * t2617 * t2619;
  t2632 = t2497 + t2535 + t2576 + t2630;
  t2637 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t388 - t2395 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1018 + t2373 - t2402 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t2632);
  tv3rho2sigma8 = t7 * t2637 + 0.2e1 * t1023;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2644 = t6 * t462 * t412;
  t2651 = t6 * t471 * t412 / 0.12e2;
  t2653 = t6 * t172 * t1096;
  t2681 = t397 * t535;
  t2690 = 0.12e2 * t498 * t1037 * t200 - 0.6e1 * t503 * t1037 * t224 + 0.12e2 * t498 * t1055 * t200 - 0.6e1 * t503 * t1055 * t224 - 0.6e1 * t503 * t1064 * t200 + 0.4e1 * t541 * t1064 * t224 - 0.6e1 * t503 * t1094 * t200 + 0.4e1 * t541 * t1094 * t224 - 0.3e1 * t503 * t410 * t535 + 0.2e1 * t541 * t410 * t581 + 0.6e1 * t2306 * t397 + 0.6e1 * t498 * t2681;
  t2694 = t1650 * t86;
  t2695 = t396 * t200;
  t2696 = t2695 * t224;
  t2705 = t409 * t200;
  t2706 = t2705 * t224;
  t2712 = t592 * t409;
  t2714 = t233 * t1093;
  t2724 = t219 * t184;
  t2727 = t49 * t522;
  t2728 = t513 * t2727;
  t2730 = 0.1e1 / t487;
  t2731 = t2730 * t526;
  t2732 = t1541 * t2731;
  t2738 = t1560 * t2730;
  t2742 = t1043 * t194;
  t2743 = t2742 * tau[0];
  t2744 = t1532 * t2743;
  t2752 = t573 * t529;
  t2759 = -0.144e3 * t1532 * t49 * t510 + 0.24e3 * t525 * t889 + 0.96e3 * t557 * t874 - 0.512e4 / 0.3e1 * t72 * t2724 + 0.48e2 * t2728 + 0.8e3 * t2732 - 0.72e2 * t525 * t2727 - 0.4e4 / 0.3e1 * t1515 * t2731 - 0.1792e6 / 0.3e1 * t72 * t2738 * t526 + 0.48e3 * t2744 - 0.1152e5 * t562 * t406 * t510 + 0.768e4 * t214 * t1090 * t194 + 0.2688e5 * t72 * t2752 * tau[0] + 0.768e4 * t1551 * t403 * t510;
  t2765 = t573 * t2730;
  t2782 = t1606 * t49;
  t2786 = -0.96e3 * t1541 * t2743 + 0.192e4 * t562 * t403 * t522 + 0.448e5 * t214 * t2765 * t526 - 0.2304e4 * t214 * t406 * t522 + 0.384e5 * t1583 * t2743 - 0.5376e5 * t1571 * t2743 - 0.64e4 * t897 - 0.2304e5 * t901 + 0.32e3 / 0.3e1 * t894 - 0.16e3 * t890 - 0.72e3 * t892 + 0.512e4 / 0.3e1 * t904 + 0.48e2 * t2782 - 0.32e3 / 0.3e1 * t210 * t184;
  t2787 = t2759 + t2786;
  t2788 = t86 * t2787;
  t2790 = t592 * t396;
  t2793 = t233 * t1054;
  t2812 = -0.8e1 * t2287 * t49 - 0.16e3 / 0.3e1 * t2318 * t1044 + 0.8e2 / 0.3e1 * t871 - 0.4e3 / 0.3e1 * t1532 * t2731 + 0.16e3 * t875 - 0.32e3 / 0.9e1 * t878 + 0.16e2 * t2782 + 0.16e3 * t2744 - 0.16e3 / 0.3e1 * t890 + 0.16e2 * t2728 + 0.8e3 / 0.3e1 * t2732 - 0.24e3 * t892 + 0.32e3 / 0.9e1 * t894;
  t2813 = t86 * t2812;
  t2816 = -0.6e1 * t1629 * t410 * t542 - 0.6e1 * t1650 * t410 * t499 + 0.6e1 * t1685 * t397 * t542 - 0.3e1 * t503 * t397 * t581 + 0.3e1 * t188 * t2790 + 0.6e1 * t188 * t2793 + 0.3e1 * t188 * t2813 - t206 * t2712 - 0.2e1 * t206 * t2714 - t206 * t2788 + 0.12e2 * t2253 * t2706 - 0.12e2 * t2694 * t2696;
  t2817 = t2690 + t2816;
  t2822 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t412 - t2644 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t1096 + t2651 - t2653 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2817);
  tv3rho2tau0 = t7 * t2822 + 0.2e1 * t1101;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2829 = t6 * t617 * t436;
  t2833 = t6 * t621 * t436 / 0.12e2;
  t2835 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t436 - t2829 / 0.4e1 + t2833);
  tv3rho2tau1 = t7 * t2835 + 0.2e1 * t1110;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2841 = t6 * t642 * t412;
  t2849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t412 - t2841 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t1096 - t2644 / 0.8e1 + t2651 - t2653 / 0.8e1);
  tv3rho2tau2 = t7 * t2849 + t1101 + t1116;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2855 = t6 * t666 * t436;
  t2862 = t6 * t251 * t1186;
  t2865 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t436 - t2855 / 0.8e1 - t2829 / 0.8e1 + t2833 - 0.3e1 / 0.8e1 * t6 * t247 * t1186 - t2862 / 0.8e1);
  tv3rho2tau3 = t7 * t2865 + t1110 + t1191;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2873 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t412 - t2841 / 0.4e1 + t2651);
  tv3rho2tau4 = t7 * t2873 + 0.2e1 * t1116;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2910 = t421 * t774;
  t2919 = 0.12e2 * t737 * t1127 * t302 - 0.6e1 * t742 * t1127 * t326 + 0.12e2 * t737 * t1145 * t302 - 0.6e1 * t742 * t1145 * t326 - 0.6e1 * t742 * t1154 * t302 + 0.4e1 * t780 * t1154 * t326 - 0.6e1 * t742 * t1184 * t302 + 0.4e1 * t780 * t1184 * t326 - 0.3e1 * t742 * t434 * t774 + 0.2e1 * t780 * t434 * t820 + 0.6e1 * t2556 * t421 + 0.6e1 * t737 * t2910;
  t2923 = t2104 * t151;
  t2924 = t420 * t302;
  t2925 = t2924 * t326;
  t2934 = t433 * t302;
  t2935 = t2934 * t326;
  t2941 = t831 * t420;
  t2944 = t335 * t1144;
  t2952 = 0.1e1 / t726;
  t2953 = t2952 * t765;
  t2958 = t2069 * t117;
  t2960 = t1133 * t296;
  t2961 = t2960 * tau[1];
  t2962 = t2017 * t2961;
  t2965 = t117 * t761;
  t2966 = t752 * t2965;
  t2968 = t2026 * t2953;
  t2972 = -0.8e1 * t2537 * t117 - 0.16e3 / 0.3e1 * t2562 * t1134 + 0.8e2 / 0.3e1 * t969 - 0.4e3 / 0.3e1 * t2017 * t2953 + 0.16e3 * t973 - 0.32e3 / 0.9e1 * t976 + 0.16e2 * t2958 + 0.16e3 * t2962 - 0.16e3 / 0.3e1 * t988 + 0.16e2 * t2966 + 0.8e3 / 0.3e1 * t2968 - 0.24e3 * t990 + 0.32e3 / 0.9e1 * t992;
  t2973 = t151 * t2972;
  t2976 = t831 * t433;
  t2978 = t335 * t1183;
  t2984 = t812 * t2952;
  t2991 = t2012 * t2952;
  t3004 = t812 * t768;
  t3018 = 0.192e4 * t801 * t427 * t761 + 0.448e5 * t316 * t2984 * t765 - 0.2304e4 * t316 * t430 * t761 - 0.1792e6 / 0.3e1 * t137 * t2991 * t765 + 0.768e4 * t2034 * t427 * t749 - 0.1152e5 * t801 * t430 * t749 + 0.768e4 * t316 * t1180 * t296 + 0.2688e5 * t137 * t3004 * tau[1] - 0.96e3 * t2026 * t2961 + 0.48e3 * t2962 - 0.32e3 / 0.3e1 * t312 * t286 + 0.48e2 * t2958 + 0.384e5 * t2044 * t2961 - 0.5376e5 * t1978 * t2961;
  t3034 = t321 * t286;
  t3041 = -0.64e4 * t995 - 0.2304e5 * t999 + 0.32e3 / 0.3e1 * t992 - 0.72e3 * t990 + 0.512e4 / 0.3e1 * t1002 - 0.16e3 * t988 + 0.48e2 * t2966 + 0.8e3 * t2968 - 0.144e3 * t2017 * t117 * t749 + 0.24e3 * t764 * t987 + 0.96e3 * t796 * t972 - 0.512e4 / 0.3e1 * t137 * t3034 - 0.72e2 * t764 * t2965 - 0.4e4 / 0.3e1 * t2002 * t2953;
  t3042 = t3018 + t3041;
  t3043 = t151 * t3042;
  t3045 = -0.6e1 * t2096 * t434 * t781 - 0.6e1 * t2104 * t434 * t738 + 0.6e1 * t2120 * t421 * t781 - 0.3e1 * t742 * t421 * t820 + 0.12e2 * t2541 * t2935 + 0.3e1 * t290 * t2941 + 0.6e1 * t290 * t2944 + 0.3e1 * t290 * t2973 - 0.12e2 * t2923 * t2925 - t308 * t2976 - 0.2e1 * t308 * t2978 - t308 * t3043;
  t3046 = t2919 + t3045;
  t3051 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t436 - t2855 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1186 + t2833 - t2862 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t3046);
  tv3rho2tau5 = t7 * t3051 + 0.2e1 * t1191;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3058 = t6 * t172 * t1230 / 0.8e1;
  t3063 = t1193 * t849;
  t3065 = 0.5e2 / 0.177147e6 * t480 * t3063;
  t3081 = t1517 * rho[0];
  t3082 = 0.1e1 / t3081;
  t3083 = t1642 * t3082;
  t3084 = t3083 * sigma[0];
  t3086 = 0.125e3 / 0.9565938e7 * t1640 * t3084;
  t3101 = -0.125e3 / 0.9565938e7 * t1668 * t3084 + 0.5e2 / 0.177147e6 * t586 * t3063 + t3086 - t3065;
  t3103 = t525 * t849;
  t3108 = t200 * t79;
  t3109 = t3108 * t86;
  t3114 = t188 * t918;
  t3119 = t529 * t59;
  t3120 = t3119 * t200;
  t3123 = t3119 * t224;
  t3126 = 0.2e1 * t188 * t86 * t849 * t59 + t3065 + 0.4e1 * t541 * t1215 * t224 - 0.3e1 * t503 * t1224 * t200 + 0.2e1 * t541 * t1224 * t224 + 0.4e1 * t541 * t358 * t906 - 0.6e1 * t503 * t1215 * t200 - t3086 - 0.3e1 / 0.8e1 * t188 * t233 * t529 * t59 + 0.6e1 * t1685 * t1212 * t200 - 0.6e1 * t1629 * t1212 * t224 + t80 * t3101 - 0.32e2 * t857 * t3103 - 0.16e2 * t1204 * t878 + 0.6e1 * t3109 * t1197 + 0.6e1 * t2325 * t1197 + 0.6e1 * t3114 * t349 + 0.6e1 * t1204 * t871 - 0.3e1 / 0.4e1 * t857 * t3120 + 0.3e1 / 0.8e1 * t862 * t3123;
  t3127 = t1518 * t67;
  t3128 = t3127 * tau[0];
  t3131 = t184 * t357;
  t3132 = t189 * t3131;
  t3135 = t529 * t224;
  t3136 = t525 * t3135;
  t3139 = t1532 * t2164;
  t3142 = t1518 * tau[0];
  t3143 = t1541 * t3142;
  t3148 = t870 * t1200;
  t3151 = t39 * t906;
  t3152 = t189 * t3151;
  t3155 = t498 * t362;
  t3158 = t503 * t362;
  t3164 = t1228 * t200;
  t3169 = t233 * t1211;
  t3172 = t918 * t357;
  t3175 = t362 * t906;
  t3178 = t233 * t1223;
  t3180 = t2318 * t529;
  t3182 = t1532 * t3142;
  t3184 = t513 * t849;
  t3187 = t1551 * t1220 * t194;
  t3189 = t219 * t1518;
  t3191 = t562 * t3189 * tau[0];
  t3193 = t75 * t849;
  t3194 = t562 * t3193;
  t3196 = 0.3e1 / 0.4e1 * t3180 + 0.15e2 / 0.4e1 * t3182 - 0.4e1 * t3184 + 0.12e3 * t3187 + 0.3e3 * t3191 - 0.16e3 * t3194;
  t3197 = t86 * t3196;
  t3199 = t1277 * t2291;
  t3202 = t1685 * t2338;
  t3203 = t357 * t224;
  t3204 = t1277 * t3203;
  t3207 = t357 * tau[0];
  t3208 = t2345 * t3207;
  t3211 = -t206 * t1228 * t224 + 0.2e2 * t1204 * t875 + 0.3e1 * t188 * t3164 - 0.2e1 * t206 * t3172 - 0.2e1 * t206 * t3175 - t206 * t3178 - t206 * t3197 - 0.12e2 * t2339 * t3199 - 0.2e2 * t2350 * t3208 + 0.2e1 * t541 * t3169 + 0.12e2 * t3202 * t3204;
  t3213 = t3126 - 0.5e1 / 0.4e1 * t348 * t3128 + 0.16e2 * t862 * t3132 - 0.6e1 * t2694 * t3136 + 0.12e2 * t857 * t3139 + 0.4e2 * t857 * t3143 - 0.6e1 * t2335 * t1201 - 0.6e1 * t862 * t3148 - 0.6e1 * t862 * t3152 + 0.12e2 * t3155 * t859 - 0.6e1 * t3158 * t864 + t3211;
  t3218 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1230 - t3058 - 0.3e1 / 0.8e1 * t6 * t28 * t3213);
  tv3rhosigma20 = t7 * t3218 + t1234;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3225 = t6 * t251 * t1271 / 0.8e1;
  t3227 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1271 - t3225);
  tv3rhosigma25 = t7 * t3227 + t1275;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3233 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1230 - t3058);
  tv3rhosigma26 = t7 * t3233 + t1234;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3251 = t1193 * t947;
  t3253 = 0.5e2 / 0.177147e6 * t721 * t3251;
  t3254 = t1945 * rho[1];
  t3255 = 0.1e1 / t3254;
  t3256 = t1642 * t3255;
  t3257 = t3256 * sigma[2];
  t3259 = 0.125e3 / 0.9565938e7 * t1963 * t3257;
  t3278 = t2004 * t132;
  t3279 = t3278 * tau[1];
  t3282 = t764 * t947;
  t3285 = t302 * t144;
  t3286 = t3285 * t151;
  t3291 = t290 * t1016;
  t3296 = t768 * t124;
  t3297 = t3296 * t302;
  t3300 = t3296 * t326;
  t3303 = 0.2e1 * t290 * t151 * t947 * t124 + 0.4e1 * t780 * t1256 * t326 - 0.3e1 * t742 * t1265 * t302 + 0.2e1 * t780 * t1265 * t326 + t3253 - t3259 - 0.3e1 / 0.8e1 * t290 * t335 * t768 * t124 + 0.6e1 * t2120 * t1253 * t302 - 0.6e1 * t2096 * t1253 * t326 + 0.4e1 * t780 * t382 * t1004 - 0.6e1 * t742 * t1256 * t302 - 0.16e2 * t1245 * t976 - 0.5e1 / 0.4e1 * t372 * t3279 - 0.32e2 * t955 * t3282 + 0.6e1 * t3286 * t1238 + 0.6e1 * t2585 * t1238 + 0.6e1 * t3291 * t373 + 0.6e1 * t1245 * t969 - 0.3e1 / 0.4e1 * t955 * t3297 + 0.3e1 / 0.8e1 * t960 * t3300;
  t3304 = t2017 * t2442;
  t3307 = t2004 * tau[1];
  t3308 = t2026 * t3307;
  t3313 = t968 * t1241;
  t3316 = t107 * t1004;
  t3317 = t291 * t3316;
  t3320 = t737 * t386;
  t3323 = t742 * t386;
  t3328 = t768 * t326;
  t3329 = t764 * t3328;
  t3332 = t286 * t381;
  t3333 = t291 * t3332;
  t3337 = t1016 * t381;
  t3340 = t386 * t1004;
  t3343 = t335 * t1264;
  t3345 = t2562 * t768;
  t3347 = t2017 * t3307;
  t3349 = t752 * t947;
  t3352 = t2034 * t1261 * t296;
  t3354 = t321 * t2004;
  t3356 = t801 * t3354 * tau[1];
  t3358 = t140 * t947;
  t3359 = t801 * t3358;
  t3361 = 0.3e1 / 0.4e1 * t3345 + 0.15e2 / 0.4e1 * t3347 - 0.4e1 * t3349 + 0.12e3 * t3352 + 0.3e3 * t3356 - 0.16e3 * t3359;
  t3362 = t151 * t3361;
  t3364 = t1269 * t302;
  t3369 = t335 * t1252;
  t3372 = t1320 * t2542;
  t3375 = t2120 * t2605;
  t3376 = t381 * t326;
  t3377 = t1320 * t3376;
  t3380 = t381 * tau[1];
  t3381 = t2612 * t3380;
  t3388 = -0.125e3 / 0.9565938e7 * t1942 * t3257 + 0.5e2 / 0.177147e6 * t825 * t3251 + t3259 - t3253;
  t3390 = -t308 * t1269 * t326 + t145 * t3388 - 0.12e2 * t2606 * t3372 - 0.2e2 * t2617 * t3381 + 0.3e1 * t290 * t3364 - 0.2e1 * t308 * t3337 - 0.2e1 * t308 * t3340 - t308 * t3343 - t308 * t3362 + 0.2e1 * t780 * t3369 + 0.12e2 * t3375 * t3377;
  t3392 = -0.6e1 * t2595 * t1242 + 0.2e2 * t1245 * t973 - 0.6e1 * t2923 * t3329 + 0.12e2 * t955 * t3304 + 0.4e2 * t955 * t3308 - 0.6e1 * t960 * t3313 - 0.6e1 * t960 * t3317 + 0.12e2 * t3320 * t957 - 0.6e1 * t3323 * t962 + 0.16e2 * t960 * t3333 + t3303 + t3390;
  t3397 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1271 - t3225 - 0.3e1 / 0.8e1 * t6 * t102 * t3392);
  tv3rhosigma211 = t7 * t3397 + t1275;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3404 = t6 * t172 * t1314 / 0.8e1;
  t3411 = t396 * t357;
  t3412 = t3411 * t224;
  t3415 = t409 * t357;
  t3416 = t3415 * t200;
  t3419 = t1629 * t86;
  t3420 = t3415 * t224;
  t3423 = t3411 * t200;
  t3426 = t59 * t184;
  t3427 = t1294 * t3426;
  t3434 = t1054 * t52;
  t3435 = t3434 * t1277;
  t3438 = t396 * t194;
  t3439 = t3438 * t1277;
  t3444 = t1093 * t52;
  t3445 = t3444 * t1277;
  t3448 = t409 * t194;
  t3449 = t3448 * t1277;
  t3452 = t1276 * t3426;
  t3455 = t2318 * t1043;
  t3457 = t2730 * tau[0];
  t3458 = t1532 * t3457;
  t3461 = t1532 * t2742;
  t3463 = t1541 * t3457;
  t3467 = t1551 * t1306 * t194;
  t3469 = t219 * t2730;
  t3471 = t562 * t3469 * tau[0];
  t3475 = t562 * t1078 * t194;
  t3478 = t214 * t2765 * tau[0];
  t3480 = t214 * t899;
  t3482 = -0.6e1 * t3455 - 0.3e2 * t3458 + 0.26e2 * t1218 + 0.18e2 * t3461 + 0.6e2 * t3463 - 0.39e2 * t1197 - 0.96e3 * t3467 - 0.24e4 * t3471 + 0.104e4 * t1221 + 0.144e4 * t3475 + 0.336e4 * t3478 - 0.1248e4 * t3480;
  t3483 = t86 * t3482;
  t3485 = t918 * t409;
  t3487 = t362 * t1093;
  t3489 = t233 * t1311;
  t3491 = t918 * t396;
  t3494 = -0.3e1 * t503 * t1037 * t357 - 0.3e1 * t503 * t1055 * t357 + 0.6e1 * t2325 * t1278 + 0.6e1 * t3109 * t1278 - 0.3e1 * t2335 * t1295 + 0.3e1 * t188 * t3491 - t206 * t3483 - t206 * t3485 - t206 * t3487 - t206 * t3489 + 0.6e1 * t2253 * t3412 + 0.6e1 * t2253 * t3416 - 0.6e1 * t2694 * t3423 - 0.6e1 * t3419 * t3420 + 0.8e1 * t862 * t3427 + 0.6e1 * t857 * t3435 + 0.6e1 * t857 * t3439 - 0.3e1 * t862 * t3445 - 0.3e1 * t862 * t3449 - 0.16e2 * t857 * t3452;
  t3495 = t362 * t1054;
  t3498 = t233 * t1290;
  t3502 = t2730 * t67;
  t3503 = t3502 * tau[0];
  t3508 = -0.13e2 / 0.3e1 * t3119 + 0.1e2 / 0.3e1 * t3503 - 0.2e1 * t3455 - 0.1e2 * t3458 + 0.26e2 / 0.3e1 * t1218;
  t3509 = t86 * t3508;
  t3545 = t1650 * t397;
  t3548 = t498 * t397;
  t3551 = t1650 * t410;
  t3554 = t1685 * t410;
  t3557 = t503 * t410;
  t3563 = 0.2e1 * t541 * t1064 * t357 + 0.2e1 * t541 * t1094 * t357 + 0.6e1 * t498 * t1284 * t200 - 0.3e1 * t503 * t1284 * t224 + 0.6e1 * t498 * t1291 * t200 - 0.3e1 * t503 * t1291 * t224 - 0.3e1 * t503 * t1301 * t200 + 0.2e1 * t541 * t1301 * t224 - 0.3e1 * t503 * t1312 * t200 + 0.2e1 * t541 * t1312 * t224 - 0.3e1 * t503 * t397 * t906 + 0.2e1 * t541 * t410 * t906 + 0.3e1 * t188 * t3495 + 0.3e1 * t188 * t3498 + 0.3e1 * t188 * t3509 - 0.6e1 * t3545 * t864 + 0.2e2 * t3548 * t875 - 0.6e1 * t3551 * t859 + 0.6e1 * t3554 * t864 - 0.1e2 * t3557 * t875;
  t3564 = t3494 + t3563;
  t3569 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1314 - t3404 - 0.3e1 / 0.8e1 * t6 * t28 * t3564);
  tv3rhosigmatau0 = t7 * t3569 + t1318;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3576 = t6 * t251 * t1357 / 0.8e1;
  t3578 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1357 - t3576);
  tv3rhosigmatau5 = t7 * t3578 + t1361;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3584 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1314 - t3404);
  tv3rhosigmatau6 = t7 * t3584 + t1318;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3589 = t420 * t381;
  t3590 = t3589 * t326;
  t3593 = t433 * t381;
  t3594 = t3593 * t302;
  t3597 = t2096 * t151;
  t3598 = t3593 * t326;
  t3601 = t3589 * t302;
  t3604 = t386 * t1183;
  t3606 = t335 * t1354;
  t3608 = t2562 * t1133;
  t3610 = t2952 * tau[1];
  t3611 = t2017 * t3610;
  t3614 = t2017 * t2960;
  t3616 = t2026 * t3610;
  t3620 = t2034 * t1349 * t296;
  t3622 = t321 * t2952;
  t3624 = t801 * t3622 * tau[1];
  t3628 = t801 * t1168 * t296;
  t3631 = t316 * t2984 * tau[1];
  t3633 = t316 * t997;
  t3635 = -0.6e1 * t3608 - 0.3e2 * t3611 + 0.26e2 * t1259 + 0.18e2 * t3614 + 0.6e2 * t3616 - 0.39e2 * t1238 - 0.96e3 * t3620 - 0.24e4 * t3624 + 0.104e4 * t1262 + 0.144e4 * t3628 + 0.336e4 * t3631 - 0.1248e4 * t3633;
  t3636 = t151 * t3635;
  t3638 = t1016 * t420;
  t3641 = t386 * t1144;
  t3644 = t335 * t1333;
  t3648 = t2952 * t132;
  t3649 = t3648 * tau[1];
  t3654 = -0.13e2 / 0.3e1 * t3296 + 0.1e2 / 0.3e1 * t3649 - 0.2e1 * t3608 - 0.1e2 * t3611 + 0.26e2 / 0.3e1 * t1259;
  t3655 = t151 * t3654;
  t3658 = t1016 * t433;
  t3664 = t1144 * t120;
  t3665 = t3664 * t1320;
  t3668 = t420 * t296;
  t3669 = t3668 * t1320;
  t3674 = t1183 * t120;
  t3675 = t3674 * t1320;
  t3678 = t124 * t286;
  t3679 = t1319 * t3678;
  t3682 = t1337 * t3678;
  t3685 = 0.6e1 * t2585 * t1321 + 0.6e1 * t3286 * t1321 - 0.3e1 * t2595 * t1338 + 0.6e1 * t2541 * t3590 + 0.6e1 * t2541 * t3594 + 0.3e1 * t290 * t3638 + 0.3e1 * t290 * t3641 + 0.3e1 * t290 * t3644 + 0.3e1 * t290 * t3655 - 0.6e1 * t2923 * t3601 - t308 * t3604 - t308 * t3606 - t308 * t3636 - t308 * t3658 - 0.6e1 * t3597 * t3598 + 0.6e1 * t955 * t3665 + 0.6e1 * t955 * t3669 - 0.3e1 * t960 * t3675 - 0.16e2 * t955 * t3679 + 0.8e1 * t960 * t3682;
  t3686 = t433 * t296;
  t3687 = t3686 * t1320;
  t3732 = t2104 * t421;
  t3735 = t737 * t421;
  t3738 = t2104 * t434;
  t3741 = t2120 * t434;
  t3744 = t742 * t434;
  t3747 = -0.3e1 * t742 * t421 * t1004 + 0.2e1 * t780 * t434 * t1004 - 0.3e1 * t742 * t1127 * t381 - 0.3e1 * t742 * t1145 * t381 + 0.2e1 * t780 * t1154 * t381 + 0.2e1 * t780 * t1184 * t381 + 0.6e1 * t737 * t1327 * t302 - 0.3e1 * t742 * t1327 * t326 + 0.6e1 * t737 * t1334 * t302 - 0.3e1 * t742 * t1334 * t326 - 0.3e1 * t742 * t1344 * t302 + 0.2e1 * t780 * t1344 * t326 - 0.3e1 * t742 * t1355 * t302 + 0.2e1 * t780 * t1355 * t326 - 0.3e1 * t960 * t3687 - 0.6e1 * t3732 * t962 + 0.2e2 * t3735 * t973 - 0.6e1 * t3738 * t957 + 0.6e1 * t3741 * t962 - 0.1e2 * t3744 * t973;
  t3748 = t3685 + t3747;
  t3753 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1357 - t3576 - 0.3e1 / 0.8e1 * t6 * t102 * t3748);
  tv3rhosigmatau11 = t7 * t3753 + t1361;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3760 = t6 * t172 * t1401 / 0.8e1;
  t3763 = t1363 * t224;
  t3766 = t233 * t1362;
  t3769 = t397 * t1054;
  t3772 = t396 * t409;
  t3773 = t3772 * t200;
  t3776 = t3772 * t224;
  t3795 = t233 * t1377;
  t3799 = 0.1e1 / t847;
  t3800 = t3799 * t67;
  t3803 = t2318 * t1370;
  t3805 = t3799 * tau[0];
  t3806 = t1532 * t3805;
  t3809 = t1370 * t194;
  t3810 = t1532 * t3809;
  t3812 = t1541 * t3805;
  t3815 = 0.8e2 / 0.3e1 * t1287 - 0.8e2 / 0.3e1 * t3800 * tau[0] + 0.32e2 * t3803 + 0.16e3 * t3806 - 0.32e3 / 0.3e1 * t1288 - 0.48e2 * t3810 - 0.16e3 * t3812 + 0.8e2 * t1304;
  t3816 = t86 * t3815;
  t3825 = t233 * t1381;
  t3837 = t233 * t1398;
  t3854 = t219 * t3799;
  t3862 = t573 * t3799;
  t3870 = t1560 * t3799;
  t3876 = 0.768e4 * t1551 * t1389 * t194 - 0.2304e5 * t562 * t1392 * t194 + 0.16128e5 * t214 * t1395 * t194 - 0.5376e5 * t214 * t3862 * tau[0] + 0.192e5 * t562 * t3854 * tau[0] + 0.3584e5 * t72 * t3870 * tau[0] - 0.32e3 * t557 * t1043 - 0.896e4 * t72 * t1086 + 0.8e3 * t1515 * t3805 + 0.288e3 * t1541 * t3809 - 0.16e3 * t1288 + 0.48e3 * t1304 - 0.64e4 * t1307 + 0.1536e5 * t1309 + 0.48e2 * t3803 + 0.24e3 * t3806 - 0.288e3 * t3810 - 0.96e3 * t3812;
  t3877 = t86 * t3876;
  t3879 = 0.4e1 * t541 * t410 * t1093 - 0.3e1 * t503 * t1378 * t224 - 0.6e1 * t1629 * t1382 * t224 + 0.6e1 * t1685 * t1382 * t200 - 0.3e1 * t503 * t1399 * t200 + 0.2e1 * t541 * t1399 * t224 + 0.3e1 * t188 * t3795 + 0.3e1 * t188 * t3816 - t206 * t3837 - t206 * t3877 + 0.2e1 * t541 * t3825;
  t3880 = -0.6e1 * t503 * t1037 * t409 - 0.6e1 * t503 * t1055 * t409 - 0.6e1 * t503 * t397 * t1093 + 0.6e1 * t498 * t1378 * t200 + 0.6e1 * t3108 * t1363 - 0.6e1 * t1650 * t3763 + 0.12e2 * t2253 * t3776 - 0.12e2 * t2694 * t3773 + 0.6e1 * t498 * t3766 + 0.12e2 * t498 * t3769 + t3879;
  t3885 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1401 - t3760 - 0.3e1 / 0.8e1 * t6 * t28 * t3880);
  tv3rhotau20 = t7 * t3885 + t1405;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3892 = t6 * t251 * t1445 / 0.8e1;
  t3894 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1445 - t3892);
  tv3rhotau22 = t7 * t3894 + t1449;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3900 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1401 - t3760);
  tv3rhotau23 = t7 * t3900 + t1405;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3907 = t1407 * t326;
  t3910 = t335 * t1406;
  t3913 = t421 * t1144;
  t3916 = t420 * t433;
  t3917 = t3916 * t302;
  t3920 = t3916 * t326;
  t3939 = t335 * t1421;
  t3943 = 0.1e1 / t945;
  t3944 = t3943 * t132;
  t3947 = t2562 * t1414;
  t3949 = t3943 * tau[1];
  t3950 = t2017 * t3949;
  t3953 = t1414 * t296;
  t3954 = t2017 * t3953;
  t3956 = t2026 * t3949;
  t3959 = 0.8e2 / 0.3e1 * t1330 - 0.8e2 / 0.3e1 * t3944 * tau[1] + 0.32e2 * t3947 + 0.16e3 * t3950 - 0.32e3 / 0.3e1 * t1331 - 0.48e2 * t3954 - 0.16e3 * t3956 + 0.8e2 * t1347;
  t3960 = t151 * t3959;
  t3969 = t335 * t1425;
  t3981 = t335 * t1442;
  t3998 = t321 * t3943;
  t4006 = t812 * t3943;
  t4014 = t2012 * t3943;
  t4020 = 0.3584e5 * t137 * t4014 * tau[1] + 0.768e4 * t2034 * t1433 * t296 - 0.2304e5 * t801 * t1436 * t296 + 0.16128e5 * t316 * t1439 * t296 - 0.5376e5 * t316 * t4006 * tau[1] + 0.192e5 * t801 * t3998 * tau[1] - 0.32e3 * t796 * t1133 - 0.896e4 * t137 * t1176 + 0.8e3 * t2002 * t3949 + 0.288e3 * t2026 * t3953 - 0.16e3 * t1331 + 0.48e3 * t1347 - 0.64e4 * t1350 + 0.1536e5 * t1352 + 0.48e2 * t3947 + 0.24e3 * t3950 - 0.288e3 * t3954 - 0.96e3 * t3956;
  t4021 = t151 * t4020;
  t4023 = 0.4e1 * t780 * t434 * t1183 - 0.3e1 * t742 * t1422 * t326 - 0.6e1 * t2096 * t1426 * t326 + 0.6e1 * t2120 * t1426 * t302 - 0.3e1 * t742 * t1443 * t302 + 0.2e1 * t780 * t1443 * t326 + 0.3e1 * t290 * t3939 + 0.3e1 * t290 * t3960 - t308 * t3981 - t308 * t4021 + 0.2e1 * t780 * t3969;
  t4024 = -0.6e1 * t742 * t1127 * t433 - 0.6e1 * t742 * t1145 * t433 - 0.6e1 * t742 * t421 * t1183 + 0.6e1 * t737 * t1422 * t302 + 0.6e1 * t3285 * t1407 - 0.6e1 * t2104 * t3907 + 0.12e2 * t2541 * t3920 - 0.12e2 * t2923 * t3917 + 0.6e1 * t737 * t3910 + 0.12e2 * t737 * t3913 + t4023;
  t4029 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1445 - t3892 - 0.3e1 / 0.8e1 * t6 * t102 * t4024);
  tv3rhotau25 = t7 * t4029 + t1449;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4033 = t39 * t1223;
  t4034 = t189 * t4033;
  t4037 = t1642 * t1518;
  t4038 = t1640 * t4037;
  t4040 = t362 * t1211;
  t4043 = t1228 * t357;
  t4046 = t362 * t1223;
  t4050 = t75 * t1518;
  t4051 = t1551 * t4050;
  t4053 = -0.3e1 / 0.32e2 * t3127 - 0.15e2 * t4051;
  t4054 = t86 * t4053;
  t4058 = t1532 * t1518;
  t4061 = t3119 * t357;
  t4064 = t188 * t1228;
  t4071 = t1211 * t357;
  t4072 = t86 * t4071;
  t4080 = 0.125e3 / 0.25509168e8 * t1668 * t4037 - 0.125e3 / 0.25509168e8 * t4038;
  t4082 = t529 * t357;
  t4083 = t525 * t4082;
  t4086 = t1518 * t79;
  t4090 = t39 * t1211;
  t4091 = t189 * t4090;
  t4094 = -0.18e2 * t3158 * t1201 - 0.9e1 * t862 * t4034 + 0.125e3 / 0.25509168e8 * t4038 + 0.6e1 * t541 * t4040 - 0.3e1 * t206 * t4043 - 0.3e1 * t206 * t4046 - t206 * t4054 + 0.18e2 * t3155 * t1197 - 0.9e1 / 0.4e1 * t857 * t4058 + 0.9e1 / 0.8e1 * t862 * t4061 + 0.9e1 * t4064 * t349 - 0.9e1 / 0.8e1 * t188 * t362 * t529 * t59 - 0.6e1 * t1629 * t4072 + 0.6e1 * t541 * t358 * t1223 + t80 * t4080 - 0.18e2 * t2694 * t4083 + 0.6e1 * t1515 * t4086 * t86 + 0.18e2 * t2253 * t4091;
  t4098 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4094);
  tv3sigma30 = t7 * t4098;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4099 = t1642 * t2004;
  t4101 = t1963 * t4099;
  t4103 = 0.125e3 / 0.25509168e8 * t1942 * t4099 - 0.125e3 / 0.25509168e8 * t4101;
  t4105 = t2004 * t144;
  t4109 = t107 * t1252;
  t4110 = t291 * t4109;
  t4113 = t768 * t381;
  t4114 = t764 * t4113;
  t4119 = t107 * t1264;
  t4120 = t291 * t4119;
  t4124 = t386 * t1252;
  t4127 = t1269 * t381;
  t4130 = t386 * t1264;
  t4134 = t140 * t2004;
  t4135 = t2034 * t4134;
  t4137 = -0.3e1 / 0.32e2 * t3278 - 0.15e2 * t4135;
  t4138 = t151 * t4137;
  t4142 = t2017 * t2004;
  t4145 = t3296 * t381;
  t4148 = t290 * t1269;
  t4158 = t1252 * t381;
  t4159 = t151 * t4158;
  t4162 = t145 * t4103 + 0.6e1 * t2002 * t4105 * t151 + 0.18e2 * t2541 * t4110 - 0.18e2 * t2923 * t4114 - 0.18e2 * t3323 * t1242 - 0.9e1 * t960 * t4120 + 0.125e3 / 0.25509168e8 * t4101 + 0.6e1 * t780 * t4124 - 0.3e1 * t308 * t4127 - 0.3e1 * t308 * t4130 - t308 * t4138 + 0.18e2 * t3320 * t1238 - 0.9e1 / 0.4e1 * t955 * t4142 + 0.9e1 / 0.8e1 * t960 * t4145 + 0.9e1 * t4148 * t373 + 0.6e1 * t780 * t382 * t1264 - 0.9e1 / 0.8e1 * t290 * t386 * t768 * t124 - 0.6e1 * t2096 * t4159;
  t4166 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4162);
  tv3sigma39 = t7 * t4166;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4195 = t1290 * t52;
  t4196 = t4195 * t1277;
  t4201 = -0.6e1 * t503 * t1284 * t357 - 0.6e1 * t503 * t1291 * t357 - 0.3e1 * t503 * t397 * t1223 + 0.3e1 / 0.4e1 * t188 * t86 * t2730 * t67 + 0.4e1 * t541 * t1301 * t357 + 0.4e1 * t541 * t1312 * t357 + 0.2e1 * t541 * t410 * t1223 - 0.12e2 * t3545 * t1201 + 0.12e2 * t3554 * t1201 + 0.12e2 * t3155 * t1278 + 0.12e2 * t857 * t4196 - 0.6e1 * t3158 * t1295;
  t4202 = t1311 * t52;
  t4203 = t4202 * t1277;
  t4206 = t1228 * t409;
  t4208 = t362 * t1311;
  t4212 = t1532 * t2730;
  t4214 = t75 * t2730;
  t4215 = t1551 * t4214;
  t4217 = t562 * t3469;
  t4219 = 0.3e1 / 0.4e1 * t3502 - 0.9e1 / 0.4e1 * t4212 + 0.12e3 * t4215 - 0.18e3 * t4217;
  t4220 = t86 * t4219;
  t4222 = t1228 * t396;
  t4225 = t362 * t1290;
  t4228 = t396 * t529;
  t4229 = t4228 * t59;
  t4235 = t409 * t529;
  t4236 = t4235 * t59;
  t4242 = t79 * t86;
  t4243 = t4242 * t396;
  t4246 = t409 * t53;
  t4247 = t209 * t529;
  t4248 = t4246 * t4247;
  t4251 = -0.6e1 * t862 * t4203 - t206 * t4206 - 0.2e1 * t206 * t4208 - t206 * t4220 + 0.3e1 * t188 * t4222 + 0.6e1 * t188 * t4225 - 0.3e1 / 0.4e1 * t857 * t4229 + 0.6e1 * t1685 * t397 * t1211 + 0.3e1 / 0.8e1 * t862 * t4236 - 0.6e1 * t1629 * t410 * t1211 + 0.6e1 * t1197 * t4243 - 0.6e1 * t2694 * t4248;
  t4252 = t4201 + t4251;
  t4256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4252);
  tv3sigma2tau0 = t7 * t4256;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4257 = t1269 * t420;
  t4260 = t386 * t1333;
  t4263 = t1269 * t433;
  t4265 = t386 * t1354;
  t4269 = t2017 * t2952;
  t4271 = t140 * t2952;
  t4272 = t2034 * t4271;
  t4274 = t801 * t3622;
  t4276 = 0.3e1 / 0.4e1 * t3648 - 0.9e1 / 0.4e1 * t4269 + 0.12e3 * t4272 - 0.18e3 * t4274;
  t4277 = t151 * t4276;
  t4279 = t433 * t768;
  t4280 = t4279 * t124;
  t4286 = t420 * t768;
  t4287 = t4286 * t124;
  t4302 = 0.3e1 * t290 * t4257 + 0.6e1 * t290 * t4260 - t308 * t4263 - 0.2e1 * t308 * t4265 - t308 * t4277 + 0.3e1 / 0.8e1 * t960 * t4280 - 0.6e1 * t2096 * t434 * t1252 - 0.3e1 / 0.4e1 * t955 * t4287 + 0.6e1 * t2120 * t421 * t1252 + 0.4e1 * t780 * t1344 * t381 + 0.4e1 * t780 * t1355 * t381 + 0.2e1 * t780 * t434 * t1264;
  t4322 = t1333 * t120;
  t4323 = t4322 * t1320;
  t4328 = t1354 * t120;
  t4329 = t4328 * t1320;
  t4332 = t144 * t151;
  t4333 = t4332 * t420;
  t4336 = t433 * t121;
  t4337 = t311 * t768;
  t4338 = t4336 * t4337;
  t4341 = -0.6e1 * t742 * t1327 * t381 - 0.6e1 * t742 * t1334 * t381 - 0.3e1 * t742 * t421 * t1264 + 0.3e1 / 0.4e1 * t290 * t151 * t2952 * t132 + 0.12e2 * t3741 * t1242 - 0.12e2 * t3732 * t1242 + 0.12e2 * t3320 * t1321 + 0.12e2 * t955 * t4323 - 0.6e1 * t3323 * t1338 - 0.6e1 * t960 * t4329 + 0.6e1 * t1238 * t4333 - 0.6e1 * t2923 * t4338;
  t4342 = t4302 + t4341;
  t4346 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4342);
  tv3sigma2tau11 = t7 * t4346;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4347 = t4242 * t1362;
  t4350 = t1363 * t357;
  t4353 = t362 * t1362;
  t4356 = t397 * t1290;
  t4361 = t3772 * t357;
  t4373 = t1377 * t52;
  t4374 = t4373 * t1277;
  t4381 = t362 * t1377;
  t4385 = t1532 * t3799;
  t4387 = -0.4e1 * t3800 + 0.6e1 * t4385;
  t4388 = t86 * t4387;
  t4391 = t1381 * t52;
  t4392 = t4391 * t1277;
  t4398 = t362 * t1381;
  t4404 = t1398 * t52;
  t4405 = t4404 * t1277;
  t4411 = t362 * t1398;
  t4415 = t1541 * t3799;
  t4417 = t75 * t3799;
  t4418 = t1551 * t4417;
  t4420 = t562 * t3854;
  t4422 = t214 * t3862;
  t4424 = -0.6e1 * t3800 + 0.36e2 * t4385 - 0.36e2 * t4415 - 0.96e3 * t4418 + 0.288e4 * t4420 - 0.2016e4 * t4422;
  t4425 = t86 * t4424;
  t4427 = 0.4e1 * t541 * t410 * t1311 - 0.3e1 * t503 * t1378 * t357 - 0.6e1 * t1629 * t1382 * t357 + 0.2e1 * t541 * t1399 * t357 + 0.3e1 * t188 * t4381 + 0.3e1 * t188 * t4388 - t206 * t4411 - t206 * t4425 + 0.6e1 * t2253 * t4392 + 0.2e1 * t541 * t4398 - 0.3e1 * t862 * t4405;
  t4428 = -0.6e1 * t503 * t1284 * t409 - 0.6e1 * t503 * t1291 * t409 - 0.6e1 * t503 * t397 * t1311 - 0.12e2 * t3545 * t1295 - 0.6e1 * t1650 * t4350 + 0.12e2 * t2253 * t4361 + 0.6e1 * t349 * t4347 + 0.6e1 * t498 * t4353 + 0.12e2 * t498 * t4356 + 0.6e1 * t857 * t4374 + t4427;
  t4432 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4428);
  tv3sigmatau20 = t7 * t4432;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4433 = t4332 * t1406;
  t4436 = t1407 * t381;
  t4439 = t386 * t1406;
  t4442 = t421 * t1333;
  t4447 = t3916 * t381;
  t4459 = t1421 * t120;
  t4460 = t4459 * t1320;
  t4467 = t386 * t1421;
  t4471 = t2017 * t3943;
  t4473 = -0.4e1 * t3944 + 0.6e1 * t4471;
  t4474 = t151 * t4473;
  t4477 = t1425 * t120;
  t4478 = t4477 * t1320;
  t4484 = t386 * t1425;
  t4490 = t1442 * t120;
  t4491 = t4490 * t1320;
  t4497 = t386 * t1442;
  t4501 = t2026 * t3943;
  t4503 = t140 * t3943;
  t4504 = t2034 * t4503;
  t4506 = t801 * t3998;
  t4508 = t316 * t4006;
  t4510 = -0.6e1 * t3944 + 0.36e2 * t4471 - 0.36e2 * t4501 - 0.96e3 * t4504 + 0.288e4 * t4506 - 0.2016e4 * t4508;
  t4511 = t151 * t4510;
  t4513 = 0.4e1 * t780 * t434 * t1354 - 0.3e1 * t742 * t1422 * t381 - 0.6e1 * t2096 * t1426 * t381 + 0.2e1 * t780 * t1443 * t381 + 0.6e1 * t2541 * t4478 + 0.3e1 * t290 * t4467 + 0.3e1 * t290 * t4474 - t308 * t4497 - t308 * t4511 + 0.2e1 * t780 * t4484 - 0.3e1 * t960 * t4491;
  t4514 = -0.6e1 * t742 * t1327 * t433 - 0.6e1 * t742 * t1334 * t433 - 0.6e1 * t742 * t421 * t1354 - 0.12e2 * t3732 * t1338 - 0.6e1 * t2104 * t4436 + 0.12e2 * t2541 * t4447 + 0.6e1 * t373 * t4433 + 0.6e1 * t737 * t4439 + 0.12e2 * t737 * t4442 + 0.6e1 * t955 * t4460 + t4513;
  t4518 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4514);
  tv3sigmatau28 = t7 * t4518;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4519 = t1362 * t396;
  t4520 = t4519 * t79;
  t4523 = t1363 * t409;
  t4526 = t397 * t1377;
  t4538 = 0.1e1 / t527;
  t4540 = 0.48e2 * t4538 * t67;
  t4541 = t1532 * t4538;
  t4543 = t1541 * t4538;
  t4545 = t4540 - 0.144e3 * t4541 + 0.96e2 * t4543;
  t4546 = t86 * t4545;
  t4549 = t1381 * t409;
  t4550 = t86 * t4549;
  t4560 = t75 * t4538;
  t4563 = t219 * t4538;
  t4566 = t573 * t4538;
  t4569 = t1560 * t4538;
  t4572 = -0.48e3 * t1515 * t4538 + 0.768e4 * t1551 * t4560 + 0.48384e5 * t214 * t4566 - 0.3456e5 * t562 * t4563 - 0.21504e5 * t72 * t4569 + t4540 - 0.432e3 * t4541 + 0.864e3 * t4543;
  t4573 = t86 * t4572;
  t4575 = -0.9e1 * t503 * t1378 * t409 + 0.18e2 * t1685 * t397 * t1381 - 0.9e1 * t503 * t397 * t1398 + 0.6e1 * t541 * t410 * t1398 - 0.6e1 * t1629 * t4550 - 0.18e2 * t1650 * t4523 + 0.3e1 * t188 * t4546 - t206 * t4573 + 0.6e1 * t4520 * t86 + 0.18e2 * t498 * t4526;
  t4579 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4575);
  tv3tau30 = t7 * t4579;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4580 = t1406 * t420;
  t4581 = t4580 * t144;
  t4584 = t1407 * t433;
  t4587 = t421 * t1421;
  t4599 = 0.1e1 / t766;
  t4601 = 0.48e2 * t4599 * t132;
  t4602 = t2017 * t4599;
  t4604 = t2026 * t4599;
  t4606 = t4601 - 0.144e3 * t4602 + 0.96e2 * t4604;
  t4607 = t151 * t4606;
  t4610 = t1425 * t433;
  t4611 = t151 * t4610;
  t4621 = t140 * t4599;
  t4624 = t321 * t4599;
  t4627 = t812 * t4599;
  t4630 = t2012 * t4599;
  t4633 = -0.21504e5 * t137 * t4630 - 0.48e3 * t2002 * t4599 + 0.768e4 * t2034 * t4621 + 0.48384e5 * t316 * t4627 - 0.3456e5 * t801 * t4624 + t4601 - 0.432e3 * t4602 + 0.864e3 * t4604;
  t4634 = t151 * t4633;
  t4636 = -0.9e1 * t742 * t1422 * t433 + 0.18e2 * t2120 * t421 * t1425 - 0.9e1 * t742 * t421 * t1442 + 0.6e1 * t780 * t434 * t1442 + 0.6e1 * t4581 * t151 - 0.6e1 * t2096 * t4611 - 0.18e2 * t2104 * t4584 + 0.3e1 * t290 * t4607 - t308 * t4634 + 0.18e2 * t737 * t4587;
  t4640 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4636);
  tv3tau33 = t7 * t4640;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t4644 = t6 * t1481 * t235;
  t4646 = t6 * t462 * t594;
  t4652 = t6 * t1493 * t235;
  t4655 = t6 * t471 * t594;
  t4658 = t6 * t172 * t1690;
  t4665 = t176 / t1666 / t81 * t1642;
  t4666 = t484 * t484;
  t4671 = t4666 / t37 / t1517 / t847 * t34;
  t4674 = t1517 * t486;
  t4676 = t1644 / t4674;
  t4681 = t485 / t36 / t3081;
  t4685 = 0.1e1 / t37 / t847;
  t4686 = t181 * t4685;
  t4692 = t176 / t1638 / t43 * t1642;
  t4694 = 0.16e6 / 0.31381059609e11 * t4692 * t4671;
  t4696 = 0.88e5 / 0.43046721e8 * t1640 * t4676;
  t4698 = 0.1958e6 / 0.4782969e7 * t481 * t4681;
  t4700 = 0.2618e5 / 0.19683e5 * t180 * t4686;
  t4706 = t224 * t581;
  t4710 = t62 * t540;
  t4750 = 0.24e2 * t1592 * t233 + t80 * (-0.16e6 / 0.31381059609e11 * t4665 * t4671 + 0.88e5 / 0.43046721e8 * t1668 * t4676 - 0.1958e6 / 0.4782969e7 * t587 * t4681 + 0.2618e5 / 0.19683e5 * t230 * t4686 + t4694 - t4696 + t4698 - t4700) - 0.72e2 * t2694 * t2340 * t535 - t4698 + t4700 + 0.72e2 * t2253 * t4706 * t200 + 0.72e2 * t4710 * t500 * t542 + 0.36e2 * t1685 * t536 * t542 + t4696 + 0.8e1 * t541 * t1589 * t224 - 0.36e2 * t503 * t1509 * t200 - 0.12e2 * t503 * t1589 * t200 + 0.72e2 * t1685 * t1503 * t200 + 0.24e2 * t541 * t546 * t581 - 0.36e2 * t503 * t1506 * t200 + 0.24e2 * t498 * t1624 * t200 - 0.12e2 * t503 * t1624 * t224 - 0.36e2 * t1650 * t500 * t581 - 0.72e2 * t1650 * t1595 * t224 + 0.72e2 * t498 * t507 * t535;
  t4754 = t63 * t1628;
  t4764 = tau[0] * t1525;
  t4768 = 0.616e4 / 0.81e2 * t4764 - 0.2618e4 / 0.81e2 * sigma[0] * t4685;
  t4773 = t522 * t522;
  t4776 = t1522 * t194;
  t4783 = t1528 * tau[0] * t39;
  t4786 = t1551 * t219;
  t4791 = t214 * t1560;
  t4792 = t1519 * t194;
  t4796 = t522 * t526 * t529;
  t4799 = t1533 * t184;
  t4802 = t1537 * t184;
  t4805 = t562 * t573;
  t4807 = t510 * t526 * t529;
  t4810 = t1542 * t849;
  t4813 = t53 * t75;
  t4819 = t52 * t556;
  t4826 = 0.24e2 * t197 * t4768 + 0.288e3 * t1606 * t522 + 0.144e3 * t513 * t4773 + 0.45056e6 / 0.3e1 * t566 * t4776 + 0.288e4 * t1532 * t194 * t1538 + 0.1536e5 * t566 * t4783 + 0.3072e6 * t4786 * t1552 * tau[0] * t39 + 0.7168e7 / 0.3e1 * t4791 * t4792 + 0.2688e6 * t1571 * t4796 - 0.3072e6 * t1583 * t4799 - 0.6144e5 * t566 * t4802 + 0.1344e7 * t4805 * t4807 - 0.14336e7 * t1571 * t4810 + 0.8e5 / 0.3e1 * t4813 * t4792 + 0.768e4 * t562 * t1529 * t194 + 0.96e4 * t4819 * t4807 + 0.48e3 * t525 * t4783 + 0.48e4 * t1541 * t4796;
  t4848 = 0.1e1 / t572 / t58;
  t4849 = t526 * t526;
  t4852 = 0.1e1 / t37 / t2238;
  t4859 = t1516 * t3082;
  t4862 = t1552 * t209;
  t4868 = t65 * t219;
  t4869 = t4849 * t4852;
  t4875 = t526 * t489;
  t4880 = params->b * t53;
  t4881 = t510 * t510;
  t4888 = 0.121856e8 / 0.27e2 * t72 * t574 * t489 - 0.78848e6 / 0.27e2 * t72 * t220 * t1525 - 0.384e4 * t1532 * t4799 - 0.192e4 * t525 * t4802 - 0.256e5 * t1541 * t4810 - 0.14336e8 / 0.9e1 * t72 * t1561 * t3082 + 0.1408e5 / 0.3e1 * t525 * t4776 + 0.4608e5 * t1551 * t563 * t522 + 0.448e7 / 0.3e1 * t72 * t4848 * t4849 * t4852 + 0.2304e6 * t1583 * t1512 * t190 - 0.32e6 / 0.9e1 * t1515 * t4859 + 0.96e3 * t4862 * t190 + 0.192e3 * t513 * t194 * t1528 + 0.2e6 / 0.9e1 * t4868 * t4869 + 0.384e3 * t214 * t75 * t4768 + 0.4352e6 / 0.27e2 * t557 * t4875 - 0.4928e5 / 0.27e2 * t210 * t4764 + 0.2304e5 * t4880 * t75 * t4881 + 0.576e4 * t562 * t75 * t4773;
  t4921 = t510 * t209;
  t4938 = -0.8e3 * t1532 * t4796 - 0.32e5 / 0.9e1 * t4819 * t4792 - 0.32e3 / 0.3e1 * t513 * t4783 + 0.64e5 / 0.9e1 * t1541 * t4859 - 0.1088e6 / 0.27e2 * t525 * t4875 + 0.4928e5 / 0.81e2 * t197 * t4764 - 0.32e3 * t2318 * t1538 + 0.128e4 / 0.3e1 * t1606 * t518 - 0.8e3 * t4921 * t530 - 0.1e6 / 0.27e2 * t4813 * t4869 + 0.128e5 / 0.3e1 * t1532 * t4810 + 0.128e4 / 0.3e1 * t513 * t4802 - 0.2816e5 / 0.27e2 * t513 * t4776 - 0.24e2 * t4773 * t59 - 0.32e2 * t870 * t1528 - 0.8e1 * t189 * t4768;
  t4945 = t1591 * t205;
  t4962 = t581 * t581;
  t4966 = t535 * t535;
  t4972 = t64 / t1627 / t78;
  t4973 = t542 * t542;
  t4977 = -0.24e2 * t1629 * t233 * t1630 + 0.12e2 * t188 * t1683 * t200 + 0.3e1 * t188 * t86 * t4938 + 0.18e2 * t188 * t592 * t535 + 0.6e1 * t541 * t86 * t4962 + 0.18e2 * t498 * t86 * t4966 + 0.24e2 * t4972 * t86 * t4973 + 0.36e2 * t498 * t592 * t499 + 0.12e2 * t541 * t592 * t542 - 0.24e2 * t4945 * t225 + 0.36e2 * t2306 * t536;
  t4985 = t6 * t1469 * t171 * t88;
  t4989 = t6 * t457 * t470 * t88;
  t4993 = t6 * t165 * t1492 * t88;
  t4996 = 0.1e1 / t170 / t448;
  t5000 = 0.1e2 / 0.27e2 * t6 * t26 * t4996 * t88;
  t5001 = t20 * t20;
  t5003 = 0.1e1 / t443 / t5001;
  t5004 = t445 * t445;
  t5010 = t453 * t453;
  t5016 = 0.1e1 / t1460 / t7;
  t5017 = t17 * t5016;
  t5020 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1461 + 0.24e2 * t5017);
  t5024 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5003 * t5004 - 0.16e2 / 0.9e1 * t1453 * t445 * t453 + 0.4e1 / 0.3e1 * t444 * t5010 + 0.16e2 / 0.9e1 * t1457 * t1465 + 0.4e1 / 0.3e1 * t24 * t5020);
  t5033 = t6 * t1474 * t235;
  t5038 = t4644 - 0.3e1 / 0.2e1 * t4646 - 0.3e1 / 0.2e1 * t6 * t166 * t1690 - 0.5e1 / 0.9e1 * t4652 + t4655 / 0.2e1 - t4658 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t4750 - 0.36e2 * t503 * t1601 * t224 - 0.72e2 * t4754 * t1631 * t200 - 0.36e2 * t1629 * t543 * t581 - 0.18e2 * t503 * t536 * t581 - t4694 - t206 * t86 * (t4826 + t4888) - 0.4e1 * t206 * t1683 * t224 - 0.6e1 * t206 * t592 * t581 - 0.4e1 * t206 * t233 * t1588 + 0.12e2 * t188 * t233 * t1623 + t4977) - t4985 / 0.2e1 + t4989 / 0.2e1 - 0.5e1 / 0.9e1 * t4993 + t5000 - 0.3e1 / 0.8e1 * t6 * t5024 * t27 * t88 - 0.3e1 / 0.2e1 * t6 * t1470 * t235 - 0.3e1 / 0.2e1 * t5033 - 0.9e1 / 0.4e1 * t6 * t458 * t594;
  t5039 = my_piecewise3(t2, 0, t5038);
  t5040 = t97 * t97;
  t5042 = 0.1e1 / t600 / t5040;
  t5043 = t602 * t602;
  t5049 = t608 * t608;
  t5054 = t94 * t5016;
  t5057 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1461 + 0.24e2 * t5054);
  t5061 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t5043 - 0.16e2 / 0.9e1 * t1697 * t602 * t608 + 0.4e1 / 0.3e1 * t601 * t5049 + 0.16e2 / 0.9e1 * t1701 * t1707 + 0.4e1 / 0.3e1 * t99 * t5057);
  t5068 = t6 * t1711 * t171 * t153;
  t5072 = t6 * t612 * t470 * t153;
  t5076 = t6 * t246 * t1492 * t153;
  t5081 = 0.1e2 / 0.27e2 * t6 * t101 * t4996 * t153;
  t5083 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t5061 * t27 * t153 - t5068 / 0.2e1 + t5072 / 0.2e1 - 0.5e1 / 0.9e1 * t5076 + t5081);
  tv4rho40 = 0.4e1 * t1695 + 0.4e1 * t1729 + t7 * (t5039 + t5083);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t5104 = 0.12e2 * t1461;
  t5105 = 0.24e2 * t5017;
  t5107 = my_piecewise5(t11, 0, t15, 0, -t5104 + t5105);
  t5111 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5003 * t260 * t1454 - 0.8e1 / 0.9e1 * t1453 * t633 * t445 - 0.8e1 / 0.9e1 * t1734 * t162 * t453 + 0.4e1 / 0.3e1 * t444 * t1745 * t162 + 0.4e1 / 0.3e1 * t1737 * t453 + 0.4e1 / 0.9e1 * t629 * t1465 + 0.4e1 / 0.3e1 * t24 * t5107);
  t5120 = t6 * t1754 * t235;
  t5126 = t6 * t1761 * t235;
  t5127 = t5126 / 0.4e1;
  t5129 = t6 * t642 * t594;
  t5141 = t6 * t1749 * t171 * t88;
  t5145 = t6 * t637 * t470 * t88;
  t5146 = t5145 / 0.4e1;
  t5149 = t6 * t263 * t1492 * t88;
  t5155 = -0.3e1 / 0.8e1 * t6 * t5111 * t27 * t88 - 0.9e1 / 0.8e1 * t6 * t1750 * t235 - 0.3e1 / 0.4e1 * t5120 - 0.9e1 / 0.8e1 * t6 * t638 * t594 + t5127 - 0.3e1 / 0.8e1 * t5129 - 0.3e1 / 0.8e1 * t6 * t264 * t1690 + t4644 / 0.2e1 - 0.3e1 / 0.8e1 * t4646 - 0.5e1 / 0.12e2 * t4652 + t4655 / 0.4e1 - t4658 / 0.8e1 - 0.3e1 / 0.8e1 * t5141 + t5146 - 0.5e1 / 0.36e2 * t5149 - t4985 / 0.8e1 + t4989 / 0.4e1 - 0.5e1 / 0.12e2 * t4993 + t5000 - 0.3e1 / 0.8e1 * t5033;
  t5156 = my_piecewise3(t2, 0, t5155);
  t5173 = 0.24e2 * t5054;
  t5175 = my_piecewise5(t15, 0, t11, 0, t5104 + t5173);
  t5179 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t271 * t1698 - 0.8e1 / 0.9e1 * t1697 * t657 * t602 - 0.8e1 / 0.9e1 * t1778 * t243 * t608 + 0.4e1 / 0.3e1 * t601 * t1788 * t243 + 0.4e1 / 0.3e1 * t1781 * t608 + 0.4e1 / 0.9e1 * t653 * t1707 + 0.4e1 / 0.3e1 * t99 * t5175);
  t5186 = t6 * t1792 * t171 * t153;
  t5190 = t6 * t661 * t470 * t153;
  t5191 = t5190 / 0.4e1;
  t5194 = t6 * t274 * t1492 * t153;
  t5203 = t6 * t1716 * t337;
  t5206 = t6 * t1720 * t337;
  t5207 = t5206 / 0.4e1;
  t5209 = t6 * t1724 * t337;
  t5211 = -0.3e1 / 0.8e1 * t6 * t5179 * t27 * t153 - 0.3e1 / 0.8e1 * t5186 + t5191 - 0.5e1 / 0.36e2 * t5194 - t5068 / 0.8e1 + t5072 / 0.4e1 - 0.5e1 / 0.12e2 * t5076 + t5081 - 0.3e1 / 0.8e1 * t6 * t1712 * t337 - 0.3e1 / 0.8e1 * t5203 + t5207 - 0.5e1 / 0.36e2 * t5209;
  t5212 = my_piecewise3(t93, 0, t5211);
  tv4rho41 = t1695 + t1729 + 0.3e1 * t1777 + 0.3e1 * t1817 + t7 * (t5156 + t5212);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t5227 = t633 * t633;
  t5240 = my_piecewise5(t11, 0, t15, 0, t5105);
  t5244 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5003 * t683 * t445 - 0.32e2 / 0.27e2 * t1734 * t162 * t633 - 0.8e1 / 0.27e2 * t1820 * t453 + 0.8e1 / 0.9e1 * t444 * t5227 + 0.8e1 / 0.9e1 * t629 * t1745 - 0.8e1 / 0.27e2 * t1453 * t688 * t445 + 0.8e1 / 0.9e1 * t444 * t1829 * t162 + 0.4e1 / 0.9e1 * t1825 * t453 + 0.4e1 / 0.3e1 * t24 * t5240);
  t5253 = t6 * t1838 * t235;
  t5266 = t6 * t1833 * t171 * t88;
  t5270 = t6 * t692 * t470 * t88;
  t5277 = -0.3e1 / 0.8e1 * t6 * t5244 * t27 * t88 - 0.3e1 / 0.4e1 * t6 * t1834 * t235 - t5253 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t693 * t594 - t5120 / 0.2e1 + t5126 / 0.3e1 - t5129 / 0.4e1 + t4644 / 0.6e1 - 0.5e1 / 0.18e2 * t4652 + t4655 / 0.12e2 - t5266 / 0.4e1 + t5270 / 0.12e2 - t5141 / 0.4e1 + t5145 / 0.3e1 - 0.5e1 / 0.18e2 * t5149 + t4989 / 0.12e2 - 0.5e1 / 0.18e2 * t4993 + t5000;
  t5278 = my_piecewise3(t2, 0, t5277);
  t5287 = t657 * t657;
  t5300 = my_piecewise5(t15, 0, t11, 0, t5173);
  t5304 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t700 * t602 - 0.32e2 / 0.27e2 * t1778 * t243 * t657 - 0.8e1 / 0.27e2 * t1850 * t608 + 0.8e1 / 0.9e1 * t601 * t5287 + 0.8e1 / 0.9e1 * t653 * t1788 - 0.8e1 / 0.27e2 * t1697 * t705 * t602 + 0.8e1 / 0.9e1 * t601 * t1859 * t243 + 0.4e1 / 0.9e1 * t1855 * t608 + 0.4e1 / 0.3e1 * t99 * t5300);
  t5311 = t6 * t1863 * t171 * t153;
  t5315 = t6 * t709 * t470 * t153;
  t5324 = t6 * t1797 * t337;
  t5327 = t6 * t1801 * t337;
  t5338 = t6 * t617 * t833;
  t5341 = t6 * t621 * t833;
  t5343 = -0.3e1 / 0.8e1 * t6 * t5304 * t27 * t153 - t5311 / 0.4e1 + t5315 / 0.12e2 - t5186 / 0.4e1 + t5190 / 0.3e1 - 0.5e1 / 0.18e2 * t5194 - 0.3e1 / 0.4e1 * t6 * t1793 * t337 - t5324 / 0.2e1 + t5327 / 0.6e1 + t5072 / 0.12e2 - 0.5e1 / 0.18e2 * t5076 + t5081 - t5203 / 0.4e1 + t5206 / 0.3e1 - 0.5e1 / 0.18e2 * t5209 - 0.3e1 / 0.8e1 * t6 * t613 * t833 - t5338 / 0.4e1 + t5341 / 0.12e2;
  t5344 = my_piecewise3(t93, 0, t5343);
  tv4rho42 = 0.2e1 * t1777 + 0.2e1 * t1817 + 0.2e1 * t1849 + 0.2e1 * t1888 + t7 * (t5278 + t5344);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t5365 = my_piecewise5(t11, 0, t15, 0, t5104 + t5105);
  t5369 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5003 * t1893 * t162 - 0.8e1 / 0.9e1 * t1820 * t633 - 0.8e1 / 0.9e1 * t1734 * t688 * t162 + 0.4e1 / 0.3e1 * t1737 * t688 + 0.4e1 / 0.3e1 * t629 * t1829 + 0.4e1 / 0.9e1 * t444 * t1900 * t162 + 0.4e1 / 0.3e1 * t24 * t5365);
  t5376 = t6 * t1904 * t171 * t88;
  t5387 = -0.3e1 / 0.8e1 * t6 * t5369 * t27 * t88 - t5376 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1905 * t235 - 0.3e1 / 0.8e1 * t5266 + t5270 / 0.4e1 - 0.3e1 / 0.8e1 * t5253 + t5146 - 0.5e1 / 0.12e2 * t5149 + t5127 - 0.5e1 / 0.36e2 * t4993 + t5000 - 0.5e1 / 0.36e2 * t4652;
  t5388 = my_piecewise3(t2, 0, t5387);
  t5405 = my_piecewise5(t15, 0, t11, 0, -t5104 + t5173);
  t5409 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t1913 * t243 - 0.8e1 / 0.9e1 * t1850 * t657 - 0.8e1 / 0.9e1 * t1778 * t705 * t243 + 0.4e1 / 0.3e1 * t1781 * t705 + 0.4e1 / 0.3e1 * t653 * t1859 + 0.4e1 / 0.9e1 * t601 * t1920 * t243 + 0.4e1 / 0.3e1 * t99 * t5405);
  t5416 = t6 * t1924 * t171 * t153;
  t5424 = t6 * t1868 * t337;
  t5433 = t6 * t666 * t833;
  t5443 = t6 * t251 * t2125;
  t5445 = -0.3e1 / 0.8e1 * t6 * t5409 * t27 * t153 - t5416 / 0.8e1 - 0.3e1 / 0.8e1 * t5311 + t5315 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1864 * t337 - 0.3e1 / 0.8e1 * t5424 + t5191 - 0.5e1 / 0.12e2 * t5194 - 0.3e1 / 0.4e1 * t5324 + t5327 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t662 * t833 - 0.3e1 / 0.8e1 * t5433 - 0.5e1 / 0.36e2 * t5076 + t5081 + t5207 - 0.5e1 / 0.12e2 * t5209 - 0.3e1 / 0.8e1 * t5338 + t5341 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t247 * t2125 - t5443 / 0.8e1;
  t5446 = my_piecewise3(t93, 0, t5445);
  tv4rho43 = 0.3e1 * t1849 + 0.3e1 * t1888 + t1912 + t2130 + t7 * (t5388 + t5446);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t5451 = t683 * t683;
  t5456 = t688 * t688;
  t5463 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1461 + 0.24e2 * t5017);
  t5467 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5003 * t5451 - 0.16e2 / 0.9e1 * t1820 * t688 + 0.4e1 / 0.3e1 * t444 * t5456 + 0.16e2 / 0.9e1 * t629 * t1900 + 0.4e1 / 0.3e1 * t24 * t5463);
  t5476 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t5467 * t27 * t88 - t5376 / 0.2e1 + t5270 / 0.2e1 - 0.5e1 / 0.9e1 * t5149 + t5000);
  t5477 = t700 * t700;
  t5482 = t705 * t705;
  t5489 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1461 + 0.24e2 * t5054);
  t5493 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t5477 - 0.16e2 / 0.9e1 * t1850 * t705 + 0.4e1 / 0.3e1 * t601 * t5482 + 0.16e2 / 0.9e1 * t653 * t1920 + 0.4e1 / 0.3e1 * t99 * t5489);
  t5512 = t724 / t104 / t3254;
  t5514 = 0.1958e6 / 0.4782969e7 * t722 * t5512;
  t5516 = 0.1e1 / t105 / t945;
  t5517 = t283 * t5516;
  t5519 = 0.2618e5 / 0.19683e5 * t282 * t5517;
  t5520 = t326 * t820;
  t5527 = t176 / t1961 / t111 * t1642;
  t5528 = t723 * t723;
  t5533 = t5528 / t105 / t1945 / t945 * t34;
  t5535 = 0.16e6 / 0.31381059609e11 * t5527 * t5533;
  t5541 = t176 / t1940 / t146 * t1642;
  t5544 = t1945 * t725;
  t5546 = t1944 / t5544;
  t5554 = 0.88e5 / 0.43046721e8 * t1963 * t5546;
  t5593 = -0.72e2 * t2923 * t2607 * t774 - t5514 + t5519 + 0.72e2 * t2541 * t5520 * t302 - t5535 + 0.24e2 * t2055 * t335 + t145 * (-0.16e6 / 0.31381059609e11 * t5541 * t5533 + 0.88e5 / 0.43046721e8 * t1942 * t5546 - 0.1958e6 / 0.4782969e7 * t826 * t5512 + 0.2618e5 / 0.19683e5 * t332 * t5517 + t5535 - t5554 + t5514 - t5519) + t5554 + 0.8e1 * t780 * t2052 * t326 + 0.24e2 * t780 * t1975 * t326 - 0.12e2 * t742 * t2052 * t302 - 0.36e2 * t742 * t1972 * t302 - 0.36e2 * t742 * t1975 * t302 - 0.36e2 * t742 * t2064 * t326 + 0.24e2 * t737 * t2087 * t302 - 0.12e2 * t742 * t2087 * t326 - 0.18e2 * t742 * t775 * t820 - 0.72e2 * t2104 * t2058 * t326 + 0.72e2 * t737 * t746 * t774 - 0.36e2 * t2096 * t782 * t820;
  t5600 = t128 * t2095;
  t5604 = t127 * t779;
  t5620 = t316 * t2012;
  t5622 = t296 * t2003 * t2004;
  t5625 = t1989 * t296;
  t5632 = t1993 * tau[1] * t107;
  t5635 = t2034 * t321;
  t5641 = t761 * t765 * t768;
  t5644 = t1979 * t947;
  t5647 = t2018 * t286;
  t5650 = t2022 * t286;
  t5653 = t801 * t812;
  t5655 = t749 * t765 * t768;
  t5661 = tau[1] * t1957;
  t5665 = 0.616e4 / 0.81e2 * t5661 - 0.2618e4 / 0.81e2 * sigma[2] * t5516;
  t5670 = t761 * t761;
  t5681 = t121 * t140;
  t5684 = 0.7168e7 / 0.3e1 * t5620 * t5622 + 0.45056e6 / 0.3e1 * t805 * t5625 + 0.288e4 * t2017 * t296 * t2023 + 0.1536e5 * t805 * t5632 + 0.3072e6 * t5635 * t1996 * tau[1] * t107 + 0.2688e6 * t1978 * t5641 - 0.14336e7 * t1978 * t5644 - 0.3072e6 * t2044 * t5647 - 0.6144e5 * t805 * t5650 + 0.1344e7 * t5653 * t5655 + 0.2304e6 * t2044 * t1999 * t292 + 0.24e2 * t299 * t5665 + 0.288e3 * t2069 * t761 + 0.144e3 * t752 * t5670 + 0.4608e5 * t2034 * t802 * t761 - 0.14336e8 / 0.9e1 * t137 * t2013 * t3255 + 0.48e3 * t764 * t5632 + 0.8e5 / 0.3e1 * t5681 * t5622;
  t5689 = 0.1e1 / t811 / t123;
  t5690 = t765 * t765;
  t5693 = 0.1e1 / t105 / t2504;
  t5697 = t120 * t795;
  t5716 = params->b * t121;
  t5717 = t749 * t749;
  t5724 = t2003 * t3255;
  t5727 = t765 * t728;
  t5732 = t1996 * t311;
  t5735 = t130 * t321;
  t5736 = t5690 * t5693;
  t5745 = 0.768e4 * t801 * t2008 * t296 + 0.448e7 / 0.3e1 * t137 * t5689 * t5690 * t5693 + 0.96e4 * t5697 * t5655 + 0.48e4 * t2026 * t5641 + 0.1408e5 / 0.3e1 * t764 * t5625 + 0.121856e8 / 0.27e2 * t137 * t813 * t728 - 0.78848e6 / 0.27e2 * t137 * t322 * t1957 - 0.384e4 * t2017 * t5647 - 0.192e4 * t764 * t5650 - 0.256e5 * t2026 * t5644 + 0.2304e5 * t5716 * t140 * t5717 + 0.576e4 * t801 * t140 * t5670 - 0.32e6 / 0.9e1 * t2002 * t5724 + 0.4352e6 / 0.27e2 * t796 * t5727 - 0.4928e5 / 0.27e2 * t312 * t5661 + 0.96e3 * t5732 * t292 + 0.2e6 / 0.9e1 * t5735 * t5736 + 0.384e3 * t316 * t140 * t5665 + 0.192e3 * t752 * t1993 * t296;
  t5755 = t129 / t2094 / t143;
  t5756 = t781 * t781;
  t5760 = t820 * t820;
  t5764 = t774 * t774;
  t5773 = t2054 * t307;
  t5807 = t749 * t311;
  t5818 = 0.128e5 / 0.3e1 * t2017 * t5644 + 0.128e4 / 0.3e1 * t752 * t5650 - 0.2816e5 / 0.27e2 * t752 * t5625 - 0.1088e6 / 0.27e2 * t764 * t5727 + 0.4928e5 / 0.81e2 * t299 * t5661 - 0.32e3 * t2562 * t2023 + 0.128e4 / 0.3e1 * t2069 * t757 - 0.8e3 * t2017 * t5641 - 0.32e5 / 0.9e1 * t5697 * t5622 - 0.32e3 / 0.3e1 * t752 * t5632 + 0.64e5 / 0.9e1 * t2026 * t5724 - 0.8e3 * t5807 * t769 - 0.1e6 / 0.27e2 * t5681 * t5736 - 0.24e2 * t5670 * t124 - 0.32e2 * t968 * t1993 - 0.8e1 * t291 * t5665;
  t5825 = 0.3e1 * t290 * t151 * t5818 + 0.24e2 * t5755 * t151 * t5756 + 0.6e1 * t780 * t151 * t5760 + 0.18e2 * t737 * t151 * t5764 + 0.12e2 * t290 * t1970 * t302 + 0.12e2 * t290 * t335 * t2086 + 0.18e2 * t290 * t831 * t774 + 0.36e2 * t737 * t831 * t738 + 0.12e2 * t780 * t831 * t781 + 0.36e2 * t2556 * t775 - 0.24e2 * t5773 * t327;
  t5839 = -0.3e1 / 0.8e1 * t6 * t5493 * t27 * t153 - 0.3e1 / 0.2e1 * t6 * t1925 * t337 - 0.9e1 / 0.4e1 * t6 * t710 * t833 - 0.3e1 / 0.2e1 * t6 * t275 * t2125 - 0.3e1 / 0.8e1 * t6 * t102 * (t5593 - 0.36e2 * t2104 * t739 * t820 + 0.72e2 * t2120 * t2090 * t302 - 0.72e2 * t5600 * t2098 * t302 + 0.72e2 * t5604 * t739 * t781 + 0.36e2 * t2120 * t775 * t781 - 0.4e1 * t308 * t1970 * t326 - 0.6e1 * t308 * t831 * t820 - 0.4e1 * t308 * t335 * t2051 - t308 * t151 * (t5684 + t5745) - 0.24e2 * t2096 * t335 * t2097 + t5825) + t5327 + t5341 / 0.2e1 - t5416 / 0.2e1 - 0.3e1 / 0.2e1 * t5424 - 0.3e1 / 0.2e1 * t5433 - t5443 / 0.2e1 - 0.5e1 / 0.9e1 * t5209 + t5315 / 0.2e1 - 0.5e1 / 0.9e1 * t5194 + t5081;
  t5840 = my_piecewise3(t93, 0, t5839);
  tv4rho44 = 0.4e1 * t1912 + 0.4e1 * t2130 + t7 * (t5476 + t5840);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t5848 = t6 * t1474 * t364;
  t5854 = t6 * t1481 * t364;
  t5857 = t6 * t462 * t920;
  t5864 = 0.5e1 / 0.36e2 * t6 * t1493 * t364;
  t5866 = t6 * t471 * t920;
  t5869 = t6 * t172 * t2357;
  t5891 = t1685 * t233;
  t5903 = t3082 * t526;
  t5907 = t4754 * t86;
  t5916 = 0.9e1 * t2282 * t871 + 0.18e2 * t2306 * t233 * t349 + 0.18e2 * t2307 * t871 - 0.24e2 * t2282 * t878 + 0.3e1 * t188 * t1683 * t349 - 0.12e3 * t2339 * t2345 * t2340 * tau[0] - 0.48e2 * t857 * t189 * t184 * t535 + 0.18e2 * t5891 * t2255 + 0.48e2 * t2335 * t2259 + 0.18e2 * t2253 * t870 * t2254 + 0.24e2 * t862 * t189 * t184 * t581 - 0.8e3 * t348 * t1532 * t5903 - 0.18e2 * t5907 * t189 * t39 * t1630 - 0.96e2 * t2325 * t2277 + 0.6e2 * t867 * t2319;
  t5917 = t522 * t67;
  t5921 = t194 * t209;
  t5927 = t4852 * t1516;
  t5939 = t489 * tau[0];
  t5953 = t503 * t592;
  t5966 = 0.3e2 * t348 * t5917 * t874 + 0.15e3 * t348 * t5921 * t2174 + 0.15e3 * t867 * t2322 + 0.1e4 / 0.3e1 * t348 * t4819 * t5927 + 0.176e3 * t857 * t189 * t494 * t200 - 0.88e2 * t862 * t189 * t494 * t224 + 0.544e4 / 0.9e1 * t348 * t513 * t5939 + 0.18e2 * t857 * t2287 * t858 + 0.18e2 * t857 * t870 * t2331 + 0.6e1 * t857 * t189 * t39 * t1623 - 0.9e1 * t5953 * t864 - 0.18e2 * t2335 * t2262 - 0.9e1 * t2335 * t2268 - 0.9e1 * t862 * t2287 * t863 - 0.9e1 * t862 * t870 * t2267;
  t5985 = 0.1e1 / t37 / t1517 / t527 * t1643 * t34;
  t5987 = 0.2e5 / 0.10460353203e11 * t4692 * t5985;
  t5994 = t499 * t205;
  t5995 = t5994 * t86;
  t6000 = t498 * t592;
  t6014 = -0.3e1 * t862 * t189 * t39 * t1588 - 0.48e2 * t2253 * t189 * t184 * t542 - 0.18e2 * t1629 * t907 * t542 - 0.24e3 * t348 * t2318 * t2177 + 0.48e2 * t862 * t870 * t2258 - 0.96e2 * t857 * t870 * t2276 - 0.24e3 * t867 * t2273 + 0.3e2 * t2282 * t875 + 0.6e2 * t2307 * t875 + 0.36e2 * t2325 * t2328 + 0.18e2 * t2325 * t2332 + 0.18e2 * t3109 * t2332 - 0.18e2 * t5995 * t864 + 0.18e2 * t6000 * t859 + t5987;
  t6025 = t1642 * t1646 * t484;
  t6027 = 0.95e4 / 0.14348907e8 * t1640 * t6025;
  t6061 = -0.18e2 * t1629 * t887 * t542 - 0.18e2 * t1650 * t887 * t499 - 0.18e2 * t1650 * t907 * t499 - 0.9e1 * t503 * t2155 * t200 - 0.9e1 * t503 * t2157 * t200 - 0.18e2 * t503 * t2159 * t200 - 0.9e1 * t503 * t2205 * t200 + 0.18e2 * t498 * t2210 * t200 + 0.6e1 * t541 * t2155 * t224 + 0.6e1 * t541 * t2157 * t224 + 0.12e2 * t541 * t2159 * t224 + 0.6e1 * t541 * t2205 * t224 - 0.18e2 * t503 * t2207 * t224 - 0.9e1 * t503 * t2210 * t224 - t6027;
  t6088 = t34 * t1525;
  t6090 = 0.154e4 / 0.6561e4 * t179 * t6088;
  t6102 = t849 * t194;
  t6103 = t6102 * tau[0];
  t6115 = t529 * t522;
  t6116 = t6115 * tau[0];
  t6119 = t1518 * t194;
  t6120 = t6119 * t526;
  t6139 = 0.896e5 * t214 * t573 * t3082 * t526 - 0.8704e5 / 0.3e1 * t214 * t219 * t489 * tau[0] + 0.72e3 * t1532 * t6103 - 0.288e4 * t4880 * t354 * t1552 + 0.768e4 * t1551 * t903 * t510 - 0.704e4 * t562 * t2201 * t194 - 0.9e2 * t1532 * t6116 - 0.6e3 * t4819 * t6120 + 0.192e4 * t562 * t903 * t522 - 0.24e3 * t562 * t354 * t1528 - 0.224e6 / 0.3e1 * t214 * t1560 * t4852 * t1516 + 0.19712e5 / 0.9e1 * t214 * t75 * t1525 - 0.176e3 * t513 * t494 * t194;
  t6160 = t1551 * t75;
  t6174 = 0.16e4 * t1541 * t5903 - 0.272e4 / 0.3e1 * t525 * t5939 - 0.18e2 * t2318 * t2171 - 0.9e2 * t4921 * t874 + 0.48e2 * t513 * t184 * t522 - 0.6e1 * t513 * t39 * t1528 - 0.25e4 / 0.3e1 * t4813 * t5927 + 0.48e2 * t1606 * t184 + 0.1232e4 / 0.9e1 * t197 * t1525 - 0.288e4 * t6160 * t889 * t522 - 0.288e5 * t4786 * t529 * t510 * tau[0] - 0.72e4 * t1583 * t6116 - 0.84e5 * t4805 * t6120 + 0.576e5 * t1583 * t6103;
  t6188 = -0.9e1 * t503 * t887 * t535 - 0.9e1 * t503 * t907 * t535 - 0.3e1 * t503 * t358 * t1623 + 0.2e1 * t541 * t358 * t1588 - 0.18e2 * t1650 * t2149 * t224 + 0.6e1 * t541 * t907 * t581 + 0.6e1 * t541 * t887 * t581 + 0.24e2 * t4972 * t358 * t1630 - t6090 + 0.18e2 * t1685 * t909 * t542 - t206 * t86 * (t6139 + t6174) - t206 * t362 * t1588 - t206 * t1683 * t357 - 0.3e1 * t206 * t592 * t906 - 0.3e1 * t206 * t233 * t2204;
  t6220 = t483 * t1672 * sigma[0];
  t6226 = 0.1705e5 / 0.1594323e7 * t481 * t6220;
  t6231 = t233 * t52;
  t6232 = t503 * t6231;
  t6246 = -0.3e1 * t206 * t2316 * t224 + 0.9e1 * t188 * t918 * t535 + 0.3e1 * t188 * t362 * t1623 - 0.3e1 * t206 * t918 * t581 + 0.9e1 * t188 * t2316 * t200 - 0.6e1 * t4945 * t358 + 0.6e1 * t541 * t918 * t542 + 0.18e2 * t498 * t918 * t499 - 0.6e1 * t1629 * t362 * t1630 + t80 * (0.2e5 / 0.10460353203e11 * t4665 * t5985 - 0.95e4 / 0.14348907e8 * t1668 * t6025 + 0.1705e5 / 0.1594323e7 * t587 * t6220 - 0.154e4 / 0.6561e4 * t229 * t6088 - t5987 + t6027 - t6226 + t6090) + 0.6e1 * t1592 * t362 - 0.6e2 * t6232 * t2352 - 0.18e2 * t2339 * t1277 * t581 * t200 + 0.18e2 * t3202 * t1277 * t4706 - 0.3e2 * t2350 * t2345 * t581 * tau[0];
  t6248 = t86 * t194;
  t6252 = t503 * t6248;
  t6255 = t209 * t1518;
  t6277 = t906 * t200;
  t6281 = t357 * t535;
  t6293 = 0.12e3 * t498 * t6248 * t2347 - 0.6e2 * t6252 * t2352 + 0.3e3 * t2344 * t6255 * t526 * t200 - 0.15e3 * t2350 * t6255 * t526 * t224 - 0.1232e4 / 0.9e1 * t348 * t189 * t1525 + 0.88e2 * t348 * t870 * t494 + 0.88e2 * t867 * t2298 - 0.54e2 * t5907 * t2291 * t542 + t6226 - 0.48e2 * t2307 * t878 + 0.36e2 * t2253 * t6277 * t224 + 0.18e2 * t2253 * t6281 * t224 + 0.18e2 * t2253 * t2291 * t581 - 0.18e2 * t3419 * t3203 * t581 - 0.48e2 * t867 * t2295;
  t6299 = t1528 * t59;
  t6303 = t4710 * t86;
  t6317 = t4710 * t2338;
  t6325 = t67 * t849;
  t6332 = t1650 * t6231;
  t6338 = t1650 * t6248;
  t6349 = -0.24e2 * t348 * t2287 * t184 + 0.9e1 * t867 * t2288 + 0.3e1 * t348 * t6299 * t39 + 0.36e2 * t6303 * t357 * t499 * t224 - 0.18e2 * t2694 * t2291 * t535 + 0.36e2 * t5891 * t2292 + 0.6e2 * t3202 * t2345 * t542 * tau[0] + 0.36e2 * t6317 * t1277 * t200 * t542 + 0.96e2 * t2339 * t3426 * t2340 - 0.48e3 * t2344 * t6325 * t2346 + 0.24e3 * t2350 * t6325 * t2351 - 0.36e2 * t6332 * t2341 + 0.12e3 * t498 * t6231 * t2347 - 0.36e2 * t6338 * t2341 - 0.18e2 * t2339 * t1277 * t535 * t224 + 0.6e2 * t2344 * t2345 * t535 * tau[0];
  t6357 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t364 - 0.3e1 / 0.8e1 * t5848 - 0.9e1 / 0.8e1 * t6 * t458 * t920 + t5854 / 0.4e1 - 0.3e1 / 0.4e1 * t5857 - 0.9e1 / 0.8e1 * t6 * t166 * t2357 - t5864 + t5866 / 0.4e1 - 0.3e1 / 0.8e1 * t5869 - 0.3e1 / 0.8e1 * t6 * t28 * (t5916 + t5966 + t6014 + t6061 + t6188 + t6246 + t6293 + t6349));
  tv4rho3sigma0 = t7 * t6357 + 0.3e1 * t2362;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t6364 = t6 * t1716 * t388;
  t6367 = t6 * t1720 * t388;
  t6371 = 0.5e1 / 0.36e2 * t6 * t1724 * t388;
  t6373 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t388 - 0.3e1 / 0.8e1 * t6364 + t6367 / 0.4e1 - t6371);
  tv4rho3sigma2 = t7 * t6373 + 0.3e1 * t2375;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t6375 = 0.2e1 * t2389;
  t6381 = t6 * t1754 * t364 / 0.4e1;
  t6386 = t6 * t1761 * t364;
  t6390 = t6 * t642 * t920 / 0.4e1;
  t6399 = -0.3e1 / 0.8e1 * t6 * t1750 * t364 - t6381 - 0.3e1 / 0.4e1 * t6 * t638 * t920 + t6386 / 0.12e2 - t6390 - 0.3e1 / 0.8e1 * t6 * t264 * t2357 - t5848 / 0.8e1 + t5854 / 0.6e1 - t5857 / 0.4e1 - t5864 + t5866 / 0.6e1 - t5869 / 0.8e1;
  t6400 = my_piecewise3(t2, 0, t6399);
  tv4rho3sigma3 = t7 * t6400 + t2362 + t6375;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t6402 = 0.2e1 * t2405;
  t6408 = t6 * t1797 * t388 / 0.4e1;
  t6410 = t6 * t1801 * t388;
  t6419 = t6 * t617 * t1018 / 0.4e1;
  t6421 = t6 * t621 * t1018;
  t6424 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t388 - t6408 + t6410 / 0.12e2 - t6364 / 0.8e1 + t6367 / 0.6e1 - t6371 - 0.3e1 / 0.8e1 * t6 * t613 * t1018 - t6419 + t6421 / 0.12e2);
  tv4rho3sigma5 = t7 * t6424 + t2375 + t6402;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t6430 = t6 * t1838 * t364;
  t6439 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t364 - t6430 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t920 - t6381 + t6386 / 0.6e1 - t6390 + t5854 / 0.12e2 - t5864 + t5866 / 0.12e2);
  tv4rho3sigma6 = t7 * t6439 + t2413 + t6375;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t6445 = t6 * t1868 * t388;
  t6452 = t6 * t666 * t1018;
  t6460 = t6 * t251 * t2632;
  t6462 = -0.3e1 / 0.8e1 * t6 * t1864 * t388 - t6445 / 0.8e1 - t6408 + t6410 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t1018 - t6452 / 0.4e1 + t6367 / 0.12e2 - t6371 - t6419 + t6421 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t2632 - t6460 / 0.8e1;
  t6463 = my_piecewise3(t93, 0, t6462);
  tv4rho3sigma8 = t7 * t6463 + t2637 + t6402;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t6472 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t364 - 0.3e1 / 0.8e1 * t6430 + t6386 / 0.4e1 - t5864);
  tv4rho3sigma9 = t7 * t6472 + 0.3e1 * t2413;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t6509 = t3255 * t765;
  t6512 = t728 * tau[1];
  t6525 = t5693 * t2003;
  t6528 = t2034 * t140;
  t6536 = t768 * t761;
  t6537 = t6536 * tau[1];
  t6540 = t2004 * t296;
  t6541 = t6540 * t765;
  t6544 = 0.19712e5 / 0.9e1 * t316 * t140 * t1957 - 0.176e3 * t752 * t733 * t296 + 0.16e4 * t2026 * t6509 - 0.272e4 / 0.3e1 * t764 * t6512 - 0.18e2 * t2562 * t2449 - 0.9e2 * t5807 * t972 + 0.48e2 * t752 * t286 * t761 - 0.6e1 * t752 * t107 * t1993 - 0.25e4 / 0.3e1 * t5681 * t6525 - 0.288e4 * t6528 * t987 * t761 - 0.288e5 * t5635 * t768 * t749 * tau[1] - 0.72e4 * t2044 * t6537 - 0.84e5 * t5653 * t6541;
  t6545 = t947 * t296;
  t6546 = t6545 * tau[1];
  t6586 = 0.576e5 * t2044 * t6546 - 0.9e2 * t2017 * t6537 - 0.6e3 * t5697 * t6541 + 0.192e4 * t801 * t1001 * t761 - 0.24e3 * t801 * t378 * t1993 - 0.224e6 / 0.3e1 * t316 * t2012 * t5693 * t2003 + 0.896e5 * t316 * t812 * t3255 * t765 - 0.8704e5 / 0.3e1 * t316 * t321 * t728 * tau[1] + 0.72e3 * t2017 * t6546 - 0.288e4 * t5716 * t378 * t1996 + 0.768e4 * t2034 * t1001 * t749 - 0.704e4 * t801 * t2479 * t296 + 0.48e2 * t2069 * t286 + 0.1232e4 / 0.9e1 * t299 * t1957;
  t6612 = t1004 * t302;
  t6616 = 0.18e2 * t737 * t1016 * t738 + 0.6e1 * t780 * t1016 * t781 + 0.9e1 * t290 * t2628 * t302 - 0.3e1 * t308 * t2628 * t326 - t308 * t1970 * t381 - t308 * t151 * (t6544 + t6586) + 0.9e1 * t290 * t1016 * t774 + 0.3e1 * t290 * t386 * t2086 - 0.3e1 * t308 * t1016 * t820 - t308 * t386 * t2051 - 0.3e1 * t308 * t831 * t1004 - 0.3e1 * t308 * t335 * t2482 - 0.1232e4 / 0.9e1 * t372 * t291 * t1957 - 0.48e2 * t2557 * t976 + 0.36e2 * t2541 * t6612 * t326;
  t6617 = t381 * t774;
  t6624 = t5600 * t151;
  t6632 = t1993 * t124;
  t6636 = t5604 * t151;
  t6641 = t2120 * t335;
  t6661 = t381 * t820;
  t6665 = -0.18e2 * t2923 * t6617 * t302 + 0.18e2 * t2541 * t6617 * t326 - 0.54e2 * t6624 * t2542 * t781 + 0.9e1 * t2546 * t969 + 0.9e1 * t965 * t2538 + 0.3e1 * t372 * t6632 * t107 + 0.36e2 * t6636 * t381 * t738 * t326 + 0.36e2 * t6641 * t2543 - 0.18e2 * t2096 * t985 * t781 - 0.18e2 * t2104 * t1005 * t738 + 0.18e2 * t2120 * t1007 * t781 - 0.18e2 * t2104 * t985 * t738 - 0.6e1 * t5773 * t382 - 0.6e1 * t2096 * t386 * t2097 + 0.18e2 * t2541 * t6661 * t302;
  t6691 = t483 * t1952 * sigma[2];
  t6693 = 0.1705e5 / 0.1594323e7 * t722 * t6691;
  t6704 = 0.1e1 / t105 / t1945 / t766 * t1943 * t34;
  t6708 = t1642 * t1947 * t723;
  t6713 = t34 * t1957;
  t6717 = 0.2e5 / 0.10460353203e11 * t5527 * t6704;
  t6719 = 0.95e4 / 0.14348907e8 * t1963 * t6708;
  t6721 = 0.154e4 / 0.6561e4 * t281 * t6713;
  t6727 = -0.18e2 * t3597 * t6661 * t326 + 0.88e2 * t965 * t2549 + 0.88e2 * t372 * t968 * t733 + 0.18e2 * t2556 * t335 * t373 + 0.18e2 * t2557 * t969 - 0.24e2 * t2546 * t976 - 0.48e2 * t965 * t2530 - 0.24e2 * t372 * t2537 * t286 + 0.3e1 * t290 * t1970 * t373 + t6693 + 0.24e2 * t5755 * t382 * t2097 - 0.18e2 * t2096 * t1005 * t781 + t145 * (0.2e5 / 0.10460353203e11 * t5541 * t6704 - 0.95e4 / 0.14348907e8 * t1942 * t6708 + 0.1705e5 / 0.1594323e7 * t826 * t6691 - 0.154e4 / 0.6561e4 * t331 * t6713 - t6717 + t6719 - t6693 + t6721) + 0.2e1 * t780 * t382 * t2051 - t6719;
  t6770 = -0.9e1 * t742 * t1005 * t774 + 0.6e1 * t780 * t1005 * t820 - 0.9e1 * t742 * t1007 * t820 + 0.6e1 * t780 * t1010 * t820 - 0.3e1 * t742 * t382 * t2086 - 0.9e1 * t742 * t2427 * t326 - 0.9e1 * t742 * t2435 * t302 + 0.6e1 * t780 * t2435 * t326 - 0.18e2 * t742 * t2437 * t302 + 0.12e2 * t780 * t2437 * t326 - 0.9e1 * t742 * t2483 * t302 + 0.6e1 * t780 * t2483 * t326 - 0.9e1 * t742 * t985 * t774 + 0.6e1 * t780 * t985 * t820 - t6721;
  t6782 = t737 * t831;
  t6814 = -0.18e2 * t2104 * t2485 * t326 + 0.18e2 * t737 * t1007 * t774 - 0.18e2 * t742 * t2424 * t326 + 0.18e2 * t6782 * t957 + 0.36e2 * t2585 * t2588 + 0.18e2 * t2585 * t2592 + 0.18e2 * t955 * t2537 * t956 + 0.18e2 * t955 * t968 * t2591 + 0.6e1 * t955 * t291 * t107 * t2086 - 0.3e1 * t960 * t291 * t107 * t2051 - 0.24e3 * t965 * t2569 + 0.3e2 * t2546 * t973 + 0.6e2 * t965 * t2563 + 0.15e3 * t965 * t2566 - 0.24e3 * t372 * t2562 * t2455;
  t6815 = t761 * t132;
  t6819 = t296 * t311;
  t6836 = t738 * t307;
  t6837 = t6836 * t151;
  t6845 = t742 * t831;
  t6860 = 0.3e2 * t372 * t6815 * t972 + 0.15e3 * t372 * t6819 * t2452 + 0.176e3 * t955 * t291 * t733 * t302 - 0.88e2 * t960 * t291 * t733 * t326 + 0.544e4 / 0.9e1 * t372 * t752 * t6512 + 0.18e2 * t3286 * t2592 - 0.18e2 * t6837 * t962 + 0.6e2 * t2557 * t973 + 0.1e4 / 0.3e1 * t372 * t5697 * t6525 - 0.9e1 * t6845 * t962 - 0.18e2 * t2595 * t2598 - 0.9e1 * t2595 * t2602 - 0.9e1 * t960 * t2537 * t961 - 0.9e1 * t960 * t968 * t2601 + 0.18e2 * t6641 * t2578;
  t6894 = t5604 * t2605;
  t6902 = t335 * t120;
  t6906 = t151 * t296;
  t6907 = t2104 * t6906;
  t6910 = 0.48e2 * t2595 * t2582 + 0.18e2 * t2541 * t968 * t2577 + t6717 - 0.18e2 * t6624 * t291 * t107 * t2097 - 0.48e2 * t2541 * t291 * t286 * t781 + 0.48e2 * t960 * t968 * t2581 + 0.24e2 * t960 * t291 * t286 * t820 - 0.8e3 * t372 * t2017 * t6509 - 0.96e2 * t2585 * t2573 - 0.96e2 * t955 * t968 * t2572 - 0.48e2 * t955 * t291 * t286 * t774 + 0.36e2 * t6894 * t1320 * t302 * t781 + 0.96e2 * t2606 * t3678 * t2607 + 0.12e3 * t737 * t6902 * t2614 - 0.36e2 * t6907 * t2608;
  t6922 = t742 * t6902;
  t6929 = t742 * t6906;
  t6943 = t311 * t2004;
  t6952 = t132 * t947;
  t6959 = t2104 * t6902;
  t6968 = -0.18e2 * t2606 * t1320 * t820 * t302 - 0.18e2 * t2606 * t1320 * t774 * t326 - 0.12e3 * t2606 * t2612 * t2607 * tau[1] + 0.6e2 * t2611 * t2612 * t774 * tau[1] + 0.3e3 * t2611 * t6943 * t765 * t302 - 0.3e2 * t2617 * t2612 * t820 * tau[1] + 0.6e2 * t3375 * t2612 * t781 * tau[1] - 0.15e3 * t2617 * t6943 * t765 * t326 + 0.18e2 * t3375 * t1320 * t5520 - 0.48e3 * t2611 * t6952 * t2613 + 0.12e3 * t737 * t6906 * t2614 + 0.24e3 * t2617 * t6952 * t2618 + 0.6e1 * t2055 * t386 - 0.36e2 * t6959 * t2608 - 0.6e2 * t6922 * t2619 - 0.6e2 * t6929 * t2619;
  t6976 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t388 - 0.3e1 / 0.8e1 * t6445 - 0.9e1 / 0.8e1 * t6 * t710 * t1018 + t6410 / 0.4e1 - 0.3e1 / 0.4e1 * t6452 - 0.9e1 / 0.8e1 * t6 * t275 * t2632 - t6371 + t6421 / 0.4e1 - 0.3e1 / 0.8e1 * t6460 - 0.3e1 / 0.8e1 * t6 * t102 * (t6616 + t6665 + t6727 + t6770 + t6814 + t6860 + t6910 + t6968));
  tv4rho3sigma11 = t7 * t6976 + 0.3e1 * t2637;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t6983 = t6 * t1474 * t412;
  t6989 = t6 * t1481 * t412;
  t6992 = t6 * t462 * t1096;
  t6999 = 0.5e1 / 0.36e2 * t6 * t1493 * t412;
  t7001 = t6 * t471 * t1096;
  t7004 = t6 * t172 * t2817;
  t7048 = -0.9e1 * t503 * t1037 * t581 + 0.18e2 * t498 * t1055 * t535 - 0.9e1 * t503 * t1055 * t581 - 0.9e1 * t503 * t1064 * t535 - 0.3e1 * t503 * t397 * t1588 + 0.6e1 * t498 * t397 * t1623 - 0.9e1 * t503 * t2712 * t200 - 0.18e2 * t503 * t2714 * t200 - 0.9e1 * t503 * t2788 * t200 + 0.18e2 * t498 * t2790 * t200 + 0.36e2 * t498 * t2793 * t200 - 0.9e1 * t503 * t2790 * t224 - 0.18e2 * t503 * t2793 * t224 - 0.9e1 * t503 * t2813 * t224;
  t7092 = 0.18e2 * t1685 * t1037 * t542 + 0.18e2 * t498 * t1037 * t535 + 0.18e2 * t1685 * t1055 * t542 - 0.18e2 * t1629 * t1064 * t542 - 0.18e2 * t1650 * t1064 * t499 - 0.18e2 * t1629 * t1094 * t542 - 0.18e2 * t1650 * t1094 * t499 + 0.2e1 * t541 * t410 * t1588 - 0.18e2 * t4754 * t397 * t1630 + 0.24e2 * t4972 * t410 * t1630 + 0.18e2 * t498 * t2813 * t200 + 0.36e2 * t6303 * t2695 * t542 - 0.54e2 * t5907 * t2705 * t542 - 0.18e2 * t5994 * t1034 + 0.18e2 * t3108 * t2681;
  t7098 = t1650 * t233;
  t7109 = t396 * t581;
  t7116 = t409 * t581;
  t7129 = t409 * t535;
  t7143 = -0.36e2 * t2694 * t1054 * t200 * t224 + 0.36e2 * t2253 * t1093 * t200 * t224 - 0.18e2 * t2694 * t396 * t535 * t224 + 0.36e2 * t6303 * t409 * t499 * t224 - t206 * t1683 * t409 + 0.18e2 * t2253 * t7116 * t200 - 0.18e2 * t2694 * t7109 * t200 - 0.18e2 * t2694 * t7129 * t200 - 0.3e1 * t206 * t233 * t2787 + 0.18e2 * t2253 * t7109 * t224 + 0.18e2 * t2253 * t7129 * t224 - 0.18e2 * t3419 * t7116 * t224 - 0.36e2 * t7098 * t2696 + 0.36e2 * t5891 * t2706 - 0.6e1 * t4945 * t410;
  t7148 = t2318 * t2727;
  t7150 = t49 * t1528;
  t7151 = t513 * t7150;
  t7154 = 0.1e1 / t37 / t3081;
  t7155 = t7154 * t1516;
  t7156 = t4813 * t7155;
  t7168 = 0.352e4 / 0.27e2 * t2298 + 0.48e2 * t7148 + 0.16e2 * t7151 + 0.2e5 / 0.9e1 * t7156 + 0.4e2 * t2288 - 0.8e2 * t5917 * t1044 - 0.4e3 * t5921 * t2731 - 0.32e3 / 0.3e1 * t2295 - 0.8e4 / 0.9e1 * t4819 * t7155 + 0.48e3 * t2319 + 0.52e4 / 0.3e1 * t2322;
  t7170 = t4921 * t1044;
  t7172 = t1043 * t522;
  t7173 = t7172 * tau[0];
  t7174 = t1532 * t7173;
  t7176 = t2730 * t194;
  t7177 = t7176 * t526;
  t7178 = t4819 * t7177;
  t7189 = -0.2624e5 / 0.27e2 * t2273 + 0.24e3 * t7170 + 0.24e3 * t7174 + 0.16e4 * t7178 - 0.8e1 * t6299 * t49 - 0.8e2 * t2162 - 0.8e2 * t2172 - 0.104e5 / 0.3e1 * t2175 - 0.352e4 / 0.27e2 * t2180 + 0.64e3 / 0.3e1 * t2169 - 0.144e4 * t2166 + 0.1312e5 / 0.9e1 * t2178;
  t7214 = t1048 * t522;
  t7218 = t1043 * t510 * tau[0];
  t7230 = t1560 * t7154;
  t7244 = 0.23296e7 / 0.3e1 * t72 * t1560 * t1518 * t526 - 0.4608e5 * t1551 * t406 * t1552 + 0.576e5 * t562 * t1090 * t510 - 0.432e3 * t1532 * t7214 - 0.288e4 * t4819 * t7218 + 0.864e4 * t1541 * t2165 - 0.144e4 * t1541 * t7173 - 0.12e5 * t4813 * t7177 + 0.192e4 * t562 * t403 * t1528 + 0.1792e7 / 0.3e1 * t214 * t7230 * t1516 - 0.2304e4 * t214 * t406 * t1528 - 0.896e6 * t72 * t4848 * t7154 * t1516 - 0.3072e5 * t214 * t2724 * t194;
  t7275 = -0.146944e7 / 0.9e1 * t72 * t573 * t849 * tau[0] + 0.72e3 * t7174 + 0.48e4 * t7178 + 0.2304e5 * t4880 * t403 * t1552 + 0.1152e5 * t214 * t1090 * t522 + 0.48384e6 * t1571 * t2165 + 0.2304e5 * t6160 * t7214 + 0.576e5 * t1583 * t7173 + 0.672e6 * t4805 * t7177 - 0.3456e5 * t1583 * t7214 - 0.8064e5 * t1571 * t7173 - 0.10752e7 * t4791 * t7177 - 0.4032e6 * t4805 * t7218 + 0.2304e6 * t4786 * t7218;
  t7293 = 0.64e3 * t2169 - 0.24e3 * t2172 - 0.104e5 * t2175 + 0.1312e5 / 0.3e1 * t2178 - 0.5632e5 / 0.9e1 * t2202 - 0.432e4 * t2166 - 0.384e5 * t2183 + 0.256e5 * t2188 - 0.96e4 * t2191 - 0.5824e6 * t2195 + 0.41984e6 / 0.3e1 * t2199 + 0.352e4 / 0.9e1 * t210 * t494 - 0.144e3 * t4862 * t49 - 0.3456e6 * t2185;
  t7318 = -0.24e3 * t2162 - 0.352e4 / 0.9e1 * t2180 + 0.36e3 * t525 * t2171 + 0.52e5 / 0.3e1 * t1515 * t2174 + 0.144e3 * t7148 + 0.48e2 * t7151 + 0.2e5 / 0.3e1 * t7156 - 0.72e2 * t525 * t7150 - 0.4e5 / 0.3e1 * t4868 * t7155 + 0.72e3 * t1532 * t39 * t510 - 0.96e3 * t525 * t2168 - 0.5248e5 / 0.9e1 * t557 * t2177 + 0.5632e5 / 0.9e1 * t72 * t219 * t494 + 0.72e3 * t7170;
  t7347 = -0.3e1 * t206 * t592 * t1093 + 0.3e1 * t188 * t86 * (t7168 + t7189) + 0.18e2 * t2306 * t1037 + 0.18e2 * t2306 * t1055 + 0.9e1 * t188 * t592 * t1054 + 0.9e1 * t188 * t233 * t2812 - t206 * t86 * (t7244 + t7275 + t7293 + t7318) + 0.3e1 * t188 * t1683 * t396 + 0.6e1 * t541 * t2788 * t224 + 0.6e1 * t541 * t1094 * t581 + 0.6e1 * t541 * t1064 * t581 + 0.12e2 * t541 * t2714 * t224 - 0.9e1 * t503 * t1094 * t535 - 0.3e1 * t503 * t410 * t1623 + 0.6e1 * t541 * t2712 * t224;
  t7354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t412 - 0.3e1 / 0.8e1 * t6983 - 0.9e1 / 0.8e1 * t6 * t458 * t1096 + t6989 / 0.4e1 - 0.3e1 / 0.4e1 * t6992 - 0.9e1 / 0.8e1 * t6 * t166 * t2817 - t6999 + t7001 / 0.4e1 - 0.3e1 / 0.8e1 * t7004 - 0.3e1 / 0.8e1 * t6 * t28 * (t7048 + t7092 + t7143 + t7347));
  tv4rho3tau0 = t7 * t7354 + 0.3e1 * t2822;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t7361 = t6 * t1716 * t436;
  t7364 = t6 * t1720 * t436;
  t7368 = 0.5e1 / 0.36e2 * t6 * t1724 * t436;
  t7370 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t436 - 0.3e1 / 0.8e1 * t7361 + t7364 / 0.4e1 - t7368);
  tv4rho3tau1 = t7 * t7370 + 0.3e1 * t2835;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t7372 = 0.2e1 * t2849;
  t7378 = t6 * t1754 * t412 / 0.4e1;
  t7383 = t6 * t1761 * t412;
  t7387 = t6 * t642 * t1096 / 0.4e1;
  t7396 = -0.3e1 / 0.8e1 * t6 * t1750 * t412 - t7378 - 0.3e1 / 0.4e1 * t6 * t638 * t1096 + t7383 / 0.12e2 - t7387 - 0.3e1 / 0.8e1 * t6 * t264 * t2817 - t6983 / 0.8e1 + t6989 / 0.6e1 - t6992 / 0.4e1 - t6999 + t7001 / 0.6e1 - t7004 / 0.8e1;
  t7397 = my_piecewise3(t2, 0, t7396);
  tv4rho3tau2 = t7 * t7397 + t2822 + t7372;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t7399 = 0.2e1 * t2865;
  t7405 = t6 * t1797 * t436 / 0.4e1;
  t7407 = t6 * t1801 * t436;
  t7416 = t6 * t617 * t1186 / 0.4e1;
  t7418 = t6 * t621 * t1186;
  t7421 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t436 - t7405 + t7407 / 0.12e2 - t7361 / 0.8e1 + t7364 / 0.6e1 - t7368 - 0.3e1 / 0.8e1 * t6 * t613 * t1186 - t7416 + t7418 / 0.12e2);
  tv4rho3tau3 = t7 * t7421 + t2835 + t7399;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t7427 = t6 * t1838 * t412;
  t7436 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t412 - t7427 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t1096 - t7378 + t7383 / 0.6e1 - t7387 + t6989 / 0.12e2 - t6999 + t7001 / 0.12e2);
  tv4rho3tau4 = t7 * t7436 + t2873 + t7372;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t7442 = t6 * t1868 * t436;
  t7449 = t6 * t666 * t1186;
  t7457 = t6 * t251 * t3046;
  t7459 = -0.3e1 / 0.8e1 * t6 * t1864 * t436 - t7442 / 0.8e1 - t7405 + t7407 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t1186 - t7449 / 0.4e1 + t7364 / 0.12e2 - t7368 - t7416 + t7418 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t3046 - t7457 / 0.8e1;
  t7460 = my_piecewise3(t93, 0, t7459);
  tv4rho3tau5 = t7 * t7460 + t3051 + t7399;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t7469 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t412 - 0.3e1 / 0.8e1 * t7427 + t7383 / 0.4e1 - t6999);
  tv4rho3tau6 = t7 * t7469 + 0.3e1 * t2873;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t7528 = 0.18e2 * t2120 * t1127 * t781 + 0.18e2 * t2120 * t1145 * t781 - 0.18e2 * t2096 * t1154 * t781 - 0.18e2 * t2104 * t1154 * t738 + 0.6e1 * t780 * t1154 * t820 - 0.18e2 * t2096 * t1184 * t781 - 0.18e2 * t2104 * t1184 * t738 - 0.9e1 * t742 * t1184 * t774 + 0.6e1 * t780 * t1184 * t820 + 0.2e1 * t780 * t434 * t2051 - 0.18e2 * t5600 * t421 * t2097 + 0.24e2 * t5755 * t434 * t2097 + 0.12e2 * t780 * t2978 * t326 + 0.6e1 * t780 * t3043 * t326;
  t7574 = -0.9e1 * t742 * t1127 * t820 + 0.18e2 * t737 * t1145 * t774 - 0.9e1 * t742 * t1145 * t820 - 0.9e1 * t742 * t1154 * t774 - 0.3e1 * t742 * t421 * t2051 + 0.6e1 * t737 * t421 * t2086 - 0.3e1 * t742 * t434 * t2086 - 0.9e1 * t742 * t2941 * t326 - 0.18e2 * t742 * t2944 * t326 + 0.18e2 * t737 * t2973 * t302 - 0.9e1 * t742 * t2973 * t326 - 0.9e1 * t742 * t2976 * t302 + 0.6e1 * t780 * t2976 * t326 - 0.18e2 * t742 * t2978 * t302 - 0.9e1 * t742 * t3043 * t302;
  t7595 = t420 * t820;
  t7599 = t433 * t820;
  t7606 = t2104 * t335;
  t7622 = -0.36e2 * t2923 * t1144 * t302 * t326 - 0.18e2 * t2923 * t420 * t774 * t326 + 0.18e2 * t737 * t1127 * t774 + 0.18e2 * t2541 * t7599 * t302 + 0.18e2 * t2541 * t7595 * t326 - 0.18e2 * t2923 * t7595 * t302 + 0.36e2 * t6636 * t2924 * t781 - 0.54e2 * t6624 * t2934 * t781 + 0.18e2 * t737 * t2941 * t302 + 0.36e2 * t737 * t2944 * t302 - 0.18e2 * t3597 * t7599 * t326 - 0.18e2 * t6836 * t1124 + 0.18e2 * t3285 * t2910 - 0.36e2 * t7606 * t2925 + 0.36e2 * t6641 * t2935;
  t7627 = t433 * t774;
  t7644 = t1133 * t761;
  t7645 = t7644 * tau[1];
  t7646 = t2017 * t7645;
  t7648 = t2952 * t296;
  t7649 = t7648 * t765;
  t7650 = t5697 * t7649;
  t7656 = 0.1e1 / t105 / t3254;
  t7657 = t7656 * t2003;
  t7661 = t2562 * t2965;
  t7663 = t5807 * t1134;
  t7665 = 0.48e3 * t2563 + 0.52e4 / 0.3e1 * t2566 - 0.2624e5 / 0.27e2 * t2569 + 0.24e3 * t7646 + 0.16e4 * t7650 - 0.4e3 * t6819 * t2953 - 0.32e3 / 0.3e1 * t2530 - 0.8e4 / 0.9e1 * t5697 * t7657 + 0.352e4 / 0.27e2 * t2549 + 0.48e2 * t7661 + 0.24e3 * t7663;
  t7666 = t117 * t1993;
  t7667 = t752 * t7666;
  t7669 = t5681 * t7657;
  t7683 = 0.16e2 * t7667 + 0.2e5 / 0.9e1 * t7669 + 0.4e2 * t2538 - 0.8e2 * t6815 * t1134 - 0.8e1 * t6632 * t117 + 0.1312e5 / 0.9e1 * t2456 + 0.64e3 / 0.3e1 * t2447 - 0.144e4 * t2444 - 0.8e2 * t2440 - 0.8e2 * t2450 - 0.104e5 / 0.3e1 * t2453 - 0.352e4 / 0.27e2 * t2458;
  t7696 = t2012 * t7656;
  t7716 = t1138 * t761;
  t7720 = t1133 * t749 * tau[1];
  t7732 = 0.1792e7 / 0.3e1 * t316 * t7696 * t2003 - 0.2304e4 * t316 * t430 * t1993 - 0.896e6 * t137 * t5689 * t7656 * t2003 - 0.3072e5 * t316 * t3034 * t296 - 0.146944e7 / 0.9e1 * t137 * t812 * t947 * tau[1] + 0.72e3 * t7646 + 0.48e4 * t7650 - 0.432e3 * t2017 * t7716 - 0.288e4 * t5697 * t7720 + 0.864e4 * t2026 * t2443 - 0.144e4 * t2026 * t7645 - 0.12e5 * t5681 * t7649 + 0.192e4 * t801 * t427 * t1993;
  t7767 = 0.1152e5 * t316 * t1180 * t761 + 0.23296e7 / 0.3e1 * t137 * t2012 * t2004 * t765 + 0.2304e5 * t5716 * t427 * t1996 - 0.4608e5 * t2034 * t430 * t1996 + 0.576e5 * t801 * t1180 * t749 - 0.8064e5 * t1978 * t7645 - 0.10752e7 * t5620 * t7649 + 0.2304e6 * t5635 * t7720 - 0.4032e6 * t5653 * t7720 + 0.48384e6 * t1978 * t2443 + 0.2304e5 * t6528 * t7716 + 0.576e5 * t2044 * t7645 + 0.672e6 * t5653 * t7649 - 0.3456e5 * t2044 * t7716;
  t7785 = 0.64e3 * t2447 - 0.24e3 * t2450 - 0.104e5 * t2453 + 0.1312e5 / 0.3e1 * t2456 - 0.5632e5 / 0.9e1 * t2480 - 0.144e3 * t5732 * t117 + 0.352e4 / 0.9e1 * t312 * t733 - 0.432e4 * t2444 - 0.384e5 * t2461 + 0.256e5 * t2466 - 0.96e4 * t2469 - 0.5824e6 * t2473 + 0.41984e6 / 0.3e1 * t2477 - 0.3456e6 * t2463;
  t7810 = 0.5632e5 / 0.9e1 * t137 * t321 * t733 + 0.72e3 * t2017 * t107 * t749 - 0.96e3 * t764 * t2446 - 0.5248e5 / 0.9e1 * t796 * t2455 + 0.144e3 * t7661 + 0.72e3 * t7663 + 0.48e2 * t7667 + 0.2e5 / 0.3e1 * t7669 + 0.36e3 * t764 * t2449 + 0.52e5 / 0.3e1 * t2002 * t2452 - 0.72e2 * t764 * t7666 - 0.4e5 / 0.3e1 * t5735 * t7657 - 0.352e4 / 0.9e1 * t2458 - 0.24e3 * t2440;
  t7827 = 0.36e2 * t2541 * t1183 * t302 * t326 - 0.18e2 * t2923 * t7627 * t302 + 0.18e2 * t2541 * t7627 * t326 + 0.36e2 * t6636 * t433 * t738 * t326 + 0.9e1 * t290 * t335 * t2972 + 0.3e1 * t290 * t151 * (t7665 + t7683) + 0.18e2 * t2556 * t1145 + 0.3e1 * t290 * t1970 * t420 + 0.9e1 * t290 * t831 * t1144 - t308 * t151 * (t7732 + t7767 + t7785 + t7810) + 0.18e2 * t2556 * t1127 - 0.3e1 * t308 * t831 * t1183 - 0.3e1 * t308 * t335 * t3042 - t308 * t1970 * t433 - 0.6e1 * t5773 * t434;
  t7834 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t436 - 0.3e1 / 0.8e1 * t7442 - 0.9e1 / 0.8e1 * t6 * t710 * t1186 + t7407 / 0.4e1 - 0.3e1 / 0.4e1 * t7449 - 0.9e1 / 0.8e1 * t6 * t275 * t3046 - t7368 + t7418 / 0.4e1 - 0.3e1 / 0.8e1 * t7457 - 0.3e1 / 0.8e1 * t6 * t102 * (t7528 + t7574 + t7622 + t7827));
  tv4rho3tau7 = t7 * t7834 + 0.3e1 * t3051;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t7841 = t6 * t462 * t1230;
  t7848 = t6 * t471 * t1230 / 0.12e2;
  t7850 = t6 * t172 * t3213;
  t7863 = t849 * t59;
  t7884 = t1685 * t362;
  t7902 = 0.12e2 * t857 * t4921 * t529 + 0.608e3 / 0.3e1 * t857 * t525 * t489 + 0.176e3 / 0.3e1 * t1204 * t2298 + 0.12e2 * t2306 * t362 * t349 + 0.8e1 * t857 * t7863 * t200 - 0.3e1 / 0.4e1 * t2253 * t3119 * t542 - 0.4e1 * t862 * t7863 * t224 + 0.32e2 * t2335 * t3132 + 0.32e2 * t862 * t870 * t3131 + 0.32e2 * t862 * t189 * t184 * t906 - 0.64e2 * t3155 * t2277 + 0.12e2 * t7884 * t2255 + 0.32e2 * t3158 * t2259 + 0.12e2 * t6303 * t525 * t529 * t542 + 0.64e2 * t2694 * t525 * t849 * t224 - 0.128e3 * t857 * t1532 * t6102 - 0.12e2 * t5995 * t1201;
  t7910 = t3082 * tau[0];
  t7924 = t498 * t918;
  t7931 = t503 * t918;
  t7947 = 0.1e1 / t37 / t4674 * t484 * t34;
  t7949 = 0.25e4 / 0.3486784401e10 * t4692 * t7947;
  t7950 = t200 * t205;
  t7951 = t7950 * t86;
  t7956 = -0.176e3 / 0.3e1 * t862 * t189 * t494 * t357 + 0.12e2 * t857 * t1532 * t6115 - 0.16e4 / 0.3e1 * t857 * t1541 * t7910 - 0.6e1 * t862 * t2287 * t1200 - 0.12e2 * t862 * t870 * t3151 - 0.6e1 * t862 * t189 * t39 * t2204 + 0.24e2 * t7924 * t859 + 0.24e2 * t3155 * t2328 + 0.12e2 * t3155 * t2332 - 0.12e2 * t7931 * t864 - 0.12e2 * t3158 * t2262 - 0.6e1 * t3158 * t2268 - 0.16e3 * t1204 * t2273 + 0.4e2 * t3114 * t875 + 0.4e2 * t1204 * t2319 - t7949 - 0.12e2 * t7951 * t3136 - 0.12e2 * t7098 * t3136;
  t7981 = t4852 * t526;
  t8026 = 0.3e1 / 0.4e1 * t5917 * t529 + 0.15e2 / 0.2e1 * t5921 * t3142 - 0.8e1 * t2318 * t849 + 0.25e2 * t4819 * t7981 - 0.5e2 * t1532 * t7910 + 0.76e2 / 0.3e1 * t513 * t489 + 0.36e3 * t4880 * t1220 * t510 + 0.24e4 * t4786 * t6119 * tau[0] - 0.128e4 * t1551 * t3193 * t194 + 0.12e3 * t1551 * t1220 * t522 + 0.35e4 * t562 * t573 * t4852 * t526 - 0.4e4 * t562 * t219 * t3082 * tau[0] + 0.304e4 / 0.3e1 * t562 * t75 * t489;
  t8037 = -0.6e1 * t2694 * t525 * t529 * t581 + 0.24e2 * t3109 * t3139 + 0.24e2 * t2325 * t3139 + 0.1e3 * t1204 * t2322 + 0.3e1 / 0.2e1 * t2694 * t3119 * t2340 - 0.5e1 * t857 * t3127 * t2346 + 0.5e1 / 0.2e1 * t862 * t3127 * t2351 + 0.8e2 * t3109 * t3143 + 0.8e2 * t2325 * t3143 + 0.1e4 / 0.3e1 * t857 * t4813 * t7981 - 0.6e1 * t5953 * t1201 - 0.12e2 * t2335 * t3148 - 0.12e2 * t2335 * t3152 - t206 * t86 * t8026 + 0.3e1 * t188 * t1228 * t535 - t206 * t1228 * t581 - 0.4e1 * t206 * t918 * t906;
  t8058 = t906 * t906;
  t8070 = t2240 * sigma[0];
  t8073 = t1193 * t489;
  t8077 = 0.5375e4 / 0.28697814e8 * t1640 * t8070;
  t8079 = 0.95e3 / 0.531441e6 * t480 * t8073;
  t8097 = -0.2e1 * t206 * t362 * t2204 - t206 * t592 * t1223 - 0.2e1 * t206 * t233 * t3196 + 0.6e1 * t188 * t3101 * t200 - 0.2e1 * t206 * t3101 * t224 + 0.2e1 * t541 * t592 * t1211 - 0.2e1 * t206 * t2316 * t357 + 0.4e1 * t541 * t86 * t8058 + 0.2e1 * t541 * t1228 * t542 + 0.6e1 * t498 * t1228 * t499 + t80 * (-0.25e4 / 0.3486784401e10 * t4665 * t7947 + 0.5375e4 / 0.28697814e8 * t1668 * t8070 - 0.95e3 / 0.531441e6 * t586 * t8073 + t7949 - t8077 + t8079) + 0.24e2 * t4972 * t1212 * t542 + 0.4e1 * t188 * t233 * t849 * t59 + 0.12e2 * t4710 * t1212 * t499 - 0.3e1 / 0.4e1 * t2306 * t1208 + t8077 - 0.6e1 * t1629 * t1224 * t542 - t8079;
  t8152 = -0.12e2 * t1650 * t1215 * t499 - 0.12e2 * t1629 * t1215 * t542 - 0.6e1 * t1650 * t1224 * t499 + 0.8e1 * t541 * t3172 * t224 + 0.8e1 * t541 * t3175 * t224 + 0.4e1 * t541 * t1215 * t581 - 0.6e1 * t503 * t3178 * t200 - 0.38e2 / 0.3e1 * t188 * t86 * t489 * t59 - 0.12e2 * t503 * t3175 * t200 - 0.6e1 * t503 * t1215 * t535 + 0.4e1 * t541 * t358 * t2204 - 0.12e2 * t503 * t3172 * t200 + 0.8e1 * t541 * t887 * t906 + 0.6e1 * t1685 * t1212 * t535 - 0.12e2 * t1629 * t3169 * t224 - 0.6e1 * t1629 * t1212 * t581 - 0.6e1 * t503 * t3164 * t224;
  t8175 = t86 * t53;
  t8176 = t1650 * t8175;
  t8177 = t556 * t1518;
  t8189 = t4754 * t2338;
  t8214 = -0.3e1 / 0.8e1 * t188 * t592 * t529 * t59 + 0.12e2 * t1685 * t3169 * t200 + 0.4e1 * t541 * t3197 * t224 + 0.2e1 * t541 * t1224 * t581 - 0.6e1 * t503 * t3197 * t200 - 0.3e1 * t503 * t1224 * t535 + 0.4e1 * t541 * t3178 * t224 - 0.8e2 * t8176 * t8177 * t2351 + 0.16e3 * t2344 * t8177 * t514 - 0.24e2 * t6332 * t3199 + 0.64e2 * t2339 * t3426 * t2291 - 0.36e2 * t8189 * t1277 * t357 * t542 - 0.64e2 * t3202 * t3426 * t3203 - 0.12e2 * t2339 * t1277 * t6281 + 0.12e2 * t3202 * t1277 * t357 * t581 + 0.16e3 * t2350 * t6325 * t3207 - 0.1e3 * t2350 * t6255 * t357 * t526 + 0.24e2 * t1685 * t6231 * t3204;
  t8236 = t362 * t52;
  t8237 = t1650 * t8236;
  t8243 = t503 * t8236;
  t8254 = t1211 * t200;
  t8269 = -0.4e2 * t6232 * t3208 - 0.24e2 * t6338 * t3199 + 0.24e2 * t1685 * t6248 * t3204 - 0.4e2 * t6252 * t3208 - 0.24e2 * t2339 * t1277 * t6277 + 0.24e2 * t3202 * t1277 * t906 * t224 - 0.4e2 * t2350 * t2345 * t906 * tau[0] - 0.24e2 * t8237 * t2341 + 0.8e2 * t498 * t8236 * t2347 - 0.4e2 * t8243 * t2352 - 0.24e2 * t2339 * t4247 * t224 * t194 + 0.3e1 / 0.4e1 * t2335 * t3123 - 0.5e1 / 0.2e1 * t867 * t3128 - 0.36e2 * t5907 * t8254 * t224 + 0.24e2 * t2253 * t2291 * t906 - 0.24e2 * t3419 * t3203 * t906 + 0.6e1 * t6000 * t1197 + 0.6e1 * t188 * t2316 * t349;
  t8284 = t1223 * t200;
  t8296 = t535 * t79;
  t8297 = t8296 * t86;
  t8300 = t3108 * t233;
  t8303 = t3082 * t67;
  t8307 = t4852 * t209;
  t8322 = 0.12e2 * t3114 * t871 + 0.6e1 * t1204 * t2288 - 0.3e1 / 0.4e1 * t857 * t3119 * t535 + 0.3e1 / 0.8e1 * t862 * t3119 * t581 - 0.3e1 / 0.2e1 * t2325 * t3120 + 0.24e2 * t7884 * t2292 + 0.12e2 * t2253 * t8284 * t224 - 0.64e2 * t3109 * t3103 - 0.64e2 * t2325 * t3103 - 0.32e2 * t3114 * t878 - 0.32e2 * t1204 * t2295 + 0.6e1 * t8297 * t1197 + 0.12e2 * t8300 * t1197 + 0.5e2 / 0.3e1 * t348 * t8303 * tau[0] - 0.25e2 / 0.4e1 * t348 * t8307 * t526 - 0.8e2 * t2339 * t2345 * t2291 * tau[0] + 0.8e2 * t3202 * t2345 * t3203 * tau[0] + 0.48e2 * t6317 * t1277 * t2292;
  t8330 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1230 - t7841 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3213 + t7848 - t7850 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t7902 + t7956 + t8037 + t8097 + t8152 + t8214 + t8269 + t8322));
  tv4rho2sigma20 = t7 * t8330 + 0.2e1 * t3218;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t8337 = t6 * t617 * t1271;
  t8341 = t6 * t621 * t1271 / 0.12e2;
  t8343 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1271 - t8337 / 0.4e1 + t8341);
  tv4rho2sigma25 = t7 * t8343 + 0.2e1 * t3227;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t8349 = t6 * t642 * t1230;
  t8357 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1230 - t8349 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3213 - t7841 / 0.8e1 + t7848 - t7850 / 0.8e1);
  tv4rho2sigma26 = t7 * t8357 + t3218 + t3233;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t8363 = t6 * t666 * t1271;
  t8370 = t6 * t251 * t3392;
  t8373 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1271 - t8363 / 0.8e1 - t8337 / 0.8e1 + t8341 - 0.3e1 / 0.8e1 * t6 * t247 * t3392 - t8370 / 0.8e1);
  tv4rho2sigma211 = t7 * t8373 + t3227 + t3397;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t8381 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1230 - t8349 / 0.4e1 + t7848);
  tv4rho2sigma212 = t7 * t8381 + 0.2e1 * t3233;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t8409 = t2120 * t386;
  t8432 = t737 * t1016;
  t8435 = t742 * t1016;
  t8440 = -0.12e2 * t6837 * t1242 - 0.176e3 / 0.3e1 * t960 * t291 * t733 * t381 + 0.32e2 * t2595 * t3333 + 0.32e2 * t960 * t968 * t3332 + 0.32e2 * t960 * t291 * t286 * t1004 - 0.64e2 * t3320 * t2573 + 0.12e2 * t8409 * t2578 + 0.32e2 * t3323 * t2582 + 0.12e2 * t6636 * t764 * t768 * t781 - 0.128e3 * t955 * t2017 * t6545 + 0.4e2 * t1245 * t2563 + 0.3e1 / 0.2e1 * t2923 * t3296 * t2607 - 0.5e1 * t955 * t3278 * t2613 + 0.5e1 / 0.2e1 * t960 * t3278 * t2618 + 0.24e2 * t8432 * t957 - 0.12e2 * t8435 * t962 + 0.4e2 * t3291 * t973;
  t8457 = t302 * t307;
  t8458 = t8457 * t151;
  t8474 = 0.1e1 / t105 / t5544 * t723 * t34;
  t8476 = 0.25e4 / 0.3486784401e10 * t5527 * t8474;
  t8489 = 0.24e2 * t3320 * t2588 - 0.12e2 * t3323 * t2598 - 0.12e2 * t2595 * t3317 - 0.6e1 * t960 * t2537 * t1241 - 0.12e2 * t960 * t968 * t3316 - 0.6e1 * t960 * t291 * t107 * t2482 - 0.12e2 * t8458 * t3329 + 0.24e2 * t3286 * t3304 + 0.8e2 * t3286 * t3308 - 0.12e2 * t7606 * t3329 + 0.24e2 * t2585 * t3304 + 0.8e2 * t2585 * t3308 - t8476 + 0.12e2 * t3320 * t2592 - 0.6e1 * t3323 * t2602 - 0.16e3 * t1245 * t2569 + 0.1e3 * t1245 * t2566 - 0.6e1 * t2923 * t764 * t768 * t820;
  t8498 = t3255 * tau[1];
  t8502 = t5693 * t765;
  t8512 = t2506 * sigma[2];
  t8515 = t1193 * t728;
  t8519 = 0.5375e4 / 0.28697814e8 * t1963 * t8512;
  t8521 = 0.95e3 / 0.531441e6 * t721 * t8515;
  t8540 = t386 * t120;
  t8541 = t2104 * t8540;
  t8547 = t742 * t8540;
  t8554 = t795 * t2004;
  t8558 = 0.12e2 * t955 * t2017 * t6536 + 0.64e2 * t2923 * t764 * t947 * t326 - 0.16e4 / 0.3e1 * t955 * t2026 * t8498 + 0.1e4 / 0.3e1 * t955 * t5681 * t8502 - 0.6e1 * t6845 * t1242 - 0.12e2 * t2595 * t3313 + t145 * (-0.25e4 / 0.3486784401e10 * t5541 * t8474 + 0.5375e4 / 0.28697814e8 * t1942 * t8512 - 0.95e3 / 0.531441e6 * t825 * t8515 + t8476 - t8519 + t8521) + 0.24e2 * t2120 * t6906 * t3377 - 0.4e2 * t6929 * t3381 - 0.24e2 * t2606 * t1320 * t6612 + 0.24e2 * t3375 * t1320 * t1004 * t326 - 0.4e2 * t2617 * t2612 * t1004 * tau[1] - 0.24e2 * t8541 * t2608 + 0.8e2 * t737 * t8540 * t2614 - 0.4e2 * t8547 * t2619 - 0.24e2 * t2606 * t4337 * t296 * t326 + 0.16e3 * t2611 * t8554 * t753;
  t8559 = t151 * t121;
  t8560 = t2104 * t8559;
  t8564 = t5600 * t2605;
  t8630 = 0.3e1 / 0.4e1 * t6815 * t768 + 0.15e2 / 0.2e1 * t6819 * t3307 - 0.8e1 * t2562 * t947 + 0.25e2 * t5697 * t8502 - 0.5e2 * t2017 * t8498 + 0.76e2 / 0.3e1 * t752 * t728 + 0.36e3 * t5716 * t1261 * t749 + 0.24e4 * t5635 * t6540 * tau[1] - 0.128e4 * t2034 * t3358 * t296 + 0.12e3 * t2034 * t1261 * t761 + 0.35e4 * t801 * t812 * t5693 * t765 - 0.4e4 * t801 * t321 * t3255 * tau[1] + 0.304e4 / 0.3e1 * t801 * t140 * t728;
  t8645 = t947 * t124;
  t8649 = -0.8e2 * t8560 * t8554 * t2618 - 0.36e2 * t8564 * t1320 * t381 * t781 - 0.64e2 * t3375 * t3678 * t3376 + 0.64e2 * t2606 * t3678 * t2542 - 0.2e1 * t308 * t386 * t2482 - t308 * t831 * t1264 - 0.2e1 * t308 * t335 * t3361 - 0.2e1 * t308 * t3388 * t326 + 0.2e1 * t780 * t831 * t1252 - 0.2e1 * t308 * t2628 * t381 - 0.4e1 * t308 * t1016 * t1004 - t308 * t151 * t8630 + 0.3e1 * t290 * t1269 * t774 - t308 * t1269 * t820 + 0.6e1 * t290 * t3388 * t302 - 0.32e2 * t3291 * t976 - 0.32e2 * t1245 * t2530 + 0.8e1 * t955 * t8645 * t302;
  t8689 = t1264 * t302;
  t8693 = t774 * t144;
  t8694 = t8693 * t151;
  t8697 = -0.3e1 / 0.4e1 * t2541 * t3296 * t781 - 0.4e1 * t960 * t8645 * t326 + 0.12e2 * t2556 * t386 * t373 - 0.64e2 * t3286 * t3282 - 0.64e2 * t2585 * t3282 + 0.176e3 / 0.3e1 * t1245 * t2549 + 0.12e2 * t955 * t5807 * t768 + 0.608e3 / 0.3e1 * t955 * t764 * t728 + 0.6e1 * t290 * t2628 * t373 + 0.12e2 * t3291 * t969 - 0.3e1 / 0.2e1 * t2585 * t3297 + 0.3e1 / 0.4e1 * t2595 * t3300 - 0.5e1 / 0.2e1 * t965 * t3279 - 0.24e2 * t3597 * t3376 * t1004 + 0.24e2 * t8409 * t2543 + 0.12e2 * t2541 * t8689 * t326 + 0.6e1 * t8694 * t1238;
  t8698 = t3285 * t335;
  t8711 = t3255 * t132;
  t8715 = t5693 * t311;
  t8719 = t1252 * t302;
  t8752 = 0.12e2 * t8698 * t1238 + 0.6e1 * t6782 * t1238 + 0.6e1 * t1245 * t2538 - 0.3e1 / 0.4e1 * t955 * t3296 * t774 + 0.3e1 / 0.8e1 * t960 * t3296 * t820 + 0.5e2 / 0.3e1 * t372 * t8711 * tau[1] - 0.25e2 / 0.4e1 * t372 * t8715 * t765 - 0.36e2 * t6624 * t8719 * t326 + 0.24e2 * t2541 * t2542 * t1004 - 0.3e1 / 0.8e1 * t290 * t831 * t768 * t124 - 0.12e2 * t2606 * t1320 * t6617 + 0.12e2 * t3375 * t1320 * t6661 + 0.16e3 * t2617 * t6952 * t3380 - 0.1e3 * t2617 * t6943 * t381 * t765 - 0.24e2 * t6959 * t3372 + 0.24e2 * t2120 * t6902 * t3377 - 0.4e2 * t6922 * t3381 - 0.24e2 * t6907 * t3372;
  t8754 = t1004 * t1004;
  t8804 = 0.4e1 * t780 * t151 * t8754 + 0.2e1 * t780 * t1269 * t781 + 0.6e1 * t737 * t1269 * t738 + t8519 + 0.4e1 * t290 * t335 * t947 * t124 - 0.6e1 * t2096 * t1265 * t781 - t8521 - 0.12e2 * t2096 * t1256 * t781 - 0.6e1 * t2104 * t1265 * t738 + 0.24e2 * t5755 * t1253 * t781 - 0.12e2 * t2104 * t1256 * t738 - 0.38e2 / 0.3e1 * t290 * t151 * t728 * t124 + 0.12e2 * t5604 * t1253 * t738 + 0.4e1 * t780 * t3362 * t326 + 0.2e1 * t780 * t1265 * t820 - 0.3e1 / 0.4e1 * t2556 * t1249 - 0.6e1 * t742 * t3343 * t302 - 0.6e1 * t742 * t3362 * t302;
  t8861 = -0.8e2 * t2606 * t2612 * t2542 * tau[1] + 0.8e2 * t3375 * t2612 * t3376 * tau[1] + 0.8e1 * t780 * t985 * t1004 - 0.6e1 * t2096 * t1253 * t820 + 0.6e1 * t2120 * t1253 * t774 - 0.6e1 * t742 * t1256 * t774 + 0.4e1 * t780 * t1256 * t820 - 0.3e1 * t742 * t1265 * t774 + 0.48e2 * t6894 * t1320 * t2543 - 0.12e2 * t2096 * t3369 * t326 + 0.12e2 * t2120 * t3369 * t302 + 0.4e1 * t780 * t382 * t2482 - 0.12e2 * t742 * t3337 * t302 - 0.12e2 * t742 * t3340 * t302 + 0.8e1 * t780 * t3337 * t326 + 0.8e1 * t780 * t3340 * t326 + 0.4e1 * t780 * t3343 * t326 - 0.6e1 * t742 * t3364 * t326;
  t8869 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1271 - t8363 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t3392 + t8341 - t8370 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t8440 + t8489 + t8558 + t8649 + t8697 + t8752 + t8804 + t8861));
  tv4rho2sigma217 = t7 * t8869 + 0.2e1 * t3397;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t8876 = t6 * t462 * t1314;
  t8883 = t6 * t471 * t1314 / 0.12e2;
  t8885 = t6 * t172 * t3564;
  t8894 = t59 * t494;
  t8933 = -0.32e2 * t2325 * t3452 - 0.32e2 * t857 * t3434 * t3426 - 0.6e1 * t5995 * t1295 - 0.88e2 / 0.3e1 * t862 * t1294 * t8894 - 0.32e2 * t857 * t3438 * t3426 + 0.16e2 * t2335 * t3427 + 0.16e2 * t862 * t3444 * t3426 + 0.16e2 * t862 * t3448 * t3426 + 0.176e3 / 0.3e1 * t857 * t1276 * t8894 - 0.32e2 * t3109 * t3452 + 0.6e1 * t2306 * t1284 - 0.6e1 * t1629 * t1312 * t542 - 0.6e1 * t5994 * t1281 - 0.6e1 * t1629 * t1301 * t542 - 0.6e1 * t1650 * t1312 * t499 - 0.6e1 * t1650 * t1301 * t499 + 0.6e1 * t1685 * t1284 * t542;
  t8988 = -0.6e1 * t503 * t1037 * t906 - 0.6e1 * t503 * t1055 * t906 + 0.6e1 * t498 * t1284 * t535 - 0.3e1 * t503 * t1284 * t581 + 0.6e1 * t1685 * t1291 * t542 + 0.2e1 * t541 * t1301 * t581 - 0.3e1 * t503 * t1312 * t535 + 0.2e1 * t541 * t1312 * t581 + 0.12e2 * t498 * t3491 * t200 + 0.12e2 * t498 * t3495 * t200 - 0.3e1 * t503 * t397 * t2204 + 0.4e1 * t541 * t3483 * t224 + 0.4e1 * t541 * t3489 * t224 - 0.6e1 * t503 * t3491 * t224 - 0.6e1 * t503 * t3495 * t224 - 0.3e1 * t503 * t2790 * t357 - 0.6e1 * t503 * t2793 * t357 - 0.3e1 * t503 * t2813 * t357;
  t9041 = 0.4e1 * t541 * t1064 * t906 + 0.4e1 * t541 * t1094 * t906 + 0.3e1 * t188 * t592 * t1290 - 0.3e1 * t503 * t1291 * t581 - 0.3e1 * t503 * t1301 * t535 - 0.6e1 * t503 * t3483 * t200 - 0.6e1 * t503 * t3485 * t200 - 0.6e1 * t503 * t3487 * t200 - 0.6e1 * t503 * t3489 * t200 + 0.2e1 * t541 * t410 * t2204 + 0.4e1 * t541 * t3485 * t224 + 0.4e1 * t541 * t3487 * t224 - 0.6e1 * t503 * t3498 * t224 - 0.6e1 * t503 * t3509 * t224 + 0.2e1 * t541 * t2712 * t357 + 0.4e1 * t541 * t2714 * t357 + 0.2e1 * t541 * t2788 * t357;
  t9056 = t7176 * tau[0];
  t9062 = t573 * t7154;
  t9075 = 0.52e2 * t3180 - 0.416e3 / 0.3e1 * t3184 + 0.832e4 * t3187 + 0.272e5 * t3191 + 0.6656e4 * t214 * t2197 + 0.18e2 * t4921 * t1043 + 0.208e3 * t3103 + 0.24e3 * t4819 * t9056 - 0.96e3 * t1551 * t1306 * t522 - 0.28e5 * t562 * t9062 * t526 + 0.144e4 * t562 * t1078 * t522 + 0.448e5 * t214 * t7230 * t526 - 0.288e4 * t4880 * t1306 * t510;
  t9087 = t7154 * t526;
  t9092 = t5921 * t3457;
  t9094 = t4819 * t9087;
  t9096 = t5917 * t1043;
  t9104 = 0.576e4 * t1551 * t1078 * t510 - 0.1248e5 * t562 * t899 * t194 - 0.3808e5 * t214 * t2193 * tau[0] + 0.18e2 * t1532 * t7172 + 0.5e3 * t4813 * t9087 - 0.156e3 * t3139 - 0.68e3 * t3143 - 0.6e2 * t9092 - 0.2e3 * t9094 - 0.6e1 * t9096 - 0.192e5 * t4786 * t9056 + 0.336e5 * t4805 * t9056 + 0.34e3 * t3182 - 0.1664e5 / 0.3e1 * t3194;
  t9135 = t7154 * t209;
  t9153 = t4972 * t86;
  t9163 = 0.6e1 * t188 * t233 * t3508 + 0.6e1 * t2306 * t1291 - t206 * t86 * (t9075 + t9104) + 0.3e1 * t188 * t2316 * t396 + 0.6e1 * t188 * t918 * t1054 + 0.3e1 * t188 * t362 * t2812 + 0.12e2 * t498 * t3498 * t200 + 0.12e2 * t498 * t3509 * t200 + 0.6e1 * t498 * t1291 * t535 - t206 * t362 * t2787 - t206 * t592 * t1311 - 0.2e1 * t206 * t233 * t3482 + 0.3e1 * t188 * t86 * (0.208e3 / 0.9e1 * t7863 - 0.34e3 / 0.9e1 * t3128 + 0.5e2 / 0.3e1 * t9135 * t526 - 0.2e1 * t9096 - 0.2e2 * t9092 + 0.52e2 / 0.3e1 * t3180 - 0.2e3 / 0.3e1 * t9094 + 0.34e3 / 0.3e1 * t3182 - 0.416e3 / 0.9e1 * t3184) - t206 * t2316 * t409 - 0.2e1 * t206 * t918 * t1093 + 0.24e2 * t9153 * t3415 * t542 - 0.18e2 * t5907 * t3411 * t542 + 0.12e2 * t6303 * t3415 * t499;
  t9178 = t1093 * t357;
  t9185 = t409 * t906;
  t9192 = t396 * t906;
  t9199 = t1650 * t362;
  t9219 = -0.12e2 * t2694 * t1290 * t200 * t224 + 0.12e2 * t2253 * t1311 * t200 * t224 - 0.12e2 * t1629 * t233 * t3420 + 0.12e2 * t2253 * t9178 * t200 + 0.12e2 * t2253 * t9185 * t200 - 0.12e2 * t2694 * t9192 * t200 + 0.12e2 * t2253 * t9192 * t224 - 0.12e2 * t3419 * t9178 * t224 - 0.12e2 * t3419 * t9185 * t224 + 0.6e1 * t2253 * t3411 * t581 + 0.6e1 * t2253 * t3415 * t535 - 0.6e1 * t2694 * t3411 * t535 - 0.6e1 * t3419 * t3415 * t581 - 0.12e2 * t9199 * t2696 + 0.12e2 * t7884 * t2706 + 0.12e2 * t5891 * t3416 - 0.12e2 * t7098 * t3423;
  t9222 = t1054 * t357;
  t9229 = t4754 * t410;
  t9234 = t4710 * t397;
  t9249 = t7950 * t397;
  t9255 = t1650 * t1037;
  t9261 = t1650 * t1055;
  t9267 = 0.4e2 * t498 * t1037 * t875 + 0.4e2 * t498 * t1055 * t875 - 0.12e2 * t2694 * t9222 * t200 + 0.12e2 * t2253 * t9222 * t224 + 0.4e2 * t3108 * t397 * t875 - 0.18e2 * t9229 * t2255 + 0.12e2 * t9234 * t2255 + 0.32e2 * t3545 * t2259 - 0.32e2 * t3554 * t2259 + 0.12e2 * t3554 * t2262 - 0.6e1 * t3545 * t2268 - 0.16e3 * t3548 * t2273 + 0.32e2 * t3551 * t2277 - 0.2e2 * t3557 * t2319 + 0.12e2 * t5891 * t3412 - 0.12e2 * t9249 * t864 - 0.12e2 * t9255 * t864 - 0.12e2 * t9261 * t864;
  t9286 = t1685 * t1064;
  t9295 = t1685 * t1094;
  t9315 = -0.12e2 * t3545 * t2262 + 0.1e3 * t3548 * t2322 - 0.6e1 * t3551 * t2332 + 0.6e1 * t3554 * t2268 + 0.8e2 * t3557 * t2273 - 0.5e2 * t3557 * t2322 + 0.4e2 * t3548 * t2319 - 0.12e2 * t1650 * t1064 * t859 + 0.12e2 * t9286 * t864 - 0.2e2 * t503 * t1064 * t875 - 0.12e2 * t1650 * t1094 * t859 + 0.12e2 * t9295 * t864 - 0.2e2 * t503 * t1094 * t875 - 0.12e2 * t3551 * t2328 - 0.3e1 * t862 * t409 * t522 * t1277 + 0.24e2 * t6303 * t3411 * t2340 - 0.36e2 * t5907 * t3415 * t2340 + 0.6e1 * t8297 * t1278;
  t9354 = t4710 * t410;
  t9365 = t513 * t3135 * tau[0];
  t9370 = 0.12e2 * t8300 * t1278 + 0.12e2 * t3109 * t3435 + 0.12e2 * t3109 * t3439 + 0.6e1 * t6000 * t1278 + 0.12e2 * t2325 * t3435 + 0.12e2 * t2325 * t3439 + 0.6e1 * t857 * t2812 * t52 * t1277 + 0.12e2 * t857 * t1054 * t194 * t1277 + 0.6e1 * t857 * t396 * t522 * t1277 - 0.3e1 * t5953 * t1295 - 0.6e1 * t2335 * t3445 - 0.6e1 * t2335 * t3449 - 0.3e1 * t862 * t2787 * t52 * t1277 - 0.6e1 * t862 * t1093 * t194 * t1277 + 0.24e2 * t9354 * t189 * t858 * t224 - 0.4e2 * t3551 * t513 * t529 * t200 * tau[0] + 0.4e2 * t3554 * t9365 - 0.4e2 * t3545 * t9365;
  t9378 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1314 - t8876 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3564 + t8883 - t8885 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t8933 + t8988 + t9041 + t9163 + t9219 + t9267 + t9315 + t9370));
  tv4rho2sigmatau0 = t7 * t9378 + 0.2e1 * t3569;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t9385 = t6 * t617 * t1357;
  t9389 = t6 * t621 * t1357 / 0.12e2;
  t9391 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1357 - t9385 / 0.4e1 + t9389);
  tv4rho2sigmatau5 = t7 * t9391 + 0.2e1 * t3578;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t9397 = t6 * t642 * t1314;
  t9405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1314 - t9397 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3564 - t8876 / 0.8e1 + t8883 - t8885 / 0.8e1);
  tv4rho2sigmatau6 = t7 * t9405 + t3569 + t3584;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t9411 = t6 * t666 * t1357;
  t9418 = t6 * t251 * t3748;
  t9421 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1357 - t9411 / 0.8e1 - t9385 / 0.8e1 + t9389 - 0.3e1 / 0.8e1 * t6 * t247 * t3748 - t9418 / 0.8e1);
  tv4rho2sigmatau11 = t7 * t9421 + t3578 + t3753;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t9429 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1314 - t9397 / 0.4e1 + t8883);
  tv4rho2sigmatau12 = t7 * t9429 + 0.2e1 * t3584;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t9443 = t5755 * t151;
  t9455 = t1183 * t381;
  t9462 = t433 * t1004;
  t9471 = t420 * t1004;
  t9475 = t2104 * t386;
  t9494 = -0.12e2 * t2923 * t1333 * t302 * t326 - 0.12e2 * t2096 * t335 * t3598 + 0.12e2 * t2541 * t9455 * t302 + 0.12e2 * t2541 * t9462 * t302 + 0.12e2 * t2541 * t9471 * t326 + 0.6e1 * t2541 * t3589 * t820 + 0.6e1 * t2541 * t3593 * t774 - 0.6e1 * t2923 * t3589 * t774 - 0.12e2 * t3597 * t9455 * t326 - 0.12e2 * t3597 * t9462 * t326 - 0.18e2 * t6624 * t3589 * t781 - 0.6e1 * t3597 * t3593 * t820 + 0.12e2 * t6636 * t3593 * t738 + 0.24e2 * t9443 * t3593 * t781 - 0.12e2 * t9475 * t2925 + 0.12e2 * t8409 * t2935 + 0.12e2 * t6641 * t3594;
  t9497 = t1144 * t381;
  t9548 = 0.12e2 * t6641 * t3590 - 0.12e2 * t2923 * t9497 * t302 + 0.12e2 * t2541 * t9497 * t326 - 0.12e2 * t2923 * t9471 * t302 + 0.12e2 * t2541 * t1354 * t302 * t326 - 0.12e2 * t7606 * t3601 - 0.6e1 * t2104 * t1344 * t738 + 0.6e1 * t2120 * t1327 * t781 + 0.6e1 * t2120 * t1334 * t781 - 0.6e1 * t6836 * t1324 - 0.6e1 * t2096 * t1355 * t781 - 0.6e1 * t2096 * t1344 * t781 - 0.6e1 * t2104 * t1355 * t738 + 0.4e1 * t780 * t1184 * t1004 + 0.2e1 * t780 * t3043 * t381 + 0.4e1 * t780 * t1154 * t1004 - 0.6e1 * t742 * t3655 * t326 + 0.2e1 * t780 * t2976 * t381;
  t9598 = -0.6e1 * t742 * t1145 * t1004 - 0.12e2 * t2104 * t1154 * t957 + 0.6e1 * t737 * t1327 * t774 - 0.3e1 * t742 * t1327 * t820 + 0.6e1 * t737 * t1334 * t774 - 0.3e1 * t742 * t421 * t2482 + 0.4e1 * t780 * t2978 * t381 + 0.12e2 * t737 * t3638 * t302 + 0.12e2 * t737 * t3641 * t302 + 0.12e2 * t737 * t3644 * t302 + 0.12e2 * t737 * t3655 * t302 - 0.6e1 * t742 * t3638 * t326 - 0.6e1 * t742 * t3641 * t326 - 0.6e1 * t742 * t3644 * t326 + 0.4e2 * t3735 * t2563 + 0.1e3 * t3735 * t2566 - 0.16e3 * t3735 * t2569;
  t9605 = t8457 * t421;
  t9611 = t2104 * t1127;
  t9617 = t2104 * t1145;
  t9625 = t5604 * t421;
  t9632 = t5600 * t434;
  t9643 = 0.4e2 * t737 * t1127 * t973 + 0.4e2 * t737 * t1145 * t973 + 0.4e2 * t3285 * t421 * t973 - 0.2e2 * t3744 * t2563 + 0.8e2 * t3744 * t2569 + 0.32e2 * t3738 * t2573 + 0.12e2 * t9625 * t2578 - 0.18e2 * t9632 * t2578 + 0.32e2 * t3732 * t2582 - 0.32e2 * t3741 * t2582 - 0.12e2 * t3738 * t2588 - 0.6e1 * t3738 * t2592 - 0.12e2 * t3732 * t2598 + 0.12e2 * t3741 * t2598 + 0.6e1 * t3741 * t2602 - 0.12e2 * t9605 * t962 - 0.12e2 * t9611 * t962 - 0.12e2 * t9617 * t962;
  t9648 = t2120 * t1154;
  t9657 = t2120 * t1184;
  t9695 = -0.6e1 * t742 * t1127 * t1004 - 0.2e2 * t742 * t1154 * t973 - 0.12e2 * t2104 * t1184 * t957 - 0.2e2 * t742 * t1184 * t973 + 0.2e1 * t780 * t1344 * t820 - 0.3e1 * t742 * t1355 * t774 + 0.2e1 * t780 * t1355 * t820 - 0.3e1 * t742 * t2941 * t381 - 0.6e1 * t742 * t2944 * t381 - 0.3e1 * t742 * t2973 * t381 - 0.6e1 * t742 * t3606 * t302 + 0.4e1 * t780 * t3606 * t326 + 0.4e1 * t780 * t3636 * t326 - 0.5e2 * t3744 * t2566 - 0.6e1 * t3732 * t2602 + 0.12e2 * t9648 * t962 + 0.12e2 * t9657 * t962;
  t9748 = -0.6e1 * t742 * t3636 * t302 + 0.4e1 * t780 * t3604 * t326 - 0.6e1 * t742 * t3604 * t302 - 0.3e1 * t742 * t1344 * t774 + 0.4e1 * t780 * t3658 * t326 + 0.2e1 * t780 * t434 * t2482 - 0.6e1 * t742 * t3658 * t302 - 0.3e1 * t742 * t1334 * t820 + 0.12e2 * t955 * t1144 * t296 * t1320 + 0.24e2 * t6636 * t3589 * t2607 - 0.36e2 * t6624 * t3593 * t2607 - 0.6e1 * t2595 * t3687 - 0.6e1 * t960 * t1183 * t296 * t1320 - 0.3e1 * t960 * t433 * t761 * t1320 + 0.6e1 * t8694 * t1321 + 0.12e2 * t8698 * t1321 + 0.12e2 * t3286 * t3665 + 0.12e2 * t3286 * t3669;
  t9760 = t124 * t733;
  t9797 = 0.6e1 * t6782 * t1321 + 0.12e2 * t2585 * t3665 + 0.12e2 * t2585 * t3669 + 0.6e1 * t955 * t2972 * t120 * t1320 - 0.88e2 / 0.3e1 * t960 * t1337 * t9760 + 0.16e2 * t2595 * t3682 + 0.16e2 * t960 * t3674 * t3678 + 0.176e3 / 0.3e1 * t955 * t1319 * t9760 - 0.6e1 * t6837 * t1338 + 0.16e2 * t960 * t3686 * t3678 - 0.32e2 * t3286 * t3679 - 0.32e2 * t2585 * t3679 - 0.32e2 * t955 * t3664 * t3678 - 0.32e2 * t955 * t3668 * t3678 - 0.2e1 * t308 * t1016 * t1183 - t308 * t386 * t3042 - t308 * t831 * t1354 + 0.3e1 * t290 * t831 * t1333;
  t9803 = t7656 * t311;
  t9806 = t6815 * t1133;
  t9808 = t6819 * t3610;
  t9811 = t7656 * t765;
  t9812 = t5697 * t9811;
  t9824 = t7648 * tau[1];
  t9834 = t812 * t7656;
  t9856 = 0.576e4 * t2034 * t1168 * t749 + 0.144e4 * t801 * t1168 * t761 - 0.96e3 * t2034 * t1349 * t761 - 0.288e4 * t5716 * t1349 * t749 - 0.3808e5 * t316 * t2471 * tau[1] - 0.1248e5 * t801 * t997 * t296 + 0.448e5 * t316 * t7696 * t765 - 0.28e5 * t801 * t9834 * t765 - 0.192e5 * t5635 * t9824 + 0.336e5 * t5653 * t9824 + 0.24e3 * t5697 * t9824 + 0.832e4 * t3352 + 0.272e5 * t3356;
  t9875 = -0.6e1 * t9806 + 0.18e2 * t5807 * t1133 + 0.208e3 * t3282 + 0.34e3 * t3347 - 0.1664e5 / 0.3e1 * t3359 + 0.6656e4 * t316 * t2475 - 0.156e3 * t3304 - 0.68e3 * t3308 + 0.18e2 * t2017 * t7644 + 0.5e3 * t5681 * t9811 - 0.6e2 * t9808 - 0.2e3 * t9812 + 0.52e2 * t3345 - 0.416e3 / 0.3e1 * t3349;
  t9904 = t752 * t3328 * tau[1];
  t9907 = t5604 * t434;
  t9923 = 0.6e1 * t290 * t335 * t3654 + 0.3e1 * t290 * t151 * (0.208e3 / 0.9e1 * t8645 - 0.34e3 / 0.9e1 * t3279 + 0.5e2 / 0.3e1 * t9803 * t765 - 0.2e1 * t9806 - 0.2e2 * t9808 + 0.52e2 / 0.3e1 * t3345 - 0.2e3 / 0.3e1 * t9812 + 0.34e3 / 0.3e1 * t3347 - 0.416e3 / 0.9e1 * t3349) - t308 * t2628 * t433 - t308 * t151 * (t9856 + t9875) + 0.3e1 * t290 * t2628 * t420 + 0.6e1 * t290 * t1016 * t1144 + 0.3e1 * t290 * t386 * t2972 - 0.2e1 * t308 * t335 * t3635 - 0.6e1 * t2595 * t3675 - 0.3e1 * t960 * t3042 * t120 * t1320 + 0.6e1 * t955 * t420 * t761 * t1320 - 0.3e1 * t6845 * t1338 - 0.4e2 * t3732 * t9904 + 0.24e2 * t9907 * t291 * t956 * t326 - 0.4e2 * t3738 * t752 * t768 * t302 * tau[1] + 0.4e2 * t3741 * t9904 + 0.6e1 * t2556 * t1327 + 0.6e1 * t2556 * t1334;
  t9931 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1357 - t9411 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t3748 + t9389 - t9418 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t9494 + t9548 + t9598 + t9643 + t9695 + t9748 + t9797 + t9923));
  tv4rho2sigmatau17 = t7 * t9931 + 0.2e1 * t3753;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t9938 = t6 * t462 * t1401;
  t9945 = t6 * t471 * t1401 / 0.12e2;
  t9947 = t6 * t172 * t3880;
  t9952 = t396 * t224;
  t9958 = t1054 * t409;
  t9962 = t396 * t1093;
  t9999 = t1054 * t1054;
  t10003 = -0.24e2 * t3419 * t409 * t224 * t1093 - 0.12e2 * t2694 * t1377 * t200 * t224 - 0.36e2 * t5907 * t1381 * t200 * t224 + 0.12e2 * t2253 * t1398 * t200 * t224 - 0.24e2 * t2694 * t9952 * t1054 + 0.24e2 * t2253 * t2705 * t1093 - 0.24e2 * t2694 * t9958 * t200 - 0.24e2 * t2694 * t9962 * t200 + 0.24e2 * t2253 * t9958 * t224 + 0.24e2 * t2253 * t9962 * t224 + 0.12e2 * t2253 * t3772 * t581 - 0.12e2 * t2694 * t3772 * t535 - 0.36e2 * t5907 * t3772 * t542 + 0.12e2 * t498 * t86 * t9999 - 0.24e2 * t7098 * t3773 + 0.24e2 * t5891 * t3776;
  t10013 = 0.1e1 / t37 / t1517;
  t10014 = t10013 * t209;
  t10017 = t5917 * t1370;
  t10019 = t5921 * t3805;
  t10022 = t10013 * t526;
  t10023 = t4819 * t10022;
  t10027 = t4921 * t1370;
  t10029 = t3799 * t194;
  t10030 = t10029 * tau[0];
  t10031 = t4819 * t10030;
  t10034 = t1370 * t522;
  t10035 = t1532 * t10034;
  t10037 = t4813 * t10022;
  t10041 = -0.104e4 / 0.9e1 * t3119 + 0.224e4 / 0.9e1 * t3503 - 0.4e3 / 0.3e1 * t10014 * t526 + 0.32e2 * t10017 + 0.32e3 * t10019 - 0.64e3 / 0.3e1 * t3455 + 0.32e4 / 0.3e1 * t10023 - 0.448e4 / 0.3e1 * t3458 + 0.416e4 / 0.9e1 * t1218 - 0.48e2 * t10027 - 0.64e3 * t10031 + 0.32e3 * t3461 - 0.48e2 * t10035 - 0.4e4 / 0.3e1 * t10037 + 0.448e4 / 0.3e1 * t3463 - 0.104e4 / 0.3e1 * t1197;
  t10079 = t1560 * t10013;
  t10083 = 0.43008e6 * t4791 * t10030 + 0.1536e6 * t4786 * t10030 - 0.5376e6 * t4805 * t10030 + 0.576e3 * t4819 * t1370 * t510 - 0.192e4 * t1541 * t2742 - 0.224e5 / 0.3e1 * t1515 * t3457 + 0.11648e6 / 0.3e1 * t72 * t2752 + 0.48e3 * t10019 + 0.16e4 * t10023 - 0.288e3 * t10035 - 0.8e4 * t10037 + 0.288e3 * t1541 * t10034 + 0.8e4 * t4868 * t10022 + 0.208e4 / 0.3e1 * t1218 + 0.192e4 * t3461 + 0.896e4 * t3463 - 0.6656e5 * t3480 - 0.224e4 * t3458 - 0.2304e5 * t562 * t1392 * t522 - 0.7168e6 * t214 * t10079 * t526;
  t10113 = t573 * t10013;
  t10128 = 0.224e6 * t562 * t10113 * t526 + 0.832e5 / 0.3e1 * t1221 - 0.512e5 * t3467 - 0.1792e6 * t3471 + 0.1536e6 * t3475 + 0.50176e6 * t3478 - 0.208e4 * t1197 - 0.32e3 * t3455 - 0.288e3 * t10027 + 0.416e4 / 0.3e1 * t557 * t529 + 0.48e2 * t10017;
  t10145 = t1093 * t1093;
  t10166 = 0.3e1 * t188 * t592 * t1377 + 0.6e1 * t188 * t233 * t3815 + 0.3e1 * t188 * t86 * t10041 - 0.2e1 * t206 * t233 * t3876 - t206 * t86 * (t10083 + 0.16128e5 * t214 * t1395 * t522 + 0.5376e6 * t72 * t4848 * t10013 * t526 - 0.384e4 * t10031 + 0.8064e5 * t562 * t1395 * t510 - 0.10752e6 * t214 * t1086 * t194 - 0.100352e7 / 0.3e1 * t72 * t2738 * tau[0] + 0.2304e5 * t4880 * t1389 * t510 - 0.9216e5 * t1551 * t1392 * t510 + 0.48e4 * t4813 * t10030 + 0.768e4 * t1551 * t1389 * t522 + t10128) + 0.6e1 * t8296 * t1363 + 0.12e2 * t3108 * t3766 + 0.6e1 * t498 * t592 * t1362 + 0.2e1 * t541 * t592 * t1381 - t206 * t592 * t1398 + 0.4e1 * t541 * t86 * t10145 + 0.6e1 * t2306 * t1378 - 0.12e2 * t503 * t1055 * t1093 - 0.6e1 * t503 * t397 * t2787 - 0.6e1 * t503 * t2813 * t409 - 0.12e2 * t503 * t2793 * t409 - 0.12e2 * t503 * t1037 * t1093;
  t10213 = 0.12e2 * t498 * t397 * t2812 - 0.6e1 * t503 * t2790 * t409 + 0.24e2 * t3108 * t3769 - 0.12e2 * t1650 * t3766 * t224 - 0.6e1 * t1650 * t1363 * t581 + 0.24e2 * t498 * t1037 * t1054 - 0.12e2 * t7950 * t3763 + 0.48e2 * t6303 * t3772 * t2340 - 0.12e2 * t5994 * t1366 - 0.6e1 * t1629 * t1399 * t542 + 0.12e2 * t4710 * t1363 * t542 + 0.24e2 * t4972 * t1382 * t542 - 0.6e1 * t1650 * t1399 * t499 + 0.6e1 * t1685 * t1378 * t542 + 0.12e2 * t4710 * t1382 * t499 + 0.4e1 * t541 * t3877 * t224;
  t10265 = 0.8e1 * t541 * t1064 * t1093 + 0.6e1 * t498 * t1378 * t535 - 0.3e1 * t503 * t1378 * t581 - 0.6e1 * t1629 * t1382 * t581 + 0.6e1 * t1685 * t1382 * t535 - 0.3e1 * t503 * t1399 * t535 + 0.2e1 * t541 * t1399 * t581 - 0.12e2 * t1629 * t3825 * t224 + 0.12e2 * t1685 * t3825 * t200 + 0.12e2 * t498 * t3795 * t200 + 0.12e2 * t498 * t3816 * t200 - 0.6e1 * t503 * t3837 * t200 - 0.6e1 * t503 * t3877 * t200 - 0.6e1 * t503 * t3795 * t224 - 0.6e1 * t503 * t3816 * t224 + 0.4e1 * t541 * t3837 * t224 + 0.4e1 * t541 * t410 * t2787;
  t10272 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1401 - t9938 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3880 + t9945 - t9947 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t10003 + t10166 + t10213 + t10265));
  tv4rho2tau20 = t7 * t10272 + 0.2e1 * t3885;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t10279 = t6 * t617 * t1445;
  t10283 = t6 * t621 * t1445 / 0.12e2;
  t10285 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1445 - t10279 / 0.4e1 + t10283);
  tv4rho2tau22 = t7 * t10285 + 0.2e1 * t3894;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t10291 = t6 * t642 * t1401;
  t10299 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1401 - t10291 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3880 - t9938 / 0.8e1 + t9945 - t9947 / 0.8e1);
  tv4rho2tau23 = t7 * t10299 + t3885 + t3900;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t10305 = t6 * t666 * t1445;
  t10312 = t6 * t251 * t4024;
  t10315 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1445 - t10305 / 0.8e1 - t10279 / 0.8e1 + t10283 - 0.3e1 / 0.8e1 * t6 * t247 * t4024 - t10312 / 0.8e1);
  tv4rho2tau25 = t7 * t10315 + t3894 + t4029;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t10323 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1401 - t10291 / 0.4e1 + t9945);
  tv4rho2tau26 = t7 * t10323 + 0.2e1 * t3900;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t10379 = 0.24e2 * t737 * t1127 * t1144 + 0.8e1 * t780 * t1154 * t1183 - 0.6e1 * t2104 * t1407 * t820 + 0.12e2 * t5604 * t1407 * t781 + 0.6e1 * t2120 * t1422 * t781 - 0.3e1 * t742 * t1422 * t820 - 0.6e1 * t2096 * t1426 * t820 + 0.12e2 * t5604 * t1426 * t738 + 0.24e2 * t5755 * t1426 * t781 - 0.6e1 * t2096 * t1443 * t781 - 0.6e1 * t2104 * t1443 * t738 - 0.12e2 * t2104 * t3910 * t326 + 0.12e2 * t2120 * t3969 * t302 - 0.12e2 * t6836 * t1410 + 0.24e2 * t3285 * t3913 - 0.12e2 * t8457 * t3907;
  t10431 = -0.12e2 * t742 * t1127 * t1183 - 0.12e2 * t742 * t1145 * t1183 + 0.6e1 * t737 * t1422 * t774 + 0.6e1 * t2120 * t1426 * t774 - 0.3e1 * t742 * t1443 * t774 + 0.2e1 * t780 * t1443 * t820 - 0.12e2 * t2096 * t3969 * t326 - 0.6e1 * t742 * t2941 * t433 - 0.12e2 * t742 * t2944 * t433 + 0.12e2 * t737 * t421 * t2972 - 0.6e1 * t742 * t2973 * t433 + 0.12e2 * t737 * t3939 * t302 + 0.12e2 * t737 * t3960 * t302 - 0.6e1 * t742 * t421 * t3042 - 0.6e1 * t742 * t3939 * t326 - 0.6e1 * t742 * t3960 * t326 + 0.4e1 * t780 * t3981 * t326;
  t10448 = t3943 * t296;
  t10449 = t10448 * tau[1];
  t10456 = 0.1e1 / t105 / t1945;
  t10457 = t812 * t10456;
  t10464 = t2012 * t10456;
  t10490 = t5697 * t10449;
  t10498 = t6815 * t1414;
  t10500 = t5807 * t1414;
  t10502 = 0.48e4 * t5681 * t10449 + 0.768e4 * t2034 * t1433 * t761 + 0.224e6 * t801 * t10457 * t765 - 0.2304e5 * t801 * t1436 * t761 - 0.7168e6 * t316 * t10464 * t765 + 0.16128e5 * t316 * t1439 * t761 + 0.5376e6 * t137 * t5689 * t10456 * t765 + 0.2304e5 * t5716 * t1433 * t749 - 0.9216e5 * t2034 * t1436 * t749 + 0.8064e5 * t801 * t1439 * t749 - 0.10752e6 * t316 * t1176 * t296 - 0.100352e7 / 0.3e1 * t137 * t2991 * tau[1] - 0.384e4 * t10490 + 0.192e4 * t3614 + 0.896e4 * t3616 - 0.6656e5 * t3633 - 0.224e4 * t3611 + 0.416e4 / 0.3e1 * t796 * t768 + 0.48e2 * t10498 - 0.288e3 * t10500;
  t10520 = t1414 * t761;
  t10523 = t10456 * t765;
  t10526 = t6819 * t3949;
  t10528 = t5697 * t10523;
  t10530 = t2017 * t10520;
  t10532 = t5681 * t10523;
  t10541 = -0.224e5 / 0.3e1 * t2002 * t3610 + 0.288e3 * t2026 * t10520 + 0.8e4 * t5735 * t10523 + 0.48e3 * t10526 + 0.16e4 * t10528 - 0.288e3 * t10530 - 0.8e4 * t10532 + 0.832e5 / 0.3e1 * t1262 + 0.1536e6 * t5635 * t10449 - 0.5376e6 * t5653 * t10449 + 0.43008e6 * t5620 * t10449;
  t10567 = t10456 * t311;
  t10583 = -0.104e4 / 0.9e1 * t3296 + 0.224e4 / 0.9e1 * t3649 - 0.4e3 / 0.3e1 * t10567 * t765 + 0.32e2 * t10498 + 0.32e3 * t10526 - 0.64e3 / 0.3e1 * t3608 + 0.32e4 / 0.3e1 * t10528 - 0.448e4 / 0.3e1 * t3611 + 0.416e4 / 0.9e1 * t1259 - 0.48e2 * t10500 - 0.64e3 * t10490 + 0.32e3 * t3614 - 0.48e2 * t10530 - 0.4e4 / 0.3e1 * t10532 + 0.448e4 / 0.3e1 * t3616 - 0.104e4 / 0.3e1 * t1238;
  t10591 = 0.4e1 * t780 * t4021 * t326 - 0.6e1 * t742 * t4021 * t302 + 0.4e1 * t780 * t434 * t3042 - 0.6e1 * t742 * t3981 * t302 + 0.48e2 * t6636 * t3916 * t2607 - t308 * t151 * (t10502 - 0.208e4 * t1238 - 0.32e3 * t3608 + 0.208e4 / 0.3e1 * t1259 - 0.512e5 * t3620 - 0.1792e6 * t3624 + 0.1536e6 * t3628 + 0.50176e6 * t3631 + 0.11648e6 / 0.3e1 * t137 * t3004 + 0.576e3 * t5697 * t1414 * t749 - 0.192e4 * t2026 * t2960 + t10541) - 0.2e1 * t308 * t335 * t4020 + 0.2e1 * t780 * t831 * t1425 - t308 * t831 * t1442 + 0.12e2 * t3285 * t3910 + 0.6e1 * t737 * t831 * t1406 + 0.3e1 * t290 * t831 * t1421 + 0.6e1 * t290 * t335 * t3959 + 0.3e1 * t290 * t151 * t10583 + 0.6e1 * t8693 * t1407 + 0.6e1 * t2556 * t1422;
  t10592 = t1144 * t1144;
  t10596 = t1183 * t1183;
  t10610 = t420 * t1183;
  t10619 = t1144 * t433;
  t10641 = t420 * t326;
  t10650 = -0.24e2 * t3597 * t433 * t326 * t1183 - 0.12e2 * t2923 * t1421 * t302 * t326 - 0.36e2 * t6624 * t1425 * t302 * t326 + 0.12e2 * t2541 * t1442 * t302 * t326 + 0.12e2 * t737 * t151 * t10592 + 0.4e1 * t780 * t151 * t10596 + 0.24e2 * t2541 * t10610 * t326 - 0.24e2 * t2923 * t10610 * t302 + 0.24e2 * t2541 * t10619 * t326 - 0.24e2 * t2923 * t10619 * t302 - 0.24e2 * t2923 * t10641 * t1144 + 0.24e2 * t2541 * t2934 * t1183 + 0.12e2 * t2541 * t3916 * t820 - 0.12e2 * t2923 * t3916 * t774 - 0.36e2 * t6624 * t3916 * t781 - 0.24e2 * t7606 * t3917 + 0.24e2 * t6641 * t3920;
  t10657 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1445 - t10305 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t4024 + t10283 - t10312 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t10379 + t10431 + t10591 + t10650));
  tv4rho2tau28 = t7 * t10657 + 0.2e1 * t4029;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t10664 = t6 * t172 * t4094 / 0.8e1;
  t10698 = -0.18e2 * t1629 * t1212 * t906 + 0.12e2 * t541 * t1215 * t906 + 0.6e1 * t541 * t907 * t1223 + 0.6e1 * t1515 * t4086 * t233 - 0.18e2 * t1629 * t4040 * t224 + 0.18e2 * t1685 * t4040 * t200 - 0.9e1 * t503 * t4043 * t200 - 0.9e1 * t503 * t4046 * t200 + 0.6e1 * t541 * t4043 * t224 + 0.24e2 * t4972 * t4072 * t224 + 0.6e1 * t541 * t358 * t3196;
  t10712 = 0.1e1 / t37 / t1645 * t29 * t181;
  t10718 = 0.625e3 / 0.2324522934e10 * t4692 * t10712;
  t10720 = 0.125e3 / 0.3188646e7 * t1640 * t3083;
  t10749 = 0.6e1 * t541 * t887 * t1223 - 0.9e1 / 0.8e1 * t188 * t918 * t529 * t59 - 0.18e2 * t4754 * t4072 * t200 + t80 * (0.625e3 / 0.2324522934e10 * t4665 * t10712 - 0.125e3 / 0.3188646e7 * t1668 * t3083 - t10718 + t10720) + 0.6e2 * t3202 * t2345 * t1211 * tau[0] - 0.36e2 * t8237 * t3199 + 0.36e2 * t1685 * t8236 * t3204 - 0.6e2 * t8243 * t3208 - 0.18e2 * t2339 * t1277 * t8284 + 0.18e2 * t3202 * t1277 * t1223 * t224 - 0.3e2 * t2350 * t2345 * t1223 * tau[0] + 0.36e2 * t4710 * t8175 * t4247 * t3203;
  t10798 = -0.36e2 * t2339 * t4247 * t357 * t194 - 0.12e3 * t8176 * t8177 * t3207 + 0.36e2 * t6317 * t1277 * t8254 - 0.54e2 * t8189 * t1277 * t1211 * t224 + 0.36e2 * t3202 * t1277 * t357 * t906 - t206 * t4080 * t224 - 0.3e1 * t206 * t1228 * t906 - 0.3e1 * t206 * t918 * t1223 - 0.3e1 * t206 * t362 * t3196 - t206 * t233 * t4053 - t206 * t86 * (0.3e1 / 0.4e1 * t8303 - 0.15e2 / 0.32e2 * t8307 * tau[0] - 0.45e2 * t4880 * t4050 * t194 - 0.15e3 * t1551 * t219 * t4852 * tau[0] + 0.12e3 * t1551 * t75 * t3082);
  t10829 = -0.9e1 * t862 * t189 * t39 * t3196 - 0.6e1 * t1629 * t233 * t4071 + 0.3e1 * t188 * t4080 * t200 + 0.18e2 * t2253 * t870 * t4090 - 0.9e1 * t862 * t870 * t4033 - 0.18e2 * t7931 * t1201 - 0.9e1 * t2335 * t4034 - 0.18e2 * t9199 * t3136 + 0.36e2 * t3155 * t3139 - 0.18e2 * t3158 * t3148 - 0.18e2 * t3158 * t3152 + 0.18e2 * t5891 * t4091;
  t10865 = -0.48e2 * t2253 * t189 * t184 * t1211 + 0.48e2 * t3158 * t3132 + 0.24e2 * t862 * t189 * t184 * t1223 + 0.96e2 * t2694 * t525 * t849 * t357 + t10718 + 0.12e3 * t3155 * t3143 + 0.9e1 / 0.4e1 * t2694 * t1532 * t1518 * t224 - 0.15e2 * t857 * t4819 * t4852 * tau[0] + 0.9e1 / 0.4e1 * t2694 * t3119 * t2291 - 0.9e1 / 0.4e1 * t2253 * t3119 * t3203 + 0.15e2 / 0.4e1 * t862 * t3127 * t3207;
  t10866 = t498 * t1228;
  t10869 = t503 * t1228;
  t10899 = -0.48e2 * t1515 * t3082 * t79 * t86 + 0.6e1 * t188 * t362 * t849 * t59 - 0.18e2 * t2694 * t525 * t529 * t906 + 0.6e1 * t541 * t918 * t1211 + 0.18e2 * t857 * t1532 * t3082 - 0.3e1 * t206 * t3101 * t357 + 0.18e2 * t10866 * t859 - 0.9e1 * t10869 * t864 + 0.3e2 * t4064 * t875 - 0.18e2 * t7098 * t4083 - 0.18e2 * t7951 * t4083 - t10720;
  t10922 = t357 * t1223;
  t10929 = -0.6e1 * t862 * t7863 * t357 - 0.24e2 * t4064 * t878 - 0.96e2 * t3155 * t3103 + 0.9e1 / 0.8e1 * t862 * t3119 * t906 + 0.9e1 * t188 * t3101 * t349 + 0.9e1 * t4064 * t871 - 0.9e1 / 0.4e1 * t3155 * t3120 + 0.9e1 / 0.8e1 * t3158 * t3123 - 0.15e2 / 0.4e1 * t1204 * t3128 + 0.18e2 * t2253 * t10922 * t200 - 0.18e2 * t3419 * t10922 * t224;
  t10934 = t1515 * t1518;
  t10935 = t205 * t86;
  t10943 = t3108 * t362;
  t10966 = 0.18e2 * t4813 * t1518 * t4242 * t194 - 0.6e1 * t10934 * t10935 * t224 + 0.6e2 * t4868 * t4852 * t4242 * tau[0] + 0.18e2 * t10943 * t1197 + 0.18e2 * t7924 * t1197 - 0.9e1 / 0.4e1 * t3109 * t4058 - 0.9e1 / 0.4e1 * t2325 * t4058 - 0.9e1 / 0.4e1 * t857 * t5921 * t1518 + 0.9e1 / 0.8e1 * t2335 * t4061 + 0.2e1 * t541 * t4054 * t224 + 0.6e1 * t541 * t4046 * t224 - 0.3e1 * t503 * t4054 * t200;
  t10974 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4094 - t10664 - 0.3e1 / 0.8e1 * t6 * t28 * (t10698 + t10749 + t10798 + t10829 + t10865 + t10899 + t10929 + t10966));
  tv4rhosigma30 = t7 * t10974 + t4098;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t10981 = t6 * t251 * t4162 / 0.8e1;
  t10983 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4162 - t10981);
  tv4rhosigma39 = t7 * t10983 + t4166;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t10989 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4094 - t10664);
  tv4rhosigma310 = t7 * t10989 + t4098;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t11043 = 0.36e2 * t3375 * t1320 * t381 * t1004 + 0.6e2 * t3375 * t2612 * t1252 * tau[1] + 0.36e2 * t5604 * t8559 * t4337 * t3376 - 0.36e2 * t2606 * t4337 * t381 * t296 - 0.3e1 * t308 * t3388 * t381 - 0.3e1 * t308 * t1269 * t1004 - 0.3e1 * t308 * t1016 * t1264 - 0.3e1 * t308 * t386 * t3361 - t308 * t335 * t4137 - t308 * t151 * (0.3e1 / 0.4e1 * t8711 - 0.15e2 / 0.32e2 * t8715 * tau[1] - 0.45e2 * t5716 * t4134 * t296 - 0.15e3 * t2034 * t321 * t5693 * tau[1] + 0.12e3 * t2034 * t140 * t3255) - 0.6e1 * t2096 * t335 * t4158;
  t11053 = 0.125e3 / 0.3188646e7 * t1963 * t3256;
  t11080 = -0.54e2 * t8564 * t1320 * t1252 * t326 + 0.18e2 * t3375 * t1320 * t1264 * t326 - 0.3e2 * t2617 * t2612 * t1264 * tau[1] + 0.6e1 * t780 * t1016 * t1252 - 0.18e2 * t2606 * t1320 * t8689 + 0.36e2 * t6894 * t1320 * t8719 + 0.36e2 * t2120 * t8540 * t3377 + 0.3e1 * t290 * t4103 * t302 - t308 * t4103 * t326 - 0.12e3 * t8560 * t8554 * t3380 - 0.6e2 * t8547 * t3381 - t11053;
  t11116 = -0.36e2 * t8541 * t3372 - 0.9e1 * t960 * t291 * t107 * t3361 - 0.18e2 * t9475 * t3329 + 0.36e2 * t3320 * t3304 + 0.12e3 * t3320 * t3308 + 0.9e1 / 0.4e1 * t2923 * t2017 * t2004 * t326 - 0.15e2 * t955 * t5697 * t5693 * tau[1] + 0.9e1 / 0.4e1 * t2923 * t3296 * t2542 - 0.9e1 / 0.4e1 * t2541 * t3296 * t3376 - 0.48e2 * t2541 * t291 * t286 * t1252 + 0.96e2 * t2923 * t764 * t947 * t381;
  t11144 = 0.1e1 / t105 / t1946 * t29 * t283;
  t11146 = 0.625e3 / 0.2324522934e10 * t5527 * t11144;
  t11150 = 0.18e2 * t6641 * t4110 + 0.18e2 * t2541 * t968 * t4109 - 0.18e2 * t8458 * t4114 - 0.18e2 * t7606 * t4114 - 0.18e2 * t2923 * t764 * t768 * t1004 - 0.18e2 * t8435 * t1242 - 0.18e2 * t3323 * t3313 - 0.18e2 * t3323 * t3317 - 0.9e1 * t2595 * t4120 - 0.9e1 * t960 * t968 * t4119 + t11146 + 0.15e2 / 0.4e1 * t960 * t3278 * t3380;
  t11153 = t737 * t1269;
  t11156 = t742 * t1269;
  t11185 = 0.24e2 * t960 * t291 * t286 * t1264 + 0.6e1 * t780 * t985 * t1264 - 0.9e1 * t742 * t4127 * t302 - 0.9e1 * t742 * t4130 * t302 + 0.6e1 * t780 * t4127 * t326 + 0.6e1 * t780 * t4130 * t326 + 0.2e1 * t780 * t4138 * t326 + 0.18e2 * t11153 * t957 - 0.9e1 * t11156 * t962 + 0.48e2 * t3323 * t3333 + 0.3e2 * t4148 * t973;
  t11224 = -0.3e1 * t742 * t4138 * t302 - 0.18e2 * t2096 * t4124 * t326 + 0.12e2 * t780 * t1256 * t1004 + 0.24e2 * t5755 * t4159 * t326 - 0.18e2 * t2096 * t1253 * t1004 + 0.6e1 * t2002 * t4105 * t335 + 0.18e2 * t2120 * t4124 * t302 + 0.6e1 * t780 * t382 * t3361 - 0.9e1 / 0.8e1 * t290 * t1016 * t768 * t124 - 0.18e2 * t5600 * t4159 * t302 + 0.6e1 * t290 * t386 * t947 * t124 + 0.6e1 * t780 * t1005 * t1264;
  t11256 = -0.48e2 * t2002 * t3255 * t144 * t151 - 0.96e2 * t3320 * t3282 + 0.18e2 * t955 * t2017 * t3255 - 0.6e1 * t960 * t8645 * t381 - 0.24e2 * t4148 * t976 + t145 * (0.625e3 / 0.2324522934e10 * t5541 * t11144 - 0.125e3 / 0.3188646e7 * t1942 * t3256 - t11146 + t11053) + 0.9e1 / 0.8e1 * t3323 * t3300 - 0.15e2 / 0.4e1 * t1245 * t3279 + 0.18e2 * t8432 * t1238 - 0.9e1 / 0.4e1 * t3286 * t4142 - 0.9e1 / 0.4e1 * t2585 * t4142;
  t11270 = t381 * t1264;
  t11283 = t2002 * t2004;
  t11284 = t307 * t151;
  t11292 = t3285 * t386;
  t11295 = -0.9e1 / 0.4e1 * t955 * t6819 * t2004 + 0.9e1 / 0.8e1 * t2595 * t4145 + 0.9e1 / 0.8e1 * t960 * t3296 * t1004 + 0.9e1 * t290 * t3388 * t373 + 0.9e1 * t4148 * t969 + 0.18e2 * t2541 * t11270 * t302 - 0.18e2 * t3597 * t11270 * t326 - 0.9e1 / 0.4e1 * t3320 * t3297 + 0.18e2 * t5681 * t2004 * t4332 * t296 - 0.6e1 * t11283 * t11284 * t326 + 0.6e2 * t5735 * t5693 * t4332 * tau[1] + 0.18e2 * t11292 * t1238;
  t11303 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4162 - t10981 - 0.3e1 / 0.8e1 * t6 * t102 * (t11043 + t11080 + t11116 + t11150 + t11185 + t11224 + t11256 + t11295));
  tv4rhosigma319 = t7 * t11303 + t4166;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t11310 = t6 * t172 * t4252 / 0.8e1;
  t11334 = t9135 * tau[0];
  t11345 = t219 * t7154;
  t11358 = -0.21e2 / 0.4e1 * t3127 + 0.15e2 / 0.4e1 * t11334 - 0.9e1 / 0.4e1 * t5921 * t2730 - 0.15e2 * t4819 * t7154 * tau[0] + 0.63e2 / 0.4e1 * t4058 + 0.36e3 * t4880 * t4214 * t194 + 0.12e4 * t1551 * t11345 * tau[0] - 0.84e3 * t4051 - 0.72e3 * t1551 * t3469 * t194 - 0.21e4 * t562 * t9062 * tau[0] + 0.126e4 * t562 * t3189;
  t11375 = 0.3e1 * t188 * t1228 * t1054 - t206 * t1228 * t1093 - t206 * t86 * t11358 + 0.6e1 * t188 * t918 * t1290 - 0.2e1 * t206 * t918 * t1311 + 0.3e1 * t188 * t3101 * t396 + 0.6e1 * t188 * t362 * t3508 - t206 * t233 * t4219 - t206 * t3101 * t409 - 0.2e1 * t206 * t362 * t3482 + 0.12e2 * t9286 * t1201 + 0.12e2 * t9295 * t1201 + 0.32e2 * t3545 * t3132 - 0.32e2 * t3554 * t3132 + 0.12e2 * t3554 * t3148 - 0.12e2 * t3545 * t3152;
  t11378 = t1650 * t1284;
  t11384 = t1650 * t1291;
  t11393 = t1685 * t1301;
  t11402 = t1685 * t1312;
  t11420 = 0.4e2 * t498 * t1284 * t875 + 0.4e2 * t498 * t1291 * t875 - 0.12e2 * t1650 * t1301 * t859 - 0.2e2 * t503 * t1301 * t875 - 0.12e2 * t1650 * t1312 * t859 - 0.2e2 * t503 * t1312 * t875 - 0.12e2 * t11378 * t864 - 0.12e2 * t11384 * t864 + 0.12e2 * t11393 * t864 + 0.12e2 * t11402 * t864 - 0.12e2 * t9249 * t1201 - 0.12e2 * t9255 * t1201 - 0.12e2 * t9261 * t1201 + 0.12e2 * t9354 * t3136 - 0.12e2 * t3551 * t3139 - 0.4e2 * t3551 * t3143 + 0.12e2 * t3554 * t3152;
  t11473 = -0.12e2 * t3545 * t3148 + 0.4e1 * t541 * t1301 * t906 + 0.4e1 * t541 * t3489 * t357 + 0.4e1 * t541 * t3487 * t357 - 0.3e1 * t503 * t1037 * t1223 - 0.3e1 * t503 * t1055 * t1223 - 0.3e1 * t503 * t397 * t3196 + 0.3e1 / 0.4e1 * t188 * t233 * t2730 * t67 + 0.4e1 * t541 * t3485 * t357 - 0.6e1 * t503 * t3495 * t357 - 0.6e1 * t503 * t1284 * t906 - 0.6e1 * t503 * t3498 * t357 - 0.6e1 * t503 * t3509 * t357 - 0.6e1 * t503 * t1291 * t906 + 0.6e1 * t1685 * t1055 * t1211 - 0.6e1 * t1629 * t1064 * t1211 - 0.6e1 * t1629 * t1094 * t1211;
  t11525 = 0.6e1 * t1685 * t1037 * t1211 + 0.2e1 * t541 * t1064 * t1223 + 0.2e1 * t541 * t1094 * t1223 + 0.4e1 * t541 * t1312 * t906 - 0.3e1 * t503 * t4206 * t200 - 0.6e1 * t503 * t4208 * t200 - 0.3e1 * t503 * t4220 * t200 + 0.6e1 * t498 * t4222 * t200 + 0.12e2 * t498 * t4225 * t200 + 0.2e1 * t541 * t4206 * t224 + 0.4e1 * t541 * t4208 * t224 + 0.2e1 * t541 * t4220 * t224 - 0.3e1 * t503 * t4222 * t224 - 0.6e1 * t503 * t4225 * t224 + 0.2e1 * t541 * t410 * t3196 + 0.4e1 * t541 * t3483 * t357 - 0.6e1 * t503 * t3491 * t357;
  t11558 = t59 * t224;
  t11563 = t67 * tau[0];
  t11574 = t409 * t1518;
  t11582 = -0.21e2 / 0.4e1 * t188 * t86 * t1518 * t67 + 0.12e2 * t2325 * t4196 + 0.12e2 * t857 * t3508 * t52 * t1277 + 0.12e2 * t857 * t1290 * t194 * t1277 - 0.6e1 * t7931 * t1295 - 0.6e1 * t3158 * t3445 - 0.6e1 * t3158 * t3449 - 0.6e1 * t2335 * t4203 - 0.6e1 * t862 * t3482 * t52 * t1277 - 0.6e1 * t862 * t1311 * t194 * t1277 + 0.3e1 / 0.4e1 * t2694 * t4228 * t11558 - 0.5e1 / 0.2e1 * t857 * t396 * t1518 * t11563 + 0.3e1 / 0.4e1 * t2694 * t4235 * t59 * t200 - 0.3e1 / 0.4e1 * t2253 * t4235 * t11558 + 0.5e1 / 0.4e1 * t862 * t11574 * t11563 + 0.12e2 * t1532 * t529 * t4242 * t3438;
  t11631 = -0.6e1 * t1197 * t10935 * t9952 + 0.4e2 * t1541 * t1518 * t4242 * t396 * tau[0] - 0.6e1 * t7951 * t4248 - 0.6e1 * t7098 * t4248 - 0.6e1 * t2694 * t1093 * t53 * t4247 + 0.12e2 * t10943 * t1278 + 0.12e2 * t7924 * t1278 + 0.12e2 * t3155 * t3435 + 0.12e2 * t3155 * t3439 + 0.12e2 * t3109 * t4196 + 0.32e2 * t2694 * t4246 * t209 * t849 - 0.32e2 * t3155 * t3452 - 0.32e2 * t857 * t4195 * t3426 + 0.16e2 * t3158 * t3427 + 0.16e2 * t862 * t4202 * t3426 + 0.4e1 * t857 * t396 * t849 * t59 - 0.2e1 * t862 * t409 * t849 * t59;
  t11635 = t409 * t1211;
  t11642 = t79 * t233;
  t11653 = t1290 * t357;
  t11660 = t396 * t1223;
  t11678 = t1311 * t357;
  t11685 = -0.32e2 * t3103 * t4243 + 0.24e2 * t9153 * t11635 * t224 - 0.12e2 * t3419 * t3415 * t906 + 0.6e1 * t1197 * t11642 * t396 + 0.6e1 * t1197 * t4242 * t1054 - 0.12e2 * t9199 * t3423 + 0.12e2 * t7884 * t3412 - 0.12e2 * t2694 * t11653 * t200 + 0.12e2 * t2253 * t11653 * t224 - 0.6e1 * t2694 * t11660 * t200 + 0.6e1 * t2253 * t11660 * t224 + 0.3e1 / 0.2e1 * t857 * t3502 * t200 - 0.3e1 / 0.4e1 * t862 * t3502 * t224 + 0.15e2 / 0.4e1 * t348 * t11334 - 0.12e2 * t1629 * t362 * t3420 + 0.12e2 * t2253 * t11678 * t200 - 0.12e2 * t3419 * t11678 * t224;
  t11686 = t409 * t1223;
  t11701 = t396 * t1211;
  t11723 = t189 * t1200 * t224;
  t11727 = t513 * t4082 * tau[0];
  t11738 = 0.6e1 * t2253 * t11686 * t200 - 0.6e1 * t3419 * t11686 * t224 - 0.3e1 / 0.4e1 * t3109 * t4229 - 0.3e1 / 0.4e1 * t2325 * t4229 - 0.3e1 / 0.4e1 * t857 * t1054 * t529 * t59 + 0.12e2 * t6303 * t11701 * t200 - 0.18e2 * t5907 * t11701 * t224 + 0.12e2 * t2253 * t3411 * t906 + 0.3e1 / 0.8e1 * t2335 * t4236 + 0.3e1 / 0.8e1 * t862 * t1093 * t529 * t59 - 0.18e2 * t5907 * t11635 * t200 + 0.12e2 * t7884 * t3416 + 0.24e2 * t9234 * t11723 - 0.4e2 * t3545 * t11727 + 0.24e2 * t9354 * t189 * t1200 * t200 - 0.36e2 * t9229 * t11723 + 0.4e2 * t3554 * t11727;
  t11746 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4252 - t11310 - 0.3e1 / 0.8e1 * t6 * t28 * (t11375 + t11420 + t11473 + t11525 + t11582 + t11631 + t11685 + t11738));
  tv4rhosigma2tau0 = t7 * t11746 + t4256;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t11753 = t6 * t251 * t4342 / 0.8e1;
  t11755 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4342 - t11753);
  tv4rhosigma2tau11 = t7 * t11755 + t4346;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t11761 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4252 - t11310);
  tv4rhosigma2tau12 = t7 * t11761 + t4256;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t11772 = t2104 * t1327;
  t11778 = t2104 * t1334;
  t11787 = t2120 * t1344;
  t11796 = t2120 * t1355;
  t11808 = 0.4e2 * t737 * t1327 * t973 + 0.4e2 * t737 * t1334 * t973 - 0.12e2 * t2104 * t1344 * t957 - 0.2e2 * t742 * t1344 * t973 - 0.12e2 * t2104 * t1355 * t957 - 0.2e2 * t742 * t1355 * t973 - 0.12e2 * t11772 * t962 - 0.12e2 * t11778 * t962 + 0.12e2 * t11787 * t962 + 0.12e2 * t11796 * t962 - 0.12e2 * t9617 * t1242 - 0.12e2 * t3738 * t3304 - 0.4e2 * t3738 * t3308 - 0.12e2 * t3732 * t3313 - 0.12e2 * t3732 * t3317 + 0.12e2 * t9907 * t3329;
  t11847 = 0.32e2 * t2923 * t4336 * t311 * t947 - 0.32e2 * t955 * t4322 * t3678 + 0.16e2 * t960 * t4328 * t3678 - 0.12e2 * t9605 * t1242 - 0.12e2 * t9611 * t1242 + 0.12e2 * t9648 * t1242 + 0.12e2 * t9657 * t1242 + 0.12e2 * t8432 * t1321 + 0.12e2 * t3286 * t4323 + 0.12e2 * t3741 * t3313 + 0.12e2 * t3741 * t3317 + 0.12e2 * t3320 * t3665 + 0.12e2 * t3320 * t3669 - 0.32e2 * t3320 * t3679 + 0.16e2 * t3323 * t3682 + 0.32e2 * t3732 * t3333 - 0.32e2 * t3741 * t3333;
  t11899 = t124 * t326;
  t11903 = 0.12e2 * t2585 * t4323 + 0.12e2 * t955 * t3654 * t120 * t1320 + 0.12e2 * t955 * t1333 * t296 * t1320 - 0.6e1 * t8435 * t1338 - 0.6e1 * t3323 * t3675 - 0.6e1 * t3323 * t3687 - 0.6e1 * t2595 * t4329 - 0.6e1 * t960 * t3635 * t120 * t1320 - 0.6e1 * t960 * t1354 * t296 * t1320 + 0.12e2 * t2017 * t768 * t4332 * t3668 - 0.6e1 * t1238 * t11284 * t10641 + 0.4e2 * t2026 * t2004 * t4332 * t420 * tau[1] - 0.6e1 * t8458 * t4338 - 0.6e1 * t7606 * t4338 - 0.6e1 * t2923 * t1183 * t121 * t4337 + 0.3e1 / 0.4e1 * t2923 * t4279 * t124 * t302 - 0.3e1 / 0.4e1 * t2541 * t4279 * t11899;
  t11904 = t433 * t2004;
  t11905 = t132 * tau[1];
  t11918 = t433 * t1264;
  t11926 = t1333 * t381;
  t11933 = t420 * t1264;
  t11946 = t9803 * tau[1];
  t11959 = 0.5e1 / 0.4e1 * t960 * t11904 * t11905 + 0.3e1 / 0.4e1 * t2923 * t4286 * t11899 - 0.5e1 / 0.2e1 * t955 * t420 * t2004 * t11905 + 0.12e2 * t11292 * t1321 - 0.6e1 * t3597 * t11918 * t326 - 0.12e2 * t9475 * t3601 + 0.12e2 * t8409 * t3590 - 0.12e2 * t2923 * t11926 * t302 + 0.12e2 * t2541 * t11926 * t326 - 0.6e1 * t2923 * t11933 * t302 + 0.6e1 * t2541 * t11933 * t326 + 0.3e1 / 0.2e1 * t955 * t3648 * t302 - 0.3e1 / 0.4e1 * t960 * t3648 * t326 + 0.15e2 / 0.4e1 * t372 * t11946 - 0.32e2 * t3282 * t4333 - 0.2e1 * t960 * t433 * t947 * t124 + 0.4e1 * t955 * t420 * t947 * t124;
  t11973 = t321 * t7656;
  t11986 = -0.21e2 / 0.4e1 * t3278 + 0.15e2 / 0.4e1 * t11946 - 0.9e1 / 0.4e1 * t6819 * t2952 - 0.15e2 * t5697 * t7656 * tau[1] + 0.63e2 / 0.4e1 * t4142 + 0.36e3 * t5716 * t4271 * t296 + 0.12e4 * t2034 * t11973 * tau[1] - 0.84e3 * t4135 - 0.72e3 * t2034 * t3622 * t296 - 0.21e4 * t801 * t9834 * tau[1] + 0.126e4 * t801 * t3354;
  t12017 = t433 * t1252;
  t12031 = -t308 * t151 * t11986 - t308 * t1269 * t1183 - 0.2e1 * t308 * t1016 * t1354 - 0.2e1 * t308 * t386 * t3635 - t308 * t335 * t4276 + 0.3e1 * t290 * t1269 * t1144 + 0.6e1 * t290 * t1016 * t1333 + 0.6e1 * t290 * t386 * t3654 - t308 * t3388 * t433 + 0.3e1 * t290 * t3388 * t420 + 0.3e1 / 0.8e1 * t960 * t1183 * t768 * t124 - 0.18e2 * t6624 * t12017 * t302 + 0.24e2 * t9443 * t12017 * t326 - 0.12e2 * t3597 * t3593 * t1004 - 0.3e1 / 0.4e1 * t3286 * t4287 - 0.3e1 / 0.4e1 * t2585 * t4287;
  t12036 = t420 * t1252;
  t12051 = t1354 * t381;
  t12061 = t144 * t335;
  t12085 = -0.3e1 / 0.4e1 * t955 * t1144 * t768 * t124 + 0.12e2 * t6636 * t12036 * t302 - 0.18e2 * t6624 * t12036 * t326 + 0.12e2 * t2541 * t3589 * t1004 + 0.12e2 * t8409 * t3594 - 0.12e2 * t2096 * t386 * t3598 + 0.12e2 * t2541 * t12051 * t302 - 0.12e2 * t3597 * t12051 * t326 + 0.6e1 * t2541 * t11918 * t302 + 0.6e1 * t1238 * t12061 * t420 + 0.6e1 * t1238 * t4332 * t1144 + 0.3e1 / 0.8e1 * t2595 * t4280 - 0.6e1 * t2096 * t1184 * t1252 + 0.6e1 * t2120 * t1127 * t1252 + 0.6e1 * t2120 * t1145 * t1252 + 0.4e1 * t780 * t4265 * t326 - 0.3e1 * t742 * t4277 * t302;
  t12139 = 0.2e1 * t780 * t4277 * t326 - 0.6e1 * t2096 * t1154 * t1252 + 0.2e1 * t780 * t4263 * t326 - 0.6e1 * t742 * t4265 * t302 + 0.6e1 * t737 * t4257 * t302 - 0.3e1 * t742 * t4257 * t326 + 0.12e2 * t737 * t4260 * t302 - 0.6e1 * t742 * t4260 * t326 - 0.3e1 * t742 * t4263 * t302 - 0.6e1 * t742 * t1334 * t1004 - 0.3e1 * t742 * t1127 * t1264 - 0.3e1 * t742 * t1145 * t1264 - 0.3e1 * t742 * t421 * t3361 + 0.3e1 / 0.4e1 * t290 * t335 * t2952 * t132 - 0.6e1 * t742 * t3641 * t381 - 0.6e1 * t742 * t1327 * t1004 - 0.6e1 * t742 * t3644 * t381;
  t12178 = t752 * t4113 * tau[1];
  t12182 = t291 * t1241 * t326;
  t12193 = -0.6e1 * t742 * t3655 * t381 + 0.2e1 * t780 * t434 * t3361 - 0.6e1 * t742 * t3638 * t381 + 0.2e1 * t780 * t1184 * t1264 + 0.4e1 * t780 * t3636 * t381 + 0.4e1 * t780 * t1355 * t1004 + 0.2e1 * t780 * t1154 * t1264 + 0.4e1 * t780 * t1344 * t1004 + 0.4e1 * t780 * t3606 * t381 + 0.4e1 * t780 * t3658 * t381 + 0.4e1 * t780 * t3604 * t381 - 0.21e2 / 0.4e1 * t290 * t151 * t2004 * t132 + 0.4e2 * t3741 * t12178 + 0.24e2 * t9625 * t12182 - 0.4e2 * t3732 * t12178 + 0.24e2 * t9907 * t291 * t1241 * t302 - 0.36e2 * t9632 * t12182;
  t12201 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4342 - t11753 - 0.3e1 / 0.8e1 * t6 * t102 * (t11808 + t11847 + t11903 + t11959 + t12031 + t12085 + t12139 + t12193));
  tv4rhosigma2tau23 = t7 * t12201 + t4346;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t12208 = t6 * t172 * t4428 / 0.8e1;
  t12210 = t10014 * tau[0];
  t12212 = t5921 * t3799;
  t12214 = t10013 * tau[0];
  t12215 = t4819 * t12214;
  t12227 = t219 * t10013;
  t12247 = -0.2688e5 * t214 * t10079 * tau[0] + 0.336e5 * t562 * t10113 * tau[0] - 0.96e4 * t1551 * t12227 * tau[0] + 0.1152e5 * t1551 * t3854 * t194 - 0.1008e5 * t562 * t3862 * t194 - 0.288e4 * t4880 * t4417 * t194 - 0.72e2 * t4819 * t10029 - 0.3e3 * t4813 * t12214 + 0.216e3 * t1541 * t2730 + 0.12096e5 * t214 * t2765 - 0.3e2 * t12210 + 0.36e2 * t12212 + 0.24e3 * t12215 + 0.36e2 * t3502 - 0.216e3 * t4212 + 0.576e4 * t4215 - 0.1728e5 * t4217;
  t12286 = -t206 * t86 * t12247 - t206 * t233 * t4424 + 0.2e1 * t541 * t918 * t1381 - t206 * t918 * t1398 - t206 * t362 * t3876 + 0.3e1 * t188 * t918 * t1377 + 0.3e1 * t188 * t362 * t3815 + 0.3e1 * t188 * t233 * t4387 + 0.3e1 * t188 * t86 * (0.24e2 * t3502 - 0.2e2 * t12210 + 0.6e1 * t12212 + 0.4e2 * t12215 - 0.36e2 * t4212) + 0.6e1 * t3108 * t4353 + 0.6e1 * t498 * t918 * t1362 - 0.12e2 * t3545 * t3445 - 0.12e2 * t3545 * t3449;
  t12287 = t1650 * t1378;
  t12296 = t4754 * t1382;
  t12307 = t1685 * t1399;
  t12323 = 0.2e2 * t498 * t1378 * t875 + 0.2e2 * t1685 * t1382 * t875 + 0.12e2 * t4710 * t1382 * t859 - 0.6e1 * t1650 * t1399 * t859 - 0.1e2 * t503 * t1399 * t875 - 0.6e1 * t12287 * t864 - 0.18e2 * t12296 * t864 + 0.6e1 * t12307 * t864 - 0.12e2 * t9249 * t1295 - 0.12e2 * t9255 * t1295 - 0.12e2 * t9261 * t1295 - 0.3e1 * t2335 * t4405 + 0.32e2 * t3545 * t3427 + 0.12e2 * t3554 * t3445;
  t12372 = -0.3e1 * t862 * t3876 * t52 * t1277 - 0.3e1 * t862 * t1398 * t194 * t1277 - 0.16e2 * t857 * t4373 * t3426 - 0.16e2 * t2253 * t4391 * t3426 + 0.8e1 * t862 * t4404 * t3426 - 0.6e1 * t349 * t10935 * t1362 * t224 + 0.12e2 * t349 * t4242 * t396 * t1054 + 0.2e2 * t1218 * t4242 * t1362 * tau[0] + 0.24e2 * t6303 * t3772 * t2291 - 0.36e2 * t5907 * t3772 * t3203 + 0.6e1 * t3109 * t4374 + 0.6e1 * t2325 * t4374 + 0.6e1 * t857 * t3815 * t52 * t1277 + 0.6e1 * t857 * t1377 * t194 * t1277;
  t12414 = 0.6e1 * t2253 * t1381 * t194 * t1277 - 0.6e1 * t503 * t1037 * t1311 - 0.6e1 * t503 * t1055 * t1311 - 0.6e1 * t503 * t1284 * t1093 - 0.6e1 * t503 * t1291 * t1093 - 0.3e1 * t503 * t1378 * t906 + 0.6e1 * t498 * t4381 * t200 - 0.6e1 * t503 * t397 * t3482 - 0.6e1 * t503 * t3498 * t409 - 0.6e1 * t503 * t3509 * t409 - 0.3e1 * t503 * t3795 * t357 - 0.3e1 * t503 * t3816 * t357 - 0.16e2 * t878 * t4347 + 0.6e1 * t5891 * t4392;
  t12454 = 0.12e2 * t498 * t1037 * t1290 + 0.12e2 * t498 * t1284 * t1054 + 0.12e2 * t498 * t1055 * t1290 - 0.6e1 * t1650 * t1363 * t906 - 0.6e1 * t1650 * t4353 * t224 - 0.6e1 * t1650 * t3766 * t357 - 0.3e1 * t503 * t4411 * t200 + 0.2e1 * t541 * t4411 * t224 - 0.6e1 * t503 * t3491 * t409 - 0.6e1 * t503 * t3495 * t409 + 0.12e2 * t498 * t397 * t3508 + 0.12e2 * t3108 * t4356 - 0.6e1 * t7950 * t4350;
  t12497 = 0.4e1 * t541 * t1064 * t1311 + 0.4e1 * t541 * t1301 * t1093 + 0.4e1 * t541 * t1094 * t1311 - 0.6e1 * t1629 * t1382 * t906 + 0.2e1 * t541 * t1399 * t906 - 0.6e1 * t1629 * t4398 * t224 - 0.6e1 * t1629 * t3825 * t357 + 0.6e1 * t1685 * t4398 * t200 - 0.3e1 * t503 * t4425 * t200 - 0.3e1 * t503 * t4388 * t224 + 0.2e1 * t541 * t4425 * t224 + 0.4e1 * t541 * t410 * t3482 + 0.2e1 * t541 * t3837 * t357 + 0.2e1 * t541 * t3877 * t357;
  t12505 = t396 * t1311;
  t12509 = t1362 * t357;
  t12516 = t396 * t1290;
  t12535 = t1290 * t409;
  t12542 = -0.12e2 * t2694 * t3411 * t1054 + 0.12e2 * t2253 * t12505 * t224 + 0.12e2 * t6303 * t12509 * t224 - 0.12e2 * t2694 * t12516 * t224 - 0.12e2 * t2694 * t12535 * t200 + 0.12e2 * t2253 * t12535 * t224 + 0.6e1 * t498 * t4388 * t200 - 0.3e1 * t503 * t4381 * t224 + 0.12e2 * t2253 * t9958 * t357 + 0.12e2 * t2253 * t9962 * t357 + 0.12e2 * t2253 * t3772 * t906 - 0.12e2 * t9199 * t3773 + 0.12e2 * t7884 * t3776 + 0.12e2 * t5891 * t4361;
  t12546 = t1377 * t357;
  t12550 = t1381 * t357;
  t12560 = t409 * t1311;
  t12567 = t1398 * t357;
  t12590 = 0.24e2 * t9234 * t1294 * t1277 * t224 - 0.4e2 * t3545 * t1294 * t2345 * tau[0] - 0.12e2 * t3419 * t3415 * t1093 + 0.6e1 * t349 * t11642 * t1362 - 0.12e2 * t2694 * t12505 * t200 - 0.6e1 * t2694 * t12546 * t200 + 0.6e1 * t2253 * t12546 * t224 - 0.18e2 * t5907 * t12550 * t200 + 0.24e2 * t9153 * t12550 * t224 + 0.12e2 * t2253 * t12560 * t200 - 0.12e2 * t3419 * t12560 * t224 + 0.6e1 * t2253 * t12567 * t200 - 0.6e1 * t3419 * t12567 * t224 + 0.6e1 * t871 * t4347;
  t12598 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4428 - t12208 - 0.3e1 / 0.8e1 * t6 * t28 * (t12286 + t12323 + t12372 + t12414 + t12454 + t12497 + t12542 + t12590));
  tv4rhosigmatau20 = t7 * t12598 + t4432;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t12605 = t6 * t251 * t4514 / 0.8e1;
  t12607 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4514 - t12605);
  tv4rhosigmatau28 = t7 * t12607 + t4518;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t12613 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4428 - t12208);
  tv4rhosigmatau29 = t7 * t12613 + t4432;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t12657 = -0.3e1 * t742 * t1422 * t1004 - 0.6e1 * t2096 * t1426 * t1004 + 0.4e1 * t780 * t1154 * t1354 + 0.4e1 * t780 * t1344 * t1183 + 0.4e1 * t780 * t1184 * t1354 - 0.6e1 * t2096 * t4484 * t326 - 0.6e1 * t2096 * t3969 * t381 + 0.6e1 * t2120 * t4484 * t302 + 0.6e1 * t737 * t4467 * t302 + 0.6e1 * t737 * t4474 * t302 - 0.3e1 * t742 * t4467 * t326 - 0.3e1 * t742 * t4474 * t326 + 0.4e1 * t780 * t434 * t3635;
  t12700 = -0.6e1 * t2104 * t1407 * t1004 - 0.6e1 * t742 * t1127 * t1354 + 0.12e2 * t737 * t1327 * t1144 - 0.6e1 * t742 * t1145 * t1354 - 0.6e1 * t742 * t1327 * t1183 - 0.6e1 * t742 * t1334 * t1183 - 0.6e1 * t2104 * t4439 * t326 - 0.6e1 * t742 * t421 * t3635 - 0.6e1 * t742 * t3638 * t433 - 0.6e1 * t742 * t3641 * t433 - 0.6e1 * t742 * t3644 * t433 - 0.6e1 * t742 * t3655 * t433 - 0.3e1 * t742 * t3939 * t381 - 0.3e1 * t742 * t3960 * t381;
  t12742 = 0.2e1 * t780 * t1443 * t1004 + 0.12e2 * t737 * t1127 * t1333 + 0.12e2 * t737 * t1145 * t1333 - 0.1e2 * t742 * t1443 * t973 - 0.6e1 * t2104 * t3910 * t381 - 0.3e1 * t742 * t4497 * t302 - 0.3e1 * t742 * t4511 * t302 + 0.2e1 * t780 * t4497 * t326 + 0.2e1 * t780 * t4511 * t326 + 0.12e2 * t737 * t421 * t3654 + 0.2e1 * t780 * t3981 * t381 + 0.2e1 * t780 * t4021 * t381 + 0.12e2 * t3285 * t4442 - 0.6e1 * t8457 * t4436;
  t12755 = t2104 * t1422;
  t12764 = t5600 * t1426;
  t12775 = t2120 * t1443;
  t12778 = 0.2e2 * t737 * t1422 * t973 + 0.2e2 * t2120 * t1426 * t973 + 0.12e2 * t5604 * t1426 * t957 - 0.6e1 * t2104 * t1443 * t957 - 0.6e1 * t12755 * t962 - 0.18e2 * t12764 * t962 + 0.6e1 * t12775 * t962 - 0.12e2 * t9605 * t1338 - 0.12e2 * t9611 * t1338 - 0.12e2 * t9617 * t1338 - 0.12e2 * t3732 * t3675 + 0.12e2 * t3741 * t3675 + 0.32e2 * t3732 * t3682 - 0.12e2 * t3732 * t3687;
  t12824 = -0.6e1 * t373 * t11284 * t1406 * t326 + 0.12e2 * t373 * t4332 * t420 * t1144 + 0.6e1 * t955 * t3959 * t120 * t1320 - 0.3e1 * t960 * t4020 * t120 * t1320 + 0.2e2 * t1259 * t4332 * t1406 * tau[1] + 0.6e1 * t955 * t1421 * t296 * t1320 + 0.6e1 * t2541 * t1425 * t296 * t1320 - 0.3e1 * t960 * t1442 * t296 * t1320 - 0.36e2 * t6624 * t3916 * t3376 + 0.6e1 * t2585 * t4460 - 0.3e1 * t2595 * t4491 + 0.6e1 * t3286 * t4460 + 0.6e1 * t6641 * t4478;
  t12848 = t433 * t1354;
  t12855 = t1442 * t381;
  t12867 = 0.12e2 * t2541 * t3916 * t1004 + 0.12e2 * t2541 * t10610 * t381 - 0.12e2 * t3597 * t3593 * t1183 + 0.6e1 * t373 * t12061 * t1406 + 0.12e2 * t2541 * t12848 * t302 - 0.12e2 * t3597 * t12848 * t326 + 0.6e1 * t2541 * t12855 * t302 - 0.6e1 * t3597 * t12855 * t326 - 0.16e2 * t2541 * t4477 * t3678 + 0.24e2 * t6636 * t3916 * t2542 - 0.16e2 * t955 * t4459 * t3678 + 0.8e1 * t960 * t4490 * t3678 + 0.6e1 * t969 * t4433 - 0.16e2 * t976 * t4433;
  t12869 = t1406 * t381;
  t12876 = t420 * t1333;
  t12889 = t1333 * t433;
  t12896 = t420 * t1354;
  t12903 = t1421 * t381;
  t12910 = t1425 * t381;
  t12914 = 0.12e2 * t2541 * t10619 * t381 - 0.12e2 * t2923 * t3589 * t1144 + 0.12e2 * t6636 * t12869 * t326 - 0.12e2 * t2923 * t12876 * t326 + 0.12e2 * t2541 * t12889 * t326 - 0.12e2 * t2923 * t12889 * t302 + 0.12e2 * t2541 * t12896 * t326 - 0.12e2 * t2923 * t12896 * t302 + 0.6e1 * t2541 * t12903 * t326 - 0.6e1 * t2923 * t12903 * t302 - 0.18e2 * t6624 * t12910 * t302 - 0.12e2 * t9475 * t3917 + 0.12e2 * t8409 * t3920 + 0.12e2 * t6641 * t4447;
  t12927 = t10567 * tau[1];
  t12929 = t6819 * t3943;
  t12931 = t10456 * tau[1];
  t12932 = t5697 * t12931;
  t12973 = t321 * t10456;
  t12993 = 0.336e5 * t801 * t10457 * tau[1] - 0.2688e5 * t316 * t10464 * tau[1] - 0.96e4 * t2034 * t12973 * tau[1] + 0.1152e5 * t2034 * t3998 * t296 - 0.1008e5 * t801 * t4006 * t296 - 0.288e4 * t5716 * t4503 * t296 - 0.72e2 * t5697 * t10448 - 0.3e3 * t5681 * t12931 + 0.216e3 * t2026 * t2952 + 0.12096e5 * t316 * t2984 - 0.3e2 * t12927 + 0.36e2 * t12929 + 0.24e3 * t12932 + 0.36e2 * t3648 - 0.216e3 * t4269 + 0.576e4 * t4272 - 0.1728e5 * t4274;
  t12999 = 0.24e2 * t9443 * t12910 * t326 + 0.24e2 * t9625 * t1337 * t1320 * t326 - 0.4e2 * t3732 * t1337 * t2612 * tau[1] + 0.3e1 * t290 * t151 * (0.24e2 * t3648 - 0.2e2 * t12927 + 0.6e1 * t12929 + 0.4e2 * t12932 - 0.36e2 * t4269) + 0.6e1 * t3285 * t4439 + 0.6e1 * t737 * t1016 * t1406 + 0.3e1 * t290 * t1016 * t1421 + 0.3e1 * t290 * t386 * t3959 + 0.3e1 * t290 * t335 * t4473 - t308 * t1016 * t1442 - t308 * t386 * t4020 - t308 * t335 * t4510 - t308 * t151 * t12993 + 0.2e1 * t780 * t1016 * t1425;
  t13007 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4514 - t12605 - 0.3e1 / 0.8e1 * t6 * t102 * (t12657 + t12700 + t12742 + t12778 + t12824 + t12867 + t12914 + t12999));
  tv4rhosigmatau217 = t7 * t13007 + t4518;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t13014 = t6 * t172 * t4575 / 0.8e1;
  t13015 = t409 * t1398;
  t13022 = t396 * t1377;
  t13026 = t396 * t1381;
  t13036 = t1377 * t409;
  t13043 = t396 * t1398;
  t13053 = -0.36e2 * t2694 * t3772 * t1054 + 0.36e2 * t2253 * t3772 * t1093 + 0.18e2 * t2253 * t13015 * t200 - 0.18e2 * t3419 * t13015 * t224 - 0.18e2 * t2694 * t13022 * t224 + 0.36e2 * t6303 * t13026 * t200 - 0.54e2 * t5907 * t13026 * t224 - 0.18e2 * t2694 * t13036 * t200 + 0.18e2 * t2253 * t13036 * t224 - 0.18e2 * t2694 * t13043 * t200 + 0.18e2 * t2253 * t13043 * t224;
  t13054 = t1362 * t409;
  t13058 = 0.24e3 * t3800;
  t13060 = 0.1e1 / t37 / t487;
  t13061 = t13060 * t209;
  t13063 = 0.24e3 * t13061 * tau[0];
  t13064 = t5921 * t4538;
  t13066 = t13060 * tau[0];
  t13067 = t4819 * t13066;
  t13070 = t4538 * t194;
  t13071 = t4819 * t13070;
  t13073 = t4813 * t13066;
  t13082 = -0.48e4 * t4868 * t13066 - 0.144e4 * t4813 * t13070 + 0.24e4 * t1515 * t3799 - t13058 + t13063 - 0.432e3 * t13064 - 0.288e4 * t13067 + 0.1728e4 * t13071 + 0.72e4 * t13073 + 0.216e4 * t4385 - 0.432e4 * t4415;
  t13086 = t219 * t13060;
  t13094 = t573 * t13060;
  t13102 = t1560 * t13060;
  t13116 = -0.32256e6 * t72 * t4848 * t13060 * tau[0] + 0.768e5 * t1551 * t13086 * tau[0] - 0.4032e6 * t562 * t13094 * tau[0] + 0.64512e6 * t214 * t13102 * tau[0] - 0.13824e6 * t1551 * t4563 * t194 - 0.129024e6 * t214 * t4569 * t194 + 0.2304e5 * t4880 * t4560 * t194 + 0.24192e6 * t562 * t4566 * t194 + 0.10752e6 * t72 * t3870 - 0.384e5 * t4418 + 0.1728e6 * t4420 - 0.24192e6 * t4422;
  t13120 = t1362 * t79;
  t13123 = t4519 * t205;
  t13153 = 0.36e2 * t6303 * t13054 * t224 - t206 * t86 * (t13082 + t13116) + 0.18e2 * t13120 * t1055 - 0.6e1 * t13123 * t225 + 0.3e1 * t188 * t233 * t4545 + 0.3e1 * t188 * t86 * (-t13058 + t13063 - 0.144e3 * t13064 - 0.96e3 * t13067 + 0.72e3 * t4385 + 0.192e3 * t13071 + 0.8e3 * t13073 - 0.48e3 * t4415) - 0.6e1 * t1629 * t233 * t4549 - t206 * t233 * t4572 - 0.3e1 * t503 * t4573 * t200 + 0.2e1 * t541 * t4573 * t224 + 0.6e1 * t541 * t1094 * t1398;
  t13188 = -0.9e1 * t503 * t1037 * t1398 - 0.9e1 * t503 * t1055 * t1398 + 0.6e1 * t541 * t1064 * t1398 - 0.18e2 * t1629 * t1382 * t1093 + 0.6e1 * t498 * t4546 * t200 - 0.18e2 * t4754 * t4550 * t200 - 0.3e1 * t503 * t4546 * t224 + 0.24e2 * t4972 * t4550 * t224 - 0.9e1 * t503 * t3816 * t409 - 0.9e1 * t503 * t397 * t3876 + 0.6e1 * t541 * t410 * t3876;
  t13222 = 0.18e2 * t498 * t1037 * t1377 + 0.18e2 * t1685 * t1037 * t1381 + 0.18e2 * t498 * t1055 * t1377 + 0.18e2 * t1685 * t1055 * t1381 - 0.18e2 * t1650 * t1363 * t1093 - 0.9e1 * t503 * t1378 * t1093 - 0.18e2 * t1650 * t3766 * t409 - 0.9e1 * t503 * t3795 * t409 + 0.18e2 * t498 * t397 * t3815 + 0.6e1 * t4520 * t233 + 0.18e2 * t3108 * t4526 - 0.18e2 * t7950 * t4523;
  t13229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4575 - t13014 - 0.3e1 / 0.8e1 * t6 * t28 * (t13053 + t13153 + t13188 + t13222));
  tv4rhotau30 = t7 * t13229 + t4579;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t13236 = t6 * t251 * t4636 / 0.8e1;
  t13238 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4636 - t13236);
  tv4rhotau33 = t7 * t13238 + t4640;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t13244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4575 - t13014);
  tv4rhotau34 = t7 * t13244 + t4579;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t13249 = 0.24e3 * t3944;
  t13251 = 0.1e1 / t105 / t726;
  t13252 = t13251 * t311;
  t13254 = 0.24e3 * t13252 * tau[1];
  t13255 = t6819 * t4599;
  t13257 = t13251 * tau[1];
  t13258 = t5697 * t13257;
  t13261 = t4599 * t296;
  t13262 = t5697 * t13261;
  t13264 = t5681 * t13257;
  t13273 = -0.48e4 * t5735 * t13257 - 0.144e4 * t5681 * t13261 + 0.24e4 * t2002 * t3943 - t13249 + t13254 - 0.432e3 * t13255 - 0.288e4 * t13258 + 0.1728e4 * t13262 + 0.72e4 * t13264 + 0.216e4 * t4471 - 0.432e4 * t4501;
  t13277 = t321 * t13251;
  t13285 = t812 * t13251;
  t13293 = t2012 * t13251;
  t13307 = -0.32256e6 * t137 * t5689 * t13251 * tau[1] + 0.768e5 * t2034 * t13277 * tau[1] - 0.4032e6 * t801 * t13285 * tau[1] + 0.64512e6 * t316 * t13293 * tau[1] - 0.13824e6 * t2034 * t4624 * t296 - 0.129024e6 * t316 * t4630 * t296 + 0.2304e5 * t5716 * t4621 * t296 + 0.24192e6 * t801 * t4627 * t296 + 0.10752e6 * t137 * t4014 - 0.384e5 * t4504 + 0.1728e6 * t4506 - 0.24192e6 * t4508;
  t13311 = t1406 * t144;
  t13314 = t4580 * t307;
  t13335 = t1406 * t433;
  t13342 = t420 * t1421;
  t13346 = t420 * t1425;
  t13350 = -t308 * t151 * (t13273 + t13307) + 0.18e2 * t13311 * t1145 - 0.6e1 * t13314 * t327 + 0.3e1 * t290 * t335 * t4606 + 0.3e1 * t290 * t151 * (-t13249 + t13254 - 0.144e3 * t13255 - 0.96e3 * t13258 + 0.72e3 * t4471 + 0.192e3 * t13262 + 0.8e3 * t13264 - 0.48e3 * t4501) - 0.6e1 * t2096 * t335 * t4610 - t308 * t335 * t4633 + 0.36e2 * t6636 * t13335 * t326 - 0.36e2 * t2923 * t3916 * t1144 - 0.18e2 * t2923 * t13342 * t326 + 0.36e2 * t6636 * t13346 * t302;
  t13357 = t1421 * t433;
  t13364 = t420 * t1442;
  t13371 = t433 * t1442;
  t13387 = -0.18e2 * t2096 * t1426 * t1183 + 0.36e2 * t2541 * t3916 * t1183 - 0.54e2 * t6624 * t13346 * t326 + 0.18e2 * t2541 * t13357 * t326 - 0.18e2 * t2923 * t13357 * t302 + 0.18e2 * t2541 * t13364 * t326 - 0.18e2 * t2923 * t13364 * t302 + 0.18e2 * t2541 * t13371 * t302 - 0.18e2 * t3597 * t13371 * t326 + 0.6e1 * t737 * t4607 * t302 - 0.3e1 * t742 * t4607 * t326;
  t13422 = 0.18e2 * t2120 * t1127 * t1425 - 0.9e1 * t742 * t1127 * t1442 + 0.18e2 * t2120 * t1145 * t1425 - 0.9e1 * t742 * t1145 * t1442 - 0.18e2 * t2104 * t1407 * t1183 - 0.9e1 * t742 * t1422 * t1183 - 0.18e2 * t5600 * t4611 * t302 + 0.24e2 * t5755 * t4611 * t326 - 0.9e1 * t742 * t3939 * t433 - 0.9e1 * t742 * t3960 * t433 - 0.9e1 * t742 * t421 * t4020;
  t13456 = 0.18e2 * t737 * t1127 * t1421 + 0.18e2 * t737 * t1145 * t1421 + 0.6e1 * t780 * t1154 * t1442 + 0.6e1 * t780 * t1184 * t1442 - 0.18e2 * t2104 * t3910 * t433 - 0.3e1 * t742 * t4634 * t302 + 0.2e1 * t780 * t4634 * t326 + 0.18e2 * t737 * t421 * t3959 + 0.6e1 * t780 * t434 * t4020 + 0.18e2 * t3285 * t4587 + 0.6e1 * t4581 * t335 - 0.18e2 * t8457 * t4584;
  t13463 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4636 - t13236 - 0.3e1 / 0.8e1 * t6 * t102 * (t13350 + t13387 + t13422 + t13456));
  tv4rhotau37 = t7 * t13463 + t4640;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t13469 = t4852 * t29 * t33;
  t13471 = t4692 * t13469;
  t13520 = 0.72e2 * t3202 * t1277 * t10922 + t80 * (-0.625e3 / 0.6198727824e10 * t4665 * t13469 + 0.625e3 / 0.6198727824e10 * t13471) - 0.36e2 * t3158 * t4034 - 0.12e2 * t862 * t189 * t39 * t4053 - 0.45e2 / 0.8e1 * t206 * t86 * t4880 * t75 * t4852 + 0.9e1 * t2694 * t1532 * t1518 * t357 - 0.72e2 * t5907 * t4071 * t52 * t1277 + 0.72e2 * t6303 * t525 * t529 * t1211 + 0.72e2 * t7884 * t4091 - 0.72e2 * t9199 * t4083 - 0.36e2 * t2694 * t525 * t529 * t1223 - 0.36e2 * t10869 * t1201 + 0.12e2 * t188 * t4080 * t349 + 0.9e1 / 0.2e1 * t3158 * t4061 + 0.9e1 / 0.4e1 * t862 * t3119 * t1223 + 0.36e2 * t10866 * t1197 - 0.9e1 * t3155 * t4058;
  t13567 = t1211 * t1211;
  t13571 = t1223 * t1223;
  t13575 = -0.24e2 * t10934 * t10935 * t357 - 0.9e1 / 0.2e1 * t2253 * t3119 * t1211 - 0.625e3 / 0.6198727824e10 * t13471 + 0.24e2 * t1515 * t4086 * t362 - 0.9e1 / 0.2e1 * t4813 * t4852 * t79 * t86 - 0.36e2 * t1629 * t1212 * t1223 + 0.24e2 * t541 * t1215 * t1223 + 0.8e1 * t541 * t4054 * t357 + 0.9e1 / 0.32e2 * t498 * t86 * t4852 * t209 - 0.9e1 / 0.4e1 * t188 * t1228 * t529 * t59 + 0.12e2 * t541 * t1228 * t1211 - 0.4e1 * t206 * t4080 * t357 - 0.6e1 * t206 * t1228 * t1223 - 0.4e1 * t206 * t362 * t4053 - 0.24e2 * t1629 * t362 * t4071 + 0.24e2 * t4972 * t86 * t13567 + 0.6e1 * t541 * t86 * t13571;
  t13580 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t13520 + t13575));
  tv4sigma40 = t7 * t13580;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t13630 = t5693 * t29 * t33;
  t13631 = t5527 * t13630;
  t13633 = 0.72e2 * t3375 * t1320 * t11270 + 0.9e1 * t2923 * t2017 * t2004 * t381 - 0.36e2 * t11156 * t1242 - 0.36e2 * t3323 * t4120 - 0.12e2 * t960 * t291 * t107 * t4137 - 0.45e2 / 0.8e1 * t308 * t151 * t5716 * t140 * t5693 + 0.72e2 * t8409 * t4110 - 0.72e2 * t6624 * t291 * t107 * t4158 + 0.72e2 * t6636 * t764 * t768 * t1252 - 0.72e2 * t9475 * t4114 - 0.36e2 * t2923 * t764 * t768 * t1264 - 0.9e1 / 0.2e1 * t2541 * t3296 * t1252 + 0.9e1 / 0.2e1 * t3323 * t4145 + 0.9e1 / 0.4e1 * t960 * t3296 * t1264 + 0.36e2 * t11153 * t1238 - 0.9e1 * t3320 * t4142 - 0.625e3 / 0.6198727824e10 * t13631;
  t13680 = t1264 * t1264;
  t13684 = t1252 * t1252;
  t13691 = 0.12e2 * t290 * t4103 * t373 - 0.24e2 * t11283 * t11284 * t381 + 0.24e2 * t780 * t1256 * t1264 + 0.8e1 * t780 * t4138 * t381 + 0.9e1 / 0.32e2 * t737 * t151 * t5693 * t311 - 0.9e1 / 0.4e1 * t290 * t1269 * t768 * t124 + 0.24e2 * t2002 * t4105 * t386 - 0.9e1 / 0.2e1 * t5681 * t5693 * t144 * t151 - 0.36e2 * t2096 * t1253 * t1264 + t145 * (-0.625e3 / 0.6198727824e10 * t5541 * t13630 + 0.625e3 / 0.6198727824e10 * t13631) - 0.4e1 * t308 * t4103 * t381 + 0.12e2 * t780 * t1269 * t1252 - 0.6e1 * t308 * t1269 * t1264 - 0.4e1 * t308 * t386 * t4137 + 0.6e1 * t780 * t151 * t13680 + 0.24e2 * t5755 * t151 * t13684 - 0.24e2 * t2096 * t386 * t4158;
  t13696 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t13633 + t13691));
  tv4sigma414 = t7 * t13696;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t13722 = t59 * t357;
  t13731 = 0.36e2 * t9354 * t4083 - 0.36e2 * t11378 * t1201 - 0.36e2 * t11384 * t1201 - 0.18e2 * t3545 * t4034 + 0.36e2 * t11393 * t1201 + 0.36e2 * t11402 * t1201 + 0.18e2 * t3554 * t4034 + 0.36e2 * t9234 * t4091 - 0.54e2 * t9229 * t4091 + 0.9e1 / 0.4e1 * t2694 * t11574 * t1532 - 0.9e1 * t862 * t4219 * t52 * t1277 + 0.9e1 / 0.4e1 * t2694 * t4228 * t13722 - 0.9e1 / 0.4e1 * t2253 * t4235 * t13722 + 0.18e2 * t10866 * t1278;
  t13762 = t79 * t362;
  t13772 = 0.36e2 * t3155 * t4196 - 0.9e1 * t10869 * t1295 - 0.18e2 * t3158 * t4203 - 0.18e2 * t1197 * t10935 * t3411 - 0.18e2 * t9199 * t4248 - 0.18e2 * t2694 * t1311 * t53 * t4247 - 0.18e2 * t3419 * t11686 * t357 - 0.9e1 / 0.4e1 * t3155 * t4229 - 0.9e1 / 0.4e1 * t857 * t1290 * t529 * t59 + 0.9e1 / 0.8e1 * t3158 * t4236 + 0.9e1 / 0.8e1 * t862 * t1311 * t529 * t59 + 0.18e2 * t1197 * t13762 * t396 + 0.18e2 * t1197 * t4242 * t1290 - 0.6e1 * t10934 * t10935 * t409;
  t13816 = -0.9e1 / 0.4e1 * t4058 * t4243 + 0.9e1 / 0.2e1 * t857 * t7154 * t556 * t52 - 0.9e1 / 0.4e1 * t862 * t3502 * t357 + 0.18e2 * t2253 * t11660 * t357 - 0.18e2 * t4754 * t397 * t4071 + 0.24e2 * t4972 * t410 * t4071 - 0.18e2 * t1629 * t1312 * t1211 + 0.18e2 * t1685 * t1291 * t1211 - 0.18e2 * t1629 * t1301 * t1211 + 0.12e2 * t541 * t4208 * t357 + 0.6e1 * t541 * t1301 * t1223 + 0.6e1 * t541 * t4220 * t357 + 0.6e1 * t541 * t1312 * t1223 + 0.2e1 * t541 * t410 * t4053;
  t13865 = 0.18e2 * t1685 * t1284 * t1211 - 0.9e1 * t503 * t1284 * t1223 - 0.9e1 * t503 * t1291 * t1223 - 0.3e1 * t503 * t397 * t4053 + 0.9e1 / 0.4e1 * t188 * t362 * t2730 * t67 + 0.6e1 * t541 * t4206 * t357 - 0.9e1 * t503 * t4222 * t357 - 0.18e2 * t503 * t4225 * t357 - 0.3e1 * t206 * t362 * t4219 - t206 * t86 * (0.9e1 / 0.32e2 * t9135 - 0.45e2 * t4880 * t75 * t7154 + 0.9e2 * t1551 * t11345) + 0.3e1 * t188 * t4080 * t396 + 0.9e1 * t188 * t1228 * t1290 - t206 * t4080 * t409 - 0.3e1 * t206 * t1228 * t1311;
  t13871 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t13731 + t13772 + t13816 + t13865));
  tv4sigma3tau0 = t7 * t13871;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t13904 = 0.36e2 * t9907 * t4114 - 0.54e2 * t9632 * t4110 + 0.36e2 * t9625 * t4110 + 0.36e2 * t11787 * t1242 + 0.36e2 * t11796 * t1242 + 0.18e2 * t3741 * t4120 - 0.36e2 * t11772 * t1242 - 0.36e2 * t11778 * t1242 - 0.18e2 * t3732 * t4120 - 0.18e2 * t2923 * t1354 * t121 * t4337 - 0.18e2 * t1238 * t11284 * t3589 + 0.9e1 / 0.4e1 * t2923 * t11904 * t2017 + 0.18e2 * t11153 * t1321 + 0.36e2 * t3320 * t4323;
  t13913 = t124 * t381;
  t13945 = -0.9e1 * t11156 * t1338 - 0.18e2 * t3323 * t4329 - 0.9e1 * t960 * t4276 * t120 * t1320 - 0.9e1 / 0.4e1 * t2541 * t4279 * t13913 + 0.9e1 / 0.4e1 * t2923 * t4286 * t13913 - 0.18e2 * t9475 * t4338 + 0.9e1 / 0.8e1 * t3323 * t4280 + 0.9e1 / 0.8e1 * t960 * t1354 * t768 * t124 - 0.18e2 * t3597 * t3593 * t1264 - 0.9e1 / 0.4e1 * t3320 * t4287 - 0.9e1 / 0.4e1 * t955 * t1333 * t768 * t124 + 0.18e2 * t2541 * t3589 * t1264 - 0.9e1 / 0.4e1 * t960 * t3648 * t381 - 0.9e1 / 0.4e1 * t4142 * t4333;
  t13951 = t144 * t386;
  t13991 = 0.9e1 / 0.2e1 * t955 * t7656 * t795 * t120 + 0.18e2 * t1238 * t13951 * t420 + 0.18e2 * t1238 * t4332 * t1333 - 0.6e1 * t11283 * t11284 * t433 - 0.18e2 * t5600 * t421 * t4158 + 0.2e1 * t780 * t434 * t4137 + 0.24e2 * t5755 * t434 * t4158 - 0.18e2 * t2096 * t1355 * t1252 + 0.18e2 * t2120 * t1327 * t1252 + 0.18e2 * t2120 * t1334 * t1252 + 0.6e1 * t780 * t1344 * t1264 + 0.6e1 * t780 * t1355 * t1264 + 0.12e2 * t780 * t4265 * t381 + 0.6e1 * t780 * t4277 * t381;
  t14040 = -0.18e2 * t2096 * t1344 * t1252 - 0.18e2 * t742 * t4260 * t381 + 0.9e1 / 0.4e1 * t290 * t386 * t2952 * t132 + 0.6e1 * t780 * t4263 * t381 - 0.9e1 * t742 * t1327 * t1264 - 0.9e1 * t742 * t1334 * t1264 - 0.3e1 * t742 * t421 * t4137 - 0.9e1 * t742 * t4257 * t381 + 0.9e1 * t290 * t1269 * t1333 - t308 * t4103 * t433 - 0.3e1 * t308 * t1269 * t1354 - 0.3e1 * t308 * t386 * t4276 - t308 * t151 * (0.9e1 / 0.32e2 * t9803 - 0.45e2 * t5716 * t140 * t7656 + 0.9e2 * t2034 * t11973) + 0.3e1 * t290 * t4103 * t420;
  t14046 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t13904 + t13945 + t13991 + t14040));
  tv4sigma3tau19 = t7 * t14046;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t14088 = 0.12e2 * t12307 * t1201 - 0.24e2 * t11378 * t1295 - 0.24e2 * t11384 * t1295 - 0.24e2 * t3545 * t4203 - 0.12e2 * t12287 * t1201 - 0.36e2 * t12296 * t1201 + 0.24e2 * t3554 * t4203 - 0.6e1 * t2694 * t1398 * t53 * t4247 - 0.6e1 * t3158 * t4405 - 0.6e1 * t862 * t4424 * t52 * t1277 - 0.12e2 * t349 * t10935 * t12509 + 0.24e2 * t349 * t4242 * t12516 + 0.3e1 / 0.2e1 * t2694 * t3772 * t3119 + 0.12e2 * t3155 * t4374 + 0.12e2 * t857 * t4387 * t52 * t1277 + 0.12e2 * t7884 * t4392;
  t14142 = -0.12e2 * t1197 * t10935 * t3772 + 0.12e2 * t6303 * t1381 * t53 * t4247 + 0.8e1 * t541 * t1301 * t1311 - 0.6e1 * t503 * t397 * t4219 - 0.6e1 * t503 * t4381 * t357 - 0.6e1 * t503 * t4388 * t357 - 0.3e1 * t503 * t1378 * t1223 - 0.9e1 / 0.4e1 * t188 * t86 * t10013 * t209 - 0.12e2 * t1629 * t4398 * t357 - 0.6e1 * t1629 * t1382 * t1223 - 0.6e1 * t1650 * t1363 * t1223 + 0.24e2 * t498 * t1284 * t1290 - 0.6e1 * t503 * t4222 * t409 - 0.12e2 * t503 * t4225 * t409 - 0.12e2 * t503 * t1284 * t1311 - 0.12e2 * t503 * t1291 * t1311 + 0.6e1 * t1197 * t4242 * t1377;
  t14195 = 0.24e2 * t7884 * t4361 + 0.24e2 * t2253 * t12535 * t357 + 0.24e2 * t2253 * t12505 * t357 + 0.12e2 * t2253 * t3772 * t1223 - 0.36e2 * t5907 * t3772 * t1211 - 0.3e1 / 0.2e1 * t862 * t3502 * t409 - 0.3e1 / 0.4e1 * t857 * t1377 * t529 * t59 - 0.3e1 / 0.4e1 * t2253 * t1381 * t529 * t59 - 0.24e2 * t3419 * t3415 * t1311 + 0.3e1 / 0.8e1 * t862 * t1398 * t529 * t59 + 0.12e2 * t349 * t13762 * t1362 - 0.24e2 * t2694 * t3411 * t1290 + 0.3e1 * t857 * t396 * t2730 * t67 + 0.4e1 * t541 * t410 * t4219 + 0.4e1 * t541 * t4411 * t357 + 0.4e1 * t541 * t4425 * t357;
  t14250 = t1290 * t1290;
  t14254 = t1311 * t1311;
  t14258 = 0.2e1 * t541 * t1399 * t1223 - 0.3e1 / 0.4e1 * t3119 * t4347 - 0.12e2 * t1650 * t4353 * t357 - 0.6e1 * t1629 * t1399 * t1211 + 0.12e2 * t4710 * t1363 * t1211 + 0.6e1 * t1685 * t1378 * t1211 + 0.24e2 * t4972 * t1382 * t1211 + 0.48e2 * t9234 * t1294 * t1277 * t357 + 0.6e1 * t188 * t362 * t4387 + 0.2e1 * t541 * t1228 * t1381 - t206 * t1228 * t1398 - 0.2e1 * t206 * t362 * t4424 - t206 * t86 * (-0.9e1 / 0.2e1 * t10014 + 0.9e1 * t4819 * t10013 + 0.36e3 * t4880 * t75 * t10013 - 0.144e4 * t1551 * t12227 + 0.126e4 * t562 * t10113) + 0.6e1 * t498 * t1228 * t1362 + 0.3e1 * t188 * t1228 * t1377 + 0.12e2 * t498 * t86 * t14250 + 0.4e1 * t541 * t86 * t14254;
  t14264 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t14088 + t14142 + t14195 + t14258));
  tv4sigma2tau20 = t7 * t14264;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t14317 = 0.2e1 * t780 * t1269 * t1425 - t308 * t1269 * t1442 - 0.2e1 * t308 * t386 * t4510 - t308 * t151 * (-0.9e1 / 0.2e1 * t10567 + 0.9e1 * t5697 * t10456 + 0.36e3 * t5716 * t140 * t10456 - 0.144e4 * t2034 * t12973 + 0.126e4 * t801 * t10457) - 0.36e2 * t12764 * t1242 + 0.24e2 * t3741 * t4329 + 0.12e2 * t12775 * t1242 - 0.24e2 * t11772 * t1338 - 0.24e2 * t11778 * t1338 - 0.24e2 * t3732 * t4329 - 0.12e2 * t12755 * t1242 - 0.12e2 * t1238 * t11284 * t3916 + 0.12e2 * t6636 * t1425 * t121 * t4337 - 0.6e1 * t2923 * t1442 * t121 * t4337 - 0.12e2 * t373 * t11284 * t12869 + 0.24e2 * t373 * t4332 * t12876;
  t14370 = 0.3e1 / 0.2e1 * t2923 * t3916 * t3296 + 0.12e2 * t3320 * t4460 + 0.12e2 * t955 * t4473 * t120 * t1320 + 0.12e2 * t8409 * t4478 - 0.6e1 * t3323 * t4491 - 0.6e1 * t960 * t4510 * t120 * t1320 + 0.6e1 * t1238 * t4332 * t1421 - 0.3e1 / 0.4e1 * t2541 * t1425 * t768 * t124 - 0.24e2 * t3597 * t3593 * t1354 + 0.3e1 / 0.8e1 * t960 * t1442 * t768 * t124 + 0.12e2 * t373 * t13951 * t1406 - 0.24e2 * t2923 * t3589 * t1333 - 0.36e2 * t6624 * t3916 * t1252 + 0.3e1 * t955 * t420 * t2952 * t132 + 0.24e2 * t8409 * t4447 + 0.24e2 * t2541 * t12889 * t381 + 0.24e2 * t2541 * t12896 * t381;
  t14395 = t1333 * t1333;
  t14399 = t1354 * t1354;
  t14424 = 0.12e2 * t2541 * t3916 * t1264 - 0.3e1 / 0.2e1 * t960 * t3648 * t433 - 0.3e1 / 0.4e1 * t955 * t1421 * t768 * t124 + 0.48e2 * t9625 * t1337 * t1320 * t381 + 0.6e1 * t290 * t386 * t4473 + 0.6e1 * t737 * t1269 * t1406 + 0.3e1 * t290 * t1269 * t1421 + 0.12e2 * t737 * t151 * t14395 + 0.4e1 * t780 * t151 * t14399 - 0.12e2 * t742 * t4260 * t433 - 0.12e2 * t742 * t1327 * t1354 - 0.12e2 * t742 * t1334 * t1354 - 0.12e2 * t2104 * t4439 * t381 - 0.6e1 * t2104 * t1407 * t1264 + 0.24e2 * t737 * t1327 * t1333 - 0.6e1 * t742 * t4257 * t433;
  t14476 = 0.4e1 * t780 * t4497 * t381 + 0.4e1 * t780 * t4511 * t381 + 0.2e1 * t780 * t1443 * t1264 - 0.3e1 / 0.4e1 * t3296 * t4433 + 0.4e1 * t780 * t434 * t4276 - 0.12e2 * t2096 * t4484 * t381 - 0.6e1 * t2096 * t1426 * t1264 + 0.8e1 * t780 * t1344 * t1354 - 0.6e1 * t742 * t4467 * t381 - 0.6e1 * t742 * t4474 * t381 - 0.3e1 * t742 * t1422 * t1264 - 0.9e1 / 0.4e1 * t290 * t151 * t10456 * t311 - 0.6e1 * t742 * t421 * t4276 + 0.12e2 * t5604 * t1407 * t1252 - 0.6e1 * t2096 * t1443 * t1252 + 0.24e2 * t5755 * t1426 * t1252 + 0.6e1 * t2120 * t1422 * t1252;
  t14482 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t14317 + t14370 + t14424 + t14476));
  tv4sigma2tau217 = t7 * t14482;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t14514 = 0.6e1 * t857 * t4545 * t52 * t1277 - 0.18e2 * t5907 * t4549 * t52 * t1277 - 0.3e1 * t862 * t4572 * t52 * t1277 - 0.18e2 * t349 * t10935 * t13054 + 0.18e2 * t349 * t4242 * t13022 + 0.36e2 * t6303 * t13054 * t357 - 0.18e2 * t12287 * t1295 - 0.18e2 * t3545 * t4405 + 0.18e2 * t3554 * t4405 + 0.6e1 * t4520 * t362 + 0.36e2 * t9234 * t4392;
  t14542 = t4819 * t13060;
  t14560 = -0.36e2 * t2694 * t3772 * t1290 - 0.18e2 * t2694 * t13022 * t357 - 0.54e2 * t5907 * t13026 * t357 + 0.36e2 * t2253 * t3772 * t1311 + 0.18e2 * t2253 * t13036 * t357 + 0.18e2 * t2253 * t13043 * t357 - 0.18e2 * t3419 * t13015 * t357 - 0.6e1 * t1629 * t362 * t4549 - t206 * t362 * t4572 - t206 * t86 * (-0.288e4 * t4880 * t75 * t13060 + 0.18e3 * t4813 * t13060 + 0.1728e5 * t1551 * t13086 - 0.3024e5 * t562 * t13094 + 0.16128e5 * t214 * t13102 + 0.54e2 * t13061 - 0.216e3 * t14542) + 0.18e2 * t13120 * t1291;
  t14597 = -0.6e1 * t13123 * t358 + 0.3e1 * t188 * t362 * t4545 + 0.3e1 * t188 * t86 * (0.18e2 * t13061 - 0.24e2 * t14542) + 0.2e1 * t541 * t4573 * t357 + 0.6e1 * t541 * t1301 * t1398 + 0.6e1 * t541 * t1312 * t1398 + 0.6e1 * t541 * t410 * t4424 - 0.9e1 * t503 * t397 * t4424 - 0.3e1 * t503 * t4546 * t357 + 0.24e2 * t4972 * t4550 * t357 - 0.18e2 * t1629 * t1382 * t1311;
  t14634 = 0.18e2 * t498 * t1284 * t1377 + 0.18e2 * t1685 * t1284 * t1381 - 0.9e1 * t503 * t1284 * t1398 + 0.18e2 * t498 * t1291 * t1377 + 0.18e2 * t1685 * t1291 * t1381 - 0.9e1 * t503 * t1291 * t1398 - 0.18e2 * t1650 * t1363 * t1311 - 0.9e1 * t503 * t1378 * t1311 - 0.18e2 * t1650 * t4353 * t409 + 0.18e2 * t498 * t397 * t4387 - 0.9e1 * t503 * t4381 * t409 - 0.9e1 * t503 * t4388 * t409;
  t14640 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t14514 + t14560 + t14597 + t14634));
  tv4sigmatau30 = t7 * t14640;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t14673 = 0.6e1 * t955 * t4606 * t120 * t1320 - 0.18e2 * t6624 * t4610 * t120 * t1320 - 0.3e1 * t960 * t4633 * t120 * t1320 - 0.18e2 * t373 * t11284 * t13335 + 0.18e2 * t373 * t4332 * t13342 - 0.54e2 * t6624 * t13346 * t381 + 0.36e2 * t2541 * t3916 * t1354 - 0.18e2 * t12755 * t1338 - 0.18e2 * t3732 * t4491 + 0.18e2 * t3741 * t4491 + 0.36e2 * t9625 * t4478;
  t14696 = t5697 * t13251;
  t14723 = 0.18e2 * t2541 * t13357 * t381 + 0.18e2 * t2541 * t13364 * t381 - 0.18e2 * t3597 * t13371 * t381 + 0.36e2 * t6636 * t13335 * t381 - 0.36e2 * t2923 * t3916 * t1333 - 0.18e2 * t2923 * t13342 * t381 + 0.3e1 * t290 * t386 * t4606 + 0.3e1 * t290 * t151 * (0.18e2 * t13252 - 0.24e2 * t14696) - 0.6e1 * t2096 * t386 * t4610 - t308 * t386 * t4633 - t308 * t151 * (-0.288e4 * t5716 * t140 * t13251 + 0.18e3 * t5681 * t13251 + 0.1728e5 * t2034 * t13277 - 0.3024e5 * t801 * t13285 + 0.16128e5 * t316 * t13293 + 0.54e2 * t13252 - 0.216e3 * t14696);
  t14756 = 0.18e2 * t737 * t1327 * t1421 + 0.6e1 * t780 * t1344 * t1442 - 0.18e2 * t2104 * t1407 * t1354 - 0.18e2 * t2096 * t1426 * t1354 + 0.6e1 * t780 * t1355 * t1442 - 0.18e2 * t2104 * t4439 * t433 + 0.24e2 * t5755 * t4611 * t381 + 0.2e1 * t780 * t4634 * t381 + 0.6e1 * t780 * t434 * t4510 + 0.18e2 * t13311 * t1334 - 0.6e1 * t13314 * t382;
  t14792 = 0.18e2 * t2120 * t1327 * t1425 - 0.9e1 * t742 * t1327 * t1442 + 0.18e2 * t737 * t1334 * t1421 + 0.18e2 * t2120 * t1334 * t1425 - 0.9e1 * t742 * t1334 * t1442 - 0.9e1 * t742 * t1422 * t1354 - 0.3e1 * t742 * t4607 * t381 + 0.18e2 * t737 * t421 * t4473 - 0.9e1 * t742 * t421 * t4510 - 0.9e1 * t742 * t4467 * t433 - 0.9e1 * t742 * t4474 * t433 + 0.6e1 * t4581 * t386;
  t14798 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t14673 + t14723 + t14756 + t14792));
  tv4sigmatau311 = t7 * t14798;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t14808 = t1381 * t1381;
  t14815 = t1398 * t1398;
  t14825 = t1377 * t1377;
  t14847 = t4685 * t209;
  t14849 = t4819 * t4685;
  t14851 = t4813 * t4685;
  t14884 = -0.12e2 * t503 * t4546 * t409 - 0.18e2 * t503 * t1378 * t1398 - 0.12e2 * t503 * t397 * t4572 + 0.24e2 * t4972 * t86 * t14808 - 0.36e2 * t1629 * t1382 * t1398 + 0.6e1 * t541 * t86 * t14815 + 0.8e1 * t541 * t410 * t4572 - 0.36e2 * t1650 * t1363 * t1398 + 0.18e2 * t498 * t86 * t14825 + 0.24e2 * t498 * t397 * t4545 + 0.36e2 * t1685 * t1378 * t1381 + 0.72e2 * t4710 * t1363 * t1381 - 0.72e2 * t2694 * t3772 * t1377 - 0.72e2 * t4754 * t397 * t4549 + 0.72e2 * t2253 * t3772 * t1398 - t206 * t86 * (-0.18432e6 * t1551 * t219 * t4685 - 0.516096e6 * t214 * t1560 * t4685 + 0.193536e6 * t72 * t4848 * t4685 + 0.2304e5 * t4880 * t75 * t4685 + 0.48384e6 * t562 * t573 * t4685 + 0.288e4 * t4868 * t4685 - 0.576e3 * t14847 + 0.3456e4 * t14849 - 0.576e4 * t14851) + 0.36e2 * t13120 * t1378 - 0.24e2 * t13123 * t410 + 0.3e1 * t188 * t86 * (-0.288e3 * t14847 + 0.768e3 * t14849 - 0.48e3 * t14851);
  t14888 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t14884);
  tv4tau40 = t7 * t14888;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t14889 = t1442 * t1442;
  t14899 = t1421 * t1421;
  t14918 = t1425 * t1425;
  t14941 = t5516 * t311;
  t14943 = t5697 * t5516;
  t14945 = t5681 * t5516;
  t14974 = 0.6e1 * t780 * t151 * t14889 + 0.8e1 * t780 * t434 * t4633 - 0.36e2 * t2104 * t1407 * t1442 + 0.18e2 * t737 * t151 * t14899 + 0.24e2 * t737 * t421 * t4606 + 0.36e2 * t2120 * t1422 * t1425 - 0.12e2 * t742 * t4607 * t433 - 0.18e2 * t742 * t1422 * t1442 - 0.12e2 * t742 * t421 * t4633 + 0.24e2 * t5755 * t151 * t14918 - 0.36e2 * t2096 * t1426 * t1442 + 0.72e2 * t5604 * t1407 * t1425 - 0.72e2 * t2923 * t3916 * t1421 - 0.72e2 * t5600 * t421 * t4610 + 0.72e2 * t2541 * t3916 * t1442 + 0.36e2 * t13311 * t1422 - 0.24e2 * t13314 * t434 + 0.3e1 * t290 * t151 * (-0.288e3 * t14941 + 0.768e3 * t14943 - 0.48e3 * t14945) - t308 * t151 * (0.193536e6 * t137 * t5689 * t5516 + 0.2304e5 * t5716 * t140 * t5516 - 0.516096e6 * t316 * t2012 * t5516 - 0.18432e6 * t2034 * t321 * t5516 + 0.48384e6 * t801 * t812 * t5516 + 0.288e4 * t5735 * t5516 - 0.576e3 * t14941 + 0.3456e4 * t14943 - 0.576e4 * t14945);
  t14978 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t14974);
  tv4tau44 = t7 * t14978;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

