/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_jk.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  double t434, t444, t445, t449, t450, t451, t452, t453;
  double t454, t457, t458, t462, t463, t464, t465, t466;
  double t467, t470, t471, t475, t476, t480, t481, t485;
  double t489, t492, t496, t500, t505, t506, t512, t515;
  double t516, t517, t525, t528, t531, t534, t538, t540;
  double t543, t544, t547, t549, t554, t555, t557, t559;
  double t563, t564, t565, t568, t573, tv3rho30, t586, t587;
  double t591, t595, t596, t600, t604, t605, t609, t610;
  double t614, t618, t619, t623, t630, t634, t635, t639;
  double t643, t644, t648, t652, t671, t672, t673, t674;
  double t675, t676, t679, t680, t681, t682, t683, t686;
  double t689, t692, t703, t705, t709, t710, t711, t714;
  double t717, t723, t724, t725, t729, t733, t734, t739;
  double tv3rho2sigma0, t743, t748, t753, t755, t757, t759, t763;
  double t767, t771, t774, tv3rho2lapl0, tv3rho2tau0, t783, t784, t788;
  double t789, t793, t794, t798, t799, t803, t807, t808;
  double t812, t813, t817, t818, t822, t823, t827, t831;
  double t835, t841, t848, t849, t850, t853, t854, t857;
  double t862, t863, t864, t873, t876, t879, t882, t896;
  double t899, t901, t905, t906, t907, t910, t911, t916;
  double tv3rhosigma20, t921, t923, t926, t929, t935, t937, t939;
  double t943, t946, tv3rhosigmalapl0, tv3rhosigmatau0, t951, t953, t956, t958;
  double t962, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t965, t966, t967, t970;
  double t974, t975, t976, t979, t983, t987, t991, t1003;
  double t1006, t1011, t1015, t1016, t1017, t1021, t1022, t1023;
  double t1026, t1027, t1028, t1036, t1040, t1044, tv3sigma30, t1047;
  double t1050, t1054, t1058, t1062, t1065, tv3sigma2lapl0, tv3sigma2tau0, t1068;
  double t1072, t1076, t1080, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t1084, t1086;
  double t1089, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t434 = t18 * t35;
  t444 = t235 * t103;
  t445 = t444 * t237;
  t449 = t108 * t108;
  t450 = 0.1e1 / t449;
  t451 = t48 * t450;
  t452 = t237 * t121;
  t453 = t451 * t452;
  t454 = t86 * t453;
  t457 = t235 * t121;
  t458 = t457 * t254;
  t462 = t87 * t87;
  t463 = 0.1e1 / t462;
  t464 = t463 * t61;
  t465 = t198 * t103;
  t466 = t464 * t465;
  t467 = t86 * t466;
  t470 = t109 * t198;
  t471 = t470 * t121;
  t475 = t61 * t103;
  t476 = t475 * t229;
  t480 = t109 * t229;
  t481 = t480 * t121;
  t485 = t204 * t254;
  t489 = t96 * t199;
  t492 = t96 * t88;
  t496 = t96 * t238;
  t500 = 0.1e1 / t33 / t379;
  t505 = -0.1232e4 / 0.27e2 * t31 * t500 + 0.44e3 / 0.27e2 * t51 * t183;
  t506 = t505 * t56;
  t512 = t29 * t423;
  t515 = t506 * t58 + 0.8e1 * t247 * t118 + 0.4e2 / 0.3e1 * t116 * t251 + 0.8e2 / 0.27e2 * t57 * t512;
  t516 = t110 * t515;
  t517 = t86 * t516;
  t525 = t215 * t104;
  t528 = t215 * t122;
  t531 = t96 * t230;
  t534 = t96 * t255;
  t538 = 0.1e1 / t19 / t181;
  t540 = t29 * t538 * t44;
  t543 = t30 * t500;
  t544 = t543 * t99;
  t547 = t181 * t181;
  t549 = 0.1e1 / t19 / t547;
  t554 = t547 * t76;
  t555 = 0.1e1 / t554;
  t557 = t97 * t97;
  t559 = 0.1e1 / t98 / t557;
  t563 = -0.28e3 / 0.27e2 * t38 * t540 - 0.952e3 / 0.27e2 * t95 * t544 + 0.1184e4 / 0.27e2 * t219 * t29 * t549 * t225 - 0.256e3 / 0.9e1 * t36 * t397 * t555 * t559;
  t564 = t89 * t563;
  t565 = t86 * t564;
  t568 = -0.4e1 / 0.3e1 * t85 * t203 * t445 - 0.4e1 / 0.3e1 * t85 * t454 + 0.4e1 / 0.3e1 * t85 * t316 * t458 - 0.4e1 / 0.3e1 * t85 * t467 - 0.4e1 / 0.3e1 * t85 * t280 * t471 + 0.4e1 / 0.3e1 * t85 * t280 * t476 + 0.2e1 / 0.3e1 * t85 * t203 * t481 + 0.2e1 / 0.3e1 * t85 * t203 * t485 - 0.32e2 / 0.9e1 * t85 * t489 - 0.32e2 / 0.9e1 * t85 * t492 * t205 - 0.32e2 / 0.9e1 * t85 * t496 - 0.2e1 / 0.9e1 * t85 * t517 - 0.2464e4 / 0.243e3 * t28 * t31 * t500 * t48 * t61 - 0.176e3 / 0.27e2 * t85 * t525 - 0.176e3 / 0.27e2 * t85 * t528 + 0.16e2 / 0.9e1 * t85 * t531 + 0.16e2 / 0.9e1 * t85 * t534 - 0.2e1 / 0.9e1 * t85 * t565;
  t573 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t66 + t7 * t174 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t259 - 0.3e1 / 0.8e1 * t7 * t20 * t568);
  tv3rho30 = 0.2e1 * rho[0] * t573 + 0.6e1 * t264;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t586 = t61 * t303;
  t587 = t586 * t103;
  t591 = t281 * t229;
  t595 = t109 * t303;
  t596 = t595 * t121;
  t600 = t286 * t254;
  t604 = t450 * t152;
  t605 = t604 * t237;
  t609 = t235 * t143;
  t610 = t609 * t237;
  t614 = t311 * t198;
  t618 = t86 * t463;
  t619 = t281 * t198;
  t623 = t317 * t254;
  t630 = t96 * t48;
  t634 = t109 * t326;
  t635 = t634 * t103;
  t639 = t311 * t229;
  t643 = t235 * t326;
  t644 = t643 * t121;
  t648 = t96 * t196;
  t652 = 0.176e3 / 0.81e2 * t28 * t215 * t134 + 0.8e1 / 0.9e1 * t85 * t280 * t587 + 0.4e1 / 0.9e1 * t85 * t280 * t591 + 0.4e1 / 0.9e1 * t85 * t203 * t596 + 0.2e1 / 0.9e1 * t85 * t203 * t600 - 0.4e1 / 0.3e1 * t85 * t316 * t605 - 0.4e1 / 0.9e1 * t85 * t203 * t610 - 0.4e1 / 0.9e1 * t85 * t280 * t614 - 0.4e1 / 0.3e1 * t85 * t618 * t619 + 0.4e1 / 0.9e1 * t85 * t316 * t623 - 0.32e2 / 0.27e2 * t85 * t492 * t312 - 0.64e2 / 0.27e2 * t85 * t630 * t318 + 0.4e1 / 0.9e1 * t85 * t203 * t635 + 0.2e1 / 0.9e1 * t85 * t203 * t639 + 0.8e1 / 0.9e1 * t85 * t316 * t644 - 0.64e2 / 0.27e2 * t85 * t648 * t282;
  t671 = t22 * t25 * t26 * sigma[0] * t30;
  t672 = t35 * t88;
  t673 = t672 * t235;
  t674 = t152 * t103;
  t675 = t674 * t121;
  t676 = t673 * t675;
  t679 = t35 * t196;
  t680 = t679 * t109;
  t681 = t143 * t103;
  t682 = t681 * t121;
  t683 = t680 * t682;
  t686 = t96 * t304;
  t689 = t215 * t153;
  t692 = t215 * t144;
  t703 = t547 * t32;
  t705 = 0.1e1 / t703 * t559;
  t709 = 0.14e2 / 0.9e1 * t138 * t212 + 0.74e2 / 0.9e1 * t36 * t216 - 0.124e3 / 0.9e1 * t295 * t222 * t225 * sigma[0] + 0.32e2 / 0.3e1 * t36 * t705 * t148;
  t710 = t89 * t709;
  t711 = t86 * t710;
  t714 = t96 * t327;
  t717 = t246 * t149;
  t723 = -t717 * t58 - 0.16e2 / 0.3e1 * t322 * t118 - 0.4e2 / 0.9e1 * t150 * t251;
  t724 = t110 * t723;
  t725 = t86 * t724;
  t729 = t22 * t27 * t30;
  t733 = -0.32e2 / 0.27e2 * t85 * t492 * t287 - 0.2e1 / 0.9e1 * t28 * t231 - 0.2e1 / 0.9e1 * t28 * t256 + 0.32e2 / 0.27e2 * t28 * t189 + 0.32e2 / 0.27e2 * t28 * t192 + 0.4e1 / 0.9e1 * t28 * t200 + 0.4e1 / 0.9e1 * t28 * t239 - 0.8e1 / 0.9e1 * t671 * t676 - 0.8e1 / 0.9e1 * t671 * t683 + 0.32e2 / 0.27e2 * t85 * t686 - 0.176e3 / 0.81e2 * t85 * t689 - 0.176e3 / 0.81e2 * t85 * t692 - 0.2e1 / 0.9e1 * t85 * t711 + 0.32e2 / 0.27e2 * t85 * t714 - 0.2e1 / 0.9e1 * t85 * t725 + 0.4e1 / 0.9e1 * t729 * t672 * t205;
  t734 = t652 + t733;
  t739 = my_piecewise3(t3, 0, t7 * t174 * t157 / 0.12e2 - t7 * t72 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t734);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t739 + 0.4e1 * t336;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t743 = t210 * params->beta;
  t748 = t163 * t339 * t25;
  t753 = t196 * t109;
  t755 = t345 * t753 * t198;
  t757 = t345 * t88;
  t759 = t757 * t444 * t121;
  t763 = t345 * t346 * t229;
  t767 = t345 * t451 * t237;
  t771 = t345 * t236 * t254;
  t774 = my_piecewise3(t3, 0, -0.14e2 / 0.9e1 * t163 * t743 * t168 - 0.4e1 / 0.3e1 * t748 * t348 - 0.8e1 / 0.3e1 * t748 * t352 - t344 * t755 - 0.2e1 * t344 * t759 + t344 * t763 / 0.2e1 - 0.3e1 * t344 * t767 + t344 * t771);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t774 + 0.4e1 * t355;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t783 = t61 * t386;
  t784 = t783 * t103;
  t788 = t109 * t386;
  t789 = t788 * t121;
  t793 = t235 * t391;
  t794 = t793 * t103;
  t798 = t450 * t391;
  t799 = t798 * t121;
  t803 = t317 * t326;
  t807 = t109 * t402;
  t808 = t807 * t103;
  t812 = t235 * t402;
  t813 = t812 * t121;
  t817 = t61 * t362;
  t818 = t817 * t103;
  t822 = t109 * t362;
  t823 = t822 * t121;
  t827 = t281 * t303;
  t831 = t595 * t152;
  t835 = t286 * t326;
  t841 = -0.32e2 / 0.27e2 * t85 * t492 * t367 + 0.4e1 / 0.9e1 * t85 * t280 * t784 + 0.2e1 / 0.9e1 * t85 * t203 * t789 - 0.4e1 / 0.9e1 * t85 * t203 * t794 - 0.4e1 / 0.3e1 * t85 * t316 * t799 + 0.8e1 / 0.9e1 * t85 * t316 * t803 + 0.2e1 / 0.9e1 * t85 * t203 * t808 + 0.4e1 / 0.9e1 * t85 * t316 * t813 - 0.4e1 / 0.3e1 * t85 * t618 * t818 - 0.4e1 / 0.9e1 * t85 * t280 * t823 + 0.8e1 / 0.9e1 * t85 * t280 * t827 + 0.4e1 / 0.9e1 * t85 * t203 * t831 + 0.4e1 / 0.9e1 * t85 * t203 * t835 + 0.32e2 / 0.27e2 * t28 * t308;
  t848 = t143 * t152;
  t849 = t848 * t103;
  t850 = t680 * t849;
  t853 = t848 * t121;
  t854 = t673 * t853;
  t857 = t115 * t398;
  t862 = 0.2e1 * t857 * t58 + 0.16e2 / 0.3e1 * t399 * t118;
  t863 = t110 * t862;
  t864 = t86 * t863;
  t873 = t96 * t387;
  t876 = t96 * t392;
  t879 = t96 * t403;
  t882 = t96 * t363;
  t896 = t29 * t298 * t225;
  t899 = t547 * rho[0];
  t901 = 0.1e1 / t899 * t559;
  t905 = t373 * t93 / 0.3e1 - t376 * t100 / 0.3e1 + 0.1e2 / 0.3e1 * t36 * t896 - 0.4e1 * t36 * t901 * sigma[0];
  t906 = t89 * t905;
  t907 = t86 * t906;
  t910 = 0.32e2 / 0.27e2 * t28 * t277 - 0.4e1 / 0.9e1 * t28 * t328 - 0.4e1 / 0.9e1 * t28 * t305 - 0.8e1 / 0.9e1 * t671 * t850 - 0.8e1 / 0.9e1 * t671 * t854 - 0.2e1 / 0.9e1 * t85 * t864 + 0.8e1 / 0.9e1 * t729 * t679 * t282 + 0.4e1 / 0.9e1 * t729 * t672 * t287 + 0.16e2 / 0.27e2 * t85 * t873 - 0.32e2 / 0.27e2 * t85 * t876 + 0.16e2 / 0.27e2 * t85 * t879 - 0.32e2 / 0.27e2 * t85 * t882 + 0.4e1 / 0.9e1 * t729 * t672 * t312 + 0.8e1 / 0.9e1 * t729 * t49 * t318 - 0.2e1 / 0.9e1 * t85 * t907;
  t911 = t841 + t910;
  t916 = my_piecewise3(t3, 0, -t7 * t72 * t407 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t911);
  tv3rhosigma20 = 0.2e1 * rho[0] * t916 + 0.2e1 * t411;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t921 = t345 * t196;
  t923 = t921 * t286 * t103;
  t926 = t757 * t609 * t121;
  t929 = t345 * t346 * t303;
  t935 = t757 * t317 * t103;
  t937 = t345 * t48;
  t939 = t937 * t604 * t121;
  t943 = t345 * t236 * t326;
  t946 = my_piecewise3(t3, 0, -0.2e1 / 0.3e1 * t748 * t414 - t344 * t923 - t344 * t926 + t344 * t929 / 0.2e1 - 0.4e1 / 0.3e1 * t748 * t418 - t344 * t935 - 0.3e1 * t344 * t939 + t344 * t943);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t946 + 0.2e1 * t421;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t951 = t235 * t56;
  t953 = t757 * t951 * t103;
  t956 = t450 * t56;
  t958 = t937 * t956 * t121;
  t962 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t344 * t428 + 0.2e1 * t426 * t953 + 0.6e1 * t426 * t958);
  tv3rholapl20 = 0.2e1 * rho[0] * t962 + 0.2e1 * t431;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t965 = t391 * t152;
  t966 = t451 * t965;
  t967 = t86 * t966;
  t970 = t317 * t402;
  t974 = t362 * t143;
  t975 = t464 * t974;
  t976 = t86 * t975;
  t979 = t822 * t152;
  t983 = t281 * t386;
  t987 = t788 * t152;
  t991 = t286 * t402;
  t1003 = t36 / t37 / t148;
  t1006 = t36 * t149;
  t1011 = 0.1e1 / t547;
  t1015 = 0.3e1 / 0.8e1 * t1003 * t45 - 0.3e1 / 0.8e1 * t1006 * t140 - t376 * t383 / 0.4e1 + 0.3e1 / 0.2e1 * t36 * t1011 * t559;
  t1016 = t89 * t1015;
  t1017 = t86 * t1016;
  t1021 = t148 * t148;
  t1022 = 0.1e1 / t1021;
  t1023 = t55 * t1022;
  t1026 = -0.6e1 * t1023 * t58 + 0.12e2 * t398;
  t1027 = t110 * t1026;
  t1028 = t86 * t1027;
  t1036 = t609 * t391;
  t1040 = -0.4e1 / 0.3e1 * t85 * t967 + 0.4e1 / 0.3e1 * t85 * t316 * t970 - 0.4e1 / 0.3e1 * t85 * t976 - 0.4e1 / 0.3e1 * t85 * t280 * t979 + 0.4e1 / 0.3e1 * t85 * t280 * t983 + 0.2e1 / 0.3e1 * t85 * t203 * t987 + 0.2e1 / 0.3e1 * t85 * t203 * t991 - 0.2e1 / 0.3e1 * t28 * t388 - 0.2e1 / 0.3e1 * t28 * t404 + 0.4e1 / 0.3e1 * t28 * t393 - 0.2e1 / 0.9e1 * t85 * t1017 - 0.2e1 / 0.9e1 * t85 * t1028 + 0.4e1 / 0.3e1 * t28 * t364 + 0.4e1 / 0.3e1 * t729 * t672 * t367 - 0.4e1 / 0.3e1 * t85 * t203 * t1036;
  t1044 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1040);
  tv3sigma30 = 0.2e1 * rho[0] * t1044;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1047 = t345 * t753 * t362;
  t1050 = t757 * t609 * t152;
  t1054 = t345 * t346 * t386;
  t1058 = t345 * t451 * t391;
  t1062 = t345 * t236 * t402;
  t1065 = my_piecewise3(t3, 0, -t344 * t1047 - 0.2e1 * t344 * t1050 + t344 * t1054 / 0.2e1 - 0.3e1 * t344 * t1058 + t344 * t1062);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1065;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1068 = t757 * t951 * t143;
  t1072 = t937 * t956 * t152;
  t1076 = t345 * t236 * t149;
  t1080 = my_piecewise3(t3, 0, 0.2e1 * t426 * t1068 + 0.6e1 * t426 * t1072 + 0.2e1 * t426 * t1076);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1080;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1084 = t163 * t33 * params->beta * t25;
  t1086 = t345 * t451 * t149;
  t1089 = my_piecewise3(t3, 0, -0.12e2 * t1084 * t1086);
  tv3lapl30 = 0.2e1 * rho[0] * t1089;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  double t434, t444, t445, t449, t450, t451, t452, t453;
  double t454, t457, t458, t462, t463, t464, t465, t466;
  double t467, t470, t471, t475, t476, t480, t481, t485;
  double t489, t492, t496, t500, t505, t506, t512, t515;
  double t516, t517, t525, t528, t531, t534, t538, t540;
  double t543, t544, t547, t549, t554, t555, t557, t559;
  double t563, t564, t565, t568, t573, tv3rho30, t586, t587;
  double t591, t595, t596, t600, t604, t605, t609, t610;
  double t614, t618, t619, t623, t630, t634, t635, t639;
  double t643, t644, t648, t652, t671, t672, t673, t674;
  double t675, t676, t679, t680, t681, t682, t683, t686;
  double t689, t692, t703, t705, t709, t710, t711, t714;
  double t717, t723, t724, t725, t729, t733, t734, t739;
  double tv3rho2sigma0, t743, t748, t753, t755, t757, t759, t763;
  double t767, t771, t774, tv3rho2lapl0, tv3rho2tau0, t783, t784, t788;
  double t789, t793, t794, t798, t799, t803, t807, t808;
  double t812, t813, t817, t818, t822, t823, t827, t831;
  double t835, t841, t848, t849, t850, t853, t854, t857;
  double t862, t863, t864, t873, t876, t879, t882, t896;
  double t899, t901, t905, t906, t907, t910, t911, t916;
  double tv3rhosigma20, t921, t923, t926, t929, t935, t937, t939;
  double t943, t946, tv3rhosigmalapl0, tv3rhosigmatau0, t951, t953, t956, t958;
  double t962, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t965, t966, t967, t970;
  double t974, t975, t976, t979, t983, t987, t991, t1003;
  double t1006, t1011, t1015, t1016, t1017, t1021, t1022, t1023;
  double t1026, t1027, t1028, t1036, t1040, t1044, tv3sigma30, t1047;
  double t1050, t1054, t1058, t1062, t1065, tv3sigma2lapl0, tv3sigma2tau0, t1068;
  double t1072, t1076, t1080, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t1084, t1086;
  double t1089, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  double t1105, t1127, t1151, t1173, t1182, t1183, t1196, t1197;
  double t1198, t1203, t1212, t1213, t1214, t1223, t1234, t1246;
  double t1300, t1310, t1316, tv4rho40, t1350, t1355, t1383, t1387;
  double t1395, t1403, t1404, t1428, t1482, t1488, t1489, t1494;
  double t1495, t1514, t1524, t1525, t1529, t1535, t1540, t1541;
  double t1550, t1565, t1653, t1660, tv4rho3sigma0, t1687, t1714, t1725;
  double t1726, tv4rho3lapl0, tv4rho3tau0, t1740, t1749, t1754, t1763, t1782;
  double t1815, t1823, t1865, t1903, t1912, t1915, t1946, t1965;
  double t1970, t1987, t2049, t2099, t2107, tv4rho2sigma20, t2113, t2114;
  double t2116, t2124, t2130, t2157, t2195, t2197, tv4rho2sigmalapl0, tv4rho2sigmatau0;
  double t2212, t2222, t2232, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, t2251, t2274;
  double t2287, t2296, t2297, t2306, t2319, t2328, t2342, t2367;
  double t2431, t2485, t2507, t2514, tv4rhosigma30, t2586, t2588, tv4rhosigma2lapl0;
  double tv4rhosigma2tau0, t2593, t2608, t2624, t2629, t2634, t2635, tv4rhosigmalapl20;
  double tv4rhosigmalapltau0, tv4rhosigmatau20, t2644, t2650, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30;
  double t2653, t2700, t2708, t2716, t2739, t2792, t2797, tv4sigma40;
  double t2839, tv4sigma3lapl0, tv4sigma3tau0, t2874, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, t2889;
  double tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t2898, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20;
  double tv4lapltau30, tv4tau40;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t434 = t18 * t35;
  t444 = t235 * t103;
  t445 = t444 * t237;
  t449 = t108 * t108;
  t450 = 0.1e1 / t449;
  t451 = t48 * t450;
  t452 = t237 * t121;
  t453 = t451 * t452;
  t454 = t86 * t453;
  t457 = t235 * t121;
  t458 = t457 * t254;
  t462 = t87 * t87;
  t463 = 0.1e1 / t462;
  t464 = t463 * t61;
  t465 = t198 * t103;
  t466 = t464 * t465;
  t467 = t86 * t466;
  t470 = t109 * t198;
  t471 = t470 * t121;
  t475 = t61 * t103;
  t476 = t475 * t229;
  t480 = t109 * t229;
  t481 = t480 * t121;
  t485 = t204 * t254;
  t489 = t96 * t199;
  t492 = t96 * t88;
  t496 = t96 * t238;
  t500 = 0.1e1 / t33 / t379;
  t505 = -0.1232e4 / 0.27e2 * t31 * t500 + 0.44e3 / 0.27e2 * t51 * t183;
  t506 = t505 * t56;
  t512 = t29 * t423;
  t515 = t506 * t58 + 0.8e1 * t247 * t118 + 0.4e2 / 0.3e1 * t116 * t251 + 0.8e2 / 0.27e2 * t57 * t512;
  t516 = t110 * t515;
  t517 = t86 * t516;
  t525 = t215 * t104;
  t528 = t215 * t122;
  t531 = t96 * t230;
  t534 = t96 * t255;
  t538 = 0.1e1 / t19 / t181;
  t540 = t29 * t538 * t44;
  t543 = t30 * t500;
  t544 = t543 * t99;
  t547 = t181 * t181;
  t549 = 0.1e1 / t19 / t547;
  t554 = t547 * t76;
  t555 = 0.1e1 / t554;
  t557 = t97 * t97;
  t559 = 0.1e1 / t98 / t557;
  t563 = -0.28e3 / 0.27e2 * t38 * t540 - 0.952e3 / 0.27e2 * t95 * t544 + 0.1184e4 / 0.27e2 * t219 * t29 * t549 * t225 - 0.256e3 / 0.9e1 * t36 * t397 * t555 * t559;
  t564 = t89 * t563;
  t565 = t86 * t564;
  t568 = -0.4e1 / 0.3e1 * t85 * t203 * t445 - 0.4e1 / 0.3e1 * t85 * t454 + 0.4e1 / 0.3e1 * t85 * t316 * t458 - 0.4e1 / 0.3e1 * t85 * t467 - 0.4e1 / 0.3e1 * t85 * t280 * t471 + 0.4e1 / 0.3e1 * t85 * t280 * t476 + 0.2e1 / 0.3e1 * t85 * t203 * t481 + 0.2e1 / 0.3e1 * t85 * t203 * t485 - 0.32e2 / 0.9e1 * t85 * t489 - 0.32e2 / 0.9e1 * t85 * t492 * t205 - 0.32e2 / 0.9e1 * t85 * t496 - 0.2e1 / 0.9e1 * t85 * t517 - 0.2464e4 / 0.243e3 * t28 * t31 * t500 * t48 * t61 - 0.176e3 / 0.27e2 * t85 * t525 - 0.176e3 / 0.27e2 * t85 * t528 + 0.16e2 / 0.9e1 * t85 * t531 + 0.16e2 / 0.9e1 * t85 * t534 - 0.2e1 / 0.9e1 * t85 * t565;
  t573 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t66 + t7 * t174 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t259 - 0.3e1 / 0.8e1 * t7 * t20 * t568);
  tv3rho30 = 0.2e1 * rho[0] * t573 + 0.6e1 * t264;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t586 = t61 * t303;
  t587 = t586 * t103;
  t591 = t281 * t229;
  t595 = t109 * t303;
  t596 = t595 * t121;
  t600 = t286 * t254;
  t604 = t450 * t152;
  t605 = t604 * t237;
  t609 = t235 * t143;
  t610 = t609 * t237;
  t614 = t311 * t198;
  t618 = t86 * t463;
  t619 = t281 * t198;
  t623 = t317 * t254;
  t630 = t96 * t48;
  t634 = t109 * t326;
  t635 = t634 * t103;
  t639 = t311 * t229;
  t643 = t235 * t326;
  t644 = t643 * t121;
  t648 = t96 * t196;
  t652 = 0.176e3 / 0.81e2 * t28 * t215 * t134 + 0.8e1 / 0.9e1 * t85 * t280 * t587 + 0.4e1 / 0.9e1 * t85 * t280 * t591 + 0.4e1 / 0.9e1 * t85 * t203 * t596 + 0.2e1 / 0.9e1 * t85 * t203 * t600 - 0.4e1 / 0.3e1 * t85 * t316 * t605 - 0.4e1 / 0.9e1 * t85 * t203 * t610 - 0.4e1 / 0.9e1 * t85 * t280 * t614 - 0.4e1 / 0.3e1 * t85 * t618 * t619 + 0.4e1 / 0.9e1 * t85 * t316 * t623 - 0.32e2 / 0.27e2 * t85 * t492 * t312 - 0.64e2 / 0.27e2 * t85 * t630 * t318 + 0.4e1 / 0.9e1 * t85 * t203 * t635 + 0.2e1 / 0.9e1 * t85 * t203 * t639 + 0.8e1 / 0.9e1 * t85 * t316 * t644 - 0.64e2 / 0.27e2 * t85 * t648 * t282;
  t671 = t22 * t25 * t26 * sigma[0] * t30;
  t672 = t35 * t88;
  t673 = t672 * t235;
  t674 = t152 * t103;
  t675 = t674 * t121;
  t676 = t673 * t675;
  t679 = t35 * t196;
  t680 = t679 * t109;
  t681 = t143 * t103;
  t682 = t681 * t121;
  t683 = t680 * t682;
  t686 = t96 * t304;
  t689 = t215 * t153;
  t692 = t215 * t144;
  t703 = t547 * t32;
  t705 = 0.1e1 / t703 * t559;
  t709 = 0.14e2 / 0.9e1 * t138 * t212 + 0.74e2 / 0.9e1 * t36 * t216 - 0.124e3 / 0.9e1 * t295 * t222 * t225 * sigma[0] + 0.32e2 / 0.3e1 * t36 * t705 * t148;
  t710 = t89 * t709;
  t711 = t86 * t710;
  t714 = t96 * t327;
  t717 = t246 * t149;
  t723 = -t717 * t58 - 0.16e2 / 0.3e1 * t322 * t118 - 0.4e2 / 0.9e1 * t150 * t251;
  t724 = t110 * t723;
  t725 = t86 * t724;
  t729 = t22 * t27 * t30;
  t733 = -0.32e2 / 0.27e2 * t85 * t492 * t287 - 0.2e1 / 0.9e1 * t28 * t231 - 0.2e1 / 0.9e1 * t28 * t256 + 0.32e2 / 0.27e2 * t28 * t189 + 0.32e2 / 0.27e2 * t28 * t192 + 0.4e1 / 0.9e1 * t28 * t200 + 0.4e1 / 0.9e1 * t28 * t239 - 0.8e1 / 0.9e1 * t671 * t676 - 0.8e1 / 0.9e1 * t671 * t683 + 0.32e2 / 0.27e2 * t85 * t686 - 0.176e3 / 0.81e2 * t85 * t689 - 0.176e3 / 0.81e2 * t85 * t692 - 0.2e1 / 0.9e1 * t85 * t711 + 0.32e2 / 0.27e2 * t85 * t714 - 0.2e1 / 0.9e1 * t85 * t725 + 0.4e1 / 0.9e1 * t729 * t672 * t205;
  t734 = t652 + t733;
  t739 = my_piecewise3(t3, 0, t7 * t174 * t157 / 0.12e2 - t7 * t72 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t734);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t739 + 0.4e1 * t336;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t743 = t210 * params->beta;
  t748 = t163 * t339 * t25;
  t753 = t196 * t109;
  t755 = t345 * t753 * t198;
  t757 = t345 * t88;
  t759 = t757 * t444 * t121;
  t763 = t345 * t346 * t229;
  t767 = t345 * t451 * t237;
  t771 = t345 * t236 * t254;
  t774 = my_piecewise3(t3, 0, -0.14e2 / 0.9e1 * t163 * t743 * t168 - 0.4e1 / 0.3e1 * t748 * t348 - 0.8e1 / 0.3e1 * t748 * t352 - t344 * t755 - 0.2e1 * t344 * t759 + t344 * t763 / 0.2e1 - 0.3e1 * t344 * t767 + t344 * t771);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t774 + 0.4e1 * t355;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t783 = t61 * t386;
  t784 = t783 * t103;
  t788 = t109 * t386;
  t789 = t788 * t121;
  t793 = t235 * t391;
  t794 = t793 * t103;
  t798 = t450 * t391;
  t799 = t798 * t121;
  t803 = t317 * t326;
  t807 = t109 * t402;
  t808 = t807 * t103;
  t812 = t235 * t402;
  t813 = t812 * t121;
  t817 = t61 * t362;
  t818 = t817 * t103;
  t822 = t109 * t362;
  t823 = t822 * t121;
  t827 = t281 * t303;
  t831 = t595 * t152;
  t835 = t286 * t326;
  t841 = -0.32e2 / 0.27e2 * t85 * t492 * t367 + 0.4e1 / 0.9e1 * t85 * t280 * t784 + 0.2e1 / 0.9e1 * t85 * t203 * t789 - 0.4e1 / 0.9e1 * t85 * t203 * t794 - 0.4e1 / 0.3e1 * t85 * t316 * t799 + 0.8e1 / 0.9e1 * t85 * t316 * t803 + 0.2e1 / 0.9e1 * t85 * t203 * t808 + 0.4e1 / 0.9e1 * t85 * t316 * t813 - 0.4e1 / 0.3e1 * t85 * t618 * t818 - 0.4e1 / 0.9e1 * t85 * t280 * t823 + 0.8e1 / 0.9e1 * t85 * t280 * t827 + 0.4e1 / 0.9e1 * t85 * t203 * t831 + 0.4e1 / 0.9e1 * t85 * t203 * t835 + 0.32e2 / 0.27e2 * t28 * t308;
  t848 = t143 * t152;
  t849 = t848 * t103;
  t850 = t680 * t849;
  t853 = t848 * t121;
  t854 = t673 * t853;
  t857 = t115 * t398;
  t862 = 0.2e1 * t857 * t58 + 0.16e2 / 0.3e1 * t399 * t118;
  t863 = t110 * t862;
  t864 = t86 * t863;
  t873 = t96 * t387;
  t876 = t96 * t392;
  t879 = t96 * t403;
  t882 = t96 * t363;
  t896 = t29 * t298 * t225;
  t899 = t547 * rho[0];
  t901 = 0.1e1 / t899 * t559;
  t905 = t373 * t93 / 0.3e1 - t376 * t100 / 0.3e1 + 0.1e2 / 0.3e1 * t36 * t896 - 0.4e1 * t36 * t901 * sigma[0];
  t906 = t89 * t905;
  t907 = t86 * t906;
  t910 = 0.32e2 / 0.27e2 * t28 * t277 - 0.4e1 / 0.9e1 * t28 * t328 - 0.4e1 / 0.9e1 * t28 * t305 - 0.8e1 / 0.9e1 * t671 * t850 - 0.8e1 / 0.9e1 * t671 * t854 - 0.2e1 / 0.9e1 * t85 * t864 + 0.8e1 / 0.9e1 * t729 * t679 * t282 + 0.4e1 / 0.9e1 * t729 * t672 * t287 + 0.16e2 / 0.27e2 * t85 * t873 - 0.32e2 / 0.27e2 * t85 * t876 + 0.16e2 / 0.27e2 * t85 * t879 - 0.32e2 / 0.27e2 * t85 * t882 + 0.4e1 / 0.9e1 * t729 * t672 * t312 + 0.8e1 / 0.9e1 * t729 * t49 * t318 - 0.2e1 / 0.9e1 * t85 * t907;
  t911 = t841 + t910;
  t916 = my_piecewise3(t3, 0, -t7 * t72 * t407 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t911);
  tv3rhosigma20 = 0.2e1 * rho[0] * t916 + 0.2e1 * t411;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t921 = t345 * t196;
  t923 = t921 * t286 * t103;
  t926 = t757 * t609 * t121;
  t929 = t345 * t346 * t303;
  t935 = t757 * t317 * t103;
  t937 = t345 * t48;
  t939 = t937 * t604 * t121;
  t943 = t345 * t236 * t326;
  t946 = my_piecewise3(t3, 0, -0.2e1 / 0.3e1 * t748 * t414 - t344 * t923 - t344 * t926 + t344 * t929 / 0.2e1 - 0.4e1 / 0.3e1 * t748 * t418 - t344 * t935 - 0.3e1 * t344 * t939 + t344 * t943);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t946 + 0.2e1 * t421;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t951 = t235 * t56;
  t953 = t757 * t951 * t103;
  t956 = t450 * t56;
  t958 = t937 * t956 * t121;
  t962 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t344 * t428 + 0.2e1 * t426 * t953 + 0.6e1 * t426 * t958);
  tv3rholapl20 = 0.2e1 * rho[0] * t962 + 0.2e1 * t431;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t965 = t391 * t152;
  t966 = t451 * t965;
  t967 = t86 * t966;
  t970 = t317 * t402;
  t974 = t362 * t143;
  t975 = t464 * t974;
  t976 = t86 * t975;
  t979 = t822 * t152;
  t983 = t281 * t386;
  t987 = t788 * t152;
  t991 = t286 * t402;
  t1003 = t36 / t37 / t148;
  t1006 = t36 * t149;
  t1011 = 0.1e1 / t547;
  t1015 = 0.3e1 / 0.8e1 * t1003 * t45 - 0.3e1 / 0.8e1 * t1006 * t140 - t376 * t383 / 0.4e1 + 0.3e1 / 0.2e1 * t36 * t1011 * t559;
  t1016 = t89 * t1015;
  t1017 = t86 * t1016;
  t1021 = t148 * t148;
  t1022 = 0.1e1 / t1021;
  t1023 = t55 * t1022;
  t1026 = -0.6e1 * t1023 * t58 + 0.12e2 * t398;
  t1027 = t110 * t1026;
  t1028 = t86 * t1027;
  t1036 = t609 * t391;
  t1040 = -0.4e1 / 0.3e1 * t85 * t967 + 0.4e1 / 0.3e1 * t85 * t316 * t970 - 0.4e1 / 0.3e1 * t85 * t976 - 0.4e1 / 0.3e1 * t85 * t280 * t979 + 0.4e1 / 0.3e1 * t85 * t280 * t983 + 0.2e1 / 0.3e1 * t85 * t203 * t987 + 0.2e1 / 0.3e1 * t85 * t203 * t991 - 0.2e1 / 0.3e1 * t28 * t388 - 0.2e1 / 0.3e1 * t28 * t404 + 0.4e1 / 0.3e1 * t28 * t393 - 0.2e1 / 0.9e1 * t85 * t1017 - 0.2e1 / 0.9e1 * t85 * t1028 + 0.4e1 / 0.3e1 * t28 * t364 + 0.4e1 / 0.3e1 * t729 * t672 * t367 - 0.4e1 / 0.3e1 * t85 * t203 * t1036;
  t1044 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1040);
  tv3sigma30 = 0.2e1 * rho[0] * t1044;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1047 = t345 * t753 * t362;
  t1050 = t757 * t609 * t152;
  t1054 = t345 * t346 * t386;
  t1058 = t345 * t451 * t391;
  t1062 = t345 * t236 * t402;
  t1065 = my_piecewise3(t3, 0, -t344 * t1047 - 0.2e1 * t344 * t1050 + t344 * t1054 / 0.2e1 - 0.3e1 * t344 * t1058 + t344 * t1062);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1065;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1068 = t757 * t951 * t143;
  t1072 = t937 * t956 * t152;
  t1076 = t345 * t236 * t149;
  t1080 = my_piecewise3(t3, 0, 0.2e1 * t426 * t1068 + 0.6e1 * t426 * t1072 + 0.2e1 * t426 * t1076);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1080;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1084 = t163 * t33 * params->beta * t25;
  t1086 = t345 * t451 * t149;
  t1089 = my_piecewise3(t3, 0, -0.12e2 * t1084 * t1086);
  tv3lapl30 = 0.2e1 * rho[0] * t1089;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1105 = t450 * t103;
  t1127 = t235 * t229;
  t1151 = t215 * t88;
  t1173 = t235 * t198;
  t1182 = 0.16e2 / 0.3e1 * t85 * t203 * t1105 * t452 + 0.16e2 / 0.9e1 * t85 * t280 * t475 * t563 + 0.8e1 / 0.9e1 * t85 * t203 * t109 * t563 * t121 + 0.4e1 / 0.3e1 * t85 * t203 * t480 * t254 + 0.8e1 / 0.9e1 * t85 * t203 * t204 * t515 - 0.8e1 / 0.3e1 * t85 * t203 * t1127 * t237 - 0.8e1 * t85 * t316 * t450 * t237 * t254 + 0.16e2 / 0.9e1 * t85 * t316 * t457 * t515 + 0.16e2 / 0.3e1 * t85 * t618 * t109 * t465 * t121 - 0.8e1 * t85 * t618 * t61 * t198 * t229 + 0.704e3 / 0.27e2 * t85 * t1151 * t205 - 0.128e3 / 0.9e1 * t85 * t648 * t476 - 0.64e2 / 0.9e1 * t85 * t492 * t481 - 0.64e2 / 0.9e1 * t85 * t492 * t485 - 0.128e3 / 0.9e1 * t85 * t630 * t458 + 0.128e3 / 0.9e1 * t85 * t648 * t471 + 0.128e3 / 0.9e1 * t85 * t492 * t445 + 0.16e2 / 0.3e1 * t85 * t280 * t1173 * t237 - 0.8e1 / 0.3e1 * t85 * t280 * t470 * t254;
  t1183 = t103 * t121;
  t1196 = 0.1e1 / t449 / t60;
  t1197 = t48 * t1196;
  t1198 = t237 * t237;
  t1203 = t254 * t254;
  t1212 = 0.1e1 / t462 / t47;
  t1213 = t1212 * t61;
  t1214 = t198 * t198;
  t1223 = 0.1e1 / t33 / t296;
  t1234 = t547 * t181;
  t1246 = 0.1e1 / t98 / t557 / t97;
  t1300 = t229 * t229;
  t1310 = -0.16e2 / 0.3e1 * t671 * t680 * t1183 * t229 - 0.16e2 / 0.3e1 * t671 * t673 * t1183 * t254 + 0.128e3 / 0.9e1 * t85 * t96 * t453 + 0.16e2 / 0.3e1 * t85 * t86 * t1197 * t1198 + 0.4e1 / 0.3e1 * t85 * t86 * t236 * t1203 + 0.128e3 / 0.9e1 * t85 * t96 * t466 + 0.16e2 / 0.3e1 * t85 * t86 * t1213 * t1214 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (0.364e4 / 0.81e2 * t38 * t382 * t44 + 0.5768e4 / 0.27e2 * t95 * t30 * t1223 * t99 - 0.37216e5 / 0.81e2 * t219 * t29 / t19 / t899 * t225 + 0.1792e5 / 0.27e2 * t36 * t397 / t1234 * t559 - 0.512e4 / 0.27e2 * t36 * t1021 / t33 / t547 / t296 * t1246 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * ((0.20944e5 / 0.81e2 * t31 * t1223 - 0.616e4 / 0.81e2 * t51 * t500) * t56 * t58 + 0.32e2 / 0.3e1 * t506 * t118 + 0.8e2 / 0.3e1 * t247 * t251 + 0.32e3 / 0.27e2 * t116 * t512 - 0.8e2 / 0.81e2 * t57 * t41) + 0.9856e4 / 0.243e3 * t85 * t543 * t104 + 0.9856e4 / 0.243e3 * t85 * t543 * t122 - 0.352e3 / 0.27e2 * t85 * t215 * t230 - 0.352e3 / 0.27e2 * t85 * t215 * t255 + 0.64e2 / 0.27e2 * t85 * t96 * t564 + 0.64e2 / 0.27e2 * t85 * t96 * t516 + 0.704e3 / 0.27e2 * t85 * t215 * t199 + 0.704e3 / 0.27e2 * t85 * t215 * t238 + 0.4e1 / 0.3e1 * t85 * t86 * t197 * t1300 + 0.41888e5 / 0.729e3 * t28 * t31 * t1223 * t48 * t61;
  t1316 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t78 * t66 - 0.5e1 / 0.9e1 * t7 * t434 * t126 + t7 * t174 * t259 / 0.2e1 - t7 * t72 * t568 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1182 + t1310));
  tv4rho40 = 0.2e1 * rho[0] * t1316 + 0.8e1 * t573;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1350 = t450 * t326;
  t1355 = t235 * t303;
  t1383 = t96 * t463;
  t1387 = t86 * t1212;
  t1395 = t1196 * t152;
  t1403 = -0.2464e4 / 0.243e3 * t28 * t543 * t134 - 0.32e2 / 0.9e1 * t85 * t492 * t635 - 0.16e2 / 0.9e1 * t85 * t492 * t639 - 0.64e2 / 0.9e1 * t85 * t630 * t644 + 0.2e1 / 0.3e1 * t85 * t203 * t109 * t723 * t103 + 0.2e1 / 0.3e1 * t85 * t203 * t634 * t229 - 0.4e1 * t85 * t316 * t1350 * t237 - 0.4e1 / 0.3e1 * t85 * t203 * t1355 * t237 - 0.4e1 / 0.3e1 * t85 * t280 * t634 * t198 - 0.4e1 * t85 * t618 * t586 * t198 + 0.4e1 / 0.3e1 * t85 * t316 * t643 * t254 + 0.4e1 / 0.9e1 * t85 * t316 * t317 * t515 + 0.32e2 / 0.9e1 * t85 * t648 * t614 + 0.4e1 / 0.3e1 * t85 * t618 * t311 * t465 + 0.32e2 / 0.3e1 * t85 * t1383 * t619 + 0.16e2 / 0.3e1 * t85 * t1387 * t281 * t465 - 0.32e2 / 0.9e1 * t85 * t630 * t623 + 0.16e2 / 0.3e1 * t85 * t316 * t1395 * t452 + 0.32e2 / 0.9e1 * t85 * t492 * t610;
  t1404 = t450 * t143;
  t1428 = t109 * t709;
  t1482 = 0.4e1 / 0.3e1 * t85 * t203 * t1404 * t452 + 0.32e2 / 0.3e1 * t85 * t630 * t605 - 0.16e2 / 0.9e1 * t85 * t492 * t600 + 0.4e1 / 0.3e1 * t85 * t280 * t61 * t709 * t103 + 0.4e1 / 0.3e1 * t85 * t280 * t586 * t229 + 0.4e1 / 0.9e1 * t85 * t280 * t281 * t563 + 0.2e1 / 0.3e1 * t85 * t203 * t1428 * t121 + 0.2e1 / 0.3e1 * t85 * t203 * t595 * t254 + 0.2e1 / 0.9e1 * t85 * t203 * t286 * t515 + 0.2e1 / 0.9e1 * t85 * t203 * t311 * t563 + 0.4e1 / 0.3e1 * t85 * t316 * t235 * t723 * t121 + 0.352e3 / 0.27e2 * t85 * t215 * t196 * t282 + 0.176e3 / 0.27e2 * t85 * t1151 * t287 - 0.64e2 / 0.9e1 * t85 * t648 * t587 - 0.32e2 / 0.9e1 * t85 * t648 * t591 - 0.32e2 / 0.9e1 * t85 * t492 * t596 + 0.176e3 / 0.27e2 * t85 * t1151 * t312 + 0.352e3 / 0.27e2 * t85 * t215 * t48 * t318 - 0.4e1 / 0.3e1 * t671 * t673 * t152 * t229 * t121 - 0.4e1 / 0.3e1 * t671 * t673 * t674 * t254;
  t1488 = t35 * t463;
  t1489 = t1488 * t61;
  t1494 = t49 * t450;
  t1495 = t152 * t121;
  t1514 = t143 * t121;
  t1524 = t78 * t196;
  t1525 = t1524 * t109;
  t1529 = t1488 * t109;
  t1535 = t679 * t235;
  t1540 = t78 * t88;
  t1541 = t1540 * t235;
  t1550 = t672 * t450;
  t1565 = -0.4e1 / 0.3e1 * t671 * t680 * t674 * t229 - 0.4e1 * t671 * t1489 * t681 * t229 - 0.4e1 * t671 * t1494 * t1495 * t254 - 0.8e1 / 0.3e1 * t671 * t680 * t303 * t103 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t143 * t229 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t681 * t254 - 0.4e1 / 0.3e1 * t671 * t673 * t1514 * t254 - 0.8e1 / 0.3e1 * t671 * t673 * t326 * t103 * t121 + 0.64e2 / 0.9e1 * t671 * t1525 * t682 + 0.4e1 * t671 * t1529 * t143 * t198 * t121 + 0.8e1 / 0.3e1 * t671 * t1535 * t681 * t237 + 0.64e2 / 0.9e1 * t671 * t1541 * t675 + 0.8e1 / 0.3e1 * t671 * t1535 * t152 * t198 * t121 + 0.4e1 * t671 * t1550 * t674 * t237 - 0.32e2 / 0.9e1 * t28 * t496 + 0.16e2 / 0.9e1 * t28 * t531 + 0.16e2 / 0.9e1 * t28 * t534 - 0.2e1 / 0.9e1 * t28 * t565 - 0.2e1 / 0.9e1 * t28 * t517;
  t1653 = -0.176e3 / 0.27e2 * t28 * t525 - 0.176e3 / 0.27e2 * t28 * t528 + 0.2464e4 / 0.243e3 * t85 * t543 * t144 + 0.2464e4 / 0.243e3 * t85 * t543 * t153 - 0.4e1 / 0.3e1 * t729 * t672 * t445 + 0.16e2 / 0.9e1 * t85 * t96 * t710 + 0.16e2 / 0.9e1 * t85 * t96 * t724 - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (-t505 * t149 * t58 - 0.8e1 * t717 * t118 - 0.4e2 / 0.3e1 * t322 * t251 - 0.8e2 / 0.27e2 * t150 * t512) - 0.4e1 / 0.3e1 * t729 * t679 * t471 - 0.32e2 / 0.9e1 * t729 * t1540 * t205 - 0.176e3 / 0.27e2 * t85 * t215 * t327 - 0.176e3 / 0.27e2 * t85 * t215 * t304 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.14e3 / 0.27e2 * t138 * t540 - 0.364e3 / 0.9e1 * t36 * t544 + 0.332e4 / 0.27e2 * t295 * t549 * t225 * sigma[0] - 0.1952e4 / 0.9e1 * t36 * t555 * t559 * t148 + 0.64e3 / 0.9e1 * t36 / t33 / t547 / t379 * t1246 * t397 * t30) + 0.4e1 / 0.3e1 * t729 * t679 * t476 + 0.2e1 / 0.3e1 * t729 * t672 * t481 + 0.2e1 / 0.3e1 * t729 * t672 * t485 + 0.4e1 / 0.3e1 * t729 * t49 * t458 - 0.4e1 / 0.3e1 * t28 * t454 - 0.4e1 / 0.3e1 * t28 * t467 - 0.32e2 / 0.9e1 * t28 * t489;
  t1660 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t157 + t7 * t174 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t734 - 0.3e1 / 0.8e1 * t7 * t20 * (t1403 + t1482 + t1565 + t1653));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t1660 + 0.6e1 * t739;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t1687 = t463 * t109;
  t1714 = t163 * t743 * t25;
  t1725 = -0.3e1 * t344 * t757 * t1127 * t121 - 0.3e1 * t344 * t757 * t444 * t254 + 0.12e2 * t344 * t345 * t1197 * t452 - 0.9e1 * t344 * t937 * t450 * t121 * t254 + 0.4e1 * t748 * t755 + 0.8e1 * t748 * t759 + 0.12e2 * t748 * t767 + 0.3e1 * t344 * t345 * t1687 * t465 + 0.6e1 * t344 * t921 * t1173 * t121 - 0.3e1 * t344 * t921 * t204 * t229 - 0.4e1 * t748 * t771 + t344 * t345 * t346 * t563 / 0.2e1 + t344 * t345 * t236 * t515 + 0.14e3 / 0.27e2 * t163 * t538 * params->beta * t168 + 0.14e2 / 0.3e1 * t1714 * t348 + 0.28e2 / 0.3e1 * t1714 * t352 - 0.2e1 * t748 * t763 + 0.9e1 * t344 * t757 * t1105 * t237;
  t1726 = my_piecewise3(t3, 0, t1725);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t1726 + 0.6e1 * t774;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t1740 = t235 * t362;
  t1749 = t450 * t402;
  t1754 = t1196 * t391;
  t1763 = t235 * t386;
  t1782 = 0.16e2 / 0.3e1 * t85 * t1387 * t817 * t198 + 0.8e1 / 0.9e1 * t85 * t280 * t1740 * t237 - 0.4e1 / 0.9e1 * t85 * t280 * t807 * t198 - 0.4e1 / 0.3e1 * t85 * t316 * t1749 * t237 + 0.16e2 / 0.3e1 * t85 * t316 * t1754 * t237 - 0.4e1 / 0.3e1 * t85 * t618 * t783 * t198 - 0.4e1 / 0.9e1 * t85 * t203 * t1763 * t237 + 0.8e1 / 0.9e1 * t85 * t280 * t793 * t198 + 0.352e3 / 0.81e2 * t85 * t1151 * t367 - 0.4e1 / 0.3e1 * t85 * t316 * t798 * t254 - 0.64e2 / 0.27e2 * t85 * t492 * t831;
  t1815 = t109 * t905;
  t1823 = -0.64e2 / 0.27e2 * t85 * t492 * t835 - 0.64e2 / 0.27e2 * t85 * t648 * t784 - 0.32e2 / 0.27e2 * t85 * t492 * t789 + 0.4e1 / 0.9e1 * t85 * t280 * t783 * t229 + 0.4e1 / 0.9e1 * t85 * t203 * t109 * t862 * t103 + 0.8e1 / 0.9e1 * t85 * t316 * t235 * t862 * t121 - 0.16e2 / 0.9e1 * t729 * t683 - 0.16e2 / 0.9e1 * t729 * t676 + 0.8e1 / 0.9e1 * t85 * t280 * t61 * t905 * t103 + 0.4e1 / 0.9e1 * t85 * t203 * t1815 * t121 + 0.64e2 / 0.9e1 * t85 * t1383 * t818;
  t1865 = 0.64e2 / 0.27e2 * t85 * t648 * t823 - 0.128e3 / 0.27e2 * t85 * t648 * t827 - 0.4e1 / 0.3e1 * t85 * t618 * t817 * t229 - 0.4e1 / 0.9e1 * t85 * t280 * t822 * t254 + 0.8e1 / 0.9e1 * t85 * t280 * t281 * t709 + 0.4e1 / 0.9e1 * t85 * t203 * t1428 * t152 + 0.8e1 / 0.9e1 * t85 * t316 * t317 * t723 - 0.32e2 / 0.27e2 * t85 * t492 * t808 - 0.64e2 / 0.27e2 * t85 * t630 * t813 + 0.2e1 / 0.9e1 * t85 * t203 * t807 * t229 + 0.4e1 / 0.9e1 * t85 * t316 * t812 * t254;
  t1903 = t143 * t326;
  t1912 = 0.2e1 / 0.9e1 * t85 * t203 * t788 * t254 + 0.64e2 / 0.27e2 * t85 * t492 * t794 + 0.64e2 / 0.9e1 * t85 * t630 * t799 - 0.128e3 / 0.27e2 * t85 * t630 * t803 - 0.4e1 / 0.9e1 * t85 * t203 * t793 * t229 + 0.8e1 / 0.9e1 * t85 * t203 * t595 * t326 + 0.4e1 / 0.9e1 * t85 * t203 * t286 * t723 + 0.32e2 / 0.9e1 * t671 * t1535 * t848 * t1183 + 0.8e1 / 0.3e1 * t671 * t1529 * t848 * t198 + 0.8e1 / 0.3e1 * t671 * t1550 * t848 * t237 - 0.16e2 / 0.9e1 * t671 * t680 * t1903 * t103 - 0.8e1 / 0.9e1 * t671 * t680 * t848 * t229;
  t1915 = t303 * t152;
  t1946 = -0.16e2 / 0.9e1 * t671 * t673 * t1915 * t121 - 0.16e2 / 0.9e1 * t671 * t673 * t1903 * t121 - 0.8e1 / 0.9e1 * t671 * t673 * t848 * t254 + 0.64e2 / 0.27e2 * t28 * t686 - 0.4e1 / 0.9e1 * t28 * t725 - 0.4e1 / 0.9e1 * t28 * t711 + 0.64e2 / 0.27e2 * t28 * t714 - 0.352e3 / 0.81e2 * t28 * t692 - 0.352e3 / 0.81e2 * t28 * t689 + 0.4e1 / 0.9e1 * t729 * t672 * t600 - 0.64e2 / 0.27e2 * t729 * t1540 * t312;
  t1965 = t303 * t303;
  t1970 = t326 * t326;
  t1987 = -0.128e3 / 0.27e2 * t729 * t79 * t318 + 0.8e1 / 0.9e1 * t729 * t672 * t635 + 0.4e1 / 0.9e1 * t729 * t672 * t639 + 0.16e2 / 0.9e1 * t729 * t49 * t644 + 0.8e1 / 0.9e1 * t729 * t49 * t623 + 0.352e3 / 0.81e2 * t85 * t215 * t363 + 0.8e1 / 0.9e1 * t85 * t86 * t197 * t1965 + 0.8e1 / 0.9e1 * t85 * t86 * t236 * t1970 - 0.176e3 / 0.81e2 * t85 * t215 * t403 + 0.352e3 / 0.81e2 * t85 * t215 * t392 - 0.176e3 / 0.81e2 * t85 * t215 * t387 - 0.8e1 / 0.3e1 * t729 * t1488 * t619;
  t2049 = -0.8e1 / 0.9e1 * t729 * t672 * t610 - 0.8e1 / 0.9e1 * t729 * t679 * t614 - 0.8e1 / 0.3e1 * t729 * t49 * t605 + 0.32e2 / 0.27e2 * t85 * t96 * t906 + 0.32e2 / 0.27e2 * t85 * t96 * t863 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.7e1 / 0.9e1 * t373 * t212 + 0.7e1 / 0.9e1 * t376 * t216 - 0.22e2 * t36 * t226 + 0.188e3 / 0.3e1 * t36 * t705 * sigma[0] - 0.8e2 / 0.3e1 * t36 / t33 / t1234 * t1246 * t148 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (0.2e1 * t246 * t398 * t58 + 0.32e2 / 0.3e1 * t857 * t118 + 0.8e2 / 0.9e1 * t399 * t251) - 0.128e3 / 0.27e2 * t729 * t1524 * t282 - 0.64e2 / 0.27e2 * t729 * t1540 * t287 + 0.16e2 / 0.9e1 * t729 * t679 * t587 + 0.8e1 / 0.9e1 * t729 * t679 * t591;
  t2099 = 0.8e1 / 0.9e1 * t729 * t672 * t596 + 0.8e1 / 0.3e1 * t671 * t1529 * t362 * t103 * t121 - 0.16e2 / 0.3e1 * t671 * t1489 * t681 * t303 - 0.16e2 / 0.9e1 * t671 * t680 * t1514 * t303 - 0.8e1 / 0.9e1 * t671 * t673 * t402 * t103 * t121 + 0.8e1 / 0.3e1 * t671 * t1550 * t391 * t103 * t121 - 0.16e2 / 0.9e1 * t671 * t673 * t674 * t326 - 0.16e2 / 0.3e1 * t671 * t1494 * t1495 * t326 - 0.8e1 / 0.9e1 * t671 * t680 * t386 * t103 * t121 + 0.128e3 / 0.27e2 * t671 * t1525 * t849 + 0.128e3 / 0.27e2 * t671 * t1541 * t853 - 0.16e2 / 0.9e1 * t671 * t680 * t1915 * t103;
  t2107 = my_piecewise3(t3, 0, t7 * t174 * t407 / 0.12e2 - t7 * t72 * t911 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1782 + t1823 + t1865 + t1912 + t1946 + t1987 + t2049 + t2099));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2107 + 0.4e1 * t916;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2113 = params->beta * t25 * t26;
  t2114 = t163 * t40 * t2113;
  t2116 = t30 * t88 * t450;
  t2124 = t345 * t463;
  t2130 = t30 * t196 * t235;
  t2157 = 0.6e1 * t2114 * t2116 * t675 + 0.12e2 * t344 * t937 * t1395 * t237 + 0.3e1 * t344 * t2124 * t286 * t198 + 0.4e1 * t2114 * t2130 * t682 + 0.3e1 * t344 * t757 * t1404 * t237 + 0.2e1 * t344 * t921 * t317 * t198 - 0.4e1 / 0.3e1 * t748 * t929 + t344 * t345 * t346 * t709 / 0.2e1 - 0.8e1 / 0.3e1 * t748 * t943 + t344 * t345 * t236 * t723 + 0.28e2 / 0.9e1 * t1714 * t418 + 0.8e1 / 0.3e1 * t748 * t935;
  t2195 = 0.8e1 * t748 * t939 - 0.2e1 * t344 * t757 * t643 * t103 - t344 * t757 * t317 * t229 - 0.6e1 * t344 * t937 * t1350 * t121 - 0.3e1 * t344 * t937 * t604 * t254 + 0.8e1 / 0.3e1 * t748 * t923 + 0.8e1 / 0.3e1 * t748 * t926 - 0.2e1 * t344 * t921 * t595 * t103 - t344 * t921 * t286 * t229 - 0.2e1 * t344 * t757 * t1355 * t121 - t344 * t757 * t609 * t254 + 0.14e2 / 0.9e1 * t1714 * t414;
  t2197 = my_piecewise3(t3, 0, t2157 + t2195);
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t2197 + 0.4e1 * t946;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t2212 = t163 * t423 * t2113;
  t2222 = t1196 * t56;
  t2232 = my_piecewise3(t3, 0, -0.8e1 / 0.9e1 * t748 * t428 - 0.4e1 / 0.3e1 * t344 * t953 - 0.4e1 * t344 * t958 - 0.4e1 * t426 * t921 * t951 * t198 - 0.12e2 * t2212 * t2116 * t56 * t103 * t121 + 0.2e1 * t426 * t757 * t951 * t229 - 0.24e2 * t426 * t937 * t2222 * t237 + 0.6e1 * t426 * t937 * t956 * t254);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t2232 + 0.4e1 * t962;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t2251 = t109 * t1015;
  t2274 = t362 * t152;
  t2287 = t143 * t386;
  t2296 = -0.8e1 / 0.3e1 * t729 * t850 - 0.8e1 / 0.3e1 * t729 * t854 - 0.4e1 / 0.3e1 * t85 * t203 * t1355 * t391 + 0.4e1 / 0.9e1 * t85 * t280 * t61 * t1015 * t103 + 0.2e1 / 0.9e1 * t85 * t203 * t2251 * t121 + 0.4e1 / 0.3e1 * t729 * t672 * t831 + 0.4e1 / 0.3e1 * t729 * t679 * t784 + 0.2e1 / 0.3e1 * t729 * t672 * t789 + 0.2e1 / 0.3e1 * t729 * t672 * t808 + 0.4e1 / 0.3e1 * t729 * t49 * t813 - 0.4e1 / 0.3e1 * t729 * t672 * t794 + 0.4e1 * t671 * t1529 * t2274 * t103 + 0.8e1 / 0.3e1 * t671 * t1535 * t2274 * t121 - 0.8e1 / 0.3e1 * t671 * t680 * t848 * t303 - 0.4e1 * t671 * t1489 * t2287 * t103 - 0.4e1 / 0.3e1 * t671 * t680 * t2287 * t121;
  t2297 = t152 * t402;
  t2306 = t143 * t391;
  t2319 = t386 * t152;
  t2328 = t143 * t402;
  t2342 = t109 * t974;
  t2367 = -0.4e1 / 0.3e1 * t671 * t673 * t2297 * t103 - 0.4e1 * t671 * t1494 * t2297 * t121 + 0.8e1 / 0.3e1 * t671 * t1535 * t2306 * t103 + 0.4e1 * t671 * t1550 * t2306 * t121 - 0.8e1 / 0.3e1 * t671 * t673 * t848 * t326 - 0.4e1 / 0.3e1 * t671 * t680 * t2319 * t103 - 0.4e1 / 0.3e1 * t671 * t673 * t2319 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t2328 * t103 - 0.4e1 / 0.3e1 * t671 * t673 * t2328 * t121 + 0.16e2 / 0.3e1 * t85 * t1387 * t61 * t974 * t103 + 0.4e1 / 0.3e1 * t85 * t618 * t2342 * t121 - 0.4e1 * t85 * t618 * t817 * t303 - 0.4e1 / 0.3e1 * t85 * t280 * t822 * t326 + 0.32e2 / 0.9e1 * t85 * t492 * t1036 - 0.16e2 / 0.9e1 * t85 * t492 * t987 - 0.16e2 / 0.9e1 * t85 * t492 * t991 + 0.32e2 / 0.9e1 * t85 * t648 * t979;
  t2431 = -0.32e2 / 0.9e1 * t85 * t648 * t983 - 0.32e2 / 0.9e1 * t85 * t630 * t970 - 0.2e1 / 0.3e1 * t28 * t907 - 0.2e1 / 0.3e1 * t28 * t864 - 0.32e2 / 0.9e1 * t28 * t882 + 0.16e2 / 0.9e1 * t28 * t873 + 0.16e2 / 0.9e1 * t28 * t879 - 0.32e2 / 0.9e1 * t28 * t876 - 0.32e2 / 0.9e1 * t729 * t1540 * t367 + 0.16e2 / 0.27e2 * t85 * t96 * t1016 + 0.16e2 / 0.27e2 * t85 * t96 * t1027 + 0.32e2 / 0.9e1 * t85 * t96 * t966 + 0.32e2 / 0.9e1 * t85 * t96 * t975 + 0.4e1 / 0.3e1 * t729 * t672 * t835 - 0.4e1 * t729 * t49 * t799 + 0.8e1 / 0.3e1 * t729 * t49 * t803 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-t1003 * t93 / 0.2e1 + t1006 * t100 / 0.2e1 + t376 * t896 / 0.3e1 - 0.14e2 * t36 * t901 + 0.1e2 * t36 / t33 / t554 * t1246 * sigma[0] * t30);
  t2485 = t450 * t965;
  t2507 = -0.2e1 / 0.9e1 * t85 * t86 * t110 * (-0.6e1 * t115 * t1022 * t58 - 0.16e2 * t1023 * t118) - 0.4e1 * t729 * t1488 * t818 - 0.4e1 / 0.3e1 * t729 * t679 * t823 + 0.8e1 / 0.3e1 * t729 * t679 * t827 + 0.2e1 / 0.9e1 * t85 * t203 * t109 * t1026 * t103 + 0.4e1 / 0.9e1 * t85 * t316 * t235 * t1026 * t121 + 0.4e1 / 0.3e1 * t85 * t280 * t586 * t386 + 0.4e1 / 0.3e1 * t85 * t280 * t281 * t905 + 0.2e1 / 0.3e1 * t85 * t203 * t1815 * t152 + 0.2e1 / 0.3e1 * t85 * t203 * t788 * t326 + 0.2e1 / 0.3e1 * t85 * t203 * t595 * t402 + 0.2e1 / 0.3e1 * t85 * t203 * t286 * t862 + 0.4e1 / 0.3e1 * t85 * t203 * t2485 * t103 + 0.16e2 / 0.3e1 * t85 * t316 * t1196 * t965 * t121 - 0.4e1 * t85 * t316 * t798 * t326 + 0.4e1 / 0.3e1 * t85 * t316 * t643 * t402 + 0.4e1 / 0.3e1 * t85 * t316 * t317 * t862;
  t2514 = my_piecewise3(t3, 0, -t7 * t72 * t1040 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2296 + t2367 + t2431 + t2507));
  tv4rhosigma30 = 0.2e1 * rho[0] * t2514 + 0.2e1 * t1044;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t2586 = -t344 * t921 * t788 * t103 - t344 * t757 * t1763 * t121 + t344 * t345 * t346 * t905 / 0.2e1 + 0.4e1 * t748 * t1058 + 0.3e1 * t344 * t757 * t798 * t103 + 0.12e2 * t344 * t937 * t1754 * t121 - 0.6e1 * t344 * t937 * t604 * t326 - 0.4e1 / 0.3e1 * t748 * t1062 - t344 * t757 * t812 * t103 - 0.3e1 * t344 * t937 * t1749 * t121 + t344 * t345 * t236 * t862;
  t2588 = my_piecewise3(t3, 0, 0.4e1 / 0.3e1 * t748 * t1047 + 0.3e1 * t344 * t2124 * t822 * t103 + 0.2e1 * t344 * t921 * t1740 * t121 - 0.2e1 * t344 * t921 * t286 * t303 + 0.8e1 / 0.3e1 * t748 * t1050 + 0.4e1 * t2114 * t2130 * t849 + 0.6e1 * t2114 * t2116 * t853 - 0.2e1 * t344 * t757 * t1355 * t152 - 0.2e1 * t344 * t757 * t609 * t326 - 0.2e1 / 0.3e1 * t748 * t1054 + t2586);
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t2588 + 0.2e1 * t1065;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t2593 = t56 * t143;
  t2608 = t56 * t152;
  t2624 = t235 * t149;
  t2629 = t450 * t149;
  t2634 = -0.2e1 / 0.3e1 * t344 * t1068 - 0.4e1 * t2212 * t2130 * t2593 * t103 - 0.6e1 * t2212 * t2116 * t2593 * t121 + 0.2e1 * t426 * t757 * t951 * t303 - 0.2e1 * t344 * t1072 - 0.6e1 * t2212 * t2116 * t2608 * t103 - 0.24e2 * t2212 * t166 * t1196 * t2608 * t121 + 0.6e1 * t426 * t937 * t956 * t326 - 0.2e1 / 0.3e1 * t344 * t1076 - 0.2e1 * t426 * t757 * t2624 * t103 - 0.6e1 * t426 * t937 * t2629 * t121;
  t2635 = my_piecewise3(t3, 0, t2634);
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t2635 + 0.2e1 * t1080;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t2644 = t1196 * t149;
  t2650 = my_piecewise3(t3, 0, 0.12e2 * t1084 * t757 * t2629 * t103 + 0.48e2 * t1084 * t937 * t2644 * t121 - 0.8e1 * t426 * t1086);
  tv4rholapl30 = 0.2e1 * rho[0] * t2650 + 0.2e1 * t1089;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t2653 = t386 * t386;
  t2700 = t391 * t391;
  t2708 = t402 * t402;
  t2716 = t362 * t362;
  t2739 = 0.4e1 / 0.3e1 * t85 * t86 * t197 * t2653 + 0.8e1 / 0.3e1 * t729 * t672 * t987 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.15e2 / 0.16e2 * t36 / t37 / t397 * t45 + 0.15e2 / 0.16e2 * t36 * t398 * t140 + 0.5e1 / 0.8e1 * t1006 * t383 + 0.3e1 / 0.4e1 * t36 * t56 * t1011 * t559 - 0.15e2 / 0.4e1 * t36 / t33 / t703 * t1246 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (-0.48e2 * t1022 + 0.24e2 * t55 / t1021 / sigma[0] * t58) - 0.16e2 / 0.3e1 * t729 * t672 * t1036 + 0.16e2 / 0.3e1 * t85 * t86 * t1197 * t2700 + 0.16e2 / 0.3e1 * t729 * t49 * t970 + 0.4e1 / 0.3e1 * t85 * t86 * t236 * t2708 + 0.8e1 / 0.3e1 * t729 * t672 * t991 + 0.16e2 / 0.3e1 * t85 * t86 * t1213 * t2716 - 0.16e2 / 0.3e1 * t729 * t679 * t979 + 0.16e2 / 0.3e1 * t729 * t679 * t983 - 0.16e2 / 0.3e1 * t671 * t680 * t848 * t386 - 0.16e2 / 0.3e1 * t671 * t673 * t2297 * t143 + 0.16e2 / 0.3e1 * t85 * t280 * t1740 * t391;
  t2792 = -0.8e1 / 0.3e1 * t85 * t203 * t1763 * t391 + 0.8e1 / 0.9e1 * t85 * t203 * t286 * t1026 + 0.16e2 / 0.3e1 * t85 * t618 * t2342 * t152 - 0.8e1 * t85 * t618 * t817 * t386 - 0.8e1 / 0.3e1 * t85 * t280 * t822 * t402 + 0.16e2 / 0.9e1 * t85 * t280 * t281 * t1015 + 0.8e1 / 0.9e1 * t85 * t203 * t2251 * t152 + 0.4e1 / 0.3e1 * t85 * t203 * t788 * t402 + 0.16e2 / 0.3e1 * t85 * t203 * t2485 * t143 - 0.8e1 * t85 * t316 * t798 * t402 + 0.16e2 / 0.9e1 * t85 * t316 * t317 * t1026 - 0.16e2 / 0.3e1 * t28 * t976 - 0.16e2 / 0.3e1 * t28 * t967 - 0.8e1 / 0.9e1 * t28 * t1017 - 0.8e1 / 0.9e1 * t28 * t1028;
  t2797 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t2739 + t2792));
  tv4sigma40 = 0.2e1 * rho[0] * t2797;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t2839 = my_piecewise3(t3, 0, 0.3e1 * t344 * t345 * t1687 * t974 + 0.6e1 * t344 * t921 * t1740 * t152 - 0.3e1 * t344 * t921 * t286 * t386 + 0.9e1 * t344 * t757 * t1404 * t391 - 0.3e1 * t344 * t757 * t1763 * t152 - 0.3e1 * t344 * t757 * t609 * t402 + t344 * t345 * t346 * t1015 / 0.2e1 + 0.12e2 * t344 * t345 * t1197 * t965 - 0.9e1 * t344 * t937 * t604 * t402 + t344 * t345 * t236 * t1026);
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t2839;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t2874 = my_piecewise3(t3, 0, -0.4e1 * t426 * t757 * t2624 * t143 - 0.12e2 * t2212 * t2116 * t2593 * t152 - 0.12e2 * t426 * t937 * t2629 * t152 - 0.24e2 * t426 * t937 * t2222 * t391 - 0.4e1 * t426 * t345 * t236 * t398 - 0.4e1 * t426 * t921 * t951 * t362 + 0.2e1 * t426 * t757 * t951 * t386 + 0.6e1 * t426 * t937 * t956 * t402);
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t2874;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t2889 = my_piecewise3(t3, 0, 0.12e2 * t1084 * t757 * t2629 * t143 + 0.48e2 * t1084 * t937 * t2644 * t152 + 0.24e2 * t1084 * t345 * t451 * t398);
  tv4sigmalapl30 = 0.2e1 * rho[0] * t2889;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t2898 = my_piecewise3(t3, 0, -0.96e2 * t163 * t52 * params->beta * t25 * t345 * t1197 * t398);
  tv4lapl40 = 0.2e1 * rho[0] * t2898;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t58 * t40 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t58 * t40 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t58 * t40 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t951 * t40 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1053, t1054, t1057, t1060, t1061, t1062, t1065, t1069;
  double t1070, t1074, t1076, t1081, t1083, t1086, t1092, t1093;
  double t1096, t1098, t1101, t1104, t1105, t1109, t1110, t1117;
  double t1120, t1121, t1141, t1149, t1151, t1156, t1157, t1159;
  double t1161, t1165, t1166, t1170, t1171, t1172, t1175, t1176;
  double t1177, t1178, t1179, t1183, t1184, t1185, t1188, t1189;
  double t1192, t1193, t1194, t1197, t1198, t1201, t1202, t1203;
  double t1204, t1205, t1210, t1211, t1217, t1218, t1224, t1229;
  double t1231, t1232, t1235, t1238, t1241, t1245, t1246, t1250;
  double t1252, t1254, t1256, t1258, t1261, t1263, tv3rho30, t1266;
  double t1267, t1268, t1271, t1276, t1277, t1279, t1283, t1284;
  double t1288, t1291, t1295, t1297, t1301, t1310, t1311, t1312;
  double t1315, t1320, t1322, t1326, t1327, t1331, t1334, t1335;
  double t1337, t1346, t1348, t1351, tv3rho31, t1354, t1359, t1363;
  double t1367, t1368, t1372, t1374, t1383, t1384, t1389, t1393;
  double t1397, t1398, t1402, t1404, t1411, t1419, t1421, t1422;
  double tv3rho32, t1427, t1434, t1438, t1439, t1446, t1447, t1454;
  double t1458, t1459, t1484, t1490, t1491, t1495, t1497, t1502;
  double t1503, t1505, t1507, t1511, t1512, t1519, t1520, t1527;
  double t1530, t1531, t1541, t1542, t1543, t1547, t1548, t1551;
  double t1552, t1553, t1554, t1555, t1559, t1560, t1561, t1564;
  double t1565, t1568, t1569, t1570, t1573, t1574, t1577, t1578;
  double t1579, t1580, t1581, t1588, t1589, t1595, t1600, tv3rho33;
  double t1608, t1615, t1617, t1623, t1624, t1625, t1629, t1630;
  double t1631, t1635, t1636, t1637, t1640, t1641, t1644, t1645;
  double t1646, t1649, t1650, t1653, t1656, t1657, t1660, t1661;
  double t1662, t1665, t1666, t1669, t1670, t1673, t1676, t1677;
  double t1678, t1681, t1682, t1688, t1689, t1696, t1697, t1713;
  double t1717, t1719, t1723, t1724, t1740, t1744, t1748, t1752;
  double t1756, t1757, t1758, t1761, t1762, t1765, t1766, t1767;
  double t1770, t1771, t1772, t1775, t1776, t1781, tv3rho2sigma0, tv3rho2sigma1;
  double t1788, t1792, t1794, tv3rho2sigma2, t1800, t1808, tv3rho2sigma3, tv3rho2sigma4;
  double t1814, t1821, t1824, tv3rho2sigma5, t1832, tv3rho2sigma6, tv3rho2sigma7, t1847;
  double t1848, t1849, t1853, t1854, t1855, t1862, t1869, t1870;
  double t1886, t1890, t1892, t1896, t1897, t1904, t1905, t1906;
  double t1909, t1910, t1913, t1914, t1917, t1920, t1921, t1922;
  double t1925, t1926, t1929, t1930, t1931, t1934, t1935, t1936;
  double t1939, t1942, t1943, t1946, t1947, t1948, t1951, t1952;
  double t1955, t1956, t1957, t1960, t1961, t1964, t1965, t1966;
  double t1969, t1970, t1971, t1983, t1987, t1991, t1995, t1999;
  double t2000, t2005, tv3rho2sigma8, t2008, t2009, t2012, t2013, t2015;
  double t2016, t2020, t2024, t2025, t2027, t2028, t2030, t2031;
  double t2032, t2034, t2037, t2040, t2043, t2046, t2047, t2050;
  double t2051, t2054, t2055, t2056, t2058, t2059, t2060, t2063;
  double t2064, tv3rho2lapl0, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, tv3rho2lapl1, t2080, t2081, t2084, t2085, t2089, t2098;
  double tv3rho2lapl2, t2100, t2101, t2104, t2105, t2110, t2112, t2115;
  double t2116, t2119, t2122, tv3rho2lapl3, t2125, t2126, t2131, tv3rho2lapl4;
  double t2134, t2137, t2140, t2141, t2144, t2145, t2149, t2154;
  double t2159, t2160, t2163, t2164, t2165, t2168, t2169, t2173;
  double t2174, t2175, t2178, t2179, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2;
  double tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2186, t2187, t2188, t2192, t2226;
  double t2228, t2231, t2232, t2236, t2241, t2242, t2246, t2247;
  double t2248, t2251, t2252, t2253, t2256, t2257, t2258, t2261;
  double t2262, t2263, t2266, t2267, t2268, t2271, t2272, t2273;
  double t2276, t2277, t2278, t2281, t2282, t2285, t2286, t2289;
  double t2290, t2293, t2294, t2295, t2298, t2299, t2300, t2303;
  double t2318, t2319, t2324, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2331, t2333, tv3rhosigma25, t2339, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2344, t2345, t2349, t2353, t2358, t2359, t2393;
  double t2395, t2398, t2399, t2403, t2404, t2405, t2408, t2409;
  double t2412, t2413, t2414, t2417, t2420, t2421, t2424, t2425;
  double t2426, t2429, t2430, t2431, t2434, t2435, t2436, t2439;
  double t2440, t2441, t2444, t2445, t2448, t2449, t2450, t2453;
  double t2454, t2455, t2458, t2459, t2460, t2475, t2476, t2481;
  double tv3rhosigma211, t2486, t2487, t2490, t2491, t2492, t2494, t2495;
  double t2497, t2498, t2503, t2504, t2507, t2508, t2510, t2511;
  double t2512, t2515, t2516, t2518, t2519, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, t2524, t2527, t2529, tv3rhosigmalapl5, t2535, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2539, t2542, t2543, t2544;
  double t2546, t2547, t2549, t2550, t2554, t2557, t2558, t2560;
  double t2561, t2562, t2565, t2566, t2568, t2569, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2574, t2575, t2578, t2579, t2580;
  double t2581, t2584, t2585, t2586, t2587, t2591, tv3rholapl20, tv3rholapl21;
  double t2596, t2598, tv3rholapl22, t2603, tv3rholapl23, tv3rholapl24, t2607, t2610;
  double t2611, t2612, t2613, t2616, t2617, t2618, t2619, t2623;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2631;
  double t2632, t2639, t2652, t2656, t2657, t2661, t2662, t2663;
  double t2666, t2667, t2676, t2677, t2680, t2681, t2684, t2685;
  double t2689, t2690, t2693, t2694, t2698, t2699, t2702, t2703;
  double t2706, t2710, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2717, t2718, t2730, t2743, t2747;
  double t2748, t2752, t2753, t2754, t2757, t2758, t2762, t2763;
  double t2766, t2767, t2770, t2771, t2774, t2775, t2778, t2779;
  double t2783, t2784, t2787, t2788, t2792, t2796, tv3sigma39, t2797;
  double t2798, t2800, t2801, t2804, t2805, t2808, t2809, t2812;
  double t2813, t2816, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t2817, t2818, t2820;
  double t2821, t2824, t2825, t2828, t2829, t2832, t2833, t2836;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t2837, t2838, t2841;
  double t2842, t2845, t2846, t2850, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t2851, t2852, t2855, t2856;
  double t2859, t2860, t2864, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27;
  double tv3sigmatau28, t2865, t2866, t2867, t2870, tv3lapl30, tv3lapl31, tv3lapl32;
  double t2871, t2872, t2873, t2876, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t58 * t40 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t951 * t40 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1053 = 0.1e1 / t350 / t20;
  t1054 = t352 * t120;
  t1057 = t351 * t120;
  t1060 = t116 * t116;
  t1061 = 0.1e1 / t1060;
  t1062 = t17 * t1061;
  t1065 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t356 - 0.6e1 * t1062);
  t1069 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1054 + 0.4e1 / 0.3e1 * t1057 * t360 + 0.4e1 / 0.3e1 * t24 * t1065);
  t1070 = t1069 * t27;
  t1074 = t364 * t129;
  t1076 = t6 * t1074 * t67;
  t1081 = t123 * t377;
  t1083 = t6 * t1081 * t67;
  t1086 = t6 * t369 * t177;
  t1092 = 0.1e1 / t128 / t116;
  t1093 = t26 * t1092;
  t1096 = 0.5e1 / 0.36e2 * t6 * t1093 * t67;
  t1098 = t6 * t378 * t177;
  t1101 = t6 * t130 * t461;
  t1104 = 0.1e1 / t39 / t933;
  t1105 = sigma[0] * t1104;
  t1109 = -0.1232e4 / 0.27e2 * t1105 + 0.44e3 / 0.27e2 * lapl[0] * t387;
  t1110 = t1109 * t57;
  t1117 = 0.1e1 / t38;
  t1120 = 0.2e1 * t1110 * t40 + 0.16e2 * t449 * t53 + 0.8e2 / 0.3e1 * t167 * t39 + 0.16e3 / 0.27e2 * t58 * t1117;
  t1121 = t162 * t1120;
  t1141 = 0.1e1 / t38 / t385;
  t1149 = t385 * t385;
  t1151 = 0.1e1 / t38 / t1149;
  t1156 = t1149 * t134;
  t1157 = 0.1e1 / t1156;
  t1159 = t149 * t149;
  t1161 = 0.1e1 / t150 / t1159;
  t1165 = -0.28e3 / 0.27e2 * t43 * t44 * t1141 * t48 - 0.952e3 / 0.27e2 * t43 * t1105 * t151 + 0.592e3 / 0.27e2 * t43 * t287 * t1151 * t428 - 0.64e2 / 0.9e1 * t43 * t949 * t1157 * t1161;
  t1166 = t143 * t1165;
  t1170 = t438 * t155;
  t1171 = t1170 * t440;
  t1172 = t408 * t1171;
  t1175 = t141 * t141;
  t1176 = 0.1e1 / t1175;
  t1177 = t1176 * t62;
  t1178 = t401 * t155;
  t1179 = t1177 * t1178;
  t1183 = t161 * t401;
  t1184 = t1183 * t172;
  t1185 = t692 * t1184;
  t1188 = t680 * t432;
  t1189 = t692 * t1188;
  t1192 = t161 * t432;
  t1193 = t1192 * t172;
  t1194 = t408 * t1193;
  t1197 = t409 * t456;
  t1198 = t408 * t1197;
  t1201 = t160 * t160;
  t1202 = 0.1e1 / t1201;
  t1203 = t52 * t1202;
  t1204 = t440 * t172;
  t1205 = t1203 * t1204;
  t1210 = t438 * t172 * t456;
  t1211 = t684 * t1210;
  t1217 = t136 * t142;
  t1218 = t1217 * t410;
  t1224 = -0.2e1 / 0.9e1 * t36 * t42 * t1121 - 0.2464e4 / 0.243e3 * t36 * t1105 * t63 - 0.176e3 / 0.27e2 * t36 * t388 * t156 - 0.176e3 / 0.27e2 * t36 * t388 * t173 + 0.16e2 / 0.9e1 * t36 * t137 * t433 + 0.16e2 / 0.9e1 * t36 * t137 * t457 - 0.2e1 / 0.9e1 * t36 * t42 * t1166 - 0.4e1 / 0.3e1 * t407 * t1172 - 0.4e1 / 0.3e1 * t36 * t42 * t1179 - 0.4e1 / 0.3e1 * t407 * t1185 + 0.4e1 / 0.3e1 * t407 * t1189 + 0.2e1 / 0.3e1 * t407 * t1194 + 0.2e1 / 0.3e1 * t407 * t1198 - 0.4e1 / 0.3e1 * t36 * t42 * t1205 + 0.4e1 / 0.3e1 * t407 * t1211 - 0.32e2 / 0.9e1 * t36 * t137 * t402 - 0.32e2 / 0.9e1 * t407 * t1218 - 0.32e2 / 0.9e1 * t36 * t137 * t441;
  t1229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t67 - 0.3e1 / 0.8e1 * t1076 - 0.9e1 / 0.8e1 * t6 * t365 * t177 + t1083 / 0.4e1 - 0.3e1 / 0.4e1 * t1086 - 0.9e1 / 0.8e1 * t6 * t124 * t461 - t1096 + t1098 / 0.4e1 - 0.3e1 / 0.8e1 * t1101 - 0.3e1 / 0.8e1 * t6 * t28 * t1224);
  t1231 = 0.1e1 / t467 / t76;
  t1232 = t469 * t185;
  t1235 = t468 * t185;
  t1238 = t73 * t1061;
  t1241 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t356 - 0.6e1 * t1238);
  t1245 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1232 + 0.4e1 / 0.3e1 * t1235 * t475 + 0.4e1 / 0.3e1 * t78 * t1241);
  t1246 = t1245 * t27;
  t1250 = t479 * t129;
  t1252 = t6 * t1250 * t111;
  t1254 = t188 * t377;
  t1256 = t6 * t1254 * t111;
  t1258 = t80 * t1092;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t111;
  t1263 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t111 - 0.3e1 / 0.8e1 * t1252 + t1256 / 0.4e1 - t1261);
  tv3rho30 = 0.3e1 * t466 + 0.3e1 * t493 + t7 * (t1229 + t1263);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1266 = 0.2e1 * t519;
  t1267 = 0.2e1 * t545;
  t1268 = t1053 * t202;
  t1271 = t351 * t500;
  t1276 = 0.2e1 * t356;
  t1277 = 0.6e1 * t1062;
  t1279 = my_piecewise5(t11, 0, t15, 0, t1276 - t1277);
  t1283 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1268 * t352 + 0.8e1 / 0.9e1 * t1271 * t120 + 0.4e1 / 0.9e1 * t496 * t360 + 0.4e1 / 0.3e1 * t24 * t1279);
  t1284 = t1283 * t27;
  t1288 = t504 * t129;
  t1291 = t6 * t1288 * t67 / 0.4e1;
  t1295 = t205 * t377;
  t1297 = t6 * t1295 * t67;
  t1301 = t6 * t509 * t177 / 0.4e1;
  t1310 = -0.3e1 / 0.8e1 * t6 * t1284 * t67 - t1291 - 0.3e1 / 0.4e1 * t6 * t505 * t177 + t1297 / 0.12e2 - t1301 - 0.3e1 / 0.8e1 * t6 * t206 * t461 - t1076 / 0.8e1 + t1083 / 0.6e1 - t1086 / 0.4e1 - t1096 + t1098 / 0.6e1 - t1101 / 0.8e1;
  t1311 = my_piecewise3(t2, 0, t1310);
  t1312 = t1231 * t213;
  t1315 = t468 * t524;
  t1320 = 0.6e1 * t1238;
  t1322 = my_piecewise5(t15, 0, t11, 0, -t1276 - t1320);
  t1326 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1312 * t469 + 0.8e1 / 0.9e1 * t1315 * t185 + 0.4e1 / 0.9e1 * t520 * t475 + 0.4e1 / 0.3e1 * t78 * t1322);
  t1327 = t1326 * t27;
  t1331 = t528 * t129;
  t1334 = t6 * t1331 * t111 / 0.4e1;
  t1335 = t216 * t377;
  t1337 = t6 * t1335 * t111;
  t1346 = t6 * t484 * t264 / 0.4e1;
  t1348 = t6 * t488 * t264;
  t1351 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t111 - t1334 + t1337 / 0.12e2 - t1252 / 0.8e1 + t1256 / 0.6e1 - t1261 - 0.3e1 / 0.8e1 * t6 * t480 * t264 - t1346 + t1348 / 0.12e2);
  tv3rho31 = t466 + t493 + t1266 + t1267 + t7 * (t1311 + t1351);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1354 = t1053 * t550;
  t1359 = t351 * t555;
  t1363 = my_piecewise5(t11, 0, t15, 0, -t1276 - t1277);
  t1367 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1354 * t120 + 0.8e1 / 0.9e1 * t496 * t500 + 0.4e1 / 0.9e1 * t1359 * t120 + 0.4e1 / 0.3e1 * t24 * t1363);
  t1368 = t1367 * t27;
  t1372 = t559 * t129;
  t1374 = t6 * t1372 * t67;
  t1383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t67 - t1374 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t177 - t1291 + t1297 / 0.6e1 - t1301 + t1083 / 0.12e2 - t1096 + t1098 / 0.12e2);
  t1384 = t1231 * t567;
  t1389 = t468 * t572;
  t1393 = my_piecewise5(t15, 0, t11, 0, t1276 - t1320);
  t1397 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1384 * t185 + 0.8e1 / 0.9e1 * t520 * t524 + 0.4e1 / 0.9e1 * t1389 * t185 + 0.4e1 / 0.3e1 * t78 * t1393);
  t1398 = t1397 * t27;
  t1402 = t576 * t129;
  t1404 = t6 * t1402 * t111;
  t1411 = t6 * t533 * t264;
  t1419 = t6 * t193 * t662;
  t1421 = -0.3e1 / 0.8e1 * t6 * t1398 * t111 - t1404 / 0.8e1 - t1334 + t1337 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t264 - t1411 / 0.4e1 + t1256 / 0.12e2 - t1261 - t1346 + t1348 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t662 - t1419 / 0.8e1;
  t1422 = my_piecewise3(t72, 0, t1421);
  tv3rho32 = t1266 + t1267 + t566 + t667 + t7 * (t1383 + t1422);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1427 = t550 * t202;
  t1434 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t356 - 0.6e1 * t1062);
  t1438 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1427 + 0.4e1 / 0.3e1 * t496 * t555 + 0.4e1 / 0.3e1 * t24 * t1434);
  t1439 = t1438 * t27;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t67 - 0.3e1 / 0.8e1 * t1374 + t1297 / 0.4e1 - t1096);
  t1447 = t567 * t213;
  t1454 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t356 - 0.6e1 * t1238);
  t1458 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1447 + 0.4e1 / 0.3e1 * t520 * t572 + 0.4e1 / 0.3e1 * t78 * t1454);
  t1459 = t1458 * t27;
  t1484 = 0.1e1 / t83 / t586;
  t1490 = 0.1e1 / t84 / t987;
  t1491 = sigma[2] * t1490;
  t1495 = t586 * t586;
  t1497 = 0.1e1 / t83 / t1495;
  t1502 = t1495 * t221;
  t1503 = 0.1e1 / t1502;
  t1505 = t236 * t236;
  t1507 = 0.1e1 / t237 / t1505;
  t1511 = -0.28e3 / 0.27e2 * t43 * t88 * t1484 * t92 - 0.952e3 / 0.27e2 * t43 * t1491 * t238 + 0.592e3 / 0.27e2 * t43 * t316 * t1497 * t629 - 0.64e2 / 0.9e1 * t43 * t1003 * t1503 * t1507;
  t1512 = t230 * t1511;
  t1519 = -0.1232e4 / 0.27e2 * t1491 + 0.44e3 / 0.27e2 * lapl[1] * t588;
  t1520 = t1519 * t101;
  t1527 = 0.1e1 / t83;
  t1530 = 0.2e1 * t1520 * t85 + 0.16e2 * t650 * t97 + 0.8e2 / 0.3e1 * t254 * t84 + 0.16e3 / 0.27e2 * t102 * t1527;
  t1531 = t249 * t1530;
  t1541 = t639 * t242;
  t1542 = t1541 * t641;
  t1543 = t609 * t1542;
  t1547 = t639 * t259 * t657;
  t1548 = t778 * t1547;
  t1551 = t228 * t228;
  t1552 = 0.1e1 / t1551;
  t1553 = t1552 * t106;
  t1554 = t602 * t242;
  t1555 = t1553 * t1554;
  t1559 = t248 * t602;
  t1560 = t1559 * t259;
  t1561 = t786 * t1560;
  t1564 = t774 * t633;
  t1565 = t786 * t1564;
  t1568 = t248 * t633;
  t1569 = t1568 * t259;
  t1570 = t609 * t1569;
  t1573 = t610 * t657;
  t1574 = t609 * t1573;
  t1577 = t247 * t247;
  t1578 = 0.1e1 / t1577;
  t1579 = t96 * t1578;
  t1580 = t641 * t259;
  t1581 = t1579 * t1580;
  t1588 = t223 * t229;
  t1589 = t1588 * t611;
  t1595 = -0.176e3 / 0.27e2 * t36 * t589 * t260 + 0.16e2 / 0.9e1 * t36 * t224 * t634 + 0.16e2 / 0.9e1 * t36 * t224 * t658 - 0.2e1 / 0.9e1 * t36 * t87 * t1512 - 0.2e1 / 0.9e1 * t36 * t87 * t1531 - 0.2464e4 / 0.243e3 * t36 * t1491 * t107 - 0.176e3 / 0.27e2 * t36 * t589 * t243 - 0.4e1 / 0.3e1 * t608 * t1543 + 0.4e1 / 0.3e1 * t608 * t1548 - 0.4e1 / 0.3e1 * t36 * t87 * t1555 - 0.4e1 / 0.3e1 * t608 * t1561 + 0.4e1 / 0.3e1 * t608 * t1565 + 0.2e1 / 0.3e1 * t608 * t1570 + 0.2e1 / 0.3e1 * t608 * t1574 - 0.4e1 / 0.3e1 * t36 * t87 * t1581 - 0.32e2 / 0.9e1 * t36 * t224 * t603 - 0.32e2 / 0.9e1 * t608 * t1589 - 0.32e2 / 0.9e1 * t36 * t224 * t642;
  t1600 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t111 - 0.3e1 / 0.8e1 * t1404 - 0.9e1 / 0.8e1 * t6 * t577 * t264 + t1337 / 0.4e1 - 0.3e1 / 0.4e1 * t1411 - 0.9e1 / 0.8e1 * t6 * t217 * t662 - t1261 + t1348 / 0.4e1 - 0.3e1 / 0.8e1 * t1419 - 0.3e1 / 0.8e1 * t6 * t81 * t1595);
  tv3rho33 = 0.3e1 * t566 + 0.3e1 * t667 + t7 * (t1446 + t1600);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1608 = t6 * t369 * t297;
  t1615 = t6 * t378 * t297 / 0.12e2;
  t1617 = t6 * t130 * t745;
  t1623 = t692 * t161;
  t1624 = t283 * t155;
  t1625 = t1624 * t172;
  t1629 = t408 * t438;
  t1630 = t292 * t155;
  t1631 = t1630 * t172;
  t1635 = t438 * t740;
  t1636 = t1635 * t172;
  t1637 = t684 * t1636;
  t1640 = t730 * t456;
  t1641 = t684 * t1640;
  t1644 = t161 * t717;
  t1645 = t1644 * t172;
  t1646 = t408 * t1645;
  t1649 = t698 * t456;
  t1650 = t408 * t1649;
  t1653 = t1217 * t726;
  t1656 = t136 * t52;
  t1657 = t1656 * t731;
  t1660 = t161 * t740;
  t1661 = t1660 * t155;
  t1662 = t408 * t1661;
  t1665 = t725 * t432;
  t1666 = t408 * t1665;
  t1669 = t136 * t399;
  t1670 = t1669 * t694;
  t1673 = t1217 * t699;
  t1676 = t62 * t717;
  t1677 = t1676 * t155;
  t1678 = t692 * t1677;
  t1681 = t693 * t432;
  t1682 = t692 * t1681;
  t1688 = 0.176e3 / 0.81e2 * t272 * t34 * t387 * t63 - 0.8e1 / 0.9e1 * t407 * t1623 * t1625 - 0.8e1 / 0.9e1 * t407 * t1629 * t1631 + 0.8e1 / 0.9e1 * t407 * t1637 + 0.4e1 / 0.9e1 * t407 * t1641 + 0.4e1 / 0.9e1 * t407 * t1646 + 0.2e1 / 0.9e1 * t407 * t1650 - 0.32e2 / 0.27e2 * t407 * t1653 - 0.64e2 / 0.27e2 * t407 * t1657 + 0.4e1 / 0.9e1 * t407 * t1662 + 0.2e1 / 0.9e1 * t407 * t1666 - 0.64e2 / 0.27e2 * t407 * t1670 - 0.32e2 / 0.27e2 * t407 * t1673 + 0.8e1 / 0.9e1 * t407 * t1678 + 0.4e1 / 0.9e1 * t407 * t1682 + 0.32e2 / 0.27e2 * t36 * t137 * t741;
  t1689 = t448 * t288;
  t1696 = -0.2e1 * t1689 * t40 - 0.32e2 / 0.3e1 * t735 * t53 - 0.8e2 / 0.9e1 * t289 * t39;
  t1697 = t162 * t1696;
  t1713 = t425 * t428;
  t1717 = t1149 * t37;
  t1719 = 0.1e1 / t1717 * t1161;
  t1723 = 0.14e2 / 0.9e1 * t43 * t276 * t415 * t48 + 0.74e2 / 0.9e1 * t43 * t387 * t151 - 0.62e2 / 0.9e1 * t43 * t1713 * sigma[0] + 0.8e1 / 0.3e1 * t43 * t1719 * t287;
  t1724 = t143 * t1723;
  t1740 = t62 * t432;
  t1744 = t161 * t456;
  t1748 = t62 * t401;
  t1752 = t438 * t440;
  t1756 = t438 * t283;
  t1757 = t1756 * t440;
  t1758 = t408 * t1757;
  t1761 = t725 * t401;
  t1762 = t692 * t1761;
  t1765 = t1202 * t292;
  t1766 = t1765 * t440;
  t1767 = t684 * t1766;
  t1770 = t41 * t1176;
  t1771 = t693 * t401;
  t1772 = t1770 * t1771;
  t1775 = -0.2e1 / 0.9e1 * t36 * t42 * t1697 + 0.4e1 / 0.9e1 * t36 * t411 + 0.32e2 / 0.27e2 * t36 * t137 * t718 - 0.2e1 / 0.9e1 * t36 * t42 * t1724 - 0.176e3 / 0.81e2 * t36 * t388 * t293 - 0.176e3 / 0.81e2 * t36 * t388 * t284 + 0.32e2 / 0.27e2 * t36 * t1217 * t680 + 0.32e2 / 0.27e2 * t36 * t1656 * t685 - 0.2e1 / 0.9e1 * t36 * t408 * t1740 - 0.2e1 / 0.9e1 * t36 * t684 * t1744 + 0.4e1 / 0.9e1 * t36 * t692 * t1748 + 0.4e1 / 0.9e1 * t36 * t684 * t1752 - 0.4e1 / 0.9e1 * t407 * t1758 - 0.4e1 / 0.9e1 * t407 * t1762 - 0.4e1 / 0.3e1 * t407 * t1767 - 0.4e1 / 0.3e1 * t407 * t1772;
  t1776 = t1688 + t1775;
  t1781 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t297 - t1608 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t745 + t1615 - t1617 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1776);
  tv3rho2sigma0 = t7 * t1781 + 0.2e1 * t750;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1788 = t6 * t484 * t326;
  t1792 = t6 * t488 * t326 / 0.12e2;
  t1794 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t326 - t1788 / 0.4e1 + t1792);
  tv3rho2sigma2 = t7 * t1794 + 0.2e1 * t759;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1800 = t6 * t509 * t297;
  t1808 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t297 - t1800 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t745 - t1608 / 0.8e1 + t1615 - t1617 / 0.8e1);
  tv3rho2sigma3 = t7 * t1808 + t750 + t765;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1814 = t6 * t533 * t326;
  t1821 = t6 * t193 * t839;
  t1824 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t326 - t1814 / 0.8e1 - t1788 / 0.8e1 + t1792 - 0.3e1 / 0.8e1 * t6 * t189 * t839 - t1821 / 0.8e1);
  tv3rho2sigma5 = t7 * t1824 + t759 + t844;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1832 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t297 - t1800 / 0.4e1 + t1615);
  tv3rho2sigma6 = t7 * t1832 + 0.2e1 * t765;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1847 = t786 * t248;
  t1848 = t312 * t242;
  t1849 = t1848 * t259;
  t1853 = t609 * t639;
  t1854 = t321 * t242;
  t1855 = t1854 * t259;
  t1862 = t649 * t317;
  t1869 = -0.2e1 * t1862 * t85 - 0.32e2 / 0.3e1 * t829 * t97 - 0.8e2 / 0.9e1 * t318 * t84;
  t1870 = t249 * t1869;
  t1886 = t626 * t629;
  t1890 = t1495 * t82;
  t1892 = 0.1e1 / t1890 * t1507;
  t1896 = 0.14e2 / 0.9e1 * t43 * t305 * t616 * t92 + 0.74e2 / 0.9e1 * t43 * t588 * t238 - 0.62e2 / 0.9e1 * t43 * t1886 * sigma[2] + 0.8e1 / 0.3e1 * t43 * t1892 * t316;
  t1897 = t230 * t1896;
  t1904 = t639 * t312;
  t1905 = t1904 * t641;
  t1906 = t609 * t1905;
  t1909 = t819 * t602;
  t1910 = t786 * t1909;
  t1913 = t223 * t600;
  t1914 = t1913 * t788;
  t1917 = t1588 * t793;
  t1920 = t106 * t811;
  t1921 = t1920 * t242;
  t1922 = t786 * t1921;
  t1925 = t787 * t633;
  t1926 = t786 * t1925;
  t1929 = t248 * t811;
  t1930 = t1929 * t259;
  t1931 = t609 * t1930;
  t1934 = 0.176e3 / 0.81e2 * t272 * t34 * t588 * t107 - 0.8e1 / 0.9e1 * t608 * t1847 * t1849 - 0.8e1 / 0.9e1 * t608 * t1853 * t1855 + 0.32e2 / 0.27e2 * t36 * t224 * t835 - 0.2e1 / 0.9e1 * t36 * t87 * t1870 + 0.4e1 / 0.9e1 * t36 * t612 + 0.32e2 / 0.27e2 * t36 * t224 * t812 - 0.2e1 / 0.9e1 * t36 * t87 * t1897 - 0.176e3 / 0.81e2 * t36 * t589 * t313 - 0.4e1 / 0.9e1 * t608 * t1906 - 0.4e1 / 0.9e1 * t608 * t1910 - 0.64e2 / 0.27e2 * t608 * t1914 - 0.32e2 / 0.27e2 * t608 * t1917 + 0.8e1 / 0.9e1 * t608 * t1922 + 0.4e1 / 0.9e1 * t608 * t1926 + 0.4e1 / 0.9e1 * t608 * t1931;
  t1935 = t792 * t657;
  t1936 = t609 * t1935;
  t1939 = t1588 * t820;
  t1942 = t223 * t96;
  t1943 = t1942 * t825;
  t1946 = t248 * t834;
  t1947 = t1946 * t242;
  t1948 = t609 * t1947;
  t1951 = t819 * t633;
  t1952 = t609 * t1951;
  t1955 = t639 * t834;
  t1956 = t1955 * t259;
  t1957 = t778 * t1956;
  t1960 = t824 * t657;
  t1961 = t778 * t1960;
  t1964 = t1578 * t321;
  t1965 = t1964 * t641;
  t1966 = t778 * t1965;
  t1969 = t86 * t1552;
  t1970 = t787 * t602;
  t1971 = t1969 * t1970;
  t1983 = t106 * t633;
  t1987 = t248 * t657;
  t1991 = t106 * t602;
  t1995 = t639 * t641;
  t1999 = 0.2e1 / 0.9e1 * t608 * t1936 - 0.32e2 / 0.27e2 * t608 * t1939 - 0.64e2 / 0.27e2 * t608 * t1943 + 0.4e1 / 0.9e1 * t608 * t1948 + 0.2e1 / 0.9e1 * t608 * t1952 + 0.8e1 / 0.9e1 * t608 * t1957 + 0.4e1 / 0.9e1 * t608 * t1961 - 0.4e1 / 0.3e1 * t608 * t1966 - 0.4e1 / 0.3e1 * t608 * t1971 - 0.176e3 / 0.81e2 * t36 * t589 * t322 + 0.32e2 / 0.27e2 * t36 * t1588 * t774 + 0.32e2 / 0.27e2 * t36 * t1942 * t779 - 0.2e1 / 0.9e1 * t36 * t609 * t1983 - 0.2e1 / 0.9e1 * t36 * t778 * t1987 + 0.4e1 / 0.9e1 * t36 * t786 * t1991 + 0.4e1 / 0.9e1 * t36 * t778 * t1995;
  t2000 = t1934 + t1999;
  t2005 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t326 - t1814 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t839 + t1792 - t1821 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t2000);
  tv3rho2sigma8 = t7 * t2005 + 0.2e1 * t844;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2008 = t861 * t432;
  t2009 = t860 * t2008;
  t2012 = t439 * t456;
  t2013 = t860 * t2012;
  t2015 = t846 * t850;
  t2016 = t2015 * t336;
  t2020 = t846 * t858;
  t2024 = t377 * params->beta;
  t2025 = t331 * t2024;
  t2027 = t2025 * t336 / 0.9e1;
  t2028 = t851 * t855;
  t2030 = t850 * t33;
  t2031 = t331 * t2030;
  t2032 = t2031 * t863;
  t2034 = t2031 * t867;
  t2037 = t35 * t1656 * t161;
  t2040 = t273 * t862;
  t2043 = t273 * t866;
  t2046 = t5 * t364;
  t2047 = t2046 * t332;
  t2050 = t1203 * t440;
  t2051 = t860 * t2050;
  t2054 = t399 * t161;
  t2055 = t2054 * t401;
  t2056 = t860 * t2055;
  t2058 = t860 * t142;
  t2059 = t1170 * t172;
  t2060 = t2058 * t2059;
  t2063 = t859 * t2009 / 0.2e1 + t859 * t2013 - t2016 / 0.3e1 + 0.5e1 / 0.3e1 * t847 * t855 + t2020 * t863 + 0.2e1 * t2020 * t867 + t2027 + 0.5e1 / 0.9e1 * t2028 + t2032 / 0.3e1 + 0.2e1 / 0.3e1 * t2034 - 0.2e2 / 0.9e1 * t333 * t2037 - 0.5e1 / 0.3e1 * t859 * t2040 - 0.1e2 / 0.3e1 * t859 * t2043 - t2047 * t336 / 0.2e1 - 0.3e1 * t859 * t2051 - t859 * t2056 - 0.2e1 * t859 * t2060;
  t2064 = my_piecewise3(t2, 0, t2063);
  tv3rho2lapl0 = t7 * t2064 + 0.2e1 * t870;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2067 = t5 * t479;
  t2068 = t2067 * t332;
  t2071 = t872 * t850;
  t2072 = t2071 * t344;
  t2074 = t340 * t2024;
  t2076 = t2074 * t344 / 0.9e1;
  t2078 = my_piecewise3(t72, 0, -t2068 * t344 / 0.2e1 - t2072 / 0.3e1 + t2076);
  tv3rho2lapl1 = t7 * t2078 + 0.2e1 * t880;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2080 = t5 * t504;
  t2081 = t2080 * t332;
  t2084 = t882 * t850;
  t2085 = t2084 * t336;
  t2089 = t882 * t858;
  t2098 = my_piecewise3(t2, 0, -t2081 * t336 / 0.2e1 - t2085 / 0.6e1 + 0.5e1 / 0.6e1 * t883 * t855 + t2089 * t863 / 0.2e1 + t2089 * t867 - t2016 / 0.6e1 + t2027 + 0.5e1 / 0.18e2 * t2028 + t2032 / 0.6e1 + t2034 / 0.3e1);
  tv3rho2lapl2 = t7 * t2098 + t870 + t887;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2100 = t5 * t528;
  t2101 = t2100 * t332;
  t2104 = t889 * t850;
  t2105 = t2104 * t344;
  t2110 = t876 * t894;
  t2112 = t872 * t858;
  t2115 = t340 * t2030;
  t2116 = t2115 * t901;
  t2119 = t2115 * t905;
  t2122 = my_piecewise3(t72, 0, -t2101 * t344 / 0.2e1 - t2105 / 0.6e1 - t2072 / 0.6e1 + t2076 + 0.5e1 / 0.6e1 * t873 * t894 + 0.5e1 / 0.18e2 * t2110 + t2112 * t901 / 0.2e1 + t2116 / 0.6e1 + t2112 * t905 + t2119 / 0.3e1);
  tv3rho2lapl3 = t7 * t2122 + t880 + t908;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2125 = t5 * t559;
  t2126 = t2125 * t332;
  t2131 = my_piecewise3(t2, 0, -t2126 * t336 / 0.2e1 - t2085 / 0.3e1 + t2027);
  tv3rho2lapl4 = t7 * t2131 + 0.2e1 * t887;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2134 = t302 * t900;
  t2137 = t302 * t904;
  t2140 = t899 * t633;
  t2141 = t898 * t2140;
  t2144 = t640 * t657;
  t2145 = t898 * t2144;
  t2149 = t889 * t858;
  t2154 = t35 * t1942 * t248;
  t2159 = t5 * t576;
  t2160 = t2159 * t332;
  t2163 = t898 * t229;
  t2164 = t1541 * t259;
  t2165 = t2163 * t2164;
  t2168 = t1579 * t641;
  t2169 = t898 * t2168;
  t2173 = t600 * t248;
  t2174 = t2173 * t602;
  t2175 = t898 * t2174;
  t2178 = -0.5e1 / 0.3e1 * t897 * t2134 - 0.1e2 / 0.3e1 * t897 * t2137 + t897 * t2141 / 0.2e1 + t897 * t2145 + 0.5e1 / 0.3e1 * t890 * t894 + t2149 * t901 + 0.2e1 * t2149 * t905 - 0.2e2 / 0.9e1 * t341 * t2154 - t2105 / 0.3e1 + 0.5e1 / 0.9e1 * t2110 + t2076 - t2160 * t344 / 0.2e1 - 0.2e1 * t897 * t2165 - 0.3e1 * t897 * t2169 + 0.2e1 / 0.3e1 * t2119 - t897 * t2175 + t2116 / 0.3e1;
  t2179 = my_piecewise3(t72, 0, t2178);
  tv3rho2lapl5 = t7 * t2179 + 0.2e1 * t908;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2186 = t6 * t130 * t959 / 0.8e1;
  t2187 = t283 * t292;
  t2188 = t2187 * t155;
  t2192 = t2187 * t172;
  t2226 = t1149 * rho[0];
  t2228 = 0.1e1 / t2226 * t1161;
  t2231 = t43 * t926 * t145 * t48 / 0.3e1 - t43 * t57 * t136 * t151 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t713 - t43 * t2228 * sigma[0];
  t2232 = t143 * t2231;
  t2236 = t166 * t950;
  t2241 = 0.4e1 * t2236 * t40 + 0.32e2 / 0.3e1 * t951 * t53;
  t2242 = t162 * t2241;
  t2246 = t438 * t944;
  t2247 = t2246 * t155;
  t2248 = t408 * t2247;
  t2251 = t1202 * t944;
  t2252 = t2251 * t172;
  t2253 = t684 * t2252;
  t2256 = -0.8e1 / 0.9e1 * t407 * t1623 * t2188 - 0.8e1 / 0.9e1 * t407 * t1629 * t2192 - 0.32e2 / 0.27e2 * t36 * t137 * t945 + 0.16e2 / 0.27e2 * t36 * t137 * t955 - 0.32e2 / 0.27e2 * t36 * t137 * t917 + 0.16e2 / 0.27e2 * t36 * t137 * t940 + 0.8e1 / 0.9e1 * t36 * t695 + 0.4e1 / 0.9e1 * t36 * t700 + 0.4e1 / 0.9e1 * t36 * t727 + 0.8e1 / 0.9e1 * t36 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t2232 - 0.2e1 / 0.9e1 * t36 * t42 * t2242 - 0.4e1 / 0.9e1 * t407 * t2248 - 0.4e1 / 0.3e1 * t407 * t2253;
  t2257 = t730 * t740;
  t2258 = t684 * t2257;
  t2261 = t161 * t954;
  t2262 = t2261 * t155;
  t2263 = t408 * t2262;
  t2266 = t438 * t954;
  t2267 = t2266 * t172;
  t2268 = t684 * t2267;
  t2271 = t62 * t916;
  t2272 = t2271 * t155;
  t2273 = t1770 * t2272;
  t2276 = t161 * t916;
  t2277 = t2276 * t172;
  t2278 = t692 * t2277;
  t2281 = t693 * t717;
  t2282 = t692 * t2281;
  t2285 = t1644 * t292;
  t2286 = t408 * t2285;
  t2289 = t698 * t740;
  t2290 = t408 * t2289;
  t2293 = t62 * t939;
  t2294 = t2293 * t155;
  t2295 = t692 * t2294;
  t2298 = t161 * t939;
  t2299 = t2298 * t172;
  t2300 = t408 * t2299;
  t2303 = t1217 * t921;
  t2318 = 0.8e1 / 0.9e1 * t407 * t2258 + 0.2e1 / 0.9e1 * t407 * t2263 + 0.4e1 / 0.9e1 * t407 * t2268 - 0.4e1 / 0.3e1 * t407 * t2273 - 0.4e1 / 0.9e1 * t407 * t2278 + 0.8e1 / 0.9e1 * t407 * t2282 + 0.4e1 / 0.9e1 * t407 * t2286 + 0.4e1 / 0.9e1 * t407 * t2290 + 0.4e1 / 0.9e1 * t407 * t2295 + 0.2e1 / 0.9e1 * t407 * t2300 - 0.32e2 / 0.27e2 * t407 * t2303 - 0.4e1 / 0.9e1 * t36 * t408 * t1676 - 0.4e1 / 0.9e1 * t36 * t684 * t1660 + 0.32e2 / 0.27e2 * t36 * t1656 * t725 + 0.32e2 / 0.27e2 * t36 * t1217 * t693;
  t2319 = t2256 + t2318;
  t2324 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t959 - t2186 - 0.3e1 / 0.8e1 * t6 * t28 * t2319);
  tv3rhosigma20 = t7 * t2324 + t963;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2331 = t6 * t193 * t1013 / 0.8e1;
  t2333 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t1013 - t2331);
  tv3rhosigma25 = t7 * t2333 + t1017;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2339 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t959 - t2186);
  tv3rhosigma26 = t7 * t2339 + t963;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2344 = t312 * t321;
  t2345 = t2344 * t242;
  t2349 = t2344 * t259;
  t2353 = t253 * t1004;
  t2358 = 0.4e1 * t2353 * t85 + 0.32e2 / 0.3e1 * t1005 * t97;
  t2359 = t249 * t2358;
  t2393 = t1495 * rho[1];
  t2395 = 0.1e1 / t2393 * t1507;
  t2398 = t43 * t980 * t232 * t92 / 0.3e1 - t43 * t101 * t223 * t238 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t807 - t43 * t2395 * sigma[2];
  t2399 = t230 * t2398;
  t2403 = t248 * t970;
  t2404 = t2403 * t259;
  t2405 = t786 * t2404;
  t2408 = t787 * t811;
  t2409 = t786 * t2408;
  t2412 = -0.8e1 / 0.9e1 * t608 * t1847 * t2345 - 0.8e1 / 0.9e1 * t608 * t1853 * t2349 - 0.2e1 / 0.9e1 * t36 * t87 * t2359 + 0.8e1 / 0.9e1 * t36 * t789 + 0.4e1 / 0.9e1 * t36 * t794 + 0.4e1 / 0.9e1 * t36 * t821 + 0.8e1 / 0.9e1 * t36 * t826 + 0.16e2 / 0.27e2 * t36 * t224 * t994 - 0.32e2 / 0.27e2 * t36 * t224 * t999 + 0.16e2 / 0.27e2 * t36 * t224 * t1009 - 0.32e2 / 0.27e2 * t36 * t224 * t971 - 0.2e1 / 0.9e1 * t36 * t87 * t2399 - 0.4e1 / 0.9e1 * t608 * t2405 + 0.8e1 / 0.9e1 * t608 * t2409;
  t2413 = t1929 * t321;
  t2414 = t609 * t2413;
  t2417 = t1588 * t975;
  t2420 = t792 * t834;
  t2421 = t609 * t2420;
  t2424 = t106 * t993;
  t2425 = t2424 * t242;
  t2426 = t786 * t2425;
  t2429 = t248 * t993;
  t2430 = t2429 * t259;
  t2431 = t609 * t2430;
  t2434 = t639 * t998;
  t2435 = t2434 * t242;
  t2436 = t609 * t2435;
  t2439 = t1578 * t998;
  t2440 = t2439 * t259;
  t2441 = t778 * t2440;
  t2444 = t824 * t834;
  t2445 = t778 * t2444;
  t2448 = t248 * t1008;
  t2449 = t2448 * t242;
  t2450 = t609 * t2449;
  t2453 = t639 * t1008;
  t2454 = t2453 * t259;
  t2455 = t778 * t2454;
  t2458 = t106 * t970;
  t2459 = t2458 * t242;
  t2460 = t1969 * t2459;
  t2475 = 0.4e1 / 0.9e1 * t608 * t2414 - 0.32e2 / 0.27e2 * t608 * t2417 + 0.4e1 / 0.9e1 * t608 * t2421 + 0.4e1 / 0.9e1 * t608 * t2426 + 0.2e1 / 0.9e1 * t608 * t2431 - 0.4e1 / 0.9e1 * t608 * t2436 - 0.4e1 / 0.3e1 * t608 * t2441 + 0.8e1 / 0.9e1 * t608 * t2445 + 0.2e1 / 0.9e1 * t608 * t2450 + 0.4e1 / 0.9e1 * t608 * t2455 - 0.4e1 / 0.3e1 * t608 * t2460 - 0.4e1 / 0.9e1 * t36 * t609 * t1920 - 0.4e1 / 0.9e1 * t36 * t778 * t1946 + 0.32e2 / 0.27e2 * t36 * t1588 * t787 + 0.32e2 / 0.27e2 * t36 * t1942 * t819;
  t2476 = t2412 + t2475;
  t2481 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t1013 - t2331 - 0.3e1 / 0.8e1 * t6 * t81 * t2476);
  tv3rhosigma211 = t7 * t2481 + t1017;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2486 = t2031 * t1019 / 0.6e1;
  t2487 = t273 * t1018;
  t2490 = t860 * t399;
  t2491 = t698 * t155;
  t2492 = t2490 * t2491;
  t2494 = t1756 * t172;
  t2495 = t2058 * t2494;
  t2497 = t861 * t717;
  t2498 = t860 * t2497;
  t2503 = t2031 * t1023 / 0.3e1;
  t2504 = t273 * t1022;
  t2507 = t730 * t155;
  t2508 = t2058 * t2507;
  t2510 = t860 * t52;
  t2511 = t1765 * t172;
  t2512 = t2510 * t2511;
  t2515 = t439 * t740;
  t2516 = t860 * t2515;
  t2518 = t2020 * t1019 / 0.2e1 + t2486 - 0.5e1 / 0.6e1 * t859 * t2487 - t859 * t2492 - t859 * t2495 + t859 * t2498 / 0.2e1 + t2020 * t1023 + t2503 - 0.5e1 / 0.3e1 * t859 * t2504 - t859 * t2508 - 0.3e1 * t859 * t2512 + t859 * t2516;
  t2519 = my_piecewise3(t2, 0, t2518);
  tv3rhosigmalapl0 = t7 * t2519 + t1026;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2524 = t2115 * t1028 / 0.6e1;
  t2527 = t2115 * t1032 / 0.3e1;
  t2529 = my_piecewise3(t72, 0, t2112 * t1028 / 0.2e1 + t2524 + t2112 * t1032 + t2527);
  tv3rhosigmalapl5 = t7 * t2529 + t1035;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2535 = my_piecewise3(t2, 0, t2089 * t1019 / 0.2e1 + t2486 + t2089 * t1023 + t2503);
  tv3rhosigmalapl6 = t7 * t2535 + t1026;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2539 = t302 * t1027;
  t2542 = t898 * t600;
  t2543 = t792 * t242;
  t2544 = t2542 * t2543;
  t2546 = t1904 * t259;
  t2547 = t2163 * t2546;
  t2549 = t899 * t811;
  t2550 = t898 * t2549;
  t2554 = t302 * t1031;
  t2557 = t824 * t242;
  t2558 = t2163 * t2557;
  t2560 = t898 * t96;
  t2561 = t1964 * t259;
  t2562 = t2560 * t2561;
  t2565 = t640 * t834;
  t2566 = t898 * t2565;
  t2568 = t2149 * t1028 / 0.2e1 + t2524 - 0.5e1 / 0.6e1 * t897 * t2539 - t897 * t2544 - t897 * t2547 + t897 * t2550 / 0.2e1 + t2149 * t1032 + t2527 - 0.5e1 / 0.3e1 * t897 * t2554 - t897 * t2558 - 0.3e1 * t897 * t2562 + t897 * t2566;
  t2569 = my_piecewise3(t72, 0, t2568);
  tv3rhosigmalapl11 = t7 * t2569 + t1035;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2574 = 0.2e1 / 0.3e1 * t2031 * t1039;
  t2575 = t860 * t1038;
  t2578 = t1037 * t142;
  t2579 = t438 * t57;
  t2580 = t2579 * t155;
  t2581 = t2578 * t2580;
  t2584 = t1037 * t52;
  t2585 = t1202 * t57;
  t2586 = t2585 * t172;
  t2587 = t2584 * t2586;
  t2591 = my_piecewise3(t2, 0, -0.2e1 * t2020 * t1039 - t2574 + 0.4e1 / 0.3e1 * t859 * t2575 + 0.2e1 * t859 * t2581 + 0.6e1 * t859 * t2587);
  tv3rholapl20 = t7 * t2591 + t1042;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2596 = 0.2e1 / 0.3e1 * t2115 * t1046;
  t2598 = my_piecewise3(t72, 0, -0.2e1 * t2112 * t1046 - t2596);
  tv3rholapl22 = t7 * t2598 + t1049;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2603 = my_piecewise3(t2, 0, -0.2e1 * t2089 * t1039 - t2574);
  tv3rholapl23 = t7 * t2603 + t1042;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2607 = t898 * t1045;
  t2610 = t1044 * t229;
  t2611 = t639 * t101;
  t2612 = t2611 * t242;
  t2613 = t2610 * t2612;
  t2616 = t1044 * t96;
  t2617 = t1578 * t101;
  t2618 = t2617 * t259;
  t2619 = t2616 * t2618;
  t2623 = my_piecewise3(t72, 0, -0.2e1 * t2149 * t1046 - t2596 + 0.4e1 / 0.3e1 * t897 * t2607 + 0.2e1 * t897 * t2613 + 0.6e1 * t897 * t2619);
  tv3rholapl25 = t7 * t2623 + t1049;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2631 = t1756 * t944;
  t2632 = t408 * t2631;
  t2639 = 0.1e1 / t44 / t287;
  t2652 = 0.1e1 / t1149;
  t2656 = 0.3e1 / 0.8e1 * t43 * t2639 * t46 * t48 - 0.3e1 / 0.8e1 * t43 * t288 * t41 * t151 - t43 * t57 * t935 * t428 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2652 * t1161;
  t2657 = t143 * t2656;
  t2661 = t287 * t287;
  t2662 = 0.1e1 / t2661;
  t2663 = t56 * t2662;
  t2666 = -0.12e2 * t2663 * t40 + 0.12e2 * t950;
  t2667 = t162 * t2666;
  t2676 = t2298 * t292;
  t2677 = t408 * t2676;
  t2680 = t698 * t954;
  t2681 = t408 * t2680;
  t2684 = t944 * t292;
  t2685 = t1203 * t2684;
  t2689 = t730 * t954;
  t2690 = t684 * t2689;
  t2693 = t916 * t283;
  t2694 = t1177 * t2693;
  t2698 = t2276 * t292;
  t2699 = t692 * t2698;
  t2702 = t693 * t939;
  t2703 = t692 * t2702;
  t2706 = -0.2e1 / 0.3e1 * t36 * t408 * t2293 - 0.2e1 / 0.3e1 * t36 * t684 * t2261 - 0.4e1 / 0.3e1 * t407 * t2632 + 0.4e1 / 0.3e1 * t36 * t684 * t2246 - 0.2e1 / 0.9e1 * t36 * t42 * t2657 - 0.2e1 / 0.9e1 * t36 * t42 * t2667 + 0.4e1 / 0.3e1 * t36 * t692 * t2271 + 0.4e1 / 0.3e1 * t36 * t922 + 0.2e1 / 0.3e1 * t407 * t2677 + 0.2e1 / 0.3e1 * t407 * t2681 - 0.4e1 / 0.3e1 * t36 * t42 * t2685 + 0.4e1 / 0.3e1 * t407 * t2690 - 0.4e1 / 0.3e1 * t36 * t42 * t2694 - 0.4e1 / 0.3e1 * t407 * t2699 + 0.4e1 / 0.3e1 * t407 * t2703;
  t2710 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t2706);
  tv3sigma30 = t7 * t2710;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2717 = t1904 * t998;
  t2718 = t609 * t2717;
  t2730 = 0.1e1 / t88 / t316;
  t2743 = 0.1e1 / t1495;
  t2747 = 0.3e1 / 0.8e1 * t43 * t2730 * t90 * t92 - 0.3e1 / 0.8e1 * t43 * t317 * t86 * t238 - t43 * t101 * t989 * t629 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2743 * t1507;
  t2748 = t230 * t2747;
  t2752 = t316 * t316;
  t2753 = 0.1e1 / t2752;
  t2754 = t100 * t2753;
  t2757 = -0.12e2 * t2754 * t85 + 0.12e2 * t1004;
  t2758 = t249 * t2757;
  t2762 = t2403 * t321;
  t2763 = t786 * t2762;
  t2766 = t787 * t993;
  t2767 = t786 * t2766;
  t2770 = t2429 * t321;
  t2771 = t609 * t2770;
  t2774 = t792 * t1008;
  t2775 = t609 * t2774;
  t2778 = t998 * t321;
  t2779 = t1579 * t2778;
  t2783 = t824 * t1008;
  t2784 = t778 * t2783;
  t2787 = t970 * t312;
  t2788 = t1553 * t2787;
  t2792 = -0.2e1 / 0.3e1 * t36 * t609 * t2424 - 0.2e1 / 0.3e1 * t36 * t778 * t2448 - 0.4e1 / 0.3e1 * t608 * t2718 + 0.4e1 / 0.3e1 * t36 * t786 * t2458 + 0.4e1 / 0.3e1 * t36 * t976 + 0.4e1 / 0.3e1 * t36 * t778 * t2434 - 0.2e1 / 0.9e1 * t36 * t87 * t2748 - 0.2e1 / 0.9e1 * t36 * t87 * t2758 - 0.4e1 / 0.3e1 * t608 * t2763 + 0.4e1 / 0.3e1 * t608 * t2767 + 0.2e1 / 0.3e1 * t608 * t2771 + 0.2e1 / 0.3e1 * t608 * t2775 - 0.4e1 / 0.3e1 * t36 * t87 * t2779 + 0.4e1 / 0.3e1 * t608 * t2784 - 0.4e1 / 0.3e1 * t36 * t87 * t2788;
  t2796 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t2792);
  tv3sigma39 = t7 * t2796;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2797 = t2054 * t916;
  t2798 = t860 * t2797;
  t2800 = t1756 * t292;
  t2801 = t2058 * t2800;
  t2804 = t861 * t939;
  t2805 = t860 * t2804;
  t2808 = t1203 * t944;
  t2809 = t860 * t2808;
  t2812 = t439 * t954;
  t2813 = t860 * t2812;
  t2816 = my_piecewise3(t2, 0, -t859 * t2798 - 0.2e1 * t859 * t2801 + t859 * t2805 / 0.2e1 - 0.3e1 * t859 * t2809 + t859 * t2813);
  tv3sigma2lapl0 = t7 * t2816;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t2817 = t2173 * t970;
  t2818 = t898 * t2817;
  t2820 = t1904 * t321;
  t2821 = t2163 * t2820;
  t2824 = t899 * t993;
  t2825 = t898 * t2824;
  t2828 = t1579 * t998;
  t2829 = t898 * t2828;
  t2832 = t640 * t1008;
  t2833 = t898 * t2832;
  t2836 = my_piecewise3(t72, 0, -t897 * t2818 - 0.2e1 * t897 * t2821 + t897 * t2825 / 0.2e1 - 0.3e1 * t897 * t2829 + t897 * t2833);
  tv3sigma2lapl11 = t7 * t2836;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t2837 = t2579 * t283;
  t2838 = t2578 * t2837;
  t2841 = t2585 * t292;
  t2842 = t2584 * t2841;
  t2845 = t439 * t288;
  t2846 = t1037 * t2845;
  t2850 = my_piecewise3(t2, 0, 0.2e1 * t859 * t2838 + 0.6e1 * t859 * t2842 + 0.2e1 * t859 * t2846);
  tv3sigmalapl20 = t7 * t2850;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t2851 = t2611 * t312;
  t2852 = t2610 * t2851;
  t2855 = t2617 * t321;
  t2856 = t2616 * t2855;
  t2859 = t640 * t317;
  t2860 = t1044 * t2859;
  t2864 = my_piecewise3(t72, 0, 0.2e1 * t897 * t2852 + 0.6e1 * t897 * t2856 + 0.2e1 * t897 * t2860);
  tv3sigmalapl28 = t7 * t2864;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t2865 = t34 * t38;
  t2866 = t1203 * t288;
  t2867 = t2865 * t2866;
  t2870 = my_piecewise3(t2, 0, -0.12e2 * t859 * t2867);
  tv3lapl30 = t7 * t2870;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t2871 = t34 * t83;
  t2872 = t1579 * t317;
  t2873 = t2871 * t2872;
  t2876 = my_piecewise3(t72, 0, -0.12e2 * t897 * t2873);
  tv3lapl33 = t7 * t2876;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1053, t1054, t1057, t1060, t1061, t1062, t1065, t1069;
  double t1070, t1074, t1076, t1081, t1083, t1086, t1092, t1093;
  double t1096, t1098, t1101, t1104, t1105, t1109, t1110, t1117;
  double t1120, t1121, t1141, t1149, t1151, t1156, t1157, t1159;
  double t1161, t1165, t1166, t1170, t1171, t1172, t1175, t1176;
  double t1177, t1178, t1179, t1183, t1184, t1185, t1188, t1189;
  double t1192, t1193, t1194, t1197, t1198, t1201, t1202, t1203;
  double t1204, t1205, t1210, t1211, t1217, t1218, t1224, t1229;
  double t1231, t1232, t1235, t1238, t1241, t1245, t1246, t1250;
  double t1252, t1254, t1256, t1258, t1261, t1263, tv3rho30, t1266;
  double t1267, t1268, t1271, t1276, t1277, t1279, t1283, t1284;
  double t1288, t1291, t1295, t1297, t1301, t1310, t1311, t1312;
  double t1315, t1320, t1322, t1326, t1327, t1331, t1334, t1335;
  double t1337, t1346, t1348, t1351, tv3rho31, t1354, t1359, t1363;
  double t1367, t1368, t1372, t1374, t1383, t1384, t1389, t1393;
  double t1397, t1398, t1402, t1404, t1411, t1419, t1421, t1422;
  double tv3rho32, t1427, t1434, t1438, t1439, t1446, t1447, t1454;
  double t1458, t1459, t1484, t1490, t1491, t1495, t1497, t1502;
  double t1503, t1505, t1507, t1511, t1512, t1519, t1520, t1527;
  double t1530, t1531, t1541, t1542, t1543, t1547, t1548, t1551;
  double t1552, t1553, t1554, t1555, t1559, t1560, t1561, t1564;
  double t1565, t1568, t1569, t1570, t1573, t1574, t1577, t1578;
  double t1579, t1580, t1581, t1588, t1589, t1595, t1600, tv3rho33;
  double t1608, t1615, t1617, t1623, t1624, t1625, t1629, t1630;
  double t1631, t1635, t1636, t1637, t1640, t1641, t1644, t1645;
  double t1646, t1649, t1650, t1653, t1656, t1657, t1660, t1661;
  double t1662, t1665, t1666, t1669, t1670, t1673, t1676, t1677;
  double t1678, t1681, t1682, t1688, t1689, t1696, t1697, t1713;
  double t1717, t1719, t1723, t1724, t1740, t1744, t1748, t1752;
  double t1756, t1757, t1758, t1761, t1762, t1765, t1766, t1767;
  double t1770, t1771, t1772, t1775, t1776, t1781, tv3rho2sigma0, tv3rho2sigma1;
  double t1788, t1792, t1794, tv3rho2sigma2, t1800, t1808, tv3rho2sigma3, tv3rho2sigma4;
  double t1814, t1821, t1824, tv3rho2sigma5, t1832, tv3rho2sigma6, tv3rho2sigma7, t1847;
  double t1848, t1849, t1853, t1854, t1855, t1862, t1869, t1870;
  double t1886, t1890, t1892, t1896, t1897, t1904, t1905, t1906;
  double t1909, t1910, t1913, t1914, t1917, t1920, t1921, t1922;
  double t1925, t1926, t1929, t1930, t1931, t1934, t1935, t1936;
  double t1939, t1942, t1943, t1946, t1947, t1948, t1951, t1952;
  double t1955, t1956, t1957, t1960, t1961, t1964, t1965, t1966;
  double t1969, t1970, t1971, t1983, t1987, t1991, t1995, t1999;
  double t2000, t2005, tv3rho2sigma8, t2008, t2009, t2012, t2013, t2015;
  double t2016, t2020, t2024, t2025, t2027, t2028, t2030, t2031;
  double t2032, t2034, t2037, t2040, t2043, t2046, t2047, t2050;
  double t2051, t2054, t2055, t2056, t2058, t2059, t2060, t2063;
  double t2064, tv3rho2lapl0, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, tv3rho2lapl1, t2080, t2081, t2084, t2085, t2089, t2098;
  double tv3rho2lapl2, t2100, t2101, t2104, t2105, t2110, t2112, t2115;
  double t2116, t2119, t2122, tv3rho2lapl3, t2125, t2126, t2131, tv3rho2lapl4;
  double t2134, t2137, t2140, t2141, t2144, t2145, t2149, t2154;
  double t2159, t2160, t2163, t2164, t2165, t2168, t2169, t2173;
  double t2174, t2175, t2178, t2179, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2;
  double tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2186, t2187, t2188, t2192, t2226;
  double t2228, t2231, t2232, t2236, t2241, t2242, t2246, t2247;
  double t2248, t2251, t2252, t2253, t2256, t2257, t2258, t2261;
  double t2262, t2263, t2266, t2267, t2268, t2271, t2272, t2273;
  double t2276, t2277, t2278, t2281, t2282, t2285, t2286, t2289;
  double t2290, t2293, t2294, t2295, t2298, t2299, t2300, t2303;
  double t2318, t2319, t2324, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2331, t2333, tv3rhosigma25, t2339, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2344, t2345, t2349, t2353, t2358, t2359, t2393;
  double t2395, t2398, t2399, t2403, t2404, t2405, t2408, t2409;
  double t2412, t2413, t2414, t2417, t2420, t2421, t2424, t2425;
  double t2426, t2429, t2430, t2431, t2434, t2435, t2436, t2439;
  double t2440, t2441, t2444, t2445, t2448, t2449, t2450, t2453;
  double t2454, t2455, t2458, t2459, t2460, t2475, t2476, t2481;
  double tv3rhosigma211, t2486, t2487, t2490, t2491, t2492, t2494, t2495;
  double t2497, t2498, t2503, t2504, t2507, t2508, t2510, t2511;
  double t2512, t2515, t2516, t2518, t2519, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, t2524, t2527, t2529, tv3rhosigmalapl5, t2535, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2539, t2542, t2543, t2544;
  double t2546, t2547, t2549, t2550, t2554, t2557, t2558, t2560;
  double t2561, t2562, t2565, t2566, t2568, t2569, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2574, t2575, t2578, t2579, t2580;
  double t2581, t2584, t2585, t2586, t2587, t2591, tv3rholapl20, tv3rholapl21;
  double t2596, t2598, tv3rholapl22, t2603, tv3rholapl23, tv3rholapl24, t2607, t2610;
  double t2611, t2612, t2613, t2616, t2617, t2618, t2619, t2623;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2631;
  double t2632, t2639, t2652, t2656, t2657, t2661, t2662, t2663;
  double t2666, t2667, t2676, t2677, t2680, t2681, t2684, t2685;
  double t2689, t2690, t2693, t2694, t2698, t2699, t2702, t2703;
  double t2706, t2710, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2717, t2718, t2730, t2743, t2747;
  double t2748, t2752, t2753, t2754, t2757, t2758, t2762, t2763;
  double t2766, t2767, t2770, t2771, t2774, t2775, t2778, t2779;
  double t2783, t2784, t2787, t2788, t2792, t2796, tv3sigma39, t2797;
  double t2798, t2800, t2801, t2804, t2805, t2808, t2809, t2812;
  double t2813, t2816, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t2817, t2818, t2820;
  double t2821, t2824, t2825, t2828, t2829, t2832, t2833, t2836;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t2837, t2838, t2841;
  double t2842, t2845, t2846, t2850, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t2851, t2852, t2855, t2856;
  double t2859, t2860, t2864, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27;
  double tv3sigmatau28, t2865, t2866, t2867, t2870, tv3lapl30, tv3lapl31, tv3lapl32;
  double t2871, t2872, t2873, t2876, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  double t2883, t2885, t2891, t2894, t2897, t2899, t2920, t2936;
  double t2946, t2951, t2961, t2979, t2980, t3000, t3010, t3022;
  double t3070, t3071, t3072, t3077, t3086, t3087, t3088, t3093;
  double t3104, t3109, t3111, t3112, t3118, t3124, t3125, t3128;
  double t3132, t3141, t3145, t3149, t3153, t3156, t3160, t3161;
  double t3162, t3163, t3165, t3166, t3172, t3177, t3180, t3184;
  double t3191, t3195, t3199, t3204, t3206, tv4rho40, t3227, t3228;
  double t3230, t3234, t3243, t3249, t3250, t3252, t3265, t3269;
  double t3270, t3273, t3278, t3279, t3296, t3298, t3302, t3309;
  double t3313, t3314, t3317, t3326, t3329, t3330, t3332, t3334;
  double t3335, tv4rho41, t3344, t3348, t3358, t3371, t3375, t3384;
  double t3400, t3401, t3410, t3423, t3427, t3434, t3438, t3447;
  double t3450, t3461, t3464, t3466, t3467, tv4rho42, t3488, t3492;
  double t3499, t3510, t3511, t3528, t3532, t3539, t3547, t3556;
  double t3566, t3568, t3569, tv4rho43, t3574, t3579, t3586, t3590;
  double t3599, t3606, t3611, t3618, t3622, t3640, t3641, t3642;
  double t3647, t3676, t3686, t3698, t3737, t3738, t3739, t3744;
  double t3749, t3759, t3769, t3774, t3804, t3814, t3824, t3829;
  double t3841, t3848, t3849, tv4rho44, t3857, t3863, t3866, t3873;
  double t3875, t3878, t3957, t3962, t3971, t3972, t3985, t4048;
  double t4053, t4057, t4068, t4073, t4077, t4085, t4100, t4104;
  double t4109, t4113, t4128, t4138, t4139, t4144, t4150, t4174;
  double t4211, t4218, tv4rho3sigma0, tv4rho3sigma1, t4225, t4228, t4232, t4234;
  double tv4rho3sigma2, t4236, t4242, t4247, t4251, t4260, t4261, tv4rho3sigma3;
  double tv4rho3sigma4, t4263, t4269, t4271, t4280, t4282, t4285, tv4rho3sigma5;
  double t4291, t4300, tv4rho3sigma6, tv4rho3sigma7, t4306, t4313, t4321, t4323;
  double t4324, tv4rho3sigma8, t4333, tv4rho3sigma9, tv4rho3sigma10, t4430, t4439, t4440;
  double t4445, t4449, t4458, t4481, t4502, t4518, t4520, t4538;
  double t4543, t4570, t4575, t4581, t4587, t4593, t4603, t4604;
  double t4613, t4618, t4623, t4627, t4681, t4688, tv4rho3sigma11, t4691;
  double t4694, t4695, t4698, t4700, t4707, t4711, t4719, t4724;
  double t4725, t4735, t4736, t4741, t4747, t4752, t4754, t4755;
  double t4756, t4758, t4771, t4772, t4773, t4779, t4781, t4786;
  double t4794, t4800, t4828, t4831, tv4rho3lapl0, t4839, t4842, t4846;
  double t4848, tv4rho3lapl1, t4850, t4860, t4863, t4868, t4875, t4877;
  double t4879, t4882, t4888, t4904, t4906, tv4rho3lapl2, t4908, t4915;
  double t4917, t4924, t4925, t4927, t4930, t4932, t4933, t4934;
  double t4938, t4939, t4941, t4942, tv4rho3lapl3, t4949, t4953, t4962;
  double t4963, tv4rho3lapl4, t4966, t4978, t4980, t4983, t4985, t4986;
  double t4988, t4990, t4991, t4993, t4994, t4996, t4998, t5003;
  double t5016, t5020, t5022, tv4rho3lapl5, t5032, tv4rho3lapl6, t5056, t5082;
  double t5089, t5106, t5107, t5143, t5147, t5150, tv4rho3lapl7, tv4rho3tau0;
  double tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7, t5157;
  double t5164, t5166, t5183, t5194, t5203, t5208, t5217, t5260;
  double t5272, t5291, t5295, t5303, t5318, t5327, t5353, t5356;
  double t5361, t5402, t5467, t5494, t5495, t5500, t5533, t5541;
  double tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t5548, t5552, t5554;
  double tv4rho2sigma25, t5560, t5568, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210;
  double t5574, t5581, t5584, tv4rho2sigma211, t5592, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214;
  double tv4rho2sigma215, tv4rho2sigma216, t5615, t5627, t5632, t5641, t5653, t5660;
  double t5678, t5687, t5699, t5733, t5734, t5741, t5785, t5790;
  double t5818, t5838, t5876, t5886, t5891, t5910, t5969, t5977;
  double tv4rho2sigma217, t5982, t5983, t5985, t5990, t5995, t5996, t5998;
  double t6003, t6008, t6015, t6019, t6031, t6036, t6040, t6042;
  double t6044, t6079, t6084, t6115, t6117, t6119, t6122, tv4rho2sigmalapl0;
  double tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, t6127, t6130, t6132, t6135;
  double t6137, tv4rho2sigmalapl5, t6141, t6154, t6156, t6168, t6170, tv4rho2sigmalapl6;
  double tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t6174, t6179, t6182, t6185;
  double t6189, t6191, t6193, t6198, t6201, t6205, t6207, t6209;
  double t6211, tv4rho2sigmalapl11, t6220, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16;
  double t6224, t6226, t6231, t6257, t6275, t6285, t6317, t6346;
  double t6349, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13;
  double tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t6361, t6362, t6364, t6366;
  double t6381, t6387, t6392, t6398, t6404, t6405, tv4rho2lapl20, tv4rho2lapl21;
  double t6410, t6413, t6415, tv4rho2lapl22, t6419, t6432, tv4rho2lapl23, tv4rho2lapl24;
  double t6436, t6441, t6445, t6449, t6452, tv4rho2lapl25, t6459, tv4rho2lapl26;
  double tv4rho2lapl27, t6489, t6494, t6500, t6508, t6509, tv4rho2lapl28, tv4rho2lapltau0;
  double tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20, tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24;
  double tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28, t6516, t6517, t6522, t6527;
  double t6576, t6589, t6611, t6616, t6625, t6630, t6635, t6644;
  double t6653, t6659, t6672, t6681, t6716, t6786, t6793, tv4rhosigma30;
  double tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38;
  double t6800, t6802, tv4rhosigma39, t6808, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313;
  double tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t6813, t6818, t6829;
  double t6851, t6856, t6865, t6870, t6883, t6930, t6935, t6944;
  double t6949, t6951, t6960, t6969, t7040, t7082, t7089, tv4rhosigma319;
  double t7092, t7096, t7101, t7106, t7127, t7158, t7182, t7184;
  double tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7;
  double tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, t7188, t7192, t7196, t7199, t7202;
  double t7204, tv4rhosigma2lapl11, t7215, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16;
  double tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, t7246, t7299;
  double t7301, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5;
  double tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13;
  double tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21;
  double tv4rhosigma2tau22, tv4rhosigma2tau23, t7306, t7312, t7328, t7332, t7350, t7354;
  double t7359, t7364, t7365, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24;
  double tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t7370, t7374, t7378, t7380, tv4rhosigmalapl28;
  double t7389, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215;
  double tv4rhosigmalapl216, t7398, t7416, t7436, t7441, t7446, t7447, tv4rhosigmalapl217;
  double tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7;
  double tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15;
  double tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23;
  double tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27;
  double tv4rhosigmatau28, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215;
  double tv4rhosigmatau216, tv4rhosigmatau217, t7452, t7456, t7461, t7462, t7468, tv4rholapl30;
  double tv4rholapl31, tv4rholapl32, t7473, t7475, tv4rholapl33, t7480, tv4rholapl34, tv4rholapl35;
  double tv4rholapl36, t7487, t7492, t7493, t7499, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1;
  double tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9;
  double tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25;
  double tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30, tv4rhotau31;
  double tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t7560, t7570;
  double t7575, t7580, t7585, t7640, t7645, tv4sigma40, tv4sigma41, tv4sigma42;
  double tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410;
  double tv4sigma411, tv4sigma412, tv4sigma413, t7705, t7715, t7720, t7725, t7730;
  double t7785, t7790, tv4sigma414, t7831, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3;
  double tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11;
  double tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t7872;
  double tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6;
  double tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14;
  double tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19, t7906, tv4sigma2lapl20, tv4sigma2lapl21;
  double tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29;
  double tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, t7940;
  double tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6;
  double tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14;
  double tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22;
  double tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26;
  double tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214;
  double tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, t7954, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33;
  double tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t7968;
  double tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6;
  double tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14;
  double tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24;
  double tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212;
  double tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32;
  double tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310;
  double tv4sigmatau311, t7974, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, t7980, tv4lapl44;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7;
  double tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27;
  double tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36;
  double tv4lapltau37, tv4tau40, tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t58 * t40 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t951 * t40 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1053 = 0.1e1 / t350 / t20;
  t1054 = t352 * t120;
  t1057 = t351 * t120;
  t1060 = t116 * t116;
  t1061 = 0.1e1 / t1060;
  t1062 = t17 * t1061;
  t1065 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t356 - 0.6e1 * t1062);
  t1069 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1054 + 0.4e1 / 0.3e1 * t1057 * t360 + 0.4e1 / 0.3e1 * t24 * t1065);
  t1070 = t1069 * t27;
  t1074 = t364 * t129;
  t1076 = t6 * t1074 * t67;
  t1081 = t123 * t377;
  t1083 = t6 * t1081 * t67;
  t1086 = t6 * t369 * t177;
  t1092 = 0.1e1 / t128 / t116;
  t1093 = t26 * t1092;
  t1096 = 0.5e1 / 0.36e2 * t6 * t1093 * t67;
  t1098 = t6 * t378 * t177;
  t1101 = t6 * t130 * t461;
  t1104 = 0.1e1 / t39 / t933;
  t1105 = sigma[0] * t1104;
  t1109 = -0.1232e4 / 0.27e2 * t1105 + 0.44e3 / 0.27e2 * lapl[0] * t387;
  t1110 = t1109 * t57;
  t1117 = 0.1e1 / t38;
  t1120 = 0.2e1 * t1110 * t40 + 0.16e2 * t449 * t53 + 0.8e2 / 0.3e1 * t167 * t39 + 0.16e3 / 0.27e2 * t58 * t1117;
  t1121 = t162 * t1120;
  t1141 = 0.1e1 / t38 / t385;
  t1149 = t385 * t385;
  t1151 = 0.1e1 / t38 / t1149;
  t1156 = t1149 * t134;
  t1157 = 0.1e1 / t1156;
  t1159 = t149 * t149;
  t1161 = 0.1e1 / t150 / t1159;
  t1165 = -0.28e3 / 0.27e2 * t43 * t44 * t1141 * t48 - 0.952e3 / 0.27e2 * t43 * t1105 * t151 + 0.592e3 / 0.27e2 * t43 * t287 * t1151 * t428 - 0.64e2 / 0.9e1 * t43 * t949 * t1157 * t1161;
  t1166 = t143 * t1165;
  t1170 = t438 * t155;
  t1171 = t1170 * t440;
  t1172 = t408 * t1171;
  t1175 = t141 * t141;
  t1176 = 0.1e1 / t1175;
  t1177 = t1176 * t62;
  t1178 = t401 * t155;
  t1179 = t1177 * t1178;
  t1183 = t161 * t401;
  t1184 = t1183 * t172;
  t1185 = t692 * t1184;
  t1188 = t680 * t432;
  t1189 = t692 * t1188;
  t1192 = t161 * t432;
  t1193 = t1192 * t172;
  t1194 = t408 * t1193;
  t1197 = t409 * t456;
  t1198 = t408 * t1197;
  t1201 = t160 * t160;
  t1202 = 0.1e1 / t1201;
  t1203 = t52 * t1202;
  t1204 = t440 * t172;
  t1205 = t1203 * t1204;
  t1210 = t438 * t172 * t456;
  t1211 = t684 * t1210;
  t1217 = t136 * t142;
  t1218 = t1217 * t410;
  t1224 = -0.2e1 / 0.9e1 * t36 * t42 * t1121 - 0.2464e4 / 0.243e3 * t36 * t1105 * t63 - 0.176e3 / 0.27e2 * t36 * t388 * t156 - 0.176e3 / 0.27e2 * t36 * t388 * t173 + 0.16e2 / 0.9e1 * t36 * t137 * t433 + 0.16e2 / 0.9e1 * t36 * t137 * t457 - 0.2e1 / 0.9e1 * t36 * t42 * t1166 - 0.4e1 / 0.3e1 * t407 * t1172 - 0.4e1 / 0.3e1 * t36 * t42 * t1179 - 0.4e1 / 0.3e1 * t407 * t1185 + 0.4e1 / 0.3e1 * t407 * t1189 + 0.2e1 / 0.3e1 * t407 * t1194 + 0.2e1 / 0.3e1 * t407 * t1198 - 0.4e1 / 0.3e1 * t36 * t42 * t1205 + 0.4e1 / 0.3e1 * t407 * t1211 - 0.32e2 / 0.9e1 * t36 * t137 * t402 - 0.32e2 / 0.9e1 * t407 * t1218 - 0.32e2 / 0.9e1 * t36 * t137 * t441;
  t1229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t67 - 0.3e1 / 0.8e1 * t1076 - 0.9e1 / 0.8e1 * t6 * t365 * t177 + t1083 / 0.4e1 - 0.3e1 / 0.4e1 * t1086 - 0.9e1 / 0.8e1 * t6 * t124 * t461 - t1096 + t1098 / 0.4e1 - 0.3e1 / 0.8e1 * t1101 - 0.3e1 / 0.8e1 * t6 * t28 * t1224);
  t1231 = 0.1e1 / t467 / t76;
  t1232 = t469 * t185;
  t1235 = t468 * t185;
  t1238 = t73 * t1061;
  t1241 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t356 - 0.6e1 * t1238);
  t1245 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1232 + 0.4e1 / 0.3e1 * t1235 * t475 + 0.4e1 / 0.3e1 * t78 * t1241);
  t1246 = t1245 * t27;
  t1250 = t479 * t129;
  t1252 = t6 * t1250 * t111;
  t1254 = t188 * t377;
  t1256 = t6 * t1254 * t111;
  t1258 = t80 * t1092;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t111;
  t1263 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t111 - 0.3e1 / 0.8e1 * t1252 + t1256 / 0.4e1 - t1261);
  tv3rho30 = 0.3e1 * t466 + 0.3e1 * t493 + t7 * (t1229 + t1263);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1266 = 0.2e1 * t519;
  t1267 = 0.2e1 * t545;
  t1268 = t1053 * t202;
  t1271 = t351 * t500;
  t1276 = 0.2e1 * t356;
  t1277 = 0.6e1 * t1062;
  t1279 = my_piecewise5(t11, 0, t15, 0, t1276 - t1277);
  t1283 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1268 * t352 + 0.8e1 / 0.9e1 * t1271 * t120 + 0.4e1 / 0.9e1 * t496 * t360 + 0.4e1 / 0.3e1 * t24 * t1279);
  t1284 = t1283 * t27;
  t1288 = t504 * t129;
  t1291 = t6 * t1288 * t67 / 0.4e1;
  t1295 = t205 * t377;
  t1297 = t6 * t1295 * t67;
  t1301 = t6 * t509 * t177 / 0.4e1;
  t1310 = -0.3e1 / 0.8e1 * t6 * t1284 * t67 - t1291 - 0.3e1 / 0.4e1 * t6 * t505 * t177 + t1297 / 0.12e2 - t1301 - 0.3e1 / 0.8e1 * t6 * t206 * t461 - t1076 / 0.8e1 + t1083 / 0.6e1 - t1086 / 0.4e1 - t1096 + t1098 / 0.6e1 - t1101 / 0.8e1;
  t1311 = my_piecewise3(t2, 0, t1310);
  t1312 = t1231 * t213;
  t1315 = t468 * t524;
  t1320 = 0.6e1 * t1238;
  t1322 = my_piecewise5(t15, 0, t11, 0, -t1276 - t1320);
  t1326 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1312 * t469 + 0.8e1 / 0.9e1 * t1315 * t185 + 0.4e1 / 0.9e1 * t520 * t475 + 0.4e1 / 0.3e1 * t78 * t1322);
  t1327 = t1326 * t27;
  t1331 = t528 * t129;
  t1334 = t6 * t1331 * t111 / 0.4e1;
  t1335 = t216 * t377;
  t1337 = t6 * t1335 * t111;
  t1346 = t6 * t484 * t264 / 0.4e1;
  t1348 = t6 * t488 * t264;
  t1351 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t111 - t1334 + t1337 / 0.12e2 - t1252 / 0.8e1 + t1256 / 0.6e1 - t1261 - 0.3e1 / 0.8e1 * t6 * t480 * t264 - t1346 + t1348 / 0.12e2);
  tv3rho31 = t466 + t493 + t1266 + t1267 + t7 * (t1311 + t1351);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1354 = t1053 * t550;
  t1359 = t351 * t555;
  t1363 = my_piecewise5(t11, 0, t15, 0, -t1276 - t1277);
  t1367 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1354 * t120 + 0.8e1 / 0.9e1 * t496 * t500 + 0.4e1 / 0.9e1 * t1359 * t120 + 0.4e1 / 0.3e1 * t24 * t1363);
  t1368 = t1367 * t27;
  t1372 = t559 * t129;
  t1374 = t6 * t1372 * t67;
  t1383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t67 - t1374 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t177 - t1291 + t1297 / 0.6e1 - t1301 + t1083 / 0.12e2 - t1096 + t1098 / 0.12e2);
  t1384 = t1231 * t567;
  t1389 = t468 * t572;
  t1393 = my_piecewise5(t15, 0, t11, 0, t1276 - t1320);
  t1397 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1384 * t185 + 0.8e1 / 0.9e1 * t520 * t524 + 0.4e1 / 0.9e1 * t1389 * t185 + 0.4e1 / 0.3e1 * t78 * t1393);
  t1398 = t1397 * t27;
  t1402 = t576 * t129;
  t1404 = t6 * t1402 * t111;
  t1411 = t6 * t533 * t264;
  t1419 = t6 * t193 * t662;
  t1421 = -0.3e1 / 0.8e1 * t6 * t1398 * t111 - t1404 / 0.8e1 - t1334 + t1337 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t264 - t1411 / 0.4e1 + t1256 / 0.12e2 - t1261 - t1346 + t1348 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t662 - t1419 / 0.8e1;
  t1422 = my_piecewise3(t72, 0, t1421);
  tv3rho32 = t1266 + t1267 + t566 + t667 + t7 * (t1383 + t1422);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1427 = t550 * t202;
  t1434 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t356 - 0.6e1 * t1062);
  t1438 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1427 + 0.4e1 / 0.3e1 * t496 * t555 + 0.4e1 / 0.3e1 * t24 * t1434);
  t1439 = t1438 * t27;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t67 - 0.3e1 / 0.8e1 * t1374 + t1297 / 0.4e1 - t1096);
  t1447 = t567 * t213;
  t1454 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t356 - 0.6e1 * t1238);
  t1458 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1447 + 0.4e1 / 0.3e1 * t520 * t572 + 0.4e1 / 0.3e1 * t78 * t1454);
  t1459 = t1458 * t27;
  t1484 = 0.1e1 / t83 / t586;
  t1490 = 0.1e1 / t84 / t987;
  t1491 = sigma[2] * t1490;
  t1495 = t586 * t586;
  t1497 = 0.1e1 / t83 / t1495;
  t1502 = t1495 * t221;
  t1503 = 0.1e1 / t1502;
  t1505 = t236 * t236;
  t1507 = 0.1e1 / t237 / t1505;
  t1511 = -0.28e3 / 0.27e2 * t43 * t88 * t1484 * t92 - 0.952e3 / 0.27e2 * t43 * t1491 * t238 + 0.592e3 / 0.27e2 * t43 * t316 * t1497 * t629 - 0.64e2 / 0.9e1 * t43 * t1003 * t1503 * t1507;
  t1512 = t230 * t1511;
  t1519 = -0.1232e4 / 0.27e2 * t1491 + 0.44e3 / 0.27e2 * lapl[1] * t588;
  t1520 = t1519 * t101;
  t1527 = 0.1e1 / t83;
  t1530 = 0.2e1 * t1520 * t85 + 0.16e2 * t650 * t97 + 0.8e2 / 0.3e1 * t254 * t84 + 0.16e3 / 0.27e2 * t102 * t1527;
  t1531 = t249 * t1530;
  t1541 = t639 * t242;
  t1542 = t1541 * t641;
  t1543 = t609 * t1542;
  t1547 = t639 * t259 * t657;
  t1548 = t778 * t1547;
  t1551 = t228 * t228;
  t1552 = 0.1e1 / t1551;
  t1553 = t1552 * t106;
  t1554 = t602 * t242;
  t1555 = t1553 * t1554;
  t1559 = t248 * t602;
  t1560 = t1559 * t259;
  t1561 = t786 * t1560;
  t1564 = t774 * t633;
  t1565 = t786 * t1564;
  t1568 = t248 * t633;
  t1569 = t1568 * t259;
  t1570 = t609 * t1569;
  t1573 = t610 * t657;
  t1574 = t609 * t1573;
  t1577 = t247 * t247;
  t1578 = 0.1e1 / t1577;
  t1579 = t96 * t1578;
  t1580 = t641 * t259;
  t1581 = t1579 * t1580;
  t1588 = t223 * t229;
  t1589 = t1588 * t611;
  t1595 = -0.176e3 / 0.27e2 * t36 * t589 * t260 + 0.16e2 / 0.9e1 * t36 * t224 * t634 + 0.16e2 / 0.9e1 * t36 * t224 * t658 - 0.2e1 / 0.9e1 * t36 * t87 * t1512 - 0.2e1 / 0.9e1 * t36 * t87 * t1531 - 0.2464e4 / 0.243e3 * t36 * t1491 * t107 - 0.176e3 / 0.27e2 * t36 * t589 * t243 - 0.4e1 / 0.3e1 * t608 * t1543 + 0.4e1 / 0.3e1 * t608 * t1548 - 0.4e1 / 0.3e1 * t36 * t87 * t1555 - 0.4e1 / 0.3e1 * t608 * t1561 + 0.4e1 / 0.3e1 * t608 * t1565 + 0.2e1 / 0.3e1 * t608 * t1570 + 0.2e1 / 0.3e1 * t608 * t1574 - 0.4e1 / 0.3e1 * t36 * t87 * t1581 - 0.32e2 / 0.9e1 * t36 * t224 * t603 - 0.32e2 / 0.9e1 * t608 * t1589 - 0.32e2 / 0.9e1 * t36 * t224 * t642;
  t1600 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t111 - 0.3e1 / 0.8e1 * t1404 - 0.9e1 / 0.8e1 * t6 * t577 * t264 + t1337 / 0.4e1 - 0.3e1 / 0.4e1 * t1411 - 0.9e1 / 0.8e1 * t6 * t217 * t662 - t1261 + t1348 / 0.4e1 - 0.3e1 / 0.8e1 * t1419 - 0.3e1 / 0.8e1 * t6 * t81 * t1595);
  tv3rho33 = 0.3e1 * t566 + 0.3e1 * t667 + t7 * (t1446 + t1600);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1608 = t6 * t369 * t297;
  t1615 = t6 * t378 * t297 / 0.12e2;
  t1617 = t6 * t130 * t745;
  t1623 = t692 * t161;
  t1624 = t283 * t155;
  t1625 = t1624 * t172;
  t1629 = t408 * t438;
  t1630 = t292 * t155;
  t1631 = t1630 * t172;
  t1635 = t438 * t740;
  t1636 = t1635 * t172;
  t1637 = t684 * t1636;
  t1640 = t730 * t456;
  t1641 = t684 * t1640;
  t1644 = t161 * t717;
  t1645 = t1644 * t172;
  t1646 = t408 * t1645;
  t1649 = t698 * t456;
  t1650 = t408 * t1649;
  t1653 = t1217 * t726;
  t1656 = t136 * t52;
  t1657 = t1656 * t731;
  t1660 = t161 * t740;
  t1661 = t1660 * t155;
  t1662 = t408 * t1661;
  t1665 = t725 * t432;
  t1666 = t408 * t1665;
  t1669 = t136 * t399;
  t1670 = t1669 * t694;
  t1673 = t1217 * t699;
  t1676 = t62 * t717;
  t1677 = t1676 * t155;
  t1678 = t692 * t1677;
  t1681 = t693 * t432;
  t1682 = t692 * t1681;
  t1688 = 0.176e3 / 0.81e2 * t272 * t34 * t387 * t63 - 0.8e1 / 0.9e1 * t407 * t1623 * t1625 - 0.8e1 / 0.9e1 * t407 * t1629 * t1631 + 0.8e1 / 0.9e1 * t407 * t1637 + 0.4e1 / 0.9e1 * t407 * t1641 + 0.4e1 / 0.9e1 * t407 * t1646 + 0.2e1 / 0.9e1 * t407 * t1650 - 0.32e2 / 0.27e2 * t407 * t1653 - 0.64e2 / 0.27e2 * t407 * t1657 + 0.4e1 / 0.9e1 * t407 * t1662 + 0.2e1 / 0.9e1 * t407 * t1666 - 0.64e2 / 0.27e2 * t407 * t1670 - 0.32e2 / 0.27e2 * t407 * t1673 + 0.8e1 / 0.9e1 * t407 * t1678 + 0.4e1 / 0.9e1 * t407 * t1682 + 0.32e2 / 0.27e2 * t36 * t137 * t741;
  t1689 = t448 * t288;
  t1696 = -0.2e1 * t1689 * t40 - 0.32e2 / 0.3e1 * t735 * t53 - 0.8e2 / 0.9e1 * t289 * t39;
  t1697 = t162 * t1696;
  t1713 = t425 * t428;
  t1717 = t1149 * t37;
  t1719 = 0.1e1 / t1717 * t1161;
  t1723 = 0.14e2 / 0.9e1 * t43 * t276 * t415 * t48 + 0.74e2 / 0.9e1 * t43 * t387 * t151 - 0.62e2 / 0.9e1 * t43 * t1713 * sigma[0] + 0.8e1 / 0.3e1 * t43 * t1719 * t287;
  t1724 = t143 * t1723;
  t1740 = t62 * t432;
  t1744 = t161 * t456;
  t1748 = t62 * t401;
  t1752 = t438 * t440;
  t1756 = t438 * t283;
  t1757 = t1756 * t440;
  t1758 = t408 * t1757;
  t1761 = t725 * t401;
  t1762 = t692 * t1761;
  t1765 = t1202 * t292;
  t1766 = t1765 * t440;
  t1767 = t684 * t1766;
  t1770 = t41 * t1176;
  t1771 = t693 * t401;
  t1772 = t1770 * t1771;
  t1775 = -0.2e1 / 0.9e1 * t36 * t42 * t1697 + 0.4e1 / 0.9e1 * t36 * t411 + 0.32e2 / 0.27e2 * t36 * t137 * t718 - 0.2e1 / 0.9e1 * t36 * t42 * t1724 - 0.176e3 / 0.81e2 * t36 * t388 * t293 - 0.176e3 / 0.81e2 * t36 * t388 * t284 + 0.32e2 / 0.27e2 * t36 * t1217 * t680 + 0.32e2 / 0.27e2 * t36 * t1656 * t685 - 0.2e1 / 0.9e1 * t36 * t408 * t1740 - 0.2e1 / 0.9e1 * t36 * t684 * t1744 + 0.4e1 / 0.9e1 * t36 * t692 * t1748 + 0.4e1 / 0.9e1 * t36 * t684 * t1752 - 0.4e1 / 0.9e1 * t407 * t1758 - 0.4e1 / 0.9e1 * t407 * t1762 - 0.4e1 / 0.3e1 * t407 * t1767 - 0.4e1 / 0.3e1 * t407 * t1772;
  t1776 = t1688 + t1775;
  t1781 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t297 - t1608 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t745 + t1615 - t1617 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1776);
  tv3rho2sigma0 = t7 * t1781 + 0.2e1 * t750;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1788 = t6 * t484 * t326;
  t1792 = t6 * t488 * t326 / 0.12e2;
  t1794 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t326 - t1788 / 0.4e1 + t1792);
  tv3rho2sigma2 = t7 * t1794 + 0.2e1 * t759;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1800 = t6 * t509 * t297;
  t1808 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t297 - t1800 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t745 - t1608 / 0.8e1 + t1615 - t1617 / 0.8e1);
  tv3rho2sigma3 = t7 * t1808 + t750 + t765;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1814 = t6 * t533 * t326;
  t1821 = t6 * t193 * t839;
  t1824 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t326 - t1814 / 0.8e1 - t1788 / 0.8e1 + t1792 - 0.3e1 / 0.8e1 * t6 * t189 * t839 - t1821 / 0.8e1);
  tv3rho2sigma5 = t7 * t1824 + t759 + t844;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1832 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t297 - t1800 / 0.4e1 + t1615);
  tv3rho2sigma6 = t7 * t1832 + 0.2e1 * t765;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1847 = t786 * t248;
  t1848 = t312 * t242;
  t1849 = t1848 * t259;
  t1853 = t609 * t639;
  t1854 = t321 * t242;
  t1855 = t1854 * t259;
  t1862 = t649 * t317;
  t1869 = -0.2e1 * t1862 * t85 - 0.32e2 / 0.3e1 * t829 * t97 - 0.8e2 / 0.9e1 * t318 * t84;
  t1870 = t249 * t1869;
  t1886 = t626 * t629;
  t1890 = t1495 * t82;
  t1892 = 0.1e1 / t1890 * t1507;
  t1896 = 0.14e2 / 0.9e1 * t43 * t305 * t616 * t92 + 0.74e2 / 0.9e1 * t43 * t588 * t238 - 0.62e2 / 0.9e1 * t43 * t1886 * sigma[2] + 0.8e1 / 0.3e1 * t43 * t1892 * t316;
  t1897 = t230 * t1896;
  t1904 = t639 * t312;
  t1905 = t1904 * t641;
  t1906 = t609 * t1905;
  t1909 = t819 * t602;
  t1910 = t786 * t1909;
  t1913 = t223 * t600;
  t1914 = t1913 * t788;
  t1917 = t1588 * t793;
  t1920 = t106 * t811;
  t1921 = t1920 * t242;
  t1922 = t786 * t1921;
  t1925 = t787 * t633;
  t1926 = t786 * t1925;
  t1929 = t248 * t811;
  t1930 = t1929 * t259;
  t1931 = t609 * t1930;
  t1934 = 0.176e3 / 0.81e2 * t272 * t34 * t588 * t107 - 0.8e1 / 0.9e1 * t608 * t1847 * t1849 - 0.8e1 / 0.9e1 * t608 * t1853 * t1855 + 0.32e2 / 0.27e2 * t36 * t224 * t835 - 0.2e1 / 0.9e1 * t36 * t87 * t1870 + 0.4e1 / 0.9e1 * t36 * t612 + 0.32e2 / 0.27e2 * t36 * t224 * t812 - 0.2e1 / 0.9e1 * t36 * t87 * t1897 - 0.176e3 / 0.81e2 * t36 * t589 * t313 - 0.4e1 / 0.9e1 * t608 * t1906 - 0.4e1 / 0.9e1 * t608 * t1910 - 0.64e2 / 0.27e2 * t608 * t1914 - 0.32e2 / 0.27e2 * t608 * t1917 + 0.8e1 / 0.9e1 * t608 * t1922 + 0.4e1 / 0.9e1 * t608 * t1926 + 0.4e1 / 0.9e1 * t608 * t1931;
  t1935 = t792 * t657;
  t1936 = t609 * t1935;
  t1939 = t1588 * t820;
  t1942 = t223 * t96;
  t1943 = t1942 * t825;
  t1946 = t248 * t834;
  t1947 = t1946 * t242;
  t1948 = t609 * t1947;
  t1951 = t819 * t633;
  t1952 = t609 * t1951;
  t1955 = t639 * t834;
  t1956 = t1955 * t259;
  t1957 = t778 * t1956;
  t1960 = t824 * t657;
  t1961 = t778 * t1960;
  t1964 = t1578 * t321;
  t1965 = t1964 * t641;
  t1966 = t778 * t1965;
  t1969 = t86 * t1552;
  t1970 = t787 * t602;
  t1971 = t1969 * t1970;
  t1983 = t106 * t633;
  t1987 = t248 * t657;
  t1991 = t106 * t602;
  t1995 = t639 * t641;
  t1999 = 0.2e1 / 0.9e1 * t608 * t1936 - 0.32e2 / 0.27e2 * t608 * t1939 - 0.64e2 / 0.27e2 * t608 * t1943 + 0.4e1 / 0.9e1 * t608 * t1948 + 0.2e1 / 0.9e1 * t608 * t1952 + 0.8e1 / 0.9e1 * t608 * t1957 + 0.4e1 / 0.9e1 * t608 * t1961 - 0.4e1 / 0.3e1 * t608 * t1966 - 0.4e1 / 0.3e1 * t608 * t1971 - 0.176e3 / 0.81e2 * t36 * t589 * t322 + 0.32e2 / 0.27e2 * t36 * t1588 * t774 + 0.32e2 / 0.27e2 * t36 * t1942 * t779 - 0.2e1 / 0.9e1 * t36 * t609 * t1983 - 0.2e1 / 0.9e1 * t36 * t778 * t1987 + 0.4e1 / 0.9e1 * t36 * t786 * t1991 + 0.4e1 / 0.9e1 * t36 * t778 * t1995;
  t2000 = t1934 + t1999;
  t2005 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t326 - t1814 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t839 + t1792 - t1821 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t2000);
  tv3rho2sigma8 = t7 * t2005 + 0.2e1 * t844;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2008 = t861 * t432;
  t2009 = t860 * t2008;
  t2012 = t439 * t456;
  t2013 = t860 * t2012;
  t2015 = t846 * t850;
  t2016 = t2015 * t336;
  t2020 = t846 * t858;
  t2024 = t377 * params->beta;
  t2025 = t331 * t2024;
  t2027 = t2025 * t336 / 0.9e1;
  t2028 = t851 * t855;
  t2030 = t850 * t33;
  t2031 = t331 * t2030;
  t2032 = t2031 * t863;
  t2034 = t2031 * t867;
  t2037 = t35 * t1656 * t161;
  t2040 = t273 * t862;
  t2043 = t273 * t866;
  t2046 = t5 * t364;
  t2047 = t2046 * t332;
  t2050 = t1203 * t440;
  t2051 = t860 * t2050;
  t2054 = t399 * t161;
  t2055 = t2054 * t401;
  t2056 = t860 * t2055;
  t2058 = t860 * t142;
  t2059 = t1170 * t172;
  t2060 = t2058 * t2059;
  t2063 = t859 * t2009 / 0.2e1 + t859 * t2013 - t2016 / 0.3e1 + 0.5e1 / 0.3e1 * t847 * t855 + t2020 * t863 + 0.2e1 * t2020 * t867 + t2027 + 0.5e1 / 0.9e1 * t2028 + t2032 / 0.3e1 + 0.2e1 / 0.3e1 * t2034 - 0.2e2 / 0.9e1 * t333 * t2037 - 0.5e1 / 0.3e1 * t859 * t2040 - 0.1e2 / 0.3e1 * t859 * t2043 - t2047 * t336 / 0.2e1 - 0.3e1 * t859 * t2051 - t859 * t2056 - 0.2e1 * t859 * t2060;
  t2064 = my_piecewise3(t2, 0, t2063);
  tv3rho2lapl0 = t7 * t2064 + 0.2e1 * t870;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2067 = t5 * t479;
  t2068 = t2067 * t332;
  t2071 = t872 * t850;
  t2072 = t2071 * t344;
  t2074 = t340 * t2024;
  t2076 = t2074 * t344 / 0.9e1;
  t2078 = my_piecewise3(t72, 0, -t2068 * t344 / 0.2e1 - t2072 / 0.3e1 + t2076);
  tv3rho2lapl1 = t7 * t2078 + 0.2e1 * t880;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2080 = t5 * t504;
  t2081 = t2080 * t332;
  t2084 = t882 * t850;
  t2085 = t2084 * t336;
  t2089 = t882 * t858;
  t2098 = my_piecewise3(t2, 0, -t2081 * t336 / 0.2e1 - t2085 / 0.6e1 + 0.5e1 / 0.6e1 * t883 * t855 + t2089 * t863 / 0.2e1 + t2089 * t867 - t2016 / 0.6e1 + t2027 + 0.5e1 / 0.18e2 * t2028 + t2032 / 0.6e1 + t2034 / 0.3e1);
  tv3rho2lapl2 = t7 * t2098 + t870 + t887;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2100 = t5 * t528;
  t2101 = t2100 * t332;
  t2104 = t889 * t850;
  t2105 = t2104 * t344;
  t2110 = t876 * t894;
  t2112 = t872 * t858;
  t2115 = t340 * t2030;
  t2116 = t2115 * t901;
  t2119 = t2115 * t905;
  t2122 = my_piecewise3(t72, 0, -t2101 * t344 / 0.2e1 - t2105 / 0.6e1 - t2072 / 0.6e1 + t2076 + 0.5e1 / 0.6e1 * t873 * t894 + 0.5e1 / 0.18e2 * t2110 + t2112 * t901 / 0.2e1 + t2116 / 0.6e1 + t2112 * t905 + t2119 / 0.3e1);
  tv3rho2lapl3 = t7 * t2122 + t880 + t908;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2125 = t5 * t559;
  t2126 = t2125 * t332;
  t2131 = my_piecewise3(t2, 0, -t2126 * t336 / 0.2e1 - t2085 / 0.3e1 + t2027);
  tv3rho2lapl4 = t7 * t2131 + 0.2e1 * t887;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2134 = t302 * t900;
  t2137 = t302 * t904;
  t2140 = t899 * t633;
  t2141 = t898 * t2140;
  t2144 = t640 * t657;
  t2145 = t898 * t2144;
  t2149 = t889 * t858;
  t2154 = t35 * t1942 * t248;
  t2159 = t5 * t576;
  t2160 = t2159 * t332;
  t2163 = t898 * t229;
  t2164 = t1541 * t259;
  t2165 = t2163 * t2164;
  t2168 = t1579 * t641;
  t2169 = t898 * t2168;
  t2173 = t600 * t248;
  t2174 = t2173 * t602;
  t2175 = t898 * t2174;
  t2178 = -0.5e1 / 0.3e1 * t897 * t2134 - 0.1e2 / 0.3e1 * t897 * t2137 + t897 * t2141 / 0.2e1 + t897 * t2145 + 0.5e1 / 0.3e1 * t890 * t894 + t2149 * t901 + 0.2e1 * t2149 * t905 - 0.2e2 / 0.9e1 * t341 * t2154 - t2105 / 0.3e1 + 0.5e1 / 0.9e1 * t2110 + t2076 - t2160 * t344 / 0.2e1 - 0.2e1 * t897 * t2165 - 0.3e1 * t897 * t2169 + 0.2e1 / 0.3e1 * t2119 - t897 * t2175 + t2116 / 0.3e1;
  t2179 = my_piecewise3(t72, 0, t2178);
  tv3rho2lapl5 = t7 * t2179 + 0.2e1 * t908;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2186 = t6 * t130 * t959 / 0.8e1;
  t2187 = t283 * t292;
  t2188 = t2187 * t155;
  t2192 = t2187 * t172;
  t2226 = t1149 * rho[0];
  t2228 = 0.1e1 / t2226 * t1161;
  t2231 = t43 * t926 * t145 * t48 / 0.3e1 - t43 * t57 * t136 * t151 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t713 - t43 * t2228 * sigma[0];
  t2232 = t143 * t2231;
  t2236 = t166 * t950;
  t2241 = 0.4e1 * t2236 * t40 + 0.32e2 / 0.3e1 * t951 * t53;
  t2242 = t162 * t2241;
  t2246 = t438 * t944;
  t2247 = t2246 * t155;
  t2248 = t408 * t2247;
  t2251 = t1202 * t944;
  t2252 = t2251 * t172;
  t2253 = t684 * t2252;
  t2256 = -0.8e1 / 0.9e1 * t407 * t1623 * t2188 - 0.8e1 / 0.9e1 * t407 * t1629 * t2192 - 0.32e2 / 0.27e2 * t36 * t137 * t945 + 0.16e2 / 0.27e2 * t36 * t137 * t955 - 0.32e2 / 0.27e2 * t36 * t137 * t917 + 0.16e2 / 0.27e2 * t36 * t137 * t940 + 0.8e1 / 0.9e1 * t36 * t695 + 0.4e1 / 0.9e1 * t36 * t700 + 0.4e1 / 0.9e1 * t36 * t727 + 0.8e1 / 0.9e1 * t36 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t2232 - 0.2e1 / 0.9e1 * t36 * t42 * t2242 - 0.4e1 / 0.9e1 * t407 * t2248 - 0.4e1 / 0.3e1 * t407 * t2253;
  t2257 = t730 * t740;
  t2258 = t684 * t2257;
  t2261 = t161 * t954;
  t2262 = t2261 * t155;
  t2263 = t408 * t2262;
  t2266 = t438 * t954;
  t2267 = t2266 * t172;
  t2268 = t684 * t2267;
  t2271 = t62 * t916;
  t2272 = t2271 * t155;
  t2273 = t1770 * t2272;
  t2276 = t161 * t916;
  t2277 = t2276 * t172;
  t2278 = t692 * t2277;
  t2281 = t693 * t717;
  t2282 = t692 * t2281;
  t2285 = t1644 * t292;
  t2286 = t408 * t2285;
  t2289 = t698 * t740;
  t2290 = t408 * t2289;
  t2293 = t62 * t939;
  t2294 = t2293 * t155;
  t2295 = t692 * t2294;
  t2298 = t161 * t939;
  t2299 = t2298 * t172;
  t2300 = t408 * t2299;
  t2303 = t1217 * t921;
  t2318 = 0.8e1 / 0.9e1 * t407 * t2258 + 0.2e1 / 0.9e1 * t407 * t2263 + 0.4e1 / 0.9e1 * t407 * t2268 - 0.4e1 / 0.3e1 * t407 * t2273 - 0.4e1 / 0.9e1 * t407 * t2278 + 0.8e1 / 0.9e1 * t407 * t2282 + 0.4e1 / 0.9e1 * t407 * t2286 + 0.4e1 / 0.9e1 * t407 * t2290 + 0.4e1 / 0.9e1 * t407 * t2295 + 0.2e1 / 0.9e1 * t407 * t2300 - 0.32e2 / 0.27e2 * t407 * t2303 - 0.4e1 / 0.9e1 * t36 * t408 * t1676 - 0.4e1 / 0.9e1 * t36 * t684 * t1660 + 0.32e2 / 0.27e2 * t36 * t1656 * t725 + 0.32e2 / 0.27e2 * t36 * t1217 * t693;
  t2319 = t2256 + t2318;
  t2324 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t959 - t2186 - 0.3e1 / 0.8e1 * t6 * t28 * t2319);
  tv3rhosigma20 = t7 * t2324 + t963;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2331 = t6 * t193 * t1013 / 0.8e1;
  t2333 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t1013 - t2331);
  tv3rhosigma25 = t7 * t2333 + t1017;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2339 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t959 - t2186);
  tv3rhosigma26 = t7 * t2339 + t963;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2344 = t312 * t321;
  t2345 = t2344 * t242;
  t2349 = t2344 * t259;
  t2353 = t253 * t1004;
  t2358 = 0.4e1 * t2353 * t85 + 0.32e2 / 0.3e1 * t1005 * t97;
  t2359 = t249 * t2358;
  t2393 = t1495 * rho[1];
  t2395 = 0.1e1 / t2393 * t1507;
  t2398 = t43 * t980 * t232 * t92 / 0.3e1 - t43 * t101 * t223 * t238 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t807 - t43 * t2395 * sigma[2];
  t2399 = t230 * t2398;
  t2403 = t248 * t970;
  t2404 = t2403 * t259;
  t2405 = t786 * t2404;
  t2408 = t787 * t811;
  t2409 = t786 * t2408;
  t2412 = -0.8e1 / 0.9e1 * t608 * t1847 * t2345 - 0.8e1 / 0.9e1 * t608 * t1853 * t2349 - 0.2e1 / 0.9e1 * t36 * t87 * t2359 + 0.8e1 / 0.9e1 * t36 * t789 + 0.4e1 / 0.9e1 * t36 * t794 + 0.4e1 / 0.9e1 * t36 * t821 + 0.8e1 / 0.9e1 * t36 * t826 + 0.16e2 / 0.27e2 * t36 * t224 * t994 - 0.32e2 / 0.27e2 * t36 * t224 * t999 + 0.16e2 / 0.27e2 * t36 * t224 * t1009 - 0.32e2 / 0.27e2 * t36 * t224 * t971 - 0.2e1 / 0.9e1 * t36 * t87 * t2399 - 0.4e1 / 0.9e1 * t608 * t2405 + 0.8e1 / 0.9e1 * t608 * t2409;
  t2413 = t1929 * t321;
  t2414 = t609 * t2413;
  t2417 = t1588 * t975;
  t2420 = t792 * t834;
  t2421 = t609 * t2420;
  t2424 = t106 * t993;
  t2425 = t2424 * t242;
  t2426 = t786 * t2425;
  t2429 = t248 * t993;
  t2430 = t2429 * t259;
  t2431 = t609 * t2430;
  t2434 = t639 * t998;
  t2435 = t2434 * t242;
  t2436 = t609 * t2435;
  t2439 = t1578 * t998;
  t2440 = t2439 * t259;
  t2441 = t778 * t2440;
  t2444 = t824 * t834;
  t2445 = t778 * t2444;
  t2448 = t248 * t1008;
  t2449 = t2448 * t242;
  t2450 = t609 * t2449;
  t2453 = t639 * t1008;
  t2454 = t2453 * t259;
  t2455 = t778 * t2454;
  t2458 = t106 * t970;
  t2459 = t2458 * t242;
  t2460 = t1969 * t2459;
  t2475 = 0.4e1 / 0.9e1 * t608 * t2414 - 0.32e2 / 0.27e2 * t608 * t2417 + 0.4e1 / 0.9e1 * t608 * t2421 + 0.4e1 / 0.9e1 * t608 * t2426 + 0.2e1 / 0.9e1 * t608 * t2431 - 0.4e1 / 0.9e1 * t608 * t2436 - 0.4e1 / 0.3e1 * t608 * t2441 + 0.8e1 / 0.9e1 * t608 * t2445 + 0.2e1 / 0.9e1 * t608 * t2450 + 0.4e1 / 0.9e1 * t608 * t2455 - 0.4e1 / 0.3e1 * t608 * t2460 - 0.4e1 / 0.9e1 * t36 * t609 * t1920 - 0.4e1 / 0.9e1 * t36 * t778 * t1946 + 0.32e2 / 0.27e2 * t36 * t1588 * t787 + 0.32e2 / 0.27e2 * t36 * t1942 * t819;
  t2476 = t2412 + t2475;
  t2481 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t1013 - t2331 - 0.3e1 / 0.8e1 * t6 * t81 * t2476);
  tv3rhosigma211 = t7 * t2481 + t1017;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2486 = t2031 * t1019 / 0.6e1;
  t2487 = t273 * t1018;
  t2490 = t860 * t399;
  t2491 = t698 * t155;
  t2492 = t2490 * t2491;
  t2494 = t1756 * t172;
  t2495 = t2058 * t2494;
  t2497 = t861 * t717;
  t2498 = t860 * t2497;
  t2503 = t2031 * t1023 / 0.3e1;
  t2504 = t273 * t1022;
  t2507 = t730 * t155;
  t2508 = t2058 * t2507;
  t2510 = t860 * t52;
  t2511 = t1765 * t172;
  t2512 = t2510 * t2511;
  t2515 = t439 * t740;
  t2516 = t860 * t2515;
  t2518 = t2020 * t1019 / 0.2e1 + t2486 - 0.5e1 / 0.6e1 * t859 * t2487 - t859 * t2492 - t859 * t2495 + t859 * t2498 / 0.2e1 + t2020 * t1023 + t2503 - 0.5e1 / 0.3e1 * t859 * t2504 - t859 * t2508 - 0.3e1 * t859 * t2512 + t859 * t2516;
  t2519 = my_piecewise3(t2, 0, t2518);
  tv3rhosigmalapl0 = t7 * t2519 + t1026;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2524 = t2115 * t1028 / 0.6e1;
  t2527 = t2115 * t1032 / 0.3e1;
  t2529 = my_piecewise3(t72, 0, t2112 * t1028 / 0.2e1 + t2524 + t2112 * t1032 + t2527);
  tv3rhosigmalapl5 = t7 * t2529 + t1035;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2535 = my_piecewise3(t2, 0, t2089 * t1019 / 0.2e1 + t2486 + t2089 * t1023 + t2503);
  tv3rhosigmalapl6 = t7 * t2535 + t1026;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2539 = t302 * t1027;
  t2542 = t898 * t600;
  t2543 = t792 * t242;
  t2544 = t2542 * t2543;
  t2546 = t1904 * t259;
  t2547 = t2163 * t2546;
  t2549 = t899 * t811;
  t2550 = t898 * t2549;
  t2554 = t302 * t1031;
  t2557 = t824 * t242;
  t2558 = t2163 * t2557;
  t2560 = t898 * t96;
  t2561 = t1964 * t259;
  t2562 = t2560 * t2561;
  t2565 = t640 * t834;
  t2566 = t898 * t2565;
  t2568 = t2149 * t1028 / 0.2e1 + t2524 - 0.5e1 / 0.6e1 * t897 * t2539 - t897 * t2544 - t897 * t2547 + t897 * t2550 / 0.2e1 + t2149 * t1032 + t2527 - 0.5e1 / 0.3e1 * t897 * t2554 - t897 * t2558 - 0.3e1 * t897 * t2562 + t897 * t2566;
  t2569 = my_piecewise3(t72, 0, t2568);
  tv3rhosigmalapl11 = t7 * t2569 + t1035;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2574 = 0.2e1 / 0.3e1 * t2031 * t1039;
  t2575 = t860 * t1038;
  t2578 = t1037 * t142;
  t2579 = t438 * t57;
  t2580 = t2579 * t155;
  t2581 = t2578 * t2580;
  t2584 = t1037 * t52;
  t2585 = t1202 * t57;
  t2586 = t2585 * t172;
  t2587 = t2584 * t2586;
  t2591 = my_piecewise3(t2, 0, -0.2e1 * t2020 * t1039 - t2574 + 0.4e1 / 0.3e1 * t859 * t2575 + 0.2e1 * t859 * t2581 + 0.6e1 * t859 * t2587);
  tv3rholapl20 = t7 * t2591 + t1042;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2596 = 0.2e1 / 0.3e1 * t2115 * t1046;
  t2598 = my_piecewise3(t72, 0, -0.2e1 * t2112 * t1046 - t2596);
  tv3rholapl22 = t7 * t2598 + t1049;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2603 = my_piecewise3(t2, 0, -0.2e1 * t2089 * t1039 - t2574);
  tv3rholapl23 = t7 * t2603 + t1042;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2607 = t898 * t1045;
  t2610 = t1044 * t229;
  t2611 = t639 * t101;
  t2612 = t2611 * t242;
  t2613 = t2610 * t2612;
  t2616 = t1044 * t96;
  t2617 = t1578 * t101;
  t2618 = t2617 * t259;
  t2619 = t2616 * t2618;
  t2623 = my_piecewise3(t72, 0, -0.2e1 * t2149 * t1046 - t2596 + 0.4e1 / 0.3e1 * t897 * t2607 + 0.2e1 * t897 * t2613 + 0.6e1 * t897 * t2619);
  tv3rholapl25 = t7 * t2623 + t1049;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2631 = t1756 * t944;
  t2632 = t408 * t2631;
  t2639 = 0.1e1 / t44 / t287;
  t2652 = 0.1e1 / t1149;
  t2656 = 0.3e1 / 0.8e1 * t43 * t2639 * t46 * t48 - 0.3e1 / 0.8e1 * t43 * t288 * t41 * t151 - t43 * t57 * t935 * t428 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2652 * t1161;
  t2657 = t143 * t2656;
  t2661 = t287 * t287;
  t2662 = 0.1e1 / t2661;
  t2663 = t56 * t2662;
  t2666 = -0.12e2 * t2663 * t40 + 0.12e2 * t950;
  t2667 = t162 * t2666;
  t2676 = t2298 * t292;
  t2677 = t408 * t2676;
  t2680 = t698 * t954;
  t2681 = t408 * t2680;
  t2684 = t944 * t292;
  t2685 = t1203 * t2684;
  t2689 = t730 * t954;
  t2690 = t684 * t2689;
  t2693 = t916 * t283;
  t2694 = t1177 * t2693;
  t2698 = t2276 * t292;
  t2699 = t692 * t2698;
  t2702 = t693 * t939;
  t2703 = t692 * t2702;
  t2706 = -0.2e1 / 0.3e1 * t36 * t408 * t2293 - 0.2e1 / 0.3e1 * t36 * t684 * t2261 - 0.4e1 / 0.3e1 * t407 * t2632 + 0.4e1 / 0.3e1 * t36 * t684 * t2246 - 0.2e1 / 0.9e1 * t36 * t42 * t2657 - 0.2e1 / 0.9e1 * t36 * t42 * t2667 + 0.4e1 / 0.3e1 * t36 * t692 * t2271 + 0.4e1 / 0.3e1 * t36 * t922 + 0.2e1 / 0.3e1 * t407 * t2677 + 0.2e1 / 0.3e1 * t407 * t2681 - 0.4e1 / 0.3e1 * t36 * t42 * t2685 + 0.4e1 / 0.3e1 * t407 * t2690 - 0.4e1 / 0.3e1 * t36 * t42 * t2694 - 0.4e1 / 0.3e1 * t407 * t2699 + 0.4e1 / 0.3e1 * t407 * t2703;
  t2710 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t2706);
  tv3sigma30 = t7 * t2710;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2717 = t1904 * t998;
  t2718 = t609 * t2717;
  t2730 = 0.1e1 / t88 / t316;
  t2743 = 0.1e1 / t1495;
  t2747 = 0.3e1 / 0.8e1 * t43 * t2730 * t90 * t92 - 0.3e1 / 0.8e1 * t43 * t317 * t86 * t238 - t43 * t101 * t989 * t629 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2743 * t1507;
  t2748 = t230 * t2747;
  t2752 = t316 * t316;
  t2753 = 0.1e1 / t2752;
  t2754 = t100 * t2753;
  t2757 = -0.12e2 * t2754 * t85 + 0.12e2 * t1004;
  t2758 = t249 * t2757;
  t2762 = t2403 * t321;
  t2763 = t786 * t2762;
  t2766 = t787 * t993;
  t2767 = t786 * t2766;
  t2770 = t2429 * t321;
  t2771 = t609 * t2770;
  t2774 = t792 * t1008;
  t2775 = t609 * t2774;
  t2778 = t998 * t321;
  t2779 = t1579 * t2778;
  t2783 = t824 * t1008;
  t2784 = t778 * t2783;
  t2787 = t970 * t312;
  t2788 = t1553 * t2787;
  t2792 = -0.2e1 / 0.3e1 * t36 * t609 * t2424 - 0.2e1 / 0.3e1 * t36 * t778 * t2448 - 0.4e1 / 0.3e1 * t608 * t2718 + 0.4e1 / 0.3e1 * t36 * t786 * t2458 + 0.4e1 / 0.3e1 * t36 * t976 + 0.4e1 / 0.3e1 * t36 * t778 * t2434 - 0.2e1 / 0.9e1 * t36 * t87 * t2748 - 0.2e1 / 0.9e1 * t36 * t87 * t2758 - 0.4e1 / 0.3e1 * t608 * t2763 + 0.4e1 / 0.3e1 * t608 * t2767 + 0.2e1 / 0.3e1 * t608 * t2771 + 0.2e1 / 0.3e1 * t608 * t2775 - 0.4e1 / 0.3e1 * t36 * t87 * t2779 + 0.4e1 / 0.3e1 * t608 * t2784 - 0.4e1 / 0.3e1 * t36 * t87 * t2788;
  t2796 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t2792);
  tv3sigma39 = t7 * t2796;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2797 = t2054 * t916;
  t2798 = t860 * t2797;
  t2800 = t1756 * t292;
  t2801 = t2058 * t2800;
  t2804 = t861 * t939;
  t2805 = t860 * t2804;
  t2808 = t1203 * t944;
  t2809 = t860 * t2808;
  t2812 = t439 * t954;
  t2813 = t860 * t2812;
  t2816 = my_piecewise3(t2, 0, -t859 * t2798 - 0.2e1 * t859 * t2801 + t859 * t2805 / 0.2e1 - 0.3e1 * t859 * t2809 + t859 * t2813);
  tv3sigma2lapl0 = t7 * t2816;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t2817 = t2173 * t970;
  t2818 = t898 * t2817;
  t2820 = t1904 * t321;
  t2821 = t2163 * t2820;
  t2824 = t899 * t993;
  t2825 = t898 * t2824;
  t2828 = t1579 * t998;
  t2829 = t898 * t2828;
  t2832 = t640 * t1008;
  t2833 = t898 * t2832;
  t2836 = my_piecewise3(t72, 0, -t897 * t2818 - 0.2e1 * t897 * t2821 + t897 * t2825 / 0.2e1 - 0.3e1 * t897 * t2829 + t897 * t2833);
  tv3sigma2lapl11 = t7 * t2836;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t2837 = t2579 * t283;
  t2838 = t2578 * t2837;
  t2841 = t2585 * t292;
  t2842 = t2584 * t2841;
  t2845 = t439 * t288;
  t2846 = t1037 * t2845;
  t2850 = my_piecewise3(t2, 0, 0.2e1 * t859 * t2838 + 0.6e1 * t859 * t2842 + 0.2e1 * t859 * t2846);
  tv3sigmalapl20 = t7 * t2850;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t2851 = t2611 * t312;
  t2852 = t2610 * t2851;
  t2855 = t2617 * t321;
  t2856 = t2616 * t2855;
  t2859 = t640 * t317;
  t2860 = t1044 * t2859;
  t2864 = my_piecewise3(t72, 0, 0.2e1 * t897 * t2852 + 0.6e1 * t897 * t2856 + 0.2e1 * t897 * t2860);
  tv3sigmalapl28 = t7 * t2864;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t2865 = t34 * t38;
  t2866 = t1203 * t288;
  t2867 = t2865 * t2866;
  t2870 = my_piecewise3(t2, 0, -0.12e2 * t859 * t2867);
  tv3lapl30 = t7 * t2870;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t2871 = t34 * t83;
  t2872 = t1579 * t317;
  t2873 = t2871 * t2872;
  t2876 = my_piecewise3(t72, 0, -0.12e2 * t897 * t2873);
  tv3lapl33 = t7 * t2876;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t2883 = t6 * t1081 * t177;
  t2885 = t6 * t369 * t461;
  t2891 = t6 * t1093 * t177;
  t2894 = t6 * t378 * t461;
  t2897 = t6 * t130 * t1224;
  t2899 = t155 * t172;
  t2920 = t161 * t1120;
  t2936 = t438 * t401;
  t2946 = t1202 * t440;
  t2951 = t62 * t1165;
  t2961 = t438 * t432;
  t2979 = -0.16e2 / 0.3e1 * t407 * t1623 * t2899 * t432 - 0.16e2 / 0.3e1 * t407 * t1629 * t2899 * t456 - 0.128e3 / 0.9e1 * t407 * t1669 * t1188 - 0.64e2 / 0.9e1 * t407 * t1217 * t1193 - 0.64e2 / 0.9e1 * t407 * t1217 * t1197 - 0.128e3 / 0.9e1 * t407 * t1656 * t1210 + 0.8e1 / 0.9e1 * t407 * t408 * t2920 * t155 + 0.16e2 / 0.9e1 * t407 * t684 * t438 * t1120 * t172 + 0.128e3 / 0.9e1 * t407 * t1669 * t1184 + 0.128e3 / 0.9e1 * t407 * t1217 * t1171 + 0.16e2 / 0.3e1 * t407 * t692 * t2936 * t440 + 0.16e2 / 0.3e1 * t407 * t408 * t1202 * t155 * t1204 - 0.8e1 * t407 * t684 * t2946 * t456 + 0.16e2 / 0.9e1 * t407 * t692 * t2951 * t155 + 0.8e1 / 0.9e1 * t407 * t408 * t161 * t1165 * t172 - 0.8e1 / 0.3e1 * t407 * t408 * t2961 * t440 + 0.16e2 / 0.3e1 * t407 * t1770 * t161 * t1178 * t172 - 0.8e1 * t407 * t1770 * t1748 * t432 - 0.8e1 / 0.3e1 * t407 * t692 * t1183 * t456;
  t2980 = t387 * t142;
  t3000 = sigma[0] / t39 / t710;
  t3010 = t1149 * t385;
  t3022 = 0.1e1 / t150 / t1159 / t149;
  t3070 = 0.1e1 / t1201 / t61;
  t3071 = t52 * t3070;
  t3072 = t440 * t440;
  t3077 = t456 * t456;
  t3086 = 0.1e1 / t1175 / t51;
  t3087 = t3086 * t62;
  t3088 = t401 * t401;
  t3093 = t432 * t432;
  t3104 = 0.704e3 / 0.27e2 * t407 * t2980 * t410 + 0.4e1 / 0.3e1 * t407 * t408 * t1192 * t456 + 0.704e3 / 0.27e2 * t36 * t388 * t441 + 0.64e2 / 0.27e2 * t36 * t137 * t1121 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (0.364e4 / 0.81e2 * t43 * t44 * t935 * t48 + 0.5768e4 / 0.27e2 * t43 * t3000 * t151 - 0.18608e5 / 0.81e2 * t43 * t287 / t38 / t2226 * t428 + 0.448e4 / 0.27e2 * t43 * t949 / t3010 * t1161 - 0.128e4 / 0.27e2 * t43 * t2661 / t39 / t1149 / t710 * t3022) - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (0.2e1 * (0.20944e5 / 0.81e2 * t3000 - 0.616e4 / 0.81e2 * lapl[0] * t1104) * t57 * t40 + 0.64e2 / 0.3e1 * t1110 * t53 + 0.16e3 / 0.3e1 * t449 * t39 + 0.64e3 / 0.27e2 * t167 * t1117 - 0.16e3 / 0.81e2 * t58 * t46) + 0.9856e4 / 0.243e3 * t36 * t1105 * t156 + 0.9856e4 / 0.243e3 * t36 * t1105 * t173 - 0.352e3 / 0.27e2 * t36 * t388 * t433 - 0.352e3 / 0.27e2 * t36 * t388 * t457 + 0.64e2 / 0.27e2 * t36 * t137 * t1166 + 0.128e3 / 0.9e1 * t36 * t137 * t1205 + 0.16e2 / 0.3e1 * t36 * t42 * t3071 * t3072 + 0.4e1 / 0.3e1 * t36 * t42 * t439 * t3077 + 0.128e3 / 0.9e1 * t36 * t137 * t1179 + 0.16e2 / 0.3e1 * t36 * t42 * t3087 * t3088 + 0.4e1 / 0.3e1 * t36 * t42 * t400 * t3093 + 0.704e3 / 0.27e2 * t36 * t388 * t402 + 0.41888e5 / 0.729e3 * t36 * t3000 * t63;
  t3109 = t20 * t20;
  t3111 = 0.1e1 / t350 / t3109;
  t3112 = t352 * t352;
  t3118 = t360 * t360;
  t3124 = 0.1e1 / t1060 / t7;
  t3125 = t17 * t3124;
  t3128 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1061 + 0.24e2 * t3125);
  t3132 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3111 * t3112 - 0.16e2 / 0.9e1 * t1053 * t352 * t360 + 0.4e1 / 0.3e1 * t351 * t3118 + 0.16e2 / 0.9e1 * t1057 * t1065 + 0.4e1 / 0.3e1 * t24 * t3128);
  t3141 = t6 * t1074 * t177;
  t3145 = t6 * t1069 * t129 * t67;
  t3149 = t6 * t364 * t377 * t67;
  t3153 = t6 * t123 * t1092 * t67;
  t3156 = 0.1e1 / t128 / t355;
  t3160 = 0.1e2 / 0.27e2 * t6 * t26 * t3156 * t67;
  t3161 = -0.9e1 / 0.4e1 * t6 * t365 * t461 + t2883 - 0.3e1 / 0.2e1 * t2885 - 0.3e1 / 0.2e1 * t6 * t124 * t1224 - 0.5e1 / 0.9e1 * t2891 + t2894 / 0.2e1 - t2897 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t2979 + t3104) - 0.3e1 / 0.8e1 * t6 * t3132 * t27 * t67 - 0.3e1 / 0.2e1 * t6 * t1070 * t177 - 0.3e1 / 0.2e1 * t3141 - t3145 / 0.2e1 + t3149 / 0.2e1 - 0.5e1 / 0.9e1 * t3153 + t3160;
  t3162 = my_piecewise3(t2, 0, t3161);
  t3163 = t76 * t76;
  t3165 = 0.1e1 / t467 / t3163;
  t3166 = t469 * t469;
  t3172 = t475 * t475;
  t3177 = t73 * t3124;
  t3180 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1061 + 0.24e2 * t3177);
  t3184 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t3166 - 0.16e2 / 0.9e1 * t1231 * t469 * t475 + 0.4e1 / 0.3e1 * t468 * t3172 + 0.16e2 / 0.9e1 * t1235 * t1241 + 0.4e1 / 0.3e1 * t78 * t3180);
  t3191 = t6 * t1245 * t129 * t111;
  t3195 = t6 * t479 * t377 * t111;
  t3199 = t6 * t188 * t1092 * t111;
  t3204 = 0.1e2 / 0.27e2 * t6 * t80 * t3156 * t111;
  t3206 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t3184 * t27 * t111 - t3191 / 0.2e1 + t3195 / 0.2e1 - 0.5e1 / 0.9e1 * t3199 + t3204);
  tv4rho40 = 0.4e1 * t1229 + 0.4e1 * t1263 + t7 * (t3162 + t3206);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3227 = 0.12e2 * t1061;
  t3228 = 0.24e2 * t3125;
  t3230 = my_piecewise5(t11, 0, t15, 0, -t3227 + t3228);
  t3234 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3111 * t202 * t1054 - 0.8e1 / 0.9e1 * t1053 * t500 * t352 - 0.8e1 / 0.9e1 * t1268 * t120 * t360 + 0.4e1 / 0.3e1 * t351 * t1279 * t120 + 0.4e1 / 0.3e1 * t1271 * t360 + 0.4e1 / 0.9e1 * t496 * t1065 + 0.4e1 / 0.3e1 * t24 * t3230);
  t3243 = t6 * t1288 * t177;
  t3249 = t6 * t1295 * t177;
  t3250 = t3249 / 0.4e1;
  t3252 = t6 * t509 * t461;
  t3265 = t6 * t1283 * t129 * t67;
  t3269 = t6 * t504 * t377 * t67;
  t3270 = t3269 / 0.4e1;
  t3273 = t6 * t205 * t1092 * t67;
  t3278 = -0.3e1 / 0.8e1 * t6 * t3234 * t27 * t67 - 0.9e1 / 0.8e1 * t6 * t1284 * t177 - 0.3e1 / 0.4e1 * t3243 - 0.9e1 / 0.8e1 * t6 * t505 * t461 + t3250 - 0.3e1 / 0.8e1 * t3252 - 0.3e1 / 0.8e1 * t6 * t206 * t1224 + t2883 / 0.2e1 - 0.3e1 / 0.8e1 * t2885 - 0.5e1 / 0.12e2 * t2891 + t2894 / 0.4e1 - t2897 / 0.8e1 - 0.3e1 / 0.8e1 * t3141 - 0.3e1 / 0.8e1 * t3265 + t3270 - 0.5e1 / 0.36e2 * t3273 - t3145 / 0.8e1 + t3149 / 0.4e1 - 0.5e1 / 0.12e2 * t3153 + t3160;
  t3279 = my_piecewise3(t2, 0, t3278);
  t3296 = 0.24e2 * t3177;
  t3298 = my_piecewise5(t15, 0, t11, 0, t3227 + t3296);
  t3302 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t213 * t1232 - 0.8e1 / 0.9e1 * t1231 * t524 * t469 - 0.8e1 / 0.9e1 * t1312 * t185 * t475 + 0.4e1 / 0.3e1 * t468 * t1322 * t185 + 0.4e1 / 0.3e1 * t1315 * t475 + 0.4e1 / 0.9e1 * t520 * t1241 + 0.4e1 / 0.3e1 * t78 * t3298);
  t3309 = t6 * t1326 * t129 * t111;
  t3313 = t6 * t528 * t377 * t111;
  t3314 = t3313 / 0.4e1;
  t3317 = t6 * t216 * t1092 * t111;
  t3326 = t6 * t1250 * t264;
  t3329 = t6 * t1254 * t264;
  t3330 = t3329 / 0.4e1;
  t3332 = t6 * t1258 * t264;
  t3334 = -0.3e1 / 0.8e1 * t6 * t3302 * t27 * t111 - 0.3e1 / 0.8e1 * t3309 + t3314 - 0.5e1 / 0.36e2 * t3317 - t3191 / 0.8e1 + t3195 / 0.4e1 - 0.5e1 / 0.12e2 * t3199 + t3204 - 0.3e1 / 0.8e1 * t6 * t1246 * t264 - 0.3e1 / 0.8e1 * t3326 + t3330 - 0.5e1 / 0.36e2 * t3332;
  t3335 = my_piecewise3(t72, 0, t3334);
  tv4rho41 = t1229 + t1263 + 0.3e1 * t1311 + 0.3e1 * t1351 + t7 * (t3279 + t3335);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t3344 = t6 * t1367 * t129 * t67;
  t3348 = t6 * t559 * t377 * t67;
  t3358 = t500 * t500;
  t3371 = my_piecewise5(t11, 0, t15, 0, t3228);
  t3375 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3111 * t550 * t352 - 0.32e2 / 0.27e2 * t1268 * t120 * t500 - 0.8e1 / 0.27e2 * t1354 * t360 + 0.8e1 / 0.9e1 * t351 * t3358 + 0.8e1 / 0.9e1 * t496 * t1279 - 0.8e1 / 0.27e2 * t1053 * t555 * t352 + 0.8e1 / 0.9e1 * t351 * t1363 * t120 + 0.4e1 / 0.9e1 * t1359 * t360 + 0.4e1 / 0.3e1 * t24 * t3371);
  t3384 = t6 * t1372 * t177;
  t3400 = -t3344 / 0.4e1 + t3348 / 0.12e2 - 0.3e1 / 0.8e1 * t6 * t3375 * t27 * t67 - 0.3e1 / 0.4e1 * t6 * t1368 * t177 - t3384 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t560 * t461 - t3243 / 0.2e1 + t3249 / 0.3e1 - t3252 / 0.4e1 + t2883 / 0.6e1 - 0.5e1 / 0.18e2 * t2891 + t2894 / 0.12e2 - t3265 / 0.4e1 + t3269 / 0.3e1 - 0.5e1 / 0.18e2 * t3273 + t3149 / 0.12e2 - 0.5e1 / 0.18e2 * t3153 + t3160;
  t3401 = my_piecewise3(t2, 0, t3400);
  t3410 = t524 * t524;
  t3423 = my_piecewise5(t15, 0, t11, 0, t3296);
  t3427 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t567 * t469 - 0.32e2 / 0.27e2 * t1312 * t185 * t524 - 0.8e1 / 0.27e2 * t1384 * t475 + 0.8e1 / 0.9e1 * t468 * t3410 + 0.8e1 / 0.9e1 * t520 * t1322 - 0.8e1 / 0.27e2 * t1231 * t572 * t469 + 0.8e1 / 0.9e1 * t468 * t1393 * t185 + 0.4e1 / 0.9e1 * t1389 * t475 + 0.4e1 / 0.3e1 * t78 * t3423);
  t3434 = t6 * t1397 * t129 * t111;
  t3438 = t6 * t576 * t377 * t111;
  t3447 = t6 * t1331 * t264;
  t3450 = t6 * t1335 * t264;
  t3461 = t6 * t484 * t662;
  t3464 = t6 * t488 * t662;
  t3466 = -0.3e1 / 0.8e1 * t6 * t3427 * t27 * t111 - t3434 / 0.4e1 + t3438 / 0.12e2 - t3309 / 0.4e1 + t3313 / 0.3e1 - 0.5e1 / 0.18e2 * t3317 - 0.3e1 / 0.4e1 * t6 * t1327 * t264 - t3447 / 0.2e1 + t3450 / 0.6e1 + t3195 / 0.12e2 - 0.5e1 / 0.18e2 * t3199 + t3204 - t3326 / 0.4e1 + t3329 / 0.3e1 - 0.5e1 / 0.18e2 * t3332 - 0.3e1 / 0.8e1 * t6 * t480 * t662 - t3461 / 0.4e1 + t3464 / 0.12e2;
  t3467 = my_piecewise3(t72, 0, t3466);
  tv4rho42 = 0.2e1 * t1311 + 0.2e1 * t1351 + 0.2e1 * t1383 + 0.2e1 * t1422 + t7 * (t3401 + t3467);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t3488 = my_piecewise5(t11, 0, t15, 0, t3227 + t3228);
  t3492 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3111 * t1427 * t120 - 0.8e1 / 0.9e1 * t1354 * t500 - 0.8e1 / 0.9e1 * t1268 * t555 * t120 + 0.4e1 / 0.3e1 * t1271 * t555 + 0.4e1 / 0.3e1 * t496 * t1363 + 0.4e1 / 0.9e1 * t351 * t1434 * t120 + 0.4e1 / 0.3e1 * t24 * t3488);
  t3499 = t6 * t1438 * t129 * t67;
  t3510 = -0.3e1 / 0.8e1 * t6 * t3492 * t27 * t67 - t3499 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1439 * t177 - 0.3e1 / 0.8e1 * t3344 + t3348 / 0.4e1 - 0.3e1 / 0.8e1 * t3384 + t3270 - 0.5e1 / 0.12e2 * t3273 + t3250 - 0.5e1 / 0.36e2 * t3153 + t3160 - 0.5e1 / 0.36e2 * t2891;
  t3511 = my_piecewise3(t2, 0, t3510);
  t3528 = my_piecewise5(t15, 0, t11, 0, -t3227 + t3296);
  t3532 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t1447 * t185 - 0.8e1 / 0.9e1 * t1384 * t524 - 0.8e1 / 0.9e1 * t1312 * t572 * t185 + 0.4e1 / 0.3e1 * t1315 * t572 + 0.4e1 / 0.3e1 * t520 * t1393 + 0.4e1 / 0.9e1 * t468 * t1454 * t185 + 0.4e1 / 0.3e1 * t78 * t3528);
  t3539 = t6 * t1458 * t129 * t111;
  t3547 = t6 * t1402 * t264;
  t3556 = t6 * t533 * t662;
  t3566 = t6 * t193 * t1595;
  t3568 = -0.3e1 / 0.8e1 * t6 * t3532 * t27 * t111 - t3539 / 0.8e1 - 0.3e1 / 0.8e1 * t3434 + t3438 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1398 * t264 - 0.3e1 / 0.8e1 * t3547 + t3314 - 0.5e1 / 0.12e2 * t3317 - 0.3e1 / 0.4e1 * t3447 + t3450 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t529 * t662 - 0.3e1 / 0.8e1 * t3556 - 0.5e1 / 0.36e2 * t3199 + t3204 + t3330 - 0.5e1 / 0.12e2 * t3332 - 0.3e1 / 0.8e1 * t3461 + t3464 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t189 * t1595 - t3566 / 0.8e1;
  t3569 = my_piecewise3(t72, 0, t3568);
  tv4rho43 = 0.3e1 * t1383 + 0.3e1 * t1422 + t1446 + t1600 + t7 * (t3511 + t3569);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t3574 = t550 * t550;
  t3579 = t555 * t555;
  t3586 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1061 + 0.24e2 * t3125);
  t3590 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3111 * t3574 - 0.16e2 / 0.9e1 * t1354 * t555 + 0.4e1 / 0.3e1 * t351 * t3579 + 0.16e2 / 0.9e1 * t496 * t1434 + 0.4e1 / 0.3e1 * t24 * t3586);
  t3599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t3590 * t27 * t67 - t3499 / 0.2e1 + t3348 / 0.2e1 - 0.5e1 / 0.9e1 * t3273 + t3160);
  t3606 = t567 * t567;
  t3611 = t572 * t572;
  t3618 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1061 + 0.24e2 * t3177);
  t3622 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t3606 - 0.16e2 / 0.9e1 * t1384 * t572 + 0.4e1 / 0.3e1 * t468 * t3611 + 0.16e2 / 0.9e1 * t520 * t1454 + 0.4e1 / 0.3e1 * t78 * t3618);
  t3640 = 0.1e1 / t1551 / t95;
  t3641 = t3640 * t106;
  t3642 = t602 * t602;
  t3647 = t633 * t633;
  t3676 = sigma[2] / t84 / t804;
  t3686 = t1495 * t586;
  t3698 = 0.1e1 / t237 / t1505 / t236;
  t3737 = 0.1e1 / t1577 / t105;
  t3738 = t96 * t3737;
  t3739 = t641 * t641;
  t3744 = t657 * t657;
  t3749 = t588 * t229;
  t3759 = 0.128e3 / 0.9e1 * t36 * t224 * t1555 + 0.16e2 / 0.3e1 * t36 * t87 * t3641 * t3642 + 0.4e1 / 0.3e1 * t36 * t87 * t601 * t3647 + 0.704e3 / 0.27e2 * t36 * t589 * t603 + 0.9856e4 / 0.243e3 * t36 * t1491 * t260 + 0.704e3 / 0.27e2 * t36 * t589 * t642 - 0.352e3 / 0.27e2 * t36 * t589 * t634 + 0.64e2 / 0.27e2 * t36 * t224 * t1512 + 0.64e2 / 0.27e2 * t36 * t224 * t1531 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (0.364e4 / 0.81e2 * t43 * t88 * t989 * t92 + 0.5768e4 / 0.27e2 * t43 * t3676 * t238 - 0.18608e5 / 0.81e2 * t43 * t316 / t83 / t2393 * t629 + 0.448e4 / 0.27e2 * t43 * t1003 / t3686 * t1507 - 0.128e4 / 0.27e2 * t43 * t2752 / t84 / t1495 / t804 * t3698) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (0.2e1 * (0.20944e5 / 0.81e2 * t3676 - 0.616e4 / 0.81e2 * lapl[1] * t1490) * t101 * t85 + 0.64e2 / 0.3e1 * t1520 * t97 + 0.16e3 / 0.3e1 * t650 * t84 + 0.64e3 / 0.27e2 * t254 * t1527 - 0.16e3 / 0.81e2 * t102 * t90) + 0.9856e4 / 0.243e3 * t36 * t1491 * t243 - 0.352e3 / 0.27e2 * t36 * t589 * t658 + 0.128e3 / 0.9e1 * t36 * t224 * t1581 + 0.16e2 / 0.3e1 * t36 * t87 * t3738 * t3739 + 0.4e1 / 0.3e1 * t36 * t87 * t640 * t3744 + 0.704e3 / 0.27e2 * t608 * t3749 * t611 - 0.128e3 / 0.9e1 * t608 * t1913 * t1564 - 0.64e2 / 0.9e1 * t608 * t1588 * t1569;
  t3769 = t639 * t602;
  t3774 = t1578 * t242;
  t3804 = t106 * t1511;
  t3814 = t248 * t1530;
  t3824 = t639 * t633;
  t3829 = t242 * t259;
  t3841 = -0.64e2 / 0.9e1 * t608 * t1588 * t1573 - 0.128e3 / 0.9e1 * t608 * t1942 * t1547 + 0.128e3 / 0.9e1 * t608 * t1588 * t1542 + 0.16e2 / 0.3e1 * t608 * t786 * t3769 * t641 + 0.16e2 / 0.3e1 * t608 * t609 * t3774 * t1580 - 0.8e1 * t608 * t778 * t1578 * t641 * t657 + 0.128e3 / 0.9e1 * t608 * t1913 * t1560 + 0.16e2 / 0.3e1 * t608 * t1969 * t248 * t1554 * t259 - 0.8e1 * t608 * t1969 * t1991 * t633 - 0.8e1 / 0.3e1 * t608 * t786 * t1559 * t657 + 0.4e1 / 0.3e1 * t608 * t609 * t1568 * t657 + 0.16e2 / 0.9e1 * t608 * t786 * t3804 * t242 + 0.8e1 / 0.9e1 * t608 * t609 * t248 * t1511 * t259 + 0.8e1 / 0.9e1 * t608 * t609 * t3814 * t242 + 0.16e2 / 0.9e1 * t608 * t778 * t639 * t1530 * t259 - 0.8e1 / 0.3e1 * t608 * t609 * t3824 * t641 - 0.16e2 / 0.3e1 * t608 * t1853 * t3829 * t657 - 0.16e2 / 0.3e1 * t608 * t1847 * t3829 * t633 + 0.41888e5 / 0.729e3 * t36 * t3676 * t107;
  t3848 = -t3539 / 0.2e1 - 0.3e1 / 0.2e1 * t3547 - 0.3e1 / 0.2e1 * t3556 - t3566 / 0.2e1 + t3438 / 0.2e1 + t3450 + t3464 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t3622 * t27 * t111 - 0.3e1 / 0.2e1 * t6 * t1459 * t264 - 0.9e1 / 0.4e1 * t6 * t577 * t662 - 0.3e1 / 0.2e1 * t6 * t217 * t1595 - 0.3e1 / 0.8e1 * t6 * t81 * (t3759 + t3841) - 0.5e1 / 0.9e1 * t3317 - 0.5e1 / 0.9e1 * t3332 + t3204;
  t3849 = my_piecewise3(t72, 0, t3848);
  tv4rho44 = 0.4e1 * t1446 + 0.4e1 * t1600 + t7 * (t3599 + t3849);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t3857 = t6 * t1074 * t297;
  t3863 = t6 * t1081 * t297;
  t3866 = t6 * t369 * t745;
  t3873 = 0.5e1 / 0.36e2 * t6 * t1093 * t297;
  t3875 = t6 * t378 * t745;
  t3878 = t6 * t130 * t1776;
  t3957 = t161 * t1723;
  t3962 = t438 * t717;
  t3971 = -0.2464e4 / 0.243e3 * t272 * t34 * t1104 * t63 - 0.4e1 / 0.3e1 * t36 * t1185 + 0.16e2 / 0.9e1 * t36 * t137 * t1724 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.14e3 / 0.27e2 * t43 * t276 * t1141 * t48 - 0.364e3 / 0.9e1 * t43 * t1104 * t151 + 0.166e4 / 0.27e2 * t43 * t1151 * t428 * sigma[0] - 0.488e3 / 0.9e1 * t43 * t1157 * t1161 * t287 + 0.16e3 / 0.9e1 * t43 / t39 / t1149 / t933 * t3022 * t949) + 0.4e1 / 0.3e1 * t36 * t1189 + 0.2e1 / 0.3e1 * t36 * t1194 + 0.2e1 / 0.3e1 * t36 * t1198 + 0.4e1 / 0.3e1 * t36 * t1211 + 0.16e2 / 0.9e1 * t36 * t137 * t1697 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.2e1 * t1109 * t288 * t40 - 0.16e2 * t1689 * t53 - 0.8e2 / 0.3e1 * t735 * t39 - 0.16e3 / 0.27e2 * t289 * t1117) - 0.32e2 / 0.9e1 * t36 * t1218 + 0.2464e4 / 0.243e3 * t36 * t1105 * t284 + 0.2464e4 / 0.243e3 * t36 * t1105 * t293 - 0.4e1 / 0.3e1 * t36 * t1172 - 0.176e3 / 0.27e2 * t36 * t388 * t718 - 0.176e3 / 0.27e2 * t36 * t388 * t741 + 0.2e1 / 0.3e1 * t407 * t408 * t3957 * t172 - 0.4e1 / 0.3e1 * t407 * t408 * t3962 * t440 - 0.4e1 / 0.3e1 * t407 * t692 * t1660 * t401;
  t3972 = t1202 * t740;
  t3985 = t161 * t1696;
  t4048 = -0.4e1 * t407 * t684 * t3972 * t440 - 0.4e1 * t407 * t1770 * t1676 * t401 + 0.4e1 / 0.3e1 * t407 * t684 * t1635 * t456 + 0.2e1 / 0.3e1 * t407 * t408 * t3985 * t155 + 0.4e1 / 0.3e1 * t407 * t684 * t438 * t1696 * t172 - 0.64e2 / 0.9e1 * t407 * t1669 * t1677 - 0.32e2 / 0.9e1 * t407 * t1217 * t1645 - 0.32e2 / 0.9e1 * t407 * t1217 * t1661 - 0.64e2 / 0.9e1 * t407 * t1656 * t1636 - 0.32e2 / 0.9e1 * t407 * t1669 * t1681 + 0.4e1 / 0.3e1 * t407 * t692 * t1676 * t432 + 0.4e1 / 0.9e1 * t407 * t692 * t693 * t1165 - 0.16e2 / 0.9e1 * t407 * t1217 * t1665 + 0.2e1 / 0.3e1 * t407 * t408 * t1660 * t432 + 0.2e1 / 0.9e1 * t407 * t408 * t725 * t1165 + 0.352e3 / 0.27e2 * t407 * t387 * t399 * t694 + 0.176e3 / 0.27e2 * t407 * t2980 * t699 + 0.4e1 / 0.9e1 * t407 * t684 * t730 * t1120 + 0.2e1 / 0.3e1 * t407 * t408 * t1644 * t456 + 0.2e1 / 0.9e1 * t407 * t408 * t698 * t1120;
  t4053 = t387 * t52;
  t4057 = t62 * t1723;
  t4068 = t3070 * t292;
  t4073 = t136 * t1176;
  t4077 = t41 * t3086;
  t4085 = t1202 * t283;
  t4100 = t1217 * t438;
  t4104 = t408 * t1202;
  t4109 = t1669 * t161;
  t4113 = t692 * t438;
  t4128 = 0.176e3 / 0.27e2 * t407 * t2980 * t726 + 0.352e3 / 0.27e2 * t407 * t4053 * t731 + 0.4e1 / 0.3e1 * t407 * t692 * t4057 * t155 - 0.32e2 / 0.9e1 * t407 * t1656 * t1640 - 0.16e2 / 0.9e1 * t407 * t1217 * t1649 + 0.16e2 / 0.3e1 * t407 * t684 * t4068 * t1204 + 0.32e2 / 0.3e1 * t407 * t4073 * t1771 + 0.16e2 / 0.3e1 * t407 * t4077 * t693 * t1178 + 0.32e2 / 0.9e1 * t407 * t1217 * t1757 + 0.4e1 / 0.3e1 * t407 * t408 * t4085 * t1204 + 0.32e2 / 0.9e1 * t407 * t1669 * t1761 + 0.4e1 / 0.3e1 * t407 * t1770 * t725 * t1178 + 0.32e2 / 0.3e1 * t407 * t1656 * t1766 + 0.64e2 / 0.9e1 * t407 * t4100 * t1631 + 0.4e1 * t407 * t4104 * t1630 * t440 + 0.64e2 / 0.9e1 * t407 * t4109 * t1625 + 0.8e1 / 0.3e1 * t407 * t4113 * t292 * t401 * t172 - 0.4e1 / 0.3e1 * t407 * t1623 * t1630 * t432 - 0.8e1 / 0.3e1 * t407 * t1629 * t740 * t155 * t172;
  t4138 = t684 * t1202;
  t4139 = t292 * t172;
  t4144 = t1770 * t161;
  t4150 = t1770 * t62;
  t4174 = t283 * t172;
  t4211 = -0.4e1 / 0.3e1 * t407 * t1629 * t292 * t432 * t172 - 0.4e1 / 0.3e1 * t407 * t1629 * t1630 * t456 - 0.4e1 * t407 * t4138 * t4139 * t456 + 0.4e1 * t407 * t4144 * t283 * t401 * t172 - 0.4e1 * t407 * t4150 * t1624 * t432 - 0.8e1 / 0.3e1 * t407 * t1623 * t717 * t155 * t172 - 0.4e1 / 0.3e1 * t407 * t1623 * t283 * t432 * t172 - 0.4e1 / 0.3e1 * t407 * t1623 * t1624 * t456 + 0.8e1 / 0.3e1 * t407 * t4113 * t283 * t440 * t155 - 0.4e1 / 0.3e1 * t407 * t1629 * t4174 * t456 - 0.176e3 / 0.27e2 * t36 * t2980 * t680 - 0.176e3 / 0.27e2 * t36 * t4053 * t685 + 0.16e2 / 0.9e1 * t36 * t1217 * t1740 + 0.16e2 / 0.9e1 * t36 * t1656 * t1744 - 0.2e1 / 0.9e1 * t36 * t408 * t2951 - 0.2e1 / 0.9e1 * t36 * t684 * t2920 - 0.4e1 / 0.3e1 * t36 * t1770 * t62 * t1178 - 0.4e1 / 0.3e1 * t36 * t684 * t1202 * t1204 - 0.32e2 / 0.9e1 * t36 * t1656 * t1752 - 0.32e2 / 0.9e1 * t36 * t1669 * t1748;
  t4218 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t297 - 0.3e1 / 0.8e1 * t3857 - 0.9e1 / 0.8e1 * t6 * t365 * t745 + t3863 / 0.4e1 - 0.3e1 / 0.4e1 * t3866 - 0.9e1 / 0.8e1 * t6 * t124 * t1776 - t3873 + t3875 / 0.4e1 - 0.3e1 / 0.8e1 * t3878 - 0.3e1 / 0.8e1 * t6 * t28 * (t3971 + t4048 + t4128 + t4211));
  tv4rho3sigma0 = t7 * t4218 + 0.3e1 * t1781;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t4225 = t6 * t1250 * t326;
  t4228 = t6 * t1254 * t326;
  t4232 = 0.5e1 / 0.36e2 * t6 * t1258 * t326;
  t4234 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t326 - 0.3e1 / 0.8e1 * t4225 + t4228 / 0.4e1 - t4232);
  tv4rho3sigma2 = t7 * t4234 + 0.3e1 * t1794;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t4236 = 0.2e1 * t1808;
  t4242 = t6 * t1288 * t297 / 0.4e1;
  t4247 = t6 * t1295 * t297;
  t4251 = t6 * t509 * t745 / 0.4e1;
  t4260 = -0.3e1 / 0.8e1 * t6 * t1284 * t297 - t4242 - 0.3e1 / 0.4e1 * t6 * t505 * t745 + t4247 / 0.12e2 - t4251 - 0.3e1 / 0.8e1 * t6 * t206 * t1776 - t3857 / 0.8e1 + t3863 / 0.6e1 - t3866 / 0.4e1 - t3873 + t3875 / 0.6e1 - t3878 / 0.8e1;
  t4261 = my_piecewise3(t2, 0, t4260);
  tv4rho3sigma3 = t7 * t4261 + t1781 + t4236;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t4263 = 0.2e1 * t1824;
  t4269 = t6 * t1331 * t326 / 0.4e1;
  t4271 = t6 * t1335 * t326;
  t4280 = t6 * t484 * t839 / 0.4e1;
  t4282 = t6 * t488 * t839;
  t4285 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t326 - t4269 + t4271 / 0.12e2 - t4225 / 0.8e1 + t4228 / 0.6e1 - t4232 - 0.3e1 / 0.8e1 * t6 * t480 * t839 - t4280 + t4282 / 0.12e2);
  tv4rho3sigma5 = t7 * t4285 + t1794 + t4263;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t4291 = t6 * t1372 * t297;
  t4300 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t297 - t4291 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t745 - t4242 + t4247 / 0.6e1 - t4251 + t3863 / 0.12e2 - t3873 + t3875 / 0.12e2);
  tv4rho3sigma6 = t7 * t4300 + t1832 + t4236;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t4306 = t6 * t1402 * t326;
  t4313 = t6 * t533 * t839;
  t4321 = t6 * t193 * t2000;
  t4323 = -0.3e1 / 0.8e1 * t6 * t1398 * t326 - t4306 / 0.8e1 - t4269 + t4271 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t839 - t4313 / 0.4e1 + t4228 / 0.12e2 - t4232 - t4280 + t4282 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t2000 - t4321 / 0.8e1;
  t4324 = my_piecewise3(t72, 0, t4323);
  tv4rho3sigma8 = t7 * t4324 + t2005 + t4263;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t4333 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t297 - 0.3e1 / 0.8e1 * t4291 + t4247 / 0.4e1 - t3873);
  tv4rho3sigma9 = t7 * t4333 + 0.3e1 * t1832;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t4430 = t1578 * t312;
  t4439 = -0.2464e4 / 0.243e3 * t272 * t34 * t1490 * t107 - 0.4e1 / 0.3e1 * t36 * t1561 - 0.32e2 / 0.9e1 * t36 * t1589 + 0.4e1 / 0.3e1 * t36 * t1565 + 0.2e1 / 0.3e1 * t36 * t1570 + 0.2e1 / 0.3e1 * t36 * t1574 + 0.4e1 / 0.3e1 * t36 * t1548 - 0.176e3 / 0.27e2 * t36 * t589 * t835 + 0.2464e4 / 0.243e3 * t36 * t1491 * t313 - 0.4e1 / 0.3e1 * t36 * t1543 - 0.176e3 / 0.27e2 * t36 * t589 * t812 + 0.2464e4 / 0.243e3 * t36 * t1491 * t322 + 0.16e2 / 0.9e1 * t36 * t224 * t1897 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.14e3 / 0.27e2 * t43 * t305 * t1484 * t92 - 0.364e3 / 0.9e1 * t43 * t1490 * t238 + 0.166e4 / 0.27e2 * t43 * t1497 * t629 * sigma[2] - 0.488e3 / 0.9e1 * t43 * t1503 * t1507 * t316 + 0.16e3 / 0.9e1 * t43 / t84 / t1495 / t987 * t3698 * t1003) + 0.16e2 / 0.9e1 * t36 * t224 * t1870 - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.2e1 * t1519 * t317 * t85 - 0.16e2 * t1862 * t97 - 0.8e2 / 0.3e1 * t829 * t84 - 0.16e3 / 0.27e2 * t318 * t1527) + 0.32e2 / 0.9e1 * t608 * t1588 * t1905 + 0.4e1 / 0.3e1 * t608 * t609 * t4430 * t1580 + 0.4e1 / 0.3e1 * t608 * t1969 * t819 * t1554;
  t4440 = t3737 * t321;
  t4445 = t223 * t1552;
  t4449 = t86 * t3640;
  t4458 = t1578 * t834;
  t4481 = t248 * t1869;
  t4502 = t588 * t96;
  t4518 = 0.16e2 / 0.3e1 * t608 * t778 * t4440 * t1580 + 0.32e2 / 0.3e1 * t608 * t4445 * t1970 + 0.16e2 / 0.3e1 * t608 * t4449 * t787 * t1554 - 0.4e1 / 0.3e1 * t608 * t786 * t1946 * t602 - 0.4e1 * t608 * t778 * t4458 * t641 + 0.32e2 / 0.9e1 * t608 * t1913 * t1909 + 0.32e2 / 0.3e1 * t608 * t1942 * t1965 - 0.32e2 / 0.9e1 * t608 * t1588 * t1947 - 0.16e2 / 0.9e1 * t608 * t1588 * t1951 - 0.64e2 / 0.9e1 * t608 * t1942 * t1956 - 0.32e2 / 0.9e1 * t608 * t1942 * t1960 + 0.2e1 / 0.3e1 * t608 * t609 * t4481 * t242 + 0.2e1 / 0.3e1 * t608 * t609 * t1946 * t633 + 0.2e1 / 0.9e1 * t608 * t609 * t819 * t1511 + 0.4e1 / 0.3e1 * t608 * t778 * t639 * t1869 * t259 + 0.176e3 / 0.27e2 * t608 * t3749 * t820 + 0.352e3 / 0.27e2 * t608 * t4502 * t825 + 0.4e1 / 0.9e1 * t608 * t786 * t787 * t1511 + 0.2e1 / 0.3e1 * t608 * t609 * t1929 * t657 - 0.4e1 * t608 * t1969 * t1920 * t602;
  t4520 = t639 * t811;
  t4538 = t106 * t1896;
  t4543 = t248 * t1896;
  t4570 = t312 * t259;
  t4575 = t786 * t639;
  t4581 = t609 * t1578;
  t4587 = t1969 * t248;
  t4593 = t1969 * t106;
  t4603 = -0.4e1 / 0.3e1 * t608 * t609 * t4520 * t641 + 0.352e3 / 0.27e2 * t608 * t588 * t600 * t788 + 0.176e3 / 0.27e2 * t608 * t3749 * t793 - 0.64e2 / 0.9e1 * t608 * t1913 * t1921 - 0.32e2 / 0.9e1 * t608 * t1588 * t1930 + 0.4e1 / 0.3e1 * t608 * t786 * t4538 * t242 + 0.2e1 / 0.3e1 * t608 * t609 * t4543 * t259 + 0.4e1 / 0.3e1 * t608 * t778 * t1955 * t657 + 0.4e1 / 0.9e1 * t608 * t778 * t824 * t1530 + 0.2e1 / 0.9e1 * t608 * t609 * t792 * t1530 - 0.32e2 / 0.9e1 * t608 * t1913 * t1925 - 0.16e2 / 0.9e1 * t608 * t1588 * t1935 + 0.4e1 / 0.3e1 * t608 * t786 * t1920 * t633 - 0.4e1 / 0.3e1 * t608 * t1853 * t4570 * t657 + 0.8e1 / 0.3e1 * t608 * t4575 * t321 * t602 * t259 + 0.4e1 * t608 * t4581 * t321 * t641 * t242 + 0.4e1 * t608 * t4587 * t312 * t602 * t259 - 0.4e1 * t608 * t4593 * t1848 * t633 - 0.8e1 / 0.3e1 * t608 * t1853 * t834 * t242 * t259;
  t4604 = t321 * t633;
  t4613 = t321 * t657;
  t4618 = t778 * t1578;
  t4623 = t1588 * t639;
  t4627 = t1913 * t248;
  t4681 = -0.4e1 / 0.3e1 * t608 * t1847 * t4604 * t242 - 0.4e1 / 0.3e1 * t608 * t1853 * t4604 * t259 - 0.4e1 / 0.3e1 * t608 * t1853 * t4613 * t242 - 0.4e1 * t608 * t4618 * t4613 * t259 + 0.64e2 / 0.9e1 * t608 * t4623 * t1855 + 0.64e2 / 0.9e1 * t608 * t4627 * t1849 + 0.8e1 / 0.3e1 * t608 * t4575 * t1848 * t641 - 0.8e1 / 0.3e1 * t608 * t1847 * t811 * t242 * t259 - 0.4e1 / 0.3e1 * t608 * t1847 * t312 * t633 * t259 - 0.4e1 / 0.3e1 * t608 * t1847 * t1848 * t657 - 0.4e1 / 0.3e1 * t36 * t1969 * t106 * t1554 - 0.4e1 / 0.3e1 * t36 * t778 * t1578 * t1580 - 0.32e2 / 0.9e1 * t36 * t1913 * t1991 - 0.32e2 / 0.9e1 * t36 * t1942 * t1995 - 0.176e3 / 0.27e2 * t36 * t3749 * t774 - 0.176e3 / 0.27e2 * t36 * t4502 * t779 + 0.16e2 / 0.9e1 * t36 * t1588 * t1983 + 0.16e2 / 0.9e1 * t36 * t1942 * t1987 - 0.2e1 / 0.9e1 * t36 * t609 * t3804 - 0.2e1 / 0.9e1 * t36 * t778 * t3814;
  t4688 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t326 - 0.3e1 / 0.8e1 * t4306 - 0.9e1 / 0.8e1 * t6 * t577 * t839 + t4271 / 0.4e1 - 0.3e1 / 0.4e1 * t4313 - 0.9e1 / 0.8e1 * t6 * t217 * t2000 - t4232 + t4282 / 0.4e1 - 0.3e1 / 0.8e1 * t4321 - 0.3e1 / 0.8e1 * t6 * t81 * (t4439 + t4518 + t4603 + t4681));
  tv4rho3sigma11 = t7 * t4688 + 0.3e1 * t2005;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t4691 = t1092 * params->beta;
  t4694 = 0.5e1 / 0.27e2 * t331 * t4691 * t336;
  t4695 = t2025 * t855;
  t4698 = t846 * t2024 * t336;
  t4700 = t2015 * t855;
  t4707 = t2046 * t850 * t336;
  t4711 = t851 * t2037;
  t4719 = t1176 * t161;
  t4724 = -t4694 - 0.5e1 / 0.9e1 * t4695 + t4698 / 0.3e1 + 0.5e1 / 0.3e1 * t4700 - t5 * t1069 * t332 * t336 / 0.2e1 - t4707 / 0.2e1 + 0.5e1 / 0.2e1 * t2047 * t855 - 0.2e2 / 0.9e1 * t4711 + 0.22e3 / 0.27e2 * t333 * t35 * t4053 * t161 - 0.2e2 / 0.3e1 * t847 * t2037 + 0.3e1 * t859 * t860 * t4719 * t1178;
  t4725 = t2031 * t2051;
  t4735 = t2031 * t2056;
  t4736 = t2031 * t2009;
  t4741 = t2031 * t2013;
  t4747 = t2046 * t858;
  t4752 = -0.3e1 * t4725 + 0.5e1 * t859 * t273 * t2055 + 0.15e2 * t859 * t273 * t2050 - 0.9e1 * t2020 * t2051 - t4735 + t4736 / 0.2e1 - 0.5e1 / 0.2e1 * t859 * t273 * t2008 + t4741 - 0.5e1 * t859 * t273 * t2012 - 0.3e1 * t2020 * t2056 + 0.3e1 / 0.2e1 * t4747 * t863 + 0.3e1 * t4747 * t867;
  t4754 = t2024 * t33;
  t4755 = t331 * t4754;
  t4756 = t4755 * t863;
  t4758 = t4755 * t867;
  t4771 = t846 * t2030;
  t4772 = t4771 * t863;
  t4773 = t4771 * t867;
  t4779 = t2031 * t2040;
  t4781 = t2031 * t2043;
  t4786 = -t4756 / 0.3e1 - 0.2e1 / 0.3e1 * t4758 + 0.3e1 / 0.2e1 * t2020 * t2009 + t859 * t860 * t861 * t1165 / 0.2e1 + 0.3e1 * t2020 * t2013 + t859 * t860 * t439 * t1120 + t4772 + 0.2e1 * t4773 + 0.12e2 * t859 * t860 * t3071 * t1204 - 0.5e1 / 0.3e1 * t4779 - 0.1e2 / 0.3e1 * t4781 + 0.2e2 / 0.3e1 * t859 * t676 * t862;
  t4794 = t273 * t142;
  t4800 = t2031 * t2060;
  t4828 = 0.4e2 / 0.3e1 * t859 * t676 * t866 - 0.5e1 * t2020 * t2040 - 0.1e2 * t2020 * t2043 + 0.1e2 * t859 * t4794 * t2059 - 0.6e1 * t2020 * t2060 - 0.2e1 * t4800 - 0.3e1 * t859 * t2490 * t1192 * t155 - 0.3e1 * t859 * t2058 * t2961 * t172 - 0.3e1 * t859 * t2058 * t438 * t456 * t155 - 0.9e1 * t859 * t2510 * t1202 * t456 * t172 + 0.9e1 * t859 * t2058 * t2946 * t155 + 0.6e1 * t859 * t2490 * t2936 * t172;
  t4831 = my_piecewise3(t2, 0, t4724 + t4752 + t4786 + t4828);
  tv4rho3lapl0 = t7 * t4831 + 0.3e1 * t2064;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t4839 = t2067 * t850 * t344;
  t4842 = t872 * t2024 * t344;
  t4846 = 0.5e1 / 0.27e2 * t340 * t4691 * t344;
  t4848 = my_piecewise3(t72, 0, -t5 * t1245 * t332 * t344 / 0.2e1 - t4839 / 0.2e1 + t4842 / 0.3e1 - t4846);
  tv4rho3lapl1 = t7 * t4848 + 0.3e1 * t2078;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t4850 = 0.2e1 * t2098;
  t4860 = t882 * t2024 * t336;
  t4863 = 0.5e1 / 0.9e1 * t2084 * t855;
  t4868 = t2080 * t850 * t336 / 0.3e1;
  t4875 = t882 * t2030;
  t4877 = t4875 * t863 / 0.3e1;
  t4879 = 0.2e1 / 0.3e1 * t4875 * t867;
  t4882 = -t5 * t1283 * t332 * t336 / 0.2e1 - t4694 - 0.1e2 / 0.27e2 * t4695 + 0.2e1 / 0.9e1 * t4698 + 0.5e1 / 0.9e1 * t4700 - t4707 / 0.6e1 + t4860 / 0.9e1 + t4863 - 0.2e2 / 0.9e1 * t883 * t2037 - t4868 + 0.5e1 / 0.3e1 * t2081 * t855 - 0.2e2 / 0.27e2 * t4711 - t2089 * t2056 - 0.3e1 * t2089 * t2051 + t4877 + t4879 - 0.5e1 / 0.3e1 * t2089 * t2040;
  t4888 = t2080 * t858;
  t4904 = -0.1e2 / 0.3e1 * t2089 * t2043 + t2089 * t2009 / 0.2e1 + t2089 * t2013 + t4888 * t863 + 0.2e1 * t4888 * t867 - t4725 - t4735 / 0.3e1 + t4736 / 0.6e1 + t4741 / 0.3e1 - 0.2e1 / 0.9e1 * t4756 - 0.4e1 / 0.9e1 * t4758 + t4772 / 0.3e1 + 0.2e1 / 0.3e1 * t4773 - 0.5e1 / 0.9e1 * t4779 - 0.1e2 / 0.9e1 * t4781 - 0.2e1 * t2089 * t2060 - 0.2e1 / 0.3e1 * t4800;
  t4906 = my_piecewise3(t2, 0, t4882 + t4904);
  tv4rho3lapl2 = t7 * t4906 + t2064 + t4850;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t4908 = 0.2e1 * t2122;
  t4915 = t2100 * t850 * t344 / 0.3e1;
  t4917 = t889 * t2024 * t344;
  t4924 = 0.5e1 / 0.9e1 * t2071 * t894;
  t4925 = t2074 * t894;
  t4927 = t2067 * t858;
  t4930 = t872 * t2030;
  t4932 = t4930 * t901 / 0.3e1;
  t4933 = t340 * t4754;
  t4934 = t4933 * t901;
  t4938 = 0.2e1 / 0.3e1 * t4930 * t905;
  t4939 = t4933 * t905;
  t4941 = -t5 * t1326 * t332 * t344 / 0.2e1 - t4915 + t4917 / 0.9e1 - t4839 / 0.6e1 + 0.2e1 / 0.9e1 * t4842 - t4846 + 0.5e1 / 0.6e1 * t2068 * t894 + t4924 - 0.5e1 / 0.27e2 * t4925 + t4927 * t901 / 0.2e1 + t4932 - t4934 / 0.9e1 + t4927 * t905 + t4938 - 0.2e1 / 0.9e1 * t4939;
  t4942 = my_piecewise3(t72, 0, t4941);
  tv4rho3lapl3 = t7 * t4942 + t2078 + t4908;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t4949 = t2125 * t850 * t336;
  t4953 = t2125 * t858;
  t4962 = -t5 * t1367 * t332 * t336 / 0.2e1 - t4949 / 0.6e1 + 0.5e1 / 0.6e1 * t2126 * t855 + t4953 * t863 / 0.2e1 + t4953 * t867 - t4868 + 0.2e1 / 0.9e1 * t4860 + t4863 + t4877 + t4879 + t4698 / 0.9e1 - t4694 - 0.5e1 / 0.27e2 * t4695 - t4756 / 0.9e1 - 0.2e1 / 0.9e1 * t4758;
  t4963 = my_piecewise3(t2, 0, t4962);
  tv4rho3lapl4 = t7 * t4963 + t2131 + t4850;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t4966 = t2159 * t850 * t344;
  t4978 = t2104 * t894;
  t4980 = t876 * t2154;
  t4983 = t2115 * t2175;
  t4985 = t889 * t2030;
  t4986 = t4985 * t901;
  t4988 = t4985 * t905;
  t4990 = t2115 * t2169;
  t4991 = t2115 * t2137;
  t4993 = -t4966 / 0.6e1 - t5 * t1397 * t332 * t344 / 0.2e1 + 0.5e1 / 0.3e1 * t2101 * t894 - 0.2e2 / 0.9e1 * t873 * t2154 - t4915 + 0.2e1 / 0.9e1 * t4917 + t4924 - 0.1e2 / 0.27e2 * t4925 + 0.5e1 / 0.9e1 * t4978 - 0.2e2 / 0.27e2 * t4980 + t4842 / 0.9e1 - t4846 - t4983 / 0.3e1 + t4986 / 0.3e1 + 0.2e1 / 0.3e1 * t4988 - t4990 - 0.1e2 / 0.9e1 * t4991;
  t4994 = t2115 * t2141;
  t4996 = t2115 * t2145;
  t4998 = t2115 * t2134;
  t5003 = t2100 * t858;
  t5016 = t2115 * t2165;
  t5020 = t4994 / 0.6e1 + t4996 / 0.3e1 - 0.5e1 / 0.9e1 * t4998 - 0.3e1 * t2112 * t2169 - t2112 * t2175 + t5003 * t901 + 0.2e1 * t5003 * t905 - 0.5e1 / 0.3e1 * t2112 * t2134 - 0.1e2 / 0.3e1 * t2112 * t2137 + t2112 * t2141 / 0.2e1 + t2112 * t2145 + t4932 - 0.2e1 / 0.9e1 * t4934 + t4938 - 0.4e1 / 0.9e1 * t4939 - 0.2e1 / 0.3e1 * t5016 - 0.2e1 * t2112 * t2165;
  t5022 = my_piecewise3(t72, 0, t4993 + t5020);
  tv4rho3lapl5 = t7 * t5022 + t2179 + t4908;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t5032 = my_piecewise3(t2, 0, -t5 * t1438 * t332 * t336 / 0.2e1 - t4949 / 0.2e1 + t4860 / 0.3e1 - t4694);
  tv4rho3lapl6 = t7 * t5032 + 0.3e1 * t2131;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t5056 = -t5 * t1458 * t332 * t344 / 0.2e1 + 0.5e1 / 0.2e1 * t2160 * t894 - t4966 / 0.2e1 - 0.2e2 / 0.3e1 * t890 * t2154 + 0.22e3 / 0.27e2 * t341 * t35 * t4502 * t248 + t4917 / 0.3e1 - 0.5e1 / 0.9e1 * t4925 + 0.5e1 / 0.3e1 * t4978 - 0.2e2 / 0.9e1 * t4980 - t4846 + t897 * t898 * t899 * t1511 / 0.2e1;
  t5082 = t2159 * t858;
  t5089 = 0.12e2 * t897 * t898 * t3738 * t1580 - 0.3e1 * t2149 * t2175 - 0.9e1 * t2149 * t2169 + 0.2e2 / 0.3e1 * t897 * t770 * t900 + 0.5e1 * t897 * t302 * t2174 + 0.4e2 / 0.3e1 * t897 * t770 * t904 + 0.15e2 * t897 * t302 * t2168 + 0.3e1 * t2149 * t2145 + t897 * t898 * t640 * t1530 + 0.3e1 / 0.2e1 * t5082 * t901 + 0.3e1 * t5082 * t905 - 0.5e1 * t2149 * t2134;
  t5106 = -0.5e1 / 0.2e1 * t897 * t302 * t2140 - 0.1e2 * t2149 * t2137 - 0.5e1 * t897 * t302 * t2144 + 0.3e1 / 0.2e1 * t2149 * t2141 - t4983 + t4986 + 0.2e1 * t4988 - 0.3e1 * t4990 - 0.1e2 / 0.3e1 * t4991 + t4994 / 0.2e1 + t4996 - 0.5e1 / 0.3e1 * t4998;
  t5107 = t1552 * t248;
  t5143 = t302 * t229;
  t5147 = 0.3e1 * t897 * t898 * t5107 * t1554 - t4934 / 0.3e1 - 0.2e1 / 0.3e1 * t4939 + 0.6e1 * t897 * t2542 * t3769 * t259 + 0.9e1 * t897 * t2163 * t3774 * t641 - 0.3e1 * t897 * t2542 * t1568 * t242 - 0.3e1 * t897 * t2163 * t3824 * t259 - 0.2e1 * t5016 - 0.3e1 * t897 * t2163 * t639 * t657 * t242 - 0.9e1 * t897 * t2560 * t1578 * t657 * t259 - 0.6e1 * t2149 * t2165 + 0.1e2 * t897 * t5143 * t2164;
  t5150 = my_piecewise3(t72, 0, t5056 + t5089 + t5106 + t5147);
  tv4rho3lapl7 = t7 * t5150 + 0.3e1 * t2179;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t5157 = t6 * t369 * t959;
  t5164 = t6 * t378 * t959 / 0.12e2;
  t5166 = t6 * t130 * t2319;
  t5183 = t438 * t939;
  t5194 = t1202 * t954;
  t5203 = t438 * t916;
  t5208 = t3070 * t944;
  t5217 = 0.32e2 / 0.9e1 * t272 * t34 * sigma[0] * t41 * t399 * t438 * t283 * t1631 + 0.352e3 / 0.81e2 * t407 * t2980 * t921 - 0.4e1 / 0.3e1 * t407 * t1770 * t2293 * t401 - 0.4e1 / 0.9e1 * t407 * t408 * t5183 * t440 - 0.64e2 / 0.27e2 * t407 * t1217 * t2285 - 0.64e2 / 0.27e2 * t407 * t1217 * t2289 - 0.4e1 / 0.3e1 * t407 * t684 * t5194 * t440 + 0.16e2 / 0.3e1 * t407 * t4077 * t2271 * t401 + 0.8e1 / 0.9e1 * t407 * t692 * t5203 * t440 + 0.16e2 / 0.3e1 * t407 * t684 * t5208 * t440 - 0.4e1 / 0.9e1 * t407 * t692 * t2261 * t401;
  t5260 = 0.8e1 / 0.9e1 * t407 * t692 * t2246 * t401 + 0.8e1 / 0.9e1 * t407 * t684 * t438 * t2241 * t172 + 0.4e1 / 0.9e1 * t407 * t684 * t2266 * t456 + 0.64e2 / 0.9e1 * t407 * t4073 * t2272 + 0.64e2 / 0.27e2 * t407 * t1669 * t2277 - 0.128e3 / 0.27e2 * t407 * t1669 * t2281 - 0.4e1 / 0.3e1 * t407 * t1770 * t2271 * t432 - 0.4e1 / 0.9e1 * t407 * t692 * t2276 * t456 + 0.8e1 / 0.9e1 * t407 * t692 * t693 * t1723 - 0.4e1 / 0.9e1 * t407 * t408 * t2246 * t432 - 0.4e1 / 0.3e1 * t407 * t684 * t2251 * t456;
  t5272 = t161 * t2241;
  t5291 = t30 * t35 * t41;
  t5295 = t142 * t438;
  t5303 = 0.8e1 / 0.9e1 * t407 * t684 * t730 * t1696 - 0.32e2 / 0.27e2 * t407 * t1217 * t2262 - 0.64e2 / 0.27e2 * t407 * t1656 * t2267 + 0.4e1 / 0.9e1 * t407 * t408 * t5272 * t155 + 0.2e1 / 0.9e1 * t407 * t408 * t2261 * t432 + 0.64e2 / 0.27e2 * t407 * t1217 * t2247 + 0.64e2 / 0.9e1 * t407 * t1656 * t2252 - 0.128e3 / 0.27e2 * t407 * t1656 * t2257 - 0.16e2 / 0.9e1 * t5291 * t2054 * t1625 - 0.16e2 / 0.9e1 * t5291 * t5295 * t1631 + 0.4e1 / 0.9e1 * t407 * t408 * t3957 * t292;
  t5318 = t62 * t2231;
  t5327 = t161 * t2231;
  t5353 = 0.8e1 / 0.9e1 * t407 * t408 * t1644 * t740 + 0.4e1 / 0.9e1 * t407 * t408 * t698 * t1696 - 0.64e2 / 0.27e2 * t407 * t1669 * t2294 - 0.32e2 / 0.27e2 * t407 * t1217 * t2299 + 0.8e1 / 0.9e1 * t407 * t692 * t5318 * t155 + 0.4e1 / 0.9e1 * t407 * t692 * t2293 * t432 + 0.4e1 / 0.9e1 * t407 * t408 * t5327 * t172 + 0.2e1 / 0.9e1 * t407 * t408 * t2298 * t456 + 0.8e1 / 0.3e1 * t407 * t4104 * t944 * t155 * t172 - 0.16e2 / 0.9e1 * t407 * t1629 * t1630 * t740 + 0.8e1 / 0.3e1 * t407 * t4104 * t2187 * t440 + 0.8e1 / 0.3e1 * t407 * t4144 * t2187 * t401;
  t5356 = t717 * t292;
  t5361 = t283 * t740;
  t5402 = -0.16e2 / 0.9e1 * t407 * t1629 * t5356 * t172 - 0.16e2 / 0.9e1 * t407 * t1623 * t5361 * t155 - 0.16e2 / 0.9e1 * t407 * t1629 * t5361 * t172 + 0.8e1 / 0.3e1 * t407 * t4144 * t916 * t155 * t172 - 0.16e2 / 0.3e1 * t407 * t4150 * t1624 * t717 - 0.16e2 / 0.9e1 * t407 * t1623 * t4174 * t717 - 0.16e2 / 0.3e1 * t407 * t4138 * t4139 * t740 - 0.8e1 / 0.9e1 * t407 * t1629 * t954 * t155 * t172 + 0.128e3 / 0.27e2 * t407 * t4109 * t2188 + 0.128e3 / 0.27e2 * t407 * t4100 * t2192 - 0.8e1 / 0.9e1 * t407 * t1623 * t2187 * t432;
  t5467 = -0.8e1 / 0.9e1 * t407 * t1629 * t2187 * t456 - 0.8e1 / 0.9e1 * t407 * t1623 * t939 * t155 * t172 - 0.16e2 / 0.9e1 * t407 * t1623 * t5356 * t155 + 0.4e1 / 0.9e1 * t36 * t1666 + 0.8e1 / 0.9e1 * t36 * t1641 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.7e1 / 0.9e1 * t43 * t926 * t415 * t48 + 0.7e1 / 0.9e1 * t43 * t57 * t387 * t151 - 0.11e2 * t43 * t1713 + 0.47e2 / 0.3e1 * t43 * t1719 * sigma[0] - 0.2e2 / 0.3e1 * t43 / t39 / t3010 * t3022 * t287) - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (0.4e1 * t448 * t950 * t40 + 0.64e2 / 0.3e1 * t2236 * t53 + 0.16e3 / 0.9e1 * t951 * t39) + 0.32e2 / 0.27e2 * t36 * t137 * t2232 + 0.16e2 / 0.9e1 * t36 * t1678 + 0.8e1 / 0.9e1 * t36 * t1646 + 0.8e1 / 0.9e1 * t36 * t1662 + 0.16e2 / 0.9e1 * t36 * t1637;
  t5494 = 0.8e1 / 0.9e1 * t36 * t1682 + 0.4e1 / 0.9e1 * t36 * t1650 + 0.32e2 / 0.27e2 * t36 * t137 * t2242 - 0.8e1 / 0.3e1 * t36 * t1767 - 0.128e3 / 0.27e2 * t36 * t1670 - 0.8e1 / 0.3e1 * t36 * t1772 - 0.64e2 / 0.27e2 * t36 * t1673 - 0.8e1 / 0.9e1 * t36 * t1758 - 0.8e1 / 0.9e1 * t36 * t1762 - 0.176e3 / 0.81e2 * t36 * t388 * t940 + 0.352e3 / 0.81e2 * t36 * t388 * t917;
  t5495 = t717 * t717;
  t5500 = t740 * t740;
  t5533 = 0.8e1 / 0.9e1 * t36 * t42 * t400 * t5495 + 0.8e1 / 0.9e1 * t36 * t42 * t439 * t5500 - 0.176e3 / 0.81e2 * t36 * t388 * t955 + 0.352e3 / 0.81e2 * t36 * t388 * t945 - 0.64e2 / 0.27e2 * t36 * t1653 - 0.128e3 / 0.27e2 * t36 * t1657 - 0.352e3 / 0.81e2 * t36 * t4053 * t725 - 0.352e3 / 0.81e2 * t36 * t2980 * t693 + 0.64e2 / 0.27e2 * t36 * t1217 * t1676 + 0.64e2 / 0.27e2 * t36 * t1656 * t1660 - 0.4e1 / 0.9e1 * t36 * t408 * t4057 - 0.4e1 / 0.9e1 * t36 * t684 * t3985;
  t5541 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t959 - t5157 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t2319 + t5164 - t5166 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t5217 + t5260 + t5303 + t5353 + t5402 + t5467 + t5494 + t5533));
  tv4rho2sigma20 = t7 * t5541 + 0.2e1 * t2324;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t5548 = t6 * t484 * t1013;
  t5552 = t6 * t488 * t1013 / 0.12e2;
  t5554 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t1013 - t5548 / 0.4e1 + t5552);
  tv4rho2sigma25 = t7 * t5554 + 0.2e1 * t2333;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t5560 = t6 * t509 * t959;
  t5568 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t959 - t5560 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t2319 - t5157 / 0.8e1 + t5164 - t5166 / 0.8e1);
  tv4rho2sigma26 = t7 * t5568 + t2324 + t2339;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t5574 = t6 * t533 * t1013;
  t5581 = t6 * t193 * t2476;
  t5584 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t1013 - t5574 / 0.8e1 - t5548 / 0.8e1 + t5552 - 0.3e1 / 0.8e1 * t6 * t189 * t2476 - t5581 / 0.8e1);
  tv4rho2sigma211 = t7 * t5584 + t2333 + t2481;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t5592 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t959 - t5560 / 0.4e1 + t5164);
  tv4rho2sigma212 = t7 * t5592 + 0.2e1 * t2339;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t5615 = t639 * t970;
  t5627 = t1578 * t1008;
  t5632 = t639 * t993;
  t5641 = t3737 * t998;
  t5653 = 0.32e2 / 0.9e1 * t272 * t34 * sigma[2] * t86 * t600 * t639 * t312 * t1855 + 0.16e2 / 0.3e1 * t608 * t4449 * t2458 * t602 + 0.8e1 / 0.9e1 * t608 * t786 * t5615 * t641 - 0.64e2 / 0.27e2 * t608 * t1588 * t2413 - 0.4e1 / 0.9e1 * t608 * t786 * t2448 * t602 - 0.4e1 / 0.3e1 * t608 * t778 * t5627 * t641 - 0.4e1 / 0.9e1 * t608 * t609 * t5632 * t641 + 0.8e1 / 0.9e1 * t608 * t786 * t2434 * t602 + 0.16e2 / 0.3e1 * t608 * t778 * t5641 * t641 - 0.64e2 / 0.27e2 * t608 * t1588 * t2420 - 0.4e1 / 0.3e1 * t608 * t1969 * t2424 * t602;
  t5660 = t248 * t2358;
  t5678 = t106 * t2398;
  t5687 = t248 * t2398;
  t5699 = -0.32e2 / 0.27e2 * t608 * t1588 * t2449 - 0.64e2 / 0.27e2 * t608 * t1942 * t2454 + 0.4e1 / 0.9e1 * t608 * t609 * t5660 * t242 + 0.2e1 / 0.9e1 * t608 * t609 * t2448 * t633 + 0.8e1 / 0.9e1 * t608 * t778 * t639 * t2358 * t259 + 0.4e1 / 0.9e1 * t608 * t778 * t2453 * t657 + 0.8e1 / 0.9e1 * t608 * t786 * t5678 * t242 + 0.4e1 / 0.9e1 * t608 * t786 * t2424 * t633 + 0.4e1 / 0.9e1 * t608 * t609 * t5687 * t259 + 0.2e1 / 0.9e1 * t608 * t609 * t2429 * t657 + 0.64e2 / 0.27e2 * t608 * t1588 * t2435;
  t5733 = t30 * t35 * t86;
  t5734 = t229 * t639;
  t5741 = 0.64e2 / 0.9e1 * t608 * t1942 * t2440 - 0.128e3 / 0.27e2 * t608 * t1942 * t2444 - 0.4e1 / 0.9e1 * t608 * t609 * t2434 * t633 - 0.4e1 / 0.3e1 * t608 * t778 * t2439 * t657 + 0.8e1 / 0.9e1 * t608 * t609 * t1929 * t834 + 0.4e1 / 0.9e1 * t608 * t609 * t792 * t1869 - 0.64e2 / 0.27e2 * t608 * t1913 * t2425 - 0.32e2 / 0.27e2 * t608 * t1588 * t2430 + 0.352e3 / 0.81e2 * t608 * t3749 * t975 - 0.16e2 / 0.9e1 * t5733 * t5734 * t1855 - 0.16e2 / 0.9e1 * t5733 * t2173 * t1849;
  t5785 = t312 * t834;
  t5790 = 0.64e2 / 0.9e1 * t608 * t4445 * t2459 + 0.64e2 / 0.27e2 * t608 * t1913 * t2404 - 0.128e3 / 0.27e2 * t608 * t1913 * t2408 - 0.4e1 / 0.3e1 * t608 * t1969 * t2458 * t633 - 0.4e1 / 0.9e1 * t608 * t786 * t2403 * t657 + 0.8e1 / 0.9e1 * t608 * t786 * t787 * t1896 + 0.4e1 / 0.9e1 * t608 * t609 * t4543 * t321 + 0.8e1 / 0.9e1 * t608 * t778 * t824 * t1869 + 0.8e1 / 0.3e1 * t608 * t4581 * t998 * t242 * t259 - 0.16e2 / 0.9e1 * t608 * t1853 * t1854 * t834 - 0.16e2 / 0.3e1 * t608 * t4618 * t321 * t259 * t834 - 0.16e2 / 0.9e1 * t608 * t1847 * t5785 * t242;
  t5818 = t811 * t321;
  t5838 = -0.16e2 / 0.9e1 * t608 * t1853 * t5785 * t259 - 0.8e1 / 0.9e1 * t608 * t1847 * t993 * t242 * t259 + 0.8e1 / 0.3e1 * t608 * t4581 * t2344 * t641 + 0.8e1 / 0.3e1 * t608 * t4587 * t2344 * t602 - 0.8e1 / 0.9e1 * t608 * t1847 * t2344 * t633 - 0.8e1 / 0.9e1 * t608 * t1853 * t2344 * t657 - 0.16e2 / 0.9e1 * t608 * t1847 * t5818 * t242 - 0.16e2 / 0.9e1 * t608 * t1853 * t5818 * t259 + 0.128e3 / 0.27e2 * t608 * t4627 * t2345 + 0.128e3 / 0.27e2 * t608 * t4623 * t2349 + 0.8e1 / 0.3e1 * t608 * t4587 * t970 * t242 * t259;
  t5876 = -0.16e2 / 0.3e1 * t608 * t4593 * t1848 * t811 - 0.16e2 / 0.9e1 * t608 * t1847 * t4570 * t811 - 0.8e1 / 0.9e1 * t608 * t1853 * t1008 * t242 * t259 - 0.4e1 / 0.9e1 * t36 * t778 * t4481 - 0.352e3 / 0.81e2 * t36 * t4502 * t819 - 0.352e3 / 0.81e2 * t36 * t3749 * t787 + 0.64e2 / 0.27e2 * t36 * t1588 * t1920 + 0.64e2 / 0.27e2 * t36 * t1942 * t1946 - 0.4e1 / 0.9e1 * t36 * t609 * t4538 + 0.16e2 / 0.9e1 * t36 * t1922 + 0.8e1 / 0.9e1 * t36 * t1931 + 0.8e1 / 0.9e1 * t36 * t1948;
  t5886 = t811 * t811;
  t5891 = t834 * t834;
  t5910 = -0.8e1 / 0.9e1 * t36 * t1906 - 0.8e1 / 0.9e1 * t36 * t1910 - 0.8e1 / 0.3e1 * t36 * t1966 - 0.8e1 / 0.3e1 * t36 * t1971 + 0.8e1 / 0.9e1 * t36 * t87 * t601 * t5886 + 0.8e1 / 0.9e1 * t36 * t87 * t640 * t5891 - 0.176e3 / 0.81e2 * t36 * t589 * t1009 + 0.352e3 / 0.81e2 * t36 * t589 * t971 + 0.352e3 / 0.81e2 * t36 * t589 * t999 - 0.176e3 / 0.81e2 * t36 * t589 * t994 - 0.64e2 / 0.27e2 * t36 * t1939;
  t5969 = -0.128e3 / 0.27e2 * t36 * t1943 + 0.4e1 / 0.9e1 * t36 * t1952 + 0.8e1 / 0.9e1 * t36 * t1961 + 0.16e2 / 0.9e1 * t36 * t1957 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.7e1 / 0.9e1 * t43 * t980 * t616 * t92 + 0.7e1 / 0.9e1 * t43 * t101 * t588 * t238 - 0.11e2 * t43 * t1886 + 0.47e2 / 0.3e1 * t43 * t1892 * sigma[2] - 0.2e2 / 0.3e1 * t43 / t84 / t3686 * t3698 * t316) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (0.4e1 * t649 * t1004 * t85 + 0.64e2 / 0.3e1 * t2353 * t97 + 0.16e3 / 0.9e1 * t1005 * t84) - 0.128e3 / 0.27e2 * t36 * t1914 - 0.64e2 / 0.27e2 * t36 * t1917 + 0.8e1 / 0.9e1 * t36 * t1926 + 0.4e1 / 0.9e1 * t36 * t1936 + 0.32e2 / 0.27e2 * t36 * t224 * t2399 + 0.32e2 / 0.27e2 * t36 * t224 * t2359;
  t5977 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t1013 - t5574 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t2476 + t5552 - t5581 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * (t5653 + t5699 + t5741 + t5790 + t5838 + t5876 + t5910 + t5969));
  tv4rho2sigma217 = t7 * t5977 + 0.2e1 * t2481;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t5982 = params->beta * t33 * t34;
  t5983 = t331 * t27 * t5982;
  t5985 = t54 * t142 * t1202;
  t5990 = t54 * t399 * t438;
  t5995 = 0.2e1 / 0.9e1 * t4755 * t1023;
  t5996 = t2031 * t2504;
  t5998 = t2031 * t2487;
  t6003 = t4771 * t1019;
  t6008 = t4755 * t1019 / 0.9e1;
  t6015 = 0.6e1 * t5983 * t5985 * t1631 + 0.4e1 * t5983 * t5990 * t1625 - t5995 - 0.1e2 / 0.9e1 * t5996 - 0.5e1 / 0.9e1 * t5998 + 0.2e2 / 0.9e1 * t859 * t676 * t1018 + t6003 / 0.3e1 - 0.5e1 / 0.3e1 * t2020 * t2487 - t6008 - 0.1e2 / 0.3e1 * t859 * t273 * t2515 + t859 * t860 * t439 * t1696;
  t6019 = t2031 * t2498;
  t6031 = t2031 * t2516;
  t6036 = t4771 * t1023;
  t6040 = t2031 * t2492;
  t6042 = t4747 * t1019 / 0.2e1 + t2020 * t2498 + t6019 / 0.3e1 - 0.5e1 / 0.3e1 * t859 * t273 * t2497 + t859 * t860 * t861 * t1723 / 0.2e1 + t4747 * t1023 + 0.2e1 * t2020 * t2516 + 0.2e1 / 0.3e1 * t6031 + 0.4e2 / 0.9e1 * t859 * t676 * t1022 + 0.2e1 / 0.3e1 * t6036 - 0.1e2 / 0.3e1 * t2020 * t2504 - 0.2e1 / 0.3e1 * t6040;
  t6044 = t2031 * t2495;
  t6079 = -0.2e1 / 0.3e1 * t6044 + 0.1e2 / 0.3e1 * t859 * t273 * t399 * t2491 + 0.1e2 / 0.3e1 * t859 * t4794 * t2494 - 0.2e1 * t859 * t2490 * t1644 * t155 - t859 * t2490 * t698 * t432 - 0.2e1 * t859 * t2058 * t3962 * t172 - t859 * t2058 * t1756 * t456 - 0.2e1 * t2020 * t2492 - 0.2e1 * t2020 * t2495 + 0.3e1 * t859 * t2058 * t4085 * t440 + 0.2e1 * t859 * t2490 * t730 * t401;
  t6084 = t860 * t1176;
  t6115 = t2031 * t2508;
  t6117 = t2031 * t2512;
  t6119 = 0.12e2 * t859 * t2510 * t4068 * t440 + 0.3e1 * t859 * t6084 * t698 * t401 + 0.1e2 / 0.3e1 * t859 * t4794 * t2507 + 0.1e2 * t859 * t273 * t52 * t2511 - 0.2e1 * t859 * t2058 * t1635 * t155 - t859 * t2058 * t730 * t432 - 0.6e1 * t859 * t2510 * t3972 * t172 - 0.3e1 * t859 * t2510 * t1765 * t456 - 0.2e1 * t2020 * t2508 - 0.6e1 * t2020 * t2512 - 0.2e1 / 0.3e1 * t6115 - 0.2e1 * t6117;
  t6122 = my_piecewise3(t2, 0, t6015 + t6042 + t6079 + t6119);
  tv4rho2sigmalapl0 = t7 * t6122 + 0.2e1 * t2519;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t6127 = t4930 * t1028;
  t6130 = t4933 * t1028 / 0.9e1;
  t6132 = t4930 * t1032;
  t6135 = 0.2e1 / 0.9e1 * t4933 * t1032;
  t6137 = my_piecewise3(t72, 0, t4927 * t1028 / 0.2e1 + t6127 / 0.3e1 - t6130 + t4927 * t1032 + 0.2e1 / 0.3e1 * t6132 - t6135);
  tv4rho2sigmalapl5 = t7 * t6137 + 0.2e1 * t2529;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t6141 = t4875 * t1019;
  t6154 = t4888 * t1019 / 0.2e1 + t6141 / 0.6e1 - 0.5e1 / 0.6e1 * t2089 * t2487 - t2089 * t2492 - t2089 * t2495 + t2089 * t2498 / 0.2e1 + t6003 / 0.6e1 - t6008 - 0.5e1 / 0.18e2 * t5998 - t6040 / 0.3e1 - t6044 / 0.3e1 + t6019 / 0.6e1;
  t6156 = t4875 * t1023;
  t6168 = t4888 * t1023 + t6156 / 0.3e1 - 0.5e1 / 0.3e1 * t2089 * t2504 - t2089 * t2508 - 0.3e1 * t2089 * t2512 + t2089 * t2516 + t6036 / 0.3e1 - t5995 - 0.5e1 / 0.9e1 * t5996 - t6115 / 0.3e1 - t6117 + t6031 / 0.3e1;
  t6170 = my_piecewise3(t2, 0, t6154 + t6168);
  tv4rho2sigmalapl6 = t7 * t6170 + t2519 + t2535;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t6174 = t4985 * t1028;
  t6179 = t2115 * t2539;
  t6182 = t2115 * t2544;
  t6185 = t2115 * t2547;
  t6189 = t2115 * t2550;
  t6191 = t5003 * t1028 / 0.2e1 + t6174 / 0.6e1 + t6127 / 0.6e1 - t6130 - 0.5e1 / 0.6e1 * t2112 * t2539 - 0.5e1 / 0.18e2 * t6179 - t2112 * t2544 - t6182 / 0.3e1 - t2112 * t2547 - t6185 / 0.3e1 + t2112 * t2550 / 0.2e1 + t6189 / 0.6e1;
  t6193 = t4985 * t1032;
  t6198 = t2115 * t2554;
  t6201 = t2115 * t2558;
  t6205 = t2115 * t2562;
  t6207 = t2115 * t2566;
  t6209 = t5003 * t1032 + t6193 / 0.3e1 + t6132 / 0.3e1 - t6135 - 0.5e1 / 0.3e1 * t2112 * t2554 - 0.5e1 / 0.9e1 * t6198 - t2112 * t2558 - t6201 / 0.3e1 - 0.3e1 * t2112 * t2562 - t6205 + t2112 * t2566 + t6207 / 0.3e1;
  t6211 = my_piecewise3(t72, 0, t6191 + t6209);
  tv4rho2sigmalapl11 = t7 * t6211 + t2529 + t2569;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t6220 = my_piecewise3(t2, 0, t4953 * t1019 / 0.2e1 + t6141 / 0.3e1 - t6008 + t4953 * t1023 + 0.2e1 / 0.3e1 * t6156 - t5995);
  tv4rho2sigmalapl12 = t7 * t6220 + 0.2e1 * t2535;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t6224 = t340 * t27 * t5982;
  t6226 = t98 * t229 * t1578;
  t6231 = t98 * t600 * t639;
  t6257 = 0.6e1 * t6224 * t6226 * t1855 + 0.4e1 * t6224 * t6231 * t1849 - 0.1e2 / 0.3e1 * t897 * t302 * t2565 + t897 * t898 * t640 * t1869 + t5082 * t1028 / 0.2e1 + t2149 * t2550 - 0.5e1 / 0.3e1 * t897 * t302 * t2549 + 0.4e2 / 0.9e1 * t897 * t770 * t1031 - 0.1e2 / 0.3e1 * t2149 * t2554 + 0.2e2 / 0.9e1 * t897 * t770 * t1027 - 0.5e1 / 0.3e1 * t2149 * t2539;
  t6275 = t897 * t898 * t899 * t1896 / 0.2e1 + t5082 * t1032 + 0.2e1 * t2149 * t2566 + t6174 / 0.3e1 - 0.5e1 / 0.9e1 * t6179 + t6189 / 0.3e1 + 0.2e1 / 0.3e1 * t6193 - 0.1e2 / 0.9e1 * t6198 + 0.2e1 / 0.3e1 * t6207 - t6130 - t6135 + 0.12e2 * t897 * t2560 * t4440 * t641;
  t6285 = t898 * t1552;
  t6317 = 0.3e1 * t897 * t2163 * t4430 * t641 + 0.2e1 * t897 * t2542 * t824 * t602 + 0.3e1 * t897 * t6285 * t792 * t602 + 0.1e2 * t897 * t302 * t96 * t2561 - 0.2e1 * t897 * t2163 * t1955 * t242 - t897 * t2163 * t824 * t633 - 0.6e1 * t897 * t2560 * t4458 * t259 - 0.3e1 * t897 * t2560 * t1964 * t657 - 0.2e1 * t2149 * t2558 - 0.6e1 * t2149 * t2562 + 0.1e2 / 0.3e1 * t897 * t302 * t600 * t2543;
  t6346 = 0.1e2 / 0.3e1 * t897 * t5143 * t2546 - 0.2e1 * t897 * t2542 * t1929 * t242 - t897 * t2542 * t792 * t633 - 0.2e1 * t897 * t2163 * t4520 * t259 - t897 * t2163 * t1904 * t657 - 0.2e1 * t2149 * t2544 - 0.2e1 * t2149 * t2547 - 0.2e1 / 0.3e1 * t6185 - 0.2e1 / 0.3e1 * t6201 - 0.2e1 * t6205 + 0.1e2 / 0.3e1 * t897 * t5143 * t2557 - 0.2e1 / 0.3e1 * t6182;
  t6349 = my_piecewise3(t72, 0, t6257 + t6275 + t6317 + t6346);
  tv4rho2sigmalapl17 = t7 * t6349 + 0.2e1 * t2569;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t6361 = 0.4e1 / 0.9e1 * t4755 * t1039;
  t6362 = t2031 * t2575;
  t6364 = t2031 * t2581;
  t6366 = t2031 * t2587;
  t6381 = t4771 * t1039;
  t6387 = t3070 * t57;
  t6392 = t1037 * t399;
  t6398 = t1036 * t142 * t1202;
  t6404 = -0.2e1 * t4747 * t1039 + 0.6e1 * t859 * t2584 * t2585 * t456 + 0.12e2 * t2020 * t2587 + t6361 + 0.8e1 / 0.9e1 * t6362 + 0.4e1 / 0.3e1 * t6364 + 0.4e1 * t6366 - 0.2e2 / 0.9e1 * t859 * t273 * t1038 - 0.8e1 / 0.3e1 * t859 * t2058 * t2580 - 0.8e1 * t859 * t2510 * t2586 + 0.2e1 * t859 * t2578 * t2579 * t432 - 0.4e1 / 0.3e1 * t6381 + 0.8e1 / 0.3e1 * t2020 * t2575 + 0.4e1 * t2020 * t2581 - 0.24e2 * t859 * t2584 * t6387 * t440 - 0.4e1 * t859 * t6392 * t2579 * t401 - 0.12e2 * t5983 * t6398 * t57 * t155 * t172;
  t6405 = my_piecewise3(t2, 0, t6404);
  tv4rho2lapl20 = t7 * t6405 + 0.2e1 * t2591;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t6410 = t4930 * t1046;
  t6413 = 0.4e1 / 0.9e1 * t4933 * t1046;
  t6415 = my_piecewise3(t72, 0, -0.2e1 * t4927 * t1046 - 0.4e1 / 0.3e1 * t6410 + t6413);
  tv4rho2lapl22 = t7 * t6415 + 0.2e1 * t2598;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t6419 = t4875 * t1039;
  t6432 = my_piecewise3(t2, 0, -0.2e1 * t4888 * t1039 - 0.2e1 / 0.3e1 * t6419 + 0.4e1 / 0.3e1 * t2089 * t2575 + 0.2e1 * t2089 * t2581 + 0.6e1 * t2089 * t2587 - 0.2e1 / 0.3e1 * t6381 + t6361 + 0.4e1 / 0.9e1 * t6362 + 0.2e1 / 0.3e1 * t6364 + 0.2e1 * t6366);
  tv4rho2lapl23 = t7 * t6432 + t2591 + t2603;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t6436 = t4985 * t1046;
  t6441 = t2115 * t2607;
  t6445 = t2115 * t2613;
  t6449 = t2115 * t2619;
  t6452 = my_piecewise3(t72, 0, -0.2e1 * t5003 * t1046 - 0.2e1 / 0.3e1 * t6436 - 0.2e1 / 0.3e1 * t6410 + t6413 + 0.4e1 / 0.3e1 * t2112 * t2607 + 0.4e1 / 0.9e1 * t6441 + 0.2e1 * t2112 * t2613 + 0.2e1 / 0.3e1 * t6445 + 0.6e1 * t2112 * t2619 + 0.2e1 * t6449);
  tv4rho2lapl25 = t7 * t6452 + t2598 + t2623;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t6459 = my_piecewise3(t2, 0, -0.2e1 * t4953 * t1039 - 0.4e1 / 0.3e1 * t6419 + t6361);
  tv4rho2lapl26 = t7 * t6459 + 0.2e1 * t2603;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t6489 = t3737 * t101;
  t6494 = t1044 * t600;
  t6500 = t1043 * t229 * t1578;
  t6508 = -0.2e1 * t5082 * t1046 + 0.2e1 * t897 * t2610 * t2611 * t633 + 0.6e1 * t897 * t2616 * t2617 * t657 + 0.8e1 / 0.3e1 * t2149 * t2607 + 0.4e1 * t2149 * t2613 + 0.12e2 * t2149 * t2619 - 0.2e2 / 0.9e1 * t897 * t302 * t1045 - 0.8e1 / 0.3e1 * t897 * t2163 * t2612 - 0.8e1 * t897 * t2560 * t2618 + 0.8e1 / 0.9e1 * t6441 - 0.4e1 / 0.3e1 * t6436 + t6413 - 0.24e2 * t897 * t2616 * t6489 * t641 - 0.4e1 * t897 * t6494 * t2611 * t602 - 0.12e2 * t6224 * t6500 * t101 * t242 * t259 + 0.4e1 / 0.3e1 * t6445 + 0.4e1 * t6449;
  t6509 = my_piecewise3(t72, 0, t6508);
  tv4rho2lapl28 = t7 * t6509 + 0.2e1 * t2623;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t6516 = t6 * t130 * t2706 / 0.8e1;
  t6517 = t161 * t2656;
  t6522 = t161 * t2666;
  t6527 = t438 * t2666;
  t6576 = 0.2e1 / 0.9e1 * t407 * t408 * t6517 * t172 + 0.2e1 / 0.9e1 * t407 * t408 * t6522 * t155 + 0.4e1 / 0.9e1 * t407 * t684 * t6527 * t172 - 0.8e1 / 0.3e1 * t5291 * t2054 * t2188 - 0.8e1 / 0.3e1 * t5291 * t5295 * t2192 + 0.2e1 / 0.3e1 * t407 * t408 * t5327 * t292 + 0.2e1 / 0.3e1 * t407 * t408 * t2298 * t740 - 0.4e1 / 0.3e1 * t407 * t408 * t3962 * t944 + 0.32e2 / 0.9e1 * t407 * t1669 * t2698 - 0.32e2 / 0.9e1 * t407 * t1669 * t2702 - 0.16e2 / 0.9e1 * t407 * t1217 * t2676 - 0.16e2 / 0.9e1 * t407 * t1217 * t2680 - 0.32e2 / 0.9e1 * t407 * t1656 * t2689 + 0.32e2 / 0.9e1 * t407 * t1217 * t2631 - 0.4e1 / 0.3e1 * t407 * t692 * t2276 * t740 + 0.4e1 / 0.3e1 * t407 * t692 * t1676 * t939;
  t6589 = t1202 * t2684;
  t6611 = t62 * t2693;
  t6616 = t161 * t2693;
  t6625 = t62 * t2656;
  t6630 = t283 * t954;
  t6635 = t292 * t954;
  t6644 = t283 * t944;
  t6653 = 0.4e1 / 0.3e1 * t407 * t692 * t693 * t2231 + 0.2e1 / 0.3e1 * t407 * t408 * t1644 * t954 + 0.2e1 / 0.3e1 * t407 * t408 * t698 * t2241 + 0.4e1 / 0.3e1 * t407 * t408 * t6589 * t155 + 0.16e2 / 0.3e1 * t407 * t684 * t3070 * t2684 * t172 - 0.4e1 * t407 * t684 * t2251 * t740 + 0.4e1 / 0.3e1 * t407 * t684 * t1635 * t954 + 0.4e1 / 0.3e1 * t407 * t684 * t730 * t2241 + 0.16e2 / 0.3e1 * t407 * t4077 * t6611 * t155 + 0.4e1 / 0.3e1 * t407 * t1770 * t6616 * t172 - 0.4e1 * t407 * t1770 * t2271 * t717 + 0.4e1 / 0.9e1 * t407 * t692 * t6625 * t155 - 0.4e1 / 0.3e1 * t407 * t1629 * t6630 * t172 - 0.4e1 / 0.3e1 * t407 * t1629 * t6635 * t155 - 0.4e1 * t407 * t4138 * t6635 * t172 + 0.8e1 / 0.3e1 * t407 * t4113 * t6644 * t155 + 0.4e1 * t407 * t4104 * t6644 * t172;
  t6659 = t916 * t292;
  t6672 = t283 * t939;
  t6681 = t939 * t292;
  t6716 = -0.8e1 / 0.3e1 * t407 * t1629 * t2187 * t740 + 0.4e1 * t407 * t4144 * t6659 * t155 + 0.8e1 / 0.3e1 * t407 * t4113 * t6659 * t172 - 0.8e1 / 0.3e1 * t407 * t1623 * t2187 * t717 - 0.4e1 * t407 * t4150 * t6672 * t155 - 0.4e1 / 0.3e1 * t407 * t1623 * t6672 * t172 - 0.4e1 / 0.3e1 * t407 * t1623 * t6681 * t155 - 0.4e1 / 0.3e1 * t407 * t1629 * t6681 * t172 - 0.4e1 / 0.3e1 * t407 * t1623 * t6630 * t155 - 0.32e2 / 0.9e1 * t36 * t1669 * t2271 - 0.2e1 / 0.3e1 * t36 * t408 * t5318 - 0.2e1 / 0.3e1 * t36 * t684 * t5272 + 0.16e2 / 0.9e1 * t36 * t1217 * t2293 + 0.16e2 / 0.9e1 * t36 * t1656 * t2261 - 0.32e2 / 0.9e1 * t36 * t1656 * t2246 + 0.4e1 / 0.3e1 * t36 * t2295 + 0.2e1 / 0.3e1 * t36 * t2300;
  t6786 = 0.2e1 / 0.3e1 * t36 * t2263 + 0.4e1 / 0.3e1 * t36 * t2268 - 0.4e1 / 0.3e1 * t36 * t2248 - 0.4e1 * t36 * t2253 + 0.8e1 / 0.3e1 * t36 * t2258 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-t43 * t2639 * t145 * t48 / 0.2e1 + t43 * t288 * t136 * t151 / 0.2e1 + t43 * t57 * t712 * t428 / 0.6e1 - 0.7e1 / 0.2e1 * t43 * t2228 + 0.5e1 / 0.2e1 * t43 / t39 / t1156 * t3022 * sigma[0]) - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.12e2 * t166 * t2662 * t40 - 0.32e2 * t2663 * t53) - 0.4e1 * t36 * t2273 - 0.4e1 / 0.3e1 * t36 * t2278 + 0.8e1 / 0.3e1 * t36 * t2282 + 0.4e1 / 0.3e1 * t36 * t2286 + 0.4e1 / 0.3e1 * t36 * t2290 + 0.32e2 / 0.9e1 * t36 * t137 * t2685 + 0.32e2 / 0.9e1 * t36 * t137 * t2694 + 0.16e2 / 0.27e2 * t36 * t137 * t2657 + 0.16e2 / 0.27e2 * t36 * t137 * t2667 - 0.32e2 / 0.9e1 * t36 * t2303;
  t6793 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t2706 - t6516 - 0.3e1 / 0.8e1 * t6 * t28 * (t6576 + t6653 + t6716 + t6786));
  tv4rhosigma30 = t7 * t6793 + t2710;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t6800 = t6 * t193 * t2792 / 0.8e1;
  t6802 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t2792 - t6800);
  tv4rhosigma39 = t7 * t6802 + t2796;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t6808 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t2706 - t6516);
  tv4rhosigma310 = t7 * t6808 + t2710;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t6813 = t106 * t2747;
  t6818 = t248 * t2747;
  t6829 = t1578 * t2778;
  t6851 = t106 * t2787;
  t6856 = t248 * t2787;
  t6865 = t248 * t2757;
  t6870 = t639 * t2757;
  t6883 = 0.4e1 / 0.9e1 * t608 * t786 * t6813 * t242 + 0.2e1 / 0.9e1 * t608 * t609 * t6818 * t259 + 0.32e2 / 0.9e1 * t608 * t1588 * t2717 + 0.32e2 / 0.9e1 * t608 * t1913 * t2762 + 0.4e1 / 0.3e1 * t608 * t609 * t6829 * t242 + 0.16e2 / 0.3e1 * t608 * t778 * t3737 * t2778 * t259 - 0.4e1 * t608 * t778 * t2439 * t834 + 0.4e1 / 0.3e1 * t608 * t778 * t1955 * t1008 + 0.4e1 / 0.3e1 * t608 * t778 * t824 * t2358 + 0.16e2 / 0.3e1 * t608 * t4449 * t6851 * t242 + 0.4e1 / 0.3e1 * t608 * t1969 * t6856 * t259 - 0.4e1 * t608 * t1969 * t2458 * t811 + 0.2e1 / 0.9e1 * t608 * t609 * t6865 * t242 + 0.4e1 / 0.9e1 * t608 * t778 * t6870 * t259 - 0.4e1 / 0.3e1 * t608 * t786 * t2403 * t834 + 0.4e1 / 0.3e1 * t608 * t786 * t1920 * t993;
  t6930 = t970 * t321;
  t6935 = t312 * t998;
  t6944 = t312 * t993;
  t6949 = 0.4e1 / 0.3e1 * t608 * t786 * t787 * t2398 + 0.2e1 / 0.3e1 * t608 * t609 * t5687 * t321 + 0.2e1 / 0.3e1 * t608 * t609 * t2429 * t834 + 0.2e1 / 0.3e1 * t608 * t609 * t1929 * t1008 + 0.2e1 / 0.3e1 * t608 * t609 * t792 * t2358 - 0.4e1 / 0.3e1 * t608 * t609 * t4520 * t998 - 0.8e1 / 0.3e1 * t5733 * t2173 * t2345 - 0.8e1 / 0.3e1 * t5733 * t5734 * t2349 - 0.32e2 / 0.9e1 * t608 * t1942 * t2783 - 0.32e2 / 0.9e1 * t608 * t1913 * t2766 - 0.16e2 / 0.9e1 * t608 * t1588 * t2770 - 0.16e2 / 0.9e1 * t608 * t1588 * t2774 - 0.8e1 / 0.3e1 * t608 * t1853 * t2344 * t834 + 0.4e1 * t608 * t4587 * t6930 * t242 + 0.8e1 / 0.3e1 * t608 * t4575 * t6935 * t242 + 0.4e1 * t608 * t4581 * t6935 * t259 - 0.4e1 / 0.3e1 * t608 * t1847 * t6944 * t259;
  t6951 = t993 * t321;
  t6960 = t312 * t1008;
  t6969 = t321 * t1008;
  t7040 = -0.4e1 / 0.3e1 * t608 * t1847 * t6951 * t242 - 0.4e1 / 0.3e1 * t608 * t1853 * t6951 * t259 - 0.4e1 / 0.3e1 * t608 * t1847 * t6960 * t242 - 0.4e1 / 0.3e1 * t608 * t1853 * t6960 * t259 - 0.4e1 / 0.3e1 * t608 * t1853 * t6969 * t242 - 0.4e1 * t608 * t4618 * t6969 * t259 + 0.8e1 / 0.3e1 * t608 * t4575 * t6930 * t259 - 0.8e1 / 0.3e1 * t608 * t1847 * t2344 * t811 - 0.4e1 * t608 * t4593 * t6944 * t242 + 0.16e2 / 0.9e1 * t36 * t1942 * t2448 - 0.32e2 / 0.9e1 * t36 * t1913 * t2458 + 0.16e2 / 0.27e2 * t36 * t224 * t2748 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-t43 * t2730 * t232 * t92 / 0.2e1 + t43 * t317 * t223 * t238 / 0.2e1 + t43 * t101 * t806 * t629 / 0.6e1 - 0.7e1 / 0.2e1 * t43 * t2395 + 0.5e1 / 0.2e1 * t43 / t84 / t1502 * t3698 * sigma[2]) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.12e2 * t253 * t2753 * t85 - 0.32e2 * t2754 * t97) + 0.4e1 / 0.3e1 * t36 * t2426 + 0.2e1 / 0.3e1 * t36 * t2431 + 0.2e1 / 0.3e1 * t36 * t2450;
  t7082 = 0.4e1 / 0.3e1 * t36 * t2455 - 0.4e1 * t36 * t2460 - 0.4e1 / 0.3e1 * t36 * t2405 + 0.8e1 / 0.3e1 * t36 * t2409 + 0.4e1 / 0.3e1 * t36 * t2414 + 0.4e1 / 0.3e1 * t36 * t2421 + 0.32e2 / 0.9e1 * t36 * t224 * t2779 + 0.32e2 / 0.9e1 * t36 * t224 * t2788 + 0.16e2 / 0.27e2 * t36 * t224 * t2758 - 0.32e2 / 0.9e1 * t36 * t2417 - 0.4e1 / 0.3e1 * t36 * t2436 - 0.4e1 * t36 * t2441 + 0.8e1 / 0.3e1 * t36 * t2445 - 0.2e1 / 0.3e1 * t36 * t609 * t5678 - 0.2e1 / 0.3e1 * t36 * t778 * t5660 - 0.32e2 / 0.9e1 * t36 * t1942 * t2434 + 0.16e2 / 0.9e1 * t36 * t1588 * t2424;
  t7089 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t2792 - t6800 - 0.3e1 / 0.8e1 * t6 * t81 * (t6883 + t6949 + t7040 + t7082));
  tv4rhosigma319 = t7 * t7089 + t2796;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t7092 = t2031 * t2805 / 0.6e1;
  t7096 = t2031 * t2809;
  t7101 = t2031 * t2813 / 0.3e1;
  t7106 = t2031 * t2798 / 0.3e1;
  t7127 = t7092 - 0.5e1 / 0.6e1 * t859 * t273 * t2804 - t7096 + 0.5e1 * t859 * t273 * t2808 + t7101 - 0.5e1 / 0.3e1 * t859 * t273 * t2812 - t7106 + 0.5e1 / 0.3e1 * t859 * t273 * t2797 + t2020 * t2805 / 0.2e1 + t859 * t860 * t861 * t2231 / 0.2e1 - 0.3e1 * t2020 * t2809 + t2020 * t2813 + t859 * t860 * t439 * t2241 - t2020 * t2798 + 0.3e1 * t859 * t2058 * t2251 * t155;
  t7158 = 0.2e1 / 0.3e1 * t2031 * t2801;
  t7182 = 0.12e2 * t859 * t2510 * t5208 * t172 - 0.6e1 * t859 * t2510 * t1765 * t740 - t859 * t2058 * t2266 * t155 + 0.3e1 * t859 * t6084 * t2276 * t155 + 0.2e1 * t859 * t2490 * t5203 * t172 - 0.2e1 * t859 * t2490 * t698 * t717 - 0.2e1 * t2020 * t2801 - 0.2e1 * t859 * t2058 * t3962 * t292 - t7158 + 0.1e2 / 0.3e1 * t859 * t4794 * t2800 - 0.3e1 * t859 * t2510 * t5194 * t172 - 0.2e1 * t859 * t2058 * t1756 * t740 - t859 * t2490 * t2298 * t155 - t859 * t2058 * t5183 * t172 + 0.6e1 * t5983 * t5985 * t2192 + 0.4e1 * t5983 * t5990 * t2188;
  t7184 = my_piecewise3(t2, 0, t7127 + t7182);
  tv4rhosigma2lapl0 = t7 * t7184 + t2816;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t7188 = t2115 * t2818 / 0.3e1;
  t7192 = 0.2e1 / 0.3e1 * t2115 * t2821;
  t7196 = t2115 * t2825 / 0.6e1;
  t7199 = t2115 * t2829;
  t7202 = t2115 * t2833 / 0.3e1;
  t7204 = my_piecewise3(t72, 0, -t2112 * t2818 - t7188 - 0.2e1 * t2112 * t2821 - t7192 + t2112 * t2825 / 0.2e1 + t7196 - 0.3e1 * t2112 * t2829 - t7199 + t2112 * t2833 + t7202);
  tv4rhosigma2lapl11 = t7 * t7204 + t2836;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t7215 = my_piecewise3(t2, 0, -t2089 * t2798 - t7106 - 0.2e1 * t2089 * t2801 - t7158 + t2089 * t2805 / 0.2e1 + t7092 - 0.3e1 * t2089 * t2809 - t7096 + t2089 * t2813 + t7101);
  tv4rhosigma2lapl12 = t7 * t7215 + t2816;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t7246 = t2149 * t2833 + t897 * t898 * t640 * t2358 - t2149 * t2818 + t2149 * t2825 / 0.2e1 + t897 * t898 * t899 * t2398 / 0.2e1 - 0.3e1 * t2149 * t2829 - t7188 + t7196 - t7199 + t7202 - 0.5e1 / 0.6e1 * t897 * t302 * t2824 + 0.5e1 * t897 * t302 * t2828 - 0.5e1 / 0.3e1 * t897 * t302 * t2832 + 0.5e1 / 0.3e1 * t897 * t302 * t2817 + 0.3e1 * t897 * t6285 * t2403 * t242;
  t7299 = 0.2e1 * t897 * t2542 * t5615 * t259 - 0.2e1 * t897 * t2542 * t792 * t811 - 0.2e1 * t2149 * t2821 - 0.2e1 * t897 * t2163 * t4520 * t321 - 0.2e1 * t897 * t2163 * t1904 * t834 + 0.1e2 / 0.3e1 * t897 * t5143 * t2820 - t897 * t2542 * t2429 * t242 - t897 * t2163 * t5632 * t259 + 0.3e1 * t897 * t2163 * t2439 * t242 + 0.12e2 * t897 * t2560 * t5641 * t259 - 0.6e1 * t897 * t2560 * t1964 * t834 - t897 * t2163 * t2453 * t242 - 0.3e1 * t897 * t2560 * t5627 * t259 - t7192 + 0.4e1 * t6224 * t6231 * t2345 + 0.6e1 * t6224 * t6226 * t2349;
  t7301 = my_piecewise3(t72, 0, t7246 + t7299);
  tv4rhosigma2lapl23 = t7 * t7301 + t2836;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t7306 = 0.2e1 / 0.3e1 * t2031 * t2838;
  t7312 = t57 * t283;
  t7328 = 0.2e1 * t2031 * t2842;
  t7332 = t57 * t292;
  t7350 = 0.2e1 / 0.3e1 * t2031 * t2846;
  t7354 = t438 * t288;
  t7359 = t1202 * t288;
  t7364 = 0.2e1 * t2020 * t2838 + t7306 - 0.4e1 / 0.3e1 * t859 * t2058 * t2837 - 0.4e1 * t5983 * t1036 * t399 * t438 * t7312 * t155 - 0.6e1 * t5983 * t6398 * t7312 * t172 + 0.2e1 * t859 * t2578 * t2579 * t717 + 0.6e1 * t2020 * t2842 + t7328 - 0.4e1 * t859 * t2510 * t2841 - 0.6e1 * t5983 * t6398 * t7332 * t155 - 0.24e2 * t5983 * t1036 * t52 * t3070 * t7332 * t172 + 0.6e1 * t859 * t2584 * t2585 * t740 + 0.2e1 * t2020 * t2846 + t7350 - 0.4e1 / 0.3e1 * t859 * t860 * t2845 - 0.2e1 * t859 * t2578 * t7354 * t155 - 0.6e1 * t859 * t2584 * t7359 * t172;
  t7365 = my_piecewise3(t2, 0, t7364);
  tv4rhosigmalapl20 = t7 * t7365 + t2850;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t7370 = 0.2e1 / 0.3e1 * t2115 * t2852;
  t7374 = 0.2e1 * t2115 * t2856;
  t7378 = 0.2e1 / 0.3e1 * t2115 * t2860;
  t7380 = my_piecewise3(t72, 0, 0.2e1 * t2112 * t2852 + 0.6e1 * t2112 * t2856 + 0.2e1 * t2112 * t2860 + t7370 + t7374 + t7378);
  tv4rhosigmalapl28 = t7 * t7380 + t2864;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t7389 = my_piecewise3(t2, 0, 0.2e1 * t2089 * t2838 + 0.6e1 * t2089 * t2842 + 0.2e1 * t2089 * t2846 + t7306 + t7328 + t7350);
  tv4rhosigmalapl29 = t7 * t7389 + t2850;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t7398 = t101 * t312;
  t7416 = t101 * t321;
  t7436 = t639 * t317;
  t7441 = t1578 * t317;
  t7446 = 0.2e1 * t2149 * t2852 + t7370 - 0.4e1 / 0.3e1 * t897 * t2163 * t2851 - 0.4e1 * t6224 * t1043 * t600 * t639 * t7398 * t242 - 0.6e1 * t6224 * t6500 * t7398 * t259 + 0.2e1 * t897 * t2610 * t2611 * t811 + 0.6e1 * t2149 * t2856 + t7374 - 0.4e1 * t897 * t2560 * t2855 - 0.6e1 * t6224 * t6500 * t7416 * t242 - 0.24e2 * t6224 * t1043 * t96 * t3737 * t7416 * t259 + 0.6e1 * t897 * t2616 * t2617 * t834 + 0.2e1 * t2149 * t2860 + t7378 - 0.4e1 / 0.3e1 * t897 * t898 * t2859 - 0.2e1 * t897 * t2610 * t7436 * t242 - 0.6e1 * t897 * t2616 * t7441 * t259;
  t7447 = my_piecewise3(t72, 0, t7446);
  tv4rhosigmalapl217 = t7 * t7447 + t2864;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t7452 = 0.4e1 * t2031 * t2867;
  t7456 = t2865 * t142;
  t7461 = t2865 * t52;
  t7462 = t3070 * t288;
  t7468 = my_piecewise3(t2, 0, 0.12e2 * t859 * t7456 * t7359 * t155 + 0.48e2 * t859 * t7461 * t7462 * t172 - 0.4e1 * t859 * t1037 * t2866 - 0.12e2 * t2020 * t2867 - t7452);
  tv4rholapl30 = t7 * t7468 + t2870;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t7473 = 0.4e1 * t2115 * t2873;
  t7475 = my_piecewise3(t72, 0, -0.12e2 * t2112 * t2873 - t7473);
  tv4rholapl33 = t7 * t7475 + t2876;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t7480 = my_piecewise3(t2, 0, -0.12e2 * t2089 * t2867 - t7452);
  tv4rholapl34 = t7 * t7480 + t2870;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t7487 = t2871 * t229;
  t7492 = t2871 * t96;
  t7493 = t3737 * t317;
  t7499 = my_piecewise3(t72, 0, 0.12e2 * t897 * t7487 * t7441 * t242 + 0.48e2 * t897 * t7492 * t7493 * t259 - 0.4e1 * t897 * t1044 * t2872 - 0.12e2 * t2149 * t2873 - t7473);
  tv4rholapl37 = t7 * t7499 + t2876;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t7560 = -0.8e1 * t407 * t1770 * t2271 * t939 + 0.4e1 / 0.3e1 * t407 * t408 * t2298 * t954 - 0.8e1 * t407 * t684 * t2251 * t954 + 0.16e2 / 0.9e1 * t407 * t692 * t6625 * t283 + 0.8e1 / 0.9e1 * t407 * t408 * t6517 * t292 + 0.8e1 / 0.9e1 * t407 * t408 * t6522 * t283 + 0.16e2 / 0.9e1 * t407 * t684 * t6527 * t292 - 0.8e1 / 0.3e1 * t407 * t408 * t5183 * t944 - 0.8e1 / 0.3e1 * t407 * t692 * t2276 * t954 + 0.16e2 / 0.3e1 * t407 * t692 * t5203 * t944 + 0.16e2 / 0.3e1 * t407 * t408 * t4085 * t2684 + 0.16e2 / 0.3e1 * t407 * t1770 * t6616 * t292 - 0.16e2 / 0.3e1 * t407 * t1623 * t6681 * t283 - 0.16e2 / 0.3e1 * t407 * t1629 * t2187 * t954 - 0.16e2 / 0.3e1 * t36 * t1770 * t6611;
  t7570 = t939 * t939;
  t7575 = t944 * t944;
  t7580 = t954 * t954;
  t7585 = t916 * t916;
  t7640 = -0.16e2 / 0.3e1 * t36 * t684 * t6589 - 0.8e1 / 0.9e1 * t36 * t408 * t6625 - 0.8e1 / 0.9e1 * t36 * t684 * t6522 + 0.4e1 / 0.3e1 * t36 * t42 * t400 * t7570 + 0.16e2 / 0.3e1 * t36 * t42 * t3071 * t7575 + 0.4e1 / 0.3e1 * t36 * t42 * t439 * t7580 + 0.16e2 / 0.3e1 * t36 * t42 * t3087 * t7585 - 0.16e2 / 0.3e1 * t36 * t2632 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.48e2 * t2662 + 0.48e2 * t56 / t2661 / sigma[0] * t40) - 0.16e2 / 0.3e1 * t36 * t2699 + 0.16e2 / 0.3e1 * t36 * t2703 + 0.8e1 / 0.3e1 * t36 * t2677 + 0.8e1 / 0.3e1 * t36 * t2681 + 0.16e2 / 0.3e1 * t36 * t2690 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.15e2 / 0.16e2 * t43 / t44 / t949 * t46 * t48 + 0.15e2 / 0.16e2 * t43 * t950 * t41 * t151 + 0.5e1 / 0.16e2 * t43 * t288 * t935 * t428 + 0.3e1 / 0.16e2 * t43 * t57 * t2652 * t1161 - 0.15e2 / 0.16e2 * t43 / t39 / t1717 * t3022);
  t7645 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t7560 + t7640));
  tv4sigma40 = t7 * t7645;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t7705 = 0.16e2 / 0.3e1 * t608 * t786 * t5615 * t998 + 0.16e2 / 0.3e1 * t608 * t609 * t4430 * t2778 + 0.16e2 / 0.3e1 * t608 * t1969 * t6856 * t321 - 0.8e1 / 0.3e1 * t608 * t786 * t2403 * t1008 + 0.4e1 / 0.3e1 * t608 * t609 * t2429 * t1008 - 0.8e1 * t608 * t778 * t2439 * t1008 + 0.16e2 / 0.9e1 * t608 * t786 * t6813 * t312 + 0.8e1 / 0.9e1 * t608 * t609 * t6818 * t321 + 0.8e1 / 0.9e1 * t608 * t609 * t6865 * t312 + 0.16e2 / 0.9e1 * t608 * t778 * t6870 * t321 - 0.8e1 / 0.3e1 * t608 * t609 * t5632 * t998 - 0.8e1 * t608 * t1969 * t2458 * t993 - 0.16e2 / 0.3e1 * t608 * t1853 * t2344 * t1008 - 0.16e2 / 0.3e1 * t608 * t1847 * t2344 * t993 - 0.8e1 / 0.9e1 * t36 * t778 * t6865;
  t7715 = t1008 * t1008;
  t7720 = t970 * t970;
  t7725 = t993 * t993;
  t7730 = t998 * t998;
  t7785 = -0.8e1 / 0.9e1 * t36 * t609 * t6813 - 0.16e2 / 0.3e1 * t36 * t778 * t6829 - 0.16e2 / 0.3e1 * t36 * t1969 * t6851 + 0.4e1 / 0.3e1 * t36 * t87 * t640 * t7715 + 0.16e2 / 0.3e1 * t36 * t87 * t3641 * t7720 + 0.4e1 / 0.3e1 * t36 * t87 * t601 * t7725 + 0.16e2 / 0.3e1 * t36 * t87 * t3738 * t7730 - 0.16e2 / 0.3e1 * t36 * t2718 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.15e2 / 0.16e2 * t43 / t88 / t1003 * t90 * t92 + 0.15e2 / 0.16e2 * t43 * t1004 * t86 * t238 + 0.5e1 / 0.16e2 * t43 * t317 * t989 * t629 + 0.3e1 / 0.16e2 * t43 * t101 * t2743 * t1507 - 0.15e2 / 0.16e2 * t43 / t84 / t1890 * t3698) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.48e2 * t2753 + 0.48e2 * t100 / t2752 / sigma[2] * t85) + 0.16e2 / 0.3e1 * t36 * t2767 + 0.8e1 / 0.3e1 * t36 * t2771 + 0.8e1 / 0.3e1 * t36 * t2775 + 0.16e2 / 0.3e1 * t36 * t2784 - 0.16e2 / 0.3e1 * t36 * t2763;
  t7790 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * (t7705 + t7785));
  tv4sigma414 = t7 * t7790;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t7831 = my_piecewise3(t2, 0, 0.3e1 * t859 * t860 * t4719 * t2693 + 0.6e1 * t859 * t2490 * t5203 * t292 - 0.3e1 * t859 * t2490 * t698 * t939 + 0.9e1 * t859 * t2058 * t4085 * t944 - 0.3e1 * t859 * t2058 * t5183 * t292 - 0.3e1 * t859 * t2058 * t1756 * t954 + t859 * t860 * t861 * t2656 / 0.2e1 + 0.12e2 * t859 * t860 * t3071 * t2684 - 0.9e1 * t859 * t2510 * t1765 * t954 + t859 * t860 * t439 * t2666);
  tv4sigma3lapl0 = t7 * t7831;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t7872 = my_piecewise3(t72, 0, 0.3e1 * t897 * t898 * t5107 * t2787 + 0.6e1 * t897 * t2542 * t5615 * t321 - 0.3e1 * t897 * t2542 * t792 * t993 + 0.9e1 * t897 * t2163 * t4430 * t998 - 0.3e1 * t897 * t2163 * t5632 * t321 - 0.3e1 * t897 * t2163 * t1904 * t1008 + t897 * t898 * t899 * t2747 / 0.2e1 + 0.12e2 * t897 * t898 * t3738 * t2778 - 0.9e1 * t897 * t2560 * t1964 * t1008 + t897 * t898 * t640 * t2757);
  tv4sigma3lapl19 = t7 * t7872;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t7906 = my_piecewise3(t2, 0, -0.4e1 * t859 * t1037 * t439 * t950 + 0.2e1 * t859 * t2578 * t2579 * t939 - 0.4e1 * t859 * t2578 * t7354 * t283 - 0.4e1 * t859 * t6392 * t2579 * t916 + 0.6e1 * t859 * t2584 * t2585 * t954 - 0.12e2 * t859 * t2584 * t7359 * t292 - 0.24e2 * t859 * t2584 * t6387 * t944 - 0.12e2 * t5983 * t6398 * t7312 * t292);
  tv4sigma2lapl20 = t7 * t7906;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t7940 = my_piecewise3(t72, 0, -0.4e1 * t897 * t1044 * t640 * t1004 + 0.6e1 * t897 * t2616 * t2617 * t1008 + 0.2e1 * t897 * t2610 * t2611 * t993 - 0.4e1 * t897 * t2610 * t7436 * t312 - 0.4e1 * t897 * t6494 * t2611 * t970 - 0.12e2 * t897 * t2616 * t7441 * t321 - 0.24e2 * t897 * t2616 * t6489 * t998 - 0.12e2 * t6224 * t6500 * t7398 * t321);
  tv4sigma2lapl217 = t7 * t7940;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t7954 = my_piecewise3(t2, 0, 0.24e2 * t859 * t2865 * t1203 * t950 + 0.12e2 * t859 * t7456 * t7359 * t283 + 0.48e2 * t859 * t7461 * t7462 * t292);
  tv4sigmalapl30 = t7 * t7954;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t7968 = my_piecewise3(t72, 0, 0.24e2 * t897 * t2871 * t1579 * t1004 + 0.12e2 * t897 * t7487 * t7441 * t312 + 0.48e2 * t897 * t7492 * t7493 * t321);
  tv4sigmalapl311 = t7 * t7968;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t7974 = my_piecewise3(t2, 0, -0.96e2 * t859 * t34 * t45 * t3071 * t950);
  tv4lapl40 = t7 * t7974;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t7980 = my_piecewise3(t72, 0, -0.96e2 * t897 * t34 * t89 * t3738 * t1004);
  tv4lapl44 = t7 * t7980;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

