/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_csk_loc.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t251;
  double t253, t254, t257, t259, t260, t261, t263, t265;
  double t266, t269, t271, t276, tv2rhosigma0, t289, t290, t292;
  double t293, t297, t298, t301, t303, t305, t309, t311;
  double t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328, t330;
  double t331, t332, t334, t338, t340, t344, tv2sigma20, t352;
  double t354, t355, t356, t357, t358, t361, t362, t365;
  double t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382, t383;
  double t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t251 = t198 * t199 * t97;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t251;
  double t253, t254, t257, t259, t260, t261, t263, t265;
  double t266, t269, t271, t276, tv2rhosigma0, t289, t290, t292;
  double t293, t297, t298, t301, t303, t305, t309, t311;
  double t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328, t330;
  double t331, t332, t334, t338, t340, t344, tv2sigma20, t352;
  double t354, t355, t356, t357, t358, t361, t362, t365;
  double t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382, t383;
  double t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  double t400, t412, t413, t415, t421, t429, t430, t432;
  double t434, t435, t436, t438, t439, t440, t442, t443;
  double t447, t451, t454, t455, t458, t459, t460, t462;
  double t463, t464, t467, t468, t474, t475, t477, t479;
  double t480, t481, t483, t484, t485, t486, t490, t491;
  double t492, t494, t499, t500, t501, t503, t506, t507;
  double t508, t511, t512, t513, t514, t519, t523, t524;
  double t525, t528, t529, t532, t534, t538, t539, t542;
  double t544, t546, t551, tv3rho30, t561, t563, t564, t567;
  double t575, t576, t579, t580, t581, t582, t583, t585;
  double t588, t589, t591, t592, t594, t595, t598, t599;
  double t602, t605, t606, t607, t611, t615, t618, t620;
  double t621, t624, t625, t627, t628, t631, t632, t633;
  double t636, t639, t645, t646, t647, t649, t650, t651;
  double t653, t654, t655, t657, t661, t662, t665, t666;
  double t670, t671, t676, t678, t682, t683, t684, t686;
  double t688, t690, t695, tv3rho2sigma0, t717, t718, t721, t722;
  double t725, t728, t730, t731, t743, t744, t745, t748;
  double t754, t755, t756, t757, t759, t760, t764, t765;
  double t770, t771, t772, t775, t778, t779, t780, t784;
  double t790, t791, t794, t796, t798, t802, t804, t806;
  double t808, t813, tv3rho2lapl0, tv3rho2tau0, t824, t825, t827, t828;
  double t831, t832, t835, t836, t837, t841, t844, t845;
  double t848, t849, t850, t851, t852, t854, t855, t861;
  double t862, t863, t864, t865, t866, t868, t869, t872;
  double t876, t877, t878, t879, t882, t883, t884, t885;
  double t887, t888, t889, t890, t892, t896, t901, t902;
  double t903, t904, t905, t908, t913, t914, t915, t916;
  double t918, t919, t920, t921, t923, t924, t925, t926;
  double t927, t929, t930, t931, t934, t936, t938, t943;
  double tv3rhosigma20, t958, t959, t961, t962, t964, t965, t966;
  double t967, t969, t970, t971, t977, t978, t982, t983;
  double t986, t987, t990, t991, t992, t993, t994, t996;
  double t999, t1002, t1005, t1008, t1009, t1010, t1011, t1012;
  double t1014, t1015, t1016, t1017, t1018, t1023, t1024, t1026;
  double t1027, t1032, t1037, t1039, t1040, t1042, t1045, t1047;
  double t1049, t1054, tv3rhosigmalapl0, tv3rhosigmatau0, t1067, t1068, t1069, t1071;
  double t1072, t1076, t1079, t1082, t1083, t1084, t1086, t1093;
  double t1105, t1109, t1110, t1113, t1114, t1116, t1118, t1119;
  double t1120, t1122, t1123, t1129, t1130, t1136, t1138, t1140;
  double t1145, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1150, t1159, t1160, t1161;
  double t1162, t1163, t1164, t1165, t1167, t1168, t1169, t1170;
  double t1171, t1172, t1173, t1174, t1175, t1176, t1178, t1179;
  double t1180, t1181, t1182, t1184, t1185, t1186, t1187, t1192;
  double t1193, t1196, t1199, t1201, t1202, t1205, t1214, t1216;
  double t1218, t1222, tv3sigma30, t1230, t1231, t1237, t1244, t1245;
  double t1246, t1247, t1248, t1249, t1250, t1251, t1252, t1255;
  double t1256, t1259, t1262, t1263, t1264, t1267, t1268, t1269;
  double t1270, t1271, t1272, t1273, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1285;
  double t1287, t1289, t1290, t1291, t1292, t1295, t1296, t1299;
  double t1301, t1303, t1307, tv3sigma2lapl0, tv3sigma2tau0, t1315, t1316, t1321;
  double t1326, t1332, t1333, t1337, t1338, t1339, t1342, t1343;
  double t1344, t1345, t1346, t1347, t1348, t1349, t1350, t1351;
  double t1352, t1353, t1355, t1356, t1358, t1359, t1360, t1361;
  double t1362, t1369, t1371, t1373, t1377, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1382, t1391, t1392, t1393, t1394, t1395, t1396, t1397;
  double t1399, t1400, t1401, t1402, t1403, t1404, t1405, t1408;
  double t1409, t1410, t1411, t1413, t1414, t1415, t1422, t1433;
  double t1434, t1435, t1436, t1438, t1440, t1444, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t251 = t198 * t199 * t97;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t400 = t21 / t22 / t34;
  t412 = 0.1e1 / t23 / t166 / rho[0];
  t413 = t33 * t412;
  t415 = 0.77e3 / 0.243e3 * t30 * t413;
  t421 = -0.154e3 / 0.81e2 * t41 * t413 - 0.55e2 / 0.81e2 * t45 * t46 * t168 + t415;
  t429 = t69 / t181 / t65;
  t430 = t184 * t97;
  t432 = t186 * t99;
  t434 = 0.1e1 / t187 / t64;
  t435 = t432 * t434;
  t436 = t190 * t67;
  t438 = 0.1e1 / t191 / t68;
  t439 = t436 * t438;
  t440 = t435 * t439;
  t442 = my_piecewise3(t60, 0, t421);
  t443 = my_piecewise3(t62, t442, 0);
  t447 = t435 * t193;
  t451 = t435 * t103;
  t454 = t203 * t186;
  t455 = t183 * t454;
  t458 = t430 * t207;
  t459 = t183 * t458;
  t460 = t188 * params->csk_a;
  t462 = t99 * t67 * t102;
  t463 = t460 * t462;
  t464 = t459 * t463;
  t467 = t199 * t203;
  t468 = t198 * t467;
  t474 = t215 * t216 * t99;
  t475 = t459 * t474;
  t477 = t430 * t99;
  t479 = t199 * t207;
  t480 = t198 * t479;
  t481 = t95 * t477 * t480;
  t483 = t430 * t432;
  t484 = t183 * t483;
  t485 = t434 * params->csk_a;
  t486 = t485 * t103;
  t490 = t192 * t207;
  t491 = t215 * t490;
  t492 = t183 * t477 * t491;
  t494 = -t95 * t443 * t104 - 0.3e1 * t183 * t430 * t447 + 0.3e1 * t95 * t243 * t468 - t429 * t430 * t440 - 0.2e1 * t95 * t430 * t451 - 0.3e1 * t455 * t251 - 0.3e1 * t455 * t266 + 0.3e1 * t484 * t486 - t210 - 0.3e1 * t464 - 0.3e1 * t475 + 0.3e1 * t481 + 0.3e1 * t492;
  t499 = t102 * t99;
  t500 = t198 * t499;
  t501 = t95 * t458 * t500;
  t503 = t95 * t483;
  t506 = t429 * t483;
  t507 = t434 * t190;
  t508 = t507 * t216;
  t511 = t434 * t67;
  t512 = params->csk_a * params->csk_a;
  t513 = t102 * t512;
  t514 = t511 * t513;
  t519 = t192 * t203;
  t523 = t434 * t436;
  t524 = t438 * params->csk_a;
  t525 = t523 * t524;
  t528 = t192 * t512;
  t529 = t507 * t528;
  t532 = t203 * t97;
  t534 = t95 * t532 * t209;
  t538 = t438 * t512;
  t539 = t523 * t538;
  t542 = 0.3e1 * t244 * t215 * t519 + 0.3e1 * t95 * t454 * t261 + 0.3e1 * t484 * t514 + 0.3e1 * t484 * t529 - 0.3e1 * t503 * t486 - t503 * t514 + 0.3e1 * t506 * t508 - t506 * t514 + 0.3e1 * t506 * t525 - 0.3e1 * t506 * t529 - 0.2e1 * t506 * t539 + 0.3e1 * t501 - 0.3e1 * t534;
  t544 = my_piecewise5(t57, 0, t60, 0, t494 + t542);
  t546 = 0.3e1 * t177 * t106 + 0.3e1 * t93 * t220 + t421 * t70 + t52 * t544 - t415;
  t551 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t72 - t8 * t159 * t108 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t222 + 0.3e1 / 0.2e2 * t8 * t24 * t546);
  tv3rho30 = 0.2e1 * rho[0] * t551 + 0.6e1 * t227;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t561 = t32 * t168;
  t563 = 0.55e2 / 0.81e2 * t30 * t561;
  t564 = t119 * t168;
  t567 = 0.11e2 / 0.27e2 * t40 * t564 - t563;
  t575 = my_piecewise3(t60, 0, t567);
  t576 = my_piecewise3(t62, t575, 0);
  t579 = t184 * t99;
  t580 = t183 * t579;
  t581 = t245 * t207;
  t582 = t215 * t581;
  t583 = t580 * t582;
  t585 = t126 * t184;
  t588 = t207 * t188 * t462;
  t589 = t95 * t585 * t588;
  t591 = t126 * t432;
  t592 = t183 * t591;
  t594 = t184 * t67 * t102;
  t595 = t485 * t594;
  t598 = t254 * t186;
  t599 = t183 * t598;
  t602 = t95 * t591;
  t605 = t184 * t432;
  t606 = t429 * t605;
  t607 = t507 * t361;
  t611 = t511 * t513 * t184;
  t615 = t429 * t591;
  t618 = t434 * t512;
  t620 = t184 * t190 * t192;
  t621 = t618 * t620;
  t624 = t216 * t203;
  t625 = t215 * t624;
  t627 = t538 * t184;
  t628 = t523 * t627;
  t631 = t438 * t126;
  t632 = t631 * params->csk_a;
  t633 = t523 * t632;
  t636 = t95 * t598;
  t639 = -t95 * t576 * t104 - 0.2e1 * t599 * t251 + 0.2e1 * t636 * t251 - t263 * t468 - t263 * t625 + 0.3e1 * t592 * t595 + 0.3e1 * t592 * t611 - 0.3e1 * t602 * t595 - t602 * t611 + 0.3e1 * t606 * t607 + 0.3e1 * t606 * t633 - t615 * t611 - 0.3e1 * t615 * t621 - 0.2e1 * t615 * t628 + 0.3e1 * t583 + 0.3e1 * t589;
  t645 = t126 * t99;
  t646 = t645 * t188;
  t647 = t95 * t646;
  t649 = params->csk_a * t184 * t207;
  t650 = t103 * t649;
  t651 = t647 * t650;
  t653 = t585 * t207;
  t654 = t183 * t653;
  t655 = t654 * t474;
  t657 = t654 * t463;
  t661 = t183 * t605;
  t662 = t507 * t245;
  t665 = t102 * t184;
  t666 = t511 * t665;
  t670 = t192 * t254;
  t671 = t215 * t670;
  t676 = t254 * t97;
  t678 = t95 * t676 * t209;
  t682 = t95 * t126 * t203 * t209;
  t683 = t102 * t203;
  t684 = t198 * t683;
  t686 = -t606 * t523 * t631 + 0.2e1 * t244 * t671 + t455 * t246 + t249 * t468 + t249 * t684 + 0.2e1 * t636 * t261 - 0.2e1 * t599 * t266 + 0.3e1 * t592 * t621 - 0.2e1 * t602 * t666 - 0.3e1 * t661 * t662 - t259 + 0.3e1 * t651 - 0.3e1 * t655 - 0.3e1 * t657 - 0.2e1 * t678 - t682;
  t688 = my_piecewise5(t57, 0, t60, 0, t639 + t686);
  t690 = 0.2e1 * t239 * t106 + t123 * t220 + t177 * t129 + 0.2e1 * t93 * t269 + t52 * t688 + t567 * t70 + t563;
  t695 = my_piecewise3(t3, 0, -t8 * t159 * t131 / 0.3e2 + t8 * t78 * t271 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t690);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t695 + 0.4e1 * t276;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t717 = t145 * t432;
  t718 = t183 * t717;
  t721 = t298 * t186;
  t722 = t183 * t721;
  t725 = t95 * t717;
  t728 = t429 * t717;
  t730 = t289 * params->csk_a;
  t731 = t507 * t730;
  t743 = t438 * t145;
  t744 = t743 * params->csk_a;
  t745 = t523 * t744;
  t748 = t95 * t721;
  t754 = t145 * t184;
  t755 = t754 * t207;
  t756 = t183 * t755;
  t757 = t756 * t474;
  t759 = -0.2e1 * t722 * t251 + 0.2e1 * t748 * t251 + t293 * t468 - t305 * t468 - t305 * t625 + 0.3e1 * t718 * t595 - 0.3e1 * t725 * t595 + 0.3e1 * t606 * t731 + 0.3e1 * t606 * t745 + 0.3e1 * t718 * t611 - t725 * t611 - t728 * t611 + 0.3e1 * t718 * t621 - 0.3e1 * t728 * t621 - 0.2e1 * t728 * t628 - 0.3e1 * t757;
  t760 = t756 * t463;
  t764 = my_piecewise3(t60, 0, 0.5e1 / 0.27e2 * t44 * t236);
  t765 = my_piecewise3(t62, t764, 0);
  t770 = t289 * t207;
  t771 = t215 * t770;
  t772 = t580 * t771;
  t775 = t95 * t754 * t588;
  t778 = t145 * t99 * t188;
  t779 = t95 * t778;
  t780 = t779 * t650;
  t784 = t507 * t289;
  t790 = t192 * t298;
  t791 = t215 * t790;
  t794 = t523 * t743;
  t796 = t298 * t97;
  t798 = t95 * t796 * t209;
  t802 = t95 * t145 * t203 * t209;
  t804 = -t95 * t765 * t104 + 0.2e1 * t244 * t791 + 0.2e1 * t748 * t261 - 0.2e1 * t722 * t266 + t455 * t290 + t293 * t684 - t606 * t794 - 0.3e1 * t661 * t784 - 0.2e1 * t725 * t666 - t303 - 0.3e1 * t760 + 0.3e1 * t772 + 0.3e1 * t775 + 0.3e1 * t780 - 0.2e1 * t798 - t802;
  t806 = my_piecewise5(t57, 0, t60, 0, t759 + t804);
  t808 = 0.5e1 / 0.27e2 * t45 * t233 * t70 - 0.5e1 / 0.36e2 * t45 * t116 * t106 + t45 * t137 * t220 / 0.24e2 + t177 * t148 + 0.2e1 * t93 * t309 + t52 * t806;
  t813 = my_piecewise3(t3, 0, -t8 * t159 * t150 / 0.3e2 + t8 * t78 * t311 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t808);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t813 + 0.4e1 * t316;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t824 = t321 * t432;
  t825 = t183 * t824;
  t827 = t97 * t67 * t102;
  t828 = t485 * t827;
  t831 = t216 * t254;
  t832 = t215 * t831;
  t835 = t429 * t824;
  t836 = t538 * t97;
  t837 = t523 * t836;
  t841 = t198 * t199 * t254;
  t844 = t528 * t97;
  t845 = t507 * t844;
  t848 = t328 * t186;
  t849 = t183 * t848;
  t850 = t849 * t266;
  t851 = t321 * t207;
  t852 = t95 * t851;
  t854 = t198 * t260 * t99;
  t855 = t852 * t854;
  t861 = t321 * t99;
  t862 = t183 * t861;
  t863 = t192 * t97;
  t864 = t863 * t207;
  t865 = t215 * t864;
  t866 = t862 * t865;
  t868 = t524 * t97;
  t869 = t523 * t868;
  t872 = t95 * t824;
  t876 = t183 * t851 * t188;
  t877 = params->csk_a * t97;
  t878 = t877 * t462;
  t879 = t876 * t878;
  t882 = t95 * t861 * t188;
  t883 = t877 * t207;
  t884 = t103 * t883;
  t885 = t882 * t884;
  t887 = 0.2e1 * t249 * t841 - 0.2e1 * t263 * t832 - 0.2e1 * t263 * t841 + 0.3e1 * t825 * t828 + 0.3e1 * t825 * t845 - 0.3e1 * t872 * t828 - 0.2e1 * t835 * t837 - 0.3e1 * t835 * t845 + 0.3e1 * t835 * t869 - t330 - t332 - t850 + 0.3e1 * t855 + 0.3e1 * t866 - 0.3e1 * t879 + 0.3e1 * t885;
  t888 = t877 * t99;
  t889 = t193 * t888;
  t890 = t876 * t889;
  t892 = t507 * t265;
  t896 = t511 * t513 * t97;
  t901 = t95 * t848;
  t902 = t901 * t251;
  t903 = t849 * t251;
  t904 = t901 * t261;
  t905 = t511 * t260;
  t908 = t507 * t863;
  t913 = t97 * t432;
  t914 = t429 * t913;
  t915 = t438 * t321;
  t916 = t523 * t915;
  t918 = t192 * t328;
  t919 = t215 * t918;
  t920 = t244 * t919;
  t921 = t328 * t97;
  t923 = t95 * t921 * t209;
  t924 = t126 * t207;
  t925 = t95 * t924;
  t926 = t100 * t67;
  t927 = t102 * t254;
  t929 = t925 * t926 * t927;
  t930 = 0.2e1 * t929;
  t931 = t198 * t927;
  t934 = 0.2e1 * t249 * t931 + 0.2e1 * t263 * t671 + 0.3e1 * t825 * t896 - 0.3e1 * t825 * t908 + 0.3e1 * t835 * t892 - t835 * t896 - t872 * t896 - 0.2e1 * t872 * t905 - t914 * t916 - 0.3e1 * t890 + t902 - t903 + t904 + t920 - t923 - t930;
  t936 = my_piecewise5(t57, 0, t60, 0, t887 + t934);
  t938 = 0.2e1 * t123 * t269 + 0.2e1 * t239 * t129 + t93 * t338 + t52 * t936;
  t943 = my_piecewise3(t3, 0, t8 * t78 * t340 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t938);
  tv3rhosigma20 = 0.2e1 * rho[0] * t943 + 0.2e1 * t344;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t958 = t354 * t207;
  t959 = t183 * t958;
  t961 = t460 * t97 * t462;
  t962 = t959 * t961;
  t964 = t103 * params->csk_a;
  t965 = t257 * t207;
  t966 = t964 * t965;
  t967 = t779 * t966;
  t969 = t215 * t192;
  t970 = t969 * t888;
  t971 = t959 * t970;
  t977 = t631 * t145;
  t978 = t523 * t977;
  t982 = t357 * t97;
  t983 = t511 * t982;
  t986 = t289 * t97;
  t987 = t507 * t986;
  t990 = t717 * t434;
  t991 = t95 * t990;
  t992 = t512 * t126;
  t993 = t992 * t97;
  t994 = t103 * t993;
  t996 = t183 * t990;
  t999 = t429 * t990;
  t1002 = t992 * t193 * t97;
  t1005 = t439 * t993;
  t1008 = -0.3e1 * t999 * t1002 - 0.2e1 * t999 * t1005 + t293 * t841 - t305 * t832 - t305 * t841 - t722 * t352 + t748 * t352 - t722 * t362 - 0.3e1 * t592 * t987 - 0.2e1 * t725 * t983 - t914 * t978 - t991 * t994 + 0.3e1 * t996 * t994 - t999 * t994 - t330 - t850 - 0.3e1 * t962 + 0.3e1 * t967 - 0.3e1 * t971;
  t1009 = t183 * t646;
  t1010 = t301 * t207;
  t1011 = t193 * t1010;
  t1012 = t1009 * t1011;
  t1014 = t591 * t434;
  t1015 = t429 * t1014;
  t1016 = t145 * params->csk_a;
  t1017 = t1016 * t97;
  t1018 = t439 * t1017;
  t1023 = t95 * t958;
  t1024 = t1023 * t854;
  t1026 = t103 * t126;
  t1027 = t877 * t1026;
  t1032 = t193 * t1017;
  t1037 = t298 * t126;
  t1039 = t95 * t1037 * t209;
  t1040 = t145 * t254;
  t1042 = t95 * t1040 * t209;
  t1045 = 0.3e1 * t996 * t1002 + 0.3e1 * t1015 * t1018 + 0.3e1 * t1015 * t1032 - 0.3e1 * t991 * t1027 + 0.3e1 * t996 * t1027 + t263 * t791 + t599 * t290 + t293 * t931 + t748 * t358 + 0.3e1 * t1012 + 0.3e1 * t1024 - t1039 - t1042 - t356 + t902 - t903 + t904 + t920 - t923;
  t1047 = my_piecewise5(t57, 0, t60, 0, t1008 + t1045);
  t1049 = -0.5e1 / 0.72e2 * t45 * t116 * t129 + t45 * t137 * t269 / 0.24e2 + t239 * t148 + t123 * t309 + t93 * t365 + t52 * t1047;
  t1054 = my_piecewise3(t3, 0, t8 * t78 * t367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1049);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1054 + 0.2e1 * t371;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1067 = t376 * t99;
  t1068 = t183 * t1067;
  t1069 = t1068 * t865;
  t1071 = t376 * t432;
  t1072 = t429 * t1071;
  t1076 = t198 * t199 * t298;
  t1079 = t183 * t1071;
  t1082 = t376 * t207;
  t1083 = t95 * t1082;
  t1084 = t1083 * t854;
  t1086 = t95 * t1071;
  t1093 = t216 * t298;
  t1105 = -0.2e1 * t305 * t215 * t1093 - 0.2e1 * t1072 * t837 - 0.3e1 * t1072 * t845 + 0.3e1 * t1072 * t869 + 0.3e1 * t1072 * t892 - t1072 * t896 + 0.2e1 * t293 * t1076 - 0.2e1 * t305 * t1076 + 0.3e1 * t1079 * t845 + 0.3e1 * t1079 * t896 - 0.3e1 * t1086 * t828 - t1086 * t896 + 0.3e1 * t1069 + 0.3e1 * t1084 - t330 - t383;
  t1109 = t183 * t1082 * t188;
  t1110 = t1109 * t878;
  t1113 = t95 * t1067 * t188;
  t1114 = t1113 * t884;
  t1116 = t1109 * t889;
  t1118 = t145 * t207;
  t1119 = t95 * t1118;
  t1120 = t102 * t298;
  t1122 = t1119 * t926 * t1120;
  t1123 = 0.2e1 * t1122;
  t1129 = t438 * t376;
  t1130 = t523 * t1129;
  t1136 = 0.2e1 * t293 * t198 * t1120 + 0.3e1 * t1079 * t828 - 0.3e1 * t1079 * t908 - 0.2e1 * t1086 * t905 - t914 * t1130 + 0.2e1 * t305 * t791 - 0.3e1 * t1110 + 0.3e1 * t1114 - 0.3e1 * t1116 - t1123 - t850 + t902 - t903 + t904 + t920 - t923;
  t1138 = my_piecewise5(t57, 0, t60, 0, t1105 + t1136);
  t1140 = -0.5e1 / 0.36e2 * t45 * t116 * t148 + t45 * t137 * t309 / 0.12e2 + t93 * t389 + t52 * t1138;
  t1145 = my_piecewise3(t3, 0, t8 * t78 * t391 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1140);
  tv3rholapl20 = 0.2e1 * rho[0] * t1145 + 0.2e1 * t395;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1150 = t321 * t126;
  t1159 = t849 * t352;
  t1160 = 0.3e1 * t1159;
  t1161 = t1150 * t207;
  t1162 = t183 * t1161;
  t1163 = t1162 * t463;
  t1164 = 0.3e1 * t1163;
  t1165 = t1150 * t99;
  t1167 = t95 * t1165 * t480;
  t1168 = 0.3e1 * t1167;
  t1169 = t1162 * t474;
  t1170 = 0.3e1 * t1169;
  t1171 = t199 * t328;
  t1172 = t198 * t1171;
  t1173 = t249 * t1172;
  t1174 = 0.3e1 * t1173;
  t1175 = t849 * t362;
  t1176 = 0.3e1 * t1175;
  t1178 = t183 * t1165 * t491;
  t1179 = 0.3e1 * t1178;
  t1180 = t901 * t358;
  t1181 = 0.3e1 * t1180;
  t1182 = -0.3e1 * t183 * t1150 * t447 - t429 * t1150 * t440 - 0.2e1 * t95 * t1150 * t451 - t1160 - t1164 + t1168 - t1170 + t1174 - t1176 + t1179 + t1181 - t330 - t332;
  t1184 = t95 * t1161 * t500;
  t1185 = 0.3e1 * t1184;
  t1186 = t1150 * t432;
  t1187 = t429 * t1186;
  t1192 = t263 * t919;
  t1193 = 0.3e1 * t1192;
  t1196 = t183 * t1186;
  t1199 = t328 * t126;
  t1201 = t95 * t1199 * t209;
  t1202 = 0.3e1 * t1201;
  t1205 = t95 * t1186;
  t1214 = 0.3e1 * t1187 * t508 - t1187 * t514 + 0.3e1 * t1187 * t525 - 0.3e1 * t1187 * t529 - 0.2e1 * t1187 * t539 + 0.3e1 * t1196 * t486 + 0.3e1 * t1196 * t514 + 0.3e1 * t1196 * t529 - 0.3e1 * t1205 * t486 - t1205 * t514 + t1185 + t1193 - t1202;
  t1216 = my_piecewise5(t57, 0, t60, 0, t1182 + t1214);
  t1218 = t52 * t1216 + 0.3e1 * t123 * t338;
  t1222 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1218);
  tv3sigma30 = 0.2e1 * rho[0] * t1222;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1230 = t321 * t67 * t102;
  t1231 = t485 * t1230;
  t1237 = t511 * t513 * t321;
  t1244 = t862 * t771;
  t1245 = 0.3e1 * t1244;
  t1246 = t145 * t321;
  t1247 = t95 * t1246;
  t1248 = t1247 * t588;
  t1249 = 0.3e1 * t1248;
  t1250 = 0.2e1 * t1159;
  t1251 = t538 * t321;
  t1252 = t523 * t1251;
  t1255 = t528 * t321;
  t1256 = t507 * t1255;
  t1259 = t305 * t1172;
  t1262 = t216 * t328;
  t1263 = t215 * t1262;
  t1264 = t305 * t1263;
  t1267 = 0.3e1 * t718 * t1231 - 0.3e1 * t725 * t1231 + 0.3e1 * t718 * t1237 - t725 * t1237 - t728 * t1237 - 0.2e1 * t728 * t1252 + 0.3e1 * t718 * t1256 - 0.3e1 * t728 * t1256 + 0.3e1 * t835 * t731 + 0.3e1 * t835 * t745 + t1245 + t1249 - t1250 - t1259 - t1264 - t330;
  t1268 = t293 * t1172;
  t1269 = 0.2e1 * t1173;
  t1270 = 0.2e1 * t1175;
  t1271 = t1246 * t207;
  t1272 = t183 * t1271;
  t1273 = t1272 * t474;
  t1274 = 0.3e1 * t1273;
  t1275 = t1272 * t463;
  t1276 = 0.3e1 * t1275;
  t1277 = params->csk_a * t321;
  t1278 = t1277 * t207;
  t1279 = t103 * t1278;
  t1280 = t779 * t1279;
  t1281 = 0.3e1 * t1280;
  t1282 = 0.2e1 * t1180;
  t1283 = 0.2e1 * t1192;
  t1284 = 0.2e1 * t1201;
  t1285 = t849 * t290;
  t1287 = t145 * t328;
  t1289 = t95 * t1287 * t209;
  t1290 = t102 * t328;
  t1291 = t198 * t1290;
  t1292 = t293 * t1291;
  t1295 = t102 * t321;
  t1296 = t511 * t1295;
  t1299 = -0.2e1 * t725 * t1296 - 0.3e1 * t825 * t784 - t835 * t794 + t1268 + t1269 - t1270 - t1274 - t1276 + t1281 + t1282 + t1283 - t1284 + t1285 - t1289 + t1292 - t356;
  t1301 = my_piecewise5(t57, 0, t60, 0, t1267 + t1299);
  t1303 = t45 * t137 * t338 / 0.24e2 + 0.2e1 * t123 * t365 + t52 * t1301;
  t1307 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1303);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1307;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1315 = t513 * t126;
  t1316 = t511 * t1315;
  t1321 = t485 * t1026;
  t1326 = t538 * t126;
  t1332 = t528 * t126;
  t1333 = t507 * t1332;
  t1337 = t198 * t357 * t99;
  t1338 = t1083 * t1337;
  t1339 = 0.3e1 * t1338;
  t1342 = t1068 * t582;
  t1343 = 0.3e1 * t1342;
  t1344 = 0.2e1 * t1259;
  t1345 = -0.2e1 * t1072 * t523 * t1326 - t1072 * t1316 - 0.3e1 * t1072 * t1333 + 0.3e1 * t1072 * t607 + 0.3e1 * t1072 * t633 + 0.3e1 * t1079 * t1316 + 0.3e1 * t1079 * t1321 + 0.3e1 * t1079 * t1333 - t1086 * t1316 - 0.3e1 * t1086 * t1321 - t1159 + t1339 + t1343 - t1344 - t330 - t383;
  t1346 = 0.2e1 * t1264;
  t1347 = 0.2e1 * t1268;
  t1348 = params->csk_a * t126;
  t1349 = t1348 * t207;
  t1350 = t103 * t1349;
  t1351 = t1113 * t1350;
  t1352 = 0.3e1 * t1351;
  t1353 = t1348 * t99;
  t1355 = t1109 * t193 * t1353;
  t1356 = 0.3e1 * t1355;
  t1358 = t1109 * t1348 * t462;
  t1359 = 0.3e1 * t1358;
  t1360 = 0.2e1 * t1285;
  t1361 = 0.2e1 * t1289;
  t1362 = 0.2e1 * t1292;
  t1369 = -0.2e1 * t1086 * t511 * t357 - 0.3e1 * t1079 * t662 - t615 * t1130 + t1173 - t1175 + t1180 + t1192 - t1201 - t1346 + t1347 + t1352 - t1356 - t1359 + t1360 - t1361 + t1362;
  t1371 = my_piecewise5(t57, 0, t60, 0, t1345 + t1369);
  t1373 = t45 * t137 * t365 / 0.12e2 + t123 * t389 + t52 * t1371;
  t1377 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1373);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1377;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1382 = t376 * t145;
  t1391 = t1382 * t207;
  t1392 = t183 * t1391;
  t1393 = t1392 * t474;
  t1394 = 0.3e1 * t1393;
  t1395 = t1392 * t463;
  t1396 = 0.3e1 * t1395;
  t1397 = t1382 * t99;
  t1399 = t95 * t1397 * t480;
  t1400 = 0.3e1 * t1399;
  t1401 = 0.3e1 * t1259;
  t1402 = 0.3e1 * t1264;
  t1403 = 0.3e1 * t1268;
  t1404 = t1382 * t432;
  t1405 = t95 * t1404;
  t1408 = t95 * t1391;
  t1409 = t1408 * t500;
  t1410 = 0.3e1 * t1409;
  t1411 = -0.3e1 * t183 * t1382 * t447 - t429 * t1382 * t440 - 0.2e1 * t95 * t1382 * t451 - 0.3e1 * t1405 * t486 - t1394 - t1396 + t1400 - t1401 - t1402 + t1403 + t1410 - t330 - t383;
  t1413 = t183 * t1397 * t491;
  t1414 = 0.3e1 * t1413;
  t1415 = t429 * t1404;
  t1422 = t183 * t1404;
  t1433 = 0.3e1 * t1285;
  t1434 = 0.3e1 * t1289;
  t1435 = 0.3e1 * t1292;
  t1436 = -t1405 * t514 + 0.3e1 * t1415 * t508 - t1415 * t514 + 0.3e1 * t1415 * t525 - 0.3e1 * t1415 * t529 - 0.2e1 * t1415 * t539 + 0.3e1 * t1422 * t486 + 0.3e1 * t1422 * t514 + 0.3e1 * t1422 * t529 + t1414 + t1433 - t1434 + t1435;
  t1438 = my_piecewise5(t57, 0, t60, 0, t1411 + t1436);
  t1440 = t45 * t137 * t389 / 0.8e1 + t52 * t1438;
  t1444 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1440);
  tv3lapl30 = 0.2e1 * rho[0] * t1444;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t251;
  double t253, t254, t257, t259, t260, t261, t263, t265;
  double t266, t269, t271, t276, tv2rhosigma0, t289, t290, t292;
  double t293, t297, t298, t301, t303, t305, t309, t311;
  double t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328, t330;
  double t331, t332, t334, t338, t340, t344, tv2sigma20, t352;
  double t354, t355, t356, t357, t358, t361, t362, t365;
  double t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382, t383;
  double t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  double t400, t412, t413, t415, t421, t429, t430, t432;
  double t434, t435, t436, t438, t439, t440, t442, t443;
  double t447, t451, t454, t455, t458, t459, t460, t462;
  double t463, t464, t467, t468, t474, t475, t477, t479;
  double t480, t481, t483, t484, t485, t486, t490, t491;
  double t492, t494, t499, t500, t501, t503, t506, t507;
  double t508, t511, t512, t513, t514, t519, t523, t524;
  double t525, t528, t529, t532, t534, t538, t539, t542;
  double t544, t546, t551, tv3rho30, t561, t563, t564, t567;
  double t575, t576, t579, t580, t581, t582, t583, t585;
  double t588, t589, t591, t592, t594, t595, t598, t599;
  double t602, t605, t606, t607, t611, t615, t618, t620;
  double t621, t624, t625, t627, t628, t631, t632, t633;
  double t636, t639, t645, t646, t647, t649, t650, t651;
  double t653, t654, t655, t657, t661, t662, t665, t666;
  double t670, t671, t676, t678, t682, t683, t684, t686;
  double t688, t690, t695, tv3rho2sigma0, t717, t718, t721, t722;
  double t725, t728, t730, t731, t743, t744, t745, t748;
  double t754, t755, t756, t757, t759, t760, t764, t765;
  double t770, t771, t772, t775, t778, t779, t780, t784;
  double t790, t791, t794, t796, t798, t802, t804, t806;
  double t808, t813, tv3rho2lapl0, tv3rho2tau0, t824, t825, t827, t828;
  double t831, t832, t835, t836, t837, t841, t844, t845;
  double t848, t849, t850, t851, t852, t854, t855, t861;
  double t862, t863, t864, t865, t866, t868, t869, t872;
  double t876, t877, t878, t879, t882, t883, t884, t885;
  double t887, t888, t889, t890, t892, t896, t901, t902;
  double t903, t904, t905, t908, t913, t914, t915, t916;
  double t918, t919, t920, t921, t923, t924, t925, t926;
  double t927, t929, t930, t931, t934, t936, t938, t943;
  double tv3rhosigma20, t958, t959, t961, t962, t964, t965, t966;
  double t967, t969, t970, t971, t977, t978, t982, t983;
  double t986, t987, t990, t991, t992, t993, t994, t996;
  double t999, t1002, t1005, t1008, t1009, t1010, t1011, t1012;
  double t1014, t1015, t1016, t1017, t1018, t1023, t1024, t1026;
  double t1027, t1032, t1037, t1039, t1040, t1042, t1045, t1047;
  double t1049, t1054, tv3rhosigmalapl0, tv3rhosigmatau0, t1067, t1068, t1069, t1071;
  double t1072, t1076, t1079, t1082, t1083, t1084, t1086, t1093;
  double t1105, t1109, t1110, t1113, t1114, t1116, t1118, t1119;
  double t1120, t1122, t1123, t1129, t1130, t1136, t1138, t1140;
  double t1145, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1150, t1159, t1160, t1161;
  double t1162, t1163, t1164, t1165, t1167, t1168, t1169, t1170;
  double t1171, t1172, t1173, t1174, t1175, t1176, t1178, t1179;
  double t1180, t1181, t1182, t1184, t1185, t1186, t1187, t1192;
  double t1193, t1196, t1199, t1201, t1202, t1205, t1214, t1216;
  double t1218, t1222, tv3sigma30, t1230, t1231, t1237, t1244, t1245;
  double t1246, t1247, t1248, t1249, t1250, t1251, t1252, t1255;
  double t1256, t1259, t1262, t1263, t1264, t1267, t1268, t1269;
  double t1270, t1271, t1272, t1273, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1285;
  double t1287, t1289, t1290, t1291, t1292, t1295, t1296, t1299;
  double t1301, t1303, t1307, tv3sigma2lapl0, tv3sigma2tau0, t1315, t1316, t1321;
  double t1326, t1332, t1333, t1337, t1338, t1339, t1342, t1343;
  double t1344, t1345, t1346, t1347, t1348, t1349, t1350, t1351;
  double t1352, t1353, t1355, t1356, t1358, t1359, t1360, t1361;
  double t1362, t1369, t1371, t1373, t1377, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1382, t1391, t1392, t1393, t1394, t1395, t1396, t1397;
  double t1399, t1400, t1401, t1402, t1403, t1404, t1405, t1408;
  double t1409, t1410, t1411, t1413, t1414, t1415, t1422, t1433;
  double t1434, t1435, t1436, t1438, t1440, t1444, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  double t1465, t1467, t1473, t1484, t1485, t1493, t1495, t1496;
  double t1498, t1499, t1500, t1501, t1502, t1503, t1504, t1505;
  double t1506, t1508, t1509, t1512, t1513, t1517, t1518, t1519;
  double t1523, t1526, t1527, t1530, t1533, t1534, t1535, t1537;
  double t1540, t1541, t1544, t1545, t1548, t1551, t1552, t1556;
  double t1559, t1562, t1565, t1569, t1573, t1574, t1577, t1581;
  double t1585, t1589, t1592, t1594, t1599, t1604, t1607, t1608;
  double t1610, t1615, t1621, t1626, t1629, t1633, t1638, t1640;
  double t1643, t1646, t1649, t1650, t1651, t1652, t1653, t1656;
  double t1657, t1658, t1661, t1662, t1663, t1664, t1667, t1672;
  double t1673, t1678, t1681, t1682, t1685, t1686, t1698, t1701;
  double t1707, t1708, t1715, t1721, t1726, t1728, t1729, t1732;
  double t1733, t1736, t1746, t1747, t1748, t1749, t1758, t1759;
  double t1760, t1765, t1781, t1785, t1792, tv4rho40, t1807, t1811;
  double t1827, t1828, t1831, t1833, t1838, t1840, t1841, t1844;
  double t1849, t1851, t1852, t1855, t1857, t1861, t1862, t1866;
  double t1867, t1868, t1869, t1870, t1873, t1876, t1879, t1882;
  double t1883, t1884, t1887, t1893, t1896, t1904, t1905, t1908;
  double t1909, t1911, t1914, t1915, t1916, t1920, t1923, t1927;
  double t1929, t1933, t1936, t1938, t1940, t1943, t1944, t1947;
  double t1955, t1956, t1959, t1960, t1963, t1964, t1967, t1971;
  double t1973, t1976, t1979, t1983, t1986, t1995, t2000, t2004;
  double t2009, t2014, t2017, t2020, t2024, t2031, t2040, t2042;
  double t2045, t2051, t2056, t2062, t2064, t2067, t2073, t2076;
  double t2078, t2082, t2095, t2098, t2100, t2101, t2105, t2113;
  double t2115, t2132, t2137, t2146, t2151, t2160, t2163, t2167;
  double t2171, t2183, t2187, t2194, tv4rho3sigma0, t2224, t2231, t2232;
  double t2235, t2236, t2237, t2248, t2249, t2256, t2259, t2260;
  double t2263, t2264, t2271, t2278, t2287, t2291, t2296, t2301;
  double t2302, t2305, t2306, t2309, t2316, t2319, t2322, t2325;
  double t2332, t2333, t2336, t2339, t2344, t2353, t2354, t2357;
  double t2360, t2365, t2366, t2370, t2377, t2381, t2399, t2403;
  double t2407, t2413, t2415, t2418, t2421, t2423, t2427, t2446;
  double t2451, t2456, t2465, t2474, t2477, t2485, t2492, t2501;
  double t2504, t2512, t2516, t2523, tv4rho3lapl0, tv4rho3tau0, t2542, t2543;
  double t2546, t2548, t2556, t2557, t2560, t2561, t2562, t2564;
  double t2565, t2566, t2567, t2569, t2572, t2575, t2577, t2579;
  double t2585, t2588, t2593, t2597, t2599, t2600, t2603, t2609;
  double t2619, t2620, t2626, t2634, t2639, t2640, t2649, t2654;
  double t2656, t2660, t2661, t2662, t2663, t2666, t2667, t2668;
  double t2672, t2675, t2676, t2681, t2682, t2684, t2685, t2687;
  double t2688, t2691, t2694, t2697, t2701, t2707, t2709, t2710;
  double t2712, t2713, t2714, t2716, t2719, t2720, t2722, t2728;
  double t2729, t2733, t2743, t2746, t2747, t2749, t2751, t2753;
  double t2756, t2759, t2765, t2771, t2775, t2778, t2784, t2788;
  double t2798, t2800, t2801, t2802, t2804, t2805, t2807, t2835;
  double t2845, t2847, t2848, t2850, t2851, t2852, t2857, t2862;
  double t2868, t2869, t2876, t2879, t2883, t2884, t2885, t2893;
  double t2894, t2895, t2896, t2899, t2900, t2904, t2907, t2908;
  double t2910, t2911, t2919, t2926, t2927, t2928, t2930, t2934;
  double t2941, tv4rho2sigma20, t2972, t2976, t2977, t2980, t2981, t2988;
  double t2989, t2993, t2995, t3007, t3011, t3026, t3028, t3029;
  double t3034, t3035, t3036, t3037, t3041, t3042, t3043, t3047;
  double t3048, t3049, t3050, t3051, t3053, t3056, t3059, t3061;
  double t3064, t3079, t3084, t3087, t3090, t3099, t3107, t3111;
  double t3122, t3129, t3131, t3145, t3146, t3147, t3152, t3153;
  double t3174, t3175, t3204, t3211, t3212, t3217, t3218, t3233;
  double t3248, t3255, t3261, t3270, t3287, t3291, t3296, t3300;
  double t3321, t3325, t3332, tv4rho2sigmalapl0, tv4rho2sigmatau0, t3354, t3355, t3358;
  double t3361, t3364, t3365, t3368, t3371, t3382, t3391, t3392;
  double t3397, t3398, t3399, t3400, t3409, t3410, t3428, t3429;
  double t3432, t3435, t3437, t3442, t3449, t3452, t3453, t3458;
  double t3465, t3480, t3495, t3515, t3520, t3542, t3545, t3547;
  double t3555, t3562, t3563, t3568, t3569, t3574, t3575, t3580;
  double t3592, t3595, t3596, t3608, t3614, t3621, t3622, t3631;
  double t3635, t3642, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, t3653, t3654, t3655;
  double t3656, t3658, t3660, t3662, t3665, t3666, t3669, t3672;
  double t3673, t3674, t3675, t3678, t3679, t3681, t3683, t3684;
  double t3685, t3686, t3689, t3690, t3691, t3692, t3694, t3697;
  double t3701, t3702, t3703, t3706, t3708, t3709, t3710, t3713;
  double t3715, t3719, t3720, t3728, t3731, t3733, t3735, t3737;
  double t3739, t3741, t3742, t3743, t3747, t3750, t3751, t3752;
  double t3755, t3758, t3761, t3762, t3765, t3767, t3771, t3775;
  double t3781, t3786, t3789, t3792, t3797, t3798, t3799, t3802;
  double t3806, t3813, t3820, t3824, t3832, t3841, t3844, t3845;
  double t3846, t3852, t3857, t3866, t3869, t3872, t3878, t3884;
  double t3889, t3893, t3898, t3900, t3905, t3906, t3908, t3909;
  double t3911, t3913, t3915, t3922, t3930, t3934, t3935, t3937;
  double t3939, t3942, t3950, t3953, t3954, t3958, t3965, tv4rhosigma30;
  double t3982, t3984, t3985, t3990, t3991, t3998, t4000, t4004;
  double t4011, t4018, t4023, t4024, t4026, t4027, t4029, t4030;
  double t4031, t4035, t4051, t4052, t4054, t4056, t4059, t4062;
  double t4063, t4064, t4067, t4071, t4075, t4077, t4080, t4081;
  double t4083, t4085, t4090, t4093, t4099, t4107, t4119, t4133;
  double t4140, t4148, t4169, t4171, t4186, t4197, t4198, t4206;
  double t4209, t4212, t4224, t4233, t4240, t4241, t4245, t4248;
  double t4259, t4278, t4283, t4289, t4298, t4302, t4306, t4307;
  double t4314, t4319, t4326, tv4rhosigma2lapl0, tv4rhosigma2tau0, t4341, t4342, t4343;
  double t4344, t4347, t4348, t4354, t4355, t4358, t4359, t4362;
  double t4367, t4386, t4389, t4394, t4415, t4416, t4421, t4422;
  double t4429, t4439, t4458, t4467, t4489, t4522, t4543, t4565;
  double t4569, t4577, t4582, t4605, t4610, t4621, t4626, t4633;
  double tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, t4646, t4647, t4648, t4651, t4652;
  double t4655, t4658, t4661, t4683, t4686, t4701, t4702, t4705;
  double t4707, t4710, t4716, t4734, t4735, t4740, t4749, t4751;
  double t4756, t4757, t4764, t4776, t4781, t4784, t4793, t4802;
  double t4804, t4812, t4822, t4826, t4835, t4840, t4841, t4842;
  double t4847, t4860, t4865, t4869, t4876, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20;
  double tv4rhotau30, t4882, t4883, t4888, t4891, t4892, t4894, t4895;
  double t4896, t4899, t4904, t4907, t4912, t4913, t4917, t4918;
  double t4920, t4922, t4924, t4927, t4928, t4930, t4932, t4938;
  double t4940, t4942, t4943, t4945, t4948, t4955, t4957, t4965;
  double t4966, t4968, t4971, t4974, t4975, t4988, t4996, t5000;
  double t5001, t5004, t5007, t5010, t5022, t5031, t5035, t5036;
  double t5038, t5044, t5052, t5053, t5055, t5058, t5060, t5086;
  double t5090, t5096, tv4sigma40, t5103, t5104, t5105, t5106, t5107;
  double t5108, t5109, t5110, t5111, t5112, t5114, t5118, t5121;
  double t5122, t5125, t5126, t5127, t5136, t5137, t5138, t5139;
  double t5140, t5141, t5144, t5145, t5153, t5154, t5157, t5158;
  double t5160, t5161, t5162, t5163, t5168, t5171, t5174, t5181;
  double t5189, t5206, t5207, t5210, t5216, t5233, t5234, t5239;
  double t5247, t5248, t5250, t5251, t5267, t5275, t5276, t5277;
  double t5279, t5280, t5281, t5282, t5285, t5290, t5307, t5311;
  double t5317, tv4sigma3lapl0, tv4sigma3tau0, t5325, t5333, t5334, t5339, t5352;
  double t5355, t5357, t5359, t5376, t5379, t5382, t5385, t5390;
  double t5399, t5403, t5404, t5412, t5419, t5430, t5441, t5443;
  double t5444, t5446, t5447, t5449, t5454, t5456, t5459, t5463;
  double t5471, t5475, t5485, t5494, t5506, t5513, t5516, t5521;
  double t5525, t5536, t5540, t5546, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, t5552;
  double t5562, t5563, t5582, t5586, t5588, t5592, t5598, t5605;
  double t5612, t5621, t5644, t5654, t5675, t5676, t5678, t5696;
  double t5700, t5706, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t5714, t5715;
  double t5719, t5722, t5723, t5727, t5733, t5752, t5762, t5771;
  double t5782, t5794, t5795, t5798, t5801, t5818, t5826, t5827;
  double t5837, t5866, t5870, t5876, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30;
  double tv4tau40;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t251 = t198 * t199 * t97;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t400 = t21 / t22 / t34;
  t412 = 0.1e1 / t23 / t166 / rho[0];
  t413 = t33 * t412;
  t415 = 0.77e3 / 0.243e3 * t30 * t413;
  t421 = -0.154e3 / 0.81e2 * t41 * t413 - 0.55e2 / 0.81e2 * t45 * t46 * t168 + t415;
  t429 = t69 / t181 / t65;
  t430 = t184 * t97;
  t432 = t186 * t99;
  t434 = 0.1e1 / t187 / t64;
  t435 = t432 * t434;
  t436 = t190 * t67;
  t438 = 0.1e1 / t191 / t68;
  t439 = t436 * t438;
  t440 = t435 * t439;
  t442 = my_piecewise3(t60, 0, t421);
  t443 = my_piecewise3(t62, t442, 0);
  t447 = t435 * t193;
  t451 = t435 * t103;
  t454 = t203 * t186;
  t455 = t183 * t454;
  t458 = t430 * t207;
  t459 = t183 * t458;
  t460 = t188 * params->csk_a;
  t462 = t99 * t67 * t102;
  t463 = t460 * t462;
  t464 = t459 * t463;
  t467 = t199 * t203;
  t468 = t198 * t467;
  t474 = t215 * t216 * t99;
  t475 = t459 * t474;
  t477 = t430 * t99;
  t479 = t199 * t207;
  t480 = t198 * t479;
  t481 = t95 * t477 * t480;
  t483 = t430 * t432;
  t484 = t183 * t483;
  t485 = t434 * params->csk_a;
  t486 = t485 * t103;
  t490 = t192 * t207;
  t491 = t215 * t490;
  t492 = t183 * t477 * t491;
  t494 = -t95 * t443 * t104 - 0.3e1 * t183 * t430 * t447 + 0.3e1 * t95 * t243 * t468 - t429 * t430 * t440 - 0.2e1 * t95 * t430 * t451 - 0.3e1 * t455 * t251 - 0.3e1 * t455 * t266 + 0.3e1 * t484 * t486 - t210 - 0.3e1 * t464 - 0.3e1 * t475 + 0.3e1 * t481 + 0.3e1 * t492;
  t499 = t102 * t99;
  t500 = t198 * t499;
  t501 = t95 * t458 * t500;
  t503 = t95 * t483;
  t506 = t429 * t483;
  t507 = t434 * t190;
  t508 = t507 * t216;
  t511 = t434 * t67;
  t512 = params->csk_a * params->csk_a;
  t513 = t102 * t512;
  t514 = t511 * t513;
  t519 = t192 * t203;
  t523 = t434 * t436;
  t524 = t438 * params->csk_a;
  t525 = t523 * t524;
  t528 = t192 * t512;
  t529 = t507 * t528;
  t532 = t203 * t97;
  t534 = t95 * t532 * t209;
  t538 = t438 * t512;
  t539 = t523 * t538;
  t542 = 0.3e1 * t244 * t215 * t519 + 0.3e1 * t95 * t454 * t261 + 0.3e1 * t484 * t514 + 0.3e1 * t484 * t529 - 0.3e1 * t503 * t486 - t503 * t514 + 0.3e1 * t506 * t508 - t506 * t514 + 0.3e1 * t506 * t525 - 0.3e1 * t506 * t529 - 0.2e1 * t506 * t539 + 0.3e1 * t501 - 0.3e1 * t534;
  t544 = my_piecewise5(t57, 0, t60, 0, t494 + t542);
  t546 = 0.3e1 * t177 * t106 + 0.3e1 * t93 * t220 + t421 * t70 + t52 * t544 - t415;
  t551 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t72 - t8 * t159 * t108 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t222 + 0.3e1 / 0.2e2 * t8 * t24 * t546);
  tv3rho30 = 0.2e1 * rho[0] * t551 + 0.6e1 * t227;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t561 = t32 * t168;
  t563 = 0.55e2 / 0.81e2 * t30 * t561;
  t564 = t119 * t168;
  t567 = 0.11e2 / 0.27e2 * t40 * t564 - t563;
  t575 = my_piecewise3(t60, 0, t567);
  t576 = my_piecewise3(t62, t575, 0);
  t579 = t184 * t99;
  t580 = t183 * t579;
  t581 = t245 * t207;
  t582 = t215 * t581;
  t583 = t580 * t582;
  t585 = t126 * t184;
  t588 = t207 * t188 * t462;
  t589 = t95 * t585 * t588;
  t591 = t126 * t432;
  t592 = t183 * t591;
  t594 = t184 * t67 * t102;
  t595 = t485 * t594;
  t598 = t254 * t186;
  t599 = t183 * t598;
  t602 = t95 * t591;
  t605 = t184 * t432;
  t606 = t429 * t605;
  t607 = t507 * t361;
  t611 = t511 * t513 * t184;
  t615 = t429 * t591;
  t618 = t434 * t512;
  t620 = t184 * t190 * t192;
  t621 = t618 * t620;
  t624 = t216 * t203;
  t625 = t215 * t624;
  t627 = t538 * t184;
  t628 = t523 * t627;
  t631 = t438 * t126;
  t632 = t631 * params->csk_a;
  t633 = t523 * t632;
  t636 = t95 * t598;
  t639 = -t95 * t576 * t104 - 0.2e1 * t599 * t251 + 0.2e1 * t636 * t251 - t263 * t468 - t263 * t625 + 0.3e1 * t592 * t595 + 0.3e1 * t592 * t611 - 0.3e1 * t602 * t595 - t602 * t611 + 0.3e1 * t606 * t607 + 0.3e1 * t606 * t633 - t615 * t611 - 0.3e1 * t615 * t621 - 0.2e1 * t615 * t628 + 0.3e1 * t583 + 0.3e1 * t589;
  t645 = t126 * t99;
  t646 = t645 * t188;
  t647 = t95 * t646;
  t649 = params->csk_a * t184 * t207;
  t650 = t103 * t649;
  t651 = t647 * t650;
  t653 = t585 * t207;
  t654 = t183 * t653;
  t655 = t654 * t474;
  t657 = t654 * t463;
  t661 = t183 * t605;
  t662 = t507 * t245;
  t665 = t102 * t184;
  t666 = t511 * t665;
  t670 = t192 * t254;
  t671 = t215 * t670;
  t676 = t254 * t97;
  t678 = t95 * t676 * t209;
  t682 = t95 * t126 * t203 * t209;
  t683 = t102 * t203;
  t684 = t198 * t683;
  t686 = -t606 * t523 * t631 + 0.2e1 * t244 * t671 + t455 * t246 + t249 * t468 + t249 * t684 + 0.2e1 * t636 * t261 - 0.2e1 * t599 * t266 + 0.3e1 * t592 * t621 - 0.2e1 * t602 * t666 - 0.3e1 * t661 * t662 - t259 + 0.3e1 * t651 - 0.3e1 * t655 - 0.3e1 * t657 - 0.2e1 * t678 - t682;
  t688 = my_piecewise5(t57, 0, t60, 0, t639 + t686);
  t690 = 0.2e1 * t239 * t106 + t123 * t220 + t177 * t129 + 0.2e1 * t93 * t269 + t52 * t688 + t567 * t70 + t563;
  t695 = my_piecewise3(t3, 0, -t8 * t159 * t131 / 0.3e2 + t8 * t78 * t271 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t690);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t695 + 0.4e1 * t276;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t717 = t145 * t432;
  t718 = t183 * t717;
  t721 = t298 * t186;
  t722 = t183 * t721;
  t725 = t95 * t717;
  t728 = t429 * t717;
  t730 = t289 * params->csk_a;
  t731 = t507 * t730;
  t743 = t438 * t145;
  t744 = t743 * params->csk_a;
  t745 = t523 * t744;
  t748 = t95 * t721;
  t754 = t145 * t184;
  t755 = t754 * t207;
  t756 = t183 * t755;
  t757 = t756 * t474;
  t759 = -0.2e1 * t722 * t251 + 0.2e1 * t748 * t251 + t293 * t468 - t305 * t468 - t305 * t625 + 0.3e1 * t718 * t595 - 0.3e1 * t725 * t595 + 0.3e1 * t606 * t731 + 0.3e1 * t606 * t745 + 0.3e1 * t718 * t611 - t725 * t611 - t728 * t611 + 0.3e1 * t718 * t621 - 0.3e1 * t728 * t621 - 0.2e1 * t728 * t628 - 0.3e1 * t757;
  t760 = t756 * t463;
  t764 = my_piecewise3(t60, 0, 0.5e1 / 0.27e2 * t44 * t236);
  t765 = my_piecewise3(t62, t764, 0);
  t770 = t289 * t207;
  t771 = t215 * t770;
  t772 = t580 * t771;
  t775 = t95 * t754 * t588;
  t778 = t145 * t99 * t188;
  t779 = t95 * t778;
  t780 = t779 * t650;
  t784 = t507 * t289;
  t790 = t192 * t298;
  t791 = t215 * t790;
  t794 = t523 * t743;
  t796 = t298 * t97;
  t798 = t95 * t796 * t209;
  t802 = t95 * t145 * t203 * t209;
  t804 = -t95 * t765 * t104 + 0.2e1 * t244 * t791 + 0.2e1 * t748 * t261 - 0.2e1 * t722 * t266 + t455 * t290 + t293 * t684 - t606 * t794 - 0.3e1 * t661 * t784 - 0.2e1 * t725 * t666 - t303 - 0.3e1 * t760 + 0.3e1 * t772 + 0.3e1 * t775 + 0.3e1 * t780 - 0.2e1 * t798 - t802;
  t806 = my_piecewise5(t57, 0, t60, 0, t759 + t804);
  t808 = 0.5e1 / 0.27e2 * t45 * t233 * t70 - 0.5e1 / 0.36e2 * t45 * t116 * t106 + t45 * t137 * t220 / 0.24e2 + t177 * t148 + 0.2e1 * t93 * t309 + t52 * t806;
  t813 = my_piecewise3(t3, 0, -t8 * t159 * t150 / 0.3e2 + t8 * t78 * t311 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t808);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t813 + 0.4e1 * t316;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t824 = t321 * t432;
  t825 = t183 * t824;
  t827 = t97 * t67 * t102;
  t828 = t485 * t827;
  t831 = t216 * t254;
  t832 = t215 * t831;
  t835 = t429 * t824;
  t836 = t538 * t97;
  t837 = t523 * t836;
  t841 = t198 * t199 * t254;
  t844 = t528 * t97;
  t845 = t507 * t844;
  t848 = t328 * t186;
  t849 = t183 * t848;
  t850 = t849 * t266;
  t851 = t321 * t207;
  t852 = t95 * t851;
  t854 = t198 * t260 * t99;
  t855 = t852 * t854;
  t861 = t321 * t99;
  t862 = t183 * t861;
  t863 = t192 * t97;
  t864 = t863 * t207;
  t865 = t215 * t864;
  t866 = t862 * t865;
  t868 = t524 * t97;
  t869 = t523 * t868;
  t872 = t95 * t824;
  t876 = t183 * t851 * t188;
  t877 = params->csk_a * t97;
  t878 = t877 * t462;
  t879 = t876 * t878;
  t882 = t95 * t861 * t188;
  t883 = t877 * t207;
  t884 = t103 * t883;
  t885 = t882 * t884;
  t887 = 0.2e1 * t249 * t841 - 0.2e1 * t263 * t832 - 0.2e1 * t263 * t841 + 0.3e1 * t825 * t828 + 0.3e1 * t825 * t845 - 0.3e1 * t872 * t828 - 0.2e1 * t835 * t837 - 0.3e1 * t835 * t845 + 0.3e1 * t835 * t869 - t330 - t332 - t850 + 0.3e1 * t855 + 0.3e1 * t866 - 0.3e1 * t879 + 0.3e1 * t885;
  t888 = t877 * t99;
  t889 = t193 * t888;
  t890 = t876 * t889;
  t892 = t507 * t265;
  t896 = t511 * t513 * t97;
  t901 = t95 * t848;
  t902 = t901 * t251;
  t903 = t849 * t251;
  t904 = t901 * t261;
  t905 = t511 * t260;
  t908 = t507 * t863;
  t913 = t97 * t432;
  t914 = t429 * t913;
  t915 = t438 * t321;
  t916 = t523 * t915;
  t918 = t192 * t328;
  t919 = t215 * t918;
  t920 = t244 * t919;
  t921 = t328 * t97;
  t923 = t95 * t921 * t209;
  t924 = t126 * t207;
  t925 = t95 * t924;
  t926 = t100 * t67;
  t927 = t102 * t254;
  t929 = t925 * t926 * t927;
  t930 = 0.2e1 * t929;
  t931 = t198 * t927;
  t934 = 0.2e1 * t249 * t931 + 0.2e1 * t263 * t671 + 0.3e1 * t825 * t896 - 0.3e1 * t825 * t908 + 0.3e1 * t835 * t892 - t835 * t896 - t872 * t896 - 0.2e1 * t872 * t905 - t914 * t916 - 0.3e1 * t890 + t902 - t903 + t904 + t920 - t923 - t930;
  t936 = my_piecewise5(t57, 0, t60, 0, t887 + t934);
  t938 = 0.2e1 * t123 * t269 + 0.2e1 * t239 * t129 + t93 * t338 + t52 * t936;
  t943 = my_piecewise3(t3, 0, t8 * t78 * t340 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t938);
  tv3rhosigma20 = 0.2e1 * rho[0] * t943 + 0.2e1 * t344;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t958 = t354 * t207;
  t959 = t183 * t958;
  t961 = t460 * t97 * t462;
  t962 = t959 * t961;
  t964 = t103 * params->csk_a;
  t965 = t257 * t207;
  t966 = t964 * t965;
  t967 = t779 * t966;
  t969 = t215 * t192;
  t970 = t969 * t888;
  t971 = t959 * t970;
  t977 = t631 * t145;
  t978 = t523 * t977;
  t982 = t357 * t97;
  t983 = t511 * t982;
  t986 = t289 * t97;
  t987 = t507 * t986;
  t990 = t717 * t434;
  t991 = t95 * t990;
  t992 = t512 * t126;
  t993 = t992 * t97;
  t994 = t103 * t993;
  t996 = t183 * t990;
  t999 = t429 * t990;
  t1002 = t992 * t193 * t97;
  t1005 = t439 * t993;
  t1008 = -0.3e1 * t999 * t1002 - 0.2e1 * t999 * t1005 + t293 * t841 - t305 * t832 - t305 * t841 - t722 * t352 + t748 * t352 - t722 * t362 - 0.3e1 * t592 * t987 - 0.2e1 * t725 * t983 - t914 * t978 - t991 * t994 + 0.3e1 * t996 * t994 - t999 * t994 - t330 - t850 - 0.3e1 * t962 + 0.3e1 * t967 - 0.3e1 * t971;
  t1009 = t183 * t646;
  t1010 = t301 * t207;
  t1011 = t193 * t1010;
  t1012 = t1009 * t1011;
  t1014 = t591 * t434;
  t1015 = t429 * t1014;
  t1016 = t145 * params->csk_a;
  t1017 = t1016 * t97;
  t1018 = t439 * t1017;
  t1023 = t95 * t958;
  t1024 = t1023 * t854;
  t1026 = t103 * t126;
  t1027 = t877 * t1026;
  t1032 = t193 * t1017;
  t1037 = t298 * t126;
  t1039 = t95 * t1037 * t209;
  t1040 = t145 * t254;
  t1042 = t95 * t1040 * t209;
  t1045 = 0.3e1 * t996 * t1002 + 0.3e1 * t1015 * t1018 + 0.3e1 * t1015 * t1032 - 0.3e1 * t991 * t1027 + 0.3e1 * t996 * t1027 + t263 * t791 + t599 * t290 + t293 * t931 + t748 * t358 + 0.3e1 * t1012 + 0.3e1 * t1024 - t1039 - t1042 - t356 + t902 - t903 + t904 + t920 - t923;
  t1047 = my_piecewise5(t57, 0, t60, 0, t1008 + t1045);
  t1049 = -0.5e1 / 0.72e2 * t45 * t116 * t129 + t45 * t137 * t269 / 0.24e2 + t239 * t148 + t123 * t309 + t93 * t365 + t52 * t1047;
  t1054 = my_piecewise3(t3, 0, t8 * t78 * t367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1049);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1054 + 0.2e1 * t371;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1067 = t376 * t99;
  t1068 = t183 * t1067;
  t1069 = t1068 * t865;
  t1071 = t376 * t432;
  t1072 = t429 * t1071;
  t1076 = t198 * t199 * t298;
  t1079 = t183 * t1071;
  t1082 = t376 * t207;
  t1083 = t95 * t1082;
  t1084 = t1083 * t854;
  t1086 = t95 * t1071;
  t1093 = t216 * t298;
  t1105 = -0.2e1 * t305 * t215 * t1093 - 0.2e1 * t1072 * t837 - 0.3e1 * t1072 * t845 + 0.3e1 * t1072 * t869 + 0.3e1 * t1072 * t892 - t1072 * t896 + 0.2e1 * t293 * t1076 - 0.2e1 * t305 * t1076 + 0.3e1 * t1079 * t845 + 0.3e1 * t1079 * t896 - 0.3e1 * t1086 * t828 - t1086 * t896 + 0.3e1 * t1069 + 0.3e1 * t1084 - t330 - t383;
  t1109 = t183 * t1082 * t188;
  t1110 = t1109 * t878;
  t1113 = t95 * t1067 * t188;
  t1114 = t1113 * t884;
  t1116 = t1109 * t889;
  t1118 = t145 * t207;
  t1119 = t95 * t1118;
  t1120 = t102 * t298;
  t1122 = t1119 * t926 * t1120;
  t1123 = 0.2e1 * t1122;
  t1129 = t438 * t376;
  t1130 = t523 * t1129;
  t1136 = 0.2e1 * t293 * t198 * t1120 + 0.3e1 * t1079 * t828 - 0.3e1 * t1079 * t908 - 0.2e1 * t1086 * t905 - t914 * t1130 + 0.2e1 * t305 * t791 - 0.3e1 * t1110 + 0.3e1 * t1114 - 0.3e1 * t1116 - t1123 - t850 + t902 - t903 + t904 + t920 - t923;
  t1138 = my_piecewise5(t57, 0, t60, 0, t1105 + t1136);
  t1140 = -0.5e1 / 0.36e2 * t45 * t116 * t148 + t45 * t137 * t309 / 0.12e2 + t93 * t389 + t52 * t1138;
  t1145 = my_piecewise3(t3, 0, t8 * t78 * t391 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1140);
  tv3rholapl20 = 0.2e1 * rho[0] * t1145 + 0.2e1 * t395;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1150 = t321 * t126;
  t1159 = t849 * t352;
  t1160 = 0.3e1 * t1159;
  t1161 = t1150 * t207;
  t1162 = t183 * t1161;
  t1163 = t1162 * t463;
  t1164 = 0.3e1 * t1163;
  t1165 = t1150 * t99;
  t1167 = t95 * t1165 * t480;
  t1168 = 0.3e1 * t1167;
  t1169 = t1162 * t474;
  t1170 = 0.3e1 * t1169;
  t1171 = t199 * t328;
  t1172 = t198 * t1171;
  t1173 = t249 * t1172;
  t1174 = 0.3e1 * t1173;
  t1175 = t849 * t362;
  t1176 = 0.3e1 * t1175;
  t1178 = t183 * t1165 * t491;
  t1179 = 0.3e1 * t1178;
  t1180 = t901 * t358;
  t1181 = 0.3e1 * t1180;
  t1182 = -0.3e1 * t183 * t1150 * t447 - t429 * t1150 * t440 - 0.2e1 * t95 * t1150 * t451 - t1160 - t1164 + t1168 - t1170 + t1174 - t1176 + t1179 + t1181 - t330 - t332;
  t1184 = t95 * t1161 * t500;
  t1185 = 0.3e1 * t1184;
  t1186 = t1150 * t432;
  t1187 = t429 * t1186;
  t1192 = t263 * t919;
  t1193 = 0.3e1 * t1192;
  t1196 = t183 * t1186;
  t1199 = t328 * t126;
  t1201 = t95 * t1199 * t209;
  t1202 = 0.3e1 * t1201;
  t1205 = t95 * t1186;
  t1214 = 0.3e1 * t1187 * t508 - t1187 * t514 + 0.3e1 * t1187 * t525 - 0.3e1 * t1187 * t529 - 0.2e1 * t1187 * t539 + 0.3e1 * t1196 * t486 + 0.3e1 * t1196 * t514 + 0.3e1 * t1196 * t529 - 0.3e1 * t1205 * t486 - t1205 * t514 + t1185 + t1193 - t1202;
  t1216 = my_piecewise5(t57, 0, t60, 0, t1182 + t1214);
  t1218 = t52 * t1216 + 0.3e1 * t123 * t338;
  t1222 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1218);
  tv3sigma30 = 0.2e1 * rho[0] * t1222;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1230 = t321 * t67 * t102;
  t1231 = t485 * t1230;
  t1237 = t511 * t513 * t321;
  t1244 = t862 * t771;
  t1245 = 0.3e1 * t1244;
  t1246 = t145 * t321;
  t1247 = t95 * t1246;
  t1248 = t1247 * t588;
  t1249 = 0.3e1 * t1248;
  t1250 = 0.2e1 * t1159;
  t1251 = t538 * t321;
  t1252 = t523 * t1251;
  t1255 = t528 * t321;
  t1256 = t507 * t1255;
  t1259 = t305 * t1172;
  t1262 = t216 * t328;
  t1263 = t215 * t1262;
  t1264 = t305 * t1263;
  t1267 = 0.3e1 * t718 * t1231 - 0.3e1 * t725 * t1231 + 0.3e1 * t718 * t1237 - t725 * t1237 - t728 * t1237 - 0.2e1 * t728 * t1252 + 0.3e1 * t718 * t1256 - 0.3e1 * t728 * t1256 + 0.3e1 * t835 * t731 + 0.3e1 * t835 * t745 + t1245 + t1249 - t1250 - t1259 - t1264 - t330;
  t1268 = t293 * t1172;
  t1269 = 0.2e1 * t1173;
  t1270 = 0.2e1 * t1175;
  t1271 = t1246 * t207;
  t1272 = t183 * t1271;
  t1273 = t1272 * t474;
  t1274 = 0.3e1 * t1273;
  t1275 = t1272 * t463;
  t1276 = 0.3e1 * t1275;
  t1277 = params->csk_a * t321;
  t1278 = t1277 * t207;
  t1279 = t103 * t1278;
  t1280 = t779 * t1279;
  t1281 = 0.3e1 * t1280;
  t1282 = 0.2e1 * t1180;
  t1283 = 0.2e1 * t1192;
  t1284 = 0.2e1 * t1201;
  t1285 = t849 * t290;
  t1287 = t145 * t328;
  t1289 = t95 * t1287 * t209;
  t1290 = t102 * t328;
  t1291 = t198 * t1290;
  t1292 = t293 * t1291;
  t1295 = t102 * t321;
  t1296 = t511 * t1295;
  t1299 = -0.2e1 * t725 * t1296 - 0.3e1 * t825 * t784 - t835 * t794 + t1268 + t1269 - t1270 - t1274 - t1276 + t1281 + t1282 + t1283 - t1284 + t1285 - t1289 + t1292 - t356;
  t1301 = my_piecewise5(t57, 0, t60, 0, t1267 + t1299);
  t1303 = t45 * t137 * t338 / 0.24e2 + 0.2e1 * t123 * t365 + t52 * t1301;
  t1307 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1303);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1307;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1315 = t513 * t126;
  t1316 = t511 * t1315;
  t1321 = t485 * t1026;
  t1326 = t538 * t126;
  t1332 = t528 * t126;
  t1333 = t507 * t1332;
  t1337 = t198 * t357 * t99;
  t1338 = t1083 * t1337;
  t1339 = 0.3e1 * t1338;
  t1342 = t1068 * t582;
  t1343 = 0.3e1 * t1342;
  t1344 = 0.2e1 * t1259;
  t1345 = -0.2e1 * t1072 * t523 * t1326 - t1072 * t1316 - 0.3e1 * t1072 * t1333 + 0.3e1 * t1072 * t607 + 0.3e1 * t1072 * t633 + 0.3e1 * t1079 * t1316 + 0.3e1 * t1079 * t1321 + 0.3e1 * t1079 * t1333 - t1086 * t1316 - 0.3e1 * t1086 * t1321 - t1159 + t1339 + t1343 - t1344 - t330 - t383;
  t1346 = 0.2e1 * t1264;
  t1347 = 0.2e1 * t1268;
  t1348 = params->csk_a * t126;
  t1349 = t1348 * t207;
  t1350 = t103 * t1349;
  t1351 = t1113 * t1350;
  t1352 = 0.3e1 * t1351;
  t1353 = t1348 * t99;
  t1355 = t1109 * t193 * t1353;
  t1356 = 0.3e1 * t1355;
  t1358 = t1109 * t1348 * t462;
  t1359 = 0.3e1 * t1358;
  t1360 = 0.2e1 * t1285;
  t1361 = 0.2e1 * t1289;
  t1362 = 0.2e1 * t1292;
  t1369 = -0.2e1 * t1086 * t511 * t357 - 0.3e1 * t1079 * t662 - t615 * t1130 + t1173 - t1175 + t1180 + t1192 - t1201 - t1346 + t1347 + t1352 - t1356 - t1359 + t1360 - t1361 + t1362;
  t1371 = my_piecewise5(t57, 0, t60, 0, t1345 + t1369);
  t1373 = t45 * t137 * t365 / 0.12e2 + t123 * t389 + t52 * t1371;
  t1377 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1373);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1377;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1382 = t376 * t145;
  t1391 = t1382 * t207;
  t1392 = t183 * t1391;
  t1393 = t1392 * t474;
  t1394 = 0.3e1 * t1393;
  t1395 = t1392 * t463;
  t1396 = 0.3e1 * t1395;
  t1397 = t1382 * t99;
  t1399 = t95 * t1397 * t480;
  t1400 = 0.3e1 * t1399;
  t1401 = 0.3e1 * t1259;
  t1402 = 0.3e1 * t1264;
  t1403 = 0.3e1 * t1268;
  t1404 = t1382 * t432;
  t1405 = t95 * t1404;
  t1408 = t95 * t1391;
  t1409 = t1408 * t500;
  t1410 = 0.3e1 * t1409;
  t1411 = -0.3e1 * t183 * t1382 * t447 - t429 * t1382 * t440 - 0.2e1 * t95 * t1382 * t451 - 0.3e1 * t1405 * t486 - t1394 - t1396 + t1400 - t1401 - t1402 + t1403 + t1410 - t330 - t383;
  t1413 = t183 * t1397 * t491;
  t1414 = 0.3e1 * t1413;
  t1415 = t429 * t1404;
  t1422 = t183 * t1404;
  t1433 = 0.3e1 * t1285;
  t1434 = 0.3e1 * t1289;
  t1435 = 0.3e1 * t1292;
  t1436 = -t1405 * t514 + 0.3e1 * t1415 * t508 - t1415 * t514 + 0.3e1 * t1415 * t525 - 0.3e1 * t1415 * t529 - 0.2e1 * t1415 * t539 + 0.3e1 * t1422 * t486 + 0.3e1 * t1422 * t514 + 0.3e1 * t1422 * t529 + t1414 + t1433 - t1434 + t1435;
  t1438 = my_piecewise5(t57, 0, t60, 0, t1411 + t1436);
  t1440 = t45 * t137 * t389 / 0.8e1 + t52 * t1438;
  t1444 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1440);
  tv3lapl30 = 0.2e1 * rho[0] * t1444;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1465 = t33 / t23 / t166 / t34;
  t1467 = 0.1309e5 / 0.729e3 * t30 * t1465;
  t1473 = 0.2618e4 / 0.243e3 * t41 * t1465 + 0.77e3 / 0.243e3 * t45 * t46 * t412 - t1467;
  t1484 = t203 * t203;
  t1485 = t95 * t1484;
  t1493 = t181 * t181;
  t1495 = t69 / t1493;
  t1496 = t184 * t184;
  t1498 = t186 * t186;
  t1499 = t187 * t187;
  t1500 = 0.1e1 / t1499;
  t1501 = t1498 * t1500;
  t1502 = t190 * t190;
  t1503 = t191 * t191;
  t1504 = 0.1e1 / t1503;
  t1505 = t1502 * t1504;
  t1506 = t1501 * t1505;
  t1508 = my_piecewise3(t60, 0, t1473);
  t1509 = my_piecewise3(t62, t1508, 0);
  t1512 = t95 * t1496;
  t1513 = t1501 * t103;
  t1517 = t207 * t207;
  t1518 = t1517 * t188;
  t1519 = t1518 * t103;
  t1523 = t1501 * t439;
  t1526 = t183 * t1496;
  t1527 = t1518 * t193;
  t1530 = t1501 * t193;
  t1533 = t1496 * t207;
  t1534 = t95 * t1533;
  t1535 = t102 * t186;
  t1537 = t511 * t1535 * params->csk_a;
  t1540 = t443 * t186;
  t1541 = t95 * t1540;
  t1544 = t203 * t432;
  t1545 = t183 * t1544;
  t1548 = t183 * t1533;
  t1551 = t95 * t605;
  t1552 = t511 * t467;
  t1556 = t507 * t528 * t186;
  t1559 = t1496 * t186;
  t1562 = t511 * t513 * t207;
  t1565 = 0.6e1 * t429 * t1496 * t1523 - 0.6e1 * t95 * t1559 * t1562 + 0.3e1 * t1512 * t1519 + 0.3e1 * t1526 * t1527 + 0.11e2 * t1526 * t1530 - 0.18e2 * t1534 * t1537 + 0.18e2 * t1548 * t1537 + 0.4e1 * t1541 * t251 + 0.18e2 * t1545 * t595 + 0.18e2 * t1548 * t1556 - 0.18e2 * t1551 * t1552;
  t1569 = t429 * t1544;
  t1573 = t186 * t67 * t102;
  t1574 = t618 * t1573;
  t1577 = t429 * t1533;
  t1581 = t511 * t513 * t203;
  t1585 = t523 * t538 * t186;
  t1589 = t507 * t528 * t203;
  t1592 = t438 * t203;
  t1594 = t523 * t1592 * params->csk_a;
  t1599 = t183 * t1540;
  t1604 = t215 * t490 * t203;
  t1607 = t429 * t1559;
  t1608 = t438 * t207;
  t1610 = t523 * t1608 * params->csk_a;
  t1615 = t507 * t624;
  t1621 = t507 * t490 * params->csk_a;
  t1626 = t203 * t99;
  t1629 = t198 * t665 * t207;
  t1633 = t183 * t1626 * t188;
  t1638 = params->csk_a * t203;
  t1640 = t103 * t1638 * t207;
  t1643 = t193 * t649;
  t1646 = 0.18e2 * t95 * t579 * t188 * t1640 + 0.18e2 * t95 * t1626 * t1629 - 0.18e2 * t1577 * t1556 - 0.18e2 * t1569 * t621 - 0.4e1 * t1599 * t251 + 0.18e2 * t580 * t1604 + 0.18e2 * t1607 * t1610 + 0.18e2 * t1607 * t1621 + 0.18e2 * t606 * t1615 - 0.18e2 * t1633 * t1643 - 0.18e2 * t1633 * t650;
  t1649 = t1496 * t1498;
  t1650 = t1495 * t1649;
  t1651 = t512 * params->csk_a;
  t1652 = t1500 * t1651;
  t1653 = t1652 * t439;
  t1656 = t1500 * t1502;
  t1657 = t1504 * t1651;
  t1658 = t1656 * t1657;
  t1661 = t183 * t1649;
  t1662 = t1500 * t190;
  t1663 = t192 * t1651;
  t1664 = t1662 * t1663;
  t1667 = t429 * t1649;
  t1672 = t1504 * t512;
  t1673 = t1656 * t1672;
  t1678 = t1662 * t528;
  t1681 = t1500 * t436;
  t1682 = t1681 * t538;
  t1685 = t1504 * params->csk_a;
  t1686 = t1656 * t1685;
  t1698 = t507 * t519;
  t1701 = t1662 * t216;
  t1707 = t1496 * t1517;
  t1708 = t183 * t1707;
  t1715 = t507 * t490;
  t1721 = t511 * t1535;
  t1726 = 0.4e1 * t244 * t215 * t192 * t443 - 0.4e1 * t95 * t443 * t97 * t209 - 0.12e2 * t95 * t1544 * t666 - 0.18e2 * t183 * t1559 * t1715 - 0.6e1 * t606 * t523 * t1592 + 0.3e1 * t95 * t1707 * t200 - 0.12e2 * t1534 * t1721 - 0.18e2 * t1667 * t1701 - 0.18e2 * t661 * t1698 - 0.3e1 * t1708 * t200 - 0.3e1 * t1708 * t217;
  t1728 = t1500 * params->csk_a;
  t1729 = t1728 * t103;
  t1732 = t1484 * t186;
  t1733 = t183 * t1732;
  t1736 = t523 * t1608;
  t1746 = t95 * t1649;
  t1747 = t1500 * t67;
  t1748 = t102 * t1651;
  t1749 = t1747 * t1748;
  t1758 = 0.3e1 * t95 * t1732 * t200 + 0.4e1 * t1541 * t261 - 0.6e1 * t1607 * t1736 - t1650 * t1749 - 0.11e2 * t1661 * t1729 - 0.7e1 * t1661 * t1749 - 0.6e1 * t1667 * t1682 + 0.6e1 * t1667 * t1749 - 0.3e1 * t1733 * t200 - 0.3e1 * t1733 * t217 + t1746 * t1749;
  t1759 = t1500 * t512;
  t1760 = t1759 * t103;
  t1765 = t1681 * t524;
  t1781 = 0.7e1 * t1650 * t1678 - 0.6e1 * t1650 * t1765 + 0.7e1 * t1661 * t1701 - 0.18e2 * t1661 * t1760 + 0.6e1 * t1667 * t1760 - 0.12e2 * t1667 * t1765 + 0.11e2 * t1746 * t1729 + 0.6e1 * t1746 * t1760 + 0.4e1 * t492 + 0.4e1 * t501 - 0.5e1 * t534;
  t1785 = my_piecewise5(t57, 0, t60, 0, -0.6e1 * t1577 * t1574 - 0.6e1 * t1551 * t1581 - 0.12e2 * t1577 * t1585 + 0.6e1 * t1512 * t1513 - 0.3e1 * t1485 * t209 + 0.3e1 * t1485 * t211 + 0.11e2 * t1650 * t1673 + 0.12e2 * t1667 * t1653 - 0.11e2 * t1661 * t1678 + 0.18e2 * t1650 * t1682 - 0.6e1 * t1650 * t1686 - 0.12e2 * t1650 * t1653 - 0.6e1 * t1650 * t1658 - 0.7e1 * t1661 * t1664 + 0.18e2 * t1667 * t1664 - 0.7e1 * t1650 * t1664 + 0.18e2 * t661 * t1589 + 0.18e2 * t606 * t1594 - 0.12e2 * t1569 * t628 - 0.4e1 * t1599 * t266 + 0.18e2 * t1545 * t611 - 0.6e1 * t1569 * t611 + 0.18e2 * t1548 * t1574 + 0.3e1 * t183 * t1484 * t194 + t1495 * t1496 * t1506 - t95 * t1509 * t104 + t1781 + t1758 + t1726 + t1646 + t1565 + 0.4e1 * t481 - 0.4e1 * t475 - 0.4e1 * t464 - t210);
  t1792 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 / t22 / t82 * t72 + 0.8e1 / 0.45e2 * t8 * t400 * t108 - t8 * t159 * t222 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t78 * t546 + 0.3e1 / 0.2e2 * t8 * t24 * (0.4e1 * t421 * t106 + t1473 * t70 + 0.6e1 * t177 * t220 + t52 * t1785 + 0.4e1 * t93 * t544 + t1467));
  tv4rho40 = 0.2e1 * rho[0] * t1792 + 0.8e1 * t551;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1807 = 0.77e3 / 0.243e3 * t30 * t32 * t412;
  t1811 = -0.154e3 / 0.81e2 * t40 * t119 * t412 + t1807;
  t1827 = t260 * t207;
  t1828 = t1638 * t67 * t1827;
  t1831 = t193 * params->csk_a;
  t1833 = t1831 * t532 * t207;
  t1838 = t430 * t186;
  t1840 = t429 * t1838 * t434;
  t1841 = t193 * t1349;
  t1844 = t126 * t430;
  t1849 = t183 * t1014;
  t1851 = t512 * t203 * t97;
  t1852 = t193 * t1851;
  t1855 = t95 * t1014;
  t1857 = t103 * t877 * t203;
  t1861 = t429 * t913 * t434;
  t1862 = t1348 * t203;
  t1866 = t248 * t434;
  t1867 = t95 * t1866;
  t1868 = t512 * t430;
  t1869 = t1868 * t207;
  t1870 = t103 * t1869;
  t1873 = t183 * t1866;
  t1876 = 0.18e2 * t183 * t1844 * t207 * t1537 + 0.9e1 * t1861 * t193 * t1862 - 0.9e1 * t1009 * t1828 - 0.9e1 * t1009 * t1833 + 0.9e1 * t647 * t1828 + 0.18e2 * t1840 * t1841 + 0.9e1 * t1849 * t1852 - 0.9e1 * t1855 * t1857 - 0.6e1 * t1867 * t1870 + 0.18e2 * t1873 * t1870 + 0.4e1 * t583 + 0.4e1 * t589 + 0.4e1 * t651;
  t1879 = t103 * params->csk_a * t430 * t207;
  t1882 = t254 * t99;
  t1883 = t1882 * t188;
  t1884 = t183 * t1883;
  t1887 = t429 * t1866;
  t1893 = t1868 * t193 * t207;
  t1896 = t439 * t1869;
  t1904 = my_piecewise3(t60, 0, t1811);
  t1905 = my_piecewise3(t62, t1904, 0);
  t1908 = t126 * t1498;
  t1909 = t95 * t1908;
  t1911 = t1747 * t199 * t430;
  t1914 = t430 * t1498;
  t1915 = t429 * t1914;
  t1916 = t1662 * t361;
  t1920 = t1747 * t513 * t430;
  t1923 = t183 * t1908;
  t1927 = t1747 * t1748 * t430;
  t1929 = -t95 * t1905 * t104 + 0.18e2 * t1840 * t439 * t1349 - 0.9e1 * t1884 * t1643 + 0.9e1 * t1849 * t1857 - 0.18e2 * t1867 * t1879 - 0.6e1 * t1887 * t1870 - 0.9e1 * t1884 * t650 - 0.18e2 * t1887 * t1893 - 0.12e2 * t1887 * t1896 + 0.11e2 * t1909 * t1911 + 0.6e1 * t1909 * t1920 + t1909 * t1927 - 0.18e2 * t1915 * t1916 - 0.18e2 * t1923 * t1920;
  t1933 = t429 * t1908;
  t1936 = t1495 * t1908;
  t1938 = t438 * t1651;
  t1940 = t1681 * t1938 * t430;
  t1943 = t254 * t432;
  t1944 = t183 * t1943;
  t1947 = t429 * t1943;
  t1955 = t1495 * t1914;
  t1956 = t1662 * t1332;
  t1959 = t576 * t186;
  t1960 = t95 * t1959;
  t1963 = t183 * t1844;
  t1964 = t1518 * t964;
  t1967 = t183 * t1838;
  t1971 = t95 * t1844;
  t1973 = t207 * t434 * t1573;
  t1976 = t1518 * t1831;
  t1979 = 0.9e1 * t95 * t1882 * t1629 - 0.18e2 * t1967 * t507 * t581 - 0.11e2 * t1923 * t1911 - 0.7e1 * t1923 * t1927 + 0.6e1 * t1933 * t1927 - t1936 * t1927 + 0.12e2 * t1933 * t1940 + 0.9e1 * t1944 * t611 - 0.3e1 * t1947 * t611 + 0.7e1 * t1955 * t1956 + 0.3e1 * t1960 * t251 - 0.3e1 * t1963 * t1964 - 0.3e1 * t1963 * t1976 - 0.12e2 * t1971 * t1973;
  t1983 = t1681 * t538 * t430;
  t1986 = t1681 * t632;
  t1995 = t1652 * t430 * t190 * t192;
  t2000 = t460 * t443 * t67 * t102;
  t2004 = t183 * t1959;
  t2009 = t507 * t831;
  t2014 = t95 * t1943;
  t2017 = t183 * t1914;
  t2020 = -0.12e2 * t1915 * t1986 + 0.7e1 * t2017 * t1916 + 0.6e1 * t1933 * t1920 - 0.6e1 * t1933 * t1983 - 0.12e2 * t1936 * t1940 - 0.7e1 * t1936 * t1995 + 0.9e1 * t1944 * t595 - 0.9e1 * t1947 * t621 + 0.3e1 * t1971 * t1964 - t263 * t2000 - 0.3e1 * t2004 * t251 + 0.9e1 * t606 * t2009 - 0.9e1 * t2014 * t595 - 0.3e1 * t599 * t468;
  t2024 = t1662 * t528 * t430;
  t2031 = t1681 * t1326;
  t2040 = t429 * t1838;
  t2042 = t523 * t631 * t207;
  t2045 = t183 * t913;
  t2051 = t511 * t260 * t203;
  t2056 = t215 * t670 * t207;
  t2062 = t215 * t216 * t443;
  t2064 = -0.3e1 * t914 * t523 * t1592 * t126 - 0.9e1 * t2045 * t507 * t245 * t203 - 0.11e2 * t1923 * t2024 - 0.6e1 * t1955 * t1986 + 0.18e2 * t1955 * t2031 + t249 * t2000 - 0.3e1 * t2004 * t266 - 0.3e1 * t2014 * t611 - 0.6e1 * t2040 * t2042 - 0.6e1 * t602 * t2051 + 0.9e1 * t580 * t2056 - t263 * t2062 - 0.3e1 * t599 * t625;
  t2067 = t1504 * t126;
  t2073 = t1656 * t1657 * t430;
  t2076 = t438 * t254;
  t2078 = t523 * t2076 * params->csk_a;
  t2082 = t1656 * t2067 * params->csk_a;
  t2095 = t198 * t499 * t203;
  t2098 = t97 * t99;
  t2100 = t183 * t2098 * t188;
  t2101 = t924 * t203;
  t2105 = t439 * t1851;
  t2113 = 0.11e2 * t1955 * t1656 * t2067 * t512 + 0.9e1 * t1861 * t439 * t1862 + 0.9e1 * t2100 * t193 * t2101 + 0.9e1 * t95 * t965 * t2095 - 0.9e1 * t1015 * t1852 - 0.6e1 * t1015 * t2105 - 0.7e1 * t1923 * t1995 + 0.18e2 * t1933 * t1995 - 0.6e1 * t1936 * t2073 + 0.9e1 * t1944 * t621 - 0.6e1 * t1947 * t628 - 0.6e1 * t1955 * t2082 + 0.9e1 * t606 * t2078 + 0.3e1 * t636 * t468;
  t2115 = t103 * t1851;
  t2132 = t198 * t102 * t443;
  t2137 = t523 * t2076;
  t2146 = -0.3e1 * t95 * t254 * t203 * t209 + t1955 * t1656 * t2067 + 0.9e1 * t95 * t1883 * t650 - 0.3e1 * t1015 * t2115 + t1599 * t246 + 0.9e1 * t1849 * t2115 - 0.3e1 * t1855 * t2115 + 0.18e2 * t1873 * t1893 + 0.3e1 * t1960 * t261 + t249 * t2132 - 0.3e1 * t606 * t2137 + 0.3e1 * t455 * t671 - 0.4e1 * t655 - 0.4e1 * t657;
  t2151 = t215 * t192 * t576;
  t2160 = t507 * t670;
  t2163 = t1681 * t631;
  t2167 = t1747 * t102 * t430;
  t2171 = t183 * t430 * t1517;
  t2183 = -t95 * t126 * t443 * t209 - 0.3e1 * t95 * t576 * t97 * t209 + 0.11e2 * t2017 * t1662 * t245 + 0.3e1 * t1971 * t1519 + 0.6e1 * t1909 * t2167 + 0.6e1 * t1915 * t2163 - 0.6e1 * t2014 * t666 + 0.3e1 * t244 * t2151 - 0.9e1 * t661 * t2160 + 0.3e1 * t2171 * t246 + 0.3e1 * t636 * t684 - t259 - 0.3e1 * t678 - 0.2e1 * t682;
  t2187 = my_piecewise5(t57, 0, t60, 0, t1876 + t1929 + t1979 + t2020 + t2064 + t2113 + t2146 + t2183);
  t2194 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t131 - t8 * t159 * t271 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t690 + 0.3e1 / 0.2e2 * t8 * t24 * (0.3e1 * t567 * t106 + t123 * t544 + t421 * t129 + 0.3e1 * t177 * t269 + t1811 * t70 + t52 * t2187 + 0.3e1 * t239 * t220 + 0.3e1 * t93 * t688 - t1807));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2194 + 0.6e1 * t695;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2224 = t183 * t778;
  t2231 = t292 * t434;
  t2232 = t183 * t2231;
  t2235 = t298 * t99;
  t2236 = t2235 * t188;
  t2237 = t183 * t2236;
  t2248 = t1016 * t203;
  t2249 = t193 * t2248;
  t2256 = t95 * t2231;
  t2259 = -0.9e1 * t2224 * t1828 + 0.9e1 * t779 * t1828 - 0.9e1 * t2224 * t1833 + 0.9e1 * t996 * t1852 - 0.9e1 * t991 * t1857 + 0.9e1 * t996 * t1857 + 0.9e1 * t1861 * t2249 + 0.18e2 * t2232 * t1870 - 0.6e1 * t2256 * t1870 + 0.18e2 * t2232 * t1879 + 0.18e2 * t2232 * t1893 - 0.3e1 * t999 * t2115 - 0.9e1 * t2237 * t650;
  t2260 = t429 * t2231;
  t2263 = t1016 * t207;
  t2264 = t439 * t2263;
  t2271 = t193 * t2263;
  t2278 = t439 * t2248;
  t2287 = t95 * t2236;
  t2291 = t193 * t1118 * t203;
  t2296 = -0.9e1 * t2237 * t1643 + 0.18e2 * t1840 * t2264 + 0.18e2 * t1840 * t2271 - 0.9e1 * t999 * t1852 + 0.9e1 * t1861 * t2278 - 0.6e1 * t2260 * t1870 - 0.18e2 * t2256 * t1879 - 0.18e2 * t2260 * t1893 - 0.12e2 * t2260 * t1896 + 0.9e1 * t2100 * t2291 - 0.6e1 * t999 * t2105 - 0.3e1 * t991 * t2115 + 0.9e1 * t996 * t2115 + 0.9e1 * t2287 * t650;
  t2301 = t145 * t1498;
  t2302 = t429 * t2301;
  t2305 = t145 * t430;
  t2306 = t95 * t2305;
  t2309 = t183 * t2305;
  t2316 = t1681 * t744;
  t2319 = t507 * t770;
  t2322 = t95 * t2301;
  t2325 = t183 * t2301;
  t2332 = t298 * t432;
  t2333 = t183 * t2332;
  t2336 = t429 * t2332;
  t2339 = 0.9e1 * t95 * t1010 * t2095 + 0.11e2 * t2322 * t1911 - 0.11e2 * t2325 * t1911 - 0.12e2 * t1915 * t2316 + 0.6e1 * t2302 * t1920 + 0.12e2 * t2302 * t1940 + 0.3e1 * t2306 * t1964 - 0.3e1 * t2309 * t1964 - 0.18e2 * t1967 * t2319 - 0.12e2 * t2306 * t1973 - 0.3e1 * t2309 * t1976 - 0.6e1 * t2302 * t1983 + 0.9e1 * t2333 * t611 - 0.3e1 * t2336 * t611;
  t2344 = t1495 * t2301;
  t2353 = my_piecewise3(t60, 0, -0.55e2 / 0.81e2 * t44 * t564);
  t2354 = my_piecewise3(t62, t2353, 0);
  t2357 = t95 * t2332;
  t2360 = t1662 * t730;
  t2365 = t765 * t186;
  t2366 = t183 * t2365;
  t2370 = t1662 * t289 * t512;
  t2377 = -t95 * t2354 * t104 + 0.6e1 * t2322 * t1920 - 0.18e2 * t2325 * t1920 + 0.6e1 * t2302 * t1927 + t2322 * t1927 - 0.7e1 * t2325 * t1927 - t2344 * t1927 - 0.6e1 * t1955 * t2316 + 0.7e1 * t1955 * t2370 - 0.7e1 * t2344 * t1995 + 0.7e1 * t2017 * t2360 - 0.11e2 * t2325 * t2024 - 0.9e1 * t2357 * t595 - 0.3e1 * t2366 * t266;
  t2381 = t1681 * t743 * t512;
  t2399 = t215 * t790 * t207;
  t2403 = t523 * t743 * t207;
  t2407 = t507 * t289 * t203;
  t2413 = t1504 * t145;
  t2415 = t1656 * t2413 * t512;
  t2418 = -0.3e1 * t914 * t523 * t1592 * t145 - 0.18e2 * t1915 * t2360 + 0.18e2 * t1955 * t2381 + 0.11e2 * t1955 * t2415 - 0.6e1 * t2040 * t2403 - 0.9e1 * t2045 * t2407 - 0.6e1 * t725 * t2051 - t305 * t2062 + 0.9e1 * t2333 * t595 - 0.6e1 * t2336 * t628 - 0.3e1 * t2366 * t251 + 0.9e1 * t580 * t2399 - 0.3e1 * t722 * t468;
  t2421 = t438 * t298;
  t2423 = t523 * t2421 * params->csk_a;
  t2427 = t1656 * t2413 * params->csk_a;
  t2446 = t507 * t1093;
  t2451 = -0.12e2 * t2344 * t1940 - 0.6e1 * t1955 * t2427 + 0.18e2 * t2302 * t1995 - 0.7e1 * t2325 * t1995 + t293 * t2000 - t305 * t2000 - 0.6e1 * t2344 * t2073 + 0.9e1 * t2333 * t621 - 0.9e1 * t2336 * t621 - 0.3e1 * t2357 * t611 + 0.9e1 * t606 * t2423 + 0.9e1 * t606 * t2446 + 0.3e1 * t748 * t468 - 0.3e1 * t722 * t625;
  t2456 = t95 * t2365;
  t2465 = t215 * t192 * t765;
  t2474 = t507 * t790;
  t2477 = t1681 * t743;
  t2485 = -t95 * t145 * t443 * t209 - 0.3e1 * t95 * t765 * t97 * t209 + 0.9e1 * t95 * t2235 * t1629 + 0.3e1 * t2306 * t1519 + 0.6e1 * t1915 * t2477 + 0.3e1 * t244 * t2465 + 0.3e1 * t2456 * t251 - 0.9e1 * t661 * t2474 + 0.3e1 * t748 * t684 - 0.4e1 * t757 - 0.4e1 * t760 + 0.4e1 * t772 + 0.4e1 * t775 + 0.4e1 * t780;
  t2492 = t1662 * t289;
  t2501 = t523 * t2421;
  t2504 = t1656 * t2413;
  t2512 = -0.3e1 * t95 * t298 * t203 * t209 + t1599 * t290 + t1955 * t2504 + 0.11e2 * t2017 * t2492 + t293 * t2132 + 0.6e1 * t2322 * t2167 + 0.3e1 * t2171 * t290 - 0.6e1 * t2357 * t666 + 0.3e1 * t2456 * t261 - 0.3e1 * t606 * t2501 + 0.3e1 * t455 * t791 - t303 - 0.3e1 * t798 - 0.2e1 * t802;
  t2516 = my_piecewise5(t57, 0, t60, 0, t2259 + t2296 + t2339 + t2377 + t2418 + t2451 + t2485 + t2512);
  t2523 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t150 - t8 * t159 * t311 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t808 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.55e2 / 0.81e2 * t45 * t561 * t70 + 0.5e1 / 0.9e1 * t45 * t233 * t106 - 0.5e1 / 0.24e2 * t45 * t116 * t220 + t45 * t137 * t544 / 0.24e2 + t421 * t148 + 0.3e1 * t177 * t309 + 0.3e1 * t93 * t806 + t52 * t2516));
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2523 + 0.6e1 * t813;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2542 = t676 * t207;
  t2543 = t964 * t2542;
  t2546 = t924 * t188;
  t2548 = t103 * t254;
  t2556 = t512 * t254 * t97;
  t2557 = t193 * t2556;
  t2560 = t328 * t99;
  t2561 = t2560 * t188;
  t2562 = t183 * t2561;
  t2564 = 0.3e1 * t2562 * t1643;
  t2565 = t324 * t434;
  t2566 = t183 * t2565;
  t2567 = t512 * t184;
  t2569 = t2567 * t103 * t207;
  t2572 = t429 * t2565;
  t2575 = t95 * t2561;
  t2577 = 0.3e1 * t2575 * t650;
  t2579 = 0.3e1 * t2562 * t650;
  t2585 = t851 * t434;
  t2588 = t103 * t196 * params->csk_a;
  t2593 = t2567 * t207;
  t2597 = -0.12e2 * t183 * t2546 * t888 * t2548 - 0.12e2 * t1009 * t1831 * t2542 - 0.6e1 * t95 * t2565 * t2569 - 0.12e2 * t2572 * t439 * t2593 - 0.18e2 * t95 * t2585 * t2588 - 0.12e2 * t1015 * t2557 + 0.18e2 * t2572 * t1643 + 0.12e2 * t1849 * t2557 + 0.12e2 * t647 * t2543 + 0.18e2 * t2566 * t2569 - 0.6e1 * t2572 * t2569 - t2564 + t2577 - t2579 - t330 - t332;
  t2599 = params->csk_a * t254 * t97;
  t2600 = t103 * t2599;
  t2603 = t193 * t2593;
  t2609 = t103 * t2556;
  t2619 = t1638 * t99;
  t2620 = t193 * t2619;
  t2626 = t439 * t649;
  t2634 = t1638 * t462;
  t2639 = t186 * t190 * t192;
  t2640 = t2567 * t2639;
  t2649 = t439 * t2556;
  t2654 = -0.12e2 * t1855 * t2600 + 0.18e2 * t2566 * t2603 + 0.12e2 * t1015 * t193 * t2599 - 0.4e1 * t1855 * t2609 + 0.12e2 * t1849 * t2609 + 0.18e2 * t183 * t2585 * t2588 + 0.3e1 * t882 * t1640 - 0.3e1 * t876 * t2620 + 0.12e2 * t1009 * t193 * t2542 + 0.18e2 * t2572 * t2626 + 0.12e2 * t95 * t2546 * t103 * t2098 * t254 - 0.3e1 * t876 * t2634 - 0.18e2 * t429 * t2585 * t2640 + 0.12e2 * t1849 * t2600 + 0.12e2 * t1861 * t439 * t1348 * t254 - 0.8e1 * t1015 * t2649 - 0.4e1 * t1015 * t2609;
  t2656 = t321 * t184;
  t2660 = t321 * t1517;
  t2661 = t183 * t2660;
  t2662 = t216 * t184;
  t2663 = t215 * t2662;
  t2666 = t321 * t1498;
  t2667 = t429 * t2666;
  t2668 = t1681 * t627;
  t2672 = t511 * t665 * t186;
  t2675 = t183 * t2666;
  t2676 = t1759 * t594;
  t2681 = t328 * t432;
  t2682 = t95 * t2681;
  t2684 = 0.3e1 * t2682 * t595;
  t2685 = t183 * t2681;
  t2687 = 0.3e1 * t2685 * t595;
  t2688 = t460 * t594;
  t2691 = t1728 * t594;
  t2694 = t1662 * t2662;
  t2697 = t95 * t2666;
  t2701 = t1747 * t1748 * t184;
  t2707 = t1495 * t2666;
  t2709 = 0.3e1 * t95 * t2656 * t1964 - 0.3e1 * t2661 * t2663 - 0.3e1 * t2661 * t2688 - 0.6e1 * t2667 * t2668 + 0.6e1 * t2667 * t2676 - 0.18e2 * t2667 * t2694 + 0.6e1 * t2667 * t2701 - 0.12e2 * t852 * t2672 - 0.18e2 * t2675 * t2676 - 0.11e2 * t2675 * t2691 - 0.7e1 * t2675 * t2701 + 0.6e1 * t2697 * t2676 + t2697 * t2701 - t2707 * t2701 - t2684 + t2687;
  t2710 = t2682 * t611;
  t2712 = 0.3e1 * t2685 * t611;
  t2713 = t429 * t2681;
  t2714 = t2713 * t611;
  t2716 = t1681 * t1938 * t184;
  t2719 = t184 * t1498;
  t2720 = t1495 * t2719;
  t2722 = t1681 * t915 * params->csk_a;
  t2728 = t183 * t2719;
  t2729 = t1662 * t1255;
  t2733 = t1662 * t1663 * t184;
  t2743 = t1662 * t528 * t184;
  t2746 = t849 * t625;
  t2747 = t438 * t328;
  t2749 = t523 * t2747 * params->csk_a;
  t2751 = 0.3e1 * t606 * t2749;
  t2753 = 0.2e1 * t2713 * t628;
  t2756 = 0.3e1 * t825 * t1581 - t872 * t1581 + 0.3e1 * t852 * t2095 + 0.12e2 * t2667 * t2716 + 0.18e2 * t2707 * t2668 - 0.7e1 * t2675 * t2733 + 0.11e2 * t2697 * t2691 - 0.12e2 * t2707 * t2716 + 0.7e1 * t2707 * t2743 - 0.6e1 * t2720 * t2722 - 0.11e2 * t2728 * t2729 - t2710 + t2712 - t2714 - t2746 + t2751 - t2753;
  t2759 = t192 * t321;
  t2765 = t511 * t260 * t254;
  t2771 = t215 * t216 * t576;
  t2775 = t523 * t538 * t203;
  t2778 = t1504 * t321;
  t2784 = t1656 * t1657 * t184;
  t2788 = t198 * t199 * t576;
  t2798 = t901 * t468;
  t2800 = 0.3e1 * t2685 * t621;
  t2801 = t849 * t468;
  t2802 = t507 * t1262;
  t2804 = 0.3e1 * t606 * t2802;
  t2805 = 0.11e2 * t2720 * t1656 * t2778 * t512 - 0.18e2 * t213 * t507 * t2759 * t207 + 0.3e1 * t825 * t1552 - t835 * t1581 + 0.3e1 * t825 * t1589 + 0.2e1 * t249 * t2788 - 0.2e1 * t263 * t2771 + 0.18e2 * t2667 * t2733 - 0.7e1 * t2707 * t2733 - 0.6e1 * t2707 * t2784 - 0.8e1 * t602 * t2765 - 0.2e1 * t835 * t2775 + t2798 + t2800 - t2801 + t2804;
  t2807 = 0.3e1 * t2713 * t621;
  t2835 = t429 * t196;
  t2845 = t215 * t918 * t207;
  t2847 = 0.3e1 * t580 * t2845;
  t2848 = t95 * t2560;
  t2850 = 0.3e1 * t2848 * t1629;
  t2851 = t254 * t254;
  t2852 = t95 * t2851;
  t2857 = -t2807 + 0.3e1 * t835 * t1615 - 0.12e2 * t2667 * t1681 * t438 * t184 * params->csk_a + 0.3e1 * t835 * t1594 - 0.6e1 * t2720 * t1656 * t2778 * params->csk_a - 0.3e1 * t872 * t1552 - 0.4e1 * t914 * t523 * t631 * t254 + 0.7e1 * t2675 * t2694 - 0.2e1 * t263 * t2788 - 0.3e1 * t835 * t1589 + 0.3e1 * t862 * t1604 - 0.6e1 * t2835 * t523 * t915 * t207 - 0.12e2 * t592 * t507 * t863 * t254 + t2847 + t2850 - 0.2e1 * t2852 * t209 + 0.2e1 * t2852 * t211;
  t2862 = 0.2e1 * t850;
  t2868 = t2851 * t186;
  t2869 = t183 * t2868;
  t2876 = t198 * t665;
  t2879 = t1747 * t665;
  t2883 = 0.2e1 * t2682 * t666;
  t2884 = 0.2e1 * t902;
  t2885 = 0.2e1 * t903;
  t2893 = 0.3e1 * t183 * t2656 * t1527 + t2720 * t1656 * t2778 + 0.2e1 * t183 * t2851 * t194 + 0.2e1 * t95 * t2868 * t200 + 0.3e1 * t95 * t2660 * t2876 - 0.2e1 * t2869 * t200 - 0.2e1 * t2869 * t217 + 0.6e1 * t2697 * t2879 - t2862 - t2883 + t2884 - t2885 + 0.4e1 * t855 + 0.4e1 * t866 - 0.4e1 * t879 + 0.4e1 * t885 - 0.4e1 * t890;
  t2894 = t455 * t919;
  t2895 = t523 * t2747;
  t2896 = t606 * t2895;
  t2899 = t95 * t328 * t203 * t209;
  t2900 = t102 * t576;
  t2904 = t198 * t2900;
  t2907 = t901 * t684;
  t2908 = t507 * t918;
  t2910 = 0.3e1 * t661 * t2908;
  t2911 = t511 * t683;
  t2919 = t429 * t2719;
  t2926 = 0.2e1 * t904;
  t2927 = 0.2e1 * t920;
  t2928 = 0.3e1 * t923;
  t2930 = 0.11e2 * t2728 * t1662 * t2759 + 0.6e1 * t2919 * t1681 * t915 - 0.2e1 * t925 * t926 * t2900 - t1569 * t916 - 0.3e1 * t825 * t1698 + 0.2e1 * t263 * t2151 + 0.2e1 * t249 * t2904 - 0.2e1 * t872 * t2911 + t2894 - t2896 - t2899 + t2907 - t2910 + t2926 + t2927 - t2928 - 0.4e1 * t929;
  t2934 = my_piecewise5(t57, 0, t60, 0, t2597 + t2654 + t2709 + t2756 + t2805 + t2857 + t2893 + t2930);
  t2941 = my_piecewise3(t3, 0, -t8 * t159 * t340 / 0.3e2 + t8 * t78 * t938 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.2e1 * t123 * t688 + 0.2e1 * t567 * t129 + t177 * t338 + 0.4e1 * t239 * t269 + t52 * t2934 + 0.2e1 * t93 * t936));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2941 + 0.4e1 * t943;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2972 = t193 * t512;
  t2976 = t1037 * t207;
  t2977 = t183 * t2976;
  t2980 = t1040 * t207;
  t2981 = t183 * t2980;
  t2988 = t429 * t196 * t434;
  t2989 = t439 * t145;
  t2993 = t429 * t958;
  t2995 = t2567 * t186;
  t3007 = t193 * t145;
  t3011 = t618 * t184;
  t3026 = -t330 + 0.6e1 * t779 * t2543 + 0.3e1 * t779 * t964 * t2101 + 0.18e2 * t2232 * t2972 * t653 - 0.6e1 * t2977 * t970 - 0.6e1 * t2981 * t970 - 0.3e1 * t959 * t969 * t2619 + 0.18e2 * t2988 * t2989 * t1349 - 0.12e2 * t2993 * t523 * t438 * t2995 - 0.6e1 * t2977 * t961 - 0.6e1 * t2981 * t961 - 0.3e1 * t959 * t460 * t203 * t462 + 0.18e2 * t2988 * t3007 * t1349 - 0.18e2 * t2993 * t3011 * t2639 + 0.6e1 * t2287 * t966 + 0.18e2 * t959 * t485 * t184 * t1573 - 0.18e2 * t2256 * t964 * t653 - 0.4e1 * t962 + 0.4e1 * t967;
  t3028 = t2332 * t434;
  t3029 = t183 * t3028;
  t3034 = t2719 * t1500;
  t3035 = t429 * t3034;
  t3036 = t354 * params->csk_a;
  t3037 = t439 * t3036;
  t3041 = t1495 * t1908 * t1500;
  t3042 = t145 * t512;
  t3043 = t3042 * t184;
  t3047 = t2301 * t1500;
  t3048 = t95 * t3047;
  t3049 = t1651 * t126;
  t3050 = t3049 * t184;
  t3051 = t103 * t3050;
  t3053 = t183 * t3047;
  t3056 = t429 * t3047;
  t3059 = t1495 * t3047;
  t3061 = t439 * t3050;
  t3064 = t2567 * t1026;
  t3079 = t1638 * t1026;
  t3084 = t193 * t3036;
  t3087 = t95 * t3028;
  t3090 = -0.12e2 * t2256 * t103 * t653 + 0.7e1 * t3041 * t193 * t3043 - 0.6e1 * t2988 * t439 * t958 + 0.6e1 * t3029 * t1002 + 0.6e1 * t3029 * t1027 - 0.6e1 * t3087 * t1027 + 0.6e1 * t996 * t2557 + 0.6e1 * t996 * t2600 - 0.12e2 * t3035 * t3037 - 0.18e2 * t3035 * t3084 + t3048 * t3051 + 0.6e1 * t3048 * t3064 - 0.7e1 * t3053 * t3051 + 0.6e1 * t3056 * t3051 - t3059 * t3051 - 0.18e2 * t3053 * t3064 + 0.12e2 * t3056 * t3061 + 0.6e1 * t3056 * t3064 + 0.3e1 * t996 * t3079 - 0.4e1 * t971;
  t3099 = t992 * t184;
  t3107 = t103 * t1348 * t184;
  t3111 = t183 * t354 * t1517;
  t3122 = t429 * t3028;
  t3129 = t992 * t203 * t67 * t102;
  t3131 = t3049 * t620;
  t3145 = t298 * params->csk_a;
  t3146 = t3145 * t97;
  t3147 = t193 * t3146;
  t3152 = -0.6e1 * t991 * t2600 - 0.3e1 * t991 * t3079 + 0.7e1 * t183 * t3034 * t3084 - 0.6e1 * t3056 * t439 * t3099 - 0.18e2 * t1873 * t193 * t755 + 0.11e2 * t3048 * t3107 - 0.3e1 * t3111 * t2663 - 0.3e1 * t3111 * t2688 - 0.11e2 * t3053 * t3107 + 0.3e1 * t95 * t754 * t1517 * t352 - 0.2e1 * t3122 * t994 - 0.2e1 * t999 * t2609 - t999 * t3129 - 0.7e1 * t3059 * t3131 - 0.6e1 * t3122 * t1002 - 0.6e1 * t999 * t2557 - 0.11e2 * t3053 * t193 * t3099 + 0.6e1 * t429 * t1943 * t434 * t1032 + 0.6e1 * t1015 * t3147 + 0.3e1 * t1015 * t2249;
  t3153 = t1495 * t3034;
  t3174 = t992 * t203;
  t3175 = t193 * t3174;
  t3204 = -0.6e1 * t3153 * t3037 + 0.18e2 * t3041 * t439 * t3043 - 0.2e1 * t3087 * t994 - 0.2e1 * t991 * t2609 - t991 * t3129 - 0.7e1 * t3053 * t3131 + 0.6e1 * t3029 * t994 + 0.3e1 * t996 * t3129 + 0.6e1 * t996 * t2609 + 0.3e1 * t1015 * t2278 + 0.3e1 * t996 * t3175 + 0.6e1 * t95 * t2976 * t854 + 0.6e1 * t95 * t2980 * t854 + 0.3e1 * t1023 * t2095 - 0.12e2 * t3059 * t3061 - 0.2e1 * t999 * t439 * t3174 + 0.11e2 * t3153 * t1505 * t3042 * t126 - 0.6e1 * t3059 * t1505 * t3050 + 0.6e1 * t1884 * t1011 + 0.6e1 * t1009 * t193 * t796 * t207;
  t3211 = t3145 * t126;
  t3212 = t439 * t3211;
  t3217 = t1016 * t254;
  t3218 = t439 * t3217;
  t3233 = t1518 * t3007;
  t3248 = 0.3e1 * t1009 * t2291 - 0.3e1 * t999 * t3175 + 0.6e1 * t1861 * t3212 - 0.4e1 * t3122 * t1005 + 0.6e1 * t1861 * t3218 - 0.4e1 * t999 * t2649 - 0.6e1 * t3153 * t1505 * t3036 + 0.18e2 * t3056 * t3131 - t2564 + t2577 - t2579 + 0.6e1 * t2322 * t1747 * t357 * t184 + 0.3e1 * t183 * t585 * t3233 + 0.6e1 * t2919 * t1681 * t977 - 0.2e1 * t722 * t841 - t305 * t2788 - t2366 * t362 - 0.2e1 * t722 * t832 + 0.3e1 * t355 * t1518 * t594;
  t3255 = t289 * t126;
  t3261 = t790 * t97;
  t3270 = t523 * t2076 * t145;
  t3287 = -0.4e1 * t725 * t2765 - 0.2e1 * t725 * t511 * t357 * t203 + 0.11e2 * t2728 * t1662 * t3255 - 0.6e1 * t1944 * t987 - 0.6e1 * t592 * t507 * t3261 - 0.3e1 * t592 * t2407 - t305 * t2771 - t1569 * t978 - 0.2e1 * t914 * t3270 - 0.2e1 * t914 * t523 * t631 * t298 + t2720 * t1656 * t2067 * t145 + t2456 * t352 + 0.2e1 * t748 * t841 + t293 * t2788 - 0.4e1 * t2357 * t983 - t2366 * t352 - t2684 + t2687 - t2710 + t2712;
  t3291 = t3011 * t1573;
  t3296 = t103 * t512;
  t3300 = -0.6e1 * t2256 * t3296 * t653 - 0.6e1 * t2993 * t3291 + 0.18e2 * t959 * t3291 + 0.4e1 * t1012 + 0.4e1 * t1024 - t2714 - t2746 + t2751 - t2753 + t2798 + t2800 - t2801 + t2804 - t2807 + t2847 + t2850 - t2862 - t2883 + t2884 - t2885;
  t3321 = t2894 - t2896 - t2899 + t2907 - t2910 - t95 * t145 * t576 * t209 + t2456 * t358 + 0.2e1 * t748 * t931 + t293 * t2904 + t2004 * t290 + 0.2e1 * t599 * t791 + t263 * t2465 - t95 * t765 * t126 * t209 - 0.2e1 * t95 * t298 * t254 * t209 - t356 + t2926 + t2927 - t2928 - 0.2e1 * t1039 - 0.2e1 * t1042;
  t3325 = my_piecewise5(t57, 0, t60, 0, t3026 + t3090 + t3152 + t3204 + t3248 + t3287 + t3300 + t3321);
  t3332 = my_piecewise3(t3, 0, -t8 * t159 * t367 / 0.3e2 + t8 * t78 * t1049 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.27e2 * t45 * t233 * t129 - 0.5e1 / 0.36e2 * t45 * t116 * t269 + t45 * t137 * t688 / 0.24e2 + t567 * t148 + 0.2e1 * t239 * t309 + t123 * t806 + t177 * t365 + 0.2e1 * t93 * t1047 + t52 * t3325));
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3332 + 0.4e1 * t1054;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3354 = t379 * t434;
  t3355 = t95 * t3354;
  t3358 = t183 * t3354;
  t3361 = t429 * t3354;
  t3364 = t1082 * t434;
  t3365 = t95 * t3364;
  t3368 = t183 * t3364;
  t3371 = t103 * t3146;
  t3382 = t429 * t3364;
  t3391 = t1118 * t188;
  t3392 = t95 * t3391;
  t3397 = 0.12e2 * t3392 * t103 * t796 * t99 + 0.12e2 * t2100 * t193 * t1118 * t298 - 0.3e1 * t1109 * t2634 + 0.18e2 * t3361 * t1643 - 0.6e1 * t3355 * t2569 + 0.18e2 * t3358 * t2569 - 0.6e1 * t3361 * t2569 - 0.18e2 * t3365 * t2588 + 0.18e2 * t3368 * t2588 + 0.18e2 * t3358 * t2603 + 0.18e2 * t3361 * t2626 - 0.18e2 * t3382 * t2640 - 0.12e2 * t991 * t3371 + 0.12e2 * t996 * t3371 - t330 - t383;
  t3398 = t512 * t97;
  t3399 = t3398 * t298;
  t3400 = t103 * t3399;
  t3409 = t512 * t190;
  t3410 = t3409 * t3261;
  t3428 = t376 * t1498;
  t3429 = t183 * t3428;
  t3432 = t429 * t3428;
  t3435 = t1495 * t3428;
  t3437 = -0.12e2 * t3382 * t439 * t2995 + 0.12e2 * t999 * t439 * t3146 - 0.8e1 * t999 * t439 * t3399 - 0.3e1 * t1109 * t2620 + 0.3e1 * t1113 * t1640 - 0.7e1 * t3429 * t2701 + 0.6e1 * t3432 * t2701 - t3435 * t2701 + 0.12e2 * t999 * t3147 - 0.4e1 * t991 * t3400 + 0.12e2 * t996 * t3400 - 0.4e1 * t999 * t3400 + 0.12e2 * t996 * t3410 - 0.12e2 * t999 * t3410 - t2564 + t2577 - t2579;
  t3442 = t1681 * t1129 * params->csk_a;
  t3449 = t95 * t3428;
  t3452 = t376 * t1517;
  t3453 = t183 * t3452;
  t3458 = t192 * t184;
  t3465 = t376 * t184;
  t3480 = -0.18e2 * t385 * t507 * t3458 * t207 + 0.3e1 * t95 * t3465 * t1964 - 0.12e2 * t1083 * t2672 - 0.3e1 * t3453 * t2663 - 0.6e1 * t3432 * t2668 - 0.18e2 * t3429 * t2676 + 0.6e1 * t3432 * t2676 + 0.6e1 * t3449 * t2676 - 0.3e1 * t3453 * t2688 - 0.11e2 * t3429 * t2691 + 0.11e2 * t3449 * t2691 + 0.7e1 * t3429 * t2694 - 0.18e2 * t3432 * t2694 + t3449 * t2701 + 0.7e1 * t3435 * t2743 - 0.12e2 * t2919 * t3442;
  t3495 = t192 * t376;
  t3515 = t460 * t103 * t765;
  t3520 = -0.11e2 * t2728 * t1662 * t3495 * t512 - 0.2e1 * t305 * t215 * t216 * t765 - t1072 * t1581 - 0.3e1 * t1072 * t1589 + 0.3e1 * t1072 * t1615 - 0.2e1 * t1072 * t2775 + 0.3e1 * t1079 * t1552 - 0.3e1 * t1086 * t1552 - t1086 * t1581 + 0.18e2 * t3435 * t2668 - 0.12e2 * t3435 * t2716 - 0.6e1 * t2720 * t3442 - 0.7e1 * t3429 * t2733 + 0.18e2 * t3432 * t2733 - 0.7e1 * t3435 * t2733 - 0.6e1 * t3435 * t2784 - 0.2e1 * t305 * t3515;
  t3542 = t523 * t743 * t298;
  t3545 = t1504 * t376;
  t3547 = t1656 * t3545 * params->csk_a;
  t3555 = t523 * t1129 * t207;
  t3562 = 0.3e1 * t1072 * t1594 + 0.11e2 * t3435 * t1656 * t1672 * t184 + 0.2e1 * t293 * t3515 + 0.3e1 * t1079 * t1589 + 0.12e2 * t3432 * t2716 + 0.3e1 * t1083 * t2095 - 0.12e2 * t2045 * t507 * t289 * t298 - 0.4e1 * t914 * t3542 - 0.6e1 * t2720 * t3547 + 0.3e1 * t1068 * t1604 + 0.3e1 * t1079 * t1581 - 0.6e1 * t2835 * t3555 - 0.8e1 * t725 * t511 * t1120 * t97 - t2684 + t2687 - t2710;
  t3563 = t183 * t3391;
  t3568 = t103 * t298;
  t3569 = t888 * t3568;
  t3574 = t298 * t298;
  t3575 = t95 * t3574;
  t3580 = -0.12e2 * t3563 * t193 * t298 * t888 - 0.2e1 * t3575 * t209 + 0.2e1 * t3575 * t211 + 0.12e2 * t3392 * t3569 - 0.12e2 * t3563 * t3569 + t2712 - t2714 - t2746 + t2751 - t2753 + t2798 + t2800 - t2801 + t2804 - t2807 + t2847 + t2850;
  t3592 = t95 * t3452;
  t3595 = 0.2e1 * t183 * t3574 * t194 + 0.3e1 * t3592 * t2876 + 0.6e1 * t3449 * t2879 + 0.4e1 * t1069 + 0.4e1 * t1084 - 0.4e1 * t1110 + 0.4e1 * t1114 - 0.4e1 * t1116 - t2862 - t2883 + t2884 - t2885 + t2894 - t2896 - t2899 + t2907 - t2910;
  t3596 = t1681 * t1129;
  t3608 = t1656 * t3545;
  t3614 = t102 * t765;
  t3621 = t3574 * t186;
  t3622 = t183 * t3621;
  t3631 = 0.6e1 * t2919 * t3596 + 0.3e1 * t183 * t3465 * t1527 + 0.11e2 * t3429 * t1662 * t3458 + 0.2e1 * t305 * t2465 - t1569 * t1130 + t2720 * t3608 - 0.3e1 * t1079 * t1698 - 0.2e1 * t1086 * t2911 - 0.2e1 * t1119 * t926 * t3614 + 0.2e1 * t293 * t198 * t3614 - 0.2e1 * t3622 * t217 - 0.2e1 * t3622 * t200 + 0.2e1 * t95 * t3621 * t200 + t2926 + t2927 - t2928 - 0.4e1 * t1122;
  t3635 = my_piecewise5(t57, 0, t60, 0, t3397 + t3437 + t3480 + t3520 + t3562 + t3580 + t3595 + t3631);
  t3642 = my_piecewise3(t3, 0, -t8 * t159 * t391 / 0.3e2 + t8 * t78 * t1140 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1e2 / 0.27e2 * t45 * t233 * t148 - 0.5e1 / 0.18e2 * t45 * t116 * t309 + t45 * t137 * t806 / 0.12e2 + t177 * t389 + 0.2e1 * t93 * t1138 + t52 * t3635));
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3642 + 0.4e1 * t1145;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3653 = params->csk_a * t328;
  t3654 = t3653 * t97;
  t3655 = t103 * t3654;
  t3656 = t1855 * t3655;
  t3658 = t2681 * t434;
  t3660 = t183 * t3658 * t1027;
  t3662 = t1161 * t434;
  t3665 = t186 * params->csk_a * t97;
  t3666 = t103 * t3665;
  t3669 = t183 * t3662;
  t3672 = t429 * t3662;
  t3673 = t512 * t186;
  t3674 = t3673 * t97;
  t3675 = t193 * t3674;
  t3678 = t429 * t3658;
  t3679 = t3678 * t1002;
  t3681 = t3678 * t994;
  t3683 = t1150 * t186;
  t3684 = t3683 * t434;
  t3685 = t429 * t3684;
  t3686 = t193 * t883;
  t3689 = t512 * t328;
  t3690 = t3689 * t97;
  t3691 = t103 * t3690;
  t3692 = t1855 * t3691;
  t3694 = t1849 * t3691;
  t3697 = t1015 * t193 * t3654;
  t3701 = -0.18e2 * t95 * t3662 * t3666 + 0.18e2 * t3669 * t3666 + 0.18e2 * t3669 * t3675 - 0.18e2 * t3672 * t3675 + 0.18e2 * t3685 * t3686 - t330 - t332 - 0.9e1 * t3656 + 0.9e1 * t3660 - 0.9e1 * t3679 - 0.3e1 * t3681 - 0.3e1 * t3692 + 0.9e1 * t3694 + 0.9e1 * t3697;
  t3702 = t193 * t3690;
  t3703 = t1849 * t3702;
  t3706 = t2575 * t103 * t965;
  t3708 = params->csk_a * t99;
  t3709 = t3708 * t254;
  t3710 = t193 * t3709;
  t3713 = params->csk_a * t207;
  t3715 = t103 * t3713 * t254;
  t3719 = t3398 * t207;
  t3720 = t103 * t3719;
  t3728 = t3708 * t2548;
  t3731 = t3653 * t126;
  t3733 = t1861 * t439 * t3731;
  t3735 = t3678 * t1005;
  t3737 = t921 * t207;
  t3739 = t1009 * t193 * t3737;
  t3741 = t243 * t434;
  t3742 = t429 * t3741;
  t3743 = t1161 * params->csk_a;
  t3747 = t439 * t3674;
  t3750 = t1150 * t1498;
  t3751 = t183 * t3750;
  t3752 = t1728 * t827;
  t3755 = 0.18e2 * t183 * t3684 * t3720 - 0.6e1 * t95 * t3684 * t3720 + 0.18e2 * t3742 * t439 * t3743 - 0.12e2 * t3672 * t3747 - 0.6e1 * t3685 * t3720 - 0.9e1 * t876 * t3710 + 0.9e1 * t882 * t3715 - 0.9e1 * t876 * t3728 - 0.11e2 * t3751 * t3752 + 0.9e1 * t3703 + 0.9e1 * t3706 + 0.9e1 * t3733 - 0.6e1 * t3735 + 0.9e1 * t3739;
  t3758 = t1662 * t1663 * t97;
  t3761 = t1495 * t3750;
  t3762 = t1681 * t868;
  t3765 = t95 * t3750;
  t3767 = t1747 * t1748 * t97;
  t3771 = t429 * t3750;
  t3775 = t1662 * t265;
  t3781 = t1681 * t1938 * t97;
  t3786 = t1662 * t844;
  t3789 = t1759 * t827;
  t3792 = t1681 * t836;
  t3797 = -0.7e1 * t3751 * t3758 - 0.7e1 * t3751 * t3767 - 0.11e2 * t3751 * t3786 - 0.7e1 * t3761 * t3758 + 0.18e2 * t3771 * t3758 - 0.6e1 * t3761 * t3762 - t3761 * t3767 + 0.7e1 * t3761 * t3786 + t3765 * t3767 + 0.6e1 * t3771 * t3767 - 0.18e2 * t3771 * t3775 + 0.12e2 * t3771 * t3781 + 0.6e1 * t3771 * t3789 - 0.6e1 * t3771 * t3792;
  t3798 = t1150 * t1517;
  t3799 = t183 * t3798;
  t3802 = t183 * t3683;
  t3806 = t2682 * t983;
  t3813 = t438 * t1150;
  t3820 = t636 * t1172;
  t3824 = t2045 * t507 * t918 * t126;
  t3832 = t618 * t2548;
  t3841 = -0.6e1 * t429 * t243 * t523 * t3813 * t207 - 0.12e2 * t95 * t3683 * t511 * t1827 - 0.18e2 * t3802 * t507 * t864 + 0.9e1 * t835 * t2009 + 0.9e1 * t862 * t2056 - 0.3e1 * t3799 * t266 + 0.7e1 * t3751 * t3775 + 0.11e2 * t3765 * t3752 - 0.12e2 * t3771 * t3762 + 0.9e1 * t825 * t3832 - 0.3e1 * t835 * t3832 - 0.3e1 * t872 * t3832 - 0.6e1 * t3806 + 0.3e1 * t3820 - 0.9e1 * t3824;
  t3844 = t97 * t1498;
  t3845 = t1495 * t3844;
  t3846 = t1504 * t1150;
  t3852 = t1656 * t1657 * t97;
  t3857 = t914 * t523 * t631 * t328;
  t3866 = t507 * t528 * t254;
  t3869 = t849 * t832;
  t3872 = t198 * t499 * t254;
  t3878 = t1681 * t3813 * t512;
  t3884 = t523 * t538 * t254;
  t3889 = t1150 * t97;
  t3893 = 0.11e2 * t3845 * t1656 * t3846 * t512 - 0.6e1 * t3845 * t1656 * t3846 * params->csk_a + 0.3e1 * t95 * t3889 * t1964 + 0.9e1 * t835 * t2078 - 0.3e1 * t3799 * t251 - 0.12e2 * t3761 * t3781 - 0.6e1 * t3761 * t3852 + 0.18e2 * t3845 * t3878 + 0.9e1 * t825 * t3866 - 0.9e1 * t835 * t3866 + 0.9e1 * t852 * t3872 - 0.6e1 * t835 * t3884 - 0.3e1 * t3857 - 0.3e1 * t3869;
  t3898 = t849 * t841;
  t3900 = t485 * t2548;
  t3905 = t964 * t3737;
  t3906 = t647 * t3905;
  t3908 = t1831 * t965;
  t3909 = t2562 * t3908;
  t3911 = t1199 * t207;
  t3913 = t183 * t3911 * t961;
  t3915 = -0.18e2 * t3751 * t3789 + 0.6e1 * t3765 * t3789 + 0.9e1 * t825 * t3900 - 0.9e1 * t872 * t3900 - t1160 - t1164 + t1168 - t1170 + t1174 - t1176 - 0.3e1 * t3898 + 0.9e1 * t3906 - 0.9e1 * t3909 - 0.9e1 * t3913;
  t3922 = t95 * t328 * t254 * t209;
  t3930 = t429 * t3844;
  t3934 = t3845 * t1656 * t3846 + 0.6e1 * t3930 * t1681 * t3813 + 0.3e1 * t95 * t3798 * t261 - 0.3e1 * t835 * t2137 - 0.9e1 * t825 * t2160 - 0.3e1 * t3922 - t850 + t855 + t866 - t879 + t885 - t890 + t902 - t903;
  t3935 = t901 * t931;
  t3937 = t599 * t919;
  t3939 = t511 * t927;
  t3942 = t183 * t3844;
  t3950 = t1747 * t260;
  t3953 = 0.6e1 * t1201;
  t3954 = 0.11e2 * t3942 * t1662 * t192 * t1150 + 0.3e1 * t183 * t3889 * t1527 + 0.6e1 * t3765 * t3950 - 0.6e1 * t872 * t3939 + t1179 + t1181 + t1185 + t1193 + 0.3e1 * t3935 + 0.3e1 * t3937 - t3953 + t904 + t920 - t923 - t930;
  t3958 = my_piecewise5(t57, 0, t60, 0, t3701 + t3755 + t3797 + t3841 + t3893 + t3915 + t3934 + t3954);
  t3965 = my_piecewise3(t3, 0, t8 * t78 * t1218 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t93 * t1216 + 0.3e1 * t123 * t936 + 0.3e1 * t239 * t338 + t52 * t3958));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3965 + 0.2e1 * t1222;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t3982 = t991 * t3691;
  t3984 = t1651 * t321 * t97;
  t3985 = t193 * t3984;
  t3990 = t512 * t321;
  t3991 = t3990 * t97;
  t3998 = t996 * t3655;
  t4000 = t2666 * t1500;
  t4004 = t3990 * t827;
  t4011 = t103 * t3984;
  t4018 = t439 * t3984;
  t4023 = -0.6e1 * t1495 * t4000 * t1018 - 0.11e2 * t3053 * t193 * t3991 - 0.6e1 * t3056 * t439 * t3991 + 0.6e1 * t3048 * t4004 + t3048 * t4011 - 0.7e1 * t3053 * t3985 - 0.18e2 * t3053 * t4004 - 0.7e1 * t3053 * t4011 + 0.18e2 * t3056 * t3985 + 0.6e1 * t3056 * t4004 + 0.6e1 * t3056 * t4011 + 0.12e2 * t3056 * t4018 - 0.7e1 * t3059 * t3985 - t3059 * t4011 - t330 - t3982 + 0.3e1 * t3998 - t962 + t967 - t971;
  t4024 = t996 * t3691;
  t4026 = t999 * t3691;
  t4027 = t996 * t3702;
  t4029 = t3844 * t1500;
  t4030 = t1495 * t4029;
  t4031 = t3042 * t321;
  t4035 = t992 * t254;
  t4051 = t95 * t1287 * t207;
  t4052 = t4051 * t854;
  t4054 = t298 * t321;
  t4056 = t183 * t4054 * t207;
  t4059 = t1348 * t2548;
  t4062 = t1016 * t328;
  t4063 = t439 * t4062;
  t4064 = t1861 * t4063;
  t4067 = t999 * t439 * t3690;
  t4071 = t1246 * params->csk_a;
  t4075 = t2562 * t1011;
  t4077 = t193 * t4035;
  t4080 = t193 * t4062;
  t4081 = t1861 * t4080;
  t4083 = t999 * t3702;
  t4085 = -0.6e1 * t2572 * t439 * t1010 - 0.6e1 * t3059 * t1505 * t3984 + 0.11e2 * t4030 * t1505 * t4031 - 0.6e1 * t4030 * t1505 * t4071 + 0.18e2 * t4030 * t439 * t4031 - 0.4e1 * t999 * t439 * t4035 + 0.6e1 * t1015 * t3218 - 0.12e2 * t3059 * t4018 - 0.3e1 * t4056 * t463 + 0.6e1 * t996 * t4059 + 0.6e1 * t996 * t4077 + 0.3e1 * t4024 - t4026 + 0.3e1 * t4027 + 0.3e1 * t4052 + 0.3e1 * t4064 - 0.2e1 * t4067 + 0.3e1 * t4075 + 0.3e1 * t4081 - 0.3e1 * t4083;
  t4090 = t183 * t1246 * t1517;
  t4093 = t1277 * t827;
  t4099 = t198 * t199 * t321;
  t4107 = t991 * t3655;
  t4119 = t103 * t4035;
  t4133 = t193 * t4071;
  t4140 = -0.6e1 * t999 * t4077 - 0.3e1 * t4090 * t266 - 0.11e2 * t3053 * t4093 + 0.3e1 * t95 * t301 * t1517 * t4099 + 0.11e2 * t3048 * t4093 - 0.12e2 * t429 * t4000 * t1018 - 0.3e1 * t4107 - 0.3e1 * t4090 * t251 - 0.6e1 * t3656 - 0.3e1 * t4056 * t474 + 0.6e1 * t1009 * t193 * t2980 + 0.6e1 * t1023 * t3872 - 0.2e1 * t991 * t4119 + 0.6e1 * t996 * t4119 - 0.2e1 * t999 * t4119 + 0.7e1 * t4030 * t193 * t4031 + 0.6e1 * t1015 * t193 * t3217 - 0.18e2 * t429 * t4029 * t4133 + 0.3e1 * t2287 * t1279 - 0.6e1 * t991 * t4059;
  t4148 = t511 * t1535 * t97;
  t4169 = t725 * t511 * t1290 * t97;
  t4171 = t2685 * t987;
  t4186 = 0.6e1 * t2667 * t1681 * t743 * t97 - 0.6e1 * t592 * t507 * t289 * t254 - 0.4e1 * t725 * t511 * t357 * t254 + 0.3e1 * t95 * t4054 * t588 - 0.3e1 * t2357 * t1231 + 0.6e1 * t3706 + 0.6e1 * t3733 - 0.4e1 * t3735 + 0.6e1 * t3739 - 0.2e1 * t4169 - 0.3e1 * t4171;
  t4197 = t523 * t2747 * t145;
  t4198 = t914 * t4197;
  t4206 = t722 * t1172;
  t4209 = t722 * t1263;
  t4212 = t748 * t1172;
  t4224 = t321 * t97;
  t4233 = -t2357 * t1237 + 0.3e1 * t2333 * t1237 - t2336 * t1237 + 0.3e1 * t835 * t2446 - t4198 - 0.2e1 * t615 * t3270 + t3845 * t1656 * t2778 * t145 + 0.3e1 * t2333 * t1231 - t4206 - 0.3e1 * t2336 * t1256 - t4209 + 0.3e1 * t835 * t2423 + t4212 - 0.2e1 * t2336 * t1252 + 0.3e1 * t2333 * t1256 + 0.3e1 * t1247 * t1518 * t827 + 0.6e1 * t2322 * t1747 * t1295 * t97 + 0.3e1 * t183 * t4224 * t3233 + 0.11e2 * t2675 * t1662 * t986 + 0.3e1 * t862 * t2399;
  t4240 = t439 * t512;
  t4241 = t4224 * t207;
  t4245 = t2972 * t4241;
  t4248 = t2224 * t3905;
  t4259 = t618 * t186 * t827;
  t4278 = t2224 * t1831 * t3737;
  t4283 = t779 * t3905;
  t4289 = 0.6e1 * t779 * t964 * t924 * t254 - 0.6e1 * t959 * t460 * t99 * t2548 - 0.6e1 * t429 * t1271 * t4259 - 0.6e1 * t2256 * t3296 * t4241 - 0.18e2 * t2256 * t964 * t4241 + 0.18e2 * t2572 * t2989 * t883 - 0.6e1 * t959 * t969 * t3709 + 0.18e2 * t1272 * t4259 - 0.18e2 * t2260 * t4245 - 0.3e1 * t4278 + 0.3e1 * t4283;
  t4298 = 0.18e2 * t3742 * t3007 * t1278 + t1012 + t1024 + t1245 + t1249 - t1250 - t1259 - t1264 + t1268 + t1269 - t1270 - t1274 - t1276 + t1281 + 0.6e1 * t3906 - 0.6e1 * t3909 - 0.6e1 * t3913 - t850 + t902 - t903;
  t4302 = t849 * t791;
  t4306 = t95 * t298 * t328 * t209;
  t4307 = t748 * t1291;
  t4314 = t904 + t920 - t923 - t1039 - t1042 + t1282 + t1283 - 0.4e1 * t1201 + t1285 - t1361 + t1292;
  t4319 = my_piecewise5(t57, 0, t60, 0, 0.18e2 * t1272 * t485 * t186 * t827 + t4314 - t4306 + t4307 + t4302 + t4298 + t4289 - 0.3e1 * t4248 + t4233 + t4186 + t4140 + t4085 + t4023 + 0.2e1 * t3935 + 0.2e1 * t3937 - 0.2e1 * t3922 - 0.2e1 * t3898 - 0.2e1 * t3869 - 0.2e1 * t3857 - 0.6e1 * t3824 + 0.2e1 * t3820 - 0.4e1 * t3806 + 0.6e1 * t3703 + 0.6e1 * t3694 + 0.6e1 * t3697 - 0.2e1 * t3692 - 0.6e1 * t3679 - 0.2e1 * t3681 + 0.6e1 * t3660 - t356 - 0.3e1 * t825 * t2474 - 0.2e1 * t2357 * t1296 - t835 * t2501 + 0.18e2 * t2232 * t4245 - 0.18e2 * t2566 * t1011 + 0.7e1 * t183 * t4029 * t4133 - 0.12e2 * t95 * t1271 * t4148 - 0.12e2 * t2260 * t4240 * t4241);
  t4326 = my_piecewise3(t3, 0, t8 * t78 * t1303 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.72e2 * t45 * t116 * t338 + t45 * t137 * t936 / 0.24e2 + 0.2e1 * t239 * t365 + 0.2e1 * t123 * t1047 + t93 * t1301 + t52 * t4319));
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4326 + 0.2e1 * t1307;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4341 = t3428 * t1500;
  t4342 = t1495 * t4341;
  t4343 = t3049 * t97;
  t4344 = t439 * t4343;
  t4347 = t429 * t4341;
  t4348 = t3049 * t827;
  t4354 = t183 * t4341;
  t4355 = t193 * t4343;
  t4358 = t1348 * t97;
  t4359 = t193 * t4358;
  t4362 = t376 * params->csk_a;
  t4367 = t95 * t4341;
  t4386 = t183 * t3452 * t188;
  t4389 = t376 * t97;
  t4394 = 0.3e1 * t95 * t4389 * t1517 * t352 - 0.6e1 * t3041 * t439 * t4362 * t97 + 0.7e1 * t4342 * t1002 + 0.18e2 * t4342 * t1005 - 0.11e2 * t4354 * t1027 + 0.11e2 * t4367 * t1027 - 0.3e1 * t4386 * t1027 - 0.12e2 * t4342 * t4344 - t4342 * t4348 - 0.7e1 * t4342 * t4355 + 0.12e2 * t4347 * t4344 + 0.6e1 * t4347 * t4348 + 0.18e2 * t4347 * t4355 - 0.18e2 * t4347 * t4359 + 0.6e1 * t4347 * t994 - 0.7e1 * t4354 * t4348 + t4367 * t4348 - 0.7e1 * t4354 * t4355 - t330 - t383;
  t4415 = t992 * t298;
  t4416 = t103 * t4415;
  t4421 = t245 * t298;
  t4422 = t3409 * t4421;
  t4429 = t376 * t126 * t207;
  t4439 = t645 * t298;
  t4458 = -0.12e2 * t4347 * t439 * t4358 - 0.11e2 * t4354 * t1002 - 0.12e2 * t3365 * t103 * t248 * t97 + 0.6e1 * t4367 * t994 - 0.18e2 * t4354 * t994 - 0.6e1 * t4347 * t1005 - 0.3e1 * t1109 * t3728 + 0.6e1 * t999 * t193 * t3211 - 0.2e1 * t991 * t4416 + 0.7e1 * t4354 * t4359 - 0.6e1 * t999 * t4422 + 0.6e1 * t2224 * t193 * t2976 - 0.6e1 * t3742 * t439 * t4429 - 0.6e1 * t4030 * t1505 * t4362 * t126 + 0.6e1 * t996 * t4422 + 0.6e1 * t3392 * t103 * t4439 - 0.18e2 * t183 * t3741 * t193 * t4429 - 0.4e1 * t999 * t439 * t4415 + 0.11e2 * t4030 * t1505 * t376 * t512 * t126 - 0.6e1 * t4342 * t1505 * t4343;
  t4467 = t1348 * t3568;
  t4489 = -0.3e1 * t1109 * t3710 + 0.3e1 * t1113 * t3715 + 0.6e1 * t999 * t3212 - 0.3e1 * t4386 * t4359 + 0.6e1 * t996 * t4416 - 0.2e1 * t999 * t4416 - 0.6e1 * t991 * t4467 + 0.6e1 * t996 * t4467 - 0.2e1 * t3982 + 0.6e1 * t3998 + 0.6e1 * t4024 - 0.2e1 * t4026 + 0.6e1 * t4027 + 0.6e1 * t4052 + 0.6e1 * t4064 - 0.4e1 * t4067 + 0.6e1 * t4075 + 0.6e1 * t4081 - 0.6e1 * t4083 - 0.6e1 * t4107;
  t4522 = 0.11e2 * t3942 * t1662 * t3495 * t126 + t3845 * t1656 * t2067 * t376 - 0.4e1 * t725 * t511 * t357 * t298 + 0.3e1 * t1072 * t2009 - t1072 * t3832 + 0.3e1 * t1079 * t3832 + 0.3e1 * t1083 * t3872 - t1086 * t3832 - 0.2e1 * t615 * t3542 - 0.2e1 * t3735 + 0.3e1 * t3739;
  t4543 = t193 * t126;
  t4565 = -0.3e1 * t1072 * t3866 + 0.3e1 * t1068 * t2056 - 0.6e1 * t718 * t507 * t4421 - 0.2e1 * t1072 * t3884 + 0.3e1 * t1072 * t2078 + 0.3e1 * t1079 * t3866 + 0.6e1 * t3449 * t1747 * t982 + 0.3e1 * t183 * t4389 * t1518 * t4543 + 0.3e1 * t3592 * t198 * t982 + 0.3e1 * t1079 * t3900 - 0.3e1 * t1086 * t3900 + 0.6e1 * t3930 * t1681 * t1129 * t126 - 0.4e1 * t4169 - 0.6e1 * t4171 - 0.2e1 * t4198 - 0.2e1 * t4206 - 0.2e1 * t4209 + 0.2e1 * t4212 - 0.2e1 * t3806 + t3820;
  t4569 = t1026 * t3665;
  t4577 = t2972 * t965;
  t4582 = t3296 * t965;
  t4605 = 0.18e2 * t3361 * t439 * params->csk_a * t965 - 0.6e1 * t3563 * t1353 * t3568 - 0.6e1 * t3563 * t1831 * t4439 + 0.6e1 * t779 * t964 * t2976 - 0.12e2 * t3361 * t4240 * t965 - 0.6e1 * t3355 * t4582 + 0.18e2 * t3358 * t4577 + 0.18e2 * t3358 * t4582 + 0.18e2 * t3361 * t3908 - 0.18e2 * t3361 * t4577 - 0.6e1 * t3361 * t4582 - 0.18e2 * t3365 * t4569 + 0.18e2 * t3368 * t4569 - 0.3e1 * t3824 - t3857 - t3869 - t3898 - 0.6e1 * t4248 - 0.6e1 * t4278 + 0.6e1 * t4283;
  t4610 = 0.3e1 * t3906 - 0.3e1 * t3909 - 0.3e1 * t3913 + t1339 + t1343 - t1159 - t1344 - t1346 + t1347 + t1069 + t1084 + t1173 - t1175 - t850 + t1352 - t1356 - t1359 - t1110 + t1114 - t1116;
  t4621 = -t1947 * t1130 - t1123 + t1180 + t1192 - t1284 - 0.4e1 * t1289 + t1360 + t1362 + t904 + t920 - t923;
  t4626 = my_piecewise5(t57, 0, t60, 0, -0.3e1 * t1079 * t2160 - 0.2e1 * t1086 * t3939 - 0.3e1 * t3656 + 0.3e1 * t3660 - 0.3e1 * t3679 - t3681 - t3692 + 0.3e1 * t3694 + 0.3e1 * t3697 + 0.3e1 * t3703 + 0.3e1 * t3706 + 0.3e1 * t3733 - t3922 + t3935 + t3937 + 0.2e1 * t4302 - 0.2e1 * t4306 + 0.2e1 * t4307 + t4394 + t4458 + t4489 + t4522 + t4565 + t4605 + t4610 + t4621 + t902 - t903);
  t4633 = my_piecewise3(t3, 0, t8 * t78 * t1373 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.36e2 * t45 * t116 * t365 + t45 * t137 * t1047 / 0.12e2 + t239 * t389 + t123 * t1138 + t93 * t1371 + t52 * t4626));
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4633 + 0.2e1 * t1377;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t4646 = t1382 * t186;
  t4647 = t4646 * t434;
  t4648 = t429 * t4647;
  t4651 = t1391 * t434;
  t4652 = t183 * t4651;
  t4655 = t429 * t4651;
  t4658 = t95 * t4647;
  t4661 = t183 * t4647;
  t4683 = t439 * t1391 * params->csk_a;
  t4686 = 0.9e1 * t1113 * t103 * t3713 * t298 - 0.9e1 * t1109 * t193 * t3708 * t298 - 0.9e1 * t1109 * t3708 * t3568 + 0.18e2 * t4661 * t193 * t3719 + 0.18e2 * t4652 * t3666 - 0.18e2 * t4655 * t3675 + 0.18e2 * t4648 * t3686 - 0.6e1 * t4648 * t3720 - 0.6e1 * t4658 * t3720 + 0.18e2 * t4661 * t3720 + 0.18e2 * t3742 * t4683 - 0.18e2 * t4658 * t884 - t330 - t383;
  t4701 = t1382 * t1498;
  t4702 = t429 * t4701;
  t4705 = -0.12e2 * t4655 * t3747 + 0.12e2 * t4702 * t3781 - 0.3e1 * t3982 + 0.9e1 * t3998 + 0.9e1 * t4024 - 0.3e1 * t4026 + 0.9e1 * t4027 + 0.9e1 * t4052 + 0.9e1 * t4064 - 0.6e1 * t4067 + 0.9e1 * t4075 + 0.9e1 * t4081 - 0.9e1 * t4083 - 0.9e1 * t4107;
  t4707 = t183 * t4701;
  t4710 = t95 * t4701;
  t4716 = t1495 * t4701;
  t4734 = t429 * t4646;
  t4735 = t438 * t97;
  t4740 = -0.6e1 * t4734 * t523 * t4735 * t207 + 0.18e2 * t4702 * t3758 - 0.7e1 * t4707 * t3758 - 0.7e1 * t4716 * t3758 - 0.6e1 * t4716 * t3762 + 0.6e1 * t4702 * t3767 - 0.7e1 * t4707 * t3767 + t4710 * t3767 - t4716 * t3767 - 0.18e2 * t4702 * t3775 - 0.11e2 * t4707 * t3786 + 0.7e1 * t4716 * t3786 - 0.18e2 * t4707 * t3789 + 0.6e1 * t4710 * t3789;
  t4749 = t192 * t1382;
  t4751 = t507 * t4749 * t207;
  t4756 = t1382 * t1517;
  t4757 = t183 * t4756;
  t4764 = t1382 * t97;
  t4776 = t618 * t3568;
  t4781 = t485 * t3568;
  t4784 = 0.9e1 * t1083 * t198 * t499 * t298 - 0.6e1 * t4716 * t1656 * t1685 * t97 + 0.3e1 * t95 * t4764 * t1964 - 0.3e1 * t1072 * t4776 + 0.9e1 * t1079 * t4776 + 0.9e1 * t1079 * t4781 - 0.12e2 * t1408 * t4148 - 0.18e2 * t244 * t4751 - 0.3e1 * t4757 * t251 - 0.3e1 * t4757 * t266 - 0.11e2 * t4707 * t3752 + 0.11e2 * t4710 * t3752 - 0.12e2 * t4702 * t3762 + 0.6e1 * t4702 * t3789 - 0.6e1 * t4702 * t3792;
  t4793 = t1681 * t438 * t1382 * t512;
  t4802 = t1504 * t1382;
  t4804 = t1656 * t4802 * t512;
  t4812 = t507 * t528 * t298;
  t4822 = t1662 * t4749 * params->csk_a;
  t4826 = -0.6e1 * t1072 * t523 * t538 * t298 + 0.9e1 * t1068 * t2399 + 0.9e1 * t1072 * t2423 + 0.9e1 * t1072 * t2446 - 0.9e1 * t1072 * t4812 + 0.9e1 * t1079 * t4812 - 0.3e1 * t1086 * t4776 - 0.9e1 * t1086 * t4781 - 0.12e2 * t4716 * t3781 + 0.18e2 * t3845 * t4793 + 0.11e2 * t3845 * t4804 - 0.6e1 * t4716 * t3852 + 0.7e1 * t3942 * t4822 - 0.6e1 * t4169;
  t4835 = -0.9e1 * t4171 - 0.3e1 * t4198 - 0.3e1 * t4206 - 0.3e1 * t4209 + 0.3e1 * t4212 - 0.9e1 * t4248 - 0.9e1 * t4278 + 0.9e1 * t4283 - t1394 - t1396 + t1400 - t1401 - t1402 + t1403;
  t4840 = t1069 + t1084 - t850 - t1110 + t1114 - t1116 + t902 - t903 + t1410 + t1414 + 0.3e1 * t4302 - 0.3e1 * t4306 + 0.3e1 * t4307 + t904;
  t4841 = 0.6e1 * t1289;
  t4842 = t1656 * t4802;
  t4847 = t1662 * t4749;
  t4860 = t95 * t4756;
  t4865 = -0.6e1 * t1086 * t511 * t1120 + 0.3e1 * t183 * t4764 * t1527 + 0.6e1 * t4702 * t1681 * t4735 - 0.3e1 * t1072 * t2501 - 0.9e1 * t1079 * t2474 + 0.3e1 * t4860 * t261 + t3845 * t4842 + 0.11e2 * t3942 * t4847 + 0.6e1 * t4710 * t3950 - t1123 + t1433 + t1435 - t4841 + t920 - t923;
  t4869 = my_piecewise5(t57, 0, t60, 0, t4686 + t4705 + t4740 + t4784 + t4826 + t4835 + t4840 + t4865);
  t4876 = my_piecewise3(t3, 0, t8 * t78 * t1440 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.24e2 * t45 * t116 * t389 + t45 * t137 * t1138 / 0.8e1 + t93 * t1438 + t52 * t4869));
  tv4rholapl30 = 0.2e1 * rho[0] * t4876 + 0.2e1 * t1444;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4882 = t103 * t3653 * t207;
  t4883 = t882 * t4882;
  t4888 = t183 * t328 * t321 * t207 * t463;
  t4891 = t193 * t3708 * t328;
  t4892 = t876 * t4891;
  t4894 = t321 * t321;
  t4895 = t4894 * t207;
  t4896 = t183 * t4895;
  t4899 = t2685 * t1231;
  t4904 = t429 * t4895;
  t4907 = t2713 * t1256;
  t4912 = t4894 * t186;
  t4913 = t429 * t4912;
  t4917 = t511 * t513 * t328;
  t4918 = t872 * t4917;
  t4920 = t825 * t4917;
  t4922 = t835 * t2802;
  t4924 = t835 * t4917;
  t4927 = t507 * t528 * t328;
  t4928 = t825 * t4927;
  t4930 = t835 * t2749;
  t4932 = t2713 * t1252;
  t4938 = 0.18e2 * t4896 * t1556 - 0.12e2 * t4904 * t1585 + 0.18e2 * t4913 * t1610 + 0.18e2 * t4913 * t1621 - 0.6e1 * t4918 + 0.18e2 * t4920 + 0.18e2 * t4922 - 0.6e1 * t4924 + 0.18e2 * t4928 + 0.18e2 * t4930 - 0.12e2 * t4932;
  t4940 = t862 * t2845;
  t4942 = t511 * t1171;
  t4943 = t872 * t4942;
  t4945 = t95 * t4912;
  t4948 = t183 * t4912;
  t4955 = t2848 * t198 * t1295 * t207;
  t4957 = t183 * t4894;
  t4965 = t328 * t328;
  t4966 = t95 * t4965;
  t4968 = 0.3e1 * t4966 * t209;
  t4971 = 0.3e1 * t4966 * t211;
  t4974 = 0.3e1 * t183 * t4965 * t194;
  t4975 = t95 * t4894;
  t4988 = 0.6e1 * t4975 * t1513 + 0.3e1 * t4975 * t1519 + 0.3e1 * t4957 * t1527 - 0.4e1 * t1159 - 0.4e1 * t1163 + 0.4e1 * t1167 - 0.4e1 * t1169 + 0.4e1 * t1173 - 0.4e1 * t1175 + t4971 + t4974;
  t4996 = t4894 * t1517;
  t5000 = t4894 * t1498;
  t5001 = t95 * t5000;
  t5004 = t183 * t5000;
  t5007 = t429 * t5000;
  t5010 = t183 * t4996;
  t5022 = t1495 * t5000;
  t5031 = t835 * t2895;
  t5035 = t511 * t1290;
  t5036 = t872 * t5035;
  t5038 = -0.12e2 * t5022 * t1653 - 0.6e1 * t5022 * t1658 + 0.11e2 * t5022 * t1673 - 0.11e2 * t5004 * t1678 - 0.6e1 * t5007 * t1682 + 0.18e2 * t5022 * t1682 - 0.6e1 * t5022 * t1686 - 0.18e2 * t4948 * t1715 - 0.3e1 * t5010 * t217 - 0.6e1 * t5031 - 0.12e2 * t5036;
  t5044 = t825 * t2908;
  t5052 = t4965 * t186;
  t5053 = t183 * t5052;
  t5055 = 0.3e1 * t5053 * t200;
  t5058 = 0.3e1 * t95 * t5052 * t200;
  t5060 = 0.3e1 * t5053 * t217;
  t5086 = 0.12e2 * t5007 * t1653 - 0.7e1 * t5004 * t1664 + 0.18e2 * t5007 * t1664 - 0.7e1 * t5022 * t1664 + 0.7e1 * t5022 * t1678 - 0.18e2 * t5007 * t1701 + t5001 * t1749 - 0.7e1 * t5004 * t1749 + 0.6e1 * t5007 * t1749 - t5022 * t1749 - 0.6e1 * t5022 * t1765;
  t5090 = my_piecewise5(t57, 0, t60, 0, -0.12e2 * t4945 * t511 * t102 * t207 + t5086 + t5058 - t5060 - t5055 - 0.18e2 * t5044 + t5038 + t4988 - t4968 + 0.18e2 * t4955 - 0.18e2 * t4943 + 0.18e2 * t4940 + t4938 - 0.18e2 * t4907 + 0.18e2 * t4899 - 0.18e2 * t4892 - 0.18e2 * t4888 + 0.18e2 * t4883 - 0.9e1 * t1201 + 0.4e1 * t1192 + 0.4e1 * t1184 + 0.4e1 * t1178 + 0.4e1 * t1180 - t330 - t332 + 0.7e1 * t5004 * t1701 - 0.6e1 * t4913 * t1736 - 0.12e2 * t5007 * t1765 + 0.11e2 * t5001 * t1729 - 0.11e2 * t5004 * t1729 - 0.3e1 * t5010 * t200 + 0.6e1 * t5001 * t1760 - 0.18e2 * t5004 * t1760 + 0.6e1 * t5007 * t1760 + 0.18e2 * t4948 * t1562 - 0.6e1 * t4913 * t1562 + 0.11e2 * t4957 * t1530 - 0.6e1 * t4945 * t1562 + 0.18e2 * t4896 * t1537 - 0.18e2 * t4904 * t1556 - 0.18e2 * t95 * t4895 * t1537 + 0.6e1 * t429 * t4894 * t1523 + t1495 * t4894 * t1506 + 0.3e1 * t95 * t4996 * t200);
  t5096 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.4e1 * t123 * t1216 + t52 * t5090));
  tv4sigma40 = 0.2e1 * rho[0] * t5096;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t5103 = t3689 * t1026;
  t5104 = t996 * t5103;
  t5105 = 0.9e1 * t5104;
  t5106 = t999 * t5103;
  t5107 = 0.3e1 * t5106;
  t5108 = t991 * t5103;
  t5109 = 0.3e1 * t5108;
  t5110 = t103 * t3731;
  t5111 = t991 * t5110;
  t5112 = 0.9e1 * t5111;
  t5114 = t512 * t1150 * t207;
  t5118 = t193 * t5114;
  t5121 = t996 * t5110;
  t5122 = 0.9e1 * t5121;
  t5125 = t145 * t1150;
  t5126 = t5125 * t207;
  t5127 = t183 * t5126;
  t5136 = t1015 * t4080;
  t5137 = 0.9e1 * t5136;
  t5138 = -0.6e1 * t2256 * t103 * t5114 - 0.6e1 * t429 * t5126 * t1574 - 0.12e2 * t2260 * t439 * t5114 + 0.18e2 * t5127 * t1574 + 0.18e2 * t2232 * t5118 - 0.18e2 * t2260 * t5118 - t330 + t5105 - t5107 - t5109 - t5112 + t5122 + t5137;
  t5139 = t3689 * t4543;
  t5140 = t999 * t5139;
  t5141 = 0.9e1 * t5140;
  t5144 = t999 * t439 * t992 * t328;
  t5145 = 0.6e1 * t5144;
  t5153 = t4051 * t1337;
  t5154 = 0.9e1 * t5153;
  t5157 = t1015 * t4063;
  t5158 = 0.9e1 * t5157;
  t5160 = t2562 * t193 * t958;
  t5161 = 0.9e1 * t5160;
  t5162 = t996 * t5139;
  t5163 = 0.9e1 * t5162;
  t5168 = t1681 * t1938 * t1150;
  t5171 = -0.18e2 * t2256 * t103 * t3743 + 0.18e2 * t5127 * t1537 + 0.18e2 * t3685 * t2264 + 0.18e2 * t3685 * t2271 + 0.12e2 * t2302 * t5168 + 0.9e1 * t4883 - 0.9e1 * t4888 - 0.9e1 * t4892 - t5141 - t5145 + t5154 + t5158 + t5161 + t5163;
  t5174 = t1662 * t1663 * t1150;
  t5181 = t1759 * t1150 * t67 * t102;
  t5189 = t1747 * t1748 * t1150;
  t5206 = -0.11e2 * t2325 * t1662 * t528 * t1150 + 0.18e2 * t2302 * t5174 + 0.6e1 * t2302 * t5181 + 0.6e1 * t2302 * t5189 - 0.6e1 * t3761 * t2316 + 0.6e1 * t2322 * t5181 + t2322 * t5189 - 0.7e1 * t2325 * t5174 - 0.18e2 * t2325 * t5181 - 0.7e1 * t2325 * t5189 - 0.12e2 * t2344 * t5168 - 0.7e1 * t2344 * t5174 - t2344 * t5189;
  t5207 = t95 * t5125;
  t5210 = t183 * t5125;
  t5216 = t1747 * t199 * t1150;
  t5233 = t615 * t4197;
  t5234 = 0.3e1 * t5233;
  t5239 = 0.3e1 * t5207 * t1964 - 0.3e1 * t5210 * t1964 - 0.12e2 * t5207 * t1973 - 0.3e1 * t5210 * t1976 - 0.6e1 * t2302 * t3878 - 0.12e2 * t3771 * t2316 - 0.18e2 * t3802 * t2319 + 0.11e2 * t2322 * t5216 - 0.11e2 * t2325 * t5216 + 0.7e1 * t3751 * t2360 - 0.18e2 * t3771 * t2360 + 0.18e2 * t3761 * t2381 - 0.6e1 * t3761 * t2427 - t5234;
  t5247 = t725 * t511 * t1290 * t126;
  t5248 = 0.6e1 * t5247;
  t5250 = t2685 * t507 * t3255;
  t5251 = 0.9e1 * t5250;
  t5267 = -0.6e1 * t2344 * t1656 * t1657 * t1150 - 0.6e1 * t429 * t3683 * t2403 + 0.7e1 * t3761 * t2370 + 0.11e2 * t3761 * t2415 + 0.9e1 * t4899 - 0.9e1 * t4907 - 0.3e1 * t4918 + 0.9e1 * t4920 + 0.9e1 * t4922 - 0.3e1 * t4924 + 0.9e1 * t4928 - t5248 - t5251;
  t5275 = t3653 * t67 * t357 * t207;
  t5276 = t2224 * t5275;
  t5277 = 0.9e1 * t5276;
  t5279 = t2224 * t1831 * t3911;
  t5280 = 0.9e1 * t5279;
  t5281 = t779 * t5275;
  t5282 = 0.9e1 * t5281;
  t5285 = 0.9e1 * t4930 - 0.6e1 * t4932 + 0.9e1 * t4940 - 0.9e1 * t4943 + 0.9e1 * t4955 - t5277 - t5280 + t5282 - t4968 + t4971 + t4974 + 0.4e1 * t1244 + 0.4e1 * t1248 - t1160;
  t5290 = -t1259 - t1264 + t1268 + t1174 - t1176 - 0.4e1 * t1273 - 0.4e1 * t1275 + 0.4e1 * t1280 - t356 + t1181 + t1193 - t3953 + t1285;
  t5307 = 0.6e1 * t2322 * t1747 * t102 * t1150 + 0.3e1 * t5207 * t1519 + 0.6e1 * t3771 * t2477 + 0.11e2 * t3751 * t2492 + t3761 * t2504 + 0.3e1 * t3799 * t290 + t1292 - t1434 - 0.3e1 * t5031 - 0.6e1 * t5036 - 0.9e1 * t5044 - t5055 + t5058 - t5060;
  t5311 = my_piecewise5(t57, 0, t60, 0, t5138 + t5171 + t5206 + t5239 + t5267 + t5285 + t5290 + t5307);
  t5317 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1216 / 0.24e2 + 0.3e1 * t123 * t1301 + t52 * t5311));
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t5317;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t5325 = t103 * t324 * params->csk_a;
  t5333 = t3990 * t207;
  t5334 = t193 * t5333;
  t5339 = t103 * t5333;
  t5352 = t1109 * t4891;
  t5355 = t1109 * t3653 * t462;
  t5357 = t1113 * t4882;
  t5359 = 0.18e2 * t3361 * t193 * t1278 + 0.18e2 * t3361 * t439 * t1278 - 0.12e2 * t3361 * t439 * t5333 - 0.6e1 * t3355 * t5339 + 0.18e2 * t3358 * t5334 + 0.18e2 * t3358 * t5339 - 0.18e2 * t3361 * t5334 - 0.6e1 * t3361 * t5339 - 0.18e2 * t3365 * t5325 + 0.18e2 * t3368 * t5325 - t330 - t383 - 0.3e1 * t5352 - 0.3e1 * t5355 + 0.3e1 * t5357;
  t5376 = t1681 * t1938 * t321;
  t5379 = 0.12e2 * t3432 * t5376 + 0.3e1 * t4883 - 0.3e1 * t4888 - 0.3e1 * t4892 + 0.12e2 * t5104 - 0.4e1 * t5106 - 0.4e1 * t5108 - 0.12e2 * t5111 + 0.12e2 * t5121 + 0.12e2 * t5136 - 0.12e2 * t5140 - 0.8e1 * t5144 + 0.12e2 * t5153 + 0.12e2 * t5157 + 0.12e2 * t5160 + 0.12e2 * t5162;
  t5382 = t1662 * t1663 * t321;
  t5385 = t1728 * t1230;
  t5390 = t1681 * t1251;
  t5399 = t1652 * t1230;
  t5403 = t2759 * params->csk_a;
  t5404 = t1662 * t5403;
  t5412 = t1759 * t1230;
  t5419 = -0.6e1 * t2707 * t3442 + 0.7e1 * t3435 * t2729 - 0.7e1 * t3429 * t5382 - 0.11e2 * t3429 * t5385 - 0.7e1 * t3429 * t5399 + 0.18e2 * t3432 * t5382 - 0.6e1 * t3432 * t5390 + 0.6e1 * t3432 * t5399 - 0.18e2 * t3432 * t5404 + 0.6e1 * t3432 * t5412 - 0.12e2 * t3435 * t5376 - 0.7e1 * t3435 * t5382 + 0.18e2 * t3435 * t5390 - t3435 * t5399 + t3449 * t5399 - 0.3e1 * t3453 * t4099;
  t5430 = t376 * t321;
  t5441 = t1086 * t4942;
  t5443 = t1086 * t4917;
  t5444 = t1079 * t4917;
  t5446 = t1072 * t4917;
  t5447 = t1079 * t4942;
  t5449 = t1068 * t2845;
  t5454 = t1072 * t2802;
  t5456 = -0.12e2 * t1083 * t511 * t1295 * t186 + 0.3e1 * t95 * t5430 * t1964 - 0.3e1 * t3453 * t215 * t5403 - 0.6e1 * t429 * t324 * t3555 - 0.12e2 * t3432 * t2722 - 0.11e2 * t3429 * t2729 - 0.18e2 * t3429 * t5412 + 0.11e2 * t3449 * t5385 + 0.6e1 * t3449 * t5412 - 0.3e1 * t5441 - t5443 + 0.3e1 * t5444 - t5446 + 0.3e1 * t5447 + 0.3e1 * t5449 + 0.3e1 * t5454;
  t5459 = t1079 * t4927;
  t5463 = t1083 * t198 * t1290 * t99;
  t5471 = t1072 * t4927;
  t5475 = t1072 * t523 * t538 * t328;
  t5485 = t1072 * t2749;
  t5494 = -0.6e1 * t3435 * t1656 * t1657 * t321 + 0.11e2 * t2707 * t1656 * t3545 * t512 - 0.18e2 * t334 * t507 * t3495 * t207 - 0.6e1 * t2707 * t3547 + 0.7e1 * t3429 * t5404 + 0.3e1 * t4899 - 0.3e1 * t4907 - 0.4e1 * t5233 - 0.8e1 * t5247 - 0.12e2 * t5250 + 0.3e1 * t5459 + 0.3e1 * t5463 - 0.3e1 * t5471 - 0.2e1 * t5475 + 0.3e1 * t5485;
  t5506 = -t4918 + 0.3e1 * t4920 + 0.3e1 * t4922 - t4924 + 0.3e1 * t4928 + 0.3e1 * t4930 - 0.2e1 * t4932 + 0.3e1 * t4940 - 0.3e1 * t4943 + 0.3e1 * t4955 - 0.12e2 * t5276 - 0.12e2 * t5279 + 0.12e2 * t5281 - t4968 + t4971 + t4974;
  t5513 = 0.4e1 * t1338 + 0.4e1 * t1342 - t1250 - t1344 - t1346 + t1347 + t1269 - t1270 + 0.4e1 * t1351 - 0.4e1 * t1355 - 0.4e1 * t1358 + t1282 + t1283 - t1202 + t1360 - t4841;
  t5516 = t1086 * t5035;
  t5521 = t1079 * t2908;
  t5525 = t2713 * t1130;
  t5536 = 0.6e1 * t3449 * t1747 * t1295 + 0.3e1 * t3592 * t198 * t1295 + 0.3e1 * t183 * t5430 * t1527 + 0.11e2 * t2675 * t1662 * t3495 + 0.6e1 * t2667 * t3596 + t2707 * t3608 + t1362 - t5031 - 0.2e1 * t5036 - 0.3e1 * t5044 - t5055 + t5058 - t5060 - 0.2e1 * t5516 - 0.3e1 * t5521 - t5525;
  t5540 = my_piecewise5(t57, 0, t60, 0, t5359 + t5379 + t5419 + t5456 + t5494 + t5506 + t5513 + t5536);
  t5546 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1301 / 0.12e2 + 0.2e1 * t123 * t1371 + t52 * t5540));
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t5546;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t5552 = t3673 * t126;
  t5562 = t512 * t207 * t126;
  t5563 = t103 * t5562;
  t5582 = 0.18e2 * t4652 * t1348 * t1573 - 0.18e2 * t4655 * t193 * t5552 + 0.18e2 * t4661 * t193 * t5562 - 0.12e2 * t4655 * t439 * t5552 - 0.18e2 * t4658 * t1350 + 0.18e2 * t4648 * t1841 + 0.18e2 * t1887 * t4683 - 0.6e1 * t4648 * t5563 - 0.6e1 * t4658 * t5563 + 0.18e2 * t4661 * t5563 - t330 - t383 - 0.9e1 * t5352 - 0.9e1 * t5355;
  t5586 = -0.18e2 * t4702 * t1916 + t5105 - t5107 - t5109 - t5112 + t5122 + t5137 - t5141 - t5145 + t5154 + t5158 + t5161 + t5163 + 0.9e1 * t5357;
  t5588 = t1652 * t4543;
  t5592 = t1681 * t1938 * t126;
  t5598 = t1747 * t1748 * t126;
  t5605 = t1747 * t1315;
  t5612 = t1728 * t1026;
  t5621 = 0.18e2 * t1936 * t4793 - 0.12e2 * t4702 * t1986 - 0.6e1 * t4716 * t1986 + 0.18e2 * t4702 * t5588 + 0.12e2 * t4702 * t5592 + 0.6e1 * t4702 * t5598 - 0.7e1 * t4707 * t5588 - 0.7e1 * t4707 * t5598 - 0.18e2 * t4707 * t5605 - 0.11e2 * t4707 * t5612 + t4710 * t5598 + 0.6e1 * t4710 * t5605 - 0.12e2 * t4716 * t5592 - t4716 * t5598;
  t5644 = t1382 * t126;
  t5654 = -0.12e2 * t1408 * t511 * t1535 * t126 + 0.3e1 * t95 * t5644 * t1964 + 0.7e1 * t1923 * t4822 - 0.11e2 * t4707 * t1956 + 0.7e1 * t4716 * t1956 - 0.6e1 * t4702 * t2031 - 0.6e1 * t4734 * t2042 - 0.6e1 * t4716 * t2082 - 0.18e2 * t263 * t4751 - 0.3e1 * t4757 * t352 - 0.3e1 * t4757 * t362 + 0.6e1 * t4702 * t5605 + 0.11e2 * t4710 * t5612 - 0.7e1 * t4716 * t5588;
  t5675 = -0.6e1 * t4716 * t1656 * t1657 * t126 + 0.11e2 * t1936 * t4804 - 0.9e1 * t5441 - 0.3e1 * t5443 + 0.9e1 * t5444 - 0.3e1 * t5446 + 0.9e1 * t5447 + 0.9e1 * t5449 + 0.9e1 * t5454 + 0.9e1 * t5459 + 0.9e1 * t5463 - 0.9e1 * t5471 - 0.6e1 * t5475 + 0.9e1 * t5485;
  t5676 = -t5234 - t5248 - t5251 - t5277 - t5280 + t5282 - t4968 + t4971 + t4974 - t1394 - t1396 + t1400 + t1338 + t1342;
  t5678 = -t1159 - t1401 - t1402 + t1403 + t1173 - t1175 + t1351 - t1355 - t1358 + t1410 + t1414 + t1180 + t1192 - t1201;
  t5696 = 0.3e1 * t183 * t5644 * t1527 + 0.6e1 * t4710 * t1747 * t357 + 0.11e2 * t1923 * t4847 + t1936 * t4842 + 0.6e1 * t4702 * t2163 + 0.3e1 * t4860 * t358 - 0.8e1 * t1289 + t1433 + t1435 - t5055 + t5058 - t5060 - 0.6e1 * t5516 - 0.9e1 * t5521 - 0.3e1 * t5525;
  t5700 = my_piecewise5(t57, 0, t60, 0, t5582 + t5586 + t5621 + t5654 + t5675 + t5676 + t5678 + t5696);
  t5706 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1371 / 0.8e1 + t123 * t1438 + t52 * t5700));
  tv4sigmalapl30 = 0.2e1 * rho[0] * t5706;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t5714 = t376 * t376;
  t5715 = t5714 * t207;
  t5719 = t429 * t5715;
  t5722 = t5714 * t186;
  t5723 = t95 * t5722;
  t5727 = t429 * t5722;
  t5733 = t183 * t5722;
  t5752 = 0.18e2 * t5733 * t507 * t528 * t207 - 0.6e1 * t5723 * t1562 - 0.6e1 * t5727 * t1562 + 0.18e2 * t5733 * t1562 + 0.18e2 * t5727 * t1621 - 0.18e2 * t5441 - 0.6e1 * t5443 + 0.18e2 * t5444 - 0.6e1 * t5446 + 0.18e2 * t5447 + 0.18e2 * t5449;
  t5762 = t183 * t5714;
  t5771 = t95 * t5714;
  t5782 = 0.6e1 * t5771 * t1513 + 0.3e1 * t5771 * t1519 - 0.4e1 * t1259 - 0.4e1 * t1264 + 0.4e1 * t1268 - 0.4e1 * t1393 - 0.4e1 * t1395 + 0.4e1 * t1399 - t4968 + t4971 + t4974;
  t5794 = t5714 * t1498;
  t5795 = t429 * t5794;
  t5798 = t183 * t5794;
  t5801 = t1495 * t5794;
  t5818 = -0.12e2 * t5801 * t1653 - 0.6e1 * t5801 * t1658 + 0.11e2 * t5801 * t1673 - 0.11e2 * t5798 * t1678 + 0.18e2 * t5801 * t1682 - 0.6e1 * t5801 * t1686 + 0.7e1 * t5798 * t1701 - 0.18e2 * t5733 * t1715 - 0.11e2 * t5798 * t1729 - 0.12e2 * t5795 * t1765 - 0.6e1 * t5525;
  t5826 = t5714 * t1517;
  t5827 = t183 * t5826;
  t5837 = t95 * t5794;
  t5866 = 0.12e2 * t5795 * t1653 + 0.18e2 * t5795 * t1664 - 0.7e1 * t5798 * t1664 - 0.18e2 * t5795 * t1701 + 0.6e1 * t5795 * t1749 - 0.7e1 * t5798 * t1749 - t5801 * t1749 + t5837 * t1749 - 0.18e2 * t5798 * t1760 + 0.6e1 * t5837 * t1760 - 0.6e1 * t5801 * t1765;
  t5870 = my_piecewise5(t57, 0, t60, 0, t5866 + t5818 + t5782 + t5752 - 0.18e2 * t5521 - 0.12e2 * t5516 + 0.18e2 * t5485 - 0.12e2 * t5475 - 0.18e2 * t5471 + 0.18e2 * t5463 + 0.18e2 * t5459 + 0.18e2 * t5454 + 0.18e2 * t5357 - 0.18e2 * t5355 - 0.18e2 * t5352 + t5058 - t5060 - t5055 + 0.4e1 * t1413 + 0.4e1 * t1409 - 0.9e1 * t1289 + 0.4e1 * t1292 + 0.4e1 * t1285 - t383 - t330 + 0.18e2 * t5727 * t1610 - 0.6e1 * t5795 * t1682 + 0.11e2 * t5837 * t1729 - 0.3e1 * t5827 * t217 - 0.6e1 * t5727 * t1736 - 0.7e1 * t5801 * t1664 + 0.7e1 * t5801 * t1678 - 0.3e1 * t5827 * t200 + 0.6e1 * t5795 * t1760 - 0.12e2 * t5719 * t1585 + 0.11e2 * t5762 * t1530 + 0.3e1 * t5762 * t1527 - 0.18e2 * t5719 * t1556 + 0.18e2 * t183 * t5715 * t1537 - 0.18e2 * t5723 * t511 * t479 + t1495 * t5714 * t1506 + 0.6e1 * t429 * t5714 * t1523 + 0.3e1 * t95 * t5826 * t200 - 0.12e2 * t95 * t5715 * t1721);
  t5876 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1438 / 0.6e1 + t52 * t5870));
  tv4lapl40 = 0.2e1 * rho[0] * t5876;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t59 * t174 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t232 * t125 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t59 * t266 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t278 * t125 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t630, t632, t633, t636, t638, t639;
  double t640, t642, t644, t645, t648, t650, t655, tv2rhosigma0;
  double tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4, t676;
  double t677, t680, t684, t685, t686, t687, t689, t690;
  double t692, t694, t695, t698, t700, t701, t702, t704;
  double t706, t707, t710, t712, t717, tv2rhosigma5, t724, t732;
  double t733, t735, t736, t740, t741, t744, t746, t748;
  double t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1, t774;
  double tv2rholapl2, t786, t787, t789, t790, t794, t795, t798;
  double t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826, t827;
  double t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t843, t846, t847, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t951, t952, t954, t958, t960, t964, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t59 * t174 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t232 * t125 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t59 * t266 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t278 * t125 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t399 * t172 + t163 * t392 * t396 + t379 * t380 * t390 - t409 * t396 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t59 * t416 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t580 * t243 + t234 * t573 * t577 + t560 * t561 * t571 - t590 * t577 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t554 * t125 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t630 = t394 * t395 * t165;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t633 * t172 + t623 * t625 + t628 * t630 + t628 * t640 - t642 * t630 - t642 * t645 - t638);
  t650 = t161 * t266 + t260 * t174 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t8 * t655 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t8 * t664 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t8 * t670 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t695 * t243 + t685 * t687 + t690 * t692 + t690 * t702 - t704 * t692 - t704 * t707 - t700);
  t712 = t113 * t710 + t680 * t125 + t232 * t284 + t278 * t245 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t8 * t717 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t741 * t172 + t623 * t733 + t736 * t630 - t748 * t630 + t736 * t640 - t748 * t645 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t8 * t759 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t8 * t768 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t8 * t774 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t795 * t243 + t685 * t787 + t790 * t692 - t802 * t692 + t790 * t702 - t802 * t707 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t820 * t396 + t379 * t817 * t390 - t830 * t396 + t827 * t407 - t830 * t413 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t847 = t234 * t846;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t560 * t843 * t571 + t847 * t577 - t856 * t577 + t853 * t588 - t856 * t594 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t922 * t390 + t926 * t396 - t931 * t396 + t928 * t407 - t931 * t413 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t234 * t948 * t577 + t560 * t945 * t571 - t954 * t577 + t951 * t588 - t954 * t594 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t630, t632, t633, t636, t638, t639;
  double t640, t642, t644, t645, t648, t650, t655, tv2rhosigma0;
  double tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4, t676;
  double t677, t680, t684, t685, t686, t687, t689, t690;
  double t692, t694, t695, t698, t700, t701, t702, t704;
  double t706, t707, t710, t712, t717, tv2rhosigma5, t724, t732;
  double t733, t735, t736, t740, t741, t744, t746, t748;
  double t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1, t774;
  double tv2rholapl2, t786, t787, t789, t790, t794, t795, t798;
  double t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826, t827;
  double t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t843, t846, t847, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t951, t952, t954, t958, t960, t964, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t968, t969, t972, t975, t976, t977, t980, t984;
  double t985, t989, t991, t996, t998, t1001, t1007, t1008;
  double t1011, t1013, t1016, t1020, t1023, t1030, t1036, t1037;
  double t1039, t1040, t1041, t1045, t1046, t1047, t1048, t1050;
  double t1051, t1052, t1055, t1056, t1057, t1058, t1059, t1061;
  double t1065, t1066, t1068, t1069, t1070, t1073, t1074, t1079;
  double t1083, t1087, t1088, t1091, t1092, t1097, t1098, t1102;
  double t1104, t1105, t1106, t1109, t1110, t1111, t1113, t1114;
  double t1118, t1122, t1126, t1127, t1128, t1130, t1133, t1135;
  double t1136, t1139, t1140, t1145, t1147, t1148, t1149, t1151;
  double t1153, t1155, t1160, t1162, t1163, t1166, t1169, t1172;
  double t1176, t1177, t1181, t1183, t1185, t1187, t1189, t1192;
  double t1194, tv3rho30, t1197, t1198, t1199, t1202, t1207, t1208;
  double t1210, t1214, t1215, t1219, t1222, t1226, t1228, t1232;
  double t1241, t1242, t1243, t1246, t1251, t1253, t1257, t1258;
  double t1262, t1265, t1266, t1268, t1277, t1279, t1282, tv3rho31;
  double t1285, t1290, t1294, t1298, t1299, t1303, t1305, t1314;
  double t1315, t1320, t1324, t1328, t1329, t1333, t1335, t1342;
  double t1350, t1352, t1353, tv3rho32, t1358, t1365, t1369, t1370;
  double t1377, t1378, t1385, t1389, t1390, t1407, t1410, t1417;
  double t1425, t1426, t1427, t1428, t1429, t1431, t1432, t1433;
  double t1436, t1437, t1438, t1439, t1441, t1445, t1446, t1449;
  double t1450, t1452, t1453, t1454, t1457, t1461, t1462, t1467;
  double t1469, t1471, t1472, t1477, t1479, t1480, t1481, t1483;
  double t1484, t1488, t1490, t1491, t1492, t1495, t1496, t1497;
  double t1499, t1500, t1504, t1508, t1512, t1513, t1516, t1519;
  double t1521, t1522, t1526, t1528, t1529, t1530, t1533, t1534;
  double t1535, t1537, t1539, t1541, t1546, tv3rho33, t1554, t1561;
  double t1563, t1566, t1567, t1570, t1578, t1579, t1582, t1583;
  double t1584, t1587, t1589, t1591, t1593, t1594, t1595, t1598;
  double t1599, t1602, t1603, t1604, t1605, t1608, t1609, t1612;
  double t1613, t1616, t1617, t1619, t1620, t1623, t1624, t1626;
  double t1627, t1633, t1634, t1638, t1639, t1642, t1647, t1649;
  double t1656, t1657, t1658, t1659, t1661, t1664, t1665, t1667;
  double t1668, t1674, t1675, t1676, t1678, t1680, t1681, t1682;
  double t1684, t1685, t1686, t1688, t1690, t1692, t1697, tv3rho2sigma0;
  double tv3rho2sigma1, t1704, t1708, t1710, tv3rho2sigma2, t1716, t1724, tv3rho2sigma3;
  double tv3rho2sigma4, t1730, t1737, t1740, tv3rho2sigma5, t1748, tv3rho2sigma6, tv3rho2sigma7;
  double t1760, t1761, t1764, t1773, t1774, t1777, t1778, t1779;
  double t1782, t1784, t1786, t1788, t1789, t1790, t1792, t1793;
  double t1794, t1795, t1798, t1799, t1802, t1803, t1806, t1807;
  double t1810, t1811, t1812, t1815, t1816, t1822, t1823, t1824;
  double t1825, t1828, t1829, t1833, t1834, t1841, t1843, t1849;
  double t1852, t1853, t1856, t1857, t1858, t1859, t1864, t1865;
  double t1867, t1868, t1869, t1871, t1872, t1873, t1875, t1876;
  double t1877, t1879, t1881, t1883, t1885, t1890, tv3rho2sigma8, t1897;
  double t1904, t1906, t1920, t1922, t1925, t1926, t1929, t1930;
  double t1932, t1935, t1936, t1939, t1940, t1943, t1945, t1949;
  double t1950, t1953, t1956, t1961, t1962, t1966, t1969, t1971;
  double t1972, t1973, t1975, t1977, t1985, t1986, t1989, t1990;
  double t1991, t1993, t2001, t2002, t2007, t2009, t2011, t2016;
  double tv3rho2lapl0, t2023, t2027, t2029, tv3rho2lapl1, t2035, t2043, tv3rho2lapl2;
  double t2049, t2056, t2059, tv3rho2lapl3, t2067, tv3rho2lapl4, t2090, t2091;
  double t2096, t2097, t2100, t2101, t2103, t2105, t2107, t2109;
  double t2110, t2113, t2114, t2119, t2120, t2124, t2125, t2126;
  double t2128, t2129, t2130, t2131, t2133, t2135, t2138, t2141;
  double t2146, t2147, t2153, t2155, t2156, t2157, t2160, t2162;
  double t2163, t2177, t2179, t2181, t2186, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1;
  double tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2193, t2199, t2200, t2201;
  double t2202, t2204, t2205, t2206, t2207, t2209, t2210, t2211;
  double t2212, t2213, t2215, t2216, t2217, t2220, t2221, t2222;
  double t2223, t2226, t2227, t2228, t2229, t2230, t2235, t2237;
  double t2238, t2239, t2240, t2242, t2244, t2245, t2246, t2247;
  double t2249, t2250, t2251, t2253, t2254, t2257, t2258, t2259;
  double t2260, t2262, t2263, t2265, t2266, t2269, t2270, t2274;
  double t2279, t2280, t2282, t2283, t2290, t2291, t2294, t2295;
  double t2298, t2299, t2300, t2301, t2303, t2304, t2309, t2311;
  double t2313, t2318, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2325;
  double t2327, tv3rhosigma25, t2333, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2343, t2344, t2345, t2348, t2349, t2350, t2353, t2354;
  double t2355, t2356, t2357, t2358, t2359, t2361, t2362, t2363;
  double t2364, t2366, t2367, t2368, t2369, t2370, t2372, t2373;
  double t2374, t2379, t2381, t2382, t2383, t2384, t2386, t2388;
  double t2389, t2390, t2391, t2393, t2394, t2395, t2397, t2398;
  double t2399, t2402, t2403, t2406, t2407, t2408, t2411, t2412;
  double t2413, t2415, t2416, t2418, t2421, t2422, t2427, t2428;
  double t2430, t2431, t2440, t2441, t2444, t2445, t2448, t2449;
  double t2450, t2451, t2453, t2455, t2457, t2462, tv3rhosigma211, t2469;
  double t2483, t2485, t2486, t2488, t2489, t2490, t2492, t2493;
  double t2495, t2496, t2498, t2500, t2501, t2502, t2504, t2505;
  double t2507, t2508, t2509, t2510, t2511, t2514, t2515, t2516;
  double t2517, t2519, t2520, t2521, t2524, t2527, t2528, t2529;
  double t2530, t2531, t2532, t2535, t2536, t2541, t2544, t2551;
  double t2552, t2558, t2559, t2563, t2566, t2568, t2570, t2575;
  double tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2582, t2584, tv3rhosigmalapl5;
  double t2590, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2606, t2608;
  double t2609, t2611, t2614, t2615, t2616, t2617, t2618, t2621;
  double t2622, t2624, t2625, t2627, t2629, t2631, t2632, t2634;
  double t2635, t2636, t2637, t2638, t2641, t2642, t2643, t2644;
  double t2645, t2648, t2649, t2651, t2652, t2655, t2656, t2659;
  double t2662, t2666, t2670, t2674, t2677, t2678, t2685, t2686;
  double t2690, t2692, t2694, t2699, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double tv3rhosigmatau11, t2706, t2714, t2720, t2721, t2723, t2724, t2726;
  double t2727, t2728, t2729, t2732, t2735, t2737, t2738, t2740;
  double t2742, t2743, t2745, t2747, t2750, t2751, t2754, t2757;
  double t2758, t2774, t2780, t2781, t2783, t2785, t2787, t2792;
  double tv3rholapl20, tv3rholapl21, t2799, t2801, tv3rholapl22, t2807, tv3rholapl23, tv3rholapl24;
  double t2821, t2822, t2824, t2825, t2826, t2828, t2829, t2833;
  double t2834, t2837, t2840, t2842, t2843, t2845, t2847, t2848;
  double t2850, t2852, t2856, t2864, t2870, t2871, t2876, t2881;
  double t2882, t2888, t2890, t2892, t2897, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21;
  double tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2901, t2902, t2903, t2906;
  double t2911, t2912, t2915, t2918, t2920, t2921, t2922, t2923;
  double t2924, t2925, t2926, t2927, t2928, t2930, t2931, t2937;
  double t2949, t2950, t2951, t2952, t2953, t2954, t2955, t2956;
  double t2957, t2958, t2959, t2961, t2962, t2963, t2964, t2965;
  double t2967, t2969, t2973, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2976, t2977, t2978, t2981;
  double t2986, t2987, t2990, t2993, t2995, t2996, t2997, t2998;
  double t2999, t3000, t3001, t3003, t3004, t3005, t3006, t3012;
  double t3024, t3025, t3026, t3027, t3028, t3029, t3030, t3031;
  double t3032, t3033, t3034, t3036, t3037, t3038, t3039, t3040;
  double t3042, t3044, t3048, tv3sigma39, t3054, t3055, t3060, t3061;
  double t3062, t3063, t3065, t3067, t3068, t3069, t3070, t3071;
  double t3072, t3073, t3074, t3075, t3076, t3077, t3078, t3079;
  double t3080, t3081, t3082, t3085, t3086, t3088, t3092, t3093;
  double t3096, t3097, t3098, t3102, t3103, t3108, t3111, t3112;
  double t3113, t3114, t3115, t3118, t3119, t3120, t3121, t3122;
  double t3123, t3124, t3126, t3128, t3132, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double t3138, t3139, t3144, t3145, t3146, t3147, t3151, t3152;
  double t3153, t3154, t3155, t3156, t3157, t3158, t3159, t3160;
  double t3161, t3162, t3163, t3164, t3165, t3166, t3168, t3169;
  double t3174, t3178, t3183, t3186, t3189, t3190, t3191, t3192;
  double t3193, t3198, t3201, t3202, t3203, t3204, t3205, t3206;
  double t3207, t3208, t3209, t3211, t3213, t3217, tv3sigma2lapl11, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3228, t3229, t3230, t3231, t3232;
  double t3234, t3235, t3236, t3238, t3239, t3241, t3242, t3243;
  double t3246, t3248, t3256, t3260, t3261, t3266, t3267, t3270;
  double t3271, t3274, t3275, t3276, t3277, t3279, t3281, t3285;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double t3296, t3297, t3298, t3299, t3300, t3302, t3303, t3304;
  double t3306, t3307, t3309, t3310, t3311, t3315, t3316, t3319;
  double t3320, t3323, t3324, t3332, t3340, t3341, t3342, t3343;
  double t3344, t3345, t3347, t3349, t3353, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1;
  double tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9;
  double tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3357, t3358, t3359, t3360, t3369;
  double t3371, t3372, t3373, t3374, t3375, t3376, t3377, t3378;
  double t3379, t3380, t3381, t3382, t3383, t3384, t3391, t3394;
  double t3395, t3396, t3398, t3399, t3400, t3411, t3413, t3415;
  double t3419, tv3lapl30, tv3lapl31, tv3lapl32, t3423, t3424, t3425, t3426;
  double t3435, t3436, t3437, t3438, t3439, t3441, t3442, t3443;
  double t3444, t3445, t3446, t3447, t3448, t3449, t3450, t3453;
  double t3463, t3464, t3465, t3466, t3467, t3468, t3477, t3479;
  double t3481, t3485, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30;
  double tv3tau31, tv3tau32, tv3tau33;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t59 * t174 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t232 * t125 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t59 * t266 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t278 * t125 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t399 * t172 + t163 * t392 * t396 + t379 * t380 * t390 - t409 * t396 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t59 * t416 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t580 * t243 + t234 * t573 * t577 + t560 * t561 * t571 - t590 * t577 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t554 * t125 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t630 = t394 * t395 * t165;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t633 * t172 + t623 * t625 + t628 * t630 + t628 * t640 - t642 * t630 - t642 * t645 - t638);
  t650 = t161 * t266 + t260 * t174 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t8 * t655 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t8 * t664 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t8 * t670 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t695 * t243 + t685 * t687 + t690 * t692 + t690 * t702 - t704 * t692 - t704 * t707 - t700);
  t712 = t113 * t710 + t680 * t125 + t232 * t284 + t278 * t245 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t8 * t717 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t741 * t172 + t623 * t733 + t736 * t630 - t748 * t630 + t736 * t640 - t748 * t645 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t8 * t759 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t8 * t768 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t8 * t774 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t795 * t243 + t685 * t787 + t790 * t692 - t802 * t692 + t790 * t702 - t802 * t707 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t820 * t396 + t379 * t817 * t390 - t830 * t396 + t827 * t407 - t830 * t413 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t847 = t234 * t846;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t560 * t843 * t571 + t847 * t577 - t856 * t577 + t853 * t588 - t856 * t594 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t922 * t390 + t926 * t396 - t931 * t396 + t928 * t407 - t931 * t413 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t234 * t948 * t577 + t560 * t945 * t571 - t954 * t577 + t951 * t588 - t954 * t594 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t968 = 0.1e1 / t26 / t21;
  t969 = t328 * t136;
  t972 = t327 * t136;
  t975 = t132 * t132;
  t976 = 0.1e1 / t975;
  t977 = t18 * t976;
  t980 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t332 - 0.6e1 * t977);
  t984 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t969 + 0.1e2 / 0.3e1 * t972 * t336 + 0.5e1 / 0.3e1 * t27 * t980);
  t985 = t984 * t31;
  t989 = t340 * t144;
  t991 = t7 * t989 * t79;
  t996 = t139 * t353;
  t998 = t7 * t996 * t79;
  t1001 = t7 * t345 * t176;
  t1007 = 0.1e1 / t30 / t132;
  t1008 = t29 * t1007;
  t1011 = 0.2e1 / 0.45e2 * t7 * t1008 * t79;
  t1013 = t7 * t354 * t176;
  t1016 = t7 * t145 * t418;
  t1020 = 0.1e1 / t41 / t361 / rho[0];
  t1023 = 0.77e3 / 0.243e3 * t38 * sigma[0] * t1020;
  t1030 = -0.154e3 / 0.81e2 * t47 * t48 * t1020 - 0.55e2 / 0.81e2 * t52 * t53 * t363 + t1023;
  t1036 = t380 * t165;
  t1037 = t1036 * t167;
  t1039 = t388 * t403;
  t1040 = t411 * t1039;
  t1041 = t379 * t1037 * t1040;
  t1045 = t76 / t377 / t72;
  t1046 = t382 * t167;
  t1047 = t1036 * t1046;
  t1048 = t1045 * t1047;
  t1050 = 0.1e1 / t383 / t71;
  t1051 = t1050 * t386;
  t1052 = t1051 * t412;
  t1055 = t163 * t1047;
  t1056 = t1050 * t74;
  t1057 = params->csk_a * params->csk_a;
  t1058 = t170 * t1057;
  t1059 = t1056 * t1058;
  t1061 = t379 * t1047;
  t1065 = t386 * t74;
  t1066 = t1050 * t1065;
  t1068 = 0.1e1 / t387 / t75;
  t1069 = t1068 * t1057;
  t1070 = t1066 * t1069;
  t1073 = t388 * t1057;
  t1074 = t1051 * t1073;
  t1079 = t163 * t399 * t165 * t405;
  t1083 = t388 * t399;
  t1087 = t1068 * params->csk_a;
  t1088 = t1066 * t1087;
  t1091 = t1050 * params->csk_a;
  t1092 = t1091 * t171;
  t1097 = 0.3e1 * t623 * t411 * t1083 + 0.3e1 * t1048 * t1052 - t1048 * t1059 - 0.2e1 * t1048 * t1070 - 0.3e1 * t1048 * t1074 + 0.3e1 * t1048 * t1088 - t1055 * t1059 - 0.3e1 * t1055 * t1092 + 0.3e1 * t1061 * t1059 + 0.3e1 * t1061 * t1074 + 0.3e1 * t1061 * t1092 + 0.3e1 * t1041 - 0.3e1 * t1079;
  t1098 = t399 * t382;
  t1102 = t1036 * t403;
  t1104 = t170 * t167;
  t1105 = t394 * t1104;
  t1106 = t163 * t1102 * t1105;
  t1109 = t1046 * t1050;
  t1110 = t1065 * t1068;
  t1111 = t1109 * t1110;
  t1113 = my_piecewise3(t67, 0, t1030);
  t1114 = my_piecewise3(t69, t1113, 0);
  t1118 = t1109 * t171;
  t1122 = t1109 * t389;
  t1126 = t395 * t403;
  t1127 = t394 * t1126;
  t1128 = t163 * t1037 * t1127;
  t1130 = t379 * t1098;
  t1133 = t379 * t1102;
  t1135 = t411 * t412 * t167;
  t1136 = t1133 * t1135;
  t1139 = t395 * t399;
  t1140 = t394 * t1139;
  t1145 = t384 * params->csk_a;
  t1147 = t167 * t74 * t170;
  t1148 = t1145 * t1147;
  t1149 = t1133 * t1148;
  t1151 = -t1045 * t1036 * t1111 - 0.2e1 * t163 * t1036 * t1118 - 0.3e1 * t379 * t1036 * t1122 + 0.3e1 * t163 * t1098 * t640 - t163 * t1114 * t172 + 0.3e1 * t163 * t622 * t1140 - 0.3e1 * t1130 * t630 - 0.3e1 * t1130 * t645 + 0.3e1 * t1106 + 0.3e1 * t1128 - 0.3e1 * t1136 - 0.3e1 * t1149 - t406;
  t1153 = my_piecewise5(t64, 0, t67, 0, t1097 + t1151);
  t1155 = t1030 * t77 + t59 * t1153 + 0.3e1 * t161 * t416 + 0.3e1 * t373 * t174 - t1023;
  t1160 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t79 + 0.3e1 / 0.1e2 * t991 + 0.9e1 / 0.2e2 * t7 * t341 * t176 - t998 / 0.1e2 + 0.3e1 / 0.5e1 * t1001 + 0.9e1 / 0.2e2 * t7 * t140 * t418 + t1011 - t1013 / 0.1e2 + 0.3e1 / 0.1e2 * t1016 + 0.3e1 / 0.2e2 * t7 * t32 * t1155);
  t1162 = 0.1e1 / t90 / t88;
  t1163 = t425 * t184;
  t1166 = t424 * t184;
  t1169 = t85 * t976;
  t1172 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t332 - 0.6e1 * t1169);
  t1176 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1162 * t1163 + 0.1e2 / 0.3e1 * t1166 * t431 + 0.5e1 / 0.3e1 * t91 * t1172);
  t1177 = t1176 * t31;
  t1181 = t435 * t144;
  t1183 = t7 * t1181 * t127;
  t1185 = t187 * t353;
  t1187 = t7 * t1185 * t127;
  t1189 = t93 * t1007;
  t1192 = 0.2e1 / 0.45e2 * t7 * t1189 * t127;
  t1194 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1177 * t127 + 0.3e1 / 0.1e2 * t1183 - t1187 / 0.1e2 + t1192);
  tv3rho30 = 0.3e1 * t423 + 0.3e1 * t449 + t8 * (t1160 + t1194);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1197 = 0.2e1 * t475;
  t1198 = 0.2e1 * t501;
  t1199 = t968 * t201;
  t1202 = t327 * t456;
  t1207 = 0.2e1 * t332;
  t1208 = 0.6e1 * t977;
  t1210 = my_piecewise5(t12, 0, t16, 0, t1207 - t1208);
  t1214 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1199 * t328 + 0.2e2 / 0.9e1 * t1202 * t136 + 0.1e2 / 0.9e1 * t452 * t336 + 0.5e1 / 0.3e1 * t27 * t1210);
  t1215 = t1214 * t31;
  t1219 = t460 * t144;
  t1222 = t7 * t1219 * t79 / 0.5e1;
  t1226 = t204 * t353;
  t1228 = t7 * t1226 * t79;
  t1232 = t7 * t465 * t176 / 0.5e1;
  t1241 = 0.3e1 / 0.2e2 * t7 * t1215 * t79 + t1222 + 0.3e1 / 0.1e2 * t7 * t461 * t176 - t1228 / 0.3e2 + t1232 + 0.3e1 / 0.2e2 * t7 * t205 * t418 + t991 / 0.1e2 - t998 / 0.15e2 + t1001 / 0.5e1 + t1011 - t1013 / 0.15e2 + t1016 / 0.1e2;
  t1242 = my_piecewise3(t2, 0, t1241);
  t1243 = t1162 * t212;
  t1246 = t424 * t480;
  t1251 = 0.6e1 * t1169;
  t1253 = my_piecewise5(t16, 0, t12, 0, -t1207 - t1251);
  t1257 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1243 * t425 + 0.2e2 / 0.9e1 * t1246 * t184 + 0.1e2 / 0.9e1 * t476 * t431 + 0.5e1 / 0.3e1 * t91 * t1253);
  t1258 = t1257 * t31;
  t1262 = t484 * t144;
  t1265 = t7 * t1262 * t127 / 0.5e1;
  t1266 = t215 * t353;
  t1268 = t7 * t1266 * t127;
  t1277 = t7 * t440 * t247 / 0.5e1;
  t1279 = t7 * t444 * t247;
  t1282 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1258 * t127 + t1265 - t1268 / 0.3e2 + t1183 / 0.1e2 - t1187 / 0.15e2 + t1192 + 0.3e1 / 0.2e2 * t7 * t436 * t247 + t1277 - t1279 / 0.3e2);
  tv3rho31 = t423 + t449 + t1197 + t1198 + t8 * (t1242 + t1282);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1285 = t968 * t506;
  t1290 = t327 * t511;
  t1294 = my_piecewise5(t12, 0, t16, 0, -t1207 - t1208);
  t1298 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1285 * t136 + 0.2e2 / 0.9e1 * t452 * t456 + 0.1e2 / 0.9e1 * t1290 * t136 + 0.5e1 / 0.3e1 * t27 * t1294);
  t1299 = t1298 * t31;
  t1303 = t515 * t144;
  t1305 = t7 * t1303 * t79;
  t1314 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1299 * t79 + t1305 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t176 + t1222 - t1228 / 0.15e2 + t1232 - t998 / 0.3e2 + t1011 - t1013 / 0.3e2);
  t1315 = t1162 * t523;
  t1320 = t424 * t528;
  t1324 = my_piecewise5(t16, 0, t12, 0, t1207 - t1251);
  t1328 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1315 * t184 + 0.2e2 / 0.9e1 * t476 * t480 + 0.1e2 / 0.9e1 * t1320 * t184 + 0.5e1 / 0.3e1 * t91 * t1324);
  t1329 = t1328 * t31;
  t1333 = t532 * t144;
  t1335 = t7 * t1333 * t127;
  t1342 = t7 * t489 * t247;
  t1350 = t7 * t192 * t599;
  t1352 = 0.3e1 / 0.2e2 * t7 * t1329 * t127 + t1335 / 0.1e2 + t1265 - t1268 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t247 + t1342 / 0.5e1 - t1187 / 0.3e2 + t1192 + t1277 - t1279 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t599 + t1350 / 0.1e2;
  t1353 = my_piecewise3(t84, 0, t1352);
  tv3rho32 = t1197 + t1198 + t522 + t604 + t8 * (t1314 + t1353);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1358 = t506 * t201;
  t1365 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t332 - 0.6e1 * t977);
  t1369 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t1358 + 0.1e2 / 0.3e1 * t452 * t511 + 0.5e1 / 0.3e1 * t27 * t1365);
  t1370 = t1369 * t31;
  t1377 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1370 * t79 + 0.3e1 / 0.1e2 * t1305 - t1228 / 0.1e2 + t1011);
  t1378 = t523 * t212;
  t1385 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t332 - 0.6e1 * t1169);
  t1389 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1162 * t1378 + 0.1e2 / 0.3e1 * t476 * t528 + 0.5e1 / 0.3e1 * t91 * t1385);
  t1390 = t1389 * t31;
  t1407 = 0.1e1 / t97 / t542 / rho[1];
  t1410 = 0.77e3 / 0.243e3 * t38 * sigma[2] * t1407;
  t1417 = -0.154e3 / 0.81e2 * t47 * t103 * t1407 - 0.55e2 / 0.81e2 * t52 * t107 * t544 + t1410;
  t1425 = t124 / t558 / t120;
  t1426 = t561 * t236;
  t1427 = t563 * t238;
  t1428 = t1426 * t1427;
  t1429 = t1425 * t1428;
  t1431 = 0.1e1 / t564 / t119;
  t1432 = t1431 * t567;
  t1433 = t1432 * t593;
  t1436 = t234 * t1428;
  t1437 = t1431 * t122;
  t1438 = t241 * t1057;
  t1439 = t1437 * t1438;
  t1441 = t560 * t1428;
  t1445 = t1431 * t1057;
  t1446 = t1445 * t570;
  t1449 = t567 * t122;
  t1450 = t1431 * t1449;
  t1452 = 0.1e1 / t568 / t123;
  t1453 = t1452 * t1057;
  t1454 = t1450 * t1453;
  t1457 = t569 * t580;
  t1461 = t1452 * params->csk_a;
  t1462 = t1450 * t1461;
  t1467 = t580 * t236;
  t1469 = t234 * t1467 * t586;
  t1471 = t1431 * params->csk_a;
  t1472 = t1471 * t242;
  t1477 = t1426 * t238;
  t1479 = t569 * t584;
  t1480 = t592 * t1479;
  t1481 = t560 * t1477 * t1480;
  t1483 = 0.3e1 * t685 * t592 * t1457 + 0.3e1 * t1429 * t1433 - t1429 * t1439 - 0.3e1 * t1429 * t1446 - 0.2e1 * t1429 * t1454 + 0.3e1 * t1429 * t1462 - t1436 * t1439 - 0.3e1 * t1436 * t1472 + 0.3e1 * t1441 * t1439 + 0.3e1 * t1441 * t1446 + 0.3e1 * t1441 * t1472 - 0.3e1 * t1469 + 0.3e1 * t1481;
  t1484 = t580 * t563;
  t1488 = t1426 * t584;
  t1490 = t241 * t238;
  t1491 = t575 * t1490;
  t1492 = t234 * t1488 * t1491;
  t1495 = t1427 * t1431;
  t1496 = t1449 * t1452;
  t1497 = t1495 * t1496;
  t1499 = my_piecewise3(t115, 0, t1417);
  t1500 = my_piecewise3(t117, t1499, 0);
  t1504 = t1495 * t570;
  t1508 = t1495 * t242;
  t1512 = t576 * t580;
  t1513 = t575 * t1512;
  t1516 = t560 * t1484;
  t1519 = t560 * t1488;
  t1521 = t592 * t593 * t238;
  t1522 = t1519 * t1521;
  t1526 = t565 * params->csk_a;
  t1528 = t238 * t122 * t241;
  t1529 = t1526 * t1528;
  t1530 = t1519 * t1529;
  t1533 = t576 * t584;
  t1534 = t575 * t1533;
  t1535 = t234 * t1477 * t1534;
  t1537 = -t1425 * t1426 * t1497 - 0.3e1 * t560 * t1426 * t1504 - 0.2e1 * t234 * t1426 * t1508 + 0.3e1 * t234 * t1484 * t702 - t234 * t1500 * t243 + 0.3e1 * t234 * t684 * t1513 - 0.3e1 * t1516 * t692 - 0.3e1 * t1516 * t707 + 0.3e1 * t1492 - 0.3e1 * t1522 - 0.3e1 * t1530 + 0.3e1 * t1535 - t587;
  t1539 = my_piecewise5(t114, 0, t115, 0, t1483 + t1537);
  t1541 = t113 * t1539 + t1417 * t125 + 0.3e1 * t232 * t597 + 0.3e1 * t554 * t245 - t1410;
  t1546 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1390 * t127 + 0.3e1 / 0.1e2 * t1335 + 0.9e1 / 0.2e2 * t7 * t533 * t247 - t1268 / 0.1e2 + 0.3e1 / 0.5e1 * t1342 + 0.9e1 / 0.2e2 * t7 * t216 * t599 + t1192 - t1279 / 0.1e2 + 0.3e1 / 0.1e2 * t1350 + 0.3e1 / 0.2e2 * t7 * t94 * t1541);
  tv3rho33 = 0.3e1 * t522 + 0.3e1 * t604 + t8 * (t1377 + t1546);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1554 = t7 * t345 * t268;
  t1561 = t7 * t354 * t268 / 0.3e2;
  t1563 = t7 * t145 * t650;
  t1566 = 0.55e2 / 0.81e2 * t38 * t363;
  t1567 = t37 * t363;
  t1570 = 0.11e2 / 0.27e2 * t47 * t1567 - t1566;
  t1578 = t388 * t633;
  t1579 = t411 * t1578;
  t1582 = t380 * t1046;
  t1583 = t1045 * t1582;
  t1584 = t1068 * t263;
  t1587 = t633 * t165;
  t1589 = t163 * t1587 * t405;
  t1591 = t263 * t399;
  t1593 = t163 * t1591 * t405;
  t1594 = t170 * t399;
  t1595 = t394 * t1594;
  t1598 = t379 * t1582;
  t1599 = t1051 * t624;
  t1602 = t263 * t1046;
  t1603 = t163 * t1602;
  t1604 = t170 * t380;
  t1605 = t1056 * t1604;
  t1608 = t633 * t382;
  t1609 = t163 * t1608;
  t1612 = my_piecewise3(t67, 0, t1570);
  t1613 = my_piecewise3(t69, t1612, 0);
  t1616 = t1045 * t1602;
  t1617 = t1050 * t1057;
  t1619 = t380 * t386 * t388;
  t1620 = t1617 * t1619;
  t1623 = t412 * t399;
  t1624 = t411 * t1623;
  t1626 = t1584 * params->csk_a;
  t1627 = t1066 * t1626;
  t1633 = -t1583 * t1066 * t1584 - t163 * t1613 * t172 + t1130 * t625 + t628 * t1140 + 0.2e1 * t623 * t1579 + 0.3e1 * t1583 * t1627 + t628 * t1595 - 0.3e1 * t1598 * t1599 - 0.2e1 * t1603 * t1605 + 0.2e1 * t1609 * t630 + 0.2e1 * t1609 * t640 - 0.3e1 * t1616 * t1620 - t642 * t1624 - 0.2e1 * t1589 - t1593 - t638;
  t1634 = t379 * t1602;
  t1638 = t380 * t74 * t170;
  t1639 = t1091 * t1638;
  t1642 = t379 * t1608;
  t1647 = t1617 * t1638;
  t1649 = t1051 * t882;
  t1656 = t379 * t380 * t167;
  t1657 = t624 * t403;
  t1658 = t411 * t1657;
  t1659 = t1656 * t1658;
  t1661 = t263 * t380;
  t1664 = t403 * t384 * t1147;
  t1665 = t163 * t1661 * t1664;
  t1667 = t1069 * t380;
  t1668 = t1066 * t1667;
  t1674 = t1661 * t403;
  t1675 = t379 * t1674;
  t1676 = t1675 * t1135;
  t1678 = t1675 * t1148;
  t1680 = t263 * t167;
  t1681 = t1680 * t384;
  t1682 = t163 * t1681;
  t1684 = params->csk_a * t380 * t403;
  t1685 = t171 * t1684;
  t1686 = t1682 * t1685;
  t1688 = -t642 * t1140 + 0.3e1 * t1583 * t1649 - 0.3e1 * t1603 * t1639 - t1603 * t1647 - t1616 * t1647 - 0.2e1 * t1616 * t1668 + 0.3e1 * t1634 * t1620 + 0.3e1 * t1634 * t1639 + 0.3e1 * t1634 * t1647 - 0.2e1 * t1642 * t630 - 0.2e1 * t1642 * t645 + 0.3e1 * t1659 + 0.3e1 * t1665 - 0.3e1 * t1676 - 0.3e1 * t1678 + 0.3e1 * t1686;
  t1690 = my_piecewise5(t64, 0, t67, 0, t1633 + t1688);
  t1692 = t1570 * t77 + 0.2e1 * t161 * t648 + t59 * t1690 + 0.2e1 * t618 * t174 + t260 * t416 + t373 * t266 + t1566;
  t1697 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t268 + t1554 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t650 - t1561 + t1563 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1692);
  tv3rho2sigma0 = t8 * t1697 + 0.2e1 * t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1704 = t7 * t440 * t286;
  t1708 = t7 * t444 * t286 / 0.3e2;
  t1710 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t286 + t1704 / 0.5e1 - t1708);
  tv3rho2sigma2 = t8 * t1710 + 0.2e1 * t664;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1716 = t7 * t465 * t268;
  t1724 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t268 + t1716 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t650 + t1554 / 0.1e2 - t1561 + t1563 / 0.1e2);
  tv3rho2sigma3 = t8 * t1724 + t655 + t670;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1730 = t7 * t489 * t286;
  t1737 = t7 * t192 * t712;
  t1740 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t286 + t1730 / 0.1e2 + t1704 / 0.1e2 - t1708 + 0.3e1 / 0.2e2 * t7 * t188 * t712 + t1737 / 0.1e2);
  tv3rho2sigma5 = t8 * t1740 + t664 + t717;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1748 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t268 + t1716 / 0.5e1 - t1561);
  tv3rho2sigma6 = t8 * t1748 + 0.2e1 * t670;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1760 = 0.55e2 / 0.81e2 * t38 * t544;
  t1761 = t37 * t544;
  t1764 = 0.11e2 / 0.27e2 * t47 * t1761 - t1760;
  t1773 = t569 * t695;
  t1774 = t592 * t1773;
  t1777 = t561 * t1427;
  t1778 = t1425 * t1777;
  t1779 = t1452 * t281;
  t1782 = t695 * t236;
  t1784 = t234 * t1782 * t586;
  t1786 = t281 * t580;
  t1788 = t234 * t1786 * t586;
  t1789 = t241 * t580;
  t1790 = t575 * t1789;
  t1792 = t281 * t1427;
  t1793 = t234 * t1792;
  t1794 = t241 * t561;
  t1795 = t1437 * t1794;
  t1798 = t560 * t1777;
  t1799 = t1432 * t686;
  t1802 = t695 * t563;
  t1803 = t234 * t1802;
  t1806 = my_piecewise3(t115, 0, t1764);
  t1807 = my_piecewise3(t117, t1806, 0);
  t1810 = t1425 * t1792;
  t1811 = t1453 * t561;
  t1812 = t1450 * t1811;
  t1815 = t1779 * params->csk_a;
  t1816 = t1450 * t1815;
  t1822 = t560 * t1792;
  t1823 = t569 * t1057;
  t1824 = t1823 * t561;
  t1825 = t1432 * t1824;
  t1828 = -t1778 * t1450 * t1779 - t234 * t1807 * t243 + t690 * t1513 + t1516 * t687 + 0.2e1 * t685 * t1774 + 0.3e1 * t1778 * t1816 + t690 * t1790 - 0.2e1 * t1793 * t1795 - 0.3e1 * t1798 * t1799 + 0.2e1 * t1803 * t692 + 0.2e1 * t1803 * t702 - 0.2e1 * t1810 * t1812 + 0.3e1 * t1822 * t1825 - 0.2e1 * t1784 - t1788 - t700;
  t1829 = t560 * t1802;
  t1833 = t561 * t122 * t241;
  t1834 = t1471 * t1833;
  t1841 = t1445 * t1833;
  t1843 = t1432 * t908;
  t1849 = t281 * t561;
  t1852 = t584 * t565 * t1528;
  t1853 = t234 * t1849 * t1852;
  t1856 = t560 * t561 * t238;
  t1857 = t686 * t584;
  t1858 = t592 * t1857;
  t1859 = t1856 * t1858;
  t1864 = t593 * t580;
  t1865 = t592 * t1864;
  t1867 = t1849 * t584;
  t1868 = t560 * t1867;
  t1869 = t1868 * t1529;
  t1871 = t281 * t238;
  t1872 = t1871 * t565;
  t1873 = t234 * t1872;
  t1875 = params->csk_a * t561 * t584;
  t1876 = t242 * t1875;
  t1877 = t1873 * t1876;
  t1879 = t1868 * t1521;
  t1881 = -t704 * t1513 + 0.3e1 * t1778 * t1843 - 0.3e1 * t1793 * t1834 - t1793 * t1841 - 0.3e1 * t1810 * t1825 - t1810 * t1841 + 0.3e1 * t1822 * t1834 + 0.3e1 * t1822 * t1841 - 0.2e1 * t1829 * t692 - 0.2e1 * t1829 * t707 - t704 * t1865 + 0.3e1 * t1853 + 0.3e1 * t1859 - 0.3e1 * t1869 + 0.3e1 * t1877 - 0.3e1 * t1879;
  t1883 = my_piecewise5(t114, 0, t115, 0, t1828 + t1881);
  t1885 = t113 * t1883 + t1764 * t125 + 0.2e1 * t232 * t710 + 0.2e1 * t680 * t245 + t278 * t597 + t554 * t284 + t1760;
  t1890 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t286 + t1730 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t712 - t1708 + t1737 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t1885);
  tv3rho2sigma8 = t8 * t1890 + 0.2e1 * t717;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1897 = t7 * t345 * t303;
  t1904 = t7 * t354 * t303 / 0.3e2;
  t1906 = t7 * t145 * t754;
  t1920 = t298 * t399;
  t1922 = t163 * t1920 * t405;
  t1925 = t388 * t741;
  t1926 = t411 * t1925;
  t1929 = t1068 * t298;
  t1930 = t1066 * t1929;
  t1932 = t1051 * t732;
  t1935 = t298 * t1046;
  t1936 = t163 * t1935;
  t1939 = t741 * t382;
  t1940 = t163 * t1939;
  t1943 = t741 * t165;
  t1945 = t163 * t1943 * t405;
  t1949 = my_piecewise3(t67, 0, 0.5e1 / 0.27e2 * t52 * t615);
  t1950 = my_piecewise3(t69, t1949, 0);
  t1953 = t379 * t1935;
  t1956 = t379 * t1939;
  t1961 = t732 * params->csk_a;
  t1962 = t1051 * t1961;
  t1966 = -t163 * t1950 * t172 + t1130 * t733 - t1583 * t1930 + 0.3e1 * t1583 * t1962 + t736 * t1595 - 0.3e1 * t1598 * t1932 - 0.2e1 * t1936 * t1605 - 0.3e1 * t1936 * t1639 + 0.3e1 * t1953 * t1639 - t1936 * t1647 + 0.2e1 * t623 * t1926 + 0.2e1 * t1940 * t640 - 0.2e1 * t1956 * t630 - t1922 - 0.2e1 * t1945 - t746;
  t1969 = t1045 * t1935;
  t1971 = t732 * t403;
  t1972 = t411 * t1971;
  t1973 = t1656 * t1972;
  t1975 = t298 * t380;
  t1977 = t163 * t1975 * t1664;
  t1985 = t379 * t1975 * t403;
  t1986 = t1985 * t1148;
  t1989 = t298 * t167 * t384;
  t1990 = t163 * t1989;
  t1991 = t1990 * t1685;
  t1993 = t1985 * t1135;
  t2001 = t1929 * params->csk_a;
  t2002 = t1066 * t2001;
  t2007 = t736 * t1140 - t748 * t1140 + 0.3e1 * t1583 * t2002 + 0.3e1 * t1953 * t1620 - 0.3e1 * t1969 * t1620 - t748 * t1624 + 0.3e1 * t1953 * t1647 - t1969 * t1647 - 0.2e1 * t1969 * t1668 + 0.2e1 * t1940 * t630 - 0.2e1 * t1956 * t645 + 0.3e1 * t1973 + 0.3e1 * t1977 - 0.3e1 * t1986 + 0.3e1 * t1991 - 0.3e1 * t1993;
  t2009 = my_piecewise5(t64, 0, t67, 0, t1966 + t2007);
  t2011 = 0.5e1 / 0.27e2 * t52 * t615 * t77 - 0.5e1 / 0.36e2 * t52 * t257 * t174 + t52 * t291 * t416 / 0.24e2 + t373 * t301 + 0.2e1 * t161 * t752 + t59 * t2009;
  t2016 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t303 + t1897 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t754 - t1904 + t1906 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2011);
  tv3rho2lapl0 = t8 * t2016 + 0.2e1 * t759;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2023 = t7 * t440 * t320;
  t2027 = t7 * t444 * t320 / 0.3e2;
  t2029 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t320 + t2023 / 0.5e1 - t2027);
  tv3rho2lapl1 = t8 * t2029 + 0.2e1 * t768;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2035 = t7 * t465 * t303;
  t2043 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t303 + t2035 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t754 + t1897 / 0.1e2 - t1904 + t1906 / 0.1e2);
  tv3rho2lapl2 = t8 * t2043 + t759 + t774;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2049 = t7 * t489 * t320;
  t2056 = t7 * t192 * t808;
  t2059 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t320 + t2049 / 0.1e2 + t2023 / 0.1e2 - t2027 + 0.3e1 / 0.2e2 * t7 * t188 * t808 + t2056 / 0.1e2);
  tv3rho2lapl3 = t8 * t2059 + t768 + t813;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2067 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t303 + t2035 / 0.5e1 - t1904);
  tv3rho2lapl4 = t8 * t2067 + 0.2e1 * t774;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2090 = t795 * t563;
  t2091 = t234 * t2090;
  t2096 = t569 * t795;
  t2097 = t592 * t2096;
  t2100 = t1452 * t315;
  t2101 = t1450 * t2100;
  t2103 = t795 * t236;
  t2105 = t234 * t2103 * t586;
  t2107 = t315 * t580;
  t2109 = t234 * t2107 * t586;
  t2110 = t1432 * t786;
  t2113 = t315 * t1427;
  t2114 = t234 * t2113;
  t2119 = my_piecewise3(t115, 0, 0.5e1 / 0.27e2 * t52 * t677);
  t2120 = my_piecewise3(t117, t2119, 0);
  t2124 = t315 * t238 * t565;
  t2125 = t234 * t2124;
  t2126 = t2125 * t1876;
  t2128 = t315 * t561;
  t2129 = t2128 * t584;
  t2130 = t560 * t2129;
  t2131 = t2130 * t1521;
  t2133 = t2130 * t1529;
  t2135 = t560 * t2090;
  t2138 = t560 * t2113;
  t2141 = -t234 * t2120 * t243 + t1516 * t787 - t1778 * t2101 + t790 * t1790 - 0.2e1 * t2114 * t1795 - 0.3e1 * t1798 * t2110 + 0.3e1 * t2138 * t1834 + 0.2e1 * t2091 * t702 + 0.2e1 * t685 * t2097 - 0.2e1 * t2135 * t707 - 0.2e1 * t2105 - t2109 + 0.3e1 * t2126 - 0.3e1 * t2131 - 0.3e1 * t2133 - t800;
  t2146 = t786 * params->csk_a;
  t2147 = t1432 * t2146;
  t2153 = t1425 * t2113;
  t2155 = t786 * t584;
  t2156 = t592 * t2155;
  t2157 = t1856 * t2156;
  t2160 = t234 * t2128 * t1852;
  t2162 = t2100 * params->csk_a;
  t2163 = t1450 * t2162;
  t2177 = t790 * t1513 - t802 * t1513 + 0.3e1 * t1778 * t2147 + 0.3e1 * t1778 * t2163 - 0.2e1 * t2153 * t1812 + 0.3e1 * t2138 * t1825 - 0.3e1 * t2153 * t1825 - 0.3e1 * t2114 * t1834 - t2114 * t1841 + 0.3e1 * t2138 * t1841 - t2153 * t1841 - t802 * t1865 + 0.2e1 * t2091 * t692 - 0.2e1 * t2135 * t692 + 0.3e1 * t2157 + 0.3e1 * t2160;
  t2179 = my_piecewise5(t114, 0, t115, 0, t2141 + t2177);
  t2181 = 0.5e1 / 0.27e2 * t52 * t677 * t125 - 0.5e1 / 0.36e2 * t52 * t275 * t245 + t52 * t308 * t597 / 0.24e2 + t554 * t318 + 0.2e1 * t232 * t806 + t113 * t2179;
  t2186 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t320 + t2049 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t808 - t2027 + t2056 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t2181);
  tv3rho2lapl5 = t8 * t2186 + 0.2e1 * t813;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2193 = t7 * t145 * t836 / 0.1e2;
  t2199 = t165 * t1046;
  t2200 = t1045 * t2199;
  t2201 = t1068 * t817;
  t2202 = t1066 * t2201;
  t2204 = t388 * t824;
  t2205 = t411 * t2204;
  t2206 = t623 * t2205;
  t2207 = t824 * t165;
  t2209 = t163 * t2207 * t405;
  t2210 = t263 * t403;
  t2211 = t163 * t2210;
  t2212 = t168 * t74;
  t2213 = t170 * t633;
  t2215 = t2211 * t2212 * t2213;
  t2216 = 0.2e1 * t2215;
  t2217 = t394 * t2213;
  t2220 = t817 * t1046;
  t2221 = t379 * t2220;
  t2222 = t388 * t165;
  t2223 = t1051 * t2222;
  t2226 = t824 * t382;
  t2227 = t163 * t2226;
  t2228 = t2227 * t640;
  t2229 = t163 * t2220;
  t2230 = t1056 * t639;
  t2235 = t817 * t403;
  t2237 = t379 * t2235 * t384;
  t2238 = params->csk_a * t165;
  t2239 = t2238 * t1147;
  t2240 = t2237 * t2239;
  t2242 = t817 * t167;
  t2244 = t163 * t2242 * t384;
  t2245 = t2238 * t403;
  t2246 = t171 * t2245;
  t2247 = t2244 * t2246;
  t2249 = t2238 * t167;
  t2250 = t389 * t2249;
  t2251 = t2237 * t2250;
  t2253 = t1073 * t165;
  t2254 = t1051 * t2253;
  t2257 = t379 * t2226;
  t2258 = t2257 * t645;
  t2259 = 0.2e1 * t642 * t1579 - t2200 * t2202 + 0.2e1 * t628 * t2217 - 0.3e1 * t2221 * t2223 + 0.3e1 * t2221 * t2254 - 0.2e1 * t2229 * t2230 + t2206 - t2209 - t2216 + t2228 - 0.3e1 * t2240 + 0.3e1 * t2247 - 0.3e1 * t2251 - t2258 - t826 - t828;
  t2260 = t163 * t2235;
  t2262 = t394 * t639 * t167;
  t2263 = t2260 * t2262;
  t2265 = t171 * t633;
  t2266 = t1145 * t2265;
  t2269 = t1045 * t2220;
  t2270 = t1051 * t644;
  t2274 = t1056 * t1058 * t165;
  t2279 = t2227 * t630;
  t2280 = t2257 * t630;
  t2282 = t165 * t74 * t170;
  t2283 = t1091 * t2282;
  t2290 = t412 * t633;
  t2291 = t411 * t2290;
  t2294 = t1069 * t165;
  t2295 = t1066 * t2294;
  t2298 = t379 * t2242;
  t2299 = t2222 * t403;
  t2300 = t411 * t2299;
  t2301 = t2298 * t2300;
  t2303 = t1087 * t165;
  t2304 = t1066 * t2303;
  t2309 = 0.3e1 * t2221 * t2274 + 0.3e1 * t2221 * t2283 - t2229 * t2274 - 0.3e1 * t2229 * t2283 - 0.3e1 * t2269 * t2254 + 0.2e1 * t628 * t2266 - 0.2e1 * t642 * t2266 + 0.3e1 * t2269 * t2270 - t2269 * t2274 - 0.2e1 * t2269 * t2295 + 0.3e1 * t2269 * t2304 - 0.2e1 * t642 * t2291 + 0.3e1 * t2263 + t2279 - t2280 + 0.3e1 * t2301;
  t2311 = my_piecewise5(t64, 0, t67, 0, t2259 + t2309);
  t2313 = t161 * t834 + t59 * t2311 + 0.2e1 * t260 * t648 + 0.2e1 * t618 * t266;
  t2318 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t836 + t2193 + 0.3e1 / 0.2e2 * t7 * t32 * t2313);
  tv3rhosigma20 = t8 * t2318 + t840;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2325 = t7 * t192 * t862 / 0.1e2;
  t2327 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t862 + t2325);
  tv3rhosigma25 = t8 * t2327 + t866;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2333 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t836 + t2193);
  tv3rhosigma26 = t8 * t2333 + t840;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2343 = t843 * t1427;
  t2344 = t234 * t2343;
  t2345 = t1437 * t701;
  t2348 = t560 * t2343;
  t2349 = t569 * t236;
  t2350 = t1432 * t2349;
  t2353 = t850 * t563;
  t2354 = t234 * t2353;
  t2355 = t2354 * t702;
  t2356 = t236 * t1427;
  t2357 = t1425 * t2356;
  t2358 = t1452 * t843;
  t2359 = t1450 * t2358;
  t2361 = t569 * t850;
  t2362 = t592 * t2361;
  t2363 = t685 * t2362;
  t2364 = t850 * t236;
  t2366 = t234 * t2364 * t586;
  t2367 = t281 * t584;
  t2368 = t234 * t2367;
  t2369 = t239 * t122;
  t2370 = t241 * t695;
  t2372 = t2368 * t2369 * t2370;
  t2373 = 0.2e1 * t2372;
  t2374 = t575 * t2370;
  t2379 = t843 * t584;
  t2381 = t560 * t2379 * t565;
  t2382 = params->csk_a * t236;
  t2383 = t2382 * t1528;
  t2384 = t2381 * t2383;
  t2386 = t843 * t238;
  t2388 = t234 * t2386 * t565;
  t2389 = t2382 * t584;
  t2390 = t242 * t2389;
  t2391 = t2388 * t2390;
  t2393 = t2382 * t238;
  t2394 = t570 * t2393;
  t2395 = t2381 * t2394;
  t2397 = t1425 * t2343;
  t2398 = t1461 * t236;
  t2399 = t1450 * t2398;
  t2402 = t576 * t695;
  t2403 = t575 * t2402;
  t2406 = 0.2e1 * t704 * t1774 - 0.2e1 * t2344 * t2345 - 0.3e1 * t2348 * t2350 - t2357 * t2359 + 0.2e1 * t690 * t2374 + 0.3e1 * t2397 * t2399 + 0.2e1 * t690 * t2403 + t2355 + t2363 - t2366 - t2373 - 0.3e1 * t2384 + 0.3e1 * t2391 - 0.3e1 * t2395 - t852 - t854;
  t2407 = t1823 * t236;
  t2408 = t1432 * t2407;
  t2411 = t560 * t2353;
  t2412 = t2411 * t707;
  t2413 = t234 * t2379;
  t2415 = t575 * t701 * t238;
  t2416 = t2413 * t2415;
  t2418 = t1432 * t706;
  t2421 = t1438 * t236;
  t2422 = t1437 * t2421;
  t2427 = t2354 * t692;
  t2428 = t2411 * t692;
  t2430 = t236 * t122 * t241;
  t2431 = t1471 * t2430;
  t2440 = t593 * t695;
  t2441 = t592 * t2440;
  t2444 = t1453 * t236;
  t2445 = t1450 * t2444;
  t2448 = t560 * t2386;
  t2449 = t2349 * t584;
  t2450 = t592 * t2449;
  t2451 = t2448 * t2450;
  t2453 = -t2344 * t2422 - 0.3e1 * t2344 * t2431 + 0.3e1 * t2348 * t2408 + 0.3e1 * t2348 * t2422 + 0.3e1 * t2348 * t2431 - 0.3e1 * t2397 * t2408 + 0.3e1 * t2397 * t2418 - t2397 * t2422 - 0.2e1 * t2397 * t2445 - 0.2e1 * t704 * t2403 - 0.2e1 * t704 * t2441 - t2412 + 0.3e1 * t2416 + t2427 - t2428 + 0.3e1 * t2451;
  t2455 = my_piecewise5(t114, 0, t115, 0, t2406 + t2453);
  t2457 = t113 * t2455 + t232 * t860 + 0.2e1 * t278 * t710 + 0.2e1 * t680 * t284;
  t2462 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t862 + t2325 + 0.3e1 / 0.2e2 * t7 * t94 * t2457);
  tv3rhosigma211 = t8 * t2462 + t866;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2469 = t7 * t145 * t888 / 0.1e2;
  t2483 = t741 * t263;
  t2485 = t163 * t2483 * t405;
  t2486 = t298 * t633;
  t2488 = t163 * t2486 * t405;
  t2489 = t875 * t403;
  t2490 = t379 * t2489;
  t2492 = t1145 * t165 * t1147;
  t2493 = t2490 * t2492;
  t2495 = t171 * params->csk_a;
  t2496 = t636 * t403;
  t2498 = t1990 * t2495 * t2496;
  t2500 = t411 * t388;
  t2501 = t2500 * t2249;
  t2502 = t2490 * t2501;
  t2504 = t163 * t2489;
  t2505 = t2504 * t2262;
  t2507 = t1935 * t1050;
  t2508 = t1045 * t2507;
  t2509 = t1057 * t263;
  t2510 = t389 * t165;
  t2511 = t2509 * t2510;
  t2514 = t379 * t1681;
  t2515 = t744 * t403;
  t2516 = t389 * t2515;
  t2517 = t2514 * t2516;
  t2519 = t379 * t2507;
  t2520 = t171 * t263;
  t2521 = t2238 * t2520;
  t2524 = t163 * t2507;
  t2527 = t1642 * t733 + t642 * t1926 + t1940 * t879 + t736 * t2217 - 0.3e1 * t2508 * t2511 + 0.3e1 * t2519 * t2521 - 0.3e1 * t2524 * t2521 + t2206 - t2209 + t2228 - t2485 - t2488 - 0.3e1 * t2493 + 0.3e1 * t2498 - 0.3e1 * t2502 + 0.3e1 * t2505 + 0.3e1 * t2517 - t826 - t877;
  t2528 = t1602 * t1050;
  t2529 = t1045 * t2528;
  t2530 = t298 * params->csk_a;
  t2531 = t2530 * t165;
  t2532 = t389 * t2531;
  t2535 = t2509 * t165;
  t2536 = t171 * t2535;
  t2541 = t1110 * t2535;
  t2544 = t1110 * t2531;
  t2551 = t1584 * t298;
  t2552 = t1066 * t2551;
  t2558 = t878 * t165;
  t2559 = t1056 * t2558;
  t2563 = t1051 * t732 * t165;
  t2566 = -0.3e1 * t1634 * t2563 - 0.2e1 * t1936 * t2559 + t1940 * t873 - t1956 * t873 - t1956 * t883 - t2200 * t2552 + t736 * t2266 - t748 * t2266 - t748 * t2291 - t2508 * t2536 - 0.2e1 * t2508 * t2541 + 0.3e1 * t2519 * t2511 + 0.3e1 * t2519 * t2536 - t2524 * t2536 + 0.3e1 * t2529 * t2532 + 0.3e1 * t2529 * t2544 - t2258 + t2279 - t2280;
  t2568 = my_piecewise5(t64, 0, t67, 0, t2527 + t2566);
  t2570 = -0.5e1 / 0.72e2 * t52 * t257 * t266 + t52 * t291 * t648 / 0.24e2 + t618 * t301 + t260 * t752 + t161 * t886 + t59 * t2568;
  t2575 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t888 + t2469 + 0.3e1 / 0.2e2 * t7 * t32 * t2570);
  tv3rhosigmalapl0 = t8 * t2575 + t892;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2582 = t7 * t192 * t914 / 0.1e2;
  t2584 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t914 + t2582);
  tv3rhosigmalapl5 = t8 * t2584 + t918;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2590 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t888 + t2469);
  tv3rhosigmalapl6 = t8 * t2590 + t892;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2606 = t795 * t281;
  t2608 = t234 * t2606 * t586;
  t2609 = t315 * t695;
  t2611 = t234 * t2609 * t586;
  t2614 = t901 * t584;
  t2615 = t560 * t2614;
  t2616 = t592 * t569;
  t2617 = t2616 * t2393;
  t2618 = t2615 * t2617;
  t2621 = t1526 * t236 * t1528;
  t2622 = t2615 * t2621;
  t2624 = t242 * params->csk_a;
  t2625 = t698 * t584;
  t2627 = t2125 * t2624 * t2625;
  t2629 = t560 * t1872;
  t2631 = t570 * t798 * t584;
  t2632 = t2629 * t2631;
  t2634 = t1792 * t1431;
  t2635 = t1425 * t2634;
  t2636 = t315 * params->csk_a;
  t2637 = t2636 * t236;
  t2638 = t1496 * t2637;
  t2641 = t2113 * t1431;
  t2642 = t560 * t2641;
  t2643 = t1057 * t281;
  t2644 = t2643 * t236;
  t2645 = t570 * t2644;
  t2648 = t234 * t2614;
  t2649 = t2648 * t2415;
  t2651 = t242 * t281;
  t2652 = t2382 * t2651;
  t2655 = t1829 * t787 + t2091 * t905 + t704 * t2097 + t790 * t2374 + 0.3e1 * t2635 * t2638 + 0.3e1 * t2642 * t2645 + 0.3e1 * t2642 * t2652 + t2355 + t2363 - t2366 - t2608 - t2611 - 0.3e1 * t2618 - 0.3e1 * t2622 + 0.3e1 * t2627 + 0.3e1 * t2632 + 0.3e1 * t2649 - t852 - t903;
  t2656 = t234 * t2641;
  t2659 = t570 * t2637;
  t2662 = t242 * t2644;
  t2666 = t1425 * t2641;
  t2670 = t1496 * t2644;
  t2674 = t1432 * t786 * t236;
  t2677 = t904 * t236;
  t2678 = t1437 * t2677;
  t2685 = t1779 * t315;
  t2686 = t1450 * t2685;
  t2690 = -0.3e1 * t1822 * t2674 + t2091 * t899 - 0.2e1 * t2114 * t2678 - t2135 * t899 - t2135 * t909 - t2357 * t2686 + t790 * t2403 - t802 * t2403 - t802 * t2441 + 0.3e1 * t2635 * t2659 + 0.3e1 * t2642 * t2662 - 0.3e1 * t2666 * t2645 - 0.3e1 * t2656 * t2652 - t2656 * t2662 - t2666 * t2662 - 0.2e1 * t2666 * t2670 - t2412 + t2427 - t2428;
  t2692 = my_piecewise5(t114, 0, t115, 0, t2655 + t2690);
  t2694 = -0.5e1 / 0.72e2 * t52 * t275 * t284 + t52 * t308 * t710 / 0.24e2 + t680 * t318 + t278 * t806 + t232 * t912 + t113 * t2692;
  t2699 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t914 + t2582 + 0.3e1 / 0.2e2 * t7 * t94 * t2694);
  tv3rhosigmalapl11 = t8 * t2699 + t918;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2706 = t7 * t145 * t937 / 0.1e2;
  t2714 = t170 * t741;
  t2720 = t1068 * t922;
  t2721 = t1066 * t2720;
  t2723 = t298 * t403;
  t2724 = t163 * t2723;
  t2726 = t2724 * t2212 * t2714;
  t2727 = 0.2e1 * t2726;
  t2728 = t922 * t1046;
  t2729 = t163 * t2728;
  t2732 = t379 * t2728;
  t2735 = t922 * t403;
  t2737 = t379 * t2735 * t384;
  t2738 = t2737 * t2239;
  t2740 = t922 * t167;
  t2742 = t163 * t2740 * t384;
  t2743 = t2742 * t2246;
  t2745 = t2737 * t2250;
  t2747 = t1045 * t2728;
  t2750 = t395 * t741;
  t2751 = t394 * t2750;
  t2754 = 0.2e1 * t736 * t394 * t2714 + 0.2e1 * t748 * t1926 - t2200 * t2721 - 0.3e1 * t2732 * t2223 - 0.2e1 * t2729 * t2230 + 0.3e1 * t2747 * t2304 + 0.2e1 * t736 * t2751 + t2206 - t2209 + t2228 - t2727 - 0.3e1 * t2738 + 0.3e1 * t2743 - 0.3e1 * t2745 - t826 - t929;
  t2757 = t163 * t2735;
  t2758 = t2757 * t2262;
  t2774 = t412 * t741;
  t2780 = t379 * t2740;
  t2781 = t2780 * t2300;
  t2783 = -0.2e1 * t748 * t411 * t2774 + 0.3e1 * t2732 * t2254 - 0.3e1 * t2747 * t2254 + 0.3e1 * t2747 * t2270 - t2729 * t2274 + 0.3e1 * t2732 * t2274 - t2747 * t2274 - 0.3e1 * t2729 * t2283 + 0.3e1 * t2732 * t2283 - 0.2e1 * t2747 * t2295 - 0.2e1 * t748 * t2751 - t2258 + t2279 - t2280 + 0.3e1 * t2758 + 0.3e1 * t2781;
  t2785 = my_piecewise5(t64, 0, t67, 0, t2754 + t2783);
  t2787 = -0.5e1 / 0.36e2 * t52 * t257 * t301 + t52 * t291 * t752 / 0.12e2 + t161 * t935 + t59 * t2785;
  t2792 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t937 + t2706 + 0.3e1 / 0.2e2 * t7 * t32 * t2787);
  tv3rholapl20 = t8 * t2792 + t941;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2799 = t7 * t192 * t960 / 0.1e2;
  t2801 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t960 + t2799);
  tv3rholapl22 = t8 * t2801 + t964;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2807 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t937 + t2706);
  tv3rholapl23 = t8 * t2807 + t941;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2821 = t1452 * t945;
  t2822 = t1450 * t2821;
  t2824 = t315 * t584;
  t2825 = t234 * t2824;
  t2826 = t241 * t795;
  t2828 = t2825 * t2369 * t2826;
  t2829 = 0.2e1 * t2828;
  t2833 = t945 * t1427;
  t2834 = t560 * t2833;
  t2837 = t234 * t2833;
  t2840 = t945 * t584;
  t2842 = t560 * t2840 * t565;
  t2843 = t2842 * t2383;
  t2845 = t945 * t238;
  t2847 = t234 * t2845 * t565;
  t2848 = t2847 * t2390;
  t2850 = t2842 * t2394;
  t2852 = t1425 * t2833;
  t2856 = 0.2e1 * t790 * t575 * t2826 + 0.2e1 * t802 * t2097 - 0.2e1 * t2837 * t2345 - 0.3e1 * t2834 * t2350 - t2357 * t2822 + 0.3e1 * t2852 * t2418 - t2837 * t2422 + t2355 + t2363 - t2366 - t2829 - 0.3e1 * t2843 + 0.3e1 * t2848 - 0.3e1 * t2850 - t852 - t952;
  t2864 = t593 * t795;
  t2870 = t560 * t2845;
  t2871 = t2870 * t2450;
  t2876 = t575 * t576 * t795;
  t2881 = t234 * t2840;
  t2882 = t2881 * t2415;
  t2888 = -0.2e1 * t802 * t592 * t2864 + 0.3e1 * t2852 * t2399 + 0.3e1 * t2834 * t2408 - 0.3e1 * t2852 * t2408 + 0.3e1 * t2834 * t2422 - t2852 * t2422 + 0.3e1 * t2834 * t2431 - 0.3e1 * t2837 * t2431 - 0.2e1 * t2852 * t2445 + 0.2e1 * t790 * t2876 - 0.2e1 * t802 * t2876 - t2412 + t2427 - t2428 + 0.3e1 * t2871 + 0.3e1 * t2882;
  t2890 = my_piecewise5(t114, 0, t115, 0, t2856 + t2888);
  t2892 = -0.5e1 / 0.36e2 * t52 * t275 * t318 + t52 * t308 * t806 / 0.12e2 + t232 * t958 + t113 * t2890;
  t2897 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t960 + t2799 + 0.3e1 / 0.2e2 * t7 * t94 * t2892);
  tv3rholapl25 = t8 * t2897 + t964;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2901 = t817 * t263;
  t2902 = t2901 * t1046;
  t2903 = t163 * t2902;
  t2906 = t1045 * t2902;
  t2911 = t642 * t2205;
  t2912 = 0.3e1 * t2911;
  t2915 = t379 * t2902;
  t2918 = t824 * t263;
  t2920 = t163 * t2918 * t405;
  t2921 = 0.3e1 * t2920;
  t2922 = t2227 * t879;
  t2923 = 0.3e1 * t2922;
  t2924 = t2901 * t403;
  t2925 = t163 * t2924;
  t2926 = t2925 * t1105;
  t2927 = 0.3e1 * t2926;
  t2928 = t2901 * t167;
  t2930 = t379 * t2928 * t1040;
  t2931 = 0.3e1 * t2930;
  t2937 = 0.3e1 * t2906 * t1052 - t2903 * t1059 + 0.3e1 * t2915 * t1059 - 0.2e1 * t2906 * t1070 - 0.3e1 * t2906 * t1074 + 0.3e1 * t2915 * t1074 + 0.3e1 * t2906 * t1088 - 0.3e1 * t2903 * t1092 + t2912 - t2921 + t2923 + t2927 + t2931;
  t2949 = t379 * t2924;
  t2950 = t2949 * t1135;
  t2951 = 0.3e1 * t2950;
  t2952 = t395 * t824;
  t2953 = t394 * t2952;
  t2954 = t628 * t2953;
  t2955 = 0.3e1 * t2954;
  t2956 = t2257 * t873;
  t2957 = 0.3e1 * t2956;
  t2958 = t2949 * t1148;
  t2959 = 0.3e1 * t2958;
  t2961 = t163 * t2928 * t1127;
  t2962 = 0.3e1 * t2961;
  t2963 = t2257 * t883;
  t2964 = 0.3e1 * t2963;
  t2965 = -t1045 * t2901 * t1111 - 0.2e1 * t163 * t2901 * t1118 - 0.3e1 * t379 * t2901 * t1122 - t2906 * t1059 + 0.3e1 * t2915 * t1092 - t2951 + t2955 - t2957 - t2959 + t2962 - t2964 - t826 - t828;
  t2967 = my_piecewise5(t64, 0, t67, 0, t2937 + t2965);
  t2969 = 0.3e1 * t260 * t834 + t59 * t2967;
  t2973 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2969);
  tv3sigma30 = t8 * t2973;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2976 = t843 * t281;
  t2977 = t2976 * t1427;
  t2978 = t234 * t2977;
  t2981 = t1425 * t2977;
  t2986 = t704 * t2362;
  t2987 = 0.3e1 * t2986;
  t2990 = t560 * t2977;
  t2993 = t850 * t281;
  t2995 = t234 * t2993 * t586;
  t2996 = 0.3e1 * t2995;
  t2997 = t2976 * t584;
  t2998 = t234 * t2997;
  t2999 = t2998 * t1491;
  t3000 = 0.3e1 * t2999;
  t3001 = t2976 * t238;
  t3003 = t560 * t3001 * t1480;
  t3004 = 0.3e1 * t3003;
  t3005 = t2354 * t905;
  t3006 = 0.3e1 * t3005;
  t3012 = 0.3e1 * t2981 * t1433 - t2981 * t1439 + 0.3e1 * t2990 * t1439 - 0.3e1 * t2981 * t1446 + 0.3e1 * t2990 * t1446 - 0.2e1 * t2981 * t1454 + 0.3e1 * t2981 * t1462 - 0.3e1 * t2978 * t1472 + t2987 - t2996 + t3000 + t3004 + t3006;
  t3024 = t560 * t2997;
  t3025 = t3024 * t1521;
  t3026 = 0.3e1 * t3025;
  t3027 = t576 * t850;
  t3028 = t575 * t3027;
  t3029 = t690 * t3028;
  t3030 = 0.3e1 * t3029;
  t3031 = t2411 * t899;
  t3032 = 0.3e1 * t3031;
  t3033 = t3024 * t1529;
  t3034 = 0.3e1 * t3033;
  t3036 = t234 * t3001 * t1534;
  t3037 = 0.3e1 * t3036;
  t3038 = t2411 * t909;
  t3039 = 0.3e1 * t3038;
  t3040 = -t1425 * t2976 * t1497 - 0.3e1 * t560 * t2976 * t1504 - 0.2e1 * t234 * t2976 * t1508 - t2978 * t1439 + 0.3e1 * t2990 * t1472 - t3026 + t3030 - t3032 - t3034 + t3037 - t3039 - t852 - t854;
  t3042 = my_piecewise5(t114, 0, t115, 0, t3012 + t3040);
  t3044 = t113 * t3042 + 0.3e1 * t278 * t860;
  t3048 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3044);
  tv3sigma39 = t8 * t3048;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3054 = t170 * t817;
  t3055 = t1056 * t3054;
  t3060 = t170 * t824;
  t3061 = t394 * t3060;
  t3062 = t736 * t3061;
  t3063 = t2257 * t733;
  t3065 = t298 * t824;
  t3067 = t163 * t3065 * t405;
  t3068 = 0.2e1 * t2911;
  t3069 = 0.2e1 * t2920;
  t3070 = 0.2e1 * t2922;
  t3071 = t298 * t817;
  t3072 = t3071 * t403;
  t3073 = t379 * t3072;
  t3074 = t3073 * t1135;
  t3075 = 0.3e1 * t3074;
  t3076 = t3073 * t1148;
  t3077 = 0.3e1 * t3076;
  t3078 = params->csk_a * t817;
  t3079 = t3078 * t403;
  t3080 = t171 * t3079;
  t3081 = t1990 * t3080;
  t3082 = 0.3e1 * t3081;
  t3085 = t1058 * t817;
  t3086 = t1056 * t3085;
  t3088 = -t2269 * t1930 - 0.3e1 * t2221 * t1932 - 0.2e1 * t1936 * t3055 - t1936 * t3086 + 0.3e1 * t2269 * t1962 + t3062 + t3063 - t3067 + t3068 - t3069 + t3070 - t3075 - t3077 + t3082 - t826 - t877;
  t3092 = t2298 * t1972;
  t3093 = 0.3e1 * t3092;
  t3096 = t736 * t2953;
  t3097 = t1073 * t817;
  t3098 = t1051 * t3097;
  t3102 = t817 * t74 * t170;
  t3103 = t1091 * t3102;
  t3108 = t748 * t2953;
  t3111 = t412 * t824;
  t3112 = t411 * t3111;
  t3113 = t748 * t3112;
  t3114 = t1069 * t817;
  t3115 = t1066 * t3114;
  t3118 = t163 * t3071;
  t3119 = t3118 * t1664;
  t3120 = 0.3e1 * t3119;
  t3121 = 0.2e1 * t2954;
  t3122 = 0.2e1 * t2956;
  t3123 = 0.2e1 * t2963;
  t3124 = -0.3e1 * t1936 * t3103 + 0.3e1 * t1953 * t3086 + 0.3e1 * t1953 * t3098 + 0.3e1 * t1953 * t3103 - t1969 * t3086 - 0.3e1 * t1969 * t3098 - 0.2e1 * t1969 * t3115 + 0.3e1 * t2269 * t2002 + t3093 + t3096 - t3108 - t3113 + t3120 + t3121 - t3122 - t3123;
  t3126 = my_piecewise5(t64, 0, t67, 0, t3088 + t3124);
  t3128 = t52 * t291 * t834 / 0.24e2 + 0.2e1 * t260 * t886 + t59 * t3126;
  t3132 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3128);
  tv3sigma2lapl0 = t8 * t3132;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3138 = t241 * t843;
  t3139 = t1437 * t3138;
  t3144 = t241 * t850;
  t3145 = t575 * t3144;
  t3146 = t790 * t3145;
  t3147 = t2411 * t787;
  t3151 = t234 * t315 * t850 * t586;
  t3152 = 0.2e1 * t2986;
  t3153 = 0.2e1 * t2995;
  t3154 = 0.2e1 * t3005;
  t3155 = t315 * t843;
  t3156 = t3155 * t584;
  t3157 = t560 * t3156;
  t3158 = t3157 * t1521;
  t3159 = 0.3e1 * t3158;
  t3160 = t3157 * t1529;
  t3161 = 0.3e1 * t3160;
  t3162 = params->csk_a * t843;
  t3163 = t3162 * t584;
  t3164 = t242 * t3163;
  t3165 = t2125 * t3164;
  t3166 = 0.3e1 * t3165;
  t3168 = t843 * t122 * t241;
  t3169 = t1471 * t3168;
  t3174 = -t2397 * t2101 - 0.3e1 * t2348 * t2110 - 0.2e1 * t2114 * t3139 - 0.3e1 * t2114 * t3169 + 0.3e1 * t2138 * t3169 + t3146 + t3147 - t3151 + t3152 - t3153 + t3154 - t3159 - t3161 + t3166 - t852 - t903;
  t3178 = t1437 * t1438 * t843;
  t3183 = t802 * t3028;
  t3186 = t1445 * t843 * t567 * t569;
  t3189 = t593 * t850;
  t3190 = t592 * t3189;
  t3191 = t802 * t3190;
  t3192 = t1453 * t843;
  t3193 = t1450 * t3192;
  t3198 = t790 * t3028;
  t3201 = t234 * t3155;
  t3202 = t3201 * t1852;
  t3203 = 0.3e1 * t3202;
  t3204 = t2448 * t2156;
  t3205 = 0.3e1 * t3204;
  t3206 = 0.2e1 * t3029;
  t3207 = 0.2e1 * t3031;
  t3208 = 0.2e1 * t3038;
  t3209 = -t2114 * t3178 + 0.3e1 * t2138 * t3178 + 0.3e1 * t2138 * t3186 + 0.3e1 * t2397 * t2147 - t2153 * t3178 - 0.3e1 * t2153 * t3186 - 0.2e1 * t2153 * t3193 + 0.3e1 * t2397 * t2163 - t3183 - t3191 + t3198 + t3203 + t3205 + t3206 - t3207 - t3208;
  t3211 = my_piecewise5(t114, 0, t115, 0, t3174 + t3209);
  t3213 = t52 * t308 * t860 / 0.24e2 + 0.2e1 * t278 * t912 + t113 * t3211;
  t3217 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3213);
  tv3sigma2lapl11 = t8 * t3217;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3228 = 0.2e1 * t3062;
  t3229 = 0.2e1 * t3063;
  t3230 = 0.2e1 * t3067;
  t3231 = params->csk_a * t263;
  t3232 = t3231 * t403;
  t3234 = t2742 * t171 * t3232;
  t3235 = 0.3e1 * t3234;
  t3236 = t3231 * t167;
  t3238 = t2737 * t389 * t3236;
  t3239 = 0.3e1 * t3238;
  t3241 = t2737 * t3231 * t1147;
  t3242 = 0.3e1 * t3241;
  t3243 = t1056 * t872;
  t3246 = t1617 * t2520;
  t3248 = -0.2e1 * t2729 * t1056 * t878 - 0.3e1 * t2732 * t1599 - t1616 * t2721 - 0.3e1 * t2729 * t3243 - t2747 * t3246 + t2911 - t2920 + t2922 + t3228 + t3229 - t3230 + t3235 - t3239 - t3242 - t826 - t929;
  t3256 = t1069 * t263;
  t3260 = t1073 * t263;
  t3261 = t1051 * t3260;
  t3266 = t2757 * t394 * t878 * t167;
  t3267 = 0.3e1 * t3266;
  t3270 = t2780 * t1658;
  t3271 = 0.3e1 * t3270;
  t3274 = 0.2e1 * t3096;
  t3275 = 0.2e1 * t3108;
  t3276 = 0.2e1 * t3113;
  t3277 = -0.2e1 * t2747 * t1066 * t3256 + 0.3e1 * t2747 * t1627 + 0.3e1 * t2747 * t1649 - t2729 * t3246 + 0.3e1 * t2732 * t3243 + 0.3e1 * t2732 * t3246 + 0.3e1 * t2732 * t3261 - 0.3e1 * t2747 * t3261 + t2954 - t2956 - t2963 + t3267 + t3271 + t3274 - t3275 - t3276;
  t3279 = my_piecewise5(t64, 0, t67, 0, t3248 + t3277);
  t3281 = t52 * t291 * t886 / 0.12e2 + t260 * t935 + t59 * t3279;
  t3285 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3281);
  tv3sigmalapl20 = t8 * t3285;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3296 = 0.2e1 * t3146;
  t3297 = 0.2e1 * t3147;
  t3298 = 0.2e1 * t3151;
  t3299 = params->csk_a * t281;
  t3300 = t3299 * t238;
  t3302 = t2842 * t570 * t3300;
  t3303 = 0.3e1 * t3302;
  t3304 = t3299 * t584;
  t3306 = t2847 * t242 * t3304;
  t3307 = 0.3e1 * t3306;
  t3309 = t2842 * t3299 * t1528;
  t3310 = 0.3e1 * t3309;
  t3311 = t1445 * t2651;
  t3315 = -0.2e1 * t2837 * t1437 * t904 - 0.3e1 * t2834 * t1799 - t1810 * t2822 + 0.3e1 * t2834 * t3311 - t2852 * t3311 + t2986 - t2995 + t3005 + t3296 + t3297 - t3298 - t3303 + t3307 - t3310 - t852 - t952;
  t3316 = t1471 * t2651;
  t3319 = t570 * t281;
  t3320 = t1445 * t3319;
  t3323 = t2870 * t1858;
  t3324 = 0.3e1 * t3323;
  t3332 = t1453 * t281;
  t3340 = t2881 * t575 * t904 * t238;
  t3341 = 0.3e1 * t3340;
  t3342 = 0.2e1 * t3183;
  t3343 = 0.2e1 * t3191;
  t3344 = 0.2e1 * t3198;
  t3345 = -0.2e1 * t2852 * t1450 * t3332 + 0.3e1 * t2852 * t1816 + 0.3e1 * t2852 * t1843 + 0.3e1 * t2834 * t3316 + 0.3e1 * t2834 * t3320 - t2837 * t3311 - 0.3e1 * t2837 * t3316 - 0.3e1 * t2852 * t3320 + t3029 - t3031 - t3038 + t3324 + t3341 - t3342 - t3343 + t3344;
  t3347 = my_piecewise5(t114, 0, t115, 0, t3315 + t3345);
  t3349 = t52 * t308 * t912 / 0.12e2 + t278 * t958 + t113 * t3347;
  t3353 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3349);
  tv3sigmalapl28 = t8 * t3353;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3357 = 0.3e1 * t3062;
  t3358 = 0.3e1 * t3063;
  t3359 = 0.3e1 * t3067;
  t3360 = t922 * t298;
  t3369 = t3360 * t167;
  t3371 = t163 * t3369 * t1127;
  t3372 = 0.3e1 * t3371;
  t3373 = t3360 * t403;
  t3374 = t379 * t3373;
  t3375 = t3374 * t1148;
  t3376 = 0.3e1 * t3375;
  t3377 = t3374 * t1135;
  t3378 = 0.3e1 * t3377;
  t3379 = 0.3e1 * t3096;
  t3380 = 0.3e1 * t3108;
  t3381 = -t1045 * t3360 * t1111 - 0.2e1 * t163 * t3360 * t1118 - 0.3e1 * t379 * t3360 * t1122 + t3357 + t3358 - t3359 + t3372 - t3376 - t3378 + t3379 - t3380 - t826 - t929;
  t3382 = 0.3e1 * t3113;
  t3383 = t3360 * t1046;
  t3384 = t1045 * t3383;
  t3391 = t379 * t3383;
  t3394 = t163 * t3373;
  t3395 = t3394 * t1105;
  t3396 = 0.3e1 * t3395;
  t3398 = t379 * t3369 * t1040;
  t3399 = 0.3e1 * t3398;
  t3400 = t163 * t3383;
  t3411 = 0.3e1 * t3384 * t1052 - t3384 * t1059 + 0.3e1 * t3391 * t1059 - t3400 * t1059 - 0.2e1 * t3384 * t1070 - 0.3e1 * t3384 * t1074 + 0.3e1 * t3391 * t1074 + 0.3e1 * t3384 * t1088 + 0.3e1 * t3391 * t1092 - 0.3e1 * t3400 * t1092 - t3382 + t3396 + t3399;
  t3413 = my_piecewise5(t64, 0, t67, 0, t3381 + t3411);
  t3415 = t52 * t291 * t935 / 0.8e1 + t59 * t3413;
  t3419 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3415);
  tv3lapl30 = t8 * t3419;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3423 = 0.3e1 * t3146;
  t3424 = 0.3e1 * t3147;
  t3425 = 0.3e1 * t3151;
  t3426 = t945 * t315;
  t3435 = t3426 * t584;
  t3436 = t560 * t3435;
  t3437 = t3436 * t1521;
  t3438 = 0.3e1 * t3437;
  t3439 = t3426 * t238;
  t3441 = t234 * t3439 * t1534;
  t3442 = 0.3e1 * t3441;
  t3443 = t3436 * t1529;
  t3444 = 0.3e1 * t3443;
  t3445 = 0.3e1 * t3183;
  t3446 = 0.3e1 * t3191;
  t3447 = -t1425 * t3426 * t1497 - 0.3e1 * t560 * t3426 * t1504 - 0.2e1 * t234 * t3426 * t1508 + t3423 + t3424 - t3425 - t3438 + t3442 - t3444 - t3445 - t3446 - t852 - t952;
  t3448 = 0.3e1 * t3198;
  t3449 = t3426 * t1427;
  t3450 = t560 * t3449;
  t3453 = t1425 * t3449;
  t3463 = t560 * t3439 * t1480;
  t3464 = 0.3e1 * t3463;
  t3465 = t234 * t3435;
  t3466 = t3465 * t1491;
  t3467 = 0.3e1 * t3466;
  t3468 = t234 * t3449;
  t3477 = 0.3e1 * t3453 * t1433 + 0.3e1 * t3450 * t1439 - t3453 * t1439 - t3468 * t1439 + 0.3e1 * t3450 * t1446 - 0.3e1 * t3453 * t1446 - 0.2e1 * t3453 * t1454 + 0.3e1 * t3453 * t1462 + 0.3e1 * t3450 * t1472 - 0.3e1 * t3468 * t1472 + t3448 + t3464 + t3467;
  t3479 = my_piecewise5(t114, 0, t115, 0, t3447 + t3477);
  t3481 = t52 * t308 * t958 / 0.8e1 + t113 * t3479;
  t3485 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3481);
  tv3lapl33 = t8 * t3485;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t630, t632, t633, t636, t638, t639;
  double t640, t642, t644, t645, t648, t650, t655, tv2rhosigma0;
  double tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4, t676;
  double t677, t680, t684, t685, t686, t687, t689, t690;
  double t692, t694, t695, t698, t700, t701, t702, t704;
  double t706, t707, t710, t712, t717, tv2rhosigma5, t724, t732;
  double t733, t735, t736, t740, t741, t744, t746, t748;
  double t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1, t774;
  double tv2rholapl2, t786, t787, t789, t790, t794, t795, t798;
  double t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826, t827;
  double t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t843, t846, t847, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t951, t952, t954, t958, t960, t964, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t968, t969, t972, t975, t976, t977, t980, t984;
  double t985, t989, t991, t996, t998, t1001, t1007, t1008;
  double t1011, t1013, t1016, t1020, t1023, t1030, t1036, t1037;
  double t1039, t1040, t1041, t1045, t1046, t1047, t1048, t1050;
  double t1051, t1052, t1055, t1056, t1057, t1058, t1059, t1061;
  double t1065, t1066, t1068, t1069, t1070, t1073, t1074, t1079;
  double t1083, t1087, t1088, t1091, t1092, t1097, t1098, t1102;
  double t1104, t1105, t1106, t1109, t1110, t1111, t1113, t1114;
  double t1118, t1122, t1126, t1127, t1128, t1130, t1133, t1135;
  double t1136, t1139, t1140, t1145, t1147, t1148, t1149, t1151;
  double t1153, t1155, t1160, t1162, t1163, t1166, t1169, t1172;
  double t1176, t1177, t1181, t1183, t1185, t1187, t1189, t1192;
  double t1194, tv3rho30, t1197, t1198, t1199, t1202, t1207, t1208;
  double t1210, t1214, t1215, t1219, t1222, t1226, t1228, t1232;
  double t1241, t1242, t1243, t1246, t1251, t1253, t1257, t1258;
  double t1262, t1265, t1266, t1268, t1277, t1279, t1282, tv3rho31;
  double t1285, t1290, t1294, t1298, t1299, t1303, t1305, t1314;
  double t1315, t1320, t1324, t1328, t1329, t1333, t1335, t1342;
  double t1350, t1352, t1353, tv3rho32, t1358, t1365, t1369, t1370;
  double t1377, t1378, t1385, t1389, t1390, t1407, t1410, t1417;
  double t1425, t1426, t1427, t1428, t1429, t1431, t1432, t1433;
  double t1436, t1437, t1438, t1439, t1441, t1445, t1446, t1449;
  double t1450, t1452, t1453, t1454, t1457, t1461, t1462, t1467;
  double t1469, t1471, t1472, t1477, t1479, t1480, t1481, t1483;
  double t1484, t1488, t1490, t1491, t1492, t1495, t1496, t1497;
  double t1499, t1500, t1504, t1508, t1512, t1513, t1516, t1519;
  double t1521, t1522, t1526, t1528, t1529, t1530, t1533, t1534;
  double t1535, t1537, t1539, t1541, t1546, tv3rho33, t1554, t1561;
  double t1563, t1566, t1567, t1570, t1578, t1579, t1582, t1583;
  double t1584, t1587, t1589, t1591, t1593, t1594, t1595, t1598;
  double t1599, t1602, t1603, t1604, t1605, t1608, t1609, t1612;
  double t1613, t1616, t1617, t1619, t1620, t1623, t1624, t1626;
  double t1627, t1633, t1634, t1638, t1639, t1642, t1647, t1649;
  double t1656, t1657, t1658, t1659, t1661, t1664, t1665, t1667;
  double t1668, t1674, t1675, t1676, t1678, t1680, t1681, t1682;
  double t1684, t1685, t1686, t1688, t1690, t1692, t1697, tv3rho2sigma0;
  double tv3rho2sigma1, t1704, t1708, t1710, tv3rho2sigma2, t1716, t1724, tv3rho2sigma3;
  double tv3rho2sigma4, t1730, t1737, t1740, tv3rho2sigma5, t1748, tv3rho2sigma6, tv3rho2sigma7;
  double t1760, t1761, t1764, t1773, t1774, t1777, t1778, t1779;
  double t1782, t1784, t1786, t1788, t1789, t1790, t1792, t1793;
  double t1794, t1795, t1798, t1799, t1802, t1803, t1806, t1807;
  double t1810, t1811, t1812, t1815, t1816, t1822, t1823, t1824;
  double t1825, t1828, t1829, t1833, t1834, t1841, t1843, t1849;
  double t1852, t1853, t1856, t1857, t1858, t1859, t1864, t1865;
  double t1867, t1868, t1869, t1871, t1872, t1873, t1875, t1876;
  double t1877, t1879, t1881, t1883, t1885, t1890, tv3rho2sigma8, t1897;
  double t1904, t1906, t1920, t1922, t1925, t1926, t1929, t1930;
  double t1932, t1935, t1936, t1939, t1940, t1943, t1945, t1949;
  double t1950, t1953, t1956, t1961, t1962, t1966, t1969, t1971;
  double t1972, t1973, t1975, t1977, t1985, t1986, t1989, t1990;
  double t1991, t1993, t2001, t2002, t2007, t2009, t2011, t2016;
  double tv3rho2lapl0, t2023, t2027, t2029, tv3rho2lapl1, t2035, t2043, tv3rho2lapl2;
  double t2049, t2056, t2059, tv3rho2lapl3, t2067, tv3rho2lapl4, t2090, t2091;
  double t2096, t2097, t2100, t2101, t2103, t2105, t2107, t2109;
  double t2110, t2113, t2114, t2119, t2120, t2124, t2125, t2126;
  double t2128, t2129, t2130, t2131, t2133, t2135, t2138, t2141;
  double t2146, t2147, t2153, t2155, t2156, t2157, t2160, t2162;
  double t2163, t2177, t2179, t2181, t2186, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1;
  double tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2193, t2199, t2200, t2201;
  double t2202, t2204, t2205, t2206, t2207, t2209, t2210, t2211;
  double t2212, t2213, t2215, t2216, t2217, t2220, t2221, t2222;
  double t2223, t2226, t2227, t2228, t2229, t2230, t2235, t2237;
  double t2238, t2239, t2240, t2242, t2244, t2245, t2246, t2247;
  double t2249, t2250, t2251, t2253, t2254, t2257, t2258, t2259;
  double t2260, t2262, t2263, t2265, t2266, t2269, t2270, t2274;
  double t2279, t2280, t2282, t2283, t2290, t2291, t2294, t2295;
  double t2298, t2299, t2300, t2301, t2303, t2304, t2309, t2311;
  double t2313, t2318, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2325;
  double t2327, tv3rhosigma25, t2333, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2343, t2344, t2345, t2348, t2349, t2350, t2353, t2354;
  double t2355, t2356, t2357, t2358, t2359, t2361, t2362, t2363;
  double t2364, t2366, t2367, t2368, t2369, t2370, t2372, t2373;
  double t2374, t2379, t2381, t2382, t2383, t2384, t2386, t2388;
  double t2389, t2390, t2391, t2393, t2394, t2395, t2397, t2398;
  double t2399, t2402, t2403, t2406, t2407, t2408, t2411, t2412;
  double t2413, t2415, t2416, t2418, t2421, t2422, t2427, t2428;
  double t2430, t2431, t2440, t2441, t2444, t2445, t2448, t2449;
  double t2450, t2451, t2453, t2455, t2457, t2462, tv3rhosigma211, t2469;
  double t2483, t2485, t2486, t2488, t2489, t2490, t2492, t2493;
  double t2495, t2496, t2498, t2500, t2501, t2502, t2504, t2505;
  double t2507, t2508, t2509, t2510, t2511, t2514, t2515, t2516;
  double t2517, t2519, t2520, t2521, t2524, t2527, t2528, t2529;
  double t2530, t2531, t2532, t2535, t2536, t2541, t2544, t2551;
  double t2552, t2558, t2559, t2563, t2566, t2568, t2570, t2575;
  double tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2582, t2584, tv3rhosigmalapl5;
  double t2590, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2606, t2608;
  double t2609, t2611, t2614, t2615, t2616, t2617, t2618, t2621;
  double t2622, t2624, t2625, t2627, t2629, t2631, t2632, t2634;
  double t2635, t2636, t2637, t2638, t2641, t2642, t2643, t2644;
  double t2645, t2648, t2649, t2651, t2652, t2655, t2656, t2659;
  double t2662, t2666, t2670, t2674, t2677, t2678, t2685, t2686;
  double t2690, t2692, t2694, t2699, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double tv3rhosigmatau11, t2706, t2714, t2720, t2721, t2723, t2724, t2726;
  double t2727, t2728, t2729, t2732, t2735, t2737, t2738, t2740;
  double t2742, t2743, t2745, t2747, t2750, t2751, t2754, t2757;
  double t2758, t2774, t2780, t2781, t2783, t2785, t2787, t2792;
  double tv3rholapl20, tv3rholapl21, t2799, t2801, tv3rholapl22, t2807, tv3rholapl23, tv3rholapl24;
  double t2821, t2822, t2824, t2825, t2826, t2828, t2829, t2833;
  double t2834, t2837, t2840, t2842, t2843, t2845, t2847, t2848;
  double t2850, t2852, t2856, t2864, t2870, t2871, t2876, t2881;
  double t2882, t2888, t2890, t2892, t2897, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21;
  double tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2901, t2902, t2903, t2906;
  double t2911, t2912, t2915, t2918, t2920, t2921, t2922, t2923;
  double t2924, t2925, t2926, t2927, t2928, t2930, t2931, t2937;
  double t2949, t2950, t2951, t2952, t2953, t2954, t2955, t2956;
  double t2957, t2958, t2959, t2961, t2962, t2963, t2964, t2965;
  double t2967, t2969, t2973, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2976, t2977, t2978, t2981;
  double t2986, t2987, t2990, t2993, t2995, t2996, t2997, t2998;
  double t2999, t3000, t3001, t3003, t3004, t3005, t3006, t3012;
  double t3024, t3025, t3026, t3027, t3028, t3029, t3030, t3031;
  double t3032, t3033, t3034, t3036, t3037, t3038, t3039, t3040;
  double t3042, t3044, t3048, tv3sigma39, t3054, t3055, t3060, t3061;
  double t3062, t3063, t3065, t3067, t3068, t3069, t3070, t3071;
  double t3072, t3073, t3074, t3075, t3076, t3077, t3078, t3079;
  double t3080, t3081, t3082, t3085, t3086, t3088, t3092, t3093;
  double t3096, t3097, t3098, t3102, t3103, t3108, t3111, t3112;
  double t3113, t3114, t3115, t3118, t3119, t3120, t3121, t3122;
  double t3123, t3124, t3126, t3128, t3132, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double t3138, t3139, t3144, t3145, t3146, t3147, t3151, t3152;
  double t3153, t3154, t3155, t3156, t3157, t3158, t3159, t3160;
  double t3161, t3162, t3163, t3164, t3165, t3166, t3168, t3169;
  double t3174, t3178, t3183, t3186, t3189, t3190, t3191, t3192;
  double t3193, t3198, t3201, t3202, t3203, t3204, t3205, t3206;
  double t3207, t3208, t3209, t3211, t3213, t3217, tv3sigma2lapl11, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3228, t3229, t3230, t3231, t3232;
  double t3234, t3235, t3236, t3238, t3239, t3241, t3242, t3243;
  double t3246, t3248, t3256, t3260, t3261, t3266, t3267, t3270;
  double t3271, t3274, t3275, t3276, t3277, t3279, t3281, t3285;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double t3296, t3297, t3298, t3299, t3300, t3302, t3303, t3304;
  double t3306, t3307, t3309, t3310, t3311, t3315, t3316, t3319;
  double t3320, t3323, t3324, t3332, t3340, t3341, t3342, t3343;
  double t3344, t3345, t3347, t3349, t3353, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1;
  double tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9;
  double tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3357, t3358, t3359, t3360, t3369;
  double t3371, t3372, t3373, t3374, t3375, t3376, t3377, t3378;
  double t3379, t3380, t3381, t3382, t3383, t3384, t3391, t3394;
  double t3395, t3396, t3398, t3399, t3400, t3411, t3413, t3415;
  double t3419, tv3lapl30, tv3lapl31, tv3lapl32, t3423, t3424, t3425, t3426;
  double t3435, t3436, t3437, t3438, t3439, t3441, t3442, t3443;
  double t3444, t3445, t3446, t3447, t3448, t3449, t3450, t3453;
  double t3463, t3464, t3465, t3466, t3467, t3468, t3477, t3479;
  double t3481, t3485, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30;
  double tv3tau31, tv3tau32, tv3tau33;

  double t3489, t3493, t3495, t3501, t3504, t3507, t3511, t3514;
  double t3521, t3532, t3533, t3541, t3542, t3543, t3544, t3545;
  double t3548, t3549, t3552, t3553, t3554, t3555, t3556, t3560;
  double t3564, t3567, t3569, t3571, t3572, t3573, t3574, t3575;
  double t3577, t3578, t3584, t3585, t3589, t3594, t3595, t3596;
  double t3599, t3601, t3605, t3608, t3609, t3612, t3614, t3618;
  double t3621, t3624, t3626, t3632, t3636, t3645, t3648, t3651;
  double t3652, t3656, t3660, t3663, t3664, t3667, t3669, t3675;
  double t3680, t3687, t3690, t3693, t3694, t3695, t3696, t3699;
  double t3702, t3703, t3704, t3705, t3708, t3710, t3713, t3714;
  double t3722, t3723, t3734, t3739, t3742, t3746, t3754, t3757;
  double t3759, t3760, t3765, t3766, t3772, t3779, t3780, t3785;
  double t3788, t3791, t3792, t3795, t3800, t3801, t3802, t3809;
  double t3810, t3821, t3825, t3831, t3833, t3834, t3840, t3846;
  double t3847, t3850, t3854, t3863, t3869, t3873, t3877, t3881;
  double t3883, t3884, t3885, t3887, t3888, t3894, t3899, t3902;
  double t3906, t3913, t3917, t3921, t3926, t3928, tv4rho40, t3935;
  double t3939, t3940, t3943, t3961, t3962, t3964, t3968, t3977;
  double t3983, t3984, t3986, t4000, t4001, t4018, t4020, t4024;
  double t4031, t4035, t4036, t4039, t4048, t4051, t4052, t4054;
  double t4056, t4057, tv4rho41, t4066, t4070, t4083, t4096, t4100;
  double t4109, t4122, t4123, t4132, t4145, t4149, t4156, t4160;
  double t4169, t4172, t4183, t4186, t4188, t4189, tv4rho42, t4210;
  double t4214, t4221, t4232, t4233, t4250, t4254, t4261, t4269;
  double t4278, t4288, t4290, t4291, tv4rho43, t4296, t4301, t4308;
  double t4312, t4321, t4333, t4336, t4343, t4354, t4355, t4363;
  double t4365, t4366, t4368, t4369, t4370, t4371, t4372, t4373;
  double t4374, t4375, t4376, t4378, t4379, t4382, t4383, t4384;
  double t4385, t4388, t4392, t4393, t4396, t4400, t4406, t4407;
  double t4408, t4416, t4417, t4419, t4422, t4425, t4429, t4432;
  double t4433, t4436, t4439, t4440, t4443, t4444, t4448, t4452;
  double t4455, t4462, t4470, t4471, t4474, t4475, t4480, t4482;
  double t4486, t4489, t4490, t4498, t4501, t4504, t4509, t4513;
  double t4514, t4517, t4518, t4521, t4522, t4523, t4524, t4527;
  double t4528, t4530, t4537, t4540, t4541, t4545, t4550, t4551;
  double t4555, t4558, t4559, t4569, t4573, t4577, t4582, t4586;
  double t4587, t4590, t4593, t4594, t4600, t4603, t4609, t4616;
  double t4619, t4620, t4629, t4630, t4641, t4645, t4651, t4656;
  double t4663, t4667, t4681, t4682, tv4rho44, t4690, t4696, t4699;
  double t4706, t4708, t4711, t4714, t4718, t4732, t4733, t4738;
  double t4739, t4743, t4744, t4745, t4751, t4753, t4754, t4758;
  double t4759, t4760, t4763, t4764, t4765, t4768, t4769, t4772;
  double t4775, t4777, t4778, t4781, t4784, t4787, t4788, t4792;
  double t4793, t4795, t4798, t4800, t4806, t4809, t4811, t4812;
  double t4816, t4817, t4823, t4826, t4829, t4832, t4835, t4846;
  double t4853, t4854, t4857, t4858, t4860, t4863, t4867, t4870;
  double t4873, t4875, t4878, t4879, t4882, t4884, t4885, t4890;
  double t4893, t4894, t4895, t4900, t4905, t4908, t4917, t4920;
  double t4923, t4924, t4927, t4929, t4936, t4943, t4944, t4952;
  double t4955, t4956, t4960, t4964, t4967, t4969, t4979, t4987;
  double t4990, t4993, t4997, t5000, t5005, t5010, t5014, t5022;
  double t5025, t5034, t5041, t5045, t5053, t5054, t5066, t5074;
  double t5077, t5092, t5096, t5103, tv4rho3sigma0, tv4rho3sigma1, t5110, t5113;
  double t5117, t5119, tv4rho3sigma2, t5121, t5127, t5132, t5136, t5145;
  double t5146, tv4rho3sigma3, tv4rho3sigma4, t5148, t5154, t5156, t5165, t5167;
  double t5170, tv4rho3sigma5, t5176, t5185, tv4rho3sigma6, tv4rho3sigma7, t5191, t5198;
  double t5206, t5208, t5209, tv4rho3sigma8, t5218, tv4rho3sigma9, tv4rho3sigma10, t5236;
  double t5240, t5254, t5255, t5260, t5265, t5266, t5269, t5273;
  double t5274, t5275, t5278, t5279, t5282, t5285, t5286, t5288;
  double t5291, t5294, t5296, t5297, t5300, t5301, t5303, t5306;
  double t5307, t5311, t5314, t5316, t5317, t5320, t5323, t5325;
  double t5330, t5331, t5336, t5344, t5347, t5354, t5360, t5363;
  double t5374, t5375, t5378, t5379, t5381, t5384, t5386, t5389;
  double t5391, t5394, t5395, t5396, t5399, t5404, t5406, t5409;
  double t5412, t5414, t5419, t5422, t5431, t5434, t5435, t5436;
  double t5439, t5444, t5447, t5450, t5451, t5455, t5459, t5464;
  double t5467, t5469, t5472, t5479, t5486, t5487, t5493, t5496;
  double t5501, t5504, t5506, t5515, t5518, t5519, t5535, t5538;
  double t5547, t5554, t5565, t5569, t5574, t5577, t5581, t5600;
  double t5608, t5611, t5616, t5620, t5627, tv4rho3sigma11, t5634, t5640;
  double t5643, t5650, t5652, t5655, t5678, t5679, t5684, t5685;
  double t5696, t5697, t5698, t5701, t5702, t5705, t5706, t5707;
  double t5710, t5711, t5714, t5715, t5733, t5740, t5745, t5751;
  double t5754, t5755, t5758, t5761, t5764, t5765, t5769, t5776;
  double t5779, t5782, t5787, t5788, t5793, t5806, t5808, t5811;
  double t5816, t5817, t5820, t5824, t5827, t5831, t5840, t5843;
  double t5849, t5860, t5863, t5869, t5880, t5882, t5898, t5903;
  double t5922, t5925, t5928, t5931, t5939, t5942, t5945, t5962;
  double t5966, t5973, tv4rho3lapl0, t5980, t5983, t5987, t5989, tv4rho3lapl1;
  double t5991, t5997, t6002, t6006, t6015, t6016, tv4rho3lapl2, t6018;
  double t6024, t6026, t6035, t6037, t6040, tv4rho3lapl3, t6046, t6055;
  double tv4rho3lapl4, t6061, t6068, t6076, t6078, t6079, tv4rho3lapl5, t6088;
  double tv4rho3lapl6, t6126, t6127, t6130, t6131, t6134, t6140, t6141;
  double t6142, t6147, t6148, t6152, t6157, t6160, t6164, t6165;
  double t6166, t6174, t6183, t6184, t6193, t6194, t6195, t6200;
  double t6203, t6211, t6219, t6222, t6223, t6226, t6229, t6230;
  double t6233, t6234, t6238, t6241, t6244, t6247, t6250, t6253;
  double t6256, t6259, t6268, t6279, t6282, t6286, t6310, t6315;
  double t6322, t6324, t6329, t6331, t6336, t6338, t6344, t6348;
  double t6352, t6357, t6360, t6361, t6364, t6384, t6387, t6388;
  double t6393, t6406, t6410, t6421, t6424, t6428, t6435, tv4rho3lapl7;
  double tv4rho3tau0, tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7;
  double t6442, t6449, t6451, t6462, t6463, t6465, t6466, t6467;
  double t6475, t6476, t6485, t6486, t6489, t6491, t6492, t6493;
  double t6496, t6497, t6498, t6499, t6500, t6506, t6508, t6511;
  double t6514, t6515, t6524, t6526, t6527, t6529, t6533, t6534;
  double t6537, t6542, t6545, t6548, t6549, t6553, t6556, t6560;
  double t6561, t6571, t6579, t6592, t6593, t6595, t6596, t6597;
  double t6599, t6602, t6605, t6608, t6611, t6612, t6613, t6617;
  double t6621, t6626, t6627, t6630, t6633, t6634, t6635, t6642;
  double t6645, t6647, t6650, t6652, t6655, t6658, t6659, t6662;
  double t6664, t6666, t6676, t6677, t6681, t6686, t6687, t6689;
  double t6691, t6693, t6695, t6705, t6710, t6730, t6736, t6738;
  double t6740, t6743, t6744, t6746, t6753, t6755, t6756, t6757;
  double t6761, t6766, t6767, t6771, t6781, t6784, t6790, t6792;
  double t6793, t6795, t6796, t6800, t6802, t6805, t6808, t6822;
  double t6823, t6827, t6832, t6836, t6837, t6839, t6840, t6845;
  double t6849, t6850, t6851, t6852, t6856, t6863, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t6870, t6874, t6876, tv4rho2sigma25, t6882;
  double t6890, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t6896, t6903;
  double t6906, tv4rho2sigma211, t6914, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t6934, t6935, t6936, t6938, t6939, t6947, t6951, t6957;
  double t6958, t6961, t6962, t6966, t6969, t6972, t6973, t6974;
  double t6977, t6980, t6990, t6992, t6994, t6996, t6997, t7000;
  double t7001, t7002, t7003, t7019, t7028, t7032, t7033, t7034;
  double t7037, t7040, t7052, t7055, t7056, t7059, t7062, t7063;
  double t7065, t7066, t7067, t7068, t7072, t7075, t7077, t7078;
  double t7080, t7081, t7083, t7086, t7092, t7093, t7095, t7096;
  double t7100, t7102, t7106, t7110, t7112, t7116, t7119, t7120;
  double t7125, t7126, t7127, t7133, t7140, t7145, t7151, t7161;
  double t7166, t7175, t7180, t7181, t7184, t7187, t7192, t7195;
  double t7196, t7206, t7207, t7209, t7211, t7213, t7215, t7230;
  double t7231, t7232, t7235, t7239, t7241, t7249, t7251, t7254;
  double t7258, t7260, t7261, t7264, t7268, t7272, t7276, t7277;
  double t7284, t7288, t7289, t7291, t7292, t7296, t7297, t7298;
  double t7301, t7302, t7305, t7306, t7310, t7314, t7319, t7322;
  double t7326, t7333, tv4rho2sigma217, t7340, t7347, t7349, t7372, t7373;
  double t7376, t7379, t7380, t7383, t7392, t7393, t7394, t7398;
  double t7399, t7407, t7410, t7413, t7420, t7427, t7432, t7439;
  double t7440, t7441, t7442, t7443, t7445, t7448, t7451, t7453;
  double t7456, t7457, t7462, t7463, t7464, t7465, t7468, t7473;
  double t7477, t7480, t7489, t7498, t7509, t7513, t7520, t7521;
  double t7522, t7523, t7531, t7537, t7541, t7542, t7549, t7550;
  double t7553, t7566, t7576, t7577, t7579, t7586, t7589, t7592;
  double t7615, t7638, t7651, t7662, t7684, t7687, t7694, t7700;
  double t7721, t7725, t7732, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4;
  double t7739, t7743, t7745, tv4rho2sigmalapl5, t7751, t7759, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t7765, t7772, t7775, tv4rho2sigmalapl11, t7783;
  double tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t7816, t7817, t7821;
  double t7823, t7830, t7836, t7840, t7844, t7845, t7848, t7849;
  double t7852, t7857, t7858, t7866, t7869, t7871, t7872, t7875;
  double t7876, t7877, t7883, t7884, t7885, t7886, t7890, t7891;
  double t7893, t7894, t7895, t7902, t7907, t7909, t7915, t7927;
  double t7931, t7937, t7941, t7946, t7954, t7961, t7962, t7965;
  double t7974, t7976, t7990, t7994, t8004, t8012, t8016, t8017;
  double t8022, t8027, t8035, t8058, t8059, t8062, t8065, t8079;
  double t8096, t8114, t8122, t8127, t8135, t8165, t8169, t8176;
  double tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6;
  double tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14;
  double tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t8183, t8190, t8192, t8207, t8208;
  double t8216, t8221, t8222, t8234, t8237, t8238, t8247, t8248;
  double t8255, t8258, t8269, t8270, t8271, t8280, t8285, t8290;
  double t8291, t8295, t8298, t8300, t8305, t8310, t8322, t8327;
  double t8329, t8345, t8357, t8361, t8367, t8376, t8383, t8386;
  double t8395, t8411, t8412, t8415, t8424, t8426, t8427, t8428;
  double t8444, t8447, t8452, t8459, t8464, t8470, t8475, t8479;
  double t8484, t8488, t8495, tv4rho2lapl20, tv4rho2lapl21, t8502, t8506, t8508;
  double tv4rho2lapl22, t8514, t8522, tv4rho2lapl23, tv4rho2lapl24, t8528, t8535, t8538;
  double tv4rho2lapl25, t8546, tv4rho2lapl26, tv4rho2lapl27, t8570, t8574, t8579, t8580;
  double t8583, t8586, t8589, t8590, t8597, t8598, t8604, t8607;
  double t8608, t8609, t8622, t8623, t8626, t8631, t8650, t8655;
  double t8659, t8670, t8672, t8675, t8676, t8682, t8688, t8693;
  double t8696, t8701, t8717, t8729, t8736, t8745, t8749, t8752;
  double t8753, t8759, t8775, t8784, t8786, t8801, t8809, t8811;
  double t8818, t8829, t8832, t8833, t8841, t8845, t8852, tv4rho2lapl28;
  double tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7;
  double tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20, tv4rho2tau21, tv4rho2tau22, tv4rho2tau23;
  double tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28, t8859, t8865, t8866;
  double t8867, t8868, t8871, t8873, t8874, t8876, t8879, t8882;
  double t8884, t8886, t8887, t8889, t8891, t8892, t8893, t8894;
  double t8897, t8899, t8902, t8903, t8906, t8907, t8910, t8912;
  double t8913, t8916, t8917, t8918, t8920, t8921, t8922, t8923;
  double t8928, t8931, t8934, t8936, t8938, t8941, t8942, t8943;
  double t8944, t8946, t8948, t8955, t8957, t8958, t8959, t8962;
  double t8963, t8967, t8972, t8975, t8976, t8979, t8980, t8981;
  double t8982, t8988, t8991, t8993, t8999, t9007, t9012, t9015;
  double t9018, t9019, t9021, t9024, t9029, t9031, t9037, t9043;
  double t9045, t9058, t9063, t9065, t9068, t9075, t9082, t9085;
  double t9086, t9092, t9097, t9101, t9106, t9110, t9114, t9116;
  double t9118, t9119, t9121, t9123, t9124, t9133, t9137, t9139;
  double t9141, t9149, t9157, t9161, t9168, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32;
  double tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t9175, t9177;
  double tv4rhosigma39, t9183, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t9193, t9194, t9195, t9196, t9197;
  double t9199, t9200, t9201, t9204, t9205, t9206, t9208, t9211;
  double t9214, t9215, t9217, t9219, t9222, t9224, t9225, t9228;
  double t9231, t9234, t9239, t9240, t9241, t9245, t9246, t9249;
  double t9251, t9252, t9255, t9257, t9260, t9262, t9264, t9267;
  double t9268, t9269, t9271, t9272, t9273, t9274, t9276, t9278;
  double t9285, t9287, t9288, t9289, t9292, t9295, t9298, t9300;
  double t9302, t9305, t9308, t9309, t9313, t9318, t9320, t9321;
  double t9322, t9328, t9333, t9337, t9340, t9341, t9343, t9346;
  double t9349, t9350, t9353, t9355, t9360, t9364, t9367, t9370;
  double t9373, t9378, t9381, t9396, t9401, t9404, t9405, t9408;
  double t9411, t9415, t9421, t9427, t9430, t9437, t9446, t9448;
  double t9452, t9454, t9462, t9466, t9478, t9481, t9482, t9484;
  double t9486, t9487, t9489, t9493, t9500, tv4rhosigma319, t9507, t9522;
  double t9523, t9527, t9532, t9533, t9537, t9541, t9544, t9545;
  double t9547, t9548, t9553, t9554, t9557, t9559, t9560, t9566;
  double t9567, t9571, t9577, t9578, t9579, t9581, t9582, t9585;
  double t9592, t9600, t9605, t9607, t9610, t9617, t9624, t9625;
  double t9629, t9633, t9635, t9637, t9646, t9647, t9650, t9656;
  double t9659, t9666, t9668, t9671, t9673, t9676, t9680, t9705;
  double t9717, t9718, t9737, t9738, t9742, t9756, t9757, t9758;
  double t9764, t9779, t9795, t9796, t9799, t9803, t9809, t9811;
  double t9812, t9813, t9823, t9825, t9837, t9838, t9839, t9845;
  double t9858, t9859, t9860, t9866, t9873, t9878, t9885, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, t9892, t9894, tv4rhosigma2lapl11, t9900, tv4rhosigma2lapl12, tv4rhosigma2lapl13;
  double tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21;
  double tv4rhosigma2lapl22, t9917, t9918, t9923, t9924, t9927, t9928, t9933;
  double t9936, t9937, t9941, t9944, t9946, t9947, t9951, t9956;
  double t9961, t9964, t9965, t9967, t9968, t9971, t9976, t9977;
  double t9978, t9981, t9988, t9989, t9996, t10000, t10002, t10003;
  double t10005, t10007, t10015, t10021, t10022, t10026, t10028, t10040;
  double t10047, t10054, t10055, t10057, t10060, t10067, t10083, t10088;
  double t10097, t10116, t10117, t10119, t10120, t10121, t10127, t10132;
  double t10134, t10139, t10153, t10160, t10161, t10164, t10165, t10193;
  double t10198, t10201, t10207, t10212, t10232, t10237, t10238, t10243;
  double t10245, t10246, t10247, t10256, t10261, t10268, tv4rhosigma2lapl23, tv4rhosigma2tau0;
  double tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8;
  double tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16;
  double tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, t10275;
  double t10287, t10290, t10291, t10294, t10303, t10306, t10311, t10312;
  double t10313, t10316, t10317, t10324, t10325, t10328, t10334, t10341;
  double t10342, t10346, t10367, t10376, t10382, t10385, t10393, t10426;
  double t10447, t10452, t10460, t10481, t10485, t10506, t10549, t10566;
  double t10570, t10575, t10582, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24;
  double tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t10589, t10591, tv4rhosigmalapl28, t10597, tv4rhosigmalapl29;
  double tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, t10612;
  double t10613, t10614, t10615, t10620, t10621, t10624, t10627, t10631;
  double t10634, t10643, t10648, t10653, t10658, t10669, t10682, t10683;
  double t10687, t10694, t10704, t10712, t10720, t10728, t10731, t10742;
  double t10751, t10772, t10778, t10797, t10809, t10822, t10872, t10888;
  double t10893, t10898, t10905, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3;
  double tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11;
  double tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19;
  double tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23;
  double tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211;
  double tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, t10912, t10920;
  double t10921, t10922, t10925, t10936, t10937, t10940, t10945, t10954;
  double t10967, t10975, t10976, t10978, t10981, t10984, t10994, t11005;
  double t11012, t11014, t11021, t11023, t11031, t11035, t11038, t11043;
  double t11045, t11056, t11057, t11062, t11078, t11079, t11091, t11100;
  double t11105, t11107, t11112, t11120, t11131, t11132, t11136, t11143;
  double tv4rholapl30, tv4rholapl31, tv4rholapl32, t11150, t11152, tv4rholapl33, t11158, tv4rholapl34;
  double tv4rholapl35, tv4rholapl36, t11170, t11171, t11172, t11175, t11183, t11186;
  double t11187, t11191, t11192, t11193, t11194, t11199, t11205, t11210;
  double t11223, t11234, t11235, t11238, t11241, t11246, t11247, t11264;
  double t11267, t11269, t11273, t11277, t11286, t11290, t11301, t11303;
  double t11307, t11316, t11318, t11326, t11329, t11333, t11337, t11340;
  double t11341, t11363, t11366, t11368, t11378, t11392, t11393, t11397;
  double t11404, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5;
  double tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21;
  double tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29;
  double tv4rholapltau210, tv4rholapltau211, tv4rhotau30, tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35;
  double tv4rhotau36, tv4rhotau37, t11413, t11414, t11419, t11422, t11423, t11425;
  double t11428, t11431, t11439, t11441, t11442, t11445, t11446, t11448;
  double t11450, t11451, t11454, t11457, t11459, t11460, t11462, t11464;
  double t11472, t11474, t11478, t11479, t11481, t11484, t11485, t11488;
  double t11491, t11492, t11494, t11498, t11503, t11509, t11511, t11512;
  double t11515, t11522, t11524, t11527, t11543, t11547, t11554, t11555;
  double t11557, t11560, t11562, t11569, t11585, t11593, t11597, t11608;
  double t11612, t11618, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45;
  double tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413;
  double t11626, t11629, t11632, t11637, t11638, t11640, t11643, t11646;
  double t11652, t11654, t11655, t11657, t11660, t11661, t11663, t11664;
  double t11667, t11671, t11673, t11675, t11678, t11679, t11681, t11684;
  double t11685, t11687, t11689, t11693, t11694, t11696, t11701, t11706;
  double t11707, t11713, t11718, t11720, t11724, t11725, t11728, t11731;
  double t11740, t11758, t11764, t11768, t11769, t11771, t11774, t11776;
  double t11779, t11789, t11790, t11795, t11802, t11803, t11822, t11826;
  double t11832, tv4sigma414, t11838, t11839, t11840, t11841, t11846, t11847;
  double t11851, t11852, t11853, t11854, t11855, t11856, t11857, t11858;
  double t11859, t11860, t11861, t11862, t11863, t11864, t11865, t11869;
  double t11875, t11876, t11877, t11878, t11880, t11881, t11883, t11884;
  double t11885, t11886, t11887, t11888, t11890, t11891, t11909, t11910;
  double t11912, t11913, t11916, t11917, t11918, t11920, t11923, t11930;
  double t11937, t11940, t11942, t11947, t11955, t11962, t11969, t11970;
  double t11976, t11977, t11984, t12000, t12011, t12012, t12021, t12040;
  double t12048, t12052, t12058, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t12064, t12065;
  double t12066, t12067, t12068, t12069, t12070, t12071, t12072, t12073;
  double t12074, t12075, t12076, t12077, t12081, t12089, t12090, t12091;
  double t12093, t12094, t12097, t12098, t12104, t12105, t12107, t12108;
  double t12109, t12110, t12111, t12113, t12114, t12125, t12126, t12128;
  double t12129, t12130, t12134, t12135, t12136, t12137, t12138, t12140;
  double t12141, t12142, t12144, t12147, t12152, t12156, t12167, t12175;
  double t12184, t12185, t12186, t12194, t12195, t12212, t12215, t12220;
  double t12229, t12230, t12242, t12262, t12269, t12273, t12279, tv4sigma3lapl19;
  double tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7;
  double tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15;
  double tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19, t12286, t12288, t12292, t12297;
  double t12314, t12317, t12327, t12331, t12334, t12335, t12336, t12339;
  double t12344, t12355, t12360, t12381, t12383, t12384, t12386, t12388;
  double t12390, t12392, t12393, t12398, t12406, t12410, t12414, t12422;
  double t12427, t12442, t12444, t12447, t12451, t12467, t12470, t12474;
  double t12480, t12481, t12495, t12499, t12505, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22;
  double tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210;
  double tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, t12515, t12532;
  double t12535, t12540, t12547, t12552, t12553, t12559, t12563, t12570;
  double t12578, t12580, t12593, t12594, t12596, t12597, t12599, t12601;
  double t12603, t12605, t12613, t12615, t12620, t12624, t12630, t12646;
  double t12657, t12659, t12664, t12666, t12682, t12690, t12691, t12696;
  double t12697, t12706, t12710, t12712, t12721, t12725, t12731, tv4sigma2lapl217;
  double tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7;
  double tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15;
  double tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23;
  double tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27;
  double tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215;
  double tv4sigma2tau216, tv4sigma2tau217, t12739, t12740, t12745, t12749, t12753, t12757;
  double t12769, t12779, t12782, t12812, t12817, t12824, t12838, t12844;
  double t12850, t12867, t12875, t12880, t12884, t12890, tv4sigmalapl30, tv4sigmalapl31;
  double tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39;
  double tv4sigmalapl310, t12896, t12900, t12903, t12906, t12911, t12913, t12917;
  double t12932, t12935, t12945, t12977, t12992, t12997, t13000, t13017;
  double t13036, t13039, t13043, t13049, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2;
  double tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10;
  double tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20;
  double tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28;
  double tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216;
  double tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36;
  double tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311, t13056, t13062, t13065;
  double t13076, t13077, t13083, t13084, t13090, t13092, t13118, t13119;
  double t13122, t13124, t13127, t13130, t13153, t13154, t13175, t13204;
  double t13208, t13214, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, t13221, t13222;
  double t13227, t13238, t13242, t13243, t13246, t13249, t13252, t13259;
  double t13265, t13281, t13282, t13285, t13288, t13291, t13296, t13311;
  double t13326, t13345, t13370, t13374, t13380, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1;
  double tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21;
  double tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30;
  double tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, tv4tau40;
  double tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t59 * t174 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t232 * t125 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t59 * t266 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t278 * t125 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t399 * t172 + t163 * t392 * t396 + t379 * t380 * t390 - t409 * t396 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t59 * t416 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t580 * t243 + t234 * t573 * t577 + t560 * t561 * t571 - t590 * t577 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t554 * t125 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t630 = t394 * t395 * t165;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t633 * t172 + t623 * t625 + t628 * t630 + t628 * t640 - t642 * t630 - t642 * t645 - t638);
  t650 = t161 * t266 + t260 * t174 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t8 * t655 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t8 * t664 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t8 * t670 + t272;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t695 * t243 + t685 * t687 + t690 * t692 + t690 * t702 - t704 * t692 - t704 * t707 - t700);
  t712 = t113 * t710 + t680 * t125 + t232 * t284 + t278 * t245 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t8 * t717 + t290;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t741 * t172 + t623 * t733 + t736 * t630 - t748 * t630 + t736 * t640 - t748 * t645 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t8 * t759 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t8 * t768 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t8 * t774 + t307;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t795 * t243 + t685 * t787 + t790 * t692 - t802 * t692 + t790 * t702 - t802 * t707 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t820 * t396 + t379 * t817 * t390 - t830 * t396 + t827 * t407 - t830 * t413 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t847 = t234 * t846;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t560 * t843 * t571 + t847 * t577 - t856 * t577 + t853 * t588 - t856 * t594 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t922 * t390 + t926 * t396 - t931 * t396 + t928 * t407 - t931 * t413 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t234 * t948 * t577 + t560 * t945 * t571 - t954 * t577 + t951 * t588 - t954 * t594 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t968 = 0.1e1 / t26 / t21;
  t969 = t328 * t136;
  t972 = t327 * t136;
  t975 = t132 * t132;
  t976 = 0.1e1 / t975;
  t977 = t18 * t976;
  t980 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t332 - 0.6e1 * t977);
  t984 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t969 + 0.1e2 / 0.3e1 * t972 * t336 + 0.5e1 / 0.3e1 * t27 * t980);
  t985 = t984 * t31;
  t989 = t340 * t144;
  t991 = t7 * t989 * t79;
  t996 = t139 * t353;
  t998 = t7 * t996 * t79;
  t1001 = t7 * t345 * t176;
  t1007 = 0.1e1 / t30 / t132;
  t1008 = t29 * t1007;
  t1011 = 0.2e1 / 0.45e2 * t7 * t1008 * t79;
  t1013 = t7 * t354 * t176;
  t1016 = t7 * t145 * t418;
  t1020 = 0.1e1 / t41 / t361 / rho[0];
  t1023 = 0.77e3 / 0.243e3 * t38 * sigma[0] * t1020;
  t1030 = -0.154e3 / 0.81e2 * t47 * t48 * t1020 - 0.55e2 / 0.81e2 * t52 * t53 * t363 + t1023;
  t1036 = t380 * t165;
  t1037 = t1036 * t167;
  t1039 = t388 * t403;
  t1040 = t411 * t1039;
  t1041 = t379 * t1037 * t1040;
  t1045 = t76 / t377 / t72;
  t1046 = t382 * t167;
  t1047 = t1036 * t1046;
  t1048 = t1045 * t1047;
  t1050 = 0.1e1 / t383 / t71;
  t1051 = t1050 * t386;
  t1052 = t1051 * t412;
  t1055 = t163 * t1047;
  t1056 = t1050 * t74;
  t1057 = params->csk_a * params->csk_a;
  t1058 = t170 * t1057;
  t1059 = t1056 * t1058;
  t1061 = t379 * t1047;
  t1065 = t386 * t74;
  t1066 = t1050 * t1065;
  t1068 = 0.1e1 / t387 / t75;
  t1069 = t1068 * t1057;
  t1070 = t1066 * t1069;
  t1073 = t388 * t1057;
  t1074 = t1051 * t1073;
  t1079 = t163 * t399 * t165 * t405;
  t1083 = t388 * t399;
  t1087 = t1068 * params->csk_a;
  t1088 = t1066 * t1087;
  t1091 = t1050 * params->csk_a;
  t1092 = t1091 * t171;
  t1097 = 0.3e1 * t623 * t411 * t1083 + 0.3e1 * t1048 * t1052 - t1048 * t1059 - 0.2e1 * t1048 * t1070 - 0.3e1 * t1048 * t1074 + 0.3e1 * t1048 * t1088 - t1055 * t1059 - 0.3e1 * t1055 * t1092 + 0.3e1 * t1061 * t1059 + 0.3e1 * t1061 * t1074 + 0.3e1 * t1061 * t1092 + 0.3e1 * t1041 - 0.3e1 * t1079;
  t1098 = t399 * t382;
  t1102 = t1036 * t403;
  t1104 = t170 * t167;
  t1105 = t394 * t1104;
  t1106 = t163 * t1102 * t1105;
  t1109 = t1046 * t1050;
  t1110 = t1065 * t1068;
  t1111 = t1109 * t1110;
  t1113 = my_piecewise3(t67, 0, t1030);
  t1114 = my_piecewise3(t69, t1113, 0);
  t1118 = t1109 * t171;
  t1122 = t1109 * t389;
  t1126 = t395 * t403;
  t1127 = t394 * t1126;
  t1128 = t163 * t1037 * t1127;
  t1130 = t379 * t1098;
  t1133 = t379 * t1102;
  t1135 = t411 * t412 * t167;
  t1136 = t1133 * t1135;
  t1139 = t395 * t399;
  t1140 = t394 * t1139;
  t1145 = t384 * params->csk_a;
  t1147 = t167 * t74 * t170;
  t1148 = t1145 * t1147;
  t1149 = t1133 * t1148;
  t1151 = -t1045 * t1036 * t1111 - 0.2e1 * t163 * t1036 * t1118 - 0.3e1 * t379 * t1036 * t1122 + 0.3e1 * t163 * t1098 * t640 - t163 * t1114 * t172 + 0.3e1 * t163 * t622 * t1140 - 0.3e1 * t1130 * t630 - 0.3e1 * t1130 * t645 + 0.3e1 * t1106 + 0.3e1 * t1128 - 0.3e1 * t1136 - 0.3e1 * t1149 - t406;
  t1153 = my_piecewise5(t64, 0, t67, 0, t1097 + t1151);
  t1155 = t1030 * t77 + t59 * t1153 + 0.3e1 * t161 * t416 + 0.3e1 * t373 * t174 - t1023;
  t1160 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t79 + 0.3e1 / 0.1e2 * t991 + 0.9e1 / 0.2e2 * t7 * t341 * t176 - t998 / 0.1e2 + 0.3e1 / 0.5e1 * t1001 + 0.9e1 / 0.2e2 * t7 * t140 * t418 + t1011 - t1013 / 0.1e2 + 0.3e1 / 0.1e2 * t1016 + 0.3e1 / 0.2e2 * t7 * t32 * t1155);
  t1162 = 0.1e1 / t90 / t88;
  t1163 = t425 * t184;
  t1166 = t424 * t184;
  t1169 = t85 * t976;
  t1172 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t332 - 0.6e1 * t1169);
  t1176 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1162 * t1163 + 0.1e2 / 0.3e1 * t1166 * t431 + 0.5e1 / 0.3e1 * t91 * t1172);
  t1177 = t1176 * t31;
  t1181 = t435 * t144;
  t1183 = t7 * t1181 * t127;
  t1185 = t187 * t353;
  t1187 = t7 * t1185 * t127;
  t1189 = t93 * t1007;
  t1192 = 0.2e1 / 0.45e2 * t7 * t1189 * t127;
  t1194 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1177 * t127 + 0.3e1 / 0.1e2 * t1183 - t1187 / 0.1e2 + t1192);
  tv3rho30 = 0.3e1 * t423 + 0.3e1 * t449 + t8 * (t1160 + t1194);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1197 = 0.2e1 * t475;
  t1198 = 0.2e1 * t501;
  t1199 = t968 * t201;
  t1202 = t327 * t456;
  t1207 = 0.2e1 * t332;
  t1208 = 0.6e1 * t977;
  t1210 = my_piecewise5(t12, 0, t16, 0, t1207 - t1208);
  t1214 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1199 * t328 + 0.2e2 / 0.9e1 * t1202 * t136 + 0.1e2 / 0.9e1 * t452 * t336 + 0.5e1 / 0.3e1 * t27 * t1210);
  t1215 = t1214 * t31;
  t1219 = t460 * t144;
  t1222 = t7 * t1219 * t79 / 0.5e1;
  t1226 = t204 * t353;
  t1228 = t7 * t1226 * t79;
  t1232 = t7 * t465 * t176 / 0.5e1;
  t1241 = 0.3e1 / 0.2e2 * t7 * t1215 * t79 + t1222 + 0.3e1 / 0.1e2 * t7 * t461 * t176 - t1228 / 0.3e2 + t1232 + 0.3e1 / 0.2e2 * t7 * t205 * t418 + t991 / 0.1e2 - t998 / 0.15e2 + t1001 / 0.5e1 + t1011 - t1013 / 0.15e2 + t1016 / 0.1e2;
  t1242 = my_piecewise3(t2, 0, t1241);
  t1243 = t1162 * t212;
  t1246 = t424 * t480;
  t1251 = 0.6e1 * t1169;
  t1253 = my_piecewise5(t16, 0, t12, 0, -t1207 - t1251);
  t1257 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1243 * t425 + 0.2e2 / 0.9e1 * t1246 * t184 + 0.1e2 / 0.9e1 * t476 * t431 + 0.5e1 / 0.3e1 * t91 * t1253);
  t1258 = t1257 * t31;
  t1262 = t484 * t144;
  t1265 = t7 * t1262 * t127 / 0.5e1;
  t1266 = t215 * t353;
  t1268 = t7 * t1266 * t127;
  t1277 = t7 * t440 * t247 / 0.5e1;
  t1279 = t7 * t444 * t247;
  t1282 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1258 * t127 + t1265 - t1268 / 0.3e2 + t1183 / 0.1e2 - t1187 / 0.15e2 + t1192 + 0.3e1 / 0.2e2 * t7 * t436 * t247 + t1277 - t1279 / 0.3e2);
  tv3rho31 = t423 + t449 + t1197 + t1198 + t8 * (t1242 + t1282);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1285 = t968 * t506;
  t1290 = t327 * t511;
  t1294 = my_piecewise5(t12, 0, t16, 0, -t1207 - t1208);
  t1298 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1285 * t136 + 0.2e2 / 0.9e1 * t452 * t456 + 0.1e2 / 0.9e1 * t1290 * t136 + 0.5e1 / 0.3e1 * t27 * t1294);
  t1299 = t1298 * t31;
  t1303 = t515 * t144;
  t1305 = t7 * t1303 * t79;
  t1314 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1299 * t79 + t1305 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t176 + t1222 - t1228 / 0.15e2 + t1232 - t998 / 0.3e2 + t1011 - t1013 / 0.3e2);
  t1315 = t1162 * t523;
  t1320 = t424 * t528;
  t1324 = my_piecewise5(t16, 0, t12, 0, t1207 - t1251);
  t1328 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1315 * t184 + 0.2e2 / 0.9e1 * t476 * t480 + 0.1e2 / 0.9e1 * t1320 * t184 + 0.5e1 / 0.3e1 * t91 * t1324);
  t1329 = t1328 * t31;
  t1333 = t532 * t144;
  t1335 = t7 * t1333 * t127;
  t1342 = t7 * t489 * t247;
  t1350 = t7 * t192 * t599;
  t1352 = 0.3e1 / 0.2e2 * t7 * t1329 * t127 + t1335 / 0.1e2 + t1265 - t1268 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t247 + t1342 / 0.5e1 - t1187 / 0.3e2 + t1192 + t1277 - t1279 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t599 + t1350 / 0.1e2;
  t1353 = my_piecewise3(t84, 0, t1352);
  tv3rho32 = t1197 + t1198 + t522 + t604 + t8 * (t1314 + t1353);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1358 = t506 * t201;
  t1365 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t332 - 0.6e1 * t977);
  t1369 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t1358 + 0.1e2 / 0.3e1 * t452 * t511 + 0.5e1 / 0.3e1 * t27 * t1365);
  t1370 = t1369 * t31;
  t1377 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1370 * t79 + 0.3e1 / 0.1e2 * t1305 - t1228 / 0.1e2 + t1011);
  t1378 = t523 * t212;
  t1385 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t332 - 0.6e1 * t1169);
  t1389 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1162 * t1378 + 0.1e2 / 0.3e1 * t476 * t528 + 0.5e1 / 0.3e1 * t91 * t1385);
  t1390 = t1389 * t31;
  t1407 = 0.1e1 / t97 / t542 / rho[1];
  t1410 = 0.77e3 / 0.243e3 * t38 * sigma[2] * t1407;
  t1417 = -0.154e3 / 0.81e2 * t47 * t103 * t1407 - 0.55e2 / 0.81e2 * t52 * t107 * t544 + t1410;
  t1425 = t124 / t558 / t120;
  t1426 = t561 * t236;
  t1427 = t563 * t238;
  t1428 = t1426 * t1427;
  t1429 = t1425 * t1428;
  t1431 = 0.1e1 / t564 / t119;
  t1432 = t1431 * t567;
  t1433 = t1432 * t593;
  t1436 = t234 * t1428;
  t1437 = t1431 * t122;
  t1438 = t241 * t1057;
  t1439 = t1437 * t1438;
  t1441 = t560 * t1428;
  t1445 = t1431 * t1057;
  t1446 = t1445 * t570;
  t1449 = t567 * t122;
  t1450 = t1431 * t1449;
  t1452 = 0.1e1 / t568 / t123;
  t1453 = t1452 * t1057;
  t1454 = t1450 * t1453;
  t1457 = t569 * t580;
  t1461 = t1452 * params->csk_a;
  t1462 = t1450 * t1461;
  t1467 = t580 * t236;
  t1469 = t234 * t1467 * t586;
  t1471 = t1431 * params->csk_a;
  t1472 = t1471 * t242;
  t1477 = t1426 * t238;
  t1479 = t569 * t584;
  t1480 = t592 * t1479;
  t1481 = t560 * t1477 * t1480;
  t1483 = 0.3e1 * t685 * t592 * t1457 + 0.3e1 * t1429 * t1433 - t1429 * t1439 - 0.3e1 * t1429 * t1446 - 0.2e1 * t1429 * t1454 + 0.3e1 * t1429 * t1462 - t1436 * t1439 - 0.3e1 * t1436 * t1472 + 0.3e1 * t1441 * t1439 + 0.3e1 * t1441 * t1446 + 0.3e1 * t1441 * t1472 - 0.3e1 * t1469 + 0.3e1 * t1481;
  t1484 = t580 * t563;
  t1488 = t1426 * t584;
  t1490 = t241 * t238;
  t1491 = t575 * t1490;
  t1492 = t234 * t1488 * t1491;
  t1495 = t1427 * t1431;
  t1496 = t1449 * t1452;
  t1497 = t1495 * t1496;
  t1499 = my_piecewise3(t115, 0, t1417);
  t1500 = my_piecewise3(t117, t1499, 0);
  t1504 = t1495 * t570;
  t1508 = t1495 * t242;
  t1512 = t576 * t580;
  t1513 = t575 * t1512;
  t1516 = t560 * t1484;
  t1519 = t560 * t1488;
  t1521 = t592 * t593 * t238;
  t1522 = t1519 * t1521;
  t1526 = t565 * params->csk_a;
  t1528 = t238 * t122 * t241;
  t1529 = t1526 * t1528;
  t1530 = t1519 * t1529;
  t1533 = t576 * t584;
  t1534 = t575 * t1533;
  t1535 = t234 * t1477 * t1534;
  t1537 = -t1425 * t1426 * t1497 - 0.3e1 * t560 * t1426 * t1504 - 0.2e1 * t234 * t1426 * t1508 + 0.3e1 * t234 * t1484 * t702 - t234 * t1500 * t243 + 0.3e1 * t234 * t684 * t1513 - 0.3e1 * t1516 * t692 - 0.3e1 * t1516 * t707 + 0.3e1 * t1492 - 0.3e1 * t1522 - 0.3e1 * t1530 + 0.3e1 * t1535 - t587;
  t1539 = my_piecewise5(t114, 0, t115, 0, t1483 + t1537);
  t1541 = t113 * t1539 + t1417 * t125 + 0.3e1 * t232 * t597 + 0.3e1 * t554 * t245 - t1410;
  t1546 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1390 * t127 + 0.3e1 / 0.1e2 * t1335 + 0.9e1 / 0.2e2 * t7 * t533 * t247 - t1268 / 0.1e2 + 0.3e1 / 0.5e1 * t1342 + 0.9e1 / 0.2e2 * t7 * t216 * t599 + t1192 - t1279 / 0.1e2 + 0.3e1 / 0.1e2 * t1350 + 0.3e1 / 0.2e2 * t7 * t94 * t1541);
  tv3rho33 = 0.3e1 * t522 + 0.3e1 * t604 + t8 * (t1377 + t1546);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1554 = t7 * t345 * t268;
  t1561 = t7 * t354 * t268 / 0.3e2;
  t1563 = t7 * t145 * t650;
  t1566 = 0.55e2 / 0.81e2 * t38 * t363;
  t1567 = t37 * t363;
  t1570 = 0.11e2 / 0.27e2 * t47 * t1567 - t1566;
  t1578 = t388 * t633;
  t1579 = t411 * t1578;
  t1582 = t380 * t1046;
  t1583 = t1045 * t1582;
  t1584 = t1068 * t263;
  t1587 = t633 * t165;
  t1589 = t163 * t1587 * t405;
  t1591 = t263 * t399;
  t1593 = t163 * t1591 * t405;
  t1594 = t170 * t399;
  t1595 = t394 * t1594;
  t1598 = t379 * t1582;
  t1599 = t1051 * t624;
  t1602 = t263 * t1046;
  t1603 = t163 * t1602;
  t1604 = t170 * t380;
  t1605 = t1056 * t1604;
  t1608 = t633 * t382;
  t1609 = t163 * t1608;
  t1612 = my_piecewise3(t67, 0, t1570);
  t1613 = my_piecewise3(t69, t1612, 0);
  t1616 = t1045 * t1602;
  t1617 = t1050 * t1057;
  t1619 = t380 * t386 * t388;
  t1620 = t1617 * t1619;
  t1623 = t412 * t399;
  t1624 = t411 * t1623;
  t1626 = t1584 * params->csk_a;
  t1627 = t1066 * t1626;
  t1633 = -t1583 * t1066 * t1584 - t163 * t1613 * t172 + t1130 * t625 + t628 * t1140 + 0.2e1 * t623 * t1579 + 0.3e1 * t1583 * t1627 + t628 * t1595 - 0.3e1 * t1598 * t1599 - 0.2e1 * t1603 * t1605 + 0.2e1 * t1609 * t630 + 0.2e1 * t1609 * t640 - 0.3e1 * t1616 * t1620 - t642 * t1624 - 0.2e1 * t1589 - t1593 - t638;
  t1634 = t379 * t1602;
  t1638 = t380 * t74 * t170;
  t1639 = t1091 * t1638;
  t1642 = t379 * t1608;
  t1647 = t1617 * t1638;
  t1649 = t1051 * t882;
  t1656 = t379 * t380 * t167;
  t1657 = t624 * t403;
  t1658 = t411 * t1657;
  t1659 = t1656 * t1658;
  t1661 = t263 * t380;
  t1664 = t403 * t384 * t1147;
  t1665 = t163 * t1661 * t1664;
  t1667 = t1069 * t380;
  t1668 = t1066 * t1667;
  t1674 = t1661 * t403;
  t1675 = t379 * t1674;
  t1676 = t1675 * t1135;
  t1678 = t1675 * t1148;
  t1680 = t263 * t167;
  t1681 = t1680 * t384;
  t1682 = t163 * t1681;
  t1684 = params->csk_a * t380 * t403;
  t1685 = t171 * t1684;
  t1686 = t1682 * t1685;
  t1688 = -t642 * t1140 + 0.3e1 * t1583 * t1649 - 0.3e1 * t1603 * t1639 - t1603 * t1647 - t1616 * t1647 - 0.2e1 * t1616 * t1668 + 0.3e1 * t1634 * t1620 + 0.3e1 * t1634 * t1639 + 0.3e1 * t1634 * t1647 - 0.2e1 * t1642 * t630 - 0.2e1 * t1642 * t645 + 0.3e1 * t1659 + 0.3e1 * t1665 - 0.3e1 * t1676 - 0.3e1 * t1678 + 0.3e1 * t1686;
  t1690 = my_piecewise5(t64, 0, t67, 0, t1633 + t1688);
  t1692 = t1570 * t77 + 0.2e1 * t161 * t648 + t59 * t1690 + 0.2e1 * t618 * t174 + t260 * t416 + t373 * t266 + t1566;
  t1697 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t268 + t1554 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t650 - t1561 + t1563 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1692);
  tv3rho2sigma0 = t8 * t1697 + 0.2e1 * t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1704 = t7 * t440 * t286;
  t1708 = t7 * t444 * t286 / 0.3e2;
  t1710 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t286 + t1704 / 0.5e1 - t1708);
  tv3rho2sigma2 = t8 * t1710 + 0.2e1 * t664;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1716 = t7 * t465 * t268;
  t1724 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t268 + t1716 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t650 + t1554 / 0.1e2 - t1561 + t1563 / 0.1e2);
  tv3rho2sigma3 = t8 * t1724 + t655 + t670;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1730 = t7 * t489 * t286;
  t1737 = t7 * t192 * t712;
  t1740 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t286 + t1730 / 0.1e2 + t1704 / 0.1e2 - t1708 + 0.3e1 / 0.2e2 * t7 * t188 * t712 + t1737 / 0.1e2);
  tv3rho2sigma5 = t8 * t1740 + t664 + t717;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1748 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t268 + t1716 / 0.5e1 - t1561);
  tv3rho2sigma6 = t8 * t1748 + 0.2e1 * t670;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1760 = 0.55e2 / 0.81e2 * t38 * t544;
  t1761 = t37 * t544;
  t1764 = 0.11e2 / 0.27e2 * t47 * t1761 - t1760;
  t1773 = t569 * t695;
  t1774 = t592 * t1773;
  t1777 = t561 * t1427;
  t1778 = t1425 * t1777;
  t1779 = t1452 * t281;
  t1782 = t695 * t236;
  t1784 = t234 * t1782 * t586;
  t1786 = t281 * t580;
  t1788 = t234 * t1786 * t586;
  t1789 = t241 * t580;
  t1790 = t575 * t1789;
  t1792 = t281 * t1427;
  t1793 = t234 * t1792;
  t1794 = t241 * t561;
  t1795 = t1437 * t1794;
  t1798 = t560 * t1777;
  t1799 = t1432 * t686;
  t1802 = t695 * t563;
  t1803 = t234 * t1802;
  t1806 = my_piecewise3(t115, 0, t1764);
  t1807 = my_piecewise3(t117, t1806, 0);
  t1810 = t1425 * t1792;
  t1811 = t1453 * t561;
  t1812 = t1450 * t1811;
  t1815 = t1779 * params->csk_a;
  t1816 = t1450 * t1815;
  t1822 = t560 * t1792;
  t1823 = t569 * t1057;
  t1824 = t1823 * t561;
  t1825 = t1432 * t1824;
  t1828 = -t1778 * t1450 * t1779 - t234 * t1807 * t243 + t690 * t1513 + t1516 * t687 + 0.2e1 * t685 * t1774 + 0.3e1 * t1778 * t1816 + t690 * t1790 - 0.2e1 * t1793 * t1795 - 0.3e1 * t1798 * t1799 + 0.2e1 * t1803 * t692 + 0.2e1 * t1803 * t702 - 0.2e1 * t1810 * t1812 + 0.3e1 * t1822 * t1825 - 0.2e1 * t1784 - t1788 - t700;
  t1829 = t560 * t1802;
  t1833 = t561 * t122 * t241;
  t1834 = t1471 * t1833;
  t1841 = t1445 * t1833;
  t1843 = t1432 * t908;
  t1849 = t281 * t561;
  t1852 = t584 * t565 * t1528;
  t1853 = t234 * t1849 * t1852;
  t1856 = t560 * t561 * t238;
  t1857 = t686 * t584;
  t1858 = t592 * t1857;
  t1859 = t1856 * t1858;
  t1864 = t593 * t580;
  t1865 = t592 * t1864;
  t1867 = t1849 * t584;
  t1868 = t560 * t1867;
  t1869 = t1868 * t1529;
  t1871 = t281 * t238;
  t1872 = t1871 * t565;
  t1873 = t234 * t1872;
  t1875 = params->csk_a * t561 * t584;
  t1876 = t242 * t1875;
  t1877 = t1873 * t1876;
  t1879 = t1868 * t1521;
  t1881 = -t704 * t1513 + 0.3e1 * t1778 * t1843 - 0.3e1 * t1793 * t1834 - t1793 * t1841 - 0.3e1 * t1810 * t1825 - t1810 * t1841 + 0.3e1 * t1822 * t1834 + 0.3e1 * t1822 * t1841 - 0.2e1 * t1829 * t692 - 0.2e1 * t1829 * t707 - t704 * t1865 + 0.3e1 * t1853 + 0.3e1 * t1859 - 0.3e1 * t1869 + 0.3e1 * t1877 - 0.3e1 * t1879;
  t1883 = my_piecewise5(t114, 0, t115, 0, t1828 + t1881);
  t1885 = t113 * t1883 + t1764 * t125 + 0.2e1 * t232 * t710 + 0.2e1 * t680 * t245 + t278 * t597 + t554 * t284 + t1760;
  t1890 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t286 + t1730 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t712 - t1708 + t1737 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t1885);
  tv3rho2sigma8 = t8 * t1890 + 0.2e1 * t717;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1897 = t7 * t345 * t303;
  t1904 = t7 * t354 * t303 / 0.3e2;
  t1906 = t7 * t145 * t754;
  t1920 = t298 * t399;
  t1922 = t163 * t1920 * t405;
  t1925 = t388 * t741;
  t1926 = t411 * t1925;
  t1929 = t1068 * t298;
  t1930 = t1066 * t1929;
  t1932 = t1051 * t732;
  t1935 = t298 * t1046;
  t1936 = t163 * t1935;
  t1939 = t741 * t382;
  t1940 = t163 * t1939;
  t1943 = t741 * t165;
  t1945 = t163 * t1943 * t405;
  t1949 = my_piecewise3(t67, 0, 0.5e1 / 0.27e2 * t52 * t615);
  t1950 = my_piecewise3(t69, t1949, 0);
  t1953 = t379 * t1935;
  t1956 = t379 * t1939;
  t1961 = t732 * params->csk_a;
  t1962 = t1051 * t1961;
  t1966 = -t163 * t1950 * t172 + t1130 * t733 - t1583 * t1930 + 0.3e1 * t1583 * t1962 + t736 * t1595 - 0.3e1 * t1598 * t1932 - 0.2e1 * t1936 * t1605 - 0.3e1 * t1936 * t1639 + 0.3e1 * t1953 * t1639 - t1936 * t1647 + 0.2e1 * t623 * t1926 + 0.2e1 * t1940 * t640 - 0.2e1 * t1956 * t630 - t1922 - 0.2e1 * t1945 - t746;
  t1969 = t1045 * t1935;
  t1971 = t732 * t403;
  t1972 = t411 * t1971;
  t1973 = t1656 * t1972;
  t1975 = t298 * t380;
  t1977 = t163 * t1975 * t1664;
  t1985 = t379 * t1975 * t403;
  t1986 = t1985 * t1148;
  t1989 = t298 * t167 * t384;
  t1990 = t163 * t1989;
  t1991 = t1990 * t1685;
  t1993 = t1985 * t1135;
  t2001 = t1929 * params->csk_a;
  t2002 = t1066 * t2001;
  t2007 = t736 * t1140 - t748 * t1140 + 0.3e1 * t1583 * t2002 + 0.3e1 * t1953 * t1620 - 0.3e1 * t1969 * t1620 - t748 * t1624 + 0.3e1 * t1953 * t1647 - t1969 * t1647 - 0.2e1 * t1969 * t1668 + 0.2e1 * t1940 * t630 - 0.2e1 * t1956 * t645 + 0.3e1 * t1973 + 0.3e1 * t1977 - 0.3e1 * t1986 + 0.3e1 * t1991 - 0.3e1 * t1993;
  t2009 = my_piecewise5(t64, 0, t67, 0, t1966 + t2007);
  t2011 = 0.5e1 / 0.27e2 * t52 * t615 * t77 - 0.5e1 / 0.36e2 * t52 * t257 * t174 + t52 * t291 * t416 / 0.24e2 + t373 * t301 + 0.2e1 * t161 * t752 + t59 * t2009;
  t2016 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t303 + t1897 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t754 - t1904 + t1906 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2011);
  tv3rho2lapl0 = t8 * t2016 + 0.2e1 * t759;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2023 = t7 * t440 * t320;
  t2027 = t7 * t444 * t320 / 0.3e2;
  t2029 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t320 + t2023 / 0.5e1 - t2027);
  tv3rho2lapl1 = t8 * t2029 + 0.2e1 * t768;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2035 = t7 * t465 * t303;
  t2043 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t303 + t2035 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t754 + t1897 / 0.1e2 - t1904 + t1906 / 0.1e2);
  tv3rho2lapl2 = t8 * t2043 + t759 + t774;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2049 = t7 * t489 * t320;
  t2056 = t7 * t192 * t808;
  t2059 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t320 + t2049 / 0.1e2 + t2023 / 0.1e2 - t2027 + 0.3e1 / 0.2e2 * t7 * t188 * t808 + t2056 / 0.1e2);
  tv3rho2lapl3 = t8 * t2059 + t768 + t813;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2067 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t303 + t2035 / 0.5e1 - t1904);
  tv3rho2lapl4 = t8 * t2067 + 0.2e1 * t774;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2090 = t795 * t563;
  t2091 = t234 * t2090;
  t2096 = t569 * t795;
  t2097 = t592 * t2096;
  t2100 = t1452 * t315;
  t2101 = t1450 * t2100;
  t2103 = t795 * t236;
  t2105 = t234 * t2103 * t586;
  t2107 = t315 * t580;
  t2109 = t234 * t2107 * t586;
  t2110 = t1432 * t786;
  t2113 = t315 * t1427;
  t2114 = t234 * t2113;
  t2119 = my_piecewise3(t115, 0, 0.5e1 / 0.27e2 * t52 * t677);
  t2120 = my_piecewise3(t117, t2119, 0);
  t2124 = t315 * t238 * t565;
  t2125 = t234 * t2124;
  t2126 = t2125 * t1876;
  t2128 = t315 * t561;
  t2129 = t2128 * t584;
  t2130 = t560 * t2129;
  t2131 = t2130 * t1521;
  t2133 = t2130 * t1529;
  t2135 = t560 * t2090;
  t2138 = t560 * t2113;
  t2141 = -t234 * t2120 * t243 + t1516 * t787 - t1778 * t2101 + t790 * t1790 - 0.2e1 * t2114 * t1795 - 0.3e1 * t1798 * t2110 + 0.3e1 * t2138 * t1834 + 0.2e1 * t2091 * t702 + 0.2e1 * t685 * t2097 - 0.2e1 * t2135 * t707 - 0.2e1 * t2105 - t2109 + 0.3e1 * t2126 - 0.3e1 * t2131 - 0.3e1 * t2133 - t800;
  t2146 = t786 * params->csk_a;
  t2147 = t1432 * t2146;
  t2153 = t1425 * t2113;
  t2155 = t786 * t584;
  t2156 = t592 * t2155;
  t2157 = t1856 * t2156;
  t2160 = t234 * t2128 * t1852;
  t2162 = t2100 * params->csk_a;
  t2163 = t1450 * t2162;
  t2177 = t790 * t1513 - t802 * t1513 + 0.3e1 * t1778 * t2147 + 0.3e1 * t1778 * t2163 - 0.2e1 * t2153 * t1812 + 0.3e1 * t2138 * t1825 - 0.3e1 * t2153 * t1825 - 0.3e1 * t2114 * t1834 - t2114 * t1841 + 0.3e1 * t2138 * t1841 - t2153 * t1841 - t802 * t1865 + 0.2e1 * t2091 * t692 - 0.2e1 * t2135 * t692 + 0.3e1 * t2157 + 0.3e1 * t2160;
  t2179 = my_piecewise5(t114, 0, t115, 0, t2141 + t2177);
  t2181 = 0.5e1 / 0.27e2 * t52 * t677 * t125 - 0.5e1 / 0.36e2 * t52 * t275 * t245 + t52 * t308 * t597 / 0.24e2 + t554 * t318 + 0.2e1 * t232 * t806 + t113 * t2179;
  t2186 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t320 + t2049 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t808 - t2027 + t2056 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t2181);
  tv3rho2lapl5 = t8 * t2186 + 0.2e1 * t813;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2193 = t7 * t145 * t836 / 0.1e2;
  t2199 = t165 * t1046;
  t2200 = t1045 * t2199;
  t2201 = t1068 * t817;
  t2202 = t1066 * t2201;
  t2204 = t388 * t824;
  t2205 = t411 * t2204;
  t2206 = t623 * t2205;
  t2207 = t824 * t165;
  t2209 = t163 * t2207 * t405;
  t2210 = t263 * t403;
  t2211 = t163 * t2210;
  t2212 = t168 * t74;
  t2213 = t170 * t633;
  t2215 = t2211 * t2212 * t2213;
  t2216 = 0.2e1 * t2215;
  t2217 = t394 * t2213;
  t2220 = t817 * t1046;
  t2221 = t379 * t2220;
  t2222 = t388 * t165;
  t2223 = t1051 * t2222;
  t2226 = t824 * t382;
  t2227 = t163 * t2226;
  t2228 = t2227 * t640;
  t2229 = t163 * t2220;
  t2230 = t1056 * t639;
  t2235 = t817 * t403;
  t2237 = t379 * t2235 * t384;
  t2238 = params->csk_a * t165;
  t2239 = t2238 * t1147;
  t2240 = t2237 * t2239;
  t2242 = t817 * t167;
  t2244 = t163 * t2242 * t384;
  t2245 = t2238 * t403;
  t2246 = t171 * t2245;
  t2247 = t2244 * t2246;
  t2249 = t2238 * t167;
  t2250 = t389 * t2249;
  t2251 = t2237 * t2250;
  t2253 = t1073 * t165;
  t2254 = t1051 * t2253;
  t2257 = t379 * t2226;
  t2258 = t2257 * t645;
  t2259 = 0.2e1 * t642 * t1579 - t2200 * t2202 + 0.2e1 * t628 * t2217 - 0.3e1 * t2221 * t2223 + 0.3e1 * t2221 * t2254 - 0.2e1 * t2229 * t2230 + t2206 - t2209 - t2216 + t2228 - 0.3e1 * t2240 + 0.3e1 * t2247 - 0.3e1 * t2251 - t2258 - t826 - t828;
  t2260 = t163 * t2235;
  t2262 = t394 * t639 * t167;
  t2263 = t2260 * t2262;
  t2265 = t171 * t633;
  t2266 = t1145 * t2265;
  t2269 = t1045 * t2220;
  t2270 = t1051 * t644;
  t2274 = t1056 * t1058 * t165;
  t2279 = t2227 * t630;
  t2280 = t2257 * t630;
  t2282 = t165 * t74 * t170;
  t2283 = t1091 * t2282;
  t2290 = t412 * t633;
  t2291 = t411 * t2290;
  t2294 = t1069 * t165;
  t2295 = t1066 * t2294;
  t2298 = t379 * t2242;
  t2299 = t2222 * t403;
  t2300 = t411 * t2299;
  t2301 = t2298 * t2300;
  t2303 = t1087 * t165;
  t2304 = t1066 * t2303;
  t2309 = 0.3e1 * t2221 * t2274 + 0.3e1 * t2221 * t2283 - t2229 * t2274 - 0.3e1 * t2229 * t2283 - 0.3e1 * t2269 * t2254 + 0.2e1 * t628 * t2266 - 0.2e1 * t642 * t2266 + 0.3e1 * t2269 * t2270 - t2269 * t2274 - 0.2e1 * t2269 * t2295 + 0.3e1 * t2269 * t2304 - 0.2e1 * t642 * t2291 + 0.3e1 * t2263 + t2279 - t2280 + 0.3e1 * t2301;
  t2311 = my_piecewise5(t64, 0, t67, 0, t2259 + t2309);
  t2313 = t161 * t834 + t59 * t2311 + 0.2e1 * t260 * t648 + 0.2e1 * t618 * t266;
  t2318 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t836 + t2193 + 0.3e1 / 0.2e2 * t7 * t32 * t2313);
  tv3rhosigma20 = t8 * t2318 + t840;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2325 = t7 * t192 * t862 / 0.1e2;
  t2327 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t862 + t2325);
  tv3rhosigma25 = t8 * t2327 + t866;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2333 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t836 + t2193);
  tv3rhosigma26 = t8 * t2333 + t840;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2343 = t843 * t1427;
  t2344 = t234 * t2343;
  t2345 = t1437 * t701;
  t2348 = t560 * t2343;
  t2349 = t569 * t236;
  t2350 = t1432 * t2349;
  t2353 = t850 * t563;
  t2354 = t234 * t2353;
  t2355 = t2354 * t702;
  t2356 = t236 * t1427;
  t2357 = t1425 * t2356;
  t2358 = t1452 * t843;
  t2359 = t1450 * t2358;
  t2361 = t569 * t850;
  t2362 = t592 * t2361;
  t2363 = t685 * t2362;
  t2364 = t850 * t236;
  t2366 = t234 * t2364 * t586;
  t2367 = t281 * t584;
  t2368 = t234 * t2367;
  t2369 = t239 * t122;
  t2370 = t241 * t695;
  t2372 = t2368 * t2369 * t2370;
  t2373 = 0.2e1 * t2372;
  t2374 = t575 * t2370;
  t2379 = t843 * t584;
  t2381 = t560 * t2379 * t565;
  t2382 = params->csk_a * t236;
  t2383 = t2382 * t1528;
  t2384 = t2381 * t2383;
  t2386 = t843 * t238;
  t2388 = t234 * t2386 * t565;
  t2389 = t2382 * t584;
  t2390 = t242 * t2389;
  t2391 = t2388 * t2390;
  t2393 = t2382 * t238;
  t2394 = t570 * t2393;
  t2395 = t2381 * t2394;
  t2397 = t1425 * t2343;
  t2398 = t1461 * t236;
  t2399 = t1450 * t2398;
  t2402 = t576 * t695;
  t2403 = t575 * t2402;
  t2406 = 0.2e1 * t704 * t1774 - 0.2e1 * t2344 * t2345 - 0.3e1 * t2348 * t2350 - t2357 * t2359 + 0.2e1 * t690 * t2374 + 0.3e1 * t2397 * t2399 + 0.2e1 * t690 * t2403 + t2355 + t2363 - t2366 - t2373 - 0.3e1 * t2384 + 0.3e1 * t2391 - 0.3e1 * t2395 - t852 - t854;
  t2407 = t1823 * t236;
  t2408 = t1432 * t2407;
  t2411 = t560 * t2353;
  t2412 = t2411 * t707;
  t2413 = t234 * t2379;
  t2415 = t575 * t701 * t238;
  t2416 = t2413 * t2415;
  t2418 = t1432 * t706;
  t2421 = t1438 * t236;
  t2422 = t1437 * t2421;
  t2427 = t2354 * t692;
  t2428 = t2411 * t692;
  t2430 = t236 * t122 * t241;
  t2431 = t1471 * t2430;
  t2440 = t593 * t695;
  t2441 = t592 * t2440;
  t2444 = t1453 * t236;
  t2445 = t1450 * t2444;
  t2448 = t560 * t2386;
  t2449 = t2349 * t584;
  t2450 = t592 * t2449;
  t2451 = t2448 * t2450;
  t2453 = -t2344 * t2422 - 0.3e1 * t2344 * t2431 + 0.3e1 * t2348 * t2408 + 0.3e1 * t2348 * t2422 + 0.3e1 * t2348 * t2431 - 0.3e1 * t2397 * t2408 + 0.3e1 * t2397 * t2418 - t2397 * t2422 - 0.2e1 * t2397 * t2445 - 0.2e1 * t704 * t2403 - 0.2e1 * t704 * t2441 - t2412 + 0.3e1 * t2416 + t2427 - t2428 + 0.3e1 * t2451;
  t2455 = my_piecewise5(t114, 0, t115, 0, t2406 + t2453);
  t2457 = t113 * t2455 + t232 * t860 + 0.2e1 * t278 * t710 + 0.2e1 * t680 * t284;
  t2462 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t862 + t2325 + 0.3e1 / 0.2e2 * t7 * t94 * t2457);
  tv3rhosigma211 = t8 * t2462 + t866;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2469 = t7 * t145 * t888 / 0.1e2;
  t2483 = t741 * t263;
  t2485 = t163 * t2483 * t405;
  t2486 = t298 * t633;
  t2488 = t163 * t2486 * t405;
  t2489 = t875 * t403;
  t2490 = t379 * t2489;
  t2492 = t1145 * t165 * t1147;
  t2493 = t2490 * t2492;
  t2495 = t171 * params->csk_a;
  t2496 = t636 * t403;
  t2498 = t1990 * t2495 * t2496;
  t2500 = t411 * t388;
  t2501 = t2500 * t2249;
  t2502 = t2490 * t2501;
  t2504 = t163 * t2489;
  t2505 = t2504 * t2262;
  t2507 = t1935 * t1050;
  t2508 = t1045 * t2507;
  t2509 = t1057 * t263;
  t2510 = t389 * t165;
  t2511 = t2509 * t2510;
  t2514 = t379 * t1681;
  t2515 = t744 * t403;
  t2516 = t389 * t2515;
  t2517 = t2514 * t2516;
  t2519 = t379 * t2507;
  t2520 = t171 * t263;
  t2521 = t2238 * t2520;
  t2524 = t163 * t2507;
  t2527 = t1642 * t733 + t642 * t1926 + t1940 * t879 + t736 * t2217 - 0.3e1 * t2508 * t2511 + 0.3e1 * t2519 * t2521 - 0.3e1 * t2524 * t2521 + t2206 - t2209 + t2228 - t2485 - t2488 - 0.3e1 * t2493 + 0.3e1 * t2498 - 0.3e1 * t2502 + 0.3e1 * t2505 + 0.3e1 * t2517 - t826 - t877;
  t2528 = t1602 * t1050;
  t2529 = t1045 * t2528;
  t2530 = t298 * params->csk_a;
  t2531 = t2530 * t165;
  t2532 = t389 * t2531;
  t2535 = t2509 * t165;
  t2536 = t171 * t2535;
  t2541 = t1110 * t2535;
  t2544 = t1110 * t2531;
  t2551 = t1584 * t298;
  t2552 = t1066 * t2551;
  t2558 = t878 * t165;
  t2559 = t1056 * t2558;
  t2563 = t1051 * t732 * t165;
  t2566 = -0.3e1 * t1634 * t2563 - 0.2e1 * t1936 * t2559 + t1940 * t873 - t1956 * t873 - t1956 * t883 - t2200 * t2552 + t736 * t2266 - t748 * t2266 - t748 * t2291 - t2508 * t2536 - 0.2e1 * t2508 * t2541 + 0.3e1 * t2519 * t2511 + 0.3e1 * t2519 * t2536 - t2524 * t2536 + 0.3e1 * t2529 * t2532 + 0.3e1 * t2529 * t2544 - t2258 + t2279 - t2280;
  t2568 = my_piecewise5(t64, 0, t67, 0, t2527 + t2566);
  t2570 = -0.5e1 / 0.72e2 * t52 * t257 * t266 + t52 * t291 * t648 / 0.24e2 + t618 * t301 + t260 * t752 + t161 * t886 + t59 * t2568;
  t2575 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t888 + t2469 + 0.3e1 / 0.2e2 * t7 * t32 * t2570);
  tv3rhosigmalapl0 = t8 * t2575 + t892;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2582 = t7 * t192 * t914 / 0.1e2;
  t2584 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t914 + t2582);
  tv3rhosigmalapl5 = t8 * t2584 + t918;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2590 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t888 + t2469);
  tv3rhosigmalapl6 = t8 * t2590 + t892;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2606 = t795 * t281;
  t2608 = t234 * t2606 * t586;
  t2609 = t315 * t695;
  t2611 = t234 * t2609 * t586;
  t2614 = t901 * t584;
  t2615 = t560 * t2614;
  t2616 = t592 * t569;
  t2617 = t2616 * t2393;
  t2618 = t2615 * t2617;
  t2621 = t1526 * t236 * t1528;
  t2622 = t2615 * t2621;
  t2624 = t242 * params->csk_a;
  t2625 = t698 * t584;
  t2627 = t2125 * t2624 * t2625;
  t2629 = t560 * t1872;
  t2631 = t570 * t798 * t584;
  t2632 = t2629 * t2631;
  t2634 = t1792 * t1431;
  t2635 = t1425 * t2634;
  t2636 = t315 * params->csk_a;
  t2637 = t2636 * t236;
  t2638 = t1496 * t2637;
  t2641 = t2113 * t1431;
  t2642 = t560 * t2641;
  t2643 = t1057 * t281;
  t2644 = t2643 * t236;
  t2645 = t570 * t2644;
  t2648 = t234 * t2614;
  t2649 = t2648 * t2415;
  t2651 = t242 * t281;
  t2652 = t2382 * t2651;
  t2655 = t1829 * t787 + t2091 * t905 + t704 * t2097 + t790 * t2374 + 0.3e1 * t2635 * t2638 + 0.3e1 * t2642 * t2645 + 0.3e1 * t2642 * t2652 + t2355 + t2363 - t2366 - t2608 - t2611 - 0.3e1 * t2618 - 0.3e1 * t2622 + 0.3e1 * t2627 + 0.3e1 * t2632 + 0.3e1 * t2649 - t852 - t903;
  t2656 = t234 * t2641;
  t2659 = t570 * t2637;
  t2662 = t242 * t2644;
  t2666 = t1425 * t2641;
  t2670 = t1496 * t2644;
  t2674 = t1432 * t786 * t236;
  t2677 = t904 * t236;
  t2678 = t1437 * t2677;
  t2685 = t1779 * t315;
  t2686 = t1450 * t2685;
  t2690 = -0.3e1 * t1822 * t2674 + t2091 * t899 - 0.2e1 * t2114 * t2678 - t2135 * t899 - t2135 * t909 - t2357 * t2686 + t790 * t2403 - t802 * t2403 - t802 * t2441 + 0.3e1 * t2635 * t2659 + 0.3e1 * t2642 * t2662 - 0.3e1 * t2666 * t2645 - 0.3e1 * t2656 * t2652 - t2656 * t2662 - t2666 * t2662 - 0.2e1 * t2666 * t2670 - t2412 + t2427 - t2428;
  t2692 = my_piecewise5(t114, 0, t115, 0, t2655 + t2690);
  t2694 = -0.5e1 / 0.72e2 * t52 * t275 * t284 + t52 * t308 * t710 / 0.24e2 + t680 * t318 + t278 * t806 + t232 * t912 + t113 * t2692;
  t2699 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t914 + t2582 + 0.3e1 / 0.2e2 * t7 * t94 * t2694);
  tv3rhosigmalapl11 = t8 * t2699 + t918;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2706 = t7 * t145 * t937 / 0.1e2;
  t2714 = t170 * t741;
  t2720 = t1068 * t922;
  t2721 = t1066 * t2720;
  t2723 = t298 * t403;
  t2724 = t163 * t2723;
  t2726 = t2724 * t2212 * t2714;
  t2727 = 0.2e1 * t2726;
  t2728 = t922 * t1046;
  t2729 = t163 * t2728;
  t2732 = t379 * t2728;
  t2735 = t922 * t403;
  t2737 = t379 * t2735 * t384;
  t2738 = t2737 * t2239;
  t2740 = t922 * t167;
  t2742 = t163 * t2740 * t384;
  t2743 = t2742 * t2246;
  t2745 = t2737 * t2250;
  t2747 = t1045 * t2728;
  t2750 = t395 * t741;
  t2751 = t394 * t2750;
  t2754 = 0.2e1 * t736 * t394 * t2714 + 0.2e1 * t748 * t1926 - t2200 * t2721 - 0.3e1 * t2732 * t2223 - 0.2e1 * t2729 * t2230 + 0.3e1 * t2747 * t2304 + 0.2e1 * t736 * t2751 + t2206 - t2209 + t2228 - t2727 - 0.3e1 * t2738 + 0.3e1 * t2743 - 0.3e1 * t2745 - t826 - t929;
  t2757 = t163 * t2735;
  t2758 = t2757 * t2262;
  t2774 = t412 * t741;
  t2780 = t379 * t2740;
  t2781 = t2780 * t2300;
  t2783 = -0.2e1 * t748 * t411 * t2774 + 0.3e1 * t2732 * t2254 - 0.3e1 * t2747 * t2254 + 0.3e1 * t2747 * t2270 - t2729 * t2274 + 0.3e1 * t2732 * t2274 - t2747 * t2274 - 0.3e1 * t2729 * t2283 + 0.3e1 * t2732 * t2283 - 0.2e1 * t2747 * t2295 - 0.2e1 * t748 * t2751 - t2258 + t2279 - t2280 + 0.3e1 * t2758 + 0.3e1 * t2781;
  t2785 = my_piecewise5(t64, 0, t67, 0, t2754 + t2783);
  t2787 = -0.5e1 / 0.36e2 * t52 * t257 * t301 + t52 * t291 * t752 / 0.12e2 + t161 * t935 + t59 * t2785;
  t2792 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t937 + t2706 + 0.3e1 / 0.2e2 * t7 * t32 * t2787);
  tv3rholapl20 = t8 * t2792 + t941;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2799 = t7 * t192 * t960 / 0.1e2;
  t2801 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t960 + t2799);
  tv3rholapl22 = t8 * t2801 + t964;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2807 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t937 + t2706);
  tv3rholapl23 = t8 * t2807 + t941;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2821 = t1452 * t945;
  t2822 = t1450 * t2821;
  t2824 = t315 * t584;
  t2825 = t234 * t2824;
  t2826 = t241 * t795;
  t2828 = t2825 * t2369 * t2826;
  t2829 = 0.2e1 * t2828;
  t2833 = t945 * t1427;
  t2834 = t560 * t2833;
  t2837 = t234 * t2833;
  t2840 = t945 * t584;
  t2842 = t560 * t2840 * t565;
  t2843 = t2842 * t2383;
  t2845 = t945 * t238;
  t2847 = t234 * t2845 * t565;
  t2848 = t2847 * t2390;
  t2850 = t2842 * t2394;
  t2852 = t1425 * t2833;
  t2856 = 0.2e1 * t790 * t575 * t2826 + 0.2e1 * t802 * t2097 - 0.2e1 * t2837 * t2345 - 0.3e1 * t2834 * t2350 - t2357 * t2822 + 0.3e1 * t2852 * t2418 - t2837 * t2422 + t2355 + t2363 - t2366 - t2829 - 0.3e1 * t2843 + 0.3e1 * t2848 - 0.3e1 * t2850 - t852 - t952;
  t2864 = t593 * t795;
  t2870 = t560 * t2845;
  t2871 = t2870 * t2450;
  t2876 = t575 * t576 * t795;
  t2881 = t234 * t2840;
  t2882 = t2881 * t2415;
  t2888 = -0.2e1 * t802 * t592 * t2864 + 0.3e1 * t2852 * t2399 + 0.3e1 * t2834 * t2408 - 0.3e1 * t2852 * t2408 + 0.3e1 * t2834 * t2422 - t2852 * t2422 + 0.3e1 * t2834 * t2431 - 0.3e1 * t2837 * t2431 - 0.2e1 * t2852 * t2445 + 0.2e1 * t790 * t2876 - 0.2e1 * t802 * t2876 - t2412 + t2427 - t2428 + 0.3e1 * t2871 + 0.3e1 * t2882;
  t2890 = my_piecewise5(t114, 0, t115, 0, t2856 + t2888);
  t2892 = -0.5e1 / 0.36e2 * t52 * t275 * t318 + t52 * t308 * t806 / 0.12e2 + t232 * t958 + t113 * t2890;
  t2897 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t960 + t2799 + 0.3e1 / 0.2e2 * t7 * t94 * t2892);
  tv3rholapl25 = t8 * t2897 + t964;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2901 = t817 * t263;
  t2902 = t2901 * t1046;
  t2903 = t163 * t2902;
  t2906 = t1045 * t2902;
  t2911 = t642 * t2205;
  t2912 = 0.3e1 * t2911;
  t2915 = t379 * t2902;
  t2918 = t824 * t263;
  t2920 = t163 * t2918 * t405;
  t2921 = 0.3e1 * t2920;
  t2922 = t2227 * t879;
  t2923 = 0.3e1 * t2922;
  t2924 = t2901 * t403;
  t2925 = t163 * t2924;
  t2926 = t2925 * t1105;
  t2927 = 0.3e1 * t2926;
  t2928 = t2901 * t167;
  t2930 = t379 * t2928 * t1040;
  t2931 = 0.3e1 * t2930;
  t2937 = 0.3e1 * t2906 * t1052 - t2903 * t1059 + 0.3e1 * t2915 * t1059 - 0.2e1 * t2906 * t1070 - 0.3e1 * t2906 * t1074 + 0.3e1 * t2915 * t1074 + 0.3e1 * t2906 * t1088 - 0.3e1 * t2903 * t1092 + t2912 - t2921 + t2923 + t2927 + t2931;
  t2949 = t379 * t2924;
  t2950 = t2949 * t1135;
  t2951 = 0.3e1 * t2950;
  t2952 = t395 * t824;
  t2953 = t394 * t2952;
  t2954 = t628 * t2953;
  t2955 = 0.3e1 * t2954;
  t2956 = t2257 * t873;
  t2957 = 0.3e1 * t2956;
  t2958 = t2949 * t1148;
  t2959 = 0.3e1 * t2958;
  t2961 = t163 * t2928 * t1127;
  t2962 = 0.3e1 * t2961;
  t2963 = t2257 * t883;
  t2964 = 0.3e1 * t2963;
  t2965 = -t1045 * t2901 * t1111 - 0.2e1 * t163 * t2901 * t1118 - 0.3e1 * t379 * t2901 * t1122 - t2906 * t1059 + 0.3e1 * t2915 * t1092 - t2951 + t2955 - t2957 - t2959 + t2962 - t2964 - t826 - t828;
  t2967 = my_piecewise5(t64, 0, t67, 0, t2937 + t2965);
  t2969 = 0.3e1 * t260 * t834 + t59 * t2967;
  t2973 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2969);
  tv3sigma30 = t8 * t2973;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2976 = t843 * t281;
  t2977 = t2976 * t1427;
  t2978 = t234 * t2977;
  t2981 = t1425 * t2977;
  t2986 = t704 * t2362;
  t2987 = 0.3e1 * t2986;
  t2990 = t560 * t2977;
  t2993 = t850 * t281;
  t2995 = t234 * t2993 * t586;
  t2996 = 0.3e1 * t2995;
  t2997 = t2976 * t584;
  t2998 = t234 * t2997;
  t2999 = t2998 * t1491;
  t3000 = 0.3e1 * t2999;
  t3001 = t2976 * t238;
  t3003 = t560 * t3001 * t1480;
  t3004 = 0.3e1 * t3003;
  t3005 = t2354 * t905;
  t3006 = 0.3e1 * t3005;
  t3012 = 0.3e1 * t2981 * t1433 - t2981 * t1439 + 0.3e1 * t2990 * t1439 - 0.3e1 * t2981 * t1446 + 0.3e1 * t2990 * t1446 - 0.2e1 * t2981 * t1454 + 0.3e1 * t2981 * t1462 - 0.3e1 * t2978 * t1472 + t2987 - t2996 + t3000 + t3004 + t3006;
  t3024 = t560 * t2997;
  t3025 = t3024 * t1521;
  t3026 = 0.3e1 * t3025;
  t3027 = t576 * t850;
  t3028 = t575 * t3027;
  t3029 = t690 * t3028;
  t3030 = 0.3e1 * t3029;
  t3031 = t2411 * t899;
  t3032 = 0.3e1 * t3031;
  t3033 = t3024 * t1529;
  t3034 = 0.3e1 * t3033;
  t3036 = t234 * t3001 * t1534;
  t3037 = 0.3e1 * t3036;
  t3038 = t2411 * t909;
  t3039 = 0.3e1 * t3038;
  t3040 = -t1425 * t2976 * t1497 - 0.3e1 * t560 * t2976 * t1504 - 0.2e1 * t234 * t2976 * t1508 - t2978 * t1439 + 0.3e1 * t2990 * t1472 - t3026 + t3030 - t3032 - t3034 + t3037 - t3039 - t852 - t854;
  t3042 = my_piecewise5(t114, 0, t115, 0, t3012 + t3040);
  t3044 = t113 * t3042 + 0.3e1 * t278 * t860;
  t3048 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3044);
  tv3sigma39 = t8 * t3048;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3054 = t170 * t817;
  t3055 = t1056 * t3054;
  t3060 = t170 * t824;
  t3061 = t394 * t3060;
  t3062 = t736 * t3061;
  t3063 = t2257 * t733;
  t3065 = t298 * t824;
  t3067 = t163 * t3065 * t405;
  t3068 = 0.2e1 * t2911;
  t3069 = 0.2e1 * t2920;
  t3070 = 0.2e1 * t2922;
  t3071 = t298 * t817;
  t3072 = t3071 * t403;
  t3073 = t379 * t3072;
  t3074 = t3073 * t1135;
  t3075 = 0.3e1 * t3074;
  t3076 = t3073 * t1148;
  t3077 = 0.3e1 * t3076;
  t3078 = params->csk_a * t817;
  t3079 = t3078 * t403;
  t3080 = t171 * t3079;
  t3081 = t1990 * t3080;
  t3082 = 0.3e1 * t3081;
  t3085 = t1058 * t817;
  t3086 = t1056 * t3085;
  t3088 = -t2269 * t1930 - 0.3e1 * t2221 * t1932 - 0.2e1 * t1936 * t3055 - t1936 * t3086 + 0.3e1 * t2269 * t1962 + t3062 + t3063 - t3067 + t3068 - t3069 + t3070 - t3075 - t3077 + t3082 - t826 - t877;
  t3092 = t2298 * t1972;
  t3093 = 0.3e1 * t3092;
  t3096 = t736 * t2953;
  t3097 = t1073 * t817;
  t3098 = t1051 * t3097;
  t3102 = t817 * t74 * t170;
  t3103 = t1091 * t3102;
  t3108 = t748 * t2953;
  t3111 = t412 * t824;
  t3112 = t411 * t3111;
  t3113 = t748 * t3112;
  t3114 = t1069 * t817;
  t3115 = t1066 * t3114;
  t3118 = t163 * t3071;
  t3119 = t3118 * t1664;
  t3120 = 0.3e1 * t3119;
  t3121 = 0.2e1 * t2954;
  t3122 = 0.2e1 * t2956;
  t3123 = 0.2e1 * t2963;
  t3124 = -0.3e1 * t1936 * t3103 + 0.3e1 * t1953 * t3086 + 0.3e1 * t1953 * t3098 + 0.3e1 * t1953 * t3103 - t1969 * t3086 - 0.3e1 * t1969 * t3098 - 0.2e1 * t1969 * t3115 + 0.3e1 * t2269 * t2002 + t3093 + t3096 - t3108 - t3113 + t3120 + t3121 - t3122 - t3123;
  t3126 = my_piecewise5(t64, 0, t67, 0, t3088 + t3124);
  t3128 = t52 * t291 * t834 / 0.24e2 + 0.2e1 * t260 * t886 + t59 * t3126;
  t3132 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3128);
  tv3sigma2lapl0 = t8 * t3132;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3138 = t241 * t843;
  t3139 = t1437 * t3138;
  t3144 = t241 * t850;
  t3145 = t575 * t3144;
  t3146 = t790 * t3145;
  t3147 = t2411 * t787;
  t3151 = t234 * t315 * t850 * t586;
  t3152 = 0.2e1 * t2986;
  t3153 = 0.2e1 * t2995;
  t3154 = 0.2e1 * t3005;
  t3155 = t315 * t843;
  t3156 = t3155 * t584;
  t3157 = t560 * t3156;
  t3158 = t3157 * t1521;
  t3159 = 0.3e1 * t3158;
  t3160 = t3157 * t1529;
  t3161 = 0.3e1 * t3160;
  t3162 = params->csk_a * t843;
  t3163 = t3162 * t584;
  t3164 = t242 * t3163;
  t3165 = t2125 * t3164;
  t3166 = 0.3e1 * t3165;
  t3168 = t843 * t122 * t241;
  t3169 = t1471 * t3168;
  t3174 = -t2397 * t2101 - 0.3e1 * t2348 * t2110 - 0.2e1 * t2114 * t3139 - 0.3e1 * t2114 * t3169 + 0.3e1 * t2138 * t3169 + t3146 + t3147 - t3151 + t3152 - t3153 + t3154 - t3159 - t3161 + t3166 - t852 - t903;
  t3178 = t1437 * t1438 * t843;
  t3183 = t802 * t3028;
  t3186 = t1445 * t843 * t567 * t569;
  t3189 = t593 * t850;
  t3190 = t592 * t3189;
  t3191 = t802 * t3190;
  t3192 = t1453 * t843;
  t3193 = t1450 * t3192;
  t3198 = t790 * t3028;
  t3201 = t234 * t3155;
  t3202 = t3201 * t1852;
  t3203 = 0.3e1 * t3202;
  t3204 = t2448 * t2156;
  t3205 = 0.3e1 * t3204;
  t3206 = 0.2e1 * t3029;
  t3207 = 0.2e1 * t3031;
  t3208 = 0.2e1 * t3038;
  t3209 = -t2114 * t3178 + 0.3e1 * t2138 * t3178 + 0.3e1 * t2138 * t3186 + 0.3e1 * t2397 * t2147 - t2153 * t3178 - 0.3e1 * t2153 * t3186 - 0.2e1 * t2153 * t3193 + 0.3e1 * t2397 * t2163 - t3183 - t3191 + t3198 + t3203 + t3205 + t3206 - t3207 - t3208;
  t3211 = my_piecewise5(t114, 0, t115, 0, t3174 + t3209);
  t3213 = t52 * t308 * t860 / 0.24e2 + 0.2e1 * t278 * t912 + t113 * t3211;
  t3217 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3213);
  tv3sigma2lapl11 = t8 * t3217;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3228 = 0.2e1 * t3062;
  t3229 = 0.2e1 * t3063;
  t3230 = 0.2e1 * t3067;
  t3231 = params->csk_a * t263;
  t3232 = t3231 * t403;
  t3234 = t2742 * t171 * t3232;
  t3235 = 0.3e1 * t3234;
  t3236 = t3231 * t167;
  t3238 = t2737 * t389 * t3236;
  t3239 = 0.3e1 * t3238;
  t3241 = t2737 * t3231 * t1147;
  t3242 = 0.3e1 * t3241;
  t3243 = t1056 * t872;
  t3246 = t1617 * t2520;
  t3248 = -0.2e1 * t2729 * t1056 * t878 - 0.3e1 * t2732 * t1599 - t1616 * t2721 - 0.3e1 * t2729 * t3243 - t2747 * t3246 + t2911 - t2920 + t2922 + t3228 + t3229 - t3230 + t3235 - t3239 - t3242 - t826 - t929;
  t3256 = t1069 * t263;
  t3260 = t1073 * t263;
  t3261 = t1051 * t3260;
  t3266 = t2757 * t394 * t878 * t167;
  t3267 = 0.3e1 * t3266;
  t3270 = t2780 * t1658;
  t3271 = 0.3e1 * t3270;
  t3274 = 0.2e1 * t3096;
  t3275 = 0.2e1 * t3108;
  t3276 = 0.2e1 * t3113;
  t3277 = -0.2e1 * t2747 * t1066 * t3256 + 0.3e1 * t2747 * t1627 + 0.3e1 * t2747 * t1649 - t2729 * t3246 + 0.3e1 * t2732 * t3243 + 0.3e1 * t2732 * t3246 + 0.3e1 * t2732 * t3261 - 0.3e1 * t2747 * t3261 + t2954 - t2956 - t2963 + t3267 + t3271 + t3274 - t3275 - t3276;
  t3279 = my_piecewise5(t64, 0, t67, 0, t3248 + t3277);
  t3281 = t52 * t291 * t886 / 0.12e2 + t260 * t935 + t59 * t3279;
  t3285 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3281);
  tv3sigmalapl20 = t8 * t3285;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3296 = 0.2e1 * t3146;
  t3297 = 0.2e1 * t3147;
  t3298 = 0.2e1 * t3151;
  t3299 = params->csk_a * t281;
  t3300 = t3299 * t238;
  t3302 = t2842 * t570 * t3300;
  t3303 = 0.3e1 * t3302;
  t3304 = t3299 * t584;
  t3306 = t2847 * t242 * t3304;
  t3307 = 0.3e1 * t3306;
  t3309 = t2842 * t3299 * t1528;
  t3310 = 0.3e1 * t3309;
  t3311 = t1445 * t2651;
  t3315 = -0.2e1 * t2837 * t1437 * t904 - 0.3e1 * t2834 * t1799 - t1810 * t2822 + 0.3e1 * t2834 * t3311 - t2852 * t3311 + t2986 - t2995 + t3005 + t3296 + t3297 - t3298 - t3303 + t3307 - t3310 - t852 - t952;
  t3316 = t1471 * t2651;
  t3319 = t570 * t281;
  t3320 = t1445 * t3319;
  t3323 = t2870 * t1858;
  t3324 = 0.3e1 * t3323;
  t3332 = t1453 * t281;
  t3340 = t2881 * t575 * t904 * t238;
  t3341 = 0.3e1 * t3340;
  t3342 = 0.2e1 * t3183;
  t3343 = 0.2e1 * t3191;
  t3344 = 0.2e1 * t3198;
  t3345 = -0.2e1 * t2852 * t1450 * t3332 + 0.3e1 * t2852 * t1816 + 0.3e1 * t2852 * t1843 + 0.3e1 * t2834 * t3316 + 0.3e1 * t2834 * t3320 - t2837 * t3311 - 0.3e1 * t2837 * t3316 - 0.3e1 * t2852 * t3320 + t3029 - t3031 - t3038 + t3324 + t3341 - t3342 - t3343 + t3344;
  t3347 = my_piecewise5(t114, 0, t115, 0, t3315 + t3345);
  t3349 = t52 * t308 * t912 / 0.12e2 + t278 * t958 + t113 * t3347;
  t3353 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3349);
  tv3sigmalapl28 = t8 * t3353;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3357 = 0.3e1 * t3062;
  t3358 = 0.3e1 * t3063;
  t3359 = 0.3e1 * t3067;
  t3360 = t922 * t298;
  t3369 = t3360 * t167;
  t3371 = t163 * t3369 * t1127;
  t3372 = 0.3e1 * t3371;
  t3373 = t3360 * t403;
  t3374 = t379 * t3373;
  t3375 = t3374 * t1148;
  t3376 = 0.3e1 * t3375;
  t3377 = t3374 * t1135;
  t3378 = 0.3e1 * t3377;
  t3379 = 0.3e1 * t3096;
  t3380 = 0.3e1 * t3108;
  t3381 = -t1045 * t3360 * t1111 - 0.2e1 * t163 * t3360 * t1118 - 0.3e1 * t379 * t3360 * t1122 + t3357 + t3358 - t3359 + t3372 - t3376 - t3378 + t3379 - t3380 - t826 - t929;
  t3382 = 0.3e1 * t3113;
  t3383 = t3360 * t1046;
  t3384 = t1045 * t3383;
  t3391 = t379 * t3383;
  t3394 = t163 * t3373;
  t3395 = t3394 * t1105;
  t3396 = 0.3e1 * t3395;
  t3398 = t379 * t3369 * t1040;
  t3399 = 0.3e1 * t3398;
  t3400 = t163 * t3383;
  t3411 = 0.3e1 * t3384 * t1052 - t3384 * t1059 + 0.3e1 * t3391 * t1059 - t3400 * t1059 - 0.2e1 * t3384 * t1070 - 0.3e1 * t3384 * t1074 + 0.3e1 * t3391 * t1074 + 0.3e1 * t3384 * t1088 + 0.3e1 * t3391 * t1092 - 0.3e1 * t3400 * t1092 - t3382 + t3396 + t3399;
  t3413 = my_piecewise5(t64, 0, t67, 0, t3381 + t3411);
  t3415 = t52 * t291 * t935 / 0.8e1 + t59 * t3413;
  t3419 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3415);
  tv3lapl30 = t8 * t3419;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3423 = 0.3e1 * t3146;
  t3424 = 0.3e1 * t3147;
  t3425 = 0.3e1 * t3151;
  t3426 = t945 * t315;
  t3435 = t3426 * t584;
  t3436 = t560 * t3435;
  t3437 = t3436 * t1521;
  t3438 = 0.3e1 * t3437;
  t3439 = t3426 * t238;
  t3441 = t234 * t3439 * t1534;
  t3442 = 0.3e1 * t3441;
  t3443 = t3436 * t1529;
  t3444 = 0.3e1 * t3443;
  t3445 = 0.3e1 * t3183;
  t3446 = 0.3e1 * t3191;
  t3447 = -t1425 * t3426 * t1497 - 0.3e1 * t560 * t3426 * t1504 - 0.2e1 * t234 * t3426 * t1508 + t3423 + t3424 - t3425 - t3438 + t3442 - t3444 - t3445 - t3446 - t852 - t952;
  t3448 = 0.3e1 * t3198;
  t3449 = t3426 * t1427;
  t3450 = t560 * t3449;
  t3453 = t1425 * t3449;
  t3463 = t560 * t3439 * t1480;
  t3464 = 0.3e1 * t3463;
  t3465 = t234 * t3435;
  t3466 = t3465 * t1491;
  t3467 = 0.3e1 * t3466;
  t3468 = t234 * t3449;
  t3477 = 0.3e1 * t3453 * t1433 + 0.3e1 * t3450 * t1439 - t3453 * t1439 - t3468 * t1439 + 0.3e1 * t3450 * t1446 - 0.3e1 * t3453 * t1446 - 0.2e1 * t3453 * t1454 + 0.3e1 * t3453 * t1462 + 0.3e1 * t3450 * t1472 - 0.3e1 * t3468 * t1472 + t3448 + t3464 + t3467;
  t3479 = my_piecewise5(t114, 0, t115, 0, t3447 + t3477);
  t3481 = t52 * t308 * t958 / 0.8e1 + t113 * t3479;
  t3485 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3481);
  tv3lapl33 = t8 * t3485;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3489 = 0.1e1 / t30 / t331;
  t3493 = 0.14e2 / 0.135e3 * t7 * t29 * t3489 * t79;
  t3495 = t7 * t345 * t418;
  t3501 = t7 * t1008 * t176;
  t3504 = t7 * t354 * t418;
  t3507 = t7 * t145 * t1155;
  t3511 = 0.1e1 / t41 / t361 / t39;
  t3514 = 0.1309e5 / 0.729e3 * t38 * sigma[0] * t3511;
  t3521 = 0.2618e4 / 0.243e3 * t47 * t48 * t3511 + 0.77e3 / 0.243e3 * t52 * t53 * t1020 - t3514;
  t3532 = t399 * t399;
  t3533 = t163 * t3532;
  t3541 = t380 * t380;
  t3542 = t379 * t3541;
  t3543 = t403 * t403;
  t3544 = t3543 * t384;
  t3545 = t3544 * t389;
  t3548 = t163 * t3541;
  t3549 = t3544 * t171;
  t3552 = t382 * t382;
  t3553 = t383 * t383;
  t3554 = 0.1e1 / t3553;
  t3555 = t3552 * t3554;
  t3556 = t3555 * t171;
  t3560 = t3555 * t1110;
  t3564 = t3555 * t389;
  t3567 = t377 * t377;
  t3569 = t76 / t3567;
  t3571 = t386 * t386;
  t3572 = t387 * t387;
  t3573 = 0.1e1 / t3572;
  t3574 = t3571 * t3573;
  t3575 = t3555 * t3574;
  t3577 = my_piecewise3(t67, 0, t3521);
  t3578 = my_piecewise3(t69, t3577, 0);
  t3584 = t399 * t380;
  t3585 = t3584 * t403;
  t3589 = t379 * t3585;
  t3594 = t3541 * t382;
  t3595 = t163 * t3594;
  t3596 = t1056 * t1126;
  t3599 = 0.18e2 * t163 * t3585 * t1148 - t163 * t3578 * t172 + t3569 * t3541 * t3575 - 0.18e2 * t3589 * t1135 - 0.18e2 * t3589 * t1148 + 0.11e2 * t3542 * t3564 - 0.18e2 * t3595 * t3596 + 0.4e1 * t1128 - 0.4e1 * t1136 - 0.4e1 * t1149 - t406;
  t3601 = t399 * t1046;
  t3605 = t3541 * t403;
  t3608 = t382 * t74 * t170;
  t3609 = t1091 * t3608;
  t3612 = t163 * t1582;
  t3614 = t1056 * t1058 * t399;
  t3618 = t1056 * t1058 * t403;
  t3621 = t1051 * t1623;
  t3624 = t379 * t3594;
  t3626 = t1051 * t1073 * t403;
  t3632 = t1045 * t3594;
  t3636 = t1066 * t1087 * t403;
  t3645 = t1066 * t1069 * t403;
  t3648 = t1056 * t1139;
  t3651 = t1114 * t382;
  t3652 = t379 * t3651;
  t3656 = t1051 * t1039 * params->csk_a;
  t3660 = t411 * t1083 * t403;
  t3663 = t389 * t399;
  t3664 = t1617 * t3663;
  t3667 = t1068 * t399;
  t3669 = t1066 * t3667 * params->csk_a;
  t3675 = t1066 * t1069 * t399;
  t3680 = -0.6e1 * t1583 * t3614 - 0.18e2 * t1583 * t3664 + 0.18e2 * t1583 * t3669 - 0.12e2 * t1583 * t3675 + 0.18e2 * t1598 * t3664 + 0.18e2 * t1656 * t3660 - 0.18e2 * t3612 * t3648 - 0.6e1 * t3632 * t3618 - 0.12e2 * t3632 * t3645 + 0.18e2 * t3632 * t3656 - 0.4e1 * t3652 * t630;
  t3687 = t163 * t3651;
  t3690 = t1051 * t1039;
  t3693 = t3541 * t3552;
  t3694 = t1045 * t3693;
  t3695 = t3554 * t386;
  t3696 = t3695 * t412;
  t3699 = t379 * t3693;
  t3702 = t3569 * t3693;
  t3703 = t1057 * params->csk_a;
  t3704 = t3554 * t3703;
  t3705 = t3704 * t389;
  t3708 = t3554 * t3571;
  t3710 = t3708 * t3573 * t1057;
  t3713 = t3573 * t3703;
  t3714 = t3708 * t3713;
  t3722 = t3554 * t1065;
  t3723 = t3722 * t1069;
  t3734 = t3708 * t3573 * params->csk_a;
  t3739 = t3695 * t1073;
  t3742 = t3532 * t382;
  t3746 = t379 * t3742;
  t3754 = t1066 * t1068 * t403;
  t3757 = 0.4e1 * t623 * t411 * t388 * t1114 - 0.6e1 * t1583 * t1066 * t3667 + 0.3e1 * t163 * t3742 * t396 - 0.6e1 * t3632 * t3754 + 0.4e1 * t3687 * t640 + 0.18e2 * t3694 * t3705 + 0.18e2 * t3702 * t3723 - 0.6e1 * t3702 * t3734 + 0.7e1 * t3702 * t3739 - 0.3e1 * t3746 * t396 - 0.3e1 * t3746 * t413;
  t3759 = t3541 * t3543;
  t3760 = t379 * t3759;
  t3765 = t3554 * params->csk_a;
  t3766 = t3765 * t171;
  t3772 = t163 * t3693;
  t3779 = t170 * t382;
  t3780 = t1056 * t3779;
  t3785 = t1051 * t1083;
  t3788 = t3722 * t1087;
  t3791 = t3554 * t1057;
  t3792 = t3791 * t171;
  t3795 = -0.12e2 * t163 * t3601 * t1605 - 0.12e2 * t163 * t3605 * t3780 + 0.3e1 * t163 * t3759 * t396 - 0.18e2 * t1598 * t3785 - 0.12e2 * t3694 * t3788 - 0.11e2 * t3699 * t3739 - 0.11e2 * t3699 * t3766 - 0.18e2 * t3699 * t3792 - 0.3e1 * t3760 * t396 - 0.3e1 * t3760 * t413 + 0.11e2 * t3772 * t3766;
  t3800 = t3554 * t74;
  t3801 = t170 * t3703;
  t3802 = t3800 * t3801;
  t3809 = t1068 * t3703;
  t3810 = t3722 * t3809;
  t3821 = -0.6e1 * t3694 * t3723 + 0.6e1 * t3694 * t3792 + 0.6e1 * t3694 * t3802 + 0.12e2 * t3694 * t3810 - 0.7e1 * t3699 * t3705 - 0.7e1 * t3699 * t3802 - 0.6e1 * t3702 * t3788 - t3702 * t3802 - 0.12e2 * t3702 * t3810 + 0.6e1 * t3772 * t3792 + t3772 * t3802;
  t3825 = my_piecewise5(t64, 0, t67, 0, t3821 + t3795 + t3757 + t3680 - 0.4e1 * t163 * t1114 * t165 * t405 + t3599 + 0.4e1 * t1106 - 0.5e1 * t1079 + 0.4e1 * t1041 + 0.3e1 * t3533 * t407 - 0.3e1 * t3533 * t405 + 0.3e1 * t3542 * t3545 + 0.3e1 * t3548 * t3549 + 0.6e1 * t3548 * t3556 - 0.7e1 * t3702 * t3705 + 0.11e2 * t3702 * t3710 - 0.6e1 * t3702 * t3714 + 0.18e2 * t1598 * t3614 - 0.4e1 * t3652 * t645 + 0.4e1 * t3687 * t630 - 0.18e2 * t3624 * t3690 - 0.18e2 * t3694 * t3696 + 0.7e1 * t3699 * t3696 - 0.18e2 * t3632 * t3626 + 0.18e2 * t3632 * t3636 + 0.18e2 * t3624 * t3618 - 0.6e1 * t3612 * t3614 - 0.6e1 * t3595 * t3618 + 0.18e2 * t1583 * t3621 + 0.18e2 * t3624 * t3626 + 0.3e1 * t379 * t3532 * t390 + 0.6e1 * t1045 * t3541 * t3560 + 0.18e2 * t379 * t3601 * t1639 + 0.18e2 * t379 * t3605 * t3609 + 0.18e2 * t163 * t3584 * t1664);
  t3831 = t21 * t21;
  t3833 = 0.1e1 / t26 / t3831;
  t3834 = t328 * t328;
  t3840 = t336 * t336;
  t3846 = 0.1e1 / t975 / t8;
  t3847 = t18 * t3846;
  t3850 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t976 + 0.24e2 * t3847);
  t3854 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3833 * t3834 - 0.2e2 / 0.9e1 * t968 * t328 * t336 + 0.1e2 / 0.3e1 * t327 * t3840 + 0.4e2 / 0.9e1 * t972 * t980 + 0.5e1 / 0.3e1 * t27 * t3850);
  t3863 = t7 * t989 * t176;
  t3869 = t7 * t996 * t176;
  t3873 = t7 * t984 * t144 * t79;
  t3877 = t7 * t340 * t353 * t79;
  t3881 = t7 * t139 * t1007 * t79;
  t3883 = -t3493 + 0.6e1 / 0.5e1 * t3495 + 0.3e1 / 0.5e1 * t7 * t140 * t1155 + 0.8e1 / 0.45e2 * t3501 - t3504 / 0.5e1 + 0.2e1 / 0.5e1 * t3507 + 0.3e1 / 0.2e2 * t7 * t32 * (0.4e1 * t1030 * t174 + 0.4e1 * t161 * t1153 + t3521 * t77 + 0.6e1 * t373 * t416 + t59 * t3825 + t3514) + 0.3e1 / 0.2e2 * t7 * t3854 * t31 * t79 + 0.3e1 / 0.5e1 * t7 * t985 * t176 + 0.6e1 / 0.5e1 * t3863 + 0.9e1 / 0.1e2 * t7 * t341 * t418 - 0.2e1 / 0.5e1 * t3869 + 0.2e1 / 0.5e1 * t3873 - t3877 / 0.5e1 + 0.8e1 / 0.45e2 * t3881;
  t3884 = my_piecewise3(t2, 0, t3883);
  t3885 = t88 * t88;
  t3887 = 0.1e1 / t90 / t3885;
  t3888 = t425 * t425;
  t3894 = t431 * t431;
  t3899 = t85 * t3846;
  t3902 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t976 + 0.24e2 * t3899);
  t3906 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3887 * t3888 - 0.2e2 / 0.9e1 * t1162 * t425 * t431 + 0.1e2 / 0.3e1 * t424 * t3894 + 0.4e2 / 0.9e1 * t1166 * t1172 + 0.5e1 / 0.3e1 * t91 * t3902);
  t3913 = t7 * t1176 * t144 * t127;
  t3917 = t7 * t435 * t353 * t127;
  t3921 = t7 * t187 * t1007 * t127;
  t3926 = 0.14e2 / 0.135e3 * t7 * t93 * t3489 * t127;
  t3928 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t3906 * t31 * t127 + 0.2e1 / 0.5e1 * t3913 - t3917 / 0.5e1 + 0.8e1 / 0.45e2 * t3921 - t3926);
  tv4rho40 = 0.4e1 * t1160 + 0.4e1 * t1194 + t8 * (t3884 + t3928);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3935 = t7 * t1214 * t144 * t79;
  t3939 = t7 * t460 * t353 * t79;
  t3940 = t3939 / 0.1e2;
  t3943 = t7 * t204 * t1007 * t79;
  t3961 = 0.12e2 * t976;
  t3962 = 0.24e2 * t3847;
  t3964 = my_piecewise5(t12, 0, t16, 0, -t3961 + t3962);
  t3968 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3833 * t201 * t969 - 0.1e2 / 0.9e1 * t968 * t456 * t328 - 0.1e2 / 0.9e1 * t1199 * t136 * t336 + 0.1e2 / 0.3e1 * t327 * t1210 * t136 + 0.1e2 / 0.3e1 * t1202 * t336 + 0.1e2 / 0.9e1 * t452 * t980 + 0.5e1 / 0.3e1 * t27 * t3964);
  t3977 = t7 * t1219 * t176;
  t3983 = t7 * t1226 * t176;
  t3984 = t3983 / 0.1e2;
  t3986 = t7 * t465 * t418;
  t4000 = 0.3e1 / 0.1e2 * t3935 - t3940 + 0.2e1 / 0.45e2 * t3943 - t3493 + 0.3e1 / 0.2e2 * t7 * t3968 * t31 * t79 + 0.9e1 / 0.2e2 * t7 * t1215 * t176 + 0.3e1 / 0.5e1 * t3977 + 0.9e1 / 0.2e2 * t7 * t461 * t418 - t3984 + 0.3e1 / 0.1e2 * t3986 + 0.3e1 / 0.2e2 * t7 * t205 * t1155 + 0.3e1 / 0.1e2 * t3495 + 0.2e1 / 0.15e2 * t3501 - t3504 / 0.1e2 + t3507 / 0.1e2 + 0.3e1 / 0.1e2 * t3863 - t3869 / 0.5e1 + t3873 / 0.1e2 - t3877 / 0.1e2 + 0.2e1 / 0.15e2 * t3881;
  t4001 = my_piecewise3(t2, 0, t4000);
  t4018 = 0.24e2 * t3899;
  t4020 = my_piecewise5(t16, 0, t12, 0, t3961 + t4018);
  t4024 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3887 * t212 * t1163 - 0.1e2 / 0.9e1 * t1162 * t480 * t425 - 0.1e2 / 0.9e1 * t1243 * t184 * t431 + 0.1e2 / 0.3e1 * t424 * t1253 * t184 + 0.1e2 / 0.3e1 * t1246 * t431 + 0.1e2 / 0.9e1 * t476 * t1172 + 0.5e1 / 0.3e1 * t91 * t4020);
  t4031 = t7 * t1257 * t144 * t127;
  t4035 = t7 * t484 * t353 * t127;
  t4036 = t4035 / 0.1e2;
  t4039 = t7 * t215 * t1007 * t127;
  t4048 = t7 * t1181 * t247;
  t4051 = t7 * t1185 * t247;
  t4052 = t4051 / 0.1e2;
  t4054 = t7 * t1189 * t247;
  t4056 = 0.3e1 / 0.2e2 * t7 * t4024 * t31 * t127 + 0.3e1 / 0.1e2 * t4031 - t4036 + 0.2e1 / 0.45e2 * t4039 + t3913 / 0.1e2 - t3917 / 0.1e2 + 0.2e1 / 0.15e2 * t3921 - t3926 + 0.3e1 / 0.2e2 * t7 * t1177 * t247 + 0.3e1 / 0.1e2 * t4048 - t4052 + 0.2e1 / 0.45e2 * t4054;
  t4057 = my_piecewise3(t84, 0, t4056);
  tv4rho41 = t1160 + t1194 + 0.3e1 * t1242 + 0.3e1 * t1282 + t8 * (t4001 + t4057);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4066 = t7 * t1298 * t144 * t79;
  t4070 = t7 * t515 * t353 * t79;
  t4083 = t456 * t456;
  t4096 = my_piecewise5(t12, 0, t16, 0, t3962);
  t4100 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3833 * t506 * t328 - 0.4e2 / 0.27e2 * t1199 * t136 * t456 - 0.1e2 / 0.27e2 * t1285 * t336 + 0.2e2 / 0.9e1 * t327 * t4083 + 0.2e2 / 0.9e1 * t452 * t1210 - 0.1e2 / 0.27e2 * t968 * t511 * t328 + 0.2e2 / 0.9e1 * t327 * t1294 * t136 + 0.1e2 / 0.9e1 * t1290 * t336 + 0.5e1 / 0.3e1 * t27 * t4096);
  t4109 = t7 * t1303 * t176;
  t4122 = t4066 / 0.5e1 - t4070 / 0.3e2 + t3935 / 0.5e1 - 0.2e1 / 0.15e2 * t3939 + 0.4e1 / 0.45e2 * t3943 - t3493 + 0.3e1 / 0.2e2 * t7 * t4100 * t31 * t79 + 0.3e1 / 0.1e2 * t7 * t1299 * t176 + t4109 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t516 * t418 + 0.2e1 / 0.5e1 * t3977 - 0.2e1 / 0.15e2 * t3983 + t3986 / 0.5e1 + 0.4e1 / 0.45e2 * t3501 - t3504 / 0.3e2 - t3869 / 0.15e2 - t3877 / 0.3e2 + 0.4e1 / 0.45e2 * t3881;
  t4123 = my_piecewise3(t2, 0, t4122);
  t4132 = t480 * t480;
  t4145 = my_piecewise5(t16, 0, t12, 0, t4018);
  t4149 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3887 * t523 * t425 - 0.4e2 / 0.27e2 * t1243 * t184 * t480 - 0.1e2 / 0.27e2 * t1315 * t431 + 0.2e2 / 0.9e1 * t424 * t4132 + 0.2e2 / 0.9e1 * t476 * t1253 - 0.1e2 / 0.27e2 * t1162 * t528 * t425 + 0.2e2 / 0.9e1 * t424 * t1324 * t184 + 0.1e2 / 0.9e1 * t1320 * t431 + 0.5e1 / 0.3e1 * t91 * t4145);
  t4156 = t7 * t1328 * t144 * t127;
  t4160 = t7 * t532 * t353 * t127;
  t4169 = t7 * t1262 * t247;
  t4172 = t7 * t1266 * t247;
  t4183 = t7 * t440 * t599;
  t4186 = t7 * t444 * t599;
  t4188 = 0.3e1 / 0.2e2 * t7 * t4149 * t31 * t127 + t4156 / 0.5e1 - t4160 / 0.3e2 + t4031 / 0.5e1 - 0.2e1 / 0.15e2 * t4035 + 0.4e1 / 0.45e2 * t4039 + 0.3e1 / 0.1e2 * t7 * t1258 * t247 + 0.2e1 / 0.5e1 * t4169 - t4172 / 0.15e2 - t3917 / 0.3e2 + 0.4e1 / 0.45e2 * t3921 - t3926 + t4048 / 0.5e1 - 0.2e1 / 0.15e2 * t4051 + 0.4e1 / 0.45e2 * t4054 + 0.3e1 / 0.2e2 * t7 * t436 * t599 + t4183 / 0.5e1 - t4186 / 0.3e2;
  t4189 = my_piecewise3(t84, 0, t4188);
  tv4rho42 = 0.2e1 * t1242 + 0.2e1 * t1282 + 0.2e1 * t1314 + 0.2e1 * t1353 + t8 * (t4123 + t4189);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4210 = my_piecewise5(t12, 0, t16, 0, t3961 + t3962);
  t4214 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3833 * t1358 * t136 - 0.1e2 / 0.9e1 * t1285 * t456 - 0.1e2 / 0.9e1 * t1199 * t511 * t136 + 0.1e2 / 0.3e1 * t1202 * t511 + 0.1e2 / 0.3e1 * t452 * t1294 + 0.1e2 / 0.9e1 * t327 * t1365 * t136 + 0.5e1 / 0.3e1 * t27 * t4210);
  t4221 = t7 * t1369 * t144 * t79;
  t4232 = 0.3e1 / 0.2e2 * t7 * t4214 * t31 * t79 + t4221 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t1370 * t176 + 0.3e1 / 0.1e2 * t4066 - t4070 / 0.1e2 + 0.3e1 / 0.1e2 * t4109 - t3940 + 0.2e1 / 0.15e2 * t3943 - t3984 + 0.2e1 / 0.45e2 * t3881 - t3493 + 0.2e1 / 0.45e2 * t3501;
  t4233 = my_piecewise3(t2, 0, t4232);
  t4250 = my_piecewise5(t16, 0, t12, 0, -t3961 + t4018);
  t4254 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3887 * t1378 * t184 - 0.1e2 / 0.9e1 * t1315 * t480 - 0.1e2 / 0.9e1 * t1243 * t528 * t184 + 0.1e2 / 0.3e1 * t1246 * t528 + 0.1e2 / 0.3e1 * t476 * t1324 + 0.1e2 / 0.9e1 * t424 * t1385 * t184 + 0.5e1 / 0.3e1 * t91 * t4250);
  t4261 = t7 * t1389 * t144 * t127;
  t4269 = t7 * t1333 * t247;
  t4278 = t7 * t489 * t599;
  t4288 = t7 * t192 * t1541;
  t4290 = 0.3e1 / 0.2e2 * t7 * t4254 * t31 * t127 + t4261 / 0.1e2 + 0.3e1 / 0.1e2 * t4156 - t4160 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t1329 * t247 + 0.3e1 / 0.1e2 * t4269 - t4036 + 0.2e1 / 0.15e2 * t4039 + 0.3e1 / 0.5e1 * t4169 - t4172 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t485 * t599 + 0.3e1 / 0.1e2 * t4278 + 0.2e1 / 0.45e2 * t3921 - t3926 - t4052 + 0.2e1 / 0.15e2 * t4054 + 0.3e1 / 0.1e2 * t4183 - t4186 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t188 * t1541 + t4288 / 0.1e2;
  t4291 = my_piecewise3(t84, 0, t4290);
  tv4rho43 = 0.3e1 * t1314 + 0.3e1 * t1353 + t1377 + t1546 + t8 * (t4233 + t4291);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4296 = t506 * t506;
  t4301 = t511 * t511;
  t4308 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t976 + 0.24e2 * t3847);
  t4312 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3833 * t4296 - 0.2e2 / 0.9e1 * t1285 * t511 + 0.1e2 / 0.3e1 * t327 * t4301 + 0.4e2 / 0.9e1 * t452 * t1365 + 0.5e1 / 0.3e1 * t27 * t4308);
  t4321 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t4312 * t31 * t79 + 0.2e1 / 0.5e1 * t4221 - t4070 / 0.5e1 + 0.8e1 / 0.45e2 * t3943 - t3493);
  t4333 = 0.1e1 / t97 / t542 / t95;
  t4336 = 0.1309e5 / 0.729e3 * t38 * sigma[2] * t4333;
  t4343 = 0.2618e4 / 0.243e3 * t47 * t103 * t4333 + 0.77e3 / 0.243e3 * t52 * t107 * t1407 - t4336;
  t4354 = t580 * t580;
  t4355 = t234 * t4354;
  t4363 = t558 * t558;
  t4365 = t124 / t4363;
  t4366 = t561 * t561;
  t4368 = t563 * t563;
  t4369 = t564 * t564;
  t4370 = 0.1e1 / t4369;
  t4371 = t4368 * t4370;
  t4372 = t567 * t567;
  t4373 = t568 * t568;
  t4374 = 0.1e1 / t4373;
  t4375 = t4372 * t4374;
  t4376 = t4371 * t4375;
  t4378 = my_piecewise3(t115, 0, t4343);
  t4379 = my_piecewise3(t117, t4378, 0);
  t4382 = t234 * t4366;
  t4383 = t584 * t584;
  t4384 = t4383 * t565;
  t4385 = t4384 * t242;
  t4388 = t4371 * t242;
  t4392 = t560 * t4366;
  t4393 = t4384 * t570;
  t4396 = t4371 * t570;
  t4400 = t4371 * t1496;
  t4406 = t580 * t561;
  t4407 = t4406 * t584;
  t4408 = t560 * t4407;
  t4416 = t4366 * t563;
  t4417 = t1425 * t4416;
  t4419 = t1445 * t242 * t584;
  t4422 = 0.6e1 * t1425 * t4366 * t4400 + 0.18e2 * t234 * t4407 * t1529 - 0.18e2 * t4408 * t1521 - 0.18e2 * t4408 * t1529 + 0.3e1 * t4392 * t4393 + 0.11e2 * t4392 * t4396 - 0.6e1 * t4417 * t4419 - 0.4e1 * t1522 - 0.4e1 * t1530 + 0.4e1 * t1535 - t587;
  t4425 = t1445 * t570 * t584;
  t4429 = t1450 * t1453 * t584;
  t4432 = t580 * t1427;
  t4433 = t560 * t4432;
  t4436 = t4366 * t584;
  t4439 = t563 * t122 * t241;
  t4440 = t1471 * t4439;
  t4443 = t234 * t4416;
  t4444 = t1437 * t1533;
  t4448 = t592 * t1457 * t584;
  t4452 = t1450 * t1461 * t584;
  t4455 = t560 * t4416;
  t4462 = t1432 * t593 * t584;
  t4470 = t1500 * t563;
  t4471 = t560 * t4470;
  t4474 = t234 * t1777;
  t4475 = t1437 * t1512;
  t4480 = t1452 * t580;
  t4482 = t1450 * t4480 * params->csk_a;
  t4486 = t1432 * t1823 * t580;
  t4489 = t242 * t580;
  t4490 = t1445 * t4489;
  t4498 = t1450 * t1453 * t580;
  t4501 = 0.18e2 * t1778 * t4482 - 0.18e2 * t1778 * t4486 - 0.6e1 * t1778 * t4490 - 0.12e2 * t1778 * t4498 + 0.18e2 * t1798 * t4486 + 0.18e2 * t1798 * t4490 - 0.6e1 * t4443 * t4419 + 0.18e2 * t4455 * t4419 - 0.4e1 * t4471 * t692 - 0.4e1 * t4471 * t707 - 0.18e2 * t4474 * t4475;
  t4504 = t1432 * t1864;
  t4509 = t234 * t4470;
  t4513 = t241 * t563;
  t4514 = t1437 * t4513;
  t4517 = t4366 * t4383;
  t4518 = t560 * t4517;
  t4521 = t4366 * t4368;
  t4522 = t560 * t4521;
  t4523 = t4370 * t567;
  t4524 = t4523 * t593;
  t4527 = t4365 * t4521;
  t4528 = t4370 * t4372;
  t4530 = t4528 * t4374 * params->csk_a;
  t4537 = t4523 * t1823;
  t4540 = t569 * t3703;
  t4541 = t4523 * t4540;
  t4545 = t1425 * t4521;
  t4550 = t4370 * t3703;
  t4551 = t4550 * t1496;
  t4555 = t4528 * t4374 * t1057;
  t4558 = t4374 * t3703;
  t4559 = t4528 * t4558;
  t4569 = t4354 * t563;
  t4573 = t560 * t4569;
  t4577 = t1450 * t1452 * t584;
  t4582 = 0.4e1 * t685 * t592 * t569 * t1500 - 0.6e1 * t1778 * t1450 * t4480 + 0.3e1 * t234 * t4569 * t577 - 0.6e1 * t4417 * t4577 + 0.4e1 * t4509 * t702 - 0.7e1 * t4527 * t4541 - 0.12e2 * t4527 * t4551 + 0.11e2 * t4527 * t4555 - 0.6e1 * t4527 * t4559 + 0.18e2 * t4545 * t4541 - 0.3e1 * t4573 * t594;
  t4586 = t4370 * t1449;
  t4587 = t4586 * t1461;
  t4590 = t4586 * t1453;
  t4593 = t4370 * params->csk_a;
  t4594 = t4593 * t242;
  t4600 = t234 * t4521;
  t4603 = t1432 * t1479;
  t4609 = t1432 * t1457;
  t4616 = -0.12e2 * t234 * t4432 * t1795 + 0.3e1 * t234 * t4517 * t577 - 0.18e2 * t1798 * t4609 - 0.18e2 * t4455 * t4603 - 0.3e1 * t4518 * t577 - 0.11e2 * t4522 * t4594 - 0.6e1 * t4527 * t4587 + 0.18e2 * t4527 * t4590 - 0.12e2 * t4545 * t4587 - 0.3e1 * t4573 * t577 + 0.11e2 * t4600 * t4594;
  t4619 = t4370 * t122;
  t4620 = t4619 * t1438;
  t4629 = t241 * t3703;
  t4630 = t4619 * t4629;
  t4641 = -0.18e2 * t4522 * t4620 - 0.7e1 * t4522 * t4630 - 0.18e2 * t4545 * t4524 + 0.7e1 * t4527 * t4537 - t4527 * t4630 + 0.12e2 * t4545 * t4551 - 0.6e1 * t4545 * t4590 + 0.6e1 * t4545 * t4620 + 0.6e1 * t4545 * t4630 + 0.6e1 * t4600 * t4620 + t4600 * t4630;
  t4645 = my_piecewise5(t114, 0, t115, 0, t4641 + 0.4e1 * t1492 + 0.4e1 * t1481 - 0.5e1 * t1469 + t4616 - 0.4e1 * t234 * t1500 * t236 * t586 + t4582 + t4501 + 0.18e2 * t560 * t4436 * t4440 + 0.18e2 * t234 * t4406 * t1852 - 0.12e2 * t234 * t4436 * t4514 + 0.3e1 * t560 * t4354 * t571 + t4365 * t4366 * t4376 - t234 * t4379 * t243 - 0.11e2 * t4522 * t4537 - 0.7e1 * t4522 * t4541 - 0.3e1 * t4518 * t594 + 0.7e1 * t4522 * t4524 - 0.6e1 * t4527 * t4530 + 0.18e2 * t1778 * t4504 - 0.6e1 * t4474 * t4490 + 0.4e1 * t4509 * t692 + 0.18e2 * t4417 * t4462 + 0.18e2 * t4433 * t1834 - 0.18e2 * t4443 * t4444 + 0.18e2 * t1856 * t4448 + 0.18e2 * t4417 * t4452 + 0.18e2 * t4455 * t4425 - 0.18e2 * t4417 * t4425 - 0.12e2 * t4417 * t4429 + 0.3e1 * t4382 * t4385 + 0.6e1 * t4382 * t4388 + 0.3e1 * t4355 * t588 - 0.3e1 * t4355 * t586 + t4422);
  t4651 = t523 * t523;
  t4656 = t528 * t528;
  t4663 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t976 + 0.24e2 * t3899);
  t4667 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3887 * t4651 - 0.2e2 / 0.9e1 * t1315 * t528 + 0.1e2 / 0.3e1 * t424 * t4656 + 0.4e2 / 0.9e1 * t476 * t1385 + 0.5e1 / 0.3e1 * t91 * t4663);
  t4681 = 0.2e1 / 0.5e1 * t4261 + 0.6e1 / 0.5e1 * t4269 + 0.6e1 / 0.5e1 * t4278 + 0.2e1 / 0.5e1 * t4288 - t4160 / 0.5e1 - 0.2e1 / 0.5e1 * t4172 - t4186 / 0.5e1 + 0.8e1 / 0.45e2 * t4039 + 0.8e1 / 0.45e2 * t4054 - t3926 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t4645 + t4343 * t125 + 0.4e1 * t1417 * t245 + 0.4e1 * t232 * t1539 + 0.6e1 * t554 * t597 + t4336) + 0.3e1 / 0.2e2 * t7 * t4667 * t31 * t127 + 0.3e1 / 0.5e1 * t7 * t1390 * t247 + 0.9e1 / 0.1e2 * t7 * t533 * t599 + 0.3e1 / 0.5e1 * t7 * t216 * t1541;
  t4682 = my_piecewise3(t84, 0, t4681);
  tv4rho44 = 0.4e1 * t1377 + 0.4e1 * t1546 + t8 * (t4321 + t4682);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4690 = t7 * t989 * t268;
  t4696 = t7 * t996 * t268;
  t4699 = t7 * t345 * t650;
  t4706 = 0.2e1 / 0.45e2 * t7 * t1008 * t268;
  t4708 = t7 * t354 * t650;
  t4711 = t7 * t145 * t1692;
  t4714 = 0.77e3 / 0.243e3 * t38 * t1020;
  t4718 = -0.154e3 / 0.81e2 * t47 * t37 * t1020 + t4714;
  t4732 = my_piecewise3(t67, 0, t4718);
  t4733 = my_piecewise3(t69, t4732, 0);
  t4738 = t1591 * t403;
  t4739 = t163 * t4738;
  t4743 = t1145 * t167;
  t4744 = t171 * t399;
  t4745 = t4743 * t4744;
  t4751 = t379 * t2528;
  t4753 = t1057 * t399 * t165;
  t4754 = t389 * t4753;
  t4758 = t1045 * t3601 * t1050;
  t4759 = t3231 * t165;
  t4760 = t389 * t4759;
  t4763 = t263 * t1036;
  t4764 = t4763 * t403;
  t4765 = t379 * t4764;
  t4768 = t627 * t1050;
  t4769 = t163 * t4768;
  t4772 = t171 * params->csk_a * t1036 * t403;
  t4775 = -t163 * t4733 * t172 - 0.9e1 * t379 * t2496 * t4745 - 0.9e1 * t379 * t4738 * t2501 + 0.9e1 * t4739 * t2492 + 0.18e2 * t4765 * t3609 + 0.9e1 * t4751 * t4754 + 0.9e1 * t4758 * t4760 - 0.18e2 * t4769 * t4772 - 0.3e1 * t1589 - 0.2e1 * t1593 + 0.4e1 * t1659 + 0.4e1 * t1665 - t638;
  t4777 = t1057 * t1036 * t403;
  t4778 = t171 * t4777;
  t4781 = t1617 * t3608;
  t4784 = t1045 * t4764;
  t4787 = t633 * t380;
  t4788 = t4787 * t403;
  t4792 = t163 * t2528;
  t4793 = t399 * params->csk_a;
  t4795 = t171 * t4793 * t165;
  t4798 = t165 * t167;
  t4800 = t379 * t4798 * t384;
  t4806 = t379 * t4788;
  t4809 = t1036 * t382;
  t4811 = t1045 * t4809 * t1050;
  t4812 = t389 * t3232;
  t4816 = t382 * t386 * t388;
  t4817 = t1617 * t4816;
  t4823 = t1066 * t1069 * t382;
  t4826 = t1110 * t4753;
  t4829 = t1110 * t3232;
  t4832 = 0.9e1 * t163 * t4788 * t1148 + 0.9e1 * t4800 * t389 * t4738 - 0.9e1 * t4806 * t1148 + 0.9e1 * t4739 * t2262 - 0.9e1 * t2529 * t4754 - 0.6e1 * t2529 * t4826 + 0.18e2 * t4765 * t4781 - 0.6e1 * t4769 * t4778 - 0.6e1 * t4784 * t4781 - 0.18e2 * t4784 * t4817 - 0.12e2 * t4784 * t4823 - 0.9e1 * t4792 * t4795 + 0.18e2 * t4811 * t4812 + 0.18e2 * t4811 * t4829;
  t4835 = t1057 * t165 * t4744;
  t4846 = t389 * t4777;
  t4853 = t163 * t4763;
  t4854 = t3544 * t2495;
  t4857 = t263 * t3552;
  t4858 = t163 * t4857;
  t4860 = t3800 * t395 * t1036;
  t4863 = t379 * t4809;
  t4867 = t379 * t4763;
  t4870 = t379 * t4857;
  t4873 = t1045 * t4857;
  t4875 = t3722 * t3809 * t1036;
  t4878 = t633 * t1046;
  t4879 = t379 * t4878;
  t4882 = -0.18e2 * t4863 * t1051 * t1657 + 0.9e1 * t4758 * t1110 * t4759 + 0.18e2 * t379 * t4768 * t4846 - 0.9e1 * t4806 * t1135 + 0.9e1 * t4879 * t1620 - 0.3e1 * t2529 * t4835 + 0.9e1 * t4751 * t4795 + 0.9e1 * t4751 * t4835 - 0.3e1 * t4792 * t4835 + 0.3e1 * t4853 * t4854 - 0.3e1 * t4867 * t4854 + 0.11e2 * t4858 * t4860 - 0.11e2 * t4870 * t4860 + 0.12e2 * t4873 * t4875;
  t4884 = t1036 * t74 * t170;
  t4885 = t3791 * t4884;
  t4890 = t1051 * t2290;
  t4893 = t1036 * t3552;
  t4894 = t3569 * t4893;
  t4895 = t3722 * t1626;
  t4900 = t1045 * t4878;
  t4905 = t3704 * t4884;
  t4908 = t3569 * t4857;
  t4917 = t163 * t4878;
  t4920 = -0.3e1 * t1642 * t1140 + 0.9e1 * t1583 * t4890 - 0.9e1 * t4900 * t1620 - 0.9e1 * t4917 * t1639 + 0.9e1 * t4879 * t1647 - 0.3e1 * t4900 * t1647 + 0.6e1 * t4858 * t4885 + t4858 * t4905 - 0.18e2 * t4870 * t4885 - 0.7e1 * t4870 * t4905 + 0.6e1 * t4873 * t4885 + 0.6e1 * t4873 * t4905 - 0.6e1 * t4894 * t4895 - t4908 * t4905;
  t4923 = t1045 * t4893;
  t4924 = t3695 * t882;
  t4927 = t1068 * t633;
  t4929 = t1066 * t4927 * params->csk_a;
  t4936 = t3573 * t263;
  t4943 = t1613 * t382;
  t4944 = t163 * t4943;
  t4952 = t403 * t1050 * t3608;
  t4955 = t389 * params->csk_a;
  t4956 = t3544 * t4955;
  t4960 = t3722 * t1069 * t1036;
  t4964 = t394 * t395 * t1114;
  t4967 = t411 * t412 * t1114;
  t4969 = -0.3e1 * t2200 * t1066 * t1584 * t399 - 0.6e1 * t4894 * t3708 * t4936 * params->csk_a + 0.9e1 * t1583 * t4929 + 0.9e1 * t4879 * t1639 - 0.12e2 * t4853 * t4952 - 0.3e1 * t4867 * t4956 - 0.6e1 * t4873 * t4960 - 0.12e2 * t4908 * t4875 - 0.12e2 * t4923 * t4895 - 0.18e2 * t4923 * t4924 + 0.3e1 * t4944 * t630 + t628 * t4964 - t642 * t4967;
  t4979 = t3708 * t3713 * t1036;
  t4987 = t3704 * t1036 * t386 * t388;
  t4990 = t379 * t4943;
  t4993 = t379 * t4893;
  t4997 = t3695 * t1073 * t1036;
  t5000 = t3695 * t3260;
  t5005 = t3722 * t3256;
  t5010 = 0.11e2 * t4894 * t3708 * t4936 * t1057 + 0.3e1 * t1609 * t1140 - 0.3e1 * t1642 * t1624 - 0.3e1 * t4917 * t1647 - 0.6e1 * t4900 * t1668 - 0.11e2 * t4870 * t4997 + 0.18e2 * t4873 * t4987 + 0.7e1 * t4894 * t5000 + 0.18e2 * t4894 * t5005 - 0.6e1 * t4908 * t4979 - 0.7e1 * t4908 * t4987 + 0.7e1 * t4993 * t4924 - t642 * t4964 - 0.3e1 * t4990 * t645;
  t5014 = t379 * t2199;
  t5022 = t411 * t1578 * t403;
  t5025 = t1045 * t4809;
  t5034 = t1056 * t1594 * t165;
  t5041 = t3800 * t170 * t1036;
  t5045 = t379 * t1036 * t3543;
  t5053 = -0.9e1 * t5014 * t1051 * t624 * t399 - 0.6e1 * t5025 * t1066 * t1584 * t403 + 0.9e1 * t163 * t4787 * t1664 + 0.11e2 * t4993 * t3695 * t624 - 0.6e1 * t1603 * t5034 + 0.9e1 * t1656 * t5022 + 0.3e1 * t4853 * t3549 + 0.6e1 * t4858 * t5041 - 0.7e1 * t4870 * t4987 - 0.3e1 * t4990 * t630 + 0.3e1 * t5045 * t625 - 0.4e1 * t1676 - 0.4e1 * t1678 + 0.4e1 * t1686;
  t5054 = t1051 * t1578;
  t5066 = t394 * t170 * t1114;
  t5074 = t411 * t388 * t1613;
  t5077 = t1066 * t4927;
  t5092 = -0.9e1 * t1598 * t5054 + 0.6e1 * t4923 * t3722 * t1584 - t163 * t263 * t1114 * t405 + 0.3e1 * t1609 * t1595 + t628 * t5066 + t3652 * t625 - 0.6e1 * t4917 * t1605 + 0.3e1 * t1130 * t1579 + 0.3e1 * t623 * t5074 - 0.3e1 * t1583 * t5077 + t4894 * t3708 * t4936 - 0.3e1 * t163 * t1613 * t165 * t405 - 0.3e1 * t163 * t633 * t399 * t405 + 0.3e1 * t4944 * t640;
  t5096 = my_piecewise5(t64, 0, t67, 0, t4775 + t4832 + t4882 + t4920 + t4969 + t5010 + t5053 + t5092);
  t5103 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t268 + 0.3e1 / 0.1e2 * t4690 + 0.9e1 / 0.2e2 * t7 * t341 * t650 - t4696 / 0.1e2 + 0.3e1 / 0.5e1 * t4699 + 0.9e1 / 0.2e2 * t7 * t140 * t1692 + t4706 - t4708 / 0.1e2 + 0.3e1 / 0.1e2 * t4711 + 0.3e1 / 0.2e2 * t7 * t32 * (t1030 * t266 + t260 * t1153 + 0.3e1 * t1570 * t174 + 0.3e1 * t161 * t1690 + 0.3e1 * t373 * t648 + 0.3e1 * t618 * t416 + t4718 * t77 + t59 * t5096 - t4714));
  tv4rho3sigma0 = t8 * t5103 + 0.3e1 * t1697;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5110 = t7 * t1181 * t286;
  t5113 = t7 * t1185 * t286;
  t5117 = 0.2e1 / 0.45e2 * t7 * t1189 * t286;
  t5119 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1177 * t286 + 0.3e1 / 0.1e2 * t5110 - t5113 / 0.1e2 + t5117);
  tv4rho3sigma2 = t8 * t5119 + 0.3e1 * t1710;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5121 = 0.2e1 * t1724;
  t5127 = t7 * t1219 * t268 / 0.5e1;
  t5132 = t7 * t1226 * t268;
  t5136 = t7 * t465 * t650 / 0.5e1;
  t5145 = 0.3e1 / 0.2e2 * t7 * t1215 * t268 + t5127 + 0.3e1 / 0.1e2 * t7 * t461 * t650 - t5132 / 0.3e2 + t5136 + 0.3e1 / 0.2e2 * t7 * t205 * t1692 + t4690 / 0.1e2 - t4696 / 0.15e2 + t4699 / 0.5e1 + t4706 - t4708 / 0.15e2 + t4711 / 0.1e2;
  t5146 = my_piecewise3(t2, 0, t5145);
  tv4rho3sigma3 = t8 * t5146 + t1697 + t5121;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5148 = 0.2e1 * t1740;
  t5154 = t7 * t1262 * t286 / 0.5e1;
  t5156 = t7 * t1266 * t286;
  t5165 = t7 * t440 * t712 / 0.5e1;
  t5167 = t7 * t444 * t712;
  t5170 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1258 * t286 + t5154 - t5156 / 0.3e2 + t5110 / 0.1e2 - t5113 / 0.15e2 + t5117 + 0.3e1 / 0.2e2 * t7 * t436 * t712 + t5165 - t5167 / 0.3e2);
  tv4rho3sigma5 = t8 * t5170 + t1710 + t5148;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5176 = t7 * t1303 * t268;
  t5185 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1299 * t268 + t5176 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t650 + t5127 - t5132 / 0.15e2 + t5136 - t4696 / 0.3e2 + t4706 - t4708 / 0.3e2);
  tv4rho3sigma6 = t8 * t5185 + t1748 + t5121;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5191 = t7 * t1333 * t286;
  t5198 = t7 * t489 * t712;
  t5206 = t7 * t192 * t1885;
  t5208 = 0.3e1 / 0.2e2 * t7 * t1329 * t286 + t5191 / 0.1e2 + t5154 - t5156 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t712 + t5198 / 0.5e1 - t5113 / 0.3e2 + t5117 + t5165 - t5167 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t1885 + t5206 / 0.1e2;
  t5209 = my_piecewise3(t84, 0, t5208);
  tv4rho3sigma8 = t8 * t5209 + t1890 + t5148;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5218 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1370 * t268 + 0.3e1 / 0.1e2 * t5176 - t5132 / 0.1e2 + t4706);
  tv4rho3sigma9 = t8 * t5218 + 0.3e1 * t1748;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5236 = 0.77e3 / 0.243e3 * t38 * t1407;
  t5240 = -0.154e3 / 0.81e2 * t47 * t37 * t1407 + t5236;
  t5254 = my_piecewise3(t115, 0, t5240);
  t5255 = my_piecewise3(t117, t5254, 0);
  t5260 = t1786 * t584;
  t5265 = t1526 * t238;
  t5266 = t5265 * t4489;
  t5269 = t234 * t5260;
  t5273 = t1425 * t4432 * t1431;
  t5274 = t3299 * t236;
  t5275 = t570 * t5274;
  t5278 = t689 * t1431;
  t5279 = t234 * t5278;
  t5282 = t242 * params->csk_a * t1426 * t584;
  t5285 = t281 * t1426;
  t5286 = t5285 * t584;
  t5288 = t1445 * t4439;
  t5291 = t1425 * t5286;
  t5294 = -t234 * t5255 * t243 - 0.9e1 * t560 * t5260 * t2617 - 0.9e1 * t560 * t2625 * t5266 + 0.18e2 * t560 * t5286 * t5288 + 0.9e1 * t5269 * t2621 + 0.9e1 * t5273 * t5275 - 0.18e2 * t5279 * t5282 - 0.6e1 * t5291 * t5288 - 0.3e1 * t1784 - 0.2e1 * t1788 + 0.4e1 * t1853 + 0.4e1 * t1859 - t700;
  t5296 = t1057 * t1426 * t584;
  t5297 = t242 * t5296;
  t5300 = t234 * t2634;
  t5301 = t580 * params->csk_a;
  t5303 = t242 * t5301 * t236;
  t5306 = t695 * t561;
  t5307 = t5306 * t584;
  t5311 = t560 * t5278;
  t5314 = t560 * t2634;
  t5316 = t1057 * t580 * t236;
  t5317 = t570 * t5316;
  t5320 = t560 * t5307;
  t5323 = t1426 * t563;
  t5325 = t1425 * t5323 * t1431;
  t5330 = t563 * t567 * t569;
  t5331 = t1445 * t5330;
  t5336 = t560 * t580 * t238 * t565;
  t5344 = t1057 * t236 * t4489;
  t5347 = t570 * t5296;
  t5354 = 0.9e1 * t5273 * t1496 * t5274 + 0.9e1 * t234 * t5307 * t1529 + 0.9e1 * t5336 * t570 * t2625 + 0.18e2 * t5325 * t570 * t3304 - 0.9e1 * t5320 * t1521 - 0.9e1 * t5320 * t1529 - 0.3e1 * t2635 * t5344 - 0.6e1 * t5279 * t5297 + 0.18e2 * t5311 * t5282 - 0.18e2 * t5291 * t5331 - 0.9e1 * t5300 * t5303 + 0.18e2 * t5311 * t5347 + 0.9e1 * t5314 * t5317 + 0.9e1 * t5314 * t5344;
  t5360 = t1496 * t5316;
  t5363 = t1496 * t3304;
  t5374 = t695 * t1427;
  t5375 = t1425 * t5374;
  t5378 = t281 * t4368;
  t5379 = t234 * t5378;
  t5381 = t4619 * t1438 * t1426;
  t5384 = t1425 * t5378;
  t5386 = t4586 * t1453 * t1426;
  t5389 = t234 * t5285;
  t5391 = t584 * t1431 * t4439;
  t5394 = t560 * t5285;
  t5395 = t570 * params->csk_a;
  t5396 = t4384 * t5395;
  t5399 = t4384 * t2624;
  t5404 = -0.12e2 * t5291 * t1450 * t1453 * t563 - 0.3e1 * t5375 * t1841 + 0.9e1 * t5269 * t2415 - 0.9e1 * t2635 * t5317 - 0.6e1 * t2635 * t5360 - 0.3e1 * t5300 * t5344 + 0.9e1 * t5314 * t5303 + 0.18e2 * t5325 * t5363 + 0.6e1 * t5379 * t5381 - 0.6e1 * t5384 * t5386 - 0.12e2 * t5389 * t5391 + 0.3e1 * t5389 * t5399 - 0.3e1 * t5394 * t5396 - 0.3e1 * t5394 * t5399;
  t5406 = t4619 * t576 * t1426;
  t5409 = t560 * t5378;
  t5412 = t1452 * t3703;
  t5414 = t4586 * t5412 * t1426;
  t5419 = t4550 * t1426 * t122 * t241;
  t5422 = t4365 * t5378;
  t5431 = t1432 * t2440;
  t5434 = t1426 * t4368;
  t5435 = t4365 * t5434;
  t5436 = t4586 * t1815;
  t5439 = t560 * t5374;
  t5444 = t234 * t5374;
  t5447 = 0.9e1 * t1778 * t5431 - 0.9e1 * t5375 * t1825 - 0.9e1 * t5444 * t1834 + 0.9e1 * t5439 * t1841 + 0.11e2 * t5379 * t5406 + t5379 * t5419 + 0.6e1 * t5384 * t5381 - 0.18e2 * t5409 * t5381 + 0.12e2 * t5384 * t5414 + 0.6e1 * t5384 * t5419 - 0.11e2 * t5409 * t5406 - 0.7e1 * t5409 * t5419 - t5422 * t5419 - 0.6e1 * t5435 * t5436;
  t5450 = t560 * t5434;
  t5451 = t4523 * t908;
  t5455 = t4523 * t1823 * t1426;
  t5459 = t4523 * t686 * t1057;
  t5464 = t4550 * t1426 * t567 * t569;
  t5467 = t1452 * t695;
  t5469 = t1450 * t5467 * params->csk_a;
  t5472 = t4374 * t281;
  t5479 = t1425 * t5434;
  t5486 = t1807 * t563;
  t5487 = t234 * t5486;
  t5493 = t592 * t1773 * t584;
  t5496 = t1425 * t5323;
  t5501 = -0.6e1 * t5496 * t1450 * t1779 * t584 - 0.3e1 * t2357 * t1450 * t4480 * t281 - 0.6e1 * t5435 * t4528 * t5472 * params->csk_a + 0.9e1 * t1778 * t5469 + 0.9e1 * t5439 * t1834 + 0.9e1 * t1856 * t5493 - 0.11e2 * t5409 * t5455 - 0.7e1 * t5422 * t5464 + 0.7e1 * t5435 * t5459 - 0.12e2 * t5479 * t5436 + 0.7e1 * t5450 * t5451 - 0.18e2 * t5479 * t5451 + 0.3e1 * t5487 * t692;
  t5504 = t1526 * t1500 * t122 * t241;
  t5506 = t4586 * t3332;
  t5515 = t560 * t5486;
  t5518 = t560 * t5323;
  t5519 = t1432 * t1857;
  t5535 = 0.3e1 * t1803 * t1513 - 0.3e1 * t1829 * t1513 + 0.9e1 * t5439 * t1825 - 0.3e1 * t1829 * t1865 - 0.3e1 * t5444 * t1841 + 0.18e2 * t5384 * t5464 - 0.7e1 * t5409 * t5464 - 0.12e2 * t5422 * t5414 + 0.18e2 * t5435 * t5506 + t690 * t5504 - t704 * t5504 - 0.3e1 * t5515 * t692 - 0.3e1 * t5515 * t707 - 0.18e2 * t5518 * t5519;
  t5538 = t592 * t593 * t1500;
  t5547 = t4528 * t4558 * t1426;
  t5554 = t1437 * t1789 * t236;
  t5565 = t4619 * t241 * t1426;
  t5569 = t560 * t1426 * t4383;
  t5574 = t1432 * t1773;
  t5577 = 0.11e2 * t5435 * t4528 * t5472 * t1057 - 0.9e1 * t4433 * t1432 * t686 * t236 + 0.9e1 * t234 * t5306 * t1852 - 0.6e1 * t1793 * t5554 - 0.9e1 * t1798 * t5574 - 0.6e1 * t5375 * t1812 + 0.3e1 * t5389 * t4385 + 0.6e1 * t5379 * t5565 - 0.6e1 * t5422 * t5547 - t704 * t5538 + 0.3e1 * t5569 * t687 - 0.4e1 * t1869 + 0.4e1 * t1877 - 0.4e1 * t1879;
  t5581 = t4523 * t686;
  t5600 = t575 * t241 * t1500;
  t5608 = t592 * t569 * t1807;
  t5611 = t1450 * t5467;
  t5616 = 0.6e1 * t5479 * t4586 * t1779 + 0.11e2 * t5450 * t5581 + t5435 * t4528 * t5472 - 0.3e1 * t234 * t1807 * t236 * t586 - 0.3e1 * t234 * t695 * t580 * t586 - t234 * t281 * t1500 * t586 + 0.3e1 * t1803 * t1790 + t690 * t5600 - 0.6e1 * t5444 * t1795 + t4471 * t687 + 0.3e1 * t1516 * t1774 + 0.3e1 * t685 * t5608 - 0.3e1 * t1778 * t5611 + 0.3e1 * t5487 * t702;
  t5620 = my_piecewise5(t114, 0, t115, 0, t5294 + t5354 + t5404 + t5447 + t5501 + t5535 + t5577 + t5616);
  t5627 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1390 * t286 + 0.3e1 / 0.1e2 * t5191 + 0.9e1 / 0.2e2 * t7 * t533 * t712 - t5156 / 0.1e2 + 0.3e1 / 0.5e1 * t5198 + 0.9e1 / 0.2e2 * t7 * t216 * t1885 + t5117 - t5167 / 0.1e2 + 0.3e1 / 0.1e2 * t5206 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t5620 + t5240 * t125 + t1417 * t284 + t278 * t1539 + 0.3e1 * t1764 * t245 + 0.3e1 * t232 * t1883 + 0.3e1 * t554 * t710 + 0.3e1 * t680 * t597 - t5236));
  tv4rho3sigma11 = t8 * t5627 + 0.3e1 * t1890;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t5634 = t7 * t989 * t303;
  t5640 = t7 * t996 * t303;
  t5643 = t7 * t345 * t754;
  t5650 = 0.2e1 / 0.45e2 * t7 * t1008 * t303;
  t5652 = t7 * t354 * t754;
  t5655 = t7 * t145 * t2011;
  t5678 = my_piecewise3(t67, 0, -0.55e2 / 0.81e2 * t52 * t1567);
  t5679 = my_piecewise3(t69, t5678, 0);
  t5684 = t1920 * t403;
  t5685 = t163 * t5684;
  t5696 = t741 * t380;
  t5697 = t5696 * t403;
  t5698 = t379 * t5697;
  t5701 = t2723 * params->csk_a;
  t5702 = t389 * t5701;
  t5705 = t298 * t1036;
  t5706 = t5705 * t403;
  t5707 = t1045 * t5706;
  t5710 = -t163 * t5679 * t172 - 0.9e1 * t379 * t5684 * t2501 - 0.9e1 * t379 * t2515 * t4745 - 0.9e1 * t5698 * t1148 + 0.9e1 * t5685 * t2492 + 0.9e1 * t4758 * t2532 + 0.18e2 * t4811 * t5702 - 0.18e2 * t5707 * t4817 - 0.2e1 * t1922 - 0.3e1 * t1945 + 0.4e1 * t1973 + 0.4e1 * t1977 - t746;
  t5711 = t379 * t5706;
  t5714 = t735 * t1050;
  t5715 = t163 * t5714;
  t5733 = t389 * t5684;
  t5740 = t1110 * t5701;
  t5745 = 0.9e1 * t163 * t5697 * t1148 - 0.9e1 * t5698 * t1135 + 0.9e1 * t5685 * t2262 + 0.9e1 * t2519 * t4795 - 0.9e1 * t2524 * t4795 - 0.3e1 * t2524 * t4835 + 0.9e1 * t4758 * t2544 + 0.18e2 * t5711 * t3609 - 0.18e2 * t5715 * t4772 - 0.6e1 * t5715 * t4778 - 0.6e1 * t5707 * t4781 + 0.18e2 * t5711 * t4781 + 0.9e1 * t4800 * t5733 + 0.18e2 * t4811 * t5740;
  t5751 = t379 * t5714;
  t5754 = t298 * t3552;
  t5755 = t1045 * t5754;
  t5758 = t1051 * t2774;
  t5761 = t3722 * t2001;
  t5764 = t1950 * t382;
  t5765 = t163 * t5764;
  t5769 = t3695 * t732 * t1057;
  t5776 = t1051 * t1971;
  t5779 = t163 * t5705;
  t5782 = t379 * t5705;
  t5787 = 0.9e1 * t1583 * t5758 - 0.3e1 * t2508 * t4835 + 0.9e1 * t2519 * t4835 + 0.18e2 * t5751 * t4846 - 0.3e1 * t5782 * t4854 - 0.18e2 * t4863 * t5776 + 0.6e1 * t5755 * t4885 - 0.6e1 * t4894 * t5761 + 0.7e1 * t4894 * t5769 - 0.12e2 * t4923 * t5761 - 0.12e2 * t5779 * t4952 - 0.3e1 * t5782 * t4956 - 0.6e1 * t5755 * t4960 + 0.3e1 * t5765 * t630;
  t5788 = t379 * t5754;
  t5793 = t163 * t5754;
  t5806 = t3573 * t298;
  t5808 = t3708 * t5806 * params->csk_a;
  t5811 = t379 * t5764;
  t5816 = t741 * t1046;
  t5817 = t379 * t5816;
  t5820 = t3695 * t1961;
  t5824 = t411 * t1925 * t403;
  t5827 = -0.3e1 * t1956 * t1140 + 0.9e1 * t5817 * t1639 + 0.9e1 * t1656 * t5824 - 0.9e1 * t2508 * t4754 - 0.6e1 * t2508 * t4826 + 0.9e1 * t2519 * t4754 - 0.12e2 * t5707 * t4823 + 0.3e1 * t5779 * t4854 - 0.11e2 * t5788 * t4860 + 0.11e2 * t5793 * t4860 - 0.18e2 * t5788 * t4885 - 0.6e1 * t4894 * t5808 - 0.18e2 * t4923 * t5820 - 0.3e1 * t5811 * t630;
  t5831 = t1051 * t732 * t399;
  t5840 = t1066 * t1929 * t403;
  t5843 = t3569 * t5754;
  t5849 = t1045 * t5816;
  t5860 = t163 * t5816;
  t5863 = 0.9e1 * t163 * t5696 * t1664 - 0.9e1 * t5849 * t1620 - 0.3e1 * t1956 * t1624 - 0.9e1 * t5860 * t1639 - 0.6e1 * t5849 * t1668 - 0.6e1 * t1936 * t5034 - 0.12e2 * t5843 * t4875 - t748 * t4967 + 0.18e2 * t5755 * t4987 - 0.7e1 * t5843 * t4987 - 0.9e1 * t5014 * t5831 - 0.6e1 * t5025 * t5840 - 0.3e1 * t5811 * t645;
  t5869 = t3722 * t1929 * t1057;
  t5880 = t1068 * t741;
  t5882 = t1066 * t5880 * params->csk_a;
  t5898 = -0.3e1 * t2200 * t1066 * t3667 * t298 + 0.9e1 * t1583 * t5882 + 0.9e1 * t5817 * t1647 - 0.3e1 * t5849 * t1647 - 0.3e1 * t5860 * t1647 + 0.12e2 * t5755 * t4875 + 0.6e1 * t5793 * t4885 + 0.18e2 * t4894 * t5869 + 0.6e1 * t5755 * t4905 - 0.7e1 * t5788 * t4905 + t5793 * t4905 - 0.7e1 * t5788 * t4987 + 0.7e1 * t4993 * t5820 - 0.11e2 * t5788 * t4997;
  t5903 = t3708 * t5806 * t1057;
  t5922 = t3695 * t732;
  t5925 = 0.3e1 * t1940 * t1140 + 0.9e1 * t5817 * t1620 + 0.11e2 * t4894 * t5903 - t5843 * t4905 + t736 * t4964 - t748 * t4964 - 0.6e1 * t5843 * t4979 + 0.11e2 * t4993 * t5922 + 0.6e1 * t5793 * t5041 + 0.3e1 * t5045 * t733 + 0.3e1 * t5765 * t640 - 0.4e1 * t1986 + 0.4e1 * t1991 - 0.4e1 * t1993;
  t5928 = t1051 * t1925;
  t5931 = t3722 * t1929;
  t5939 = t411 * t388 * t1950;
  t5942 = t1066 * t5880;
  t5945 = t3708 * t5806;
  t5962 = -t163 * t298 * t1114 * t405 - 0.3e1 * t163 * t1950 * t165 * t405 - 0.3e1 * t163 * t741 * t399 * t405 + 0.3e1 * t1130 * t1926 - 0.3e1 * t1583 * t5942 + 0.3e1 * t1940 * t1595 - 0.9e1 * t1598 * t5928 - 0.6e1 * t5860 * t1605 + 0.3e1 * t5779 * t3549 + t3652 * t733 + t4894 * t5945 + 0.6e1 * t4923 * t5931 + t736 * t5066 + 0.3e1 * t623 * t5939;
  t5966 = my_piecewise5(t64, 0, t67, 0, t5710 + t5745 + t5787 + t5827 + t5863 + t5898 + t5925 + t5962);
  t5973 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t303 + 0.3e1 / 0.1e2 * t5634 + 0.9e1 / 0.2e2 * t7 * t341 * t754 - t5640 / 0.1e2 + 0.3e1 / 0.5e1 * t5643 + 0.9e1 / 0.2e2 * t7 * t140 * t2011 + t5650 - t5652 / 0.1e2 + 0.3e1 / 0.1e2 * t5655 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.55e2 / 0.81e2 * t52 * t1567 * t77 + 0.5e1 / 0.9e1 * t52 * t615 * t174 - 0.5e1 / 0.24e2 * t52 * t257 * t416 + t52 * t291 * t1153 / 0.24e2 + t1030 * t301 + 0.3e1 * t373 * t752 + 0.3e1 * t161 * t2009 + t59 * t5966));
  tv4rho3lapl0 = t8 * t5973 + 0.3e1 * t2016;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t5980 = t7 * t1181 * t320;
  t5983 = t7 * t1185 * t320;
  t5987 = 0.2e1 / 0.45e2 * t7 * t1189 * t320;
  t5989 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1177 * t320 + 0.3e1 / 0.1e2 * t5980 - t5983 / 0.1e2 + t5987);
  tv4rho3lapl1 = t8 * t5989 + 0.3e1 * t2029;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t5991 = 0.2e1 * t2043;
  t5997 = t7 * t1219 * t303 / 0.5e1;
  t6002 = t7 * t1226 * t303;
  t6006 = t7 * t465 * t754 / 0.5e1;
  t6015 = 0.3e1 / 0.2e2 * t7 * t1215 * t303 + t5997 + 0.3e1 / 0.1e2 * t7 * t461 * t754 - t6002 / 0.3e2 + t6006 + 0.3e1 / 0.2e2 * t7 * t205 * t2011 + t5634 / 0.1e2 - t5640 / 0.15e2 + t5643 / 0.5e1 + t5650 - t5652 / 0.15e2 + t5655 / 0.1e2;
  t6016 = my_piecewise3(t2, 0, t6015);
  tv4rho3lapl2 = t8 * t6016 + t2016 + t5991;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t6018 = 0.2e1 * t2059;
  t6024 = t7 * t1262 * t320 / 0.5e1;
  t6026 = t7 * t1266 * t320;
  t6035 = t7 * t440 * t808 / 0.5e1;
  t6037 = t7 * t444 * t808;
  t6040 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1258 * t320 + t6024 - t6026 / 0.3e2 + t5980 / 0.1e2 - t5983 / 0.15e2 + t5987 + 0.3e1 / 0.2e2 * t7 * t436 * t808 + t6035 - t6037 / 0.3e2);
  tv4rho3lapl3 = t8 * t6040 + t2029 + t6018;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6046 = t7 * t1303 * t303;
  t6055 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1299 * t303 + t6046 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t754 + t5997 - t6002 / 0.15e2 + t6006 - t5640 / 0.3e2 + t5650 - t5652 / 0.3e2);
  tv4rho3lapl4 = t8 * t6055 + t2067 + t5991;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6061 = t7 * t1333 * t320;
  t6068 = t7 * t489 * t808;
  t6076 = t7 * t192 * t2181;
  t6078 = 0.3e1 / 0.2e2 * t7 * t1329 * t320 + t6061 / 0.1e2 + t6024 - t6026 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t808 + t6068 / 0.5e1 - t5983 / 0.3e2 + t5987 + t6035 - t6037 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t2181 + t6076 / 0.1e2;
  t6079 = my_piecewise3(t84, 0, t6078);
  tv4rho3lapl5 = t8 * t6079 + t2186 + t6018;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t6088 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1370 * t303 + 0.3e1 / 0.1e2 * t6046 - t6002 / 0.1e2 + t5650);
  tv4rho3lapl6 = t8 * t6088 + 0.3e1 * t2067;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t6126 = my_piecewise3(t115, 0, -0.55e2 / 0.81e2 * t52 * t1761);
  t6127 = my_piecewise3(t117, t6126, 0);
  t6130 = t1467 * t584;
  t6131 = t2624 * t6130;
  t6134 = t560 * t2124;
  t6140 = t795 * t238;
  t6141 = t6140 * t565;
  t6142 = t234 * t6141;
  t6147 = t789 * t1431;
  t6148 = t560 * t6147;
  t6152 = t570 * t1875;
  t6157 = t1425 * t6147;
  t6160 = -t234 * t6127 * t243 - 0.9e1 * t6134 * t5395 * t6130 - 0.9e1 * t560 * t6141 * t6152 + 0.9e1 * t6142 * t1876 + 0.9e1 * t2125 * t6131 + 0.9e1 * t2642 * t5303 - 0.9e1 * t2656 * t5303 + 0.18e2 * t6148 * t5347 - 0.18e2 * t6157 * t5347 - 0.9e1 * t6134 * t6131 - 0.3e1 * t2105 - 0.2e1 * t2109 - t800;
  t6164 = t315 * t1426;
  t6165 = t6164 * t584;
  t6166 = t560 * t6165;
  t6174 = t234 * t6147;
  t6183 = t2824 * params->csk_a;
  t6184 = t570 * t6183;
  t6193 = t1425 * t2356 * t1431;
  t6194 = t2636 * t580;
  t6195 = t1496 * t6194;
  t6200 = t570 * t6194;
  t6203 = -0.6e1 * t1425 * t6165 * t5288 - 0.12e2 * t6157 * t1496 * t5296 + 0.9e1 * t2125 * t242 * t6130 + 0.9e1 * t5336 * t2631 + 0.9e1 * t2642 * t5317 - 0.3e1 * t2656 * t5344 - 0.6e1 * t2666 * t5360 + 0.18e2 * t6166 * t4440 - 0.18e2 * t6174 * t5282 + 0.18e2 * t6166 * t5288 - 0.6e1 * t6174 * t5297 + 0.18e2 * t5325 * t6184 + 0.9e1 * t6193 * t6195 + 0.9e1 * t6193 * t6200;
  t6211 = t1496 * t6183;
  t6219 = t560 * t6164;
  t6222 = t315 * t4368;
  t6223 = t560 * t6222;
  t6226 = t1425 * t6222;
  t6229 = t795 * t1427;
  t6230 = t234 * t6229;
  t6233 = t2120 * t563;
  t6234 = t560 * t6233;
  t6238 = t4523 * t786 * t1057;
  t6241 = t4365 * t6222;
  t6244 = t560 * t6229;
  t6247 = t4586 * t2162;
  t6250 = -0.9e1 * t560 * t795 * t561 * t584 * t1529 - 0.9e1 * t6230 * t1834 + 0.9e1 * t6244 * t1834 + 0.9e1 * t2642 * t5344 - 0.9e1 * t2666 * t5317 - 0.3e1 * t2666 * t5344 + 0.18e2 * t5325 * t6211 - 0.6e1 * t6226 * t5386 - 0.3e1 * t6219 * t5399 - 0.11e2 * t6223 * t5406 + 0.7e1 * t5435 * t6238 - 0.7e1 * t6241 * t5464 - 0.12e2 * t5479 * t6247 - 0.3e1 * t6234 * t692;
  t6253 = t234 * t6164;
  t6256 = t234 * t6222;
  t6259 = t1432 * t2155;
  t6268 = t234 * t6233;
  t6279 = t1425 * t6229;
  t6282 = 0.3e1 * t2091 * t1513 - 0.3e1 * t2135 * t1513 + 0.9e1 * t6244 * t1825 - 0.9e1 * t6279 * t1825 - 0.12e2 * t6253 * t5391 - 0.3e1 * t6219 * t5396 + 0.3e1 * t6253 * t5399 + 0.11e2 * t6256 * t5406 - 0.11e2 * t6223 * t5455 + t790 * t5504 - t802 * t5504 - 0.18e2 * t5518 * t6259 - 0.6e1 * t6241 * t5547 + 0.3e1 * t6268 * t692;
  t6286 = t4586 * t2100 * t1057;
  t6310 = -0.3e1 * t6230 * t1841 + 0.9e1 * t6244 * t1841 - 0.3e1 * t2135 * t1865 + 0.12e2 * t6226 * t5414 - 0.12e2 * t6241 * t5414 - 0.7e1 * t6223 * t5419 + 0.6e1 * t6226 * t5419 - t6241 * t5419 + t6256 * t5419 + 0.18e2 * t5435 * t6286 - 0.7e1 * t6223 * t5464 + 0.18e2 * t6226 * t5464 - t802 * t5538;
  t6315 = t4523 * t2146;
  t6322 = t4374 * t315;
  t6324 = t4528 * t6322 * params->csk_a;
  t6329 = t1452 * t795;
  t6331 = t1450 * t6329 * params->csk_a;
  t6336 = t560 * t2356;
  t6338 = t1432 * t786 * t580;
  t6344 = t4528 * t6322 * t1057;
  t6348 = t592 * t2096 * t584;
  t6352 = t1450 * t2100 * t584;
  t6357 = -0.3e1 * t2357 * t1450 * t4480 * t315 + 0.9e1 * t1778 * t6331 - 0.6e1 * t6279 * t1812 + 0.9e1 * t1856 * t6348 - 0.6e1 * t2114 * t5554 - 0.18e2 * t6223 * t5381 + 0.6e1 * t6226 * t5381 - 0.6e1 * t5435 * t6324 + 0.11e2 * t5435 * t6344 + 0.7e1 * t5450 * t6315 - 0.18e2 * t5479 * t6315 - 0.6e1 * t5496 * t6352 - 0.3e1 * t6234 * t707 - 0.9e1 * t6336 * t6338;
  t6360 = t1794 * t584;
  t6361 = t575 * t6360;
  t6364 = t1432 * t2864;
  t6384 = t4523 * t786;
  t6387 = 0.9e1 * t234 * t6140 * t6361 + 0.9e1 * t1778 * t6364 - 0.3e1 * t6279 * t1841 + 0.3e1 * t6253 * t4385 + 0.6e1 * t6256 * t5381 - 0.6e1 * t5435 * t6247 + 0.11e2 * t5450 * t6384 + 0.6e1 * t6256 * t5565 + 0.3e1 * t5569 * t787 + 0.4e1 * t2126 - 0.4e1 * t2131 - 0.4e1 * t2133 + 0.4e1 * t2157 + 0.4e1 * t2160;
  t6388 = t4586 * t2100;
  t6393 = t4528 * t6322;
  t6406 = t1432 * t2096;
  t6410 = t592 * t569 * t2120;
  t6421 = t1450 * t6329;
  t6424 = -t234 * t315 * t1500 * t586 - 0.3e1 * t234 * t2120 * t236 * t586 - 0.3e1 * t234 * t795 * t580 * t586 + 0.3e1 * t1516 * t2097 - 0.3e1 * t1778 * t6421 + 0.3e1 * t2091 * t1790 - 0.6e1 * t6230 * t1795 - 0.9e1 * t1798 * t6406 + t4471 * t787 + t5435 * t6393 + 0.6e1 * t5479 * t6388 + t790 * t5600 + 0.3e1 * t6268 * t702 + 0.3e1 * t685 * t6410;
  t6428 = my_piecewise5(t114, 0, t115, 0, t6160 + t6203 + t6250 + t6282 + t6310 + t6357 + t6387 + t6424);
  t6435 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1390 * t320 + 0.3e1 / 0.1e2 * t6061 + 0.9e1 / 0.2e2 * t7 * t533 * t808 - t6026 / 0.1e2 + 0.3e1 / 0.5e1 * t6068 + 0.9e1 / 0.2e2 * t7 * t216 * t2181 + t5987 - t6037 / 0.1e2 + 0.3e1 / 0.1e2 * t6076 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.55e2 / 0.81e2 * t52 * t1761 * t125 + 0.5e1 / 0.9e1 * t52 * t677 * t245 - 0.5e1 / 0.24e2 * t52 * t275 * t597 + t52 * t308 * t1539 / 0.24e2 + t1417 * t318 + 0.3e1 * t554 * t806 + 0.3e1 * t232 * t2179 + t113 * t6428));
  tv4rho3lapl7 = t8 * t6435 + 0.3e1 * t2186;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t6442 = t7 * t345 * t836;
  t6449 = t7 * t354 * t836 / 0.3e2;
  t6451 = t7 * t145 * t2313;
  t6462 = 0.2e1 * t2206;
  t6463 = 0.3e1 * t2209;
  t6465 = 0.2e1 * t2228;
  t6466 = t633 * t633;
  t6467 = t163 * t6466;
  t6475 = t1587 * t403;
  t6476 = t2495 * t6475;
  t6485 = t2213 * t165;
  t6486 = params->csk_a * t74 * t6485;
  t6489 = t820 * t1050;
  t6491 = t1057 * t380;
  t6492 = t6491 * t403;
  t6493 = t171 * t6492;
  t6496 = t1045 * t6489;
  t6497 = t1057 * t386;
  t6498 = t388 * t380;
  t6499 = t6498 * t403;
  t6500 = t6497 * t6499;
  t6506 = -0.12e2 * t6496 * t1110 * t6492 - 0.6e1 * t163 * t6489 * t6493 - 0.12e2 * t2514 * t4955 * t6475 + 0.2e1 * t379 * t6466 * t390 + 0.12e2 * t1682 * t6476 - 0.12e2 * t2514 * t6476 - 0.2e1 * t6467 * t405 + 0.2e1 * t6467 * t407 + 0.12e2 * t4751 * t6486 - 0.18e2 * t6496 * t6500 - 0.4e1 * t2215 + t6462 - t6463 + t6465 - t826 - t828;
  t6508 = t824 * t380 * t403;
  t6511 = 0.3e1 * t163 * t6508 * t1148;
  t6514 = 0.3e1 * t379 * t6508 * t1148;
  t6515 = t379 * t6489;
  t6524 = t824 * t167;
  t6526 = t379 * t6524 * t384;
  t6527 = t389 * t1684;
  t6529 = 0.3e1 * t6526 * t6527;
  t6533 = t1057 * t633 * t165;
  t6534 = t389 * t6533;
  t6537 = t171 * t6533;
  t6542 = t2235 * t1050;
  t6545 = t171 * t392 * params->csk_a;
  t6548 = t4793 * t167;
  t6549 = t389 * t6548;
  t6553 = t171 * t4793 * t403;
  t6556 = t4793 * t1147;
  t6560 = t1045 * t2199 * t1050;
  t6561 = t3231 * t633;
  t6571 = 0.12e2 * t163 * t2210 * t384 * t171 * t4798 * t633 - 0.18e2 * t163 * t6542 * t6545 + 0.12e2 * t6560 * t389 * t6561 - 0.3e1 * t2237 * t6549 - 0.3e1 * t2237 * t6556 + 0.3e1 * t2244 * t6553 + 0.12e2 * t4751 * t6534 + 0.12e2 * t4751 * t6537 - 0.12e2 * t4792 * t6486 - 0.4e1 * t4792 * t6537 - 0.6e1 * t6496 * t6493 + 0.18e2 * t6515 * t6493 + 0.18e2 * t6496 * t6527 + 0.18e2 * t6515 * t6500 + t6511 - t6514 - t6529;
  t6579 = t1110 * t6533;
  t6592 = t824 * t1046;
  t6593 = t379 * t6592;
  t6595 = 0.3e1 * t6593 * t1639;
  t6596 = t817 * t3552;
  t6597 = t163 * t6596;
  t6599 = t3800 * t1604 * params->csk_a;
  t6602 = t379 * t6596;
  t6605 = t3791 * t1638;
  t6608 = t1045 * t6596;
  t6611 = t817 * t3543;
  t6612 = t379 * t6611;
  t6613 = t1145 * t1638;
  t6617 = t3695 * t1073 * t380;
  t6621 = t1056 * t1604 * t382;
  t6626 = 0.18e2 * t6496 * t1110 * t1684 + 0.12e2 * t6560 * t1110 * t6561 + 0.12e2 * t2514 * t389 * t6475 + 0.18e2 * t379 * t6542 * t6545 - 0.12e2 * t2260 * t6621 - 0.12e2 * t2529 * t6534 - 0.4e1 * t2529 * t6537 - 0.8e1 * t2529 * t6579 + 0.11e2 * t6597 * t6599 + 0.6e1 * t6597 * t6605 - 0.11e2 * t6602 * t6599 - 0.18e2 * t6602 * t6605 - 0.11e2 * t6602 * t6617 + 0.6e1 * t6608 * t6605 - 0.3e1 * t6612 * t6613 + t6595;
  t6627 = t3722 * t1667;
  t6630 = t1051 * t6499;
  t6633 = t380 * t3552;
  t6634 = t3569 * t6633;
  t6635 = t3573 * t817;
  t6642 = t3722 * t3114;
  t6645 = t3569 * t6596;
  t6647 = t3704 * t1110 * t380;
  t6650 = t1045 * t6592;
  t6652 = 0.3e1 * t6650 * t1620;
  t6655 = t3704 * t1619;
  t6658 = t6498 * params->csk_a;
  t6659 = t3695 * t6658;
  t6662 = t163 * t6592;
  t6664 = 0.3e1 * t6662 * t1639;
  t6666 = 0.3e1 * t6593 * t1647;
  t6676 = 0.3e1 * t6593 * t1620;
  t6677 = -0.6e1 * t6634 * t3708 * t6635 * params->csk_a - 0.3e1 * t2269 * t3664 - 0.7e1 * t6602 * t6655 + 0.7e1 * t6602 * t6659 - 0.6e1 * t6608 * t6627 + 0.12e2 * t6608 * t6647 + 0.18e2 * t6608 * t6655 - 0.18e2 * t6608 * t6659 + 0.7e1 * t6645 * t6617 - 0.18e2 * t830 * t6630 + 0.18e2 * t6634 * t6642 - 0.12e2 * t6645 * t6647 - 0.7e1 * t6645 * t6655 - t6652 - t6664 + t6666 + t6676;
  t6681 = t394 * t395 * t1613;
  t6686 = t2257 * t1624;
  t6687 = t1068 * t824;
  t6689 = t1066 * t6687 * params->csk_a;
  t6691 = 0.3e1 * t1583 * t6689;
  t6693 = 0.2e1 * t6650 * t1668;
  t6695 = t411 * t412 * t1613;
  t6705 = t3708 * t3713 * t380;
  t6710 = t1045 * t392;
  t6730 = 0.2e1 * t628 * t6681 + 0.3e1 * t2221 * t3664 - t6686 + t6691 - t6693 - 0.2e1 * t642 * t6695 - 0.2e1 * t2269 * t3675 + 0.11e2 * t6634 * t3708 * t6635 * t1057 - 0.6e1 * t6645 * t6705 + 0.3e1 * t2298 * t3660 - 0.6e1 * t6710 * t1066 * t2201 * t403 - 0.12e2 * t1634 * t1051 * t2222 * t633 - 0.12e2 * t6608 * t3722 * t1068 * t380 * params->csk_a + 0.3e1 * t2269 * t3669 - 0.2e1 * t642 * t6681 + 0.3e1 * t2269 * t3621;
  t6736 = t411 * t2204 * t403;
  t6738 = 0.3e1 * t1656 * t6736;
  t6740 = t1604 * t403;
  t6743 = 0.3e1 * t163 * t6524 * t394 * t6740;
  t6744 = t6650 * t1647;
  t6746 = t3800 * t3801 * t380;
  t6753 = t1051 * t3111;
  t6755 = 0.3e1 * t1583 * t6753;
  t6756 = t6662 * t1647;
  t6757 = t817 * t380;
  t6761 = t411 * t6658;
  t6766 = t2227 * t1140;
  t6767 = t2257 * t1140;
  t6771 = -0.6e1 * t6634 * t3722 * t2201 * params->csk_a + 0.3e1 * t163 * t6757 * t4854 + 0.3e1 * t2221 * t3648 - t2229 * t3614 - 0.3e1 * t2229 * t3648 + t6597 * t6746 - 0.7e1 * t6602 * t6746 + 0.6e1 * t6608 * t6746 - 0.3e1 * t6612 * t6761 - t6645 * t6746 + t6738 + t6743 - t6744 + t6755 - t6756 + t6766 - t6767;
  t6781 = t394 * t1594 * t167;
  t6784 = t1056 * t6485;
  t6790 = 0.2e1 * t2258;
  t6792 = 0.2e1 * t2279;
  t6793 = 0.2e1 * t2280;
  t6795 = t6466 * t382;
  t6796 = t379 * t6795;
  t6800 = 0.2e1 * t6662 * t1605;
  t6802 = t394 * t1604;
  t6805 = t3800 * t1604;
  t6808 = -0.4e1 * t2200 * t1066 * t1584 * t633 + 0.3e1 * t163 * t6611 * t6802 - 0.8e1 * t1603 * t6784 + 0.3e1 * t2221 * t3614 + 0.3e1 * t2260 * t6781 - t2269 * t3614 - 0.2e1 * t6796 * t396 + 0.6e1 * t6597 * t6805 - 0.4e1 * t2240 + 0.4e1 * t2247 - 0.4e1 * t2251 + 0.4e1 * t2263 + 0.4e1 * t2301 - t6790 + t6792 - t6793 - t6800;
  t6822 = t163 * t824 * t399 * t405;
  t6823 = t170 * t1613;
  t6827 = t394 * t6823;
  t6832 = t1045 * t6633;
  t6836 = t2227 * t1595;
  t6837 = t1051 * t2204;
  t6839 = 0.3e1 * t1598 * t6837;
  t6840 = t1056 * t1594;
  t6845 = t1045 * t3601;
  t6849 = t1130 * t2205;
  t6850 = t1066 * t6687;
  t6851 = t1583 * t6850;
  t6852 = 0.3e1 * t379 * t6757 * t3545 + 0.11e2 * t6602 * t3695 * t6498 + 0.2e1 * t163 * t6795 * t396 - 0.2e1 * t6796 * t413 - t6822 - 0.2e1 * t2211 * t2212 * t6823 + 0.2e1 * t628 * t6827 - 0.3e1 * t2221 * t3785 + 0.6e1 * t6832 * t3722 * t2201 + t6836 - t6839 - 0.2e1 * t2229 * t6840 + 0.2e1 * t642 * t5074 - t6845 * t2202 + t6634 * t3708 * t6635 + t6849 - t6851;
  t6856 = my_piecewise5(t64, 0, t67, 0, t6506 + t6571 + t6626 + t6677 + t6730 + t6771 + t6808 + t6852);
  t6863 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t836 + t6442 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2313 - t6449 + t6451 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.2e1 * t1570 * t266 + 0.2e1 * t161 * t2311 + 0.2e1 * t260 * t1690 + t373 * t834 + t59 * t6856 + 0.4e1 * t618 * t648));
  tv4rho2sigma20 = t8 * t6863 + 0.2e1 * t2318;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6870 = t7 * t440 * t862;
  t6874 = t7 * t444 * t862 / 0.3e2;
  t6876 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t862 + t6870 / 0.5e1 - t6874);
  tv4rho2sigma25 = t8 * t6876 + 0.2e1 * t2327;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6882 = t7 * t465 * t836;
  t6890 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t836 + t6882 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2313 + t6442 / 0.1e2 - t6449 + t6451 / 0.1e2);
  tv4rho2sigma26 = t8 * t6890 + t2318 + t2333;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6896 = t7 * t489 * t862;
  t6903 = t7 * t192 * t2457;
  t6906 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t862 + t6896 / 0.1e2 + t6870 / 0.1e2 - t6874 + 0.3e1 / 0.2e2 * t7 * t188 * t2457 + t6903 / 0.1e2);
  tv4rho2sigma211 = t8 * t6906 + t2327 + t2462;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6914 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t836 + t6882 / 0.5e1 - t6449);
  tv4rho2sigma212 = t8 * t6914 + 0.2e1 * t2333;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6934 = 0.2e1 * t2355;
  t6935 = 0.2e1 * t2363;
  t6936 = 0.3e1 * t2366;
  t6938 = t695 * t695;
  t6939 = t234 * t6938;
  t6947 = t1782 * t584;
  t6951 = t2624 * t6947;
  t6957 = t1057 * t695 * t236;
  t6958 = t570 * t6957;
  t6961 = t846 * t1431;
  t6962 = t1425 * t6961;
  t6966 = t850 * t561 * t584;
  t6969 = 0.3e1 * t234 * t6966 * t1529;
  t6972 = 0.3e1 * t560 * t6966 * t1529;
  t6973 = -0.12e2 * t2629 * t5395 * t6947 + 0.2e1 * t560 * t6938 * t571 + 0.12e2 * t1873 * t6951 - 0.12e2 * t2629 * t6951 + 0.12e2 * t5314 * t6958 - 0.2e1 * t6939 * t586 + 0.2e1 * t6939 * t588 + 0.18e2 * t6962 * t6152 - 0.4e1 * t2372 + t6934 + t6935 - t6936 + t6969 - t6972 - t852 - t854;
  t6974 = t242 * t6957;
  t6977 = t2379 * t1431;
  t6980 = t242 * t573 * params->csk_a;
  t6990 = t850 * t238;
  t6992 = t560 * t6990 * t565;
  t6994 = 0.3e1 * t6992 * t6152;
  t6996 = t2370 * t236;
  t6997 = params->csk_a * t122 * t6996;
  t7000 = t1057 * t567;
  t7001 = t569 * t561;
  t7002 = t7001 * t584;
  t7003 = t7000 * t7002;
  t7019 = t3299 * t695;
  t7028 = t1496 * t6957;
  t7032 = t1057 * t561;
  t7033 = t7032 * t584;
  t7034 = t242 * t7033;
  t7037 = t560 * t6961;
  t7040 = 0.12e2 * t234 * t2367 * t565 * t242 * t236 * t238 * t695 + 0.18e2 * t6962 * t1496 * t1875 + 0.12e2 * t6193 * t1496 * t7019 - 0.6e1 * t234 * t6961 * t7034 - 0.18e2 * t234 * t6977 * t6980 + 0.12e2 * t2629 * t570 * t6947 + 0.18e2 * t560 * t6977 * t6980 + 0.12e2 * t6193 * t570 * t7019 - 0.12e2 * t2635 * t6958 - 0.4e1 * t2635 * t6974 - 0.8e1 * t2635 * t7028 - 0.4e1 * t5300 * t6974 + 0.12e2 * t5314 * t6974 + 0.12e2 * t5314 * t6997 - 0.18e2 * t6962 * t7003 + 0.18e2 * t7037 * t7034 - t6994;
  t7052 = t242 * t5301 * t584;
  t7055 = t5301 * t238;
  t7056 = t570 * t7055;
  t7059 = t5301 * t1528;
  t7062 = t850 * t1427;
  t7063 = t1425 * t7062;
  t7065 = 0.3e1 * t7063 * t1825;
  t7066 = t843 * t4368;
  t7067 = t4365 * t7066;
  t7068 = t4523 * t1824;
  t7072 = t4550 * t570 * t561;
  t7075 = t234 * t7062;
  t7077 = 0.3e1 * t7075 * t1834;
  t7078 = t560 * t7062;
  t7080 = 0.3e1 * t7078 * t1834;
  t7081 = t234 * t7066;
  t7083 = t4619 * t1794 * params->csk_a;
  t7086 = t560 * t7066;
  t7092 = t7075 * t1841;
  t7093 = -0.12e2 * t847 * t1437 * t6360 - 0.12e2 * t6962 * t1496 * t7033 - 0.3e1 * t2381 * t7056 - 0.3e1 * t2381 * t7059 + 0.3e1 * t2388 * t7052 - 0.12e2 * t5300 * t6997 - 0.6e1 * t6962 * t7034 + 0.18e2 * t7037 * t7003 + 0.7e1 * t7067 * t7068 - 0.7e1 * t7067 * t7072 + 0.11e2 * t7081 * t7083 - 0.11e2 * t7086 * t7083 - t7065 - t7077 + t7080 - t7092;
  t7095 = 0.3e1 * t7078 * t1841;
  t7096 = t7063 * t1841;
  t7100 = 0.3e1 * t7078 * t1825;
  t7102 = t4619 * t4629 * t561;
  t7106 = t1425 * t7066;
  t7110 = t1432 * t3189;
  t7112 = 0.3e1 * t1778 * t7110;
  t7116 = t4586 * t5412 * t561;
  t7119 = t7001 * params->csk_a;
  t7120 = t4523 * t7119;
  t7125 = t561 * t4368;
  t7126 = t4365 * t7125;
  t7127 = t4374 * t843;
  t7133 = t575 * t576 * t1807;
  t7140 = -0.6e1 * t7126 * t4528 * t7127 * params->csk_a + 0.3e1 * t2348 * t4486 + 0.3e1 * t2397 * t4482 + 0.2e1 * t690 * t7133 - 0.2e1 * t704 * t7133 - t7067 * t7102 - 0.7e1 * t7086 * t7072 + 0.18e2 * t7106 * t7072 + t7081 * t7102 - 0.7e1 * t7086 * t7102 + 0.6e1 * t7106 * t7102 + 0.12e2 * t7106 * t7116 - 0.18e2 * t7106 * t7120 + t7095 - t7096 + t7100 + t7112;
  t7145 = t4586 * t3192;
  t7151 = t592 * t593 * t1807;
  t7161 = t4528 * t4558 * t561;
  t7166 = t1425 * t573;
  t7175 = t1437 * t6996;
  t7180 = t4370 * t1057;
  t7181 = t7180 * t1833;
  t7184 = t4586 * t1811;
  t7187 = t1432 * t7002;
  t7192 = -0.3e1 * t2397 * t4486 + 0.18e2 * t7126 * t7145 - 0.12e2 * t7067 * t7116 - 0.2e1 * t704 * t7151 - 0.2e1 * t2397 * t4498 + 0.11e2 * t7126 * t4528 * t7127 * t1057 - 0.6e1 * t7067 * t7161 + 0.3e1 * t2448 * t4448 - 0.6e1 * t7166 * t1450 * t2358 * t584 - 0.12e2 * t1822 * t1432 * t2349 * t695 - 0.8e1 * t1793 * t7175 + 0.7e1 * t7086 * t7120 + 0.6e1 * t7106 * t7181 - 0.6e1 * t7106 * t7184 - 0.18e2 * t856 * t7187 - 0.11e2 * t7086 * t7068;
  t7195 = t2354 * t1513;
  t7196 = t2411 * t1513;
  t7206 = t2411 * t1865;
  t7207 = t1452 * t850;
  t7209 = t1450 * t7207 * params->csk_a;
  t7211 = 0.3e1 * t1778 * t7209;
  t7213 = 0.2e1 * t7063 * t1812;
  t7215 = t575 * t1789 * t238;
  t7230 = t843 * t4383;
  t7231 = t560 * t7230;
  t7232 = t1526 * t1833;
  t7235 = t843 * t561;
  t7239 = -0.12e2 * t7106 * t4586 * t1452 * t561 * params->csk_a - 0.4e1 * t2357 * t1450 * t1779 * t695 - 0.6e1 * t7126 * t4586 * t2358 * params->csk_a + 0.3e1 * t234 * t7235 * t5399 - 0.3e1 * t2344 * t4475 - t2344 * t4490 + 0.3e1 * t2348 * t4475 + 0.3e1 * t2348 * t4490 - t2397 * t4490 + 0.3e1 * t2397 * t4504 + 0.3e1 * t2413 * t7215 - 0.3e1 * t7231 * t7232 + t7195 - t7196 - t7206 + t7211 - t7213;
  t7241 = t592 * t7119;
  t7249 = t592 * t2361 * t584;
  t7251 = 0.3e1 * t1856 * t7249;
  t7254 = 0.3e1 * t234 * t6990 * t6361;
  t7258 = 0.2e1 * t2412;
  t7260 = 0.2e1 * t2427;
  t7261 = 0.2e1 * t2428;
  t7264 = t575 * t1794;
  t7268 = 0.2e1 * t7075 * t1795;
  t7272 = t241 * t1807;
  t7276 = 0.3e1 * t234 * t7230 * t7264 - 0.2e1 * t2368 * t2369 * t7272 + 0.3e1 * t560 * t7235 * t4393 + 0.6e1 * t7081 * t7181 - 0.18e2 * t7086 * t7181 - 0.3e1 * t7231 * t7241 - 0.4e1 * t2384 + 0.4e1 * t2391 - 0.4e1 * t2395 + 0.4e1 * t2416 + 0.4e1 * t2451 + t7251 + t7254 - t7258 + t7260 - t7261 - t7268;
  t7277 = t575 * t7272;
  t7284 = t1425 * t7125;
  t7288 = t2354 * t1790;
  t7289 = t1432 * t2361;
  t7291 = 0.3e1 * t1798 * t7289;
  t7292 = t1425 * t4432;
  t7296 = t1516 * t2362;
  t7297 = t1450 * t7207;
  t7298 = t1778 * t7297;
  t7301 = t234 * t850 * t580 * t586;
  t7302 = t1437 * t1789;
  t7305 = t560 * t7125;
  t7306 = t569 * t843;
  t7310 = t6938 * t563;
  t7314 = t560 * t7310;
  t7319 = t4619 * t1794;
  t7322 = 0.2e1 * t234 * t7310 * t577 + 0.6e1 * t7284 * t4586 * t2358 + 0.11e2 * t7305 * t4523 * t7306 + t7126 * t4528 * t7127 - 0.2e1 * t2344 * t7302 - 0.3e1 * t2348 * t4609 - t7292 * t2359 + 0.2e1 * t704 * t5608 - 0.2e1 * t7314 * t577 - 0.2e1 * t7314 * t594 + 0.2e1 * t690 * t7277 + 0.6e1 * t7081 * t7319 + t7288 - t7291 + t7296 - t7298 - t7301;
  t7326 = my_piecewise5(t114, 0, t115, 0, t6973 + t7040 + t7093 + t7140 + t7192 + t7239 + t7276 + t7322);
  t7333 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t862 + t6896 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2457 - t6874 + t6903 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t7326 + 0.2e1 * t1764 * t284 + 0.2e1 * t278 * t1883 + 0.2e1 * t232 * t2455 + t554 * t860 + 0.4e1 * t680 * t710));
  tv4rho2sigma217 = t8 * t7333 + 0.2e1 * t2462;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t7340 = t7 * t345 * t888;
  t7347 = t7 * t354 * t888 / 0.3e2;
  t7349 = t7 * t145 * t2570;
  t7372 = t2483 * t403;
  t7373 = t163 * t7372;
  t7376 = t379 * t7372;
  t7379 = t2486 * t403;
  t7380 = t163 * t7379;
  t7383 = t379 * t7379;
  t7392 = t392 * t1050;
  t7393 = t1045 * t7392;
  t7394 = t389 * t298;
  t7398 = t1045 * t2489;
  t7399 = t1617 * t380;
  t7407 = t7399 * t3608;
  t7410 = 0.18e2 * t2490 * t1091 * t380 * t3608 - 0.18e2 * t5715 * t2495 * t1674 + 0.18e2 * t7393 * t7394 * t3232 - 0.18e2 * t7398 * t7399 * t4816 - 0.3e1 * t2490 * t4745 + 0.18e2 * t2490 * t7407 + 0.6e1 * t7373 * t2492 - 0.6e1 * t7376 * t2492 + 0.6e1 * t7380 * t2492 - 0.6e1 * t7383 * t2492 - 0.6e1 * t7376 * t2501 - 0.6e1 * t7383 * t2501 - 0.2e1 * t2485 - 0.2e1 * t2488 + t6462 - t6463 + t6465 - t826 - t877;
  t7413 = t171 * t1057;
  t7420 = t389 * t1057;
  t7427 = t1110 * t298;
  t7432 = t6491 * t382;
  t7439 = t5754 * t3554;
  t7440 = t163 * t7439;
  t7441 = t3703 * t263;
  t7442 = t7441 * t380;
  t7443 = t171 * t7442;
  t7445 = t379 * t7439;
  t7448 = t1045 * t7439;
  t7451 = t3569 * t7439;
  t7453 = t1110 * t7442;
  t7456 = t5816 * t1050;
  t7457 = t1045 * t7456;
  t7462 = t6633 * t3554;
  t7463 = t3569 * t7462;
  t7464 = t875 * params->csk_a;
  t7465 = t1110 * t7464;
  t7468 = t6491 * t2520;
  t7473 = -0.6e1 * t7398 * t7407 - 0.6e1 * t5715 * t7413 * t1674 + 0.3e1 * t1990 * t2495 * t4738 + 0.18e2 * t5751 * t7420 * t1674 - 0.3e1 * t2490 * t2500 * t6548 + 0.18e2 * t7393 * t7427 * t3232 - 0.12e2 * t7398 * t1066 * t1068 * t7432 - 0.4e1 * t2493 + 0.4e1 * t2498 - 0.4e1 * t2502 + t7440 * t7443 - 0.7e1 * t7445 * t7443 + 0.6e1 * t7448 * t7443 - t7451 * t7443 + 0.12e2 * t7448 * t7453 - 0.6e1 * t7457 * t2511 - 0.6e1 * t2508 * t6534 - 0.6e1 * t7463 * t7465 - 0.18e2 * t7445 * t7468 + 0.6e1 * t7448 * t7468;
  t7477 = t163 * t7456;
  t7480 = t379 * t7456;
  t7489 = t1045 * t7462;
  t7498 = t2509 * t380;
  t7509 = t171 * t3231 * t380;
  t7513 = t379 * t875 * t3543;
  t7520 = t4857 * t3554;
  t7521 = t3569 * t7520;
  t7522 = t298 * t1057;
  t7523 = t7522 * t380;
  t7531 = 0.6e1 * t7440 * t7468 - 0.6e1 * t7477 * t2521 + 0.6e1 * t7480 * t2521 - 0.6e1 * t2524 * t6486 + 0.6e1 * t2519 * t6486 + 0.6e1 * t2519 * t6534 - 0.12e2 * t7489 * t7465 - 0.2e1 * t7477 * t2536 + 0.6e1 * t7480 * t2536 - 0.2e1 * t2524 * t6537 - 0.6e1 * t7448 * t1110 * t7498 - 0.12e2 * t2504 * t6621 + 0.3e1 * t163 * t1975 * t3543 * t873 + 0.11e2 * t7440 * t7509 - 0.3e1 * t7513 * t6761 - 0.3e1 * t7513 * t6613 - 0.11e2 * t7445 * t7509 + 0.7e1 * t7521 * t389 * t7523 - 0.12e2 * t7451 * t7453 + 0.6e1 * t2519 * t6537;
  t7537 = t1045 * t4878 * t1050;
  t7541 = t741 * params->csk_a * t165;
  t7542 = t389 * t7541;
  t7549 = t1943 * t403;
  t7550 = t389 * t7549;
  t7553 = t1110 * t7541;
  t7566 = t2530 * t399;
  t7576 = t2509 * t399;
  t7577 = t171 * t7576;
  t7579 = t389 * t7442;
  t7586 = t4793 * t2520;
  t7589 = -0.2e1 * t7457 * t2536 - 0.2e1 * t2508 * t6537 + 0.6e1 * t7537 * t2532 + 0.6e1 * t2529 * t7542 + 0.6e1 * t7480 * t2511 + 0.6e1 * t7537 * t2544 + 0.6e1 * t2514 * t7550 + 0.6e1 * t2529 * t7553 + 0.6e1 * t7373 * t2262 + 0.6e1 * t7380 * t2262 - 0.6e1 * t7393 * t1110 * t2489 - 0.6e1 * t7451 * t3574 * t7442 + 0.3e1 * t2529 * t1110 * t7566 + 0.3e1 * t2529 * t389 * t7566 + 0.18e2 * t7521 * t1110 * t7523 - t2524 * t7577 - 0.7e1 * t7445 * t7579 + 0.3e1 * t2519 * t7577 + 0.18e2 * t7448 * t7579 + 0.3e1 * t2519 * t7586;
  t7592 = t389 * t7464;
  t7615 = t2509 * t3663;
  t7638 = -0.18e2 * t7489 * t7592 - 0.3e1 * t2524 * t7586 + 0.7e1 * t379 * t7462 * t7592 - 0.11e2 * t7445 * t389 * t7498 - 0.6e1 * t7463 * t3574 * t7464 - 0.4e1 * t7457 * t2541 - 0.4e1 * t2508 * t6579 + 0.6e1 * t379 * t633 * t167 * t384 * t2516 - 0.3e1 * t2508 * t7615 + 0.3e1 * t2514 * t5733 + 0.3e1 * t2519 * t7615 + 0.3e1 * t2504 * t6781 - 0.18e2 * t379 * t7392 * t389 * t2489 - t2508 * t7577 - 0.7e1 * t7451 * t7579 - 0.2e1 * t2508 * t1110 * t7576 + 0.11e2 * t7463 * t3574 * t7522 * t263 + t6511 - t6514;
  t7651 = t3544 * t7394;
  t7662 = t379 * t6633;
  t7684 = -t6529 - 0.2e1 * t2200 * t1066 * t1584 * t741 + 0.3e1 * t876 * t3544 * t1638 + 0.6e1 * t5793 * t3800 * t878 * t380 + 0.3e1 * t379 * t1661 * t7651 + 0.6e1 * t6832 * t3722 * t2551 - t748 * t6681 - 0.2e1 * t1936 * t1056 * t878 * t399 + 0.11e2 * t7662 * t3695 * t732 * t263 - 0.3e1 * t1634 * t5831 - t6845 * t2552 + t6634 * t3708 * t4936 * t298 + t5765 * t873 + 0.2e1 * t1940 * t2266 + t736 * t6681 - t5811 * t873 - 0.2e1 * t1956 * t2266 - t5811 * t883 - 0.2e1 * t1956 * t2291 - t748 * t6695;
  t7687 = t1066 * t4927 * t298;
  t7694 = t1925 * t165;
  t7700 = -0.6e1 * t1634 * t1051 * t7694 - 0.4e1 * t1936 * t6784 - 0.2e1 * t2200 * t7687 - 0.4e1 * t5860 * t2559 - 0.6e1 * t4879 * t2563 + t6595 - t6652 - t6664 + t6666 + t6676 - t6686 + t6691 - t6693 + t6738 + t6743 - t6744 + t6755 - t6756 + t6766 - t6767;
  t7721 = 0.4e1 * t2505 + 0.4e1 * t2517 - t6790 + t6792 - t6793 - t6800 - t6822 + t6836 - t6839 + t6849 - t6851 - t163 * t298 * t1613 * t405 + t5765 * t879 + 0.2e1 * t1940 * t2217 + t736 * t6827 + t4990 * t733 + 0.2e1 * t1642 * t1926 + t642 * t5939 - t163 * t1950 * t263 * t405 - 0.2e1 * t163 * t741 * t633 * t405;
  t7725 = my_piecewise5(t64, 0, t67, 0, t7410 + t7473 + t7531 + t7589 + t7638 + t7684 + t7700 + t7721);
  t7732 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t888 + t7340 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2570 - t7347 + t7349 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.27e2 * t52 * t615 * t266 - 0.5e1 / 0.36e2 * t52 * t257 * t648 + t52 * t291 * t1690 / 0.24e2 + t1570 * t301 + 0.2e1 * t618 * t752 + t260 * t2009 + t373 * t886 + 0.2e1 * t161 * t2568 + t59 * t7725));
  tv4rho2sigmalapl0 = t8 * t7732 + 0.2e1 * t2575;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t7739 = t7 * t440 * t914;
  t7743 = t7 * t444 * t914 / 0.3e2;
  t7745 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t914 + t7739 / 0.5e1 - t7743);
  tv4rho2sigmalapl5 = t8 * t7745 + 0.2e1 * t2584;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t7751 = t7 * t465 * t888;
  t7759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t888 + t7751 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2570 + t7340 / 0.1e2 - t7347 + t7349 / 0.1e2);
  tv4rho2sigmalapl6 = t8 * t7759 + t2575 + t2590;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t7765 = t7 * t489 * t914;
  t7772 = t7 * t192 * t2694;
  t7775 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t914 + t7765 / 0.1e2 + t7739 / 0.1e2 - t7743 + 0.3e1 / 0.2e2 * t7 * t188 * t2694 + t7772 / 0.1e2);
  tv4rho2sigmalapl11 = t8 * t7775 + t2584 + t2699;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t7783 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t888 + t7751 / 0.5e1 - t7347);
  tv4rho2sigmalapl12 = t8 * t7783 + 0.2e1 * t2590;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t7816 = t1425 * t573 * t1431;
  t7817 = t1496 * t315;
  t7821 = t1425 * t2614;
  t7823 = t7032 * t563;
  t7830 = t570 * t1057;
  t7836 = t570 * t315;
  t7840 = t1445 * t561;
  t7844 = t2606 * t584;
  t7845 = t560 * t7844;
  t7848 = t2609 * t584;
  t7849 = t560 * t7848;
  t7852 = t7840 * t4439;
  t7857 = -0.2e1 * t2608 - 0.2e1 * t2611 + t6934 + t6935 - t6936 - t903 - t852 - 0.3e1 * t2615 * t2616 * t7055 + 0.18e2 * t7816 * t7817 * t3304 - 0.12e2 * t7821 * t1450 * t1452 * t7823 + 0.3e1 * t2125 * t2624 * t5260 + 0.18e2 * t6148 * t7830 * t1867 - 0.3e1 * t2615 * t5266 + 0.18e2 * t7816 * t7836 * t3304 - 0.18e2 * t7821 * t7840 * t5330 - 0.6e1 * t7845 * t2617 - 0.6e1 * t7849 * t2617 + 0.18e2 * t2615 * t7852 - 0.6e1 * t7821 * t7852;
  t7858 = t242 * t1057;
  t7866 = t242 * t3299 * t580;
  t7869 = t7125 * t4370;
  t7871 = t2636 * t281;
  t7872 = t570 * t7871;
  t7875 = t6222 * t4370;
  t7876 = t560 * t7875;
  t7877 = t2643 * t561;
  t7883 = t5378 * t4370;
  t7884 = t4365 * t7883;
  t7885 = t315 * t1057;
  t7886 = t7885 * t561;
  t7890 = t2643 * t580;
  t7891 = t242 * t7890;
  t7893 = t3703 * t281;
  t7894 = t7893 * t561;
  t7895 = t570 * t7894;
  t7902 = t570 * t7890;
  t7907 = t4365 * t7875;
  t7909 = t7893 * t1496 * t561;
  t7915 = t4365 * t7869;
  t7927 = -0.6e1 * t6174 * t7858 * t1867 - 0.4e1 * t2618 - 0.4e1 * t2622 + 0.4e1 * t2627 - 0.3e1 * t2656 * t7866 + 0.7e1 * t560 * t7869 * t7872 - 0.11e2 * t7876 * t570 * t7877 + 0.3e1 * t2635 * t6200 + 0.18e2 * t7884 * t1496 * t7886 - t2656 * t7891 - 0.7e1 * t7876 * t7895 + 0.3e1 * t2648 * t7215 + 0.3e1 * t2635 * t6195 + 0.3e1 * t2642 * t7902 - 0.3e1 * t2666 * t7902 - 0.12e2 * t7907 * t7909 - 0.2e1 * t2666 * t1496 * t7890 + 0.11e2 * t7915 * t4375 * t7885 * t281 - 0.6e1 * t7907 * t4375 * t7894 + 0.3e1 * t2629 * t570 * t2107 * t584;
  t7931 = t1425 * t7875;
  t7937 = t7893 * t1833;
  t7941 = t7032 * t2651;
  t7946 = t234 * t7875;
  t7954 = t1496 * t7871;
  t7961 = t6229 * t1431;
  t7962 = t234 * t7961;
  t7965 = t560 * t7961;
  t7974 = 0.6e1 * t2642 * t6958 + 0.6e1 * t2642 * t6997 + 0.3e1 * t2642 * t7891 + 0.6e1 * t7965 * t2645 - 0.6e1 * t7962 * t2652 + 0.6e1 * t7965 * t2652 - 0.6e1 * t2656 * t6997 - 0.2e1 * t2666 * t6974 - t2666 * t7891 - 0.7e1 * t7876 * t7937 - 0.18e2 * t7876 * t7941 - 0.7e1 * t7907 * t7895 + 0.18e2 * t7931 * t7895 - t7907 * t7937 + 0.12e2 * t7931 * t7909 - 0.6e1 * t7915 * t7954 + 0.6e1 * t7931 * t7937 + 0.6e1 * t7931 * t7941 + t7946 * t7937 + 0.6e1 * t7946 * t7941;
  t7976 = t1437 * t1794 * t563;
  t7990 = t242 * t3299 * t561;
  t7994 = t560 * t901 * t4383;
  t8004 = t1425 * t7869;
  t8012 = t1425 * t5374 * t1431;
  t8016 = t795 * params->csk_a * t236;
  t8017 = t570 * t8016;
  t8022 = t1425 * t7961;
  t8027 = t234 * t7848;
  t8035 = -0.12e2 * t2648 * t7976 - 0.6e1 * t7931 * t1496 * t7877 - 0.18e2 * t5311 * t570 * t2129 + 0.3e1 * t234 * t2128 * t4383 * t899 + 0.11e2 * t7946 * t7990 - 0.3e1 * t7994 * t7241 - 0.3e1 * t7994 * t7232 - 0.11e2 * t7876 * t7990 + 0.7e1 * t7884 * t570 * t7886 - 0.12e2 * t8004 * t7954 - 0.2e1 * t7962 * t2662 - 0.2e1 * t2656 * t6974 + 0.6e1 * t8012 * t2659 + 0.6e1 * t2635 * t8017 + 0.6e1 * t7965 * t2662 - 0.2e1 * t8022 * t2662 + 0.6e1 * t2642 * t6974 + 0.6e1 * t8027 * t2415 - 0.6e1 * t7816 * t1496 * t2614 + 0.3e1 * t2642 * t7866;
  t8058 = t2103 * t584;
  t8059 = t570 * t8058;
  t8062 = t1496 * t8016;
  t8065 = t234 * t7844;
  t8079 = -0.18e2 * t8004 * t7872 - 0.4e1 * t8022 * t2670 - 0.4e1 * t2666 * t7028 - 0.6e1 * t7915 * t4375 * t7871 - 0.6e1 * t8022 * t2645 - 0.6e1 * t2666 * t6958 + 0.6e1 * t560 * t695 * t238 * t565 * t2631 + 0.6e1 * t8012 * t2638 + 0.6e1 * t2629 * t8059 + 0.6e1 * t2635 * t8062 + 0.6e1 * t8065 * t2415 + t6969 - t6972 - t6994 - 0.3e1 * t1822 * t6338 - 0.2e1 * t2114 * t1437 * t904 * t580 - t802 * t7151 - t7292 * t2686 + t7126 * t4528 * t5472 * t315;
  t8096 = t4384 * t7836;
  t8114 = t1450 * t5467 * t315;
  t8122 = t1432 * t2096 * t236;
  t8127 = t6268 * t899 + 0.2e1 * t2091 * t2403 + t790 * t7133 - 0.2e1 * t2357 * t1450 * t1779 * t795 + 0.3e1 * t902 * t4384 * t1833 + 0.6e1 * t6256 * t4619 * t904 * t561 + 0.3e1 * t560 * t1849 * t8096 + 0.11e2 * t5409 * t4523 * t786 * t561 + 0.6e1 * t7284 * t4586 * t2685 - t6234 * t899 - 0.2e1 * t2135 * t2403 - t802 * t7133 - t6234 * t909 - 0.2e1 * t2135 * t2441 - 0.2e1 * t2357 * t8114 - 0.4e1 * t2114 * t7175 - 0.6e1 * t5439 * t2674 - 0.6e1 * t1822 * t8122 - 0.4e1 * t6230 * t2678 - t7065;
  t8135 = 0.18e2 * t2615 * t1471 * t561 * t4439 + 0.4e1 * t2632 + 0.4e1 * t2649 - t7077 + t7080 - t7092 + t7095 - t7096 + t7100 + t7112 + t7195 - t7196 - t7206 + t7211 - t7213 + t7251 + t7254 - t7258 + t7260 - t7261;
  t8165 = -0.18e2 * t6174 * t2624 * t1867 + 0.6e1 * t8065 * t2621 - 0.6e1 * t7845 * t2621 + 0.6e1 * t8027 * t2621 - 0.6e1 * t7849 * t2621 - t7268 + t7288 - t7291 + t7296 - t7298 - t7301 + t704 * t6410 - t234 * t2120 * t281 * t586 - 0.2e1 * t234 * t795 * t695 * t586 - t234 * t315 * t1807 * t586 + t6268 * t905 + 0.2e1 * t2091 * t2374 + t790 * t7277 + t5515 * t787 + 0.2e1 * t1829 * t2097;
  t8169 = my_piecewise5(t114, 0, t115, 0, t7857 + t7927 + t7974 + t8035 + t8079 + t8127 + t8135 + t8165);
  t8176 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t914 + t7765 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2694 - t7743 + t7772 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (0.5e1 / 0.27e2 * t52 * t677 * t284 - 0.5e1 / 0.36e2 * t52 * t275 * t710 + t52 * t308 * t1883 / 0.24e2 + t1764 * t318 + 0.2e1 * t680 * t806 + t278 * t2179 + t554 * t912 + 0.2e1 * t232 * t2692 + t113 * t8169));
  tv4rho2sigmalapl17 = t8 * t8176 + 0.2e1 * t2699;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t8183 = t7 * t345 * t937;
  t8190 = t7 * t354 * t937 / 0.3e2;
  t8192 = t7 * t145 * t2787;
  t8207 = t741 * t741;
  t8208 = t163 * t8207;
  t8216 = t379 * t1989;
  t8221 = t925 * t1050;
  t8222 = t379 * t8221;
  t8234 = t6497 * t7694;
  t8237 = -0.8e1 * t2508 * t1110 * t1057 * t741 * t165 + 0.2e1 * t379 * t8207 * t390 + 0.12e2 * t2508 * t7553 - 0.12e2 * t2508 * t8234 - 0.3e1 * t2737 * t6556 + 0.3e1 * t2742 * t6553 - 0.2e1 * t8208 * t405 + 0.2e1 * t8208 * t407 + 0.18e2 * t8222 * t6500 + 0.12e2 * t8216 * t7550 - 0.4e1 * t2726 + t6462 - t6463 + t6465 - t826 - t929;
  t8238 = t171 * t7541;
  t8247 = t2735 * t1050;
  t8248 = t1045 * t8247;
  t8255 = t163 * t8221;
  t8258 = t1045 * t8221;
  t8269 = t1057 * t74;
  t8270 = t2714 * t165;
  t8271 = t8269 * t8270;
  t8280 = t379 * t8247;
  t8285 = 0.18e2 * t7393 * t1110 * t2735 * params->csk_a - 0.12e2 * t8248 * t1110 * t7432 + 0.12e2 * t1990 * t171 * t7549 - 0.18e2 * t8255 * t1685 + 0.12e2 * t2508 * t7542 - 0.4e1 * t2508 * t8271 + 0.12e2 * t2519 * t8234 + 0.12e2 * t2519 * t8238 + 0.12e2 * t2519 * t8271 - 0.12e2 * t2524 * t8238 - 0.4e1 * t2524 * t8271 - 0.3e1 * t2737 * t6549 + 0.18e2 * t8222 * t6493 - 0.6e1 * t8255 * t6493 - 0.6e1 * t8258 * t6493 + 0.18e2 * t8258 * t6527 + 0.18e2 * t8280 * t6545;
  t8290 = t922 * t3552;
  t8291 = t3569 * t8290;
  t8295 = t1066 * t1929 * t741;
  t8298 = t3573 * t922;
  t8300 = t3708 * t8298 * params->csk_a;
  t8305 = t388 * t922;
  t8310 = t379 * t8290;
  t8322 = t3695 * t8305 * t1057;
  t8327 = -0.12e2 * t5014 * t1051 * t732 * t741 + 0.7e1 * t7662 * t3695 * t8305 * params->csk_a - 0.18e2 * t8248 * t389 * t7432 - 0.4e1 * t2200 * t8295 - t2729 * t3614 - 0.3e1 * t2729 * t3648 + 0.3e1 * t2732 * t3614 - t2747 * t3614 + 0.3e1 * t2747 * t3621 - 0.11e2 * t8310 * t6617 - 0.6e1 * t6634 * t8300 + 0.7e1 * t6634 * t8322 - 0.6e1 * t8291 * t6705 + t6511 - t6514 - t6529;
  t8329 = t394 * t395 * t1950;
  t8345 = t3722 * t2720 * t1057;
  t8357 = t3708 * t8298 * t1057;
  t8361 = t3722 * t2720 * params->csk_a;
  t8367 = t1066 * t2720 * t403;
  t8376 = 0.2e1 * t736 * t8329 + 0.3e1 * t2732 * t3664 + 0.3e1 * t2757 * t6781 + 0.3e1 * t2780 * t3660 + 0.3e1 * t2747 * t3669 - 0.2e1 * t748 * t8329 - 0.3e1 * t2747 * t3664 + 0.18e2 * t6634 * t8345 - 0.12e2 * t8291 * t6647 - 0.2e1 * t748 * t411 * t412 * t1950 - 0.2e1 * t2747 * t3675 + 0.11e2 * t6634 * t8357 - 0.12e2 * t6832 * t8361 - 0.11e2 * t8310 * t6599 - 0.6e1 * t6710 * t8367 - 0.12e2 * t926 * t1056 * t6740 - 0.8e1 * t1936 * t1056 * t8270;
  t8383 = t1045 * t8290;
  t8386 = t922 * t380;
  t8395 = t163 * t8290;
  t8411 = t922 * t3543;
  t8412 = t379 * t8411;
  t8415 = 0.3e1 * t163 * t8386 * t4854 + 0.3e1 * t2732 * t3648 - 0.18e2 * t8310 * t6605 + 0.6e1 * t8395 * t6605 - 0.3e1 * t8412 * t6613 - 0.6e1 * t8383 * t6627 - 0.6e1 * t6634 * t8361 + 0.12e2 * t8383 * t6647 - 0.7e1 * t8291 * t6655 - 0.7e1 * t8310 * t6655 + 0.18e2 * t8383 * t6655 - 0.18e2 * t8383 * t6659 - t8291 * t6746 - 0.7e1 * t8310 * t6746 + 0.6e1 * t8383 * t6746 + t8395 * t6746;
  t8424 = 0.11e2 * t8395 * t6599 + 0.6e1 * t8383 * t6605 - 0.18e2 * t931 * t6630 - 0.3e1 * t8412 * t6761 + t6595 - t6652 - t6664 + t6666 + t6676 - t6686 + t6691 - t6693 + t6738 + t6743 - t6744 + t6755 - t6756;
  t8426 = t2723 * t384;
  t8427 = t379 * t8426;
  t8428 = t171 * t741;
  t8444 = -0.12e2 * t8427 * t4955 * t4798 * t741 + 0.12e2 * t1990 * t2495 * t7549 - 0.12e2 * t8427 * t2249 * t8428 - 0.4e1 * t2738 + 0.4e1 * t2743 - 0.4e1 * t2745 + 0.4e1 * t2758 + 0.4e1 * t2781 + t6766 - t6767 - t6790 + t6792 - t6793 - t6800 - t6822 + t6836 - t6839;
  t8447 = t3695 * t8305;
  t8452 = t170 * t1950;
  t8459 = t3708 * t8298;
  t8464 = t163 * t8411;
  t8470 = t3722 * t2720;
  t8475 = t8207 * t382;
  t8479 = t379 * t8475;
  t8484 = t6849 - t6851 - 0.2e1 * t2729 * t6840 + 0.11e2 * t7662 * t8447 - 0.3e1 * t2732 * t3785 + 0.2e1 * t736 * t394 * t8452 + 0.2e1 * t748 * t5939 - t6845 * t2721 + t6634 * t8459 - 0.2e1 * t2724 * t2212 * t8452 + 0.3e1 * t8464 * t6802 + 0.3e1 * t379 * t8386 * t3545 + 0.6e1 * t6832 * t8470 + 0.6e1 * t8395 * t6805 + 0.2e1 * t163 * t8475 * t396 - 0.2e1 * t8479 * t396 - 0.2e1 * t8479 * t413;
  t8488 = my_piecewise5(t64, 0, t67, 0, t8237 + t8285 + t8327 + t8376 + t8415 + t8424 + t8444 + t8484);
  t8495 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t937 + t8183 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2787 - t8190 + t8192 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1e2 / 0.27e2 * t52 * t615 * t301 - 0.5e1 / 0.18e2 * t52 * t257 * t752 + t52 * t291 * t2009 / 0.12e2 + t373 * t935 + 0.2e1 * t161 * t2785 + t59 * t8488));
  tv4rho2lapl20 = t8 * t8495 + 0.2e1 * t2792;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t8502 = t7 * t440 * t960;
  t8506 = t7 * t444 * t960 / 0.3e2;
  t8508 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t960 + t8502 / 0.5e1 - t8506);
  tv4rho2lapl22 = t8 * t8508 + 0.2e1 * t2801;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t8514 = t7 * t465 * t937;
  t8522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t937 + t8514 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2787 + t8183 / 0.1e2 - t8190 + t8192 / 0.1e2);
  tv4rho2lapl23 = t8 * t8522 + t2792 + t2807;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t8528 = t7 * t489 * t960;
  t8535 = t7 * t192 * t2892;
  t8538 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t960 + t8528 / 0.1e2 + t8502 / 0.1e2 - t8506 + 0.3e1 / 0.2e2 * t7 * t188 * t2892 + t8535 / 0.1e2);
  tv4rho2lapl25 = t8 * t8538 + t2801 + t2897;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t8546 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t937 + t8514 / 0.5e1 - t8190);
  tv4rho2lapl26 = t8 * t8546 + 0.2e1 * t2807;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t8570 = t795 * t795;
  t8574 = t234 * t8570;
  t8579 = t948 * t1431;
  t8580 = t1425 * t8579;
  t8583 = t234 * t8579;
  t8586 = t560 * t8579;
  t8589 = t242 * t795;
  t8590 = t2382 * t8589;
  t8597 = t2840 * t1431;
  t8598 = t1425 * t8597;
  t8604 = 0.18e2 * t7816 * t1496 * t2840 * params->csk_a - 0.12e2 * t8598 * t1496 * t7823 + 0.2e1 * t560 * t8570 * t571 + 0.12e2 * t2642 * t8590 - 0.2e1 * t8574 * t586 + 0.2e1 * t8574 * t588 + 0.12e2 * t6134 * t8059 + 0.18e2 * t8580 * t6152 - 0.6e1 * t8583 * t7034 + 0.18e2 * t8586 * t7034 - 0.4e1 * t2828 + t6934 + t6935 - t6936 - t852 - t952;
  t8607 = t2824 * t565;
  t8608 = t234 * t8607;
  t8609 = t2103 * t238;
  t8622 = t1057 * t795 * t236;
  t8623 = t570 * t8622;
  t8626 = t242 * t8622;
  t8631 = t560 * t8597;
  t8650 = -0.8e1 * t2666 * t1496 * t8622 + 0.12e2 * t8608 * t242 * t8609 - 0.18e2 * t8598 * t570 * t7823 - 0.18e2 * t8583 * t1876 + 0.12e2 * t2642 * t8623 + 0.12e2 * t2642 * t8626 - 0.12e2 * t2656 * t8590 - 0.4e1 * t2656 * t8626 + 0.12e2 * t2666 * t8017 + 0.12e2 * t2666 * t8062 - 0.12e2 * t2666 * t8623 - 0.4e1 * t2666 * t8626 - 0.3e1 * t2842 * t7056 - 0.3e1 * t2842 * t7059 + 0.3e1 * t2847 * t7052 + 0.18e2 * t8631 * t6980 + 0.18e2 * t8586 * t7003;
  t8655 = t1450 * t2100 * t795;
  t8659 = t575 * t576 * t2120;
  t8670 = t4374 * t945;
  t8672 = t4528 * t8670 * t1057;
  t8675 = t945 * t4368;
  t8676 = t4365 * t8675;
  t8682 = t4528 * t8670 * params->csk_a;
  t8688 = t4586 * t2821 * t1057;
  t8693 = -0.2e1 * t802 * t592 * t593 * t2120 - 0.4e1 * t2357 * t8655 + 0.3e1 * t2834 * t4486 - 0.3e1 * t2852 * t4486 - 0.2e1 * t2852 * t4498 + 0.3e1 * t2870 * t4448 - 0.6e1 * t8580 * t7034 - 0.12e2 * t8676 * t7116 + 0.11e2 * t7126 * t8672 - 0.6e1 * t7126 * t8682 + 0.18e2 * t7126 * t8688 - 0.6e1 * t8676 * t7161 + 0.2e1 * t790 * t8659 + t6969 - t6972 - t6994;
  t8696 = t569 * t945;
  t8701 = t560 * t8675;
  t8717 = t4586 * t2821 * params->csk_a;
  t8729 = t1450 * t2821 * t584;
  t8736 = -0.8e1 * t2114 * t1437 * t2826 * t236 + 0.7e1 * t7305 * t4523 * t8696 * params->csk_a - 0.12e2 * t2138 * t8122 + 0.3e1 * t2834 * t4490 - 0.3e1 * t2837 * t4475 - t2837 * t4490 + 0.3e1 * t2852 * t4482 - t2852 * t4490 + 0.3e1 * t2852 * t4504 + 0.3e1 * t2881 * t7215 + 0.7e1 * t8676 * t7068 - 0.11e2 * t8701 * t7068 - 0.7e1 * t8676 * t7072 - 0.11e2 * t8701 * t7083 - 0.6e1 * t7166 * t8729 - 0.12e2 * t7284 * t8717 - 0.2e1 * t802 * t8659;
  t8745 = t945 * t561;
  t8749 = t234 * t8675;
  t8752 = t945 * t4383;
  t8753 = t560 * t8752;
  t8759 = t1425 * t8675;
  t8775 = 0.3e1 * t234 * t8745 * t5399 + 0.3e1 * t2834 * t4475 - 0.12e2 * t2881 * t7976 + 0.18e2 * t8759 * t7072 + 0.11e2 * t8749 * t7083 - t8676 * t7102 - 0.7e1 * t8701 * t7102 + t8749 * t7102 + 0.6e1 * t8759 * t7102 + 0.12e2 * t8759 * t7116 - 0.18e2 * t8759 * t7120 - 0.6e1 * t7126 * t8717 - 0.18e2 * t8701 * t7181 + 0.6e1 * t8749 * t7181 - 0.18e2 * t954 * t7187 - 0.3e1 * t8753 * t7241;
  t8784 = -0.7e1 * t8701 * t7072 + 0.6e1 * t8759 * t7181 - 0.6e1 * t8759 * t7184 - 0.3e1 * t8753 * t7232 - t7065 - t7077 + t7080 - t7092 + t7095 - t7096 + t7100 + t7112 + t7195 - t7196 - t7206 + t7211 - t7213;
  t8786 = t560 * t8607;
  t8801 = 0.12e2 * t2125 * t2624 * t8058 - 0.12e2 * t8786 * t2393 * t8589 - 0.12e2 * t8786 * t5395 * t8609 - 0.4e1 * t2843 + 0.4e1 * t2848 - 0.4e1 * t2850 + 0.4e1 * t2871 + 0.4e1 * t2882 + t7251 + t7254 - t7258 + t7260 - t7261 - t7268 + t7288 - t7291 + t7296;
  t8809 = t4528 * t8670;
  t8811 = t241 * t2120;
  t8818 = t234 * t8752;
  t8829 = t4586 * t2821;
  t8832 = t8570 * t563;
  t8833 = t560 * t8832;
  t8841 = -t7298 - t7301 - 0.3e1 * t2834 * t4609 - 0.2e1 * t2837 * t7302 + 0.2e1 * t802 * t6410 - t7292 * t2822 + t7126 * t8809 - 0.2e1 * t2825 * t2369 * t8811 + 0.2e1 * t790 * t575 * t8811 + 0.3e1 * t8818 * t7264 + 0.6e1 * t8749 * t7319 + 0.3e1 * t560 * t8745 * t4393 + 0.11e2 * t8701 * t4523 * t7001 + 0.6e1 * t7284 * t8829 - 0.2e1 * t8833 * t577 + 0.2e1 * t234 * t8832 * t577 - 0.2e1 * t8833 * t594;
  t8845 = my_piecewise5(t114, 0, t115, 0, t8604 + t8650 + t8693 + t8736 + t8775 + t8784 + t8801 + t8841);
  t8852 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t960 + t8528 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2892 - t8506 + t8535 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (0.1e2 / 0.27e2 * t52 * t677 * t318 - 0.5e1 / 0.18e2 * t52 * t275 * t806 + t52 * t308 * t2179 / 0.12e2 + t554 * t958 + 0.2e1 * t232 * t2890 + t113 * t8845));
  tv4rho2lapl28 = t8 * t8852 + 0.2e1 * t2897;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t8859 = t7 * t145 * t2969 / 0.1e2;
  t8865 = 0.6e1 * t2920;
  t8866 = t6592 * t1050;
  t8867 = t1045 * t8866;
  t8868 = t8867 * t2511;
  t8871 = t163 * t8866 * t2521;
  t8873 = t379 * t8866;
  t8874 = t8873 * t2521;
  t8876 = t2912 - t8865 + t2923 + t2927 + t2931 + t2206 - t2209 - t2216 + t2228 - t826 - t828 - 0.9e1 * t8868 - 0.9e1 * t8871 + 0.9e1 * t8874;
  t8879 = t2238 * t3608;
  t8882 = t2207 * t403;
  t8884 = t2514 * t389 * t8882;
  t8886 = t824 * params->csk_a;
  t8887 = t8886 * t165;
  t8889 = t2529 * t1110 * t8887;
  t8891 = t2901 * t382;
  t8892 = t8891 * t1050;
  t8893 = t1045 * t8892;
  t8894 = t1110 * t2245;
  t8897 = params->csk_a * t403;
  t8899 = t171 * t8897 * t633;
  t8902 = params->csk_a * t167;
  t8903 = t8902 * t2265;
  t8906 = t639 * t403;
  t8907 = t8269 * t8906;
  t8910 = t8867 * t2541;
  t8912 = t8902 * t633;
  t8913 = t389 * t8912;
  t8916 = t2918 * t403;
  t8917 = t163 * t8916;
  t8918 = t8917 * t2262;
  t8920 = t379 * t8892;
  t8921 = t1057 * t403;
  t8922 = t8921 * t165;
  t8923 = t389 * t8922;
  t8928 = t1110 * t8922;
  t8931 = t163 * t8892;
  t8934 = 0.18e2 * t379 * t2924 * t1050 * t8879 - 0.9e1 * t2237 * t8903 - 0.9e1 * t2237 * t8913 + 0.9e1 * t2244 * t8899 - 0.18e2 * t8931 * t2246 + 0.18e2 * t8893 * t8894 - 0.6e1 * t8893 * t8907 - 0.18e2 * t8893 * t8923 - 0.12e2 * t8893 * t8928 + 0.18e2 * t8920 * t8923 + 0.9e1 * t8884 + 0.9e1 * t8889 - 0.6e1 * t8910 + 0.9e1 * t8918;
  t8936 = t8873 * t2511;
  t8938 = t389 * t2245;
  t8941 = t1057 * t824;
  t8942 = t8941 * t165;
  t8943 = t171 * t8942;
  t8944 = t4792 * t8943;
  t8946 = t4751 * t8943;
  t8948 = t8867 * t2536;
  t8955 = t2529 * t389 * t8887;
  t8957 = t2901 * t3552;
  t8958 = t379 * t8957;
  t8959 = t3791 * t2282;
  t8962 = t1045 * t8957;
  t8963 = t3704 * t2510;
  t8967 = t3722 * t3809 * t165;
  t8972 = t3695 * t644;
  t8975 = t3569 * t8957;
  t8976 = t3722 * t2303;
  t8979 = 0.18e2 * t8893 * t8938 + 0.18e2 * t8920 * t8907 - 0.6e1 * t8931 * t8907 - 0.18e2 * t8958 * t8959 - 0.7e1 * t8958 * t8963 + 0.18e2 * t8962 * t8963 + 0.12e2 * t8962 * t8967 - 0.18e2 * t8962 * t8972 - 0.6e1 * t8975 * t8976 + 0.9e1 * t8936 - 0.3e1 * t8944 + 0.9e1 * t8946 - 0.3e1 * t8948 + 0.9e1 * t8955;
  t8980 = t165 * t3552;
  t8981 = t3569 * t8980;
  t8982 = t3573 * t2901;
  t8988 = t1051 * t1073 * t633;
  t8991 = t1068 * t2901;
  t8993 = t3722 * t8991 * t1057;
  t8999 = t1066 * t1069 * t633;
  t9007 = t3708 * t3713 * t165;
  t9012 = t2200 * t1066 * t1584 * t824;
  t9015 = t1056 * t395 * t633;
  t9018 = t379 * t8980;
  t9019 = t388 * t2901;
  t9021 = t3695 * t9019 * params->csk_a;
  t9024 = t3695 * t2253;
  t9029 = t163 * t8957;
  t9031 = t3800 * t3801 * t165;
  t9037 = 0.11e2 * t8981 * t3708 * t8982 * t1057 - 0.6e1 * t8981 * t3708 * t8982 * params->csk_a + 0.9e1 * t2221 * t8988 - 0.9e1 * t2229 * t9015 - 0.9e1 * t2269 * t8988 - 0.6e1 * t2269 * t8999 - 0.11e2 * t8958 * t9024 - 0.7e1 * t8958 * t9031 + 0.6e1 * t8962 * t9031 - 0.12e2 * t8975 * t8967 - 0.6e1 * t8975 * t9007 + 0.18e2 * t8981 * t8993 + 0.7e1 * t9018 * t9021 + t9029 * t9031 - 0.3e1 * t9012;
  t9043 = t2257 * t2266;
  t9045 = t1617 * t2265;
  t9058 = t1045 * t622;
  t9063 = t1609 * t2953;
  t9065 = t2257 * t2291;
  t9068 = t394 * t1104 * t633;
  t9075 = -0.18e2 * t623 * t1051 * t9019 * t403 - 0.6e1 * t9058 * t1066 * t8991 * t403 + 0.9e1 * t2221 * t9015 + 0.9e1 * t2221 * t9045 - 0.3e1 * t2229 * t9045 + 0.9e1 * t2260 * t9068 + 0.9e1 * t2269 * t4890 - 0.3e1 * t2269 * t9045 + 0.9e1 * t2298 * t5022 + 0.6e1 * t9029 * t8959 - t8975 * t9031 - 0.3e1 * t9043 + 0.3e1 * t9063 - 0.3e1 * t9065;
  t9082 = t3765 * t2282;
  t9085 = t2901 * t3543;
  t9086 = t379 * t9085;
  t9092 = t1056 * t3779 * t165;
  t9097 = t6662 * t2559;
  t9101 = t3722 * t2294;
  t9106 = t1634 * t1051 * t2204 * t165;
  t9110 = t2901 * t165;
  t9114 = 0.3e1 * t163 * t9110 * t4854 + 0.9e1 * t2269 * t4929 - 0.12e2 * t2925 * t9092 - 0.3e1 * t9086 * t630 - 0.3e1 * t9086 * t645 - 0.11e2 * t8958 * t9082 + 0.6e1 * t8962 * t8959 - 0.12e2 * t8962 * t8976 - 0.6e1 * t8962 * t9101 - 0.7e1 * t8975 * t8963 + 0.7e1 * t8975 * t9024 + 0.11e2 * t9029 * t9082 - 0.6e1 * t9097 - 0.9e1 * t9106;
  t9116 = t8917 * t2492;
  t9118 = t379 * t8916;
  t9119 = t9118 * t2492;
  t9121 = t9118 * t2501;
  t9123 = 0.9e1 * t9116 - 0.9e1 * t9119 - 0.9e1 * t9121 - t2240 + t2247 - t2251 - t2951 + t2955 - t2957 - t2959 + t2962 - t2964 - t2258 + t2263;
  t9124 = t3800 * t639;
  t9133 = t1642 * t2205;
  t9137 = t163 * t824 * t633 * t405;
  t9139 = t2227 * t2217;
  t9141 = t1056 * t2213;
  t9149 = t1045 * t8980;
  t9157 = 0.3e1 * t163 * t9085 * t640 + 0.3e1 * t379 * t9110 * t3545 + 0.11e2 * t9018 * t3695 * t9019 + t8981 * t3708 * t8982 + 0.6e1 * t9149 * t3722 * t8991 - 0.9e1 * t2221 * t5054 - 0.6e1 * t2229 * t9141 - 0.3e1 * t2269 * t5077 + 0.6e1 * t9029 * t9124 + t2279 - t2280 + t2301 + 0.3e1 * t9133 - 0.3e1 * t9137 + 0.3e1 * t9139;
  t9161 = my_piecewise5(t64, 0, t67, 0, t8876 + t8934 + t8979 + t9037 + t9075 + t9114 + t9123 + t9157);
  t9168 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t2969 + t8859 + 0.3e1 / 0.2e2 * t7 * t32 * (t161 * t2967 + 0.3e1 * t260 * t2311 + t59 * t9161 + 0.3e1 * t618 * t834));
  tv4rhosigma30 = t8 * t9168 + t2973;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t9175 = t7 * t192 * t3044 / 0.1e2;
  t9177 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3044 + t9175);
  tv4rhosigma39 = t8 * t9177 + t3048;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t9183 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t2969 + t8859);
  tv4rhosigma310 = t8 * t9183 + t2973;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t9193 = 0.6e1 * t2995;
  t9194 = params->csk_a * t850;
  t9195 = t9194 * t236;
  t9196 = t242 * t9195;
  t9197 = t5300 * t9196;
  t9199 = t2976 * t563;
  t9200 = t9199 * t1431;
  t9201 = t234 * t9200;
  t9204 = t7062 * t1431;
  t9205 = t1425 * t9204;
  t9206 = t9205 * t2645;
  t9208 = -0.18e2 * t9201 * t2390 + t2355 + t2363 - t2366 - t2373 + t2987 + t3000 + t3004 + t3006 - t852 - t854 - t9193 - 0.9e1 * t9197 - 0.9e1 * t9206;
  t9211 = t2382 * t4439;
  t9214 = t560 * t9204;
  t9215 = t9214 * t2652;
  t9217 = params->csk_a * t584;
  t9219 = t242 * t9217 * t695;
  t9222 = t560 * t9200;
  t9224 = t1057 * t584 * t236;
  t9225 = t570 * t9224;
  t9228 = t1425 * t9200;
  t9231 = t1496 * t9224;
  t9234 = t9214 * t2645;
  t9239 = params->csk_a * t238;
  t9240 = t242 * t695;
  t9241 = t9239 * t9240;
  t9245 = t701 * t584;
  t9246 = t1057 * t122 * t9245;
  t9249 = t9205 * t2670;
  t9251 = t9239 * t695;
  t9252 = t570 * t9251;
  t9255 = t2364 * t584;
  t9257 = t2629 * t570 * t9255;
  t9260 = t2635 * t1496 * t9195;
  t9262 = 0.18e2 * t560 * t2997 * t1431 * t9211 + 0.18e2 * t9228 * t570 * t2389 - 0.9e1 * t2381 * t9241 - 0.9e1 * t2381 * t9252 + 0.9e1 * t2388 * t9219 + 0.18e2 * t9222 * t9225 - 0.18e2 * t9228 * t9225 - 0.12e2 * t9228 * t9231 - 0.6e1 * t9228 * t9246 + 0.9e1 * t9215 + 0.9e1 * t9234 - 0.6e1 * t9249 + 0.9e1 * t9257 + 0.9e1 * t9260;
  t9264 = t1496 * t2389;
  t9267 = t2993 * t584;
  t9268 = t234 * t9267;
  t9269 = t9268 * t2415;
  t9271 = t1057 * t850;
  t9272 = t9271 * t236;
  t9273 = t242 * t9272;
  t9274 = t5300 * t9273;
  t9276 = t5314 * t9273;
  t9278 = t9205 * t2662;
  t9285 = t2635 * t570 * t9195;
  t9287 = t2976 * t4368;
  t9288 = t560 * t9287;
  t9289 = t4593 * t2430;
  t9292 = t4550 * t2430;
  t9295 = t1425 * t9287;
  t9298 = t4365 * t9287;
  t9300 = t234 * t9287;
  t9302 = t4619 * t2421;
  t9305 = -0.6e1 * t9201 * t9246 + 0.18e2 * t9222 * t9246 + 0.18e2 * t9228 * t9264 - 0.11e2 * t9288 * t9289 - 0.7e1 * t9288 * t9292 + 0.6e1 * t9295 * t9292 - t9298 * t9292 + t9300 * t9292 + 0.6e1 * t9300 * t9302 + 0.9e1 * t9269 - 0.3e1 * t9274 + 0.9e1 * t9276 - 0.3e1 * t9278 + 0.9e1 * t9285;
  t9308 = t570 * t236;
  t9309 = t4550 * t9308;
  t9313 = t4586 * t5412 * t236;
  t9318 = t2411 * t2441;
  t9320 = t236 * t4368;
  t9321 = t4365 * t9320;
  t9322 = t4374 * t2976;
  t9328 = t4528 * t4558 * t236;
  t9333 = t2357 * t1450 * t1779 * t850;
  t9337 = t1437 * t2402;
  t9340 = t560 * t9320;
  t9341 = t569 * t2976;
  t9343 = t4523 * t9341 * params->csk_a;
  t9346 = t4523 * t2407;
  t9349 = t570 * t695;
  t9350 = t1445 * t9349;
  t9353 = t1452 * t2976;
  t9355 = t4586 * t9353 * t1057;
  t9360 = 0.11e2 * t9321 * t4528 * t9322 * t1057 - 0.9e1 * t2344 * t9337 + 0.9e1 * t2397 * t5469 - 0.9e1 * t2397 * t9350 - 0.18e2 * t9288 * t9302 - 0.7e1 * t9288 * t9309 - 0.11e2 * t9288 * t9346 + 0.18e2 * t9295 * t9309 + 0.12e2 * t9295 * t9313 - 0.12e2 * t9298 * t9313 - 0.6e1 * t9298 * t9328 + 0.18e2 * t9321 * t9355 + 0.7e1 * t9340 * t9343 - 0.3e1 * t9318 - 0.3e1 * t9333;
  t9364 = t1450 * t1453 * t695;
  t9367 = t4523 * t706;
  t9370 = t4586 * t2398;
  t9373 = t1425 * t684;
  t9378 = t1803 * t3028;
  t9381 = t575 * t1490 * t695;
  t9396 = t7075 * t2678;
  t9401 = t1437 * t4513 * t236;
  t9404 = t2976 * t4383;
  t9405 = t560 * t9404;
  t9408 = -0.18e2 * t685 * t1432 * t9341 * t584 - 0.6e1 * t9373 * t1450 * t9353 * t584 - 0.6e1 * t9321 * t4528 * t9322 * params->csk_a + 0.9e1 * t2348 * t9350 - 0.6e1 * t2397 * t9364 + 0.9e1 * t2413 * t9381 + 0.9e1 * t2448 * t5493 - 0.12e2 * t2998 * t9401 - 0.3e1 * t9405 * t707 + 0.6e1 * t9295 * t9302 - 0.18e2 * t9295 * t9367 - 0.6e1 * t9298 * t9370 + 0.3e1 * t9378 - 0.6e1 * t9396;
  t9411 = t1822 * t1432 * t2361 * t236;
  t9415 = t2976 * t236;
  t9421 = t4586 * t2444;
  t9427 = t1437 * t1438 * t695;
  t9430 = t2411 * t2403;
  t9437 = t4523 * t9341 * t1057;
  t9446 = 0.3e1 * t234 * t9415 * t5399 - 0.3e1 * t2344 * t9427 + 0.9e1 * t2348 * t9337 + 0.9e1 * t2348 * t9427 + 0.9e1 * t2397 * t5431 - 0.3e1 * t2397 * t9427 - 0.3e1 * t9405 * t692 + 0.11e2 * t9300 * t9289 - 0.12e2 * t9295 * t9370 - 0.6e1 * t9295 * t9421 - 0.7e1 * t9298 * t9309 + 0.7e1 * t9321 * t9437 - 0.9e1 * t9411 - 0.3e1 * t9430;
  t9448 = t1829 * t2362;
  t9452 = t234 * t850 * t695 * t586;
  t9454 = t1437 * t2370;
  t9462 = t1425 * t9320;
  t9466 = t2354 * t2374;
  t9478 = t4619 * t701;
  t9481 = t560 * t9267;
  t9482 = t9481 * t2621;
  t9484 = t9481 * t2617;
  t9486 = 0.3e1 * t234 * t9404 * t702 + 0.3e1 * t560 * t9415 * t4393 + 0.11e2 * t9340 * t4523 * t9341 + t9321 * t4528 * t9322 + 0.6e1 * t9462 * t4586 * t9353 - 0.6e1 * t2344 * t9454 - 0.9e1 * t2348 * t5574 - 0.3e1 * t2397 * t5611 + 0.6e1 * t9300 * t9478 + 0.3e1 * t9448 - 0.3e1 * t9452 + 0.3e1 * t9466 - 0.9e1 * t9482 - 0.9e1 * t9484;
  t9487 = t9268 * t2621;
  t9489 = 0.9e1 * t9487 - t2384 + t2391 - t2395 - t3026 + t3030 - t3032 - t3034 + t3037 - t3039 - t2412 + t2416 + t2427 - t2428 + t2451;
  t9493 = my_piecewise5(t114, 0, t115, 0, t9208 + t9262 + t9305 + t9360 + t9408 + t9446 + t9486 + t9489);
  t9500 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3044 + t9175 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t9493 + t232 * t3042 + 0.3e1 * t278 * t2455 + 0.3e1 * t680 * t860));
  tv4rhosigma319 = t8 * t9500 + t3048;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t9507 = t7 * t145 * t3128 / 0.1e2;
  t9522 = t395 * t817;
  t9523 = t394 * t9522;
  t9527 = t379 * t3071 * t3543;
  t9532 = t1057 * t817;
  t9533 = t9532 * t165;
  t9537 = 0.3e1 * t163 * t744 * t3543 * t9523 - 0.11e2 * t7445 * t389 * t9533 - 0.3e1 * t9527 * t630 - 0.3e1 * t9527 * t645 + t2206 - t2209 + t2228 - t2485 - t2488 - t2493 + t2498 - t2502 - 0.4e1 * t2920 + t3062 + t3063 + t3068 + t3070 - t3230 - t826 - t877;
  t9541 = t163 * t3072;
  t9544 = t8886 * t2282;
  t9545 = t2519 * t9544;
  t9547 = t6596 * t3554;
  t9548 = t3569 * t9547;
  t9553 = t3703 * t817;
  t9554 = t9553 * t2510;
  t9557 = t2524 * t9544;
  t9559 = t3078 * t165;
  t9560 = t171 * t9559;
  t9566 = t3569 * t8980 * t3554;
  t9567 = t7522 * t817;
  t9571 = t9553 * t165;
  t9577 = t2530 * t824;
  t9578 = t389 * t9577;
  t9579 = t6560 * t9578;
  t9581 = t8941 * t2510;
  t9582 = t2508 * t9581;
  t9585 = t2509 * t389 * t633;
  t9592 = t9553 * t1110 * t165;
  t9600 = t171 * t6561;
  t9605 = t741 * t817;
  t9607 = t379 * t9605 * t403;
  t9610 = -0.6e1 * t7448 * t1110 * t9533 - 0.12e2 * t9541 * t9092 + 0.3e1 * t9545 + 0.7e1 * t9548 * t389 * t7522 * t165 - 0.7e1 * t7451 * t9554 - 0.3e1 * t9557 + 0.11e2 * t7440 * t9560 - 0.11e2 * t7445 * t9560 + 0.11e2 * t9566 * t3574 * t9567 - 0.6e1 * t7451 * t3574 * t9571 + 0.6e1 * t2504 * t9068 + 0.3e1 * t9579 - 0.3e1 * t9582 - 0.6e1 * t2508 * t9585 + 0.18e2 * t9566 * t1110 * t9567 - 0.12e2 * t7451 * t9592 + 0.3e1 * t163 * t741 * t167 * t384 * t3080 - 0.6e1 * t2524 * t9600 + 0.6e1 * t2519 * t9585 - 0.3e1 * t9607 * t1148;
  t9617 = t2530 * t633;
  t9624 = t622 * t1050;
  t9625 = t1045 * t9624;
  t9629 = t1045 * t9547;
  t9633 = t1990 * t171 * t8882;
  t9635 = t6526 * t2516;
  t9637 = t379 * t9624;
  t9646 = t1110 * t9577;
  t9647 = t6560 * t9646;
  t9650 = t2508 * t1110 * t8942;
  t9656 = t2524 * t8943;
  t9659 = t9532 * t2282;
  t9666 = t171 * t9571;
  t9668 = 0.6e1 * t2519 * t9600 - 0.6e1 * t9548 * t3574 * t2531 + 0.6e1 * t2529 * t1110 * t9617 + 0.6e1 * t2514 * t389 * t7379 - 0.6e1 * t9625 * t1110 * t3072 - 0.12e2 * t9629 * t2544 + 0.3e1 * t9633 + 0.3e1 * t9635 - 0.18e2 * t9637 * t389 * t3072 - 0.3e1 * t9607 * t1135 + 0.7e1 * t7445 * t389 * t9559 + 0.3e1 * t9647 - 0.2e1 * t9650 - 0.4e1 * t2508 * t1110 * t2509 * t633 - t9656 - 0.7e1 * t7445 * t9554 - 0.18e2 * t7445 * t9659 + 0.6e1 * t7448 * t9659 + 0.6e1 * t7440 * t9659 + t7440 * t9666;
  t9671 = t2519 * t8943;
  t9673 = t2508 * t8943;
  t9676 = t2519 * t9581;
  t9680 = t2509 * t2265;
  t9705 = -0.18e2 * t9629 * t2532 - 0.6e1 * t9548 * t2544 + 0.6e1 * t7448 * t9666 - t7451 * t9666 - 0.6e1 * t8868 - 0.6e1 * t8871 + 0.6e1 * t8874 + 0.6e1 * t8884 + 0.6e1 * t8889 - 0.4e1 * t8910 + 0.6e1 * t8918;
  t9717 = t1066 * t6687 * t298;
  t9718 = t2200 * t9717;
  t9737 = t1051 * t732 * t824;
  t9738 = t5014 * t9737;
  t9742 = t1956 * t3112;
  t9756 = 0.6e1 * t8936 - 0.2e1 * t8944 + 0.6e1 * t8946 - 0.2e1 * t8948 + 0.6e1 * t8955 - 0.3e1 * t5860 * t3103 - t9718 - 0.2e1 * t1616 * t7687 + t8981 * t3708 * t6635 * t298 + 0.3e1 * t2269 * t5882 + 0.3e1 * t2298 * t5824 - 0.6e1 * t1634 * t1051 * t732 * t633 + 0.6e1 * t9149 * t3722 * t2201 * t298 - 0.3e1 * t9738 - 0.3e1 * t5849 * t3098 - t9742 - 0.2e1 * t5849 * t3115 + 0.3e1 * t163 * t9605 * t1664 - 0.4e1 * t1936 * t1056 * t878 * t633 + 0.11e2 * t9018 * t3695 * t732 * t817;
  t9757 = t1956 * t2953;
  t9758 = t817 * t165;
  t9764 = t1936 * t1056 * t3060 * t165;
  t9779 = t1940 * t2953;
  t9795 = t1940 * t3061;
  t9796 = -0.3e1 * t2221 * t5928 - 0.2e1 * t5860 * t3055 + 0.3e1 * t5817 * t3098 + 0.3e1 * t5817 * t3103 - 0.2e1 * t9012 - 0.2e1 * t9043 + 0.2e1 * t9063 - 0.2e1 * t9065 - 0.4e1 * t9097 - 0.6e1 * t9106 + t9795;
  t9799 = t2257 * t1926;
  t9803 = t163 * t741 * t824 * t405;
  t9809 = t8216 * t4955 * t8882;
  t9811 = t1045 * t5714;
  t9812 = t1110 * t1057;
  t9813 = t9758 * t403;
  t9823 = t8886 * t74;
  t9825 = t8216 * t9823 * t8906;
  t9837 = t3065 * t403;
  t9838 = t163 * t9837;
  t9839 = t9838 * t2492;
  t9845 = t1617 * t382 * t2282;
  t9858 = t382 * params->csk_a;
  t9859 = t9858 * t165;
  t9860 = t1056 * t170 * t9859;
  t9866 = t9799 - t2269 * t5942 - t9803 + 0.6e1 * t1990 * t2495 * t2210 * t633 - 0.3e1 * t9809 - 0.12e2 * t9811 * t9812 * t9813 - 0.6e1 * t2490 * t2500 * t8912 + 0.18e2 * t9625 * t7427 * t3079 - 0.3e1 * t9825 - 0.18e2 * t9811 * t9532 * t386 * t2299 + 0.18e2 * t3073 * t1051 * t388 * t1057 * t382 * t165 + 0.3e1 * t9839 - 0.6e1 * t2490 * t4743 * t2265 + 0.18e2 * t3073 * t9845 - 0.6e1 * t1045 * t3072 * t9845 - 0.6e1 * t5715 * t7413 * t9813 + 0.18e2 * t6496 * t7394 * t2245 - 0.18e2 * t9541 * t9860 + 0.18e2 * t3073 * t9860 + 0.6e1 * t9116;
  t9873 = -t3113 + t3120 + t3121 - t3122 - t3123 - t2258 + t2279 - t2280 + 0.2e1 * t9133 - 0.2e1 * t9137 + 0.2e1 * t9139;
  t9878 = my_piecewise5(t64, 0, t67, 0, 0.6e1 * t5793 * t3800 * t3054 * t165 + t9537 - t5849 * t3086 - 0.7e1 * t7445 * t9666 + 0.18e2 * t7448 * t9554 + 0.12e2 * t7448 * t9592 + 0.6e1 * t2519 * t9680 - 0.2e1 * t2508 * t9680 - 0.2e1 * t2524 * t9680 + 0.3e1 * t2269 * t5758 - t5860 * t3086 + 0.3e1 * t5817 * t3086 - 0.6e1 * t9119 - 0.6e1 * t9121 - t3108 + t3093 + t3096 + t3082 - t3075 - t3077 + t2505 + t2517 + t9873 + t9866 + t9796 + t9779 - 0.2e1 * t9764 + t9756 - t9757 + t9705 + 0.3e1 * t9676 - t9673 + 0.3e1 * t9671 + t9668 + t9610 + 0.3e1 * t3118 * t3544 * t2282 + 0.6e1 * t2529 * t389 * t9617 + 0.3e1 * t379 * t9758 * t7651);
  t9885 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3128 + t9507 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.72e2 * t52 * t257 * t834 + t52 * t291 * t2311 / 0.24e2 + 0.2e1 * t618 * t886 + 0.2e1 * t260 * t2568 + t161 * t3126 + t59 * t9878));
  tv4rhosigma2lapl0 = t8 * t9885 + t3132;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t9892 = t7 * t192 * t3213 / 0.1e2;
  t9894 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3213 + t9892);
  tv4rhosigma2lapl11 = t8 * t9894 + t3217;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t9900 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3128 + t9507);
  tv4rhosigma2lapl12 = t8 * t9900 + t3132;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t9917 = t7066 * t4370;
  t9918 = t4365 * t9917;
  t9923 = t3703 * t843;
  t9924 = t9923 * t9308;
  t9927 = t3162 * t236;
  t9928 = t242 * t9927;
  t9933 = 0.7e1 * t9918 * t570 * t7885 * t236 - 0.11e2 * t7876 * t9928 - 0.7e1 * t7907 * t9924 + 0.11e2 * t7946 * t9928 + t2355 + t2363 - t2366 - t2608 - t2611 - t2618 - t2622 + t2627 - 0.4e1 * t2995 + t3146 + t3147 + t3152 + t3154 - t3298 - t852 - t903;
  t9936 = t576 * t843;
  t9937 = t575 * t9936;
  t9941 = t560 * t3155 * t4383;
  t9944 = t2656 * t9196;
  t9946 = t1057 * t843;
  t9947 = t9946 * t236;
  t9951 = t234 * t3156;
  t9956 = t2642 * t9196;
  t9961 = t1425 * t9917;
  t9964 = t570 * t9272;
  t9965 = t2642 * t9964;
  t9967 = t9923 * t236;
  t9968 = t1496 * t9967;
  t9971 = t2656 * t9273;
  t9976 = t2636 * t850;
  t9977 = t1496 * t9976;
  t9978 = t6193 * t9977;
  t9981 = t2666 * t1496 * t9272;
  t9988 = t4365 * t9320 * t4370;
  t9989 = t7885 * t843;
  t9996 = t2636 * t695;
  t10000 = 0.3e1 * t234 * t798 * t4383 * t9937 - 0.3e1 * t9941 * t692 - 0.3e1 * t9944 - 0.11e2 * t7876 * t570 * t9947 - 0.12e2 * t9951 * t9401 - 0.3e1 * t9941 * t707 + 0.3e1 * t9956 - 0.6e1 * t7931 * t1496 * t9947 - 0.12e2 * t9961 * t2638 + 0.3e1 * t9965 + 0.12e2 * t7931 * t9968 - t9971 - 0.7e1 * t7876 * t9924 - 0.18e2 * t9961 * t2659 + 0.3e1 * t9978 - 0.2e1 * t9981 - 0.4e1 * t2666 * t1496 * t2643 * t695 + 0.11e2 * t9988 * t4375 * t9989 - 0.6e1 * t7907 * t4375 * t9967 + 0.6e1 * t2635 * t1496 * t9996;
  t10002 = t570 * t9976;
  t10003 = t6193 * t10002;
  t10005 = t2666 * t9964;
  t10007 = t2643 * t9349;
  t10015 = t6992 * t2631;
  t10021 = t684 * t1431;
  t10022 = t560 * t10021;
  t10026 = t795 * t843;
  t10028 = t560 * t10026 * t584;
  t10040 = t9946 * t2430;
  t10047 = t242 * t9967;
  t10054 = -0.6e1 * t9988 * t4375 * t3155 * params->csk_a - 0.18e2 * t10022 * t570 * t3156 + 0.18e2 * t9988 * t1496 * t9989 + 0.7e1 * t7876 * t570 * t9927 + 0.6e1 * t2642 * t10007 - 0.6e1 * t2666 * t10007 - 0.3e1 * t10028 * t1521 - 0.18e2 * t7876 * t10040 + 0.6e1 * t7931 * t10040 + 0.6e1 * t7946 * t10040 - 0.7e1 * t7876 * t10047 - t7907 * t10047 + 0.6e1 * t7931 * t10047 + t7946 * t10047 - 0.6e1 * t9918 * t2638 + 0.6e1 * t2648 * t9381 - 0.12e2 * t7907 * t9968 + 0.3e1 * t10003 - 0.3e1 * t10005 + 0.3e1 * t10015;
  t10055 = t2642 * t9273;
  t10057 = t2666 * t9273;
  t10060 = t2643 * t9240;
  t10067 = t242 * t7019;
  t10083 = t1425 * t10021;
  t10088 = t2125 * t242 * t9255;
  t10097 = -0.6e1 * t10083 * t1496 * t3156 + 0.6e1 * t2629 * t570 * t7848 + 0.3e1 * t6142 * t3164 + 0.3e1 * t10088 - 0.6e1 * t9197 - 0.6e1 * t9206 + 0.6e1 * t9215 + 0.6e1 * t9234 - 0.4e1 * t9249 + 0.6e1 * t9257 + 0.6e1 * t9260;
  t10116 = t2624 * t9255;
  t10117 = t2125 * t10116;
  t10119 = t843 * t236;
  t10120 = t10119 * t584;
  t10121 = t7830 * t10120;
  t10127 = t6134 * t10116;
  t10132 = t6134 * t5395 * t9255;
  t10134 = t1496 * t1057;
  t10139 = t1445 * t563 * t2430;
  t10153 = 0.6e1 * t9269 - 0.2e1 * t9274 + 0.6e1 * t9276 - 0.2e1 * t9278 + 0.6e1 * t9285 + 0.18e2 * t6962 * t7817 * t2389 - 0.6e1 * t2615 * t5265 * t9240 + 0.6e1 * t2125 * t2624 * t2367 * t695 + 0.3e1 * t10117 + 0.18e2 * t6148 * t10121 - 0.6e1 * t2615 * t2616 * t9251 - 0.3e1 * t10127 - 0.18e2 * t6157 * t10121 - 0.3e1 * t10132 - 0.12e2 * t6157 * t10134 * t10120 + 0.18e2 * t3157 * t10139 - 0.6e1 * t1425 * t3156 * t10139 - 0.6e1 * t6174 * t7858 * t10120 + 0.18e2 * t6962 * t7836 * t2389 - 0.3e1 * t6230 * t3169;
  t10160 = t1432 * t786 * t850;
  t10161 = t6336 * t10160;
  t10164 = t1450 * t7207 * t315;
  t10165 = t2357 * t10164;
  t10193 = t2135 * t3190;
  t10198 = t2091 * t3028;
  t10201 = t2135 * t3028;
  t10207 = -0.6e1 * t1822 * t1432 * t786 * t695 + 0.6e1 * t9462 * t4586 * t2358 * t315 + 0.3e1 * t560 * t10119 * t8096 + 0.3e1 * t2397 * t6331 + 0.3e1 * t2448 * t6348 + 0.3e1 * t6244 * t3186 - 0.3e1 * t6279 * t3186 - 0.2e1 * t6279 * t3193 - t10193 + t10198 - t10201;
  t10212 = t2114 * t1437 * t3144 * t236;
  t10232 = t234 * t795 * t850 * t586;
  t10237 = t2091 * t3145;
  t10238 = t2411 * t2097;
  t10243 = 0.6e1 * t6256 * t4619 * t3138 * t236 + 0.3e1 * t3201 * t4384 * t2430 - 0.3e1 * t2348 * t6406 - t2397 * t6421 - 0.2e1 * t6230 * t3139 + 0.3e1 * t6244 * t3169 - t6279 * t3178 - 0.2e1 * t10212 - t10232 + t10237 + t10238 - 0.2e1 * t9318 - 0.2e1 * t9333 + 0.2e1 * t9378 - 0.4e1 * t9396 - 0.6e1 * t9411 - 0.2e1 * t9430 + 0.2e1 * t9448 - 0.2e1 * t9452 + 0.2e1 * t9466;
  t10245 = t563 * params->csk_a;
  t10246 = t10245 * t236;
  t10247 = t1437 * t241 * t10246;
  t10256 = -t3183 - t3191 + t3198 + t3203 + t3205 + t3206 - t3207 - t3208 - t2412 + t2427 - t2428;
  t10261 = my_piecewise5(t114, 0, t115, 0, t9321 * t4528 * t7127 * t315 - 0.4e1 * t2114 * t1437 * t904 * t695 + 0.11e2 * t9340 * t4523 * t786 * t843 + 0.6e1 * t9487 - 0.6e1 * t9482 - 0.6e1 * t9484 + t3166 - t3161 - t3159 + t2649 + t2632 + t10256 + t10243 + t10207 - t10165 - 0.3e1 * t10161 + t10153 + t10097 + 0.3e1 * t10055 - t10057 + t10054 - 0.18e2 * t9951 * t10247 + 0.18e2 * t3157 * t10247 + 0.3e1 * t2397 * t6364 - t6230 * t3178 + 0.3e1 * t6244 * t3178 - 0.2e1 * t1810 * t8114 + 0.18e2 * t7931 * t9924 - 0.2e1 * t2666 * t10060 - 0.2e1 * t2656 * t10060 + 0.6e1 * t2642 * t10060 - 0.6e1 * t2656 * t10067 - 0.3e1 * t10028 * t1529 + 0.6e1 * t2642 * t10067 + t10000 + t9933 + 0.3e1 * t234 * t10026 * t1852 + 0.6e1 * t2635 * t570 * t9996);
  t10268 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3213 + t9892 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.72e2 * t52 * t275 * t860 + t52 * t308 * t2455 / 0.24e2 + 0.2e1 * t680 * t912 + 0.2e1 * t278 * t2692 + t232 * t3211 + t113 * t10261));
  tv4rhosigma2lapl23 = t8 * t10268 + t3217;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t10275 = t7 * t145 * t3281 / 0.1e2;
  t10287 = t379 * t8411 * t384;
  t10290 = t8290 * t3554;
  t10291 = t1045 * t10290;
  t10294 = t922 * t165;
  t10303 = t379 * t10290;
  t10306 = t163 * t8247;
  t10311 = t3569 * t10290;
  t10312 = t7441 * t165;
  t10313 = t1110 * t10312;
  t10316 = 0.3e1 * t163 * t10294 * t3543 * t873 - 0.12e2 * t10306 * t171 * t627 * t165 - 0.3e1 * t10287 * t2521 - 0.3e1 * t10287 * t4760 + 0.6e1 * t10291 * t2536 - 0.6e1 * t10291 * t2541 - 0.11e2 * t10303 * t2511 - 0.12e2 * t10311 * t10313 + t2206 - t2209 + t2228 - t2727 + t2911 + t2922 - 0.4e1 * t3067 - t3069 + t3228 + t3229 - t826 - t929;
  t10317 = t389 * t10312;
  t10324 = t922 * params->csk_a * t165;
  t10325 = t1110 * t10324;
  t10328 = t163 * t10290;
  t10334 = t922 * t1057 * t263;
  t10341 = t2509 * t741;
  t10342 = t389 * t10341;
  t10346 = t1680 * t741;
  t10367 = t7441 * t2282;
  t10376 = -0.6e1 * t1045 * t4768 * t1110 * t10294 * t403 + 0.6e1 * t163 * t8426 * t171 * t10346 - 0.6e1 * t10311 * t3574 * t10312 - 0.6e1 * t7521 * t3574 * t10324 - 0.12e2 * t1045 * t7520 * t10325 + 0.11e2 * t9566 * t3574 * t10334 - 0.4e1 * t2508 * t1110 * t10341 + 0.18e2 * t10291 * t10317 + 0.6e1 * t10291 * t10367 - 0.18e2 * t10291 * t4760 - 0.7e1 * t10303 * t10367 - 0.11e2 * t10303 * t2521 - 0.18e2 * t10303 * t2536 - 0.7e1 * t10311 * t10317 - t10311 * t10367 - 0.6e1 * t7521 * t10325 + t10328 * t10367 + 0.11e2 * t10328 * t2521 + 0.6e1 * t10328 * t2536 + 0.6e1 * t2519 * t10342;
  t10382 = t2509 * t8428;
  t10385 = t3231 * t8428;
  t10393 = t3231 * t741;
  t10426 = -0.18e2 * t9637 * t389 * t2735 * t263 + 0.18e2 * t9566 * t1110 * t10334 + 0.7e1 * t9566 * t389 * t10334 + 0.6e1 * t2508 * t1110 * t10393 + 0.6e1 * t2508 * t389 * t10393 + 0.6e1 * t8216 * t389 * t7372 + 0.12e2 * t10291 * t10313 - 0.7e1 * t10303 * t10317 + 0.7e1 * t10303 * t4760 - 0.6e1 * t2508 * t10342 - 0.2e1 * t2508 * t10382 + 0.6e1 * t2519 * t10382 - 0.2e1 * t2524 * t10382 + 0.6e1 * t2519 * t10385 - 0.6e1 * t2524 * t10385 - 0.3e1 * t2737 * t8903 - 0.3e1 * t2737 * t8913 + 0.3e1 * t2742 * t8899 + 0.6e1 * t9545 - 0.6e1 * t9557;
  t10447 = -0.3e1 * t8868 - 0.3e1 * t8871 + 0.3e1 * t8874 + 0.3e1 * t8884 + 0.3e1 * t8889 - 0.2e1 * t8910 + 0.3e1 * t8918 + 0.3e1 * t8936 - t8944 + 0.3e1 * t8946 - t8948;
  t10452 = t7420 * t2496;
  t10460 = t2509 * t74 * t8906;
  t10481 = t389 * t263;
  t10485 = t9859 * t2520;
  t10506 = 0.3e1 * t8955 - 0.18e2 * t8258 * t10452 + 0.18e2 * t8258 * t1110 * t263 * t2245 - 0.6e1 * t8258 * t10460 - 0.6e1 * t8427 * t3236 * t8428 + 0.6e1 * t1990 * t2495 * t7372 - 0.6e1 * t8427 * t4955 * t10346 - 0.12e2 * t8258 * t9812 * t2496 + 0.18e2 * t8222 * t10452 - 0.6e1 * t8255 * t10460 + 0.18e2 * t8222 * t10460 + 0.18e2 * t8258 * t10481 * t2245 + 0.18e2 * t8280 * t10485 - 0.18e2 * t10306 * t10485 + 0.3e1 * t2732 * t8988 + 0.3e1 * t2757 * t9068 - 0.4e1 * t1936 * t1056 * t878 * t741 + 0.11e2 * t9018 * t3695 * t8305 * t263 - 0.3e1 * t2747 * t8988 + 0.3e1 * t2780 * t5022;
  t10549 = -0.6e1 * t1953 * t1051 * t624 * t741 - 0.2e1 * t1616 * t8295 + t8981 * t3708 * t4936 * t922 - 0.2e1 * t2747 * t8999 + 0.3e1 * t379 * t10294 * t3544 * t10481 + 0.3e1 * t8464 * t394 * t2558 + 0.6e1 * t8395 * t3800 * t2558 + 0.6e1 * t4873 * t3722 * t2720 * t165 - t2729 * t9045 + 0.3e1 * t2732 * t9045 + 0.3e1 * t2732 * t9015 + 0.3e1 * t2747 * t4929 - 0.3e1 * t2729 * t9015 - t2747 * t9045 + 0.3e1 * t2747 * t4890 - 0.2e1 * t9718 - 0.6e1 * t9738 - 0.2e1 * t9742 - 0.2e1 * t9757 - 0.4e1 * t9764;
  t10566 = -t4900 * t2721 - 0.2e1 * t2729 * t9141 - 0.3e1 * t2732 * t5054 + t3235 - t3239 - t3242 - t9012 - t9043 + t9063 - t9065 - 0.2e1 * t9097 - 0.3e1 * t9106 + 0.3e1 * t9116 + 0.2e1 * t9779 + 0.2e1 * t9795 + 0.2e1 * t9799 - 0.2e1 * t9803 - 0.6e1 * t9809 - 0.6e1 * t9825 + 0.6e1 * t9839;
  t10570 = t2954 - t2956 - t2963 + t2758 + t2781 - t2258 + t2279 - t2280 + t9133 - t9137 + t9139;
  t10575 = my_piecewise5(t64, 0, t67, 0, t10570 + t10566 + t10549 + t2743 - t2745 - t2738 + t10506 + t10447 + t10426 + t10376 + t10316 - 0.3e1 * t9119 - 0.3e1 * t9121 + t3271 + t3274 - t3275 - t3276 + 0.6e1 * t9676 - 0.2e1 * t9673 + 0.6e1 * t9671 - 0.2e1 * t9656 - 0.4e1 * t9650 + 0.6e1 * t9647 + 0.6e1 * t9635 + t3267 + 0.6e1 * t9633 + 0.6e1 * t9579 - 0.6e1 * t9582);
  t10582 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3281 + t10275 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.36e2 * t52 * t257 * t886 + t52 * t291 * t2568 / 0.12e2 + t618 * t935 + t260 * t2785 + t161 * t3279 + t59 * t10575));
  tv4rhosigmalapl20 = t8 * t10582 + t3285;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t10589 = t7 * t192 * t3349 / 0.1e2;
  t10591 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3349 + t10589);
  tv4rhosigmalapl28 = t8 * t10591 + t3353;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t10597 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3281 + t10275);
  tv4rhosigmalapl29 = t8 * t10597 + t3285;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t10612 = t8675 * t4370;
  t10613 = t1425 * t10612;
  t10614 = t7893 * t236;
  t10615 = t570 * t10614;
  t10620 = t945 * params->csk_a * t236;
  t10621 = t1496 * t10620;
  t10624 = t234 * t10612;
  t10627 = t560 * t10612;
  t10631 = t560 * t8752 * t565;
  t10634 = t945 * t236;
  t10643 = 0.3e1 * t234 * t10634 * t4383 * t899 - 0.12e2 * t1425 * t7883 * t10621 + 0.18e2 * t10613 * t10615 + 0.6e1 * t10613 * t2662 + 0.11e2 * t10624 * t2652 - 0.11e2 * t10627 * t2652 - 0.3e1 * t10631 * t2652 - 0.3e1 * t10631 * t5275 + t2355 + t2363 - t2366 - t2829 + t2986 + t3005 - 0.4e1 * t3151 - t3153 + t3296 + t3297 - t852 - t952;
  t10648 = t234 * t8597;
  t10653 = t4365 * t10612;
  t10658 = t1496 * t10614;
  t10669 = t242 * t10614;
  t10682 = t686 * t795;
  t10683 = t7000 * t10682;
  t10687 = t945 * t1057 * t281;
  t10694 = -0.12e2 * t10648 * t242 * t689 * t236 + 0.18e2 * t9988 * t1496 * t10687 + 0.6e1 * t6134 * t570 * t7844 + 0.6e1 * t10613 * t10669 - 0.6e1 * t10613 * t2670 - 0.18e2 * t10613 * t5275 - 0.7e1 * t10627 * t10615 - 0.7e1 * t10653 * t10615 - 0.6e1 * t7884 * t10621 + t10624 * t10669 + 0.6e1 * t10624 * t2662 - 0.7e1 * t10627 * t10669 - 0.11e2 * t10627 * t2645 - 0.18e2 * t10627 * t2662 + 0.7e1 * t10627 * t5275 - 0.12e2 * t10653 * t10658 - t10653 * t10669 + 0.7e1 * t10653 * t2645 - 0.6e1 * t2666 * t10683 - 0.3e1 * t2842 * t9252;
  t10704 = t1871 * t795;
  t10712 = t1425 * t5278;
  t10720 = t2643 * t795;
  t10728 = t3299 * t8589;
  t10731 = t242 * t10720;
  t10742 = t3299 * t795;
  t10751 = 0.11e2 * t9988 * t4375 * t10687 - 0.6e1 * t10653 * t4375 * t10614 + 0.6e1 * t2642 * t10683 + 0.6e1 * t8608 * t242 * t10704 - 0.18e2 * t10022 * t570 * t2840 * t281 - 0.6e1 * t10712 * t1496 * t10634 * t584 - 0.6e1 * t7884 * t4375 * t10620 - 0.4e1 * t2666 * t1496 * t10720 + 0.12e2 * t10613 * t10658 - 0.3e1 * t2842 * t9241 + 0.6e1 * t2642 * t10728 - 0.2e1 * t2656 * t10731 + 0.6e1 * t2642 * t10731 - 0.2e1 * t2666 * t10731 + 0.3e1 * t2847 * t9219 - 0.6e1 * t2656 * t10728 + 0.6e1 * t2666 * t570 * t10742 + 0.6e1 * t2666 * t1496 * t10742 - 0.6e1 * t9944 + 0.6e1 * t9956;
  t10772 = -0.3e1 * t9197 - 0.3e1 * t9206 + 0.3e1 * t9215 + 0.3e1 * t9234 - 0.2e1 * t9249 + 0.3e1 * t9257 + 0.3e1 * t9260 + 0.3e1 * t9269 - t9274 + 0.3e1 * t9276 - t9278;
  t10778 = t2643 * t122 * t9245;
  t10797 = t7830 * t2625;
  t10809 = t2651 * t10246;
  t10822 = 0.3e1 * t9285 - 0.6e1 * t8580 * t10778 - 0.6e1 * t8786 * t3300 * t8589 + 0.18e2 * t8580 * t1496 * t281 * t2389 - 0.6e1 * t8786 * t5395 * t10704 + 0.6e1 * t2125 * t2624 * t7844 - 0.12e2 * t8580 * t10134 * t2625 + 0.18e2 * t8586 * t10797 - 0.18e2 * t8580 * t10797 + 0.18e2 * t8580 * t3319 * t2389 - 0.6e1 * t8583 * t10778 + 0.18e2 * t8586 * t10778 - 0.18e2 * t10648 * t10809 + 0.18e2 * t8631 * t10809 + 0.6e1 * t10117 - 0.6e1 * t10127 - 0.6e1 * t10132 - 0.3e1 * t2837 * t9337 + 0.3e1 * t2852 * t5431 - t2837 * t9427;
  t10872 = 0.3e1 * t2834 * t9427 + 0.11e2 * t9340 * t4523 * t8696 * t281 - 0.3e1 * t2852 * t9350 + 0.3e1 * t2870 * t5493 - 0.6e1 * t2138 * t1432 * t10682 - 0.2e1 * t1810 * t8655 + t9321 * t4528 * t5472 * t945 - 0.2e1 * t2852 * t9364 + 0.3e1 * t2834 * t9350 + 0.3e1 * t2881 * t9381 - 0.4e1 * t2114 * t1437 * t904 * t795 + 0.3e1 * t560 * t10634 * t4384 * t3319 + 0.3e1 * t8818 * t575 * t2677 + 0.6e1 * t8749 * t4619 * t2677 + 0.6e1 * t5384 * t4586 * t2821 * t236 - t2852 * t9427 + 0.3e1 * t2834 * t9337 + 0.3e1 * t2852 * t5469 - 0.6e1 * t10161 - 0.2e1 * t10165;
  t10888 = -t5375 * t2822 - 0.3e1 * t2834 * t5574 - 0.2e1 * t2837 * t9454 - 0.2e1 * t10193 + 0.2e1 * t10198 - 0.2e1 * t10201 - 0.4e1 * t10212 - 0.2e1 * t10232 + 0.2e1 * t10237 + 0.2e1 * t10238 - t3303 + t3307 - t3310 - t9318 - t9333 + t9378 - 0.2e1 * t9396 - 0.3e1 * t9411 - t9430 + t9448;
  t10893 = -t3342 - t3343 + t3344 + t3029 - t3031 - t3038 + t2871 + t2882 - t2412 + t2427 - t2428;
  t10898 = my_piecewise5(t114, 0, t115, 0, t3324 + t3341 + 0.3e1 * t9487 - 0.3e1 * t9482 - 0.3e1 * t9484 + t9466 - t9452 + t10893 + t10888 + t10872 + t10822 + t10772 + t10751 + t10694 + t10643 + t2848 - t2850 - t2843 + 0.6e1 * t10088 + 0.6e1 * t10055 - 0.2e1 * t10057 + 0.6e1 * t10015 - 0.6e1 * t10005 + 0.6e1 * t10003 - 0.4e1 * t9981 + 0.6e1 * t9978 - 0.2e1 * t9971 + 0.6e1 * t9965);
  t10905 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3349 + t10589 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.36e2 * t52 * t275 * t912 + t52 * t308 * t2692 / 0.12e2 + t680 * t958 + t278 * t2890 + t232 * t3347 + t113 * t10898));
  tv4rhosigmalapl217 = t8 * t10905 + t3353;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t10912 = t7 * t145 * t3415 / 0.1e2;
  t10920 = 0.6e1 * t3067;
  t10921 = t3373 * t1050;
  t10922 = t163 * t10921;
  t10925 = t379 * t10921;
  t10936 = t3360 * t382 * t1050;
  t10937 = t1045 * t10936;
  t10940 = 0.9e1 * t2742 * t171 * t8897 * t741 - 0.9e1 * t2737 * t8902 * t8428 - 0.18e2 * t10922 * t8879 + 0.18e2 * t10925 * t8879 - 0.18e2 * t10937 * t8923 - t10920 + t2206 - t2209 + t2228 - t2727 + t3357 + t3358 - t826 - t929;
  t10945 = t379 * t10936;
  t10954 = t163 * t10936;
  t10967 = -0.9e1 * t2737 * t389 * t8902 * t741 + 0.18e2 * t10937 * t8894 - 0.6e1 * t10937 * t8907 - 0.12e2 * t10937 * t8928 + 0.18e2 * t10937 * t8938 + 0.18e2 * t10945 * t8907 + 0.18e2 * t10945 * t8923 - 0.6e1 * t10954 * t8907 + 0.9e1 * t9545 - 0.9e1 * t9557 + 0.9e1 * t9579 - 0.9e1 * t9582 + 0.9e1 * t9633 + 0.9e1 * t9635;
  t10975 = t3360 * t3552;
  t10976 = t163 * t10975;
  t10978 = t379 * t10975;
  t10981 = t1045 * t10975;
  t10984 = t3569 * t10975;
  t10994 = t10976 * t9031 - 0.7e1 * t10978 * t8963 - 0.7e1 * t10978 * t9031 + 0.18e2 * t10981 * t8963 + 0.12e2 * t10981 * t8967 - 0.18e2 * t10981 * t8972 + 0.6e1 * t10981 * t9031 - t10984 * t9031 + 0.9e1 * t9647 - 0.6e1 * t9650 - 0.3e1 * t9656 + 0.9e1 * t9671 - 0.3e1 * t9673 + 0.9e1 * t9676;
  t11005 = t1056 * t2750;
  t11012 = t388 * t3360;
  t11014 = t1051 * t11012 * t403;
  t11021 = t3573 * t3360;
  t11023 = t3708 * t11021 * t1057;
  t11031 = t3708 * t11021 * params->csk_a;
  t11035 = t1051 * t1073 * t741;
  t11038 = 0.9e1 * t2757 * t394 * t1104 * t741 + 0.6e1 * t10976 * t8959 + 0.11e2 * t10976 * t9082 - 0.18e2 * t10978 * t8959 + 0.7e1 * t10978 * t8972 - 0.11e2 * t10978 * t9082 - 0.6e1 * t10984 * t8976 - 0.6e1 * t10984 * t9007 - 0.9e1 * t2729 * t11005 - 0.18e2 * t623 * t11014 + 0.11e2 * t8981 * t11023 - 0.6e1 * t8981 * t11031 + 0.9e1 * t2732 * t11035 + 0.9e1 * t2747 * t5882 + 0.9e1 * t2780 * t5824;
  t11043 = t1068 * t3360;
  t11045 = t3722 * t11043 * t1057;
  t11056 = t3360 * t3543;
  t11057 = t379 * t11056;
  t11062 = t3360 * t165;
  t11078 = -0.6e1 * t2747 * t1066 * t1069 * t741 + 0.3e1 * t163 * t11062 * t4854 - 0.11e2 * t10978 * t9024 + 0.6e1 * t10981 * t8959 - 0.12e2 * t10981 * t8976 - 0.6e1 * t10981 * t9101 - 0.7e1 * t10984 * t8963 - 0.12e2 * t10984 * t8967 + 0.7e1 * t10984 * t9024 - 0.9e1 * t2747 * t11035 + 0.18e2 * t8981 * t11045 - 0.3e1 * t11057 * t630 - 0.3e1 * t11057 * t645 - 0.12e2 * t3394 * t9092;
  t11079 = t1617 * t8428;
  t11091 = t1066 * t11043 * t403;
  t11100 = t3722 * t11043;
  t11105 = 0.9e1 * t2732 * t11005 - 0.3e1 * t2729 * t11079 + 0.9e1 * t2732 * t11079 - 0.3e1 * t2747 * t11079 - 0.6e1 * t9058 * t11091 + 0.6e1 * t9149 * t11100 + 0.9e1 * t2747 * t5758 - 0.3e1 * t2747 * t5942 - 0.3e1 * t9718 - 0.9e1 * t9738 - 0.3e1 * t9742 - 0.3e1 * t9757 - 0.6e1 * t9764 + 0.3e1 * t9779;
  t11107 = t3708 * t11021;
  t11112 = t3695 * t11012;
  t11120 = t163 * t11056;
  t11131 = -0.6e1 * t2729 * t1056 * t2714 + 0.3e1 * t379 * t11062 * t3545 + 0.6e1 * t10976 * t9124 + t8981 * t11107 + 0.11e2 * t9018 * t11112 + 0.3e1 * t11120 * t640 - 0.9e1 * t2732 * t5928 - t2738 + 0.3e1 * t9795 + 0.3e1 * t9799 - 0.3e1 * t9803 - 0.9e1 * t9809 - 0.9e1 * t9825 + 0.9e1 * t9839;
  t11132 = t2743 - t2745 + t3372 - t3376 - t3378 + t3379 - t3380 - t3382 + t2758 + t2781 - t2258 + t2279 - t2280 + t3396 + t3399;
  t11136 = my_piecewise5(t64, 0, t67, 0, t10940 + t10967 + t10994 + t11038 + t11078 + t11105 + t11131 + t11132);
  t11143 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3415 + t10912 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.24e2 * t52 * t257 * t935 + t52 * t291 * t2785 / 0.8e1 + t161 * t3413 + t59 * t11136));
  tv4rholapl30 = t8 * t11143 + t3419;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t11150 = t7 * t192 * t3481 / 0.1e2;
  t11152 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3481 + t11150);
  tv4rholapl33 = t8 * t11152 + t3485;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t11158 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3415 + t10912);
  tv4rholapl34 = t8 * t11158 + t3419;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t11170 = 0.6e1 * t3151;
  t11171 = t3435 * t1431;
  t11172 = t560 * t11171;
  t11175 = t234 * t11171;
  t11183 = t570 * t3435 * params->csk_a;
  t11186 = t1425 * t11171;
  t11187 = t1057 * t563;
  t11191 = 0.9e1 * t2847 * t242 * t9217 * t795 - 0.18e2 * t11186 * t11187 * t9308 + 0.18e2 * t10083 * t11183 + 0.18e2 * t11172 * t9211 - 0.18e2 * t11175 * t9211 - t11170 + t2355 + t2363 - t2366 - t2829 + t3423 + t3424 - t852 - t952;
  t11192 = t3426 * t563;
  t11193 = t11192 * t1431;
  t11194 = t1425 * t11193;
  t11199 = t560 * t11193;
  t11205 = t11187 * t2430;
  t11210 = t234 * t11193;
  t11223 = -0.9e1 * t2842 * t570 * t9239 * t795 - 0.9e1 * t2842 * t9239 * t8589 + 0.18e2 * t11172 * t11205 - 0.6e1 * t11186 * t11205 - 0.12e2 * t11194 * t9231 + 0.18e2 * t11194 * t9264 + 0.18e2 * t11199 * t9225 - 0.6e1 * t11210 * t9246 - 0.9e1 * t9944 + 0.9e1 * t9956 + 0.9e1 * t9965 - 0.3e1 * t9971 + 0.9e1 * t9978 - 0.6e1 * t9981;
  t11234 = t3426 * t4368;
  t11235 = t234 * t11234;
  t11238 = t4365 * t11234;
  t11241 = t1425 * t11234;
  t11246 = t11235 * t9292 + 0.6e1 * t11235 * t9302 - t11238 * t9292 - 0.6e1 * t11238 * t9370 + 0.6e1 * t11241 * t9292 + 0.9e1 * t10003 - 0.9e1 * t10005 + 0.9e1 * t10015 + 0.9e1 * t10055 - 0.3e1 * t10057 + 0.9e1 * t10088 + 0.9e1 * t10117 - 0.9e1 * t10127 - 0.9e1 * t10132;
  t11247 = t560 * t11234;
  t11264 = t1471 * t8589;
  t11267 = t569 * t3426;
  t11269 = t4523 * t11267 * params->csk_a;
  t11273 = t1445 * t570 * t795;
  t11277 = t1437 * t1438 * t795;
  t11286 = 0.11e2 * t11235 * t9289 + 0.6e1 * t11241 * t9302 + 0.18e2 * t11241 * t9309 + 0.12e2 * t11241 * t9313 - 0.7e1 * t11247 * t9292 - 0.18e2 * t11247 * t9302 - 0.7e1 * t11247 * t9309 + 0.7e1 * t11247 * t9367 + 0.9e1 * t2834 * t11264 - 0.9e1 * t2837 * t11264 - 0.18e2 * t9462 * t11269 - 0.9e1 * t2852 * t11273 + 0.9e1 * t2834 * t11277 - 0.3e1 * t2837 * t11277 - 0.3e1 * t2852 * t11277;
  t11290 = t4523 * t11267 * t1057;
  t11301 = t1452 * t3426;
  t11303 = t1450 * t11301 * t584;
  t11307 = t4586 * t11301 * t1057;
  t11316 = t4374 * t3426;
  t11318 = t4528 * t11316 * t1057;
  t11326 = t4528 * t11316 * params->csk_a;
  t11329 = t3426 * t236;
  t11333 = t560 * t11192;
  t11337 = -0.6e1 * t2852 * t1450 * t1453 * t795 + 0.9e1 * t2881 * t575 * t1490 * t795 + 0.3e1 * t234 * t11329 * t5399 - 0.18e2 * t11333 * t1432 * t2449 - 0.12e2 * t11238 * t9313 - 0.6e1 * t11238 * t9328 + 0.9e1 * t2834 * t11273 + 0.7e1 * t9321 * t11290 - 0.6e1 * t9373 * t11303 + 0.18e2 * t9321 * t11307 + 0.11e2 * t9321 * t11318 - 0.6e1 * t9321 * t11326 + 0.9e1 * t2852 * t6331 + 0.9e1 * t2870 * t6348;
  t11340 = t3426 * t4383;
  t11341 = t560 * t11340;
  t11363 = -0.7e1 * t11238 * t9309 - 0.12e2 * t11241 * t9370 - 0.6e1 * t11241 * t9421 - 0.11e2 * t11247 * t9289 - 0.11e2 * t11247 * t9346 - 0.3e1 * t11341 * t692 - 0.3e1 * t11341 * t707 + 0.9e1 * t2852 * t6364 - 0.12e2 * t3465 * t9401 - 0.9e1 * t10161 - 0.3e1 * t10165 - 0.3e1 * t10193 + 0.3e1 * t10198 - 0.3e1 * t10201;
  t11366 = t4528 * t11316;
  t11368 = t4586 * t11301;
  t11378 = t234 * t11340;
  t11392 = 0.11e2 * t11247 * t4523 * t2349 + 0.3e1 * t560 * t11329 * t4393 - 0.6e1 * t2837 * t1437 * t2826 + 0.6e1 * t11235 * t9478 + t9321 * t11366 + 0.6e1 * t9462 * t11368 + 0.3e1 * t11378 * t702 - 0.9e1 * t2834 * t6406 - 0.3e1 * t2852 * t6421 - 0.6e1 * t10212 - 0.3e1 * t10232 + 0.3e1 * t10237 + 0.3e1 * t10238 - t2843;
  t11393 = t2848 - t2850 - t3438 + t3442 - t3444 - t3445 - t3446 + t3448 + t2871 + t2882 - t2412 + t2427 - t2428 + t3464 + t3467;
  t11397 = my_piecewise5(t114, 0, t115, 0, t11191 + t11223 + t11246 + t11286 + t11337 + t11363 + t11392 + t11393);
  t11404 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3481 + t11150 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.24e2 * t52 * t275 * t958 + t52 * t308 * t2890 / 0.8e1 + t232 * t3479 + t113 * t11397));
  tv4rholapl37 = t8 * t11404 + t3485;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t11413 = t817 * t817;
  t11414 = t163 * t11413;
  t11419 = t379 * t11413;
  t11422 = t824 * t824;
  t11423 = t163 * t11422;
  t11425 = 0.3e1 * t11423 * t407;
  t11428 = 0.3e1 * t379 * t11422 * t390;
  t11431 = 0.3e1 * t11423 * t405;
  t11439 = t824 * t817;
  t11441 = t379 * t11439 * t403;
  t11442 = t11441 * t1135;
  t11445 = t171 * t8897 * t824;
  t11446 = t2244 * t11445;
  t11448 = t11441 * t1148;
  t11450 = t11413 * t382;
  t11451 = t163 * t11450;
  t11454 = t379 * t11450;
  t11457 = 0.6e1 * t1045 * t11413 * t3560 + t3569 * t11413 * t3575 + 0.11e2 * t11419 * t3564 - 0.18e2 * t11451 * t3596 + 0.18e2 * t11454 * t3626 - t11431 - 0.18e2 * t11442 + 0.18e2 * t11446 - 0.18e2 * t11448 - t826 - t828;
  t11459 = t1056 * t2952;
  t11460 = t2229 * t11459;
  t11462 = t6593 * t3103;
  t11464 = t11413 * t403;
  t11472 = t2269 * t6753;
  t11474 = t1045 * t11450;
  t11478 = t1056 * t1058 * t824;
  t11479 = t2229 * t11478;
  t11481 = t2269 * t11478;
  t11484 = t1051 * t1073 * t824;
  t11485 = t2221 * t11484;
  t11488 = t2269 * t11484;
  t11491 = t1066 * t1069 * t824;
  t11492 = t2269 * t11491;
  t11494 = t2269 * t6689;
  t11498 = t2298 * t6736;
  t11503 = t163 * t11439 * t1664;
  t11509 = t2221 * t11478;
  t11511 = t11413 * t3552;
  t11512 = t1045 * t11511;
  t11515 = -0.6e1 * t11474 * t3618 - 0.18e2 * t11474 * t3626 + 0.18e2 * t11474 * t3636 - 0.12e2 * t11474 * t3645 + 0.12e2 * t11512 * t3810 - 0.18e2 * t11488 - 0.12e2 * t11492 + 0.18e2 * t11494 + 0.18e2 * t11498 + 0.18e2 * t11503 + 0.18e2 * t11509;
  t11522 = t2269 * t6850;
  t11524 = t3569 * t11511;
  t11527 = t379 * t11511;
  t11543 = t11413 * t3543;
  t11547 = t163 * t11511;
  t11554 = t11422 * t382;
  t11555 = t379 * t11554;
  t11557 = 0.3e1 * t11555 * t396;
  t11560 = 0.3e1 * t163 * t11554 * t396;
  t11562 = 0.3e1 * t11555 * t413;
  t11569 = 0.3e1 * t163 * t11543 * t396 - 0.18e2 * t11512 * t3696 - 0.7e1 * t11524 * t3705 + 0.7e1 * t11524 * t3739 - 0.6e1 * t11524 * t3788 - 0.7e1 * t11527 * t3705 - 0.11e2 * t11527 * t3766 + 0.11e2 * t11547 * t3766 - t11557 + t11560 - t11562;
  t11585 = t379 * t11543;
  t11593 = t2221 * t6837;
  t11597 = t6662 * t3055;
  t11608 = -0.12e2 * t163 * t11464 * t3780 - 0.6e1 * t11512 * t3723 - 0.12e2 * t11512 * t3788 - 0.18e2 * t11593 - 0.12e2 * t11597 - 0.4e1 * t2950 + 0.4e1 * t2954 - 0.4e1 * t2956 - 0.4e1 * t2958 + 0.4e1 * t2961 - 0.4e1 * t2963;
  t11612 = my_piecewise5(t64, 0, t67, 0, t11457 - 0.18e2 * t11460 + 0.18e2 * t11462 + 0.18e2 * t11472 - 0.6e1 * t11479 - 0.6e1 * t11481 + 0.18e2 * t11485 + t11515 + 0.3e1 * t11419 * t3545 - 0.6e1 * t11451 * t3618 + 0.18e2 * t11454 * t3618 + 0.18e2 * t11474 * t3656 + 0.3e1 * t11414 * t3549 + 0.6e1 * t11414 * t3556 - 0.12e2 * t11524 * t3810 + 0.11e2 * t11524 * t3710 - 0.6e1 * t11474 * t3754 - 0.6e1 * t11524 * t3734 + 0.7e1 * t11527 * t3696 - 0.11e2 * t11527 * t3739 + 0.18e2 * t11524 * t3723 - 0.18e2 * t11454 * t3690 - 0.3e1 * t11585 * t396 - 0.3e1 * t11585 * t413 + t11547 * t3802 - 0.7e1 * t11527 * t3802 + 0.6e1 * t11512 * t3802 - t11524 * t3802 + 0.6e1 * t11547 * t3792 - 0.18e2 * t11527 * t3792 + 0.18e2 * t11512 * t3705 + 0.6e1 * t11512 * t3792 - 0.6e1 * t11524 * t3714 + 0.4e1 * t2930 + 0.4e1 * t2922 + 0.4e1 * t2926 - 0.9e1 * t2920 + 0.4e1 * t2911 + t11608 + t11569 - 0.6e1 * t11522 + t11425 + t11428 + 0.18e2 * t379 * t11464 * t3609);
  t11618 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t59 * t11612 + 0.4e1 * t260 * t2967));
  tv4sigma40 = t8 * t11618;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t11626 = t843 * t843;
  t11629 = t234 * t11626;
  t11632 = t560 * t11626;
  t11637 = t850 * t850;
  t11638 = t234 * t11637;
  t11640 = 0.3e1 * t11638 * t588;
  t11643 = 0.3e1 * t11638 * t586;
  t11646 = 0.3e1 * t560 * t11637 * t571;
  t11652 = t850 * t843;
  t11654 = t560 * t11652 * t584;
  t11655 = t11654 * t1529;
  t11657 = t11654 * t1521;
  t11660 = t242 * t9217 * t850;
  t11661 = t2388 * t11660;
  t11663 = t11626 * t563;
  t11664 = t234 * t11663;
  t11667 = t11626 * t584;
  t11671 = 0.6e1 * t1425 * t11626 * t4400 + 0.18e2 * t560 * t11667 * t4440 + 0.11e2 * t11632 * t4396 - 0.18e2 * t11664 * t4444 - t11643 + t11646 - 0.18e2 * t11655 - 0.18e2 * t11657 + 0.18e2 * t11661 - t852 - t854;
  t11673 = t7078 * t3169;
  t11675 = t2397 * t7209;
  t11678 = t1432 * t1823 * t850;
  t11679 = t2348 * t11678;
  t11681 = t2397 * t11678;
  t11684 = t1450 * t1453 * t850;
  t11685 = t2397 * t11684;
  t11687 = t2397 * t7110;
  t11689 = t1425 * t11663;
  t11693 = t1437 * t1438 * t850;
  t11694 = t2344 * t11693;
  t11696 = t2348 * t11693;
  t11701 = t560 * t11663;
  t11706 = t1437 * t3027;
  t11707 = t2344 * t11706;
  t11713 = t2448 * t7249;
  t11718 = t234 * t11652 * t1852;
  t11720 = t2397 * t11693;
  t11724 = t11626 * t4368;
  t11725 = t560 * t11724;
  t11728 = -0.6e1 * t11689 * t4419 - 0.18e2 * t11689 * t4425 - 0.12e2 * t11689 * t4429 + 0.18e2 * t11689 * t4452 + 0.18e2 * t11701 * t4419 + 0.18e2 * t11701 * t4425 - 0.18e2 * t11725 * t4620 - 0.18e2 * t11707 + 0.18e2 * t11713 + 0.18e2 * t11718 - 0.6e1 * t11720;
  t11731 = t1425 * t11724;
  t11740 = t4365 * t11724;
  t11758 = t2397 * t7297;
  t11764 = t2348 * t7289;
  t11768 = t11637 * t563;
  t11769 = t560 * t11768;
  t11771 = 0.3e1 * t11769 * t577;
  t11774 = 0.3e1 * t234 * t11768 * t577;
  t11776 = 0.3e1 * t11769 * t594;
  t11779 = -0.12e2 * t11731 * t4587 - 0.6e1 * t11731 * t4590 - 0.6e1 * t11740 * t4530 - 0.7e1 * t11740 * t4541 + 0.11e2 * t11740 * t4555 - 0.6e1 * t11740 * t4559 - 0.6e1 * t11758 - 0.18e2 * t11764 - t11771 + t11774 - t11776;
  t11789 = t1437 * t3144;
  t11790 = t2344 * t11789;
  t11795 = t234 * t11724;
  t11802 = t11626 * t4383;
  t11803 = t560 * t11802;
  t11822 = -0.12e2 * t234 * t11667 * t4514 + 0.3e1 * t234 * t11802 * t577 + 0.11e2 * t11795 * t4594 - 0.3e1 * t11803 * t577 - 0.3e1 * t11803 * t594 - 0.4e1 * t3025 + 0.4e1 * t3029 - 0.4e1 * t3031 - 0.4e1 * t3033 + 0.4e1 * t3036 - 0.4e1 * t3038;
  t11826 = my_piecewise5(t114, 0, t115, 0, 0.4e1 * t3005 + 0.4e1 * t3003 - 0.9e1 * t2995 + 0.4e1 * t2999 + 0.4e1 * t2986 + t11822 - 0.12e2 * t11790 + t11779 + t11728 + 0.18e2 * t11696 - 0.6e1 * t11694 + 0.18e2 * t11687 - 0.12e2 * t11685 + 0.18e2 * t11679 - 0.18e2 * t11681 + 0.18e2 * t11673 + 0.18e2 * t11675 + t11671 + t11640 - t11740 * t4630 + t11795 * t4630 + 0.6e1 * t11795 * t4620 + 0.6e1 * t11731 * t4620 - 0.7e1 * t11725 * t4630 + 0.7e1 * t11725 * t4524 - 0.11e2 * t11725 * t4537 + 0.18e2 * t11740 * t4590 - 0.12e2 * t11740 * t4551 - 0.6e1 * t11740 * t4587 - 0.7e1 * t11725 * t4541 - 0.18e2 * t11731 * t4524 + 0.12e2 * t11731 * t4551 + 0.18e2 * t11731 * t4541 + 0.18e2 * t11689 * t4462 - 0.6e1 * t11664 * t4419 + 0.6e1 * t11629 * t4388 + 0.3e1 * t11632 * t4393 + 0.3e1 * t11629 * t4385 - 0.11e2 * t11725 * t4594 + 0.7e1 * t11740 * t4537 - 0.6e1 * t11689 * t4577 - 0.18e2 * t11701 * t4603 + 0.6e1 * t11731 * t4630 + t4365 * t11626 * t4376);
  t11832 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t11826 + 0.4e1 * t278 * t3042));
  tv4sigma414 = t8 * t11832;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t11838 = t8886 * t2520;
  t11839 = t2519 * t11838;
  t11840 = 0.9e1 * t11839;
  t11841 = t1057 * t2901;
  t11846 = -0.18e2 * t9811 * t11841 * t389 * t403 + t11425 + t11428 - t11431 + t11840 + t2912 + t2923 + t3062 + t3063 - t3359 - t826 - t877 - t8865;
  t11847 = t11841 * t403;
  t11851 = t8941 * t263;
  t11852 = t171 * t11851;
  t11853 = t2524 * t11852;
  t11854 = 0.3e1 * t11853;
  t11855 = t2524 * t11838;
  t11856 = 0.9e1 * t11855;
  t11857 = t2519 * t11852;
  t11858 = 0.9e1 * t11857;
  t11859 = t2508 * t11852;
  t11860 = 0.3e1 * t11859;
  t11861 = t389 * t11851;
  t11862 = t2519 * t11861;
  t11863 = 0.9e1 * t11862;
  t11864 = t298 * t2901;
  t11865 = t11864 * t403;
  t11869 = t379 * t11865;
  t11875 = t2514 * t389 * t9837;
  t11876 = 0.9e1 * t11875;
  t11877 = t2529 * t9646;
  t11878 = 0.9e1 * t11877;
  t11880 = t2508 * t1110 * t11851;
  t11881 = 0.6e1 * t11880;
  t11883 = t394 * t1104 * t824;
  t11884 = t2504 * t11883;
  t11885 = 0.9e1 * t11884;
  t11886 = t2529 * t9578;
  t11887 = 0.9e1 * t11886;
  t11888 = -0.12e2 * t9811 * t1110 * t11847 - 0.18e2 * t163 * t11865 * t3609 + 0.18e2 * t11869 * t3609 + 0.18e2 * t8893 * t5740 - t11854 - t11856 + t11858 - t11860 + t11863 + t11876 + t11878 - t11881 + t11885 + t11887;
  t11890 = t2508 * t11861;
  t11891 = 0.9e1 * t11890;
  t11909 = t8216 * t9823 * t878 * t403;
  t11910 = 0.9e1 * t11909;
  t11912 = t8216 * t4955 * t8916;
  t11913 = 0.9e1 * t11912;
  t11916 = t9838 * t394 * t170 * t3236;
  t11917 = 0.9e1 * t11916;
  t11918 = t170 * t2901;
  t11920 = t3800 * t11918 * params->csk_a;
  t11923 = -0.6e1 * t1045 * t11865 * t4781 - 0.6e1 * t5715 * t171 * t11847 + 0.18e2 * t11869 * t4781 + 0.18e2 * t11869 * t4817 + 0.11e2 * t5793 * t11920 + 0.18e2 * t8893 * t5702 - 0.9e1 * t11442 + 0.9e1 * t11446 - 0.9e1 * t11448 - t11891 - t11910 - t11913 + t11917;
  t11930 = t379 * t11864;
  t11937 = t163 * t11864;
  t11940 = t388 * t3703;
  t11942 = t3695 * t11940 * t2901;
  t11947 = t3791 * t2901 * t74 * t170;
  t11955 = t3800 * t3801 * t2901;
  t11962 = -0.11e2 * t5788 * t3695 * t1073 * t2901 - 0.11e2 * t5788 * t11920 - 0.3e1 * t11930 * t4854 - 0.3e1 * t11930 * t4956 - 0.12e2 * t11937 * t4952 - 0.7e1 * t5788 * t11942 + 0.6e1 * t5755 * t11947 - 0.18e2 * t5788 * t11947 + 0.6e1 * t5793 * t11947 + 0.6e1 * t5755 * t11955 - 0.7e1 * t5788 * t11955 + t5793 * t11955 - t5843 * t11955 - 0.6e1 * t5755 * t8993;
  t11969 = t1936 * t1056 * t878 * t824;
  t11970 = 0.6e1 * t11969;
  t11976 = t1634 * t9737;
  t11977 = 0.9e1 * t11976;
  t11984 = t3704 * t2901 * t1065 * t1068;
  t12000 = -0.6e1 * t5843 * t3708 * t3713 * t2901 - 0.6e1 * t1045 * t8891 * t5840 - 0.18e2 * t379 * t8891 * t5776 + 0.18e2 * t5755 * t11942 + 0.12e2 * t5755 * t11984 - 0.12e2 * t5843 * t11984 - 0.12e2 * t8962 * t5761 + 0.7e1 * t5788 * t9021 - 0.6e1 * t8975 * t5808 + 0.18e2 * t8975 * t5869 + 0.11e2 * t8975 * t5903 - t11970 - t11977;
  t12011 = t1616 * t9717;
  t12012 = 0.3e1 * t12011;
  t12021 = 0.3e1 * t11937 * t4854 - 0.7e1 * t5843 * t11942 - 0.6e1 * t8975 * t5761 + 0.7e1 * t8975 * t5769 - 0.18e2 * t8962 * t5820 - 0.9e1 * t11460 + 0.9e1 * t11462 + 0.9e1 * t11472 - 0.3e1 * t11479 - 0.3e1 * t11481 + 0.9e1 * t11485 - 0.9e1 * t11488 - 0.6e1 * t11492 - t12012;
  t12040 = 0.6e1 * t5793 * t3800 * t11918 + 0.3e1 * t11937 * t3549 + 0.11e2 * t8958 * t5922 + 0.6e1 * t8962 * t5931 + t8975 * t5945 + 0.3e1 * t9086 * t733 + 0.9e1 * t11494 + 0.9e1 * t11498 + 0.9e1 * t11503 + 0.9e1 * t11509 - 0.3e1 * t11522 - t11557 + t11560;
  t12048 = -t11562 - 0.9e1 * t11593 - 0.6e1 * t11597 - 0.4e1 * t3074 - 0.4e1 * t3076 + 0.4e1 * t3081 + 0.4e1 * t3092 + t3096 - t3108 - t3113 + 0.4e1 * t3119 + t2955 - t2957 - t2964;
  t12052 = my_piecewise5(t64, 0, t67, 0, t11846 + t11888 + t11923 + t11962 + t12000 + t12021 + t12040 + t12048);
  t12058 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t2967 / 0.24e2 + 0.3e1 * t260 * t3126 + t59 * t12052));
  tv4sigma3lapl0 = t8 * t12058;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t12064 = t9271 * t2651;
  t12065 = t2642 * t12064;
  t12066 = 0.9e1 * t12065;
  t12067 = t2666 * t12064;
  t12068 = 0.3e1 * t12067;
  t12069 = t3146 + t3147 - t3425 + t2987 - t9193 + t3006 - t903 + t11640 - t11643 + t11646 - t852 + t12066 - t12068;
  t12070 = t9271 * t281;
  t12071 = t570 * t12070;
  t12072 = t2642 * t12071;
  t12073 = 0.9e1 * t12072;
  t12074 = t2656 * t12064;
  t12075 = 0.3e1 * t12074;
  t12076 = t315 * t2976;
  t12077 = t12076 * t584;
  t12081 = t560 * t12077;
  t12089 = t242 * t9194 * t281;
  t12090 = t2656 * t12089;
  t12091 = 0.9e1 * t12090;
  t12093 = t1057 * t2976 * t584;
  t12094 = t570 * t12093;
  t12097 = t2642 * t12089;
  t12098 = 0.9e1 * t12097;
  t12104 = t2635 * t9977;
  t12105 = 0.9e1 * t12104;
  t12107 = t2666 * t1496 * t12070;
  t12108 = 0.6e1 * t12107;
  t12109 = t2635 * t10002;
  t12110 = 0.9e1 * t12109;
  t12111 = -0.18e2 * t234 * t12077 * t4440 - 0.12e2 * t6157 * t1496 * t12093 + 0.18e2 * t12081 * t4440 + 0.18e2 * t6148 * t12094 - 0.18e2 * t6157 * t12094 + 0.18e2 * t9228 * t6184 + 0.18e2 * t9228 * t6211 + t12073 - t12075 - t12091 + t12098 + t12105 - t12108 + t12110;
  t12113 = t2666 * t12071;
  t12114 = 0.9e1 * t12113;
  t12125 = t2629 * t570 * t2824 * t850;
  t12126 = 0.9e1 * t12125;
  t12128 = t575 * t1490 * t850;
  t12129 = t2648 * t12128;
  t12130 = 0.9e1 * t12129;
  t12134 = t2624 * t9267;
  t12135 = t2125 * t12134;
  t12136 = 0.9e1 * t12135;
  t12137 = t6134 * t12134;
  t12138 = 0.9e1 * t12137;
  t12140 = t6134 * t5395 * t9267;
  t12141 = 0.9e1 * t12140;
  t12142 = t241 * t2976;
  t12144 = t4619 * t12142 * params->csk_a;
  t12147 = -0.6e1 * t1425 * t12077 * t5288 - 0.6e1 * t6174 * t242 * t12093 + 0.18e2 * t12081 * t5288 + 0.11e2 * t6256 * t12144 - 0.9e1 * t11655 - 0.9e1 * t11657 + 0.9e1 * t11661 - t12114 + t12126 + t12130 + t12136 - t12138 - t12141;
  t12152 = t4550 * t2976 * t567 * t569;
  t12156 = t4586 * t5412 * t2976;
  t12167 = t7180 * t2976 * t122 * t241;
  t12175 = t4619 * t4629 * t2976;
  t12184 = t2114 * t1437 * t904 * t850;
  t12185 = 0.6e1 * t12184;
  t12186 = -0.11e2 * t6223 * t12144 - 0.7e1 * t6223 * t12152 + 0.18e2 * t6226 * t12152 + 0.12e2 * t6226 * t12156 - 0.18e2 * t6223 * t12167 + 0.6e1 * t6226 * t12167 + 0.6e1 * t6256 * t12167 - 0.7e1 * t6223 * t12175 + 0.6e1 * t6226 * t12175 - t6241 * t12175 + t6256 * t12175 - 0.6e1 * t9298 * t6247 - 0.18e2 * t9295 * t6315 - t12185;
  t12194 = t1822 * t10160;
  t12195 = 0.9e1 * t12194;
  t12212 = t234 * t12076;
  t12215 = t560 * t12076;
  t12220 = -0.6e1 * t6241 * t4528 * t4558 * t2976 - 0.6e1 * t1425 * t9199 * t6352 - 0.7e1 * t6241 * t12152 - 0.12e2 * t6241 * t12156 + 0.3e1 * t12212 * t5399 - 0.3e1 * t12215 * t5396 - 0.3e1 * t12215 * t5399 + 0.7e1 * t6223 * t9343 + 0.7e1 * t9298 * t6238 + 0.18e2 * t9298 * t6286 - 0.6e1 * t9298 * t6324 + 0.11e2 * t9298 * t6344 - t12195;
  t12229 = t1810 * t10164;
  t12230 = 0.3e1 * t12229;
  t12242 = -0.18e2 * t560 * t9199 * t6259 - 0.12e2 * t12212 * t5391 - 0.11e2 * t6223 * t9437 - 0.6e1 * t6226 * t9355 - 0.12e2 * t9295 * t6247 + 0.9e1 * t11673 + 0.9e1 * t11675 + 0.9e1 * t11679 - 0.9e1 * t11681 - 0.6e1 * t11685 + 0.9e1 * t11687 - 0.3e1 * t11694 + 0.9e1 * t11696 - t12230;
  t12262 = 0.6e1 * t6256 * t4619 * t12142 + 0.3e1 * t12212 * t4385 + 0.11e2 * t9288 * t6384 + 0.6e1 * t9295 * t6388 + t9298 * t6393 + 0.3e1 * t9405 * t787 - 0.9e1 * t11707 + 0.9e1 * t11713 + 0.9e1 * t11718 - 0.3e1 * t11720 - 0.3e1 * t11758 - 0.9e1 * t11764 - t11771;
  t12269 = t11774 - t11776 - 0.6e1 * t11790 - 0.4e1 * t3158 - 0.4e1 * t3160 + 0.4e1 * t3165 - t3183 - t3191 + t3198 + 0.4e1 * t3202 + 0.4e1 * t3204 + t3030 - t3032 - t3039;
  t12273 = my_piecewise5(t114, 0, t115, 0, t12069 + t12111 + t12147 + t12186 + t12220 + t12242 + t12262 + t12269);
  t12279 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3042 / 0.24e2 + 0.3e1 * t278 * t3211 + t113 * t12273));
  tv4sigma3lapl19 = t8 * t12279;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t12286 = t2737 * t8886 * t1147;
  t12288 = t2742 * t11445;
  t12292 = t2737 * t389 * t8886 * t167;
  t12297 = 0.18e2 * t8258 * t1110 * t3079 - t10920 + t11425 + t11428 - t11431 - 0.3e1 * t12286 + 0.3e1 * t12288 - 0.3e1 * t12292 - t2921 + t3068 + t3070 + t3228 + t3229 - t826 - t929;
  t12314 = 0.12e2 * t11839 - 0.4e1 * t11853 - 0.12e2 * t11855 + 0.12e2 * t11857 - 0.4e1 * t11859 + 0.12e2 * t11862 + 0.12e2 * t11875 + 0.12e2 * t11877 - 0.8e1 * t11880 + 0.12e2 * t11884 + 0.12e2 * t11886 - 0.12e2 * t11890 - 0.3e1 * t11442 + 0.3e1 * t11446 - 0.3e1 * t11448 - 0.12e2 * t11909;
  t12317 = t3800 * t9522;
  t12327 = t3722 * t3809 * t817;
  t12331 = t3695 * t11940 * t817;
  t12334 = t388 * t817;
  t12335 = t12334 * params->csk_a;
  t12336 = t3695 * t12335;
  t12339 = t3800 * t3085;
  t12344 = t3704 * t3102;
  t12355 = -0.11e2 * t8310 * t12317 + 0.11e2 * t8395 * t12317 - 0.12e2 * t8291 * t12327 + 0.12e2 * t8383 * t12327 - 0.7e1 * t8310 * t12331 + 0.18e2 * t8383 * t12331 - 0.18e2 * t8383 * t12336 - 0.18e2 * t8310 * t12339 + 0.6e1 * t8395 * t12339 - t8291 * t12344 - 0.7e1 * t8310 * t12344 + 0.6e1 * t8383 * t12344 + t8395 * t12344 - 0.12e2 * t6608 * t8361 - 0.6e1 * t6645 * t8361 - 0.12e2 * t11912;
  t12360 = t922 * t817;
  t12381 = t2747 * t6753;
  t12383 = t2729 * t11478;
  t12384 = t2732 * t11478;
  t12386 = t2732 * t11459;
  t12388 = t2747 * t6689;
  t12390 = t2729 * t11459;
  t12392 = t2747 * t11478;
  t12393 = -0.12e2 * t2757 * t1056 * t3054 * t382 - 0.6e1 * t1045 * t820 * t8367 - 0.3e1 * t8412 * t411 * t12335 + 0.3e1 * t163 * t12360 * t4854 - 0.11e2 * t8310 * t3695 * t3097 - 0.7e1 * t8291 * t12331 + 0.6e1 * t8383 * t12339 - 0.6e1 * t8383 * t6642 - 0.3e1 * t8412 * t9523 + 0.3e1 * t12381 - t12383 + 0.3e1 * t12384 + 0.3e1 * t12386 + 0.3e1 * t12388 - 0.3e1 * t12390 - t12392;
  t12398 = t2757 * t11883;
  t12406 = t2747 * t11484;
  t12410 = t2780 * t6736;
  t12414 = t2747 * t11491;
  t12422 = t2732 * t11484;
  t12427 = -0.18e2 * t830 * t1051 * t8305 * t403 - 0.6e1 * t8291 * t3708 * t3713 * t817 + 0.7e1 * t8310 * t12336 - 0.6e1 * t6645 * t8300 + 0.7e1 * t6645 * t8322 + 0.18e2 * t6645 * t8345 + 0.11e2 * t6645 * t8357 + 0.12e2 * t11916 - 0.8e1 * t11969 - 0.12e2 * t11976 + 0.3e1 * t12398 - 0.3e1 * t12406 + 0.3e1 * t12410 - 0.2e1 * t12414 + 0.3e1 * t12422;
  t12442 = -0.4e1 * t12011 - 0.3e1 * t11460 + 0.3e1 * t11462 + 0.3e1 * t11472 - t11479 - t11481 + 0.3e1 * t11485 - 0.3e1 * t11488 - 0.2e1 * t11492 + 0.3e1 * t11494 + 0.3e1 * t11498 + 0.3e1 * t11503 + 0.3e1 * t11509 + 0.4e1 * t3234 - 0.4e1 * t3238 - 0.4e1 * t3241;
  t12444 = t6650 * t2721;
  t12447 = t2729 * t1056 * t3060;
  t12451 = t2732 * t6837;
  t12467 = t171 * t820 * params->csk_a;
  t12470 = 0.3e1 * t379 * t12360 * t3545 + 0.6e1 * t8395 * t3800 * t3054 + 0.3e1 * t8464 * t394 * t3054 - 0.18e2 * t10306 * t12467 + 0.11e2 * t6602 * t8447 + 0.6e1 * t6608 * t8470 + t6645 * t8459 - t11522 - t11557 + t11560 - t11562 - 0.3e1 * t11593 - 0.2e1 * t11597 - t12444 - 0.2e1 * t12447 - 0.3e1 * t12451;
  t12474 = t6497 * t12334 * t403;
  t12480 = t9532 * t403;
  t12481 = t171 * t12480;
  t12495 = -0.12e2 * t8258 * t1110 * t12480 + 0.18e2 * t8258 * t389 * t3079 + 0.18e2 * t8280 * t12467 + 0.18e2 * t8222 * t12474 - 0.18e2 * t8258 * t12474 + 0.18e2 * t8222 * t12481 - 0.6e1 * t8255 * t12481 - 0.6e1 * t8258 * t12481 + t3121 - t3122 - t3123 + 0.4e1 * t3266 + 0.4e1 * t3270 + t3274 - t3275 - t3276;
  t12499 = my_piecewise5(t64, 0, t67, 0, t12297 + t12314 + t12355 + t12393 + t12427 + t12442 + t12470 + t12495);
  t12505 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3126 / 0.12e2 + 0.2e1 * t260 * t3279 + t59 * t12499));
  tv4sigma2lapl20 = t8 * t12505;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t12515 = t3296 + t3297 - t11170 + t3152 - t2996 + t3154 + t11640 - t11643 + t11646 - t852 - t952 + 0.12e2 * t12065 - 0.4e1 * t12067 + 0.12e2 * t12072 - 0.4e1 * t12074;
  t12532 = t4619 * t9936;
  t12535 = 0.11e2 * t8749 * t12532 - 0.12e2 * t7106 * t8717 - 0.3e1 * t11655 - 0.3e1 * t11657 + 0.3e1 * t11661 - 0.12e2 * t12090 + 0.12e2 * t12097 + 0.12e2 * t12104 - 0.8e1 * t12107 + 0.12e2 * t12109 - 0.12e2 * t12113 + 0.12e2 * t12125 + 0.12e2 * t12129 + 0.12e2 * t12135 - 0.12e2 * t12137 - 0.12e2 * t12140;
  t12540 = t4619 * t4629 * t843;
  t12547 = t7180 * t3168;
  t12552 = t7306 * params->csk_a;
  t12553 = t4523 * t12552;
  t12559 = t4586 * t5412 * t843;
  t12563 = t4523 * t4540 * t843;
  t12570 = t2834 * t11678;
  t12578 = -0.6e1 * t8676 * t4528 * t4558 * t843 - 0.11e2 * t8701 * t12532 - t8676 * t12540 - 0.7e1 * t8701 * t12540 + t8749 * t12540 + 0.6e1 * t8759 * t12540 - 0.18e2 * t8701 * t12547 + 0.6e1 * t8749 * t12547 - 0.18e2 * t8759 * t12553 - 0.12e2 * t8676 * t12559 + 0.12e2 * t8759 * t12559 - 0.7e1 * t8676 * t12563 - 0.7e1 * t8701 * t12563 + 0.18e2 * t8759 * t12563 - 0.6e1 * t7067 * t8717 + 0.3e1 * t12570;
  t12580 = t4523 * t1823 * t843;
  t12593 = t2837 * t11693;
  t12594 = t2834 * t11693;
  t12596 = t2852 * t11693;
  t12597 = t2834 * t11706;
  t12599 = t2852 * t7209;
  t12601 = t2837 * t11706;
  t12603 = t2852 * t7110;
  t12605 = t2881 * t12128;
  t12613 = t2852 * t11678;
  t12615 = -0.18e2 * t856 * t1432 * t8696 * t584 - 0.3e1 * t8753 * t592 * t12552 - 0.6e1 * t1425 * t846 * t8729 + 0.7e1 * t8701 * t12553 + 0.7e1 * t8676 * t12580 - 0.11e2 * t8701 * t12580 - 0.6e1 * t8759 * t7145 - t12593 + 0.3e1 * t12594 - t12596 + 0.3e1 * t12597 + 0.3e1 * t12599 - 0.3e1 * t12601 + 0.3e1 * t12603 + 0.3e1 * t12605 - 0.3e1 * t12613;
  t12620 = t2870 * t7249;
  t12624 = t2852 * t11684;
  t12630 = t945 * t843;
  t12646 = -0.12e2 * t2881 * t1437 * t3138 * t563 + 0.3e1 * t234 * t12630 * t5399 + 0.6e1 * t8759 * t12547 + 0.11e2 * t7067 * t8672 - 0.6e1 * t7067 * t8682 + 0.18e2 * t7067 * t8688 - 0.3e1 * t8753 * t9937 + 0.3e1 * t11673 + 0.3e1 * t11675 + 0.3e1 * t11679 - 0.8e1 * t12184 - 0.12e2 * t12194 - 0.4e1 * t12229 + 0.3e1 * t12620 - 0.2e1 * t12624;
  t12657 = t7063 * t2822;
  t12659 = t2837 * t11789;
  t12664 = 0.11e2 * t7086 * t4523 * t8696 + t7067 * t8809 - 0.3e1 * t11681 - 0.2e1 * t11685 + 0.3e1 * t11687 - t11694 + 0.3e1 * t11696 - 0.3e1 * t11707 + 0.3e1 * t11713 + 0.3e1 * t11718 - t11720 - t12657 - 0.2e1 * t12659 - 0.4e1 * t3302 + 0.4e1 * t3306 - 0.4e1 * t3309;
  t12666 = t2834 * t7289;
  t12682 = t242 * t846 * params->csk_a;
  t12690 = t9946 * t584;
  t12691 = t242 * t12690;
  t12696 = 0.3e1 * t560 * t12630 * t4393 + 0.6e1 * t8749 * t4619 * t3138 + 0.3e1 * t8818 * t575 * t3138 + 0.18e2 * t8580 * t570 * t3163 - 0.18e2 * t10648 * t12682 + 0.18e2 * t8631 * t12682 - 0.6e1 * t8583 * t12691 + 0.18e2 * t8586 * t12691 + 0.6e1 * t7106 * t8829 - t11758 - 0.3e1 * t11764 - t11771 + t11774 - t11776 - 0.2e1 * t11790 - 0.3e1 * t12666;
  t12697 = t570 * t12690;
  t12706 = t2842 * t9194 * t1528;
  t12710 = t2842 * t570 * t9194 * t238;
  t12712 = t2847 * t11660;
  t12721 = -0.12e2 * t8580 * t1496 * t12690 + 0.18e2 * t8580 * t1496 * t3163 - 0.6e1 * t8580 * t12691 - 0.18e2 * t8580 * t12697 + 0.18e2 * t8586 * t12697 - 0.3e1 * t12706 - 0.3e1 * t12710 + 0.3e1 * t12712 + t3206 - t3207 - t3208 + 0.4e1 * t3323 + 0.4e1 * t3340 - t3342 - t3343 + t3344;
  t12725 = my_piecewise5(t114, 0, t115, 0, t12515 + t12535 + t12578 + t12615 + t12646 + t12664 + t12696 + t12721);
  t12731 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3211 / 0.12e2 + 0.2e1 * t278 * t3347 + t113 * t12725));
  tv4sigma2lapl217 = t8 * t12731;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t12739 = t8921 * t263;
  t12740 = t171 * t12739;
  t12745 = 0.18e2 * t10937 * t4812 + 0.18e2 * t10945 * t12740 - 0.6e1 * t10954 * t12740 + t11425 + t11428 - t11431 + t2911 - t2920 + t2922 - 0.8e1 * t3067 + t3357 + t3358 - t826 - t929;
  t12749 = -0.9e1 * t12286 + 0.9e1 * t12288 - 0.9e1 * t12292 + t11840 - t11854 - t11856 + t11858 - t11860 + t11863 + t11876 + t11878 - t11881 + t11885 + t11887;
  t12753 = t3704 * t10481;
  t12757 = t3800 * t3801 * t263;
  t12769 = t3800 * t1058 * t263;
  t12779 = t3722 * t3809 * t263;
  t12782 = t10976 * t12757 + 0.6e1 * t10976 * t12769 - 0.7e1 * t10978 * t12753 - 0.7e1 * t10978 * t12757 - 0.18e2 * t10978 * t12769 + 0.18e2 * t10981 * t12753 + 0.6e1 * t10981 * t12757 + 0.12e2 * t10981 * t12779 - 0.18e2 * t10981 * t4924 - 0.7e1 * t10984 * t12753 - t10984 * t12757 - 0.6e1 * t10984 * t4895 + 0.7e1 * t10984 * t5000 - t11891;
  t12812 = -0.12e2 * t3394 * t1056 * t3779 * t263 - 0.6e1 * t10984 * t3708 * t3713 * t263 - 0.6e1 * t1045 * t627 * t11091 + 0.7e1 * t10978 * t4924 - 0.11e2 * t10978 * t5000 - 0.12e2 * t10981 * t4895 - 0.6e1 * t10981 * t5005 - 0.18e2 * t642 * t11014 + 0.11e2 * t4908 * t11023 - 0.6e1 * t4908 * t11031 + 0.18e2 * t4908 * t11045 - 0.3e1 * t11057 * t883 - t11910 - t11913;
  t12817 = t3800 * t872;
  t12824 = t3360 * t263;
  t12838 = 0.3e1 * t163 * t12824 * t4854 + 0.11e2 * t10976 * t12817 - 0.11e2 * t10978 * t12817 + 0.6e1 * t10981 * t12769 - 0.12e2 * t10984 * t12779 - 0.3e1 * t11057 * t873 + 0.9e1 * t12381 - 0.3e1 * t12383 + 0.9e1 * t12384 + 0.9e1 * t12386 + 0.9e1 * t12388 - 0.9e1 * t12390 - 0.3e1 * t12392 + 0.9e1 * t12398;
  t12844 = t171 * t9858 * t263;
  t12850 = -0.18e2 * t10922 * t12844 + 0.18e2 * t10925 * t12844 + t4908 * t11107 + t11917 - t11970 - t11977 - t12012 - 0.9e1 * t12406 + 0.9e1 * t12410 - 0.6e1 * t12414 + 0.9e1 * t12422 + t3234 - t3238 - t3241;
  t12867 = t6497 * t1657;
  t12875 = -0.12e2 * t10937 * t1110 * t12739 + 0.6e1 * t10976 * t3800 * t878 + 0.3e1 * t379 * t12824 * t3545 - 0.6e1 * t10937 * t12740 - 0.18e2 * t10937 * t12867 + 0.6e1 * t4873 * t11100 + 0.11e2 * t4870 * t11112 + 0.3e1 * t11120 * t879 - t11557 + t11560 - t11562 - 0.3e1 * t12444 - 0.6e1 * t12447 - 0.9e1 * t12451;
  t12880 = 0.18e2 * t10937 * t4829 + 0.18e2 * t10945 * t12867 + t2954 - t2956 - t2963 + t3266 + t3270 + t3372 - t3376 - t3378 + t3379 - t3380 - t3382 + t3396 + t3399;
  t12884 = my_piecewise5(t64, 0, t67, 0, t12745 + t12749 + t12782 + t12812 + t12838 + t12850 + t12875 + t12880);
  t12890 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3279 / 0.8e1 + t260 * t3413 + t59 * t12884));
  tv4sigmalapl30 = t8 * t12890;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t12896 = t2643 * t584;
  t12900 = 0.18e2 * t11199 * t570 * t12896 + t11640 - t11643 + t11646 + t12066 - t12068 + t2986 - t2995 + t3005 - 0.8e1 * t3151 + t3423 + t3424 - t852 - t952;
  t12903 = t4550 * t2651;
  t12906 = t7180 * t2651;
  t12911 = -0.6e1 * t11238 * t5436 + 0.6e1 * t11241 * t12903 + 0.6e1 * t11241 * t12906 - 0.18e2 * t11247 * t12906 + t12073 - t12075 - t12091 + t12098 + t12105 - t12108 + t12110 - t12114 + t12126 + t12130;
  t12913 = t4550 * t3319;
  t12917 = t4586 * t5412 * t281;
  t12932 = t4619 * t898;
  t12935 = t3426 * t281;
  t12945 = 0.3e1 * t234 * t12935 * t5399 + t11235 * t12903 + 0.6e1 * t11235 * t12906 + 0.11e2 * t11235 * t12932 - t11238 * t12903 - 0.7e1 * t11238 * t12913 + 0.18e2 * t11241 * t12913 + 0.12e2 * t11241 * t12917 - 0.12e2 * t11241 * t5436 - 0.7e1 * t11247 * t12903 - 0.7e1 * t11247 * t12913 + 0.7e1 * t11247 * t5451 - 0.11e2 * t11247 * t5459 - 0.18e2 * t11333 * t5519;
  t12977 = -0.6e1 * t11238 * t4528 * t4558 * t281 - 0.12e2 * t3465 * t1437 * t4513 * t281 - 0.6e1 * t1425 * t689 * t11303 - 0.12e2 * t11238 * t12917 - 0.6e1 * t11241 * t5506 - 0.11e2 * t11247 * t12932 - 0.18e2 * t5384 * t11269 + 0.7e1 * t5422 * t11290 + 0.18e2 * t5422 * t11307 + 0.11e2 * t5422 * t11318 - 0.6e1 * t5422 * t11326 - 0.3e1 * t11341 * t899 - 0.3e1 * t11341 * t909 + t12136;
  t12992 = -t12138 - t12141 + 0.9e1 * t12570 - 0.3e1 * t12593 + 0.9e1 * t12594 - 0.3e1 * t12596 + 0.9e1 * t12597 + 0.9e1 * t12599 - 0.9e1 * t12601 + 0.9e1 * t12603 + 0.9e1 * t12605 - 0.9e1 * t12613 + 0.9e1 * t12620 - 0.6e1 * t12624;
  t12997 = t242 * t10245 * t281;
  t13000 = t11187 * t2651;
  t13017 = -0.18e2 * t11186 * t11187 * t3319 - 0.12e2 * t11194 * t1496 * t12896 - 0.6e1 * t11210 * t242 * t12896 + 0.18e2 * t10712 * t11183 + 0.18e2 * t11172 * t12997 + 0.18e2 * t11172 * t13000 - 0.18e2 * t11175 * t12997 - 0.6e1 * t11186 * t13000 + 0.18e2 * t11194 * t5363 - t12185 - t12195 - t12230 - t3302 + t3306;
  t13036 = 0.6e1 * t11235 * t4619 * t904 + 0.3e1 * t560 * t12935 * t4393 + 0.11e2 * t11247 * t5581 + t5422 * t11366 + 0.6e1 * t5384 * t11368 + 0.3e1 * t11378 * t905 - t11771 + t11774 - t11776 - 0.3e1 * t12657 - 0.6e1 * t12659 - 0.9e1 * t12666 - 0.9e1 * t12706 - t3309;
  t13039 = -0.9e1 * t12710 + 0.9e1 * t12712 - t3438 + t3442 - t3444 + t3323 + t3340 - t3445 - t3446 + t3448 + t3029 - t3031 - t3038 + t3464 + t3467;
  t13043 = my_piecewise5(t114, 0, t115, 0, t12900 + t12911 + t12945 + t12977 + t12992 + t13017 + t13036 + t13039);
  t13049 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3347 / 0.8e1 + t278 * t3479 + t113 * t13043));
  tv4sigmalapl311 = t8 * t13049;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t13056 = t922 * t922;
  t13062 = t163 * t13056;
  t13065 = t379 * t13056;
  t13076 = t13056 * t403;
  t13077 = t163 * t13076;
  t13083 = t13056 * t382;
  t13084 = t1045 * t13083;
  t13090 = 0.18e2 * t379 * t13076 * t3609 - 0.6e1 * t163 * t13083 * t3618 - 0.18e2 * t13077 * t3609 + 0.18e2 * t13084 * t3656 + t11428 - t11431 - 0.18e2 * t12286 + 0.18e2 * t12288 - 0.18e2 * t12292 - t826 - t929;
  t13092 = t379 * t13083;
  t13118 = t13056 * t3552;
  t13119 = t1045 * t13118;
  t13122 = t3569 * t13118;
  t13124 = t163 * t13118;
  t13127 = 0.6e1 * t13119 * t3802 - t13122 * t3802 + 0.6e1 * t13124 * t3792 + 0.18e2 * t12388 - 0.18e2 * t12390 - 0.6e1 * t12392 + 0.18e2 * t12398 - 0.18e2 * t12406 + 0.18e2 * t12410 - 0.12e2 * t12414 + 0.18e2 * t12422;
  t13130 = t379 * t13118;
  t13153 = t13056 * t3543;
  t13154 = t379 * t13153;
  t13175 = -0.12e2 * t13077 * t3780 - 0.6e1 * t13084 * t3754 - 0.18e2 * t13092 * t3690 + 0.11e2 * t13122 * t3710 - 0.6e1 * t13122 * t3714 + 0.18e2 * t13122 * t3723 - 0.12e2 * t13122 * t3810 + 0.11e2 * t13124 * t3766 + 0.7e1 * t13130 * t3696 - 0.11e2 * t13130 * t3766 - 0.3e1 * t13154 * t413;
  t13204 = -t11557 + t11560 - t11562 + 0.4e1 * t3371 - 0.4e1 * t3375 - 0.4e1 * t3377 + 0.4e1 * t3096 - 0.4e1 * t3108 - 0.4e1 * t3113 + 0.4e1 * t3395 + 0.4e1 * t3398;
  t13208 = my_piecewise5(t64, 0, t67, 0, -0.9e1 * t3067 + 0.4e1 * t3062 + 0.4e1 * t3063 + t13090 - 0.7e1 * t13130 * t3802 + 0.18e2 * t13092 * t3618 - 0.6e1 * t13084 * t3618 - 0.12e2 * t13084 * t3645 + 0.18e2 * t13084 * t3636 + 0.18e2 * t13092 * t3626 - 0.18e2 * t13084 * t3626 + 0.3e1 * t13062 * t3549 + 0.11e2 * t13065 * t3564 + 0.6e1 * t13062 * t3556 + 0.3e1 * t13065 * t3545 + 0.6e1 * t13119 * t3792 - 0.3e1 * t13154 * t396 - 0.6e1 * t13119 * t3723 - 0.12e2 * t13119 * t3788 - 0.11e2 * t13130 * t3739 - 0.6e1 * t13122 * t3734 + 0.18e2 * t13119 * t3705 + 0.12e2 * t13119 * t3810 - 0.7e1 * t13130 * t3705 - 0.18e2 * t13119 * t3696 + 0.7e1 * t13122 * t3739 - 0.7e1 * t13122 * t3705 - 0.18e2 * t13130 * t3792 - 0.6e1 * t13122 * t3788 + t13124 * t3802 - 0.18e2 * t12451 - 0.6e1 * t12444 - 0.12e2 * t12447 - 0.6e1 * t12383 + 0.18e2 * t12384 + 0.18e2 * t12386 + 0.18e2 * t12381 + t13204 + t13175 + t13127 + t11425 + 0.6e1 * t1045 * t13056 * t3560 + t3569 * t13056 * t3575 + 0.3e1 * t163 * t13153 * t396);
  t13214 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3413 / 0.6e1 + t59 * t13208));
  tv4lapl40 = t8 * t13214;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t13221 = t945 * t945;
  t13222 = t560 * t13221;
  t13227 = t234 * t13221;
  t13238 = t13221 * t563;
  t13242 = t13221 * t584;
  t13243 = t560 * t13242;
  t13246 = t1425 * t13242;
  t13249 = t234 * t13242;
  t13252 = t1425 * t13238;
  t13259 = -0.6e1 * t234 * t13238 * t4419 + 0.18e2 * t13243 * t4440 + 0.18e2 * t13243 * t5288 - 0.6e1 * t13246 * t5288 - 0.18e2 * t13249 * t4440 - 0.12e2 * t13252 * t4429 + 0.18e2 * t13252 * t4462 - t11643 + t11646 - t852 - t952;
  t13265 = t560 * t13238;
  t13281 = t13221 * t4368;
  t13282 = t560 * t13281;
  t13285 = t234 * t13281;
  t13288 = t4365 * t13281;
  t13291 = t1425 * t13281;
  t13296 = -0.7e1 * t13282 * t4630 + 0.6e1 * t13285 * t4620 + t13285 * t4630 - 0.6e1 * t13288 * t4587 - t13288 * t4630 + 0.6e1 * t13291 * t4630 + 0.18e2 * t12603 + 0.18e2 * t12605 - 0.18e2 * t12613 + 0.18e2 * t12620 - 0.12e2 * t12624;
  t13311 = t13221 * t4383;
  t13326 = t560 * t13311;
  t13345 = -0.12e2 * t13249 * t4514 - 0.6e1 * t13252 * t4577 - 0.18e2 * t13265 * t4603 + 0.7e1 * t13282 * t4524 - 0.11e2 * t13282 * t4594 + 0.11e2 * t13285 * t4594 + 0.7e1 * t13288 * t4537 + 0.18e2 * t13288 * t4590 - 0.18e2 * t13291 * t4524 - 0.3e1 * t13326 * t577 - 0.3e1 * t13326 * t594;
  t13370 = -0.18e2 * t12706 - 0.18e2 * t12710 + 0.18e2 * t12712 - 0.4e1 * t3437 + 0.4e1 * t3441 - 0.4e1 * t3443 - 0.4e1 * t3183 - 0.4e1 * t3191 + 0.4e1 * t3198 + 0.4e1 * t3463 + 0.4e1 * t3466;
  t13374 = my_piecewise5(t114, 0, t115, 0, -0.12e2 * t13288 * t4551 - 0.7e1 * t13282 * t4541 - 0.7e1 * t13288 * t4541 - 0.6e1 * t13291 * t4590 - 0.12e2 * t13291 * t4587 - 0.11e2 * t13282 * t4537 - 0.18e2 * t13282 * t4620 + 0.6e1 * t13291 * t4620 + 0.18e2 * t13291 * t4541 + 0.12e2 * t13291 * t4551 - 0.18e2 * t13246 * t5331 + 0.18e2 * t13252 * t4452 + 0.18e2 * t13265 * t4425 + 0.3e1 * t13222 * t4393 + 0.11e2 * t13222 * t4396 + 0.3e1 * t13227 * t4385 + 0.6e1 * t13227 * t4388 + 0.11e2 * t13288 * t4555 - 0.6e1 * t13288 * t4559 - 0.6e1 * t13288 * t4530 + t13345 + 0.4e1 * t3147 - 0.9e1 * t3151 + t11774 - t11776 - t11771 + 0.4e1 * t3146 - 0.18e2 * t12666 - 0.12e2 * t12659 - 0.6e1 * t12657 + t11640 + 0.18e2 * t12599 - 0.18e2 * t12601 + 0.18e2 * t12594 - 0.6e1 * t12596 + 0.18e2 * t12597 - 0.6e1 * t12593 + 0.18e2 * t12570 + t13296 + t13259 + t13370 + t4365 * t13221 * t4376 + 0.6e1 * t1425 * t13221 * t4400 + 0.3e1 * t234 * t13311 * t577);
  t13380 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3479 / 0.6e1 + t113 * t13374));
  tv4lapl44 = t8 * t13380;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

