/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_rpbe.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t20, t21, t22, t23;
  double t24, t25, t27, t28, t29, t30, t31, t33;
  double t34, t39, t42, t46, tzk0;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t20 = M_CBRT6;
  t21 = params->rpbe_mu * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t34 = 0.1e1 / params->rpbe_kappa;
  t39 = exp(-t21 * t25 * t29 * t33 * t34 / 0.24e2);
  t42 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t39);
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t20, t21, t22, t23;
  double t24, t25, t27, t28, t29, t30, t31, t33;
  double t34, t39, t42, t46, tzk0;

  double t52, t55, t59, t60, t64, tvrho0, t72, t73;
  double t76, tvsigma0;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t20 = M_CBRT6;
  t21 = params->rpbe_mu * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t34 = 0.1e1 / params->rpbe_kappa;
  t39 = exp(-t21 * t25 * t29 * t33 * t34 / 0.24e2);
  t42 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t39);
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = t30 * rho[0];
  t55 = t17 / t18 / t52;
  t59 = t29 * t39;
  t60 = t20 * t25 * t59;
  t64 = my_piecewise3(t2, 0, -t6 * t17 / t31 * t42 / 0.8e1 + t6 * t55 * params->rpbe_mu * t60 / 0.24e2);
  tvrho0 = 0.2e1 * rho[0] * t64 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t25 * t28 * t39;
  t73 = t21 * t72;
  t76 = my_piecewise3(t2, 0, -t6 * t17 / t18 / t30 * t73 / 0.64e2);
  tvsigma0 = 0.2e1 * rho[0] * t76;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t20, t21, t22, t23;
  double t24, t25, t27, t28, t29, t30, t31, t33;
  double t34, t39, t42, t46, tzk0;

  double t52, t55, t59, t60, t64, tvrho0, t72, t73;
  double t76, tvsigma0;

  double t85, t88, t93, t96, t98, t99, t102, t103;
  double t106, t107, t111, tv2rho20, t117, t121, t125, t129;
  double tv2rhosigma0, t132, t137, t140, tv2sigma20;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t20 = M_CBRT6;
  t21 = params->rpbe_mu * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t34 = 0.1e1 / params->rpbe_kappa;
  t39 = exp(-t21 * t25 * t29 * t33 * t34 / 0.24e2);
  t42 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t39);
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = t30 * rho[0];
  t55 = t17 / t18 / t52;
  t59 = t29 * t39;
  t60 = t20 * t25 * t59;
  t64 = my_piecewise3(t2, 0, -t6 * t17 / t31 * t42 / 0.8e1 + t6 * t55 * params->rpbe_mu * t60 / 0.24e2);
  tvrho0 = 0.2e1 * rho[0] * t64 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t25 * t28 * t39;
  t73 = t21 * t72;
  t76 = my_piecewise3(t2, 0, -t6 * t17 / t18 / t30 * t73 / 0.64e2);
  tvsigma0 = 0.2e1 * rho[0] * t76;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t30 * t30;
  t88 = t17 / t18 / t85;
  t93 = t85 * t52;
  t96 = params->rpbe_mu * params->rpbe_mu;
  t98 = t6 * t17 / t93 * t96;
  t99 = t20 * t20;
  t102 = t99 / t23 / t22;
  t103 = sigma[0] * sigma[0];
  t106 = t27 * t34 * t39;
  t107 = t102 * t103 * t106;
  t111 = my_piecewise3(t2, 0, t6 * t17 / t31 / rho[0] * t42 / 0.12e2 - t6 * t88 * params->rpbe_mu * t60 / 0.8e1 + t98 * t107 / 0.108e3);
  tv2rho20 = 0.2e1 * rho[0] * t111 + 0.4e1 * t64;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t117 = t85 * t30;
  t121 = t6 * t17 / t117 * t96;
  t125 = t102 * t27 * sigma[0] * t34 * t39;
  t129 = my_piecewise3(t2, 0, 0.7e1 / 0.192e3 * t6 * t55 * t73 - t121 * t125 / 0.288e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t129 + 0.2e1 * t76;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t132 = t85 * rho[0];
  t137 = t102 * t106;
  t140 = my_piecewise3(t2, 0, t6 * t17 / t132 * t96 * t137 / 0.768e3);
  tv2sigma20 = 0.2e1 * rho[0] * t140;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t20, t21, t22, t23;
  double t24, t25, t27, t28, t29, t30, t31, t33;
  double t34, t39, t42, t46, tzk0;

  double t52, t55, t59, t60, t64, tvrho0, t72, t73;
  double t76, tvsigma0;

  double t85, t88, t93, t96, t98, t99, t102, t103;
  double t106, t107, t111, tv2rho20, t117, t121, t125, t129;
  double tv2rhosigma0, t132, t137, t140, tv2sigma20;

  double t149, t154, t158, t161, t164, t165, t169, t170;
  double t171, t173, t174, t175, t176, t180, tv3rho30, t189;
  double t193, t195, t199, tv3rho2sigma0, t205, t210, t214, tv3rhosigma20;
  double t217, t224, tv3sigma30;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t20 = M_CBRT6;
  t21 = params->rpbe_mu * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t34 = 0.1e1 / params->rpbe_kappa;
  t39 = exp(-t21 * t25 * t29 * t33 * t34 / 0.24e2);
  t42 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t39);
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = t30 * rho[0];
  t55 = t17 / t18 / t52;
  t59 = t29 * t39;
  t60 = t20 * t25 * t59;
  t64 = my_piecewise3(t2, 0, -t6 * t17 / t31 * t42 / 0.8e1 + t6 * t55 * params->rpbe_mu * t60 / 0.24e2);
  tvrho0 = 0.2e1 * rho[0] * t64 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t25 * t28 * t39;
  t73 = t21 * t72;
  t76 = my_piecewise3(t2, 0, -t6 * t17 / t18 / t30 * t73 / 0.64e2);
  tvsigma0 = 0.2e1 * rho[0] * t76;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t30 * t30;
  t88 = t17 / t18 / t85;
  t93 = t85 * t52;
  t96 = params->rpbe_mu * params->rpbe_mu;
  t98 = t6 * t17 / t93 * t96;
  t99 = t20 * t20;
  t102 = t99 / t23 / t22;
  t103 = sigma[0] * sigma[0];
  t106 = t27 * t34 * t39;
  t107 = t102 * t103 * t106;
  t111 = my_piecewise3(t2, 0, t6 * t17 / t31 / rho[0] * t42 / 0.12e2 - t6 * t88 * params->rpbe_mu * t60 / 0.8e1 + t98 * t107 / 0.108e3);
  tv2rho20 = 0.2e1 * rho[0] * t111 + 0.4e1 * t64;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t117 = t85 * t30;
  t121 = t6 * t17 / t117 * t96;
  t125 = t102 * t27 * sigma[0] * t34 * t39;
  t129 = my_piecewise3(t2, 0, 0.7e1 / 0.192e3 * t6 * t55 * t73 - t121 * t125 / 0.288e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t129 + 0.2e1 * t76;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t132 = t85 * rho[0];
  t137 = t102 * t106;
  t140 = my_piecewise3(t2, 0, t6 * t17 / t132 * t96 * t137 / 0.768e3);
  tv2sigma20 = 0.2e1 * rho[0] * t140;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t149 = t17 / t18 / t132;
  t154 = t85 * t85;
  t158 = t6 * t17 / t154 * t96;
  t161 = t22 * t22;
  t164 = t3 / t4 / t161;
  t165 = t154 * t30;
  t169 = t164 * t17 / t31 / t165;
  t170 = t96 * params->rpbe_mu;
  t171 = t103 * sigma[0];
  t173 = params->rpbe_kappa * params->rpbe_kappa;
  t174 = 0.1e1 / t173;
  t175 = t174 * t39;
  t176 = t170 * t171 * t175;
  t180 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t33 * t42 + 0.115e3 / 0.216e3 * t6 * t149 * params->rpbe_mu * t60 - 0.5e1 / 0.54e2 * t158 * t107 + t169 * t176 / 0.81e2);
  tv3rho30 = 0.2e1 * rho[0] * t180 + 0.6e1 * t111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t189 = t154 * rho[0];
  t193 = t164 * t17 / t31 / t189;
  t195 = t170 * t103 * t175;
  t199 = my_piecewise3(t2, 0, -0.35e2 / 0.288e3 * t6 * t88 * t73 + 0.25e2 / 0.864e3 * t98 * t125 - t193 * t195 / 0.216e3);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t199 + 0.4e1 * t129;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t205 = 0.1e1 / t31 / t154;
  t210 = t170 * t174 * sigma[0] * t39;
  t214 = my_piecewise3(t2, 0, -0.5e1 / 0.768e3 * t121 * t137 + t164 * t17 * t205 * t210 / 0.576e3);
  tv3rhosigma20 = 0.2e1 * rho[0] * t214 + 0.2e1 * t140;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t217 = t164 * t17;
  t224 = my_piecewise3(t2, 0, -t217 / t31 / t93 * t170 * t175 / 0.1536e4);
  tv3sigma30 = 0.2e1 * rho[0] * t224;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t20, t21, t22, t23;
  double t24, t25, t27, t28, t29, t30, t31, t33;
  double t34, t39, t42, t46, tzk0;

  double t52, t55, t59, t60, t64, tvrho0, t72, t73;
  double t76, tvsigma0;

  double t85, t88, t93, t96, t98, t99, t102, t103;
  double t106, t107, t111, tv2rho20, t117, t121, t125, t129;
  double tv2rhosigma0, t132, t137, t140, tv2sigma20;

  double t149, t154, t158, t161, t164, t165, t169, t170;
  double t171, t173, t174, t175, t176, t180, tv3rho30, t189;
  double t193, t195, t199, tv3rho2sigma0, t205, t210, t214, tv3rhosigma20;
  double t217, t224, tv3sigma30;

  double t246, t257, t260, t262, t269, tv4rho40, t292, tv4rho3sigma0;
  double t312, tv4rho2sigma20, t324, t330, tv4rhosigma30, t341, tv4sigma40;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t20 = M_CBRT6;
  t21 = params->rpbe_mu * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t34 = 0.1e1 / params->rpbe_kappa;
  t39 = exp(-t21 * t25 * t29 * t33 * t34 / 0.24e2);
  t42 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t39);
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = t30 * rho[0];
  t55 = t17 / t18 / t52;
  t59 = t29 * t39;
  t60 = t20 * t25 * t59;
  t64 = my_piecewise3(t2, 0, -t6 * t17 / t31 * t42 / 0.8e1 + t6 * t55 * params->rpbe_mu * t60 / 0.24e2);
  tvrho0 = 0.2e1 * rho[0] * t64 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t25 * t28 * t39;
  t73 = t21 * t72;
  t76 = my_piecewise3(t2, 0, -t6 * t17 / t18 / t30 * t73 / 0.64e2);
  tvsigma0 = 0.2e1 * rho[0] * t76;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t30 * t30;
  t88 = t17 / t18 / t85;
  t93 = t85 * t52;
  t96 = params->rpbe_mu * params->rpbe_mu;
  t98 = t6 * t17 / t93 * t96;
  t99 = t20 * t20;
  t102 = t99 / t23 / t22;
  t103 = sigma[0] * sigma[0];
  t106 = t27 * t34 * t39;
  t107 = t102 * t103 * t106;
  t111 = my_piecewise3(t2, 0, t6 * t17 / t31 / rho[0] * t42 / 0.12e2 - t6 * t88 * params->rpbe_mu * t60 / 0.8e1 + t98 * t107 / 0.108e3);
  tv2rho20 = 0.2e1 * rho[0] * t111 + 0.4e1 * t64;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t117 = t85 * t30;
  t121 = t6 * t17 / t117 * t96;
  t125 = t102 * t27 * sigma[0] * t34 * t39;
  t129 = my_piecewise3(t2, 0, 0.7e1 / 0.192e3 * t6 * t55 * t73 - t121 * t125 / 0.288e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t129 + 0.2e1 * t76;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t132 = t85 * rho[0];
  t137 = t102 * t106;
  t140 = my_piecewise3(t2, 0, t6 * t17 / t132 * t96 * t137 / 0.768e3);
  tv2sigma20 = 0.2e1 * rho[0] * t140;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t149 = t17 / t18 / t132;
  t154 = t85 * t85;
  t158 = t6 * t17 / t154 * t96;
  t161 = t22 * t22;
  t164 = t3 / t4 / t161;
  t165 = t154 * t30;
  t169 = t164 * t17 / t31 / t165;
  t170 = t96 * params->rpbe_mu;
  t171 = t103 * sigma[0];
  t173 = params->rpbe_kappa * params->rpbe_kappa;
  t174 = 0.1e1 / t173;
  t175 = t174 * t39;
  t176 = t170 * t171 * t175;
  t180 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t33 * t42 + 0.115e3 / 0.216e3 * t6 * t149 * params->rpbe_mu * t60 - 0.5e1 / 0.54e2 * t158 * t107 + t169 * t176 / 0.81e2);
  tv3rho30 = 0.2e1 * rho[0] * t180 + 0.6e1 * t111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t189 = t154 * rho[0];
  t193 = t164 * t17 / t31 / t189;
  t195 = t170 * t103 * t175;
  t199 = my_piecewise3(t2, 0, -0.35e2 / 0.288e3 * t6 * t88 * t73 + 0.25e2 / 0.864e3 * t98 * t125 - t193 * t195 / 0.216e3);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t199 + 0.4e1 * t129;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t205 = 0.1e1 / t31 / t154;
  t210 = t170 * t174 * sigma[0] * t39;
  t214 = my_piecewise3(t2, 0, -0.5e1 / 0.768e3 * t121 * t137 + t164 * t17 * t205 * t210 / 0.576e3);
  tv3rhosigma20 = 0.2e1 * rho[0] * t214 + 0.2e1 * t140;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t217 = t164 * t17;
  t224 = my_piecewise3(t2, 0, -t217 / t31 / t93 * t170 * t175 / 0.1536e4);
  tv3sigma30 = 0.2e1 * rho[0] * t224;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t246 = t154 * t52;
  t257 = t96 * t96;
  t260 = t103 * t103;
  t262 = 0.1e1 / t173 / params->rpbe_kappa;
  t269 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 / t31 / t52 * t42 - 0.305e3 / 0.108e3 * t6 * t17 / t18 / t117 * params->rpbe_mu * t60 + 0.835e3 / 0.972e3 * t6 * t17 / t189 * t96 * t107 - 0.62e2 / 0.243e3 * t164 * t17 / t31 / t246 * t176 + t164 * t17 / t18 / t154 / t117 * t257 * t260 * t262 * t20 * t72 / 0.729e3);
  tv4rho40 = 0.2e1 * rho[0] * t269 + 0.8e1 * t180;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t292 = my_piecewise3(t2, 0, 0.455e3 / 0.864e3 * t6 * t149 * t73 - 0.595e3 / 0.2592e4 * t158 * t125 + t169 * t195 / 0.12e2 - t164 * t17 / t18 / t154 / t132 * t257 * t171 * t262 * t20 * t72 / 0.1944e4);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t292 + 0.6e1 * t199;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t312 = my_piecewise3(t2, 0, 0.5e1 / 0.128e3 * t98 * t137 - 0.41e2 / 0.1728e4 * t193 * t210 + t164 * t17 / t18 / t154 / t85 * t257 * t262 * t103 * t20 * t72 / 0.5184e4);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t312 + 0.4e1 * t214;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t324 = t262 * t20;
  t330 = my_piecewise3(t2, 0, 0.23e2 / 0.4608e4 * t217 * t205 * t170 * t175 - t164 * t17 / t18 / t246 * t257 * t324 * t25 * t59 / 0.13824e5);
  tv4rhosigma30 = 0.2e1 * rho[0] * t330 + 0.2e1 * t224;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t341 = my_piecewise3(t2, 0, t164 * t17 / t18 / t165 * t257 * t324 * t72 / 0.36864e5);
  tv4sigma40 = 0.2e1 * rho[0] * t341;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t41;
  double t45, t48, t52, t53, t54, t56, t57, t58;
  double t59, t61, t62, t63, t64, t65, t67, t72;
  double t75, t79, tzk0;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->rpbe_mu * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t41 = 0.1e1 / params->rpbe_kappa;
  t45 = exp(-t34 * sigma[0] * t39 * t41 / 0.24e2);
  t48 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t45);
  t52 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t48);
  t53 = rho[1] <= p->dens_threshold;
  t54 = -t16;
  t56 = my_piecewise5(t14, t11, t10, t15, t54 * t7);
  t57 = 0.1e1 + t56;
  t58 = t57 <= p->zeta_threshold;
  t59 = POW_1_3(t57);
  t61 = my_piecewise3(t58, t22, t59 * t57);
  t62 = t61 * t26;
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t72 = exp(-t34 * sigma[2] * t67 * t41 / 0.24e2);
  t75 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t72);
  t79 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t62 * t75);
  tzk0 = t52 + t79;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t41;
  double t45, t48, t52, t53, t54, t56, t57, t58;
  double t59, t61, t62, t63, t64, t65, t67, t72;
  double t75, t79, tzk0;

  double t80, t81, t82, t84, t87, t88, t92, t93;
  double t94, t97, t99, t100, t101, t103, t106, t110;
  double t111, t113, t116, t117, t121, t124, t126, tvrho0;
  double t130, t133, t134, t139, t141, t144, t145, t150;
  double t151, t153, t156, t160, tvrho1, t163, t166, t169;
  double tvsigma0, tvsigma1, t170, t173, t176, tvsigma2;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->rpbe_mu * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t41 = 0.1e1 / params->rpbe_kappa;
  t45 = exp(-t34 * sigma[0] * t39 * t41 / 0.24e2);
  t48 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t45);
  t52 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t48);
  t53 = rho[1] <= p->dens_threshold;
  t54 = -t16;
  t56 = my_piecewise5(t14, t11, t10, t15, t54 * t7);
  t57 = 0.1e1 + t56;
  t58 = t57 <= p->zeta_threshold;
  t59 = POW_1_3(t57);
  t61 = my_piecewise3(t58, t22, t59 * t57);
  t62 = t61 * t26;
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t72 = exp(-t34 * sigma[2] * t67 * t41 / 0.24e2);
  t75 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t72);
  t79 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t62 * t75);
  tzk0 = t52 + t79;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t80 = t6 * t6;
  t81 = 0.1e1 / t80;
  t82 = t16 * t81;
  t84 = my_piecewise5(t10, 0, t14, 0, t7 - t82);
  t87 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t84);
  t88 = t87 * t26;
  t92 = t26 * t26;
  t93 = 0.1e1 / t92;
  t94 = t25 * t93;
  t97 = t5 * t94 * t48 / 0.8e1;
  t99 = t5 * t27 * params->rpbe_mu;
  t100 = t28 * t33;
  t101 = t35 * rho[0];
  t103 = 0.1e1 / t37 / t101;
  t106 = t100 * sigma[0] * t103 * t45;
  t110 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t88 * t48 - t97 + t99 * t106 / 0.24e2);
  t111 = t54 * t81;
  t113 = my_piecewise5(t14, 0, t10, 0, -t7 - t111);
  t116 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t113);
  t117 = t116 * t26;
  t121 = t61 * t93;
  t124 = t5 * t121 * t75 / 0.8e1;
  t126 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t117 * t75 - t124);
  tvrho0 = t52 + t79 + t6 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t10, 0, t14, 0, -t7 - t82);
  t133 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t130);
  t134 = t133 * t26;
  t139 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t134 * t48 - t97);
  t141 = my_piecewise5(t14, 0, t10, 0, t7 - t111);
  t144 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t141);
  t145 = t144 * t26;
  t150 = t5 * t62 * params->rpbe_mu;
  t151 = t63 * rho[1];
  t153 = 0.1e1 / t65 / t151;
  t156 = t100 * sigma[2] * t153 * t72;
  t160 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t145 * t75 - t124 + t150 * t156 / 0.24e2);
  tvrho1 = t52 + t79 + t6 * (t139 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t163 = t5 * t27;
  t166 = t29 * t33 * t39 * t45;
  t169 = my_piecewise3(t1, 0, -t163 * t166 / 0.64e2);
  tvsigma0 = t6 * t169;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t5 * t62;
  t173 = t29 * t33 * t67 * t72;
  t176 = my_piecewise3(t53, 0, -t170 * t173 / 0.64e2);
  tvsigma2 = t6 * t176;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t41;
  double t45, t48, t52, t53, t54, t56, t57, t58;
  double t59, t61, t62, t63, t64, t65, t67, t72;
  double t75, t79, tzk0;

  double t80, t81, t82, t84, t87, t88, t92, t93;
  double t94, t97, t99, t100, t101, t103, t106, t110;
  double t111, t113, t116, t117, t121, t124, t126, tvrho0;
  double t130, t133, t134, t139, t141, t144, t145, t150;
  double t151, t153, t156, t160, tvrho1, t163, t166, t169;
  double tvsigma0, tvsigma1, t170, t173, t176, tvsigma2;

  double t179, t180, t181, t184, t185, t186, t189, t193;
  double t194, t198, t200, t203, t207, t208, t211, t213;
  double t214, t216, t218, t221, t224, t226, t227, t230;
  double t231, t232, t235, t237, t238, t242, t243, t244;
  double t245, t248, t251, t255, t256, t260, t262, t264;
  double t267, t269, tv2rho20, t272, t276, t280, t281, t285;
  double t287, t290, t296, t297, t301, t305, t306, t310;
  double t312, t316, t320, t321, t324, tv2rho21, t329, t334;
  double t338, t339, t345, t346, t351, t355, t356, t362;
  double t366, t368, t371, t375, t376, t377, t380, t382;
  double t383, t387, tv2rho22, t390, t393, t395, t398, t401;
  double t403, t406, t407, t411, tv2rhosigma0, tv2rhosigma1, t413, t416;
  double t418, t420, tv2rhosigma2, t422, t426, tv2rhosigma3, tv2rhosigma4, t428;
  double t433, t436, t438, t441, t442, t446, tv2rhosigma5, t448;
  double t453, t456, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t457;
  double t462, t465, tv2sigma25;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->rpbe_mu * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t41 = 0.1e1 / params->rpbe_kappa;
  t45 = exp(-t34 * sigma[0] * t39 * t41 / 0.24e2);
  t48 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t45);
  t52 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t48);
  t53 = rho[1] <= p->dens_threshold;
  t54 = -t16;
  t56 = my_piecewise5(t14, t11, t10, t15, t54 * t7);
  t57 = 0.1e1 + t56;
  t58 = t57 <= p->zeta_threshold;
  t59 = POW_1_3(t57);
  t61 = my_piecewise3(t58, t22, t59 * t57);
  t62 = t61 * t26;
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t72 = exp(-t34 * sigma[2] * t67 * t41 / 0.24e2);
  t75 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t72);
  t79 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t62 * t75);
  tzk0 = t52 + t79;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t80 = t6 * t6;
  t81 = 0.1e1 / t80;
  t82 = t16 * t81;
  t84 = my_piecewise5(t10, 0, t14, 0, t7 - t82);
  t87 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t84);
  t88 = t87 * t26;
  t92 = t26 * t26;
  t93 = 0.1e1 / t92;
  t94 = t25 * t93;
  t97 = t5 * t94 * t48 / 0.8e1;
  t99 = t5 * t27 * params->rpbe_mu;
  t100 = t28 * t33;
  t101 = t35 * rho[0];
  t103 = 0.1e1 / t37 / t101;
  t106 = t100 * sigma[0] * t103 * t45;
  t110 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t88 * t48 - t97 + t99 * t106 / 0.24e2);
  t111 = t54 * t81;
  t113 = my_piecewise5(t14, 0, t10, 0, -t7 - t111);
  t116 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t113);
  t117 = t116 * t26;
  t121 = t61 * t93;
  t124 = t5 * t121 * t75 / 0.8e1;
  t126 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t117 * t75 - t124);
  tvrho0 = t52 + t79 + t6 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t10, 0, t14, 0, -t7 - t82);
  t133 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t130);
  t134 = t133 * t26;
  t139 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t134 * t48 - t97);
  t141 = my_piecewise5(t14, 0, t10, 0, t7 - t111);
  t144 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t141);
  t145 = t144 * t26;
  t150 = t5 * t62 * params->rpbe_mu;
  t151 = t63 * rho[1];
  t153 = 0.1e1 / t65 / t151;
  t156 = t100 * sigma[2] * t153 * t72;
  t160 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t145 * t75 - t124 + t150 * t156 / 0.24e2);
  tvrho1 = t52 + t79 + t6 * (t139 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t163 = t5 * t27;
  t166 = t29 * t33 * t39 * t45;
  t169 = my_piecewise3(t1, 0, -t163 * t166 / 0.64e2);
  tvsigma0 = t6 * t169;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t5 * t62;
  t173 = t29 * t33 * t67 * t72;
  t176 = my_piecewise3(t53, 0, -t170 * t173 / 0.64e2);
  tvsigma2 = t6 * t176;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t179 = t23 * t23;
  t180 = 0.1e1 / t179;
  t181 = t84 * t84;
  t184 = t80 * t6;
  t185 = 0.1e1 / t184;
  t186 = t16 * t185;
  t189 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t81 + 0.2e1 * t186);
  t193 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t181 + 0.4e1 / 0.3e1 * t23 * t189);
  t194 = t193 * t26;
  t198 = t87 * t93;
  t200 = t5 * t198 * t48;
  t203 = t5 * t88 * params->rpbe_mu;
  t207 = 0.1e1 / t92 / t6;
  t208 = t25 * t207;
  t211 = t5 * t208 * t48 / 0.12e2;
  t213 = t5 * t94 * params->rpbe_mu;
  t214 = t213 * t106;
  t216 = t35 * t35;
  t218 = 0.1e1 / t37 / t216;
  t221 = t100 * sigma[0] * t218 * t45;
  t224 = params->rpbe_mu * params->rpbe_mu;
  t226 = t5 * t27 * t224;
  t227 = t28 * t28;
  t230 = t227 / t31 / t30;
  t231 = sigma[0] * sigma[0];
  t232 = t230 * t231;
  t235 = 0.1e1 / t36 / t216 / t101;
  t237 = t235 * t41 * t45;
  t238 = t232 * t237;
  t242 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t194 * t48 - t200 / 0.4e1 + t203 * t106 / 0.12e2 + t211 + t214 / 0.36e2 - 0.11e2 / 0.72e2 * t99 * t221 + t226 * t238 / 0.216e3);
  t243 = t59 * t59;
  t244 = 0.1e1 / t243;
  t245 = t113 * t113;
  t248 = t54 * t185;
  t251 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t81 + 0.2e1 * t248);
  t255 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t245 + 0.4e1 / 0.3e1 * t59 * t251);
  t256 = t255 * t26;
  t260 = t116 * t93;
  t262 = t5 * t260 * t75;
  t264 = t61 * t207;
  t267 = t5 * t264 * t75 / 0.12e2;
  t269 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t256 * t75 - t262 / 0.4e1 + t267);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t6 * (t242 + t269);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t180 * t130;
  t276 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t186);
  t280 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t272 * t84 + 0.4e1 / 0.3e1 * t23 * t276);
  t281 = t280 * t26;
  t285 = t133 * t93;
  t287 = t5 * t285 * t48;
  t290 = t5 * t134 * params->rpbe_mu;
  t296 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t281 * t48 - t287 / 0.8e1 + t290 * t106 / 0.24e2 - t200 / 0.8e1 + t211 + t214 / 0.72e2);
  t297 = t244 * t141;
  t301 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t248);
  t305 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t297 * t113 + 0.4e1 / 0.3e1 * t59 * t301);
  t306 = t305 * t26;
  t310 = t144 * t93;
  t312 = t5 * t310 * t75;
  t316 = t5 * t117 * params->rpbe_mu;
  t320 = t5 * t121 * params->rpbe_mu;
  t321 = t320 * t156;
  t324 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t306 * t75 - t312 / 0.8e1 - t262 / 0.8e1 + t267 + t316 * t156 / 0.24e2 + t321 / 0.72e2);
  tv2rho21 = t110 + t126 + t139 + t160 + t6 * (t296 + t324);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t329 = t130 * t130;
  t334 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t81 + 0.2e1 * t186);
  t338 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t329 + 0.4e1 / 0.3e1 * t23 * t334);
  t339 = t338 * t26;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t339 * t48 - t287 / 0.4e1 + t211);
  t346 = t141 * t141;
  t351 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t81 + 0.2e1 * t248);
  t355 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t346 + 0.4e1 / 0.3e1 * t59 * t351);
  t356 = t355 * t26;
  t362 = t5 * t145 * params->rpbe_mu;
  t366 = t63 * t63;
  t368 = 0.1e1 / t65 / t366;
  t371 = t100 * sigma[2] * t368 * t72;
  t375 = t5 * t62 * t224;
  t376 = sigma[2] * sigma[2];
  t377 = t230 * t376;
  t380 = 0.1e1 / t64 / t366 / t151;
  t382 = t380 * t41 * t72;
  t383 = t377 * t382;
  t387 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t356 * t75 - t312 / 0.4e1 + t362 * t156 / 0.12e2 + t267 + t321 / 0.36e2 - 0.11e2 / 0.72e2 * t150 * t371 + t375 * t383 / 0.216e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t160 + t6 * (t345 + t387);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t390 = t5 * t88;
  t393 = t5 * t94;
  t395 = t393 * t166 / 0.192e3;
  t398 = t29 * t33 * t103 * t45;
  t401 = t216 * t35;
  t403 = 0.1e1 / t36 / t401;
  t406 = sigma[0] * t41 * t45;
  t407 = t230 * t403 * t406;
  t411 = my_piecewise3(t1, 0, -t390 * t166 / 0.64e2 - t395 + t163 * t398 / 0.24e2 - t226 * t407 / 0.576e3);
  tv2rhosigma0 = t6 * t411 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t413 = t5 * t117;
  t416 = t5 * t121;
  t418 = t416 * t173 / 0.192e3;
  t420 = my_piecewise3(t53, 0, -t413 * t173 / 0.64e2 - t418);
  tv2rhosigma2 = t6 * t420 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t422 = t5 * t134;
  t426 = my_piecewise3(t1, 0, -t422 * t166 / 0.64e2 - t395);
  tv2rhosigma3 = t6 * t426 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t428 = t5 * t145;
  t433 = t29 * t33 * t153 * t72;
  t436 = t366 * t63;
  t438 = 0.1e1 / t64 / t436;
  t441 = sigma[2] * t41 * t72;
  t442 = t230 * t438 * t441;
  t446 = my_piecewise3(t53, 0, -t428 * t173 / 0.64e2 - t418 + t170 * t433 / 0.24e2 - t375 * t442 / 0.576e3);
  tv2rhosigma5 = t6 * t446 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t448 = t216 * rho[0];
  t453 = t230 / t36 / t448 * t41 * t45;
  t456 = my_piecewise3(t1, 0, t226 * t453 / 0.1536e4);
  tv2sigma20 = t6 * t456;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t457 = t366 * rho[1];
  t462 = t230 / t64 / t457 * t41 * t72;
  t465 = my_piecewise3(t53, 0, t375 * t462 / 0.1536e4);
  tv2sigma25 = t6 * t465;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t41;
  double t45, t48, t52, t53, t54, t56, t57, t58;
  double t59, t61, t62, t63, t64, t65, t67, t72;
  double t75, t79, tzk0;

  double t80, t81, t82, t84, t87, t88, t92, t93;
  double t94, t97, t99, t100, t101, t103, t106, t110;
  double t111, t113, t116, t117, t121, t124, t126, tvrho0;
  double t130, t133, t134, t139, t141, t144, t145, t150;
  double t151, t153, t156, t160, tvrho1, t163, t166, t169;
  double tvsigma0, tvsigma1, t170, t173, t176, tvsigma2;

  double t179, t180, t181, t184, t185, t186, t189, t193;
  double t194, t198, t200, t203, t207, t208, t211, t213;
  double t214, t216, t218, t221, t224, t226, t227, t230;
  double t231, t232, t235, t237, t238, t242, t243, t244;
  double t245, t248, t251, t255, t256, t260, t262, t264;
  double t267, t269, tv2rho20, t272, t276, t280, t281, t285;
  double t287, t290, t296, t297, t301, t305, t306, t310;
  double t312, t316, t320, t321, t324, tv2rho21, t329, t334;
  double t338, t339, t345, t346, t351, t355, t356, t362;
  double t366, t368, t371, t375, t376, t377, t380, t382;
  double t383, t387, tv2rho22, t390, t393, t395, t398, t401;
  double t403, t406, t407, t411, tv2rhosigma0, tv2rhosigma1, t413, t416;
  double t418, t420, tv2rhosigma2, t422, t426, tv2rhosigma3, tv2rhosigma4, t428;
  double t433, t436, t438, t441, t442, t446, tv2rhosigma5, t448;
  double t453, t456, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t457;
  double t462, t465, tv2sigma25;

  double t469, t470, t473, t476, t477, t478, t481, t485;
  double t486, t491, t494, t497, t498, t501, t504, t507;
  double t509, t512, t517, t519, t521, t523, t526, t527;
  double t530, t532, t536, t537, t540, t541, t543, t546;
  double t547, t548, t549, t550, t551, t552, t553, t554;
  double t557, t560, t561, t563, t564, t567, t570, t573;
  double t577, t578, t582, t584, t586, t588, t590, t593;
  double t595, tv3rho30, t598, t599, t600, t603, t608, t609;
  double t611, t615, t616, t620, t623, t625, t628, t630;
  double t633, t635, t639, t648, t649, t650, t653, t658;
  double t660, t664, t665, t669, t672, t673, t675, t680;
  double t684, t686, t688, t689, t692, tv3rho31, t695, t700;
  double t704, t708, t709, t713, t715, t718, t725, t726;
  double t731, t735, t739, t740, t744, t746, t750, t754;
  double t755, t761, t764, t768, t769, t771, t772, tv3rho32;
  double t777, t784, t788, t789, t796, t798, t805, t809;
  double t810, t815, t818, t821, t823, t826, t832, t841;
  double t844, t845, t846, t847, t848, t851, t854, t855;
  double tv3rho33, t859, t862, t863, t869, t871, t872, t874;
  double t878, t882, t885, t887, t889, t890, t894, tv3rho2sigma0;
  double tv3rho2sigma1, t897, t900, t901, t903, t905, t907, tv3rho2sigma2;
  double t909, t912, t913, t923, tv3rho2sigma3, tv3rho2sigma4, t925, t928;
  double t929, t934, t938, t941, tv3rho2sigma5, t944, t949, tv3rho2sigma6;
  double tv3rho2sigma7, t952, t964, t968, t971, t973, t975, t976;
  double t980, tv3rho2sigma8, t985, t988, t991, t993, t995, t996;
  double t1000, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1005, t1007;
  double tv3rhosigma25, t1012, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1018;
  double t1021, t1023, t1025, t1026, t1030, tv3rhosigma211, t1034, t1035;
  double t1038, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36;
  double tv3sigma37, tv3sigma38, t1041, t1042, t1045, tv3sigma39;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->rpbe_mu * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t41 = 0.1e1 / params->rpbe_kappa;
  t45 = exp(-t34 * sigma[0] * t39 * t41 / 0.24e2);
  t48 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t45);
  t52 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t48);
  t53 = rho[1] <= p->dens_threshold;
  t54 = -t16;
  t56 = my_piecewise5(t14, t11, t10, t15, t54 * t7);
  t57 = 0.1e1 + t56;
  t58 = t57 <= p->zeta_threshold;
  t59 = POW_1_3(t57);
  t61 = my_piecewise3(t58, t22, t59 * t57);
  t62 = t61 * t26;
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t72 = exp(-t34 * sigma[2] * t67 * t41 / 0.24e2);
  t75 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t72);
  t79 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t62 * t75);
  tzk0 = t52 + t79;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t80 = t6 * t6;
  t81 = 0.1e1 / t80;
  t82 = t16 * t81;
  t84 = my_piecewise5(t10, 0, t14, 0, t7 - t82);
  t87 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t84);
  t88 = t87 * t26;
  t92 = t26 * t26;
  t93 = 0.1e1 / t92;
  t94 = t25 * t93;
  t97 = t5 * t94 * t48 / 0.8e1;
  t99 = t5 * t27 * params->rpbe_mu;
  t100 = t28 * t33;
  t101 = t35 * rho[0];
  t103 = 0.1e1 / t37 / t101;
  t106 = t100 * sigma[0] * t103 * t45;
  t110 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t88 * t48 - t97 + t99 * t106 / 0.24e2);
  t111 = t54 * t81;
  t113 = my_piecewise5(t14, 0, t10, 0, -t7 - t111);
  t116 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t113);
  t117 = t116 * t26;
  t121 = t61 * t93;
  t124 = t5 * t121 * t75 / 0.8e1;
  t126 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t117 * t75 - t124);
  tvrho0 = t52 + t79 + t6 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t10, 0, t14, 0, -t7 - t82);
  t133 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t130);
  t134 = t133 * t26;
  t139 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t134 * t48 - t97);
  t141 = my_piecewise5(t14, 0, t10, 0, t7 - t111);
  t144 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t141);
  t145 = t144 * t26;
  t150 = t5 * t62 * params->rpbe_mu;
  t151 = t63 * rho[1];
  t153 = 0.1e1 / t65 / t151;
  t156 = t100 * sigma[2] * t153 * t72;
  t160 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t145 * t75 - t124 + t150 * t156 / 0.24e2);
  tvrho1 = t52 + t79 + t6 * (t139 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t163 = t5 * t27;
  t166 = t29 * t33 * t39 * t45;
  t169 = my_piecewise3(t1, 0, -t163 * t166 / 0.64e2);
  tvsigma0 = t6 * t169;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t5 * t62;
  t173 = t29 * t33 * t67 * t72;
  t176 = my_piecewise3(t53, 0, -t170 * t173 / 0.64e2);
  tvsigma2 = t6 * t176;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t179 = t23 * t23;
  t180 = 0.1e1 / t179;
  t181 = t84 * t84;
  t184 = t80 * t6;
  t185 = 0.1e1 / t184;
  t186 = t16 * t185;
  t189 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t81 + 0.2e1 * t186);
  t193 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t181 + 0.4e1 / 0.3e1 * t23 * t189);
  t194 = t193 * t26;
  t198 = t87 * t93;
  t200 = t5 * t198 * t48;
  t203 = t5 * t88 * params->rpbe_mu;
  t207 = 0.1e1 / t92 / t6;
  t208 = t25 * t207;
  t211 = t5 * t208 * t48 / 0.12e2;
  t213 = t5 * t94 * params->rpbe_mu;
  t214 = t213 * t106;
  t216 = t35 * t35;
  t218 = 0.1e1 / t37 / t216;
  t221 = t100 * sigma[0] * t218 * t45;
  t224 = params->rpbe_mu * params->rpbe_mu;
  t226 = t5 * t27 * t224;
  t227 = t28 * t28;
  t230 = t227 / t31 / t30;
  t231 = sigma[0] * sigma[0];
  t232 = t230 * t231;
  t235 = 0.1e1 / t36 / t216 / t101;
  t237 = t235 * t41 * t45;
  t238 = t232 * t237;
  t242 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t194 * t48 - t200 / 0.4e1 + t203 * t106 / 0.12e2 + t211 + t214 / 0.36e2 - 0.11e2 / 0.72e2 * t99 * t221 + t226 * t238 / 0.216e3);
  t243 = t59 * t59;
  t244 = 0.1e1 / t243;
  t245 = t113 * t113;
  t248 = t54 * t185;
  t251 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t81 + 0.2e1 * t248);
  t255 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t245 + 0.4e1 / 0.3e1 * t59 * t251);
  t256 = t255 * t26;
  t260 = t116 * t93;
  t262 = t5 * t260 * t75;
  t264 = t61 * t207;
  t267 = t5 * t264 * t75 / 0.12e2;
  t269 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t256 * t75 - t262 / 0.4e1 + t267);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t6 * (t242 + t269);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t180 * t130;
  t276 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t186);
  t280 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t272 * t84 + 0.4e1 / 0.3e1 * t23 * t276);
  t281 = t280 * t26;
  t285 = t133 * t93;
  t287 = t5 * t285 * t48;
  t290 = t5 * t134 * params->rpbe_mu;
  t296 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t281 * t48 - t287 / 0.8e1 + t290 * t106 / 0.24e2 - t200 / 0.8e1 + t211 + t214 / 0.72e2);
  t297 = t244 * t141;
  t301 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t248);
  t305 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t297 * t113 + 0.4e1 / 0.3e1 * t59 * t301);
  t306 = t305 * t26;
  t310 = t144 * t93;
  t312 = t5 * t310 * t75;
  t316 = t5 * t117 * params->rpbe_mu;
  t320 = t5 * t121 * params->rpbe_mu;
  t321 = t320 * t156;
  t324 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t306 * t75 - t312 / 0.8e1 - t262 / 0.8e1 + t267 + t316 * t156 / 0.24e2 + t321 / 0.72e2);
  tv2rho21 = t110 + t126 + t139 + t160 + t6 * (t296 + t324);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t329 = t130 * t130;
  t334 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t81 + 0.2e1 * t186);
  t338 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t329 + 0.4e1 / 0.3e1 * t23 * t334);
  t339 = t338 * t26;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t339 * t48 - t287 / 0.4e1 + t211);
  t346 = t141 * t141;
  t351 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t81 + 0.2e1 * t248);
  t355 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t346 + 0.4e1 / 0.3e1 * t59 * t351);
  t356 = t355 * t26;
  t362 = t5 * t145 * params->rpbe_mu;
  t366 = t63 * t63;
  t368 = 0.1e1 / t65 / t366;
  t371 = t100 * sigma[2] * t368 * t72;
  t375 = t5 * t62 * t224;
  t376 = sigma[2] * sigma[2];
  t377 = t230 * t376;
  t380 = 0.1e1 / t64 / t366 / t151;
  t382 = t380 * t41 * t72;
  t383 = t377 * t382;
  t387 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t356 * t75 - t312 / 0.4e1 + t362 * t156 / 0.12e2 + t267 + t321 / 0.36e2 - 0.11e2 / 0.72e2 * t150 * t371 + t375 * t383 / 0.216e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t160 + t6 * (t345 + t387);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t390 = t5 * t88;
  t393 = t5 * t94;
  t395 = t393 * t166 / 0.192e3;
  t398 = t29 * t33 * t103 * t45;
  t401 = t216 * t35;
  t403 = 0.1e1 / t36 / t401;
  t406 = sigma[0] * t41 * t45;
  t407 = t230 * t403 * t406;
  t411 = my_piecewise3(t1, 0, -t390 * t166 / 0.64e2 - t395 + t163 * t398 / 0.24e2 - t226 * t407 / 0.576e3);
  tv2rhosigma0 = t6 * t411 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t413 = t5 * t117;
  t416 = t5 * t121;
  t418 = t416 * t173 / 0.192e3;
  t420 = my_piecewise3(t53, 0, -t413 * t173 / 0.64e2 - t418);
  tv2rhosigma2 = t6 * t420 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t422 = t5 * t134;
  t426 = my_piecewise3(t1, 0, -t422 * t166 / 0.64e2 - t395);
  tv2rhosigma3 = t6 * t426 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t428 = t5 * t145;
  t433 = t29 * t33 * t153 * t72;
  t436 = t366 * t63;
  t438 = 0.1e1 / t64 / t436;
  t441 = sigma[2] * t41 * t72;
  t442 = t230 * t438 * t441;
  t446 = my_piecewise3(t53, 0, -t428 * t173 / 0.64e2 - t418 + t170 * t433 / 0.24e2 - t375 * t442 / 0.576e3);
  tv2rhosigma5 = t6 * t446 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t448 = t216 * rho[0];
  t453 = t230 / t36 / t448 * t41 * t45;
  t456 = my_piecewise3(t1, 0, t226 * t453 / 0.1536e4);
  tv2sigma20 = t6 * t456;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t457 = t366 * rho[1];
  t462 = t230 / t64 / t457 * t41 * t72;
  t465 = my_piecewise3(t53, 0, t375 * t462 / 0.1536e4);
  tv2sigma25 = t6 * t465;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t469 = 0.1e1 / t179 / t19;
  t470 = t181 * t84;
  t473 = t180 * t84;
  t476 = t80 * t80;
  t477 = 0.1e1 / t476;
  t478 = t16 * t477;
  t481 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t185 - 0.6e1 * t478);
  t485 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t469 * t470 + 0.4e1 / 0.3e1 * t473 * t189 + 0.4e1 / 0.3e1 * t23 * t481);
  t486 = t485 * t26;
  t491 = t5 * t88 * t224;
  t494 = t213 * t221;
  t497 = t5 * t94 * t224;
  t498 = t497 * t238;
  t501 = 0.1e1 / t37 / t448;
  t504 = t100 * sigma[0] * t501 * t45;
  t507 = t216 * t216;
  t509 = 0.1e1 / t36 / t507;
  t512 = t232 * t509 * t41 * t45;
  t517 = t193 * t93;
  t519 = t5 * t517 * t48;
  t521 = t87 * t207;
  t523 = t5 * t521 * t48;
  t526 = 0.1e1 / t92 / t80;
  t527 = t25 * t526;
  t530 = 0.5e1 / 0.36e2 * t5 * t527 * t48;
  t532 = t5 * t194 * params->rpbe_mu;
  t536 = t5 * t198 * params->rpbe_mu;
  t537 = t536 * t106;
  t540 = t5 * t208 * params->rpbe_mu;
  t541 = t540 * t106;
  t543 = t30 * t30;
  t546 = t2 / t3 / t543;
  t547 = t546 * t27;
  t548 = t224 * params->rpbe_mu;
  t549 = t231 * sigma[0];
  t550 = t548 * t549;
  t551 = t507 * t101;
  t552 = 0.1e1 / t551;
  t553 = params->rpbe_kappa * params->rpbe_kappa;
  t554 = 0.1e1 / t553;
  t557 = t550 * t552 * t554 * t45;
  t560 = -0.3e1 / 0.8e1 * t5 * t486 * t48 + t491 * t238 / 0.72e2 - 0.11e2 / 0.72e2 * t494 + t498 / 0.216e3 + 0.77e2 / 0.108e3 * t99 * t504 - 0.11e2 / 0.216e3 * t226 * t512 - 0.11e2 / 0.24e2 * t203 * t221 - 0.3e1 / 0.8e1 * t519 + t523 / 0.4e1 - t530 + t532 * t106 / 0.8e1 + t537 / 0.12e2 - t541 / 0.36e2 + t547 * t557 / 0.324e3;
  t561 = my_piecewise3(t1, 0, t560);
  t563 = 0.1e1 / t243 / t57;
  t564 = t245 * t113;
  t567 = t244 * t113;
  t570 = t54 * t477;
  t573 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t185 - 0.6e1 * t570);
  t577 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t563 * t564 + 0.4e1 / 0.3e1 * t567 * t251 + 0.4e1 / 0.3e1 * t59 * t573);
  t578 = t577 * t26;
  t582 = t255 * t93;
  t584 = t5 * t582 * t75;
  t586 = t116 * t207;
  t588 = t5 * t586 * t75;
  t590 = t61 * t526;
  t593 = 0.5e1 / 0.36e2 * t5 * t590 * t75;
  t595 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t578 * t75 - 0.3e1 / 0.8e1 * t584 + t588 / 0.4e1 - t593);
  tv3rho30 = 0.3e1 * t242 + 0.3e1 * t269 + t6 * (t561 + t595);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t598 = 0.2e1 * t296;
  t599 = 0.2e1 * t324;
  t600 = t469 * t130;
  t603 = t180 * t276;
  t608 = 0.2e1 * t185;
  t609 = 0.6e1 * t478;
  t611 = my_piecewise5(t10, 0, t14, 0, t608 - t609);
  t615 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t600 * t181 + 0.8e1 / 0.9e1 * t603 * t84 + 0.4e1 / 0.9e1 * t272 * t189 + 0.4e1 / 0.3e1 * t23 * t611);
  t616 = t615 * t26;
  t620 = t280 * t93;
  t623 = t5 * t620 * t48 / 0.4e1;
  t625 = t5 * t281 * params->rpbe_mu;
  t628 = t133 * t207;
  t630 = t5 * t628 * t48;
  t633 = t5 * t285 * params->rpbe_mu;
  t635 = t633 * t106 / 0.36e2;
  t639 = t5 * t134 * t224;
  t648 = -0.3e1 / 0.8e1 * t5 * t616 * t48 - t623 + t625 * t106 / 0.12e2 + t630 / 0.12e2 + t635 - 0.11e2 / 0.72e2 * t290 * t221 + t639 * t238 / 0.216e3 - t519 / 0.8e1 + t523 / 0.6e1 + t537 / 0.36e2 - t530 - t541 / 0.54e2 - 0.11e2 / 0.216e3 * t494 + t498 / 0.648e3;
  t649 = my_piecewise3(t1, 0, t648);
  t650 = t563 * t141;
  t653 = t244 * t301;
  t658 = 0.6e1 * t570;
  t660 = my_piecewise5(t14, 0, t10, 0, -t608 - t658);
  t664 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t650 * t245 + 0.8e1 / 0.9e1 * t653 * t113 + 0.4e1 / 0.9e1 * t297 * t251 + 0.4e1 / 0.3e1 * t59 * t660);
  t665 = t664 * t26;
  t669 = t305 * t93;
  t672 = t5 * t669 * t75 / 0.4e1;
  t673 = t144 * t207;
  t675 = t5 * t673 * t75;
  t680 = t5 * t256 * params->rpbe_mu;
  t684 = t5 * t260 * params->rpbe_mu;
  t686 = t684 * t156 / 0.36e2;
  t688 = t5 * t264 * params->rpbe_mu;
  t689 = t688 * t156;
  t692 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t665 * t75 - t672 + t675 / 0.12e2 - t584 / 0.8e1 + t588 / 0.6e1 - t593 + t680 * t156 / 0.24e2 + t686 - t689 / 0.108e3);
  tv3rho31 = t242 + t269 + t598 + t599 + t6 * (t649 + t692);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t695 = t469 * t329;
  t700 = t180 * t334;
  t704 = my_piecewise5(t10, 0, t14, 0, -t608 - t609);
  t708 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t695 * t84 + 0.8e1 / 0.9e1 * t272 * t276 + 0.4e1 / 0.9e1 * t700 * t84 + 0.4e1 / 0.3e1 * t23 * t704);
  t709 = t708 * t26;
  t713 = t338 * t93;
  t715 = t5 * t713 * t48;
  t718 = t5 * t339 * params->rpbe_mu;
  t725 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t709 * t48 - t715 / 0.8e1 + t718 * t106 / 0.24e2 - t623 + t630 / 0.6e1 + t635 + t523 / 0.12e2 - t530 - t541 / 0.108e3);
  t726 = t563 * t346;
  t731 = t244 * t351;
  t735 = my_piecewise5(t14, 0, t10, 0, t608 - t658);
  t739 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t726 * t113 + 0.8e1 / 0.9e1 * t297 * t301 + 0.4e1 / 0.9e1 * t731 * t113 + 0.4e1 / 0.3e1 * t59 * t735);
  t740 = t739 * t26;
  t744 = t355 * t93;
  t746 = t5 * t744 * t75;
  t750 = t5 * t306 * params->rpbe_mu;
  t754 = t5 * t310 * params->rpbe_mu;
  t755 = t754 * t156;
  t761 = t320 * t371;
  t764 = t5 * t117 * t224;
  t768 = t5 * t121 * t224;
  t769 = t768 * t383;
  t771 = -0.3e1 / 0.8e1 * t5 * t740 * t75 - t746 / 0.8e1 - t672 + t675 / 0.6e1 + t750 * t156 / 0.12e2 + t755 / 0.36e2 + t588 / 0.12e2 - t593 + t686 - t689 / 0.54e2 - 0.11e2 / 0.72e2 * t316 * t371 - 0.11e2 / 0.216e3 * t761 + t764 * t383 / 0.216e3 + t769 / 0.648e3;
  t772 = my_piecewise3(t53, 0, t771);
  tv3rho32 = t598 + t599 + t345 + t387 + t6 * (t725 + t772);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t777 = t329 * t130;
  t784 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t185 - 0.6e1 * t478);
  t788 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t469 * t777 + 0.4e1 / 0.3e1 * t272 * t334 + 0.4e1 / 0.3e1 * t23 * t784);
  t789 = t788 * t26;
  t796 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t789 * t48 - 0.3e1 / 0.8e1 * t715 + t630 / 0.4e1 - t530);
  t798 = t346 * t141;
  t805 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t185 - 0.6e1 * t570);
  t809 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t563 * t798 + 0.4e1 / 0.3e1 * t297 * t351 + 0.4e1 / 0.3e1 * t59 * t805);
  t810 = t809 * t26;
  t815 = 0.1e1 / t65 / t457;
  t818 = t100 * sigma[2] * t815 * t72;
  t821 = t366 * t366;
  t823 = 0.1e1 / t64 / t821;
  t826 = t377 * t823 * t41 * t72;
  t832 = t5 * t145 * t224;
  t841 = t5 * t356 * params->rpbe_mu;
  t844 = t546 * t62;
  t845 = t376 * sigma[2];
  t846 = t548 * t845;
  t847 = t821 * t151;
  t848 = 0.1e1 / t847;
  t851 = t846 * t848 * t554 * t72;
  t854 = t769 / 0.216e3 - 0.3e1 / 0.8e1 * t5 * t810 * t75 + 0.77e2 / 0.108e3 * t150 * t818 - 0.11e2 / 0.216e3 * t375 * t826 - 0.11e2 / 0.24e2 * t362 * t371 + t832 * t383 / 0.72e2 + t755 / 0.12e2 - 0.11e2 / 0.72e2 * t761 - t689 / 0.36e2 - 0.3e1 / 0.8e1 * t746 + t675 / 0.4e1 - t593 + t841 * t156 / 0.8e1 + t844 * t851 / 0.324e3;
  t855 = my_piecewise3(t53, 0, t854);
  tv3rho33 = 0.3e1 * t345 + 0.3e1 * t387 + t6 * (t796 + t855);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t859 = t5 * t194;
  t862 = t5 * t198;
  t863 = t862 * t166;
  t869 = t5 * t208;
  t871 = t869 * t166 / 0.288e3;
  t872 = t393 * t398;
  t874 = t497 * t407;
  t878 = t29 * t33 * t218 * t45;
  t882 = t230 * t235 * t406;
  t885 = t507 * t35;
  t887 = t548 / t885;
  t889 = t231 * t554 * t45;
  t890 = t887 * t889;
  t894 = my_piecewise3(t1, 0, -t859 * t166 / 0.64e2 - t863 / 0.96e2 + t390 * t398 / 0.12e2 - t491 * t407 / 0.288e3 + t871 + t872 / 0.36e2 - t874 / 0.864e3 - 0.11e2 / 0.72e2 * t163 * t878 + t226 * t882 / 0.64e2 - t547 * t890 / 0.864e3);
  tv3rho2sigma0 = t6 * t894 + 0.2e1 * t411;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t897 = t5 * t256;
  t900 = t5 * t260;
  t901 = t900 * t173;
  t903 = t5 * t264;
  t905 = t903 * t173 / 0.288e3;
  t907 = my_piecewise3(t53, 0, -t897 * t173 / 0.64e2 - t901 / 0.96e2 + t905);
  tv3rho2sigma2 = t6 * t907 + 0.2e1 * t420;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t909 = t5 * t281;
  t912 = t5 * t285;
  t913 = t912 * t166;
  t923 = my_piecewise3(t1, 0, -t909 * t166 / 0.64e2 - t913 / 0.192e3 + t422 * t398 / 0.24e2 - t639 * t407 / 0.576e3 - t863 / 0.192e3 + t871 + t872 / 0.72e2 - t874 / 0.1728e4);
  tv3rho2sigma3 = t6 * t923 + t411 + t426;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t925 = t5 * t306;
  t928 = t5 * t310;
  t929 = t928 * t173;
  t934 = t416 * t433;
  t938 = t768 * t442;
  t941 = my_piecewise3(t53, 0, -t925 * t173 / 0.64e2 - t929 / 0.192e3 - t901 / 0.192e3 + t905 + t413 * t433 / 0.24e2 + t934 / 0.72e2 - t764 * t442 / 0.576e3 - t938 / 0.1728e4);
  tv3rho2sigma5 = t6 * t941 + t420 + t446;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t944 = t5 * t339;
  t949 = my_piecewise3(t1, 0, -t944 * t166 / 0.64e2 - t913 / 0.96e2 + t871);
  tv3rho2sigma6 = t6 * t949 + 0.2e1 * t426;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t952 = t5 * t356;
  t964 = t29 * t33 * t368 * t72;
  t968 = t230 * t380 * t441;
  t971 = t821 * t63;
  t973 = t548 / t971;
  t975 = t376 * t554 * t72;
  t976 = t973 * t975;
  t980 = my_piecewise3(t53, 0, -t952 * t173 / 0.64e2 - t929 / 0.96e2 + t428 * t433 / 0.12e2 - t832 * t442 / 0.288e3 + t905 + t934 / 0.36e2 - t938 / 0.864e3 - 0.11e2 / 0.72e2 * t170 * t964 + t375 * t968 / 0.64e2 - t844 * t976 / 0.864e3);
  tv3rho2sigma8 = t6 * t980 + 0.2e1 * t446;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t985 = t497 * t453 / 0.4608e4;
  t988 = t230 * t403 * t41 * t45;
  t991 = t507 * rho[0];
  t993 = t548 / t991;
  t995 = t554 * sigma[0] * t45;
  t996 = t993 * t995;
  t1000 = my_piecewise3(t1, 0, t491 * t453 / 0.1536e4 + t985 - t226 * t988 / 0.288e3 + t547 * t996 / 0.2304e4);
  tv3rhosigma20 = t6 * t1000 + t456;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1005 = t768 * t462 / 0.4608e4;
  t1007 = my_piecewise3(t53, 0, t764 * t462 / 0.1536e4 + t1005);
  tv3rhosigma25 = t6 * t1007 + t465;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1012 = my_piecewise3(t1, 0, t639 * t453 / 0.1536e4 + t985);
  tv3rhosigma26 = t6 * t1012 + t456;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1018 = t230 * t438 * t41 * t72;
  t1021 = t821 * rho[1];
  t1023 = t548 / t1021;
  t1025 = t554 * sigma[2] * t72;
  t1026 = t1023 * t1025;
  t1030 = my_piecewise3(t53, 0, t832 * t462 / 0.1536e4 + t1005 - t375 * t1018 / 0.288e3 + t844 * t1026 / 0.2304e4);
  tv3rhosigma211 = t6 * t1030 + t465;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1034 = t554 * t45;
  t1035 = t548 / t507 * t1034;
  t1038 = my_piecewise3(t1, 0, -t547 * t1035 / 0.6144e4);
  tv3sigma30 = t6 * t1038;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1041 = t554 * t72;
  t1042 = t548 / t821 * t1041;
  t1045 = my_piecewise3(t53, 0, -t844 * t1042 / 0.6144e4);
  tv3sigma39 = t6 * t1045;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t41;
  double t45, t48, t52, t53, t54, t56, t57, t58;
  double t59, t61, t62, t63, t64, t65, t67, t72;
  double t75, t79, tzk0;

  double t80, t81, t82, t84, t87, t88, t92, t93;
  double t94, t97, t99, t100, t101, t103, t106, t110;
  double t111, t113, t116, t117, t121, t124, t126, tvrho0;
  double t130, t133, t134, t139, t141, t144, t145, t150;
  double t151, t153, t156, t160, tvrho1, t163, t166, t169;
  double tvsigma0, tvsigma1, t170, t173, t176, tvsigma2;

  double t179, t180, t181, t184, t185, t186, t189, t193;
  double t194, t198, t200, t203, t207, t208, t211, t213;
  double t214, t216, t218, t221, t224, t226, t227, t230;
  double t231, t232, t235, t237, t238, t242, t243, t244;
  double t245, t248, t251, t255, t256, t260, t262, t264;
  double t267, t269, tv2rho20, t272, t276, t280, t281, t285;
  double t287, t290, t296, t297, t301, t305, t306, t310;
  double t312, t316, t320, t321, t324, tv2rho21, t329, t334;
  double t338, t339, t345, t346, t351, t355, t356, t362;
  double t366, t368, t371, t375, t376, t377, t380, t382;
  double t383, t387, tv2rho22, t390, t393, t395, t398, t401;
  double t403, t406, t407, t411, tv2rhosigma0, tv2rhosigma1, t413, t416;
  double t418, t420, tv2rhosigma2, t422, t426, tv2rhosigma3, tv2rhosigma4, t428;
  double t433, t436, t438, t441, t442, t446, tv2rhosigma5, t448;
  double t453, t456, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t457;
  double t462, t465, tv2sigma25;

  double t469, t470, t473, t476, t477, t478, t481, t485;
  double t486, t491, t494, t497, t498, t501, t504, t507;
  double t509, t512, t517, t519, t521, t523, t526, t527;
  double t530, t532, t536, t537, t540, t541, t543, t546;
  double t547, t548, t549, t550, t551, t552, t553, t554;
  double t557, t560, t561, t563, t564, t567, t570, t573;
  double t577, t578, t582, t584, t586, t588, t590, t593;
  double t595, tv3rho30, t598, t599, t600, t603, t608, t609;
  double t611, t615, t616, t620, t623, t625, t628, t630;
  double t633, t635, t639, t648, t649, t650, t653, t658;
  double t660, t664, t665, t669, t672, t673, t675, t680;
  double t684, t686, t688, t689, t692, tv3rho31, t695, t700;
  double t704, t708, t709, t713, t715, t718, t725, t726;
  double t731, t735, t739, t740, t744, t746, t750, t754;
  double t755, t761, t764, t768, t769, t771, t772, tv3rho32;
  double t777, t784, t788, t789, t796, t798, t805, t809;
  double t810, t815, t818, t821, t823, t826, t832, t841;
  double t844, t845, t846, t847, t848, t851, t854, t855;
  double tv3rho33, t859, t862, t863, t869, t871, t872, t874;
  double t878, t882, t885, t887, t889, t890, t894, tv3rho2sigma0;
  double tv3rho2sigma1, t897, t900, t901, t903, t905, t907, tv3rho2sigma2;
  double t909, t912, t913, t923, tv3rho2sigma3, tv3rho2sigma4, t925, t928;
  double t929, t934, t938, t941, tv3rho2sigma5, t944, t949, tv3rho2sigma6;
  double tv3rho2sigma7, t952, t964, t968, t971, t973, t975, t976;
  double t980, tv3rho2sigma8, t985, t988, t991, t993, t995, t996;
  double t1000, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1005, t1007;
  double tv3rhosigma25, t1012, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1018;
  double t1021, t1023, t1025, t1026, t1030, tv3rhosigma211, t1034, t1035;
  double t1038, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36;
  double tv3sigma37, tv3sigma38, t1041, t1042, t1045, tv3sigma39;

  double t1048, t1057, t1063, t1071, t1075, t1079, t1082, t1086;
  double t1089, t1091, t1094, t1098, t1100, t1102, t1103, t1109;
  double t1115, t1116, t1119, t1123, t1128, t1138, t1142, t1143;
  double t1148, t1149, t1151, t1153, t1154, t1160, t1162, t1166;
  double t1169, t1170, t1172, t1179, t1181, t1182, t1184, t1185;
  double t1191, t1196, t1199, t1203, t1210, t1214, t1218, t1223;
  double t1225, tv4rho40, t1232, t1233, t1240, t1252, t1256, t1257;
  double t1260, t1262, t1279, t1280, t1282, t1286, t1296, t1300;
  double t1304, t1305, t1312, t1315, t1317, t1334, t1336, t1340;
  double t1347, t1351, t1352, t1355, t1366, t1370, t1371, t1374;
  double t1376, t1377, tv4rho41, t1387, t1392, t1396, t1413, t1426;
  double t1430, t1448, t1450, t1452, t1455, t1457, t1460, t1465;
  double t1469, t1476, t1481, t1486, t1487, t1490, t1491, t1501;
  double t1514, t1518, t1530, t1532, tv4rho42, t1553, t1557, t1564;
  double t1576, t1577, t1586, t1588, t1592, t1601, t1619, t1623;
  double t1628, t1636, t1640, t1641, t1643, t1647, t1648, t1650;
  double t1653, t1655, tv4rho43, t1660, t1665, t1672, t1676, t1685;
  double t1708, t1713, t1720, t1724, t1729, t1735, t1736, t1742;
  double t1747, t1761, t1768, t1771, t1773, tv4rho44, t1782, t1788;
  double t1789, t1791, t1794, t1799, t1801, t1817, t1821, t1828;
  double t1834, t1835, tv4rho3sigma0, tv4rho3sigma1, t1842, t1845, t1849, t1851;
  double tv4rho3sigma2, t1853, t1857, t1862, t1866, t1876, t1886, t1887;
  double tv4rho3sigma3, tv4rho3sigma4, t1889, t1895, t1897, t1904, t1905, t1910;
  double t1911, t1913, t1914, tv4rho3sigma5, t1920, t1930, t1931, tv4rho3sigma6;
  double tv4rho3sigma7, t1937, t1942, t1946, t1953, t1957, t1961, t1963;
  double t1964, tv4rho3sigma8, t1973, tv4rho3sigma9, tv4rho3sigma10, t2019, t2020, tv4rho3sigma11;
  double t2025, t2032, t2033, t2035, t2051, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t2056, t2059, t2061, tv4rho2sigma25, t2065, t2075;
  double tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t2079, t2084, t2088;
  double t2091, tv4rho2sigma211, t2098, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t2124, tv4rho2sigma217, t2129, t2143, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33;
  double tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2148, t2150, tv4rhosigma39;
  double t2155, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316;
  double tv4rhosigma317, tv4rhosigma318, t2172, tv4rhosigma319, t2180, tv4sigma40, tv4sigma41, tv4sigma42;
  double tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410;
  double tv4sigma411, tv4sigma412, tv4sigma413, t2187, tv4sigma414;

  gga_x_rpbe_params *params;

  assert(p->params != NULL);
  params = (gga_x_rpbe_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->rpbe_mu * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t41 = 0.1e1 / params->rpbe_kappa;
  t45 = exp(-t34 * sigma[0] * t39 * t41 / 0.24e2);
  t48 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t45);
  t52 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t48);
  t53 = rho[1] <= p->dens_threshold;
  t54 = -t16;
  t56 = my_piecewise5(t14, t11, t10, t15, t54 * t7);
  t57 = 0.1e1 + t56;
  t58 = t57 <= p->zeta_threshold;
  t59 = POW_1_3(t57);
  t61 = my_piecewise3(t58, t22, t59 * t57);
  t62 = t61 * t26;
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t72 = exp(-t34 * sigma[2] * t67 * t41 / 0.24e2);
  t75 = 0.1e1 + params->rpbe_kappa * (0.1e1 - t72);
  t79 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t62 * t75);
  tzk0 = t52 + t79;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t80 = t6 * t6;
  t81 = 0.1e1 / t80;
  t82 = t16 * t81;
  t84 = my_piecewise5(t10, 0, t14, 0, t7 - t82);
  t87 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t84);
  t88 = t87 * t26;
  t92 = t26 * t26;
  t93 = 0.1e1 / t92;
  t94 = t25 * t93;
  t97 = t5 * t94 * t48 / 0.8e1;
  t99 = t5 * t27 * params->rpbe_mu;
  t100 = t28 * t33;
  t101 = t35 * rho[0];
  t103 = 0.1e1 / t37 / t101;
  t106 = t100 * sigma[0] * t103 * t45;
  t110 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t88 * t48 - t97 + t99 * t106 / 0.24e2);
  t111 = t54 * t81;
  t113 = my_piecewise5(t14, 0, t10, 0, -t7 - t111);
  t116 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t113);
  t117 = t116 * t26;
  t121 = t61 * t93;
  t124 = t5 * t121 * t75 / 0.8e1;
  t126 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t117 * t75 - t124);
  tvrho0 = t52 + t79 + t6 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t10, 0, t14, 0, -t7 - t82);
  t133 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t130);
  t134 = t133 * t26;
  t139 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t134 * t48 - t97);
  t141 = my_piecewise5(t14, 0, t10, 0, t7 - t111);
  t144 = my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t141);
  t145 = t144 * t26;
  t150 = t5 * t62 * params->rpbe_mu;
  t151 = t63 * rho[1];
  t153 = 0.1e1 / t65 / t151;
  t156 = t100 * sigma[2] * t153 * t72;
  t160 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t145 * t75 - t124 + t150 * t156 / 0.24e2);
  tvrho1 = t52 + t79 + t6 * (t139 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t163 = t5 * t27;
  t166 = t29 * t33 * t39 * t45;
  t169 = my_piecewise3(t1, 0, -t163 * t166 / 0.64e2);
  tvsigma0 = t6 * t169;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t5 * t62;
  t173 = t29 * t33 * t67 * t72;
  t176 = my_piecewise3(t53, 0, -t170 * t173 / 0.64e2);
  tvsigma2 = t6 * t176;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t179 = t23 * t23;
  t180 = 0.1e1 / t179;
  t181 = t84 * t84;
  t184 = t80 * t6;
  t185 = 0.1e1 / t184;
  t186 = t16 * t185;
  t189 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t81 + 0.2e1 * t186);
  t193 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t181 + 0.4e1 / 0.3e1 * t23 * t189);
  t194 = t193 * t26;
  t198 = t87 * t93;
  t200 = t5 * t198 * t48;
  t203 = t5 * t88 * params->rpbe_mu;
  t207 = 0.1e1 / t92 / t6;
  t208 = t25 * t207;
  t211 = t5 * t208 * t48 / 0.12e2;
  t213 = t5 * t94 * params->rpbe_mu;
  t214 = t213 * t106;
  t216 = t35 * t35;
  t218 = 0.1e1 / t37 / t216;
  t221 = t100 * sigma[0] * t218 * t45;
  t224 = params->rpbe_mu * params->rpbe_mu;
  t226 = t5 * t27 * t224;
  t227 = t28 * t28;
  t230 = t227 / t31 / t30;
  t231 = sigma[0] * sigma[0];
  t232 = t230 * t231;
  t235 = 0.1e1 / t36 / t216 / t101;
  t237 = t235 * t41 * t45;
  t238 = t232 * t237;
  t242 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t194 * t48 - t200 / 0.4e1 + t203 * t106 / 0.12e2 + t211 + t214 / 0.36e2 - 0.11e2 / 0.72e2 * t99 * t221 + t226 * t238 / 0.216e3);
  t243 = t59 * t59;
  t244 = 0.1e1 / t243;
  t245 = t113 * t113;
  t248 = t54 * t185;
  t251 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t81 + 0.2e1 * t248);
  t255 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t245 + 0.4e1 / 0.3e1 * t59 * t251);
  t256 = t255 * t26;
  t260 = t116 * t93;
  t262 = t5 * t260 * t75;
  t264 = t61 * t207;
  t267 = t5 * t264 * t75 / 0.12e2;
  t269 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t256 * t75 - t262 / 0.4e1 + t267);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t6 * (t242 + t269);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t180 * t130;
  t276 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t186);
  t280 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t272 * t84 + 0.4e1 / 0.3e1 * t23 * t276);
  t281 = t280 * t26;
  t285 = t133 * t93;
  t287 = t5 * t285 * t48;
  t290 = t5 * t134 * params->rpbe_mu;
  t296 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t281 * t48 - t287 / 0.8e1 + t290 * t106 / 0.24e2 - t200 / 0.8e1 + t211 + t214 / 0.72e2);
  t297 = t244 * t141;
  t301 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t248);
  t305 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t297 * t113 + 0.4e1 / 0.3e1 * t59 * t301);
  t306 = t305 * t26;
  t310 = t144 * t93;
  t312 = t5 * t310 * t75;
  t316 = t5 * t117 * params->rpbe_mu;
  t320 = t5 * t121 * params->rpbe_mu;
  t321 = t320 * t156;
  t324 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t306 * t75 - t312 / 0.8e1 - t262 / 0.8e1 + t267 + t316 * t156 / 0.24e2 + t321 / 0.72e2);
  tv2rho21 = t110 + t126 + t139 + t160 + t6 * (t296 + t324);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t329 = t130 * t130;
  t334 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t81 + 0.2e1 * t186);
  t338 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t180 * t329 + 0.4e1 / 0.3e1 * t23 * t334);
  t339 = t338 * t26;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t339 * t48 - t287 / 0.4e1 + t211);
  t346 = t141 * t141;
  t351 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t81 + 0.2e1 * t248);
  t355 = my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t244 * t346 + 0.4e1 / 0.3e1 * t59 * t351);
  t356 = t355 * t26;
  t362 = t5 * t145 * params->rpbe_mu;
  t366 = t63 * t63;
  t368 = 0.1e1 / t65 / t366;
  t371 = t100 * sigma[2] * t368 * t72;
  t375 = t5 * t62 * t224;
  t376 = sigma[2] * sigma[2];
  t377 = t230 * t376;
  t380 = 0.1e1 / t64 / t366 / t151;
  t382 = t380 * t41 * t72;
  t383 = t377 * t382;
  t387 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t356 * t75 - t312 / 0.4e1 + t362 * t156 / 0.12e2 + t267 + t321 / 0.36e2 - 0.11e2 / 0.72e2 * t150 * t371 + t375 * t383 / 0.216e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t160 + t6 * (t345 + t387);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t390 = t5 * t88;
  t393 = t5 * t94;
  t395 = t393 * t166 / 0.192e3;
  t398 = t29 * t33 * t103 * t45;
  t401 = t216 * t35;
  t403 = 0.1e1 / t36 / t401;
  t406 = sigma[0] * t41 * t45;
  t407 = t230 * t403 * t406;
  t411 = my_piecewise3(t1, 0, -t390 * t166 / 0.64e2 - t395 + t163 * t398 / 0.24e2 - t226 * t407 / 0.576e3);
  tv2rhosigma0 = t6 * t411 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t413 = t5 * t117;
  t416 = t5 * t121;
  t418 = t416 * t173 / 0.192e3;
  t420 = my_piecewise3(t53, 0, -t413 * t173 / 0.64e2 - t418);
  tv2rhosigma2 = t6 * t420 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t422 = t5 * t134;
  t426 = my_piecewise3(t1, 0, -t422 * t166 / 0.64e2 - t395);
  tv2rhosigma3 = t6 * t426 + t169;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t428 = t5 * t145;
  t433 = t29 * t33 * t153 * t72;
  t436 = t366 * t63;
  t438 = 0.1e1 / t64 / t436;
  t441 = sigma[2] * t41 * t72;
  t442 = t230 * t438 * t441;
  t446 = my_piecewise3(t53, 0, -t428 * t173 / 0.64e2 - t418 + t170 * t433 / 0.24e2 - t375 * t442 / 0.576e3);
  tv2rhosigma5 = t6 * t446 + t176;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t448 = t216 * rho[0];
  t453 = t230 / t36 / t448 * t41 * t45;
  t456 = my_piecewise3(t1, 0, t226 * t453 / 0.1536e4);
  tv2sigma20 = t6 * t456;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t457 = t366 * rho[1];
  t462 = t230 / t64 / t457 * t41 * t72;
  t465 = my_piecewise3(t53, 0, t375 * t462 / 0.1536e4);
  tv2sigma25 = t6 * t465;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t469 = 0.1e1 / t179 / t19;
  t470 = t181 * t84;
  t473 = t180 * t84;
  t476 = t80 * t80;
  t477 = 0.1e1 / t476;
  t478 = t16 * t477;
  t481 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t185 - 0.6e1 * t478);
  t485 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t469 * t470 + 0.4e1 / 0.3e1 * t473 * t189 + 0.4e1 / 0.3e1 * t23 * t481);
  t486 = t485 * t26;
  t491 = t5 * t88 * t224;
  t494 = t213 * t221;
  t497 = t5 * t94 * t224;
  t498 = t497 * t238;
  t501 = 0.1e1 / t37 / t448;
  t504 = t100 * sigma[0] * t501 * t45;
  t507 = t216 * t216;
  t509 = 0.1e1 / t36 / t507;
  t512 = t232 * t509 * t41 * t45;
  t517 = t193 * t93;
  t519 = t5 * t517 * t48;
  t521 = t87 * t207;
  t523 = t5 * t521 * t48;
  t526 = 0.1e1 / t92 / t80;
  t527 = t25 * t526;
  t530 = 0.5e1 / 0.36e2 * t5 * t527 * t48;
  t532 = t5 * t194 * params->rpbe_mu;
  t536 = t5 * t198 * params->rpbe_mu;
  t537 = t536 * t106;
  t540 = t5 * t208 * params->rpbe_mu;
  t541 = t540 * t106;
  t543 = t30 * t30;
  t546 = t2 / t3 / t543;
  t547 = t546 * t27;
  t548 = t224 * params->rpbe_mu;
  t549 = t231 * sigma[0];
  t550 = t548 * t549;
  t551 = t507 * t101;
  t552 = 0.1e1 / t551;
  t553 = params->rpbe_kappa * params->rpbe_kappa;
  t554 = 0.1e1 / t553;
  t557 = t550 * t552 * t554 * t45;
  t560 = -0.3e1 / 0.8e1 * t5 * t486 * t48 + t491 * t238 / 0.72e2 - 0.11e2 / 0.72e2 * t494 + t498 / 0.216e3 + 0.77e2 / 0.108e3 * t99 * t504 - 0.11e2 / 0.216e3 * t226 * t512 - 0.11e2 / 0.24e2 * t203 * t221 - 0.3e1 / 0.8e1 * t519 + t523 / 0.4e1 - t530 + t532 * t106 / 0.8e1 + t537 / 0.12e2 - t541 / 0.36e2 + t547 * t557 / 0.324e3;
  t561 = my_piecewise3(t1, 0, t560);
  t563 = 0.1e1 / t243 / t57;
  t564 = t245 * t113;
  t567 = t244 * t113;
  t570 = t54 * t477;
  t573 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t185 - 0.6e1 * t570);
  t577 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t563 * t564 + 0.4e1 / 0.3e1 * t567 * t251 + 0.4e1 / 0.3e1 * t59 * t573);
  t578 = t577 * t26;
  t582 = t255 * t93;
  t584 = t5 * t582 * t75;
  t586 = t116 * t207;
  t588 = t5 * t586 * t75;
  t590 = t61 * t526;
  t593 = 0.5e1 / 0.36e2 * t5 * t590 * t75;
  t595 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t578 * t75 - 0.3e1 / 0.8e1 * t584 + t588 / 0.4e1 - t593);
  tv3rho30 = 0.3e1 * t242 + 0.3e1 * t269 + t6 * (t561 + t595);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t598 = 0.2e1 * t296;
  t599 = 0.2e1 * t324;
  t600 = t469 * t130;
  t603 = t180 * t276;
  t608 = 0.2e1 * t185;
  t609 = 0.6e1 * t478;
  t611 = my_piecewise5(t10, 0, t14, 0, t608 - t609);
  t615 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t600 * t181 + 0.8e1 / 0.9e1 * t603 * t84 + 0.4e1 / 0.9e1 * t272 * t189 + 0.4e1 / 0.3e1 * t23 * t611);
  t616 = t615 * t26;
  t620 = t280 * t93;
  t623 = t5 * t620 * t48 / 0.4e1;
  t625 = t5 * t281 * params->rpbe_mu;
  t628 = t133 * t207;
  t630 = t5 * t628 * t48;
  t633 = t5 * t285 * params->rpbe_mu;
  t635 = t633 * t106 / 0.36e2;
  t639 = t5 * t134 * t224;
  t648 = -0.3e1 / 0.8e1 * t5 * t616 * t48 - t623 + t625 * t106 / 0.12e2 + t630 / 0.12e2 + t635 - 0.11e2 / 0.72e2 * t290 * t221 + t639 * t238 / 0.216e3 - t519 / 0.8e1 + t523 / 0.6e1 + t537 / 0.36e2 - t530 - t541 / 0.54e2 - 0.11e2 / 0.216e3 * t494 + t498 / 0.648e3;
  t649 = my_piecewise3(t1, 0, t648);
  t650 = t563 * t141;
  t653 = t244 * t301;
  t658 = 0.6e1 * t570;
  t660 = my_piecewise5(t14, 0, t10, 0, -t608 - t658);
  t664 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t650 * t245 + 0.8e1 / 0.9e1 * t653 * t113 + 0.4e1 / 0.9e1 * t297 * t251 + 0.4e1 / 0.3e1 * t59 * t660);
  t665 = t664 * t26;
  t669 = t305 * t93;
  t672 = t5 * t669 * t75 / 0.4e1;
  t673 = t144 * t207;
  t675 = t5 * t673 * t75;
  t680 = t5 * t256 * params->rpbe_mu;
  t684 = t5 * t260 * params->rpbe_mu;
  t686 = t684 * t156 / 0.36e2;
  t688 = t5 * t264 * params->rpbe_mu;
  t689 = t688 * t156;
  t692 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t665 * t75 - t672 + t675 / 0.12e2 - t584 / 0.8e1 + t588 / 0.6e1 - t593 + t680 * t156 / 0.24e2 + t686 - t689 / 0.108e3);
  tv3rho31 = t242 + t269 + t598 + t599 + t6 * (t649 + t692);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t695 = t469 * t329;
  t700 = t180 * t334;
  t704 = my_piecewise5(t10, 0, t14, 0, -t608 - t609);
  t708 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t695 * t84 + 0.8e1 / 0.9e1 * t272 * t276 + 0.4e1 / 0.9e1 * t700 * t84 + 0.4e1 / 0.3e1 * t23 * t704);
  t709 = t708 * t26;
  t713 = t338 * t93;
  t715 = t5 * t713 * t48;
  t718 = t5 * t339 * params->rpbe_mu;
  t725 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t709 * t48 - t715 / 0.8e1 + t718 * t106 / 0.24e2 - t623 + t630 / 0.6e1 + t635 + t523 / 0.12e2 - t530 - t541 / 0.108e3);
  t726 = t563 * t346;
  t731 = t244 * t351;
  t735 = my_piecewise5(t14, 0, t10, 0, t608 - t658);
  t739 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t726 * t113 + 0.8e1 / 0.9e1 * t297 * t301 + 0.4e1 / 0.9e1 * t731 * t113 + 0.4e1 / 0.3e1 * t59 * t735);
  t740 = t739 * t26;
  t744 = t355 * t93;
  t746 = t5 * t744 * t75;
  t750 = t5 * t306 * params->rpbe_mu;
  t754 = t5 * t310 * params->rpbe_mu;
  t755 = t754 * t156;
  t761 = t320 * t371;
  t764 = t5 * t117 * t224;
  t768 = t5 * t121 * t224;
  t769 = t768 * t383;
  t771 = -0.3e1 / 0.8e1 * t5 * t740 * t75 - t746 / 0.8e1 - t672 + t675 / 0.6e1 + t750 * t156 / 0.12e2 + t755 / 0.36e2 + t588 / 0.12e2 - t593 + t686 - t689 / 0.54e2 - 0.11e2 / 0.72e2 * t316 * t371 - 0.11e2 / 0.216e3 * t761 + t764 * t383 / 0.216e3 + t769 / 0.648e3;
  t772 = my_piecewise3(t53, 0, t771);
  tv3rho32 = t598 + t599 + t345 + t387 + t6 * (t725 + t772);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t777 = t329 * t130;
  t784 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t185 - 0.6e1 * t478);
  t788 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t469 * t777 + 0.4e1 / 0.3e1 * t272 * t334 + 0.4e1 / 0.3e1 * t23 * t784);
  t789 = t788 * t26;
  t796 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t789 * t48 - 0.3e1 / 0.8e1 * t715 + t630 / 0.4e1 - t530);
  t798 = t346 * t141;
  t805 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t185 - 0.6e1 * t570);
  t809 = my_piecewise3(t58, 0, -0.8e1 / 0.27e2 * t563 * t798 + 0.4e1 / 0.3e1 * t297 * t351 + 0.4e1 / 0.3e1 * t59 * t805);
  t810 = t809 * t26;
  t815 = 0.1e1 / t65 / t457;
  t818 = t100 * sigma[2] * t815 * t72;
  t821 = t366 * t366;
  t823 = 0.1e1 / t64 / t821;
  t826 = t377 * t823 * t41 * t72;
  t832 = t5 * t145 * t224;
  t841 = t5 * t356 * params->rpbe_mu;
  t844 = t546 * t62;
  t845 = t376 * sigma[2];
  t846 = t548 * t845;
  t847 = t821 * t151;
  t848 = 0.1e1 / t847;
  t851 = t846 * t848 * t554 * t72;
  t854 = t769 / 0.216e3 - 0.3e1 / 0.8e1 * t5 * t810 * t75 + 0.77e2 / 0.108e3 * t150 * t818 - 0.11e2 / 0.216e3 * t375 * t826 - 0.11e2 / 0.24e2 * t362 * t371 + t832 * t383 / 0.72e2 + t755 / 0.12e2 - 0.11e2 / 0.72e2 * t761 - t689 / 0.36e2 - 0.3e1 / 0.8e1 * t746 + t675 / 0.4e1 - t593 + t841 * t156 / 0.8e1 + t844 * t851 / 0.324e3;
  t855 = my_piecewise3(t53, 0, t854);
  tv3rho33 = 0.3e1 * t345 + 0.3e1 * t387 + t6 * (t796 + t855);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t859 = t5 * t194;
  t862 = t5 * t198;
  t863 = t862 * t166;
  t869 = t5 * t208;
  t871 = t869 * t166 / 0.288e3;
  t872 = t393 * t398;
  t874 = t497 * t407;
  t878 = t29 * t33 * t218 * t45;
  t882 = t230 * t235 * t406;
  t885 = t507 * t35;
  t887 = t548 / t885;
  t889 = t231 * t554 * t45;
  t890 = t887 * t889;
  t894 = my_piecewise3(t1, 0, -t859 * t166 / 0.64e2 - t863 / 0.96e2 + t390 * t398 / 0.12e2 - t491 * t407 / 0.288e3 + t871 + t872 / 0.36e2 - t874 / 0.864e3 - 0.11e2 / 0.72e2 * t163 * t878 + t226 * t882 / 0.64e2 - t547 * t890 / 0.864e3);
  tv3rho2sigma0 = t6 * t894 + 0.2e1 * t411;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t897 = t5 * t256;
  t900 = t5 * t260;
  t901 = t900 * t173;
  t903 = t5 * t264;
  t905 = t903 * t173 / 0.288e3;
  t907 = my_piecewise3(t53, 0, -t897 * t173 / 0.64e2 - t901 / 0.96e2 + t905);
  tv3rho2sigma2 = t6 * t907 + 0.2e1 * t420;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t909 = t5 * t281;
  t912 = t5 * t285;
  t913 = t912 * t166;
  t923 = my_piecewise3(t1, 0, -t909 * t166 / 0.64e2 - t913 / 0.192e3 + t422 * t398 / 0.24e2 - t639 * t407 / 0.576e3 - t863 / 0.192e3 + t871 + t872 / 0.72e2 - t874 / 0.1728e4);
  tv3rho2sigma3 = t6 * t923 + t411 + t426;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t925 = t5 * t306;
  t928 = t5 * t310;
  t929 = t928 * t173;
  t934 = t416 * t433;
  t938 = t768 * t442;
  t941 = my_piecewise3(t53, 0, -t925 * t173 / 0.64e2 - t929 / 0.192e3 - t901 / 0.192e3 + t905 + t413 * t433 / 0.24e2 + t934 / 0.72e2 - t764 * t442 / 0.576e3 - t938 / 0.1728e4);
  tv3rho2sigma5 = t6 * t941 + t420 + t446;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t944 = t5 * t339;
  t949 = my_piecewise3(t1, 0, -t944 * t166 / 0.64e2 - t913 / 0.96e2 + t871);
  tv3rho2sigma6 = t6 * t949 + 0.2e1 * t426;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t952 = t5 * t356;
  t964 = t29 * t33 * t368 * t72;
  t968 = t230 * t380 * t441;
  t971 = t821 * t63;
  t973 = t548 / t971;
  t975 = t376 * t554 * t72;
  t976 = t973 * t975;
  t980 = my_piecewise3(t53, 0, -t952 * t173 / 0.64e2 - t929 / 0.96e2 + t428 * t433 / 0.12e2 - t832 * t442 / 0.288e3 + t905 + t934 / 0.36e2 - t938 / 0.864e3 - 0.11e2 / 0.72e2 * t170 * t964 + t375 * t968 / 0.64e2 - t844 * t976 / 0.864e3);
  tv3rho2sigma8 = t6 * t980 + 0.2e1 * t446;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t985 = t497 * t453 / 0.4608e4;
  t988 = t230 * t403 * t41 * t45;
  t991 = t507 * rho[0];
  t993 = t548 / t991;
  t995 = t554 * sigma[0] * t45;
  t996 = t993 * t995;
  t1000 = my_piecewise3(t1, 0, t491 * t453 / 0.1536e4 + t985 - t226 * t988 / 0.288e3 + t547 * t996 / 0.2304e4);
  tv3rhosigma20 = t6 * t1000 + t456;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1005 = t768 * t462 / 0.4608e4;
  t1007 = my_piecewise3(t53, 0, t764 * t462 / 0.1536e4 + t1005);
  tv3rhosigma25 = t6 * t1007 + t465;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1012 = my_piecewise3(t1, 0, t639 * t453 / 0.1536e4 + t985);
  tv3rhosigma26 = t6 * t1012 + t456;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1018 = t230 * t438 * t41 * t72;
  t1021 = t821 * rho[1];
  t1023 = t548 / t1021;
  t1025 = t554 * sigma[2] * t72;
  t1026 = t1023 * t1025;
  t1030 = my_piecewise3(t53, 0, t832 * t462 / 0.1536e4 + t1005 - t375 * t1018 / 0.288e3 + t844 * t1026 / 0.2304e4);
  tv3rhosigma211 = t6 * t1030 + t465;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1034 = t554 * t45;
  t1035 = t548 / t507 * t1034;
  t1038 = my_piecewise3(t1, 0, -t547 * t1035 / 0.6144e4);
  tv3sigma30 = t6 * t1038;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1041 = t554 * t72;
  t1042 = t548 / t821 * t1041;
  t1045 = my_piecewise3(t53, 0, -t844 * t1042 / 0.6144e4);
  tv3sigma39 = t6 * t1045;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1048 = t213 * t504;
  t1057 = t540 * t221;
  t1063 = t536 * t221;
  t1071 = t5 * t517 * params->rpbe_mu * t106;
  t1075 = t5 * t521 * params->rpbe_mu * t106;
  t1079 = t5 * t527 * params->rpbe_mu * t106;
  t1082 = 0.1e1 / t92 / t184;
  t1086 = 0.1e2 / 0.27e2 * t5 * t25 * t1082 * t48;
  t1089 = t5 * t485 * t93 * t48;
  t1091 = 0.77e2 / 0.81e2 * t1048 - 0.1309e4 / 0.324e3 * t99 * t100 * sigma[0] / t37 / t401 * t45 + 0.11e2 / 0.54e2 * t1057 + t5 * t486 * params->rpbe_mu * t106 / 0.6e1 - 0.11e2 / 0.18e2 * t1063 + 0.77e2 / 0.27e2 * t203 * t504 - 0.11e2 / 0.12e2 * t532 * t221 + t1071 / 0.6e1 - t1075 / 0.9e1 + 0.5e1 / 0.81e2 * t1079 + t1086 - t1089 / 0.2e1;
  t1094 = t5 * t193 * t207 * t48;
  t1098 = t5 * t87 * t526 * t48;
  t1100 = t19 * t19;
  t1102 = 0.1e1 / t179 / t1100;
  t1103 = t181 * t181;
  t1109 = t189 * t189;
  t1115 = 0.1e1 / t476 / t6;
  t1116 = t16 * t1115;
  t1119 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t477 + 0.24e2 * t1116);
  t1123 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1102 * t1103 - 0.16e2 / 0.9e1 * t469 * t181 * t189 + 0.4e1 / 0.3e1 * t180 * t1109 + 0.16e2 / 0.9e1 * t473 * t481 + 0.4e1 / 0.3e1 * t23 * t1119);
  t1128 = t497 * t512;
  t1138 = t5 * t194 * t224;
  t1142 = t5 * t198 * t224;
  t1143 = t1142 * t238;
  t1148 = t5 * t208 * t224;
  t1149 = t1148 * t238;
  t1151 = t224 * t224;
  t1153 = t546 * t27 * t1151;
  t1154 = t231 * t231;
  t1160 = 0.1e1 / t553 / params->rpbe_kappa;
  t1162 = t100 * t45;
  t1166 = t546 * t88;
  t1169 = t546 * t94;
  t1170 = t1169 * t557;
  t1172 = t507 * t216;
  t1179 = t1094 / 0.2e1 - 0.5e1 / 0.9e1 * t1098 - 0.3e1 / 0.8e1 * t5 * t1123 * t26 * t48 - 0.11e2 / 0.162e3 * t1128 + 0.979e3 / 0.1944e4 * t226 * t232 / t36 / t991 * t41 * t45 + t1138 * t238 / 0.36e2 + t1143 / 0.54e2 - 0.11e2 / 0.54e2 * t491 * t512 - t1149 / 0.162e3 + t1153 * t1154 / t37 / t507 / t401 * t1160 * t1162 / 0.2916e4 + t1166 * t557 / 0.81e2 + t1170 / 0.243e3 - 0.11e2 / 0.162e3 * t547 * t550 / t1172 * t554 * t45;
  t1181 = my_piecewise3(t1, 0, t1091 + t1179);
  t1182 = t57 * t57;
  t1184 = 0.1e1 / t243 / t1182;
  t1185 = t245 * t245;
  t1191 = t251 * t251;
  t1196 = t54 * t1115;
  t1199 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t477 + 0.24e2 * t1196);
  t1203 = my_piecewise3(t58, 0, 0.4e2 / 0.81e2 * t1184 * t1185 - 0.16e2 / 0.9e1 * t563 * t245 * t251 + 0.4e1 / 0.3e1 * t244 * t1191 + 0.16e2 / 0.9e1 * t567 * t573 + 0.4e1 / 0.3e1 * t59 * t1199);
  t1210 = t5 * t577 * t93 * t75;
  t1214 = t5 * t255 * t207 * t75;
  t1218 = t5 * t116 * t526 * t75;
  t1223 = 0.1e2 / 0.27e2 * t5 * t61 * t1082 * t75;
  t1225 = my_piecewise3(t53, 0, -0.3e1 / 0.8e1 * t5 * t1203 * t26 * t75 - t1210 / 0.2e1 + t1214 / 0.2e1 - 0.5e1 / 0.9e1 * t1218 + t1223);
  tv4rho40 = 0.4e1 * t561 + 0.4e1 * t595 + t6 * (t1181 + t1225);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1232 = t5 * t628 * params->rpbe_mu * t106;
  t1233 = t1232 / 0.36e2;
  t1240 = t633 * t221;
  t1252 = t5 * t620 * params->rpbe_mu * t106;
  t1256 = t5 * t280 * t207 * t48;
  t1257 = t1256 / 0.4e1;
  t1260 = t5 * t133 * t526 * t48;
  t1262 = -t1233 + 0.77e2 / 0.324e3 * t1048 + 0.11e2 / 0.108e3 * t1057 - 0.11e2 / 0.72e2 * t1063 + t1071 / 0.24e2 - t1075 / 0.18e2 + 0.5e1 / 0.108e3 * t1079 - 0.11e2 / 0.72e2 * t1240 + 0.77e2 / 0.108e3 * t290 * t504 - 0.11e2 / 0.24e2 * t625 * t221 + t5 * t616 * params->rpbe_mu * t106 / 0.8e1 + t1252 / 0.12e2 + t1257 - 0.5e1 / 0.36e2 * t1260;
  t1279 = 0.12e2 * t477;
  t1280 = 0.24e2 * t1116;
  t1282 = my_piecewise5(t10, 0, t14, 0, -t1279 + t1280);
  t1286 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1102 * t130 * t470 - 0.8e1 / 0.9e1 * t469 * t276 * t181 - 0.8e1 / 0.9e1 * t600 * t84 * t189 + 0.4e1 / 0.3e1 * t180 * t611 * t84 + 0.4e1 / 0.3e1 * t603 * t189 + 0.4e1 / 0.9e1 * t272 * t481 + 0.4e1 / 0.3e1 * t23 * t1282);
  t1296 = t5 * t615 * t93 * t48;
  t1300 = t5 * t281 * t224;
  t1304 = t5 * t285 * t224;
  t1305 = t1304 * t238;
  t1312 = t546 * t134;
  t1315 = -0.3e1 / 0.8e1 * t5 * t1286 * t26 * t48 + t1086 - t1089 / 0.8e1 + t1094 / 0.4e1 - 0.5e1 / 0.12e2 * t1098 - 0.3e1 / 0.8e1 * t1296 - 0.11e2 / 0.648e3 * t1128 + t1300 * t238 / 0.72e2 + t1305 / 0.216e3 - 0.11e2 / 0.216e3 * t639 * t512 + t1143 / 0.216e3 - t1149 / 0.324e3 + t1170 / 0.972e3 + t1312 * t557 / 0.324e3;
  t1317 = my_piecewise3(t1, 0, t1262 + t1315);
  t1334 = 0.24e2 * t1196;
  t1336 = my_piecewise5(t14, 0, t10, 0, t1279 + t1334);
  t1340 = my_piecewise3(t58, 0, 0.4e2 / 0.81e2 * t1184 * t141 * t564 - 0.8e1 / 0.9e1 * t563 * t301 * t245 - 0.8e1 / 0.9e1 * t650 * t113 * t251 + 0.4e1 / 0.3e1 * t244 * t660 * t113 + 0.4e1 / 0.3e1 * t653 * t251 + 0.4e1 / 0.9e1 * t297 * t573 + 0.4e1 / 0.3e1 * t59 * t1336);
  t1347 = t5 * t664 * t93 * t75;
  t1351 = t5 * t305 * t207 * t75;
  t1352 = t1351 / 0.4e1;
  t1355 = t5 * t144 * t526 * t75;
  t1366 = t5 * t582 * params->rpbe_mu * t156;
  t1370 = t5 * t586 * params->rpbe_mu * t156;
  t1371 = t1370 / 0.36e2;
  t1374 = t5 * t590 * params->rpbe_mu * t156;
  t1376 = -0.3e1 / 0.8e1 * t5 * t1340 * t26 * t75 - 0.3e1 / 0.8e1 * t1347 + t1352 - 0.5e1 / 0.36e2 * t1355 - t1210 / 0.8e1 + t1214 / 0.4e1 - 0.5e1 / 0.12e2 * t1218 + t1223 + t5 * t578 * params->rpbe_mu * t156 / 0.24e2 + t1366 / 0.24e2 - t1371 + 0.5e1 / 0.324e3 * t1374;
  t1377 = my_piecewise3(t53, 0, t1376);
  tv4rho41 = t561 + t595 + 0.3e1 * t649 + 0.3e1 * t692 + t6 * (t1317 + t1377);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1387 = t5 * t339 * t224;
  t1392 = t5 * t708 * t93 * t48;
  t1396 = t5 * t338 * t207 * t48;
  t1413 = t276 * t276;
  t1426 = my_piecewise5(t10, 0, t14, 0, t1280);
  t1430 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1102 * t329 * t181 - 0.32e2 / 0.27e2 * t600 * t84 * t276 - 0.8e1 / 0.27e2 * t695 * t189 + 0.8e1 / 0.9e1 * t180 * t1413 + 0.8e1 / 0.9e1 * t272 * t611 - 0.8e1 / 0.27e2 * t469 * t334 * t181 + 0.8e1 / 0.9e1 * t180 * t704 * t84 + 0.4e1 / 0.9e1 * t700 * t189 + 0.4e1 / 0.3e1 * t23 * t1426);
  t1448 = t5 * t713 * params->rpbe_mu * t106;
  t1450 = -t1149 / 0.972e3 - 0.3e1 / 0.8e1 * t5 * t1430 * t26 * t48 - 0.11e2 / 0.108e3 * t1240 + t1305 / 0.324e3 + 0.11e2 / 0.324e3 * t1057 - t1075 / 0.54e2 + 0.5e1 / 0.162e3 * t1079 + t1252 / 0.18e2 - t1232 / 0.27e2 + t5 * t709 * params->rpbe_mu * t106 / 0.12e2 + t1448 / 0.36e2;
  t1452 = my_piecewise3(t1, 0, -0.11e2 / 0.72e2 * t718 * t221 + t1387 * t238 / 0.216e3 - t1392 / 0.4e1 + t1396 / 0.12e2 + t1086 - t1296 / 0.4e1 + t1256 / 0.3e1 - 0.5e1 / 0.18e2 * t1260 + t1094 / 0.12e2 - 0.5e1 / 0.18e2 * t1098 + t1450);
  t1455 = t684 * t371;
  t1457 = t688 * t371;
  t1460 = t5 * t256 * t224;
  t1465 = t5 * t669 * params->rpbe_mu * t156;
  t1469 = t5 * t673 * params->rpbe_mu * t156;
  t1476 = t5 * t739 * t93 * t75;
  t1481 = t5 * t355 * t207 * t75;
  t1486 = t5 * t264 * t224;
  t1487 = t1486 * t383;
  t1490 = t5 * t260 * t224;
  t1491 = t1490 * t383;
  t1501 = t301 * t301;
  t1514 = my_piecewise5(t14, 0, t10, 0, t1334);
  t1518 = my_piecewise3(t58, 0, 0.4e2 / 0.81e2 * t1184 * t346 * t245 - 0.32e2 / 0.27e2 * t650 * t113 * t301 - 0.8e1 / 0.27e2 * t726 * t251 + 0.8e1 / 0.9e1 * t244 * t1501 + 0.8e1 / 0.9e1 * t297 * t660 - 0.8e1 / 0.27e2 * t563 * t351 * t245 + 0.8e1 / 0.9e1 * t244 * t735 * t113 + 0.4e1 / 0.9e1 * t731 * t251 + 0.4e1 / 0.3e1 * t59 * t1514);
  t1530 = t1481 / 0.12e2 + t1214 / 0.12e2 - 0.5e1 / 0.18e2 * t1218 + t1223 - t1487 / 0.972e3 + t1491 / 0.324e3 - 0.3e1 / 0.8e1 * t5 * t1518 * t26 * t75 + t1366 / 0.36e2 - t1370 / 0.27e2 + 0.5e1 / 0.162e3 * t1374 + t5 * t665 * params->rpbe_mu * t156 / 0.12e2;
  t1532 = my_piecewise3(t53, 0, -0.11e2 / 0.72e2 * t680 * t371 - 0.11e2 / 0.108e3 * t1455 + 0.11e2 / 0.324e3 * t1457 + t1460 * t383 / 0.216e3 + t1465 / 0.18e2 - t1469 / 0.54e2 - t1347 / 0.4e1 + t1351 / 0.3e1 - 0.5e1 / 0.18e2 * t1355 - t1476 / 0.4e1 + t1530);
  tv4rho42 = 0.2e1 * t649 + 0.2e1 * t692 + 0.2e1 * t725 + 0.2e1 * t772 + t6 * (t1452 + t1532);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1553 = my_piecewise5(t10, 0, t14, 0, t1279 + t1280);
  t1557 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1102 * t777 * t84 - 0.8e1 / 0.9e1 * t695 * t276 - 0.8e1 / 0.9e1 * t600 * t334 * t84 + 0.4e1 / 0.3e1 * t603 * t334 + 0.4e1 / 0.3e1 * t272 * t704 + 0.4e1 / 0.9e1 * t180 * t784 * t84 + 0.4e1 / 0.3e1 * t23 * t1553);
  t1564 = t5 * t788 * t93 * t48;
  t1576 = -0.3e1 / 0.8e1 * t5 * t1557 * t26 * t48 - t1564 / 0.8e1 + t5 * t789 * params->rpbe_mu * t106 / 0.24e2 - 0.3e1 / 0.8e1 * t1392 + t1396 / 0.4e1 + t1448 / 0.24e2 + t1257 - 0.5e1 / 0.12e2 * t1260 - t1233 - 0.5e1 / 0.36e2 * t1098 + t1086 + 0.5e1 / 0.324e3 * t1079;
  t1577 = my_piecewise3(t1, 0, t1576);
  t1586 = t320 * t818;
  t1588 = t754 * t371;
  t1592 = t5 * t744 * params->rpbe_mu * t156;
  t1601 = t5 * t809 * t93 * t75;
  t1619 = my_piecewise5(t14, 0, t10, 0, -t1279 + t1334);
  t1623 = my_piecewise3(t58, 0, 0.4e2 / 0.81e2 * t1184 * t798 * t113 - 0.8e1 / 0.9e1 * t726 * t301 - 0.8e1 / 0.9e1 * t650 * t351 * t113 + 0.4e1 / 0.3e1 * t653 * t351 + 0.4e1 / 0.3e1 * t297 * t735 + 0.4e1 / 0.9e1 * t244 * t805 * t113 + 0.4e1 / 0.3e1 * t59 * t1619);
  t1628 = t5 * t740 * params->rpbe_mu * t156 / 0.8e1 + 0.77e2 / 0.108e3 * t316 * t818 - 0.11e2 / 0.24e2 * t750 * t371 + 0.77e2 / 0.324e3 * t1586 - 0.11e2 / 0.72e2 * t1588 + t1592 / 0.24e2 - t1371 + 0.5e1 / 0.108e3 * t1374 - 0.11e2 / 0.72e2 * t1455 + 0.11e2 / 0.108e3 * t1457 + t1465 / 0.12e2 - t1469 / 0.18e2 - t1601 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1623 * t26 * t75;
  t1636 = t5 * t306 * t224;
  t1640 = t5 * t310 * t224;
  t1641 = t1640 * t383;
  t1643 = t768 * t826;
  t1647 = t546 * t121;
  t1648 = t1647 * t851;
  t1650 = t546 * t117;
  t1653 = t1352 - 0.5e1 / 0.12e2 * t1355 - 0.3e1 / 0.8e1 * t1476 + t1481 / 0.4e1 - 0.5e1 / 0.36e2 * t1218 + t1223 - 0.11e2 / 0.216e3 * t764 * t826 + t1636 * t383 / 0.72e2 + t1641 / 0.216e3 - 0.11e2 / 0.648e3 * t1643 - t1487 / 0.324e3 + t1491 / 0.216e3 + t1648 / 0.972e3 + t1650 * t851 / 0.324e3;
  t1655 = my_piecewise3(t53, 0, t1628 + t1653);
  tv4rho43 = 0.3e1 * t725 + 0.3e1 * t772 + t796 + t855 + t6 * (t1577 + t1655);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1660 = t329 * t329;
  t1665 = t334 * t334;
  t1672 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t477 + 0.24e2 * t1116);
  t1676 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1102 * t1660 - 0.16e2 / 0.9e1 * t695 * t334 + 0.4e1 / 0.3e1 * t180 * t1665 + 0.16e2 / 0.9e1 * t272 * t784 + 0.4e1 / 0.3e1 * t23 * t1672);
  t1685 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1676 * t26 * t48 - t1564 / 0.2e1 + t1396 / 0.2e1 - 0.5e1 / 0.9e1 * t1260 + t1086);
  t1708 = t346 * t346;
  t1713 = t351 * t351;
  t1720 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t477 + 0.24e2 * t1196);
  t1724 = my_piecewise3(t58, 0, 0.4e2 / 0.81e2 * t1184 * t1708 - 0.16e2 / 0.9e1 * t726 * t351 + 0.4e1 / 0.3e1 * t244 * t1713 + 0.16e2 / 0.9e1 * t297 * t805 + 0.4e1 / 0.3e1 * t59 * t1720);
  t1729 = 0.77e2 / 0.81e2 * t1586 - 0.11e2 / 0.18e2 * t1588 + t1592 / 0.6e1 + t5 * t810 * params->rpbe_mu * t156 / 0.6e1 + 0.77e2 / 0.27e2 * t362 * t818 - 0.11e2 / 0.12e2 * t841 * t371 - 0.1309e4 / 0.324e3 * t150 * t100 * sigma[2] / t65 / t436 * t72 + 0.5e1 / 0.81e2 * t1374 + 0.11e2 / 0.54e2 * t1457 - t1469 / 0.9e1 - t1601 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t1724 * t26 * t75;
  t1735 = t546 * t62 * t1151;
  t1736 = t376 * t376;
  t1742 = t100 * t72;
  t1747 = t5 * t356 * t224;
  t1761 = t821 * t366;
  t1768 = t546 * t145;
  t1771 = -0.5e1 / 0.9e1 * t1355 + t1481 / 0.2e1 + t1223 + t1641 / 0.54e2 - 0.11e2 / 0.162e3 * t1643 + t1735 * t1736 / t65 / t821 / t436 * t1160 * t1742 / 0.2916e4 + t1747 * t383 / 0.36e2 + 0.979e3 / 0.1944e4 * t375 * t377 / t64 / t1021 * t41 * t72 - 0.11e2 / 0.54e2 * t832 * t826 - t1487 / 0.162e3 + t1648 / 0.243e3 - 0.11e2 / 0.162e3 * t844 * t846 / t1761 * t554 * t72 + t1768 * t851 / 0.81e2;
  t1773 = my_piecewise3(t53, 0, t1729 + t1771);
  tv4rho44 = 0.4e1 * t796 + 0.4e1 * t855 + t6 * (t1685 + t1773);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1782 = t862 * t398;
  t1788 = 0.5e1 / 0.864e3 * t5 * t527 * t166;
  t1789 = t869 * t398;
  t1791 = t393 * t878;
  t1794 = t5 * t517 * t166;
  t1799 = t5 * t521 * t166;
  t1801 = t497 * t882;
  t1817 = t1142 * t407;
  t1821 = t1148 * t407;
  t1828 = t1169 * t890;
  t1834 = 0.77e2 / 0.108e3 * t163 * t29 * t33 * t501 * t45 + t1782 / 0.12e2 - 0.11e2 / 0.24e2 * t390 * t878 - t1788 - t1789 / 0.36e2 - 0.11e2 / 0.72e2 * t1791 - t1794 / 0.64e2 + t859 * t398 / 0.8e1 + t1799 / 0.96e2 + t1801 / 0.64e2 - 0.341e3 / 0.2592e4 * t226 * t230 * t509 * t406 - t1153 / t37 / t507 / t448 * t549 * t1160 * t1162 / 0.7776e4 - t1138 * t407 / 0.192e3 - t1817 / 0.288e3 + 0.3e1 / 0.64e2 * t491 * t882 + t1821 / 0.864e3 - t5 * t486 * t166 / 0.64e2 - t1166 * t890 / 0.288e3 - t1828 / 0.864e3 + 0.19e2 / 0.864e3 * t547 * t548 * t552 * t889;
  t1835 = my_piecewise3(t1, 0, t1834);
  tv4rho3sigma0 = t6 * t1835 + 0.3e1 * t894;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1842 = t5 * t582 * t173;
  t1845 = t5 * t586 * t173;
  t1849 = 0.5e1 / 0.864e3 * t5 * t590 * t173;
  t1851 = my_piecewise3(t53, 0, -t5 * t578 * t173 / 0.64e2 - t1842 / 0.64e2 + t1845 / 0.96e2 - t1849);
  tv4rho3sigma2 = t6 * t1851 + 0.3e1 * t907;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1853 = 0.2e1 * t923;
  t1857 = t912 * t398 / 0.36e2;
  t1862 = t5 * t620 * t166 / 0.96e2;
  t1866 = t5 * t628 * t166;
  t1876 = t1304 * t407 / 0.864e3;
  t1886 = -t1312 * t890 / 0.864e3 + t1857 - 0.11e2 / 0.72e2 * t422 * t878 - t1862 + t909 * t398 / 0.12e2 + t1866 / 0.288e3 + t1782 / 0.36e2 - t1788 - t1789 / 0.54e2 - 0.11e2 / 0.216e3 * t1791 - t1794 / 0.192e3 + t1799 / 0.144e3 - t1300 * t407 / 0.288e3 - t1876 + t639 * t882 / 0.64e2 + t1801 / 0.192e3 - t1817 / 0.864e3 + t1821 / 0.1296e4 - t1828 / 0.2592e4 - t5 * t616 * t166 / 0.64e2;
  t1887 = my_piecewise3(t1, 0, t1886);
  tv4rho3sigma3 = t6 * t1887 + t1853 + t894;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1889 = 0.2e1 * t941;
  t1895 = t5 * t669 * t173 / 0.96e2;
  t1897 = t5 * t673 * t173;
  t1904 = t900 * t433 / 0.36e2;
  t1905 = t903 * t433;
  t1910 = t1490 * t442 / 0.864e3;
  t1911 = t1486 * t442;
  t1913 = -t5 * t665 * t173 / 0.64e2 - t1895 + t1897 / 0.288e3 - t1842 / 0.192e3 + t1845 / 0.144e3 - t1849 + t897 * t433 / 0.24e2 + t1904 - t1905 / 0.108e3 - t1460 * t442 / 0.576e3 - t1910 + t1911 / 0.2592e4;
  t1914 = my_piecewise3(t53, 0, t1913);
  tv4rho3sigma5 = t6 * t1914 + t1889 + t907;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1920 = t5 * t713 * t166;
  t1930 = -t5 * t709 * t166 / 0.64e2 - t1920 / 0.192e3 + t944 * t398 / 0.24e2 - t1387 * t407 / 0.576e3 - t1862 + t1866 / 0.144e3 + t1857 - t1876 + t1799 / 0.288e3 - t1788 - t1789 / 0.108e3 + t1821 / 0.2592e4;
  t1931 = my_piecewise3(t1, 0, t1930);
  tv4rho3sigma6 = t6 * t1931 + t1853 + t949;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1937 = t5 * t744 * t173;
  t1942 = t928 * t433;
  t1946 = t1640 * t442;
  t1953 = t416 * t964;
  t1957 = t768 * t968;
  t1961 = t1647 * t976;
  t1963 = -t5 * t740 * t173 / 0.64e2 - t1937 / 0.192e3 - t1895 + t1897 / 0.144e3 + t925 * t433 / 0.12e2 + t1942 / 0.36e2 - t1636 * t442 / 0.288e3 - t1946 / 0.864e3 + t1845 / 0.288e3 - t1849 + t1904 - t1905 / 0.54e2 - t1910 + t1911 / 0.1296e4 - 0.11e2 / 0.72e2 * t413 * t964 - 0.11e2 / 0.216e3 * t1953 + t764 * t968 / 0.64e2 + t1957 / 0.192e3 - t1650 * t976 / 0.864e3 - t1961 / 0.2592e4;
  t1964 = my_piecewise3(t53, 0, t1963);
  tv4rho3sigma8 = t6 * t1964 + t1889 + t980;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t1973 = my_piecewise3(t1, 0, -t5 * t789 * t166 / 0.64e2 - t1920 / 0.64e2 + t1866 / 0.96e2 - t1788);
  tv4rho3sigma9 = t6 * t1973 + 0.3e1 * t949;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2019 = 0.19e2 / 0.864e3 * t844 * t548 * t848 * t975 - t5 * t810 * t173 / 0.64e2 - t1768 * t976 / 0.288e3 - 0.11e2 / 0.24e2 * t428 * t964 + 0.77e2 / 0.108e3 * t170 * t29 * t33 * t815 * t72 + t952 * t433 / 0.8e1 - t1961 / 0.864e3 - t1937 / 0.64e2 + t1942 / 0.12e2 - 0.11e2 / 0.72e2 * t1953 - t1905 / 0.36e2 + t1897 / 0.96e2 - t1849 - 0.341e3 / 0.2592e4 * t375 * t230 * t823 * t441 - t1735 / t65 / t821 / t457 * t845 * t1160 * t1742 / 0.7776e4 - t1747 * t442 / 0.192e3 + 0.3e1 / 0.64e2 * t832 * t968 + t1957 / 0.64e2 + t1911 / 0.864e3 - t1946 / 0.288e3;
  t2020 = my_piecewise3(t53, 0, t2019);
  tv4rho3sigma11 = t6 * t2020 + 0.3e1 * t980;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2025 = t1142 * t453;
  t2032 = t1148 * t453 / 0.6912e4;
  t2033 = t497 * t988;
  t2035 = t1169 * t996;
  t2051 = my_piecewise3(t1, 0, t1138 * t453 / 0.1536e4 + t2025 / 0.2304e4 - t491 * t988 / 0.144e3 + t1166 * t996 / 0.1152e4 - t2032 - t2033 / 0.432e3 + t2035 / 0.3456e4 + 0.19e2 / 0.864e3 * t226 * t230 * t237 - 0.43e2 / 0.6912e4 * t547 * t887 * t995 + t1153 / t37 / t1172 * t1160 * t231 * t1162 / 0.20736e5);
  tv4rho2sigma20 = t6 * t2051 + 0.2e1 * t1000;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2056 = t1490 * t462;
  t2059 = t1486 * t462 / 0.6912e4;
  t2061 = my_piecewise3(t53, 0, t1460 * t462 / 0.1536e4 + t2056 / 0.2304e4 - t2059);
  tv4rho2sigma25 = t6 * t2061 + 0.2e1 * t1007;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2065 = t1304 * t453;
  t2075 = my_piecewise3(t1, 0, t1300 * t453 / 0.1536e4 + t2065 / 0.4608e4 - t639 * t988 / 0.288e3 + t1312 * t996 / 0.2304e4 + t2025 / 0.4608e4 - t2032 - t2033 / 0.864e3 + t2035 / 0.6912e4);
  tv4rho2sigma26 = t6 * t2075 + t1000 + t1012;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2079 = t1640 * t462;
  t2084 = t768 * t1018;
  t2088 = t1647 * t1026;
  t2091 = my_piecewise3(t53, 0, t1636 * t462 / 0.1536e4 + t2079 / 0.4608e4 + t2056 / 0.4608e4 - t2059 - t764 * t1018 / 0.288e3 - t2084 / 0.864e3 + t1650 * t1026 / 0.2304e4 + t2088 / 0.6912e4);
  tv4rho2sigma211 = t6 * t2091 + t1007 + t1030;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2098 = my_piecewise3(t1, 0, t1387 * t453 / 0.1536e4 + t2065 / 0.2304e4 - t2032);
  tv4rho2sigma212 = t6 * t2098 + 0.2e1 * t1012;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2124 = my_piecewise3(t53, 0, t1747 * t462 / 0.1536e4 + t2079 / 0.2304e4 - t832 * t1018 / 0.144e3 + t1768 * t1026 / 0.1152e4 - t2059 - t2084 / 0.432e3 + t2088 / 0.3456e4 + 0.19e2 / 0.864e3 * t375 * t230 * t382 - 0.43e2 / 0.6912e4 * t844 * t973 * t1025 + t1735 / t65 / t1761 * t1160 * t376 * t1742 / 0.20736e5);
  tv4rho2sigma217 = t6 * t2124 + 0.2e1 * t1030;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2129 = t1169 * t1035 / 0.18432e5;
  t2143 = my_piecewise3(t1, 0, -t1166 * t1035 / 0.6144e4 - t2129 + t547 * t993 * t1034 / 0.768e3 - t1153 / t37 / t551 * t1160 * t28 * t33 * sigma[0] * t45 / 0.55296e5);
  tv4rhosigma30 = t6 * t2143 + t1038;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2148 = t1647 * t1042 / 0.18432e5;
  t2150 = my_piecewise3(t53, 0, -t1650 * t1042 / 0.6144e4 - t2148);
  tv4rhosigma39 = t6 * t2150 + t1045;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2155 = my_piecewise3(t1, 0, -t1312 * t1035 / 0.6144e4 - t2129);
  tv4rhosigma310 = t6 * t2155 + t1038;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2172 = my_piecewise3(t53, 0, -t1768 * t1042 / 0.6144e4 - t2148 + t844 * t1023 * t1041 / 0.768e3 - t1735 / t65 / t847 * t1160 * t28 * t33 * sigma[2] * t72 / 0.55296e5);
  tv4rhosigma319 = t6 * t2172 + t1045;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2180 = my_piecewise3(t1, 0, t1153 / t37 / t885 * t1160 * t1162 / 0.147456e6);
  tv4sigma40 = t6 * t2180;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2187 = my_piecewise3(t53, 0, t1735 / t65 / t971 * t1160 * t1742 / 0.147456e6);
  tv4sigma414 = t6 * t2187;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

