% VCFALLELICPRIMITIVES(1) vcfallelicprimitives (vcflib) | vcfallelicprimitives (VCF transformation)
% Erik Garrison and vcflib contributors

# NAME

**vcfallelicprimitives**

# SYNOPSIS

**vcfallelicprimitives** [options] [file]

# DESCRIPTION

If multiple allelic primitives (gaps or mismatches) are specified in a single VCF record, split the record into multiple lines, but drop all INFO fields. Does not handle genotypes (yet). MNPs are split into multiple SNPs unless the -m flag is provided. Records generated by splits have th



# OPTIONS

```

options:
    -m, --use-mnps          Retain MNPs as separate events (default: false).
    -t, --tag-parsed FLAG   Tag records which are split apart of a complex allele with this flag.
    -L, --max-length LEN    Do not manipulate records in which either the ALT or
                            REF is longer than LEN (default: 200).
    -k, --keep-info         Maintain site and allele-level annotations when decomposing.
                            Note that in many cases, such as multisample VCFs, these won't
                            be valid post-decomposition.  For biallelic loci in single-sample
                            VCFs, they should be usable with caution.
    -g, --keep-geno         Maintain genotype-level annotations when decomposing.  Similar
                            caution should be used for this as for --keep-info.

Type: transformation

```





# EXIT VALUES

**0**
: Success

**not 0**
: Failure

# SEE ALSO



[vcflib](./vcflib.md)(1)



# OTHER

## Source code

[vcfallelicprimitives.cpp](https://github.com/vcflib/vcflib/blob/master/src/vcfallelicprimitives.cpp)

# LICENSE

Copyright 2011-2022 (C) Erik Garrison and vcflib contributors. MIT licensed.

<!--
  Created with ./scripts/bin2md.rb scripts/bin2md-template.erb
-->
