#pragma once


#include <odsstream/odsdocwriter.h>
#include <pappsomspp/core/amino_acid/aacode.h>
#include <pappsomspp/core/fasta/fastareader.h>
#include <pappsomspp/core/protein/protein.h>
#include <pappsomspp/core/protein/proteinpresenceabsencematrix.h>
#include <pappsomspp/core/processing/specglob/spectralalignment.h>
#include <pappsomspp/core/processing/specself/selfspectrum.h>

class FastaProteinArrayHandler : public pappso::FastaHandlerInterface
{
  public:
  const std::vector<pappso::Protein> &getProteinArray() const;
  void setSequence(const QString &description_in, const QString &sequence_in) override;

  private:
  std::vector<pappso::Protein> m_proteinArray;
};


void writeProteinConvolutionScore(const QString &filename,
                                  const pappso::Protein &protein,
                                  const pappso::ProteinPresenceAbsenceMatrix *pmatrix,
                                  const std::vector<double> &convolution_score);

void writeSpectralAlignmentMatrix(const QString &filename,
                                  const pappso::specglob::SpectralAlignment &spectral_alignment);


void writeSelfSpectrum(const QString &filename,
                       const pappso::specself::SelfSpectrum &self_spectrum,
                       const pappso::AaStringCodec &aa_codec);


void writeJsonAaCode(const QString &filein, const pappso::AaCode &aa_code);


void writeProteinConvolutionScoreJson(const QString &filein,
                                      const pappso::Protein &protein,
                                      const pappso::ProteinIntegerCode & protein_code,
                                      const pappso::ProteinPresenceAbsenceMatrix *pmatrix,
                                      const std::vector<double> &convolution_score);
