/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IDODAD_H
#define IDODAD_H

#define DODAD_NONE	0
#define DODAD_BUTTON	1
#define DODAD_SBUTTON	2
#define DODAD_BOX	3
#define DODAD_INTBOX	4
#define DODAD_REALBOX	5
#define DODAD_STATBAR	6
#define DODAD_TEXTBOX	7
#define DODAD_LISTBOX	8
#define DODAD_SLIDER	9

#define IBTK_WRAP		1
#define IBTK_SUPPLEMENTARY	2

class IWindow;

class IDoDad  {
public:
  IDoDad() { hidden=1; flags=0; };
  virtual int Type()  { return DODAD_NONE; };
  virtual void Redraw() {};
  virtual void Rebuild() {};
  void Hide() { if(!hidden) { hidden=1; Redraw(); } };
  void Show() { if(hidden) { hidden=0; Redraw(); } };
  int Hidden() { return hidden; };
  void SetFlags(int v) { flags=v; };
  int Flags() { return flags; };
  virtual void GotFocus() {};
  virtual void LostFocus() {};
  virtual int KeyDown(XKeyEvent ev) { return 0; };
  virtual int KeyUp(XKeyEvent ev) { return 0; };
  virtual int Press(int b, int x, int y) { return 0; };
  virtual int Release(int b, int x, int y) { return 0; };
  virtual int Drag(int x, int y) { return 0; };
  virtual void Resize(int, int) {};
  virtual void Move(int, int) {};
  virtual void MoveAndResize(int, int, int, int) {};
  void SetParent(IDoDad *p) { parent = p; };
  IWindow *GetWindow() { return Win; };
protected:
  IWindow *Win;
  IDoDad *parent;
  int hidden, flags;
  };

#endif
