/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.config.CaliperRc;
import com.google.caliper.config.InvalidConfigurationException;
import com.google.caliper.config.NewInstrumentConfig;
import com.google.caliper.config.NewResultProcessorConfig;
import com.google.caliper.config.NewVmConfig;
import com.google.caliper.util.Util;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class CaliperConfig {
    private final ImmutableMap<String, String> properties;
    private static final Splitter ARGS_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    CaliperConfig(ImmutableMap<String, String> properties) {
        this.properties = (ImmutableMap)Preconditions.checkNotNull(properties);
    }

    public NewVmConfig getVmConfig(String name) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap<String, String> vmGroupMap = CaliperConfig.subgroupMap(this.properties, "vm");
        ImmutableMap<String, String> vmMap = CaliperConfig.subgroupMap(vmGroupMap, name);
        File homeDir = CaliperConfig.getJdkHomeDir((String)vmGroupMap.get((Object)"baseDirectory"), (String)vmMap.get((Object)"home"), name);
        return new NewVmConfig.Builder(homeDir).addAllOptions(CaliperConfig.getArgs(vmGroupMap)).addAllOptions(CaliperConfig.getArgs(vmMap)).build();
    }

    public NewInstrumentConfig getInstrumentConfig(String name) {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap<String, String> instrumentGroupMap = CaliperConfig.subgroupMap(this.properties, "instrument");
        ImmutableMap<String, String> insrumentMap = CaliperConfig.subgroupMap(instrumentGroupMap, name);
        return new NewInstrumentConfig.Builder().className((String)insrumentMap.get((Object)"class")).addAllOptions((Map<String, String>)CaliperConfig.subgroupMap(insrumentMap, "options")).build();
    }

    public NewResultProcessorConfig getResultProcessorConfig(String name) {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap<String, String> resultsGroupMap = CaliperConfig.subgroupMap(this.properties, "results");
        ImmutableMap<String, String> resultsMap = CaliperConfig.subgroupMap(resultsGroupMap, name);
        return new NewResultProcessorConfig.Builder().className((String)resultsMap.get((Object)"class")).addAllOptions((Map<String, String>)CaliperConfig.subgroupMap(resultsMap, "options")).build();
    }

    private static final ImmutableMap<String, String> subgroupMap(ImmutableMap<String, String> map, String groupName) {
        return Util.prefixedSubmap(map, groupName + ".");
    }

    private static List<String> getArgs(Map<String, String> properties) {
        return ImmutableList.copyOf((Iterable)ARGS_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)properties.get("args"))));
    }

    private static File getJdkHomeDir(@Nullable String baseDirectoryPath, @Nullable String homeDirPath, String vmConfigName) throws InvalidConfigurationException {
        if (homeDirPath == null) {
            File baseDirectory = CaliperConfig.getBaseDirectory(baseDirectoryPath);
            File homeDir = new File(baseDirectory, vmConfigName);
            CaliperConfig.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", homeDir);
            return homeDir;
        }
        File potentialHomeDir = new File(homeDirPath);
        if (potentialHomeDir.isAbsolute()) {
            CaliperConfig.checkConfiguration(potentialHomeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
            return potentialHomeDir;
        }
        File baseDirectory = CaliperConfig.getBaseDirectory(baseDirectoryPath);
        File homeDir = new File(baseDirectory, homeDirPath);
        CaliperConfig.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
        return homeDir;
    }

    private static File getBaseDirectory(@Nullable String baseDirectoryPath) throws InvalidConfigurationException {
        if (baseDirectoryPath == null) {
            throw new InvalidConfigurationException("must set either a home directory or a base directory");
        }
        File baseDirectory = new File(baseDirectoryPath);
        CaliperConfig.checkConfiguration(baseDirectory.isAbsolute(), "base directory cannot be a relative path");
        CaliperConfig.checkConfiguration(baseDirectory.isDirectory(), "base directory must be a directory");
        return baseDirectory;
    }

    private static void checkConfiguration(boolean check, String message) throws InvalidConfigurationException {
        if (!check) {
            throw new InvalidConfigurationException(message);
        }
    }

    private static void checkConfiguration(boolean check, String messageFormat, Object ... args) throws InvalidConfigurationException {
        if (!check) {
            throw new InvalidConfigurationException(String.format(messageFormat, args));
        }
    }

    public CaliperRc asCaliperRc() {
        return new CaliperRc((Map<String, String>)this.properties);
    }
}

