/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "account.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_ACCOUNT_ACCOUNT_H
#define AB_ACCOUNT_ACCOUNT_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_ACCOUNT Structure AB_ACCOUNT
<p>This page describes the properties of AB_ACCOUNT.</p>



<h1>AB_ACCOUNT</h1>

This type contains all important information about accounts. All text fields are in UTF-8.


<h2>Type</h2>



@anchor AB_ACCOUNT_accountType
<h3>accountType</h3>

<p>Set this property with @ref AB_Account_SetAccountType(), get it with @ref AB_Account_GetAccountType().</p>


<h2>Identifiers</h2>



@anchor AB_ACCOUNT_uniqueId
<h3>uniqueId</h3>

This is a unique id assigned by AqBanking.
<p>Set this property with @ref AB_Account_SetUniqueId(), get it with @ref AB_Account_GetUniqueId().</p>


<h2>Common Information</h2>



@anchor AB_ACCOUNT_backendName
<h3>backendName</h3>

Name of the banking backend this account belongs to.
<p>Set this property with @ref AB_Account_SetBackendName(), get it with @ref AB_Account_GetBackendName().</p>


@anchor AB_ACCOUNT_ownerName
<h3>ownerName</h3>

Name of the account owner as it is stored with the bank.
<p>Set this property with @ref AB_Account_SetOwnerName(), get it with @ref AB_Account_GetOwnerName().</p>


@anchor AB_ACCOUNT_bankName
<h3>bankName</h3>

Name of the bank the account belongs to.
<p>Set this property with @ref AB_Account_SetBankName(), get it with @ref AB_Account_GetBankName().</p>


@anchor AB_ACCOUNT_accountName
<h3>accountName</h3>

Name of the account.
<p>Set this property with @ref AB_Account_SetAccountName(), get it with @ref AB_Account_GetAccountName().</p>


@anchor AB_ACCOUNT_currency
<h3>currency</h3>

Currency used with this account.
<p>Set this property with @ref AB_Account_SetCurrency(), get it with @ref AB_Account_GetCurrency().</p>


@anchor AB_ACCOUNT_memo
<h3>memo</h3>

Optional additional info.
<p>Set this property with @ref AB_Account_SetMemo(), get it with @ref AB_Account_GetMemo().</p>


<h2>SEPA Account Specification</h2>



@anchor AB_ACCOUNT_iban
<h3>iban</h3>

Internation bank account number as specified by the SEPA specs.
<p>Set this property with @ref AB_Account_SetIban(), get it with @ref AB_Account_GetIban().</p>


@anchor AB_ACCOUNT_bic
<h3>bic</h3>

SWIFT code of the bank at which this account is registered.
<p>Set this property with @ref AB_Account_SetBic(), get it with @ref AB_Account_GetBic().</p>


<h2>Non-SEPA Account Specification</h2>



@anchor AB_ACCOUNT_country
<h3>country</h3>

<p>Set this property with @ref AB_Account_SetCountry(), get it with @ref AB_Account_GetCountry().</p>


@anchor AB_ACCOUNT_bankCode
<h3>bankCode</h3>

National bank code (e.g. BLZ in Germany, routing number in other countries).
<p>Set this property with @ref AB_Account_SetBankCode(), get it with @ref AB_Account_GetBankCode().</p>


@anchor AB_ACCOUNT_branchId
<h3>branchId</h3>

This is the branch id of the local bank (OFX only)
<p>Set this property with @ref AB_Account_SetBranchId(), get it with @ref AB_Account_GetBranchId().</p>


@anchor AB_ACCOUNT_accountNumber
<h3>accountNumber</h3>

Account number in national account specification.
<p>Set this property with @ref AB_Account_SetAccountNumber(), get it with @ref AB_Account_GetAccountNumber().</p>


@anchor AB_ACCOUNT_subAccountId
<h3>subAccountId</h3>

If your account has subaccounts which are distinguished by different suffixes, then this is that suffix. Otherwise it's empty. (HBCI only)
<p>Set this property with @ref AB_Account_SetSubAccountId(), get it with @ref AB_Account_GetSubAccountId().</p>


<h2>Internal Data</h2>



@anchor AB_ACCOUNT_userId
<h3>userId</h3>

Id of the user to whom this account is assigned.
<p>Set this property with @ref AB_Account_SetUserId(), get it with @ref AB_Account_GetUserId().</p>


@anchor AB_ACCOUNT_provider
<h3>provider</h3>

<p>Set this property with @ref AB_Account_SetProvider(), get it with @ref AB_Account_GetProvider().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/list2.h>
#include <gwenhywfar/inherit.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <gwenhywfar/mdigest.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/buffer.h>

typedef struct AB_ACCOUNT AB_ACCOUNT;
GWEN_LIST_FUNCTION_DEFS(AB_ACCOUNT, AB_Account)
GWEN_LIST2_FUNCTION_DEFS(AB_ACCOUNT, AB_Account)
GWEN_INHERIT_FUNCTION_DEFS(AB_ACCOUNT)



/* post-headers */
#include <aqbanking/account_type.h>
#include <aqbanking/backendsupport/provider.h>


/* definitions for virtual functions (post) */
typedef int (*AB_ACCOUNT_READFROMDB_FN)(AB_ACCOUNT *p_struct, GWEN_DB_NODE *dbData);

typedef int (*AB_ACCOUNT_WRITETODB_FN)(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *dbData);

/** Constructor. */
AB_ACCOUNT *AB_Account_new(void);

/** Destructor. */
void AB_Account_free(AB_ACCOUNT *p_struct);

void AB_Account_Attach(AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountType" (see @ref AB_ACCOUNT_accountType)
*/
int AB_Account_GetAccountType(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "uniqueId" (see @ref AB_ACCOUNT_uniqueId)
*/
uint32_t AB_Account_GetUniqueId(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "backendName" (see @ref AB_ACCOUNT_backendName)
*/
const char *AB_Account_GetBackendName(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "ownerName" (see @ref AB_ACCOUNT_ownerName)
*/
const char *AB_Account_GetOwnerName(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "bankName" (see @ref AB_ACCOUNT_bankName)
*/
const char *AB_Account_GetBankName(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountName" (see @ref AB_ACCOUNT_accountName)
*/
const char *AB_Account_GetAccountName(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "currency" (see @ref AB_ACCOUNT_currency)
*/
const char *AB_Account_GetCurrency(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "memo" (see @ref AB_ACCOUNT_memo)
*/
const char *AB_Account_GetMemo(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "iban" (see @ref AB_ACCOUNT_iban)
*/
const char *AB_Account_GetIban(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "bic" (see @ref AB_ACCOUNT_bic)
*/
const char *AB_Account_GetBic(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "country" (see @ref AB_ACCOUNT_country)
*/
const char *AB_Account_GetCountry(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "bankCode" (see @ref AB_ACCOUNT_bankCode)
*/
const char *AB_Account_GetBankCode(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "branchId" (see @ref AB_ACCOUNT_branchId)
*/
const char *AB_Account_GetBranchId(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountNumber" (see @ref AB_ACCOUNT_accountNumber)
*/
const char *AB_Account_GetAccountNumber(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "subAccountId" (see @ref AB_ACCOUNT_subAccountId)
*/
const char *AB_Account_GetSubAccountId(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "userId" (see @ref AB_ACCOUNT_userId)
*/
uint32_t AB_Account_GetUserId(const AB_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "provider" (see @ref AB_ACCOUNT_provider)
*/
AB_PROVIDER *AB_Account_GetProvider(const AB_ACCOUNT *p_struct);

/** Setter.
 * Use this function to set the member "accountType" (see @ref AB_ACCOUNT_accountType)
*/
void AB_Account_SetAccountType(AB_ACCOUNT *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "uniqueId" (see @ref AB_ACCOUNT_uniqueId)
*/
void AB_Account_SetUniqueId(AB_ACCOUNT *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "backendName" (see @ref AB_ACCOUNT_backendName)
*/
void AB_Account_SetBackendName(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ownerName" (see @ref AB_ACCOUNT_ownerName)
*/
void AB_Account_SetOwnerName(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankName" (see @ref AB_ACCOUNT_bankName)
*/
void AB_Account_SetBankName(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountName" (see @ref AB_ACCOUNT_accountName)
*/
void AB_Account_SetAccountName(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "currency" (see @ref AB_ACCOUNT_currency)
*/
void AB_Account_SetCurrency(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "memo" (see @ref AB_ACCOUNT_memo)
*/
void AB_Account_SetMemo(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "iban" (see @ref AB_ACCOUNT_iban)
*/
void AB_Account_SetIban(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bic" (see @ref AB_ACCOUNT_bic)
*/
void AB_Account_SetBic(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "country" (see @ref AB_ACCOUNT_country)
*/
void AB_Account_SetCountry(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankCode" (see @ref AB_ACCOUNT_bankCode)
*/
void AB_Account_SetBankCode(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "branchId" (see @ref AB_ACCOUNT_branchId)
*/
void AB_Account_SetBranchId(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountNumber" (see @ref AB_ACCOUNT_accountNumber)
*/
void AB_Account_SetAccountNumber(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "subAccountId" (see @ref AB_ACCOUNT_subAccountId)
*/
void AB_Account_SetSubAccountId(AB_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "userId" (see @ref AB_ACCOUNT_userId)
*/
void AB_Account_SetUserId(AB_ACCOUNT *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "provider" (see @ref AB_ACCOUNT_provider)
*/
void AB_Account_SetProvider(AB_ACCOUNT *p_struct, AB_PROVIDER *p_src);

/* prototypes for virtual functions */
/**
 * Read an account from a GWEN_DB_NODE.
 * @param dbData Profile data to read from.
 */
int AB_Account_ReadFromDb(AB_ACCOUNT *p_struct, GWEN_DB_NODE *dbData);

/**
 * Write an account to a GWEN_DB_NODE.
 * @param dbData Profile data to read from.
 */
int AB_Account_WriteToDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *dbData);

/* setters for virtual functions */
AB_ACCOUNT_READFROMDB_FN AB_Account_SetReadFromDbFn(AB_ACCOUNT *p_struct, AB_ACCOUNT_READFROMDB_FN fn);

AB_ACCOUNT_WRITETODB_FN AB_Account_SetWriteToDbFn(AB_ACCOUNT *p_struct, AB_ACCOUNT_WRITETODB_FN fn);

/* getters for virtual functions */
AB_ACCOUNT_READFROMDB_FN AB_Account_GetReadFromDbFn(const AB_ACCOUNT *p_struct);

AB_ACCOUNT_WRITETODB_FN AB_Account_GetWriteToDbFn(const AB_ACCOUNT *p_struct);

void AB_Account_ReadDb(AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

int AB_Account_WriteDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

AB_ACCOUNT *AB_Account_fromDb(GWEN_DB_NODE *p_db);

int AB_Account_toDb(const AB_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

void AB_Account_ReadXml(AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

void AB_Account_WriteXml(const AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

void AB_Account_toXml(const AB_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

AB_ACCOUNT *AB_Account_fromXml(GWEN_XMLNODE *p_db);

AB_ACCOUNT *AB_Account_List_GetByUniqueId(const AB_ACCOUNT_LIST *p_list, uint32_t p_cmp);

/**
 * Check whether a given account info object matches the given criteria.
 * @param a account info object to match
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
int AB_Account_Matches(const AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId,
                       const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty);
/**
 * Find the first matching account object in a list of account info objects.
 * @param al list of account objects among to search
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
AB_ACCOUNT *AB_Account_List_FindFirst(AB_ACCOUNT_LIST *al, const char *backendName, const char *country,
                                      const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency,
                                      int ty);
/**
 * Find the next matching account object in a list of account info objects.
 * @param a previous matching account objects among to search
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
AB_ACCOUNT *AB_Account_List_FindNext(AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId,
                                     const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty);
/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

