/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// PmemConfig struct for PmemConfig
type PmemConfig struct {
	File          string  `json:"file"`
	Size          *int64  `json:"size,omitempty"`
	Iommu         *bool   `json:"iommu,omitempty"`
	Mergeable     *bool   `json:"mergeable,omitempty"`
	DiscardWrites *bool   `json:"discard_writes,omitempty"`
	Id            *string `json:"id,omitempty"`
}

// NewPmemConfig instantiates a new PmemConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPmemConfig(file string) *PmemConfig {
	this := PmemConfig{}
	this.File = file
	var iommu bool = false
	this.Iommu = &iommu
	var mergeable bool = false
	this.Mergeable = &mergeable
	var discardWrites bool = false
	this.DiscardWrites = &discardWrites
	return &this
}

// NewPmemConfigWithDefaults instantiates a new PmemConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPmemConfigWithDefaults() *PmemConfig {
	this := PmemConfig{}
	var iommu bool = false
	this.Iommu = &iommu
	var mergeable bool = false
	this.Mergeable = &mergeable
	var discardWrites bool = false
	this.DiscardWrites = &discardWrites
	return &this
}

// GetFile returns the File field value
func (o *PmemConfig) GetFile() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.File
}

// GetFileOk returns a tuple with the File field value
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetFileOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.File, true
}

// SetFile sets field value
func (o *PmemConfig) SetFile(v string) {
	o.File = v
}

// GetSize returns the Size field value if set, zero value otherwise.
func (o *PmemConfig) GetSize() int64 {
	if o == nil || o.Size == nil {
		var ret int64
		return ret
	}
	return *o.Size
}

// GetSizeOk returns a tuple with the Size field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetSizeOk() (*int64, bool) {
	if o == nil || o.Size == nil {
		return nil, false
	}
	return o.Size, true
}

// HasSize returns a boolean if a field has been set.
func (o *PmemConfig) HasSize() bool {
	if o != nil && o.Size != nil {
		return true
	}

	return false
}

// SetSize gets a reference to the given int64 and assigns it to the Size field.
func (o *PmemConfig) SetSize(v int64) {
	o.Size = &v
}

// GetIommu returns the Iommu field value if set, zero value otherwise.
func (o *PmemConfig) GetIommu() bool {
	if o == nil || o.Iommu == nil {
		var ret bool
		return ret
	}
	return *o.Iommu
}

// GetIommuOk returns a tuple with the Iommu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetIommuOk() (*bool, bool) {
	if o == nil || o.Iommu == nil {
		return nil, false
	}
	return o.Iommu, true
}

// HasIommu returns a boolean if a field has been set.
func (o *PmemConfig) HasIommu() bool {
	if o != nil && o.Iommu != nil {
		return true
	}

	return false
}

// SetIommu gets a reference to the given bool and assigns it to the Iommu field.
func (o *PmemConfig) SetIommu(v bool) {
	o.Iommu = &v
}

// GetMergeable returns the Mergeable field value if set, zero value otherwise.
func (o *PmemConfig) GetMergeable() bool {
	if o == nil || o.Mergeable == nil {
		var ret bool
		return ret
	}
	return *o.Mergeable
}

// GetMergeableOk returns a tuple with the Mergeable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetMergeableOk() (*bool, bool) {
	if o == nil || o.Mergeable == nil {
		return nil, false
	}
	return o.Mergeable, true
}

// HasMergeable returns a boolean if a field has been set.
func (o *PmemConfig) HasMergeable() bool {
	if o != nil && o.Mergeable != nil {
		return true
	}

	return false
}

// SetMergeable gets a reference to the given bool and assigns it to the Mergeable field.
func (o *PmemConfig) SetMergeable(v bool) {
	o.Mergeable = &v
}

// GetDiscardWrites returns the DiscardWrites field value if set, zero value otherwise.
func (o *PmemConfig) GetDiscardWrites() bool {
	if o == nil || o.DiscardWrites == nil {
		var ret bool
		return ret
	}
	return *o.DiscardWrites
}

// GetDiscardWritesOk returns a tuple with the DiscardWrites field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetDiscardWritesOk() (*bool, bool) {
	if o == nil || o.DiscardWrites == nil {
		return nil, false
	}
	return o.DiscardWrites, true
}

// HasDiscardWrites returns a boolean if a field has been set.
func (o *PmemConfig) HasDiscardWrites() bool {
	if o != nil && o.DiscardWrites != nil {
		return true
	}

	return false
}

// SetDiscardWrites gets a reference to the given bool and assigns it to the DiscardWrites field.
func (o *PmemConfig) SetDiscardWrites(v bool) {
	o.DiscardWrites = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *PmemConfig) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PmemConfig) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *PmemConfig) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *PmemConfig) SetId(v string) {
	o.Id = &v
}

func (o PmemConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["file"] = o.File
	}
	if o.Size != nil {
		toSerialize["size"] = o.Size
	}
	if o.Iommu != nil {
		toSerialize["iommu"] = o.Iommu
	}
	if o.Mergeable != nil {
		toSerialize["mergeable"] = o.Mergeable
	}
	if o.DiscardWrites != nil {
		toSerialize["discard_writes"] = o.DiscardWrites
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	return json.Marshal(toSerialize)
}

type NullablePmemConfig struct {
	value *PmemConfig
	isSet bool
}

func (v NullablePmemConfig) Get() *PmemConfig {
	return v.value
}

func (v *NullablePmemConfig) Set(val *PmemConfig) {
	v.value = val
	v.isSet = true
}

func (v NullablePmemConfig) IsSet() bool {
	return v.isSet
}

func (v *NullablePmemConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePmemConfig(val *PmemConfig) *NullablePmemConfig {
	return &NullablePmemConfig{value: val, isSet: true}
}

func (v NullablePmemConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePmemConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
