# Examples

Sometimes the best way to learn how to use a new package is to look for
examples of what others have already built with it.

The following packages use Documenter to build their documentation and so
should give a good overview of what this package is currently able to do.

!!! note

    Packages are listed alphabetically. If you have a package that uses Documenter then
    please open a PR that adds it to the appropriate list below; a simple way to do so
    is to navigate to
    <https://github.com/JuliaDocs/Documenter.jl/edit/master/docs/src/man/examples.md>.

    The `make.jl` file for all listed packages will be tested to check for potential
    regressions prior to tagging new Documenter releases whenever possible.

## Registered

Packages that have tagged versions available in the general Registry:

- [Augmentor.jl](https://evizero.github.io/Augmentor.jl/)
- [BanditOpt.jl](https://v-i-s-h.github.io/BanditOpt.jl/stable/)
- [BeaData.jl](https://stephenbnicar.github.io/BeaData.jl/stable/)
- [Bio.jl](https://biojulia.net/Bio.jl/stable/)
- [ControlSystems.jl](https://juliacontrol.github.io/ControlSystems.jl/stable/)
- [COSMO.jl](https://oxfordcontrol.github.io/COSMO.jl/stable/)
- [DiscretePredictors.jl](https://github.com/v-i-s-h/DiscretePredictors.jl)
- [Documenter.jl](https://juliadocs.github.io/Documenter.jl/stable/)
- [DrWatson](https://juliadynamics.github.io/DrWatson.jl/stable/)
- [EvolvingGraphs.jl](https://etymoio.github.io/EvolvingGraphs.jl/stable/)
- [ExtractMacro.jl](https://carlobaldassi.github.io/ExtractMacro.jl/stable/)
- [EzXML.jl](https://bicycle1885.github.io/EzXML.jl/stable/)
- [FourierFlows.jl](https://fourierflows.github.io/FourierFlowsDocumentation/stable/)
- [Gadfly.jl](https://gadflyjl.org/stable/)
- [GeoStats.jl](https://juliaearth.github.io/GeoStats.jl/stable/)
- [Highlights.jl](https://juliadocs.github.io/Highlights.jl/stable/)
- [IntervalConstraintProgramming.jl](https://juliaintervals.github.io/IntervalConstraintProgramming.jl/stable/)
- [Luxor.jl](https://juliagraphics.github.io/Luxor.jl/stable/)
- [MergedMethods.jl](https://michaelhatherly.github.io/MergedMethods.jl/stable/)
- [Mimi.jl](https://www.mimiframework.org/Mimi.jl/stable/)
- [NumericSuffixes.jl](https://michaelhatherly.github.io/NumericSuffixes.jl/stable/)
- [NLOptControl.jl](https://huckl3b3rry87.github.io/MPCDocs.jl/stable/)
- [OhMyREPL.jl](https://github.com/KristofferC/OhMyREPL.jl)
- [OnlineStats.jl](https://joshday.github.io/OnlineStats.jl/stable/)
- [POMDPs.jl](https://juliapomdp.github.io/POMDPs.jl/stable/)
- [PhyloNetworks.jl](https://crsl4.github.io/PhyloNetworks.jl/stable/)
- [PrivateModules.jl](https://michaelhatherly.github.io/PrivateModules.jl/stable/)
- [Query.jl](https://www.queryverse.org/Query.jl/stable/)
- [TaylorSeries.jl](https://www.juliadiff.org/TaylorSeries.jl/stable/)
- [Weave.jl](https://weavejl.mpastell.com/stable/)

## Documentation repositories

Some projects or organizations maintain dedicated documentation repositories that are
separate from specific packages.

- [DifferentialEquations.jl](https://docs.sciml.ai/dev/)
- [JuliaDocs landing page](https://juliadocs.github.io/dev/)
- [JuliaImages](https://juliaimages.org)
- [JuliaMusic](https://juliamusic.github.io/JuliaMusic_documentation.jl/dev/)
- [Plots.jl](https://docs.juliaplots.org/dev/)
