/*
 *  Copyright (C) 2008  Robert Millan
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>

int
main (int argc, char *argv[])
{
  int b, i;
  char *sym;
  unsigned int len;

  if (argc != 3)
    {
      fprintf (stderr, "Usage: %s symbol_name length\n", argv[0]);
      exit (1);
    }

  sym = argv[1];
  len = atoi (argv[2]);

  b = getchar ();
  if (b == EOF)
    goto abort;

  printf ("/* THIS CHUNK OF BYTES IS AUTOMATICALY GENERATED */\n"
	  "unsigned char %s[%u] =\n{\n", sym, len);

  while (1)
    {
      printf ("0x%02x", b);

      b = getchar ();
      if (b == EOF)
	goto end;

      for (i = 0; i < 16 - 1; i++)
	{
	  printf (", 0x%02x", b);

	  b = getchar ();
	  if (b == EOF)
	    goto end;
	}

      printf (",\n");
    }

end:
  printf ("\n};\n");

abort:
  exit (0);
}
