### **Awesome React** [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


A collection of awesome things regarding React ecosystem.

- [React](#react)
  - [React General Resources](#react-general-resources)
  - [React Community](#react-community)
  - [React Online Playground](#react-online-playground)
  - [React Tutorials](#react-tutorials)
    - [React General Tutorials](#react-general-tutorials)
    - [React styling](#react-styling)
    - [React Charts Tutorials](#react-charts-tutorials)
    - [React and Ruby on Rails](#react-and-ruby-on-rails)
    - [React and Meteor](#react-and-meteor)
    - [React and Angular](#react-and-angular)
    - [React and Bootstrap](#react-and-bootstrap)
    - [React and ClojureScript](#react-and-clojurescript)
    - [React and CoffeeScript](#react-and-coffeescript)
    - [React and Datatables](#react-and-datatables)
    - [React and Haskell](#react-and-haskell)
    - [React and SocketIO](#react-and-socketio)
    - [Server-Client with React](#server-client-with-react)
    - [Server Side Rendering](#server-side-rendering)
    - [Prerendering aka snapshotting](#prerendering-aka-snapshotting)
    - [Compiling React Tutorials](#compiling-react-tutorials)
    - [Debugging React](#debugging-react)
    - [Authentication](#authentication)
    - [File Uploads](#file-uploads)
  - [React Tools](#react-tools)
    - [Boilerplates](#boilerplates)
    - [Routing](#routing)
    - [React Projects](#react-projects)
    - [Components](#components)
    - [Libraries](#libraries)
    - [Integration](#integration)
    - [Forms](#forms)
    - [Autocomplete](#autocomplete)
    - [Documentation Tools](#documentation-tools)
    - [Graphics](#graphics)
    - [Model Libraries](#model-libraries)
    - [Data Managing](#data-managing)
    - [React Developer Experience](#react-developer-experience)
    - [Template Engines](#template-engines)
    - [Maps](#maps)
    - [Charts](#charts)
- [React Native](#react-native)
  - [React Native General Resources](#react-native-general-resources)
  - [React Native Community](#react-native-community)
  - [React Native Tutorials](#react-native-tutorials)
  - [React Native Developer Experience](#react-native-developer-experience)
  - [React Native Sample Apps](#react-native-sample-apps)
  - [React Native Boilerplates](#react-native-boilerplates)
  - [React Native Awesome Components](#react-native-awesome-components)
- [JSX](#jsx)
  - [JSX Resources](#jsx-resources)
- [Flux](#flux)
  - [Flux General Resources](#flux-general-resources)
  - [Flux Implementations](#flux-implementations)
  - [Flux Tutorials](#flux-tutorials)
- [Redux](#redux)
  - [Redux General Resources](#redux-general-resources)
  - [Redux Tools](#redux-tools)
  - [Redux Tutorials](#redux-tutorials)
- [MobX](#mobx)
  - [MobX General Resources](#mobx-general-resources)
  - [MobX Tools](#mobx-tools)
  - [MobX Tutorials](#mobx-tutorials)
- [Testing](#testing)
  - [Testing Utilities](#testing-utilities)
  - [Testing Tutorials](#testing-tutorials)
- [GraphQL](#graphql)
  - [GraphQL Spec](#graphql-spec)
  - [GraphQL Tools](#graphql-tools)
  - [GraphQL Tutorials](#graphql-tutorials)
  - [GraphQL Implementations](#graphql-implementations)
  - [Server Integration](#server-integration)
  - [Database Integration](#database-integration)
- [Relay](#relay)
  - [Relay General Resources](#relay-general-resources)
  - [Relay Tutorials](#relay-tutorials)
  - [Relay Tools](#relay-tools)
- [Apollo](#apollo)
  - [Apolo General Resources](#apollo-general-resources)
- [Flow](#flow)
  - [Flow Resources](#flow-resources)
- [Videos](#videos)
  - [Video from Confs](#video-from-confs)
  - [React.js Conf 2015 Playlist](#reactjs-conf-2015-playlist)
  - [ReactEurope Conf 2015 Day 1 Playlist](#reacteurope-conf-2015-day-1-playlist)
  - [ReactEurope Conf 2015 Day 2 Playlist](#reacteurope-conf-2015-day-2-playlist)
  - [ReactRally Conf 2015 Playlist](#reactrally-conf-2015-playlist)
  - [React.js Conf 2016 Playlist](#reactjs-conf-2016-playlist)
  - [ReactRally Conf 2016 Playlist](#reactrally-conf-2016-playlist)
  - [Video Tutorials](#video-tutorials)
- [Books](#books)
- [Demos](#demos)
- [Example Apps](#example-apps)
- [Real Apps](#real-apps)
- [Contribution](#contribution)


---
### React
> JavaScript Library for building User Interfaces

#### React General Resources
* [React Official Site](http://facebook.github.io/react/)
* [React GitHub](https://github.com/facebook/react)
* [React Community GitHub](https://github.com/reactjs)
* [React FAQ](https://reactfaq.site/)

#### React Community
* [Reactiflux](http://www.reactiflux.com/)
* [React Discussion Forum](https://discuss.reactjs.org/)
* [React StackOverflow](http://stackoverflow.com/questions/tagged/reactjs)
* [React Twitter](https://twitter.com/reactjs)
* [React Core meeting notes](https://github.com/reactjs/core-notes)
* [Made with React - Collection of websites and applications using ReactJS](http://madewithreact.com/)
* [The React newsletter](http://theproblemsolver.nl/TheReactNewsletter/Subscribe)
* [React Iran Telegram Group](https://telegram.me/joinchat/D8jLp0D27irx4rjq2j88xw)

#### React Online Playground
* [CodeSandbox](https://codesandbox.io)
* [Online VS Code IDE for React](https://stackblitz.com)
* [React JSFiddle Integration with JSX](https://jsfiddle.net/reactjs/69z2wepo/)
* [React JSFiddle Integration without JSX](https://jsfiddle.net/reactjs/5vjqabv3/)
* [Babel REPL](https://babeljs.io/repl/)
* [React HTML to JSX Online Compiler](https://facebook.github.io/react/html-jsx.html)
* [React browser prototyping for components](http://react.run)

#### React Tutorials

##### React General Tutorials
* [React Tutorial](https://facebook.github.io/react/docs/tutorial.html)
* [React.js Fundamentals (paid)](https://tylermcginnis.com/courses/react-fundamentals)
* [React Primer](https://github.com/mikechau/react-primer-draft)
* [ReactJS: Keep Simple. Everything can be a component!](https://speakerdeck.com/pedronauck/reactjs-keep-simple-everything-can-be-a-component)
* [React js tutorial](https://hackr.io/tutorials/learn-react)
* [React.js Koans: Practical exercises that will help you learn React.js from square one](https://github.com/arkency/reactjs_koans)
* [LearnCode React Tutorials](https://www.youtube.com/watch?v=MhkGQAoc7bc&list=PLoYCgNOIyGABj2GQSlDRjgvXtqfDxKm5b)
* [Thinkster React topics](https://thinkster.io/topics/react)
* [React tutorial - Cloning Yelp](https://www.fullstackreact.com/articles/react-tutorial-cloning-yelp/)
* [Learn React by building the Hacker News front page](https://github.com/mking/react-hn)
* [React.js in patterns](http://krasimirtsonev.com/blog/article/react-js-in-design-patterns)
* [DIY guide to build your own React](https://engineering.hexacta.com/didact-learning-how-react-works-by-building-it-from-scratch-51007984e5c5)
* [React cheatsheet](https://devhints.io/react)
* [Codecademy Learn ReactJS Course](https://www.codecademy.com/pt/learn/react-101)
* [Getting Started with React](https://sabe.io/tutorials/getting-started-with-react)
* [React Express - Beginners Guide to React Application Development](http://www.react.express/)
* [GraphCMS Beginners Guide with React](https://graphcms.com/docs/getting-started/beginners_guide_with_react/)

##### React best practices

* [Pete Hunt: React: Rethinking best practices - JSConf EU 2013](https://www.youtube.com/watch?v=x7cQ3mrcKaY)
* [Pete Hunt: React: Rethinking Best Practices (updated) - JSConf.Asia 2013](https://www.youtube.com/watch?v=DgVS-zXgMTk)
* [React.js Best Practices](https://github.com/ximet/awesome-best-practices/blob/master/frontend/react/bestPracticeReact.md)
* [Clean Code vs. Dirty Code: React Best Practices](http://americanexpress.io/clean-code-dirty-code/)
* [Writing Scalable React Apps with the Component Folder Pattern](https://medium.com/styled-components/component-folder-pattern-ee42df37ec68)

##### React styling
* [React: CSS in JS](http://blog.vjeux.com/2014/javascript/react-css-in-js-nationjs.html)
* [React: CSS in JS techniques comparison](https://github.com/MicheleBertoli/css-in-js)
* [CSS in JS Playground](https://css-in-js-playground.com)
* [Radium](https://github.com/FormidableLabs/radium)
* [jsxstyle](https://github.com/petehunt/jsxstyle)
* [ReactCSS](https://github.com/casesandberg/reactcss)
* [Aphrodite](https://github.com/Khan/aphrodite)
* [Glamor](https://github.com/threepointone/glamor)
* [Styletron](https://github.com/rtsao/styletron)
* [TypeStyle](https://github.com/typestyle/typestyle)
* [styled-components](https://github.com/styled-components/styled-components)
* [gloss](https://github.com/motion/gloss)
* [JSS](https://github.com/cssinjs/jss)
* [reas](https://github.com/diegohaz/reas)

##### React Charts Tutorials
* [Integrating D3.js visualizations in a React app](http://nicolashery.com/integrating-d3js-visualizations-in-a-react-app/)
* [D3 and React - the future of charting components?](http://10consulting.com/2014/02/19/d3-plus-reactjs-for-charting/)

##### React and Ruby on Rails
* [React on Rails - integration of React, Webpack, React-Router with Ruby on Rails](https://github.com/shakacode/react_on_rails/)
* [reactrails.com - live example site using React on Rails with source code](http://www.reactrails.com/)

##### React and Meteor
* [Meteor official Guide](http://guide.meteor.com/react.html)
* [Meteor with React Tutorial](https://www.meteor.com/tutorials/react/creating-an-app)
* [React for Meteor developers](http://blog.differential.com/react-for-meteor-developers/)

##### React and Angular
* [NgReact - React Components in Angular](http://davidandsuzi.com/ngreact-react-components-in-angular/)
* [ng-React Update - React 0.9 and Angular Track By](http://davidandsuzi.com/ngreact-update/)
* [Using React for Faster Renders and Isomosphism in Angular](http://davidandsuzi.com/using-react-for-faster-renders-and-isomorphism-in-angular/)
* [Faster AngularJS Rendering](http://www.williambrownstreet.net/blog/2014/04/faster-angularjs-rendering-angularjs-and-reactjs/)
* [Improving AngularJS long list rendering performance using ReactJS](http://www.mono-software.com/blog/post/Mono/242/Improving-AngularJS-long-list-rendering-performance-using-ReactJS/)
* [How can React and Flux help us create better Angular applications?](https://medium.com/@gilbox/how-can-react-and-flux-help-us-create-better-stronger-faster-angular-applications-639247898fb)
* [Achieving Reasonable and Scalable Routing in AngularJS with Flux](https://medium.com/@gilbox/achieving-reasonable-and-scalable-routing-in-angularjs-with-flux-2655e06cd5ee)
* [Angular to React/Redux, a Guide for Angular v1 Experts Looking to Learn React/Redux](https://github.com/GoTeamEpsilon/angular-to-react-redux)

##### React and Bootstrap
* [Better Bootstrap modals and popover with React.js](http://clozeit.wordpress.com/2014/01/08/bootstrap-modals-and-popover-in-react-js/)
* [A mixin-based design for a React.js Bootstrap component library](http://clozeit.wordpress.com/2014/01/08/13/)
* [Popover mixin](http://clozeit.wordpress.com/2014/01/09/popover-mixin/)
* [Bootstrap TabbedArea component with React.js](http://clozeit.wordpress.com/2014/01/13/34/)
* [Bootstrap forms using React.js](http://clozeit.wordpress.com/2014/01/13/bootstrap-forms-using-react-js/)

##### React and ClojureScript
* [The Future of JavaScript MVC Frameworks](http://swannodette.github.io/2013/12/17/the-future-of-javascript-mvcs)
* [The Case for React.js and ClojureScript](http://murilopereira.com/the-case-for-reactjs-and-clojurescript/)
* [A Reagent Framework For Writing SPAs](https://github.com/Day8/re-frame)

##### React and CoffeeScript
* [React & CoffeeScript](http://blog.vjeux.com/2013/javascript/react-coffeescript.html)
* [React patterns - Mostly reasonable patterns for writing React in CoffeeScript](https://github.com/planningcenter/react-patterns)

##### React and Datatables
* [React and Datatables](https://github.com/wyvernnot/react-datatables-example)

##### React and Haskell
* [stackage-view, built with Yesod and GHCJS+React](https://github.com/fpco/stackage-view)
* [TodoMVC example with Shade (Haste+React)](https://github.com/takeoutweight/shade-todomvc)
* [react-haskell, to be used with Haste](https://hackage.haskell.org/package/react-haskell) ([blog post](http://joelburget.com/react-haskell/))
* [blaze-react, blaze-html style React bindings using GHCJS](https://github.com/meiersi/blaze-react) ([video tutorial](https://www.youtube.com/watch?v=4nTnC0t7pzY))
* [purescript-react bindings](https://github.com/purescript-contrib/purescript-react) ([example app](https://github.com/fujimura/purescript-react-example))

##### React and Socket.IO
* [Socket.IO integration example](https://gist.github.com/zpao/5686416)
* [Socket.IO integration example inside of a single React component](https://gist.github.com/petehunt/5687230)
* [Socket.IO integration employing separation of concerns](https://gist.github.com/petehunt/5687276)

##### Server-Client with React
* [Server/Client With React, Part 1: Getting Started](http://eflorenzano.com/blog/2014/04/09/react-part-1-getting-started/)
* [Server/Client With React, Part 2: The Build System](http://eflorenzano.com/blog/2014/04/10/react-part-2-build-system/)
* [Server/Client With React, Part 3: Frontend Server](http://eflorenzano.com/blog/2014/04/11/react-part-3-frontend-server/)

##### Server Side rendering
* [Super-basic example of how server rendering works](https://github.com/petehunt/react-server-rendering-example)
* [Server Side Rendering for ReactJS](http://yanns.github.io/blog/2014/03/15/server-side-rendering-for-javascript-reactjs-framework/)
* [React Server Rendering](https://github.com/mhart/react-server-example)
* [JDK8 + Facebook React: Rendering single page apps on the server](http://augustl.com/blog/2014/jdk8_react_rendering_on_server/)
* [Server-side React with PHP – part 1](http://www.phpied.com/server-side-react-with-php/)
* [Server-side React with PHP – part 2](http://www.phpied.com/server-side-react-with-php-part-2/)
* [Server-rendered React components in Rails](http://bensmithett.com/server-rendered-react-components-in-rails/)
* [Server-rendered React + Flux in Rails](https://github.com/nambrot/rails-webpack-react-flux)
* [Golang Isomorphic Hot Reloadable/React/Flummox/Css-Module Starter Kit](https://github.com/olebedev/go-starter-kit)
* [Serverside rendering with React + Hapi](https://github.com/jedireza/hapi-react-views)
* [Isomorphic React apps in PHP via dnode](http://ericescalante.com/2015/06/07/isomorphic/)
* [React Server Side Rendering with Hypernova](https://blog.larah.me/2017/04/10/react-server-side-rendering/)
* [Server Side Rendering with Simple Redux Store Hydration](https://medium.com/@navgarcha7891/react-server-side-rendering-with-simple-redux-store-hydration-9f77ab66900a)

##### Prerendering aka snapshotting
* [react-snap](https://github.com/stereobooster/react-snap)
* [Prerendering solutions comparison](https://github.com/stereobooster/react-snap/blob/master/doc/alternatives.md)

##### Compiling React Tutorials
* [Webpack Howto by Pete Hunt](https://github.com/petehunt/webpack-howto)
* [React Webpack Cookbook](https://github.com/christianalfoni/react-webpack-cookbook)
* [AMD and CommonJS examples with Webpack](https://github.com/simonsmith/webpack-example)
* [Integrating JSX live reload into your React workflow](http://gaearon.github.io/react-hot-loader/)
* [React JS and a browserify workflow, part1](http://christianalfoni.github.io/javascript/2014/08/15/react-js-workflow.html)
* [React JS and a browserify workflow, part2](http://christianalfoni.github.io/javascript/2014/10/30/react-js-workflow-part2.html)
* [Choosing the correct packaging tool for React JS](http://christianalfoni.github.io/javascript/2014/08/29/choosing-the-correct-packaging-tool-for-react-js.html)

##### Building React components
* [Distributing React components](http://krasimirtsonev.com/blog/article/distributing-react-components-babel-browserify-webpack-uglifyjs)
* [A guide to building a React component for NPM](https://medium.com/@markus.s.englund/a-guide-to-building-a-react-component-for-npm-68f03b314753)

##### Debugging React
* [Trace Logging with React](http://www.garysieling.com/blog/trace-logging-react)
* [Reactotron: Control, monitor, and instrument](https://github.com/skellock/reactotron)
* [React-fix-it: Automagically generate tests from errors](https://github.com/MicheleBertoli/react-fix-it)

##### Authentication
* [Adding authentication to your React Flux app](https://auth0.com/blog/2015/04/09/adding-authentication-to-your-react-flux-app/)
* [Build a React Application with User Authentication](https://stormpath.com/blog/build-a-react-app-with-user-authentication/)

##### File Uploads
* [Direct uploads to S3 with React, Rails, and Paperclip](http://blog.littleblimp.com/post/119230396893/direct-uploads-to-s3-with-react-rails-and)

##### API Integration
* [react-flux-cosmicjs Data-driven react application connected to the Cosmic JS API](https://github.com/tonyspiro/react-flux-cosmicjs)

##### History of React
* [The Evolution of React](https://blog.pusher.com/the-evolution-of-react)

#### React Tools

##### Boilerplates
* [Create React App](https://github.com/facebookincubator/create-react-app)
* [React Boilerplate - Minimalistic boilerplate with React, Redux, Flowtype, Babel and Webpack2](https://github.com/nordsoftware/react-boilerplate)
* [React App SDK - CLI tools and templates for authoring React apps with a single dev dependency and zero configurations](https://github.com/kriasoft/react-app)
* [React Starter Kit — isomorphic web app boilerplate (Node.js, GraphQL, React, Babel, Webpack, CSS Modules, HMR)](https://github.com/kriasoft/react-starter-kit)
* [ASP.NET Core Starter Kit (C#) — Frontend: React, Babel, PostCSS, CSS Modules + backend: .NET Core, C#](https://github.com/kriasoft/aspnet-starter-kit)
* [ASP.NET Core Starter Kit (F#) — Frontend: React, Babel, PostCSS, CSS Modules + backend: .NET Core, F#](https://github.com/kriasoft/fsharp-starter-kit)
* [React Redux Universal Hot Example](https://github.com/erikras/react-redux-universal-hot-example)
* [React Slingshot - React + Redux with Babel, hot reloading, testing, linting and working example app](https://github.com/coryhouse/react-slingshot)
* [este - Robust and comfortable dev stack for mobile/offline/frontend first isomorphic web apps](https://github.com/steida/este)
* [frontend-boilerplate - webpack-react-redux-babel-autoprefixer-hmr-postcss-css-modules-rucksack-boilerplate](https://github.com/tj/frontend-boilerplate)
* [react-engine - A composite render engine for isomorphic express apps](https://github.com/paypal/react-engine)
* [reactGo - Boilerplate for an universal/isomorphic React + Redux/alt Flux app](https://github.com/reactGo/reactGo)
* [react-native-nw-react-calculator - Mobile, desktop and website Apps with the same code](https://github.com/benoitvallon/react-native-nw-react-calculator)
* [StarHackIt - An ES6/ES7 full-stack starter kit with authentication and authorization code](https://github.com/FredericHeem/starhackit)
* [react-cordova-boilerplate - TodoMVC example for React to build a Cordova application](https://github.com/unimonkiez/react-cordova-boilerplate)
* [UniversalRelayBoilerplate - Boilerplate + examples for React Native (iOS, Android), React (isomorphic, Material-UI), Relay, GraphQL, JWT, Node.js, Apache Cassandra](https://github.com/codefoundries/UniversalRelayBoilerplate)
* [react-boilerplate - A highly scalable, offline-first foundation with the best developer experience and a focus on performance and best practices.](http://reactboilerplate.com)
* [Next.js - A minimalistic framework for server-rendered React applications](https://github.com/zeit/next.js)
* [react-express-stripe - A minimal boilerplate to accept payments in a React App](https://github.com/rwieruch/react-express-stripe)
* [React-PWA - BoilerPlate with PWA and support for Code-Splitting, SSR, SEO, Page and API caching, Image optimization and much more.](https://github.com/Atyantik/react-pwa)
* [ARc - A progressive React starter kit based on Atomic Design](https://arc.js.org)
* [react-webpack-starter - A simple boiler plate for creating react applications bundled by webpack (using ES6, Babel, SASS and webpack development server)](https://github.com/temilaj/react-webpack-starter)
* [Happyreaction - React/Spring/Java maven archetype for bootstraping a new project quickly](https://github.com/ignl/happyreaction)
* [Create React NPM Component - CLI tool for creating a component for distribution on NPM](https://github.com/deltaskelta/create-react-npm-component)
* [Suicrux - Universal starter with ultimate hot-reloading. PWA/LL/SSR/React/Redux/i18n.](https://github.com/Metnew/suicrux)
* [Redux Async Boilerplate + Redux app containing example async actions and React storybook with auto publish to github pages](https://github.com/shanedasilva/redux-async-boilerplate)
* [ReactQL - Universal React + GraphQL starter kit, with full server rendering, isomorphic data fetching and store management](https://reactql.org)
* [React + Redux w/ ES6 Starter Project - Starter kit using Webpack, React Hot Loader, Code Splitting for React Router, CSS Modules, custom Ducks pattern app architecture, best practices, and Enzyme test environment](https://github.com/nicksp/redux-webpack-es6-boilerplate)
* [react-firebase-authentication - Boilerplate for authentication and real-time database using React and Firebase](https://github.com/zerostatic/react-firebase-authentication)
* [react-redux-saga-boilerplate - Starter kit with routing, state container, storage and SEO tools. PWA-ready](https://github.com/gilbarbara/react-redux-saga-boilerplate)
* [generator-react-firebase - Yeoman generator for starting projects using React and Firebase (Redux optional) with features Full Authentication, Route protection and Material UI Application Navbar](https://github.com/prescottprue/generator-react-firebase)
* [Starter template for React + Redux + TypeScript - setup and simple app using async actions and Material UI](https://github.com/dsheiko/boilerplate/tree/master/react-redux-typescript)


##### Routing
* [react-router - A complete routing library for React](https://github.com/reactjs/react-router)

##### React Projects
* [gatsby - Transform plain text into dynamic blogs and websites using React.js](https://github.com/gatsbyjs/gatsby)
* [react-blessed - A react renderer for blessed terminal interface library](https://github.com/Yomguithereal/react-blessed)
* [MJML - The only framework that makes responsive-email easy. Based on React](https://mjml.io)
* [react-tv - React renderer for low memory applications and Packager for TVs](https://github.com/raphamorim/react-tv)

##### Components
* [React Responsive Tables](https://github.com/adam-hanna/react-responsive-tables)
* [React Component List](http://dvemac.github.io/react-component-list/)
* [JS.coach - A catalog of React components](https://js.coach/)
* [iReact: Fantastic React Components and Libraries!](http://ireact.cn/)
* [Khan Academy React Components](http://khan.github.io/react-components/)
* [VistarMedia Components](http://cmpnt.vistarmedia.com/)
* [React Topcoat UI components](https://github.com/kjda/react-topui)
* [react-material - Material design components written with React.js and React Style](https://github.com/SanderSpies/react-material)
* [Ant Design of React - A set of high-quality React components](http://github.com/ant-design/ant-design/)
* [react-md - Set of React components and sass files for implementing Google's Material Design](https://github.com/mlaursen/react-md)
* [material-ui - A CSS Framework and a Set of React Components for Material Design](https://github.com/callemall/material-ui)
* [ReactSymbols - Pixel perfect UI Kit / Library with ready-to-use components + original Sketch resource file](http://reactsymbols.com)
* [react-google-login-component](https://github.com/kennetpostigo/react-google-login-component)
* [react-facebook-login-component](https://github.com/kennetpostigo/react-facebook-login-component)
* [react-component - A Collection of React UI Components](http://react-component.github.io/badgeboard/)
* [Ant Design - An enterprise-class UI design language and React-based implementation](https://github.com/ant-design/ant-design)
* [Zent - A collection of React UI components](https://github.com/youzan/zent)
* [UXCore - A React UI Component Set living for enterprise backend application](https://github.com/uxcore/uxcore)
* [react-desktop - OS X and Windows UI components built with React](https://github.com/gabrielbull/react-desktop)
* [react-aim - Determine the cursor aim for triggering mouse events](https://github.com/gabrielbull/react-aim)
* [react-uwp - React Components that Implement Microsoft's UWP Design & Fluent Design.](https://github.com/myxvisual/react-uwp)
* [react-touch - React photo viewer for mobile](https://github.com/petehunt/react-touch)
* [griddle - A simple grid component for use with React](http://dynamictyped.github.io/Griddle/)
* [react-grid - Data grid for React](https://github.com/prometheusresearch/react-grid)
* [React-iCheck - iCheck components built with React. Highly customizable checkboxes and radio buttons](https://github.com/luqin/react-icheck)
* [react-absolute-grid - An absolutely positioned, animated, filterable, sortable, drag and droppable, ES6 grid for React](https://github.com/jrowny/react-absolute-grid)
* [react-async - Async rendering for React components](https://github.com/andreypopp/react-async)
* [react-async-input - Inputs that behave properly with async set{State,Props} calls](https://github.com/grncdr/react-async-input)
* [react-countup - A React component wrapper around CountUp.js](https://github.com/glennreyes/react-countup)
* [react-mediaswitch - Choose your DOM based on media queries](https://github.com/matthewwithanm/react-mediaswitch)
* [react-frame-component - Render your React app to an iFrame](https://github.com/ryanseddon/react-frame-component)
* [react-gravatar - React component for rendering a gravatar profile image](https://github.com/KyleAMathews/react-gravatar)
* [markdown-react - React Render for Standard Markdown](https://github.com/vjeux/markdown-react)
* [react-component-gallery — React component for creating an evenly spaced components]( https://github.com/KyleAMathews/react-component-gallery)
* [react-markdown-textarea - Component to create textareas for entering Markdown](https://github.com/KyleAMathews/react-markdown-textarea)
* [react-markdown-area - Github flavored markdown editor with live preview](https://github.com/MattMcFarland/react-markdown-area)
* [react-textarea-autosize - Textarea component for React which grows with content](https://github.com/andreypopp/react-textarea-autosize)
* [react-spinner - Zero configuration loading spinner](https://github.com/chenglou/react-spinner)
* [react-treeview - Easy, light, flexible tree view made with React](https://github.com/chenglou/react-treeview)
* [react-tree-menu - A stateless tree menu component built with the Flux architecture in mind](https://github.com/MandarinConLaBarba/react-tree-menu)
* [react-tween-state - React animation tween state](https://github.com/chenglou/react-tween-state)
* [react-stripe-checkout - Easily load Stripe Checkout as a React component](https://github.com/azmenak/react-stripe-checkout)
* [react-id-swiper - A library to use idangerous Swiper as a ReactJs component](https://github.com/kidjp85/react-id-swiper)
* [react-swipe - Brad Birdsall's swipe.js, as a React component](https://github.com/jed/react-swipe)
* [react-smart-time-ago - Show relative "time ago" dates](https://github.com/KyleAMathews/react-smart-time-ago)
* [react-autoupdate-time - Renders a <time> element that autoupdates](https://github.com/KyleAMathews/react-autoupdate-time)
* [react-time - Component for React to render relative and/or formatted dates into <time>](https://github.com/andreypopp/react-time)
* [react-crouton - A message component for reactjs](https://github.com/xeodou/react-crouton)
* [react-ago-component - Renders the approximate time ago in words from a specific past date](https://github.com/martinandert/react-ago-component)
* [react-translate-component - Provides multi-lingual/localized text content](https://github.com/martinandert/react-translate-component)
* [react-lorem-component - Renders lorem ipsum placeholder text](https://github.com/martinandert/react-lorem-component)
* [react-interpolate-component - Renders elements into a format string](https://github.com/martinandert/react-interpolate-component)
* [react-proxy-loader - Hot Module Replacement and Code Splitting](https://github.com/webpack/react-proxy-loader)
* [RCSS - Turn your JavaScript objects into CSS classes](https://github.com/chenglou/RCSS)
* [ReactiveElements - Allows to use React.js component as HTML element](https://github.com/PixelsCommander/ReactiveElements)
* [react-chosen - React wrapper for Chosen jQuery](https://github.com/chenglou/react-chosen)
* [react-inlinesvg - An SVG loader component for React](https://github.com/gilbarbara/react-inlinesvg)
* [react-imageloader - A React component for wrangling image loading](https://github.com/hzdg/react-imageloader)
* [expose - A React mixin for lazy loading](https://github.com/dok/expose)
* [react-loadqueueloader - A React component for managing loads with a load queue](https://github.com/hzdg/react-loadqueueloader)
* [react-loadermixin - A React mixin for giving components loading behavior](https://github.com/hzdg/react-loadermixin)
* [react-pressable - Add onRelease, onReleaseInside, onReleaseOutside, and onPress events](https://github.com/hzdg/react-pressable)
* [react-google-analytics - Google analytics component](https://github.com/hzdg/react-google-analytics)
* [react-layers - A library for layering components in React](https://github.com/pieterv/react-layers)
* [react-gcal-events-list - A Reusable component that pulls events from your google calendar](https://github.com/VinSpee/react-gcal-events-list)
* [reactdi - Dependency injection for ReactJS components](https://github.com/hzdg/reactdi)
* [qrcode.react - A <QRCode/> component for use with React](https://github.com/zpao/qrcode.react)
* [react-swf - Shockwave Flash Player component for React](https://github.com/syranide/react-swf)
* [react-unmount-listener-mixin - React mixin for listenable componentWillUnmount](https://github.com/syranide/react-unmount-listener-mixin)
* [react-sortable - A sortable list component built \w React](https://github.com/danielstocks/react-sortable)
* [react-anything-sortable - A sortable component with IE8 compatibility](https://github.com/jasonslyvia/react-anything-sortable)
* [react-controllables - Easily create controllable components](https://github.com/matthewwithanm/react-controllables)
* [react-datalist - A <datalist> polyfill for Reactjs](https://github.com/asbjornenge/react-datalist)
* [react-pad - Authoring tool for React components](https://github.com/andreypopp/react-pad)
* [ogre.js - Object graph manager, built with ReactJS in mind](https://github.com/elucidata/ogre.js)
* [react-scroll-components - A set of components that react to page scrolling](https://github.com/jeroencoumans/react-scroll-components)
* [react-fullscreen-component - Create fullscreen toggles](https://github.com/jeroencoumans/react-fullscreen-component)
* [react-frozenhead - Make your whole page a React component and render it on the server](https://github.com/matthewwithanm/react-frozenhead)
* [react-document-title - declarative, nested, stateful document.title](https://github.com/gaearon/react-document-title)
* [react-tags - A simple wrapper around React.DOM](https://github.com/adelevie/react-tags)
* [react-datepicker by @misino - Datepicker component for application using Facebook React](https://github.com/misino/react-datepicker)
* [react-datepicker by @Hacker0x01 - A simple and reusable datepicker component for React](https://github.com/Hacker0x01/react-datepicker)
* [react-table-sorter-demo - A React.js Table Sorter Component](https://github.com/bgerm/react-table-sorter-demo)
* [react-table-component - React Table Component for creating a very basic html table](https://gist.github.com/ChaseWest/1935d08b156ae04b85d2)
* [react-input-placeholder - Input is a small wrapper around React.DOM.input](https://github.com/enigma-io/react-input-placeholder)
* [react-infinite-scroll - An infinite scroll component for React](https://github.com/guillaumervls/react-infinite-scroll)
* [react-ellipsis - Ellipsis component for React](https://github.com/guillaumervls/react-ellipsis)
* [react-pillbox - Pillbox component for React](https://github.com/redbadger/react-pillbox)
* [react-intl - React Internationalization Component](https://github.com/yahoo/react-intl)
* [react-tokeninput - Tokeninput component for React](https://github.com/instructure/react-tokeninput)
* [react-select-box - An accessible select box component for React](https://github.com/instructure/react-select-box)
* [react-ladda - React wrapper for Ladda buttons](https://github.com/jsdir/react-ladda)
* [react-list - A versatile infinite scroll React component](https://github.com/orgsync/react-list)
* [olay-react - Olay implemented as a React component](https://github.com/orgsync/olay-react)
* [reactable - Fast, flexible, and simple data tables in React](https://github.com/glittershark/reactable)
* [react-tabs - React tabs component](https://github.com/mzabriskie/react-tabs)
* [react-draggable-tabs - Atom-fashioned draggable tabs](https://github.com/ZaninAndrea/react-draggable-tabs)
* [react-simpletabs - Just a simple tabs component](https://github.com/pedronauck/react-simpletabs)
* [react-draggable - React draggable component](https://github.com/mzabriskie/react-draggable)
* [react-resizable - A tiny Resizable component based on react-draggable](https://github.com/strml/react-resizable)
* [react-grid-layout - A Masonry-style responsive grid layout](https://github.com/strml/react-grid-layout)
* [react-dnd - Flexible HTML5 drag-and-drop mixin for React with full DOM control](https://github.com/gaearon/react-dnd)
* [react-sticky - <Sticky /> component for React-based apps](https://github.com/captivationsoftware/react-sticky)
* [js-object-to-table - JavaScript objects drawing themselves into a table using React](https://github.com/enaqx/js-object-to-table)
* [react-kaomoji - A React component for displaying Japanese emoticons](https://github.com/enaqx/react-kaomoji)
* [react-calendar - Calendar that inspired by React philosophy](https://github.com/Aetet/react-calendar)
* [react-element-pan - React component for allowing panning of DOM-elements](https://github.com/rexxars/react-element-pan)
* [react-anchor - Functional factory to create react anchor components](https://github.com/yoshuawuyts/react-anchor)
* [react-bootstrap-daterangepicker - A date/time picker for react (using Bootstrap)](https://github.com/skratchdot/react-bootstrap-daterangepicker)
* [react-bootstrap-datetimepicker - A react.js datetime picker for Bootstrap](https://github.com/quri/react-bootstrap-datetimepicker)
* [react-bootstrap-multiselect - A multiselect component for react (with bootstrap)](https://github.com/skratchdot/react-bootstrap-multiselect)
* [react-colorpicker - Colorpicker for React](https://github.com/stayradiated/react-colorpicker)
* [react-commits-graph - A React component to render an svg graph of git commits](https://www.npmjs.org/package/react-commits-graph)
* [react-layout - Dynamic subview layout for React](https://github.com/jsdf/react-layout)
* [react-weather - Example React weather app using forecast.io's API](https://github.com/andrewgleave/react-weather)
* [react-sparkline - React component for rendering simple sparklines](https://github.com/KyleAMathews/react-sparkline)
* [react-component-width-mixin - React mixin which sets width](https://github.com/KyleAMathews/react-component-width-mixin)
* [react-micro-bar-chart - React component for micro bar-charts rendered with D3](https://github.com/KyleAMathews/react-micro-bar-chart)
* [react-horizontal-bar-chart - Simple horizontal bar chart component, using D3 scales only](https://github.com/laem/react-horizontal-bar-chart)
* [react-boxplot - Simple SVG box plots in React](https://github.com/bodylabs/react-boxplot)
* [react-infinity - A UITableView Inspired list and grid display](https://github.com/nmn/react-infinity)
* [react-timeago - A simple time-ago component for React](https://github.com/nmn/react-timeago)
* [react-spinkit - A collection of loading indicators animated with CSS for React](https://github.com/KyleAMathews/react-spinkit)
* [react.animate - State animation plugin for react.js](https://github.com/pleasetrythisathome/react.animate)
* [react-animate - React animation mixin](https://github.com/elierotenberg/react-animate)
* [react-star-rating-input - React.js component for entering 0-5 stars](https://github.com/ikr/react-star-rating-input)
* [react-star-rating - A simple star rating component built with React.](https://github.com/cameronjroe/react-star-rating)
* [react-data-components - React components and mixins for manipulating data](https://github.com/carlosrocha/react-data-components)
* [react-number-editor - Number editor (textfield) component for react](https://github.com/tleunen/react-number-editor)
* [react-localstorage - Simple localstorage mixin for react](https://github.com/STRML/react-localstorage)
* [react-sortable-data React Mixin to sort data easily](https://github.com/AndrewHathaway/ReactSortableDataMixin)
* [react-widgets - Suite of ui input widgets including combobox, multiselect, datepicker and more](https://github.com/theporchrat/react-widgets)
* [react-select - Rich Select Component](https://github.com/JedWatson/react-select)
* [react-video - React component to load video from Vimeo or Youtube](https://github.com/pedronauck/react-video)
* [react-captcha - A react.js reCAPTCHA for Google](https://github.com/appleboy/react-recaptcha)
* [react-cassette-player - Vector-based HTML5 Audio Player](https://github.com/chadpaulson/react-cassette-player)
* [react-tagsinput - A simple react component for inputing tags.](https://github.com/olahol/react-tagsinput)
* [react-autolink - An autolink mixin for React](https://github.com/banyan/react-autolink)
* [react-emoji - An emoji mixin for React](https://github.com/banyan/react-emoji)
* [react-portal - A transportation of (not just) modals and lightboxes to document.body](https://github.com/tajo/react-portal)
* [react-hotkeys - Declarative hotkey and focus area management for React](https://github.com/Chrisui/react-hotkeys)
* [react-data-grid - Data grid for React:Excel-like grid component built with React, with editors, keyboard navigation, copy & paste ](https://github.com/adazzle/react-data-grid)
* [react-datagrid - A carefully crafted DataGrid for React](https://github.com/nishp1/react-datagrid)
* [react-panels - A multipurpose tabbed panel with many features](https://github.com/Theadd/react-panels)
* [autoresponsive-react - A Magical Layout Libary For React](http://xudafeng.github.io/autoresponsive-react)
* [Belle - Set of easy to style React Components with great UX](http://nikgraf.github.io/belle/)
* [react-input-color - React input color component with hsv color picker](https://github.com/wangzuo/react-input-color)
* [react-medium-editor - React wrapper for medium-editor](https://github.com/wangzuo/react-medium-editor)
* [react-progress-label - Progress label component](https://github.com/wangzuo/react-progress-label)
* [react-input-slider - React input slider component](https://github.com/wangzuo/react-input-slider)
* [react-range-slider - Collection of react slider components](https://github.com/jpuri/react-range-slider)
* [rheostat - a www, mobile, and accessible slider component](https://github.com/airbnb/rheostat)
* [react-ui-tree - React tree component with drag and drop support](https://github.com/pqx/react-ui-tree)
* [react-frame - React components within an iframe for isolated css styling](https://github.com/pqx/react-frame)
* [rodal - A React modal with animations](https://github.com/chenjiahan/rodal)
* [react-scrollbar - Simple ScrollArea component built for React](https://github.com/souhe/reactScrollbar)
* [react-experiments - Implement A/B tests with randomized parameterizations of your components](https://github.com/HubSpot/react-experiments)
* [react-slide-deck - For swipe, tabs, carousel, one page scroll. With animation hooks. tweening, tween callbacks](https://github.com/jl-/react-slide-deck)
* [react-resizable-box - Resizable component for React](https://github.com/bokuweb/react-resizable-box)
* [react-ios-switch - React switch component](https://github.com/clariussystems/react-ios-switch)
* [react-listview-sticky-header - Turn listview with section headers that stick to the top](https://github.com/cht8687/react-listview-sticky-header)
* [react-expandable-listview - Create listview with expandable section headers](https://github.com/cht8687/react-expandable-listview)
* [react-keydown - Lightweight keydown wrapper for React components](https://github.com/glortho/react-keydown)
* [searchkit  - Components to build user interfaces for elasticsearch](https://github.com/searchkit/searchkit)
* [grommet - The most advanced UX framework for enterprise applications](https://github.com/grommet/grommet)
* [react-resizable-and-movable - Resizable and movable component for React](https://github.com/bokuweb/react-resizable-and-movable)
* [react-sidebar - An app like sidebar for React including touch support](https://balloob.github.io/react-sidebar/example)
* [react-motion - An spring-based animation library, similar to Rebound.js](https://github.com/chenglou/react-motion)
* [react-motion-menu - Motion menu component powered by React Motion](https://github.com/bokuweb/react-motion-menu)
* [sweetalert-react - Using sweetalert in React](https://github.com/chentsulin/sweetalert-react)
* [React Joyride - Create walkthroughs, tours and tooltips for your apps](http://gilbarbara.github.io/react-joyride/)
* [react-file-reader-input - Complete control over styling + abstraction from file reading](https://github.com/ngokevin/react-file-reader-input)
* [react-sortable-pane - Resizable and sortable pane component for React](https://github.com/bokuweb/react-sortable-pane)
* [react-DnR - Dragable and Resizable window build with React.js](https://github.com/yongxu/react-DnR)
* [react-http-request - React component exposes network request functionality](https://github.com/mbasso/react-http-request)
* [react-https-redirect - Force a redirect to HTTPS when not on a local web server](https://github.com/mbasso/react-https-redirect)
* [react-browser-detection - React component to detect browser](https://github.com/mbasso/react-browser-detection)
* [react-text-mask - React input mask](https://github.com/text-mask/text-mask)
* [react-imask - another React input mask](https://github.com/uNmAnNeR/imaskjs/tree/gh-pages/plugins/react)
* [rebass - Configurable React Stateless Functional UI Components](https://github.com/jxnblk/rebass)
* [echarts-for-react - baidu Echarts(v3.0) components for React](https://github.com/hustcc/echarts-for-react)
* [react-pagespeed-score - A React component for display a dial-type chart of PageSpeed Insights](https://github.com/cauealves/react-pagespeed-score)
* [react-livestamp - A simple and html date countdown component for React](https://github.com/markafoni/react-livestamp)
* [react-offcanvas - Off-canvas menus for React](https://github.com/vutran/react-offcanvas)
* [react-svg-pan-zoom - Adds pan and zoom features to the SVG images](http://chrvadala.github.io/react-svg-pan-zoom/)
* [react-virtualized - React components for efficiently rendering large lists and tabular data ](https://github.com/bvaughn/react-virtualized)
* [react-colorizer - A library for generation of harmonious color themes for React](https://github.com/opensource-cards/react-colorizer)
* [react-skeletor - Display a skeleton preview of your application's content before the data get loaded](https://github.com/trainline/react-skeletor)
* [react-data-menu - Smart data-driven menu rendered in an overlay, never clipped by other components or screen edges](https://github.com/dkozar/react-data-menu)
* [omnibar - Extensible search component for React.](https://github.com/vutran/omnibar)
* [react-virtualized-sticky-tree - Render virtualized tree structures with support for position: sticky ](https://github.com/marchaos/react-virtualized-sticky-tree)
* [react-flexbox-svg - Flexbox for SVG in React, using css-layout](https://github.com/paulmelnikow/react-flexbox-svg)
* [react-instantsearch - Search Interface building blocks for Algolia](https://github.com/algolia/react-instantsearch)
* [react-d3-tree - Create interactive D3 tree graphs](https://github.com/bkrem/react-d3-tree)
* [react-redux-modal-flex - Accessible modal dialog component for React, easy to install and use with Redux.](https://github.com/tronghiep92/react-redux-modal-flex)
* [react-switch - A draggable, customizable and accessible toggle-switch component.](https://github.com/yogaboll/react-switch)
* [react-credit-card-input - A simple credit/debit card input field for React.](https://github.com/medipass/react-credit-card-input)
* [react-creditcard - An awesome react credit card component.](https://github.com/medipass/react-creditcard)
* [email-autocomplete-input - Simple email autocomplete input.](https://github.com/alex-cory/email-autocomplete-input)
* [rlist-view - List view for react with pulling refresh and infinite data load ](https://github.com/gitpadtech/rlist-view)
* [react-breadcrumbs-dynamic - Extremely flexible and completely router-independent react breadcrumbs solution](https://github.com/oklas/react-breadcrumbs-dynamic)
* [react-automatic-width - Automatically sets `width` property on child components](https://github.com/zalando-stups/react-automatic-width)
* [react-js-diagrams - A flow based diagramming library](http://github.com/woodenconsulting/react-js-diagrams/)
* [react-file-input-previews-base64 - Wrapper around file input, with option for image previews and returning file as base64 string](https://github.com/SiDevesh/react-file-input-previews-base64)
* [react-credit-cards - Beautiful credit cards for your payment forms](https://github.com/amarofashion/react-credit-cards)
* [react-dropdown-tree-select - Lightweight, customizable and fast Dropdown Tree Select component for React](https://github.com/dowjones/react-dropdown-tree-select)
* [react-sortly - Simple, lightweight and highly customizable dnd nested sortable component](https://github.com/lytc/react-sortly)  
* [react-dates - An easily internationalizable, mobile-friendly datepicker library for the web](https://github.com/airbnb/react-dates)
* [react-ui-cards - Various card components for React](https://github.com/nukeop/react-ui-cards)
* [React components IO - A curated list of useful React component libraries and component related tools](https://www.reactcomponent.io/)

##### Containers
* [Reapop - A React & Redux notifications system](https://github.com/LouisBarranqueiro/reapop)

##### Libraries
* [react-magic - Automatically AJAXify plain HTML with the power of React](https://github.com/reactjs/react-magic)
* [react-toolbox - A set of React components implementing Google's Material Design specification](https://github.com/react-toolbox/react-toolbox)
* [tcomb-react -  Library allowing you to check all the props of your React components](https://github.com/gcanti/tcomb-react)
* [react-responsive - Media queries in react for responsive design](https://github.com/wearefractal/react-responsive)
* [react-cursor - Functional state management abstraction for use with Facebook React](https://github.com/dustingetz/react-cursor)
* [Omniscient.js - Abstracting React components for fast top down render of immutable data](https://github.com/omniscientjs/omniscient)
* [Touchstonejs - React.js powered UI framework for developing beautiful hybrid mobile apps.](https://github.com/touchstonejs/touchstonejs)
* [Elemental - A UI Toolkit for React.js Websites and Apps](http://elemental-ui.com/)
* [StateTrooper - Centrally manage state for React applications with CSP](https://github.com/swipely/state-trooper)
* [Preact: Fast 3kb React alternative with the same ES6 API.](https://git.io/preact)
* [riotjs - A React- like, 3.5KB user interface library](https://github.com/muut/riotjs)
* [Maple.js - Bringing the concept of web-components to React](https://github.com/Wildhoney/Maple.js)
* [react-i13n - A performant, scalable and pluggable approach to instrumenting your React application](https://github.com/yahoo/react-i13n)
* [react-icons - svg react icons of popular icon packs](https://github.com/gorangajic/react-icons)
* [Keo - Plain functions for a more functional Deku approach to creating React components, with functional goodies such as pipe, memoize, etc...](https://github.com/Wildhoney/Keo)
* [Blueprint - A React-based UI toolkit for the web](https://github.com/palantir/blueprint)
* [Bit - A virtual repository for managing and using react and other web components across applications](https://github.com/teambit/bit)
* [AtlasKit -  Atlassian's React UI library](https://atlaskit.atlassian.com/)
* [ReactiveSearch - UI components libray for Elasticsearch](https://github.com/appbaseio/reactivesearch)

##### Integration
* [ReactJS.NET](http://reactjs.net/)
* [React ASP.NET Boilerplate](https://github.com/pauldotknopf/react-aspnet-boilerplate)
* [React Bootstrap](https://github.com/react-bootstrap/react-bootstrap/)
* [React Bootstrap Components Playground](http://gcanti.github.io/resources/tcomb-react-bootstrap/playground/playground.html)
* [React Rails](https://github.com/reactjs/react-rails)
* [React on Rails](https://github.com/elierotenberg/react-rails)
* [om - ClojureScript interface](https://github.com/swannodette/om)
* [quiescent - A lightweight ClojureScript abstraction over React](https://github.com/levand/quiescent)
* [Reagent - A minimalistic ClojureScript interface to React.js](https://github.com/reagent-project/reagent)
* [react-haskell - React bindings for Haskell](https://github.com/joelburget/react-haskell)
* [Express React views](https://github.com/reactjs/express-react-views)
* [Express Coffee-React views - render coffee-react on the server](https://github.com/duereg/express-coffee-react-views)
* [React Page Middleware](https://github.com/reactjs/react-page-middleware)
* [ngReact - React Components in Angular](https://github.com/davidchang/ngReact)
* [React Python](https://github.com/reactjs/react-python)
* [React PHP](https://github.com/reactjs/react-php-v8js)
* [React Laravel](https://github.com/talyssonoc/react-laravel)
* [React Meteor](https://github.com/reactjs/react-meteor)
* [Coffee React](https://github.com/jsdf/coffee-react)
* [react-coffee - Build React components using natural CoffeeScript syntax](https://github.com/elucidata/react-coffee)
* [coffee-react-transform - Provides React JSX support for Coffeescript](https://github.com/jsdf/coffee-react-transform)
* [sprockets-coffee-react - Sprockets preprocessor for CJSX](https://github.com/jsdf/sprockets-coffee-react)
* [react-kup -  A simple, non-intrusive alternative to jsx for coffeescript](https://github.com/snd/react-kup)
* [turbo-react - Combine Turbolinks and React to apply DOM diffs](https://github.com/ssorallen/turbo-react)
* [react-bacon - A little module for using React with Bacon.js](https://github.com/jamesmacaulay/react-bacon)
* [msx - React's JSX Transformer, tweaked to output calls to Mithril](https://github.com/insin/msx)
* [React.withBackbone - React 16 ready backbone binding](https://github.com/beanworks/React.withBackbone)
* [Backbone React Component](https://github.com/magalhas/backbone-react-component)
* [react-backbone - Backbone-aware mixins for react](https://github.com/jhudson8/react-backbone)
* [NestedReact - transparent integration with Backbone Views and NestedTypes models](https://github.com/Volicon/NestedReact/)
* [backbone-reaction - React, Backbone and then some](https://github.com/jhudson8/backbone-reaction)
* [react.backbone - Plugin for React to make Backbone migration easier](https://github.com/usepropeller/react.backbone)
* [reactbone - React extensions for Backbone](https://github.com/andrejewski/reactbone)
* [backbone-react-ui - React components for use with backbone and backbone paginator](https://github.com/securingsincity/backbone-react-ui)
* [react-events - Declarative managed event bindings for react components](https://github.com/jhudson8/react-events)
* [react-mixin-manager - React mixin registration manager](https://github.com/jhudson8/react-mixin-manager)
* [gsap-react-plugin - A GSAP plugin for tweening React.js component state](https://github.com/hzdg/gsap-react-plugin)
* [react-topcoat by @plaxdan - Topcoat CSS components built with the React library](https://github.com/plaxdan/react-topcoat)
* [react-topcoat by @arnemart - A collection of React components for Topcoat](https://github.com/arnemart/react-topcoat)
* [reactdown - Write React components using markdown syntax](https://github.com/andreypopp/reactdown)
* [react-jade - Compile Jade to React JavaScript](https://github.com/ForbesLindesay/react-jade)
* [jade-react - Compile Jade templates to React.DOM expressions](https://github.com/duncanbeevers/jade-react)
* [gulp-jade-react - Compile Jade templates into React de-sugared JSX with Gulp](https://github.com/duncanbeevers/gulp-jade-react)
* [react-semantic-ui - React components for Semantic UI](https://github.com/jhudson8/react-semantic-ui)
* [semantic-react - React wrappers for Semantic UI](https://github.com/DveMac/semantic-react)
* [sbt-reactjs - React SBT Plugin using npm](https://github.com/ddispaltro/sbt-reactjs)
* [scalajs-react - A guilty affair between Scala.js and Facebook's React](https://github.com/japgolly/scalajs-react)
* [rpm-xtags-rivets-finch-react - RPM project: x-tags, rivets.js, finch.js, and React](https://github.com/ruahman/rpm-xtags-rivets-finch-react)
* [react-xtags - Using React to implement xtags](https://github.com/vjeux/react-xtags/)
* [jreact - React on server-side Java (with Rhino or Nashorn)](https://github.com/KnisterPeter/jreact)
* [React.hiccup - A complete replacement for JSX written in sweet.js](https://github.com/lantiga/react.hiccup)
* [react-play - Rendering React components in the Play Framework with JDK8's Nashorn](https://github.com/ssorallen/react-play)
* [rx-react - Utilitiels to works with React in a RxJS](https://github.com/fdecampredon/rx-react)
* [react-with-di - A hacked prototype of React.js with DI](https://github.com/vojtajina/react-with-di)
* [reactfire - ReactJS mixin for easy Firebase integration](https://github.com/firebase/reactfire)
* [firedux - Firebase + Redux for ReactJS](https://github.com/AndersDJohnson/firedux)
* [react-clickdrag-mixin - ClickDrag mixin for React component](https://github.com/tleunen/react-clickdrag-mixin)
* [Rewrite the Admin UI of KeystoneJS in React](https://github.com/keystonejs/keystone/issues/503)
* [react-masonry-mixin - Standalone mixin for Masonry (@desandro)](https://github.com/eiriklv/react-masonry-mixin)
* [react-packery-mixin - Standalone mixin for Packery (Metafizzy)](https://github.com/eiriklv/react-packery-mixin)
* [react-dropzone - Simple HTML5 drag-drop zone with React.js.](https://github.com/paramaggarwal/react-dropzone)
* [aframe-react - A-Frame VR + React](https://github.com/ngokevin/aframe)
* [react-three - React bindings to create and control a 3D scene using three.js](https://github.com/Izzimach/react-three)
* [react-three-renderer - Render into a three.js canvas using React](https://github.com/toxicFork/react-three-renderer)
* [react-threejs - Simplest bindings between React & Three.js](https://github.com/fritx/react-threejs)

##### Forms
* [React Forms](http://facebook.github.io/react/docs/forms.html)
* [react-formal - Better form validation and value management for React, Provides minimal wiring](https://github.com/jquense/react-formal)
* [react-forms - Forms library for React](https://github.com/prometheusresearch/react-forms)
* [valuelink - full-featured two-way data binding with extended React links](https://github.com/Volicon/valuelink)
* [wingspan-forms - A dynamic form library for Facebook React](https://github.com/wingspan/wingspan-forms)
* [newforms - Isomorphic form-handling for React](https://github.com/insin/newforms)
* [formjs - A form generator for Reactjs](https://github.com/zackify/formjs)
* [react-form-builder - A Form Builder for React.js](https://github.com/quri/react-form-builder)
* [plexus-form - A dynamic form component for react using JSON-Schema](https://github.com/AppliedMathematicsANU/plexus-form)
* [tcomb-form - UI library for developing forms writing less code](https://github.com/gcanti/tcomb-form)
* [formsy-react - A form input builder and validator for React JS](https://github.com/christianalfoni/formsy-react)
* [Learn Raw React: Ridiculously Simple Forms](http://jamesknelson.com/learn-raw-react-ridiculously-simple-forms/)
* [Winterfell - Generate complex, validated and extendable JSON-based forms in React](https://github.com/andrewhathaway/Winterfell)
* [Redux-Autoform - Create Redux-Forms dynamically out of metadata](https://github.com/redux-autoform/redux-autoform)
* [uniforms - Bunch of React components and helpers to easily generate and validate forms](https://github.com/vazco/uniforms)
* [formik - Forms in React, without tears](https://github.com/jaredpalmer/formik)
* [NeoForm – Modular HOCs for form state management and validation](https://github.com/zero-plus-x/neoform)
* [react-jsonschema-form – A React component for building Web forms from JSON Schema](https://github.com/mozilla-services/react-jsonschema-form)
* [List View Select - A Togglable select box for React Native with native components](https://github.com/JamesWatling/react-native-list-view-select)

##### Autocomplete
* [react-typeahead-search by @tonyspiro](https://github.com/tonyspiro/react-typeahead-search)
* [react-autocomplete by @rackt - WAI-ARIA compliant React autocomplete](https://github.com/rackt/react-autocomplete)
* [react-autosuggest by @moroshko - WAI-ARIA compliant React autosuggest component](https://github.com/moroshko/react-autosuggest)
* [react-autocomplete by @eliseumds- Just tasting some ReactJS + RxJS](https://github.com/eliseumds/react-autocomplete)
* [react-autocomplete by @prometheusresearch - Autocomplete widget based on React](https://github.com/prometheusresearch/react-autocomplete)
* [instatype by @gragland - Simple react autocomplete component](https://github.com/gragland/instatype)
* [downshift - 🏎 Primitives to build simple, flexible, WAI-ARIA compliant enhanced input React components](https://github.com/paypal/downshift)

##### Documentation Tools
* [react-docgen - Extract information from React component files for documentation generation](https://github.com/reactjs/react-docgen)
* [react-styleguide-generator - Easily generate a good-looking styleguide](https://github.com/pocotan001/react-styleguide-generator)

##### Graphics
* [react-art - React Bridge to the ART Drawing Library](https://github.com/facebook/react-art)
* [react-canvas - High performance <canvas> rendering for React components](https://github.com/Flipboard/react-canvas)
* [react-famous - Complex 3D animations UI at 60 FPS with Famo.us](https://github.com/pilwon/react-famous)
* [react-kinetic - HTML5 Canvas via KineticJS using React](https://github.com/freiksenet/react-kinetic)
* [react-svg-morph - morph your svg components one into another](https://github.com/gorangajic/react-svg-morph)

##### Model Libraries
* [mori - ClojureScript's persistent data structures and supporting API](https://github.com/swannodette/mori)
* [NestedTypes - fast mutable models with "pure render" support](https://github.com/Volicon/NestedTypes)
* [swarm - JavaScript replicated model (M of MVC) library](https://github.com/gritzko/swarm)
* [caplet - JavaScript models library](https://github.com/mojo-js/caplet.js)

##### Data Managing
* [Immutable.js - Immutable Data Collections for Javascript](https://github.com/facebook/immutable-js)
* [cortex - A javascript library for centrally managing data with React](https://github.com/mquan/cortex)
* [avers - A modern client-side model abstraction library](https://github.com/wereHamster/avers)
* [imvvm - Immutable Model-View-ViewModel for React](https://github.com/entrendipity/imvvm)
* [morearty.js - Better state management for React in pure JavaScript](https://github.com/moreartyjs/moreartyjs)
* [valuable - An immutable data store for React](https://github.com/josephsavona/valuable)
* [react-resolver - Isomorphic library to recursively lazy-load data for React components](https://github.com/ericclemmons/react-resolver)
* [freezer-js - Lightweight and reactive immutable data structure for React](https://github.com/arqex/freezer)
* [MobX - Simple, scalable state management](#mobx)
* [baobab - JavaScript persistent and optionally immutable data tree with cursors](https://github.com/Yomguithereal/baobab)
* [baobab-react - React integration for Baobab](https://github.com/Yomguithereal/baobab-react)
* [datascript - Immutable database and Datalog query engine in ClojureScript](https://github.com/tonsky/datascript)
* [immstruct - Immutable data structures with history for top-to-bottom properties in component based libraries like React](https://github.com/omniscientjs/immstruct)
* [seamless-immutable - Immutable data structures for JavaScript which are backwards-compatible with normal JS Arrays and Objects](https://github.com/rtfeldman/seamless-immutable)
* [tydel - Typed Models and Collections, with React bindings](http://tydel.js.org)
* [extendable-immutable - Extend any Immutable.js data structure](https://github.com/philpl/extendable-immutable)
* [statty - A tiny and unobtrusive state management library for React and Preact apps](https://github.com/vesparny/statty)
* [Hydux - An Elm-Like state manager for React with "batteries included"](https://github.com/hydux/hydux)

##### React Developer Experience
* [react-devtools - React Chrome Developer Tools](https://github.com/facebook/react-devtools)
* [react-transform-hmr - A React Transform that enables hot reloading React](https://github.com/gaearon/react-transform-hmr)
* [Nuclide - An open IDE for web and native mobile development, built on top of Atom](http://nuclide.io/)
* [babel-sublime - Syntax definitions for ES6 JavaScript with React JSX extensions](https://github.com/babel/babel-sublime)
* [babel-sublime-snippets - Next generation JavaScript and React snippets for Sublime](https://github.com/babel/babel-sublime-snippets)
* [atom-react - Atom React.js support](https://atom.io/packages/react)
* [vim-jsx - Vim JSX Syntax](https://github.com/mxw/vim-jsx)
* [vim-react-snippets - Vim version of the snippets from sublime-react](https://github.com/justinj/vim-react-snippets)
* [vim-babel - Wrapper around babel.js for vim](https://github.com/jbgutierrez/vim-babel)
* [web-mode.el - An autonomous emacs major-mode for editing web templates](http://web-mode.org/)
* [eslint-plugin-react - React specific linting rules for ESLint](https://github.com/yannickcr/eslint-plugin-react)
* [generator-react-webpack - Yeoman generator for ReactJS and Webpack](https://github.com/newtriks/generator-react-webpack)
* [generator-react-gulp-browserify - Yeoman generator for React](https://github.com/randylien/generator-react-gulp-browserify)
* [generator-reactapp - Yeoman generator for react app with redux, webpack, gulp and restful.js etc.](https://github.com/Jackong/generator-reactapp)
* [static-site-generator-webpack-plugin - Prerender isomorphic JavaScript apps to static HTML](https://github.com/markdalgleish/static-site-generator-webpack-plugin)
* [react-cosmos - DX tool for designing reusable React components](https://github.com/react-cosmos/react-cosmos)
* [React Storybook - UI Component Dev Environment for React](https://github.com/kadirahq/react-storybook)
* [generator-sui-react - A yeoman generator for Schibsted User Interface (SUI) ReactJS components](https://github.com/SUI-Components/generator-sui-react)
* [Racket - A yeoman generator for creating a universal react/redux web application](https://github.com/mohebifar/racket)

##### Template Engines
 * [react-templates - Lightweight templates for React](https://github.com/wix/react-templates)
 * [teact - A JSX alternative based on composing functions in the Markaby / CoffeeKup / Teacup tradition](https://github.com/hurrymaplelad/teact)

##### Maps
* [react-googlemaps - React interface to Google maps](https://github.com/pieterv/react-googlemaps)
* [react-maps - A map component for React](https://github.com/matnel/react-maps)
* [react-google-maps - React.js Google Maps integration component](https://github.com/tomchentw/react-google-maps)
* [react-gmaps - A Google Maps component for React.js](https://github.com/MicheleBertoli/react-gmaps)
* [react-map-gl - A React wrapper for MapboxGL-js plus overlay API](https://github.com/uber/react-map-gl)
* [google-map-react - Isomorphic google map React component](https://github.com/istarkov/google-map-react)
* [react-mapbox-gl - A mapbox-gl-js wrapper to make the API react friendly](https://github.com/alex3165/react-mapbox-gl)

##### Charts
* [react-chartjs - Common react charting components using chart.js](https://github.com/jhudson8/react-chartjs)
* [react-stockcharts - Highly customizable stock charts with ReactJS and d3](https://github.com/rrag/react-stockcharts)
* [Number Picture - Low-level React + D3 building blocks](http://numberpicture.com/library)
* [VictoryJS - A collection of composable React components for building interactive data visualizations](https://github.com/FormidableLabs/victory)
* [Recharts - A charting library built on D3 with an awesome declarative API](https://github.com/recharts/recharts)


---
### React Native
> Framework for building native apps using React

#### React Native General Resources
* [React Native Official Site](https://facebook.github.io/react-native/)
* [React Native GitHub](https://github.com/facebook/react-native)
* [React Native Newsletter](http://brentvatne.ca/react-native-newsletter/)
* [React Native Playground](https://rnplay.org/)
* [React Native Awesome List](https://github.com/jondot/awesome-react-native)
* [React Native StackOverflow](http://stackoverflow.com/questions/tagged/react-native)
* [React Native Radio](https://devchat.tv/react-native-radio/)

#### React Native Tutorials
* [React Native Tutorial](https://facebook.github.io/react-native/docs/tutorial.html)
* [Building the F8 2016 App](http://makeitopen.com/)
* [Introducing React Native: Building Apps with JavaScript](http://www.raywenderlich.com/99473/introducing-react-native-building-apps-javascript)
* [Introduction to React Native: Building iOS Apps with JavaScript](http://www.appcoda.com/react-native-introduction/)
* [React Native Meets Async Functions](https://medium.com/the-exponent-log/react-native-meets-async-functions-3e6f81111173)
* [Gesture detection in React Native – fixing unexpected panning](http://blog.lum.pe/gesture-detection-in-react-native-fixing-unexpected-panning/)
* [Use The iOS Camera In Your React Native Mobile App](https://blog.nraboy.com/2015/09/use-the-ios-camera-in-your-react-native-mobile-app/)
* [Digital Smart Mirror lab with React Native](http://atticuswhite.com/blog/react-native-smart-mirror-lab/)
* [The Beauty Of React Native: Building Your First iOS App With JavaScript (Part 1)](https://www.smashingmagazine.com/2016/04/the-beauty-of-react-native-building-your-first-ios-app-with-javascript-part-1/)
* [The Beauty Of React Native: Building Your First iOS App With JavaScript (Part 2)](https://www.smashingmagazine.com/2016/04/how-to-build-your-first-ios-app-with-javascript/)
* [A Mini-Course on React Native Flexbox](https://medium.com/@yoniweisbrod/a-mini-course-on-react-native-flexbox-2832a1ccc6)
* [A Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)
* [Test driving react native applications](http://www.multunus.com/blog/2016/07/test-driving-react-native-applications/)

#### React Native Developer Experience
* [react-native-webpack-server - Build React Native apps with Webpack](https://github.com/mjohnston/react-native-webpack-server)
* [react-native-code-push - React Native plugin for the CodePush service](https://github.com/Microsoft/react-native-code-push)
* [Preview your React Native apps in your Github Pull Request](http://tech.m6web.fr/preview-android-ios-react-native-on-github-pull-request/)

#### React Native Sample Apps
* [HackerNews](https://github.com/iSimar/HackerNews-React-Native)
* [Ziliun](https://github.com/sonnylazuardi/ziliun-react-native)
* [FinanceReactNative](https://github.com/7kfpun/FinanceReactNative)
* [SplashWalls](https://github.com/nashvail/SplashWalls)
* [NBAreact](https://github.com/jbkuczma/NBAreact)

#### React Native Boilerplates
* [Create React Native App - Create a React Native app on any OS with no build config, with or without Expo](https://github.com/react-community/create-react-native-app)
* [Snowflake - React Native iOS & Android with Redux, Parse.com, Jest (88% coverage)](https://github.com/bartonhammond/snowflake)
* [Ignite - The hottest CLI for React Native, boilerplates, plugins, generators, and more!](https://github.com/infinitered/ignite)

#### React Native Awesome Components
* [react-native-social-share - Use the iOS and Android native Twitter and Facebook share popup with React Native](https://github.com/doefler/react-native-social-share)
* [react-native-fbsdk - A wrapper around the iOS Facebook SDK](https://github.com/facebook/react-native-fbsdk)
* [react-native-side-menu - Simple customizable component to create side menu](https://github.com/Kureev/react-native-side-menu)
* [react-native-mapbox-gl - A Mapbox GL react native module](https://github.com/mapbox/react-native-mapbox-gl)
* [react-native-icons - Quick and easy icons in React Native](https://github.com/corymsmith/react-native-icons)
* [react-native-vector-icons - 3000 Customizable Icons for React Native with support for NavBar/TabBar](https://github.com/oblador/react-native-vector-icons)
* [react-native-google-signin - Google Signin for React Native](https://github.com/apptailor/react-native-google-signin)


---
### JSX
> XML-Like Syntax Extension to JavaScript

#### JSX Resources
* [JSX Spec](https://facebook.github.io/jsx/)
* [JSX in Depth](http://facebook.github.io/react/docs/jsx-in-depth.html)
* [JSX in TypeScript](https://github.com/Microsoft/TypeScript/wiki/JSX)

---
### Flux
> Application Architecture for Building User Interfaces

#### Flux General Resources
* [Flux Official Site](http://facebook.github.io/flux/)
* [Flux GitHub](https://github.com/facebook/flux)
* [Awesome Flux](https://github.com/yanmagale/awesome-flux/)

#### Flux Implementations
* [Flux Comparision](https://github.com/voronianski/flux-comparison)
* [RefluxJS](https://github.com/spoike/refluxjs)
* [Fluxxor](https://github.com/BinaryMuse/fluxxor)
* [Marty](https://github.com/martyjs/marty)
* [McFly](https://github.com/kenwheeler/mcfly)
* [Alt](https://github.com/goatslacker/alt)
* [Fluxible](https://github.com/yahoo/fluxible)
* [NuclearJS](https://github.com/optimizely/nuclear-js)
* [Flummox](https://github.com/acdlite/flummox)
* [Coflux](https://github.com/blainekasten/coflux)
* [MobX](#mobx)
* [Sinux](https://github.com/jbpin/sinux)

#### Flux Tutorials
* [Building Applications with React and Flux](https://www.pluralsight.com/courses/react-flux-building-applications)
* [Flux Application Architecture](http://facebook.github.io/flux/docs/overview.html)
* [Flux: A simple architecture model to build Client-side apps](https://speakerdeck.com/pedronauck/flux-a-simple-architecture-model-to-build-client-side-apps)
* [Isomorphic Flux examples using Dispatchr and Fetchr from Yahoo](https://github.com/yahoo/flux-examples)
* [Async requests with React.js and Flux](http://www.code-experience.com/async-requests-with-react-js-and-flux-revisited/)
* [Implementing Flux in CoffeeScript](http://archive.is/l9ih6)
* [React: Flux Architecture](https://egghead.io/series/react-flux-architecture)
* [Understanding Flux](https://medium.com/@garychambers108/understanding-flux-f93e9f650af7)
* [Yo in Flux](http://davidandsuzi.com/yo-in-flux/)
* [React.js architecture - Flux VS Reflux](http://blog.krawaller.se/posts/react-js-architecture-flux-vs-reflux/)
* [Avoiding Event Chains in Single Page Applications](http://www.code-experience.com/avoiding-event-chains-in-single-page-applications/)
* [ReactJS and Flux](http://christianalfoni.github.io/javascript/2014/08/20/react-js-and-flux.html)
* [Deconstructing ReactJS's Flux](http://spoike.ghost.io/deconstructing-reactjss-flux/)
* [Flux Step By Step](http://blogs.atlassian.com/2014/08/flux-architecture-step-by-step/)
* [Flux in practice](https://medium.com/@garychambers108/flux-in-practice-ec08daa9041a)
* [What is the Flux Application Architecture?](https://medium.com/brigade-engineering/what-is-the-flux-application-architecture-b57ebca85b9e)
* [React + Flux Backed by Rails API: Part 1](http://fancypixel.github.io/blog/2015/01/28/react-plus-flux-backed-by-rails-api/)
* [React + Flux Backed by Rails API: Part 2](http://fancypixel.github.io/blog/2015/01/29/react-plus-flux-backed-by-rails-api-part-2/)
* [React + Flux Backed by Rails API: Part 3](http://fancypixel.github.io/blog/2015/01/30/react-plus-flux-backed-by-rails-api-part-3/)
* [Flux solutions compared by example](http://pixelhunter.me/post/110248593059/flux-solutions-compared-by-example)
* [Flux Cargo-Culting](https://medium.com/@cassiozen/flux-cargo-culting-3cae9ff27c0c)
* [The Case for Flux](https://medium.com/@dan_abramov/the-case-for-flux-379b7d1982c6)
* [The Evolution of Flux Frameworks](http://medium.com/@dan_abramov/the-evolution-of-flux-frameworks-6c16ad26bb31)
* [React with Flux by example - a simple Todo List dissected](http://reactkungfu.com/2015/07/react-with-flux-by-example-simple-todo-list-dissected/)
* [FOR FLUX SAKE! - a beginners tutorial](https://github.com/MIJOTHY/FOR_FLUX_SAKE)
* [Simple Counter App with React and Nuclear JS](https://github.com/haochuan/random-notes/blob/master/react/couter-app-with-react-nuclear.md)
* [LearnCode.academy Flux Tutorial Series](https://www.youtube.com/watch?v=PvjNglsyOHs&list=PLoYCgNOIyGABj2GQSlDRjgvXtqfDxKm5b&index=9)


---
### Redux
> Predictable State Container for JavaScript Apps

#### Redux General Resources
* [Redux GitHub](https://github.com/reactjs/redux)
* [Redux Official Site](http://redux.js.org/)
* [Awesome Redux List](https://github.com/xgrommx/awesome-redux)

#### Redux Tools
* [react-redux - Official React bindings for Redux](https://github.com/reactjs/react-redux)
* [redux-devtools - DevTools for Redux with hot reloading, action replay, and customizable UI](https://github.com/gaearon/redux-devtools)
  * [react-router-redux - Bindings to keep react-router and redux in sync](https://github.com/reactjs/react-router-redux)
* [redux-form - A Higher Order Component using react-redux to keep form state](https://github.com/erikras/redux-form)
* [redux-thunk - Thunk middleware for redux](https://github.com/gaearon/redux-thunk)
* [redux-logger - Logger middleware for redux](https://github.com/theaqua/redux-logger)
* [reselect - Selector library for Redux](https://github.com/reactjs/reselect)
* [normalizr - Normalizes nested JSON according to a schema](https://github.com/paularmstrong/normalizr)
* [redux-saga - An alternative side effect model for Redux apps](https://github.com/yelouafi/redux-saga)
* [redux-data-fx - Declarative Side Effects for Redux](https://github.com/matthieu-beteille/redux-data-fx)
* [redux-observable - RxJS middleware for Redux](https://github.com/redux-observable/redux-observable)
* [redux-analytics - Analytics middleware for Redux](https://github.com/markdalgleish/redux-analytics)
* [redux-undo - Higher order reducer to add undo/redo functionality to redux state containers](https://github.com/omnidan/redux-undo)
* [redux-search - Redux bindings for client-side search](https://github.com/treasure-data/redux-search)
* [redux-mock-store - A mock store for your testing your redux async action creators and middleware](https://github.com/arnaudbenard/redux-mock-store)
* [redux-immutable - Create an equivalent function of Redux combineReducers that works with Immutable.js state](https://github.com/gajus/redux-immutable)
* [redux-react-i18n - An i18n solution for redux/react](https://github.com/derzunov/redux-react-i18n)
* [R16N - A redux/react I18n solution](https://github.com/razodeh/r16n/)

#### Redux Tutorials
* [Building Applications with React and Redux in ES6](https://www.pluralsight.com/courses/react-redux-react-router-es6)
* [Getting Started with Redux](https://egghead.io/series/getting-started-with-redux)
* [Building React Applications with Idiomatic Redux](https://egghead.io/series/building-react-applications-with-idiomatic-redux)
* [Redux Tutorial](https://github.com/happypoulp/redux-tutorial)
* [Getting Started with React, Redux and Immutable: a Test-Driven Tutorial: Part 1](http://www.theodo.fr/blog/2016/03/getting-started-with-react-redux-and-immutable-a-test-driven-tutorial-part-1/)
* [Getting Started with React, Redux and Immutable: a Test-Driven Tutorial: Part 2](http://www.theodo.fr/blog/2016/03/getting-started-with-react-redux-and-immutable-a-test-driven-tutorial-part-2/)
* [Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)
* [Server-Side Rendering with Redux and React-Router](https://www.codementor.io/reactjs/tutorial/redux-server-rendering-react-router-universal-web-app)
* [Deep Introduction to Redux](https://www.codementor.io/reactjs/tutorial/intro-to-react-redux-pros)
* [Unit Testing Redux Apps](https://www.codementor.io/reactjs/tutorial/redux-unit-test-mocha-mocking)
* [Secure Your React and Redux App with JWT Authentication](https://auth0.com/blog/2016/01/04/secure-your-react-and-redux-app-with-jwt-authentication/)
* [Build an Image Gallery Using React, Redux and redux-saga](http://joelhooks.com/blog/2016/03/20/build-an-image-gallery-using-redux-saga)
* [A simplified approach to calling APIs with redux](http://www.sohamkamani.com/blog/2016/06/05/redux-apis/)
* [React Redux based blood donor demo application](https://github.com/smanne/reduxnor)
* [LearnCode.academy Redux Tutorials Series](https://www.youtube.com/watch?v=1w-oQ-i1XB8&list=PLoYCgNOIyGABj2GQSlDRjgvXtqfDxKm5b&index=15)


---
### MobX
> Simple, scalable state management for JavaScript Apps

#### MobX General Resources
* [MobX GitHub](https://github.com/mobxjs/mobx)
* [MobX Official Site](https://mobxjs.github.io/mobx/)

#### MobX Tools
* [mobx-react - React component wrapper for combining React with MobX](https://github.com/mobxjs/mobx-react)

#### MobX Tutorials
* [Ten minute introduction to MobX and React](https://mobxjs.github.io/mobx/getting-started.html)
* [Manage Complex State in React Apps with MobX](https://egghead.io/courses/manage-complex-state-in-react-apps-with-mobx)
* [Refactor your application from Redux to MobX](http://www.robinwieruch.de/mobx-react)
* [Redux or MobX: An attempt to dissolve the Confusion](https://www.robinwieruch.de/redux-mobx-confusion/)

---
### Testing
> React Testing

#### Testing Utilities
* [Jest - Painless JavaScript Unit Testing](http://facebook.github.io/jest/)
* [enzyme - JavaScript Testing utilities for React](https://github.com/airbnb/enzyme)
* [chai-immutable - Chai assertions for Facebook's Immutable library for JavaScript collections](https://github.com/astorije/chai-immutable)

##### Testing Tutorials
* [Approaches to testing React components - an overview](http://reactkungfu.com/2015/07/approaches-to-testing-react-components-an-overview/)
* [Unit testing React components without a DOM](http://simonsmith.io/unit-testing-react-components-without-a-dom/)
* [The missing piece to the React testing puzzle](https://medium.com/@bruderstein/the-missing-piece-to-the-react-testing-puzzle-c51cd30df7a0)


---
### GraphQL
> Query Language

#### GraphQL Spec
* [GraphQL Official Site](http://graphql.org/)
* [GraphQL Specification](http://facebook.github.io/graphql/)
* [GraphQL Specification Repository](https://github.com/facebook/graphql)

#### GraphQL Tools
* [GraphCMS - The GraphQL Headless CMS](https://graphcms.com)
* [GraphQL CMS](https://github.com/sarkistlt/graphql-auto-generating-cms)
* [Mongoose schema To GraphQL](https://github.com/sarkistlt/mongoose-schema-to-graphql)
* [GraphQL bridge to REST API](https://github.com/dacz/apollo-bridge-link)

#### GraphQL Tutorials
* [GraphQL Introduction](http://facebook.github.io/react/blog/2015/05/01/graphql-introduction.html)
* [First Thoughts on GraphQL](http://hueypetersen.com/posts/2015/02/02/first-thoughts-on-graph-ql/)
* [Modeling Queries in a GraphQL Like Way](http://hueypetersen.com/posts/2015/02/08/modeling-queries-graph-ql-like/)
* [Thin and Graphy](http://hueypetersen.com/posts/2015/02/22/thin-and-graphy/)
* [GraphQL and g2sd](https://webcache.googleusercontent.com/search?q=cache:xFibiodnfmgJ:https://fistfulofbytes.com/graphql-and-g2sd+&cd=1&hl=en&ct=clnk&gl=fr)
* [GraphQL Overview - Getting Started with GraphQL and Node.js](https://blog.risingstack.com/graphql-overview-getting-started-with-graphql-and-nodejs/)
* [Writing a Basic API with GraphQL](http://davidandsuzi.com/writing-a-basic-api-with-graphql/)
* [Building a GraphQL Server with Node.js and SQL](https://www.reindex.io/blog/building-a-graphql-server-with-node-js-and-sql/)
* [GraphQL Tour: Variables](https://medium.com/the-graphqlhub/graphql-tour-variables-58c6abd10f56#.wj9dsgyoy)
* [How to Graphql - The Fullstack Tutorial for GraphQL](https://howtographql.com/)
* [Build an online text RPG with React and GraphQL](https://learn.pusher.com/rpg)


#### GraphQL Implementations
* [graphql-js - A reference implementation of GraphQL for **JavaScript**](https://github.com/graphql/graphql-js)
* [react-transmit - Relay-inspired library based on **JavaScript Promises**](https://github.com/RickWong/react-transmit)
* [graphql-ruby - **Ruby** implementation of Facebook's GraphQL](https://github.com/rmosolgo/graphql-ruby)
* [graphql-java - GraphQL **Java** implementation](https://github.com/andimarek/graphql-java)
* [sangria - **Scala** GraphQL client and server library](https://github.com/OlegIlyenko/sangria)
* [graphql-php - A **PHP** port of GraphQL reference implementation](https://github.com/webonyx/graphql-php)
* [graphene - GraphQL in **Python** made simple](http://graphene-python.org/)
* [graphqllib - GraphQL implementation for **Python**](https://github.com/dittos/graphqllib)
* [graphql-dotnet - GraphQL for **.NET**](https://github.com/graphql-dotnet/graphql-dotnet)
* [graphql-go - GraphQL for Go/Golang](https://github.com/graphql-go/graphql)

#### Server Integration
* [express-graphql - Create a GraphQL HTTP server with **Express**](https://github.com/graphql/express-graphql)

#### Database Integration
* [graphql-bookshelf - Some help defining GraphQL schema around BookshelfJS models](https://github.com/brysgo/graphql-bookshelf)
* [GraphpostgresQL - GraphQL for **PostgreSQL**](https://github.com/solidsnack/GraphpostgresQL)
* [graffiti - Node.js GraphQL ORM](https://github.com/RisingStack/graffiti)
* [sql-to-graphql - Generate a GraphQL API based on your SQL database structure](https://github.com/vaffel/sql-to-graphql)
* [graphql-sequelize - GraphQL & Relay for MySQL & Postgres via Sequelize](https://github.com/mickhansen/graphql-sequelize)


---
### Relay
> Data-Driven React Applications

#### Relay General Resources
* [Relay Offical Site](https://facebook.github.io/relay/)
* [Relay GitHub](https://github.com/facebook/relay)

#### Relay Tutorials
* [official Relay Getting Started](https://facebook.github.io/relay/docs/en/introduction-to-relay.html)
* [Relay for Visual Learners](http://sgwilym.github.io/relay-visual-learners/)
* [Getting Started with Relay](https://auth0.com/blog/2015/10/06/getting-started-with-relay/)
* [Relay and Routing](https://medium.com/@cpojer/relay-and-routing-36b5439bad9)

#### Relay Tools
* [graphql-relay-js - A library to help construct a graphql-js server supporting react-relay](https://github.com/graphql/graphql-relay-js)
* [react-router-relay - Relay integration for React Router](https://github.com/relay-tools/react-router-relay)
* [relay-local-schema - Use Relay without a GraphQL server](https://github.com/relay-tools/relay-local-schema)
* [relay-codemod -  Codemod scripts based for on jsodeshift to update Relay APIs](https://github.com/facebook/jscodeshift)


---
### Apollo
> Data stack based on GraphQL

#### Apollo General Resources
* [Apollo Official Site](http://www.apollostack.com/)
* [Apollo GitHub](https://github.com/apollostack)
* [Apollo Blog](https://medium.com/apollo-stack)
* [Apollo Slack](https://apollostack.slack.com/)


---
### Flow
> Static Type Checker for JavaScript

#### Flow Resources
* [Flow Official Site](http://flowtype.org/)
* [Flow GitHub](https://github.com/facebook/flow)


---
### Videos

#### Video from Confs
* [Tom Occhino and Jordan Walke: JS Apps at Facebook - JSConfUS 2013](https://www.youtube.com/watch?v=GW0rj4sNH2w)
* [Pete Hunt: High performance functional programming with React and Meteor -- Devshop 11](https://www.youtube.com/watch?v=qqVbr_LaCIo)
* [Stoyan Stefanov: Introduction to React - LAWebSpeed meetup](https://www.youtube.com/watch?v=SMMRJif5QW0)
* [Pete Hunt: Be Predictable, Not Correct - Mountain West JavaScript 2014](https://www.youtube.com/watch?v=h3KksH8gfcQ)
* [Pete Hunt: The Secrets of React's Virtual DOM  - FutureJS 2014](https://www.youtube.com/watch?v=-DX3vJiqxm4)
* [Hacker Way: Rethinking Web App Development at Facebook](https://www.youtube.com/watch?v=nYkdrAPrdcw)
* [Christopher Chedeau: Why does React Scale? - JSConf2014](https://www.youtube.com/watch?v=D-ioDiacTm8)
* [Christopher Chedeau: React's Architecture - OSCON 2014](https://www.youtube.com/watch?v=eCf5CquV_Bw)
* [Christian Johansen: Functional UI Programming - flatMap 2014](https://vimeo.com/96639841)
* [Pete Hunt: React RESTful UI Rendering - Strange Loop 2014](https://www.youtube.com/watch?v=IVvHPPcl2TM)
* [Stefano Masini: Refactoring to React - Amsterdam Javascript MVC meetup 10 sep 2014](https://www.youtube.com/watch?v=MivXyEtwK24)
* [Pete Hunt: How Instagram.com Works - OSCON 2014](https://www.youtube.com/watch?v=VkTCL6Nqm6Y)
* [Bill Fisher and Jing Chen: React and Flux - NewCircle Training 2014](https://www.youtube.com/watch?v=i__969noyAM)
* [Vagmi Mudumbai: Building single page apps with React.JS - JSFoo 2014](https://www.youtube.com/watch?v=-v9MehRHsNE)
* [Ben Anderson: Reactive, Component-based UIs with React - E4E Developer Conf 2014](https://www.youtube.com/watch?v=uwnjDXtJufs)
* [Sebastian Markbage: Minimal API Surface Area - JSConf EU 2014](https://www.youtube.com/watch?v=4anAwXYqLG8)
* [Pete Hunt, Aaron Murray, and Contra Schof: Facebook React at the Famo.us Meetup 8/13/14](https://www.youtube.com/watch?v=1tWCnNgNZm4)
* [Steven Luscher: Decomplexifying Code with React - Powered by JavaScript conf 2014](https://www.youtube.com/watch?v=rI0GQc__0SM)
* [James Pearce: An Introduction to ReactJS - All Things Open 2014](https://www.youtube.com/watch?v=m2fuO2wl_3c)
* [Avik Chaudhuri: JavaScript Testing and Static Type Systems at Scale - Scale 2014](https://www.youtube.com/watch?v=M8x0bc81smU)
* [Jonathan Beebe: Real World React - Nodevember 2014](https://www.youtube.com/watch?v=uZgAq1CZ1N8)
* [Pete Hunt: Secrets of the Virtual DOM - JSConf.au 2014](https://www.youtube.com/watch?v=a21b-KDHG-Q)
* [Dave Smith: Angular + React = Speed - ng-conf 2015](https://www.youtube.com/watch?v=XQM0K6YG18s)
* [Ilya Boyandin: Interactive Data Visualization with React: Taming the Complexity of Changing State - OpenVis 2015](https://www.youtube.com/watch?v=dcLrbiHIX5M)
* [React Native & Relay: Bringing Modern Web Techniques to Mobile - f8 2015)](https://www.youtube.com/watch?v=X6YbAKiLCLU)
* [Flux: A Unidirectional Data Flow Architecture for React Apps - ACM Applicative 2015](https://www.youtube.com/watch?v=N3tF7jtbKZY)
* [Michael Chan: React.js on Rails](https://www.youtube.com/watch?v=kTSsZrub5iE)
* [What's new in React Native](https://www.youtube.com/watch?v=oWPoW0gIzvs)
* [Building and Deploying Relay with Facebook](https://www.youtube.com/watch?v=Pxdgu2XIAAg)
* [Supercharge your React.js Development with Taylor Hakes](https://www.youtube.com/watch?v=93KPAF_HafE)
* [Citrusbyte Presents GraphQL: A Horizontal Platform with Nick Schrock](https://www.youtube.com/watch?v=LQFQl8EsV3k)
* [Laney Kuenzel: Mutations and Subscriptions in Relay - JSConf 2015](https://www.youtube.com/watch?v=mmke4w4gc6c)
* [Pete Hunt: Immediate Mode UIs with React - SFJS Meetup 2015](https://www.youtube.com/watch?v=Y4q34vpFO2M)

#### [React.js Conf 2015 Playlist](https://www.youtube.com/playlist?list=PLb0IAmt7-GS1cbw4qonlQztYV1TAW0sCr)
#### [ReactEurope Conf 2015 Day 1 Playlist](https://www.youtube.com/playlist?list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD)
#### [ReactEurope Conf 2015 Day 2 Playlist](https://www.youtube.com/playlist?list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R)
#### [ReactRally Conf 2015 Playlist](https://www.youtube.com/playlist?list=PLUD4kD-wL_zZhHy-G8hPNZTvx_M35loXQ)
#### [React.js Conf 2016 Playlist](https://www.youtube.com/playlist?list=PLb0IAmt7-GS0M8Q95RIc2lOM6nc77q1IY)
#### [React Amsterdam 2016 Playlist](https://www.youtube.com/playlist?list=PLNBNS7NRGKMG3uLrm5fgY02hJ87Wzb4IU)
#### [ReactEurope Conf 2016 Day 1 Playlist](https://www.youtube.com/playlist?list=PLCC436JpVnK09bZeayg-KeLuHfHgc-tDa)
#### [ReactEurope Conf 2016 Day 2 Playlist](https://www.youtube.com/playlist?list=PLCC436JpVnK0LTDKW3O_BGTZnrZ8dBAof)
#### [ReactRally Conf 2016 Playlist](https://www.youtube.com/playlist?list=PLUD4kD-wL_zYSfU3tIYsb4WqfFQzO_EjQ)

#### Video Tutorials
* [learnreact.com — 3ish minute videos on React.js](http://learnreact.com/)
* [Learn ReactJS (make a Pokedex!) - part 1](https://www.youtube.com/watch?v=A9xmIxYBGf4)
* [Learn ReactJS (make a Pokedex!) - part 2](https://www.youtube.com/watch?v=lNqnZ58YGE0)
* [React.js Components  - part 1](http://www.youtube.com/watch?v=rFvZydtmsxM)
* [React.js Components  - part 2](http://www.youtube.com/watch?v=5yvFLrt7N8M)
* [Advanced Input Validation With React](https://www.youtube.com/watch?v=Mjcou3UCiBM)
* [ReactJS: Dealing with the Server](https://www.youtube.com/watch?v=lJUUjdsv0aw)
* [Building UIs with ReactJS](http://www.youtube.com/watch?v=lAn7GVoGlKU)
* [React.js Internals](https://www.youtube.com/watch?v=FAgSdSikSCc)
* [React in 7 Minutes](https://egghead.io/lessons/react-react-in-7-minutes)
* [jFlux - Going from MVC to FLUX](https://www.youtube.com/watch?v=plUN2L4Ak14)
* [Learn React in steps - BigBinary](http://bigbinary.com/videos/learn-reactjs-in-steps)
* [Keep up with React - BigBinary](http://bigbinary.com/videos/keep-up-with-reactjs)
* [React Native Intro](http://brentvatne.ca/react-native-intro-talk/)
* [Building a Simple ToDo App With React Native and Firebase](https://www.youtube.com/watch?v=3ab0K6viEp0)
* [React & Flux by: Christian Lilley](https://www.youtube.com/watch?v=mK4_a7u2cgI)
* [React for beginners](https://reactforbeginners.com/)
* [React For Everyone](https://www.youtube.com/playlist?list=PLLnpHn493BHFfs3Uj5tvx17mXk4B4ws4p)
* [React Native in Arabic - Create a real app series](https://www.youtube.com/playlist?list=PLk-CkzAysw4BLLNtATmnZOA8E8I6TP8MS)
* [Start Using React to Build Web Applications](https://egghead.io/courses/react-fundamentals)
* [Modern React with Redux](https://www.udemy.com/react-redux/)
* [Advanced React and Redux](https://www.udemy.com/react-redux-tutorial/)

---
### Books
* [SurviveJS - Webpack and React](http://survivejs.com/)
* [Fullstack React: The Complete Guide to ReactJS and Friends](https://www.fullstackreact.com/)
* [The Road to learn React](https://www.robinwieruch.de/the-road-to-learn-react/)
* [Isomorphic Development with JavaScript](https://www.manning.com/books/isomorphic-development-with-javascript)
* [React in Action](https://www.manning.com/books/react-in-action)
* [React Quickly](https://www.manning.com/books/react-quickly)
* [React: Up & Running: Building Web Applications](https://www.amazon.com/React-Running-Building-Web-Applications/dp/1491931825)
* [Developing a React.js Edge](https://bleedingedgepress.com/developing-a-react-edge-2nd-edition/)

---
### Demos
* [react.rocks - Pinterest-style directory of online demos with available code](http://react.rocks/)
* [react-hn - A React & react-router-powered implementation of Hacker News](https://github.com/insin/react-hn)
* [react-pokemon - A React component for displaying Pokémon](https://github.com/passy/react-pokemon)
* [React + Backbone TodoMVC](http://todomvc.com/examples/react-backbone/)
* [React + NestedTypes TodoMVC](https://github.com/gaperton/todomvc-nestedreact)
* [react-rxjs-todomvc - TodoMVC implementation with React and RxJS](https://github.com/fdecampredon/react-rxjs-todomvc)
* [react-mvc - A sample chat application written with React and pure MVC](https://github.com/ustun/react-mvc)
* [react-observe-todomvc - TodoMVC implementation built on top of React and Object.observe](https://github.com/fdecampredon/react-observe-todomvc)
* [react-lights-out - Simple demo of the React framework's power and flexibility](https://github.com/chenglou/react-lights-out)
* [todomvc-swarm - React TodoMVC implementation using Swarm for real-time collaboration](https://github.com/gritzko/todomvc-swarm)
* [reactodo - Multiple localStorage TODO lists, built with React](https://github.com/insin/reactodo)
* [lifequote - React port of a life insurance quick quoting application](https://github.com/insin/lifequote)
* [reactor-demo - Isomorphic Javascript app with React](https://github.com/natew/reactor-demo)
* [imgsible - React-based Imgur-like isomorphic demo app](https://github.com/BinaryMuse/imgsible)
* [wow-realm-status-react - WoW Realm Status: React Edition](https://github.com/BinaryMuse/wow-realm-status-react)
* [react-json-editor - A generic JSON editor](https://github.com/dustingetz/react-json-editor)
* [react-todos - Backbone's example TODO app with React JS for views](https://github.com/ssorallen/react-todos)
* [github-issues-viewer - A gitub issues viewer build in react + backbone](https://github.com/jaredly/github-issues-viewer)
* [wolfenstein3D-react - Wolfenstein with the rendering layer written in React](https://github.com/petehunt/wolfenstein3D-react)
* [Flux ImmutableJS TodoList](https://github.com/MandarinConLaBarba/flux-immutable-todomvc)
* [Hapi+React+Flux user management system](https://github.com/jedireza/aqua)
* [Redux TodoMVC](https://github.com/gaearon/redux/tree/master/examples/todomvc)
* [react-babel-webpack - CRUD demo app featuring React, React Router, Flux, Webpack, Bootstrap](https://github.com/arcseldon/react-babel-webpack-starter-app.git)
* [React/Redux CRUD with persistent state in Local Storage](https://github.com/cristianszwarc/react_crud_localStorage/)


---
### Example Apps
* [isomorphic500 - Isomorphic JS app built with React and Fluxible](https://github.com/gpbl/isomorphic500)
* [fil -  A playground for in-browser interpreters (Redux)](https://github.com/fatiherikli/fil)
* [sound-redux - A Soundcloud client built with React / Redux](https://github.com/andrewngu/sound-redux)
* [react-pomodoro - A Pomodoro timer for developers](https://github.com/afonsopacifer/react-pomodoro)
* [Do - Notes management application built with React and Redux](https://github.com/1ven/do)
* [soundcloud-react-redux - A SoundCloud Client built with React / Redux](https://github.com/rwieruch/favesound-redux)
* [soundcloud-react-mobx - A SoundCloud Client built with React / MobX](https://github.com/rwieruch/favesound-mobx)
* [A Reimplementation of Winamp 2.9 with React and Redux](https://github.com/captbaritone/winamp2-js)
* [ComingOrNot - Event Planner built with react, react-router, redux, graphQL & serverless](https://github.com/lakshmantgld/comingOrNot#reactjs-redux-serverless-graphql-event-planner)

---
### Real Apps
* [khan/perseus](https://github.com/khan/perseus)
* [mozilla/payments-ui](https://github.com/mozilla/payments-ui)
* [webbylab/itsquiz-wall](https://github.com/webbylab/itsquiz-wall)
* [brainfock/brainfock](https://github.com/brainfock/brainfock)
* [HVF/franchise](https://github.com/HVF/franchise)
* [KELiON/cerebro](https://github.com/KELiON/cerebro)
* [stride-nyc/remote_retro](https://github.com/stride-nyc/remote_retro)
* [Sqlectron - SQL client](https://sqlectron.github.io/)
* [ALM - A cloud ready IDE for React + TypeScript](https://alm-tools.github.io)

---
### Contribution
Your contributions and suggestions are heartily♡ welcome. (✿◠‿◠)


---
### License
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)
