// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an alias for the specified version of a bot. Use an alias to enable you
// to change the version of a bot without updating applications that use the bot.
//
// For example, you can create an alias called "PROD" that your applications use
// to call the Amazon Lex bot.
func (c *Client) CreateBotAlias(ctx context.Context, params *CreateBotAliasInput, optFns ...func(*Options)) (*CreateBotAliasOutput, error) {
	if params == nil {
		params = &CreateBotAliasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateBotAlias", params, optFns, c.addOperationCreateBotAliasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateBotAliasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateBotAliasInput struct {

	// The alias to create. The name must be unique for the bot.
	//
	// This member is required.
	BotAliasName *string

	// The unique identifier of the bot that the alias applies to.
	//
	// This member is required.
	BotId *string

	// Maps configuration information to a specific locale. You can use this parameter
	// to specify a specific Lambda function to run different functions in different
	// locales.
	BotAliasLocaleSettings map[string]types.BotAliasLocaleSettings

	// The version of the bot that this alias points to. You can use the [UpdateBotAlias] operation to
	// change the bot version associated with the alias.
	//
	// [UpdateBotAlias]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html
	BotVersion *string

	// Specifies whether Amazon Lex logs text and audio for a conversation with the
	// bot. When you enable conversation logs, text logs store text input, transcripts
	// of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs
	// store audio input in Amazon S3.
	ConversationLogSettings *types.ConversationLogSettings

	// A description of the alias. Use this description to help identify the alias.
	Description *string

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the
	// sentiment of user utterances.
	SentimentAnalysisSettings *types.SentimentAnalysisSettings

	// A list of tags to add to the bot alias. You can only add tags when you create
	// an alias, you can't use the UpdateBotAlias operation to update the tags on a
	// bot alias. To update tags, use the TagResource operation.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateBotAliasOutput struct {

	// The unique identifier of the bot alias.
	BotAliasId *string

	// Configuration information for a specific locale.
	BotAliasLocaleSettings map[string]types.BotAliasLocaleSettings

	// The name specified for the bot alias.
	BotAliasName *string

	// The current status of the alias. The alias is first put into the Creating
	// state. When the alias is ready to be used, it is put into the Available state.
	// You can use the DescribeBotAlias operation to get the current state of an alias.
	BotAliasStatus types.BotAliasStatus

	// The unique identifier of the bot that this alias applies to.
	BotId *string

	// The version of the bot associated with this alias.
	BotVersion *string

	// The conversation log settings specified for the alias.
	ConversationLogSettings *types.ConversationLogSettings

	// A Unix timestamp indicating the date and time that the bot alias was created.
	CreationDateTime *time.Time

	// The description specified for the bot alias.
	Description *string

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the
	// sentiment of user utterances.
	SentimentAnalysisSettings *types.SentimentAnalysisSettings

	// A list of tags associated with the bot alias.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateBotAliasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateBotAlias{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateBotAlias{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateBotAlias"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateBotAliasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateBotAlias(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateBotAlias(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateBotAlias",
	}
}
