// Code generated by smithy-go-codegen DO NOT EDIT.

package ivs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets summary information about all recording configurations in your account, in
// the Amazon Web Services region where the API request is processed.
func (c *Client) ListRecordingConfigurations(ctx context.Context, params *ListRecordingConfigurationsInput, optFns ...func(*Options)) (*ListRecordingConfigurationsOutput, error) {
	if params == nil {
		params = &ListRecordingConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRecordingConfigurations", params, optFns, c.addOperationListRecordingConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRecordingConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRecordingConfigurationsInput struct {

	// Maximum number of recording configurations to return. Default: your service
	// quota or 100, whichever is smaller.
	MaxResults *int32

	// The first recording configuration to retrieve. This is used for pagination; see
	// the nextToken response field.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRecordingConfigurationsOutput struct {

	// List of the matching recording configurations.
	//
	// This member is required.
	RecordingConfigurations []types.RecordingConfigurationSummary

	// If there are more recording configurations than maxResults , use nextToken in
	// the request to get the next set.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRecordingConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRecordingConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRecordingConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRecordingConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRecordingConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRecordingConfigurationsPaginatorOptions is the paginator options for
// ListRecordingConfigurations
type ListRecordingConfigurationsPaginatorOptions struct {
	// Maximum number of recording configurations to return. Default: your service
	// quota or 100, whichever is smaller.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRecordingConfigurationsPaginator is a paginator for
// ListRecordingConfigurations
type ListRecordingConfigurationsPaginator struct {
	options   ListRecordingConfigurationsPaginatorOptions
	client    ListRecordingConfigurationsAPIClient
	params    *ListRecordingConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListRecordingConfigurationsPaginator returns a new
// ListRecordingConfigurationsPaginator
func NewListRecordingConfigurationsPaginator(client ListRecordingConfigurationsAPIClient, params *ListRecordingConfigurationsInput, optFns ...func(*ListRecordingConfigurationsPaginatorOptions)) *ListRecordingConfigurationsPaginator {
	if params == nil {
		params = &ListRecordingConfigurationsInput{}
	}

	options := ListRecordingConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRecordingConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRecordingConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRecordingConfigurations page.
func (p *ListRecordingConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRecordingConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRecordingConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRecordingConfigurationsAPIClient is a client that implements the
// ListRecordingConfigurations operation.
type ListRecordingConfigurationsAPIClient interface {
	ListRecordingConfigurations(context.Context, *ListRecordingConfigurationsInput, ...func(*Options)) (*ListRecordingConfigurationsOutput, error)
}

var _ ListRecordingConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRecordingConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRecordingConfigurations",
	}
}
