// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Configures the accounts within the administrator's Organizations organization
// that the specified Firewall Manager administrator can apply policies to.
type AccountScope struct {

	// The list of accounts within the organization that the specified Firewall
	// Manager administrator either can or cannot apply policies to, based on the value
	// of ExcludeSpecifiedAccounts . If ExcludeSpecifiedAccounts is set to true , then
	// the Firewall Manager administrator can apply policies to all members of the
	// organization except for the accounts in this list. If ExcludeSpecifiedAccounts
	// is set to false , then the Firewall Manager administrator can only apply
	// policies to the accounts in this list.
	Accounts []string

	// A boolean value that indicates if the administrator can apply policies to all
	// accounts within an organization. If true, the administrator can apply policies
	// to all accounts within the organization. You can either enable management of all
	// accounts through this operation, or you can specify a list of accounts to manage
	// in AccountScope$Accounts . You cannot specify both.
	AllAccountsEnabled bool

	// A boolean value that excludes the accounts in AccountScope$Accounts from the
	// administrator's scope. If true, the Firewall Manager administrator can apply
	// policies to all members of the organization except for the accounts listed in
	// AccountScope$Accounts . You can either specify a list of accounts to exclude by
	// AccountScope$Accounts , or you can enable management of all accounts by
	// AccountScope$AllAccountsEnabled . You cannot specify both.
	ExcludeSpecifiedAccounts bool

	noSmithyDocumentSerde
}

// Describes a remediation action target.
type ActionTarget struct {

	// A description of the remediation action target.
	Description *string

	// The ID of the remediation target.
	ResourceId *string

	noSmithyDocumentSerde
}

// Contains high level information about the Firewall Manager administrator
// account.
type AdminAccountSummary struct {

	// The Amazon Web Services account ID of the Firewall Manager administrator's
	// account.
	AdminAccount *string

	// A boolean value that indicates if the administrator is the default
	// administrator. If true, then this is the default administrator account. The
	// default administrator can manage third-party firewalls and has full
	// administrative scope. There is only one default administrator account per
	// organization. For information about Firewall Manager default administrator
	// accounts, see [Managing Firewall Manager administrators]in the Firewall Manager Developer Guide.
	//
	// [Managing Firewall Manager administrators]: https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html
	DefaultAdmin bool

	// The current status of the request to onboard a member account as an Firewall
	// Manager administrator.
	//
	//   - ONBOARDING - The account is onboarding to Firewall Manager as an
	//   administrator.
	//
	//   - ONBOARDING_COMPLETE - Firewall Manager The account is onboarded to Firewall
	//   Manager as an administrator, and can perform actions on the resources defined in
	//   their AdminScope.
	//
	//   - OFFBOARDING - The account is being removed as an Firewall Manager
	//   administrator.
	//
	//   - OFFBOARDING_COMPLETE - The account has been removed as an Firewall Manager
	//   administrator.
	Status OrganizationStatus

	noSmithyDocumentSerde
}

// Defines the resources that the Firewall Manager administrator can manage. For
// more information about administrative scope, see [Managing Firewall Manager administrators]in the Firewall Manager
// Developer Guide.
//
// [Managing Firewall Manager administrators]: https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html
type AdminScope struct {

	// Defines the accounts that the specified Firewall Manager administrator can
	// apply policies to.
	AccountScope *AccountScope

	// Defines the Organizations organizational units that the specified Firewall
	// Manager administrator can apply policies to. For more information about OUs in
	// Organizations, see [Managing organizational units (OUs)]in the Organizations User Guide.
	//
	// [Managing organizational units (OUs)]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html
	OrganizationalUnitScope *OrganizationalUnitScope

	// Defines the Firewall Manager policy types that the specified Firewall Manager
	// administrator can create and manage.
	PolicyTypeScope *PolicyTypeScope

	// Defines the Amazon Web Services Regions that the specified Firewall Manager
	// administrator can perform actions in.
	RegionScope *RegionScope

	noSmithyDocumentSerde
}

// An individual Firewall Manager application.
type App struct {

	// The application's name.
	//
	// This member is required.
	AppName *string

	// The application's port number, for example 80 .
	//
	// This member is required.
	Port *int64

	// The IP protocol name or number. The name can be one of tcp , udp , or icmp . For
	// information on possible numbers, see [Protocol Numbers].
	//
	// [Protocol Numbers]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
	//
	// This member is required.
	Protocol *string

	noSmithyDocumentSerde
}

// An Firewall Manager applications list.
type AppsListData struct {

	// An array of applications in the Firewall Manager applications list.
	//
	// This member is required.
	AppsList []App

	// The name of the Firewall Manager applications list.
	//
	// This member is required.
	ListName *string

	// The time that the Firewall Manager applications list was created.
	CreateTime *time.Time

	// The time that the Firewall Manager applications list was last updated.
	LastUpdateTime *time.Time

	// The ID of the Firewall Manager applications list.
	ListId *string

	// A unique identifier for each update to the list. When you update the list, the
	// update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string

	// A map of previous version numbers to their corresponding App object arrays.
	PreviousAppsList map[string][]App

	noSmithyDocumentSerde
}

// Details of the Firewall Manager applications list.
type AppsListDataSummary struct {

	// An array of App objects in the Firewall Manager applications list.
	AppsList []App

	// The Amazon Resource Name (ARN) of the applications list.
	ListArn *string

	// The ID of the applications list.
	ListId *string

	// The name of the applications list.
	ListName *string

	noSmithyDocumentSerde
}

// Violation detail for an EC2 instance resource.
type AwsEc2InstanceViolation struct {

	// Violation detail for network interfaces associated with the EC2 instance.
	AwsEc2NetworkInterfaceViolations []AwsEc2NetworkInterfaceViolation

	// The resource ID of the EC2 instance.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Violation detail for network interfaces associated with an EC2 instance.
type AwsEc2NetworkInterfaceViolation struct {

	// List of security groups that violate the rules specified in the primary
	// security group of the Firewall Manager policy.
	ViolatingSecurityGroups []string

	// The resource ID of the network interface.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Violation detail for the rule violation in a security group when compared to
// the primary security group of the Firewall Manager policy.
type AwsVPCSecurityGroupViolation struct {

	// List of rules specified in the security group of the Firewall Manager policy
	// that partially match the ViolationTarget rule.
	PartialMatches []PartialMatch

	// Remediation options for the rule specified in the ViolationTarget .
	PossibleSecurityGroupRemediationActions []SecurityGroupRemediationAction

	// The security group rule that is being evaluated.
	ViolationTarget *string

	// A description of the security group that violates the policy.
	ViolationTargetDescription *string

	noSmithyDocumentSerde
}

// Details of the resource that is not protected by the policy.
type ComplianceViolator struct {

	// Metadata about the resource that doesn't comply with the policy scope.
	Metadata map[string]string

	// The resource ID.
	ResourceId *string

	// The resource type. This is in the format shown in the [Amazon Web Services Resource Types Reference]. For example:
	// AWS::ElasticLoadBalancingV2::LoadBalancer , AWS::CloudFront::Distribution , or
	// AWS::NetworkFirewall::FirewallPolicy .
	//
	// [Amazon Web Services Resource Types Reference]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html
	ResourceType *string

	// The reason that the resource is not protected by the policy.
	ViolationReason ViolationReason

	noSmithyDocumentSerde
}

// Information about the CreateNetworkAcl action in Amazon EC2. This is a
// remediation option in RemediationAction .
type CreateNetworkAclAction struct {

	// Brief description of this remediation action.
	Description *string

	// Indicates whether it is possible for Firewall Manager to perform this
	// remediation action. A false value indicates that auto remediation is disabled or
	// Firewall Manager is unable to perform the action due to a conflict of some kind.
	FMSCanRemediate bool

	// The VPC that's associated with the remediation action.
	Vpc *ActionTarget

	noSmithyDocumentSerde
}

// Information about the CreateNetworkAclEntries action in Amazon EC2. This is a
// remediation option in RemediationAction .
type CreateNetworkAclEntriesAction struct {

	// Brief description of this remediation action.
	Description *string

	// Indicates whether it is possible for Firewall Manager to perform this
	// remediation action. A false value indicates that auto remediation is disabled or
	// Firewall Manager is unable to perform the action due to a conflict of some kind.
	FMSCanRemediate bool

	// Lists the entries that the remediation action would create.
	NetworkAclEntriesToBeCreated []EntryDescription

	// The network ACL that's associated with the remediation action.
	NetworkAclId *ActionTarget

	noSmithyDocumentSerde
}

// Information about the DeleteNetworkAclEntries action in Amazon EC2. This is a
// remediation option in RemediationAction .
type DeleteNetworkAclEntriesAction struct {

	// Brief description of this remediation action.
	Description *string

	// Indicates whether it is possible for Firewall Manager to perform this
	// remediation action. A false value indicates that auto remediation is disabled or
	// Firewall Manager is unable to perform the action due to a conflict of some kind.
	FMSCanRemediate bool

	// Lists the entries that the remediation action would delete.
	NetworkAclEntriesToBeDeleted []EntryDescription

	// The network ACL that's associated with the remediation action.
	NetworkAclId *ActionTarget

	noSmithyDocumentSerde
}

// A resource in the organization that's available to be associated with a
// Firewall Manager resource set.
type DiscoveredResource struct {

	// The Amazon Web Services account ID associated with the discovered resource.
	AccountId *string

	// The name of the discovered resource.
	Name *string

	// The type of the discovered resource.
	Type *string

	// The universal resource identifier (URI) of the discovered resource.
	URI *string

	noSmithyDocumentSerde
}

// A DNS Firewall rule group that Firewall Manager tried to associate with a VPC
// is already associated with the VPC and can't be associated again.
type DnsDuplicateRuleGroupViolation struct {

	// Information about the VPC ID.
	ViolationTarget *string

	// A description of the violation that specifies the rule group and VPC.
	ViolationTargetDescription *string

	noSmithyDocumentSerde
}

// The VPC that Firewall Manager was applying a DNS Fireall policy to reached the
// limit for associated DNS Firewall rule groups. Firewall Manager tried to
// associate another rule group with the VPC and failed due to the limit.
type DnsRuleGroupLimitExceededViolation struct {

	// The number of rule groups currently associated with the VPC.
	NumberOfRuleGroupsAlreadyAssociated int32

	// Information about the VPC ID.
	ViolationTarget *string

	// A description of the violation that specifies the rule group and VPC.
	ViolationTargetDescription *string

	noSmithyDocumentSerde
}

// A rule group that Firewall Manager tried to associate with a VPC has the same
// priority as a rule group that's already associated.
type DnsRuleGroupPriorityConflictViolation struct {

	// The ID of the Firewall Manager DNS Firewall policy that was already applied to
	// the VPC. This policy contains the rule group that's already associated with the
	// VPC.
	ConflictingPolicyId *string

	// The priority setting of the two conflicting rule groups.
	ConflictingPriority int32

	// The priorities of rule groups that are already associated with the VPC. To
	// retry your operation, choose priority settings that aren't in this list for the
	// rule groups in your new DNS Firewall policy.
	UnavailablePriorities []int32

	// Information about the VPC ID.
	ViolationTarget *string

	// A description of the violation that specifies the VPC and the rule group that's
	// already associated with it.
	ViolationTargetDescription *string

	noSmithyDocumentSerde
}

// The action of associating an EC2 resource, such as a subnet or internet
// gateway, with a route table.
type EC2AssociateRouteTableAction struct {

	// The ID of the EC2 route table that is associated with the remediation action.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// A description of the EC2 route table that is associated with the remediation
	// action.
	Description *string

	// The ID of the gateway to be used with the EC2 route table that is associated
	// with the remediation action.
	GatewayId *ActionTarget

	// The ID of the subnet for the EC2 route table that is associated with the
	// remediation action.
	SubnetId *ActionTarget

	noSmithyDocumentSerde
}

// An action that copies the EC2 route table for use in remediation.
type EC2CopyRouteTableAction struct {

	// The ID of the copied EC2 route table that is associated with the remediation
	// action.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// The VPC ID of the copied EC2 route table that is associated with the
	// remediation action.
	//
	// This member is required.
	VpcId *ActionTarget

	// A description of the copied EC2 route table that is associated with the
	// remediation action.
	Description *string

	noSmithyDocumentSerde
}

// Information about the CreateRoute action in Amazon EC2.
type EC2CreateRouteAction struct {

	// Information about the ID of the route table for the route.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// A description of CreateRoute action in Amazon EC2.
	Description *string

	// Information about the IPv4 CIDR address block used for the destination match.
	DestinationCidrBlock *string

	// Information about the IPv6 CIDR block destination.
	DestinationIpv6CidrBlock *string

	// Information about the ID of a prefix list used for the destination match.
	DestinationPrefixListId *string

	// Information about the ID of an internet gateway or virtual private gateway
	// attached to your VPC.
	GatewayId *ActionTarget

	// Information about the ID of a VPC endpoint. Supported for Gateway Load Balancer
	// endpoints only.
	VpcEndpointId *ActionTarget

	noSmithyDocumentSerde
}

// Information about the CreateRouteTable action in Amazon EC2.
type EC2CreateRouteTableAction struct {

	// Information about the ID of a VPC.
	//
	// This member is required.
	VpcId *ActionTarget

	// A description of the CreateRouteTable action.
	Description *string

	noSmithyDocumentSerde
}

// Information about the DeleteRoute action in Amazon EC2.
type EC2DeleteRouteAction struct {

	// Information about the ID of the route table.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// A description of the DeleteRoute action.
	Description *string

	// Information about the IPv4 CIDR range for the route. The value you specify must
	// match the CIDR for the route exactly.
	DestinationCidrBlock *string

	// Information about the IPv6 CIDR range for the route. The value you specify must
	// match the CIDR for the route exactly.
	DestinationIpv6CidrBlock *string

	// Information about the ID of the prefix list for the route.
	DestinationPrefixListId *string

	noSmithyDocumentSerde
}

// Information about the ReplaceRoute action in Amazon EC2.
type EC2ReplaceRouteAction struct {

	// Information about the ID of the route table.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// A description of the ReplaceRoute action in Amazon EC2.
	Description *string

	// Information about the IPv4 CIDR address block used for the destination match.
	// The value that you provide must match the CIDR of an existing route in the
	// table.
	DestinationCidrBlock *string

	// Information about the IPv6 CIDR address block used for the destination match.
	// The value that you provide must match the CIDR of an existing route in the
	// table.
	DestinationIpv6CidrBlock *string

	// Information about the ID of the prefix list for the route.
	DestinationPrefixListId *string

	// Information about the ID of an internet gateway or virtual private gateway.
	GatewayId *ActionTarget

	noSmithyDocumentSerde
}

// Information about the ReplaceRouteTableAssociation action in Amazon EC2.
type EC2ReplaceRouteTableAssociationAction struct {

	// Information about the association ID.
	//
	// This member is required.
	AssociationId *ActionTarget

	// Information about the ID of the new route table to associate with the subnet.
	//
	// This member is required.
	RouteTableId *ActionTarget

	// A description of the ReplaceRouteTableAssociation action in Amazon EC2.
	Description *string

	noSmithyDocumentSerde
}

// Describes a single rule in a network ACL.
type EntryDescription struct {

	// Describes a rule in a network ACL.
	//
	// Each network ACL has a set of numbered ingress rules and a separate set of
	// numbered egress rules. When determining whether a packet should be allowed in or
	// out of a subnet associated with the network ACL, Amazon Web Services processes
	// the entries in the network ACL according to the rule numbers, in ascending
	// order.
	//
	// When you manage an individual network ACL, you explicitly specify the rule
	// numbers. When you specify the network ACL rules in a Firewall Manager policy,
	// you provide the rules to run first, in the order that you want them to run, and
	// the rules to run last, in the order that you want them to run. Firewall Manager
	// assigns the rule numbers for you when you save the network ACL policy
	// specification.
	EntryDetail *NetworkAclEntry

	// The rule number for the entry. ACL entries are processed in ascending order by
	// rule number. In a Firewall Manager network ACL policy, Firewall Manager assigns
	// rule numbers.
	EntryRuleNumber int32

	// Specifies whether the entry is managed by Firewall Manager or by a user, and,
	// for Firewall Manager-managed entries, specifies whether the entry is among those
	// that run first in the network ACL or those that run last.
	EntryType EntryType

	noSmithyDocumentSerde
}

// Detailed information about an entry violation in a network ACL. The violation
// is against the network ACL specification inside the Firewall Manager network ACL
// policy. This data object is part of InvalidNetworkAclEntriesViolation .
type EntryViolation struct {

	// The evaluation location within the ordered list of entries where the
	// ExpectedEntry is currently located.
	ActualEvaluationOrder *string

	// The list of entries that are in conflict with ExpectedEntry .
	EntriesWithConflicts []EntryDescription

	// The entry that's currently in the ExpectedEvaluationOrder location, in place of
	// the expected entry.
	EntryAtExpectedEvaluationOrder *EntryDescription

	// Descriptions of the violations that Firewall Manager found for these entries.
	EntryViolationReasons []EntryViolationReason

	// The Firewall Manager-managed network ACL entry that is involved in the entry
	// violation.
	ExpectedEntry *EntryDescription

	// The evaluation location within the ordered list of entries where the
	// ExpectedEntry should be, according to the network ACL policy specifications.
	ExpectedEvaluationOrder *string

	noSmithyDocumentSerde
}

// Describes the compliance status for the account. An account is considered
// noncompliant if it includes resources that are not protected by the specified
// policy or that don't comply with the policy.
type EvaluationResult struct {

	// Describes an Amazon Web Services account's compliance with the Firewall Manager
	// policy.
	ComplianceStatus PolicyComplianceStatusType

	// Indicates that over 100 resources are noncompliant with the Firewall Manager
	// policy.
	EvaluationLimitExceeded bool

	// The number of resources that are noncompliant with the specified policy. For
	// WAF and Shield Advanced policies, a resource is considered noncompliant if it is
	// not associated with the policy. For security group policies, a resource is
	// considered noncompliant if it doesn't comply with the rules of the policy and
	// remediation is disabled or not possible.
	ViolatorCount int64

	noSmithyDocumentSerde
}

// Information about the expected route in the route table.
type ExpectedRoute struct {

	// Information about the allowed targets.
	AllowedTargets []string

	// Information about the contributing subnets.
	ContributingSubnets []string

	// Information about the IPv4 CIDR block.
	IpV4Cidr *string

	// Information about the IPv6 CIDR block.
	IpV6Cidr *string

	// Information about the ID of the prefix list for the route.
	PrefixListId *string

	// Information about the route table ID.
	RouteTableId *string

	noSmithyDocumentSerde
}

// Details of a resource that failed when trying to update it's association to a
// resource set.
type FailedItem struct {

	// The reason the resource's association could not be updated.
	Reason FailedItemReason

	// The univeral resource indicator (URI) of the resource that failed.
	URI *string

	noSmithyDocumentSerde
}

// Contains details about the firewall subnet that violates the policy scope.
type FirewallSubnetIsOutOfScopeViolation struct {

	// The ID of the firewall subnet that violates the policy scope.
	FirewallSubnetId *string

	// The Availability Zone of the firewall subnet that violates the policy scope.
	SubnetAvailabilityZone *string

	// The Availability Zone ID of the firewall subnet that violates the policy scope.
	SubnetAvailabilityZoneId *string

	// The VPC endpoint ID of the firewall subnet that violates the policy scope.
	VpcEndpointId *string

	// The VPC ID of the firewall subnet that violates the policy scope.
	VpcId *string

	noSmithyDocumentSerde
}

// The violation details for a firewall subnet's VPC endpoint that's deleted or
// missing.
type FirewallSubnetMissingVPCEndpointViolation struct {

	// The ID of the firewall that this VPC endpoint is associated with.
	FirewallSubnetId *string

	// The name of the Availability Zone of the deleted VPC subnet.
	SubnetAvailabilityZone *string

	// The ID of the Availability Zone of the deleted VPC subnet.
	SubnetAvailabilityZoneId *string

	// The resource ID of the VPC associated with the deleted VPC subnet.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the actions that you can take to remediate scope
// violations caused by your policy's FirewallCreationConfig .
// FirewallCreationConfig is an optional configuration that you can use to choose
// which Availability Zones Firewall Manager creates Network Firewall endpoints in.
type FMSPolicyUpdateFirewallCreationConfigAction struct {

	// Describes the remedial action.
	Description *string

	// A FirewallCreationConfig that you can copy into your current policy's [SecurityServiceData] in order
	// to remedy scope violations.
	//
	// [SecurityServiceData]: https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html
	FirewallCreationConfig *string

	noSmithyDocumentSerde
}

// Violation detail for the entries in a network ACL resource.
type InvalidNetworkAclEntriesViolation struct {

	// The network ACL containing the entry violations.
	CurrentAssociatedNetworkAcl *string

	// Detailed information about the entry violations in the network ACL.
	EntryViolations []EntryViolation

	// The subnet that's associated with the network ACL.
	Subnet *string

	// The Availability Zone where the network ACL is in use.
	SubnetAvailabilityZone *string

	// The VPC where the violation was found.
	Vpc *string

	noSmithyDocumentSerde
}

// Defines a Firewall Manager network ACL policy. This is used in the PolicyOption
// of a SecurityServicePolicyData for a Policy , when the SecurityServicePolicyData
// type is set to NETWORK_ACL_COMMON .
//
// For information about network ACLs, see [Control traffic to subnets using network ACLs] in the Amazon Virtual Private Cloud
// User Guide.
//
// [Control traffic to subnets using network ACLs]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
type NetworkAclCommonPolicy struct {

	// The definition of the first and last rules for the network ACL policy.
	//
	// This member is required.
	NetworkAclEntrySet *NetworkAclEntrySet

	noSmithyDocumentSerde
}

// Describes a rule in a network ACL.
//
// Each network ACL has a set of numbered ingress rules and a separate set of
// numbered egress rules. When determining whether a packet should be allowed in or
// out of a subnet associated with the network ACL, Amazon Web Services processes
// the entries in the network ACL according to the rule numbers, in ascending
// order.
//
// When you manage an individual network ACL, you explicitly specify the rule
// numbers. When you specify the network ACL rules in a Firewall Manager policy,
// you provide the rules to run first, in the order that you want them to run, and
// the rules to run last, in the order that you want them to run. Firewall Manager
// assigns the rule numbers for you when you save the network ACL policy
// specification.
type NetworkAclEntry struct {

	// Indicates whether the rule is an egress, or outbound, rule (applied to traffic
	// leaving the subnet). If it's not an egress rule, then it's an ingress, or
	// inbound, rule.
	//
	// This member is required.
	Egress *bool

	// The protocol number. A value of "-1" means all protocols.
	//
	// This member is required.
	Protocol *string

	// Indicates whether to allow or deny the traffic that matches the rule.
	//
	// This member is required.
	RuleAction NetworkAclRuleAction

	// The IPv4 network range to allow or deny, in CIDR notation.
	CidrBlock *string

	// ICMP protocol: The ICMP type and code.
	IcmpTypeCode *NetworkAclIcmpTypeCode

	// The IPv6 network range to allow or deny, in CIDR notation.
	Ipv6CidrBlock *string

	// TCP or UDP protocols: The range of ports the rule applies to.
	PortRange *NetworkAclPortRange

	noSmithyDocumentSerde
}

// The configuration of the first and last rules for the network ACL policy, and
// the remediation settings for each.
type NetworkAclEntrySet struct {

	// Applies only when remediation is enabled for the policy as a whole. Firewall
	// Manager uses this setting when it finds policy violations that involve conflicts
	// between the custom entries and the policy entries.
	//
	// If forced remediation is disabled, Firewall Manager marks the network ACL as
	// noncompliant and does not try to remediate. For more information about the
	// remediation behavior, see [Remediation for managed network ACLs]in the Firewall Manager Developer Guide.
	//
	// [Remediation for managed network ACLs]: https://docs.aws.amazon.com/waf/latest/developerguide/network-acl-policies.html#network-acls-remediation
	//
	// This member is required.
	ForceRemediateForFirstEntries *bool

	// Applies only when remediation is enabled for the policy as a whole. Firewall
	// Manager uses this setting when it finds policy violations that involve conflicts
	// between the custom entries and the policy entries.
	//
	// If forced remediation is disabled, Firewall Manager marks the network ACL as
	// noncompliant and does not try to remediate. For more information about the
	// remediation behavior, see [Remediation for managed network ACLs]in the Firewall Manager Developer Guide.
	//
	// [Remediation for managed network ACLs]: https://docs.aws.amazon.com/waf/latest/developerguide/network-acl-policies.html#network-acls-remediation
	//
	// This member is required.
	ForceRemediateForLastEntries *bool

	// The rules that you want to run first in the Firewall Manager managed network
	// ACLs.
	//
	// Provide these in the order in which you want them to run. Firewall Manager will
	// assign the specific rule numbers for you, in the network ACLs that it creates.
	//
	// You must specify at least one first entry or one last entry in any network ACL
	// policy.
	FirstEntries []NetworkAclEntry

	// The rules that you want to run last in the Firewall Manager managed network
	// ACLs.
	//
	// Provide these in the order in which you want them to run. Firewall Manager will
	// assign the specific rule numbers for you, in the network ACLs that it creates.
	//
	// You must specify at least one first entry or one last entry in any network ACL
	// policy.
	LastEntries []NetworkAclEntry

	noSmithyDocumentSerde
}

// ICMP protocol: The ICMP type and code.
type NetworkAclIcmpTypeCode struct {

	// ICMP code.
	Code *int32

	// ICMP type.
	Type *int32

	noSmithyDocumentSerde
}

// TCP or UDP protocols: The range of ports the rule applies to.
type NetworkAclPortRange struct {

	// The beginning port number of the range.
	From *int32

	// The ending port number of the range.
	To *int32

	noSmithyDocumentSerde
}

// Violation detail for an internet gateway route with an inactive state in the
// customer subnet route table or Network Firewall subnet route table.
type NetworkFirewallBlackHoleRouteDetectedViolation struct {

	// Information about the route table ID.
	RouteTableId *string

	// Information about the route or routes that are in violation.
	ViolatingRoutes []Route

	// The subnet that has an inactive state.
	ViolationTarget *string

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Violation detail for the subnet for which internet traffic that hasn't been
// inspected.
type NetworkFirewallInternetTrafficNotInspectedViolation struct {

	// The actual firewall subnet routes.
	ActualFirewallSubnetRoutes []Route

	// The actual internet gateway routes.
	ActualInternetGatewayRoutes []Route

	// Information about the subnet route table for the current firewall.
	CurrentFirewallSubnetRouteTable *string

	// The current route table for the internet gateway.
	CurrentInternetGatewayRouteTable *string

	// The expected endpoint for the current firewall.
	ExpectedFirewallEndpoint *string

	// The firewall subnet routes that are expected.
	ExpectedFirewallSubnetRoutes []ExpectedRoute

	// The internet gateway routes that are expected.
	ExpectedInternetGatewayRoutes []ExpectedRoute

	// The firewall subnet ID.
	FirewallSubnetId *string

	// The internet gateway ID.
	InternetGatewayId *string

	// Information about whether the route table is used in another Availability Zone.
	IsRouteTableUsedInDifferentAZ bool

	// Information about the route table ID.
	RouteTableId *string

	// The subnet Availability Zone.
	SubnetAvailabilityZone *string

	// The subnet ID.
	SubnetId *string

	// The route or routes that are in violation.
	ViolatingRoutes []Route

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Violation detail for the improperly configured subnet route. It's possible
// there is a missing route table route, or a configuration that causes traffic to
// cross an Availability Zone boundary.
type NetworkFirewallInvalidRouteConfigurationViolation struct {

	// The actual firewall endpoint.
	ActualFirewallEndpoint *string

	// The actual subnet ID for the firewall.
	ActualFirewallSubnetId *string

	// The actual firewall subnet routes that are expected.
	ActualFirewallSubnetRoutes []Route

	// The actual internet gateway routes.
	ActualInternetGatewayRoutes []Route

	// The subnets that are affected.
	AffectedSubnets []string

	// The subnet route table for the current firewall.
	CurrentFirewallSubnetRouteTable *string

	// The route table for the current internet gateway.
	CurrentInternetGatewayRouteTable *string

	// The firewall endpoint that's expected.
	ExpectedFirewallEndpoint *string

	// The expected subnet ID for the firewall.
	ExpectedFirewallSubnetId *string

	// The firewall subnet routes that are expected.
	ExpectedFirewallSubnetRoutes []ExpectedRoute

	// The expected routes for the internet gateway.
	ExpectedInternetGatewayRoutes []ExpectedRoute

	// The internet gateway ID.
	InternetGatewayId *string

	// Information about whether the route table is used in another Availability Zone.
	IsRouteTableUsedInDifferentAZ bool

	// The route table ID.
	RouteTableId *string

	// The route that's in violation.
	ViolatingRoute *Route

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Violation detail for an expected route missing in Network Firewall.
type NetworkFirewallMissingExpectedRoutesViolation struct {

	// The expected routes.
	ExpectedRoutes []ExpectedRoute

	// The target of the violation.
	ViolationTarget *string

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Violation detail for Network Firewall for a subnet that's not associated to the
// expected Firewall Manager managed route table.
type NetworkFirewallMissingExpectedRTViolation struct {

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string

	// The resource ID of the current route table that's associated with the subnet,
	// if one is available.
	CurrentRouteTable *string

	// The resource ID of the route table that should be associated with the subnet.
	ExpectedRouteTable *string

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Violation detail for Network Firewall for a subnet that doesn't have a Firewall
// Manager managed firewall in its VPC.
type NetworkFirewallMissingFirewallViolation struct {

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string

	// The reason the resource has this violation, if one is available.
	TargetViolationReason *string

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Violation detail for Network Firewall for an Availability Zone that's missing
// the expected Firewall Manager managed subnet.
type NetworkFirewallMissingSubnetViolation struct {

	// The Availability Zone of a violating subnet.
	AvailabilityZone *string

	// The reason the resource has this violation, if one is available.
	TargetViolationReason *string

	// The resource ID of the VPC associated with a violating subnet.
	VPC *string

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Configures the firewall policy deployment model of Network Firewall. For
// information about Network Firewall deployment models, see [Network Firewall example architectures with routing]in the Network
// Firewall Developer Guide.
//
// [Network Firewall example architectures with routing]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/architectures.html
type NetworkFirewallPolicy struct {

	// Defines the deployment model to use for the firewall policy. To use a
	// distributed model, set [PolicyOption]to NULL .
	//
	// [PolicyOption]: https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html
	FirewallDeploymentModel FirewallDeploymentModel

	noSmithyDocumentSerde
}

// The definition of the Network Firewall firewall policy.
type NetworkFirewallPolicyDescription struct {

	// The default actions to take on a packet that doesn't match any stateful rules.
	// The stateful default action is optional, and is only valid when using the strict
	// rule order.
	//
	// Valid values of the stateful default action:
	//
	//   - aws:drop_strict
	//
	//   - aws:drop_established
	//
	//   - aws:alert_strict
	//
	//   - aws:alert_established
	StatefulDefaultActions []string

	// Additional options governing how Network Firewall handles stateful rules. The
	// stateful rule groups that you use in your policy must have stateful rule options
	// settings that are compatible with these settings.
	StatefulEngineOptions *StatefulEngineOptions

	// The stateful rule groups that are used in the Network Firewall firewall policy.
	StatefulRuleGroups []StatefulRuleGroup

	// Names of custom actions that are available for use in the stateless default
	// actions settings.
	StatelessCustomActions []string

	// The actions to take on packets that don't match any of the stateless rule
	// groups.
	StatelessDefaultActions []string

	// The actions to take on packet fragments that don't match any of the stateless
	// rule groups.
	StatelessFragmentDefaultActions []string

	// The stateless rule groups that are used in the Network Firewall firewall
	// policy.
	StatelessRuleGroups []StatelessRuleGroup

	noSmithyDocumentSerde
}

// Violation detail for Network Firewall for a firewall policy that has a
// different NetworkFirewallPolicyDescriptionthan is required by the Firewall Manager policy.
type NetworkFirewallPolicyModifiedViolation struct {

	// The policy that's currently in use in the individual account.
	CurrentPolicyDescription *NetworkFirewallPolicyDescription

	// The policy that should be in use in the individual account in order to be
	// compliant.
	ExpectedPolicyDescription *NetworkFirewallPolicyDescription

	// The ID of the Network Firewall or VPC resource that's in violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// The setting that allows the policy owner to change the behavior of the rule
// group within a policy.
type NetworkFirewallStatefulRuleGroupOverride struct {

	// The action that changes the rule group from DROP to ALERT . This only applies to
	// managed rule groups.
	Action NetworkFirewallOverrideAction

	noSmithyDocumentSerde
}

// Violation detail for an unexpected route that's present in a route table.
type NetworkFirewallUnexpectedFirewallRoutesViolation struct {

	// The endpoint of the firewall.
	FirewallEndpoint *string

	// The subnet ID for the firewall.
	FirewallSubnetId *string

	// The ID of the route table.
	RouteTableId *string

	// The routes that are in violation.
	ViolatingRoutes []Route

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Violation detail for an unexpected gateway route that’s present in a route
// table.
type NetworkFirewallUnexpectedGatewayRoutesViolation struct {

	// Information about the gateway ID.
	GatewayId *string

	// Information about the route table.
	RouteTableId *string

	// The routes that are in violation.
	ViolatingRoutes []Route

	// Information about the VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// Defines the Organizations organizational units (OUs) that the specified
// Firewall Manager administrator can apply policies to. For more information about
// OUs in Organizations, see [Managing organizational units (OUs)]in the Organizations User Guide.
//
// [Managing organizational units (OUs)]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html
type OrganizationalUnitScope struct {

	// A boolean value that indicates if the administrator can apply policies to all
	// OUs within an organization. If true, the administrator can manage all OUs within
	// the organization. You can either enable management of all OUs through this
	// operation, or you can specify OUs to manage in
	// OrganizationalUnitScope$OrganizationalUnits . You cannot specify both.
	AllOrganizationalUnitsEnabled bool

	// A boolean value that excludes the OUs in
	// OrganizationalUnitScope$OrganizationalUnits from the administrator's scope. If
	// true, the Firewall Manager administrator can apply policies to all OUs in the
	// organization except for the OUs listed in
	// OrganizationalUnitScope$OrganizationalUnits . You can either specify a list of
	// OUs to exclude by OrganizationalUnitScope$OrganizationalUnits , or you can
	// enable management of all OUs by
	// OrganizationalUnitScope$AllOrganizationalUnitsEnabled . You cannot specify both.
	ExcludeSpecifiedOrganizationalUnits bool

	// The list of OUs within the organization that the specified Firewall Manager
	// administrator either can or cannot apply policies to, based on the value of
	// OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits . If
	// OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits is set to true ,
	// then the Firewall Manager administrator can apply policies to all OUs in the
	// organization except for the OUs in this list. If
	// OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits is set to false ,
	// then the Firewall Manager administrator can only apply policies to the OUs in
	// this list.
	OrganizationalUnits []string

	noSmithyDocumentSerde
}

// The reference rule that partially matches the ViolationTarget rule and
// violation reason.
type PartialMatch struct {

	// The reference rule from the primary security group of the Firewall Manager
	// policy.
	Reference *string

	// The violation reason.
	TargetViolationReasons []string

	noSmithyDocumentSerde
}

// An Firewall Manager policy.
type Policy struct {

	// If set to True , resources with the tags that are specified in the ResourceTag
	// array are not in scope of the policy. If set to False , and the ResourceTag
	// array is not null, only resources with the specified tags are in scope of the
	// policy.
	//
	// This member is required.
	ExcludeResourceTags bool

	// The name of the Firewall Manager policy.
	//
	// This member is required.
	PolicyName *string

	// Indicates if the policy should be automatically applied to new resources.
	//
	// This member is required.
	RemediationEnabled bool

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the [Amazon Web Services Resource Types Reference]. To apply this policy to multiple resource types, specify
	// a resource type of ResourceTypeList and then specify the resource types in a
	// ResourceTypeList .
	//
	// The following are valid resource types for each Firewall Manager policy type:
	//
	//   - Amazon Web Services WAF Classic - AWS::ApiGateway::Stage ,
	//   AWS::CloudFront::Distribution , and AWS::ElasticLoadBalancingV2::LoadBalancer .
	//
	//   - WAF - AWS::ApiGateway::Stage , AWS::ElasticLoadBalancingV2::LoadBalancer ,
	//   and AWS::CloudFront::Distribution .
	//
	//   - Shield Advanced - AWS::ElasticLoadBalancingV2::LoadBalancer ,
	//   AWS::ElasticLoadBalancing::LoadBalancer , AWS::EC2::EIP , and
	//   AWS::CloudFront::Distribution .
	//
	//   - Network ACL - AWS::EC2::Subnet .
	//
	//   - Security group usage audit - AWS::EC2::SecurityGroup .
	//
	//   - Security group content audit - AWS::EC2::SecurityGroup ,
	//   AWS::EC2::NetworkInterface , and AWS::EC2::Instance .
	//
	//   - DNS Firewall, Network Firewall, and third-party firewall - AWS::EC2::VPC .
	//
	// [Amazon Web Services Resource Types Reference]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html
	//
	// This member is required.
	ResourceType *string

	// Details about the security service that is being used to protect the resources.
	//
	// This member is required.
	SecurityServicePolicyData *SecurityServicePolicyData

	// Indicates whether Firewall Manager should automatically remove protections from
	// resources that leave the policy scope and clean up resources that Firewall
	// Manager is managing for accounts when those accounts leave policy scope. For
	// example, Firewall Manager will disassociate a Firewall Manager managed web ACL
	// from a protected customer resource when the customer resource leaves policy
	// scope.
	//
	// By default, Firewall Manager doesn't remove protections or delete Firewall
	// Manager managed resources.
	//
	// This option is not available for Shield Advanced or WAF Classic policies.
	DeleteUnusedFMManagedResources bool

	// Specifies the Amazon Web Services account IDs and Organizations organizational
	// units (OUs) to exclude from the policy. Specifying an OU is the equivalent of
	// specifying all accounts in the OU and in any of its child OUs, including any
	// child OUs and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap , Firewall Manager applies the policy to all accounts specified by
	// the IncludeMap , and does not evaluate any ExcludeMap specifications. If you do
	// not specify an IncludeMap , then Firewall Manager applies the policy to all
	// accounts except for those specified by the ExcludeMap .
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//   - Specify account IDs by setting the key to ACCOUNT . For example, the
	//   following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]} .
	//
	//   - Specify OUs by setting the key to ORG_UNIT . For example, the following is a
	//   valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]} .
	//
	//   - Specify accounts and OUs together in a single map, separated with a comma.
	//   For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//   “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]} .
	ExcludeMap map[string][]string

	// Specifies the Amazon Web Services account IDs and Organizations organizational
	// units (OUs) to include in the policy. Specifying an OU is the equivalent of
	// specifying all accounts in the OU and in any of its child OUs, including any
	// child OUs and accounts that are added at a later time.
	//
	// You can specify inclusions or exclusions, but not both. If you specify an
	// IncludeMap , Firewall Manager applies the policy to all accounts specified by
	// the IncludeMap , and does not evaluate any ExcludeMap specifications. If you do
	// not specify an IncludeMap , then Firewall Manager applies the policy to all
	// accounts except for those specified by the ExcludeMap .
	//
	// You can specify account IDs, OUs, or a combination:
	//
	//   - Specify account IDs by setting the key to ACCOUNT . For example, the
	//   following is a valid map: {“ACCOUNT” : [“accountID1”, “accountID2”]} .
	//
	//   - Specify OUs by setting the key to ORG_UNIT . For example, the following is a
	//   valid map: {“ORG_UNIT” : [“ouid111”, “ouid112”]} .
	//
	//   - Specify accounts and OUs together in a single map, separated with a comma.
	//   For example, the following is a valid map: {“ACCOUNT” : [“accountID1”,
	//   “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]} .
	IncludeMap map[string][]string

	// Your description of the Firewall Manager policy.
	PolicyDescription *string

	// The ID of the Firewall Manager policy.
	PolicyId *string

	// Indicates whether the policy is in or out of an admin's policy or Region scope.
	//
	//   - ACTIVE - The administrator can manage and delete the policy.
	//
	//   - OUT_OF_ADMIN_SCOPE - The administrator can view the policy, but they can't
	//   edit or delete the policy. Existing policy protections stay in place. Any new
	//   resources that come into scope of the policy won't be protected.
	PolicyStatus CustomerPolicyStatus

	// A unique identifier for each update to the policy. When issuing a PutPolicy
	// request, the PolicyUpdateToken in the request must match the PolicyUpdateToken
	// of the current policy version. To get the PolicyUpdateToken of the current
	// policy version, use a GetPolicy request.
	PolicyUpdateToken *string

	// The unique identifiers of the resource sets used by the policy.
	ResourceSetIds []string

	// An array of ResourceTag objects.
	ResourceTags []ResourceTag

	// An array of ResourceType objects. Use this only to specify multiple resource
	// types. To specify a single resource type, use ResourceType .
	ResourceTypeList []string

	noSmithyDocumentSerde
}

// Describes the noncompliant resources in a member account for a specific
// Firewall Manager policy. A maximum of 100 entries are displayed. If more than
// 100 resources are noncompliant, EvaluationLimitExceeded is set to True .
type PolicyComplianceDetail struct {

	// Indicates if over 100 resources are noncompliant with the Firewall Manager
	// policy.
	EvaluationLimitExceeded bool

	// A timestamp that indicates when the returned information should be considered
	// out of date.
	ExpiredAt *time.Time

	// Details about problems with dependent services, such as WAF or Config, and the
	// error message received that indicates the problem with the service.
	IssueInfoMap map[string]string

	// The Amazon Web Services account ID.
	MemberAccount *string

	// The ID of the Firewall Manager policy.
	PolicyId *string

	// The Amazon Web Services account that created the Firewall Manager policy.
	PolicyOwner *string

	// An array of resources that aren't protected by the WAF or Shield Advanced
	// policy or that aren't in compliance with the security group policy.
	Violators []ComplianceViolator

	noSmithyDocumentSerde
}

// Indicates whether the account is compliant with the specified policy. An
// account is considered noncompliant if it includes resources that are not
// protected by the policy, for WAF and Shield Advanced policies, or that are
// noncompliant with the policy, for security group policies.
type PolicyComplianceStatus struct {

	// An array of EvaluationResult objects.
	EvaluationResults []EvaluationResult

	// Details about problems with dependent services, such as WAF or Config, and the
	// error message received that indicates the problem with the service.
	IssueInfoMap map[string]string

	// Timestamp of the last update to the EvaluationResult objects.
	LastUpdated *time.Time

	// The member account ID.
	MemberAccount *string

	// The ID of the Firewall Manager policy.
	PolicyId *string

	// The name of the Firewall Manager policy.
	PolicyName *string

	// The Amazon Web Services account that created the Firewall Manager policy.
	PolicyOwner *string

	noSmithyDocumentSerde
}

// Contains the settings to configure a network ACL policy, a Network Firewall
// firewall policy deployment model, or a third-party firewall policy.
type PolicyOption struct {

	// Defines a Firewall Manager network ACL policy.
	NetworkAclCommonPolicy *NetworkAclCommonPolicy

	// Defines the deployment model to use for the firewall policy.
	NetworkFirewallPolicy *NetworkFirewallPolicy

	// Defines the policy options for a third-party firewall policy.
	ThirdPartyFirewallPolicy *ThirdPartyFirewallPolicy

	noSmithyDocumentSerde
}

// Details of the Firewall Manager policy.
type PolicySummary struct {

	// Indicates whether Firewall Manager should automatically remove protections from
	// resources that leave the policy scope and clean up resources that Firewall
	// Manager is managing for accounts when those accounts leave policy scope. For
	// example, Firewall Manager will disassociate a Firewall Manager managed web ACL
	// from a protected customer resource when the customer resource leaves policy
	// scope.
	//
	// By default, Firewall Manager doesn't remove protections or delete Firewall
	// Manager managed resources.
	//
	// This option is not available for Shield Advanced or WAF Classic policies.
	DeleteUnusedFMManagedResources bool

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string

	// The ID of the specified policy.
	PolicyId *string

	// The name of the specified policy.
	PolicyName *string

	// Indicates whether the policy is in or out of an admin's policy or Region scope.
	//
	//   - ACTIVE - The administrator can manage and delete the policy.
	//
	//   - OUT_OF_ADMIN_SCOPE - The administrator can view the policy, but they can't
	//   edit or delete the policy. Existing policy protections stay in place. Any new
	//   resources that come into scope of the policy won't be protected.
	PolicyStatus CustomerPolicyStatus

	// Indicates if the policy should be automatically applied to new resources.
	RemediationEnabled bool

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the [Amazon Web Services Resource Types Reference].
	//
	// [Amazon Web Services Resource Types Reference]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html
	ResourceType *string

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an WAF policy, a Shield Advanced
	// policy, or a security group policy.
	SecurityServiceType SecurityServiceType

	noSmithyDocumentSerde
}

// Defines the policy types that the specified Firewall Manager administrator can
// manage.
type PolicyTypeScope struct {

	// Allows the specified Firewall Manager administrator to manage all Firewall
	// Manager policy types, except for third-party policy types. Third-party policy
	// types can only be managed by the Firewall Manager default administrator.
	AllPolicyTypesEnabled bool

	// The list of policy types that the specified Firewall Manager administrator can
	// manage.
	PolicyTypes []SecurityServiceType

	noSmithyDocumentSerde
}

// A list of remediation actions.
type PossibleRemediationAction struct {

	// The ordered list of remediation actions.
	//
	// This member is required.
	OrderedRemediationActions []RemediationActionWithOrder

	// A description of the list of remediation actions.
	Description *string

	// Information about whether an action is taken by default.
	IsDefaultAction bool

	noSmithyDocumentSerde
}

// A list of possible remediation action lists. Each individual possible
// remediation action is a list of individual remediation actions.
type PossibleRemediationActions struct {

	// Information about the actions.
	Actions []PossibleRemediationAction

	// A description of the possible remediation actions list.
	Description *string

	noSmithyDocumentSerde
}

// An Firewall Manager protocols list.
type ProtocolsListData struct {

	// The name of the Firewall Manager protocols list.
	//
	// This member is required.
	ListName *string

	// An array of protocols in the Firewall Manager protocols list.
	//
	// This member is required.
	ProtocolsList []string

	// The time that the Firewall Manager protocols list was created.
	CreateTime *time.Time

	// The time that the Firewall Manager protocols list was last updated.
	LastUpdateTime *time.Time

	// The ID of the Firewall Manager protocols list.
	ListId *string

	// A unique identifier for each update to the list. When you update the list, the
	// update token must match the token of the current version of the application
	// list. You can retrieve the update token by getting the list.
	ListUpdateToken *string

	// A map of previous version numbers to their corresponding protocol arrays.
	PreviousProtocolsList map[string][]string

	noSmithyDocumentSerde
}

// Details of the Firewall Manager protocols list.
type ProtocolsListDataSummary struct {

	// The Amazon Resource Name (ARN) of the specified protocols list.
	ListArn *string

	// The ID of the specified protocols list.
	ListId *string

	// The name of the specified protocols list.
	ListName *string

	// An array of protocols in the Firewall Manager protocols list.
	ProtocolsList []string

	noSmithyDocumentSerde
}

// Defines the Amazon Web Services Regions that the specified Firewall Manager
// administrator can manage.
type RegionScope struct {

	// Allows the specified Firewall Manager administrator to manage all Amazon Web
	// Services Regions.
	AllRegionsEnabled bool

	// The Amazon Web Services Regions that the specified Firewall Manager
	// administrator can perform actions in.
	Regions []string

	noSmithyDocumentSerde
}

// Information about an individual action you can take to remediate a violation.
type RemediationAction struct {

	// Information about the CreateNetworkAcl action in Amazon EC2.
	CreateNetworkAclAction *CreateNetworkAclAction

	// Information about the CreateNetworkAclEntries action in Amazon EC2.
	CreateNetworkAclEntriesAction *CreateNetworkAclEntriesAction

	// Information about the DeleteNetworkAclEntries action in Amazon EC2.
	DeleteNetworkAclEntriesAction *DeleteNetworkAclEntriesAction

	// A description of a remediation action.
	Description *string

	// Information about the AssociateRouteTable action in the Amazon EC2 API.
	EC2AssociateRouteTableAction *EC2AssociateRouteTableAction

	// Information about the CopyRouteTable action in the Amazon EC2 API.
	EC2CopyRouteTableAction *EC2CopyRouteTableAction

	// Information about the CreateRoute action in the Amazon EC2 API.
	EC2CreateRouteAction *EC2CreateRouteAction

	// Information about the CreateRouteTable action in the Amazon EC2 API.
	EC2CreateRouteTableAction *EC2CreateRouteTableAction

	// Information about the DeleteRoute action in the Amazon EC2 API.
	EC2DeleteRouteAction *EC2DeleteRouteAction

	// Information about the ReplaceRoute action in the Amazon EC2 API.
	EC2ReplaceRouteAction *EC2ReplaceRouteAction

	// Information about the ReplaceRouteTableAssociation action in the Amazon EC2 API.
	EC2ReplaceRouteTableAssociationAction *EC2ReplaceRouteTableAssociationAction

	// The remedial action to take when updating a firewall configuration.
	FMSPolicyUpdateFirewallCreationConfigAction *FMSPolicyUpdateFirewallCreationConfigAction

	// Information about the ReplaceNetworkAclAssociation action in Amazon EC2.
	ReplaceNetworkAclAssociationAction *ReplaceNetworkAclAssociationAction

	noSmithyDocumentSerde
}

// An ordered list of actions you can take to remediate a violation.
type RemediationActionWithOrder struct {

	// The order of the remediation actions in the list.
	Order int32

	// Information about an action you can take to remediate a violation.
	RemediationAction *RemediationAction

	noSmithyDocumentSerde
}

// Information about the ReplaceNetworkAclAssociation action in Amazon EC2. This
// is a remediation option in RemediationAction .
type ReplaceNetworkAclAssociationAction struct {

	// Describes a remediation action target.
	AssociationId *ActionTarget

	// Brief description of this remediation action.
	Description *string

	// Indicates whether it is possible for Firewall Manager to perform this
	// remediation action. A false value indicates that auto remediation is disabled or
	// Firewall Manager is unable to perform the action due to a conflict of some kind.
	FMSCanRemediate bool

	// The network ACL that's associated with the remediation action.
	NetworkAclId *ActionTarget

	noSmithyDocumentSerde
}

// Details of a resource that is associated to an Firewall Manager resource set.
type Resource struct {

	// The resource's universal resource indicator (URI).
	//
	// This member is required.
	URI *string

	// The Amazon Web Services account ID that the associated resource belongs to.
	AccountId *string

	noSmithyDocumentSerde
}

// A set of resources to include in a policy.
type ResourceSet struct {

	// The descriptive name of the resource set. You can't change the name of a
	// resource set after you create it.
	//
	// This member is required.
	Name *string

	// Determines the resources that can be associated to the resource set. Depending
	// on your setting for max results and the number of resource sets, a single call
	// might not return the full list.
	//
	// This member is required.
	ResourceTypeList []string

	// A description of the resource set.
	Description *string

	// A unique identifier for the resource set. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string

	// The last time that the resource set was changed.
	LastUpdateTime *time.Time

	// Indicates whether the resource set is in or out of an admin's Region scope.
	//
	//   - ACTIVE - The administrator can manage and delete the resource set.
	//
	//   - OUT_OF_ADMIN_SCOPE - The administrator can view the resource set, but they
	//   can't edit or delete the resource set. Existing protections stay in place. Any
	//   new resource that come into scope of the resource set won't be protected.
	ResourceSetStatus ResourceSetStatus

	// An optional token that you can use for optimistic locking. Firewall Manager
	// returns a token to your requests that access the resource set. The token marks
	// the state of the resource set resource at the time of the request. Update tokens
	// are not allowed when creating a resource set. After creation, each subsequent
	// update call to the resource set requires the update token.
	//
	// To make an unconditional change to the resource set, omit the token in your
	// update request. Without the token, Firewall Manager performs your updates
	// regardless of whether the resource set has changed since you last retrieved it.
	//
	// To make a conditional change to the resource set, provide the token in your
	// update request. Firewall Manager uses the token to ensure that the resource set
	// hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException . If this happens, retrieve the resource set
	// again to get a current copy of it with a new token. Reapply your changes as
	// needed, then try the operation again using the new token.
	UpdateToken *string

	noSmithyDocumentSerde
}

// Summarizes the resource sets used in a policy.
type ResourceSetSummary struct {

	// A description of the resource set.
	Description *string

	// A unique identifier for the resource set. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string

	// The last time that the resource set was changed.
	LastUpdateTime *time.Time

	// The descriptive name of the resource set. You can't change the name of a
	// resource set after you create it.
	Name *string

	// Indicates whether the resource set is in or out of an admin's Region scope.
	//
	//   - ACTIVE - The administrator can manage and delete the resource set.
	//
	//   - OUT_OF_ADMIN_SCOPE - The administrator can view the resource set, but they
	//   can't edit or delete the resource set. Existing protections stay in place. Any
	//   new resource that come into scope of the resource set won't be protected.
	ResourceSetStatus ResourceSetStatus

	noSmithyDocumentSerde
}

// The resource tags that Firewall Manager uses to determine if a particular
// resource should be included or excluded from the Firewall Manager policy. Tags
// enable you to categorize your Amazon Web Services resources in different ways,
// for example, by purpose, owner, or environment. Each tag consists of a key and
// an optional value. Firewall Manager combines the tags with "AND" so that, if you
// add more than one tag to a policy scope, a resource must have all the specified
// tags to be included or excluded. For more information, see [Working with Tag Editor].
//
// Every resource tag must have a string value, either a non-empty string or an
// empty string. If you don't provide a value for a resource tag, Firewall Manager
// saves the value as an empty string: "". When Firewall Manager compares tags, it
// only matches two tags if they have the same key and the same value. A tag with
// an empty string value only matches with tags that also have an empty string
// value.
//
// [Working with Tag Editor]: https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html
type ResourceTag struct {

	// The resource tag key.
	//
	// This member is required.
	Key *string

	// The resource tag value. To specify an empty string value, either don't provide
	// this or specify it as "".
	Value *string

	noSmithyDocumentSerde
}

// Violation detail based on resource type.
type ResourceViolation struct {

	// Violation detail for an EC2 instance.
	AwsEc2InstanceViolation *AwsEc2InstanceViolation

	// Violation detail for a network interface.
	AwsEc2NetworkInterfaceViolation *AwsEc2NetworkInterfaceViolation

	// Violation detail for security groups.
	AwsVPCSecurityGroupViolation *AwsVPCSecurityGroupViolation

	// Violation detail for a DNS Firewall policy that indicates that a rule group
	// that Firewall Manager tried to associate with a VPC is already associated with
	// the VPC and can't be associated again.
	DnsDuplicateRuleGroupViolation *DnsDuplicateRuleGroupViolation

	// Violation detail for a DNS Firewall policy that indicates that the VPC reached
	// the limit for associated DNS Firewall rule groups. Firewall Manager tried to
	// associate another rule group with the VPC and failed.
	DnsRuleGroupLimitExceededViolation *DnsRuleGroupLimitExceededViolation

	// Violation detail for a DNS Firewall policy that indicates that a rule group
	// that Firewall Manager tried to associate with a VPC has the same priority as a
	// rule group that's already associated.
	DnsRuleGroupPriorityConflictViolation *DnsRuleGroupPriorityConflictViolation

	// Contains details about the firewall subnet that violates the policy scope.
	FirewallSubnetIsOutOfScopeViolation *FirewallSubnetIsOutOfScopeViolation

	// The violation details for a third-party firewall's VPC endpoint subnet that was
	// deleted.
	FirewallSubnetMissingVPCEndpointViolation *FirewallSubnetMissingVPCEndpointViolation

	// Violation detail for the entries in a network ACL resource.
	InvalidNetworkAclEntriesViolation *InvalidNetworkAclEntriesViolation

	// Violation detail for an internet gateway route with an inactive state in the
	// customer subnet route table or Network Firewall subnet route table.
	NetworkFirewallBlackHoleRouteDetectedViolation *NetworkFirewallBlackHoleRouteDetectedViolation

	// Violation detail for the subnet for which internet traffic hasn't been
	// inspected.
	NetworkFirewallInternetTrafficNotInspectedViolation *NetworkFirewallInternetTrafficNotInspectedViolation

	// The route configuration is invalid.
	NetworkFirewallInvalidRouteConfigurationViolation *NetworkFirewallInvalidRouteConfigurationViolation

	// Violation detail for an Network Firewall policy that indicates that a subnet is
	// not associated with the expected Firewall Manager managed route table.
	NetworkFirewallMissingExpectedRTViolation *NetworkFirewallMissingExpectedRTViolation

	// Expected routes are missing from Network Firewall.
	NetworkFirewallMissingExpectedRoutesViolation *NetworkFirewallMissingExpectedRoutesViolation

	// Violation detail for an Network Firewall policy that indicates that a subnet
	// has no Firewall Manager managed firewall in its VPC.
	NetworkFirewallMissingFirewallViolation *NetworkFirewallMissingFirewallViolation

	// Violation detail for an Network Firewall policy that indicates that an
	// Availability Zone is missing the expected Firewall Manager managed subnet.
	NetworkFirewallMissingSubnetViolation *NetworkFirewallMissingSubnetViolation

	// Violation detail for an Network Firewall policy that indicates that a firewall
	// policy in an individual account has been modified in a way that makes it
	// noncompliant. For example, the individual account owner might have deleted a
	// rule group, changed the priority of a stateless rule group, or changed a policy
	// default action.
	NetworkFirewallPolicyModifiedViolation *NetworkFirewallPolicyModifiedViolation

	// There's an unexpected firewall route.
	NetworkFirewallUnexpectedFirewallRoutesViolation *NetworkFirewallUnexpectedFirewallRoutesViolation

	// There's an unexpected gateway route.
	NetworkFirewallUnexpectedGatewayRoutesViolation *NetworkFirewallUnexpectedGatewayRoutesViolation

	// A list of possible remediation action lists. Each individual possible
	// remediation action is a list of individual remediation actions.
	PossibleRemediationActions *PossibleRemediationActions

	// Contains details about the route endpoint that violates the policy scope.
	RouteHasOutOfScopeEndpointViolation *RouteHasOutOfScopeEndpointViolation

	// The violation details for a third-party firewall that has the Firewall Manager
	// managed route table that was associated with the third-party firewall has been
	// deleted.
	ThirdPartyFirewallMissingExpectedRouteTableViolation *ThirdPartyFirewallMissingExpectedRouteTableViolation

	// The violation details for a third-party firewall that's been deleted.
	ThirdPartyFirewallMissingFirewallViolation *ThirdPartyFirewallMissingFirewallViolation

	// The violation details for a third-party firewall's subnet that's been deleted.
	ThirdPartyFirewallMissingSubnetViolation *ThirdPartyFirewallMissingSubnetViolation

	noSmithyDocumentSerde
}

// Describes a route in a route table.
type Route struct {

	// The destination of the route.
	Destination *string

	// The type of destination for the route.
	DestinationType DestinationType

	// The route's target.
	Target *string

	// The type of target for the route.
	TargetType TargetType

	noSmithyDocumentSerde
}

// Contains details about the route endpoint that violates the policy scope.
type RouteHasOutOfScopeEndpointViolation struct {

	// The route table associated with the current firewall subnet.
	CurrentFirewallSubnetRouteTable *string

	// The current route table associated with the Internet Gateway.
	CurrentInternetGatewayRouteTable *string

	// The ID of the firewall subnet.
	FirewallSubnetId *string

	// The list of firewall subnet routes.
	FirewallSubnetRoutes []Route

	// The ID of the Internet Gateway.
	InternetGatewayId *string

	// The routes in the route table associated with the Internet Gateway.
	InternetGatewayRoutes []Route

	// The ID of the route table.
	RouteTableId *string

	// The subnet's Availability Zone.
	SubnetAvailabilityZone *string

	// The ID of the subnet's Availability Zone.
	SubnetAvailabilityZoneId *string

	// The ID of the subnet associated with the route that violates the policy scope.
	SubnetId *string

	// The list of routes that violate the route table.
	ViolatingRoutes []Route

	// The VPC ID of the route that violates the policy scope.
	VpcId *string

	noSmithyDocumentSerde
}

// Remediation option for the rule specified in the ViolationTarget .
type SecurityGroupRemediationAction struct {

	// Brief description of the action that will be performed.
	Description *string

	// Indicates if the current action is the default action.
	IsDefaultAction bool

	// The remediation action that will be performed.
	RemediationActionType RemediationActionType

	// The final state of the rule specified in the ViolationTarget after it is
	// remediated.
	RemediationResult *SecurityGroupRuleDescription

	noSmithyDocumentSerde
}

// Describes a set of permissions for a security group rule.
type SecurityGroupRuleDescription struct {

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number. A value of -1 indicates all ICMP/ICMPv6 types.
	FromPort *int64

	// The IPv4 ranges for the security group rule.
	IPV4Range *string

	// The IPv6 ranges for the security group rule.
	IPV6Range *string

	// The ID of the prefix list for the security group rule.
	PrefixListId *string

	// The IP protocol name ( tcp , udp , icmp , icmpv6 ) or number.
	Protocol *string

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code. A value of -1 indicates all ICMP/ICMPv6 codes.
	ToPort *int64

	noSmithyDocumentSerde
}

// Details about the security service that is being used to protect the resources.
type SecurityServicePolicyData struct {

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an WAF policy, a Shield Advanced
	// policy, or a security group policy. For security group policies, Firewall
	// Manager supports one security group for each common policy and for each content
	// audit policy. This is an adjustable limit that you can increase by contacting
	// Amazon Web Services Support.
	//
	// This member is required.
	Type SecurityServiceType

	// Details about the service that are specific to the service type, in JSON
	// format.
	//
	//   - Example: DNS_FIREWALL
	//
	//   "{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"
	//
	// Valid values for preProcessRuleGroups are between 1 and 99. Valid values for
	//   postProcessRuleGroups are between 9901 and 10000.
	//
	//   - Example: IMPORT_NETWORK_FIREWALL
	//
	//   "{\"type\":\"IMPORT_NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-2:000000000000:stateless-rulegroup\/rg1\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:pass\"],\"networkFirewallStatelessCustomActions\":[],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-west-2:aws-managed:stateful-rulegroup\/ThreatSignaturesEmergingEventsStrictOrder\",\"priority\":8}],\"networkFirewallStatefulEngineOptions\":{\"ruleOrder\":\"STRICT_ORDER\"},\"networkFirewallStatefulDefaultActions\":[\"aws:drop_strict\"]}}"
	//
	//   "{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"
	//
	// Valid values for preProcessRuleGroups are between 1 and 99. Valid values for
	//   postProcessRuleGroups are between 9901 and 10000.
	//
	//   - Example: NETWORK_FIREWALL - Centralized deployment model
	//
	//   "{\"type\":\"NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}},\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"
	//
	// To use the centralized deployment model, you must set [PolicyOption]to CENTRALIZED .
	//
	//   - Example: NETWORK_FIREWALL - Distributed deployment model with automatic
	//   Availability Zone configuration
	//
	//   "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"OFF\"},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"
	//
	// With automatic Availbility Zone configuration, Firewall Manager chooses which
	//   Availability Zones to create the endpoints in. To use the distributed deployment
	//   model, you must set [PolicyOption]to NULL .
	//
	//   - Example: NETWORK_FIREWALL - Distributed deployment model with automatic
	//   Availability Zone configuration and route management
	//
	//   "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"]},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":
	//   \"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"
	//
	// To use the distributed deployment model, you must set [PolicyOption]to NULL .
	//
	//   - Example: NETWORK_FIREWALL - Distributed deployment model with custom
	//   Availability Zone configuration
	//
	//   "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",
	//   \"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{
	//   \"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[
	//   \"10.0.0.0/28\"]}]}
	//   },\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"OFF\",\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"
	//
	// With custom Availability Zone configuration, you define which specific
	//   Availability Zones to create endpoints in by configuring
	//   firewallCreationConfig . To configure the Availability Zones in
	//   firewallCreationConfig , specify either the availabilityZoneName or
	//   availabilityZoneId parameter, not both parameters.
	//
	// To use the distributed deployment model, you must set [PolicyOption]to NULL .
	//
	//   - Example: NETWORK_FIREWALL - Distributed deployment model with custom
	//   Availability Zone configuration and route management
	//
	//   "{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"],\"routeManagementConfig\":{\"allowCrossAZTrafficIfNoEndpoint\":true}},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"
	//
	// To use the distributed deployment model, you must set [PolicyOption]to NULL .
	//
	//   - Example: SECURITY_GROUPS_COMMON
	//
	//   "{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,
	//   \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\"
	//   sg-000e55995d61a06bd\"}]}"
	//
	//   - Example: SECURITY_GROUPS_COMMON - Security group tag distribution
	//
	//   ""{\"type\":\"SECURITY_GROUPS_COMMON\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"revertManualSecurityGroupChanges\":true,\"exclusiveResourceSecurityGroupManagement\":false,\"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":false,\"enableTagDistribution\":true}""
	//
	// Firewall Manager automatically distributes tags from the primary group to the
	//   security groups created by this policy. To use security group tag distribution,
	//   you must also set revertManualSecurityGroupChanges to true , otherwise
	//   Firewall Manager won't be able to create the policy. When you enable
	//   revertManualSecurityGroupChanges , Firewall Manager identifies and reports
	//   when the security groups created by this policy become non-compliant.
	//
	// Firewall Manager won't distribute system tags added by Amazon Web Services
	//   services into the replica security groups. System tags begin with the aws:
	//   prefix.
	//
	//   - Example: Shared VPCs. Apply the preceding policy to resources in shared
	//   VPCs as well as to those in VPCs that the account owns
	//
	//   "{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,
	//   \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\"
	//   sg-000e55995d61a06bd\"}]}"
	//
	//   - Example: SECURITY_GROUPS_CONTENT_AUDIT
	//
	//   "{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"
	//
	// The security group action for content audit can be ALLOW or DENY . For ALLOW ,
	//   all in-scope security group rules must be within the allowed range of the
	//   policy's security group rules. For DENY , all in-scope security group rules
	//   must not contain a value or a range that matches a rule value or range in the
	//   policy security group.
	//
	//   - Example: SECURITY_GROUPS_USAGE_AUDIT
	//
	//   "{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"
	//
	//   - Example: SHIELD_ADVANCED with web ACL management
	//
	// "{\"type\":\"SHIELD_ADVANCED\",\"optimizeUnassociatedWebACL\":true}"
	//
	// If you set optimizeUnassociatedWebACL to true , Firewall Manager creates web
	//   ACLs in accounts within the policy scope if the web ACLs will be used by at
	//   least one resource. Firewall Manager creates web ACLs in the accounts within
	//   policy scope only if the web ACLs will be used by at least one resource. If at
	//   any time an account comes into policy scope, Firewall Manager automatically
	//   creates a web ACL in the account if at least one resource will use the web ACL.
	//
	// Upon enablement, Firewall Manager performs a one-time cleanup of unused web
	//   ACLs in your account. The cleanup process can take several hours. If a resource
	//   leaves policy scope after Firewall Manager creates a web ACL, Firewall Manager
	//   doesn't disassociate the resource from the web ACL. If you want Firewall Manager
	//   to clean up the web ACL, you must first manually disassociate the resources from
	//   the web ACL, and then enable the manage unused web ACLs option in your policy.
	//
	// If you set optimizeUnassociatedWebACL to false , and Firewall Manager
	//   automatically creates an empty web ACL in each account that's within policy
	//   scope.
	//
	//   - Specification for SHIELD_ADVANCED for Amazon CloudFront distributions
	//
	// "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\":
	//   {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\",
	//   \"automaticResponseAction\":\"BLOCK|COUNT\"},
	//   \"overrideCustomerWebaclClassic\":true|false,
	//   \"optimizeUnassociatedWebACL\":true|false}"
	//
	// For example: "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\":
	//   {\"automaticResponseStatus\":\"ENABLED\",
	//   \"automaticResponseAction\":\"COUNT\"}}"
	//
	// The default value for automaticResponseStatus is IGNORED . The value for
	//   automaticResponseAction is only required when automaticResponseStatus is set
	//   to ENABLED . The default value for overrideCustomerWebaclClassic is false .
	//
	// For other resource types that you can protect with a Shield Advanced policy,
	//   this ManagedServiceData configuration is an empty string.
	//
	//   - Example: THIRD_PARTY_FIREWALL
	//
	// Replace THIRD_PARTY_FIREWALL_NAME with the name of the third-party firewall.
	//
	// "{ "type":"THIRD_PARTY_FIREWALL",
	//   "thirdPartyFirewall":"THIRD_PARTY_FIREWALL_NAME", "thirdPartyFirewallConfig":{
	//   "thirdPartyFirewallPolicyList":["global-1"] }, "firewallDeploymentModel":{
	//   "distributedFirewallDeploymentModel":{
	//   "distributedFirewallOrchestrationConfig":{ "firewallCreationConfig":{
	//   "endpointLocation":{ "availabilityZoneConfigList":[ {
	//   "availabilityZoneName":"${AvailabilityZone}" } ] } }, "allowedIPV4CidrList":[ ]
	//   } } } }"
	//
	//   - Example: WAFV2 - Account takeover prevention, Bot Control managed rule
	//   groups, optimize unassociated web ACL, and rule action override
	//
	//   "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesATPRuleSet\",\"managedRuleGroupConfigs\":[{\"awsmanagedRulesATPRuleSet\":{\"loginPath\":\"/loginpath\",\"requestInspection\":{\"payloadType\":\"FORM_ENCODED|JSON\",\"usernameField\":{\"identifier\":\"/form/username\"},\"passwordField\":{\"identifier\":\"/form/password\"}}}}]},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true},{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesBotControlRuleSet\",\"managedRuleGroupConfigs\":[{\"awsmanagedRulesBotControlRuleSet\":{\"inspectionLevel\":\"TARGETED|COMMON\"}}]},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true,\"ruleActionOverrides\":[{\"name\":\"Rule1\",\"actionToUse\":{\"allow|block|count|captcha|challenge\":{}}},{\"name\":\"Rule2\",\"actionToUse\":{\"allow|block|count|captcha|challenge\":{}}}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\":null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":null,\"sampledRequestsEnabledForDefaultActions\":true,\"optimizeUnassociatedWebACL\":true}"
	//
	//   - Bot Control - For information about AWSManagedRulesBotControlRuleSet managed
	//   rule groups, see [AWSManagedRulesBotControlRuleSet]in the WAF API Reference.
	//
	//   - Fraud Control account takeover prevention (ATP) - For information about the
	//   properties available for AWSManagedRulesATPRuleSet managed rule groups, see [AWSManagedRulesATPRuleSet]
	//   in the WAF API Reference.
	//
	//   - Optimize unassociated web ACL - If you set optimizeUnassociatedWebACL to
	//   true , Firewall Manager creates web ACLs in accounts within the policy scope
	//   if the web ACLs will be used by at least one resource. Firewall Manager creates
	//   web ACLs in the accounts within policy scope only if the web ACLs will be used
	//   by at least one resource. If at any time an account comes into policy scope,
	//   Firewall Manager automatically creates a web ACL in the account if at least one
	//   resource will use the web ACL.
	//
	// Upon enablement, Firewall Manager performs a one-time cleanup of unused web
	//   ACLs in your account. The cleanup process can take several hours. If a resource
	//   leaves policy scope after Firewall Manager creates a web ACL, Firewall Manager
	//   disassociates the resource from the web ACL, but won't clean up the unused web
	//   ACL. Firewall Manager only cleans up unused web ACLs when you first enable
	//   management of unused web ACLs in a policy.
	//
	// If you set optimizeUnassociatedWebACL to false Firewall Manager doesn't manage
	//   unused web ACLs, and Firewall Manager automatically creates an empty web ACL in
	//   each account that's within policy scope.
	//
	//   - Rule action overrides - Firewall Manager supports rule action overrides
	//   only for managed rule groups. To configure a RuleActionOverrides add the Name
	//   of the rule to override, and ActionToUse , which is the new action to use for
	//   the rule. For information about using rule action override, see [RuleActionOverride]in the WAF
	//   API Reference.
	//
	//   - Example: WAFV2 - CAPTCHA and Challenge configs
	//
	//   "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAdminProtectionRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],\"sampledRequestsEnabled\":true}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\":null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":null,\"sampledRequestsEnabledForDefaultActions\":true,\"captchaConfig\":{\"immunityTimeProperty\":{\"immunityTime\":500}},\"challengeConfig\":{\"immunityTimeProperty\":{\"immunityTime\":800}},\"tokenDomains\":[\"google.com\",\"amazon.com\"],\"associationConfig\":{\"requestBody\":{\"CLOUDFRONT\":{\"defaultSizeInspectionLimit\":\"KB_16\"}}}}"
	//
	//   - CAPTCHA and Challenge configs - If you update the policy's values for
	//   associationConfig , captchaConfig , challengeConfig , or tokenDomains ,
	//   Firewall Manager will overwrite your local web ACLs to contain the new value(s).
	//   However, if you don't update the policy's associationConfig , captchaConfig ,
	//   challengeConfig , or tokenDomains values, the values in your local web ACLs
	//   will remain unchanged. For information about association configs, see [AssociationConfig]. For
	//   information about CAPTCHA and Challenge configs, see [CaptchaConfig]and [ChallengeConfig]in the WAF API
	//   Reference.
	//
	//   - defaultSizeInspectionLimit - Specifies the maximum size of the web request
	//   body component that an associated Amazon CloudFront distribution should send to
	//   WAF for inspection. For more information, see [DefaultSizeInspectionLimit]in the WAF API Reference.
	//
	//   - Example: WAFV2 - Firewall Manager support for WAF managed rule group
	//   versioning
	//
	//   "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":true,\"version\":\"Version_2.0\",\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesCommonRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"
	//
	// To use a specific version of a WAF managed rule group in your Firewall Manager
	//   policy, you must set versionEnabled to true , and set version to the version
	//   you'd like to use. If you don't set versionEnabled to true , or if you omit
	//   versionEnabled , then Firewall Manager uses the default version of the WAF
	//   managed rule group.
	//
	//   - Example: WAFV2 - Logging configurations
	//
	// "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,
	//   \"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":
	//   {\"versionEnabled\":null,\"version\":null,\"vendorName\":\"AWS\",
	//   \"managedRuleGroupName\":\"AWSManagedRulesAdminProtectionRuleSet\"}
	//   ,\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[],
	//   \"sampledRequestsEnabled\":true}],\"postProcessRuleGroups\":[],
	//   \"defaultAction\":{\"type\":\"ALLOW\"},\"customRequestHandling\"
	//   :null,\"customResponse\":null,\"overrideCustomerWebACLAssociation\"
	//   :false,\"loggingConfiguration\":{\"logDestinationConfigs\":
	//   [\"arn:aws:s3:::aws-waf-logs-example-bucket\"]
	//   ,\"redactedFields\":[],\"loggingFilterConfigs\":{\"defaultBehavior\":\"KEEP\",
	//   \"filters\":[{\"behavior\":\"KEEP\",\"requirement\":\"MEETS_ALL\",
	//   \"conditions\":[{\"actionCondition\":\"CAPTCHA\"},{\"actionCondition\":
	//   \"CHALLENGE\"},
	//   {\"actionCondition\":\"EXCLUDED_AS_COUNT\"}]}]}},\"sampledRequestsEnabledForDefaultActions\":true}"
	//
	// Firewall Manager supports Amazon Kinesis Data Firehose and Amazon S3 as the
	//   logDestinationConfigs in your loggingConfiguration . For information about WAF
	//   logging configurations, see [LoggingConfiguration]in the WAF API Reference
	//
	// In the loggingConfiguration , you can specify one logDestinationConfigs .
	//   Optionally provide as many as 20 redactedFields . The RedactedFieldType must
	//   be one of URI , QUERY_STRING , HEADER , or METHOD .
	//
	//   - Example: WAF Classic
	//
	// "{\"type\": \"WAF\", \"ruleGroups\":
	//   [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" :
	//   {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"
	//
	// [AssociationConfig]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociationConfig.html
	// [PolicyOption]: https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html
	// [LoggingConfiguration]: https://docs.aws.amazon.com/waf/latest/APIReference/API_LoggingConfiguration.html
	// [AWSManagedRulesATPRuleSet]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesATPRuleSet.html
	// [ChallengeConfig]: https://docs.aws.amazon.com/waf/latest/APIReference/API_ChallengeConfig.html
	// [AWSManagedRulesBotControlRuleSet]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AWSManagedRulesBotControlRuleSet.html
	// [CaptchaConfig]: https://docs.aws.amazon.com/waf/latest/APIReference/API_CaptchaConfig.html
	// [RuleActionOverride]: https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleActionOverride.html
	// [DefaultSizeInspectionLimit]: https://docs.aws.amazon.com/waf/latest/APIReference/API_RequestBodyAssociatedResourceTypeConfig.html#WAF-Type-RequestBodyAssociatedResourceTypeConfig-DefaultSizeInspectionLimit
	ManagedServiceData *string

	// Contains the settings to configure a network ACL policy, a Network Firewall
	// firewall policy deployment model, or a third-party firewall policy.
	PolicyOption *PolicyOption

	noSmithyDocumentSerde
}

// Configuration settings for the handling of the stateful rule groups in a
// Network Firewall firewall policy.
type StatefulEngineOptions struct {

	// Indicates how to manage the order of stateful rule evaluation for the policy.
	// Stateful rules are provided to the rule engine as Suricata compatible strings,
	// and Suricata evaluates them based on certain settings. For more information, see
	// [Evaluation order for stateful rules]in the Network Firewall Developer Guide.
	//
	// Default: DEFAULT_ACTION_ORDER
	//
	// [Evaluation order for stateful rules]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html
	RuleOrder RuleOrder

	// Indicates how Network Firewall should handle traffic when a network connection
	// breaks midstream.
	//
	//   - DROP - Fail closed and drop all subsequent traffic going to the firewall.
	//
	//   - CONTINUE - Continue to apply rules to subsequent traffic without context
	//   from traffic before the break. This impacts the behavior of rules that depend on
	//   context. For example, with a stateful rule that drops HTTP traffic, Network
	//   Firewall won't match subsequent traffic because the it won't have the context
	//   from session initialization, which defines the application layer protocol as
	//   HTTP. However, a TCP-layer rule using a flow:stateless rule would still match,
	//   and so would the aws:drop_strict default action.
	//
	//   - REJECT - Fail closed and drop all subsequent traffic going to the firewall.
	//   With this option, Network Firewall also sends a TCP reject packet back to the
	//   client so the client can immediately establish a new session. With the new
	//   session, Network Firewall will have context and will apply rules appropriately.
	//
	// For applications that are reliant on long-lived TCP connections that trigger
	//   Gateway Load Balancer idle timeouts, this is the recommended setting.
	//
	//   - FMS_IGNORE - Firewall Manager doesn't monitor or modify the Network Firewall
	//   stream exception policy settings.
	//
	// For more information, see [Stream exception policy in your firewall policy] in the Network Firewall Developer Guide.
	//
	// Default: FMS_IGNORE
	//
	// [Stream exception policy in your firewall policy]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html
	StreamExceptionPolicy StreamExceptionPolicy

	noSmithyDocumentSerde
}

// Network Firewall stateful rule group, used in a NetworkFirewallPolicyDescription.
type StatefulRuleGroup struct {

	// The action that allows the policy owner to override the behavior of the rule
	// group within a policy.
	Override *NetworkFirewallStatefulRuleGroupOverride

	// An integer setting that indicates the order in which to run the stateful rule
	// groups in a single Network Firewall firewall policy. This setting only applies
	// to firewall policies that specify the STRICT_ORDER rule order in the stateful
	// engine options settings.
	//
	// Network Firewall evalutes each stateful rule group against a packet starting
	// with the group that has the lowest priority setting. You must ensure that the
	// priority settings are unique within each policy. For information about
	//
	// You can change the priority settings of your rule groups at any time. To make
	// it easier to insert rule groups later, number them so there's a wide range in
	// between, for example use 100, 200, and so on.
	Priority *int32

	// The resource ID of the rule group.
	ResourceId *string

	// The name of the rule group.
	RuleGroupName *string

	noSmithyDocumentSerde
}

// Network Firewall stateless rule group, used in a NetworkFirewallPolicyDescription.
type StatelessRuleGroup struct {

	// The priority of the rule group. Network Firewall evaluates the stateless rule
	// groups in a firewall policy starting from the lowest priority setting.
	Priority *int32

	// The resource ID of the rule group.
	ResourceId *string

	// The name of the rule group.
	RuleGroupName *string

	noSmithyDocumentSerde
}

// A collection of key:value pairs associated with an Amazon Web Services
// resource. The key:value pair can be anything you define. Typically, the tag key
// represents a category (such as "environment") and the tag value represents a
// specific value within that category (such as "test," "development," or
// "production"). You can add up to 50 tags to each Amazon Web Services resource.
type Tag struct {

	// Part of the key:value pair that defines a tag. You can use a tag key to
	// describe a category of information, such as "customer." Tag keys are
	// case-sensitive.
	//
	// This member is required.
	Key *string

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Configures the third-party firewall's firewall policy.
type ThirdPartyFirewallFirewallPolicy struct {

	// The ID of the specified firewall policy.
	FirewallPolicyId *string

	// The name of the specified firewall policy.
	FirewallPolicyName *string

	noSmithyDocumentSerde
}

// The violation details for a third-party firewall that's not associated with an
// Firewall Manager managed route table.
type ThirdPartyFirewallMissingExpectedRouteTableViolation struct {

	// The Availability Zone of the firewall subnet that's causing the violation.
	AvailabilityZone *string

	// The resource ID of the current route table that's associated with the subnet,
	// if one is available.
	CurrentRouteTable *string

	// The resource ID of the route table that should be associated with the subnet.
	ExpectedRouteTable *string

	// The resource ID of the VPC associated with a fireawll subnet that's causing the
	// violation.
	VPC *string

	// The ID of the third-party firewall or VPC resource that's causing the violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// The violation details about a third-party firewall's subnet that doesn't have a
// Firewall Manager managed firewall in its VPC.
type ThirdPartyFirewallMissingFirewallViolation struct {

	// The Availability Zone of the third-party firewall that's causing the violation.
	AvailabilityZone *string

	// The reason the resource is causing this violation, if a reason is available.
	TargetViolationReason *string

	// The resource ID of the VPC associated with a third-party firewall.
	VPC *string

	// The ID of the third-party firewall that's causing the violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// The violation details for a third-party firewall for an Availability Zone
// that's missing the Firewall Manager managed subnet.
type ThirdPartyFirewallMissingSubnetViolation struct {

	// The Availability Zone of a subnet that's causing the violation.
	AvailabilityZone *string

	// The reason the resource is causing the violation, if a reason is available.
	TargetViolationReason *string

	// The resource ID of the VPC associated with a subnet that's causing the
	// violation.
	VPC *string

	// The ID of the third-party firewall or VPC resource that's causing the violation.
	ViolationTarget *string

	noSmithyDocumentSerde
}

// Configures the deployment model for the third-party firewall.
type ThirdPartyFirewallPolicy struct {

	// Defines the deployment model to use for the third-party firewall policy.
	FirewallDeploymentModel FirewallDeploymentModel

	noSmithyDocumentSerde
}

// Violations for a resource based on the specified Firewall Manager policy and
// Amazon Web Services account.
type ViolationDetail struct {

	// The Amazon Web Services account that the violation details were requested for.
	//
	// This member is required.
	MemberAccount *string

	// The ID of the Firewall Manager policy that the violation details were requested
	// for.
	//
	// This member is required.
	PolicyId *string

	// The resource ID that the violation details were requested for.
	//
	// This member is required.
	ResourceId *string

	// The resource type that the violation details were requested for.
	//
	// This member is required.
	ResourceType *string

	// List of violations for the requested resource.
	//
	// This member is required.
	ResourceViolations []ResourceViolation

	// Brief description for the requested resource.
	ResourceDescription *string

	// The ResourceTag objects associated with the resource.
	ResourceTags []Tag

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
