// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the status of the specified subscription grant status in Amazon
// DataZone.
func (c *Client) UpdateSubscriptionGrantStatus(ctx context.Context, params *UpdateSubscriptionGrantStatusInput, optFns ...func(*Options)) (*UpdateSubscriptionGrantStatusOutput, error) {
	if params == nil {
		params = &UpdateSubscriptionGrantStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSubscriptionGrantStatus", params, optFns, c.addOperationUpdateSubscriptionGrantStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSubscriptionGrantStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSubscriptionGrantStatusInput struct {

	// The identifier of the asset the subscription grant status of which is to be
	// updated.
	//
	// This member is required.
	AssetIdentifier *string

	// The identifier of the Amazon DataZone domain in which a subscription grant
	// status is to be updated.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the subscription grant the status of which is to be updated.
	//
	// This member is required.
	Identifier *string

	// The status to be updated as part of the UpdateSubscriptionGrantStatus action.
	//
	// This member is required.
	Status types.SubscriptionGrantStatus

	// Specifies the error message that is returned if the operation cannot be
	// successfully completed.
	FailureCause *types.FailureCause

	// The target name to be updated as part of the UpdateSubscriptionGrantStatus
	// action.
	TargetName *string

	noSmithyDocumentSerde
}

type UpdateSubscriptionGrantStatusOutput struct {

	// The timestamp of when the subscription grant status was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone domain user who created the subscription grant status.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription grant
	// status is to be updated.
	//
	// This member is required.
	DomainId *string

	// The granted entity to be updated as part of the UpdateSubscriptionGrantStatus
	// action.
	//
	// This member is required.
	GrantedEntity types.GrantedEntity

	// The identifier of the subscription grant.
	//
	// This member is required.
	Id *string

	// The status to be updated as part of the UpdateSubscriptionGrantStatus action.
	//
	// This member is required.
	Status types.SubscriptionGrantOverallStatus

	// The identifier of the subscription target whose subscription grant status is to
	// be updated.
	//
	// This member is required.
	SubscriptionTargetId *string

	// The timestamp of when the subscription grant status is to be updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The details of the asset for which the subscription grant is created.
	Assets []types.SubscribedAsset

	// The identifier of the subscription.
	SubscriptionId *string

	// The Amazon DataZone user who updated the subscription grant status.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSubscriptionGrantStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSubscriptionGrantStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSubscriptionGrantStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSubscriptionGrantStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSubscriptionGrantStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSubscriptionGrantStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSubscriptionGrantStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSubscriptionGrantStatus",
	}
}
