// Code generated by smithy-go-codegen DO NOT EDIT.

package billingconductor

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/billingconductor/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateAccounts struct {
}

func (*validateOpAssociateAccounts) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateAccounts) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateAccountsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateAccountsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociatePricingRules struct {
}

func (*validateOpAssociatePricingRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociatePricingRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociatePricingRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociatePricingRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchAssociateResourcesToCustomLineItem struct {
}

func (*validateOpBatchAssociateResourcesToCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchAssociateResourcesToCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchAssociateResourcesToCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchAssociateResourcesToCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchDisassociateResourcesFromCustomLineItem struct {
}

func (*validateOpBatchDisassociateResourcesFromCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchDisassociateResourcesFromCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchDisassociateResourcesFromCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchDisassociateResourcesFromCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateBillingGroup struct {
}

func (*validateOpCreateBillingGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateBillingGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateBillingGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateBillingGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateCustomLineItem struct {
}

func (*validateOpCreateCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePricingPlan struct {
}

func (*validateOpCreatePricingPlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePricingPlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePricingPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePricingPlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePricingRule struct {
}

func (*validateOpCreatePricingRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePricingRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePricingRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePricingRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteBillingGroup struct {
}

func (*validateOpDeleteBillingGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteBillingGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteBillingGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteBillingGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCustomLineItem struct {
}

func (*validateOpDeleteCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePricingPlan struct {
}

func (*validateOpDeletePricingPlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePricingPlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePricingPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePricingPlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePricingRule struct {
}

func (*validateOpDeletePricingRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePricingRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePricingRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePricingRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateAccounts struct {
}

func (*validateOpDisassociateAccounts) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateAccounts) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateAccountsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateAccountsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociatePricingRules struct {
}

func (*validateOpDisassociatePricingRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociatePricingRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociatePricingRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociatePricingRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetBillingGroupCostReport struct {
}

func (*validateOpGetBillingGroupCostReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetBillingGroupCostReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetBillingGroupCostReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetBillingGroupCostReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCustomLineItemVersions struct {
}

func (*validateOpListCustomLineItemVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCustomLineItemVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCustomLineItemVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCustomLineItemVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPricingPlansAssociatedWithPricingRule struct {
}

func (*validateOpListPricingPlansAssociatedWithPricingRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPricingPlansAssociatedWithPricingRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPricingPlansAssociatedWithPricingRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPricingPlansAssociatedWithPricingRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPricingRulesAssociatedToPricingPlan struct {
}

func (*validateOpListPricingRulesAssociatedToPricingPlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPricingRulesAssociatedToPricingPlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPricingRulesAssociatedToPricingPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPricingRulesAssociatedToPricingPlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResourcesAssociatedToCustomLineItem struct {
}

func (*validateOpListResourcesAssociatedToCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResourcesAssociatedToCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResourcesAssociatedToCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResourcesAssociatedToCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateBillingGroup struct {
}

func (*validateOpUpdateBillingGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateBillingGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateBillingGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateBillingGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateCustomLineItem struct {
}

func (*validateOpUpdateCustomLineItem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateCustomLineItem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateCustomLineItemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateCustomLineItemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePricingPlan struct {
}

func (*validateOpUpdatePricingPlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePricingPlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePricingPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePricingPlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePricingRule struct {
}

func (*validateOpUpdatePricingRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePricingRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePricingRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePricingRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateAccountsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateAccounts{}, middleware.After)
}

func addOpAssociatePricingRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociatePricingRules{}, middleware.After)
}

func addOpBatchAssociateResourcesToCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchAssociateResourcesToCustomLineItem{}, middleware.After)
}

func addOpBatchDisassociateResourcesFromCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchDisassociateResourcesFromCustomLineItem{}, middleware.After)
}

func addOpCreateBillingGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateBillingGroup{}, middleware.After)
}

func addOpCreateCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCustomLineItem{}, middleware.After)
}

func addOpCreatePricingPlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePricingPlan{}, middleware.After)
}

func addOpCreatePricingRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePricingRule{}, middleware.After)
}

func addOpDeleteBillingGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteBillingGroup{}, middleware.After)
}

func addOpDeleteCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCustomLineItem{}, middleware.After)
}

func addOpDeletePricingPlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePricingPlan{}, middleware.After)
}

func addOpDeletePricingRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePricingRule{}, middleware.After)
}

func addOpDisassociateAccountsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateAccounts{}, middleware.After)
}

func addOpDisassociatePricingRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociatePricingRules{}, middleware.After)
}

func addOpGetBillingGroupCostReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetBillingGroupCostReport{}, middleware.After)
}

func addOpListCustomLineItemVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCustomLineItemVersions{}, middleware.After)
}

func addOpListPricingPlansAssociatedWithPricingRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPricingPlansAssociatedWithPricingRule{}, middleware.After)
}

func addOpListPricingRulesAssociatedToPricingPlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPricingRulesAssociatedToPricingPlan{}, middleware.After)
}

func addOpListResourcesAssociatedToCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResourcesAssociatedToCustomLineItem{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateBillingGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateBillingGroup{}, middleware.After)
}

func addOpUpdateCustomLineItemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateCustomLineItem{}, middleware.After)
}

func addOpUpdatePricingPlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePricingPlan{}, middleware.After)
}

func addOpUpdatePricingRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePricingRule{}, middleware.After)
}

func validateAccountGrouping(v *types.AccountGrouping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccountGrouping"}
	if v.LinkedAccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkedAccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBillingPeriodRange(v *types.BillingPeriodRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BillingPeriodRange"}
	if v.InclusiveStartBillingPeriod == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InclusiveStartBillingPeriod"))
	}
	if v.ExclusiveEndBillingPeriod == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExclusiveEndBillingPeriod"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputationPreference(v *types.ComputationPreference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputationPreference"}
	if v.PricingPlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PricingPlanArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFreeTierConfig(v *types.CreateFreeTierConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFreeTierConfig"}
	if v.Activated == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Activated"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateTieringInput(v *types.CreateTieringInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTieringInput"}
	if v.FreeTier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FreeTier"))
	} else if v.FreeTier != nil {
		if err := validateCreateFreeTierConfig(v.FreeTier); err != nil {
			invalidParams.AddNested("FreeTier", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomLineItemBillingPeriodRange(v *types.CustomLineItemBillingPeriodRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomLineItemBillingPeriodRange"}
	if v.InclusiveStartBillingPeriod == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InclusiveStartBillingPeriod"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomLineItemChargeDetails(v *types.CustomLineItemChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomLineItemChargeDetails"}
	if v.Flat != nil {
		if err := validateCustomLineItemFlatChargeDetails(v.Flat); err != nil {
			invalidParams.AddNested("Flat", err.(smithy.InvalidParamsError))
		}
	}
	if v.Percentage != nil {
		if err := validateCustomLineItemPercentageChargeDetails(v.Percentage); err != nil {
			invalidParams.AddNested("Percentage", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.LineItemFilters != nil {
		if err := validateLineItemFiltersList(v.LineItemFilters); err != nil {
			invalidParams.AddNested("LineItemFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomLineItemFlatChargeDetails(v *types.CustomLineItemFlatChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomLineItemFlatChargeDetails"}
	if v.ChargeValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChargeValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomLineItemPercentageChargeDetails(v *types.CustomLineItemPercentageChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomLineItemPercentageChargeDetails"}
	if v.PercentageValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PercentageValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLineItemFilter(v *types.LineItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LineItemFilter"}
	if len(v.Attribute) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Attribute"))
	}
	if len(v.MatchOption) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MatchOption"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLineItemFiltersList(v []types.LineItemFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LineItemFiltersList"}
	for i := range v {
		if err := validateLineItemFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateCustomLineItemChargeDetails(v *types.UpdateCustomLineItemChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCustomLineItemChargeDetails"}
	if v.Flat != nil {
		if err := validateUpdateCustomLineItemFlatChargeDetails(v.Flat); err != nil {
			invalidParams.AddNested("Flat", err.(smithy.InvalidParamsError))
		}
	}
	if v.Percentage != nil {
		if err := validateUpdateCustomLineItemPercentageChargeDetails(v.Percentage); err != nil {
			invalidParams.AddNested("Percentage", err.(smithy.InvalidParamsError))
		}
	}
	if v.LineItemFilters != nil {
		if err := validateLineItemFiltersList(v.LineItemFilters); err != nil {
			invalidParams.AddNested("LineItemFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateCustomLineItemFlatChargeDetails(v *types.UpdateCustomLineItemFlatChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCustomLineItemFlatChargeDetails"}
	if v.ChargeValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChargeValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateCustomLineItemPercentageChargeDetails(v *types.UpdateCustomLineItemPercentageChargeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCustomLineItemPercentageChargeDetails"}
	if v.PercentageValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PercentageValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateFreeTierConfig(v *types.UpdateFreeTierConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFreeTierConfig"}
	if v.Activated == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Activated"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateTieringInput(v *types.UpdateTieringInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateTieringInput"}
	if v.FreeTier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FreeTier"))
	} else if v.FreeTier != nil {
		if err := validateUpdateFreeTierConfig(v.FreeTier); err != nil {
			invalidParams.AddNested("FreeTier", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateAccountsInput(v *AssociateAccountsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateAccountsInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociatePricingRulesInput(v *AssociatePricingRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociatePricingRulesInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.PricingRuleArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PricingRuleArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchAssociateResourcesToCustomLineItemInput(v *BatchAssociateResourcesToCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchAssociateResourcesToCustomLineItemInput"}
	if v.TargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetArn"))
	}
	if v.ResourceArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArns"))
	}
	if v.BillingPeriodRange != nil {
		if err := validateCustomLineItemBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchDisassociateResourcesFromCustomLineItemInput(v *BatchDisassociateResourcesFromCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchDisassociateResourcesFromCustomLineItemInput"}
	if v.TargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetArn"))
	}
	if v.ResourceArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArns"))
	}
	if v.BillingPeriodRange != nil {
		if err := validateCustomLineItemBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateBillingGroupInput(v *CreateBillingGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateBillingGroupInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.AccountGrouping == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountGrouping"))
	} else if v.AccountGrouping != nil {
		if err := validateAccountGrouping(v.AccountGrouping); err != nil {
			invalidParams.AddNested("AccountGrouping", err.(smithy.InvalidParamsError))
		}
	}
	if v.ComputationPreference == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputationPreference"))
	} else if v.ComputationPreference != nil {
		if err := validateComputationPreference(v.ComputationPreference); err != nil {
			invalidParams.AddNested("ComputationPreference", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateCustomLineItemInput(v *CreateCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCustomLineItemInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.BillingGroupArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BillingGroupArn"))
	}
	if v.BillingPeriodRange != nil {
		if err := validateCustomLineItemBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if v.ChargeDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChargeDetails"))
	} else if v.ChargeDetails != nil {
		if err := validateCustomLineItemChargeDetails(v.ChargeDetails); err != nil {
			invalidParams.AddNested("ChargeDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePricingPlanInput(v *CreatePricingPlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePricingPlanInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePricingRuleInput(v *CreatePricingRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePricingRuleInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Scope) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Scope"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Tiering != nil {
		if err := validateCreateTieringInput(v.Tiering); err != nil {
			invalidParams.AddNested("Tiering", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteBillingGroupInput(v *DeleteBillingGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteBillingGroupInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteCustomLineItemInput(v *DeleteCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteCustomLineItemInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.BillingPeriodRange != nil {
		if err := validateCustomLineItemBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePricingPlanInput(v *DeletePricingPlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePricingPlanInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePricingRuleInput(v *DeletePricingRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePricingRuleInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateAccountsInput(v *DisassociateAccountsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateAccountsInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociatePricingRulesInput(v *DisassociatePricingRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociatePricingRulesInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.PricingRuleArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PricingRuleArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetBillingGroupCostReportInput(v *GetBillingGroupCostReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetBillingGroupCostReportInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.BillingPeriodRange != nil {
		if err := validateBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCustomLineItemVersionsInput(v *ListCustomLineItemVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCustomLineItemVersionsInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPricingPlansAssociatedWithPricingRuleInput(v *ListPricingPlansAssociatedWithPricingRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPricingPlansAssociatedWithPricingRuleInput"}
	if v.PricingRuleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PricingRuleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPricingRulesAssociatedToPricingPlanInput(v *ListPricingRulesAssociatedToPricingPlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPricingRulesAssociatedToPricingPlanInput"}
	if v.PricingPlanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PricingPlanArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResourcesAssociatedToCustomLineItemInput(v *ListResourcesAssociatedToCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResourcesAssociatedToCustomLineItemInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateBillingGroupInput(v *UpdateBillingGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateBillingGroupInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.ComputationPreference != nil {
		if err := validateComputationPreference(v.ComputationPreference); err != nil {
			invalidParams.AddNested("ComputationPreference", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateCustomLineItemInput(v *UpdateCustomLineItemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCustomLineItemInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.ChargeDetails != nil {
		if err := validateUpdateCustomLineItemChargeDetails(v.ChargeDetails); err != nil {
			invalidParams.AddNested("ChargeDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.BillingPeriodRange != nil {
		if err := validateCustomLineItemBillingPeriodRange(v.BillingPeriodRange); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePricingPlanInput(v *UpdatePricingPlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePricingPlanInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePricingRuleInput(v *UpdatePricingRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePricingRuleInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.Tiering != nil {
		if err := validateUpdateTieringInput(v.Tiering); err != nil {
			invalidParams.AddNested("Tiering", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
