// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies whether to get notified for alarm state changes.
type AcknowledgeFlow struct {

	// The value must be TRUE or FALSE . If TRUE , you receive a notification when the
	// alarm state changes. You must choose to acknowledge the notification before the
	// alarm state can return to NORMAL . If FALSE , you won't receive notifications.
	// The alarm automatically changes to the NORMAL state when the input property
	// value returns to the specified range.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// An action to be performed when the condition is TRUE.
type Action struct {

	// Information needed to clear the timer.
	ClearTimer *ClearTimerAction

	// Writes to the DynamoDB table that you created. The default action payload
	// contains all attribute-value pairs that have the information about the detector
	// model instance and the event that triggered the action. You can customize the [payload].
	// One column of the DynamoDB table receives all attribute-value pairs in the
	// payload that you specify. For more information, see [Actions]in AWS IoT Events Developer
	// Guide.
	//
	// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
	// [Actions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html
	DynamoDB *DynamoDBAction

	// Writes to the DynamoDB table that you created. The default action payload
	// contains all attribute-value pairs that have the information about the detector
	// model instance and the event that triggered the action. You can customize the [payload].
	// A separate column of the DynamoDB table receives one attribute-value pair in the
	// payload that you specify. For more information, see [Actions]in AWS IoT Events Developer
	// Guide.
	//
	// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
	// [Actions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html
	DynamoDBv2 *DynamoDBv2Action

	// Sends information about the detector model instance and the event that
	// triggered the action to an Amazon Kinesis Data Firehose delivery stream.
	Firehose *FirehoseAction

	// Sends AWS IoT Events input, which passes information about the detector model
	// instance and the event that triggered the action.
	IotEvents *IotEventsAction

	// Sends information about the detector model instance and the event that
	// triggered the action to an asset property in AWS IoT SiteWise .
	IotSiteWise *IotSiteWiseAction

	// Publishes an MQTT message with the given topic to the AWS IoT message broker.
	IotTopicPublish *IotTopicPublishAction

	// Calls a Lambda function, passing in information about the detector model
	// instance and the event that triggered the action.
	Lambda *LambdaAction

	// Information needed to reset the timer.
	ResetTimer *ResetTimerAction

	// Information needed to set the timer.
	SetTimer *SetTimerAction

	// Sets a variable to a specified value.
	SetVariable *SetVariableAction

	// Sends an Amazon SNS message.
	Sns *SNSTopicPublishAction

	// Sends information about the detector model instance and the event that
	// triggered the action to an Amazon SQS queue.
	Sqs *SqsAction

	noSmithyDocumentSerde
}

// Specifies one of the following actions to receive notifications when the alarm
// state changes.
type AlarmAction struct {

	// Defines an action to write to the Amazon DynamoDB table that you created. The
	// standard action payload contains all the information about the detector model
	// instance and the event that triggered the action. You can customize the [payload]. One
	// column of the DynamoDB table receives all attribute-value pairs in the payload
	// that you specify.
	//
	// You must use expressions for all parameters in DynamoDBAction . The expressions
	// accept literals, operators, functions, references, and substitution templates.
	//
	// Examples
	//
	//   - For literal values, the expressions must contain single quotes. For
	//   example, the value for the hashKeyType parameter can be 'STRING' .
	//
	//   - For references, you must specify either variables or input values. For
	//   example, the value for the hashKeyField parameter can be
	//   $input.GreenhouseInput.name .
	//
	//   - For a substitution template, you must use ${} , and the template must be in
	//   single quotes. A substitution template can also contain a combination of
	//   literals, operators, functions, references, and substitution templates.
	//
	// In the following example, the value for the hashKeyValue parameter uses a
	//   substitution template.
	//
	// '${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'
	//
	//   - For a string concatenation, you must use + . A string concatenation can also
	//   contain a combination of literals, operators, functions, references, and
	//   substitution templates.
	//
	// In the following example, the value for the tableName parameter uses a string
	//   concatenation.
	//
	// 'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date
	//
	// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
	//
	// If the defined payload type is a string, DynamoDBAction writes non-JSON data to
	// the DynamoDB table as binary data. The DynamoDB console displays the data as
	// Base64-encoded text. The value for the payloadField parameter is _raw .
	//
	// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
	// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
	DynamoDB *DynamoDBAction

	// Defines an action to write to the Amazon DynamoDB table that you created. The
	// default action payload contains all the information about the detector model
	// instance and the event that triggered the action. You can customize the [payload]. A
	// separate column of the DynamoDB table receives one attribute-value pair in the
	// payload that you specify.
	//
	// You must use expressions for all parameters in DynamoDBv2Action . The
	// expressions accept literals, operators, functions, references, and substitution
	// templates.
	//
	// Examples
	//
	//   - For literal values, the expressions must contain single quotes. For
	//   example, the value for the tableName parameter can be
	//   'GreenhouseTemperatureTable' .
	//
	//   - For references, you must specify either variables or input values. For
	//   example, the value for the tableName parameter can be $variable.ddbtableName .
	//
	//   - For a substitution template, you must use ${} , and the template must be in
	//   single quotes. A substitution template can also contain a combination of
	//   literals, operators, functions, references, and substitution templates.
	//
	// In the following example, the value for the contentExpression parameter in
	//   Payload uses a substitution template.
	//
	// '{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\":
	//   \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'
	//
	//   - For a string concatenation, you must use + . A string concatenation can also
	//   contain a combination of literals, operators, functions, references, and
	//   substitution templates.
	//
	// In the following example, the value for the tableName parameter uses a string
	//   concatenation.
	//
	// 'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date
	//
	// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
	//
	// The value for the type parameter in Payload must be JSON .
	//
	// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
	// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
	DynamoDBv2 *DynamoDBv2Action

	// Sends information about the detector model instance and the event that
	// triggered the action to an Amazon Kinesis Data Firehose delivery stream.
	Firehose *FirehoseAction

	// Sends an AWS IoT Events input, passing in information about the detector model
	// instance and the event that triggered the action.
	IotEvents *IotEventsAction

	// Sends information about the detector model instance and the event that
	// triggered the action to a specified asset property in AWS IoT SiteWise.
	//
	// You must use expressions for all parameters in IotSiteWiseAction . The
	// expressions accept literals, operators, functions, references, and substitutions
	// templates.
	//
	// Examples
	//
	//   - For literal values, the expressions must contain single quotes. For
	//   example, the value for the propertyAlias parameter can be
	//   '/company/windfarm/3/turbine/7/temperature' .
	//
	//   - For references, you must specify either variables or input values. For
	//   example, the value for the assetId parameter can be
	//   $input.TurbineInput.assetId1 .
	//
	//   - For a substitution template, you must use ${} , and the template must be in
	//   single quotes. A substitution template can also contain a combination of
	//   literals, operators, functions, references, and substitution templates.
	//
	// In the following example, the value for the propertyAlias parameter uses a
	//   substitution template.
	//
	// 'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/
	//   ${$input.TemperatureInput.sensorData.turbineID}/temperature'
	//
	// You must specify either propertyAlias or both assetId and propertyId to
	// identify the target asset property in AWS IoT SiteWise.
	//
	// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
	//
	// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
	IotSiteWise *IotSiteWiseAction

	// Information required to publish the MQTT message through the AWS IoT message
	// broker.
	IotTopicPublish *IotTopicPublishAction

	// Calls a Lambda function, passing in information about the detector model
	// instance and the event that triggered the action.
	Lambda *LambdaAction

	// Information required to publish the Amazon SNS message.
	Sns *SNSTopicPublishAction

	// Sends information about the detector model instance and the event that
	// triggered the action to an Amazon SQS queue.
	Sqs *SqsAction

	noSmithyDocumentSerde
}

// Contains the configuration information of alarm state changes.
type AlarmCapabilities struct {

	// Specifies whether to get notified for alarm state changes.
	AcknowledgeFlow *AcknowledgeFlow

	// Specifies the default alarm state. The configuration applies to all alarms that
	// were created based on this alarm model.
	InitializationConfiguration *InitializationConfiguration

	noSmithyDocumentSerde
}

// Contains information about one or more alarm actions.
type AlarmEventActions struct {

	// Specifies one or more supported actions to receive notifications when the alarm
	// state changes.
	AlarmActions []AlarmAction

	noSmithyDocumentSerde
}

// Contains a summary of an alarm model.
type AlarmModelSummary struct {

	// The description of the alarm model.
	AlarmModelDescription *string

	// The name of the alarm model.
	AlarmModelName *string

	// The time the alarm model was created, in the Unix epoch format.
	CreationTime *time.Time

	noSmithyDocumentSerde
}

// Contains a summary of an alarm model version.
type AlarmModelVersionSummary struct {

	// The ARN of the alarm model. For more information, see [Amazon Resource Names (ARNs)] in the AWS General
	// Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	AlarmModelArn *string

	// The name of the alarm model.
	AlarmModelName *string

	// The version of the alarm model.
	AlarmModelVersion *string

	// The time the alarm model was created, in the Unix epoch format.
	CreationTime *time.Time

	// The time the alarm model was last updated, in the Unix epoch format.
	LastUpdateTime *time.Time

	// The ARN of the IAM role that allows the alarm to perform actions and access AWS
	// resources. For more information, see [Amazon Resource Names (ARNs)]in the AWS General Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	RoleArn *string

	// The status of the alarm model. The status can be one of the following values:
	//
	//   - ACTIVE - The alarm model is active and it's ready to evaluate data.
	//
	//   - ACTIVATING - AWS IoT Events is activating your alarm model. Activating an
	//   alarm model can take up to a few minutes.
	//
	//   - INACTIVE - The alarm model is inactive, so it isn't ready to evaluate data.
	//   Check your alarm model information and update the alarm model.
	//
	//   - FAILED - You couldn't create or update the alarm model. Check your alarm
	//   model information and try again.
	Status AlarmModelVersionStatus

	//  Contains information about the status of the alarm model version.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains information about one or more notification actions.
type AlarmNotification struct {

	// Contains the notification settings of an alarm model. The settings apply to all
	// alarms that were created based on this alarm model.
	NotificationActions []NotificationAction

	noSmithyDocumentSerde
}

// Defines when your alarm is invoked.
type AlarmRule struct {

	// A rule that compares an input property value to a threshold value with a
	// comparison operator.
	SimpleRule *SimpleRule

	noSmithyDocumentSerde
}

// Contains the result of the analysis.
type AnalysisResult struct {

	// The severity level of the analysis result. Based on the severity level,
	// analysis results fall into three general categories:
	//
	//   - INFO - An information result tells you about a significant field in your
	//   detector model. This type of result usually doesn't require immediate action.
	//
	//   - WARNING - A warning result draws special attention to fields that might
	//   cause issues for your detector model. We recommend that you review warnings and
	//   take necessary actions before you use your detector model in production
	//   environments. Otherwise, the detector model might not work as expected.
	//
	//   - ERROR - An error result notifies you about a problem found in your detector
	//   model. You must fix all errors before you can publish your detector model.
	Level AnalysisResultLevel

	// Contains one or more locations that you can use to locate the fields in your
	// detector model that the analysis result references.
	Locations []AnalysisResultLocation

	// Contains additional information about the analysis result.
	Message *string

	// The type of the analysis result. Analyses fall into the following types based
	// on the validators used to generate the analysis result:
	//
	//   - supported-actions - You must specify AWS IoT Events supported actions that
	//   work with other AWS services in a supported AWS Region.
	//
	//   - service-limits - Resources or API operations can't exceed service quotas
	//   (also known as limits). Update your detector model or request a quota increase.
	//
	//   - structure - The detector model must follow a structure that AWS IoT Events
	//   supports.
	//
	//   - expression-syntax - Your expression must follow the required syntax.
	//
	//   - data-type - Data types referenced in the detector model must be compatible.
	//
	//   - referenced-data - You must define the data referenced in your detector model
	//   before you can use the data.
	//
	//   - referenced-resource - Resources that the detector model uses must be
	//   available.
	//
	// For more information, see [Running detector model analyses] in the AWS IoT Events Developer Guide.
	//
	// [Running detector model analyses]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html
	Type *string

	noSmithyDocumentSerde
}

// Contains information that you can use to locate the field in your detector
// model that the analysis result references.
type AnalysisResultLocation struct {

	// A [JsonPath] expression that identifies the error field in your detector model.
	//
	// [JsonPath]: https://github.com/json-path/JsonPath
	Path *string

	noSmithyDocumentSerde
}

// A structure that contains timestamp information. For more information, see [TimeInNanos] in
// the AWS IoT SiteWise API Reference.
//
// You must use expressions for all parameters in AssetPropertyTimestamp . The
// expressions accept literals, operators, functions, references, and substitution
// templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the timeInSeconds parameter can be '1586400675' .
//
//   - For references, you must specify either variables or input values. For
//     example, the value for the offsetInNanos parameter can be $variable.time .
//
//   - For a substitution template, you must use ${} , and the template must be in
//     single quotes. A substitution template can also contain a combination of
//     literals, operators, functions, references, and substitution templates.
//
// In the following example, the value for the timeInSeconds parameter uses a
//
//	substitution template.
//
// '${$input.TemperatureInput.sensorData.timestamp / 1000}'
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// [TimeInNanos]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type AssetPropertyTimestamp struct {

	// The timestamp, in seconds, in the Unix epoch format. The valid range is between
	// 1-31556889864403199.
	//
	// This member is required.
	TimeInSeconds *string

	// The nanosecond offset converted from timeInSeconds . The valid range is between
	// 0-999999999.
	OffsetInNanos *string

	noSmithyDocumentSerde
}

// A structure that contains value information. For more information, see [AssetPropertyValue] in the
// AWS IoT SiteWise API Reference.
//
// You must use expressions for all parameters in AssetPropertyValue . The
// expressions accept literals, operators, functions, references, and substitution
// templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the quality parameter can be 'GOOD' .
//
//   - For references, you must specify either variables or input values. For
//     example, the value for the quality parameter can be
//     $input.TemperatureInput.sensorData.quality .
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// [AssetPropertyValue]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type AssetPropertyValue struct {

	// The quality of the asset property value. The value must be 'GOOD' , 'BAD' , or
	// 'UNCERTAIN' .
	Quality *string

	// The timestamp associated with the asset property value. The default is the
	// current event time.
	Timestamp *AssetPropertyTimestamp

	// The value to send to an asset property.
	Value *AssetPropertyVariant

	noSmithyDocumentSerde
}

// A structure that contains an asset property value. For more information, see [Variant]
// in the AWS IoT SiteWise API Reference.
//
// You must use expressions for all parameters in AssetPropertyVariant . The
// expressions accept literals, operators, functions, references, and substitution
// templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the integerValue parameter can be '100' .
//
//   - For references, you must specify either variables or parameters. For
//     example, the value for the booleanValue parameter can be $variable.offline .
//
//   - For a substitution template, you must use ${} , and the template must be in
//     single quotes. A substitution template can also contain a combination of
//     literals, operators, functions, references, and substitution templates.
//
// In the following example, the value for the doubleValue parameter uses a
//
//	substitution template.
//
// '${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// You must specify one of the following value types, depending on the dataType of
// the specified asset property. For more information, see [AssetProperty]in the AWS IoT SiteWise
// API Reference.
//
// [Variant]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html
// [AssetProperty]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type AssetPropertyVariant struct {

	// The asset property value is a Boolean value that must be 'TRUE' or 'FALSE' . You
	// must use an expression, and the evaluated result should be a Boolean value.
	BooleanValue *string

	// The asset property value is a double. You must use an expression, and the
	// evaluated result should be a double.
	DoubleValue *string

	// The asset property value is an integer. You must use an expression, and the
	// evaluated result should be an integer.
	IntegerValue *string

	// The asset property value is a string. You must use an expression, and the
	// evaluated result should be a string.
	StringValue *string

	noSmithyDocumentSerde
}

// The attributes from the JSON payload that are made available by the input.
// Inputs are derived from messages sent to the AWS IoT Events system using
// BatchPutMessage . Each such message contains a JSON payload. Those attributes
// (and their paired values) specified here are available for use in the condition
// expressions used by detectors.
type Attribute struct {

	// An expression that specifies an attribute-value pair in a JSON structure. Use
	// this to specify an attribute from the JSON payload that is made available by the
	// input. Inputs are derived from messages sent to AWS IoT Events ( BatchPutMessage
	// ). Each such message contains a JSON payload. The attribute (and its paired
	// value) specified here are available for use in the condition expressions used
	// by detectors.
	//
	// Syntax: ....
	//
	// This member is required.
	JsonPath *string

	noSmithyDocumentSerde
}

// Information needed to clear the timer.
type ClearTimerAction struct {

	// The name of the timer to clear.
	//
	// This member is required.
	TimerName *string

	noSmithyDocumentSerde
}

// The detector model and the specific detectors (instances) for which the logging
// level is given.
type DetectorDebugOption struct {

	// The name of the detector model.
	//
	// This member is required.
	DetectorModelName *string

	// The value of the input attribute key used to create the detector (the instance
	// of the detector model).
	KeyValue *string

	noSmithyDocumentSerde
}

// Information about the detector model.
type DetectorModel struct {

	// Information about how the detector is configured.
	DetectorModelConfiguration *DetectorModelConfiguration

	// Information that defines how a detector operates.
	DetectorModelDefinition *DetectorModelDefinition

	noSmithyDocumentSerde
}

// Information about how the detector model is configured.
type DetectorModelConfiguration struct {

	// The time the detector model was created.
	CreationTime *time.Time

	// The ARN of the detector model.
	DetectorModelArn *string

	// A brief description of the detector model.
	DetectorModelDescription *string

	// The name of the detector model.
	DetectorModelName *string

	// The version of the detector model.
	DetectorModelVersion *string

	// Information about the order in which events are evaluated and how actions are
	// executed.
	EvaluationMethod EvaluationMethod

	// The value used to identify a detector instance. When a device or system sends
	// input, a new detector instance with a unique key value is created. AWS IoT
	// Events can continue to route input to its corresponding detector instance based
	// on this identifying information.
	//
	// This parameter uses a JSON-path expression to select the attribute-value pair
	// in the message payload that is used for identification. To route the message to
	// the correct detector instance, the device must send a message payload that
	// contains the same attribute-value.
	Key *string

	// The time the detector model was last updated.
	LastUpdateTime *time.Time

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	RoleArn *string

	// The status of the detector model.
	Status DetectorModelVersionStatus

	noSmithyDocumentSerde
}

// Information that defines how a detector operates.
type DetectorModelDefinition struct {

	// The state that is entered at the creation of each detector (instance).
	//
	// This member is required.
	InitialStateName *string

	// Information about the states of the detector.
	//
	// This member is required.
	States []State

	noSmithyDocumentSerde
}

// Information about the detector model.
type DetectorModelSummary struct {

	// The time the detector model was created.
	CreationTime *time.Time

	// A brief description of the detector model.
	DetectorModelDescription *string

	// The name of the detector model.
	DetectorModelName *string

	noSmithyDocumentSerde
}

// Information about the detector model version.
type DetectorModelVersionSummary struct {

	// The time the detector model version was created.
	CreationTime *time.Time

	// The ARN of the detector model version.
	DetectorModelArn *string

	// The name of the detector model.
	DetectorModelName *string

	// The ID of the detector model version.
	DetectorModelVersion *string

	// Information about the order in which events are evaluated and how actions are
	// executed.
	EvaluationMethod EvaluationMethod

	// The last time the detector model version was updated.
	LastUpdateTime *time.Time

	// The ARN of the role that grants the detector model permission to perform its
	// tasks.
	RoleArn *string

	// The status of the detector model version.
	Status DetectorModelVersionStatus

	noSmithyDocumentSerde
}

// Defines an action to write to the Amazon DynamoDB table that you created. The
// standard action payload contains all the information about the detector model
// instance and the event that triggered the action. You can customize the [payload]. One
// column of the DynamoDB table receives all attribute-value pairs in the payload
// that you specify.
//
// You must use expressions for all parameters in DynamoDBAction . The expressions
// accept literals, operators, functions, references, and substitution templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the hashKeyType parameter can be 'STRING' .
//
//   - For references, you must specify either variables or input values. For
//     example, the value for the hashKeyField parameter can be
//     $input.GreenhouseInput.name .
//
//   - For a substitution template, you must use ${} , and the template must be in
//     single quotes. A substitution template can also contain a combination of
//     literals, operators, functions, references, and substitution templates.
//
// In the following example, the value for the hashKeyValue parameter uses a
//
//	substitution template.
//
// '${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'
//
//   - For a string concatenation, you must use + . A string concatenation can also
//     contain a combination of literals, operators, functions, references, and
//     substitution templates.
//
// In the following example, the value for the tableName parameter uses a string
//
//	concatenation.
//
// 'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// If the defined payload type is a string, DynamoDBAction writes non-JSON data to
// the DynamoDB table as binary data. The DynamoDB console displays the data as
// Base64-encoded text. The value for the payloadField parameter is _raw .
//
// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type DynamoDBAction struct {

	// The name of the hash key (also called the partition key). The hashKeyField
	// value must match the partition key of the target DynamoDB table.
	//
	// This member is required.
	HashKeyField *string

	// The value of the hash key (also called the partition key).
	//
	// This member is required.
	HashKeyValue *string

	// The name of the DynamoDB table. The tableName value must match the table name
	// of the target DynamoDB table.
	//
	// This member is required.
	TableName *string

	// The data type for the hash key (also called the partition key). You can specify
	// the following values:
	//
	//   - 'STRING' - The hash key is a string.
	//
	//   - 'NUMBER' - The hash key is a number.
	//
	// If you don't specify hashKeyType , the default value is 'STRING' .
	HashKeyType *string

	// The type of operation to perform. You can specify the following values:
	//
	//   - 'INSERT' - Insert data as a new item into the DynamoDB table. This item uses
	//   the specified hash key as a partition key. If you specified a range key, the
	//   item uses the range key as a sort key.
	//
	//   - 'UPDATE' - Update an existing item of the DynamoDB table with new data. This
	//   item's partition key must match the specified hash key. If you specified a range
	//   key, the range key must match the item's sort key.
	//
	//   - 'DELETE' - Delete an existing item of the DynamoDB table. This item's
	//   partition key must match the specified hash key. If you specified a range key,
	//   the range key must match the item's sort key.
	//
	// If you don't specify this parameter, AWS IoT Events triggers the 'INSERT'
	// operation.
	Operation *string

	// Information needed to configure the payload.
	//
	// By default, AWS IoT Events generates a standard payload in JSON for any action.
	// This action payload contains all attribute-value pairs that have the information
	// about the detector model instance and the event triggered the action. To
	// configure the action payload, you can use contentExpression .
	Payload *Payload

	// The name of the DynamoDB column that receives the action payload.
	//
	// If you don't specify this parameter, the name of the DynamoDB column is payload .
	PayloadField *string

	// The name of the range key (also called the sort key). The rangeKeyField value
	// must match the sort key of the target DynamoDB table.
	RangeKeyField *string

	// The data type for the range key (also called the sort key), You can specify the
	// following values:
	//
	//   - 'STRING' - The range key is a string.
	//
	//   - 'NUMBER' - The range key is number.
	//
	// If you don't specify rangeKeyField , the default value is 'STRING' .
	RangeKeyType *string

	// The value of the range key (also called the sort key).
	RangeKeyValue *string

	noSmithyDocumentSerde
}

// Defines an action to write to the Amazon DynamoDB table that you created. The
// default action payload contains all the information about the detector model
// instance and the event that triggered the action. You can customize the [payload]. A
// separate column of the DynamoDB table receives one attribute-value pair in the
// payload that you specify.
//
// You must use expressions for all parameters in DynamoDBv2Action . The
// expressions accept literals, operators, functions, references, and substitution
// templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the tableName parameter can be
//     'GreenhouseTemperatureTable' .
//
//   - For references, you must specify either variables or input values. For
//     example, the value for the tableName parameter can be $variable.ddbtableName .
//
//   - For a substitution template, you must use ${} , and the template must be in
//     single quotes. A substitution template can also contain a combination of
//     literals, operators, functions, references, and substitution templates.
//
// In the following example, the value for the contentExpression parameter in
//
//	Payload uses a substitution template.
//
// '{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\":
//
//	\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'
//
//	- For a string concatenation, you must use + . A string concatenation can also
//	contain a combination of literals, operators, functions, references, and
//	substitution templates.
//
// In the following example, the value for the tableName parameter uses a string
//
//	concatenation.
//
// 'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// The value for the type parameter in Payload must be JSON .
//
// [payload]: https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type DynamoDBv2Action struct {

	// The name of the DynamoDB table.
	//
	// This member is required.
	TableName *string

	// Information needed to configure the payload.
	//
	// By default, AWS IoT Events generates a standard payload in JSON for any action.
	// This action payload contains all attribute-value pairs that have the information
	// about the detector model instance and the event triggered the action. To
	// configure the action payload, you can use contentExpression .
	Payload *Payload

	noSmithyDocumentSerde
}

// Contains the configuration information of email notifications.
type EmailConfiguration struct {

	// The email address that sends emails.
	//
	// If you use the AWS IoT Events managed AWS Lambda function to manage your
	// emails, you must [verify the email address that sends emails in Amazon SES].
	//
	// [verify the email address that sends emails in Amazon SES]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html
	//
	// This member is required.
	From *string

	// Contains the information of one or more recipients who receive the emails.
	//
	// You must [add the users that receive emails to your AWS SSO store].
	//
	// [add the users that receive emails to your AWS SSO store]: https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html
	//
	// This member is required.
	Recipients *EmailRecipients

	// Contains the subject and message of an email.
	Content *EmailContent

	noSmithyDocumentSerde
}

// Contains the subject and message of an email.
type EmailContent struct {

	// The message that you want to send. The message can be up to 200 characters.
	AdditionalMessage *string

	// The subject of the email.
	Subject *string

	noSmithyDocumentSerde
}

// Contains the information of one or more recipients who receive the emails.
//
// You must [add the users that receive emails to your AWS SSO store].
//
// [add the users that receive emails to your AWS SSO store]: https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html
type EmailRecipients struct {

	// Specifies one or more recipients who receive the email.
	To []RecipientDetail

	noSmithyDocumentSerde
}

// Specifies the actions to be performed when the condition evaluates to TRUE.
type Event struct {

	// The name of the event.
	//
	// This member is required.
	EventName *string

	// The actions to be performed.
	Actions []Action

	// Optional. The Boolean expression that, when TRUE, causes the actions to be
	// performed. If not present, the actions are performed (=TRUE). If the expression
	// result is not a Boolean value, the actions are not performed (=FALSE).
	Condition *string

	noSmithyDocumentSerde
}

// Sends information about the detector model instance and the event that
// triggered the action to an Amazon Kinesis Data Firehose delivery stream.
type FirehoseAction struct {

	// The name of the Kinesis Data Firehose delivery stream where the data is written.
	//
	// This member is required.
	DeliveryStreamName *string

	// You can configure the action payload when you send a message to an Amazon
	// Kinesis Data Firehose delivery stream.
	Payload *Payload

	// A character separator that is used to separate records written to the Kinesis
	// Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab),
	// '\r\n' (Windows newline), ',' (comma).
	Separator *string

	noSmithyDocumentSerde
}

// Specifies the default alarm state. The configuration applies to all alarms that
// were created based on this alarm model.
type InitializationConfiguration struct {

	// The value must be TRUE or FALSE . If FALSE , all alarm instances created based
	// on the alarm model are activated. The default value is TRUE .
	//
	// This member is required.
	DisabledOnInitialization *bool

	noSmithyDocumentSerde
}

// Information about the input.
type Input struct {

	// Information about the configuration of an input.
	InputConfiguration *InputConfiguration

	// The definition of the input.
	InputDefinition *InputDefinition

	noSmithyDocumentSerde
}

// Information about the configuration of an input.
type InputConfiguration struct {

	// The time the input was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The ARN of the input.
	//
	// This member is required.
	InputArn *string

	// The name of the input.
	//
	// This member is required.
	InputName *string

	// The last time the input was updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The status of the input.
	//
	// This member is required.
	Status InputStatus

	// A brief description of the input.
	InputDescription *string

	noSmithyDocumentSerde
}

// The definition of the input.
type InputDefinition struct {

	// The attributes from the JSON payload that are made available by the input.
	// Inputs are derived from messages sent to the AWS IoT Events system using
	// BatchPutMessage . Each such message contains a JSON payload, and those
	// attributes (and their paired values) specified here are available for use in the
	// condition expressions used by detectors that monitor this input.
	//
	// This member is required.
	Attributes []Attribute

	noSmithyDocumentSerde
}

// The identifer of the input.
type InputIdentifier struct {

	//  The identifier of the input routed to AWS IoT Events.
	IotEventsInputIdentifier *IotEventsInputIdentifier

	//  The identifer of the input routed from AWS IoT SiteWise.
	IotSiteWiseInputIdentifier *IotSiteWiseInputIdentifier

	noSmithyDocumentSerde
}

// Information about the input.
type InputSummary struct {

	// The time the input was created.
	CreationTime *time.Time

	// The ARN of the input.
	InputArn *string

	// A brief description of the input.
	InputDescription *string

	// The name of the input.
	InputName *string

	// The last time the input was updated.
	LastUpdateTime *time.Time

	// The status of the input.
	Status InputStatus

	noSmithyDocumentSerde
}

// Sends an AWS IoT Events input, passing in information about the detector model
// instance and the event that triggered the action.
type IotEventsAction struct {

	// The name of the AWS IoT Events input where the data is sent.
	//
	// This member is required.
	InputName *string

	// You can configure the action payload when you send a message to an AWS IoT
	// Events input.
	Payload *Payload

	noSmithyDocumentSerde
}

// The identifier of the input routed to AWS IoT Events.
type IotEventsInputIdentifier struct {

	//  The name of the input routed to AWS IoT Events.
	//
	// This member is required.
	InputName *string

	noSmithyDocumentSerde
}

// Sends information about the detector model instance and the event that
// triggered the action to a specified asset property in AWS IoT SiteWise.
//
// You must use expressions for all parameters in IotSiteWiseAction . The
// expressions accept literals, operators, functions, references, and substitutions
// templates.
//
// Examples
//
//   - For literal values, the expressions must contain single quotes. For
//     example, the value for the propertyAlias parameter can be
//     '/company/windfarm/3/turbine/7/temperature' .
//
//   - For references, you must specify either variables or input values. For
//     example, the value for the assetId parameter can be
//     $input.TurbineInput.assetId1 .
//
//   - For a substitution template, you must use ${} , and the template must be in
//     single quotes. A substitution template can also contain a combination of
//     literals, operators, functions, references, and substitution templates.
//
// In the following example, the value for the propertyAlias parameter uses a
//
//	substitution template.
//
// 'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/
//
//	${$input.TemperatureInput.sensorData.turbineID}/temperature'
//
// You must specify either propertyAlias or both assetId and propertyId to
// identify the target asset property in AWS IoT SiteWise.
//
// For more information, see [Expressions] in the AWS IoT Events Developer Guide.
//
// [Expressions]: https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
type IotSiteWiseAction struct {

	// The ID of the asset that has the specified property.
	AssetId *string

	// A unique identifier for this entry. You can use the entry ID to track which
	// data entry causes an error in case of failure. The default is a new unique
	// identifier.
	EntryId *string

	// The alias of the asset property.
	PropertyAlias *string

	// The ID of the asset property.
	PropertyId *string

	// The value to send to the asset property. This value contains timestamp,
	// quality, and value (TQV) information.
	PropertyValue *AssetPropertyValue

	noSmithyDocumentSerde
}

// The asset model property identifer of the input routed from AWS IoT SiteWise.
type IotSiteWiseAssetModelPropertyIdentifier struct {

	//  The ID of the AWS IoT SiteWise asset model.
	//
	// This member is required.
	AssetModelId *string

	//  The ID of the AWS IoT SiteWise asset property.
	//
	// This member is required.
	PropertyId *string

	noSmithyDocumentSerde
}

// The identifer of the input routed from AWS IoT SiteWise.
type IotSiteWiseInputIdentifier struct {

	//  The identifier of the AWS IoT SiteWise asset model property.
	IotSiteWiseAssetModelPropertyIdentifier *IotSiteWiseAssetModelPropertyIdentifier

	noSmithyDocumentSerde
}

// Information required to publish the MQTT message through the AWS IoT message
// broker.
type IotTopicPublishAction struct {

	// The MQTT topic of the message. You can use a string expression that includes
	// variables ( $variable. ) and input values ( $input.. ) as the topic string.
	//
	// This member is required.
	MqttTopic *string

	// You can configure the action payload when you publish a message to an AWS IoT
	// Core topic.
	Payload *Payload

	noSmithyDocumentSerde
}

// Calls a Lambda function, passing in information about the detector model
// instance and the event that triggered the action.
type LambdaAction struct {

	// The ARN of the Lambda function that is executed.
	//
	// This member is required.
	FunctionArn *string

	// You can configure the action payload when you send a message to a Lambda
	// function.
	Payload *Payload

	noSmithyDocumentSerde
}

// The values of the AWS IoT Events logging options.
type LoggingOptions struct {

	// If TRUE, logging is enabled for AWS IoT Events.
	//
	// This member is required.
	Enabled bool

	// The logging level.
	//
	// This member is required.
	Level LoggingLevel

	// The ARN of the role that grants permission to AWS IoT Events to perform logging.
	//
	// This member is required.
	RoleArn *string

	// Information that identifies those detector models and their detectors
	// (instances) for which the logging level is given.
	DetectorDebugOptions []DetectorDebugOption

	noSmithyDocumentSerde
}

// Contains the notification settings of an alarm model. The settings apply to all
// alarms that were created based on this alarm model.
type NotificationAction struct {

	// Specifies an AWS Lambda function to manage alarm notifications. You can create
	// one or use the [AWS Lambda function provided by AWS IoT Events].
	//
	// [AWS Lambda function provided by AWS IoT Events]: https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html
	//
	// This member is required.
	Action *NotificationTargetActions

	// Contains the configuration information of email notifications.
	EmailConfigurations []EmailConfiguration

	// Contains the configuration information of SMS notifications.
	SmsConfigurations []SMSConfiguration

	noSmithyDocumentSerde
}

// Specifies an AWS Lambda function to manage alarm notifications. You can create
// one or use the [AWS Lambda function provided by AWS IoT Events].
//
// [AWS Lambda function provided by AWS IoT Events]: https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html
type NotificationTargetActions struct {

	// Calls a Lambda function, passing in information about the detector model
	// instance and the event that triggered the action.
	LambdaAction *LambdaAction

	noSmithyDocumentSerde
}

// When entering this state, perform these actions if the condition is TRUE.
type OnEnterLifecycle struct {

	// Specifies the actions that are performed when the state is entered and the
	// condition is TRUE .
	Events []Event

	noSmithyDocumentSerde
}

// When exiting this state, perform these actions if the specified condition is
// TRUE .
type OnExitLifecycle struct {

	// Specifies the actions that are performed when the state is exited and the
	// condition is TRUE .
	Events []Event

	noSmithyDocumentSerde
}

// Specifies the actions performed when the condition evaluates to TRUE.
type OnInputLifecycle struct {

	// Specifies the actions performed when the condition evaluates to TRUE.
	Events []Event

	// Specifies the actions performed, and the next state entered, when a condition
	// evaluates to TRUE.
	TransitionEvents []TransitionEvent

	noSmithyDocumentSerde
}

// Information needed to configure the payload.
//
// By default, AWS IoT Events generates a standard payload in JSON for any action.
// This action payload contains all attribute-value pairs that have the information
// about the detector model instance and the event triggered the action. To
// configure the action payload, you can use contentExpression .
type Payload struct {

	// The content of the payload. You can use a string expression that includes
	// quoted strings ( '' ), variables ( $variable. ), input values ( $input.. ),
	// string concatenations, and quoted strings that contain ${} as the content. The
	// recommended maximum size of a content expression is 1 KB.
	//
	// This member is required.
	ContentExpression *string

	// The value of the payload type can be either STRING or JSON .
	//
	// This member is required.
	Type PayloadType

	noSmithyDocumentSerde
}

// The information that identifies the recipient.
type RecipientDetail struct {

	// The AWS Single Sign-On (AWS SSO) authentication information.
	SsoIdentity *SSOIdentity

	noSmithyDocumentSerde
}

// Information required to reset the timer. The timer is reset to the previously
// evaluated result of the duration. The duration expression isn't reevaluated when
// you reset the timer.
type ResetTimerAction struct {

	// The name of the timer to reset.
	//
	// This member is required.
	TimerName *string

	noSmithyDocumentSerde
}

// Contains information about the routed resource.
type RoutedResource struct {

	//  The ARN of the routed resource. For more information, see [Amazon Resource Names (ARNs)] in the AWS General
	// Reference.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	Arn *string

	//  The name of the routed resource.
	Name *string

	noSmithyDocumentSerde
}

// Information needed to set the timer.
type SetTimerAction struct {

	// The name of the timer.
	//
	// This member is required.
	TimerName *string

	// The duration of the timer, in seconds. You can use a string expression that
	// includes numbers, variables ( $variable. ), and input values ( $input.. ) as the
	// duration. The range of the duration is 1-31622400 seconds. To ensure accuracy,
	// the minimum duration is 60 seconds. The evaluated result of the duration is
	// rounded down to the nearest whole number.
	DurationExpression *string

	// The number of seconds until the timer expires. The minimum value is 60 seconds
	// to ensure accuracy. The maximum value is 31622400 seconds.
	//
	// Deprecated: seconds is deprecated. You can use durationExpression for
	// SetTimerAction. The value of seconds can be used as a string expression for
	// durationExpression.
	Seconds *int32

	noSmithyDocumentSerde
}

// Information about the variable and its new value.
type SetVariableAction struct {

	// The new value of the variable.
	//
	// This member is required.
	Value *string

	// The name of the variable.
	//
	// This member is required.
	VariableName *string

	noSmithyDocumentSerde
}

// A rule that compares an input property value to a threshold value with a
// comparison operator.
type SimpleRule struct {

	// The comparison operator.
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// The value on the left side of the comparison operator. You can specify an AWS
	// IoT Events input attribute as an input property.
	//
	// This member is required.
	InputProperty *string

	// The value on the right side of the comparison operator. You can enter a number
	// or specify an AWS IoT Events input attribute.
	//
	// This member is required.
	Threshold *string

	noSmithyDocumentSerde
}

// Contains the configuration information of SMS notifications.
type SMSConfiguration struct {

	// Specifies one or more recipients who receive the message.
	//
	// You must [add the users that receive SMS messages to your AWS SSO store].
	//
	// [add the users that receive SMS messages to your AWS SSO store]: https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html
	//
	// This member is required.
	Recipients []RecipientDetail

	// The message that you want to send. The message can be up to 200 characters.
	AdditionalMessage *string

	// The sender ID.
	SenderId *string

	noSmithyDocumentSerde
}

// Information required to publish the Amazon SNS message.
type SNSTopicPublishAction struct {

	// The ARN of the Amazon SNS target where the message is sent.
	//
	// This member is required.
	TargetArn *string

	// You can configure the action payload when you send a message as an Amazon SNS
	// push notification.
	Payload *Payload

	noSmithyDocumentSerde
}

// Sends information about the detector model instance and the event that
// triggered the action to an Amazon SQS queue.
type SqsAction struct {

	// The URL of the SQS queue where the data is written.
	//
	// This member is required.
	QueueUrl *string

	// You can configure the action payload when you send a message to an Amazon SQS
	// queue.
	Payload *Payload

	// Set this to TRUE if you want the data to be base-64 encoded before it is
	// written to the queue. Otherwise, set this to FALSE.
	UseBase64 *bool

	noSmithyDocumentSerde
}

// Contains information about your identity source in AWS Single Sign-On. For more
// information, see the [AWS Single Sign-On User Guide].
//
// [AWS Single Sign-On User Guide]: https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html
type SSOIdentity struct {

	// The ID of the AWS SSO identity store.
	//
	// This member is required.
	IdentityStoreId *string

	// The user ID.
	UserId *string

	noSmithyDocumentSerde
}

// Information that defines a state of a detector.
type State struct {

	// The name of the state.
	//
	// This member is required.
	StateName *string

	// When entering this state, perform these actions if the condition is TRUE.
	OnEnter *OnEnterLifecycle

	// When exiting this state, perform these actions if the specified condition is
	// TRUE .
	OnExit *OnExitLifecycle

	// When an input is received and the condition is TRUE, perform the specified
	// actions .
	OnInput *OnInputLifecycle

	noSmithyDocumentSerde
}

// Metadata that can be used to manage the resource.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies the actions performed and the next state entered when a condition
// evaluates to TRUE.
type TransitionEvent struct {

	// Required. A Boolean expression that when TRUE causes the actions to be
	// performed and the nextState to be entered.
	//
	// This member is required.
	Condition *string

	// The name of the transition event.
	//
	// This member is required.
	EventName *string

	// The next state to enter.
	//
	// This member is required.
	NextState *string

	// The actions to be performed.
	Actions []Action

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
