---
stage: Govern
group: Compliance
info: "To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments"
---

<!--
  This documentation is auto generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  bundle exec rake gitlab:audit_event_types:compile_docs

  To make changes to the output of the Rake task,
  edit `tooling/audit_events/docs/templates/audit_event_types.md.erb`.
-->

# Audit event types

DETAILS:
**Tier:** Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

Audit event types are used to filter streamed audit events:

- [For instances](../../administration/audit_event_streaming/index.md#update-event-filters).
- [For top-level groups](audit_event_streaming.md#update-event-filters)

Every audit event is associated with an event type. Audit event types can allow audit events to be:

- Saved to the database. Available in the Premium and Ultimate tier. You can retrieve audit events associated with these
  types by using the audit events dashboard or the [audit events API](../../api/audit_events.md).
- Streamed to external destinations. Available in the Ultimate tier. You can stream audit events associated with these
  types to external destinations if a destination is set.

Some audit event types don't allow saving audit events to the database. Other audit event types don't allow streaming
audit events to external destinations.

An audit event type's scope limits the availability of the audit event type to either:

- [Project, group, or user](audit_events.md) audit events.
- [Instance](../../administration/audit_event_reports.md) audit events.

## Available audit event types

Audit event types belong to the following product categories.

### Ai framework

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`duo_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145509) | GitLab Duo Features enabled setting on group or project changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/442485) | Group, Project |

### Audit events

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132443) | Triggered when Amazon S3 configuration for audit events streaming is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133695) | Triggered when Amazon S3 configuration for audit events streaming is deleted. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133691) | Triggered when Amazon S3 configuration for audit events streaming is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`audit_events_streaming_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | Triggered when a streaming header for audit events is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`audit_events_streaming_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | Triggered when a streaming header for audit events is deleted. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`audit_events_streaming_instance_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125870) | Triggered when a streaming header for instance level external audit event destination is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`audit_events_streaming_instance_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | Triggered when a streaming header for instance level external audit event destination is deleted. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`audit_events_streaming_instance_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | Triggered when a streaming header for instance level external audit event destination is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`create_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | Event triggered when an external audit event destination is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`create_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136047) | Event triggered when a namespace filter for an external audit event destination for a top-level group is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/424176) | Group |
| [`create_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123882) | Event triggered when an external audit event destination for an instance is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`created_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147888) | Triggered when an external audit event destination for a top-level group is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`created_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | Triggered when a namespace filter for an external audit event destination for a top-level group is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | Group |
| [`created_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148383) | Triggered when an external audit event destination for an instance is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |
| [`created_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | Triggered when a namespace filter for an external audit event destination for an instance is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | Instance |
| [`delete_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136302) | Triggered when a namespace filter for an external audit event destination for a top-level group is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/424177) | Group |
| [`deleted_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148738) | Triggered when an external audit event destination for a top-level group is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`deleted_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | Triggered when a namespace filter for an external audit event destination for a top-level group is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | Group |
| [`deleted_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/14910) | Triggered when an external audit event destination for a GitLab instance is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |
| [`deleted_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | Triggered when a namespace filter for an external audit event destination for a GitLab instance is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | Instance |
| [`destroy_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | Triggered when an external audit event destination is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`destroy_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | Triggered when an instance level external audit event destination is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`event_type_filters_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113081) | Triggered when a new audit events streaming event type filter is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | Group |
| [`event_type_filters_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113489) | Triggered when an audit events streaming event type filter is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | Group |
| [`google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Triggered when Google Cloud Logging configuration is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Triggered when Google Cloud Logging configuration is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Triggered when Google Cloud Logging configuration is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`instance_amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137651) | Triggered when instance Amazon S3 configuration for audit events streaming is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138318) | Triggered when instance-level Amazon S3 configuration for audit events streaming is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138310) | Triggered when instance-level Amazon S3 configuration for audit events streaming is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130663) | Triggered when instance-level Google Cloud Logging configuration is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423038) | Instance |
| [`instance_google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131752) | Triggered when instance-level Google Cloud Logging configuration is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423040) | Instance |
| [`instance_google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131790) | Triggered when instance-level Google Cloud Logging configuration is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423039) | Instance |
| [`update_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | Event triggered when an external audit event destination is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`update_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | Event triggered when an instance level external audit event destination is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`updated_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148388) | Event triggered when an external audit event destination for a top-level group is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`updated_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149104) | Event triggered when an external audit event destination for a GitLab instance is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |

### Authorization

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`secure_ci_job_token_policies_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170930) | Event triggered when permissions are updated for a CI_JOB_TOKEN scope | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/495144) | Project |

### Build artifacts

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`job_artifact_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129608) | Triggered when a user downloads a job artifact from a project | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/250663) | Project |

### Code review

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`delete_merge_request`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | Triggered when a merge request is successfully deleted | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |

### Code review workflow

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`merge_request_approval_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92983) | Triggered when a merge request is approved | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/10869) | Project |
| [`merge_request_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | Triggered when a merge request is closed using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | Triggered when a merge request is created using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_invalid_approver_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | Triggered for an invalid rule when merge request is approved | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | Project |
| [`merge_request_merged_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | Triggered when a merge request is merged using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | Triggered when a merge request is reopened using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`project_merge_requests_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Triggered when an merge request template for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`project_remove_source_branch_after_merge_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | Triggered when a project has its setting to remove branches after merges updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`project_reset_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66234) | Triggered when a project has its setting on whether approvals are reset on a push is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.2](https://gitlab.com/gitlab-org/gitlab/-/issues/336211) | Project |
| [`selective_code_owner_removals_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148743) | Event triggered when selective code owner removal is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/327562) | Project |

### Code suggestions

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`project_suggestion_commit_message_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | Triggered when a project has its suggested commit message updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |

### Compliance management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`add_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | Triggered when a GPG key is added. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | User |
| [`allow_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Triggered when 'Prevent approval by author' setting is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`allow_committer_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Triggered when 'Prevent approvals by users who add commits' setting is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`allow_overrides_to_approver_list_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Triggered when 'Prevent editing approval rules in projects and merge requests' setting is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`audit_events_streaming_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | Triggered when a streaming header for audit events is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`compliance_framework_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | Triggered when a compliance framework is applied to a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | Project |
| [`compliance_framework_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65343) | Triggered when a compliance framework is removed from a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/329362) | Project |
| [`compliance_framework_id_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/94711) | Triggered when a compliance framework is updated for a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369310) | Project |
| [`compliance_framework_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | Triggered when a compliance framework is removed from a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | Project |
| [`create_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | Triggered on when a compliance framework is successfully created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`create_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Triggered when an external status check is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`created_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485) | Triggered when a requirement is added to a compliance framework | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | Group |
| [`delete_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Triggered when an external status check is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`destroy_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | Triggered when a compliance framework is successfully deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`email_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | Triggered when an email is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`email_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | Triggered when an email is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`external_status_check_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106095) | Triggered when the name of an external status check is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369333) | Project |
| [`external_status_check_url_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Triggered when the URL that is used for external status checks for a pipeline is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`group_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | Triggered when a group is marked for deletion | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | Triggered when a group is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | Triggered when a group is restored | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_saml_provider_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | Triggered when a group SAML provider is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | Group |
| [`group_saml_provider_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | Triggered when a group SAML provider is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | Group |
| [`inactive_project_scheduled_for_deletion`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130699) | Triggered when an inactive project is scheduled for deletion | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423263) | Project |
| [`member_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | Triggered when a membership is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |
| [`member_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | Triggered when a membership is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |
| [`member_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | Triggered when a membership is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |
| [`merge_request_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90911) | Triggered when a merge request is created | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/367239) | Project |
| [`merge_request_merged`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164846) | When a merge request is merged | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/442279) | Project |
| [`omniauth_login_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | Triggered when an OmniAuth login fails | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`password_reset_requested`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114548) | Triggered when a user requests a password reset using a registered email address | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`personal_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | Triggered when a user creates a personal access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | User |
| [`personal_access_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | Triggered when a personal access token is revoked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | User |
| [`project_archived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | Triggered when a project is archived | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | Triggered when a project is marked for deletion | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | Triggered when a project is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Group |
| [`project_export_file_download_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | Triggered when a download of a project export file is started | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | Triggered when a group is invited to a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Group |
| [`project_group_link_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | Triggered when a project group link is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Group |
| [`project_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | Triggered when a project group link is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Project |
| [`project_imported`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | Triggered when a project is imported | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Group |
| [`project_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | Triggered when a project is restored | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_topics_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154158) | Triggered when a project's topics assignments are changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/343204) | Project |
| [`project_unarchived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | Triggered when a project is unarchived | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`protected_branch_allow_force_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68869) | Triggered when a protected branch has its ability to allow force pushes is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/338873) | Project |
| [`public_repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149842) | Triggered when a Git repository for a public project is downloaded | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/383218) | Project |
| [`registration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | Triggered when a user registers for instance access | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`release_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | Triggered when a release is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_deleted_audit_event`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | Triggered when a release is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_milestones_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | Triggered when a release's associated milestones are updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | Triggered when a release is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`remove_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | Triggered when a GPG key is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | User |
| [`repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111218) | Triggered when a Git repository for a private or internal project is downloaded | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374108) | Project |
| [`require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Triggered when require user password for approvals from group merge request setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`retain_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Triggered when require new approvals when new commits are added to an MR from group merge request setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`saml_group_links_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | Triggered when a SAML Group Link is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | Group |
| [`saml_group_links_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | Triggered when a SAML Group Link is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | Group |
| [`smartcard_authentication_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/8120) | Triggered when a user authenticates with smartcard | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/726) | User |
| [`update_approval_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | Event triggered on updating a merge approval rule | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | Project |
| [`update_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | Triggered when a compliance framework is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`update_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Event triggered when an external status check is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |

### Container registry

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`container_repository_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156037) | Triggered when a container repository is first pushed to the registry | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | Triggered when a project's container registry is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | Triggered when a project's container repository is marked for deletion | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_tags_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156066) | Triggered when a project's container repository tag is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |

### Continuous-integration

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`multi_project_downstream_pipeline_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168626) | Triggered when multi project downstream pipeline is created | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | Project |

### Continuous delivery

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`deploy_key_added`](https://gitlab.com/gitlab-org/gitlab/-/commit/08586a616909c7f9efe2210c2b74fd3422d4eb62) | Triggered when a deploy key is added | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_key_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92219) | Triggered when a deploy key is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | Triggered when a deploy token is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | Triggered when a deploy token fails to create | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | Triggered when a deploy token is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | Triggered when a project deploy token is revoked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deployment_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | Triggered when a deployment is approved | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | Project |
| [`deployment_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | Triggered when a deployment is rejected | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | Project |
| [`deployment_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156111) | Triggered when a deployment to a protected environment is started | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/456687) | Project |
| [`group_deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | Triggered when a group deploy token is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | Triggered when creating a group deploy token failed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | Triggered when a group deploy token is destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | Triggered when a group deploy token is revoked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |

### Continuous integration

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`allow_merge_on_skipped_pipeline_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | Triggered when 'Skipped pipelines are considered successful' setting is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`ci_group_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is created for a group | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_group_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is deleted for a group | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_group_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is updated for a group | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_instance_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | Triggered when a CI/CD variable is created for an instance | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_instance_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | Triggered when a CI/CD variable is deleted for an instance | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_instance_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | Triggered when a CI/CD variable is updated for an instance | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is created for a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`ci_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is deleted for a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`ci_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | Triggered when a CI/CD variable is updated for a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`destroy_pipeline`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135255) | Triggered when a pipeline is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/339041) | Project |

### Deployment management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`cluster_agent_create_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | Triggered when a user attempts to create a cluster agent but it failed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | Triggered when a user creates a cluster agent | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_delete_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | Triggered when a user attempts to delete a cluster agent but it failed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | Triggered when a user deletes a cluster agent | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | Triggered when a user creates a cluster agent token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | Project |
| [`cluster_agent_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | Triggered when a user revokes a cluster agent token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | Project |

### Dynamic application security testing

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`dast_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | Triggered when a dynamic application security testing profile is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | Triggered when a dynamic application security profile is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_profile_schedule_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68046) | Triggered when a dynamic application security testing profile schedule is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | Project |
| [`dast_profile_schedule_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66445) | Triggered when a dynamic application security testing profile schedule is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | Project |
| [`dast_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | Triggered when a dynamic application security profile is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | Triggered when a dynamic application security testing scanner profile is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | Triggered when a dynamic application security testing scanner profile is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | Triggered when a dynamic application security testing scanner profile is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | Triggered when a dynamic application security testing site profile is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | Triggered when a dynamic application security testing site profile is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | Triggered when a dynamic application security testing site profile is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |

### Environment management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`environment_protected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | Triggered when a protected environment is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | Group, Project |
| [`environment_unprotected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | Triggered when a protected environment is unprotected | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | Group, Project |
| [`protected_environment_approval_rule_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when an approval rule is added to a protected environment | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when an approval rule is removed from a protected environment | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project, Group |
| [`protected_environment_approval_rule_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when an approval rule of a protected environment is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project, Group |
| [`protected_environment_deploy_access_level_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when a deploy access level is added to a protected environment | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_deploy_access_level_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when a deploy access level is removed from a protected environment | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_deploy_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when a deploy access level of a protected environment is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project |
| [`protected_environment_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | Triggered when a protected environment is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |

### Feature flags

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`feature_flag_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | Triggered when a feature flag is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |
| [`feature_flag_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | Triggered when a feature flag is deleted. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |
| [`feature_flag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | Triggered when a feature flag is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |

### Fleet visibility

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`ci_runner_usage_export`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139578) | Triggered when a runner usage report is generated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/426560) | Instance |

### Fuzz testing

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`coverage_fuzzing_corpus_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71992) | Event triggered on a corpus action is added | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.5](https://gitlab.com/gitlab-org/gitlab/-/issues/341485) | Project |

### Groups and projects

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`allow_mfa_for_subgroups_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting for Subgroups can set up their own two-factor authentication rules updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`allow_runner_registration_token_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Allow members of projects and groups to create runners with runner registration tokens is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`allowed_email_domain_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166105) | Triggered when group setting allowed email domain entry is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`create_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | Triggered when an SSH certificate is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | Group |
| [`default_branch_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when default branch name for the group repository is changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`delete_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | Triggered when an SSH certificate is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | Group |
| [`disable_personal_access_tokens_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Disable personal access tokens is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`emails_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Enable email notifications is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`enabled_git_access_protocol_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Enabled Git access protocols is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`enforce_ssh_certificates_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Enforce SSH Certificates is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121005) | Triggered when a group is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/411595) | Group |
| [`group_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | Triggered when group description is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_lfs_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when LFS enabled for a group is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_membership_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when membership lock for a group is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_mentions_disabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when a group's setting to notify group members on group mention is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_merge_request_approval_setting_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87880) | Triggered when merge request approval settings are added to a group | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/356152) | Group |
| [`group_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's name is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369320) | Group |
| [`group_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's path is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369321) | Group |
| [`group_project_creation_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's project creation level is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369327) | Group |
| [`group_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's repository size limit is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | Group |
| [`group_request_access_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's request access enabled is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_require_two_factor_authentication_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's require two factor authentication setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369325) | Group |
| [`group_share_with_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | Triggered when you invite a group to another group by using the group's membership page | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_share_with_group_link_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | Triggered when you remove a group from another group by using the group's membership page | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_share_with_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | Triggered when you update a group's access settings to another group by using the group's membership page | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_shared_runners_minutes_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's shared runners minutes limit is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369324) | Group |
| [`group_shared_with_group_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | Triggered when group can be shared with other group setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_two_factor_grace_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's two factor grace period is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369326) | Group |
| [`group_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Triggered when a group's visibility level is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | Group |
| [`merge_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | Triggered when merge commit template is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | Project |
| [`new_user_signups_cap_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Number of users for user cap is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`prevent_forking_outside_group_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting for Prevent forking outside current group is changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`prevent_sharing_groups_outside_hierarchy_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when a group's setting to Members cannot invite groups outside of group and its sugroup updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`project_cicd_merge_pipelines_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | Triggered when the CI/CD merge pipelines setting for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | Project |
| [`project_cicd_merge_trains_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | Triggered when the CI/CD merge trains settings for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | Project |
| [`project_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | Triggered when a project is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_default_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | Triggered when default branch of a project's repository is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128978) | Triggered when a project's description is updated | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377769) | Project |
| [`project_disable_overriding_approvers_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when the disable overriding approvers per MR setting for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_feature_analytics_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's analytics access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369299) | Project |
| [`project_feature_builds_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's builds access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369294) | Project |
| [`project_feature_container_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's container registry access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369303) | Project |
| [`project_feature_environments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's environments access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369307) | Project |
| [`project_feature_feature_flags_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's feature flags access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369306) | Project |
| [`project_feature_forking_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's feature forking access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369290) | Project |
| [`project_feature_infrastructure_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's infrastructure access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369305) | Project |
| [`project_feature_issues_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's issues access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |
| [`project_feature_merge_requests_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's merge request access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |
| [`project_feature_metrics_dashboard_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's metrics dashboard access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |
| [`project_feature_monitor_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's monitor access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369304) | Project |
| [`project_feature_operations_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's operation access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369300) | Project |
| [`project_feature_package_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's package registry access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369296) | Project |
| [`project_feature_pages_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's page access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369297) | Project |
| [`project_feature_releases_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's releases access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369308) | Project |
| [`project_feature_repository_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's repository access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369295) | Project |
| [`project_feature_requirements_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's requirements access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369301) | Project |
| [`project_feature_security_and_compliance_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's security and compliance access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369302) | Project |
| [`project_feature_snippets_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's snippet access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369293) | Project |
| [`project_feature_wiki_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | Triggered when a project's wiki access level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369292) | Project |
| [`project_merge_method_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | Triggered when a project's merge request method is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`project_merge_requests_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's MR author approval setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_merge_requests_disable_committers_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's setting for disabling committers approval on merge requests is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369277) | Project |
| [`project_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | Triggered when a project has its name updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [10.2](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | Project |
| [`project_namespace_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when project's namespace is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_only_allow_merge_if_all_discussions_are_resolved_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's setting for allowing merge only when all discussions are resolved is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369286) | Project |
| [`project_only_allow_merge_if_pipeline_succeeds_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's only allow merge if pipeline succeeds setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_packages_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/7962) | Triggered when the setting that controls packages for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [11.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100770) | Triggered when a project's path is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369271) | Project |
| [`project_printing_merge_request_link_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when setting for projects for enabling printing merge request link is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369283) | Project |
| [`project_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when the repository size limit of a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369274) | Project |
| [`project_require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's setting for requiring a user's password for approval of merge request is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369280) | Project |
| [`project_resolve_outdated_diff_discussions_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's resolve outdated diff discussions setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_security_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150767) | Triggered when a project's security setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/457024) | Project |
| [`project_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | Triggered when a project's visibility level setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`remove_dormant_members_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Days of inactivity before removal is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`remove_dormant_members_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Dormant members is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`resource_access_token_creation_allowed_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting for Users can create project access tokens and group access tokens in this group is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`runner_registration_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Runner registration is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`seat_control_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Seat control is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`service_access_tokens_expiration_enforced_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Service account token expiration is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`show_diff_preview_in_email_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Triggered when setting Email notification to include diff preview is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`squash_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | Triggered when the merge request squash commit template for a project is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | Project |
| [`squash_option_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Triggered when squash option setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |

### Importers

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`group_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | Triggered when a group file export is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | Group |
| [`project_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | Triggered when a project file export is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | Project |

### Incident management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`incident_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an incident is closed using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`incident_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an incident is created using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`incident_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an incident is reopened using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### MLOps

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`project_feature_model_experiments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121027) | Triggered when a project's model experiments access level is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/412384) | Project |
| [`ml_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | ML model is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | ML model destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_version_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | ML model version is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_version_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | ML model version destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`project_feature_model_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138399) | Model registry access level was updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/412734) | Project |

### Not categorized

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`experiment_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118222) | Triggered when enabling experiment AI features setting is toggled | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/404856/) | Group |

### Permissions

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`member_role_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137087) | Triggered when a custom role is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/388934) | Group, Instance |
| [`member_role_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | Triggered when a custom role is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | Group, Instance |
| [`member_role_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | Triggered when a custom role is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | Group, Instance |

### Portfolio management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`delete_epic`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | Triggered when an epic is successfully deleted | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Group |
| [`epic_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an epic is closed by a group access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |
| [`epic_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an epic is created by a group access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |
| [`epic_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an epic is reopened by a group access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |

### Product analytics data management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`product_analytics_settings_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154101) | Triggered when product analytics settings are changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/463318) | Project |

### Project

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`project_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when a project access token is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when creating a project access token fails | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when a project access token is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when deleting a project access token fails | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |

### Quality management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`test_case_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a test case is closed using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`test_case_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a test case is created using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`test_case_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a test case is reopened using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### Runner

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`set_runner_associated_projects`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/97666) | Triggered when associated projects are successfully assigned to a CI/CD runner | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/359958) | User |

### Secret detection

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`project_security_exclusion_applied`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | Triggered when a project security exclusion is applied in one of the security scanners | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/492465) | Project |
| [`project_security_exclusion_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | Triggered when a project security exclusion is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`project_security_exclusion_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | Triggered when a project security exclusion is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`project_security_exclusion_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | Triggered when a project security exclusion is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`skip_secret_push_protection`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147855) | Triggered when secret push protection is skipped by the user | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/441185) | Project |

### Secrets management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`user_authenticated_using_job_token`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164546) | Triggered when a user is authenticated using job token | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | Project |

### Security policy management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`policy_project_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102154) | Triggered when the security policy project is updated for a project | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/377877) | Group, Project |

### Self-hosted models

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`self_hosted_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165303) | A new self-hosted model configuration was added | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165321) | A new self-hosted model configuration was destroyed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_feature_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165489) | A self-hosted model feature had its configuration changed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Instance |
| [`self_hosted_model_terms_accepted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165480) | Terms for usage of self-hosted models were accepted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165520) | A self-hosted model configuration was updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/483295) | Instance |

### Source code management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`approval_rule_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | Triggered when a merge request approval rule is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | Project |
| [`approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82297) | Triggered when a merge request approval rule is deleted. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/329514) | Project |
| [`group_push_rules_author_email_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for author email regex | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369343) | Group |
| [`group_push_rules_branch_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for branch name regex | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369340) | Group |
| [`group_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group's push rule setting is updated for reject unverified users | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_commit_message_negative_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for commit message negative regex | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369342) | Group |
| [`group_push_rules_commit_message_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for commit message regex | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369341) | Group |
| [`group_push_rules_file_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for filename regex | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369344) | Group |
| [`group_push_rules_max_file_size_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | Triggered when a group's push rules settings is changed for max file size | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369345) | Group |
| [`group_push_rules_prevent_secrets_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group's push rule setting is updated to prevent pushing secret files | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_deny_delete_tag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group's push rule setting is updated to deny deletion of tags using Git push | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_member_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group's push rule setting is updated to check if commit author is a GitLab user | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_non_dco_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group's push rule setting is updated for reject non DCO certified commits | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_unsigned_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | Triggered when a group push's rule setting is updated for reject unsigned commits | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`merged_merge_request_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | Triggered when a merged merge request is deleted | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | Project |
| [`merged_merge_request_deletion_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | Triggered when a merged merge request's deletion is started | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | Project |
| [`project_fork_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | Triggered when a project is forked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | Project |
| [`project_fork_relationship_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/101017) | Triggered when a project's fork relationship is successfully removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/272532) | Project |
| [`project_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132157) | Triggered when a project's push rule setting for reject unverified users is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`protected_branch_code_owner_approval_required_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | Triggered when the protected branch code owner approval required setting is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | Project |
| [`protected_branch_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | Triggered when a protected branch is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | Project |
| [`protected_branch_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | Triggered when a protected branch is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | Project |
| [`protected_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | Triggered when the setting for protected branches is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | Project |
| [`repository_git_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76719) | Triggered when authenticated users push, pull, or clone a project using SSH, HTTP(S), or the UI | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373950) | Project |
| [`require_reauthentication_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150710) | Triggered when the setting for requiring reauthentication for merge requqest approvals is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/431346) | Group, Project |
| [`manually_trigger_housekeeping`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112095) | Triggered when manually triggering housekeeping via API or admin UI | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/390761) | Project |
| [`project_blobs_removal`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | Triggered when removing blobs via the GraphQL API or project settings UI | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | Project |
| [`project_text_replacement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | Triggered when replacing text via the GraphQL API or project settings UI | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | Project |

### System access

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`application_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124639) | Triggered when an application setting is updated. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/282428) | Instance |
| [`group_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when a group access token is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when creating a group access token failed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when a group access token is deleted | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Triggered when deleting a group access token failed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`ip_restrictions_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86037) | Event triggered on any changes in the IP allowlist | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/358986) | Group |
| [`login_failed_with_otp_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Triggered when sign-in fails because of an incorrect OTP | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | User |
| [`login_failed_with_standard_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Triggered when sign-in to GitLab fails with standard authentication, such as password | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | Instance |
| [`login_failed_with_webauthn_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Triggered when sign-in fails when using a WebAuthn device | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | User |
| [`update_mismatched_group_saml_extern_uid`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104791) | Triggered when the external UID is changed on a SAML identity. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/382256) | User |
| [`user_access_locked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124169) | Event triggered when user access to the instance is locked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | User |
| [`user_access_unlocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124973) | Event triggered when user access to the instance is unlocked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | User |
| [`user_disable_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89598) | Audit event triggered when user disables two factor authentication. Group scope was [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171988) in GitLab 17.6. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/238177) | User, Group |
| [`user_enable_admin_mode`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104754) | Event triggered on enabling Admin Mode | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/362101) | User |

### Team planning

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`comment_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | Triggered when a comment is added to an issue or a merge request when using a project access token | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`delete_issue`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | Triggered when an issue is successfully deleted | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |
| [`delete_work_item`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | Triggered when a work item is successfully deleted | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |
| [`issue_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an issue is closed using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`issue_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an issue is created using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`issue_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when an issue is reopened using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`task_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a task is closed using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`task_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a task is created using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`task_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | Triggered when a task is reopened using a project access token | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### User management

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`authenticated_with_group_saml`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/28575) | Triggered when successfully signing in with SAML authentication. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [12.10](https://gitlab.com/gitlab-org/gitlab/-/issues/35710) | Group |
| [`ban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116103) | Triggered when a user is banned, unbanned, blocked, or unblocked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`change_membership_state`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87924) | Triggered when a user's membership is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/362200) | Group |
| [`password_reset_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129079) | Triggered when a password reset fails for a user | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377762) | User |
| [`unban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116221) | Event triggered on user unban action | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`unblock_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115727) | Event triggered on user unblock action | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`user_activate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121708) | Event triggered on user activate action | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | User |
| [`user_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | Event triggered when a user is approved for an instance | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_blocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | Event triggered when a user is blocked | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | Event triggered when a user is created | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_deactivate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117776) | Event triggered on user deactivate action | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | User |
| [`user_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | Event triggered when a user is scheduled for removal from the instance. Group and Project scopes were [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167021) in GitLab 17.5. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User, Group, Project |
| [`user_email_changed_and_user_signed_in`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106090) | audit when user emailed changed and user signed in | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369331) | User |
| [`user_impersonation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79340) | Triggered when an instance administrator starts or stops impersonating a user | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.8](https://gitlab.com/gitlab-org/gitlab/-/issues/300961) | User, Group |
| [`user_password_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | audit when user password is updated | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369330) | User |
| [`user_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | Event triggered when a user registration is rejected | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |

### User profile

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`email_confirmation_sent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129261) | Triggered when users add or change an email address and it must be confirmed | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377625) | User |
| [`remove_ssh_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65615) | Triggered when a SSH key is removed | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/220127) | User |
| [`user_admin_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65168) | Adds an audit event when a user is either made an administrator, or removed as an administrator | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323905) | User |
| [`user_auditor_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136456) | Adds an audit event when a user is either made an auditor, or removed as an auditor | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/430235) | User |
| [`user_email_address_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/2103) | Adds an audit event when a user updates their email address | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [10.1](https://gitlab.com/gitlab-org/gitlab-ee/issues/1370) | User |
| [`user_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167484) | Event triggered on updating a user's name | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | User |
| [`user_profile_visiblity_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | Triggered when user toggles private profile user setting | **{dotted-circle}** No | **{check-circle}** Yes | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | User |
| [`user_username_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | Event triggered on updating a user's username | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369329) | User |

### Verify security

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`secure_ci_job_token_group_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | Triggered when group added to CI_JOB_TOKEN scope | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | Project |
| [`secure_ci_job_token_group_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | Triggered when group removed from CI_JOB_TOKEN scope | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | Project |
| [`secure_ci_job_token_inbound_disabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Triggered when CI_JOB_TOKEN permissions disabled for inbound | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_inbound_enabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Triggered when CI_JOB_TOKEN permissions enabled for inbound | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_project_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Triggered when project added to inbound CI_JOB_TOKEN scope | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_project_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Triggered when project removed from inbound CI_JOB_TOKEN scope | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |

### Webhooks

| Name | Description | Saved to database | Streamed | Introduced in | Scope |
|:------------|:------------|:------------------|:---------|:--------------|:--------------|
| [`webhook_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154046) | Event triggered when a webhook is created. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/8068) | Project, Group, Instance |
| [`webhook_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102342) | Event triggered when a webhook is destroyed. | **{check-circle}** Yes | **{check-circle}** Yes | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/458817) | Project, Group, Instance |
