---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Improper neutralization of special elements in data query logic

## Description

The application generates a query intended to interact with MongoDB,
but it does not neutralize or incorrectly neutralizes special elements
that can modify the intended logic of the query.

## Remediation

Refactor find or search queries to use standard
filtering operators such as `$gt` or `$in` instead of broad operators such
as `$where`. If possible, disable the MongoDB JavaScript interface entirely.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 943.1 | false | 943 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/943.html)
- [Disabling MongoDB Server Side JS](https://www.mongodb.com/docs/manual/core/server-side-javascript/#std-label-disable-server-side-js)
