# frozen_string_literal: true

class PrepareIndexVulnerabilityOccurrenceIdentifiersOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.3'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_occurrence_identifiers_on_project_id'

  def up
    prepare_async_index :vulnerability_occurrence_identifiers, :project_id, name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_occurrence_identifiers, INDEX_NAME
  end
end
