# frozen_string_literal: true

class RemoveIndexVulnerabilityOccurrencesOnPrimaryIdentifierId < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.3'

  INDEX_NAME = 'index_vulnerability_occurrences_on_primary_identifier_id'
  TABLE_NAME = :vulnerability_occurrences

  def up
    # This index was replaced with index_vulnerability_occurrences_prim_iden_id_and_vuln_id
    # see https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156266
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, [:primary_identifier_id], name: INDEX_NAME
  end
end
