# frozen_string_literal: true

class FinalizeFixCorruptedScannerIdsOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  MIGRATION = "FixCorruptedScannerIdsOfVulnerabilityReads"

  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  milestone '17.1'

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION,
      table_name: :vulnerability_reads,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down
    # no-op
  end
end
