#pragma once

#include <stdint.h>
#include <stdbool.h>
#include <xkbcommon/xkbcommon.h>

struct kitty_key_data {
    xkb_keysym_t sym;
    uint16_t key;
    uint8_t final:7;
    bool is_modifier:1;
} __attribute__((packed));

_Static_assert(sizeof(struct kitty_key_data) == 7, "bad size");

/* Note! *Must* Be kept sorted (on 'sym') */
static const struct kitty_key_data kitty_keymap[] = {
    {XKB_KEY_ISO_Level3_Shift, 57453, 'u', true},
    {XKB_KEY_ISO_Level5_Shift, 57454, 'u', true},
    {XKB_KEY_ISO_Left_Tab, 9,     'u', false},

    {XKB_KEY_BackSpace,    127,   'u', false},
    {XKB_KEY_Tab,          9,     'u', false},
    {XKB_KEY_Return,       13,    'u', false},
    {XKB_KEY_Pause,        57362, 'u', false},
    {XKB_KEY_Scroll_Lock,  57359, 'u', false},
    {XKB_KEY_Escape,       27,    'u', false},
    {XKB_KEY_Home,         1,     'H', false},
    {XKB_KEY_Left,         1,     'D', false},
    {XKB_KEY_Up,           1,     'A', false},
    {XKB_KEY_Right,        1,     'C', false},
    {XKB_KEY_Down,         1,     'B', false},
    {XKB_KEY_Prior,        5,     '~', false},
    {XKB_KEY_Next,         6,     '~', false},
    {XKB_KEY_End,          1,     'F', false},
    {XKB_KEY_Print,        57361, 'u', false},
    {XKB_KEY_Insert,       2,     '~', false},
    {XKB_KEY_Menu,         57363, 'u', false},
    {XKB_KEY_Num_Lock,     57360, 'u', true},

    {XKB_KEY_KP_Enter,     57414, 'u', false},
    {XKB_KEY_KP_Home,      57423, 'u', false},
    {XKB_KEY_KP_Left,      57417, 'u', false},
    {XKB_KEY_KP_Up,        57419, 'u', false},
    {XKB_KEY_KP_Right,     57418, 'u', false},
    {XKB_KEY_KP_Down,      57420, 'u', false},
    {XKB_KEY_KP_Prior,     57421, 'u', false},
    {XKB_KEY_KP_Next,      57422, 'u', false},
    {XKB_KEY_KP_End,       57424, 'u', false},
    {XKB_KEY_KP_Begin,     1,     'E', false},
    {XKB_KEY_KP_Insert,    57425, 'u', false},
    {XKB_KEY_KP_Delete,    57426, 'u', false},
    {XKB_KEY_KP_Multiply,  57411, 'u', false},
    {XKB_KEY_KP_Add,       57413, 'u', false},
    {XKB_KEY_KP_Separator, 57416, 'u', false},
    {XKB_KEY_KP_Subtract,  57412, 'u', false},
    {XKB_KEY_KP_Decimal,   57409, 'u', false},
    {XKB_KEY_KP_Divide,    57410, 'u', false},
    {XKB_KEY_KP_0,         57399, 'u', false},
    {XKB_KEY_KP_1,         57400, 'u', false},
    {XKB_KEY_KP_2,         57401, 'u', false},
    {XKB_KEY_KP_3,         57402, 'u', false},
    {XKB_KEY_KP_4,         57403, 'u', false},
    {XKB_KEY_KP_5,         57404, 'u', false},
    {XKB_KEY_KP_6,         57405, 'u', false},
    {XKB_KEY_KP_7,         57406, 'u', false},
    {XKB_KEY_KP_8,         57407, 'u', false},
    {XKB_KEY_KP_9,         57408, 'u', false},
    {XKB_KEY_KP_Equal,     57415, 'u', false},

    {XKB_KEY_F1,           1,     'P', false},
    {XKB_KEY_F2,           1,     'Q', false},
    {XKB_KEY_F3,           13,    '~', false},
    {XKB_KEY_F4,           1,     'S', false},
    {XKB_KEY_F5,           15,    '~', false},
    {XKB_KEY_F6,           17,    '~', false},
    {XKB_KEY_F7,           18,    '~', false},
    {XKB_KEY_F8,           19,    '~', false},
    {XKB_KEY_F9,           20,    '~', false},
    {XKB_KEY_F10,          21,    '~', false},
    {XKB_KEY_F11,          23,    '~', false},
    {XKB_KEY_F12,          24,    '~', false},
    {XKB_KEY_F13,          57376, 'u', false},
    {XKB_KEY_F14,          57377, 'u', false},
    {XKB_KEY_F15,          57378, 'u', false},
    {XKB_KEY_F16,          57379, 'u', false},
    {XKB_KEY_F17,          57380, 'u', false},
    {XKB_KEY_F18,          57381, 'u', false},
    {XKB_KEY_F19,          57382, 'u', false},
    {XKB_KEY_F20,          57383, 'u', false},
    {XKB_KEY_F21,          57384, 'u', false},
    {XKB_KEY_F22,          57385, 'u', false},
    {XKB_KEY_F23,          57386, 'u', false},
    {XKB_KEY_F24,          57387, 'u', false},
    {XKB_KEY_F25,          57388, 'u', false},
    {XKB_KEY_F26,          57389, 'u', false},
    {XKB_KEY_F27,          57390, 'u', false},
    {XKB_KEY_F28,          57391, 'u', false},
    {XKB_KEY_F29,          57392, 'u', false},
    {XKB_KEY_F30,          57393, 'u', false},
    {XKB_KEY_F31,          57394, 'u', false},
    {XKB_KEY_F32,          57395, 'u', false},
    {XKB_KEY_F33,          57396, 'u', false},
    {XKB_KEY_F34,          57397, 'u', false},
    {XKB_KEY_F35,          57398, 'u', false},

    {XKB_KEY_Shift_L,      57441, 'u', true},
    {XKB_KEY_Shift_R,      57447, 'u', true},
    {XKB_KEY_Control_L,    57442, 'u', true},
    {XKB_KEY_Control_R,    57448, 'u', true},
    {XKB_KEY_Caps_Lock,    57358, 'u', true},
    {XKB_KEY_Meta_L,       57446, 'u', true},
    {XKB_KEY_Meta_R,       57452, 'u', true},
    {XKB_KEY_Alt_L,        57443, 'u', true},
    {XKB_KEY_Alt_R,        57449, 'u', true},
    {XKB_KEY_Super_L,      57444, 'u', true},
    {XKB_KEY_Super_R,      57450, 'u', true},
    {XKB_KEY_Hyper_L,      57445, 'u', true},
    {XKB_KEY_Hyper_R,      57451, 'u', true},

    {XKB_KEY_Delete,       3,     '~', false},

    {XKB_KEY_XF86AudioLowerVolume, 57438, 'u', false},
    {XKB_KEY_XF86AudioMute,        57440, 'u', false},
    {XKB_KEY_XF86AudioRaiseVolume, 57439, 'u', false},
    {XKB_KEY_XF86AudioPlay,        57428, 'u', false},
    {XKB_KEY_XF86AudioStop,        57432, 'u', false},
    {XKB_KEY_XF86AudioPrev,        57436, 'u', false},
    {XKB_KEY_XF86AudioNext,        57435, 'u', false},
    {XKB_KEY_XF86AudioRecord,      57437, 'u', false},
    {XKB_KEY_XF86AudioPause,       57429, 'u', false},
    {XKB_KEY_XF86AudioRewind,      57434, 'u', false},
    {XKB_KEY_XF86AudioForward,     57433, 'u', false},
    //{XKB_KEY_XF86AudioPlayPause, 57430, 'u', false},
    //{XKB_KEY_XF86AudioReverse, 57431, 'u', false},
};
