#!/usr/bin/python3
"""
Module file handling for Fortran

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

import click
import logging
import magic

log = logging.getLogger("dhfortran")


@click.command()
@click.option("--sourcedir")
def dh_fortran_mod(*args, **argv):
    """Entry point for dh_fortran_mod command"""

    pass


def which_mod_version(modfile: str) -> str:
    """ """

    def parse_modfile(mf):
        try:
            magic = magic.from_file(modfile)
        except:
            raise Error(f"Can't open modfile {modfile}")
        mime = magic.split(";")[0]
        if (mime == "test/plain") or (mime == "text/x-c++"):
            with open(modfile) as mf:
                strings = mf.readstrings()
        else:
            if mime == "application/gzip":
                pass


def which_compiler(s: str) -> str:
    """Determine which compiler pkg(s) created a given mod/smod file"""
    pass
