#!/usr/bin/env python3
"""

Helpers for tests
"""


from pathlib import Path
from functools import wraps
import pytest
import os


# @contextmanager
def compiler_present(*args, **kwds):
    """Execute a given block if the named compiler is present, else skip"""
    print(f"compiler_present: args are {args}")


@pytest.fixture
def dry_run():
    os.environ["NO_ACT"] = "1"


def chdir_to_test(testdir: str):
    """Get the current folder of the test"""
    p = Path(__file__).parent.parent / testdir
    pytest.MonkeyPatch.chdir(p)


def make_testdir(dirname: str):
    pass
