NICOLA-DDSKK on Daredevil SKK 11.4
==================================

        (オリジナル)    箕浦 逸史 <minoura@eva.hi-ho.ne.jp>
        (改訂・文責)    塚本 徹雄 <czkmt@remus.dti.ne.jp>


# 1. 本文について

これは、箕浦さんが NICOLA-SKK 0.39 について解説された文章を塚本が
NICOLA-DDSKK に適合するように加筆修正したものです。もし本文に誤りがあ
れば塚本の責任ですので、その旨ご連絡下さい。


# 2. 概説

NICOLA-DDSKK とは、Daredevil SKK で NICOLA かな入力（親指シフト入力）
によって日本語入力を可能にするものです。

Daredevil SKK がサポートしている Emacsen で稼動します。


# 3. はじめに

SKK は Emacs で使える優れたかな漢字変換システムです。その SKK の独自の
入力方法を支えている漢字の部分の指定方法は、ローマ字の大文字と小文字を
使い分けて日本語を入力するというものです。これは、ローマ字入力に大きく
依存していますが、その原理自体は特にローマ字入力に依存しているわけでは
ありません。

伝統的に SKK では、漢字の部分の指定するためにシフトキーを使います。し
かし、タッチタイピングを容易にするために、NICOLA-DDSKK ではホームポジ
ションのキーである、f と j を同時に打鍵するという方法を使います。これ
によって、小指でシフトを押すよりも効率的な入力が可能になっているのでは
ないかと思います。


# 4. 注意

英語用のキーボードでは親指シフトキーとして使えるキーがないため、使用は
難しいと思われます。日本語キーボードの使用をお勧めします。

    まれに US キーボードで、space キーが半分に分かれていたり、左半分が
    backspace キーになっていたりするものがあります。そういう特殊なもの
    ならば、工夫次第で実用的親指シフトキーボードになり得るようです。

また、遅いネットワークの向こうで Emacs を立ちあげて使う場合には、同時
打鍵を正しく認識しなくなることがあります。

現在、NICOLA-DDSKK は Daredevil SKK に附属するかたちで配布されています。
必ず同梱されている Daredevil SKK と NICOLA-DDSKK とを組み合わせて使用
してください。

NICOLA-DDSKK はまだベータバージョンです。まだバグがあるかもしれません。
バグを見つけられた方は報告をお願いします。


# 5. 著作権など

SKK NICOLA patch は SKK をもとに箕浦さんが作成されたものです。その著作
権は箕浦さんが保持されています。

Daredevil SKK の為に加筆修正した部分については、塚本が著作権を保持しま
す。また、今後 [skk-dev](https://github.com/skk-dev/ddskk/issues) にお
いて本プログラムが加筆修正された場合は、その部分の著作権はその改変を行
った方に属します。

本プログラムはフリーソフトウェアです。再配布および改変が認められますが、
その際には Free Software Foundation が公表する GNU General Public
Licence の第 3 バージョン以降 (の任意の 1 つのバージョン) の条件に従う
必要があります。

本プログラムは有用であると思われますが、その配布は無保証です。市場性ま
たは特定の目的への適合性のために通常認められるような暗黙の保証すらされ
ません。GNU General Public License を参照すればより詳しいことが分かり
ます。

Daredevil SKK とともに GNU General Public License が収録されています。
[LICENSE](../LICENSE) という名前のファイルを見てください。


# 6. インストール

[README.md](README.md) を参照してください。


# 7. 設定

基本的には [REAME.md](REAME.md) に書かれている通りです。

```
(setq skk-use-kana-keyboard t)
```

という設定は必ずします。日本語 106 キーボードの場合、
`skk-kanagaki-keyboard-type` という変数は `nicola-jis`, `oasys`, `omelet-jis`
のいずれかにすることになるでしょう。それぞれ微妙にキー配列が違います。

```
 (setq skk-kanagaki-keyboard-type 'omelet-jis)
```


# 8. 使用法

標準では、左親指キーは <kbd>無変換</kbd>、右親指キーは <kbd>変換</kbd> と
<kbd>space</kbd> に割りあてられています。

これを、例えば

  * 左親指キー => <kbd>space</kbd>

  * 右親指キー => <kbd>変換</kbd>

のように設定を変更したい場合は、~/.skk に次のような設定を書きます。

```
 (setq skk-nicola-lshift-keys '(" "))
 (setq skk-nicola-rshift-keys '([henkan]))
```

上記は XFree86 上での GNU Emacs 20.3 以降の例です。`[henkan]` の部分
が Emacs の種類によって違ってくるので以下のように変更してください。

  - Mule for Windows または Meadow … `[convert]`
  - XFree86 上での Mule2.3@19.34 … `[numbersign]`
  - XFree86 上での Mule2.3@19.28 … `[key-35]`
  - XFree86 上での Emacs 20.2 … <kbd>変換</kbd> キーが使えません。

<kbd>変換</kbd> キーや <kbd>無変換</kbd> キーが使えない環境でも xmodmap を
使うなど、仮想キーコードのレベルで設定を変更できる場合は、それによって
使用できるようにするといいでしょう。

xmodmap コマンドの使い方については割愛します。

一度 Emacs を終了し、起動しなおします。<kbd>C-x</kbd> <kbd>C-j</kbd> で
skk-mode にすると、モードラインが「かな」ではなく、「にこら」になります。
これで SKK で NICOLA 入力ができるようになります。

`skk-use-kana-keyboard` を nil にしておくと、従来通りローマ字かな変換が
使えます。

なお、SKK 使用中に仮名入力とローマ字入力を切り替えることが可能です。
<kbd>f12</kbd> キーがある場合はそれを押してみてください。ない場合は、
M-x skk-kanagaki-toggle-rom-kana を実行してみてください。このコマンドを実
行するたびに、モードラインの表示が切り替わります。

Daredevil SKK には、NICOLA 版のチュートリアルが付属しています。親指シ
フト入力の設定ができている状態で <kbd>C-x</kbd> <kbd>t</kbd> (または M-x skk-tutorial) を実
行してみてください。


# 9. キー配列

通常のコンピュータ用のキーボードのことを考えて、右シフト、スペース、変
換を一つのキーで兼用し、また左シフト、改行、確定を一つのキーで兼用しま
す。つまり左右の親指が一つずつキーを担当します。例えば omelet-jis では、
以下のようなキー配列になります。

```
┌──┬──┬──┬──┬──┐┌──┬──┬──┬──┬──┬──┬──┬──┐
│！？│“／│”〜│＃「│％」││　［│　］│【（│】）│｛『│｝』│＝‘│＿’│
│1 　│2 　│3 　│4 　│5 　││6 　│7 　│8 　│9 　│0 　│- −│^ 々│\ ￥│
├──┼──┼──┼──┼──┤├──┼──┼──┼──┼──┼──┼──┼──┘
│ゐぁ│がえ│だり│ごゃ│ざれ││ぱよ│ぢに│ぐる│づま│ぴぇ│×＠│〃゜│
│Q 。│W か│E た│R こ│T さ││Y ら│U ち│I く│O つ│P ，│@ 、│[ ゛│
├──┼──┼──┼──┼──┤├──┼──┼──┼──┼──┼──┼──┤
│ヴを│じあ│でな│げゅ│ぜも││ばみ│どお│ぎの│ぽょ│ヶっ│＊；│＋—│
│A う│S し│D て│F け│G せ││H は│J と│K き│L い│; ん│: ：│] …│
├──┼──┼──┼──┼──┤├──┼──┼──┼──┼──┼──┼──┘
│ゑぅ│びー│ずろ│ぶや│べぃ││ぷぬ│ぞゆ│ぺむ│ぼわ│ゎぉ│＿’│
│Z ．│X ひ│C す│V ふ│B へ││N め│M そ│, ね│. ほ│/ ・│\ ￥│
└──┴──┼──┴──┴──┘└──┴──┴──┼──┴──┴──┘
            │       左シフト  |   右シフト(space)│
　　　　　　└──────────────────┘
```

下の段のかなはそのまま入力し、上の段の右のかなは同じ側の親指シフトキー
を同時に押すことで入力します。たとえば「え」を入力するためには「か」の
キー (<kbd>w</kbd> のキー) と <kbd>左シフト</kbd> を同時に押します。
また濁点つきの文字を入力するためには、反対側のシフトキーと同時打鍵します。
つまり「が」を入力するためには「か」(<kbd>w</kbd> のキー) と <kbd>右シフト</kbd>
を同時に押します。

半濁点のついた文字は、以下の方法で入力できます。

- ぱ <kbd>[左シフト]</kbd> + <kbd>y</kbd>
- ぴ <kbd>[左シフト]</kbd> + <kbd>p</kbd>
- ぷ <kbd>[左シフト]</kbd> + <kbd>n</kbd>
- ぺ <kbd>[左シフト]</kbd> + <kbd>,</kbd>
- ぽ <kbd>[左シフト]</kbd> + <kbd>l</kbd>

操作の基本は SKK のものを尊重して作られています。しかしローマ字では使
わない l や q などには NICOLA では全て「かな」が割りあてられているため、
キーバインドを大幅に変更しました。

キーバインド表

 |                    | NICOLA                | ローマ字         | 変更理由など |
 |--------------------|-----------------------|------------------|--------------|
 | 変換               | <kbd>space</kbd> [右] | <kbd>space</kbd> |              |
 | 確定               | C-j                   | C-j              |              |
 | 前候補             | C-p                   | x                | かなと衝突   |
 | 次候補             | <kbd>space</kbd> [右] | <kbd>space</kbd> |              |
 | 変換開始           | [fj] Q                | Q                |              |
 | 接頭語接尾語の入力 | [gh] > < ?            | > < ?            |              |
 | abbrev-mode 開始   | [gh]                  | <kbd>/</kbd>     | かなと衝突   |

 |                  | NICOLA      | ローマ字 | 変更理由など |
 |------------------|-------------|----------|--------------|
 | かなモードへ     | C-j  [左右] | C-j      |              |
 | カタカナモードへ | [dk]        | q        | かなと衝突   |
 | 半角モードへ     | [左右] A    | l        | かなと衝突   |
 | 全英モードへ     | Z L         | L        |              |

 |              | NICOLA | ローマ字 | 変更理由など |
 |--------------|--------|----------|--------------|
 | カタカナ変換 | [dk]   | q        | かなと衝突   |
 | 全角変換     | C-q    | C-q      |              |

 |            | NICOLA         | ローマ字       | 変更理由など |
 |------------|----------------|----------------|--------------|
 | 補完の開始 | <kbd>tab</kbd> | <kbd>tab</kbd> |              |
 | 補完次候補 | <kbd>.</kbd>   | <kbd>.</kbd>   |              |
 | 補完前候補 | <kbd>,</kbd>   | <kbd>,</kbd>   |              |

 |                  | NICOLA       | ローマ字     | 変更理由など |
 |------------------|--------------|--------------|--------------|
 | 今日の日付を挿入 | <kbd>D</kbd> | <kbd>@</kbd> | かなと衝突   |
 | 文字コード表示   | <kbd>$</kbd> | <kbd>$</kbd> |              |
 | JIS コード入力   | <kbd>C</kbd> | <kbd>\\</kbd> | かなと衝突   |

よりよいキー定義があれば [skk-dev](https://github.com/skk-dev/ddskk/issues)
に提案してください。


# 10. 各種の設定

以下の変数を .skk に設定することで、NICOLA 関連の動作が制御できます。

## 10.1. skk-nicola-rshift-keys

右親指キーとして使うキーのリスト。
標準ではスペースキーと変換キー。
変換キーを表すシンポルは Emacs の種類によって色々なので注意が必要。

- Mule for Windows または Meadow … `[convert]`
- XFree86 上での GNU Emacs 20.3 以降 … `[henkan]`
- XFree86 上での Mule2.3@19.34 … `[numbersign]`
- XFree86 上での Mule2.3@19.28 … `[key-35]`
- XFree86 上での Emacs 20.2 … <kbd>変換</kbd> キーが使えません。

例
```
(setq skk-nicola-rshift-keys '(" " [henkan]))
```

## 10.2. skk-nicola-lshift-keys

左親指キーとして使うキーのリスト。
標準では無変換キー。
無変換キーを表すシンポルも Emacs の種類によって異なることがある。

- Mule for Windows または Neadow … `[noconvert]`
- XFree86 上での Emacsen … `[muhenkan]`

例
```
(setq skk-nicola-lshift-keys '([muhenkan]))
```

## 10.3. skk-nicola-interval

この時間(ms)以内に打鍵されたものを同時打鍵と判定する。

例
```
(setq skk-nicola-interval 0.1) ; 100 ミリ秒
```

## 10.4. skk-nicola-latin-interval

英数 (latin) モードで同時打鍵と判定する時間(ms)。

例
```
(setq skk-nicola-latin-interval 0.15) ; 150 ミリ秒
```

## 10.5. skk-nicola-use-lshift-as-space

の変数を t にすると、左シフトもスペースとして機能する。
標準では nil。
キーボードを改造して、真中に右シフトと左シフトが並んでいるように
したときは、便利かもしれません。そのときは、NICOLA SKK 以外でも
工夫する必要がありますが。

## 10.6. skk-nicola-use-koyubi-functions

この変数が非 nil ならば、右手小指のホームポジションの右（JIS キー
ボードでは、":" の位置） に後退キーのような機能を割り当てる。
この機能については一応「OAK パワーアップキット β版」を参考にしま
したが、変換対象文字列の扱いが SKK においては一般の FEP と全然違
うために、そっくり同じ機能は実装できません。。
なお、"]" の位置には取消キーのような機能を割り当てます。

## 10.7. skk-nicola-prefix-suffix-chars

接頭・接尾語入力をする際に設定する。
abbrev モードと同じキーを使用しない場合に
`skk-nicola-prefix-suffix-abbrev-chars` を nil にして設定する。

例
```
(setq skk-nicola-prefix-suffix-abbrev-chars '())
(setq skk-nicola-prefix-suffix-chars '(?s ?l))
```

## 10.8. skk-nicola-abbrev-chars

abbrev モードに入る際に設定する。
接頭・接尾語入力と同じキーを使用しない場合に
`skk-nicola-prefix-suffix-abbrev-chars` を nil にして設定する。

例
```
(setq skk-nicola-prefix-suffix-abbrev-chars '())
(setq skk-nicola-abbrev-chars '(?g ?h))
```

# 11. 辞書の非互換性

NICOLA-DDSKK はローマ字入力の替わりに、かな入力を基本としているため、
辞書の内容が下に示すように本来の SKK と異なることがあります。

- 本来の SKK
  * いt /行/[った/行/]/

- NICOLA SKK
  * いt /行/[っ/行/]/

NICOLA 入力の場合は、無理にオリジナルに合わせると、少しおかしなタイミ
ング（『▽い*った』まで入力）で変換することになりますので、NICOLA-DDSKK
はあえてこのような仕様にしてあります。

`skk-henkan-okuri-strictly` を非 nil にしている場合は問題になり得ますが、
これについては SKK 本体に手を入れ、NICOLA-DDSKK 使用時には前者を強制的
に後者に置き換えることで対処しています。

