# SPDX-License-Identifier: GPL-3.0-or-later
#
# Datasheets:
#
# https://cdrdv2.intel.com/v1/dl/getContent/613456

# The datasheet says that this spec covers the following pci ids:
# 8086:1502 - Intel 82579LM gigabit ethernet controller
# 8086:1503 - Intel 82579V gigabit ethernet controller

# GbE SPEC for 82579LM/82579V
{
	"mac_address_"[6]	: 8,
	"reserved_x03"		: 16,
	"reserved_x04"		: 16,
	"imageversioninfo_x05"	: 16,
	"reserved_x06"		: 16,
	"reserved_x07"		: 16,
	"pba_low_x08"		: 16,
	"pba_high_x09"		: 16,
	"pci_loaddeviceid_0"	: 1,
	"pci_loadsubsystemid_1"	: 1,
	"pci_reserved_2"	: 1,
	"pci_reserved_3"	: 3,
	"pci_pmenable_6"	: 1,
	"pci_auxpwr_7"		: 1,
	"pci_reserved_8"	: 8,
	"subsystemid_x0B"	: 16,
	"subsystemvendorid_x0C"	: 16,
	"deviceid_x0D"		: 16,
	"reserved_x0E"		: 16,
	"reserved_x0F"		: 16,
	"lanpwr_d3pwr_0"	: 5,
	"lanpwr_reserved_5"	: 3,
	"lanpwr_d0pwr_8"	: 8,
	"reserved_x11"		: 16,
	"reserved_x12"		: 16,
	"sicw_dynamicclock_0"	: 1,
	"sicw_clkcnt_1"		: 1,
	"sicw_reserved_2"	: 1,
	"sicw_fullduplex_3"	: 1,
	"sicw_forcespeed_4"	: 1,
	"sicw_reserved_5"	: 1,
	"sicw_phydeviceype_6"	: 2,
	"sicw_reserved_8"	: 1,
	"sicw_phy_enpwrdown_9"	: 1,
	"sicw_reserved_10"	: 3,
	"sicw_macsecdisable_13"	: 1,
	"sicw_sign_14"		: 2,
	"ecw1_extcfgptr_0"	: 12,
	"ecw1_oemload_12"	: 1,
	"ecw1_phyload_13"	: 1,
	"ecw1_reserved_14"	: 2,
	"ecw2_reserved_0"	: 8,
	"ecw2_extphylen_8"	: 8,
	"ecw3_extcfg1_0"	: 16,
	"oem_reserved_0"	: 9,
	"oem_lpluenind0a_9" 	: 1,
	"oem_lplueninnond0a_10"	: 1,
	"oem_gbedisinnond0a_11"	: 1,
	"oem_reserved_12"	: 2,
	"oem_gbedis_14"		: 1,
	"oem_reserved_15"	: 1,
	"l02_led0mode_0"	: 3,
	"l02_led0invert_3"	: 1,
	"l02_led0blink_4"	: 1,
	"l02_led1mode_5"	: 3,
	"l02_led1invert_8"	: 1,
	"l02_led1blink_9"	: 1,
	"l02_led2mode_10"	: 3,
	"l02_led2invert_13"	: 1,
	"l02_led2blink_14"	: 1,
	"l02_blinkrate_15"	: 1,
	"reserved_x19"		: 16,
	"amp_enable_0"		: 1,
	"amp_reserved_1"	: 15,
	"reserved_x1B"		: 16,
	"reserved_x1C"		: 16,
	"reserved_x1D"		: 16,
	"reserved_x1E"		: 16,
	"reserved_x1F"		: 16,
	"reserved_x20"		: 16,
	"reserved_x21"		: 16,
	"reserved_x22"		: 16,
	"reserved_x23"		: 16,
	"reserved_x24_0"	: 14,
	"reserved_x24_14"	: 1,
	"reserved_x24_15"	: 1,
	"reserved_x25_0"	: 4,
	"reserved_x25_4"	: 1,
	"reserved_x25_5"	: 2,
	"reserved_x25_7"	: 1,
	"reserved_x25_8"	: 7,
	"reserved_x25_15"	: 1,
	"reserved_x26_0"	: 9,
	"reserved_x26_9"	: 1,
	"reserved_x26_10"	: 1,
	"reserved_x26_11"	: 1,
	"reserved_x26_12"	: 2,
	"reserved_x26_14"	: 1,
	"reserved_x26_15"	: 1,
	"reserved_x27"		: 16,
	"offset_x28"		: 16,
	"offset_x29"		: 16,
	"offset_x2A"		: 16,
	"offset_x2B"		: 16,
	"offset_x2C"		: 16,
	"offset_x2D"		: 16,
	"offset_x2E"		: 16,
	"offset_x2F"		: 16,
	"pxe30_protocolsel_0"	: 2,
	"pxe30_reserved_2"	: 1,
	"pxe30_defbootsel_3"	: 2,
	"pxe30_reserved_5"	: 1,
	"pxe30_prompttime_6"	: 2,
	"pxe30_dispsetup_8"	: 1,
	"pxe30_reserved_9"	: 1,
	"pxe30_forcespeed_10"	: 2,
	"pxe30_forcefullduplex_12" : 1,
	"pxe30_reserved_13"	: 1,
	"pxe30_reserved_14"	: 2,
	"pxe31_disablemenu_0"	: 1,
	"pxe31_disabletitle_1"	: 1,
	"pxe31_disableprotsel_2" : 1,
	"pxe31_disbootorder_3"	: 1,
	"pxe31_dislegacywak_4"	: 1,
	"pxe31_disableflasicwpro_5" : 1,
	"pxe31_reserved_6"	: 2,
	"pxe31_ibootagentmode_8" : 3,
	"pxe31_contretrydis_11"	: 1,
	"pxe31_reserved_12"	: 2,
	"pxe31_signature_14"	: 2,
	"pxe32_buildnum_0"	: 8,
	"pxe32_minorversion_8"	: 4,
	"pxe32_majorversion_12"	: 4,
	"pxe33_basecodepresent_0" : 1,
	"pxe33_undipresent_1"	: 1,
	"pxe33_reserved_2"	: 1,
	"pxe33_efiundipresent_3" : 1,
	"pxe33_iscsi_4"		: 1,
	"pxe33_reserved_5"	: 9,
	"pxe33_signature_14"	: 2,
	"pxe_padding"[11]	: 16,
	"checksum_gbe"		: 16,
	"g3_s5_phy_conf"[0x16]  : 8,
	"padding"[0xf6a]	: 8
}
