//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_42.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot42(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[42] = {1.460017135478569e-02,1.314318292053676e-01,3.652569320013846e-01,7.164002894347877e-01,1.185352227654440e+00,
    1.772772387972019e+00,2.479494902134027e+00,3.306535043617567e+00,4.255097485700951e+00,5.326586333162191e+00,6.522617136911987e+00,7.845031151606489e+00,
    9.295912157785057e+00,1.087760624554686e+01,1.259274505043534e+01,1.444427304964665e+01,1.643547967545258e+01,1.857003719308730e+01,2.085204553638739e+01,
    2.328608561584580e+01,2.587728303814923e+01,2.863138474333377e+01,3.155485183293098e+01,3.465497291466760e+01,3.794000375365336e+01,4.141934109105191e+01,
    4.510374147266588e+01,4.900560030677341e+01,5.313931293794423e+01,5.752174962197211e+01,6.217289225082515e+01,6.711670672143431e+01,7.238236890708382e+01,
    7.800603996678934e+01,8.403353104686988e+01,9.052448180105013e+01,9.755928035400053e+01,1.052513563988187e+02,1.137711697013339e+02,1.233996876590921e+02,
    1.346750257673260e+02,1.489838572972913e+02};
  constexpr double aw[42] = {2.381665164123877e-01,2.119783608299676e-01,1.678971935081127e-01,1.183031774092678e-01,7.412062712682743e-02,
    4.126550145699646e-02,2.039769051596592e-02,8.942997462150033e-03,3.473555670318476e-03,1.193574051167489e-03,3.622532246353051e-04,9.693254025651544e-05,
    2.282041964292070e-05,4.715890638678973e-06,8.532109247531311e-07,1.347515082659149e-07,1.851735909072757e-08,2.206031653348500e-09,2.269170056982643e-10,
    2.006197650690580e-11,1.516794211468352e-12,9.751111983536444e-14,5.296367290397574e-15,2.413046421035697e-16,9.146809474774557e-18,2.857946497692167e-19,
    7.282847898000456e-21,1.495176144996499e-22,2.438114477260604e-24,3.105677547554655e-26,3.029994066125889e-28,2.211339194320611e-30,1.173072668454671e-32,
    4.365256260679369e-35,1.089369391193148e-37,1.719616536649988e-40,1.587180741790976e-43,7.668228473195954e-47,1.643081895799633e-50,1.189775567817074e-54,
    1.736892166137280e-59,1.377759112535871e-65};
  constexpr double x[16128] = {  6.829531865545015e-04, -4.016016722500040e-06,  1.770563245081128e-08, -6.935560998859635e-11,  2.545511529857284e-13,
 -8.962838818005976e-16,  3.065730150695220e-18, -1.026292481999061e-20,  3.378455340359050e-23, -1.097155143765586e-25,  3.522848246434908e-28, -1.120203339970319e-30,
  6.141111733273537e-03, -3.601456622991429e-05,  1.579205605078556e-07, -6.130062272732403e-10,  2.219225191352922e-12, -7.663851039219280e-15,  2.553524285739954e-17,
 -8.259182199644081e-20,  2.601466348167248e-22, -7.989849504625021e-25,  2.392192328618522e-27, -6.970315391300951e-30,  1.702830079740702e-02, -9.932355462904897e-05,
  4.307996265362550e-07, -1.641715971388239e-09,  5.777688753506398e-12, -1.915103141363613e-14,  6.023885288147404e-17, -1.799027956071915e-19,  5.072376818832177e-22,
 -1.331033572503675e-24,  3.148491485601371e-27, -6.175640026970618e-30,  3.328640351593350e-02, -1.925811259111461e-04,  8.216051017219564e-07, -3.043537123926069e-09,
  1.024267881598503e-11, -3.171983864202720e-14,  9.000018975460017e-17, -2.285454193755643e-19,  4.859721241139119e-22, -6.681774086427002e-25, -7.424667978907962e-28,
  1.076095063492136e-29,  5.482859224333211e-02, -3.137801303478353e-04,  1.309123165169673e-06, -4.663193311689664e-09,  1.471216003315216e-11, -4.096572327933457e-14,
  9.635602972999553e-17, -1.625811385831663e-19,  6.756526976860064e-24,  1.529075602914744e-24, -8.762720798707329e-27,  3.473758116037103e-29,  8.153974477323282e-02,
 -4.603101095131620e-04,  1.866688771332997e-06, -6.316049622244234e-09,  1.820418716090275e-11, -4.273959355330081e-14,  6.595015816310564e-17,  4.249149100114002e-20,
 -8.712615342757004e-22,  4.375025074937848e-24, -1.532886943637795e-26,  3.954297664070647e-29,  1.132769976895931e-01, -6.290119960761443e-04,  2.463476891720590e-06,
 -7.804838137019902e-09,  1.980655469750888e-11, -3.415896578655915e-14, -4.202820875679802e-18,  3.499821135447211e-19, -1.807876733716494e-21,  6.009747998282388e-24,
 -1.292508921444463e-26,  3.456531416938695e-30,  1.498704354353083e-01, -8.162444575200051e-04,  3.065999910840087e-06, -8.937711765061427e-09,  1.882056814921034e-11,
 -1.439702933290627e-14, -1.041955868653652e-16,  6.652972108349099e-19, -2.297942824620552e-21,  4.595608677733209e-24,  2.056777906895279e-27, -6.507061896588238e-29,
  1.911239132947747e-01, -1.017960578152700e-03,  3.639741050263111e-06, -9.546076900362930e-09,  1.487880934515113e-11,  1.492194467138579e-14, -2.123538686178910e-16,
  8.632121103382839e-19, -1.897321385240198e-21, -4.434713886882314e-25,  2.477411319833202e-26, -1.213553284369673e-28,  2.368160120709850e-01, -1.229793360591314e-03,
  4.150846918286812e-06, -9.500661666975476e-09,  8.019996003747443e-12,  4.981838619454119e-14, -2.999398570085541e-16,  8.311784602089404e-19, -4.628562844622840e-22,
 -7.664314504529635e-24,  4.248912229796680e-26, -1.097088888477145e-28,  2.867011217933791e-01, -1.447148340292342e-03,  4.567798971014690e-06, -8.724412056072469e-09,
 -1.290440508844492e-12,  8.454718634936548e-14, -3.383707966277714e-16,  5.141952646397555e-19,  1.706818381543966e-21, -1.387649672928453e-23,  4.105792913614598e-26,
 -7.039780205318772e-30,  3.405106513166336e-01, -1.665301448398549e-03,  4.862984015516855e-06, -7.201063320455688e-09, -1.219831251909555e-11,  1.125865917845900e-13,
 -3.071445306195046e-16, -5.497992233843511e-20,  3.909834348292629e-21, -1.548040146146662e-23,  1.416423168704171e-26,  1.467206112030116e-28,  3.979543601602669e-01,
 -1.879500132635581e-03,  5.014087924099452e-06, -4.978588924766755e-09, -2.355361518914473e-11,  1.278495982655586e-13, -2.003704648399610e-16, -7.526311381338240e-19,
  5.266991175379695e-21, -1.031280012028763e-23, -3.036846225326950e-26,  2.594104121785294e-28,  4.587218083926360e-01, -2.085065656323024e-03,  5.005244337154183e-06,
 -2.167156016409043e-09, -3.404742312052710e-11,  1.258913362629427e-13, -3.005692773871272e-17, -1.391803410976950e-18,  5.060628571754774e-21,  9.176735681545807e-25,
 -7.192458511705921e-26,  2.401767006594239e-28,  5.224839197797893e-01, -2.277494444447096e-03,  4.827881026867850e-06,  1.068319755721811e-09, -4.237557825523167e-11,
  1.048783528581836e-13,  1.749420433544214e-16, -1.774501096684324e-18,  3.054899963950283e-21,  1.442816119257991e-23, -8.668377196789403e-26,  6.481520108111742e-29,
  5.888946527999742e-01, -2.452556335354691e-03,  4.481220338026592e-06,  4.520464476662934e-09, -4.740802873878359e-11,  6.612293985858325e-14,  3.743438475816326e-16,
 -1.753110868750556e-18, -3.395247152518135e-22,  2.467338238965625e-23, -6.091831821351940e-26, -1.925514785779405e-28,  6.575927734698234e-01, -2.606387628562782e-03,
  3.972406137895415e-06,  7.955602976193255e-09, -4.834144216757390e-11,  1.406180043244874e-14,  5.251141951437620e-16, -1.281591508120039e-18, -4.140869117397928e-21,
  2.670694727195923e-23, -5.387374302734915e-28, -3.900312164031618e-28,  7.282037232410578e-01, -2.735576894351379e-03,  3.316247297221233e-06,  1.113245826288529e-08,
 -4.481443923512645e-11, -4.434013111834769e-14,  5.914087286567002e-16, -4.390373253043096e-19, -7.104295725876531e-21,  1.854756688007288e-23,  6.926404923092487e-26,
 -3.993187847817730e-28,  8.003415745110595e-01, -2.837241629381869e-03,  2.534586097548476e-06,  1.382183049303490e-08, -3.696930871960323e-11, -1.006717265272032e-13,
  5.533696712816602e-16,  5.838235742497629e-19, -8.159577459659169e-21,  2.402769669195510e-24,  1.152546115291141e-25, -1.894470877913763e-28,  8.736110655524190e-01,
 -2.909094003875812e-03,  1.655318263263224e-06,  1.582558416848368e-08, -2.545082977621879e-11, -1.464602451893546e-13,  4.125531694564311e-16,  1.533162098589073e-18,
 -6.815928791826544e-21, -1.593457210146948e-23,  1.129850303157228e-25,  1.427099810738045e-28,  9.476097059126081e-01, -2.949494148312433e-03,  7.111086721586784e-07,
  1.699330601882821e-08, -1.134098633931087e-11, -1.746130857701122e-13,  1.925214422920955e-16,  2.162233721909813e-18, -3.374736860744479e-21, -2.936749008446154e-23,
  6.026767942908626e-26,  4.203797777311020e-28,  1.021929942573849e+00, -2.957489668599504e-03, -2.621376567935338e-07,  1.723517213042347e-08,  3.963153634300857e-12,
 -1.806542442959423e-13, -6.571077880741042e-17,  2.302371638540587e-18,  1.141369978215945e-21, -3.249244786616543e-23, -2.039123626801395e-26,  4.883437258778822e-28,
  1.096161376405119e+00, -2.932840354680495e-03, -1.226976770622583e-06,  1.652986919358318e-08,  1.891344037573423e-11, -1.635252992240589e-13, -3.124179406578369e-16,
  1.912950458520518e-18,  5.327296399484780e-21, -2.396478597525802e-23, -9.229989058644325e-26,  3.062186398627134e-28,  1.169893017694585e+00, -2.876027353982211e-03,
 -2.146217049062694e-06,  1.492682742689965e-08,  3.199575397000541e-11, -1.257973945484490e-13, -5.000767799469386e-16,  1.094501483826114e-18,  7.881375532430323e-21,
 -7.131155498411271e-24, -1.227976443936547e-25, -2.568380146231677e-29,  1.242715568834440e+00, -2.788246412401389e-03, -2.984712675991153e-06,  1.254250797697485e-08,
  4.191232714298468e-11, -7.324799499627428e-14, -5.938604242956056e-16,  6.041421973380636e-20,  8.057841259355765e-21,  1.138890823974614e-23, -9.953763241936077e-26,
 -3.254730990024677e-28,  1.314223721555158e+00, -2.671385135145418e-03, -3.711070021767482e-06,  9.551004188117741e-09,  4.773742886170291e-11, -1.387414437499286e-14,
 -5.791923862720604e-16, -9.244113836696697e-19,  5.915903148595490e-21,  2.453912634067081e-23, -3.613132538115430e-26, -4.371543561372089e-28,  1.384018455487519e+00,
 -2.527984580288157e-03, -4.299180672938233e-06,  6.169718936738375e-09,  4.902583940521130e-11,  4.347997650572387e-14, -4.645460616134982e-16, -1.619189954571937e-18,
  2.273415929932945e-21,  2.778811741962695e-23,  3.570647528512692e-26, -3.191802591307803e-28,  1.451709324284065e+00, -2.361185861248477e-03, -4.729502311670469e-06,
  2.641324037836536e-09,  4.585967532914273e-11,  9.062995403354381e-14, -2.788476970970391e-16, -1.873937613537472e-18, -1.612236366590331e-21,  2.088018830125069e-23,
  8.294702032283593e-26, -6.016204098387070e-29,  1.516916715072828e+00, -2.174662791851707e-03, -4.990020283396766e-06, -7.864485768019485e-10,  3.882730704995311e-11,
  1.214152293172734e-13, -6.418232634639562e-17, -1.667035016947267e-18, -4.508321053987505e-21,  7.631226135755681e-24,  8.765807161500185e-26,  1.840674401083445e-28,
  1.579274066661289e+00, -1.972541950137212e-03, -5.076838003742888e-06, -3.881423809209860e-09,  2.893725719117439e-11,  1.326701935221595e-13,  1.343326365269721e-16,
 -1.103013795909086e-18, -5.635281057531868e-21, -6.039546046645987e-24,  5.433405689331344e-26,  2.877093754744360e-28,  1.638430031673195e+00, -1.759311855455768e-03,
 -4.994362638963966e-06, -6.446193148481964e-09,  1.747881950650478e-11,  1.246277060602897e-13,  2.789563848940333e-16, -3.727934430813891e-19, -4.899063156026590e-21,
 -1.483622625439613e-23,  4.925300807512093e-27,  2.234921404872334e-28,  1.694050567700199e+00, -1.539723238637037e-03, -4.755072859002114e-06, -8.334210027327531e-09,
  5.848455316334968e-12,  1.006901653103339e-13,  3.474418359205056e-16,  3.094727363546571e-19, -2.850691799212509e-21, -1.626690387181042e-23, -3.464234522324722e-26,
  6.296031198616857e-29,  1.745820942599196e+00, -1.318682628520856e-03, -4.378876878547757e-06, -9.461328333185077e-09, -4.634242548575079e-12,  6.662570776219193e-14,
  3.369285733200306e-16,  7.717747981936832e-19, -4.084096803723830e-22, -1.132123149899951e-23, -4.825738622863088e-26, -8.322001093619687e-29,  1.793447639280333e+00,
 -1.101141672091173e-03, -3.892090349199113e-06, -9.811741527844662e-09, -1.289578224454230e-11,  2.935804699688699e-14,  2.628168352811771e-16,  9.308769199368628e-19,
  1.529593221806404e-21, -3.481593636185582e-24, -3.614057841764273e-26, -1.388709101533163e-28,  1.836660145731413e+00, -8.919847429900482e-04, -3.326083795302888e-06,
 -9.437780265879193e-09, -1.824005341356790e-11, -4.404335678102211e-15,  1.531555354487787e-16,  8.064390460396833e-19,  2.418376204987498e-21,  3.274571650987991e-24,
 -1.145977687363409e-26, -1.006105665126454e-28,  1.875212616654492e+00, -6.959174686789236e-04, -2.715667082254296e-06, -8.453582535172158e-09, -2.042387271981385e-11,
 -2.942611005006769e-14,  4.023823437570269e-17,  5.004676754926378e-19,  2.216432350802421e-21,  6.392664302531905e-24,  9.572859533623951e-27, -2.208984743891310e-29,
  1.908885394070939e+00, -5.173588154254115e-04, -2.097292852593410e-06, -7.023211139798854e-09, -1.966692283168496e-11, -4.284387536018378e-14, -4.821674125344454e-17,
  1.518193865763390e-19,  1.310819744232056e-21,  5.645841562501743e-24,  1.736238289183991e-26,  3.521314035636308e-29,  1.937486376015948e+00, -3.603393080228376e-04,
 -1.507171100668960e-06, -5.344306320305300e-09, -1.659555958166118e-11, -4.453647520108213e-14, -9.590269072605189e-17, -1.165002054958959e-19,  2.745894255602363e-22,
  2.716158133260641e-24,  1.268700030950790e-26,  4.445301347711361e-29,  1.960852226894541e+00, -2.284078162918807e-04, -9.793923983823372e-07, -3.628777446145663e-09,
 -1.212940871862925e-11, -3.690837683136015e-14, -1.010126842707606e-16, -2.380648870903488e-19, -4.183000485205084e-22, -1.302863728222121e-25,  3.346364529647280e-27,
  2.088745476409289e-29,  1.978849440929993e+00, -1.245490510667506e-04, -5.441570765674230e-07, -2.082315527830848e-09, -7.327851937368617e-12, -2.414959938890534e-14,
 -7.492336719882135e-17, -2.180814017322701e-19, -5.876714188496926e-22, -1.420017015909911e-24, -2.824190417582465e-27, -3.135041927010074e-30,  1.991375389646934e+00,
 -5.111295697917681e-05, -2.261994793698441e-07, -8.846106429135654e-10, -3.219182444919157e-12, -1.114339508654947e-14, -3.708565085719240e-17, -1.192820031223297e-19,
 -3.715161490752625e-22, -1.119969889445364e-24, -3.258367138076320e-27, -9.093208961069162e-30,  1.998361165640260e+00, -9.746879462791137e-06, -4.344162011880386e-08,
 -1.719186105954395e-10, -6.369725152150365e-13, -2.261925284013520e-15, -7.794096699927527e-18, -2.625031449550935e-20, -8.680915948386929e-23, -2.827230345985742e-25,
 -9.086556713046277e-28, -2.885831203893716e-30,  6.671672347409815e-04, -3.877632831114325e-06,  1.689722318214854e-08, -6.542229480075542e-11,  2.373385904977058e-13,
 -8.260360906549981e-16,  2.792928800979633e-18, -9.242389113677595e-21,  3.007700091492633e-23, -9.656198948432026e-26,  3.065307755792382e-28, -9.637004259489091e-31,
  5.999534445940682e-03, -3.478003385206356e-05,  1.507725790097591e-07, -5.786923121052294e-10,  2.071894061798473e-12, -7.077841304324367e-15,  2.333502169919456e-17,
 -7.470946092868437e-20,  2.330341037436943e-22, -7.091625573667618e-25,  2.105346475385431e-27, -6.088679504872181e-30,  1.663777678338805e-02, -9.595441705963964e-05,
  4.116413031666998e-07, -1.552260245128513e-09,  5.408726724882002e-12, -1.776395553188901e-14,  5.542178377624258e-17, -1.644140842711307e-19,  4.615228163838733e-22,
 -1.210427403466548e-24,  2.884379472946734e-27, -5.824131485967049e-30,  3.252899725566463e-02, -1.861516363330286e-04,  7.860453925990347e-07, -2.884614221229062e-09,
  9.629372734529334e-12, -2.963489048271898e-14,  8.381498162216552e-17, -2.133840327046163e-19,  4.614904071489639e-22, -6.891529341765452e-25, -3.238680211838055e-28,
  8.348665742937842e-30,  5.359406885828489e-02, -3.035270380571613e-04,  1.254550578196458e-06, -4.434229165325826e-09,  1.391560261420782e-11, -3.870773287984698e-14,
  9.181459469872053e-17, -1.615489316062592e-19,  5.584867641528735e-23,  1.207632806588203e-24, -7.345432933018773e-27,  2.979193112959170e-29,  7.972789824121394e-02,
 -4.456748825891260e-04,  1.792615849248063e-06, -6.031534613970985e-09,  1.736530401878324e-11, -4.114552171480624e-14,  6.677244815028236e-17,  1.701615188666867e-20,
 -7.243855501380235e-22,  3.795847000431303e-24, -1.365075614989233e-26,  3.670043424303492e-29,  1.107997797050948e-01, -6.096734777312404e-04,  2.371697709483301e-06,
 -7.493400960122339e-09,  1.912312751394976e-11, -3.414858042955091e-14,  4.818565125126760e-18,  2.954922930145646e-19, -1.600779500274152e-21,  5.497486861123727e-24,
 -1.264907074426327e-26,  8.802885335357161e-30,  1.466538415348797e-01, -7.921403719388561e-04,  2.960544218990272e-06, -8.639015884315884e-09,  1.850908722215620e-11,
 -1.668233961375816e-14, -8.657178982123066e-17,  5.944206574557141e-19, -2.131669420061411e-21,  4.625045430597925e-24, -4.796014756939943e-28, -5.060452304253168e-29,
  1.871095870782730e-01, -9.892967934830802e-04,  3.526625466813090e-06, -9.305897254914421e-09,  1.512820557952028e-11,  1.010862221205490e-14, -1.890350251866503e-16,
  8.024234657463210e-19, -1.896695196951697e-21,  4.451587199437973e-25,  1.976690091196189e-26, -1.063264347597341e-28,  2.319625333053869e-01, -1.197040362344113e-03,
  4.037640532629629e-06, -9.364754031142280e-09,  8.946253584938561e-12,  4.289718844842626e-14, -2.769134150908944e-16,  8.122709899664611e-19, -7.093422037097162e-22,
 -6.061180750804143e-24,  3.767635687692925e-26, -1.085170171594073e-28,  2.809849498307522e-01, -1.411024945632954e-03,  4.463036529547589e-06, -8.731967789539489e-09,
  3.204904012839453e-13,  7.660477841625808e-14, -3.232815199205909e-16,  5.611365358749712e-19,  1.236688745383500e-21, -1.224718840434579e-23,  4.024955706269721e-26,
 -2.873444164844427e-29,  3.339267015246670e-01, -1.626746376726898e-03,  4.775473226609498e-06, -7.378623258148163e-09, -1.002034916817532e-11,  1.052102770261720e-13,
 -3.070152932232933e-16,  6.133935664775978e-20,  3.364190221807318e-21, -1.479605561824339e-23,  1.977974503778734e-26,  1.092029723982305e-28,  3.905161978731941e-01,
 -1.839632615494851e-03,  4.952167225551771e-06, -5.335258942027017e-09, -2.104632215777182e-11,  1.228065176035278e-13, -2.191418822205073e-16, -5.902402247870501e-19,
  4.876537628584954e-21, -1.130788831412346e-23, -1.960418358294895e-26,  2.294753246408863e-28,  4.504614521505575e-01, -2.045136794977923e-03,  4.976052838248586e-06,
 -2.691824287313298e-09, -3.153987203614267e-11,  1.247206344718795e-13, -6.675913360733767e-17, -1.229869186347200e-18,  5.044443024069679e-21, -1.746216895203264e-24,
 -6.124420462801104e-26,  2.437381632169300e-28,  5.134512532304520e-01, -2.238831482227000e-03,  4.836702721425128e-06,  4.073024759217825e-10, -4.023999063620086e-11,
  1.084922322155823e-13,  1.266979585313388e-16, -1.669096435173288e-18,  3.512719022415143e-21,  1.103200136313790e-23, -8.279348674421648e-26,  1.102245521359667e-28,
  5.791564524709854e-01, -2.416502381744019e-03,  4.530959917723850e-06,  3.772987130236106e-09, -4.599970639837712e-11,  7.451772276052597e-14,  3.252347254912396e-16,
 -1.750249455686831e-18,  5.029958467726279e-22,  2.208712303874391e-23, -6.790810412809642e-26, -1.257867131852491e-28,  6.472313675501997e-01, -2.574239633627955e-03,
  4.063244060071856e-06,  7.185062079721402e-09, -4.793715901952443e-11,  2.621984040089777e-14,  4.875188413266484e-16, -1.398753058341386e-18, -3.183822401243073e-21,
  2.635551530089477e-23, -1.668745781619251e-26, -3.426586374556913e-28,  7.173153043959175e-01, -2.708524809913647e-03,  3.445507831317997e-06,  1.040909937739629e-08,
 -4.556042957937775e-11, -3.031889207679735e-14,  5.760369506121088e-16, -6.551912612614205e-19, -6.390980084868126e-21,  2.096339140264961e-23,  5.147406003470949e-26,
 -4.066341095188637e-28,  7.890341974381863e-01, -2.816311696697222e-03,  2.696834917833218e-06,  1.321494069983174e-08, -3.884876244970522e-11, -8.722408341733652e-14,
  5.660804875324366e-16,  3.249733166926995e-19, -7.992290139954924e-21,  6.825910886632642e-24,  1.054233680475239e-25, -2.551939598921821e-28,  8.620023673113887e-01,
 -2.895098971409100e-03,  1.842687111288265e-06,  1.539548936797322e-08, -2.827767421856692e-11, -1.360689716436110e-13,  4.523482162983992e-16,  1.306757013452494e-18,
 -7.306950779931184e-21, -1.131593613836825e-23,  1.172950006748317e-25,  5.328806381648946e-29,  9.358243938466850e-01, -2.942992948674132e-03,  9.138252339585596e-07,
  1.678418354421466e-08, -1.478220611154579e-11, -1.692792230407057e-13,  2.513966894919125e-16,  2.037826946994872e-18, -4.384264412236888e-21, -2.660334566278871e-23,
  7.750564501631755e-26,  3.608556982014410e-28,  1.010097100729276e+00, -2.958758678655884e-03, -5.505457780538958e-08,  1.726961420157157e-08,  3.395366666326090e-13,
 -1.814546643342653e-13, -9.097659246948247e-19,  2.320064691008003e-18, -3.782430850121367e-23, -3.287455071708480e-23,  1.345396741885150e-27,  4.964791930941906e-28,
  1.084411646559960e+00, -2.941857841781877e-03, -1.026911845803194e-06,  1.680593134613164e-08,  1.557238874027141e-11, -1.703621369048971e-13, -2.566033174355750e-16,
  2.068935356981255e-18,  4.401556934372809e-21, -2.736532133370555e-23, -7.720277871989560e-26,  3.781181935414375e-28,  1.158355715273756e+00, -2.892472095208031e-03,
 -1.964108636466341e-06,  1.541799073618495e-08,  2.936241613822790e-11, -1.374032568439733e-13, -4.659452397448054e-16,  1.341649339107683e-18,  7.536209890562044e-21,
 -1.203895010345369e-23, -1.219228955808252e-25,  6.613158756162504e-29,  1.231515796953838e+00, -2.811510789636577e-03, -2.830229846161407e-06,  1.320061224200077e-08,
  4.030512985098703e-11, -8.745085815713677e-14, -5.885029128568501e-16,  3.240296151516741e-19,  8.392862739437179e-21,  7.136505203056450e-24, -1.126692530615865e-25,
 -2.687514966889159e-28,  1.303479548067683e+00, -2.700602288575588e-03, -3.591886804879982e-06,  1.031181951475026e-08,  4.731895721738821e-11, -2.806316660397815e-14,
 -6.022949824656352e-16, -7.212847484112118e-19,  6.768625578088740e-21,  2.270545119863525e-23, -5.561576355005549e-26, -4.458141092024640e-28,  1.373838218082245e+00,
 -2.562068482056338e-03, -4.220410872308857e-06,  6.960468140538275e-09,  4.978032199941853e-11,  3.179597737262405e-14, -5.087127000310686e-16, -1.530187622115766e-18,
  3.295942709199633e-21,  2.891695010431713e-23,  2.028552965234022e-26, -3.808571252024505e-28,  1.442189127331365e+00, -2.398882487050166e-03, -4.693345305445333e-06,
  3.389198082698008e-09,  4.760107377279379e-11,  8.330285372045132e-14, -3.319226991295951e-16, -1.912868230167839e-18, -8.016510966011395e-22,  2.412465730351120e-23,
  7.875655505982232e-26, -1.315085592478218e-28,  1.508138178963014e+00, -2.214609958695624e-03, -4.995650425957765e-06, -1.458850810407114e-10,  4.123634395759265e-11,
  1.192987060511771e-13, -1.128328209063420e-16, -1.806213737867141e-18, -4.168622875157513e-21,  1.128928556175502e-23,  9.496847715798284e-26,  1.461026993571231e-28,
  1.571302385843617e+00, -2.013334888832912e-03, -5.120549012593706e-06, -3.397036163150398e-09,  3.162029315104929e-11,  1.355030017018237e-13,  1.008940934441424e-16,
 -1.286377111532377e-18, -5.810498047896291e-21, -3.609243206931445e-24,  6.725878816370764e-26,  2.983410458129715e-28,  1.631312391503044e+00, -1.799571227821205e-03,
 -5.069955567953450e-06, -6.146231718292392e-09,  2.003738402316610e-11,  1.311791940254111e-13,  2.662434806142987e-16, -5.380511432037812e-19, -5.427140192285008e-21,
 -1.443034590067551e-23,  1.567113179843447e-26,  2.649861138858628e-28,  1.687814962631260e+00, -1.578162116804092e-03, -4.854453996928003e-06, -8.224068497959064e-09,
  7.946290943074190e-12,  1.091218935927269e-13,  3.547400540322172e-16,  2.086195023090114e-19, -3.460474189672107e-21, -1.758600870741450e-23, -3.102461229113139e-26,
  1.025414799017879e-28,  1.740475429351712e+00, -1.354168943661317e-03, -4.492812289676571e-06, -9.524369430089132e-09, -3.219124429979989e-12,  7.496944296247645e-14,
  3.582913331377940e-16,  7.518051717712269e-19, -8.515675249332509e-22, -1.332090994758190e-23, -5.162011870444348e-26, -6.859086530549019e-29,  1.788980048563737e+00,
 -1.132752819235661e-03, -4.011048731729317e-06, -1.001302508321060e-08, -1.224340597898515e-11,  3.598383061134530e-14,  2.895457450275074e-16,  9.775273473909681e-19,
  1.376731664274381e-21, -5.052735301523871e-24, -4.249521333188980e-26, -1.496619909318680e-28,  1.833038265136103e+00, -9.190513934580593e-04, -3.441090442194899e-06,
 -9.730118263394776e-09, -1.828950815025423e-11, -4.487889178240751e-16,  1.768363006873086e-16,  8.856157680116392e-19,  2.526890752938279e-21,  2.721889472432160e-24,
 -1.632050135158869e-26, -1.206776117940784e-28,  1.872384845732909e+00, -7.180541769545657e-04, -2.819090002352524e-06, -8.785015294246253e-09, -2.100156035136647e-11,
 -2.828400542983706e-14,  5.527940293770756e-17,  5.751474774854053e-19,  2.453194426513116e-21,  6.752579328301761e-24,  8.329713791557275e-27, -3.489019560991939e-29,
  1.906781860721086e+00, -5.344796873075318e-04, -2.183487887328335e-06, -7.344798266744017e-09, -2.053500271918249e-11, -4.394513324171680e-14, -4.334702271360354e-17,
  1.971546903558140e-19,  1.526944120126237e-21,  6.371282877205521e-24,  1.890662767536847e-26,  3.478784885713104e-29,  1.936020491415990e+00, -3.726577860371297e-04,
 -1.572925752383866e-06, -5.617087256778800e-09, -1.750956442593019e-11, -4.687619698354428e-14, -9.902625960654050e-17, -1.060469630306725e-19,  3.819930530721732e-22,
  3.264512367845654e-24,  1.477513198565665e-26,  5.055159551214866e-29,  1.959922644831164e+00, -2.364204929634007e-04, -1.024126943437516e-06, -3.828887340113762e-09,
 -1.289236706271606e-11, -3.941418699318420e-14, -1.078664096651711e-16, -2.514978243981399e-19, -4.203476117250565e-22,  2.326471672401398e-26,  4.365228364754895e-27,
  2.556309186672289e-29,  1.978342377093417e+00, -1.290042893529595e-04, -5.698645976653835e-07, -2.203524909780927e-09, -7.829331327600945e-12, -2.602320859398972e-14,
 -8.130076534211799e-17, -2.377268814564814e-19, -6.408574500297495e-22, -1.535603799473802e-24, -2.951276975038084e-27, -2.602418095889752e-30,  1.991167250138038e+00,
 -5.296590700050819e-05, -2.371313630520707e-07, -9.379500251549548e-10, -3.451228538762070e-12, -1.207491103634023e-14, -4.059823143173389e-17, -1.318415805556448e-19,
 -4.142806929638022e-22, -1.258657923942204e-24, -3.685006446251017e-27, -1.032534257279418e-29,  1.998321469741457e+00, -1.010284127899636e-05, -4.556731929704779e-08,
 -1.824824980598216e-10, -6.841428029478046e-13, -2.458127273992706e-15, -8.569577595868417e-18, -2.919832714238331e-20, -9.767322822928056e-23, -3.217423044789969e-25,
 -1.045747104065445e-27, -3.358255201360345e-30,  6.519221764049589e-04, -3.745531992053148e-06,  1.613440652694782e-08, -6.175348721931617e-11,  2.214677586086624e-13,
 -7.620056131792175e-16,  2.547110211976742e-18, -8.333258841695326e-21,  2.681162643346157e-23, -8.510804271561558e-26,  2.671365815959094e-28, -8.304590848657014e-31,
  5.862783472848987e-03, -3.360107745987673e-05,  1.440225983788044e-07, -5.466447292271506e-10,  1.935772456776443e-12, -6.542083532300598e-15,  2.134383099668073e-17,
 -6.764510387088943e-20,  2.089576743939301e-22, -6.300735294187274e-25,  1.854679513728226e-27, -5.323040445350002e-30,  1.626042944615576e-02, -9.273435049173280e-05,
  3.935219236761392e-07, -1.468492116114636e-09,  5.066384408146438e-12, -1.648744646690689e-14,  5.101855669030012e-17, -1.503207876598478e-19,  4.199634158035303e-22,
 -1.100068290609895e-24,  2.636306705224476e-27, -5.449466031571078e-30,  3.179675184510641e-02, -1.799991598303890e-04,  7.523352312546500e-07, -2.735178546905385e-09,
  9.056315092262521e-12, -2.769338220573171e-14,  7.804323286704362e-17, -1.990151103833498e-19,  4.365306717974739e-22, -6.953669808150094e-25, -1.078232346942763e-30,
  6.391719967268703e-30,  5.239970178088248e-02, -2.936997494531340e-04,  1.202650562592278e-06, -4.217654568345286e-09,  1.316311827334297e-11, -3.655822289397400e-14,
  8.732239069512505e-17, -1.591203997967198e-19,  9.433859995884937e-23,  9.387164346636204e-25, -6.131878392133364e-27,  2.546702137668263e-29,  7.797342875434922e-02,
 -4.316188080687975e-04,  1.721877629401338e-06, -5.760185845423641e-09,  1.655844454969251e-11, -3.953976233572874e-14,  6.694418550171787e-17, -4.080055133592213e-21,
 -5.971823551615700e-22,  3.281241614674000e-24, -1.210122539947007e-26,  3.372122425763494e-29,  1.083984707339638e-01, -5.910544296622443e-04,  2.283590207934401e-06,
 -7.192885698104819e-09,  1.844195338549496e-11, -3.393925847745330e-14,  1.240426106554766e-17,  2.473370829689729e-19, -1.411872709687636e-21,  5.000485469670394e-24,
 -1.217350467437685e-26,  1.258280457949434e-29,  1.435319992625887e-01, -7.688656825407108e-04,  2.858641539860953e-06, -8.345647030538596e-09,  1.815597216177267e-11,
 -1.856789173365536e-14, -7.085801906561375e-17,  5.288634322306710e-19, -1.966015234653352e-21,  4.565084902175464e-24, -2.429351145531400e-27, -3.837122273156463e-29,
  1.832081244911352e-01, -9.615263441438672e-04,  3.416412901272585e-06, -9.062467571839581e-09,  1.528679415068747e-11,  5.834557483998474e-15, -1.674134421585804e-16,
  7.421293380476280e-19, -1.867525679606127e-21,  1.146552716695125e-24,  1.540738222193691e-26, -9.197159352506733e-29,  2.272382659016448e-01, -1.165186249999685e-03,
  3.926149488074457e-06, -9.215103834533729e-09,  9.739566290261558e-12,  3.652143310708503e-14, -2.545183959031888e-16,  7.863623778235121e-19, -9.015596539254916e-22,
 -4.648620314693811e-24,  3.298082838441948e-26, -1.045258242651497e-28,  2.754115952763080e-01, -1.375739586949830e-03,  4.358332891543045e-06, -8.714999320309235e-09,
  1.776292485211092e-12,  6.903863933233856e-14, -3.070797426863149e-16,  5.939641340431096e-19,  8.244175063383599e-22, -1.066762762494472e-23,  3.861081472185492e-26,
 -4.490183980632814e-29,  3.274955591737730e-01, -1.588899333043033e-03,  4.686035938050588e-06, -7.522514751893462e-09, -7.989627378330473e-12,  9.787419842924507e-14,
 -3.038695701688612e-16,  1.606324029250783e-19,  2.846839063942893e-21, -1.391887025262690e-23,  2.383748712163999e-26,  7.597513937821143e-29,  3.832364887690893e-01,
 -1.800276909936570e-03,  4.886203783366372e-06, -5.652642121454601e-09, -1.864403500386529e-11,  1.173660441971340e-13, -2.335460852765868e-16, -4.408365092340359e-19,
  4.457688209378375e-21, -1.189933344487505e-23, -1.019778646744246e-26,  1.979592260052314e-28,  4.423603053752595e-01, -2.005465969729937e-03,  4.940805121510220e-06,
 -3.176605373375409e-09, -2.906417691791450e-11,  1.227233454533219e-13, -9.894826045708810e-17, -1.069904701913844e-18,  4.940060744657901e-21, -3.982403089202605e-24,
 -5.060159879207939e-26,  2.387562580736682e-28,  5.045733302665941e-01, -2.200129089310574e-03,  4.837799409223944e-06, -2.190290597624036e-10, -3.804345687206108e-11,
  1.109852131743394e-13,  8.159216296962591e-17, -1.550964001733692e-18,  3.851529810201593e-21,  7.828225861329601e-24, -7.714306892566116e-26,  1.448619685103495e-28,
  5.695632075385313e-01, -2.380085995000349e-03,  4.571870301532386e-06,  3.049322149156988e-09, -4.443525272616201e-11,  8.173780690382518e-14,  2.765688235502416e-16,
 -1.721965358270486e-18,  1.248075090222684e-21,  1.927875249964430e-23, -7.205919698626769e-26, -6.386159889919015e-29,  6.369999486351638e-01, -2.541401793157303e-03,
  4.144882165278312e-06,  6.422884922362935e-09, -4.729898585963582e-11,  3.743967023403404e-14,  4.470689545334092e-16, -1.485611995900318e-18, -2.250531916836624e-21,
  2.540198028874292e-23, -3.059620935596062e-26, -2.887376576151648e-28,  7.065371068232604e-01, -2.680473544166988e-03,  3.566025627294486e-06,  9.676025989448175e-09,
 -4.603016095312218e-11, -1.673654864200161e-14,  5.549445207904200e-16, -8.472652683124974e-19, -5.603538393751932e-21,  2.266584882472560e-23,  3.370825376689896e-26,
 -3.985048263895846e-28,  7.778130892589115e-01, -2.794113394835865e-03,  2.851629555473415e-06,  1.258014539323406e-08, -4.045679605379618e-11, -7.355760521079922e-14,
  5.716418066417384e-16,  7.394267095909577e-20, -7.673508170134981e-21,  1.080205827788192e-23,  9.300953108139254e-26, -3.065922007975388e-28,  8.504526133503162e-01,
 -2.879626385489245e-03,  2.024630465013701e-06,  1.492187736755097e-08, -3.088766438604246e-11, -1.248003099840811e-13,  4.856091317108591e-16,  1.067325158051789e-18,
 -7.629543230916636e-21, -6.603130320503393e-24,  1.177121198017633e-25, -3.358657781108936e-29,  9.240683128408773e-01, -2.934880981831871e-03,  1.113705734611882e-06,
  1.652093049579929e-08, -1.810291918339936e-11, -1.625777089334360e-13,  3.063521561386140e-16,  1.882835155344706e-18, -5.282538322449408e-21, -2.320593735076762e-23,
  9.184108785514026e-26,  2.890129630142594e-28,  9.982624973989573e-01, -2.958370357151879e-03,  1.520936845252131e-07,  1.724603492617207e-08, -3.284518399699111e-12,
 -1.806981858640930e-13,  6.385750420030252e-17,  2.299971599060781e-18, -1.215089838435678e-21, -3.238576122356311e-23,  2.301153921012867e-26,  4.851567557269603e-28,
  1.072629067489855e+00, -2.949262477179434e-03, -8.238591887527042e-07,  1.702751698409724e-08,  1.210833186994771e-11, -1.758104689755893e-13, -1.968533862915158e-16,
  2.193460408380691e-18,  3.364997769023126e-21, -3.010234938973685e-23, -5.922106043915733e-26,  4.367735061702001e-28,  1.146755583916955e+00, -2.907437126902290e-03,
 -1.776366573917705e-06,  1.586521053802866e-08,  2.650570601981713e-11, -1.481083314288481e-13, -4.250746605673928e-16,  1.574939719803256e-18,  7.015975942102337e-21,
 -1.683004220075924e-23, -1.169474299676103e-25,  1.600129347527985e-28,  1.220225488659943e+00, -2.833508173916492e-03, -2.668013400445333e-06,  1.383073840801152e-08,
  3.841576462606812e-11, -1.014354997832359e-13, -5.756377878379572e-16,  5.958200997158189e-19,  8.565986940498269e-21,  2.413399936882026e-24, -1.229606921589425e-25,
 -1.966610057447214e-28,  1.292620470530560e+00, -2.728829592712482e-03, -3.463623434275321e-06,  1.106364091413789e-08,  4.661163685382909e-11, -4.273538353414741e-14,
 -6.193390123747976e-16, -4.920780639179917e-19,  7.541259902775928e-21,  2.008972926400114e-23, -7.510760217332221e-26, -4.371768000202416e-28,  1.363522965749488e+00,
 -2.595484082367817e-03, -4.132087546427919e-06,  7.761362946949472e-09,  5.029074572743663e-11,  1.908561432176136e-14, -5.499239508850496e-16, -1.407938474053705e-18,
  4.347367233404717e-21,  2.937657382062735e-23,  2.299736904173280e-27, -4.351573141293664e-28,  1.432518779879430e+00, -2.436253496775990e-03, -4.648051697389013e-06,
  4.163692640288686e-09,  4.918311951654178e-11,  7.469191036084322e-14, -3.857073239664805e-16, -1.924029915644373e-18,  1.219431629935533e-22,  2.713675597246065e-23,
  7.128400577587025e-26, -2.089528033768822e-28,  1.499199813706671e+00, -2.254570768009959e-03, -4.993364144995218e-06,  5.328196199707323e-10,  4.359106549558896e-11,
  1.159691588283326e-13, -1.652079551319002e-16, -1.932362134382741e-18, -3.692408450015757e-21,  1.520252157784992e-23,  1.003211659488215e-25,  9.500298810066575e-29,
  1.563166871744077e+00, -2.054453531192757e-03, -5.158188074625426e-06, -2.869312052231561e-09,  3.435154123783086e-11,  1.374711256174527e-13,  6.225674900237008e-17,
 -1.473846983209625e-18, -5.888830236922866e-21, -6.553350514130535e-25,  8.044231931901164e-26,  2.990862868621269e-28,  1.624032528149109e+00, -1.840420239697752e-03,
 -5.141699071685257e-06, -5.804303202794161e-09,  2.272354259731417e-11,  1.373681527295573e-13,  2.486695909697545e-16, -7.198869947514331e-19, -5.932429040822521e-21,
 -1.355819975043506e-23,  2.823312237261750e-26,  3.057220657587575e-28,  1.681424021144739e+00, -1.617390173796726e-03, -4.952306451233061e-06, -8.079004005505415e-09,
  1.021427239477475e-11,  1.176926446562906e-13,  3.589342794895844e-16,  8.752487567278841e-20, -4.114702705698390e-21, -1.872368978613683e-23, -2.552483557542076e-26,
  1.484768088555886e-28,  1.734986143646317e+00, -1.390569370288933e-03, -4.607362746118047e-06, -9.563406002226451e-09, -1.632058403409750e-12,  8.381750473297676e-14,
  3.788854092105200e-16,  7.164780929484073e-19, -1.368962295212106e-21, -1.544028175641089e-23, -5.419194186293964e-26, -4.708121008855100e-29,  1.784384094890971e+00,
 -1.165325107304904e-03, -4.132355401694282e-06, -1.020277520497019e-08, -1.145199638454294e-11,  4.326617581723168e-14,  3.175035267864994e-16,  1.018331277632086e-18,
  1.162624916090651e-21, -6.886920327663517e-24, -4.927503287070501e-26, -1.580173656347354e-28,  1.829306255604076e+00, -9.470521365599510e-04, -3.559607179947406e-06,
 -1.002258300892487e-08, -1.825398705039260e-11,  4.102072205909276e-15,  2.027793598257273e-16,  9.679073222487067e-19,  2.611790692511315e-21,  1.956513618186971e-24,
 -2.210911985690573e-26, -1.427548798434009e-28,  1.869466847803234e+00, -7.410343326274444e-04, -2.926544754269348e-06, -9.125487978497909e-09, -2.155262216219511e-11,
 -2.675495261811918e-14,  7.251954816764946e-17,  6.576002262715346e-19,  2.701874702942222e-21,  7.050625790074328e-24,  6.456882748481154e-27, -5.078679914949516e-29,
  1.904608439987033e+00, -5.523057933978088e-04, -2.273626008302521e-06, -7.680444077071716e-09, -2.142383206851122e-11, -4.491347915447889e-14, -3.710708118179742e-17,
  2.498356916371890e-19,  1.770288397413157e-21,  7.157748166353837e-24,  2.040366861141623e-26,  3.300010418812793e-29,  1.934504259742496e+00, -3.855156469417260e-04,
 -1.642043076922584e-06, -5.904870592638137e-09, -1.847108756772200e-11, -4.928696492818508e-14, -1.018059351623829e-16, -9.182429772810522e-20,  5.107069956453073e-22,
  3.901916132779742e-24,  1.714331119151027e-26,  5.717608190141436e-29,  1.958960280801957e+00, -2.448008626624736e-04, -1.071337734355776e-06, -4.041614562417572e-09,
 -1.370711698556895e-11, -4.208900203621665e-14, -1.150962851104506e-16, -2.648995550340149e-19, -4.160818439600211e-22,  2.219427609020557e-25,  5.609351442084778e-27,
  3.115059527072157e-29,  1.977817071575054e+00, -1.336711451635378e-04, -5.970760374078680e-07, -2.333066246109327e-09, -8.369859043817541e-12, -2.805667243512957e-14,
 -8.825269652318880e-17, -2.591418230360108e-19, -6.982897849168746e-22, -1.655730224479943e-24, -3.049185766527065e-27, -1.796743902525923e-30,  1.990951519774114e+00,
 -5.490893694445045e-05, -2.487262257173984e-07, -9.951558902643919e-10, -3.702777275258218e-12, -1.309510830828046e-14, -4.448241337995889e-17, -1.458529102201880e-19,
 -4.623586827175010e-22, -1.415543393253211e-24, -4.169451455537527e-27, -1.172399073596490e-29,  1.998280315162833e+00, -1.047632889048326e-05, -4.782444631985349e-08,
 -1.938335424622681e-10, -7.354301406645081e-13, -2.673971959004057e-15, -9.432688908842327e-18, -3.251756548797740e-20, -1.100459194707201e-22, -3.666845980447715e-25,
 -1.205417418774216e-27, -3.914552278488881e-30,  6.371935892194197e-04, -3.619361805050068e-06,  1.541413320778779e-08, -5.832868017188274e-11,  2.068205422700018e-13,
 -7.035807512541083e-16,  2.325344267943985e-18, -7.522316100368212e-21,  2.393158791630083e-23, -7.511862420844933e-26,  2.331616655017802e-28, -7.168196200823480e-31,
  5.730642710034356e-03, -3.247461885602587e-05,  1.376444664377041e-07, -5.166919015791883e-10,  1.809903704364858e-12, -6.051825210305711e-15,  1.954007065707131e-17,
 -6.130750837871888e-20,  1.875558082558457e-22, -5.603680042364112e-25,  1.635440969222062e-27, -4.657714768035098e-30,  1.589567870255353e-02, -8.965530930302299e-05,
  3.763757211282777e-07, -1.390002833015409e-09,  4.748546700475598e-12, -1.531202617980043e-14,  4.699190709546619e-17, -1.374957076765685e-19,  3.822023358984747e-22,
 -9.992990514841085e-25,  2.404944715058770e-27, -5.066643148696629e-30,  3.108858811886437e-02, -1.741093446749488e-04,  7.203645418539392e-07, -2.594608544727479e-09,
  8.520734517536779e-12, -2.588565831702127e-14,  7.266261517067820e-17, -1.854461483253800e-19,  4.115599533096374e-22, -6.902755991816457e-25,  2.441401877059121e-28,
  4.810742159710151e-30,  5.124382963262173e-02, -2.842774668397038e-04,  1.153278603425618e-06, -4.012781631542583e-09,  1.245255219367612e-11, -3.451557925724628e-14,
  8.291403838104097e-17, -1.556060796252630e-19,  1.239769812331144e-22,  7.147056120301997e-25, -5.096074681588766e-27,  2.170242370605032e-29,  7.627407206993923e-02,
 -4.181158315908831e-04,  1.654319196265455e-06, -5.501489875711223e-09,  1.578369594502090e-11, -3.793652631553984e-14,  6.657951484007543e-17, -2.139046754149222e-20,
 -4.874210113338980e-22,  2.825983209246637e-24, -1.068353126233215e-26,  3.072443040178699e-29,  1.060702508131707e-01, -5.731260017722169e-04,  2.199023665784359e-06,
 -6.903226285241186e-09,  1.776668050772951e-11, -3.356339327978730e-14,  1.872357953743885e-17,  2.049445903588504e-19, -1.240479067016827e-21,  4.525443217086480e-24,
 -1.156023418171097e-26,  1.510972380206508e-29,  1.405016474618462e-01, -7.463922316538822e-04,  2.760224208162335e-06, -8.058209828668173e-09,  1.776877176558947e-11,
 -2.009774408484498e-14, -5.690606344503191e-17,  4.685585676675388e-19, -1.803799303679759e-21,  4.437290282289828e-24, -3.885984454304427e-27, -2.815313373821375e-29,
  1.794159988535216e-01, -9.346258738843408e-04,  3.309133985315481e-06, -8.817156699253510e-09,  1.536495449998011e-11,  2.059279556898327e-15, -1.474634636861562e-16,
  6.831402022813026e-19, -1.816094993716003e-21,  1.685933400411226e-24,  1.165926642784175e-26, -7.857181882541321e-29,  2.226396427560751e-01, -1.134216676523896e-03,
  3.816526289793586e-06, -9.053751810955392e-09,  1.041067653517171e-11,  3.067380357491558e-14, -2.329275427539200e-16,  7.550805753983693e-19, -1.046257472851202e-21,
 -3.419730143670956e-24,  2.850728631990465e-26, -9.854945762188387e-29,  2.699777087320321e-01, -1.341290658267877e-03,  4.253967707744639e-06, -8.675927186505853e-09,
  3.084727183674831e-12,  6.187093425962368e-14, -2.901350394534459e-16,  6.144949257856352e-19,  4.676725591940802e-22, -9.166378549566105e-24,  3.636889908210546e-26,
 -5.627381042108419e-29,  3.212143638303787e-01, -1.551774153222644e-03,  4.595062074836845e-06, -7.635083455556759e-09, -6.104656530845643e-12,  9.064513913669903e-14,
 -2.981704606470910e-16,  2.439040160295099e-19,  2.363647845572374e-21, -1.290729134800403e-23,  2.653242563583956e-26,  4.727489281157806e-29,  3.761131238624513e-01,
 -1.761463501270881e-03,  4.816658714859010e-06, -5.932476570397785e-09, -1.635368338089883e-11,  1.116285378613776e-13, -2.439573277691061e-16, -3.051067519852671e-19,
  4.023983847914233e-21, -1.214238323705187e-23, -2.185124321865836e-27,  1.663408465096030e-28,  4.344172420404531e-01, -1.966099725619972e-03,  4.899976248435463e-06,
 -3.622135363262928e-09, -2.663579242674114e-11,  1.200068165507427e-13, -1.267166645958438e-16, -9.144868906481951e-19,  4.762766114765301e-21, -5.799385024730576e-24,
 -4.033315306281820e-26,  2.270233792646282e-28,  4.958501876682004e-01, -2.161447385935424e-03,  4.831592443799434e-06, -8.098748509108583e-10, -3.580761506995045e-11,
  1.124364677366185e-13,  3.992885129775349e-17, -1.423788580714606e-18,  4.079412152633159e-21,  4.877868150406619e-24, -7.019764452476606e-26,  1.692013925936335e-28,
  5.601162283353559e-01, -2.343376625010143e-03,  4.604251453661048e-06,  2.351780496490009e-09, -4.273799951534453e-11,  8.780201263043664e-14,  2.290132748019908e-16,
 -1.671483171168938e-18,  1.889704335910325e-21,  1.635699537992853e-23, -7.362562201464421e-26, -8.543266755765243e-30,  6.269011296333366e-01, -2.507947242057863e-03,
  4.217442641333011e-06,  5.672660195059693e-09, -4.644630377885641e-11,  4.766285751857498e-14,  4.045992328246775e-16, -1.543257530815687e-18, -1.360999569316753e-21,
  2.394078217030575e-23, -4.204539856755535e-26, -2.313503457844646e-28,  6.958729867313543e-01, -2.651493430884474e-03,  3.677710318784537e-06,  8.937580793301762e-09,
 -4.623372832694235e-11, -3.722061251145373e-15,  5.288350338011734e-16, -1.013296728610320e-18, -4.767475630450064e-21,  2.366894643703198e-23,  1.660401915558720e-26,
 -3.769338361469593e-28,  7.666832021667888e-01, -2.770707622624855e-03,  2.998661315098817e-06,  1.192181307003038e-08, -4.179072820883711e-11, -5.984072019535779e-14,
  5.703378933366833e-16, -1.646966818664033e-19, -7.221027150829299e-21,  1.424090561723235e-23,  7.867053330675771e-26, -3.426038140651401e-28,  8.389676238527580e-01,
 -2.862721678634176e-03,  2.200647487214554e-06,  1.440834958417782e-08, -3.326484709561581e-11, -1.128148452539742e-13,  5.120469195496814e-16,  8.202807540636553e-19,
 -7.783081528117132e-21, -1.948497497603663e-24,  1.144320655514468e-25, -1.141938271786424e-28,  9.123478565220708e-01, -2.925183499720336e-03,  1.310113061191436e-06,
  1.620568840994488e-08, -2.127678047596685e-11, -1.546124722153756e-13,  3.565845650275358e-16,  1.701159817826799e-18, -6.048972059883500e-21, -1.930115910583806e-23,
  1.028111069047762e-25,  2.085205773923870e-28,  9.864327585453959e-01, -2.956326965400130e-03,  3.586118584109349e-07,  1.716467599517901e-08, -6.877967232989713e-12,
 -1.783982789732258e-13,  1.275385833203254e-16,  2.242653503179604e-18, -2.359330710415328e-21, -3.104591244008946e-23,  4.376111797281255e-26,  4.550070423809269e-28,
  1.060820134220710e+00, -2.955033005203089e-03, -6.184833939472681e-07,  1.719288500984437e-08,  8.549911025399139e-12, -1.797867964408839e-13, -1.340949273875969e-16,
  2.283382633721230e-18,  2.243432859535302e-21, -3.207309530292239e-23, -3.900753654981193e-26,  4.791220702840823e-28,  1.135098629177102e+00, -2.920879548485399e-03,
 -1.583539004647759e-06,  1.626506564633360e-08,  2.344522205851670e-11, -1.577561655092916e-13, -3.779306243484284e-16,  1.788869420440967e-18,  6.327837869615103e-21,
 -2.133985538951058e-23, -1.078757591917866e-25,  2.515848403469519e-28,  1.208849833428259e+00, -2.854178115616828e-03, -2.498425988227425e-06,  1.442841656055591e-08,
  3.625041317826453e-11, -1.150195905806414e-13, -5.551110603434623e-16,  8.703570512299518e-19,  8.562471277291475e-21, -2.653861432334991e-24, -1.297812555303904e-25,
 -1.114317747442070e-28,  1.281650592828062e+00, -2.755994917283641e-03, -3.326415859209479e-06,  1.180177763872995e-08,  4.560731547549774e-11, -5.773694225532082e-14,
 -6.296343381596057e-16, -2.398031457808272e-19,  8.205835208688563e-21,  1.670738896954152e-23, -9.380959644292985e-26, -4.097321728610582e-28,  1.353075525226803e+00,
 -2.628154533949123e-03, -4.034113041763161e-06,  8.568338367809235e-09,  5.053736845075756e-11,  5.431069127386668e-15, -5.872397160799101e-16, -1.251922347551835e-18,
  5.401839424415173e-21,  2.907197578977528e-23, -1.784478372431812e-26, -4.783685605786896e-28,  1.422699732537582e+00, -2.473224565126733e-03, -4.593318188802017e-06,
  4.962051998778696e-09,  5.058003044569208e-11,  6.478982336115917e-14, -4.393748545646565e-16, -1.903966045643413e-18,  1.147760143006048e-21,  2.978059474484060e-23,
  6.031917999214738e-26, -2.897332057505465e-28,  1.490101694272098e+00, -2.294480074277151e-03, -4.982709776289748e-06,  1.248597672587954e-09,  4.586634940923993e-11,
  1.113420760482455e-13, -2.208804539781208e-16, -2.040980955236628e-18, -3.072041168594673e-21,  1.928097615568852e-23,  1.031326068839404e-25,  3.062475006328418e-29,
  1.554866322009457e+00, -2.095847209736717e-03, -5.189231116638063e-06, -2.297625243709949e-09,  3.711245262492638e-11,  1.384487820358470e-13,  1.835186688841169e-17,
 -1.662020394845736e-18, -5.851352611097752e-21,  2.823141215326829e-24,  9.339819938265629e-26,  2.876146602286405e-28,  1.616588147881864e+00, -1.881826047150673e-03,
 -5.209077556335498e-06, -5.418430596612113e-09,  2.552884090149485e-11,  1.430724466760485e-13,  2.257833596671543e-16, -9.172892869840044e-19, -6.396850032141345e-21,
 -1.214841850626101e-23,  4.253150760902071e-26,  3.435155882472810e-28,  1.674874613703999e+00, -1.657393457380031e-03, -5.048194734250598e-06, -7.896276216235685e-09,
  1.265438845827972e-11,  1.263209674200216e-13,  3.594389300348728e-16, -5.511384774736721e-20, -4.805424358684438e-21, -1.959915815156971e-23, -1.787047210354660e-26,
  2.003779121004359e-28,  1.729349421087711e+00, -1.427887629019867e-03, -4.722223357378415e-06, -9.575607344263033e-09,  1.368213443473393e-13,  9.314601237093287e-14,
  3.982469340079940e-16,  6.633557548022129e-19, -1.964257481322237e-21, -1.764132040756903e-23, -5.564509086061208e-26, -1.755844079846725e-29,  1.779655897056995e+00,
 -1.198876730168410e-03, -4.255858172331672e-06, -1.037866076731374e-08, -1.050814174204964e-11,  5.123238079550455e-14,  3.464975951097311e-16,  1.051174298739679e-18,
  8.775261666253721e-22, -8.998673850913422e-24, -5.634711906290545e-26, -1.627278274312194e-28,  1.825460324627558e+00, -9.760150350688999e-04, -3.681626969315745e-06,
 -1.031371666073152e-08, -1.812103428401744e-11,  9.303496604551925e-15,  2.310601456707734e-16,  1.052428197381623e-18,  2.664730274808119e-21,  9.396302413352612e-25,
 -2.890846765933209e-26, -1.665575225184593e-28,  1.866455183890559e+00, -7.648906164191324e-04, -3.038136996149829e-06, -9.474509720873636e-09, -2.206877359168681e-11,
 -2.478352360708793e-14,  9.218128085615820e-17,  7.481665322808942e-19,  2.959758479154925e-21,  7.258756647682142e-24,  3.808020497758930e-27, -7.024130300695407e-29,
  1.902362246766420e+00, -5.708693586328238e-04, -2.367877817959777e-06, -8.030457437757766e-09, -2.233040660949350e-11, -4.571345915130642e-14, -2.927871566424885e-17,
  3.107680879210738e-19,  2.042999859163738e-21,  8.002023169460980e-24,  2.178388591336756e-26,  2.939460938131969e-29,  1.932935468502573e+00, -3.989405252642574e-04,
 -1.714707710170695e-06, -6.208427502282759e-09, -1.948145843572915e-11, -5.175917897049501e-14, -1.041261289248026e-16, -7.309678054430594e-20,  6.641441229975857e-22,
  4.640019923224041e-24,  1.981354455151012e-26,  6.426817229852035e-29,  1.957963623435727e+00, -2.535693553351445e-04, -1.121181264198945e-06, -4.267815308870351e-09,
 -1.457712866546127e-11, -4.494181468196385e-14, -1.226983513547157e-16, -2.780402391677030e-19, -4.037059165582347e-22,  4.756050249041050e-25,  7.122214169259291e-27,
  3.780590352525996e-29,  1.977272653193559e+00, -1.385620606505280e-04, -6.258952358642947e-07, -2.471590653088022e-09, -8.952774159772515e-12, -3.026438974139597e-14,
 -9.583063083797009e-17, -2.824644729292520e-19, -7.601077415687452e-22, -1.778966051253747e-24, -3.104161188588376e-27, -6.356884752180964e-31,  1.990727827326285e+00,
 -5.694754167677872e-05, -2.610323975518676e-07, -1.056554968278329e-09, -3.975694859679959e-12, -1.421341295914416e-14, -4.878132793896522e-17, -1.614969650495440e-19,
 -5.164486655879489e-22, -1.593090988432659e-24, -4.719475164342120e-27, -1.330972582405238e-29,  1.998237629636914e+00, -1.086843265399620e-05, -5.022285565150400e-08,
 -2.060408773385903e-10, -7.912492845582569e-13, -2.911692859509106e-15, -1.039453416254802e-17, -3.625989890717758e-20, -1.241576489420613e-22, -4.185313891547735e-25,
 -1.391699400619028e-27, -4.570776039750370e-30,  6.229584131843533e-04, -3.498793310940265e-06,  1.473358908475029e-08, -5.512916225377446e-11,  1.932903861159312e-13,
 -6.502158862968577e-16,  2.125046711295163e-18, -6.798033500328100e-21,  2.138786498825315e-23, -6.639327376377025e-26,  2.038127047311060e-28, -6.197291110188148e-31,
  5.602907960568957e-03, -3.139778107807219e-05,  1.316140011411222e-07, -4.886768257710741e-10,  1.693421199243622e-12, -5.602802833962944e-15,  1.790454045837972e-17,
 -5.561625908292196e-20,  1.685123018368123e-22, -4.988729906563817e-25,  1.443522141346956e-27, -4.079163471146631e-30,  1.554297562991450e-02, -8.670975494784241e-05,
  3.601416366542769e-07, -1.316416017063566e-09,  4.453279398240716e-12, -1.422906951121428e-14,  4.330797559620356e-17, -1.258226923291614e-19,  3.479064276280015e-22,
 -9.074475200107618e-25,  2.190401802645721e-27, -4.686449514580495e-30,  3.040348260343693e-02, -1.684686906497356e-04,  6.900304474632783e-07, -2.462325484693637e-09,
  8.020047381045912e-12, -2.420260014210935e-14,  6.765078182200314e-17, -1.726715537964671e-19,  3.869331951181715e-22, -6.766711958167207e-25,  4.268266133726272e-28,
  3.539380140954476e-30,  5.012487196500048e-02, -2.752405162049698e-04,  1.106298234776716e-06, -3.818956642232293e-09,  1.178178947594403e-11, -3.257745526555072e-14,
  7.861620785920763e-17, -1.512646799165446e-19,  1.462582206668097e-22,  5.289658022621158e-25, -4.214678320729229e-27,  1.843893770555113e-29,  7.462766572310899e-02,
 -4.051411134700906e-04,  1.589791795061971e-06, -5.254933999285505e-09,  1.504088726814101e-11, -3.634747655157365e-14,  6.577693839426553e-17, -3.544005833359829e-20,
 -3.930598845436435e-22,  2.424810039349638e-24, -9.396470270678117e-27,  2.779495216505798e-29,  1.038124132948922e-01, -5.558603856189018e-04,  2.117868484079936e-06,
 -6.624303252225897e-09,  1.710034856075949e-11, -3.304950418440440e-14,  2.393015656058007e-17,  1.677680030880044e-19, -1.085721436362393e-21,  4.076846963948333e-24,
 -1.085839657066317e-26,  1.664850548081675e-29,  1.375596364809659e-01, -7.246924299634425e-04,  2.665217999335264e-06, -7.777194979770153e-09,  1.735418903235511e-11,
 -2.131242999466385e-14, -4.457073816095343e-17,  4.133606045780073e-19, -1.647129375767625e-21,  4.259679252151210e-24, -4.933200696553042e-27, -1.972397804120102e-29,
  1.757297773005745e-01, -9.085718443431520e-04,  3.204803894282331e-06, -8.571173848786019e-09,  1.537226453180105e-11, -1.256816327467492e-15, -1.291394206500217e-16,
  6.260797304339627e-19, -1.747806070837013e-21,  2.086859122838943e-24,  8.476426675219092e-27, -6.629757153696755e-29,  2.181631564422060e-01, -1.104116169902229e-03,
  3.708899973308194e-06, -8.882569796415862e-09,  1.096994251196447e-11,  2.533336026170417e-14, -2.122709970545830e-16,  7.198422887141168e-19, -1.149868828621697e-21,
 -2.364092740418896e-24,  2.432770465835194e-26, -9.126468490309718e-29,  2.646799515172821e-01, -1.307674430450128e-03,  4.150192340651564e-06, -8.617044661567656e-09,
  4.253914616029031e-12,  5.511555971672895e-14, -2.727672997185223e-16,  6.244563880571477e-19,  1.632492622322569e-22, -7.763566170394423e-24,  3.371852999576708e-26,
 -6.358809106515355e-29,  3.150802057786404e-01, -1.515381665829747e-03,  4.502913599365752e-06, -7.718641081759261e-09, -4.362719107478815e-12,  8.357912484853990e-14,
 -2.903506065416780e-16,  3.123145947068099e-19,  1.918521687879868e-21, -1.181183208541963e-23,  2.806448681721141e-26,  2.310019216808642e-29,  3.691438794698556e-01,
 -1.723219271034072e-03,  4.743971679451362e-06, -6.176595706797577e-09, -1.418028087929342e-11,  1.056851926888593e-13, -2.507633266815326e-16, -1.833363816990075e-19,
  3.586965555796578e-21, -1.209251329555213e-23,  4.455929777146600e-27,  1.357789362639026e-28,  4.266309574866064e-01, -1.927080841770620e-03,  4.854032234203723e-06,
 -4.029280588618018e-09, -2.426805400254073e-11,  1.166753676032877e-13, -1.502220726784759e-16, -7.657109246770365e-19,  4.527314208259223e-21, -7.217554802345155e-24,
 -3.069758664633895e-26,  2.102636613458685e-28,  4.872816285286147e-01, -2.122843088873672e-03,  4.818510754877399e-06, -1.364768077156518e-09, -3.355245508819675e-11,
  1.129312616077586e-13,  1.912968929249876e-18, -1.290964789429013e-18,  4.206314320275547e-21,  2.223893429401146e-24, -6.239275649151535e-26,  1.840936018514251e-28,
  5.508165523608034e-01, -2.306441217332110e-03,  4.628428845177991e-06,  1.682303676761058e-09, -4.093074945095208e-11,  9.274406982709763e-14,  1.831428053583699e-16,
 -1.602159243928424e-18,  2.425588970967837e-21,  1.341903750869207e-23, -7.292594912566166e-26,  3.899700137650234e-29,  6.169372331339056e-01, -2.473947970830421e-03,
  4.281088844689741e-06,  4.937658218928742e-09, -4.539946501945900e-11,  5.685056748880151e-14,  3.609054372054162e-16, -1.573363102672172e-18, -5.317013823890651e-22,
  2.207250232789419e-23, -5.094556984950485e-26, -1.733080370307189e-28,  6.853265178734305e-01, -2.621655321256584e-03,  3.780522600541113e-06,  8.197925264538489e-09,
 -4.618363304027435e-11,  8.613063780245889e-15,  4.984557211719169e-16, -1.152126375721797e-18, -3.907356118987956e-21,  2.401028561212422e-23,  7.005809186262348e-28,
 -3.443483570662223e-28,  7.556492401536387e-01, -2.746157538290439e-03,  3.137674070861763e-06,  1.124432859266105e-08, -4.285116791008139e-11, -4.623356538994300e-14,
  5.625725948737134e-16, -3.869893872793528e-19, -6.655411731317292e-21,  1.707909636596447e-23,  6.309005607086962e-26, -3.630645631030692e-28,  8.275530295383122e-01,
 -2.844434113098621e-03,  2.370281982108890e-06,  1.385873666680499e-08, -3.539653795435092e-11, -1.002782819726240e-13,  5.315236498065916e-16,  5.709720831236229e-19,
 -7.772246460009991e-21,  2.506564125320966e-24,  1.078022092345173e-25, -1.853870321744700e-28,  9.006693074882622e-01, -2.913930741382612e-03,  1.502438256452498e-06,
  1.584100270662693e-08, -2.427970705716750e-11, -1.455053392789501e-13,  4.014083979519494e-16,  1.497285408555447e-18, -6.667804616570721e-21, -1.503008139345155e-23,
  1.101220634272310e-25,  1.233611890446578e-28,  9.746144899917456e-01, -2.952636306871711e-03,  5.638105392953728e-07,  1.702627228860146e-08, -1.041028564072786e-11,
 -1.745933724129867e-13,  1.891105125851026e-16,  2.149648729680947e-18, -3.440764728424716e-21, -2.890782215769358e-23,  6.279833592772110e-26,  4.076709597364430e-28,
  1.048991416046430e+00, -2.959153562601912e-03, -4.114671483566491e-07,  1.730076470902566e-08,  4.927208387893519e-12, -1.822308224948471e-13, -6.933064081806342e-17,
  2.336439009340544e-18,  1.065875654190030e-21, -3.320335904537619e-23, -1.733205563680819e-26,  5.029368050932439e-28,  1.123391019186969e+00, -2.932761003176168e-03,
 -1.386213143519691e-06,  1.661447282357627e-08,  2.020356769009218e-11, -1.662032979654497e-13, -3.251287049795038e-16,  1.978258870733956e-18,  5.484834486254420e-21,
 -2.540789236009308e-23, -9.490802714436966e-26,  3.363760262459163e-28,  1.197394256393427e+00, -2.873463278904641e-03, -2.321883183577044e-06,  1.498930501344790e-08,
  3.381892819168228e-11, -1.280189784697366e-13, -5.269266291914251e-16,  1.141817635459567e-18,  8.372556711388231e-21, -7.915748136104376e-24, -1.326191983448623e-25,
 -1.622543127262298e-29,  1.270574304831054e+00, -2.782027446744404e-03, -3.180456996154059e-06,  1.252143399016928e-08,  4.430107612762210e-11, -7.289853892582041e-14,
 -6.325875557270844e-16,  3.164827776124202e-20,  8.735523756470793e-21,  1.260682459943307e-23, -1.108772793982760e-25, -3.628728253217291e-28,  1.342499031886951e+00,
 -2.660002408654926e-03, -3.926440321665231e-06,  9.377027918941439e-09,  5.050231797356636e-11, -9.062835821628272e-15, -6.197174038018122e-16, -1.062497555025060e-18,
  6.430420476592801e-21,  2.792764722423543e-23, -3.957957241356242e-26, -5.068643191048149e-28,  1.412733737849778e+00, -2.509719079704420e-03, -4.528877025848062e-06,
  5.781107874594050e-09,  5.176608446444609e-11,  5.361025118736979e-14, -4.920073662128617e-16, -1.849644801162692e-18,  2.260001421804063e-21,  3.191451733508717e-23,
  4.578904021072294e-26, -3.703881284255453e-28,  1.480844163345324e+00, -2.334269176880736e-03, -4.963250935456864e-06,  1.999966345691646e-09,  4.803549609157419e-11,
  1.053447369204001e-13, -2.792941611454846e-16, -2.127382898416653e-18, -2.303542694969865e-21,  2.341143219565971e-23,  1.028287976241487e-25, -4.643171197912688e-29,
  1.546399745381857e+00, -2.137461039576875e-03, -5.213148414541859e-06, -1.681666467390161e-09,  3.988195439570609e-11,  1.383097497913655e-13, -3.078554907315268e-17,
 -1.846892129951273e-18, -5.679480232499916e-21,  6.805666091523480e-24,  1.055397192586889e-25,  2.617273620180763e-28,  1.608977096743781e+00, -1.923751589087376e-03,
 -5.271552598117960e-06, -4.986792283020608e-09,  2.844227621522146e-11,  1.481595154752713e-13,  1.971702387383698e-16, -1.128627462744875e-18, -6.799836002465168e-21,
 -1.013487794639486e-23,  5.838056645859201e-26,  3.757390909532191e-28,  1.668163673758002e+00, -1.698154399469621e-03, -5.141650339649395e-06, -7.673126783450921e-09,
  1.526685556483731e-11,  1.349109506397494e-13,  3.556359626316053e-16, -2.202962790754278e-19, -5.521586811156908e-21, -2.012119437787943e-23, -7.815923874807673e-27,
  2.573919878011341e-28,  1.723561587495247e+00, -1.466124862829320e-03, -4.837054335166414e-06, -9.557989347078340e-09,  2.096786092536001e-12,  1.029191213603338e-13,
  4.158423645633053e-16,  5.899076490696262e-19, -2.639499738920228e-21, -1.987190653075873e-23, -5.560319300782385e-26,  2.104031859810426e-29,  1.774791503698648e+00,
 -1.233424548619801e-03, -4.381375578697612e-06, -1.053813196111644e-08, -9.397935568770467e-12,  5.990437554566389e-14,  3.762717237729292e-16,  1.073622868757159e-18,
  5.112748614263724e-22, -1.139607001903271e-23, -6.352008903646583e-26, -1.623439017675237e-28,  1.821496567676002e+00, -1.005968021995163e-03, -3.807124044436184e-06,
 -1.060185315459691e-08, -1.787707310892559e-11,  1.521221455357232e-14,  2.617253433537656e-16,  1.138002849648491e-18,  2.675910341018177e-21, -3.705805787039065e-25,
 -3.678451842575625e-26, -1.915953499714128e-28,  1.863346282647158e+00, -7.896565284151918e-04, -3.153965662885368e-06, -9.831447939530772e-09, -2.254056737481954e-11,
 -2.230884407553249e-14,  1.144953726234933e-16,  8.470828107402670e-19,  3.223011074396434e-21,  7.342662665811061e-24,  2.163512557692107e-28, -9.371684246172174e-29,
  1.900040264305256e+00, -5.902039867213795e-04, -2.466417312392507e-06, -8.395093181529123e-09, -2.325095853104646e-11, -4.630407050938583e-14, -1.961742511716499e-17,
  3.809238599860256e-19,  2.347054858507713e-21,  8.897679161959940e-24,  2.295543303061184e-26,  2.341403605514462e-29,  1.931311791651943e+00, -4.129615699818080e-04,
 -1.791113662887766e-06, -6.528548737005173e-09, -2.054178498272249e-11, -5.428020508414046e-14, -1.058490672152516e-16, -4.901289581486747e-20,  8.461518310031092e-22,
  5.491290005320785e-24,  2.280426103771793e-26,  7.172104684520529e-29,  1.956931077071190e+00, -2.627476949268648e-04, -1.173824639427924e-06, -4.508402729501019e-09,
 -1.550605062858396e-11, -4.798143856613970e-14, -1.306613528314412e-16, -2.906265112233405e-19, -3.810351259094845e-22,  7.959911505364330e-25,  8.954603189233035e-27,
  4.570529391753581e-29,  1.976708199286739e+00, -1.436903408706654e-04, -6.564341767746788e-07, -2.619805044423229e-09, -9.581716394554668e-12, -3.266204152719251e-14,
 -1.040899631573905e-16, -3.078365983223241e-19, -8.263883182538164e-22, -1.903252359882953e-24, -3.098367938583007e-27,  9.846361368570366e-31,  1.990495778787359e+00,
 -5.908761891010781e-05, -2.741023150658655e-07, -1.122505414699169e-09, -4.272046793788958e-12, -1.544034961242348e-14, -5.354350031429539e-17, -1.789785529593274e-19,
 -5.773437369406253e-22, -1.794094919244549e-24, -5.343792469098179e-27, -1.510475989656073e-29,  1.998193336371713e+00, -1.128032519670874e-05, -5.277327269771769e-08,
 -2.191806446751738e-10, -8.520624481655385e-13, -3.173808275627443e-15, -1.146777799139929e-17, -4.048516797640882e-20, -1.402772475972078e-22, -4.784405132296726e-25,
 -1.609402323085594e-27, -5.346274751460555e-30,  6.091948604923860e-04, -3.383519193705919e-06,  1.409017467494291e-08, -5.213784291042702e-11,  1.807810521860393e-13,
 -6.014237195060943e-16,  1.943935132919929e-18, -6.150342710224833e-21,  1.913811360310102e-23, -5.876073198095026e-26,  1.784193339847305e-28, -5.366358032654262e-31,
  5.479386160069815e-03, -3.036787331317192e-05,  1.259088240251494e-07, -4.624557062285787e-10,  1.585539174761280e-12, -5.191187790138417e-15,  1.642015627845904e-17,
 -5.050041407129762e-20,  1.515503594423538e-22, -4.445684969725612e-25,  1.275368249421770e-27, -3.575702826392826e-30,  1.520180051069158e-02, -8.389061979856769e-05,
  3.447629477995100e-07, -1.247384899792677e-09,  4.178812932046946e-12, -1.323072608251660e-14,  3.993600944063670e-17, -1.151958632575854e-19,  3.167667128520447e-22,
 -8.238456788219215e-25,  1.992385655463992e-27, -4.316452350534662e-30,  2.974046422316888e-02, -1.630644934632817e-04,  6.612367738047815e-07, -2.337790544948058e-09,
  7.551847082700646e-12, -2.263562225382230e-14,  6.298568740436888e-17, -1.606758737000602e-19,  3.629149698287123e-22, -6.567996079556098e-25,  5.593505232294769e-28,
  2.522323092344868e-30,  4.904132489098448e-02, -2.665702844576512e-04,  1.061580633902684e-06, -3.635559318235183e-09,  1.114876799605267e-11, -3.074094586909523e-14,
  7.444896022607592e-17, -1.463107350154394e-19,  1.624540614865574e-22,  3.757448517843076e-25, -3.466892988306732e-27,  1.562018957046028e-29,  7.303214426652585e-02,
 -3.926709795129011e-04,  1.528152799774331e-06, -5.020009988068123e-09,  1.432963681178801e-11, -3.478208107057141e-14,  6.462114543085800e-17, -4.669148289142793e-20,
 -3.122450735735978e-22,  2.072574869337907e-24, -8.235714383877463e-27,  2.499103778771709e-29,  1.016223607016821e-01, -5.392308030324222e-04,  2.039996771120958e-06,
 -6.355952862772803e-09,  1.644546248718657e-11, -3.242260369558398e-14,  2.816273207940430e-17,  1.352908044968443e-19, -9.465938462326841e-22,  3.657437925390008e-24,
 -1.010645518176120e-26,  1.742030359247407e-29,  1.347029258031292e-01, -7.037393037417614e-04,  2.573543417752849e-06, -7.502992234455934e-09,  1.691815077179265e-11,
 -2.224905427446943e-14, -3.371178252577193e-17,  3.630663873255716e-19, -1.497522426742046e-21,  4.047120539620607e-24, -5.644768386415752e-27, -1.286018479109878e-29,
  1.721461212753862e-01, -8.833406512529801e-04,  3.103424186522113e-06, -8.325581257209485e-09,  1.531752233277341e-11, -4.152048081088364e-15, -1.123804767464004e-16,
  5.714119011675379e-19, -1.667248512594120e-21,  2.370920078269405e-24,  5.807206218625746e-27, -5.523354251534810e-29,  2.138053633478673e-01, -1.074868312899565e-03,
  3.603378092159824e-06, -8.703267402812700e-09,  1.142727548159677e-11,  2.047649329924276e-14, -1.926420544923285e-16,  6.818648626076995e-19, -1.218406862297757e-21,
 -1.468968657891771e-24,  2.048714113221560e-26, -8.322005934505219e-29,  2.595150037186176e-01, -1.274885271309583e-03,  4.047231420878120e-06, -8.540513274487185e-09,
  5.292179913900009e-12,  4.877930310136535e-14, -2.552495778680879e-16,  6.254632973589393e-19, -9.264909751091505e-23, -6.472169630758539e-24,  3.082248799650979e-26,
 -6.755404386762634e-29,  3.090901376053174e-01, -1.479729913870672e-03,  4.409925029545316e-06, -7.775447451603244e-09, -2.760078212206160e-12,  7.672220024930306e-14,
 -2.808086714688519e-16,  3.671219457466940e-19,  1.513690635733306e-21, -1.067506745417060e-23,  2.862934566307123e-26,  3.269252891565519e-30,  3.623264312751964e-01,
 -1.685567672719496e-03,  4.668559912789850e-06, -6.386899082559877e-09, -1.212711069916863e-11,  9.961784155598043e-14, -2.543549190918368e-16, -7.547320350248882e-20,
  3.156204616288575e-21, -1.180338474746721e-23,  9.791783350454252e-27,  1.071318130495897e-28,  4.189999833231853e-01, -1.888448414237061e-03,  4.803427485945115e-06,
 -4.399104281618320e-09, -2.197225302208002e-11,  1.128288816408030e-13, -1.696743896590507e-16, -6.252134106439682e-19,  4.247557662905180e-21, -8.266172663903109e-24,
 -2.188060196709079e-26,  1.900623244109470e-28,  4.788672359649430e-01, -2.084369466358318e-03,  4.798987012055995e-06, -1.883547877756316e-09, -3.129621979156739e-11,
  1.125586758754447e-13, -3.234092217658520e-17, -1.155547436530097e-18,  4.243427545587628e-21, -1.073216682227272e-25, -5.412040671696864e-26,  1.906481327354848e-28,
  5.416649546783916e-01, -2.269344026710544e-03,  4.644749080749707e-06,  1.042474465699107e-09, -3.903550032770234e-11,  9.661036891901480e-14,  1.394376434586810e-16,
 -1.517369924778617e-18,  2.856692807141869e-21,  1.054845796151885e-23, -7.031791811768136e-26,  7.814056791617388e-29,  6.071102966184183e-01, -2.439474511736898e-03,
  4.336021399524774e-06,  4.220818486360651e-09, -4.417941162538591e-11,  6.498244515466340e-14,  3.167296390125989e-16, -1.578070994089815e-18,  2.245430987746983e-22,
  1.989893233812104e-23, -5.732287749431196e-26, -1.170394585216101e-28,  6.749009902803303e-01, -2.591030184728421e-03,  3.874471834484051e-06,  7.461004000143838e-09,
 -4.589442504730723e-11,  2.017555577656570e-14,  4.645755010149802e-16, -1.263355394457197e-18, -3.046028803160016e-21,  2.374681857085109e-23, -1.357543780925173e-26,
 -3.034084694659395e-28,  7.447156508130627e-01, -2.720528138997696e-03,  3.268464152915365e-06,  1.055204202062814e-08, -4.364182139164326e-11, -3.288533276069951e-14,
  5.488509902269224e-16, -5.896693753167409e-19, -5.999015610045843e-21,  1.928052488400453e-23,  4.694118291630549e-26, -3.686031261088654e-28,  8.162142570740928e-01,
 -2.824816413635049e-03,  2.533124829594570e-06,  1.327704557263872e-08, -3.727338774006125e-11, -8.735785948377036e-14,  5.440483027481277e-16,  3.245191368374075e-19,
 -7.606527504801925e-21,  6.637117654749766e-24,  9.829301696689176e-26, -2.447363925877980e-28,  8.890388178404085e-01, -2.901157688979793e-03,  1.690105136969471e-06,
  1.542978379025243e-08, -2.709020660199027e-11, -1.353930299435180e-13,  4.402699852745384e-16,  1.276117575655154e-18, -7.128522354614481e-21, -1.054198018893110e-23,
  1.136577338976754e-25,  3.757434314335896e-29,  9.628142553842876e-01, -2.947311656764322e-03,  7.670120418653852e-07,  1.683203960754787e-08, -1.385195947830229e-11,
 -1.693458233498148e-13,  2.476064199540969e-16,  2.023412226340592e-18, -4.432064202178562e-21, -2.605442254525237e-23,  7.941977954515682e-26,  3.456820210175732e-28,
  1.037149534706019e+00, -2.961613800349608e-03, -2.035054641271484e-07,  1.735037500253505e-08,  1.271266846145913e-12, -1.831069683458616e-13, -3.613235144986804e-18,
  2.351331562961615e-18, -1.365645486879710e-22, -3.345141175889672e-23,  4.958897841992088e-27,  5.069815588869655e-28,  1.111639065885647e+00, -2.943047973546974e-03,
 -1.185010942365525e-06,  1.691073258988273e-08,  1.680605635379953e-11, -1.733227293640941e-13, -2.674228075576003e-16,  2.138436260605383e-18,  4.505591268714221e-21,
 -2.888556173537555e-23, -7.843801319978686e-26,  4.101037764035371e-28,  1.185864405058416e+00, -2.891309857980947e-03, -2.138851593569054e-06,  1.550924912669259e-08,
  3.113483108933749e-11, -1.402515915953042e-13, -4.912549688310485e-16,  1.404156522164656e-18,  7.992199963024674e-21, -1.320529000035896e-23, -1.311201505368233e-25,
  8.499360618885911e-29,  1.259396276219900e+00, -2.806858140150641e-03, -3.025997667846911e-06,  1.321776342246432e-08,  4.269152102913275e-11, -8.803803079169638e-14,
 -6.277259395973889e-16,  3.175604196620202e-19,  9.105851736674082e-21,  7.870442888909414e-24, -1.254621664168932e-25, -2.970435825345651e-28,  1.331796931229361e+00,
 -2.690950116331883e-03, -3.809076389875328e-06,  1.018279715643452e-08,  5.017004340633743e-11, -2.426888331574908e-14, -6.464377951489526e-16, -8.409872476217771e-19,
  7.401900305720719e-21,  2.589392743466117e-23, -6.218318530951692e-26, -5.173617158815841e-28,  1.402622858843000e+00, -2.545658445125731e-03, -4.454500930446795e-06,
  6.617283840731010e-09,  5.271605950913526e-11,  4.118983933798146e-14, -5.426098898431194e-16, -1.758621761329679e-18,  3.437754782291294e-21,  3.339717833856260e-23,
  2.778654653723950e-26, -4.468558403912280e-28,  1.471427845273914e+00, -2.373865962668162e-03, -4.934571639571853e-06,  2.785004849184446e-09,  5.007049568591669e-11,
  9.791935380167470e-14, -3.397605375362982e-16, -2.186822933120352e-18, -1.387415174858520e-21,  2.745848958277392e-23,  9.888095867476725e-26, -1.346922385943795e-28,
  1.537766378633672e+00, -2.179235889110826e-03, -5.229408639055747e-06, -1.021483730156032e-09,  4.263646703879056e-11,  1.369300599169298e-13, -8.500016736241829e-17,
 -2.023878787442043e-18, -5.355811919284465e-21,  1.124639560870852e-23,  1.161896713478890e-25,  2.195427307317163e-28,  1.601197377770431e+00, -1.966155412785039e-03,
 -5.328565059302102e-06, -4.507764422166137e-09,  3.145009921029420e-11,  1.524874739670056e-13,  1.624708962011185e-16, -1.351576395361598e-18, -7.118602014385507e-21,
 -7.461316712745813e-24,  7.546997731467187e-26,  3.993676260427394e-28,  1.661288212733669e+00, -1.739651551622016e-03, -5.232171706096666e-06, -7.406810058037154e-09,
  1.804982154302832e-11,  1.433515572344640e-13,  3.468848033053545e-16, -4.086139989839278e-19, -6.248687470536470e-21, -2.018966418502886e-23,  4.834856698115021e-27,
  3.181038434988254e-28,  1.717618969783263e+00, -1.505279350686258e-03, -4.951479217815692e-06, -9.507426016146849e-09,  4.256256410070508e-12,  1.130873263422833e-13,
  4.310666900806423e-16,  4.935707900177038e-19, -3.394577528686717e-21, -2.206397170125546e-23, -5.364637958655135e-26,  6.961122572842899e-29,  1.769786899112199e+00,
 -1.268983845528704e-03, -4.508694209789791e-06, -1.067841332268004e-08, -8.107099986365218e-12,  6.929708601457734e-14,  4.064969630285900e-16,  1.082915263770074e-18,
  5.357359186757802e-23, -1.407818089897906e-23, -7.053347080397044e-26, -1.551760220309484e-28,  1.817410969031019e+00, -1.036938740471562e-03, -3.936051305700101e-06,
 -1.088510007255310e-08, -1.750738382819879e-11,  2.188564494694381e-14,  2.947841030621259e-16,  1.223117611063289e-18,  2.633984565134058e-21, -2.018073808043938e-24,
 -4.577615146053658e-26, -2.171173050739306e-28,  1.860136437193834e+00, -8.153663271522374e-04, -3.274121150290464e-06, -1.019550885358258e-08, -2.295728291544471e-11,
 -1.926443680232114e-14,  1.396973016888474e-16,  9.544416778895110e-19,  3.486437731783970e-21,  7.260961522362877e-24, -4.504808549265291e-27, -1.216495937438777e-28,
  1.897639338632942e+00, -6.103446844837019e-04, -2.569421155855819e-06, -8.774538967491578e-09, -2.418083904699767e-11, -4.663810898923729e-14, -7.850647763682698e-18,
  4.613337699805320e-19,  2.684125975209156e-21,  9.834089983409025e-24,  2.379944063254491e-26,  1.438518176938736e-29,  1.929630783385750e+00, -4.276095203945514e-04,
 -1.871464532269162e-06, -6.866040565879047e-09, -2.165288741034828e-11, -5.683380223353833e-14, -1.068113418598295e-16, -1.859069860804975e-20,  1.061038276263833e-21,
  6.468817859136310e-24,  2.612781455931481e-26,  7.936221040134490e-29,  1.955860956406755e+00, -2.723589870716604e-04, -1.229446280323948e-06, -4.764349743321897e-09,
 -1.649770426461599e-11, -5.121631031523239e-14, -1.389647745708651e-16, -3.022879254681737e-19, -3.454236503495183e-22,  1.197033444047480e-24,  1.116551513588098e-26,
  5.504562728041404e-29,  1.976122732125282e+00, -1.490702216967785e-04, -6.888136868436981e-07, -2.778477151877507e-09, -1.026065270496752e-11, -3.526668612238535e-14,
 -1.130900801503499e-16, -3.354010973391858e-19, -8.971203817815026e-22, -2.025717926854832e-24, -3.008831093365711e-27,  3.194916358682831e-30,  1.990254955692276e+00,
 -6.133550361883465e-05, -2.879929180806532e-07, -1.193400182276713e-09, -4.594121197595105e-12, -1.678767927523589e-14, -5.882356125298567e-17, -1.985295395985692e-19,
 -6.459440979200730e-22, -2.021717968894207e-24, -6.052127209573539e-27, -1.713268341899373e-29,  1.998147353707157e+00, -1.171326873351567e-05, -5.548738265772233e-08,
 -2.333368019053683e-10, -9.183853914482373e-13, -3.463161577115079e-15, -1.266688754309364e-17, -4.526252163483628e-20, -1.587189064504962e-22, -5.477803275752180e-25,
 -1.864272236804873e-27, -6.264412584287048e-30,  5.958823322713682e-04, -3.273252138300636e-06,  1.348148665551557e-08, -4.933909630992902e-11,  1.692055227849227e-13,
 -5.567684945387926e-16,  1.779990958045704e-18, -5.570436726139109e-21,  1.714569827499424e-23, -5.207443630837054e-26,  1.564140568776339e-28, -4.654027290695275e-31,
  5.359894659984132e-03, -2.938237708205550e-05,  1.205082091956929e-07, -4.378967286857045e-10,  1.485544492203723e-12, -4.813538616068301e-15,  1.507170169445098e-17,
 -4.589732784560238e-20,  1.364274650490639e-22, -3.965669299190881e-25,  1.127902482823903e-27, -3.137251818499961e-30,  1.487166101597916e-02, -8.119127383197205e-05,
  3.301869285063420e-07, -1.182589808899493e-09,  3.923527593863521e-12, -1.230984910113151e-14,  3.684808564444606e-17, -1.055188474851535e-19,  2.884979784445291e-22,
 -7.478430928336401e-25,  1.810327257351341e-27, -3.961774208707812e-30,  2.909861122082575e-02, -1.578847929966248e-04,  6.338935870029271e-07, -2.220502064151846e-09,
  7.113893479742189e-12, -2.117666223745716e-14,  5.864582621598622e-17, -1.494363913128769e-19,  3.396973456711542e-22, -6.324577066863938e-25,  6.518586262000083e-28,
  1.713583908934149e-30,  4.799175696109633e-02, -2.582491598711880e-04,  1.019004225479554e-06, -3.462001882351916e-09,  1.055148808197804e-11, -2.900273222240792e-14,
  7.042688934358530e-17, -1.409212409655821e-19,  1.736435545445412e-22,  2.500739153667206e-25, -2.834321887328000e-27,  1.319360168835916e-29,  7.148553470607563e-02,
 -3.806828722565001e-04,  1.469265640576101e-06, -4.796217130032482e-09,  1.364939281820771e-11, -3.324792427528433e-14,  6.318467382195296e-17, -5.555099853308325e-20,
 -2.433043031955233e-22,  1.764348405108184e-24, -7.194843777079112e-27,  2.235042995112201e-29,  9.949760063586353e-02, -5.232114904726845e-04,  1.965282824581681e-06,
 -6.097975127448653e-09,  1.580405912480300e-11, -3.170454438991804e-14,  3.154604707228338e-17,  1.070299693406675e-19, -8.220170973323983e-22,  3.268601670275842e-24,
 -9.334009940994486e-27,  1.760769620054660e-29,  1.319285815070799e-01, -6.835065323773811e-04,  2.485116835852370e-06, -7.235902270277819e-09,  1.646587487288302e-11,
 -2.294142875008863e-14, -2.419522729480354e-17,  3.174322310356864e-19, -1.356010923789269e-21,  3.811726257055890e-24, -6.084826109175867e-27, -7.348617400393153e-30,
  1.686617865856240e-01, -8.589087265317049e-04,  3.004984493137374e-06, -8.081306439318144e-09,  1.520877520152170e-11, -6.663133540070712e-15, -9.711474644359981e-17,
  5.194658570152291e-19, -1.578272576015662e-21,  2.557586085405046e-24,  3.597712916473712e-27, -4.539985019918871e-29,  2.095628871245127e-01, -1.046455907254580e-03,
  3.500048620082445e-06, -8.517399549901167e-09,  1.179209476710088e-11,  1.607774144225035e-14, -1.741025478232263e-16,  6.421808620734055e-19, -1.257399149540156e-21,
 -7.202638470066704e-25,  1.700911029433203e-26, -7.484852909639608e-29,  2.544795713843673e-01, -1.242915853095202e-03,  3.945284443271029e-06, -8.448360607109662e-09,
  6.207922013502382e-12,  4.286292695365056e-14, -2.378114771074428e-16,  6.190026558070341e-19, -3.041766787169337e-22, -5.299267243509780e-24,  2.781341134300837e-26,
 -6.882937583212584e-29,  3.032411849072072e-01, -1.444824371596791e-03,  4.316404152910907e-06, -7.807695736460649e-09, -1.292168846014564e-12,  7.011127142101695e-14,
 -2.699073211435800e-16,  4.096322066337527e-19,  1.149990614729396e-21, -9.531946209846350e-24,  2.841171989392547e-26, -1.252601001229188e-29,  3.556583676786986e-01,
 -1.648528913885776e-03,  4.590817593072420e-06, -6.565326196086921e-09, -1.019591289427082e-11,  9.349898763159119e-14, -2.551174790421232e-16,  1.881093132153310e-20,
  2.739396677312158e-21, -1.132532896685105e-23,  1.392055221049003e-26,  8.098819532526942e-29,  4.115227019610052e-01, -1.850237957773861e-03,  4.748602633027188e-06,
 -4.732834643593264e-09, -1.975773703596979e-11,  1.085617031442972e-13, -1.853233072981793e-16, -4.942058249321492e-19,  3.936178383419086e-21, -8.980583931187719e-24,
 -1.400210399741268e-26,  1.678191032232619e-28,  4.706063869494727e-01, -2.046076322370086e-03,  4.773454123147016e-06, -2.366330903784166e-09, -2.905534964403319e-11,
  1.114095559377961e-13, -6.279865928683939e-17, -1.020220945812912e-18,  4.202622628496104e-21, -2.104052447846362e-24, -4.572009439325531e-26,  1.901252209709133e-28,
  5.326619589902774e-01, -2.232146464988153e-03,  4.653575679121709e-06,  4.335316909577938e-10, -3.707321450514315e-11,  9.945769752155970e-14,  9.828434375528703e-17,
 -1.420415384444108e-18,  3.186725729411415e-21,  7.814130038075987e-24, -6.617554657395153e-26,  1.087534169813930e-28,  5.974220788646881e-01, -2.404595656671164e-03,
  4.382474183129428e-06,  3.524743106720259e-09, -4.280731972720225e-11,  7.205518244950360e-14,  2.727487307970083e-16, -1.559875484452868e-18,  8.985354120677693e-22,
  1.751880978509568e-23, -6.130056819908843e-26, -6.452106775325006e-29,  6.645994105489292e-01, -2.559688730601908e-03,  3.959613262597525e-06,  6.730514879533022e-09,
 -4.538233468943384e-11,  3.089065148353031e-14,  4.279645523121747e-16, -1.347280268680225e-18, -2.204013663929163e-21,  2.295019347289918e-23, -2.591625066625459e-26,
 -2.568278236084773e-28,  7.338866188201719e-01, -2.693885843698068e-03,  3.390879640076462e-06,  9.849220931221466e-09, -4.416925052273022e-11, -1.993207682667499e-14,
  5.297594351397738e-16, -7.702015617022604e-19, -5.275016238315866e-21,  2.083524850810651e-23,  3.085410114944587e-26, -3.605174769164764e-28,  8.049565159900660e-01,
 -2.803924383333702e-03,  2.688815780372809e-06,  1.266740614792857e-08, -3.888937844451627e-11, -7.421891962265377e-14,  5.497683179991946e-16,  8.567010720652434e-20,
 -7.299549467460578e-21,  1.033895157918414e-23,  8.646445949869867e-26, -2.906118925517226e-28,  8.774623907610517e-01, -2.886903788807323e-03,  1.872574414988173e-06,
  1.497526339259415e-08, -2.968964276119584e-11, -1.244238707736692e-13,  4.727569133410447e-16,  1.042811869131890e-18, -7.426026738650920e-21, -5.987264348773115e-24,
  1.134763108792163e-25, -4.499037619826534e-29,  9.510385545291464e-01, -2.940371645474719e-03,  9.675560586072740e-07,  1.658365476660442e-08, -1.717494772759414e-11,
 -1.627402731468901e-13,  3.021399285157161e-16,  1.867220459520839e-18, -5.309364518646005e-21, -2.259432791352232e-23,  9.304996179732846e-26,  2.722878767899696e-28,
  1.025301142167011e+00, -2.962408958520077e-03,  4.700272769481722e-09,  1.734143580704324e-08, -2.386414142749820e-12, -1.824052426831205e-13,  6.198235353293555e-17,
  2.327775233090130e-18, -1.331895944546468e-21, -3.281015854983589e-23,  2.698796007722546e-26,  4.910967326868724e-28,  1.099849205135516e+00, -2.951712040288192e-03,
 -9.805842361689418e-07,  1.715156977402242e-08,  1.328035031329331e-11, -1.790070515477343e-13, -2.056885232476287e-16,  2.265407982035769e-18,  3.413755096109398e-21,
 -3.164367305191094e-23, -5.903853673428023e-26,  4.689582538319065e-28,  1.174266134373480e+00, -2.907667975373236e-03, -1.949846263612037e-06,  1.598433945451894e-08,
  2.821523005501022e-11, -1.515414896971341e-13, -4.484367132356739e-16,  1.651297553587733e-18,  7.423579990205398e-21, -1.834502485457084e-23, -1.251182775839919e-25,
  1.876584296408963e-28,  1.248121448457070e+00, -2.830420195873894e-03, -2.863346867680181e-06,  1.388592673795200e-08,  4.078099756786385e-11, -1.029635997151708e-13,
 -6.147192782274386e-16,  6.124882895183492e-19,  9.295915163986575e-21,  2.613867005549852e-24, -1.367602284093837e-25, -2.138286979475841e-28,  1.320972978644097e+00,
 -2.720920349338650e-03, -3.682085268540186e-06,  1.098078436091353e-08,  4.952775522584878e-11, -4.003835377220987e-14, -6.665329290335220e-16, -5.897360609512255e-19,
  8.283833857331215e-21,  2.295274074728950e-23, -8.480230990472015e-26, -5.071948647041232e-28,  1.392369476280802e+00, -2.580962426247360e-03, -4.370007934511060e-06,
  7.466607099737094e-09,  5.340571035194653e-11,  2.758985360873172e-14, -5.901291390530543e-16, -1.629202035198803e-18,  4.655130890499642e-21,  3.409466689506466e-23,
  6.593625268839860e-27, -5.146419279511653e-28,  1.461853659356925e+00, -2.413195090521866e-03, -4.896281679245647e-06,  3.601335932175215e-09,  5.194235856482608e-11,
  8.902625185543353e-14, -4.014591692248011e-16, -2.214654026368570e-18, -3.293977137382824e-22,  3.126717362469230e-23,  9.084618455163554e-26, -2.317164320863907e-28,
  1.528965703552026e+00, -2.221108385006769e-03, -5.237483381655858e-06, -3.175218988112629e-10,  4.534997965620613e-11,  1.341910726316448e-13, -1.440008117794722e-16,
 -2.187871916466125e-18, -4.865103170564450e-21,  1.607088142888831e-23,  1.245989020181792e-25,  1.597089652975015e-28,  1.593247168872323e+00, -2.008991518433093e-03,
 -5.379537731112569e-06, -3.979966310000351e-09,  3.453564232243389e-11,  1.559066784356199e-13,  1.214015971405707e-16, -1.583052095676417e-18, -7.328594138440378e-21,
 -4.086646524262346e-24,  9.334917879277395e-26,  4.110710445999632e-28,  1.654245336084403e+00, -1.781859321789934e-03, -5.319224578281992e-06, -7.094628631509749e-09,
  2.099905868570027e-11,  1.515162333997972e-13,  3.325353629421784e-16, -6.201354471469444e-19, -6.968494442982656e-21, -1.969802249291264e-23,  2.020161776294137e-26,
  3.804472292801485e-28,  1.711517908014313e+00, -1.545346207608684e-03, -5.065083258646661e-06, -9.420665361994134e-09,  6.622511755365261e-12,  1.235857433208524e-13,
  4.432435780548633e-16,  3.718282827714051e-19, -4.226617708649996e-21, -2.413193944788604e-23, -4.932121886746463e-26,  1.287614511150646e-28,  1.764638010093460e+00,
 -1.305568059351118e-03, -4.637565969976997e-06, -1.079649901001220e-08, -6.621144001118930e-12,  7.941657828694245e-14,  4.367624418411079e-16,  1.075962937593700e-18,
 -5.056355732927768e-22, -1.703210559943830e-23, -7.704747401663166e-26, -1.393133671225111e-28,  1.813199403304877e+00, -1.068954361906954e-03, -4.068337493498424e-06,
 -1.116132029769368e-08, -1.699609982227159e-11,  2.938087519122855e-14,  3.301978695017985e-16,  1.305870182950108e-18,  2.526005026808108e-21, -4.047608441513150e-24,
 -5.588234324442588e-26, -2.420502206169698e-28,  1.856821802235492e+00, -8.420549532128718e-04, -3.398683254760562e-06, -1.056571620865936e-08, -2.330681345127644e-11,
 -1.557816218322657e-14,  1.680225778258737e-16,  1.070144203714766e-18,  3.743215037131406e-21,  6.964436128891773e-24, -1.056002558364582e-26, -1.544084882000278e-28,
  1.895156172912591e+00, -6.313278797231167e-04, -2.677067785897456e-06, -9.168900156156480e-09, -2.511438750415711e-11, -4.666147687235842e-14,  6.323724431258242e-18,
  5.530750041311712e-19,  3.055410187594127e-21,  1.079524531013295e-23,  2.416463390572001e-26,  1.506380266123160e-30,  1.927889871622828e+00, -4.429167834781161e-04,
 -1.955973658042941e-06, -7.221719559920441e-09, -2.281521957215831e-11, -5.939946163664898e-14, -1.068200487341726e-16,  1.929723683632618e-20,  1.313589759152591e-21,
  7.586013362817456e-24,  2.978713569914620e-26,  8.693184134716223e-29,  1.954751480788146e+00, -2.824278125179694e-04, -1.288236654521263e-06, -5.036691730984017e-09,
 -1.755607388053005e-11, -5.465423967924464e-14, -1.475764650459091e-16, -3.125608721161779e-19, -2.936794862156247e-22,  1.695203211868232e-24,  1.382304648758248e-26,
  6.604338363096479e-29,  1.975515215043250e+00, -1.547169435719085e-04, -7.231641978980936e-07, -2.948440986653645e-09, -1.099390579066804e-11, -3.809685500826812e-14,
 -1.228943477741374e-16, -3.652986688579902e-19, -9.721714236719102e-22, -2.142448260356914e-24, -2.806120363981233e-27,  6.159059723714686e-30,  1.990004913294273e+00,
 -6.369800579837762e-05, -3.027660895092110e-07, -1.269670788947848e-09, -4.944455065780565e-12, -1.826855536255446e-14, -6.468305469439578e-17, -2.204124959336508e-19,
 -7.232710640691443e-22, -2.279532942663095e-24, -6.855263246044788e-27, -1.941798764831803e-29,  1.998099594740765e+00, -1.216862313559690e-05, -5.837792967248469e-08,
 -2.486020331055721e-10, -9.907943767792943e-13, -3.782967762585295e-15, -1.400841462705405e-17, -5.067199755905368e-20, -1.798504746652964e-22, -6.281709646362471e-25,
 -2.163187546629697e-27, -7.353458409473832e-30,  5.830013416111715e-04, -3.167723329244045e-06,  1.290530113919857e-08, -4.671862173318183e-11,  1.584850301958667e-13,
 -5.158600694440113e-16,  1.631426558307010e-18, -5.050600663257203e-21,  1.537887286002325e-23, -4.620874943762674e-26,  1.373156037318027e-28, -4.042369060876286e-31,
  5.244260563812657e-03, -2.843893357439005e-05,  1.153929462772191e-07, -4.148789577230755e-10,  1.392789327840746e-12, -4.466758842491210e-15,  1.384561034947585e-17,
 -4.175162707753437e-20,  1.229309437175252e-22, -3.540953193236525e-25,  9.984604282441716e-28, -2.755112401485158e-30,  1.455209051703481e-02, -7.860549391894871e-05,
  3.163645378942053e-07, -1.121735879434822e-09,  3.685940123330010e-12, -1.145993055464855e-14,  3.401885537763708e-17, -9.670402900273913e-20,  2.628379682910787e-22,
 -6.788160145853098e-25,  1.643474643893913e-27, -3.625695603203128e-30,  2.847704827798885e-02, -1.529183251193075e-04,  6.079167632955290e-07, -2.109992961079306e-09,
  6.704102571204533e-12, -1.981816554488203e-14,  5.461040548149062e-17, -1.389252042051468e-19,  3.174145436102867e-22, -6.050745548684392e-25,  7.126517298543526e-28,
  1.075019391665431e-30,  4.697480527146967e-02, -2.502604756470568e-04,  9.784542977888832e-07, -3.297728003706738e-09,  9.988019559187448e-12, -2.735920095646984e-14,
  6.656009069455845e-17, -1.352413886660352e-19,  1.807395717042358e-22,  1.476749955070703e-25, -2.300787986447620e-27,  1.111090837900472e-29,  6.998595213020600e-02,
 -3.691553029235179e-04,  1.412999698506805e-06, -4.583064663951963e-09,  1.299946835985095e-11, -3.175098027716617e-14,  6.152940910738593e-17, -6.237413653309000e-20,
 -1.847377754713039e-22,  1.495486459853065e-24, -6.266136020575087e-27,  1.989532547497424e-29,  9.743574175862180e-02, -5.077776798968698e-04,  1.893603523637801e-06,
 -5.850140805693218e-09,  1.517776712253792e-11, -3.091434341631788e-14,  3.419180724950076e-17,  8.253759142304234e-20, -7.108815794950058e-22,  2.910690217211329e-24,
 -8.563382406780708e-27,  1.735975973038771e-29,  1.292337735950524e-01, -6.639684773428733e-04,  2.399851497101413e-06, -6.976147516142711e-09,  1.600193457038396e-11,
 -2.342023521135090e-14, -1.589432681955344e-17,  2.761879114062648e-19, -1.223235255774085e-21,  3.563226298537855e-24, -6.308457986979147e-27, -2.991454538657812e-30,
  1.652736230779078e-01, -8.352526274354187e-04,  2.909464063671649e-06, -7.839153931352179e-09,  1.505335400971158e-11, -8.824967985654914e-15, -8.326275073519172e-17,
  4.704583300412094e-19, -1.484066481901413e-21,  2.664168543291588e-24,  1.794259103791238e-27, -3.676971725635662e-29,  2.054324215096126e-01, -1.018861123029350e-03,
  3.398981758988373e-06, -8.326374593220694e-09,  1.207329786731028e-11,  1.211048688785145e-14, -1.566877969727704e-16,  6.016542339964077e-19, -1.271853257696096e-21,
 -1.032937920146783e-25,  1.390035862805363e-26, -6.648176227619304e-29,  2.495703929149097e-01, -1.211757347137309e-03,  3.844527377564203e-06, -8.342480021813703e-09,
  7.009503291101454e-12,  3.736216774782304e-14, -2.206428569756202e-16,  6.064254237926933e-19, -4.756537659720441e-22, -4.247191945377530e-24,  2.479641131150072e-26,
 -6.800590332833743e-29,  2.975303561438443e-01, -1.410668154936652e-03,  4.222632900041519e-06, -7.817500623187754e-09,  4.622804516989773e-14,  6.377498124121300e-14,
 -2.579724540742223e-16,  4.411595318311618e-19,  8.271288756908838e-22, -8.410326299418679e-24,  2.758084532930109e-26, -2.467439324690234e-29,  3.491372024092745e-01,
 -1.612120142128214e-03,  4.511115503705004e-06, -6.713833285058167e-09, -8.387069063684042e-12,  8.739202154699556e-14, -2.534240114810695e-16,  1.000622451574522e-19,
  2.342501690059354e-21, -1.070430583714608e-23,  1.696100283190095e-26,  5.770449585529684e-29,  4.041973607051869e-01, -1.812481523455612e-03,  4.689982730219775e-06,
 -5.031834677886729e-09, -1.763202914695252e-11,  1.039618215883218e-13, -1.974469544103488e-16, -3.735149906966383e-19,  3.604513802131634e-21, -9.399759250206639e-24,
 -7.124992677787910e-27,  1.447227460425207e-28,  4.624982661500969e-01, -2.008010007560013e-03,  4.742342077899139e-06, -2.813482298704963e-09, -2.684446586765581e-11,
  1.095747083559595e-13, -8.949588001272529e-17, -8.872856330186644e-19,  4.095961603617716e-21, -3.767022082159033e-24, -3.747429786538222e-26,  1.838424731941402e-28,
  5.238078492537661e-01, -2.194906982006275e-03,  4.655285051612269e-06, -1.436116586242326e-10, -3.506363322350983e-11,  1.013510273069661e-13,  5.997907027567842e-17,
 -1.314440297686008e-18,  3.421607492645255e-21,  5.269972907706471e-24, -6.086959942280608e-26,  1.311028954361850e-28,  5.878740674146187e-01, -2.369378207366830e-03,
  4.420710265808502e-06,  2.851695700358329e-09, -4.130427497772021e-11,  7.808084863470503e-14,  2.295661710160674e-16, -1.521509444233267e-18,  1.484523234556169e-21,
  1.502434415936591e-23, -6.307828209649196e-26, -1.724686968044185e-29,  6.544245035974313e-01, -2.527701053266666e-03,  4.036044897204551e-06,  6.009885134725513e-09,
 -4.466490377567549e-11,  4.070190058607949e-14,  3.893759628979173e-16, -1.404810708760831e-18, -1.399058356220349e-21,  2.170200175017467e-23, -3.613172942225913e-26,
 -2.072174502382306e-28,  7.231660610650832e-01, -2.666298083855300e-03,  3.504819104893021e-06,  9.140006930331983e-09, -4.444259222190084e-11, -7.495011750170153e-15,
  5.059448643964851e-16, -9.267935242724553e-19, -4.506510545438014e-21,  2.175722590310290e-23,  1.538992049048505e-26, -3.406229101412851e-28,  7.937847871556982e-01,
 -2.781816507659540e-03,  2.837044612647061e-06,  1.203401830889700e-08, -4.024175301053792e-11, -6.102172285702862e-14,  5.489574482174911e-16, -1.413183845941104e-19,
 -6.868270509428569e-21,  1.353144536782857e-23,  7.293012409262591e-26, -3.222051774328644e-28,  8.659458632714149e-01, -2.871212641499174e-03,  2.049347273122419e-06,
  1.448094720632361e-08, -3.206243292919137e-11, -1.127543405396339e-13,  4.986025991210598e-16,  8.026011311444187e-19, -7.560552167861105e-21, -1.510733028336511e-24,
  1.097971080643439e-25, -1.208916751125752e-28,  9.392938022839664e-01, -2.931840097881514e-03,  1.164805036201620e-06,  1.628322857089034e-08, -2.035310706708651e-11,
 -1.548814527908097e-13,  3.519264759362095e-16,  1.685046848116565e-18, -6.053089588900274e-21, -1.865615231075295e-23,  1.032679607954909e-25,  1.912270244600028e-28,
  1.013452898205289e+00, -2.961539893145064e-03,  2.124483413607504e-07,  1.727417122679558e-08, -6.014393328684495e-12, -1.801414327666220e-13,  1.263875298461834e-16,
  2.266506014910629e-18, -2.488501778512825e-21, -3.130741816722652e-23,  4.789472194393096e-26,  4.562074057540733e-28,  1.088027975884748e+00, -2.958730100298490e-03,
 -7.736094393002532e-07,  1.733516780809024e-08,  9.656041255542911e-12, -1.831711227606378e-13, -1.409020046293679e-16,  2.356006802305463e-18,  2.237172647601111e-21,
 -3.357910306654011e-23, -3.743479394459825e-26,  5.098628006823474e-28,  1.162605490267839e+00, -2.922492056707980e-03, -1.755427395553995e-06,  1.641096793072399e-08,
  2.508065661071043e-11, -1.617229355012741e-13, -3.989806853844300e-16,  1.877337396391301e-18,  6.675334222893028e-21, -2.315499723424722e-23, -1.146572424403773e-25,
  2.868605140665056e-28,  1.236755024901165e+00, -2.852649515581741e-03, -2.692871306218750e-06,  1.452115336552767e-08,  3.857575602240069e-11, -1.174774035227633e-13,
 -5.933985156744949e-16,  9.103906187022655e-19,  9.289531487035793e-21, -3.016853232551177e-24, -1.440625404230263e-25, -1.159613843413868e-28,  1.310031237353333e+00,
 -2.749836548819042e-03, -3.545590446478165e-06,  1.176594808314945e-08,  4.856584068555189e-11, -5.620260202134313e-14, -6.792150791482892e-16, -3.121304810362089e-19,
  9.043765841172288e-21,  1.912224844161870e-23, -1.064848530281641e-25, -4.745818690088877e-28,  1.381976294467693e+00, -2.615549529368164e-03, -4.275266026140585e-06,
  8.324728120922506e-09,  5.381227321132319e-11,  1.289731016961715e-14, -6.334766758583918e-16, -1.460593754888919e-18,  5.881671006685287e-21,  3.388838187814503e-23,
 -1.730470962717744e-26, -5.690533514487681e-28,  1.452122832309362e+00, -2.452178219695530e-03, -4.848022177704236e-06,  4.446113275378864e-09,  5.362150891338577e-11,
  7.864698155793646e-14, -4.634429582785715e-16, -2.206505253557523e-18,  8.589011623878666e-22,  3.466723576522238e-23,  7.841100125778562e-26, -3.340608848271429e-28,
  1.519997463827875e+00, -2.263010955270905e-03, -5.236852146203300e-06,  4.293394323921183e-10,  4.799419029623447e-11,  1.299829052611320e-13, -2.073468847271041e-16,
 -2.333324012161171e-18, -4.195341501032488e-21,  2.117372590354026e-23,  1.299746234621146e-25,  8.163271842824193e-29,  1.585124841292779e+00, -2.052209227040260e-03,
 -5.423878536290850e-06, -3.402308205515016e-09,  3.767918447534431e-11,  1.582618017701266e-13,  7.377615439069178e-17, -1.819164950664106e-18, -7.404139546459212e-21,
  9.208490184342517e-27,  1.114169444541971e-25,  4.073598559898441e-28,  1.647032260383003e+00, -1.824747715755806e-03, -5.402242824123341e-06, -6.733973834443188e-09,
  2.410765238886744e-11,  1.592628696959807e-13,  3.119443861280768e-16, -8.542835383886484e-19, -7.658877786615756e-21, -1.853696022278092e-23,  3.829757232052745e-26,
  4.416371684790861e-28,  1.705254768676633e+00, -1.586317072670125e-03, -5.177412034023236e-06, -9.294350210924299e-09,  9.201365945029782e-12,  1.343324240055289e-13,
  4.516279984582931e-16,  2.223080110143461e-19, -5.129334518909516e-21, -2.597167860766996e-23, -4.215658179866007e-26,  1.986620513023186e-28,  1.759340713887966e+00,
 -1.343188495550438e-03, -4.767705300202527e-06, -1.088915092047425e-08, -4.925561097280690e-12,  9.025798394866107e-14,  4.665663934197160e-16,  1.049365712235874e-18,
 -1.175680702217977e-21, -2.022961379502686e-23, -8.263412544634266e-26, -1.126682701908425e-28,  1.808857637732987e+00, -1.102041380649634e-03, -4.203884142160448e-06,
 -1.142811378246153e-08, -1.632622653941130e-11,  3.775337988772059e-14,  3.678687807346045e-16,  1.383918258700407e-18,  2.337425583302353e-21, -6.502849091607510e-24,
 -6.704658313782934e-26, -2.649344390926524e-28,  1.853398391516954e+00, -8.697579352859714e-04, -3.527718846786249e-06, -1.094088819416065e-08, -2.357555326464322e-11,
 -1.117228798777715e-14,  1.997006060808658e-16,  1.193843150695080e-18,  3.984596839125205e-21,  6.395393476591296e-24, -1.816764184822781e-26, -1.922403467868038e-28,
  1.892587321735378e+00, -6.531914311760992e-04, -2.789536323959800e-06, -9.578182477674862e-09, -2.604478632602645e-11, -4.631246016063243e-14,  2.323840157798430e-17,
  6.572525908006041e-19,  3.461410319658316e-21,  1.175833827275274e-23,  2.386145421757589e-26, -1.616209484433028e-29,  1.926086351178481e+00, -4.589175122119499e-04,
 -2.044864207978583e-06, -7.596406007799954e-09, -2.402877620073179e-11, -6.195164824384280e-14, -1.056484989330324e-16,  6.593922039857633e-20,  1.609074407556741e-21,
  8.856143488792454e-24,  3.377131684874809e-26,  9.405582243709235e-29,  1.953600768110378e+00, -2.929803265488823e-04, -1.350399041721451e-06, -5.326529025055957e-09,
 -1.868529114841820e-11, -5.830209688919201e-14, -1.564497686376255e-16, -3.208695651376586e-19, -2.219662897035746e-22,  2.309891353547891e-24,  1.700520321217516e-26,
  7.893185963251896e-29,  1.974884548260942e+00, -1.606468316307338e-04, -7.596265773802777e-07, -3.130602772144241e-09, -1.178618450481424e-11, -4.117264710608553e-14,
 -1.335699893007549e-16, -3.976632747554070e-19, -1.051244982561409e-21, -2.248195955850581e-24, -2.452721568255722e-27,  1.008203029666255e-29,  1.989745178582683e+00,
 -6.618245193090981e-05, -3.184891429794597e-07, -1.351791531931742e-09, -5.325863846985037e-12, -1.989770038269315e-14, -7.119135405611970e-17, -2.449248183308320e-19,
 -8.104825970641674e-22, -2.571565655949274e-24, -7.765068099205858e-27, -2.198527710429373e-29,  1.998049966919395e+00, -1.264785483787005e-05, -6.145882760703117e-08,
 -2.650787793200868e-10, -1.069934127573797e-12, -4.136867352732068e-15, -1.551132606539255e-17, -5.680639342824584e-20, -2.041033935233972e-22, -7.215342485771779e-25,
 -2.514398119274428e-27, -8.647683237101208e-30,  5.705334423387631e-04, -3.066681076566011e-06,  1.235955853578914e-08, -4.426331858147687e-11,  1.485481974317167e-13,
 -4.783487238942528e-16,  1.496656754168116e-18, -4.584066712712890e-21,  1.381008584800088e-23, -4.105579499495869e-26,  1.207151168717226e-28, -3.516311837080320e-31,
  5.132320111879855e-03, -2.753533202956065e-05,  1.105452159159218e-07, -3.932913448428055e-10,  1.306684653120451e-12, -4.148059731310336e-15,  1.272977510236600e-17,
 -3.801431864874803e-20,  1.108741179545752e-22, -3.164799811319514e-25,  8.847335117152201e-28, -2.421778888131884e-30,  1.424264651483135e-02, -7.612743549768326e-05,
  3.032501352593813e-07, -1.064550969570825e-09,  3.464691530514327e-12, -1.067504229138187e-14,  3.142530890056096e-17, -8.867183077922864e-20,  2.395463089969403e-22,
 -6.161732274514313e-25,  1.490963238410960e-27, -3.310122280261465e-30,  2.787494382149398e-02, -1.481544768266112e-04,  5.832275887299348e-07, -2.005828316632504e-09,
  6.320536522415620e-12, -1.855306683933857e-14,  5.085946652892315e-17, -1.291108770943078e-19,  2.961549290161850e-22, -5.757787279356680e-25,  7.485012821169586e-28,
  5.750638330095345e-31,  4.598917179159204e-02, -2.425884564960361e-04,  9.398226322098074e-07, -3.142211644237476e-09,  9.456506630623319e-12, -2.580654203181144e-14,
  6.285498109742878e-17, -1.293895004311256e-19,  1.845121245878013e-22,  6.487602324696541e-26, -1.852139036811759e-27,  9.328351216234337e-30,  6.853159552959347e-02,
 -3.580678043271469e-04,  1.359230174105118e-06, -4.380073697888871e-09,  1.237907110050475e-11, -3.029585212226318e-14,  5.970792916143947e-17, -6.747104838063781e-20,
 -1.352071215216864e-22,  1.261669610225370e-24, -5.441159651678603e-27,  1.763633630055144e-29,  9.543448985139094e-02, -4.929055768101947e-04,  1.824838642611083e-06,
 -5.612197499834769e-09,  1.456786060062605e-11, -3.006848346492322e-14,  3.619967480142713e-17,  6.140131481104224e-20, -6.120795811725472e-22,  2.583285127027429e-24,
 -7.810982862612765e-27,  1.679687504750394e-29,  1.266157732200780e-01, -6.451002036413122e-04,  2.317658395129491e-06, -6.723881975621636e-09,  1.553031925869536e-11,
 -2.371320635466600e-14, -8.690138902734094e-18,  2.390479075796934e-19, -1.099523145085318e-21,  3.309316102050588e-24, -6.362434323805836e-27,  3.910784596975790e-31,
  1.619785739794269e-01, -8.123491138999655e-04,  2.816833174307256e-06, -7.599816453346391e-09,  1.485791123270216e-11, -1.067047734846259e-14, -7.074027968899195e-17,
  4.245135890931493e-19, -1.387233514485389e-21,  2.705865414007451e-24,  3.450969626055812e-28, -2.928386659346049e-29,  2.014107325799479e-01, -9.920656338923165e-04,
  3.300231646988104e-06, -8.131462825329743e-09,  1.227924331614635e-11,  8.547536823399511e-15, -1.404110950573125e-16,  5.609971665344558e-19, -1.266246527630397e-21,
  3.966305435179330e-25,  1.115499571563947e-26, -5.836491626774311e-29,  2.447842447001229e-01, -1.181399605623208e-03,  3.745114272349702e-06, -8.224632000119277e-09,
  7.705158269170972e-12,  3.226864357989764e-14, -2.038976927375443e-16,  5.889437306140195e-19, -6.114150329457911e-22, -3.314571848331549e-24,  2.185215004811645e-26,
 -6.560245949855285e-29,  2.919546516632802e-01, -1.377262224418718e-03,  4.128868343864882e-06, -7.806889123406613e-09,  1.260829128596278e-12,  5.773459063973766e-14,
 -2.452934452468475e-16,  4.629939337324576e-19,  5.439273675688815e-22, -7.331653569301630e-24,  2.628777645321278e-26, -3.360803235449413e-29,  3.427603863892922e-01,
 -1.576355632684845e-03,  4.429800956885204e-06, -6.834373031067345e-09, -6.699781171207885e-12,  8.135158540129701e-14, -2.496297991106448e-16,  1.689921498656530e-19,
  1.969913793713565e-21, -9.981270498026401e-24,  1.904320422525226e-26,  3.744466555630813e-29,  3.970220853511252e-01, -1.775207829257837e-03,  4.627975810913191e-06,
 -5.297574049001062e-09, -1.560096108811234e-11,  9.911031322823726e-14, -2.063417454862091e-16, -2.636277674800332e-19,  3.262465139536891e-21, -9.564203576112143e-24,
 -1.264680870681246e-27,  1.217429003430968e-28,  4.545418796787564e-01, -1.970213454027386e-03,  4.706075140425987e-06, -3.225586684073602e-09, -2.467638709837847e-11,
  1.071433549994288e-13, -1.125272458188861e-16, -7.586583126001945e-19,  3.935291062445903e-21, -5.107093977017321e-24, -2.960768867487526e-26,  1.730988056581654e-28,
  5.151026817113185e-01, -2.157680977760738e-03,  4.650262714298137e-06, -6.883477019168570e-10, -3.302513422447992e-11,  1.023614043711561e-13,  2.473285977082197e-17,
 -1.202371682955858e-18,  3.568935732491732e-21,  2.955408679865372e-24, -5.475189601471397e-26,  1.457678569108819e-28,  5.784674869762726e-01, -2.333886758053263e-03,
  4.451017867531153e-06,  2.203605208819842e-09, -3.969098310733877e-11,  8.308505993887850e-14,  1.877068080600851e-16, -1.465838366845242e-18,  1.979915497684788e-21,
  1.249858675342231e-23, -6.291080144651532e-26,  2.376752744882387e-29,  6.443787157883077e-01, -2.495136303357442e-03,  4.103904159296178e-06,  5.302253268992761e-09,
 -4.376062476347522e-11,  4.957055980000581e-14,  3.495298485192295e-16, -1.437376106903010e-18, -6.458635138968103e-22,  2.008920148624432e-23, -4.414200222892811e-26,
 -1.569599811806556e-28,  7.125576234002362e-01, -2.637832906219600e-03,  3.610229864813847e-06,  8.428376898059402e-09, -4.447324879051190e-11,  4.320694091875253e-15,
  4.780941586649133e-16, -1.058379734035419e-18, -3.715709274429498e-21,  2.208114694414941e-23,  1.021529619241950e-27, -3.110865054311777e-28,  7.827038128549814e-01,
 -2.758553551747080e-03,  2.977551663785358e-06,  1.138110083936704e-08, -4.133088456332123e-11, -4.791859319780787e-14,  5.420006319839148e-16, -3.527740237113859e-19,
 -6.332102931680216e-21,  1.615899739571948e-23,  5.832163043234110e-26, -3.394950040829363e-28,  8.544948902812068e-01, -2.854131665956549e-03,  2.219968353962131e-06,
  1.395056491131471e-08, -3.419617621220603e-11, -1.005455633658991e-13,  5.176861042413079e-16,  5.606292786415894e-19, -7.537352856410314e-21,  2.754454817988804e-24,
  1.029785675947160e-25, -1.872715054022946e-28,  9.275863081762664e-01, -2.921745831025892e-03,  1.358149188419159e-06,  1.593327237768661e-08, -2.336256773095431e-11,
 -1.458915212946141e-13,  3.963008083641129e-16,  1.481414242135736e-18, -6.648556000521588e-21, -1.438196702418010e-23,  1.098236008808875e-25,  1.064801424356916e-28,
  1.001611447974131e+00, -2.959013054748080e-03,  4.190427133758488e-07,  1.714930451567861e-08, -9.581799414330898e-12, -1.763566116851943e-13,  1.885682732366493e-16,
  2.169249071887738e-18, -3.576373654264150e-21, -2.900430533831918e-23,  6.688219316064498e-26,  4.042534616999081e-28,  1.076181998544756e+00, -2.964084540816815e-03,
 -5.647818721503265e-07,  1.746019591265198e-08,  5.964182776935324e-12, -1.857541891817277e-13, -7.411509475562826e-17,  2.408010133711795e-18,  1.006850662537880e-21,
 -3.462017865884790e-23, -1.446719118744249e-26,  5.306875653106113e-28,  1.150888691738973e+00, -2.935741176581707e-03, -1.556196409925958e-06,  1.678588079235429e-08,
  2.175482170439252e-11, -1.706443498088481e-13, -3.435561629650843e-16,  2.076752007332811e-18,  5.762494648382151e-21, -2.746135191312137e-23, -9.999867322412416e-26,
  3.776533209828825e-28,  1.225302459076983e+00, -2.873485161611755e-03, -2.514994209723622e-06,  1.511880455523915e-08,  3.608603010551625e-11, -1.313796260330491e-13,
 -5.637701733182317e-16,  1.204797639766947e-18,  9.076254427123688e-21, -8.850040197802241e-24, -1.468044479189691e-25, -7.245857341585485e-30,  1.298976074452357e+00,
 -2.777623388168810e-03, -3.399776718182018e-06,  1.253312104605032e-08,  4.727824071306244e-11, -7.257533180938038e-14, -6.838057292748665e-16, -1.257761726421019e-20,
  9.650596343933788e-21,  1.445994950286421e-23, -1.262241855572728e-25, -4.188607024665544e-28,  1.371446345456056e+00, -2.649337419519504e-03, -4.170197511082450e-06,
  9.186948500510792e-09,  5.391498706474663e-11, -2.774500170210851e-15, -6.715561483230625e-16, -1.253043898083151e-18,  7.083045722187307e-21,  3.268324782451649e-23,
 -4.321787069856343e-26, -6.054913776878134e-28,  1.442236909723541e+00, -2.490734283116408e-03, -4.789471261347689e-06,  5.316015670346226e-09,  5.507823890170287e-11,
  6.678724464804978e-14, -5.246485583324231e-16, -2.158477332303510e-18,  2.159557441185432e-21,  3.747920873207790e-23,  6.143500101016746e-26, -4.373150585093756e-28,
  1.510861681690155e+00, -2.304871914022001e-03, -5.227007779192975e-06,  1.217750884832632e-09,  5.053871788764572e-11,  1.242081531463932e-13, -2.744376911427154e-16,
 -2.454370034468455e-18, -3.338883371829750e-21,  2.641757194726718e-23,  1.315188382191046e-25, -1.429298816835319e-29,  1.576828978539257e+00, -2.095753076291240e-03,
 -5.460984317106788e-06, -2.774040961342306e-09,  4.085786266921127e-11,  1.593944486048880e-13,  1.952886519384547e-17, -2.055197195414453e-18, -7.319312626774495e-21,
  4.819200720146245e-24,  1.289186448375402e-25,  3.847891866839070e-28,  1.639646331432561e+00, -1.868282087131469e-03, -5.480629767798316e-06, -6.322371200411061e-09,
  2.736569321626601e-11,  1.664341961093255e-13,  2.844952809030453e-16, -1.109710218202715e-18, -8.293794454473024e-21, -1.659931081456818e-23,  5.899690456765526e-26,
  4.981375281957953e-28,  1.698825959230150e+00, -1.628179786960308e-03, -5.287970333392085e-06, -9.125044473549322e-09,  1.199680977533816e-11,  1.452267686774050e-13,
  4.554119075538295e-16,  4.290262449262647e-20, -6.092353932285838e-21, -2.746022749830215e-23, -3.168647530116576e-26,  2.788791955780201e-28,  1.753890847339992e+00,
 -1.381854015754717e-03, -4.898786396974988e-06, -1.095290031338901e-08, -3.006070432908422e-12,  1.018032170542265e-13,  4.953078444055496e-16,  9.994446581038931e-19,
 -1.964542952472847e-21, -2.362348295917431e-23, -8.677106098955473e-26, -7.305386550902975e-29,  1.804381335337860e+00, -1.136225383414356e-03, -4.342562317831194e-06,
 -1.168279984141103e-08, -1.547968901301048e-11,  4.705544390371239e-14,  4.076266411275407e-16,  1.454429473778413e-18,  2.052185488642570e-21, -9.423787507928796e-24,
 -7.913846221200800e-26, -2.838605665347427e-28,  1.849862075693558e+00, -8.985112764765954e-04, -3.661279256720186e-06, -1.131961257560205e-08, -2.374828789540052e-11,
 -5.963726542116935e-15,  2.349468262130187e-16,  1.324876469414473e-18,  4.199600671791505e-21,  5.487240996710533e-24, -2.755287982962852e-26, -2.351975954303851e-28,
  1.889929185393901e+00, -6.759746288746538e-04, -2.907005263594294e-06, -1.000227226233776e-08, -2.696390129353388e-11, -4.552098751856935e-14,  4.325712550133316e-17,
  7.749729651941834e-19,  3.901661320660973e-21,  1.269211089828121e-23,  2.265586846736254e-26, -3.970214878860000e-29,  1.924217376623125e+00, -4.756476842492839e-04,
 -2.138369174958926e-06, -7.990915720086131e-09, -2.529298390012147e-11, -6.445893411263303e-14, -1.030314997508914e-16,  1.227996650321678e-19,  1.953225773162606e-21,
  1.029166892131692e-23,  3.804987832740689e-26,  1.002126198548334e-28,  1.952406828309631e+00, -3.040443646348993e-04, -1.416150326579118e-06, -5.635029097518263e-09,
 -1.988961256725082e-11, -6.216542443785931e-14, -1.655200796817344e-16, -3.265036638194326e-19, -1.256909706128808e-22,  3.063818151304566e-24,  2.080053132080377e-26,
  9.395566579674891e-29,  1.974229564373517e+00, -1.668773827581291e-04, -7.983530330159492e-07, -3.325947378132658e-09, -1.264261611007972e-11, -4.451581844944069e-14,
 -1.451878155500876e-16, -4.326160595582340e-19, -1.133826379512350e-21, -2.336018542603173e-24, -1.901027518577972e-27,  1.521935784524574e-29,  1.989475248126734e+00,
 -6.879673056267647e-05, -3.352353639868296e-07, -1.440284204598355e-09, -5.741474786350034e-12, -2.169160605559918e-14, -7.842670107395089e-17, -2.724033705232524e-19,
 -9.088903916304507e-22, -2.902338056576122e-24, -8.794472835809217e-27, -2.485804360294210e-29,  1.997998371593501e+00, -1.315254668440661e-05, -6.474528399771036e-08,
 -2.828804052962460e-10, -1.156526948505744e-12, -4.528988878371784e-15, -1.719739117359364e-17, -6.377348677294234e-20, -2.319846118385826e-22, -8.301542143679431e-25,
 -2.927818195286057e-27, -1.018871795856814e-29,  5.584611630564688e-04, -2.969889557085364e-06,  1.184234983436973e-08, -4.196117433703970e-11,  1.393302763181142e-13,
 -4.439206040346781e-16,  1.374274083717742e-18, -4.164889608288743e-21,  1.241539021016417e-23, -3.652279782858448e-26,  1.062646606376121e-28, -3.063163798133631e-31,
  5.023918110661950e-03, -2.666949906753209e-05,  1.059484765839009e-07, -3.730318351389046e-10,  1.226694416259582e-12, -3.854927307367061e-15,  1.171338051031247e-17,
 -3.464201227387253e-20,  1.000929774347498e-22, -2.831332828114828e-25,  7.847202506911562e-28, -2.130773008715658e-30,  1.394290917851018e-02, -7.375160643000896e-05,
  2.908012189544717e-07, -1.010783762076820e-09,  3.258536042251768e-12, -9.949782505281033e-15,  2.904656009438481e-17, -8.135003401021031e-20,  2.184032712316082e-22,
 -5.593594534551711e-25,  1.351868058945238e-27, -3.015946250223550e-30,  2.729150750309625e-02, -1.435832444658410e-04,  5.597523869301862e-07, -1.907603112335934e-09,
  5.961394088151170e-12, -1.737476894614870e-14,  4.737396471154425e-17, -1.199597474038605e-19,  2.759707947915621e-22, -5.454540301754772e-25,  7.649144296191359e-28,
  1.876512469187792e-31,  4.503361989988392e-02, -2.352181681269806e-04,  9.030071469604636e-07, -2.994955841738893e-09,  8.955170985584463e-12, -2.434082849558971e-14,
  5.931499019531641e-17, -1.234612677461164e-19,  1.856087680330490e-22, -1.466160885743836e-27, -1.476049148435181e-27,  7.806654327400484e-30,  6.712074380295320e-02,
 -3.474008849115378e-04,  1.307837935724904e-06, -4.186778688078126e-09,  1.178732858271166e-11, -2.888598050033196e-14,  5.776470429777845e-17, -7.111147990948839e-20,
 -9.352331339337615e-23,  1.058922339400273e-24, -4.711212302114221e-27,  1.557562028186625e-29,  9.349164396961286e-02, -4.785723360858819e-04,  1.758871096442739e-06,
 -5.383874937402536e-09,  1.397530702982795e-11, -2.918118989761359e-14,  3.765825909704757e-17,  4.324387254138307e-20, -5.245290619163787e-22,  2.285410032178239e-24,
 -7.088474239179528e-27,  1.601514177190982e-29,  1.240719498408467e-01, -6.268774946749516e-04,  2.238447040696487e-06, -6.479200106842343e-09,  1.505449157177093e-11,
 -2.384531714031211e-14, -2.471823589259320e-18,  2.057202982247392e-19, -9.849570976323332e-22,  3.055972884177331e-24, -6.286035853152940e-27,  2.959556412113001e-30,
  1.587736749518888e-01, -7.901752151421483e-04,  2.727054405851160e-06, -7.363885443048966e-09,  1.462846127290912e-11, -1.223053368848935e-14, -5.946073068156776e-17,
  3.816809579875555e-19, -1.289866396738904e-21,  2.695863843985558e-24, -7.984134951043073e-28, -2.286197685128198e-29,  1.974946604904478e-01, -9.660507391489713e-04,
  3.203837963115117e-06, -7.933805163933298e-09,  1.241774413456572e-11,  5.361602993104966e-15, -1.252677207161733e-16,  5.207869686011605e-19, -1.244534131177773e-21,
  7.937690979628243e-25,  8.757982692466706e-27, -5.067096422544737e-29,  2.401179460552606e-01, -1.151831330628781e-03,  3.647178834803908e-06, -8.096446801816881e-09,
  8.302919546415508e-12,  2.757066880761174e-14, -1.876979503594482e-16,  5.676323655950303e-19, -7.156929899380331e-22, -2.497243145139339e-24,  1.904010567183664e-26,
 -6.206320596867949e-29,  2.865110719328014e-01, -1.344605579699732e-03,  4.035343794812566e-06, -7.777793745463963e-09,  2.357709740968231e-12,  5.200484405849249e-14,
 -2.321241850356592e-16,  4.763765028442826e-19,  2.985401078618376e-22, -6.311717940020588e-24,  2.466415451483452e-26, -3.977298625531236e-29,  3.365253188491716e-01,
 -1.541246975727694e-03,  4.347197943825208e-06, -6.928877060640351e-09, -5.132241916557923e-12,  7.542404810620752e-14, -2.440684509492772e-16,  2.264300949251199e-19,
  1.624647690020222e-21, -9.191878895488799e-24,  2.030093267661637e-26,  2.021960855482082e-29,  3.899948932370724e-01, -1.738442400898363e-03,  4.562971764924464e-06,
 -5.531603147499640e-09, -1.366881513179391e-11,  9.408101124002045e-14, -2.123135109334256e-16, -1.647375459827661e-19,  2.918474041649179e-21, -9.514248762770397e-24,
  3.601341648148060e-27,  9.963549576401104e-29,  4.467360686580449e-01, -1.932726231172361e-03,  4.665069387232046e-06, -3.603419645042095e-09, -2.256217438120251e-11,
  1.042018442295423e-13, -1.320358522179796e-16, -6.358845891422214e-19,  3.731918357874869e-21, -6.142994340147326e-24, -2.228929658148353e-26,  1.591163572570105e-28,
  5.065462972129555e-01, -2.120520743829564e-03,  4.638899761273355e-06, -1.200350986444627e-09, -3.097463017027027e-11,  1.025639849024744e-13, -7.321609485451798e-18,
 -1.086873389039077e-18,  3.637480773394886e-21,  8.963678301051812e-25, -4.814358062054167e-26,  1.535494169039475e-28,  5.692033086310203e-01, -2.298183510199593e-03,
  4.473706386863764e-06,  1.582074037548885e-09, -3.798751809417137e-11,  8.710505946719332e-14,  1.476145306891161e-16, -1.395764868567493e-18,  2.384917997383032e-21,
  1.001363843554129e-23, -6.108760800426416e-26,  5.795340978336699e-29,  6.344642193115818e-01, -2.462062386575706e-03,  4.163364334058601e-06,  4.610456631865634e-09,
 -4.268859565242907e-11,  5.747463809539430e-14,  3.091001899084627e-16, -1.446825770986731e-18,  4.403376027206408e-23,  1.819993766790356e-23, -4.996526039986527e-26,
 -1.081179550541507e-28,  7.020646789458104e-01, -2.608558591366757e-03,  3.707105798742538e-06,  7.718109355148717e-09, -4.427455903919640e-11,  1.542663644199182e-14,
  4.469142956799602e-16, -1.164581964429410e-18, -2.923257460203606e-21,  2.185864340980395e-23, -1.187822162805468e-26, -2.742618047201051e-28,  7.717180884769508e-01,
 -2.734198155859863e-03,  3.110127761926158e-06,  1.071284271695239e-08, -4.216009236420119e-11, -3.505145410244870e-14,  5.293766697793272e-16, -5.456728505200603e-19,
 -5.712007670904946e-21,  1.819107467560483e-23,  4.325565205657323e-26, -3.431650931393479e-28,  8.431149300267070e-01, -2.835711741787947e-03,  2.384028140021616e-06,
  1.338801871275067e-08, -3.608171167437234e-11, -8.795986086564790e-14,  5.300274665540974e-16,  3.217983954477616e-19, -7.366190168981566e-21,  6.691792414907890e-24,
  9.348971537652315e-26, -2.419767364160892e-28,  9.159222569085982e-01, -2.910122413392244e-03,  1.547011073500349e-06,  1.553665909154593e-08, -2.618205228260848e-11,
 -1.359070357773584e-13,  4.347301092483052e-16,  1.261231940199111e-18, -7.086332655182292e-21, -9.920332515500096e-24,  1.126425168163144e-25,  2.201687854326222e-29,
  9.897833997550030e-01, -2.954840419036720e-03,  6.237989718087216e-07,  1.696804496662668e-08, -1.305882626501832e-11, -1.711159831042329e-13,  2.475519379132279e-16,
  2.038648664635854e-18, -4.568254092603022e-21, -2.599183774135276e-23,  8.325858586923761e-26,  3.380483664834977e-28,  1.064317952763767e+00, -2.967763366992739e-03,
 -3.548098077163451e-07,  1.752582849571004e-08,  2.236786655830146e-12, -1.867213737443139e-13, -6.427637447096085e-18,  2.420222235311056e-18, -2.442487213296189e-22,
 -3.473040319316381e-23,  8.953836543560808e-27,  5.303974777404525e-28,  1.139122111625362e+00, -2.947379370461961e-03, -1.352791399089331e-06,  1.710622698001965e-08,
  1.826429501797494e-11, -1.781720121079276e-13, -2.829794384922287e-16,  2.244596065042865e-18,  4.706111724225827e-21, -3.110499141136402e-23, -8.161675223659518e-26,
  4.553753579261477e-28,  1.213769441140133e+00, -2.892869801684669e-03, -2.330193355337437e-06,  1.567443719642665e-08,  3.332603344460216e-11, -1.444728133352120e-13,
 -5.260256477424540e-16,  1.489008205294770e-18,  8.652181727400966e-21, -1.469505879602796e-23, -1.446093205201008e-25,  1.076104229471256e-28,  1.287812154991498e+00,
 -2.804207268528312e-03, -3.244891341438423e-06,  1.327706967560010e-08,  4.566277443757615e-11, -8.895555354786269e-14, -6.797633282074878e-16,  3.035611492871856e-19,
  1.007602384380165e-20,  9.063818892452076e-24, -1.430126078383738e-25, -3.406682818377228e-28,  1.360782991516444e+00, -2.682243371167626e-03, -4.054782989596174e-06,
  1.004825720991448e-08,  5.369561861595753e-11, -1.928618423705997e-14, -7.032939737341030e-16, -1.007947025467395e-18,  8.222048021947409e-21,  3.041575834802867e-23,
 -7.026112578939499e-26, -6.197879414686637e-28,  1.432197766346248e+00, -2.528779806203634e-03, -4.720349754675955e-06,  6.207248918110075e-09,  5.628321842095511e-11,
  5.347950252419610e-14, -5.839124498003354e-16, -2.067348610311833e-18,  3.548134357542972e-21,  3.952215088941140e-23,  3.999103722183271e-26, -5.362236442572443e-28,
  1.501558674111377e+00, -2.346615591327296e-03, -5.207462297842190e-06,  2.045862237581816e-09,  5.295139085741121e-11,  1.167858218143318e-13, -3.445056775415768e-16,
 -2.544985574571316e-18, -2.293597444410977e-21,  3.163382563725457e-23,  1.284763896617347e-25, -1.264830574733936e-28,  1.568358395666839e+00, -2.139562749109645e-03,
 -5.490245225601500e-06, -2.094806620451689e-09,  4.404564141085781e-11,  1.591463251741147e-13, -4.126234249178819e-17, -2.285611623327675e-18, -7.049020749314704e-21,
  1.030313520830008e-23,  1.449537679272362e-25,  3.402206036875729e-28,  1.632085043352469e+00, -1.912422900287363e-03, -5.553760097556739e-06, -5.857530766632297e-09,
  3.075998190834378e-11,  1.728586950593580e-13,  2.496214393514021e-16, -1.384173615432662e-18, -8.843473486839978e-21, -1.378627111189715e-23,  8.200191965873447e-26,
  5.456800208610682e-28,  1.692227943956265e+00, -1.670918064026601e-03, -5.396221399872842e-06, -8.909265376718294e-09,  1.501062354991041e-11,  1.561481182283356e-13,
  4.537335941994358e-16, -1.680888849332036e-19, -7.100546351205551e-21, -2.845658491824300e-23, -1.748065787796032e-26,  3.681907043559663e-28,  1.748284217329223e+00,
 -1.421570704812897e-03, -5.030440475526172e-06, -1.098405366754979e-08, -8.489056043346313e-13,  1.140185050369672e-13,  5.222795212643424e-16,  9.222968700490651e-19,
 -2.878104121599430e-21, -2.714366715096076e-23, -8.883961114542772e-26, -1.830288704080098e-29,  1.799766059068863e+00, -1.171530791777847e-03, -4.484209149520662e-06,
 -1.192240047401281e-08, -1.443741415551418e-11,  5.733425637109852e-14,  4.492145453627937e-16,  1.514035664231387e-18,  1.652899750447597e-21, -1.284337366913824e-23,
 -9.193261779705125e-26, -2.964137856080712e-28,  1.846208580700279e+00, -9.283513184789517e-04, -3.799397351784172e-06, -1.170022011922178e-08, -2.380809114077932e-11,
  1.355159433011499e-16,  2.739528476535456e-16,  1.462190575465403e-18,  4.374684708599697e-21,  4.164408057534298e-24, -3.893733415077469e-26, -2.830458928575425e-28,
  1.887178004176639e+00, -6.997181830209006e-04, -3.029650905618639e-06, -1.044091399670901e-08, -2.786210696681074e-11, -4.420788883298918e-14,  6.677422726834249e-17,
  9.073077739764899e-19,  4.374392500472545e-21,  1.355495063742834e-23,  2.026317870845113e-26, -7.033308091329370e-29,  1.922279954826960e+00, -4.931451801392673e-04,
 -2.236731264646006e-06, -8.406049944410841e-09, -2.660657363911928e-11, -6.688301349541290e-14, -9.866022080366497e-17,  1.915333514556800e-19,  2.352198048384631e-21,
  1.190332018767455e-23,  4.256542755872596e-26,  1.046932472305750e-28,  1.951167556419679e+00, -3.156495545280230e-04, -1.485721815402471e-06, -5.963428319816895e-09,
 -2.117338828030835e-11, -6.624795821826477e-14, -1.747007173113959e-16, -3.285920569523433e-19,  6.238526627045897e-25,  3.983462398005856e-24,  2.530842512519665e-26,
  1.113613579717866e-28,  1.973549023476406e+00, -1.734273602028144e-04, -8.395080978465752e-07, -3.535545285024442e-09, -1.356878024851475e-11, -4.814986313045833e-14,
 -1.578217584872804e-16, -4.702573086629475e-19, -1.219113863383353e-21, -2.396827042360026e-24, -1.090868472947271e-27,  2.188860625711922e-29,  1.989194585728011e+00,
 -7.154934244632533e-05, -3.530846109867247e-07, -1.535723380236566e-09, -6.194764530603961e-12, -2.366875998621776e-14, -8.647738250347425e-17, -3.032296969272117e-19,
 -1.019978485890840e-21, -3.276909297557834e-24, -9.957385239473062e-27, -2.805682604987726e-29,  1.997944703529939e+00, -1.368440882400864e-05, -6.825393891875664e-08,
 -3.021325226683080e-10, -1.251383193747139e-12, -4.964021459073616e-15, -1.909163707942201e-17, -7.169867335945294e-20, -2.640909061666340e-22, -9.567506286848513e-25,
 -3.415385935682287e-27, -1.202723646528913e-29,  5.467679460038669e-04, -2.877127660253516e-06,  1.135190415976072e-08, -3.980116401651953e-11,  1.307724710160348e-13,
 -4.122937210866502e-16,  1.263027307792936e-18, -3.787839530737608e-21,  1.117394120743810e-23, -3.252984436981377e-26,  9.366764661526267e-29, -2.672218079347410e-31,
  4.918907403046115e-03, -2.583948888393136e-05,  1.015873615657997e-07, -3.540065619985764e-10,  1.152330344696904e-12, -3.585093161047551e-15,  1.078675565512521e-17,
 -3.159624243186869e-20,  9.044329175506003e-23, -2.535422203626009e-25,  6.966842578822372e-28, -1.876501453669553e-30,  1.365247998437134e-02, -7.147284285852437e-05,
  2.789781870234362e-07, -9.602020343658285e-10,  3.066331068593512e-12, -9.279227167956722e-15,  2.686364948193909e-17, -7.467313859298452e-20,  1.992084423921428e-22,
 -5.078569645247042e-25,  1.225241944720002e-27, -2.743323595814806e-30,  2.672598784044227e-02, -1.391951948344939e-04,  5.374221730970633e-07, -1.814940118600443e-09,
  5.625001473169829e-12, -1.627712029037201e-14,  4.413581686937066e-17, -1.114369478981928e-19,  2.568863185864782e-22, -5.147855069146132e-25,  7.663553644274492e-28,
 -1.086975553854541e-31,  4.410697111571599e-02, -2.281354695265212e-04,  8.679115556915086e-07, -2.855491455062422e-09,  8.482313470182566e-12, -2.295808099554176e-14,
  5.594114202276114e-17, -1.175333789484622e-19,  1.845723730266632e-22, -5.403495818620726e-26, -1.161824882920480e-27,  6.510854319096658e-30,  6.575175194415737e-02,
 -3.371359840700837e-04,  1.258709352399449e-06, -4.002728545087336e-09,  1.122330961797900e-11, -2.752382527851349e-14,  5.573716359521660e-17, -7.352935070693832e-20,
 -5.863417096660075e-23,  8.836171992974836e-25, -4.067636579430767e-27,  1.370932970626640e-29,  9.160509269676019e-02, -4.647560360622825e-04,  1.695587127196727e-06,
 -5.164889530426495e-09,  1.340080980434590e-11, -2.826468433595348e-14,  3.864608490449827e-17,  2.772197841078529e-20, -4.471905661983755e-22,  2.015700363166150e-24,
 -6.403751649060465e-27,  1.509033905215502e-29,  1.215997683287138e-01, -6.092768613891565e-04,  2.162126127454725e-06, -6.242144820029683e-09,  1.457744058313391e-11,
 -2.383898056523378e-14,  2.863278581086806e-18,  1.759136749294137e-19, -8.794310707525458e-22,  2.807738249480417e-24, -6.111902608684493e-27,  4.855321322867261e-30,
  1.556560528987264e-01, -7.687082865315988e-04,  2.640083799231194e-06, -7.131860934030315e-09,  1.437042195074858e-11, -1.353392117184404e-14, -4.933698882949628e-17,
  3.419500208734961e-19, -1.193617244672579e-21,  2.645480204596290e-24, -1.681082833027485e-27, -1.741158224761799e-29,  1.936811207499205e-01, -9.407974733528592e-04,
  3.109827427464550e-06, -7.734421873120596e-09,  1.249606994895478e-11,  2.525690597571971e-15, -1.112384835897686e-16,  4.814824674595917e-19, -1.210170376730094e-21,
  1.101646290956324e-24,  6.688011147430846e-27, -4.351400239697658e-29,  2.355683635057475e-01, -1.123040230658844e-03,  3.550835971914782e-06, -7.959428183905556e-09,
  8.810559096032074e-12,  2.325397658396756e-14, -1.721373722779301e-16,  5.434334983249152e-19, -7.925319387828773e-22, -1.789032171554927e-24,  1.640182103998587e-26,
 -5.775983413326341e-29,  2.811966250095234e-01, -1.312695445040572e-03,  3.942269965139177e-06, -7.732047752592904e-09,  3.343181952333607e-12,  4.659480241188364e-14,
 -2.186847187125686e-16,  4.824811411542765e-19,  8.864273553120527e-23, -5.361435175383609e-24,  2.282210658269001e-26, -4.360711145460791e-29,  3.304293576964831e-01,
 -1.506803261657881e-03,  4.263607478936045e-06, -6.999241091421159e-09, -3.681794754748375e-12,  6.964806040402847e-14, -2.370491864562213e-16,  2.732824938876304e-19,
  1.308530562000242e-21, -8.366463078624387e-24,  2.086576109760383e-26,  5.924058825313779e-30,  3.831137057173175e-01, -1.702207720450375e-03,  4.495341513720046e-06,
 -5.735529467107061e-09, -1.183847057263827e-11,  8.894037308173913e-14, -2.156699309198261e-16, -7.679058014781393e-20,  2.579553884119307e-21, -9.288720844280408e-24,
  7.524408527978697e-27,  7.895787383255628e-29,  4.390795225271591e-01, -1.895584619889781e-03,  4.619730582286688e-06, -3.947920128328170e-09, -2.051119943374985e-11,
  1.008326110125906e-13, -1.482031160065308e-16, -5.201602198384017e-19,  3.496367668725651e-21, -6.899167294308194e-24, -1.563684588264891e-26,  1.429996703929145e-28,
  4.981383337182832e-01, -2.083475431901313e-03,  4.621589618541713e-06, -1.679554489104044e-09, -2.892750463091129e-11,  1.020362468038134e-13, -3.612219480622808e-17,
 -9.703160857647387e-19,  3.636724143545458e-21, -8.933132634751345e-25, -4.132720145244828e-26,  1.553878530995563e-28,  5.600822597188858e-01, -2.262328118570846e-03,
  4.489102550516175e-06,  9.883899184779074e-10, -3.621310909033051e-11,  9.018777143753608e-14,  1.096524206333015e-16, -1.314145726553811e-18,  2.702118809141904e-21,
  7.629640975380098e-24, -5.791429367595407e-26,  8.513746134866254e-29,  6.246829177153018e-01, -2.428545691371123e-03,  4.214630909747409e-06,  3.937024346869046e-09,
 -4.146819690478115e-11,  6.440765981705141e-14,  2.687044935979572e-16, -1.435327736213232e-18,  6.622355920074401e-22,  1.611992063680832e-23, -5.370229304731349e-26,
 -6.237659986773267e-29,  6.916903278836199e-01, -2.578543291228866e-03,  3.795484791951934e-06,  7.012756180873171e-09, -4.386145970943022e-11,  2.575143275537195e-14,
  4.131138933170261e-16, -1.245650215678296e-18, -2.147698102103964e-21,  2.115416970654422e-23, -2.304128981478279e-26, -2.325353801033157e-28,  7.608318558196464e-01,
 -2.708814433679767e-03,  3.234613592718518e-06,  1.003335775510109e-08, -4.273541276861944e-11, -2.254979840828626e-14,  5.116395107561023e-16, -7.176745515810530e-19,
 -5.029609772651560e-21,  1.962102722105557e-23,  2.830538815620726e-26, -3.344860765512362e-28,  8.318112309732416e-01, -2.816006835190460e-03,  2.541164712805472e-06,
  1.279733149144431e-08, -3.771310908345629e-11, -7.515746568222100e-14,  5.357790054558561e-16,  9.063488667940635e-20, -7.060661214297134e-21,  1.020520514556564e-23,
  8.187752705951294e-26, -2.836230773536737e-28,  9.043076898967403e-01, -2.897007889524004e-03,  1.730849674924921e-06,  1.509657955936126e-08, -2.879313101429353e-11,
 -1.250756622819717e-13,  4.668224413928637e-16,  1.029625229708812e-18, -7.362348568278898e-21, -5.419347432569661e-24,  1.118203492303135e-25, -5.844182856523748e-29,
  9.779753030790747e-01, -2.949039371008521e-03,  8.260500254875421e-07,  1.673206709671834e-08, -1.641719876132602e-11, -1.645071103658193e-13,  3.024515995364373e-16,
  1.878163781597028e-18, -5.440628522963326e-21, -2.238601421186115e-23,  9.647154401699021e-26,  2.610796230669529e-28,  1.052442554786645e+00, -2.969760281037375e-03,
 -1.444083346215302e-07,  1.753175629062888e-08, -1.493703842309693e-12, -1.860644772503641e-13,  6.104195676008297e-17,  2.392516079305267e-18, -1.482512882146448e-21,
 -3.391026788463255e-23,  3.189781869675304e-26,  5.091213676774680e-28,  1.127312256207923e+00, -2.957375907982964e-03, -1.145882032746411e-06,  1.736960083443348e-08,
  1.463811393276268e-11, -1.841933732648941e-13, -2.181950102180552e-16,  2.376685449900402e-18,  3.532573945016924e-21, -3.394973288119711e-23, -6.017864763969141e-26,
  5.159661116737912e-28,  1.202161882599084e+00, -2.910750134843369e-03, -2.138998343686140e-06,  1.618386687554656e-08,  3.031386756621334e-11, -1.565663642975788e-13,
 -4.805446658343878e-16,  1.756308590789582e-18,  8.020493277780912e-21, -2.035056399865822e-23, -1.373230486989358e-25,  2.232479872193197e-28,  1.276544434062222e+00,
 -2.829516820595118e-03, -3.081244451489003e-06,  1.399255831552972e-08,  4.372139807867321e-11, -1.051311806463701e-13, -6.667085372247480e-16,  6.300829227621071e-19,
  1.029598900728279e-20,  3.071171741149134e-24, -1.559010005013335e-25, -2.420389358934390e-28,  1.349989925744395e+00, -2.714184748848785e-03, -3.929064848188615e-06,
  1.090337517494425e-08,  5.313897622578621e-11, -3.647318784469866e-14, -7.276725788011281e-16, -7.279177248501435e-19,  9.259864039004839e-21,  2.706125847988333e-23,
 -9.738237259443646e-26, -6.085624501092847e-28,  1.422007614989856e+00, -2.566229271012339e-03, -4.640426801848006e-06,  7.115556278018894e-09,  5.720805265959143e-11,
  3.878512917939002e-14, -6.399928270673454e-16, -1.930782606888346e-18,  4.993791317021597e-21,  4.062286320994819e-23,  1.439797045944169e-26, -6.249035352460251e-28,
  1.492089068398381e+00, -2.388162511069364e-03, -5.177753060547734e-06,  2.911296623733987e-09,  5.519861563452135e-11,  1.076553641710316e-13, -4.166146052434734e-16,
 -2.599180801273096e-18, -1.063945149855409e-21,  3.662546976028167e-23,  1.201911115162081e-25, -2.520023403297666e-28,  1.559712158773369e+00, -2.183573039774808e-03,
 -5.511049721735878e-06, -1.364688964760915e-09,  4.721335105521675e-11,  1.573629576272621e-13, -1.083535260450169e-16, -2.504098428988145e-18, -6.570298553491155e-21,
  1.638219283323097e-23,  1.584961256725313e-25,  2.711352430107087e-28,  1.624346058578244e+00, -1.957125511037305e-03, -5.620982404755861e-06, -5.337401916827657e-09,
  3.427375852258030e-11,  1.783521144912296e-13,  2.068328794902807e-16, -1.674424955196831e-18, -9.274848436111054e-21, -1.001490062303162e-23,  1.068124736345680e-25,
  5.793516339505674e-28,  1.685457261135422e+00, -1.714511155894753e-03, -5.501586595714807e-06, -8.643522106699140e-09,  1.824196402471140e-11,  1.669546204587710e-13,
  4.456912831757772e-16, -4.117989614278427e-19, -8.133411788447751e-21, -2.880388913635484e-23,  8.165536563261709e-28,  4.643995357596551e-28,  1.742516612582424e+00,
 -1.462341516319803e-03, -5.162253132638434e-06, -1.097870356269335e-08,  1.558845643942670e-12,  1.268517706260252e-13,  5.466626482824038e-16,  8.138765323123984e-19,
 -3.919256279878626e-21, -3.069350754388903e-23, -8.812915594448821e-26,  5.356505143197360e-29,  1.795007277028736e+00, -1.207980576147624e-03, -4.628624169246800e-06,
 -1.214362532828936e-08, -1.317945472229988e-11,  6.862964509839895e-14,  4.922733263839528e-16,  1.558795324216791e-18,  1.121186481547706e-21, -1.678325978349982e-23,
 -1.050855548677427e-25, -2.996347616748723e-28,  1.842433486712980e+00, -9.593145810625545e-04, -3.942084284623736e-06, -1.208075645409258e-08, -2.373623358944331e-11,
  7.217626338439563e-15,  3.168742916949628e-16,  1.604253333120996e-18,  4.493430494069393e-21,  2.342775487578150e-24, -5.252391702778214e-26, -3.351495919830655e-28,
  1.884329852733726e+00, -7.244641992170074e-04, -3.157645506701590e-06, -1.089368496882036e-08, -2.872809747303323e-11, -4.228417784005798e-14,  9.421300928772367e-17,
  1.055245727848893e-18,  4.876116865639806e-21,  1.429274708016886e-23,  1.634231999251962e-26, -1.093933154920983e-28,  1.920270937194374e+00, -5.114498601301347e-04,
 -2.340202649216130e-06, -8.842583076113909e-09, -2.796743228276875e-11, -6.917759011595829e-14, -9.217668622645222e-17,  2.739976673920182e-19,  2.812482294382712e-21,
  1.369884275455690e-23,  4.722439365747304e-26,  1.065537536890754e-28,  1.949880725166743e+00, -3.278274349646915e-04, -1.559360070646831e-06, -6.313033141740465e-09,
 -2.254102026344279e-11, -7.055104037429679e-14, -1.838780067827474e-16, -3.260723169127672e-19,  1.634829562113978e-22,  5.099493143741071e-24,  3.063891048599743e-26,
  1.313826481218171e-28,  1.972841607895972e+00, -1.803168964149056e-04, -8.832697021449896e-07, -3.760560103858487e-09, -1.457074439880217e-11, -5.210008008554504e-14,
 -1.715481462183609e-16, -5.106559230869046e-19, -1.305931598810814e-21, -2.418825011002172e-24,  5.351061399084351e-29,  3.048310005595791e-29,  1.988902619862311e+00,
 -7.444945575618066e-05, -3.721239836570056e-07, -1.638742335356671e-09, -6.689601561200152e-12, -2.584990239900248e-14, -9.544306134847371e-17, -3.378358543053387e-19,
 -1.145423266230755e-21, -3.700911485963412e-24, -1.126850423557621e-26, -3.159651635295743e-29,  1.997888850378861e+00, -1.424529078319242e-05, -7.200302078190726e-08,
 -3.229744928655722e-10, -1.355413302318462e-12, -5.447299250271280e-15, -2.122288475060467e-17, -8.072810909627726e-20, -3.011261255094659e-22, -1.104568487131834e-24,
 -3.991505656649017e-27, -1.422504624697652e-29,  5.354380903446002e-04, -2.788187928898319e-06,  1.088657747314236e-08, -3.777315983493622e-11,  1.228213366473008e-13,
 -3.832144315881443e-16,  1.161802700413012e-18, -3.448309862856450e-21,  1.006756833096299e-23, -2.900799336723903e-26,  8.267083985555271e-29, -2.334426598425739e-31,
  4.817148376220380e-03, -2.504347423195319e-05,  9.744758512872799e-08, -3.361291204783208e-10,  1.083147297658224e-12, -3.336508565299633e-15,  9.941244721508253e-18,
 -2.884287642190246e-20,  8.179810563604893e-23, -2.272585557819086e-25,  6.191180720711606e-28, -1.654133018228344e-30,  1.337098044773301e-02, -6.928628689824971e-05,
  2.677441176640902e-07, -9.125910815579285e-10,  2.887028094765053e-12, -8.658885978169025e-15,  2.485936455386948e-17, -6.858176673199257e-20,  1.817793660256456e-22,
 -4.611858888372979e-25,  1.110143048725763e-27, -2.491887217590135e-30,  2.617767000827073e-02, -1.349814289475136e-04,  5.161723324866392e-07, -1.727487925555959e-09,
  5.309803653209022e-12, -1.525439151168981e-14,  4.112792348449237e-17, -1.035071995566899e-19,  2.389040136626286e-22, -4.842973626620154e-25,  7.564297187276073e-28,
 -3.316451664823194e-31,  4.320810201694105e-02, -2.213269679094244e-04,  8.344450412573948e-07, -2.723375892185877e-09,  8.036314599190613e-12, -2.165431949321804e-14,
  5.273254259598619e-17, -1.116666165258967e-19,  1.818565477199772e-22, -9.511558652676124e-26, -9.002209911595239e-28,  5.410039595526088e-30,  6.442304740532971e-02,
 -3.272554288483350e-04,  1.211736115369794e-06, -3.827487425431203e-09,  1.068604229208033e-11, -2.621102293663891e-14,  5.365663860324621e-17, -7.492693358471588e-20,
 -2.961192207383440e-23,  7.324683203507151e-25, -3.502040847708657e-27,  1.202950488467366e-29,  8.977281050462432e-02, -4.514356513556179e-04,  1.634876439775137e-06,
 -4.954948292893605e-09,  1.284484597254746e-11, -2.732941543997976e-14,  3.923252287092102e-17,  1.452476805705189e-20, -3.790786916089200e-22,  1.772537240233908e-24,
 -5.761758033236978e-27,  1.408141384985958e-29,  1.191967860481944e-01, -5.922755464599481e-04,  2.088604106718383e-06, -6.012714655209171e-09,  1.410173108631579e-11,
 -2.371424318674844e-14,  7.409737991577888e-18,  1.493423984629263e-19, -7.826975764262024e-22,  2.567967063073150e-24, -5.866866360516445e-27,  6.201210491809339e-30,
  1.526229245625695e-01, -7.479260576815047e-04,  2.555871896453011e-06, -6.904160766804896e-09,  1.408865625794156e-11, -1.460734231695160e-14, -4.028291221658714e-17,
  3.052636745671374e-19, -1.099762048897996e-21,  2.564321829673831e-24, -2.343513177797378e-27, -1.283480827924647e-29,  1.899671050816787e-01, -9.162867043329505e-04,
  3.018215197122501e-06, -7.534221192953360e-09,  1.252095607335133e-11,  1.340752498440359e-17, -9.829282171643468e-17,  4.434395691410493e-19, -1.166139110833942e-21,
  1.332848429436727e-24,  4.919825441307009e-27, -3.696120333256110e-29,  2.311324144701704e-01, -1.095013165051110e-03,  3.456183281907519e-06, -7.814957948039760e-09,
  9.235543118264378e-12,  1.930235240433300e-14, -1.572850965091750e-16,  5.171637267107109e-19, -8.457277741637516e-22, -1.182410310468076e-24,  1.396399380792809e-26,
 -5.299638963818056e-29,  2.760083332880260e-01, -1.281527445271870e-03,  3.849836178980146e-06, -7.671382241078531e-09,  4.223688857704062e-12,  4.150863122088884e-14,
 -2.051633167288052e-16,  4.824019119001043e-19, -8.840593571140663e-23, -4.487615168815152e-24,  2.085497411608084e-26, -4.552432134161067e-29,  3.244698291504435e-01,
 -1.473031262976933e-03,  4.179308107272526e-06, -7.047312546702020e-09, -2.345082252875429e-12,  6.405516195918115e-14, -2.288551839091746e-16,  3.104977639409074e-19,
  1.022391007754118e-21, -7.530211540735576e-24,  2.086268905909096e-26, -5.630432401597570e-30,  3.763763600294546e-01, -1.666523380459782e-03,  4.425436454994143e-06,
 -5.910996337332294e-09, -1.011155115182865e-11,  8.374751403026139e-14, -2.167142457706581e-16,  4.693813153158351e-22,  2.251362682465902e-21, -8.923955884974882e-24,
  1.057639441381786e-26,  6.009028745133479e-29,  4.315707920191443e-01, -1.858821702457572e-03,  4.570452376125072e-06, -4.260164085814063e-09, -1.853123133321055e-11,
  9.711337174946824e-14, -1.612393585827164e-16, -4.123590841522690e-19,  3.238209768535004e-21, -7.403834632837399e-24, -9.722537744858218e-27,  1.257104415210027e-28,
  4.898782388743120e-01, -2.046591047105549e-03,  4.598725090899263e-06, -2.126124868360371e-09, -2.689758190194340e-11,  1.008563975269958e-13, -6.166882472767863e-17,
 -8.547611631000212e-19,  3.576452247346690e-21, -2.410248359050540e-24, -3.454223760797577e-26,  1.522894754561901e-28,  5.511048342790422e-01, -2.226377567463302e-03,
  4.497546724412605e-06,  4.235408714356334e-10, -3.438596604657901e-11,  9.238788542663044e-14,  7.410503793209870e-17, -1.223722625743611e-18,  2.936050189564863e-21,
  5.394462389639835e-24, -5.369654080723455e-26,  1.054776321965389e-28,  6.150364524662941e-01, -2.394650846165586e-03,  4.257937861852896e-06,  3.284175198105882e-09,
 -4.011879535636899e-11,  7.037721345980706e-14,  2.288962563980978e-16, -1.405270316714248e-18,  1.203340310116935e-21,  1.392946379229419e-23, -5.551922447295891e-26,
 -2.101879299273487e-29,  6.814373986579871e-01, -2.547854688330941e-03,  3.875445874210344e-06,  6.315619765914738e-09, -4.325014602947617e-11,  3.524055847758249e-14,
  3.773866245772010e-16, -1.302388873293953e-18, -1.405085985749710e-21,  2.004082233656631e-23, -3.230288490308474e-26, -1.881941830191643e-28,  7.500490979874292e-01,
 -2.682467577774351e-03,  3.350898545014846e-06,  9.346643209941498e-09, -4.306533413763740e-11, -1.052911608971560e-14,  4.893989397052353e-16, -8.671303382666123e-19,
 -4.306375764236582e-21,  2.046387284696730e-23,  1.397777967763556e-26, -3.151746492292816e-28,  8.205888202383493e-01, -2.795073613239892e-03,  2.691064892695725e-06,
  1.218259561549314e-08, -3.908759630465442e-11, -6.229348613063163e-14,  5.352131989536571e-16, -1.288209609792848e-19, -6.637415378795972e-21,  1.322148589532198e-23,
  6.873274515903017e-26, -3.116021116458294e-28,  8.927484879713146e-01, -2.882444474150766e-03,  1.909163936605950e-06,  1.461649541469148e-08, -3.118040992459290e-11,
 -1.135527414189896e-13,  4.923304050255679e-16,  7.917654164206395e-19, -7.477757056782292e-21, -1.020130403500835e-24,  1.076071504490703e-25, -1.316284889761673e-28,
  9.661936274020054e-01, -2.941632544463179e-03,  1.025151530412264e-06,  1.644348269266727e-08, -1.963059764499500e-11, -1.566375997508160e-13,  3.524870635670055e-16,
  1.691935107196872e-18, -6.174517684938997e-21, -1.832171269441194e-23,  1.061326320614646e-25,  1.772688185436180e-28,  1.040562534596953e+00, -2.970074711888062e-03,
  6.570686255401374e-08,  1.747818897745938e-08, -5.194949547538314e-12, -1.838020637653163e-13,  1.271867252996404e-16,  2.325832807240296e-18, -2.675012334850106e-21,
 -3.219702741624386e-23,  5.346542483101373e-26,  4.681362615647864e-28,  1.115465743802852e+00, -2.965705523547154e-03, -9.361639907340460e-07,  1.757407803258575e-08,
  1.090733115524270e-11, -1.886198582101317e-13, -1.502520113534177e-16,  2.469753429485221e-18,  2.272651129699201e-21, -3.588941241022037e-23, -3.651170307570068e-26,
  5.562476361720487e-28,  1.190485899381835e+00, -2.927077292577804e-03, -1.941987126592820e-06,  1.664322874087566e-08,  2.707133974632262e-11, -1.674810288182113e-13,
 -4.278924187256546e-16,  2.000203523607216e-18,  7.191670353236365e-21, -2.561388565941882e-23, -1.250359128515169e-25,  3.339749024422936e-28,  1.265178146874308e+00,
 -2.853483406602853e-03, -2.909208682239034e-06,  1.467441697703982e-08,  4.146038613156834e-11, -1.208831887319061e-13, -6.444456830179554e-16,  9.601011293940009e-19,
  1.029203385834757e-20, -3.344916997551417e-24, -1.640606749248751e-25, -1.264033587115149e-28,  1.339071170692413e+00, -2.745079513460369e-03, -3.793150167824380e-06,
  1.174680788334589e-08,  5.223339689873828e-11, -5.414755442323254e-14, -7.437650612328259e-16, -4.168184339423756e-19,  1.015758291089993e-20,  2.263984235936492e-23,
 -1.234045319715684e-25, -5.695696491538233e-28,  1.411669013897932e+00, -2.602995524693954e-03, -4.549525308004526e-06,  8.036238151753865e-09,  5.782587701797110e-11,
  2.279596981872554e-14, -6.915971964779341e-16, -1.747526527489669e-18,  6.459745649702643e-21,  4.062619697805680e-23, -1.475823133848702e-26, -6.971554250701484e-28,
  1.482453816971092e+00, -2.429429619308833e-03, -5.137449208943566e-06,  3.811131269214816e-09,  5.724582587648511e-11,  9.678069257367615e-14, -4.896636198025376e-16,
 -2.611226919087186e-18,  3.380819523915784e-22,  4.117224219964596e-23,  1.061673712076856e-25, -3.864830458188035e-28,  1.550889604546340e+00, -2.227713862433856e-03,
 -5.522790171894432e-06, -5.842628266967328e-10,  5.032880575408064e-11,  1.538979269638876e-13, -1.813142640444214e-16, -2.703666439199584e-18, -5.863781419065707e-21,
  2.293454950910447e-23,  1.684287183175445e-25,  1.759838683770426e-28,  1.616427228693721e+00, -2.002339970339144e-03, -5.681622405898343e-06, -4.760232279950109e-09,
  3.788646847701995e-11,  1.827196565493781e-13,  1.557458176517501e-16, -1.976113856058030e-18, -9.552280633883093e-21, -5.226742870752517e-24,  1.327010546286927e-25,
  5.937665263651924e-28,  1.678510541562853e+00, -1.758933518382114e-03, -5.603445571811573e-06, -8.324361223310630e-09,  2.168693232286617e-11,  1.774824795015960e-13,
  4.303615421440127e-16, -6.886111597081385e-19, -9.164573388088019e-21, -2.833331059077092e-23,  2.343950685859405e-26,  5.641612897991358e-28,  1.736583816944239e+00,
 -1.504165897662502e-03, -5.293761874409542e-06, -1.093274542117645e-08,  4.228848300251462e-12,  1.402299194971050e-13,  5.675244344465904e-16,  6.701066090140549e-19,
 -5.086880032854043e-21, -3.414627994735864e-23, -8.385001346419490e-26,  1.441221600312443e-28,  1.790100368903879e+00, -1.245595939767495e-03, -4.775565485204534e-06,
 -1.234285903098089e-08, -1.168516239821437e-11,  8.097142645096841e-14,  5.363251231331399e-16,  1.584169172113113e-18,  4.381645046594834e-22, -2.124859018411169e-23,
 -1.181113273925178e-25, -2.900091582024510e-28,  1.838532227805911e+00, -9.914375741725124e-04, -4.089325895951617e-06, -1.245895260156689e-08, -2.351210853733173e-11,
  1.537794940490892e-14,  3.638160582992247e-16,  1.748957260307802e-18,  4.536253253699530e-21, -6.918514992769101e-26, -6.847625717744693e-26, -3.903341572712267e-28,
  1.881380634573434e+00, -7.502561376142292e-04, -3.291155105060404e-06, -1.135996677378815e-08, -2.954868345228197e-11, -3.965039131725502e-14,  1.260225834013541e-16,
  1.219630036205572e-18,  5.401139432243497e-21,  1.483654189919182e-23,  1.049136525760372e-26, -1.583027022582534e-28,  1.918187011596060e+00, -5.306036383702419e-04,
 -2.449044558611760e-06, -9.301247808063485e-09, -2.937243052152848e-11, -7.128712849361557e-14, -8.316796902829075e-17,  3.722613675266897e-19,  3.340770297104947e-21,
  1.568132744293802e-23,  5.188550309038266e-26,  1.045600783425985e-28,  1.948543977076118e+00, -3.406115810889377e-04, -1.637327755131632e-06, -6.685220500651516e-09,
 -2.399690751785695e-11, -7.507290330800621e-14, -1.929054390878133e-16, -3.176553288242351e-19,  3.705768254692354e-22,  6.447177727331065e-24,  3.691162148832177e-26,
  1.542181468668875e-28,  1.972105916491075e+00, -1.875676048294891e-04, -9.298303390157512e-07, -4.002256673268489e-09, -1.565510046964786e-11, -5.639361861040123e-14,
 -1.864446410881787e-16, -5.538357621626654e-19, -1.392620131143723e-21, -2.386813860824280e-24,  1.627131882665852e-27,  4.148820014617565e-29,  1.988598740889481e+00,
 -7.750696694587943e-05, -3.924485664889075e-07, -1.750039694793367e-09, -7.230294095244845e-12, -2.825831685481578e-14, -1.054362805199129e-16, -3.767109024936234e-19,
 -1.287114594072007e-21, -4.180575317909081e-24, -1.274299119499481e-26, -3.548248578278124e-29,  1.997830692089708e+00, -1.483719486111537e-05, -7.601252138439462e-08,
 -3.455611368276935e-10, -1.469641658489217e-12, -5.984899876180273e-15, -2.362438123130254e-17, -9.103245892377290e-20, -3.439219997763541e-22, -1.277487182674063e-24,
 -4.673592875843251e-27, -1.685769023339825e-29,  5.244566995160645e-04, -2.702875586185195e-06,  1.044484230122373e-08, -3.586784995200360e-11,  1.154282440264600e-13,
 -3.564543371566050e-16,  1.069607740101255e-18, -3.142237613256399e-21,  9.080409830611250e-24, -2.589767940237098e-26,  7.305767273015185e-29, -2.042130008951297e-31,
  4.718508504188125e-03, -2.427973812125410e-05,  9.351585698206933e-08, -3.193199110610082e-10,  1.018739106616933e-12, -3.107321508616860e-15,  9.169093079065675e-18,
 -2.635159716093008e-20,  7.404556438755604e-23, -2.038902983682891e-25,  5.507120111935605e-28, -1.459492773002671e-30,  1.309805094062822e-02, -6.718736601130222e-05,
  2.570645677677993e-07, -8.677522784528957e-10,  2.719664412340323e-12, -8.084662428022343e-15,  2.301807618405207e-17, -6.302211006427958e-20,  1.659501879081904e-22,
 -4.189035888124814e-25,  1.005654131974171e-27, -2.260908827027067e-30,  2.564587376954595e-02, -1.309335482845226e-04,  4.959423217011658e-07, -1.644919108984929e-09,
  5.014356167317551e-12, -1.430125179185285e-14,  3.833417133046505e-17, -9.613541850152668e-20,  2.220099396452244e-22, -4.543841437594462e-25,  7.380378377476176e-28,
 -4.956851408093267e-31,  4.233594133250160e-02, -2.147799762176647e-04,  8.025219447677960e-07, -2.598191837760396e-09,  7.615634143903337e-12, -2.042560426197672e-14,
  4.968678736419433e-17, -1.059084950100995e-19,  1.778389714946784e-22, -1.266495314810311e-25, -6.832688646467885e-28,  4.477038622646490e-30,  6.313312663021961e-02,
 -3.177423921080178e-04,  1.166815051742187e-06, -3.660635259099141e-09,  1.017452903889251e-11, -2.494852271319509e-14,  5.154919554907480e-17, -7.547864126195537e-20,
 -5.641136425989234e-24,  6.025176176299150e-25, -3.006446883001502e-27,  1.052552071597766e-29,  8.799285422424011e-02, -4.385910247651158e-04,  1.576632294097833e-06,
 -4.753752190239247e-09,  1.230769957169649e-11, -2.638426791650241e-14,  3.947867189626193e-17,  3.371944174585371e-21, -3.192692884855714e-22,  1.554151671202864e-24,
 -5.165156581221986e-27,  1.303350626046972e-29,  1.168606499293772e-01, -5.758515242148145e-04,  2.017789680702862e-06, -5.790870202541034e-09,  1.362954899783636e-11,
 -2.348897684839338e-14,  1.125425474106099e-17,  1.257304847315706e-19, -6.944064152193814e-22,  2.339043826861344e-24, -5.572739466611610e-27,  7.102770227770964e-30,
  1.496715949463267e-01, -7.278066726424811e-04,  2.474364675021822e-06, -6.681129134716168e-09,  1.378751365786076e-11, -1.547545572831911e-14, -3.221447965048504e-17,
  2.715292130170178e-19, -1.009259127090673e-21,  2.460458539335199e-24, -2.821974878242946e-27, -9.033316659040583e-30,  1.863496819137404e-01, -8.924992204648850e-04,
  2.929006159603578e-06, -7.334007778154392e-09,  1.249861806761122e-11, -2.200795642986492e-15, -8.639147783189289e-17,  4.069257462442046e-19, -1.114989863880005e-21,
  1.498903925421622e-24,  3.426051978092922e-27, -3.104326045931086e-29,  2.268070703891539e-01, -1.067736276678353e-03,  3.363302487169725e-06, -7.664301113616425e-09,
  9.584998712333496e-12,  1.569818335980262e-14, -1.431890548205260e-16,  4.895226975696409e-19, -8.787891928125200e-22, -6.690300771643395e-25,  1.174131565834943e-26,
 -4.801570082211014e-29,  2.709432395636699e-01, -1.251095771966485e-03,  3.758211607834634e-06, -7.597424786466056e-09,  5.005714108709206e-12,  3.674633536874137e-14,
 -1.917188309376364e-16,  4.771451233894127e-19, -2.354293461597368e-22, -3.693688892132931e-24,  1.883861210696610e-26, -4.590422272904162e-29,  3.186440366579295e-01,
 -1.439935611543448e-03,  4.094556546768317e-06, -7.074880444694446e-09, -1.118181984469682e-12,  5.867041701801626e-14, -2.197428242322527e-16,  3.390372765014159e-19,
  7.662386734213741e-22, -6.703496654266930e-24,  2.040712439567687e-26, -1.468712455603314e-29,  3.697806205378560e-01, -1.631406241525112e-03,  4.353588148350420e-06,
 -6.059664001732004e-09, -8.488570400828410e-12,  7.855437696638004e-14, -2.157401785032813e-16,  6.745930139114878e-20,  1.938305707791257e-21, -8.453126987083434e-24,
  1.284246493254227e-26,  4.326090237420236e-29,  4.242083017517403e-01, -1.822467465591953e-03,  4.517614812411531e-06, -4.541339621960911e-09, -1.662853711304216e-11,
  9.311653515523318e-14, -1.713752385072579e-16, -3.130655298608486e-19,  2.965957249636224e-21, -7.687305002416151e-24, -4.579642564664331e-27,  1.080555400485025e-28,
  4.817652825745928e-01, -2.009910463774506e-03,  4.570695707673233e-06, -2.540437477108995e-09, -2.489712660481919e-11,  9.910198904828008e-14, -8.401475674674289e-17,
 -7.419566573601222e-19,  3.466411697078439e-21, -3.659739341888104e-24, -2.798358066923665e-26,  1.452657019576182e-28,  5.422713039275415e-01, -2.190386075688588e-03,
  4.499389419786485e-06, -1.117673473492720e-10, -3.252314295472745e-11,  9.376601714298810e-14,  4.118244823805526e-17, -1.127066988151800e-18,  3.092749983618960e-21,
  3.343964437128788e-24, -4.872707758202885e-26,  1.193930641413957e-28,  6.055262104225172e-01, -2.360440506327098e-03,  4.293543939341834e-06,  2.653820013170215e-09,
 -3.865947874038059e-11,  7.540335205904009e-14,  1.901601072830291e-16, -1.359169805354912e-18,  1.664705394291844e-21,  1.170122525817590e-23, -5.562978199428819e-26,
  1.507206910833625e-29,  6.713084504922709e-01, -2.516559678927244e-03,  3.947106116152851e-06,  5.629735549253409e-09, -4.245773935107550e-11,  4.385581135072738e-14,
  3.403968506665955e-16, -1.336072893901431e-18, -7.087495470169289e-22,  1.859633070880056e-23, -3.959465007635487e-26, -1.433194783963242e-28,  7.393735358449189e-01,
 -2.655223476211200e-03,  3.458919086250317e-06,  8.656542854896137e-09, -4.316050494255112e-11,  9.102147195683258e-16,  4.633013987876314e-16, -9.930659407994309e-19,
 -3.562885649687369e-21,  2.075329833121879e-23,  6.971814649203809e-28, -2.872430651919294e-28,  8.094524935721689e-01, -2.772971051494572e-03,  2.833464773498397e-06,
  1.154792338248326e-08, -4.020542913225173e-11, -4.951519599263942e-14,  5.287078307121879e-16, -3.330992088709684e-19, -6.115307730747402e-21,  1.569137254647532e-23,
  5.465654396305078e-26, -3.260369728138346e-28,  8.812503553558091e-01, -2.866478220343211e-03,  2.081495716447742e-06,  1.410008946710756e-08, -3.333164951292426e-11,
 -1.014978226235150e-13,  5.111501318581022e-16,  5.527078172336555e-19, -7.438578555521795e-21,  3.148907027470969e-24,  1.003837585087661e-25, -1.948876223073631e-28,
  9.544447415051299e-01, -2.932647619597764e-03,  1.220486936467061e-06,  1.610480645553627e-08, -2.267503330371837e-11, -1.476323268954021e-13,  3.970018279771281e-16,
  1.484630315864325e-18, -6.756035338158124e-21, -1.394582713314105e-23,  1.120307566189072e-25,  9.071208855088163e-29,  1.028684613039855e+00, -2.968711795135426e-03,
  2.748257030526134e-07,  1.736584926032557e-08, -8.835245498492183e-12, -1.799788306440053e-13,  1.909405595878134e-16,  2.222139031813489e-18, -3.790789820786867e-21,
 -2.966246715500231e-23,  7.283710432736846e-26,  4.097687823184548e-28,  1.103589282523703e+00, -2.972348600791231e-03, -7.243530097574350e-07,  1.771824386965707e-08,
  7.104512281534121e-12, -1.913890541328658e-13, -8.027673121018294e-17,  2.521572413765120e-18,  9.603084227576861e-22, -3.685344489265644e-23, -1.155945898525413e-26,
  5.741468330417398e-28,  1.178747793358196e+00, -2.941807209306443e-03, -1.739781824852181e-06,  1.704903473904627e-08,  2.362369211014389e-11, -1.770532591891105e-13,
 -3.688101805347537e-16,  2.214648681475202e-18,  6.183364783223176e-21, -3.029099168262225e-23, -1.080893021137638e-25,  4.341314858927089e-28,  1.253718796836391e+00,
 -2.876041615974939e-03, -2.729217959907099e-06,  1.531761129562709e-08,  3.889042460207704e-11, -1.359902319267500e-13, -6.129792050506128e-16,  1.286244310019547e-18,
  1.005248782496786e-20, -9.981633905084335e-24, -1.668427658498755e-25,  1.523142519868903e-30,  1.328031074934439e+00, -2.774846749163052e-03, -3.647212955402655e-06,
  1.257290545737904e-08,  5.097118974412595e-11, -7.210051923088159e-14, -7.507699245214086e-16, -7.973590732774643e-20,  1.087788482753328e-20,  1.722025906290047e-23,
 -1.470824382797108e-25, -5.020049859682854e-28,  1.401184872391668e+00, -2.638990230378323e-03, -4.447527086363577e-06,  8.964181497515730e-09,  5.811197613170756e-11,
  5.635172441961261e-15, -7.374152690825355e-16, -1.517588930411460e-18,  7.904117090907097e-21,  3.940590530633985e-23, -4.661901947913914e-26, -7.468599498746301e-28,
  1.472654211123460e+00, -2.470330564979864e-03, -5.086158295342320e-06,  4.741886053624377e-09,  5.905801043027391e-11,  8.415401394613250e-14, -5.623980497544617e-16,
 -2.575909158489083e-18,  1.892256170603962e-21,  4.503832045676905e-23,  8.613308664544229e-26, -5.241445957302445e-28,  1.541890359682460e+00, -2.271910306730074e-03,
 -5.524869024925895e-06,  2.453591897330575e-10,  5.335701077991263e-11,  1.486175589907559e-13, -2.595104283285352e-16, -2.876783718751072e-18, -4.915307773118071e-21,
  2.979270405000916e-23,  1.735944045916091e-25,  5.455069290639406e-29,  1.608326615992337e+00, -2.048010856658915e-03, -5.734986892343046e-06, -4.124629982617722e-09,
  4.157357966467906e-11,  1.857589048999161e-13,  9.611452058403022e-17, -2.283721913565680e-18, -9.638608693277738e-21,  6.027356196697933e-25,  1.586975280051408e-25,
  5.833350672679982e-28,  1.671384528396730e+00, -1.804154480065351e-03, -5.701137024078273e-06, -7.948419081759017e-09,  2.533813167346743e-11,  1.875457092909866e-13,
  4.068229408939895e-16, -9.979662298970636e-19, -1.016144651365751e-20, -2.686995847592866e-23,  5.044756455897296e-26,  6.628485972101342e-28,  1.730481624185938e+00,
 -1.547039396203436e-03, -5.424453884454788e-06, -1.084190097567840e-08,  7.171072389484443e-12,  1.540561089417453e-13,  5.838191632566382e-16,  4.870250993367698e-19,
 -6.374710271346784e-21, -3.734246913216962e-23, -7.515730093221879e-26,  2.542550498070806e-28,  1.785040633720739e+00, -1.284395971551518e-03, -4.924745821332137e-06,
 -1.251615173274067e-08, -9.933417875606450e-12,  9.437635462647983e-14,  5.807565166036531e-16,  1.585014828966445e-18, -4.148439628227826e-22, -2.622182093221964e-23,
 -1.303576609831498e-25, -2.635009438614233e-28,  1.834500092420641e+00, -1.024756579817929e-03, -4.241078757180528e-06, -1.283219450515752e-08, -2.311318236800594e-11,
  2.471356548383103e-14,  4.148147602341249e-16,  1.893514290998336e-18,  4.480169569973801e-21, -3.168320552252858e-24, -8.689155471649277e-26, -4.467267080906222e-28,
  1.878326076759084e+00, -7.771387532435909e-04, -3.430336984311435e-06, -1.183891346958620e-08, -3.030857669752175e-11, -3.619602704036513e-14,  1.626727239252585e-16,
  1.401078723137902e-18,  5.940978165655289e-21,  1.510003948794967e-23,  2.245250989368769e-27, -2.184979050282873e-28,  1.916024694012070e+00, -5.506505530775583e-04,
 -2.563526676223575e-06, -9.782717319910561e-09, -3.081722441648896e-11, -7.314546353979202e-14, -7.116021085879718e-17,  4.886079213341492e-19,  3.943749416218812e-21,
  1.784702918299182e-23,  5.634566923058147e-26,  9.712581194742365e-29,  1.947154816063586e+00, -3.540377366328806e-04, -1.719904475408537e-06, -7.081437231280385e-09,
 -2.554537545810068e-11, -7.980780104730027e-14, -2.015967671188207e-16, -3.017846285942822e-19,  6.309536616090839e-22,  8.066726523865875e-24,  4.425358589290128e-26,
  1.799989787002672e-28,  1.971340458488233e+00, -1.952027013736670e-04, -9.793983306971862e-07, -4.262009747698895e-09, -1.682900201549119e-11, -6.105949338029067e-14,
 -2.025887423314845e-16, -5.997580511036470e-19, -1.476899012177307e-21, -2.281335780821690e-24,  3.748743254952061e-27,  5.550037594586266e-29,  1.988282298007407e+00,
 -8.073256788718371e-05, -4.141622569160784e-07, -1.870386891762235e-09, -7.821644176760362e-12, -3.092015931367684e-14, -1.165841578186564e-16, -4.204080830543661e-19,
 -1.447177573821617e-21, -4.722738716504422e-24, -1.439593699006534e-26, -3.970509039706913e-29,  1.997770100270682e+00, -1.546229101087829e-05, -8.030439287185756e-08,
 -3.700646830971991e-10, -1.595222581480911e-12, -6.583759375048304e-15, -2.633454679185050e-17, -1.028113788977717e-19, -3.934632999393065e-22, -1.480153944067723e-24,
 -5.482747442041738e-27, -2.001769122523932e-29,  5.138096323128948e-04, -2.621007640985756e-06,  1.002527839104929e-08, -3.407666530723698e-11,  1.085489026571922e-13,
 -3.318075501926978e-16,  9.855568738950384e-19, -2.866034665024556e-21,  8.198600176210933e-24, -2.314736150844138e-26,  6.464264240247883e-29, -1.788833699682347e-31,
  4.622861922166683e-03, -2.354666617076583e-05,  8.977980422757773e-08, -3.035055464346268e-10,  9.587348488881037e-13, -2.895856295862547e-15,  8.463346916223944e-18,
 -2.409545089122946e-20,  6.708702470268150e-23, -1.830943432715505e-25,  4.903273497687377e-28, -1.288970979193000e-30,  1.283334958888567e-02, -6.517177392641860e-05,
  2.469073879473745e-07, -8.255017676227881e-10,  2.563355611060348e-12, -7.552817614294594e-15,  2.132558992329003e-17, -5.794541961639213e-20,  1.515703368038820e-22,
 -3.806033975376556e-25,  9.108956349753683e-28, -2.049421447951101e-30,  2.512995153695948e-02, -1.270436233408884e-04,  4.766753912164418e-07, -1.566928523792811e-09,
  4.737317382991694e-12, -1.341274530462564e-14,  3.573942130150356e-17, -8.928717301312849e-20,  2.061778944833056e-22, -4.253363279137783e-25,  7.135019253249124e-28,
 -6.126848172299123e-31,  4.148946720016236e-02, -2.084824730461785e-04,  7.720614698435007e-07, -2.479545993304247e-09,  7.218809992085004e-12, -1.926806794602810e-14,
  4.680030048809729e-17, -1.002955022471224e-19,  1.728328889170272e-22, -1.502824183130933e-25, -5.041192941812109e-28,  3.688085159335260e-30,  6.188055175190382e-02,
 -3.085808522032163e-04,  1.123847933175853e-06, -3.501768056634930e-09,  9.687759182678284e-12, -2.373670400751261e-14,  4.943636684104787e-17, -7.533443590124815e-20,
  1.399275188762903e-23,  4.911162527174236e-25, -2.573382027041442e-27,  9.185176456671777e-30,  8.626335963042273e-02, -4.262028385927277e-04,  1.520751560154058e-06,
 -4.560998987791775e-09,  1.178949098996077e-11, -2.543675099638873e-14,  3.943818687604907e-17, -5.988253578832849e-21, -2.669033616750654e-22,  1.358704384161881e-24,
 -4.614879742100755e-27,  1.198053924304535e-29,  1.145890935480758e-01, -5.599834969037225e-04,  1.949592222953310e-06, -5.576539826562849e-09,  1.316274298629638e-11,
 -2.317906398215063e-14,  1.447597001867523e-17,  1.048143699016252e-19, -6.141361748953882e-22,  2.122568664891534e-24, -5.247043538976234e-27,  7.649748762868356e-30,
  1.467994555878069e-01, -7.083287230201013e-04,  2.395504383748872e-06, -6.463044476448282e-09,  1.347087037981182e-11, -1.616093785771466e-14, -2.505065330820202e-17,
  2.406276406422456e-19, -9.228013610843865e-22,  2.340595196146111e-24, -3.148467670745616e-27, -5.911799985255748e-30,  1.828259965400035e-01, -8.694158079954708e-04,
  2.842196126569236e-06, -7.134490868818955e-09,  1.243477048554899e-11, -4.141445122765225e-15, -7.548878675625822e-17,  3.721333133278324e-19, -1.058877097503682e-21,
  1.610227946589594e-24,  2.178602758262830e-27, -2.576329841381581e-29,  2.225893593459491e-01, -1.041195113443754e-03,  3.272260802248441e-06, -7.508611540577426e-09,
  9.865690738078146e-12,  1.242292885416463e-14, -1.298791148955103e-16,  4.611026810892252e-19, -8.949162284296710e-22, -2.401535821075147e-25,  9.739008289879323e-27,
 -4.300662127122568e-29,  2.659984124510608e-01, -1.221393339686648e-03,  3.667546514083775e-06, -7.511699422841006e-09,  5.695705559330695e-12,  3.230443511023975e-14,
 -1.784832160401948e-16,  4.676253112158181e-19, -3.553237562287422e-22, -2.980375615328935e-24,  1.683304461507724e-26, -4.508611578565808e-29,  3.129492691114584e-01,
 -1.407518970242557e-03,  4.009588439175933e-06, -7.083667359683237e-09,  3.270408252752964e-15,  5.351305909403787e-14, -2.099416696562852e-16,  3.598518465139697e-19,
  5.394302131286457e-22, -5.902299299569372e-24,  1.960300650359278e-26, -2.152057125938510e-29,  3.633241893431791e-01, -1.596870591522950e-03,  4.280108214223958e-06,
 -6.183192988277975e-09, -6.969072463606994e-12,  7.340601036797285e-14, -2.130279783533002e-16,  1.247186787798371e-19,  1.643657380156880e-21, -7.905838796989783e-24,
  1.441496044628125e-26,  2.857199795647809e-29,  4.169903623839611e-01, -1.786548914285392e-03,  4.461583122723207e-06, -4.792723834171705e-09, -1.480799216097935e-11,
  8.890880756446544e-14, -1.788541279102566e-16, -2.226091497376974e-19,  2.687015773841662e-21, -7.780553985868895e-24, -2.093747240880199e-28,  9.068572075659644e-29,
  4.737985694147347e-01, -1.973473461241366e-03,  4.537885367467842e-06, -2.923051579330120e-09, -2.293686888660439e-11,  9.684874283953916e-14, -1.032578658137825e-16,
 -6.333431851805772e-19,  3.316028558884220e-21, -4.654003265862651e-24, -2.180241026590004e-26,  1.352852117364221e-28,  5.335817290605811e-01, -2.154405028637057e-03,
  4.494988020590544e-06, -6.170918971507884e-10, -3.064043679103849e-11,  9.438698281890601e-14,  1.102560054146215e-17, -1.026538588410639e-18,  3.179341305926813e-21,
  1.502729776581802e-24, -4.327574148787443e-26,  1.274937215867001e-28,  5.961533320983793e-01, -2.325975170669600e-03,  4.321729003906008e-06,  2.047568032270298e-09,
 -3.710882316464262e-11,  7.951690707190516e-14,  1.529094162328349e-16, -1.299586923790197e-18,  2.046141794935013e-21,  9.498649286109196e-24, -5.427820468859949e-26,
  4.538677458600485e-29,  6.613057771219928e-01, -2.484724081715394e-03,  4.010617347590122e-06,  4.957859769235645e-09, -4.150196875409472e-11,  5.157445980491426e-14,
  3.027676862855314e-16, -1.348358618732541e-18, -6.919110907055657e-23,  1.689940555878061e-23, -4.493381556528735e-26, -9.971013003186046e-29,  7.288086259757873e-01,
 -2.627148343860738e-03,  3.558656723391091e-06,  7.966714878257637e-09, -4.303342424099952e-11,  1.168358466841213e-14,  4.340115945253238e-16, -1.095143146535587e-18,
 -2.818223020390525e-21,  2.053814002815474e-23, -1.120435456603791e-26, -2.528509727892414e-28,  7.984068069122517e-01, -2.749760039662170e-03,  2.968149676516616e-06,
  1.089739995790484e-08, -4.106971065698236e-11, -3.695970599579980e-14,  5.167291619697277e-16, -5.193570369831795e-19, -5.514537044424989e-21,  1.758934426196337e-23,
  4.023011187931134e-26, -3.276957955589658e-28,  8.698188050154283e-01, -2.849158666447939e-03,  2.247432135450583e-06,  1.355121474251725e-08, -3.523781486057339e-11,
 -8.907127551391619e-14,  5.233159325826573e-16,  3.172442865323361e-19, -7.255155810180863e-21,  6.976718473605225e-24,  9.063236994787596e-26, -2.462799891368943e-28,
  9.427348937842652e-01, -2.922117081974593e-03,  1.411472087884115e-06,  1.571891612928117e-08, -2.552916037352681e-11, -1.376303098689827e-13,  4.354755020922882e-16,
  1.261275553677083e-18, -7.176692000325130e-21, -9.410096857201510e-24,  1.141341343294096e-25,  5.422515430156278e-30,  1.016815479123858e+00, -2.965682303779476e-03,
  4.822497882948101e-07,  1.719595860165426e-08, -1.238403151909759e-11, -1.746642917327670e-13,  2.513058526795165e-16,  2.084344539545037e-18, -4.802035248701279e-21,
 -2.640883407100260e-23,  8.931572652582845e-26,  3.372231972613711e-28,  1.091689647402794e+00, -2.977291308208294e-03, -5.111786402999371e-07,  1.780121318876488e-08,
  3.263196446105105e-12, -1.924662027346010e-13, -9.442286090788526e-18,  2.531034913183167e-18, -3.686460371996357e-22, -3.681045124940273e-23,  1.367042310093559e-26,
  5.688384660947608e-28,  1.166954032451290e+00, -2.954900956732785e-03, -1.533043887999252e-06,  1.739822583539399e-08,  1.999924647962411e-11, -1.851392589963032e-13,
 -3.041995298694429e-16,  2.394273245628857e-18,  5.019908544387411e-21, -3.420639202260851e-23, -8.706592034419224e-26,  5.184709976874966e-28,  1.242172141678525e+00,
 -2.897129747951393e-03, -2.541765451353113e-06,  1.591731322158516e-08,  3.602660844077606e-11, -1.502335829963197e-13, -5.725240411697199e-16,  1.600888950878511e-18,
  9.573395741967449e-21, -1.661469259227841e-23, -1.638302291600602e-25,  1.359643163600138e-28,  1.316874307491749e+00, -2.803407205134890e-03, -3.491495613648861e-06,
  1.337592936174134e-08,  4.934901930202689e-11, -9.010592307591353e-14, -7.480443796962555e-16,  2.770981195442060e-19,  1.138682566941577e-20,  1.092129431611382e-23,
 -1.671715933338530e-25, -4.067329173954121e-28,  1.390558454632904e+00, -2.674124357651344e-03, -4.334377592514348e-06,  9.893899237114408e-09,  5.804441124677289e-11,
 -1.254282628056781e-14, -7.761563908980203e-16, -1.242384112723927e-18,  9.281162466313506e-21,  3.687534443386460e-23, -8.006671076718451e-26, -7.684370772438724e-28,
  1.462691893554926e+00, -2.510776034004907e-03, -5.023532994283559e-06,  5.699521115541271e-09,  6.060031481804977e-11,  6.979931843989586e-14, -6.334275603435940e-16,
 -2.488797449321666e-18,  3.569729160978749e-21,  4.798247390918257e-23,  6.009918200480491e-26, -6.579388771837747e-28,  1.532714359982424e+00, -2.316082745018546e-03,
 -5.516705525769367e-06,  1.122484076463098e-09,  5.626046743434349e-11,  1.414059746378931e-13, -3.420916223428618e-16, -3.015570566787678e-18, -3.717577274134348e-21,
  3.674315023237802e-23,  1.728623090145121e-25, -9.170110538990277e-29,  1.600042515640951e+00, -2.094077142965821e-03, -5.780368442533892e-06, -3.429628317249379e-09,
  4.530646588857856e-11,  1.872635347067944e-13,  2.786449525603946e-17, -2.590535397535129e-18, -9.496545670182463e-21,  7.454363175129121e-24,  1.835879882563811e-25,
  5.426363700936862e-28,  1.664076098314198e+00, -1.850137919935897e-03, -5.793960121405639e-06, -7.512481337382127e-09,  2.918422634307494e-11,  1.969365209937352e-13,
  3.741852534828704e-16, -1.338161440260700e-18, -1.108516038806779e-20, -2.424103565047303e-23,  8.166681273630529e-26,  7.544807713038298e-28,  1.724205854423176e+00,
 -1.590953248861537e-03, -5.553764118494445e-06, -1.070174933416828e-08,  1.039329126504059e-11,  1.682070960187478e-13,  5.943938991216144e-16,  2.609689496476070e-19,
 -7.770124065471310e-21, -4.008825774282718e-23, -6.118818829620000e-26,  3.838345273575490e-28,  1.779823299054846e+00, -1.324397266848016e-03, -5.075828467592166e-06,
 -1.265921384468750e-08, -7.902925992238659e-12,  1.088446671606237e-13,  6.248018664330292e-16,  1.555607723244679e-18, -1.455371442040518e-21, -3.165563046789879e-23,
 -1.409848337625790e-25, -2.156476803468131e-28,  1.830332224773073e+00, -1.059307400827622e-03, -4.397265843666691e-06, -1.319749201799572e-08, -2.251497783774304e-11,
  3.532141048044956e-14,  4.698181193673067e-16,  2.034344531281844e-18,  4.298661621712920e-21, -7.053472934130936e-24, -1.077660110410630e-25, -5.015790171386938e-28,
  1.875161724887726e+00, -8.051580144694694e-04, -3.575336734168384e-06, -1.232941620464042e-08, -3.099016498088930e-11, -3.179913421847753e-14,  2.046462165571493e-16,
  1.599884968219595e-18,  6.483694439634120e-21,  1.497709336699972e-23, -8.922897952579120e-27, -2.913317831678238e-28,  1.913780319905296e+00, -5.716368309635554e-04,
 -2.683926300848956e-06, -1.028758406178660e-08, -3.229602769782665e-11, -7.467426632238836e-14, -5.561265255644897e-17,  6.255309252748763e-19,  4.627808073345599e-21,
  2.018256481267702e-23,  6.032301520499195e-26,  8.224452314491421e-29,  1.945710598484691e+00, -3.681439527952449e-04, -1.807387610664776e-06, -7.503198197344786e-09,
 -2.719058617501830e-11, -8.474496062640177e-14, -2.097178845120005e-16, -2.765900582725370e-19,  9.552018276755476e-22,  1.000351690450366e-23,  5.279530186362359e-26,
  2.087428682283151e-28,  1.970543646809809e+00, -2.032471365311845e-04, -1.032199202697838e-06, -4.541313281346107e-09, -1.810020135066479e-11, -6.612855709635053e-14,
 -2.200557296984979e-16, -6.482988628015109e-19, -1.555695150702093e-21, -2.077620665851762e-24,  6.566180743436898e-27,  7.324921811093054e-29,  1.987952595923600e+00,
 -8.413782000713580e-05, -4.373786883815893e-07, -2.000636548306497e-09, -8.469008772687728e-12, -3.386483036796303e-14, -1.290302916870187e-16, -4.695526948565405e-19,
 -1.627994184395058e-21, -5.334828713651098e-24, -1.624154100334757e-26, -4.423195882808934e-29,  1.997706937485390e+00, -1.612293339456999e-05, -8.490276969251512e-08,
 -3.966769911571420e-10, -1.733458804046065e-12, -7.251806677590343e-15, -2.939785960948796e-17, -1.162988857476917e-19, -4.509183230518605e-22, -1.718147279257014e-24,
 -6.444586541590431e-27, -2.381860541871336e-29,  5.034834574048367e-04, -2.542412064621752e-06,  9.626564198738147e-09, -3.239171366755963e-11,  1.021429351482766e-13,
 -3.090882792340576e-16,  9.088590733921683e-19, -2.616528288625732e-21,  7.410002361469588e-24, -2.071237734622525e-26,  5.726660795613131e-29, -1.569021643492738e-31,
  4.530089030369571e-03, -2.284273955841665e-05,  8.622790008344548e-08, -2.886183147563463e-10,  9.027955061097542e-13, -2.700595412503107e-15,  7.817764730387272e-18,
 -2.205045130179491e-20,  6.083541208198126e-23, -1.645701066753774e-25,  4.369732170004362e-28, -1.139444742795553e-30,  1.257655124266982e-02, -6.323545297727091e-05,
  2.372425526103411e-07, -7.856692620343875e-10,  2.417288759868109e-12, -7.059937452068210e-15,  1.976901099069708e-17, -5.330753715821280e-20,  1.385032589134210e-22,
 -3.459129305451655e-25,  8.250340616539233e-28, -1.856311274576666e-30,  2.462928655591465e-02, -1.233041643187254e-04,  4.583183276604694e-07, -1.493231717488355e-09,
  4.477441228429785e-12, -1.258426809704640e-14,  3.332948519148588e-17, -8.292902020597340e-20,  1.913727712257729e-22, -3.973612783286533e-25,  6.846713162020884e-28,
 -6.923391619741324e-31,  4.066770457990321e-02, -2.024230648744573e-04,  7.429874018607528e-07, -2.367067840345105e-09,  6.844456443288160e-12, -1.817794018984853e-14,
  4.406861626156826e-17, -9.485499925061327e-20,  1.670969899417495e-22, -1.674058911515922e-25, -3.569000963831125e-28,  3.022479821387014e-30,  6.066394744870388e-02,
 -2.997555541985516e-04,  1.082741282015374e-06, -3.350498033402042e-09,  9.224719300364931e-12, -2.257547733061280e-14,  4.733579214209855e-17, -7.462288266565220e-20,
  2.991419892205489e-23,  3.959032804469251e-25, -2.195929844191316e-27,  7.995503289249161e-30,  8.458253814170096e-02, -4.142525856514528e-04,  1.467134741570510e-06,
 -4.376385658521475e-09,  1.129020275286577e-11, -2.449316773973169e-14,  3.915804825666274e-17, -1.378116157074535e-20, -2.211884672437170e-22,  1.184345858570679e-24,
 -4.110573192483419e-27,  1.094741029243353e-29,  1.123799342272041e-01, -5.446508878704208e-04,  1.883922133957708e-06, -5.369624753584662e-09,  1.270286247586379e-11,
 -2.279857461650748e-14,  1.714684175783982e-17,  8.634476920044226e-20, -5.414195419160988e-22,  1.919515522943163e-24, -4.903669134057106e-27,  7.917717719750948e-30,
  1.440039827146602e-01, -6.894712747739586e-04,  2.319230287671856e-06, -6.250126734750600e-09,  1.314216829122692e-11, -1.668456252273054e-14, -1.871400308152512e-17,
  2.124214127249438e-19, -8.408622997358418e-22,  2.210239098212916e-24, -3.350909296024296e-27, -3.380326313559411e-30,  1.793932709906086e-01, -8.470173192042746e-04,
  2.757772931407217e-06, -6.936292135133473e-09,  1.233464871364264e-11, -5.831914000602271e-15, -6.553460887949772e-17,  3.391914246004932e-19, -9.996005244728104e-22,
  1.676115808057122e-24,  1.149719617502181e-27, -2.110431069570305e-29,  2.184763682224940e-01, -1.015374739107761e-03,  3.183112232449911e-06, -7.348937851116108e-09,
  1.008400735987272e-11,  9.457519189975705e-15, -1.173699469805304e-16,  4.323986043229875e-19, -8.969924631588753e-22,  1.130139692950222e-25,  7.955033949124931e-27,
 -3.811149892152303e-29,  2.611709511973945e-01, -1.192411932301727e-03,  3.577973487862990e-06, -7.415627738935557e-09,  6.300011819515814e-12,  2.817658059036918e-14,
 -1.655641180200826e-16,  4.546643512723941e-19, -4.509715867317787e-22, -2.346279694599579e-24,  1.488430600071701e-26, -4.336640332074461e-29,  3.073828083930721e-01,
 -1.375782198294497e-03,  3.924619186083880e-06, -7.075323249212262e-09,  1.023971000682671e-12,  4.859712885120192e-14, -1.996550287187467e-16,  3.738632753344027e-19,
  3.408188475490827e-22, -5.138689280558360e-24,  1.854185914052311e-26, -2.641784482001299e-29,  3.570047162545639e-01, -1.562928304881626e-03,  4.205288419039101e-06,
 -6.283229683597360e-09, -5.551766493702876e-12,  6.834092888402944e-14, -2.088414767489087e-16,  1.728754611077765e-19,  1.369693633599326e-21, -7.307943656296908e-24,
  1.538842604748299e-26,  1.602562542236542e-29,  4.099151822997552e-01, -1.751090194205202e-03,  4.402706788421916e-06, -5.015661473066052e-09, -1.307319676086512e-11,
  8.455096938695387e-14, -1.839254771785053e-16, -1.411003533683636e-19,  2.407681500391431e-21, -7.714077738873720e-24,  3.412363472240510e-27,  7.410244016477892e-29,
  4.659770509689185e-01, -1.937316777299545e-03,  4.500670277152167e-06, -3.274686146657479e-09, -2.102605104794948e-11,  9.416958096523047e-14, -1.195322152299167e-16,
 -5.300678510410259e-19,  3.134190322455769e-21, -5.410472690155669e-24, -1.610888948544527e-26,  1.232389624306535e-28,  5.250359702786614e-01, -2.118482935568256e-03,
  4.484703751670345e-06, -1.092232156460349e-09, -2.875231959502021e-11,  9.431821507994218e-14, -1.628732019549827e-17, -9.242571299632107e-19,  3.203644815844003e-21,
 -1.148744050582744e-25, -3.758256224575646e-26,  1.305141319047259e-28,  5.869187206060553e-01, -2.291313026872426e-03,  4.342790466841610e-06,  1.466736725592740e-09,
 -3.548469470158626e-11,  8.275777179102569e-14,  1.174860980207848e-16, -1.229053822595306e-18,  2.349564132160421e-21,  7.375063773441879e-24, -5.172364856304994e-26,
  6.974857212906666e-29,  6.514314116397878e-01, -2.452412373306746e-03,  4.066162758785857e-06,  4.302462158002277e-09, -4.040087234403829e-11,  5.838813512575191e-14,
  2.650715877040083e-16, -1.341193408203594e-18,  5.058899668214399e-22,  1.502657999070930e-23, -4.840962814486670e-26, -5.883529244389862e-29,  7.183575600813962e-01,
 -2.598308371467327e-03,  3.650135608724708e-06,  7.280604814677476e-09, -4.269812333043477e-11,  2.172238370689344e-14,  4.021954354425254e-16, -1.173603911382750e-18,
 -2.089497314601834e-21,  1.987860321202842e-23, -2.149051607426347e-26, -2.141695616446714e-28,  7.874560695114708e-01, -2.725502989840358e-03,  3.094953558689853e-06,
  1.023503955382485e-08, -4.168616821441730e-11, -2.475205513952906e-14,  4.998138973114610e-16, -6.854082754443511e-19, -4.855812048954283e-21,  1.891228716664950e-23,
  2.598876326722393e-26, -3.178743856434895e-28,  8.584591454519053e-01, -2.830538466684053e-03,  2.406607312701751e-06,  1.297384325602955e-08, -3.689305954716433e-11,
 -7.643107714511417e-14,  5.289910827224415e-16,  8.977562425781953e-20, -6.941463519796136e-21,  1.037302875169732e-23,  7.890378206830421e-26, -2.846297281282899e-28,
  9.310701935731079e-01, -2.910077946679955e-03,  1.597559317159885e-06,  1.528900811053731e-08, -2.817452720907380e-11, -1.267813416818563e-13,  4.675314096331079e-16,
  1.027081323964022e-18, -7.433441813878935e-21, -4.864078836665275e-24,  1.125813408943214e-25, -7.490550128349774e-29,  1.004961767695512e+00, -2.961002531180265e-03,
  6.872982610140856e-07,  1.697021503305955e-08, -1.581237003187437e-11, -1.679508287815464e-13,  3.073783405032989e-16,  1.916185052395776e-18, -5.685085439507924e-21,
 -2.256323158893906e-23,  1.023603259592778e-25,  2.543521484512611e-28,  1.079773657071328e+00, -2.980525684017347e-03, -2.973778170085363e-07,  1.782264148255905e-08,
 -5.826654377106771e-13, -1.918449423780289e-13,  6.106335410350192e-17,  2.498189545625675e-18, -1.678005257145357e-21, -3.576970320006412e-23,  3.816253626152612e-26,
  5.407961880169544e-28,  1.155111229492899e+00, -2.966325037076052e-03, -1.322468664128499e-06,  1.768821792669914e-08,  1.622897252397316e-11, -1.916185806573788e-13,
 -2.351006124158232e-16,  2.534581164483686e-18,  3.731477879831479e-21, -3.721231835824169e-23, -6.276348367294440e-26,  5.825238899391793e-28,  1.230544177682438e+00,
 -2.916690274417388e-03, -2.347400667664848e-06,  1.646897086775891e-08,  3.288833822584526e-11, -1.634022414536833e-13, -5.235091256834539e-16,  1.896416869287869e-18,
  8.859113514467064e-21, -2.300845117209307e-23, -1.548776997270094e-25,  2.704085077853065e-28,  1.305605850073511e+00, -2.830683845783782e-03, -3.326309576103290e-06,
  1.415012465595877e-08,  4.736821281579336e-11, -1.079243921439843e-13, -7.351346225630965e-16,  6.464436219720779e-19,  1.165561973196884e-20,  3.910231020277971e-24,
 -1.825046791920961e-25, -2.864065151465228e-28,  1.379793381352727e+00, -2.708308708845125e-03, -4.210090125768795e-06,  1.081957964870166e-08,  5.760463802595834e-11,
 -3.155325715607972e-14, -8.065904058928692e-16, -9.248309664330727e-19,  1.054288095920078e-20,  3.299722112593159e-23, -1.137589620514981e-25, -7.573363547910077e-28,
  1.452568869458099e+00, -2.550674137048049e-03, -4.949277782857010e-06,  6.679444613514350e-09,  6.183870751963655e-11,  5.377534042265813e-14, -7.012520002380182e-16,
 -2.346523107047552e-18,  5.333053789135261e-21,  4.977042591083171e-23,  2.840960098714287e-26, -7.798357702920750e-28,  1.523361868906299e+00, -2.360146995246461e-03,
 -5.497742908017987e-06,  2.044801489915729e-09,  5.899958150910529e-11,  1.321703709196814e-13, -4.279847642030054e-16, -3.112045222342828e-18, -2.271769446850261e-21,
  4.352899519615109e-23,  1.652083084910672e-25, -2.593420363698654e-28,  1.591573478295359e+00, -2.140472104554893e-03, -5.817050918847336e-06, -2.674751638199406e-09,
  4.905237249628620e-11,  1.870278229599724e-13, -4.887423559965509e-17, -2.888668267990814e-18, -9.090424982719490e-21,  1.525579286886268e-23,  2.059322405837669e-25,
  4.668910560267008e-28,  1.656582283929246e+00, -1.896841959454373e-03, -5.881176689629269e-06, -7.013549405508954e-09,  3.320951577974482e-11,  2.054264787153357e-13,
  3.316242670720705e-16, -1.706152544189409e-18, -1.189081579095903e-20, -2.028636078766089e-23,  1.166307035090535e-25,  8.317513850933586e-28,  1.717752372203351e+00,
 -1.635893958081596e-03, -5.681073821605949e-06, -1.050776648722559e-08,  1.390052867326849e-11,  1.825307888758327e-13,  5.979998922781720e-16, -1.120269343907665e-20,
 -9.252904607228601e-21, -4.215580931477570e-23, -4.111465441531391e-26,  5.313437426255456e-28,  1.774443531821879e+00, -1.365613515638861e-03, -5.228423197773924e-06,
 -1.276741607134976e-08, -5.572583892267959e-12,  1.243562411822506e-13,  6.675276942614967e-16,  1.489696372301546e-18, -2.698594118258894e-21, -3.746509208379585e-23,
 -1.489504872702828e-25, -1.417382904437833e-28,  1.826023627337036e+00, -1.095125073501672e-03, -4.557771835528999e-06, -1.355144795158680e-08, -2.169110016015998e-11,
  4.729586361137689e-14,  5.286612072842283e-16,  2.166962867326315e-18,  3.961687841763785e-21, -1.182061533539817e-23, -1.309522375965309e-25, -5.510818352774795e-28,
  1.871882938444799e+00, -8.343609961690830e-04, -3.726284864819728e-06, -1.283006418808413e-08, -3.157328076383541e-11, -2.632612354477805e-14,  2.524281033948313e-16,
  1.815894593797276e-18,  7.013135142966419e-21,  1.433934703320364e-23, -2.359503161790811e-26, -3.779261548241404e-28,  1.911450035352362e+00, -5.936109438700634e-04,
 -2.810527231157845e-06, -1.081633464157867e-08, -3.380135196220030e-11, -7.578136926789010e-14, -3.591194123059699e-17,  7.857183395988799e-19,  5.398627410903845e-21,
  2.266137130831617e-23,  6.343685717076695e-26,  5.741999858727492e-29,  1.944208523615409e+00, -3.829707336353504e-04, -1.900093109863546e-06, -7.952082808554299e-09,
 -2.893642566868130e-11, -8.986732232077091e-14, -2.169773241337024e-16, -2.398354886576374e-19,  1.355637001637563e-21,  1.230811496293376e-23,  6.266441999609528e-26,
  2.402904196153617e-28,  1.969713790851246e+00, -2.117277388558134e-04, -1.088477172875818e-06, -4.841790298642157e-09, -1.947708556851724e-11, -7.163341555555719e-14,
 -2.389158936662571e-16, -6.992204569289304e-19, -1.624929150338844e-21, -1.744298318907643e-24,  1.026276356859141e-26,  9.562234058352142e-29,  1.987608891214810e+00,
 -8.773523622921132e-05, -4.622222600894519e-07, -2.141731895398584e-09, -9.178368789196320e-12, -3.712539593721651e-14, -1.429368970201649e-16, -5.248506443790012e-19,
 -1.832223578212279e-21, -6.024802882640195e-24, -1.829188767791192e-26, -4.899725771802431e-29,  1.997641056479544e+00, -1.682167882590366e-05, -8.983421909797286e-08,
 -4.256120931493647e-10, -1.885822865711110e-12, -7.998121237842200e-15, -3.286590538651128e-17, -1.317698028949558e-19, -5.176759065281481e-22, -1.998177589387576e-24,
 -7.590277648498329e-27, -2.840009638516981e-29,  4.934654110163158e-04, -2.466927032645600e-06,  9.247469130338481e-09, -3.080572011358804e-11,  9.617349706600495e-14,
 -2.881286939073917e-16,  8.388069424594799e-19, -2.390909595846395e-21,  6.703978260061200e-24, -1.855397007488882e-26,  5.079283582502923e-29, -1.378001419235892e-31,
  4.440076124888978e-03, -2.216652851617901e-05,  8.284939874002216e-08, -2.745956935909119e-10,  8.506109650651087e-13, -2.520163385796502e-15,  7.226739200032831e-18,
 -2.019523271783008e-20,  5.521379155774540e-23, -1.480540194645901e-25,  3.897866944740478e-28, -1.008210654589051e-30,  1.232734651503730e-02, -6.137457774452845e-05,
  2.280420037671978e-07, -7.480969517009367e-10,  2.280716212308206e-12, -6.602902975620760e-15,  1.833662182976108e-17, -4.906846602475295e-20,  1.266252182294688e-22,
 -3.144921356439171e-25,  7.472868651539548e-28, -1.680385828667203e-30,  2.414329120074132e-02, -1.197080938054567e-04,  4.408212144477949e-07, -1.423563456282074e-09,
  4.233570380884828e-12, -1.181154562964483e-14,  3.109109444204135e-17, -7.702874658209926e-20,  1.775532316440266e-22, -3.706003632444513e-25,  6.530094812638641e-28,
 -7.425493485308306e-31,  3.986972281398685e-02, -1.965909504853144e-04,  7.152278418591200e-07, -2.260408434428429e-09,  6.491262074995296e-12, -1.715156611745320e-14,
  4.148661154475359e-17, -8.960682694082161e-20,  1.608438814023068e-22, -1.791940930780830e-25, -2.365884648182724e-28,  2.462260917253195e-30,  5.948199795212322e-02,
 -2.912519726415974e-04,  1.043406176862683e-06, -3.206453583397055e-09,  8.784401711936065e-12, -2.146437085812155e-14,  4.526177864365677e-17, -7.345387175623703e-20,
  4.266750813591403e-23,  3.147829109187786e-25, -1.867750310105276e-27,  6.943350732578467e-30,  8.294867363642081e-02, -4.027225401939250e-04,  1.415685972653378e-06,
 -4.199610404311774e-09,  1.080970210352799e-11, -2.355876658482746e-14,  3.867927210270847e-17, -2.020781854486356e-20, -1.813982454722003e-22,  1.029260418456069e-24,
 -3.650951355242337e-27,  9.951827336575588e-30,  1.102310701707832e-01, -5.298338321129624e-04,  1.820691139244355e-06, -5.170003578843658e-09,  1.225119220352011e-11,
 -2.235993383070680e-14,  1.933206181779967e-17,  7.008781192010219e-20, -4.757633754113386e-22,  1.730365420321651e-24, -4.553463295996649e-27,  7.969715580118671e-30,
  1.412827353035043e-01, -6.712138893953356e-04,  2.245479329547449e-06, -6.042544006673483e-09,  1.280445204636120e-11, -1.706529297006102e-14, -1.313113395105305e-17,
  1.867607952886398e-19, -7.637363937235170e-22,  2.073858044345774e-24, -3.453406782371680e-27, -1.355791105555018e-30,  1.760488036466295e-01, -8.252847321550018e-04,
  2.675717434848762e-06, -6.739953154296122e-09,  1.220303297072457e-11, -7.294334822475250e-15, -5.647594575676244e-17,  3.081767850135421e-19, -9.386449897475046e-22,
  1.704771997579570e-24,  3.127215430361903e-28, -1.703524073390459e-29,  2.144652444324892e-01, -9.902598340137422e-04,  3.095898800242299e-06, -7.186229522549573e-09,
  1.024595289712822e-11,  6.782688744033656e-15, -1.056636077913668e-16,  4.038181582469339e-19, -8.875877324384202e-22,  3.990726562315118e-25,  6.381980263358701e-27,
 -3.343345522553514e-29,  2.564579899302148e-01, -1.164142339479967e-03,  3.489608665084794e-06, -7.310530894432435e-09,  6.824830477464617e-12,  2.435410423648778e-14,
 -1.530474517174715e-16,  4.389930165140397e-19, -5.251748978488813e-22, -1.788412241376634e-24,  1.302633704574594e-26, -4.099855525310567e-29,  3.019419362707890e-01,
 -1.344724509607765e-03,  3.839844848845228e-06, -7.051420943531196e-09,  1.948849955041756e-12,  4.393209275022515e-14, -1.890609737039146e-16,  3.819503969904751e-19,
  1.688861325104991e-22, -4.421328428779722e-24,  1.730257124107903e-26, -2.966414716168296e-29,  3.508198081271445e-01, -1.529589000517183e-03,  4.129400920823834e-06,
 -6.361393996350901e-09, -4.234653208053875e-12,  6.339153359556245e-14, -2.034260376816990e-16,  2.126162635302231e-19,  1.117827589444328e-21, -6.681534421521001e-24,
  1.585573520171994e-26,  5.547497874494080e-30,  4.029808787886395e-01, -1.716112720604840e-03,  4.341318847294269e-06, -5.211545494877192e-09, -1.142659559346302e-11,
  8.009779888574489e-14, -1.868391709690216e-16, -6.846541232937166e-20,  2.133175016683864e-21, -7.517008545431698e-24,  6.328671174262941e-27,  5.867035881084512e-29,
  4.582995378214146e-01, -1.901474177002399e-03,  4.459417176208635e-06, -3.596196545173410e-09, -1.917249156151699e-11,  9.113385407222769e-14, -1.330001055987558e-16,
 -4.330041763560768e-19,  2.929086779741999e-21, -5.950231032477241e-24, -1.097613384945304e-26,  1.099170675827217e-28,  5.166336999346681e-01, -2.082665410146471e-03,
  4.468898900795643e-06, -1.537208184893550e-09, -2.687190064882169e-11,  9.362833946314747e-14, -4.073391213419589e-17, -8.220855679947426e-19,  3.173833578182012e-21,
 -1.503412446149657e-24, -3.185361018560859e-26,  1.292543536809651e-28,  5.778230511589337e-01, -2.256509824882126e-03,  4.357039861652419e-06,  9.123645109894349e-10,
 -3.380408519811559e-11,  8.517320328634769e-14,  8.416229923830539e-17, -1.150012678274785e-18,  2.578619158574628e-21,  5.373361348370565e-24, -4.822667945949519e-26,
  8.826094307406551e-29,  6.416871323436520e-01, -2.419687451157736e-03,  4.113953441974233e-06,  3.665723226487314e-09, -3.917252276098920e-11,  6.430152791348509e-14,
  2.278234443692024e-16, -1.316727728540348e-18,  1.011470604994776e-21,  1.304962672820345e-23, -5.016830996384958e-26, -2.181436721896191e-29,  7.080232657429086e-01,
 -2.568769395086539e-03,  3.733419851471222e-06,  6.601423585394387e-09, -4.216984675103780e-11,  3.097384248804429e-14,  3.685047280308431e-16, -1.229201376331533e-18,
 -1.391503262375876e-21,  1.884245814362086e-23, -3.001860150713978e-26, -1.732654391255258e-28,  7.766043386202558e-01, -2.700263451532360e-03,  3.213757917473093e-06,
  9.564745458029172e-09, -4.206289653969766e-11, -1.300374180162101e-14,  4.785506884956533e-16, -8.297272139138880e-19, -4.159583048837892e-21,  1.967723406715384e-23,
  1.240166234169352e-26, -2.982605129585669e-28,  8.471764689998055e-01, -2.810673010309547e-03,  2.558703489263217e-06,  1.237201554301152e-08, -3.829464779962079e-11,
 -6.372986067183706e-14,  5.284553618002582e-16, -1.257922186549092e-19, -6.514319296730786e-21,  1.327040458690830e-23,  6.578378304598098e-26, -3.095167200676588e-28,
  9.194565936320371e-01, -2.896571451924910e-03,  1.778240984589820e-06,  1.481854961393696e-08, -3.059575657412993e-11, -1.152424987609760e-13,  4.929393329847394e-16,
  7.872708323705020e-19, -7.528485265214196e-21, -4.486750152869814e-25,  1.076627903992992e-25, -1.470932036628714e-28,  9.931300376741752e-01, -2.954694128327332e-03,
  8.893133536399210e-07,  1.669076366420285e-08, -1.909337922134180e-11, -1.599511894782818e-13,  3.583682446102216e-16,  1.722076466126732e-18, -6.421200336014013e-21,
 -1.827087878349642e-23,  1.116088728324551e-25,  1.653907489499895e-28,  1.067848150203534e+00, -2.982049669216657e-03, -8.368835014312160e-08,  1.778272692986367e-08,
 -4.399279552033012e-12, -1.895472760306225e-13,  1.300696957857976e-16,  2.424230436651462e-18, -2.932618666971322e-21, -3.378029639021894e-23,  6.095023404286884e-26,
  4.917475096940394e-28,  1.143226119996091e+00, -2.976051630779362e-03, -1.108779462495045e-06,  1.791694029893408e-08,  1.234598961599988e-11, -1.963971369564447e-13,
 -1.626651906735843e-16,  2.632120615356938e-18,  2.352949644493072e-21, -3.919654320424684e-23, -3.615334997706934e-26,  6.229133488258238e-28,  1.218841122112060e+00,
 -2.934670276243695e-03, -2.146725742869192e-06,  1.696837588485060e-08,  2.949911443769725e-11, -1.752980373292545e-13, -4.665734705622638e-16,  2.165485554764899e-18,
  7.922514543221214e-21, -2.892731194696654e-23, -1.401351562753490e-25,  3.980147753511841e-28,  1.294230987111941e+00, -2.856602402494736e-03, -3.152035048465645e-06,
  1.488979645629855e-08,  4.503497698451431e-11, -1.253081921770470e-13, -7.118014975091137e-16,  1.020244539315384e-18,  1.166231101239985e-20, -3.601818217256526e-24,
 -1.920704732183942e-25, -1.454537982538715e-28,  1.368893629411677e+00, -2.741454476401857e-03, -4.074749379297053e-06,  1.173514543730543e-08,  5.677809523238719e-11,
 -5.118298242646713e-14, -8.275905171744712e-16, -5.693951599904167e-19,  1.164094025742579e-20,  2.779152960231696e-23, -1.461847401351866e-25, -7.105161951805854e-28,
  1.442287515949384e+00, -2.589930850152924e-03, -4.863155462092881e-06,  7.676531585000796e-09,  6.274069864622809e-11,  3.617780668254618e-14, -7.642949161641459e-16,
 -2.147047339874969e-18,  7.136683622740792e-21,  5.018892275973111e-23, -8.224407093700748e-27, -8.812517721614590e-28,  1.513833495359659e+00, -2.404014543027464e-03,
 -5.467455986941896e-06,  3.009354205799560e-09,  6.153317831919505e-11,  1.208463676022941e-13, -5.158952559246567e-16, -3.158419213452202e-18, -5.890072972771322e-22,
  4.985602316313635e-23,  1.498060599382552e-25, -4.427921682385912e-28,  1.582918332991538e+00, -2.187123274009666e-03, -5.844315755376052e-06, -1.860081043032379e-09,
  5.277448012100873e-11,  1.848519430608653e-13, -1.337353346086325e-16, -3.169146338057345e-18, -8.388269411324422e-21,  2.387317413125917e-23,  2.241040194875044e-25,
  3.525181172292653e-28,  1.648900297402206e+00, -1.944218675380621e-03, -5.962014232984498e-06, -6.448913502847212e-09,  3.739354066808004e-11,  2.127685558591230e-13,
  2.784219600515978e-16, -2.097370507980176e-18, -1.252816367035711e-20, -1.487120405647058e-23,  1.545247003322257e-25,  8.861882750572613e-28,  1.711117106309599e+00,
 -1.681842857992014e-03, -5.805709574207702e-06, -1.025537403704071e-08,  1.769446011086502e-11,  1.968441512471679e-13,  5.933107839249928e-16, -3.318462789691615e-19,
 -1.079405734462885e-20, -4.328599668612226e-23, -1.421314980991709e-26,  6.934860476545931e-28,  1.768896450781084e+00, -1.408055058188876e-03, -5.382082225635906e-06,
 -1.283579596893979e-08, -2.921929660987722e-12,  1.408663980870899e-13,  7.078192006343715e-16,  1.380601027129767e-18, -4.155830185961149e-21, -4.351942429696310e-23,
 -1.530044668550550e-25, -3.709465514465697e-29,  1.821569164554783e+00, -1.132243541194846e-03, -4.722438051252745e-06, -1.389022795993902e-08, -2.061331729438769e-11,
  6.072572703945593e-14,  5.910395444681901e-16,  2.285869061225620e-18,  3.435901335562634e-21, -1.755612042069995e-23, -1.561085670949510e-25, -5.901855733399284e-28,
  1.868484886643311e+00, -8.647957438904731e-04, -3.883292930668744e-06, -1.333910194422474e-08, -3.203496898182599e-11, -1.963187934799645e-14,  3.064911457436668e-16,
  2.048358006460791e-18,  7.508096415279322e-21,  1.303429014567903e-23, -4.239371986578112e-26, -4.789662049803576e-28,  1.909029787967829e+00, -6.166236552031863e-04,
 -2.943618322735927e-06, -1.136932028014986e-08, -3.532371205179147e-11, -7.635896162990923e-14, -1.136708195425823e-17,  9.720214576649200e-19,  6.260630299809782e-21,
  2.523930252905727e-23,  6.518467343988232e-26,  1.960020429043461e-29,  1.942645623538805e+00, -3.985611876443718e-04, -1.998356235389843e-06, -8.429729518879529e-09,
 -3.078636348359715e-11, -9.515003360490799e-14, -2.230152092186826e-16, -1.888605951245364e-19,  1.846484829642550e-21,  1.503598207428553e-23,  7.397613494555248e-26,
  2.742183172602960e-28,  1.968849088659649e+00, -2.206733708807963e-04, -1.148496762353265e-06, -5.165203323556394e-09, -2.096871012800170e-11, -7.760826579844442e-14,
 -2.592308600900024e-16, -7.521349885207207e-19, -1.679250410942548e-21, -1.241832155259995e-24,  1.506484222888834e-26,  1.236927840309580e-28,  1.987250388341659e+00,
 -9.153837162407968e-05, -4.888292867098280e-07, -2.294717367481638e-09, -9.956407034246251e-12, -4.073906216641754e-14, -1.584871890899752e-16, -5.870976014125510e-19,
 -2.062819267023018e-21, -6.801031267853991e-24, -2.055516496697433e-26, -5.388685218969783e-29,  1.997572299329673e+00, -1.756130734493009e-05, -9.512802430704327e-08,
 -4.571091045381510e-10, -2.053981925885385e-12, -8.833118161525105e-15, -3.679862518454752e-17, -1.495475149140813e-19, -5.953904652744172e-22, -2.328333923605208e-24,
 -8.957821993993731e-27, -3.393429813100719e-29,  4.837433575191192e-04, -2.394400225937644e-06,  8.886846461716888e-09, -2.931197328039816e-11,  9.060693698615301e-14,
 -2.687770347751843e-16,  7.747671704069356e-19, -2.186688811065089e-21,  6.071191324125201e-24, -1.663846056056933e-26,  4.510366875305035e-29, -1.211774956819091e-31,
  4.352715053591570e-03, -2.151668632373225e-05,  7.963427577068221e-08, -2.613799093523393e-10,  8.018973232910123e-13, -2.353312409512526e-15,  6.685228155922230e-18,
 -1.851074600343967e-20,  5.015412300440018e-23, -1.333147605956524e-25,  3.480156644181851e-28, -8.929268903867789e-31,  1.208544088350684e-02, -5.958553989661360e-05,
  2.192795073842681e-07, -7.126385048512817e-10,  2.152949977473409e-12, -6.178863438038010e-15,  1.701777115474756e-17, -4.519197917107444e-20,  1.158241699458904e-22,
 -2.860312015713138e-25,  6.769247538903645e-28, -1.520423854613031e-30,  2.367140537647609e-02, -1.162487212983722e-04,  4.241372094614358e-07, -1.357676356620391e-09,
  4.004629896214374e-12, -1.109061113841010e-14,  2.901186326487857e-17, -7.155553224926189e-20,  1.646738223591717e-22, -3.451429089524408e-25,  6.196658103238532e-28,
 -7.697379148536357e-31,  3.909463332518485e-02, -1.909758874551085e-04,  6.887149547051569e-07, -2.159239235935912e-09,  6.157987291468216e-12, -1.618541974368447e-14,
  3.904869681315260e-17, -8.456466185105488e-20,  1.542473336764860e-22, -1.866353252410753e-25, -1.388974423380940e-28,  1.991892779855642e-30,  5.833344420058876e-02,
 -2.830562758872793e-04,  1.005758059223534e-06, -3.069279130359957e-09,  8.365811368240143e-12, -2.040260441596915e-14,  4.322578945946643e-17, -7.192103502308180e-20,
  5.272596027023782e-23,  2.459014262453867e-25, -1.583078135722832e-27,  6.015801389313794e-30,  8.136011938494224e-02, -3.915957289557687e-04,  1.366312993245758e-06,
 -4.030374339288815e-09,  1.034776071751698e-11, -2.263787656692894e-14,  3.803756105573625e-17, -2.544705422241592e-20, -1.468706038722266e-22,  8.916976253652371e-25,
 -3.234079168271495e-27,  9.005832206015823e-30,  1.081404776401459e-01, -5.155131646666414e-04,  1.759812536602269e-06, -4.977536246982000e-09,  1.180878352956270e-11,
 -2.187407888359274e-14,  2.109049664177210e-17,  5.582560641214646e-20, -4.166643897756069e-22,  1.555217635619767e-24, -4.204745684771006e-27,  7.857840789076476e-30,
  1.386333530644323e-01, -6.535366401021837e-04,  2.174186715044871e-06, -5.840418614654364e-09,  1.246040430484820e-11, -1.732038219914666e-14, -8.232952468969978e-18,
  1.634890263024202e-19, -6.915737487508981e-22,  1.935026483694790e-24, -3.476576013414620e-27,  2.373076900045069e-31,  1.727899686312890e-01, -8.041992027541828e-04,
  2.596004443217902e-06, -6.545942491464086e-09,  1.204427369168400e-11, -8.549547502401543e-15, -4.825827346453499e-17,  2.791231071468694e-19, -8.772188296825884e-22,
  1.703364109585191e-24, -3.574883826434363e-28, -1.351585237046889e-29,  2.105531972707282e-01, -9.658347862963412e-04,  3.010651698066839e-06, -7.021343044548333e-09,
  1.035714674100373e-11,  4.379250507419288e-15, -9.475184389549661e-17,  3.756916872587726e-19, -8.689686072223831e-22,  6.262453311094196e-25,  5.008634275686764e-27,
 -2.904319736822192e-29,  2.518567013785207e-01, -1.136574483546104e-03,  3.402552916649048e-06, -7.197632379671716e-09,  7.276166755845154e-12,  2.082651203551661e-14,
 -1.409999077315052e-16,  4.212543765166302e-19, -5.806062880118656e-22, -1.302637500249676e-24,  1.128284013943841e-26, -3.819489412197696e-29,  2.966239406763504e-01,
 -1.314343623741958e-03,  3.755443093663926e-06, -7.013453099602471e-09,  2.782985989091371e-12,  3.952343304758283e-14, -1.783136924834289e-16,  3.849390507249847e-19,
  2.185559977972361e-23, -3.755970996122902e-24,  1.595172334728228e-26, -3.153230824127475e-29,  3.447670375726367e-01, -1.496860197246050e-03,  4.052698650999751e-06,
 -6.419268975832683e-09, -3.015142608709710e-12,  5.858457195088365e-14, -1.970072813377435e-16,  2.446609051050079e-19,  8.887429441112746e-22, -6.045072021647574e-24,
  1.590521061593743e-26, -2.991667074551407e-30,  3.961854887010253e-01, -1.681635311881172e-03,  4.277735422063575e-06, -5.381799531028852e-09, -9.869597485881433e-12,
  7.559811978608601e-14, -1.878408458407479e-16, -4.479957711730913e-21,  1.867702709032665e-21, -7.216470605879607e-24,  8.595973861937400e-27,  4.463340252782560e-29,
  4.507647112962390e-01, -1.865976534567622e-03,  4.414481834217715e-06, -3.888552359851631e-09, -1.738266267031683e-11,  8.780675298415872e-14, -1.438447448401807e-16,
 -3.427762516496410e-19,  2.708104157131072e-21, -6.296623862743575e-24, -6.444963998635467e-27,  9.599601692897805e-29,  5.083744137170132e-01, -2.046995172157998e-03,
  4.447934301870025e-06, -1.952238798484302e-09, -2.501091541928817e-11,  9.238592287621025e-14, -6.234025617092354e-17, -7.216237101447685e-19,  3.098136532577922e-21,
 -2.664979558079994e-24, -2.625924592172331e-26,  1.245300805204046e-28,  5.688667810276457e-01, -2.221618777080927e-03,  4.364799583915432e-06,  3.852258297774489e-10,
 -3.208298150946605e-11,  8.681618411652534e-14,  5.314363714585723e-17, -1.064766263496829e-18,  2.738311894724033e-21,  3.526172909182443e-24, -4.403819452233828e-26,
  1.012502695176477e-28,  6.320744694780251e-01, -2.386610424226767e-03,  4.154224925761217e-06,  3.049535724526259e-09, -3.783478022070999e-11,  6.933094773981535e-14,
  1.914760621943404e-16, -1.277232662304090e-18,  1.444995335861346e-21,  1.103358741159112e-23, -5.039766891443250e-26,  1.057950527053896e-29,  6.978084084610904e-01,
 -2.538596587997211e-03,  3.808610596333310e-06,  5.932130597761189e-09, -4.146473997128300e-11,  3.940053075692563e-14,  3.335639364064448e-16, -1.263122151271772e-18,
 -7.365145706648115e-22,  1.750141654178038e-23, -3.673280664474161e-26, -1.320089041401418e-28,  7.658554156883071e-01, -2.674105737270141e-03,  3.324490241614215e-06,
  8.890274383605762e-09, -4.221007597809864e-11, -1.811697334920060e-15,  4.535618625708186e-16, -9.514292694249419e-19, -3.445368048314359e-21,  1.991841523869302e-23,
 -1.423019551073451e-28, -2.707919463647485e-28,  8.359756416603478e-01, -2.789620034193539e-03,  2.703451555798382e-06,  1.174979189079059e-08, -3.944282082539393e-11,
 -5.111229503399714e-14,  5.220900491142439e-16, -3.261257507486612e-19, -5.992544063840481e-21,  1.562500242030755e-23,  5.186096808041677e-26, -3.212207931020542e-28,
  9.078998739154488e-01, -2.881642726669706e-03,  1.953052428752142e-06,  1.431122850698251e-08, -3.278065622770068e-11, -1.031746403161459e-13,  5.116135734264855e-16,
  5.469182140711110e-19, -7.468854183135890e-21,  3.709440428648497e-24,  9.979462929614184e-26, -2.086237606790429e-28,  9.813267510240844e-01, -2.946783898251522e-03,
  1.087665542940186e-06,  1.636016068748782e-08, -2.220261142797307e-11, -1.507955296100619e-13,  4.036170234549410e-16,  1.506948285180391e-18, -6.997083023512592e-21,
 -1.368769845309567e-23,  1.168889596383008e-25,  7.467708665015541e-29,  1.055919961932662e+00, -2.981867088625361e-03,  1.291575529592159e-07,  1.768220337742180e-08,
 -8.153569699510220e-12, -1.856227720711455e-13,  1.964551103934741e-16,  2.311440957819657e-18, -4.099777673829611e-21, -3.092813037871145e-23,  8.116811732857176e-26,
  4.245377006612304e-28,  1.131305539034733e+00, -2.984058795012577e-03, -8.927212043142631e-07,  1.808286566954503e-08,  8.385015287719056e-12, -1.994095132170686e-13,
 -8.812550100892663e-17,  2.684612710758887e-18,  9.225091087429406e-22, -4.008828739161658e-23, -8.326871478482760e-27,  6.375935631304633e-28,  1.207069393963278e+00,
 -2.951021846686477e-03, -1.940390927234250e-06,  1.741172673620926e-08,  2.588623121408603e-11, -1.857405496931085e-13, -4.025546473998257e-16,  2.401298402871259e-18,
  6.784773189061138e-21, -3.414769320778801e-23, -1.200525010241368e-25,  5.120684701829698e-28,  1.282755293600496e+00, -2.881091919586358e-03, -2.969119814895303e-06,
  1.558938905752404e-08,  4.236051193911164e-11, -1.420066281200604e-13, -6.780400590633087e-16,  1.389871215518592e-18,  1.139322018124665e-20, -1.136768043959199e-23,
 -1.950889558821925e-25,  1.008282509253370e-29,  1.357863529078411e+00, -2.773473825646616e-03, -3.928514226380852e-06,  1.263432185390329e-08,  5.555474378858914e-11,
 -7.119349535439608e-14, -8.381764267060731e-16, -1.820655840116013e-19,  1.252884316796432e-20,  2.134084164593064e-23, -1.757402637436611e-25, -6.268642217463740e-28,
  1.431850589634430e+00, -2.628450506447914e-03, -4.764993381716896e-06,  8.685154617575518e-09,  6.327609493704653e-11,  1.714079234539627e-14, -8.209442841653265e-16,
 -1.889905443008032e-18,  8.927998682160797e-21,  4.906075701904197e-23, -4.871180822326438e-26, -9.536091170120103e-28,  1.504130210467907e+00, -2.447592825730164e-03,
 -5.425359054094490e-06,  4.012517665476674e-09,  6.381912369251654e-11,  1.074032215070532e-13, -6.043170402210760e-16, -3.147435333036702e-18,  1.308464494154507e-21,
  5.540252163282937e-23,  1.261230090977909e-25, -6.342862285778830e-28,  1.574076210111485e+00, -2.233952449594165e-03, -5.861449024142530e-06, -9.863181462803218e-10,
  5.643208171544553e-11,  1.805479865559065e-13, -2.260876769257230e-16, -3.422062082444899e-18, -7.364124887027658e-21,  3.310494144672489e-23,  2.363570085588482e-25,
  1.977442423789723e-28,  1.641027555143884e+00, -1.992213840385037e-03, -6.035669868345067e-06, -5.816231608885375e-09,  4.171074015532660e-11,  2.187002144441480e-13,
  2.140114353481523e-16, -2.505567758382017e-18, -1.294278357959284e-20, -7.901149841695272e-24,  1.941414827423181e-25,  9.084784496844380e-28,  1.704296071311474e+00,
 -1.728775675435265e-03, -5.926942981559693e-06, -9.939997813666126e-09,  2.177277725780195e-11,  2.109316361447368e-13,  5.789486646478377e-16, -7.022359069488288e-19,
 -1.235477864939079e-20, -4.319426094775267e-23,  2.004863558505310e-26,  8.648063149097532e-28,  1.763177140880132e+00, -1.451728408787682e-03, -5.536296285639538e-06,
 -1.285907236957819e-08,  6.832215091809664e-14,  1.583014234669497e-13,  7.443702614793933e-16,  1.221365135381537e-18, -5.832740795285453e-21, -4.963381770074719e-23,
 -1.516987058206844e-25,  1.025232278011004e-28,  1.816963567936479e+00, -1.170695285949937e-03, -4.891057029720472e-06, -1.420953222766943e-08, -1.925170734092323e-11,
  7.569052398922172e-14,  6.564792593224178e-16,  2.384449119799962e-18,  2.685148963083347e-21, -2.432785058018382e-23, -1.826410195459245e-25, -6.124502714141165e-28,
  1.864962544871731e+00, -8.965111048857561e-04, -4.046449118973879e-06, -1.385438288993124e-08, -3.234926091268158e-11, -1.156027346828155e-14,  3.672767570227610e-16,
  2.295754388882025e-18,  7.941430172598084e-21,  1.088409369506463e-23, -6.595714557542013e-26, -5.944245142509482e-28,  1.906515317668119e+00, -6.407280533224888e-04,
 -3.083491661095418e-06, -1.194672225764953e-08, -3.685129421244161e-11, -7.628167637001428e-14,  1.879446970931567e-17,  1.187403523914320e-18,  7.216254573483702e-21,
  2.784924961863261e-23,  6.491641216758123e-26, -3.487578014499491e-29,  1.941018752413984e+00, -4.149611849611157e-04, -2.102532226158321e-06, -8.937827823044144e-09,
 -3.274327943593328e-11, -1.005586577262855e-13, -2.273904945654562e-16, -1.205170396958677e-19,  2.444045103491024e-21,  1.824671257404551e-23,  8.681913567779998e-26,
  3.097231108473954e-28,  1.967947618462154e+00, -2.301150984250702e-04, -1.212544534683398e-06, -5.513465315230175e-09, -2.258482823364697e-11, -8.408863284242082e-14,
 -2.810487711141875e-16, -8.064587769492304e-19, -1.711710112973999e-21, -5.206263157613807e-25,  2.125059147505299e-26,  1.587479851776920e-28,  1.986876235281428e+00,
 -9.556192378849256e-05, -5.173492830268857e-07, -2.460750523592574e-09, -1.081059627132567e-11, -4.474771067243797e-14, -1.758880307829358e-16, -6.571886215807093e-19,
 -2.323040603532517e-21, -7.672092478117003e-24, -2.303311364412864e-26, -5.871790854998481e-29,  1.997500496504780e+00, -1.834484520481473e-05, -1.008165051072531e-07,
 -4.914355631081966e-10, -2.239826597482600e-12, -9.768766059362399e-15, -4.126580196975442e-17, -1.700133157953173e-19, -6.860369076364241e-22, -2.718388124468931e-24,
 -1.059365249482407e-26, -4.063380898893551e-29,  4.743057527113656e-04, -2.324688185953545e-06,  8.543626872131778e-09, -2.790427674707137e-11,  8.541249215564912e-14,
 -2.508959379641691e-16,  7.161721534779912e-19, -2.001656404006043e-21,  5.503436815949114e-24, -1.493654210745934e-26,  4.009771522940444e-29, -1.066930548711678e-31,
  4.267902895118689e-03, -2.089194375840321e-05,  7.657317357993447e-08, -2.489175376430290e-10,  7.563944662921152e-13, -2.198909527514172e-15,  6.188693534297763e-18,
 -1.697999167638846e-20,  4.559617628950240e-23, -1.201491280697271e-25,  3.110040220661068e-28, -7.915634490953270e-31,  1.185055385004156e-02, -5.786493413318208e-05,
  2.109305211994293e-07, -6.791581550008323e-10,  2.033356603198245e-12, -5.785211946023394e-15,  1.580277347827459e-17, -4.164526205972211e-20,  1.059987103273363e-22,
 -2.602484139137023e-25,  6.132721239918009e-28, -1.375211206227963e-30,  2.321309501908872e-02, -1.129197194437461e-04,  4.082223385589560e-07, -1.295339615234421e-09,
  3.789621262005591e-12, -1.041778492979335e-14,  2.708024804231489e-17, -6.648005493192673e-20,  1.526866371526184e-22, -3.210375424729031e-25,  5.855347339635842e-28,
 -7.791106485422300e-31,  3.834158744510122e-02, -1.855681606032227e-04,  6.633847310428576e-07, -2.063250982031483e-09,  5.843461647279738e-12, -1.527611323065823e-14,
  3.674897232817878e-17, -7.973715732650352e-20,  1.474484661158387e-22, -1.905594328205948e-25, -6.017562849183926e-29,  1.597976409026516e-30,  5.721708113281524e-02,
 -2.751552919601910e-04,  9.697165425550529e-07, -2.938634879902764e-09,  7.967971370985989e-12, -1.938915252437265e-14,  4.123686831984001e-17, -7.010388367000215e-20,
  6.050011745305144e-23,  1.876244879063772e-25, -1.336705872351103e-27,  5.200453817002484e-30,  7.981529509713955e-02, -3.808559024757318e-04,  1.318927105191179e-06,
 -3.868382878519156e-09,  9.904071864873495e-12, -2.173402760822009e-14,  3.726389778125529e-17, -2.965750372682670e-20, -1.170049575325925e-22,  7.699936586610569e-25,
 -2.857592917835705e-27,  8.117053685686233e-30,  1.061062081802756e-01, -5.016704071919488e-04,  1.701201398439824e-06, -4.792067556118236e-09,  1.137648271229155e-11,
 -2.135060562997144e-14,  2.247513728325922e-17,  4.335636343332074e-20, -3.636211895267425e-22,  1.393881623437220e-24, -3.863756607094118e-27,  7.624748099675886e-30,
  1.360535543696562e-01, -6.364201236345405e-04,  2.105286428400192e-06, -5.643832630459260e-09,  1.211237889090301e-11, -1.746547806813637e-14, -3.954803524503291e-18,
  1.424464464407338e-19, -6.244098542041616e-22,  1.796558359327570e-24, -3.437883827089710e-27,  1.466594354743322e-30,  1.696142150071030e-01, -7.837421097967788e-04,
  2.518603544175188e-06, -6.354662367878049e-09,  1.186231765373695e-11, -9.617076190567720e-15, -4.082662803143785e-17,  2.520293751800586e-19, -8.162899733050505e-22,
  1.678093092317287e-24, -8.841066043337202e-28, -1.050054782438341e-29,  2.067374989155710e-01, -9.420837741627801e-04,  2.927392367329955e-06, -6.855048052682413e-09,
  1.042282723131610e-11,  2.228318623679664e-15, -8.461812378892982e-17,  3.482816496952148e-19, -8.431143839421968e-22,  8.022522525199643e-25,  3.821270255437644e-27,
 -2.498519630910080e-29,  2.473643001052455e-01, -1.109697536968276e-03,  3.316893000881472e-06, -7.078061361487439e-09,  7.659801400462574e-12,  1.758191595093304e-14,
 -1.294713444524456e-16,  4.020085253019871e-19, -6.197745492803376e-22, -8.840469875191891e-25,  9.669027244074382e-27, -3.512959311160365e-29,  2.914261213944364e-01,
 -1.284635909186099e-03,  3.671574165405475e-06, -6.962830431060146e-09,  3.531532299690778e-12,  3.537320237549894e-14, -1.675450728998016e-16,  3.835954051798089e-19,
 -1.022112792576732e-22, -3.145942768198380e-24,  1.454430096866063e-26, -3.227560366865559e-29,  3.388439510551269e-01, -1.464747465676388e-03,  3.975415809755824e-06,
 -6.458392239097051e-09, -1.890162254789995e-12,  5.394162025529280e-14, -1.897904617908922e-16,  2.697411196622049e-19,  6.825209104684609e-22, -5.413610251518882e-24,
  1.561861998511236e-26, -9.757764941143357e-30,  3.895269785630582e-01, -1.647674326094643e-03,  4.212255447821213e-06, -5.527862260294286e-09, -8.402693159790778e-12,
  7.109495024785516e-14, -1.871681151404847e-16,  5.119981489693811e-20,  1.614537415334596e-21, -6.837148054250106e-24,  1.027909996749171e-26,  3.213260979839405e-29,
  4.433711348368049e-01, -1.830851926259282e-03,  4.366207806641841e-06, -4.152816545396233e-09, -1.566177805152249e-11,  8.424888776232251e-14, -1.522636346452702e-16,
 -2.597855142338633e-19,  2.477765708001316e-21, -6.474068897658778e-24, -2.529025733865239e-27,  8.203445200230540e-29,  5.002574421873064e-01, -2.011512068309195e-03,
  4.422167081503517e-06, -2.337719658736466e-09, -2.317973776956894e-11,  9.065839839080518e-14, -8.117356156128349e-17, -6.242104900320987e-19,  2.984593143908776e-21,
 -3.607772158718351e-24, -2.093434711315742e-26,  1.171327335941534e-28,  5.600501598444489e-01, -2.186690483779509e-03,  4.366399823543275e-06, -1.141519426591896e-10,
 -3.033626661635583e-11,  8.774387703794212e-14,  2.457365658613812e-17, -9.754403004758374e-19,  2.834645375856582e-21,  1.856433397417743e-24, -3.939089276230275e-26,
  1.092079748022986e-28,  6.225947127569993e-01, -2.353240431220863e-03,  4.187233749787644e-06,  2.455509816733025e-09, -3.640507526369463e-11,  7.350280130421290e-14,
  1.564178532424965e-16, -1.225025113640327e-18,  1.806107660172632e-21,  9.035408500588164e-24, -4.931229528358295e-26,  3.789711026491530e-29,  6.877153948805536e-01,
 -2.507854176712233e-03,  3.875842928837956e-06,  5.275421745031194e-09, -4.059955010379195e-11,  4.697956471165323e-14,  2.979591912518839e-16, -1.276904024622128e-18,
 -1.342023191674099e-22,  1.592784959950638e-23, -4.165405348423074e-26, -9.200863532022157e-29,  7.552128440364302e-01, -2.647094562264533e-03,  3.427122061779012e-06,
  8.215205467783235e-09, -4.213967449676975e-11,  8.742310641457906e-15,  4.254859765216607e-16, -1.050231885803958e-18, -2.731193716382586e-21,  1.968386851963705e-23,
 -1.134245881702606e-26, -2.375190382196181e-28,  8.248612944897289e-01, -2.767439233468174e-03,  2.840631009475413e-06,  1.111120610802615e-08, -4.034061450066807e-11,
 -3.871284776844001e-14,  5.103611248696650e-16, -5.085144954069432e-19, -5.396117999854841e-21,  1.741609005013079e-23,  3.769789472811326e-26, -3.206275413690014e-28,
  8.964056267119517e-01, -2.865340437077029e-03,  2.121574306691940e-06,  1.377090193160309e-08, -3.472026032139877e-11, -9.073900693784433e-14,  5.236066962987674e-16,
  3.108030377859879e-19, -7.265816316034494e-21,  7.502237412893510e-24,  8.948743959891848e-26, -2.577313048082888e-28,  9.695582526283726e-01, -2.937303551025715e-03,
  1.281758238412575e-06,  1.598133182193352e-08, -2.511836875149825e-11, -1.406281107909088e-13,  4.426092674465947e-16,  1.276064744655575e-18, -7.405128182935745e-21,
 -8.972722542359404e-24,  1.182163156213055e-25, -1.361790296331399e-29,  1.043995900445734e+00, -2.979987580584656e-03,  3.404396290487913e-07,  1.752232452141655e-08,
 -1.181371446425071e-11, -1.801470355665834e-13,  2.591760462010206e-16,  2.163095258827065e-18, -5.150456370101513e-21, -2.733093300984968e-23,  9.809676168873150e-26,
  3.429160136023914e-28,  1.119356397432648e+00, -2.990330610092785e-03, -6.750537673936183e-07,  1.818503107681884e-08,  4.381775181916915e-12, -2.006204940145822e-13,
 -1.276015954309873e-17,  2.691032684715100e-18, -5.199140056287056e-22, -3.986179981313860e-23,  1.956662300245792e-26,  6.259890689056503e-28,  1.195235593176861e+00,
 -2.965702455786966e-03, -1.729089353864078e-06,  1.779568630331116e-08,  2.208037510625117e-11, -1.945716591272962e-13, -3.324698646484471e-16,  2.597861128447698e-18,
  5.474718848372342e-21, -3.846977704490326e-23, -9.536369780749790e-26,  6.064481377459899e-28,  1.271184620773384e+00, -2.904085286897259e-03, -2.778077087548663e-06,
  1.624356599121413e-08,  3.936101310645309e-11, -1.577718268316611e-13, -6.340917429677091e-16,  1.746404104182938e-18,  1.084405988045690e-20, -1.911471103657185e-23,
 -1.910761005588243e-25,  1.728536934243759e-28,  1.346707758938062e+00, -2.804280496438773e-03, -3.771619639649381e-06,  1.351071290362027e-08,  5.392953558489920e-11,
 -9.132493925975147e-14, -8.375558206119290e-16,  2.297409609536366e-19,  1.316422579176008e-20,  1.379221749197463e-23, -2.008212332285434e-25, -5.075093128876615e-28,
  1.421261232109785e+00, -2.666136335970111e-03, -4.654689223654451e-06,  9.699226761668709e-09,  6.341777156630993e-11, -3.162978596380420e-15, -8.695995370586464e-16,
 -1.576409469211054e-18,  1.064887478749609e-20,  4.625976562700500e-23, -9.159625677037653e-26, -9.889953136448964e-28,  1.494253363086612e+00, -2.490785580528542e-03,
 -5.371013954357267e-06,  5.049990276048831e-09,  6.581504604489428e-11,  9.184868198377945e-14, -6.915525899900952e-16, -3.072736916025985e-18,  3.386524137933183e-21,
  5.983292527210449e-23,  9.401387772207059e-26, -8.240291897940455e-28,  1.565046564197668e+00, -2.280875763178211e-03, -5.867749245512316e-06, -5.484502168035680e-11,
  5.998088645826681e-11,  1.739466075762893e-13, -3.250122872569490e-16, -3.636807142366343e-18, -6.000563836227664e-21,  4.267878530896851e-23,  2.409179643882630e-25,
  3.217106236288071e-30,  1.632961703488182e+00, -2.040766699012125e-03, -6.101315237678970e-06, -5.113613359012648e-09,  4.613018177236866e-11,  2.229476097160383e-13,
  1.380255481374387e-16, -2.922711015675090e-18, -1.307782548603969e-20,  6.615891349201217e-25,  2.338545572854940e-25,  8.889830378872218e-28,  1.697285390871782e+00,
 -1.776662091502963e-03, -6.043991128589360e-06, -9.557136874069199e-09,  2.612852803219730e-11,  2.245443485709911e-13,  5.535189006636422e-16, -1.122236457437455e-18,
 -1.388570177422066e-20, -4.158026032079555e-23,  6.190948636172408e-26,  1.037373240153961e-27,  1.757280669566395e+00, -1.496635748982333e-03, -5.690490941178789e-06,
 -1.283166910219951e-08,  3.415653379139005e-12,  1.765539046195615e-13,  7.756785150001085e-16,  1.004968968293187e-18, -7.727248539278365e-21, -5.556205356660527e-23,
 -1.434179350424442e-25,  2.803740868757202e-28,  1.812201442721927e+00, -1.210510915474366e-03, -5.063366789221840e-06, -1.450457014856004e-08, -1.757488735005911e-11,
  9.225604965619086e-14,  7.243047605923807e-16,  2.454898226179118e-18,  1.671334416317163e-21, -3.217381011392973e-23, -2.096398890237292e-25, -6.099573349126363e-28,
  1.861310691891956e+00, -9.295565215646588e-04, -4.215813260133546e-06, -1.437331940273086e-08, -3.248696331410425e-11, -1.945199076905202e-15,  4.351706079826942e-16,
  2.555586847707024e-18,  8.279129840214895e-21,  7.685711497744491e-24, -9.490020334830313e-26, -7.232038830490423e-28,  1.903902147333866e+00, -6.659795685624966e-04,
 -3.230440286907062e-06, -1.254851173969813e-08, -3.836958518251412e-11, -7.540460333768910e-14,  5.542892033907017e-17,  1.434861794153015e-18,  8.265013594289204e-21,
  3.039469373435969e-23,  6.180699515998321e-26, -1.103039387309279e-28,  1.939324575106234e+00, -4.322195194585296e-04, -2.212996846806932e-06, -9.478107176768945e-09,
 -3.480925130242186e-11, -1.060470540609735e-13, -2.295663522380019e-16, -3.109995760047835e-20,  3.166817053954113e-21,  2.200259691710955e-23,  1.012356613782548e-25,
  3.454682114261619e-28,  1.967007329488401e+00, -2.400863743452844e-04, -1.280930968870311e-06, -5.888651024826850e-09, -2.433591368350803e-11, -9.111097414338517e-14,
 -3.043980283690449e-16, -8.613549497129261e-19, -1.713359418625565e-21,  4.812445325072854e-25,  2.916008146785697e-26,  2.023185196604316e-28,  1.986485518737847e+00,
 -9.982184409835624e-05, -5.479464004579875e-07, -2.641115466528650e-09, -1.174929863546120e-11, -4.919850059135616e-14, -1.953728531576947e-16, -7.361279972558942e-19,
 -2.616454851231332e-21, -8.646447755513054e-24, -2.571742220134652e-26, -6.321099496614466e-29,  1.997425465830656e+00, -1.917559059188564e-05, -1.069353814426683e-07,
 -5.288912661882107e-10, -2.445504516652199e-12, -1.081884392764912e-14, -4.634883524985282e-17, -1.936177027629840e-19, -7.919777410126535e-22, -3.180170497961964e-24,
 -1.255462708818005e-26, -4.876175146519884e-29,  4.651416095756036e-04, -2.257655719450073e-06,  8.216812532987109e-09, -2.657690503816058e-11,  8.056201573590717e-14,
 -2.343609484098123e-16,  6.625126322340974e-19, -1.833849269645158e-21,  4.993495515252638e-24, -1.342267865104755e-26,  3.568747412347808e-29, -9.405524763223389e-32,
  4.185541659243436e-03, -2.029110396297831e-05,  7.365735142308265e-08, -2.371591403839586e-10,  7.138638870177888e-13, -2.055925196578290e-15,  5.733047338409589e-18,
 -1.558778546971631e-20,  4.148658493068981e-23, -1.083784597568937e-25,  2.781789198084801e-28, -7.023593856485448e-31,  1.162241815520990e-02, -5.620954514361237e-05,
  2.029720730174422e-07, -6.475298661206781e-10,  1.921352523233634e-12, -5.419563389781782e-15,  1.468281817919181e-17, -3.839858791688445e-20,  9.705710372748232e-23,
 -2.368880219501683e-25,  5.557061584434911e-28, -1.243566046438759e-30,  2.276785068754246e-02, -1.097151018685339e-04,  3.930353037605471e-07, -1.236337831079781e-09,
  3.587616854850024e-12, -9.789654679395856e-15,  2.528550450195432e-17, -6.177454688698990e-20,  1.415426108568841e-22, -2.983013861048769e-25,  5.513043329345304e-28,
 -7.748738532068147e-31,  3.760977436497395e-02, -1.803585522925341e-04,  6.391767625183368e-07, -1.972152602718642e-09,  5.546581020720996e-12, -1.442040275807693e-14,
  3.458135498239139e-17, -7.512890181385755e-20,  1.405610157877123e-22, -1.916614267612563e-25,  2.680919559411955e-30,  1.268984815051794e-30,  5.613175511468568e-02,
 -2.675364759312232e-04,  9.352052247778000e-07, -2.814196492871284e-09,  7.589927329088985e-12, -1.842279793814702e-14,  3.930200800866875e-17, -6.806969314604856e-20,
  6.634532524172864e-23,  1.385153372888315e-25, -1.123956876046809e-27,  4.485605241347914e-30,  7.831268408382545e-02, -3.704875068262778e-04,  1.273443113703386e-06,
 -3.713346870606690e-09,  9.478265304241189e-12, -2.085005723127701e-14,  3.638508335234178e-17, -3.297952298569892e-20, -9.125884613664895e-23,  6.625848943860945e-25,
 -2.518871160349299e-27,  7.289729355756330e-30,  1.041263859027736e-01, -4.882877531043823e-04,  1.644774734714164e-06, -4.613430232363057e-09,  1.095495636244256e-11,
 -2.079790413547725e-14,  2.353354796795383e-17,  3.249418398778790e-20, -3.161433021938593e-22,  1.245952291621049e-24, -3.535041863147576e-27,  7.305021063786120e-30,
  1.335411341428110e-01, -6.198454681810042e-04,  2.038711684896774e-06, -5.452832885534901e-09,  1.176243182641385e-11, -1.751473039745999e-14, -2.365040665277110e-19,
  1.234737523863857e-19, -5.621907776126589e-22,  1.660626140020524e-24, -3.351993907262882e-27,  2.391897398034777e-30,  1.665190658057186e-01, -7.638950936387739e-04,
  2.443479864962953e-06, -6.166454908604310e-09,  1.166073432290863e-11, -1.051512954323011e-14, -3.412647525545161e-17,  2.268669962155181e-19, -7.566193248678429e-22,
  1.634273064872880e-24, -1.288260460839613e-27, -7.941290885037922e-30,  2.030154851190931e-01, -9.189908398352631e-04,  2.846133504303539e-06, -6.688033366891631e-09,
  1.044785951765622e-11,  3.114852742537042e-16, -7.523941285268883e-17,  3.217915038816226e-19, -8.117367240874377e-22,  9.342320015309901e-25,  2.804681290595384e-27,
 -2.128314682906643e-29,  2.429780452879622e-01, -1.083500030794128e-03,  3.232702673014850e-06, -6.952856476710936e-09,  7.981266654493840e-12,  1.460741063176228e-14,
 -1.184970342585285e-16,  3.817382059079962e-19, -6.450025672488245e-22, -5.272665942779529e-25,  8.193218433735318e-27, -3.194239930067375e-29,  2.863457951944561e-01,
 -1.255596518780837e-03,  3.588381875895934e-06, -6.900881036782580e-09,  4.199653184288872e-12,  3.148053838493652e-14, -1.568664336314180e-16,  3.786220835221448e-19,
 -2.053357960091008e-22, -2.592586170296717e-24,  1.312466165894859e-26, -3.212330970385274e-29,  3.330480763878343e-01, -1.433254575753672e-03,  3.897768454223104e-06,
 -6.480249052621532e-09, -8.562557812399474e-13,  4.947957439400686e-14, -1.819603852399932e-16,  2.885831853711308e-19,  4.987578102303790e-22, -4.799085466685271e-24,
  1.506991265291630e-26, -1.493801063310455e-29,  3.830032541421591e-01, -1.614243798951635e-03,  4.145160575801747e-06, -5.651173636460094e-09, -7.025569163374201e-12,
  6.662573226054242e-14, -1.850476294200542e-16,  9.900873367909127e-20,  1.376111275541970e-21, -6.401034002506516e-24,  1.144715567485034e-26,  2.122436453104696e-29,
  4.361172649956894e-01, -1.796125732247258e-03,  4.314925432132937e-06, -4.390126038686219e-09, -1.401388737349732e-11,  8.051601631773453e-14, -1.584627271637434e-16,
 -1.842387812450346e-19,  2.243711433642912e-21, -6.507072409982574e-24,  7.800580337547633e-28,  6.847563540680403e-29,  4.922819622004384e-01, -1.976253110005116e-03,
  4.391948666665598e-06, -2.694201719541169e-09, -2.138741191934825e-11,  8.851116493728058e-14, -9.733497741403190e-17, -5.309332734860058e-19,  2.840858961281105e-21,
 -4.344699430349770e-24, -1.598007010413840e-26,  1.077995426900547e-28,  5.513732401578793e-01, -2.151772882415400e-03,  4.362175708466454e-06, -5.854702452416402e-10,
 -2.857765049955944e-11,  8.801619804728811e-14, -1.460816888122044e-18, -8.839569556696655e-19,  2.874286299912941e-21,  3.782385088201057e-25, -3.449323514489155e-26,
  1.127357311569204e-28,  6.132489195602084e-01, -2.319634485939810e-03,  4.213254121346628e-06,  1.884981488578421e-09, -3.490022233113360e-11,  7.685203926094705e-14,
  1.229724927344173e-16, -1.162402283503395e-18,  2.096342686415558e-21,  7.103145233044847e-24, -4.714006254066676e-26,  5.997705805486954e-29,  6.777463770996447e-01,
 -2.476605182242512e-03,  3.935282664839433e-06,  4.633722054323719e-09, -3.959134492411347e-11,  5.370157841743835e-14,  2.622296222749360e-16, -1.272352868374411e-18,
  4.083364372333256e-22,  1.419196254285170e-23, -4.486752457249065e-26, -5.457248574258938e-29,  7.446799079363401e-01, -2.619294701056612e-03,  3.521666658090381e-06,
  7.542914111713504e-09, -4.186514185054249e-11,  1.859187130700796e-14,  3.949616984631731e-16, -1.126399546239034e-18, -2.033162679725958e-21,  1.903184925391948e-23,
 -2.098851759681393e-26, -2.004806257635907e-28,  8.138378165407111e-01, -2.744191874691512e-03,  2.970069375009360e-06,  1.046022254668751e-08, -4.099363644551135e-11,
 -2.665396495169368e-14,  4.938014297701627e-16, -6.708950260380778e-19, -4.745373393862224e-21,  1.864450612158683e-23,  2.380701496353256e-26, -3.091073832053332e-28,
  8.849792432322801e-01, -2.847716416716097e-03,  2.283434315804608e-06,  1.320154479807660e-08, -3.640880458819905e-11, -7.809401590654603e-14,  5.290994911712834e-16,
  8.328615889416719e-20, -6.934144241690626e-21,  1.084343332362852e-23,  7.731231307025822e-26, -2.934316567241768e-28,  9.578307512148252e-01, -2.926289423333862e-03,
  1.471031943929654e-06,  1.555752624955365e-08, -2.782195016322040e-11, -1.296037734581130e-13,  4.749795149954311e-16,  1.034842321960116e-18, -7.643401007914265e-21,
 -4.280787249318251e-24,  1.157820268728223e-25, -9.573059147288629e-29,  1.032082723959532e+00, -2.976426476832490e-03,  5.494556598683359e-07,  1.730483977608936e-08,
 -1.534964703322375e-11, -1.732195158597900e-13,  3.172929564732367e-16,  1.983323288706533e-18, -6.060343353906160e-21, -2.313170238617879e-23,  1.111966907581272e-25,
  2.512644183263277e-28,  1.107385657474937e+00, -2.994857271821659e-03, -4.565451375985048e-07,  1.822304912932917e-08,  3.723908065184569e-13, -2.000257501080965e-13,
  6.214148862015406e-17,  2.651639459162004e-18, -1.934292521878522e-21, -3.853736602926935e-23,  4.638555611430693e-26,  5.890228937475444e-28,  1.183346478481756e+00,
 -2.978675270254723e-03, -1.513551155465195e-06,  1.811743237001243e-08,  1.811513789491420e-11, -2.016595626180355e-13, -2.574902171328092e-16,  2.750210904872559e-18,
  4.027783431443184e-21, -4.172821761710684e-23, -6.705087521450787e-26,  6.760624602191466e-28,  1.259525079695201e+00, -2.925519751334330e-03, -2.579482399098185e-06,
  1.684728917557235e-08,  3.605755516092268e-11, -1.723647129121279e-13, -5.804481545599815e-16,  2.080946592777617e-18,  1.002062580515849e-20, -2.655766357598114e-23,
 -1.798921859333437e-25,  3.346398423140876e-28,  1.335431338369258e+00, -2.833790416398240e-03, -3.604377653636131e-06,  1.435788435877588e-08,  5.190279220994572e-11,
 -1.113010818308089e-13, -8.251621510357957e-16,  6.573489825113318e-19,  1.351115515432412e-20,  5.355195048624562e-24, -2.199255670570561e-25, -3.559804208871125e-28,
  1.410522973216278e+00, -2.702891049487522e-03, -4.532216196493768e-06,  1.071225677715471e-08,  6.314243824595666e-11, -2.452302334297282e-14, -9.087234835618589e-16,
 -1.209792211095508e-18,  1.223777523828867e-20,  4.172464913490718e-23, -1.351009522075412e-25, -9.808754631387930e-28,  1.484204693789976e+00, -2.533493257330708e-03,
 -5.304038206953964e-06,  6.116796010894744e-09,  6.747914991745793e-11,  7.423324030694175e-14, -7.757434971049682e-16, -2.929252726927588e-18,  5.598973569547609e-21,
  6.281499918320231e-23,  5.380253941679419e-26, -1.000572044735657e-27,  1.555829196366375e+00, -2.327803813430304e-03, -5.862535884262756e-06,  9.322218088984451e-10,
  6.337346151006796e-11,  1.649041335416760e-13, -4.292869194826682e-16, -3.802385911179906e-18, -4.291224124980132e-21,  5.225287515028316e-23,  2.361057507150281e-25,
 -2.274420494178267e-28,  1.624700645175793e+00, -2.089809787037219e-03, -6.158102450166376e-06, -4.339707521854856e-09,  5.061538732576978e-11,  2.252309909838657e-13,
  5.034766442947773e-17, -3.338939417442139e-18, -1.287635189088841e-20,  1.078131433128478e-23,  2.716189468460101e-25,  8.184535074643954e-28,  1.690081322794490e+00,
 -1.825465310201958e-03, -6.156017926457717e-06, -9.102443145703054e-09,  3.074944901170607e-11,  2.374001562667671e-13,  5.156543922618134e-16, -1.589958963247727e-18,
 -1.532656690984402e-20, -3.814185895680683e-23,  1.112008403076195e-25,  1.200583856182811e-27,  1.751202105182314e+00, -1.542774392592093e-03, -5.844023240759017e-06,
 -1.274774949806279e-08,  7.135021192965713e-12,  1.954780296851177e-13,  8.000474006156187e-16,  7.246138213642704e-19, -9.827218463898505e-21, -6.099087081579273e-23,
 -1.264374289789572e-25,  4.980500830294316e-28,  1.807277276288067e+00, -1.251718703042705e-03, -5.239044807646604e-06, -1.477003941973111e-08, -1.555033902774138e-11,
  1.104691238753227e-13,  7.936047034721408e-16,  2.488178321779242e-18,  3.557361682616452e-22, -4.108821060301843e-23, -2.358145796438393e-25, -5.733262641258247e-28,
  1.857523907947163e+00, -9.639817825780315e-04, -4.391411219336106e-06, -1.489282971433772e-08, -3.241547457398086e-11,  9.387737907863691e-15,  5.104720893485254e-16,
  2.824148695948691e-18,  8.479451769033444e-21,  3.212877753168202e-24, -1.297579525318593e-25, -8.626916909924371e-28,  1.901185573443778e+00, -6.924359700237849e-04,
 -3.384755402220820e-06, -1.317440334915370e-08, -3.986096123358493e-11, -7.356128155394475e-14,  9.947561169454283e-17,  1.717315606502133e-18,  9.402304750798328e-21,
  3.274214800598299e-23,  5.482861627385443e-26, -2.115945941754350e-28,  1.937559555160985e+00, -4.503880746308322e-04, -2.330146782089147e-06, -1.005232216117857e-08,
 -3.698529645143958e-11, -1.115548843061682e-13, -2.288935917135144e-16,  8.372357005326453e-20,  4.035556821730105e-21,  2.636623980281890e-23,  1.171938662061715e-25,
  3.793858973097284e-28,  1.966026032027164e+00, -2.506232378226641e-04, -1.353992470575333e-06, -6.293008645930793e-09, -2.623317416679267e-11, -9.871211309111108e-14,
 -3.292792373325458e-16, -9.156618408398333e-19, -1.672758395629368e-21,  1.840732838397243e-24,  3.920655478680266e-26,  2.562035228942141e-28,  1.986077258881818e+00,
 -1.043354611260588e-04, -5.808010345567581e-07, -2.837237952899937e-09, -1.278187781343919e-11, -5.414454402464650e-14, -2.172048507784967e-16, -8.250389565801833e-19,
 -2.946924604443555e-21, -9.731943531308620e-24, -2.858468287160467e-26, -6.695208607896383e-29,  1.997347011345188e+00, -2.005714244810787e-05, -1.135241864484383e-07,
 -5.698126885172861e-10, -2.673459502958556e-12, -1.199924467055591e-14, -5.214286414944976e-17, -2.208940501563399e-19, -9.160452500000314e-22, -3.728034795895513e-24,
 -1.491052008301612e-26, -5.864445232854334e-29,  4.562404663266691e-04, -2.193175348460938e-06,  7.905471699334886e-09, -2.532456376067032e-11,  7.602973208829441e-14,
 -2.190591989496305e-16,  6.133312134933053e-19, -1.681521260429570e-21,  4.535007472950604e-24, -1.207459046312734e-26,  3.179732382121536e-29, -8.301452540430365e-32,
  4.105538006983578e-03, -1.971303769651667e-05,  7.087863957831947e-08, -2.260589360715907e-10,  6.740867216279067e-13, -1.923423070674648e-15,  5.314603759045213e-18,
 -1.432055220963105e-20,  3.777801985541954e-23, -9.784552865463182e-26,  2.490397575730866e-28, -6.237860535710968e-31,  1.140077904262698e-02, -5.461633550029340e-05,
  1.953826485907699e-07, -6.176365688362385e-10,  1.816399824718773e-12, -5.079734449607857e-15,  1.364988723887431e-17, -3.542502290424010e-20,  8.891638550858247e-23,
 -2.157181611561664e-25,  5.036550038733106e-28, -1.124355948106143e-30,  2.233518624154606e-02, -1.066292024914959e-04,  3.785373050545507e-07, -1.180469912864099e-09,
  3.397754781260379e-12, -9.203056773202641e-15,  2.361764383019800e-17, -5.741281535379260e-20,  1.311925150427533e-22, -2.769274873306039e-25,  5.174962323841203e-28,
 -7.604143387085832e-31,  3.689841920175969e-02, -1.753383144768333e-04,  6.160340297371072e-07, -1.885670182905929e-09,  5.266304698167150e-12, -1.361519165295257e-14,
  3.253968054989261e-17, -7.074122149950212e-20,  1.336758165278149e-22, -1.905218069681176e-25,  5.230569998268629e-29,  9.950237674481436e-31,  5.507636149365212e-02,
 -2.601878787773109e-04,  9.021515050918640e-07, -2.695654697108801e-09,  7.230750728498152e-12, -1.750217695144142e-14,  3.742646926797881e-17, -6.587516030514994e-20,
  7.056845106899830e-23,  9.731421472095121e-26, -9.406519647568645e-28,  3.860359191275395e-30,  7.685083053023417e-02, -3.604756558636916e-04,  1.229779256506579e-06,
 -3.564983508373581e-09,  9.069920167661928e-12, -1.998820498225783e-14,  3.542422358213997e-17, -3.553698929114364e-20, -6.914417491971374e-23,  5.680154864496476e-25,
 -2.215165108667296e-27,  6.525531823967162e-30,  1.021992048306910e-01, -4.753480515416758e-04,  1.590451621322446e-06, -4.441447618180171e-09,  1.054471429233860e-11,
 -2.022328362750034e-14,  2.430830505538457e-17,  2.306859862135704e-20, -2.737577641210772e-22,  1.110871052686441e-24, -3.221780189436757e-27,  6.926407569412091e-30,
  1.310939617234247e-01, -6.037943379175831e-04,  1.974395326129917e-06, -5.267435501982552e-09,  1.141235022079290e-11, -1.748089787687236e-14,  2.977703604423453e-18,
  1.064145098147705e-19, -5.047943214022769e-22,  1.528866167819115e-24, -3.231103324202768e-27,  3.065576276693099e-30,  1.635021169147282e-01, -7.446400890965387e-04,
  2.370594758203255e-06, -5.981607969844664e-09,  1.144274200196834e-11, -1.126061958339973e-14, -2.810439479960646e-17,  2.035859303987324e-19, -6.987911804604257e-22,
  1.576415536996609e-24, -1.588951253031083e-27, -5.789784702462876e-30,  1.993845556171027e-01, -8.965399557336315e-04,  2.766879994427735e-06, -6.520912878107608e-09,
  1.043674655200044e-11, -1.389042122719047e-15, -6.658770867230955e-17,  2.963739276698806e-19, -7.763014539669312e-22,  1.028699074909411e-24,  1.942986943007170e-27,
 -1.794468666699419e-29,  2.386952430832985e-01, -1.057969954399133e-03,  3.150043747081010e-06, -6.822969952687138e-09,  8.245829240942783e-12,  1.188939817283165e-14,
 -1.080997438999689e-16,  3.608549772825589e-19, -6.584151663934555e-22, -2.267031508446579e-25,  6.858267760385114e-27, -2.874270547800671e-29,  2.813803004364898e-01,
 -1.227219517218485e-03,  3.505994594525974e-06, -6.828850663467332e-09,  4.792470532499992e-12,  2.784213581808021e-14, -1.463703303823568e-16,  3.706565775194192e-19,
 -2.895579937402516e-22, -2.095663459511333e-24,  1.172764775315157e-26, -3.127843912202328e-29,  3.273769296495890e-01, -1.402383639294836e-03,  3.819955160535435e-06,
 -6.486266911805406e-09,  9.032837925492935e-14,  4.521113709619114e-14, -1.736817635668464e-16,  3.018941419092059e-19,  3.366714817255812e-22, -4.210644250326411e-24,
  1.432456241791791e-26, -1.872865341717049e-29,  3.766121694600997e-01, -1.581355581926160e-03,  4.076715231651684e-06, -5.753162898629202e-09, -5.737216572550012e-12,
  6.222262238487289e-14, -1.816928896448041e-16,  1.394473243357851e-19,  1.154114838680432e-21, -5.927328677254291e-24,  1.217019067261658e-26,  1.189797168640805e-29,
  4.290014620023559e-01, -1.761820745583693e-03,  4.260951053257978e-06, -4.601673920202638e-09, -1.244197494200905e-11,  7.665890380154775e-14, -1.626513706600979e-16,
 -1.161764045259628e-19,  2.010709544733833e-21, -6.419447974166437e-24,  3.507758118786403e-27,  5.565482509965454e-29,  4.844470081432956e-01, -1.941252526042373e-03,
  4.357623047342903e-06, -3.022370320233514e-09, -1.964170071048716e-11,  8.600685573913925e-14, -1.109527444657599e-16, -4.426426031522569e-19,  2.674059601037378e-21,
 -4.892088856102523e-24, -1.146671905238886e-26,  9.719297827273730e-29,  5.428358881463156e-01, -2.116911218709151e-03,  4.352464673052632e-06, -1.028640194663330e-09,
 -2.681962821488689e-11,  8.769452562601867e-14, -2.492372658552203e-17, -7.920184982760732e-19,  2.864265298272440e-21, -9.021037086591957e-25, -2.952569894081183e-26,
  1.124963097947559e-28,  6.040379236945561e-01, -2.285847348915512e-03,  4.232574689745746e-06,  1.339023686901744e-09, -3.333626434388929e-11,  7.942061569637187e-14,
  9.140026946753288e-17, -1.091586338079664e-18,  2.318800419998290e-21,  5.275670849288095e-24, -4.411042716009275e-26,  7.690090384823246e-29,  6.679032579634551e-01,
 -2.444911187323007e-03,  3.987123078058736e-06,  4.009182655200917e-09, -3.845725435389422e-11,  5.956951492564978e-14,  2.268609899245113e-16, -1.251461986698956e-18,
  8.864576747410382e-22,  1.235949506016426e-23, -4.650900972339449e-26, -2.069222482637993e-29,  7.342596330253087e-01, -2.590770663681098e-03,  3.608176483165826e-06,
  6.876550724023020e-09, -4.140110362266408e-11,  2.768575677406513e-14,  3.626134028475220e-16, -1.180677013421432e-18, -1.365150346962236e-21,  1.802725755164239e-23,
 -2.895768317093877e-26, -1.615995661163225e-28,  8.029093493391175e-01, -2.719940415641786e-03,  3.091641132494182e-06,  9.800696958597703e-09, -4.140981101924821e-11,
 -1.504468452733410e-14,  4.729925036250054e-16, -8.118502350060886e-19, -4.060258955975809e-21,  1.933026849738195e-23,  1.063229330065352e-26, -2.883800352981559e-28,
  8.736259017000410e-01, -2.828825285452453e-03,  2.438308302097804e-06,  1.260719917445719e-08, -3.784364011443830e-11, -6.539233643392037e-14,  5.283877983444896e-16,
 -1.317895085842708e-19, -6.491297157656361e-21,  1.367022875819482e-23,  6.386679198711156e-26, -3.154986844551409e-28,  9.461503014663590e-01, -2.913782167019714e-03,
  1.654967845249569e-06,  1.509226716941454e-08, -3.029782685488017e-11, -1.178843072843356e-13,  5.005140070454193e-16,  7.886720121416888e-19, -7.715364780715633e-21,
  2.440619657447443e-25,  1.099301595008209e-25, -1.684984450941696e-28,  1.020187118272685e+00, -2.971204634861738e-03,  7.555272370514167e-07,  1.703196252846271e-08,
 -1.873350527111310e-11, -1.649607407384671e-13,  3.699920231794928e-16,  1.776946814393654e-18, -6.810615984805611e-21, -1.849104017313452e-23,  1.201295968067339e-25,
  1.542934856823857e-28,  1.095400308360145e+00, -2.997635128661858e-03, -2.379644844025884e-07,  1.819710939620626e-08, -3.607237857298825e-12, -1.976516657905917e-13,
  1.353151083350715e-16,  2.567952433336671e-18, -3.282137796770214e-21, -3.617969643167927e-23,  7.106057358369950e-26,  5.290319543059123e-28,  1.171408944056609e+00,
 -2.989909424000181e-03, -1.294537024607009e-06,  1.837469970516194e-08,  1.402645578709373e-11, -2.069020975967396e-13, -1.789090469586549e-16,  2.854605968381119e-18,
  2.484593664987735e-21, -4.380104685068923e-23, -3.629060462474357e-26,  7.172173156358193e-28,  1.247783022860066e+00, -2.945337399802643e-03, -2.373969560546165e-06,
  1.739589525040597e-08,  3.247585627075830e-11, -1.855609682851081e-13, -5.178458605560718e-16,  2.384952195137704e-18,  8.938994627791011e-21, -3.341307460111628e-23,
 -1.617685025178113e-25,  4.868908945545747e-28,  1.324039617559279e+00, -2.861922317752400e-03, -3.427177298258918e-06,  1.516945198822086e-08,  4.948047555360579e-11,
 -1.308351311300236e-13, -8.006866671551400e-16,  1.091065076831031e-18,  1.354227927438279e-20, -3.704416912352309e-24, -2.317590991431565e-25, -1.781778701780076e-28,
  1.399639731878488e+00, -2.738617461018552e-03, -4.397627494254261e-06,  1.171741642624355e-08,  6.243137478103395e-11, -4.669327677414626e-14, -9.368972498872945e-16,
 -7.952766975895451e-19,  1.363230010833601e-20,  3.547036780049646e-23, -1.772048678876299e-25, -9.247945634183232e-28,  1.473986347078150e+00, -2.575613496323488e-03,
 -5.224113014493297e-06,  7.207300663151556e-09,  6.877110628649809e-11,  5.465351549172643e-14, -8.549118299884867e-16, -2.713577727469005e-18,  7.888012228060413e-21,
  6.403989848530255e-23,  6.342272192152499e-27, -1.151418846137533e-27,  1.546424276048438e+00, -2.374641869439455e-03, -5.845158446360658e-06,  1.971985609294587e-09,
  6.655981892592435e-11,  1.533099314820277e-13, -5.373805406896861e-16, -3.907808697306565e-18, -2.243212719424549e-21,  6.142229518492232e-23,  2.204719445714668e-25,
 -4.872239815388488e-28,  1.616242566458683e+00, -2.139268802597790e-03, -6.205171086980274e-06, -3.493791331775442e-09,  5.512427903744401e-11,  2.252713257054016e-13,
 -4.883754790189737e-17, -3.742607229629994e-18, -1.228427819758938e-20,  2.233269965645259e-23,  3.050076860291865e-25,  6.889392371389278e-28,  1.682680285770125e+00,
 -1.875141641896874e-03, -6.262136478666830e-06, -8.571811672606529e-09,  3.561731147758588e-11,  2.491849791525385e-13,  4.640695475693892e-16, -2.101414374551326e-18,
 -1.660647840147678e-20, -3.259378884456463e-23,  1.672283725823636e-25,  1.341162863929460e-27,  1.744936537551294e+00, -1.590136225832141e-03, -5.996178860549177e-06,
 -1.260126317972706e-08,  1.123804420323083e-11,  2.148850397641926e-13,  8.155972213810027e-16,  3.740831601548605e-19, -1.210798549774088e-20, -6.553728567933269e-23,
 -9.901384166523689e-26,  7.546617879430831e-28,  1.802185448494640e+00, -1.294344078334121e-03, -5.417701786683318e-06, -1.500011123137334e-08, -1.314484762573501e-11,
  1.303515179707074e-13,  8.631974374276789e-16,  2.474026388152693e-18, -1.299126570877891e-21, -5.100498700651911e-23, -2.594324641241470e-25, -4.918905650429429e-28,
  1.853596573959167e+00, -9.998367264382867e-04, -4.573228634534181e-06, -1.540928217531466e-08, -3.209864256411797e-11,  2.261871288527572e-14,  5.933568509173722e-16,
  3.096263247776459e-18,  8.492154244241061e-21, -2.779214943087295e-24, -1.709074942749474e-25, -1.008225591762651e-27,  1.898360656769731e+00, -7.201573376704564e-04,
 -3.546722978775908e-06, -1.382380184312823e-08, -4.130423746049247e-11, -7.056174631763609e-14,  1.519527835346830e-16,  2.037451759890486e-18,  1.061792631518202e-20,
  3.471252931873202e-23,  4.272547636516099e-26, -3.441771008078124e-28,  1.935719942109117e+00, -4.695219918494640e-04, -2.454399826717817e-06, -1.066223309199255e-08,
 -3.927105945584078e-11, -1.170046966025667e-13, -2.245920660328465e-16,  2.289862794363956e-19,  5.073227047263659e-21,  3.139688351836723e-23,  1.345503256708089e-25,
  4.084258116403415e-28,  1.965001386652762e+00, -2.617645303014272e-04, -1.432093523994883e-06, -6.728971575848378e-09, -2.828855112608066e-11, -1.069284532425519e-13,
 -3.556549116130677e-16, -9.678040318769986e-19, -1.575379454507255e-21,  3.652987247926244e-24,  5.188866084906236e-26,  3.224877563785757e-28,  1.985650403571563e+00,
 -1.091216176746716e-04, -6.161116250656251e-07, -3.050702410394720e-09, -1.391882552151754e-11, -5.964566136872899e-14, -2.416804399955966e-16, -9.251726309739234e-19,
 -3.318573232595883e-21, -1.093507508443471e-23, -3.158939221083249e-26, -6.934102272637849e-29,  1.997264922031424e+00, -2.099343282102328e-05, -1.206267364687760e-07,
 -6.145780781419219e-10, -2.926477332160665e-12, -1.332833448400364e-14, -5.875931283002895e-17, -2.524752012196256e-19, -1.061642350434547e-21, -4.379434932726035e-24,
 -1.774714173458228e-26, -7.068744912025266e-29,  4.475923565760414e-04, -2.131126801691778e-06,  7.608733757086490e-09, -2.414235345329910e-11,  7.179201698754265e-14,
 -2.048882354287450e-16,  5.682166634847606e-19, -1.543117477037460e-21,  4.122362908610415e-24, -1.087281399882792e-26,  2.836181714089999e-29, -7.335700266879274e-32,
  4.027802989002289e-03, -1.915667893647802e-05,  6.822939729371681e-08, -2.155744998885382e-10,  6.368619785344457e-13, -1.800550867982629e-15,  4.930036712537057e-18,
 -1.316614442668486e-20,  3.442846737979142e-23, -8.841184776117494e-26,  2.231486741174114e-28, -5.545155097531479e-31,  1.118539357008543e-02, -5.308243441332472e-05,
  1.881420882725464e-07, -5.893694612519395e-10,  1.718002396430159e-12, -4.763725480916449e-15,  1.269668084194801e-17, -3.270015881617027e-20,  8.150153827456433e-23,
 -1.965288617639042e-25,  4.565953351997677e-28, -1.016508909223955e-30,  2.191463759929127e-02, -1.036566562088134e-04,  3.646918748295088e-07, -1.127548066191814e-09,
  3.219234081201082e-12, -8.655058705599279e-15,  2.206738862112047e-17, -5.337023512869839e-20,  1.215877131329009e-22, -2.568908017824958e-25,  4.844982806749641e-28,
 -7.384483426506755e-31,  3.620678117271364e-02, -1.704991423955616e-04,  5.939027023950171e-07, -1.803545971497309e-09,  5.001652418649253e-12, -1.285753131946568e-14,
  3.061778536360342e-17, -6.657285074979821e-20,  1.268645993375992e-22, -1.876240081153997e-25,  9.092880463453833e-29,  7.676175131120014e-31,  5.404984227479692e-02,
 -2.530981176871657e-04,  8.704864057467047e-07, -2.582714852150790e-09,  6.889541468830181e-12, -1.662581758188075e-14,  3.561405621134079e-17, -6.356785652452850e-20,
  7.343390676003600e-23,  6.291918936336280e-26, -7.830726213874017e-28,  3.314677720212011e-30,  7.542833687930584e-02, -3.508061040854098e-04,  1.187857123224123e-06,
 -3.423017047874901e-09,  8.678576069614656e-12, -1.915019577329044e-14,  3.440116665897475e-17, -3.743897814251602e-20, -5.022326828347602e-23,  4.849404090302693e-25,
 -1.943696378669365e-27,  5.824231006551355e-30,  1.003229263093500e-01, -4.628347904269129e-04,  1.538153298345638e-06, -4.275936014585270e-09,  1.014612997021322e-11,
 -1.963308708770331e-14,  2.483742046335098e-17,  1.492392871161712e-20, -2.360137314532643e-22,  9.879748235011846e-25, -2.926059424699955e-27,  6.510915169467709e-30,
  1.287099787192229e-01, -5.882489345942181e-04,  1.912270163602946e-06, -5.087629978315836e-09,  1.106367903921478e-11, -1.737545308023374e-14,  5.739259981276702e-18,
  9.111704747543849e-20, -4.520476254982542e-22,  1.402470883415364e-24, -3.085260958367994e-27,  3.533005639490613e-30,  1.605610358434258e-01, -7.259593531324430e-04,
  2.299906420263116e-06, -5.800360551732682e-09,  1.121123345031437e-11, -1.186919502727710e-14, -2.270860581304608e-17,  1.821198964811394e-19, -6.432405930740896e-22,
  1.508314178383574e-24, -1.803079264972763e-27, -3.999040351761280e-30,  1.958421742889335e-01, -8.747150834629674e-04,  2.689629777113823e-06, -6.354231238967426e-09,
  1.039364247505097e-11, -2.890337879518435e-15, -5.863135616391615e-17,  2.721383217994620e-19, -7.380513576833899e-22,  1.091529846575899e-24,  1.220249262229000e-27,
 -1.496539424579386e-29,  2.345132486090306e-01, -1.033094846941715e-03,  3.068967106928643e-06, -6.689271950763389e-09,  8.458479355188358e-12,  9.413865054019318e-15,
 -9.829163802262106e-17,  3.397056387599895e-19, -6.619348486660360e-22,  2.326242271892040e-26,  5.662807593641187e-27, -2.561369052569340e-29,  2.765270011830414e-01,
 -1.199498000644703e-03,  3.424526230871137e-06, -6.747903751175623e-09,  5.315019323187409e-12,  2.445267491775532e-14, -1.361323799210771e-16,  3.602714864783825e-19,
 -3.568863512433424e-22, -1.653713942486950e-24,  1.037976016124599e-26, -2.991715150887030e-29,  3.218280215421461e-01, -1.372135246989152e-03,  3.742157742738651e-06,
 -6.477811462642138e-09,  9.535579054631255e-13,  4.114529245628307e-14, -1.650999079463806e-16,  3.103512198763630e-19,  1.951955410639377e-22, -3.654987397151509e-24,
  1.343938856737111e-26, -2.132547924401911e-29,  3.703515352553935e-01, -1.549019479369018e-03,  4.007166807339781e-06, -5.835238271607777e-09, -4.536033408108375e-12,
  5.791282682868086e-14, -1.773027247607823e-16,  1.730596896843988e-19,  9.495976194323601e-22, -5.432455822899113e-24,  1.251660901662952e-26,  4.091855758578540e-30,
  4.220219998838195e-01, -1.727957286584401e-03,  4.204586441745198e-06, -4.788693169968793e-09, -1.094806000912911e-11,  7.272329390577461e-14, -1.650380344108586e-16,
 -5.549964609040108e-20,  1.782692587186581e-21, -6.233724811113669e-24,  5.692112199365694e-27,  4.380993800063463e-29,  4.767514829364752e-01, -1.906541828211387e-03,
  4.319525284992440e-06, -3.323025159169275e-09, -1.794914689639159e-11,  8.320476566496814e-14, -1.221758182819360e-16, -3.599708937988992e-19,  2.490689069731589e-21,
 -5.268522094920520e-24, -7.437333360709823e-27,  8.588846814374369e-29,  5.344377944062849e-01, -2.082148037945102e-03,  4.337604059362720e-06, -1.443762976681695e-09,
 -2.507346232355765e-11,  8.684055723793628e-14, -4.582350509045627e-17, -7.010999195376835e-19,  2.811717258195361e-21, -1.984912634189331e-24, -2.463903931598660e-26,
  1.091716842482175e-28,  5.949623446186768e-01, -2.251931424281770e-03,  4.245495468266116e-06,  8.184597029414965e-10, -3.172834764846833e-11,  8.125599741975109e-14,
  6.190083820010397e-17, -1.014679613080093e-18,  2.477816517983018e-21,  3.582812770448117e-24, -4.044481197944613e-26,  8.894401653354043e-29,  6.581876972354347e-01,
 -2.412832129895540e-03,  4.031581615240879e-06,  3.403681683547685e-09, -3.721423746971053e-11,  6.459729114271396e-14,  1.922815094523407e-16, -1.216336554568703e-18,
  1.297776556562168e-21,  1.048997497742580e-23, -4.675104623942194e-26,  8.951240710881442e-30,  7.239547879734298e-01, -2.561586393382930e-03,  3.686740359275844e-06,
  6.219024313763667e-09, -4.076306204342051e-11,  3.598742591676242e-14,  3.290387516429369e-16, -1.214214895097727e-18, -7.386272274416810e-22,  1.673826616629110e-23,
 -3.520768041615833e-26, -1.226016659167124e-28,  7.920797828611219e-01, -2.694748135496560e-03,  3.205266200832357e-06,  9.136341630290333e-09, -4.159910092606190e-11,
 -3.979682685222366e-15,  4.485467601280108e-16, -9.305865682091264e-19, -3.359702007703728e-21,  1.950956830206755e-23, -1.463105832413098e-27, -2.603759681968000e-28,
  8.623505569808273e-01, -2.808724061873180e-03,  2.585920771276669e-06,  1.199192550554307e-08, -3.902509198782607e-11, -5.277831140155837e-14,  5.218669310597926e-16,
 -3.311712975419832e-19, -5.956564325094270e-21,  1.594371604381648e-23,  4.974290523196819e-26, -3.243942920023644e-28,  9.345227874308879e-01, -2.899826411351044e-03,
  1.833090789740304e-06,  1.458930012746180e-08, -3.253374497175590e-11, -1.056348379985253e-13,  5.191476217306834e-16,  5.427539310378179e-19, -7.629389047697393e-21,
  4.474116041032495e-24,  1.011280880824882e-25, -2.294964976227971e-28,  1.008315675077985e+00, -2.964348225800988e-03,  9.580051047831748e-07,  1.670633166111795e-08,
 -2.194002165013643e-11, -1.555090868722422e-13,  4.166019848684887e-16,  1.549295216511022e-18, -7.388426622735905e-21, -1.357890752652735e-23,  1.247659418676254e-25,
  5.673177905162715e-29,  1.083407341614379e+00, -2.998666663618449e-03, -2.007527876047948e-08,  1.810796999303745e-08, -7.522037799570681e-12, -1.935543221477401e-13,
  2.055557427546781e-16,  2.442677338491311e-18, -4.528032448794375e-21, -3.289384147487446e-23,  9.265296431404757e-26,  4.495789622699054e-28,  1.159429995215175e+00,
 -2.999380235286609e-03, -1.072831324883513e-06,  1.856581268348385e-08,  9.851990127996709e-12, -2.102292483066947e-13, -9.810567121490261e-17,  2.908665491050962e-18,
  8.892851070164457e-22, -4.461613665193832e-23, -4.386205864926858e-27,  7.278789194271594e-28,  1.235965023929404e+00, -2.963485606206916e-03, -2.162225729553922e-06,
  1.788516719642666e-08,  2.864592514644471e-11, -1.971567566144522e-13, -4.472520098188968e-16,  2.650549633278216e-18,  7.625190733699968e-21, -3.941422324992489e-23,
 -1.373089761197066e-25,  6.213192548188466e-28,  1.312538265059680e+00, -2.888598349351364e-03, -3.240483451537252e-06,  1.593917314642113e-08,  4.667433498768983e-11,
 -1.496362319028045e-13, -7.641027804902065e-16,  1.520483126179563e-18,  1.324067853298981e-20, -1.307488836509005e-23, -2.353355223660692e-25,  1.786084735054019e-29,
  1.388615814388188e+00, -2.773219142595295e-03, -4.251059878696845e-06,  1.270761911488589e-08,  6.127110980091481e-11, -6.939560031047502e-14, -9.528759680179873e-16,
 -3.400581967260781e-19,  1.477208363037920e-20,  2.759588940876428e-23, -2.157483325766859e-25, -8.189969344566179e-28,  1.463600881547827e+00, -2.617041668562238e-03,
 -5.130990989450043e-06,  8.315242828368915e-09,  6.965299981198627e-11,  3.325452198610753e-14, -9.270118288717058e-16, -2.424326720079832e-18,  1.018546932094775e-20,
  6.324403785577351e-23, -4.695558295854127e-26, -1.263851150902605e-27,  1.536832361766688e+00, -2.421290149137137e-03, -5.815006063715791e-06,  3.060734235402712e-09,
  6.948815028265452e-11,  1.390937662020005e-13, -6.474598578452675e-16, -3.942556979512440e-18,  1.208274472496543e-22,  6.973141002141174e-23,  1.929551029666357e-25,
 -7.655387833832644e-28,  1.607585964601185e+00, -2.189062537655097e-03, -6.241656278642884e-06, -2.575859557661257e-09,  5.960927020182546e-11,  2.227981170489175e-13,
 -1.589959261674347e-16, -4.120429584185191e-18, -1.125385782980088e-20,  3.508695719199945e-23,  3.312918189939072e-25,  4.948484265926521e-28,  1.675078887742432e+00,
 -1.925640110188762e-03, -6.361412591812293e-06, -7.961481044835516e-09,  4.070730697899310e-11,  2.595554888916562e-13,  3.976237281793718e-16, -2.650187213535323e-18,
 -1.764491839016400e-20, -2.469097420251690e-23,  2.286592791833930e-25,  1.443435413883945e-27,  1.738479100844955e+00, -1.638707127051754e-03, -6.146169889480487e-06,
 -1.238600658193568e-08,  1.573210113315631e-11,  2.345390768818702e-13,  8.202874352921181e-16, -5.181634111663491e-20, -1.452985972329748e-20, -6.875029315737403e-23,
 -5.951414646579905e-26,  1.045929497339628e-27,  1.796920244167221e+00, -1.338409067801420e-03, -5.598875284581965e-06, -1.518842349527533e-08, -1.032507053127682e-11,
  1.518930624477695e-13,  9.315976143315309e-16,  2.401032387495398e-18, -3.326992864746501e-21, -6.177908361346257e-23, -2.782701402552344e-25, -3.540964903170305e-28,
  1.849522872015779e+00, -1.037170892333810e-03, -4.761203973767883e-06, -1.591843769771801e-08, -3.149668220692725e-11,  3.793018757260192e-14,  6.838317438768269e-16,
  3.365002606673434e-18,  8.257967037656209e-21, -1.054561845329715e-23, -2.184645751952109e-25, -1.152482246258704e-27,  1.895422213241958e+00, -7.492060046090782e-04,
 -3.716619681900124e-06, -1.449574127327946e-08, -4.267417941007873e-11, -6.619073561374481e-14,  2.139482945559975e-16,  2.397517277014087e-18,  1.189426677065424e-20,
  3.607163315377482e-23,  2.399501176820232e-26, -5.137930819520825e-28,  1.933801758097831e+00, -4.896798391174661e-04, -2.586194810525296e-06, -1.130958113905665e-08,
 -4.166443676445589e-11, -1.222985396074177e-13, -2.157301132584404e-16,  4.104884441426439e-19,  6.304784279817730e-21,  3.714499267355438e-23,  1.530001527056239e-25,
  4.282421071616101e-28,  1.963930892552392e+00, -2.735521292054433e-04, -1.515628984296199e-06, -7.199170034669101e-09, -3.051470121986959e-11, -1.157949133017056e-13,
 -3.834364012878213e-16, -1.015682381794583e-18, -1.402887745161344e-21,  6.035021997974318e-24,  6.780311950923637e-26,  4.035424633780338e-28,  1.985203821994487e+00,
 -1.142008230649801e-04, -6.540966728307562e-07, -3.283271104133416e-09, -1.517190393929696e-11, -6.576922250483762e-14, -2.691329484375121e-16, -1.037915433967312e-18,
 -3.735718185603186e-21, -1.225991991274798e-23, -3.465430441191068e-26, -6.952186046419977e-29,  1.997178970413303e+00, -2.198876323145609e-05, -1.282916668682808e-07,
 -6.636133456629374e-10, -3.207739347169713e-12, -1.482737928922778e-14, -6.632894896388069e-17, -2.891136449397321e-19, -1.232866631601000e-21, -5.155641742063351e-24,
 -2.117025140441219e-26, -8.539572250640822e-29,  4.391877814540400e-04, -2.071396543860270e-06,  7.325784683685575e-09, -2.302573677148796e-11,  6.782720001973536e-14,
 -1.917549705117546e-16,  5.267988742753209e-19, -1.417251809525892e-21,  3.750607790340031e-24, -9.800324661397679e-27,  2.532423316011234e-29, -6.489910910856991e-32,
  3.952251800949646e-03, -1.862102080334814e-05,  6.570247416872888e-08, -2.056664907419757e-10,  6.020049403101406e-13, -1.686532198572835e-15,  4.576342148269624e-18,
 -1.211368259000548e-20,  3.140059768827641e-23, -7.995532884772638e-26,  2.001223285044551e-28, -4.933933540803916e-31,  1.097602996406549e-02, -5.160512727945336e-05,
  1.812314917015300e-07, -5.626273686000345e-10,  1.625702422065309e-12, -4.469704097954929e-15,  1.181655010308401e-17, -3.020187101010406e-20,  7.474473793890903e-23,
 -1.791301629987479e-25,  4.140495400809293e-28, -9.190198456861462e-31,  2.150576156987387e-02, -1.007923808569095e-04,  3.514647240114450e-07, -1.077396854693494e-09,
  3.051310273116370e-12, -8.142942529580466e-15,  2.062612934089554e-17, -4.962372018227663e-20,  1.126807221513510e-22, -2.381529921540645e-25,  4.525912614474514e-28,
 -7.111446153350984e-31,  3.553415187206688e-02, -1.658331498207425e-04,  5.727319510160953e-07, -1.725537437817826e-09,  4.751701417979563e-12, -1.214462042065753e-14,
  2.880957083195791e-17, -6.262049048791137e-20,  1.201832107927970e-22, -1.833693453817181e-25,  1.204350577188140e-28,  5.795182876015665e-31,  5.305118391285366e-02,
 -2.462563477713212e-04,  8.401443992541000e-07, -2.475096479097250e-09,  6.565429699234099e-12, -1.579217161188320e-14,  3.386735364634997e-17, -6.118749885676875e-20,
  7.516900785492596e-23,  3.436849414125760e-26, -6.479228305857500e-28,  2.839393494759204e-30,  7.404386132220131e-02, -3.414652201638569e-04,  1.147601567152337e-06,
 -3.287179362448452e-09,  8.303742650509939e-12, -1.833731327069082e-14,  3.333289560925151e-17, -3.878131275254342e-20, -3.410487762430541e-23,  4.121251299366151e-25,
 -1.701728686842215e-27,  5.184220135519332e-30,  9.849587648631378e-02, -4.507320788527213e-04,  1.487803242075684e-06, -4.116706713864858e-09,  9.759458782777650e-12,
 -1.903279591207512e-14,  2.515474539328074e-17,  7.918526390170196e-21, -2.024855147288532e-22,  8.765349015377221e-25, -2.649107512500144e-27,  6.075769605645055e-30,
  1.263871968572840e-01, -5.731919965615315e-04,  1.852269275795152e-06, -4.913382863571187e-09,  1.071774580049373e-11, -1.720868430906596e-14,  8.095442125703278e-18,
  7.743583869757513e-20, -4.037416736541266e-22,  1.282268771767540e-24, -2.922662401186032e-27,  3.833150917031715e-30,  1.576935603873140e-01, -7.078354878464465e-04,
  2.231370447101644e-06, -5.622907807181650e-09,  1.096880072248790e-11, -1.235528557266583e-14, -1.788935859922211e-17,  1.623907502091351e-19, -5.902777192216264e-22,
  1.433127358823012e-24, -1.945526643624874e-27, -2.524456742952808e-30,  1.923858690946975e-01, -8.535002261521435e-04,  2.614374643606268e-06, -6.188469325505565e-09,
  1.032236776419379e-11, -4.208684130584814e-15, -5.133616286144263e-17,  2.491575802208700e-19, -6.980290725062662e-22,  1.127969854167508e-24,  6.209279393706255e-28,
 -1.233211219746883e-29,  2.304294675761982e-01, -1.008861880941309e-03,  2.989513664237448e-06, -6.552555044008037e-09,  8.623924754096501e-12,  7.166615562878263e-15,
 -8.907600187608895e-17,  3.185786888990005e-19, -6.572836332695185e-22,  2.281281224495644e-25,  4.602313053482464e-27, -2.261632979815816e-29,  2.717832908480098e-01,
 -1.172424208460851e-03,  3.344077200768337e-06, -6.659125124751105e-09,  5.772211253398879e-12,  2.130520631058811e-14, -1.262130567555753e-16,  3.479761696377652e-19,
 -4.092594785859820e-22, -1.264364114817964e-24,  9.100329529237859e-27, -2.818939524592826e-29,  3.163988632112795e-01, -1.342508599472867e-03,  3.664542013356980e-06,
 -6.456183613920401e-09,  1.737546798500234e-12,  3.728776058633104e-14, -1.563416780712051e-16,  3.145940878222708e-19,  7.306122483153692e-23, -3.136713452206122e-24,
  1.246273902992982e-26, -2.291679317880384e-29,  3.642191269010648e-01, -1.517243383614613e-03,  3.936745967057668e-06, -5.898778249572996e-09, -3.419920034241309e-12,
  5.371896599110319e-14, -1.720603438071792e-16,  2.004145789946168e-19,  7.630663671781374e-22, -4.930168927917542e-24,  1.255125381546640e-26, -2.292062778923670e-30,
  4.151770761197874e-01, -1.694553321055877e-03,  4.146118409027780e-06, -4.952442027708015e-09, -9.533296691426229e-12,  6.874997371740501e-14, -1.658267809720534e-16,
 -1.996590755703473e-21,  1.562811727429705e-21, -5.970727170775596e-24,  7.379713635131323e-27,  3.309411900988187e-29,  4.691941687512236e-01, -1.872149887887236e-03,
  4.277980255076601e-06, -3.597061331423945e-09, -1.631514439805044e-11,  8.016042501196553e-14, -1.311680553805026e-16, -2.833537393721848e-19,  2.296547302179819e-21,
 -5.493823010390223e-24, -3.911657132079543e-27,  7.436908837223412e-29,  5.261784847387584e-01, -2.047523194497800e-03,  4.317928954670120e-06, -1.831110131013848e-09,
 -2.334918667347068e-11,  8.551531811673142e-14, -6.420669799907382e-17, -6.124491834881985e-19,  2.723664241744944e-21, -2.875939855880545e-24, -1.995421938715477e-26,
  1.034291518498080e-28,  5.860225970317339e-01, -2.217936680594219e-03,  4.252324927751911e-06,  3.238783217112940e-10, -3.009062602113294e-11,  8.240975317918805e-14,
  3.461708005496375e-17, -9.336302054579992e-19,  2.578644345363090e-21,  2.045829832360563e-24, -3.634917302287388e-26,  9.652602775067165e-29,  6.486011185426724e-01,
 -2.380426122765634e-03,  4.068896643629001e-06,  2.818828694949881e-09, -3.587887704922958e-11,  6.880838710989632e-14,  1.588596951586297e-16, -1.169125159040453e-18,
  1.641920597768525e-21,  8.635516626028720e-24, -4.578966242422076e-26,  3.396639981677079e-29,  7.137678873140386e-01, -2.531804987463594e-03,  3.757480506961164e-06,
  5.572990775402938e-09, -3.996710954102811e-11,  4.347425569067173e-14,  2.947984214506048e-16, -1.228491405771739e-18, -1.625968304689987e-22,  1.523329147249870e-23,
 -3.976675522019509e-26, -8.495936260140392e-29,  7.813527529630151e-01, -2.668678778740971e-03,  3.310908030063429e-06,  8.470695101768794e-09, -4.157321396311918e-11,
  6.461261806359057e-15,  4.210905679297970e-16, -1.026892664380876e-18, -2.661086294264475e-21,  1.923139197623017e-23, -1.220315635418287e-26, -2.271048814228534e-28,
  8.511579317661588e-01, -2.787471773922701e-03,  2.726044829660557e-06,  1.135975648505204e-08, -3.995627026685521e-11, -4.038577415908532e-14,  5.100144573813349e-16,
 -5.122416882764434e-19, -5.350215972983083e-21,  1.764808213191210e-23,  3.549911027328386e-26, -3.211628299550123e-28,  9.229539073258481e-01, -2.884470403948726e-03,
  2.004971638567029e-06,  1.405254027518859e-08, -3.452075718304130e-11, -9.302034139397632e-14,  5.309564265748188e-16,  3.019506113858455e-19, -7.398080796532827e-21,
  8.302259190844143e-24,  8.993218234649017e-26, -2.771115429652907e-28,  9.964748712055879e-01, -2.955888481501983e-03,  1.156274005498865e-06,  1.633096737298768e-08,
 -2.494684497560931e-11, -1.450172097559398e-13,  4.566056338712858e-16,  1.306010506233548e-18, -7.787089869854244e-21, -8.566346520529853e-24,  1.251792189853457e-25,
 -3.696594602258967e-29,  1.071413726687152e+00, -2.997960421630043e-03,  1.963714307417872e-07,  1.795693968734751e-08, -1.133834003895770e-11, -1.878176857801415e-13,
  2.717494441617931e-16,  2.279585831326099e-18, -5.640976211498110e-21, -2.881896219212482e-23,  1.104028587212130e-25,  3.551796855200741e-28,  1.147416723335580e+00,
 -3.007069367377520e-03, -8.492348715736609e-07,  1.868970764535018e-08,  5.630466975809562e-12, -2.116047409295425e-13, -1.650597968044979e-17,  2.911452323128765e-18,
 -7.123652760757049e-22, -4.415475813672018e-23,  2.730877293260087e-26,  7.078088405441195e-28,  1.224077855765926e+00, -2.979917435666437e-03, -1.944985656931710e-06,
  1.831139941323579e-08,  2.460159778073373e-11, -2.069739950938815e-13, -3.698410818913250e-16,  2.870848676997750e-18,  6.114319596535659e-21, -4.432562774139065e-23,
 -1.074653573934223e-25,  7.304984222896718e-28,  1.300933252919220e+00, -2.913744675078727e-03, -3.044834583493619e-06,  1.666103964927203e-08,  4.350191949800339e-11,
 -1.674164377840724e-13, -7.156811166470802e-16,  1.934842031128921e-18,  1.260127553460971e-20, -2.241264860681317e-23, -2.300615127266045e-25,  2.223982154403666e-28,
  1.377455910017654e+00, -2.806601103731697e-03, -4.092736255329337e-06,  1.367560876020487e-08,  5.965401604405148e-11, -9.232461054189075e-14, -9.556426262108267e-16,
  1.468100945866145e-19,  1.560188828087953e-20,  1.828720995063663e-23, -2.485626524684371e-25, -6.648873668387361e-28,  1.453051277779567e+00, -2.657671476624698e-03,
 -5.024503416649079e-06,  9.433780335282338e-09,  7.009030825714929e-11,  1.023058304192582e-14, -9.899908315079380e-16, -2.062435815148419e-18,  1.241483477215419e-20,
  6.023132642290209e-23, -1.041332865788926e-25, -1.325926831425342e-27,  1.527054420643979e+00, -2.467644175875646e-03, -5.771517425917581e-06,  4.193917859795889e-09,
  7.210570581104646e-11,  1.222328384598275e-13, -7.574097220897438e-16, -3.897106476704934e-18,  2.761208135494504e-21,  7.669248709454775e-23,  1.530371371176208e-25,
 -1.048325039854170e-27,  1.598729675519289e+00, -2.239102878313055e-03, -6.266697837145596e-06, -1.586710809159935e-09,  6.401752336305444e-11,  2.175583160799844e-13,
 -2.792013318270058e-16, -4.457746998178167e-18, -9.747596246603120e-21,  4.870216692696662e-23,  3.475692032050607e-25,  2.340909399636588e-28,  1.667273955783489e+00,
 -1.976902091862858e-03, -6.452869548416703e-06, -7.268143141171705e-09,  4.598750283329945e-11,  2.681434363290887e-13,  3.153932460658833e-16, -3.227155941386160e-18,
 -1.835367751621153e-20, -1.425602687813815e-23,  2.934289876100659e-25,  1.489948997784794e-27,  1.731824998801906e+00, -1.688466371909541e-03, -6.293133429757611e-06,
 -1.209569852466515e-08,  2.061935284491751e-11,  2.541537240589549e-13,  8.119523965467503e-16, -5.567359842583482e-19, -1.703579550994079e-20, -7.011853963431171e-23,
 -6.585453579306896e-27,  1.363247745348982e-27,  1.791475867920922e+00, -1.383931683942574e-03, -5.782023326931081e-06, -1.532808431618509e-08, -7.058251490736824e-12,
  1.750439891473106e-13,  9.969862031160143e-16,  2.256808351333721e-18, -5.754655216141168e-21, -7.316622198345435e-23, -2.895883995051209e-25, -1.481936001343772e-28,
  1.845296787370378e+00, -1.076033112622488e-03, -4.955220896390604e-06, -1.641539149947229e-08, -3.056617440236648e-11,  5.550223752185575e-14,  7.816817024562702e-16,
  3.621395110308684e-18,  7.708440742222978e-21, -2.033864139481665e-23, -2.721521101804027e-25, -1.284819001720081e-27,  1.892364805115168e+00, -7.796464637030318e-04,
 -3.894708016310147e-06, -1.518881605938249e-08, -4.394098157028399e-11, -6.020619571972444e-14,  2.866036770441604e-16,  2.799048614658554e-18,  1.320414029437877e-20,
  3.652008243194720e-23, -3.118479545284430e-27, -7.261309867522780e-28,  1.931800783849719e+00, -5.109237779234654e-04, -2.725991186703113e-06, -1.199605687143317e-08,
 -4.416112857220118e-11, -1.273140613719132e-13, -2.012022292236271e-16,  6.348552600448200e-19,  7.756732026982432e-21,  4.364454886825960e-23,  1.720118910902573e-25,
  4.328137866052123e-28,  1.962811874881050e+00, -2.860312005453165e-04, -1.605026506941112e-06, -7.706442199183442e-09, -3.292495308412838e-11, -1.253435087020159e-13,
 -4.124673991420886e-16, -1.056538818588224e-18, -1.132280392628371e-21,  9.129886365079842e-24,  8.765685613811787e-26,  5.019981153794312e-28,  1.984736297666112e+00,
 -1.195954225178701e-04, -6.949970009578465e-07, -3.536905721431319e-09, -1.655430586819581e-11, -7.259107873652391e-14, -2.999364748912189e-16, -1.164793610572878e-18,
 -4.202758157101649e-21, -1.370661733589761e-23, -3.765721406074525e-26, -6.628909112105213e-29,  1.997088910996882e+00, -2.304784562565020e-05, -1.365730439557884e-07,
 -7.173988836757981e-10, -3.520885379896107e-12, -1.652105182263812e-14, -7.500556683537518e-17, -3.317061071245522e-19, -1.434663247086178e-21, -6.082635552110471e-24,
 -2.531047442555387e-26, -1.033992990170068e-28,  4.310176835444527e-04, -2.013877339827935e-06,  7.055862884260368e-09, -2.197050867306710e-11,  6.411538674522383e-14,
 -1.795747510834592e-16,  4.887444187083012e-19, -1.302687293370156e-21,  3.415362006781860e-24, -8.842213047620951e-27,  2.263534520537750e-29, -5.748308685960305e-32,
  3.878803554507893e-03, -1.810511178153269e-05,  6.329117466305635e-08, -1.962984026116116e-10,  5.693457203481788e-13, -1.580659245235133e-15,  4.250804558938671e-18,
 -1.115341426280881e-20,  2.866121195764260e-23, -7.236824723443789e-26,  1.796247906860169e-28, -4.394153809564482e-31,  1.077246701457172e-02, -5.018184596372351e-05,
  1.746331298451811e-07, -5.373161564557491e-10,  1.539077186241844e-12, -4.195990293401407e-15,  1.100343624402956e-17, -2.791009939872217e-20,  6.858466559369700e-23,
 -1.633503445991914e-25,  3.755826943665207e-28, -8.309537736747773e-31,  2.110813475547144e-02, -9.803156036229302e-05,  3.388235990506586e-07, -1.029852329843202e-09,
  2.893291219579905e-12, -7.664189340396992e-15,  1.928588181404402e-17, -4.615167986865111e-20,  1.044256197002896e-22, -2.206662603400527e-25,  4.219706761381070e-28,
 -6.802260691696397e-31,  3.487985364377430e-02, -1.613328457655198e-04,  5.524737697303247e-07, -1.651416375123303e-09,  4.515583503518697e-12, -1.147380268818019e-14,
  2.710905368511416e-17, -5.887927175747397e-20,  1.136743333061747e-22, -1.780897956164755e-25,  1.424142670284581e-28,  4.245379906563432e-31,  5.207941521465945e-02,
 -2.396522351314556e-04,  8.110632413986887e-07, -2.372532765940113e-09,  6.257577067601680e-12, -1.499964134254312e-14,  3.218793111232557e-17, -5.876705956354594e-20,
  7.596872451014514e-23,  1.082438874251339e-26, -5.322910450016226e-28,  2.426193508050237e-30,  7.269611539323147e-02, -3.324399612101960e-04,  1.108940611255051e-06,
 -3.157210355313513e-09,  7.944907743171445e-12, -1.755046437029975e-14,  3.223387915721505e-17, -3.964798650244660e-20, -2.044024728385771e-23,  3.484428442572531e-25,
 -1.486618956591530e-27,  4.602929351237758e-30,  9.671644386282514e-02, -4.390246289820092e-04,  1.439327214335861e-06, -3.963567756320554e-09,  9.384854299705663e-12,
 -1.842712514670434e-14,  2.529035161206211e-17,  1.923938047443425e-21, -1.727743704385136e-22,  7.757874058505050e-25, -2.391484203261702e-27,  5.634244186396554e-30,
  1.241236958435718e-01, -5.586067955908244e-04,  1.794326263444856e-06, -4.744641052334449e-09,  1.037568327786894e-11, -1.698979333119161e-14,  1.008955004344837e-17,
  6.523246251552462e-20, -3.596431278166548e-22,  1.168793033700805e-24, -2.749918449049927e-27,  3.999186165615374e-30,  1.548974972091663e-01, -6.902514592546529e-04,
  2.164940332364682e-06, -5.449405660873048e-09,  1.071775903640500e-11, -1.273215420160101e-14, -1.359921415483858e-17,  1.443121304389298e-19, -5.401092641297888e-22,
  1.353456542992596e-24, -2.029278988600207e-27, -1.324516109906523e-30,  1.890132318155392e-01, -8.328794746674122e-04,  2.541100970802908e-06, -6.024049446044550e-09,
  1.022642560688148e-11, -5.359521498753344e-15, -4.466633482904011e-17,  2.274741352031084e-19, -6.570994277697794e-22,  1.142656551752960e-24,  1.302029089637576e-28,
 -1.002566029065475e-29,  2.264413576018940e-01, -9.852579384085007e-04,  2.911715262379154e-06, -6.413538754340727e-09,  8.746589114729057e-12,  5.133466031178170e-15,
 -8.044878473751876e-17,  2.977106486555132e-19, -6.459894637389253e-22,  3.931629840373529e-25,  3.669995378932487e-27, -1.979314330208893e-29,  2.671465954137670e-01,
 -1.145989627488258e-03,  3.264735368850200e-06, -6.563522207919119e-09,  6.168805638184240e-12,  1.839149345367951e-14, -1.166594279956615e-16,  3.342194546257040e-19,
 -4.485181440197835e-22, -9.245917962295379e-25,  7.902639048384671e-27, -2.622040742023710e-29,  3.110869715559394e-01, -1.313501632198997e-03,  3.587258572209144e-06,
 -6.422617694612859e-09,  2.446494441852412e-12,  3.364142716652570e-14, -1.475166136397212e-16,  3.152195223397466e-19, -3.113293432077452e-23, -2.658649401305669e-24,
  1.143493412130935e-26, -2.367853263426206e-29,  3.582126917875114e-01, -1.486033407247581e-03,  3.865667048802338e-06, -5.945124346728059e-09, -2.386367079810936e-12,
  4.965945574667949e-14, -1.661328747361532e-16,  2.220895271632519e-19,  5.945782789427243e-22, -4.431722004421933e-24,  1.233407997383408e-26, -7.376034949625137e-30,
  4.084648208197339e-01, -1.661624580962300e-03,  4.085818582930543e-06, -5.094190936958697e-09, -8.198071802121804e-12,  6.477491474066713e-14, -1.652144376186269e-16,
  4.463389076409804e-20,  1.353503428030371e-21, -5.649302799257123e-24,  8.622274063303085e-27,  2.358908843596365e-29,  4.617737374013052e-01, -1.838103021790011e-03,
  4.233301610047876e-06, -3.845451567408208e-09, -1.474401673842572e-11,  7.692530547002621e-14, -1.381030186798047e-16, -2.130526669343378e-19,  2.096711232214722e-21,
 -5.588207407346743e-24, -8.902145182747332e-28,  6.302582704577696e-29,  5.180573308642373e-01, -2.013073877714410e-03,  4.293770264570904e-06, -2.191104047027910e-09,
 -2.165562847887728e-11,  8.377832225435198e-14, -8.015168547226540e-17, -5.270937380795786e-19,  2.606841145513552e-21, -3.585198571489014e-24, -1.556365211169315e-26,
  9.589554743042597e-29,  5.772189007336187e-01, -2.183910594150381e-03,  4.253377280294016e-06, -1.443497130743751e-10, -2.843619188902602e-11,  8.293624595656524e-14,
  9.639786883730342e-18, -8.502074112891693e-19,  2.627159043075996e-21,  6.781438145823794e-25, -3.200869896220832e-26,  1.001638704921013e-28,  6.391447169909206e-01,
 -2.347749299014005e-03,  4.099324270184153e-06,  2.255972137442821e-09, -3.446720269866088e-11,  7.223440561818976e-14,  1.269040051142453e-16, -1.111959831140871e-18,
  1.920248853408234e-21,  6.840126796246605e-24, -4.383234027894711e-26,  5.421792951589866e-29,  7.037011953424223e-01, -2.501488442384164e-03,  3.820549460020309e-06,
  4.940845621362750e-09, -3.902965995343643e-11,  5.013655231798914e-14,  2.604080332982819e-16, -1.225233804291348e-18,  3.563651215113297e-22,  1.357840677390785e-23,
 -4.272173229329629e-26, -4.985945248753161e-29,  7.707316402026281e-01, -2.641796215710389e-03,  3.408571358753072e-06,  7.807096641366437e-09, -4.134530301279800e-11,
  1.621341288589231e-14,  3.912487051838550e-16, -1.101083267918021e-18, -1.979854606389279e-21,  1.855400164409213e-23, -2.139982551639693e-26, -1.905390935634689e-28,
  8.400525093105062e-01, -2.765129072170778e-03,  2.858501591079961e-06,  1.071465427877368e-08, -4.064284150462943e-11, -2.833629060737054e-14,  4.933720994556994e-16,
 -6.730367040868319e-19, -4.692701907778831e-21,  1.878878987091957e-23,  2.163744017809674e-26, -3.073021576819736e-28,  9.114491598126292e-01, -2.867765635433261e-03,
  2.170228985218288e-06,  1.348601966987312e-08, -3.625318663951587e-11, -8.020238282565270e-14,  5.361464437319379e-16,  7.066388303968604e-20, -7.037487710946684e-21,
  1.164480628744764e-23,  7.695159365301395e-26, -3.105549057910794e-28,  9.846710489519310e-01, -2.945861405064060e-03,  1.349756966945961e-06,  1.590922243687578e-08,
 -2.773478839560584e-11, -1.336482636381946e-13,  4.896458144374567e-16,  1.052851050057347e-18, -8.005978916682129e-21, -3.617677381371439e-24,  1.216281969261650e-25,
 -1.228699551748151e-28,  1.059426386943660e+00, -2.995530884182018e-03,  4.106434729302410e-07,  1.774585110098039e-08, -1.502441316050973e-11, -1.805510834889094e-13,
  3.329009666987946e-16,  2.083355955721782e-18, -6.595475894118111e-21, -2.412043209394885e-23,  1.237640346199444e-25,  2.509716981012968e-28,  1.135376280263940e+00,
 -3.012964930537806e-03, -6.245575082697958e-07,  1.874594448657533e-08,  1.400994382846427e-12, -2.110266721049355e-13,  6.445843265320776e-17,  2.863494527634354e-18,
 -2.274878508594412e-21, -4.245200198780881e-23,  5.746995955681923e-26,  6.585592990579030e-28,  1.212128466947562e+00, -2.994591999711989e-03, -1.723025200039128e-06,
  1.867145457483290e-08,  2.037997500865452e-11, -2.148649690471546e-13, -2.869635370620169e-16,  3.040210143964519e-18,  4.449203394720209e-21, -4.795603397158579e-23,
 -7.348700970245772e-26,  8.084102908419482e-28,  1.289230839466295e+00, -2.937292049762901e-03, -2.840839389036036e-06,  1.732936971233623e-08,  3.998644759547365e-11,
 -1.838979199414500e-13, -6.559939995961359e-16,  2.323419831703627e-18,  1.163168191795313e-20, -3.135933217599596e-23, -2.157985741273247e-25,  4.246117185804326e-28,
  1.366165083880846e+00, -2.838670487080004e-03, -3.922967129266234e-06,  1.461405734097292e-08,  5.757879646340810e-11, -1.151537506080721e-13, -9.444573236619184e-16,
  6.546310746826464e-19,  1.607470994975978e-20,  7.814845852172460e-24, -2.736152570579035e-25, -4.672653624920315e-28,  1.442340943710207e+00, -2.697395610868777e-03,
 -4.904566864217903e-06,  1.055555241126360e-08,  7.005288491064046e-11, -1.417531134602749e-14, -1.041857610921194e-15, -1.631386278929345e-18,  1.449407129717545e-20,
  5.489402103953675e-23, -1.627448576094114e-25, -1.327580114203468e-27,  1.517091846324658e+00, -2.513595215279945e-03, -5.714190890334455e-06,  5.366141856895495e-09,
  7.435980818288725e-11,  1.027581528962287e-13, -8.648687458604523e-16, -3.763486598388923e-18,  5.620467361092050e-21,  8.181037413764646e-23,  1.008870216950170e-25,
 -1.318524900109999e-27,  1.589672901266097e+00, -2.289294882252650e-03, -6.279450392904755e-06, -5.280282335137446e-10,  6.829139625704596e-11,  2.093261501779408e-13,
 -4.081023741433788e-16, -4.738919618502966e-18, -7.742408199843219e-21,  6.271976596241937e-23,  3.509435022656856e-25, -9.080366204943198e-29,  1.659262567324119e+00,
 -2.028861000427559e-03, -6.535494245780433e-06, -6.489060795027561e-09,  5.141840204859955e-11,  2.745617928924939e-13,  2.167501716728058e-16, -3.820291604882227e-18,
 -1.863983497324573e-20, -1.209809175797242e-24,  3.586840570060725e-25,  1.462504294589635e-27,  1.724969532342087e+00, -1.739386031251209e-03, -6.436131200250616e-06,
 -1.172407193564383e-08,  2.589570496450643e-11,  2.733895856197351e-13,  7.883526165287792e-16, -1.142197454313671e-18, -1.954946893945833e-20, -6.908559768207869e-23,
  6.063525212149528e-26,  1.692826525371581e-27,  1.785846461528700e+00, -1.430925263831240e-03, -5.966518132832589e-06, -1.541168815327929e-08, -3.313094740420935e-12,
  1.997066228320379e-13,  1.057186785175897e-15,  2.028271805444560e-18, -8.598016589316142e-21, -8.480237628721070e-23, -2.901452404128875e-25,  1.367162748417924e-28,
  1.840912112198161e+00, -1.116471041426051e-03, -5.155099918440129e-06, -1.689451565122857e-08, -2.926017181731059e-11,  7.550650642253712e-14,  8.864084443918815e-16,
  3.854136506934531e-18,  6.766365339777002e-21, -3.238902049255209e-23, -3.311396717910539e-25, -1.390624278710795e-27,  1.889182732591309e+00, -8.115452319008244e-04,
 -4.081230593818090e-06, -1.590110350313964e-08, -4.506972045427610e-11, -5.233826864769110e-14,  3.710895851623621e-16,  3.242525805711121e-18,  1.450826021574321e-20,
  3.568340217825420e-23, -4.060959730391533e-26, -9.862441427069429e-28,  1.929712543963597e+00, -5.333197251637279e-04, -2.874268196891812e-06, -1.272326097860478e-08,
 -4.675410718855565e-11, -1.319000549745360e-13, -1.797053792196366e-16,  9.095749529678253e-19,  9.456345327409581e-21,  5.090238701972395e-23,  1.907442153845056e-25,
  4.139979633361227e-28,  1.961641471066317e+00, -2.992504714804233e-04, -1.700749105456455e-06, -8.253844395185905e-09, -3.553323144365710e-11, -1.356014886539980e-13,
 -4.425032522349015e-16, -1.086791094172941e-18, -7.348672905773947e-22,  1.311128359494460e-23,  1.122770086647831e-25,  6.206714627927931e-28,  1.984246520713596e+00,
 -1.253297857070431e-04, -7.390782909917531e-07, -3.813791673275531e-09, -1.808083446302702e-11, -8.019658843042499e-14, -3.345098170087826e-16, -1.307473189511273e-18,
 -4.723994923745455e-21, -1.526922810811300e-23, -4.041294105373087e-26, -5.796186050872933e-29,  1.996994478537413e+00, -2.417584856804826e-05, -1.455310651329011e-07,
 -7.764774791420825e-10, -3.870087757598910e-12, -1.843803596666906e-14, -8.497043260207962e-17, -3.813235883847706e-19, -1.673013766999408e-21, -7.192219857244929e-24,
 -3.032948970500873e-26, -1.254856783281326e-28,  4.230734224982125e-04, -1.958467850658624e-06,  6.798255369073086e-09, -2.097276930569452e-11,  6.063829848978190e-14,
 -1.682705260161333e-16,  4.537526204007008e-19, -1.198318906653439e-21,  3.112748352976771e-24, -7.985406728463288e-27,  2.025237095462656e-29, -5.097319475297247e-32,
  3.807381063003619e-03, -1.760805221262658e-05,  6.098922545546669e-08, -1.874363378624029e-10,  5.387279581771795e-13, -1.482286202670149e-15,  3.950967197402220e-18,
 -1.027658983059266e-20,  2.618075786857310e-23, -6.555547139750771e-26,  1.613613854855026e-28, -3.917075105137107e-31,  1.057449350747917e-02, -4.881015975746267e-05,
  1.683303637871059e-07, -5.133481927528471e-10,  1.457736163991206e-12, -3.941042946557858e-15,  1.025181560397785e-17, -2.580665046728341e-20,  6.296588083952765e-23,
 -1.490342813611031e-25,  3.407994526761010e-28, -7.514466211026066e-31,  2.072135251869800e-02, -9.536962899484036e-05,  3.267381489638734e-07, -9.847612244978528e-10,
  2.744533293174533e-12, -7.216464763469152e-15,  1.803924609855563e-17, -4.293396415915858e-20,  9.677832763558837e-23, -2.043763922596012e-25,  3.927644564322699e-28,
 -6.470536901664633e-31,  3.424323804465991e-02, -1.569911125682355e-04,  5.330828095301213e-07, -1.580968050502050e-09,  4.292482183804613e-12, -1.084256367246992e-14,
  2.551040439357225e-17, -5.534313922596980e-20,  1.073697797201841e-22, -1.720589104698281e-25,  1.582045222830856e-28,  2.974001471694271e-31,  5.113360534669626e-02,
 -2.332759312415849e-04,  7.831838102876879e-07, -2.274770056928099e-09,  5.965177481239376e-12, -1.424660180675943e-14,  3.057651789421927e-17, -5.633373262358895e-20,
  7.599987862129139e-23, -8.441476652916526e-27, -4.336133237540459e-28,  2.067583358354389e-30,  7.138386166619891e-02, -3.237178478078038e-04,  1.071805349949846e-06,
 -3.032858251377705e-09,  7.601544330863986e-12, -1.679023571601004e-14,  3.111638450083246e-17, -4.011246146157425e-20, -8.919312760777856e-24,  2.928699992508559e-25,
 -1.295852320339238e-27,  4.077147194181827e-30,  9.498307691830304e-02, -4.276977376341801e-04,  1.392653292220331e-06, -3.816325441530254e-09,  9.022382722983918e-12,
 -1.782010985936756e-14,  2.527088866399102e-17, -3.175973369092633e-21, -1.465093262669075e-22,  6.849567440055158e-25, -2.153238921550547e-27,  5.196370154482290e-30,
  1.219176212390298e-01, -5.444771318039433e-04,  1.738375467407755e-06, -4.581334731941658e-09,  1.003845029171522e-11, -1.672698836400879e-14,  1.176111502656176e-17,
  5.437622363017137e-20, -3.195038770351400e-22,  1.062340065626043e-24, -2.572296155104516e-27,  4.059118712953929e-30,  1.521707203526025e-01, -6.731906122984063e-04,
  2.100567912307355e-06, -5.279975055052896e-09,  1.046016953632631e-11, -1.301195504179068e-14, -9.793230807764926e-18,  1.277924631678019e-19, -4.928571987808592e-22,
  1.271419302676874e-24, -2.065570736155522e-27, -3.611833757023518e-31,  1.857219176203877e-01, -8.128370482009405e-04,  2.469790394169059e-06, -5.861340281382397e-09,
  1.010901904936886e-11, -6.357420272167132e-15, -3.858525317871121e-17,  2.071053029688982e-19, -6.159707596652498e-22,  1.139652743223307e-24, -2.658102931423042e-28,
 -8.023009348155189e-30,  2.225464292316488e-01, -9.622696799622294e-04,  2.835595525797260e-06, -6.272874086798382e-09,  8.830613921568730e-12,  3.300404127344706e-15,
 -7.239996969342143e-17,  2.772921239719481e-19, -6.293958942252311e-22,  5.233317391081881e-25,  2.857537691057803e-27, -1.717160190781946e-29,  2.626143762464798e-01,
 -1.120185088705895e-03,  3.186576961935350e-06, -6.462027650432176e-09,  6.509386749608886e-12,  1.570231444729690e-14, -1.075068012149871e-16,  3.193930974419043e-19,
 -4.763860189363337e-22, -6.309468558474687e-25,  6.794968124844700e-27, -2.411276624406629e-29,  3.058898740506691e-01, -1.285111133924081e-03,  3.510443611764167e-06,
 -6.378280519098293e-09,  3.084632970020998e-12,  3.020674429024699e-14, -1.387181856299540e-16,  3.127781211123388e-19, -1.188629706589075e-22, -2.222159858729433e-24,
  1.038888502895140e-26, -2.377115292031429e-29,  3.523299561832441e-01, -1.455394011832108e-03,  3.794128544763525e-06, -5.975575193235662e-09, -1.432535657508218e-12,
  4.574889479957576e-14, -1.596713065677075e-16,  2.386578691123361e-19,  4.438272338040884e-22, -3.946083222933540e-24,  1.191932342161064e-26, -1.129624495995041e-29,
  4.018833054146896e-01, -1.629184686278727e-03,  4.023943331739761e-06, -5.215211028475493e-09, -6.942099237012812e-12,  6.082947400235430e-14, -1.633884075927731e-16,
  8.476044340281582e-20,  1.156563565459265e-21, -5.286177128686346e-24,  9.473773966714851e-27,  1.531839744454120e-29,  4.544887603765572e-01, -1.804425085210485e-03,
  4.185790947767785e-06, -4.069229766923865e-09, -1.323910016289909e-11,  7.354664303230527e-14, -1.431594286392238e-16, -1.491783579428179e-19,  1.895533553774311e-21,
 -5.571594217860434e-24,  1.641723718737085e-27,  5.216204554951606e-29,  5.100735610049507e-01, -1.978834652283270e-03,  4.265453017498640e-06, -2.524298938836702e-09,
 -2.000044569132067e-11,  8.168688129249149e-14, -9.376265794989754e-17, -4.458519426011643e-19,  2.467562355313500e-21, -4.125863060029522e-24, -1.153340623024242e-26,
  8.713910071221975e-29,  5.685512906696849e-01, -2.149898113233178e-03,  4.248969966252866e-06, -5.860543365218946e-10, -2.677703253086527e-11,  8.289144489570486e-14,
 -1.298709497942930e-17, -7.659861751630324e-19,  2.629591260786952e-21, -5.137570657240510e-25, -2.758447873120428e-26,  1.004295665746973e-28,  6.298194673477127e-01,
 -2.314855682449680e-03,  4.123135266507170e-06,  1.716209423848013e-09, -3.299454274250284e-11,  7.491364241056804e-14,  9.666403607540455e-17, -1.046905373587796e-18,
  2.135554412585793e-21,  5.139460485614992e-24, -4.108761667474688e-26,  6.978611897768324e-29,  6.937567309843059e-01, -2.470697423825742e-03,  3.876126918406611e-06,
  4.324720847179802e-09, -3.796720127618309e-11,  5.597639496025669e-14,  2.263322512862066e-16, -1.206342481620228e-18,  8.139872388558832e-22,  1.183525508773596e-23,
 -4.420514198421969e-26, -1.819255834041785e-29,  7.602195699808780e-01, -2.614164122217490e-03,  3.498299693912964e-06,  7.148665524263719e-09, -4.092966672598537e-11,
  2.522686955805480e-14,  3.596305435200710e-16, -1.153932449811946e-18, -1.329237539107760e-21,  1.754147821496725e-23, -2.894923082503553e-26, -1.525172955224242e-28,
  8.290385277025936e-01, -2.741757849813983e-03,  2.983159093468379e-06,  1.006047166087980e-08, -4.109276948555633e-11, -1.673783904912330e-14,  4.725274656825818e-16,
 -8.122398750320334e-19, -4.003930645151089e-21,  1.938996273525023e-23,  8.586609296368085e-27, -2.846237205193252e-28,  9.000138317959290e-01, -2.849766452838018e-03,
  2.328530247196504e-06,  1.289383565740467e-08, -3.772852868148615e-11, -6.733616474456596e-14,  5.350393381770547e-16, -1.472613962778246e-19, -6.566225333895979e-21,
  1.444289737694357e-23,  6.281272981903261e-26, -3.298197221918859e-28,  9.729103976313449e-01, -2.934307449463405e-03,  1.537918983042670e-06,  1.544473009959725e-08,
 -3.028800081177222e-11, -1.215720428143318e-13,  5.155260127323063e-16,  7.955029481191883e-19, -8.050156294400897e-21,  1.116388790022130e-24,  1.145293166972797e-25,
 -1.977697812655938e-28,  1.047452176259654e+00, -2.991398293706728e-03,  6.220336380747878e-07,  1.747702581445208e-08, -1.855094008194134e-11, -1.718860696102887e-13,
  3.881565482152767e-16,  1.859382514555474e-18, -7.372329563098175e-21, -1.898084889417766e-23,  1.324234148233637e-25,  1.423549782765184e-28,  1.123315852429374e+00,
 -3.017061524277910e-03, -3.996106102114854e-07,  1.873470727751583e-08, -2.797623072883771e-12, -2.085271564000980e-13,  1.433908692584246e-16,  2.766745222195092e-18,
 -3.754971391385926e-21, -3.959406787428809e-23,  8.487829771895225e-26,  5.833310136022207e-28,  1.200123956968496e+00, -3.007474757020619e-03, -1.497154210820087e-06,
  1.896281079110482e-08,  1.602077588458832e-11, -2.207161087604499e-13, -2.001075849379027e-16,  3.154465191307232e-18,  2.678590757645214e-21, -5.016894074347549e-23,
 -3.684870277343204e-26,  8.508896500103145e-28,  1.277437549848518e+00, -2.959176363784831e-03, -2.629172334836561e-06,  1.793889665222895e-08,  3.615653288541325e-11,
 -1.988201484370859e-13, -5.859086165239594e-16,  2.675944686144842e-18,  1.035239390279911e-20, -3.956071465402894e-23, -1.928947297429764e-25,  6.133401185351039e-28,
  1.354748766996269e+00, -2.869337270929076e-03, -3.742150848025762e-06,  1.551566919236453e-08,  5.505083762610073e-11, -1.375424606742994e-13, -9.188991630353845e-16,
  1.171374546196188e-18,  1.615468655572635e-20, -3.474606687969418e-24, -2.891591637055029e-25, -2.342805000243865e-28,  1.431473717279580e+00, -2.736106455328372e-03,
 -4.771188954958985e-06,  1.167275737274428e-08,  6.951591131417531e-11, -3.967385097606917e-14, -1.080755611981186e-15, -1.137326927861364e-18,  1.633912356766424e-20,
  4.723027682578539e-23, -2.199630654267967e-25, -1.261723012462896e-27,  1.506946474986723e+00, -2.559030793036710e-03, -5.642594576229859e-06,  6.571176875794982e-09,
  7.619898382963877e-11,  8.075984140235595e-14, -9.672807697754924e-16, -3.535847929325350e-18,  8.623626719676793e-21,  8.461239032440134e-23,  3.747484781686731e-26,
 -1.556959553179435e-27,  1.580415237039410e+00, -2.339536940998939e-03, -6.279094450652629e-06,  5.975485345939952e-10,  7.236909133606467e-11,  1.979136025207748e-13,
 -5.439020437398693e-16, -4.947855045001549e-18, -5.233760969022118e-21,  7.656914412023540e-23,  3.387493232947442e-25, -4.717318477113265e-28,  1.651042082542831e+00,
 -2.081442024521860e-03, -6.608244784679753e-06, -5.622191414491386e-09,  5.695264538479521e-11,  2.784128392362224e-13,  1.014452768361790e-16, -4.414569793356953e-18,
 -1.840986784122597e-20,  1.439675446492084e-23,  4.207800226451769e-25,  1.343622814472578e-27,  1.717908129588576e+00, -1.791430370502533e-03, -6.574150341510075e-06,
 -1.126498248546750e-08,  3.154973578160326e-11,  2.918533015788062e-13,  7.472432440787953e-16, -1.806954192809167e-18, -2.197406478050241e-20, -6.507433318569025e-23,
  1.422778268040864e-25,  2.015051954279672e-27,  1.780026124034330e+00, -1.479397758483010e-03, -6.151640124506505e-06, -1.543134732501901e-08,  9.391897246241850e-13,
  2.257266140281140e-13,  1.109651661928890e-15,  1.702066994534987e-18, -1.185743010443751e-20, -9.618481008704718e-23, -2.762639188946138e-25,  5.092198140549063e-28,
  1.836362451375665e+00, -1.158530613828124e-03, -5.360589402984328e-06, -1.734940436581294e-08, -2.752844094516229e-11,  9.809859435633014e-14,  9.971613829027419e-16,
  4.049326665177201e-18,  5.346988876475273e-21, -4.688012104987011e-23, -3.938561715064805e-25, -1.450766770256007e-27,  1.885870026082832e+00, -8.449706648366402e-04,
 -4.276403418144664e-06, -1.663007742480378e-08, -4.601979415883875e-11, -4.228899449685454e-14,  4.685703747057157e-16,  3.726940199458046e-18,  1.575237229102247e-20,
  3.310325425132129e-23, -9.066601263829165e-26, -1.297685379048059e-27,  1.927532291584190e+00, -5.569375063479725e-04, -3.031523510847793e-06, -1.349265574167834e-08,
 -4.943299056316490e-11, -1.358714260133424e-13, -1.497146525839479e-16,  1.243005247784908e-18,  1.143044655114658e-20,  5.888378841248035e-23,  2.079416436334448e-25,
  3.610252225921287e-28,  1.960416615981242e+00, -3.132625238086868e-04, -1.803297822905398e-06, -8.844659748868294e-09, -3.835393860469081e-11, -1.465889173064040e-13,
 -4.731851644904419e-16, -1.101832194273635e-18, -1.750793490917434e-22,  1.818850714547347e-23,  1.426162692802684e-25,  7.624214428943645e-28,  1.983733079362543e+00,
 -1.314305168181174e-04, -7.866339286615679e-07, -4.116365440718342e-09, -1.976810441528086e-11, -8.868173618525876e-14, -3.733203052189778e-16, -1.467752850851002e-18,
 -5.303363721736180e-21, -1.693275114119900e-23, -4.264889388918635e-26, -4.221594711594982e-29,  1.996895386109817e+00, -2.537844943614037e-05, -1.552328615140340e-07,
 -8.414635126508361e-10, -4.260138534534006e-12, -2.061174858137283e-14, -9.643766160977024e-17, -4.392481375616835e-19, -1.955169942920643e-21, -8.523413432025785e-24,
 -3.642782731436286e-26, -1.526409279544616e-28,  4.153467522036828e-04, -1.905072258998358e-06,  6.552294241473164e-09, -2.002889932944437e-11,  5.737912787494168e-14,
 -1.577721027245366e-16,  4.215520750545604e-19, -1.103158487244088e-21,  2.839330814777275e-24, -7.218430867427570e-27,  1.813807613275111e-29, -4.525250551863473e-32,
  3.737910640541338e-03, -1.712899103927695e-05,  5.879074540181992e-08, -1.790488004201856e-10,  5.100076391174252e-13, -1.390823391415682e-15,  3.674605565343638e-18,
 -9.475352759062016e-21,  2.393290462399815e-23, -5.943292201879322e-26,  1.450733559105606e-28, -3.495085463918833e-31,  1.038190769178804e-02, -4.748776696091656e-05,
  1.623075696995809e-07, -4.906418542784713e-10,  1.381318367328525e-12, -3.703447586984368e-15,  9.556649921438318e-18, -2.387501842065329e-20,  5.783825210937005e-23,
 -1.360419222428645e-25,  3.093409417134990e-28, -6.797043975733408e-31,  2.034502801087806e-02, -9.280225664705143e-05,  3.151798016952457e-07, -9.419802055136416e-10,
  2.604437822872920e-12, -6.797605409966540e-15,  1.687936700601086e-17, -3.995180142241594e-20,  8.969679803333893e-23, -1.892251635095793e-25,  3.650473168064504e-28,
 -6.126958187898169e-31,  3.362368439262136e-02, -1.528011852704249e-04,  5.145162214547365e-07, -1.513990400135943e-09,  4.081629871570166e-12, -1.024852669178507e-14,
  2.400797581992428e-17, -5.200516722526040e-20,  1.012924246825514e-22, -1.655011223325251e-25,  1.689293895493970e-28,  1.936101632896588e-31,  5.021286194257125e-02,
 -2.271180485921741e-04,  7.564499515873078e-07, -2.181567333095640e-09,  5.687457463165392e-12, -1.353141909207698e-14,  2.903315277741017e-17, -5.390977408196901e-20,
  7.540484016285136e-23, -2.406125878586882e-26, -3.496383436319742e-28,  1.756838791773494e-30,  7.010591154901494e-02, -3.152869398436512e-04,  1.036129848024575e-06,
 -2.913879786362622e-09,  7.273116447142565e-12, -1.605694313438567e-14,  2.999075540633499e-17, -4.023884807143428e-20,  7.329179677916269e-25,  2.444806788508850e-25,
 -1.127064682636440e-27,  3.603267094342627e-30,  9.329428180886122e-02, -4.167372677021701e-04,  1.347711881030168e-06, -3.674785621781726e-09,  8.672035692558620e-12,
 -1.721518323518453e-14,  2.511991625601821e-17, -7.485920107052285e-21, -1.233472679544359e-22,  6.032733569046530e-25, -1.934039788415935e-27,  4.769539365185222e-30,
  1.197671823592256e-01, -5.307873269962301e-04,  1.684352153084461e-06, -4.423380011596801e-09,  9.706850693826035e-12, -1.642757188189398e-14,  1.314612138017100e-17,
  4.474449868218421e-20, -2.830686480662250e-22,  9.630188430759694e-25, -2.393932718394621e-27,  4.036395837616718e-30,  1.495111697024335e-01, -6.566366824917044e-04,
  2.038203761913397e-06, -5.114705840594380e-09,  1.019786086027822e-11, -1.320579476330572e-14, -6.429074740346023e-18,  1.127374075226332e-19, -4.485749567759355e-22,
  1.188716232575195e-24, -2.064042975651041e-27,  3.999171297712604e-31,  1.825096444807522e-01, -7.933573297084584e-04,  2.400420423031536e-06, -5.700661546951656e-09,
  9.973068547276475e-12, -7.216068497387341e-15, -3.305611026743159e-17,  1.880479679982583e-19, -5.752148891207134e-22,  1.122486859256795e-24, -5.799303192638703e-28,
 -6.298989723396148e-30,  2.187422466985949e-01, -9.398836073688488e-04,  2.761170655256258e-06, -6.131148009847949e-09,  8.879863224404177e-12,  1.653717273829132e-15,
 -6.491477837737978e-17,  2.574735204009675e-19, -6.086739935198570e-22,  6.232460151452202e-25,  2.155689194975441e-27, -1.476715191468509e-29,  2.581841325388886e-01,
 -1.095000856812747e-03,  3.109667448909830e-06, -6.355502271615905e-09,  6.798346804711167e-12,  1.322772552399878e-14, -9.878026794549083e-17,  3.038357393372343e-19,
 -4.944576402573913e-22, -3.797321038243086e-25,  5.781538134084685e-27, -2.194875442524032e-29,  3.008051131070125e-01, -1.257332858720938e-03,  3.434219728921084e-06,
 -6.324271232009505e-09,  3.656182347350990e-12,  2.698210037423876e-14, -1.300251152005331e-16,  3.077727032700625e-19, -1.916320048593861e-22, -1.827429219234046e-24,
  9.350816715472978e-27, -2.333794062374523e-29,  3.465686315888142e-01, -1.425328132535998e-03,  3.722313645114417e-06, -5.991381852724018e-09, -5.553298499151203e-13,
  4.199844936743785e-14, -1.528107577053960e-16,  2.506783850659889e-19,  3.102218413545586e-22, -3.480173371569098e-24,  1.135507594165069e-26, -1.419459196243909e-29,
  3.954305508612421e-01, -1.597245266924291e-03,  3.960733817552563e-06, -5.316764078975999e-09, -5.764509860796965e-12,  5.694064066861248e-14, -1.605250550654081e-16,
  1.187999641752623e-19,  9.732248844702421e-22, -4.895909954313973e-24,  9.988182448153725e-27,  8.259959690078054e-30,  4.473377184914545e-01, -1.771137571120907e-03,
  4.135737169439295e-06, -4.269475885770356e-09, -1.180282926237664e-11,  7.006736229340565e-14, -1.465172616386086e-16, -9.171354259722530e-20,  1.696663479482209e-21,
 -5.463070474101976e-24,  3.710438752626316e-27,  4.200087081693281e-29,  5.022262702798821e-01, -1.944837511264298e-03,  4.233294893519462e-06, -2.831362521165177e-09,
 -1.839017677517359e-11,  7.929555371110901e-14, -1.051639657452602e-16, -3.693481467099090e-19,  2.311626258279957e-21, -4.513270276852743e-24, -7.906056682904134e-27,
  7.765812987243341e-29,  5.600196270796347e-01, -2.115941641614696e-03,  4.239421353074139e-06, -1.001248282413894e-09, -2.512400875014983e-11,  8.233186737368760e-14,
 -3.326089978212241e-17, -6.823395175175876e-19,  2.592295382705729e-21, -1.529316787403669e-24, -2.321189573529323e-26,  9.791411968500979e-29,  6.206261326952888e-01,
 -2.281797082142139e-03,  4.140612127909842e-06,  1.200399147127450e-09, -3.147540431312423e-11,  7.688970100695330e-14,  6.833300316934074e-17, -9.759182726847379e-19,
  2.291765144269971e-21,  3.560955617420860e-24, -3.775655859245665e-26,  8.092286220193748e-29,  6.839362735335994e-01, -2.439491062011749e-03,  3.924416586457216e-06,
  3.726485560706308e-09, -3.679607278353903e-11,  6.100636275282488e-14,  1.929809408840653e-16, -1.173820101432675e-18,  1.208113199177466e-21,  1.005948045459053e-23,
 -4.438230081867488e-26,  9.439066955049369e-30,  7.498194139230242e-01, -2.585845680253604e-03,  3.580172570803643e-06,  6.498285049485922e-09, -4.034145751799260e-11,
  3.346604997335774e-14,  3.268182048970280e-16, -1.186600102483251e-18, -7.201029723130927e-22,  1.626049616966513e-23, -3.482406915931981e-26, -1.146716480371030e-28,
  8.181199756365081e-01, -2.717420873137495e-03,  3.099930774773599e-06,  9.400917485953606e-09, -4.131603391655484e-11, -5.683923923913743e-15,  4.480962598355463e-16,
 -9.291547586276236e-19, -3.302653364267005e-21,  1.949121756975293e-23, -3.308694771124670e-27, -2.551130263790396e-28,  8.886529877830447e-01, -2.830529666735482e-03,
  2.479592149624244e-06,  1.228010128065519e-08, -3.894729713411424e-11, -5.456794686918288e-14,  5.280558070058276e-16, -3.486051459124283e-19, -6.004579022080928e-21,
  1.666252303905711e-23,  4.812665539096434e-26, -3.355925523647331e-28,  9.611989364680299e-01, -2.921271169276998e-03,  1.720270055627089e-06,  1.494134985593875e-08,
 -3.259406139434881e-11, -1.089611705799111e-13,  5.342058665134088e-16,  5.394069668355927e-19, -7.929778445710683e-21,  5.504381407758151e-24,  1.044219882228650e-25,
 -2.593016358618733e-28,  1.035497856413225e+00, -2.985588431111195e-03,  8.298652995624373e-07,  1.715323237212468e-08, -2.189142714240178e-11, -1.619728128329994e-13,
  4.368210807511018e-16,  1.613567644421028e-18, -7.959076934628708e-21, -1.359058393210508e-23,  1.363047071980938e-25,  3.463555062034511e-29,  1.111242634909765e+00,
 -3.019360219780510e-03, -1.751996455922946e-07,  1.865679402352287e-08, -6.927553086705626e-12, -2.041710195358547e-13,  2.189681798895365e-16,  2.624483826328125e-18,
 -5.113303736497424e-21, -3.571267076781618e-23,  1.084871739217379e-25,  4.867092696976795e-28,  1.188071550354371e+00, -3.018537755172237e-03, -1.268208922301509e-06,
  1.918359787087541e-08,  1.156562516072471e-11, -2.244507818813485e-13, -1.108556676640075e-16,  3.211071849894978e-18,  8.550439456121034e-22, -5.088988566399918e-23,
  8.380887843260504e-28,  8.559235451721643e-28,  1.265560154471744e+00, -2.979339147888564e-03, -2.410568172838652e-06,  1.848485206092359e-08,  3.204576858303795e-11,
 -2.119467713869704e-13, -5.065686915198372e-16,  2.983001021305364e-18,  8.796291478944276e-21, -4.668623454122958e-23, -1.621816451553732e-25,  7.778967215357958e-28,
  1.343212743543996e+00, -2.898514968554043e-03, -3.550772563764462e-06,  1.637328975634346e-08,  5.208241040724350e-11, -1.591442392004342e-13, -8.788981911380194e-16,
  1.684075094262800e-18,  1.581959646429637e-20, -1.517276272490238e-23, -2.938738049171475e-25,  2.291735718221803e-29,  1.420453866167557e+00, -2.773696835796059e-03,
 -4.624473115835885e-06,  1.277724508740553e-08,  6.846078527301937e-11, -6.593353753688707e-14, -1.105037954361417e-15, -5.890750399260787e-19,  1.786797069752276e-20,
  3.735647420710815e-23, -2.727327621579549e-25, -1.125229835801251e-27,  1.496620599122527e+00, -2.603835292637467e-03, -5.556376226116448e-06,  7.801987793435847e-09,
  7.757418709850127e-11,  5.639106256194985e-14, -1.061961936229437e-15, -3.211003464444951e-18,  1.167959655181431e-20,  8.468189137690095e-23, -3.536139509435671e-26,
 -1.743597013168210e-27,  1.570956697358151e+00, -2.389721033896041e-03, -6.264848239384040e-06,  1.786363513569283e-09,  7.618551849729355e-11,  1.831811882510710e-13,
 -6.843539436591500e-16, -5.068664274612611e-18, -2.239480675438017e-21,  8.958200126533157e-23,  3.088127973654129e-25, -8.943870455482723e-28,  1.642610177670218e+00,
 -2.134561933034178e-03, -6.670059564417158e-06, -4.666313966497125e-09,  6.253489521226573e-11,  2.792982581830601e-13, -3.030856958408504e-17, -4.992032300592629e-18,
 -1.757489047885723e-20,  3.235219681119530e-23,  4.753531299499005e-25,  1.118429138180091e-27,  1.710636378270268e+00, -1.844555261009426e-03, -6.706105627669608e-06,
 -1.071253443856906e-08,  3.756162233983556e-11,  3.090984236403252e-13,  6.864608251939917e-16, -2.546329916914546e-18, -2.419212170849236e-20, -5.752146324980488e-23,
  2.374756110807253e-25,  2.304245266724565e-27,  1.774008934800951e+00, -1.529350976108467e-03, -6.336572421133009e-06, -1.537874165484638e-08,  5.723663249479091e-12,
  2.528839974400764e-13,  1.151461942602933e-15,  1.265145501008218e-18, -1.551242167829541e-20, -1.066572458800986e-22, -2.439746734489848e-25,  9.737030901573157e-28,
  1.831641230571718e+00, -1.202255430446953e-03, -5.571355922500180e-06, -1.777282447101441e-08, -2.531787355202849e-11,  1.234087047914608e-13,  1.112661862703841e-15,
  4.190261632274106e-18,  3.360305132372182e-21, -6.391421687431927e-23, -4.577828313599001e-25, -1.441276103832297e-27,  1.882420439331783e+00, -8.799927134113822e-04,
 -4.480408079534311e-06, -1.737251283560541e-08, -4.674436550579067e-11, -2.973301977415068e-14,  5.801552508356245e-16,  4.249265851974525e-18,  1.686411549447428e-20,
  2.823136594581684e-23, -1.555770146126763e-25, -1.661286634355836e-27,  1.925254992484711e+00, -5.818509954148802e-04, -3.198271220198814e-06, -1.430550564407509e-08,
 -5.218330932873966e-11, -1.390035785705620e-13, -1.094593685611917e-16,  1.644331515417925e-18,  1.370358199647644e-20,  6.749344596223297e-23,  2.218071924424099e-25,
  2.599620167829599e-28,  1.959134025899910e+00, -3.281241092072502e-04, -1.913214494087988e-06, -9.482404519451337e-09, -4.140178090143770e-11, -1.583155638965920e-13,
 -5.040082219322973e-16, -1.095788741782908e-18,  5.909030258987546e-22,  2.461143528063494e-23,  1.797496808272359e-25,  9.298978464443315e-28,  1.983194450535898e+00,
 -1.379266887427726e-04, -8.379881978506197e-07, -4.447345324182841e-09, -2.163476641826479e-11, -9.815434053691181e-14, -4.168872985628977e-16, -1.647546243325145e-18,
 -5.944036712316518e-21, -1.866899965975917e-23, -4.397207483200584e-26, -1.586033094853431e-29,  1.996791322956807e+00, -2.666189350270915e-05, -1.657534198119519e-07,
 -9.130536762572749e-10, -4.696552538765110e-12, -2.308120364128924e-14, -1.096607380747802e-16, -5.070179714041804e-19, -2.289943666420814e-21, -1.012419356063110e-23,
 -4.385470667611161e-26, -1.861017721125646e-28,  4.078297994010498e-04, -1.853599921405211e-06,  6.317353468586683e-09, -1.913553743635531e-11,  5.432240841543112e-14,
 -1.480154823570654e-16,  3.918975676865244e-19, -1.016321493640921e-21,  2.592060858218191e-24, -6.531202025684340e-27,  1.626000784584250e-29, -4.022020185605937e-32,
  3.670321913696227e-03, -1.666712277976662e-05,  5.669021786544928e-08, -1.711065069245864e-10,  4.830520255370098e-13, -1.305731972658786e-15,  3.419703792375275e-18,
 -8.742642603640474e-21,  2.189416977523609e-23, -5.392623007441825e-26,  1.305332301064611e-28, -3.121553762628986e-31,  1.019451677938382e-02, -4.621248704311910e-05,
  1.565500694912808e-07, -4.691210737282118e-10,  1.309489925012673e-12, -3.481905293284104e-15,  8.913341376835782e-18, -2.210022370782416e-20,  5.315643951989127e-23,
 -1.242468926552705e-25,  2.808817155046059e-28, -6.150012928523432e-31,  1.997879125728094e-02, -9.032533506748938e-05,  3.041216491136005e-07, -9.013751811041593e-10,
  2.472447801975672e-12, -6.405606258402758e-15,  1.579989643491120e-17, -3.718773153405015e-20,  8.314112218615313e-23, -1.751522281721376e-25,  3.388523317305558e-28,
 -5.779854167837975e-31,  3.302059839487360e-02, -1.487566322114649e-04,  4.967335091658010e-07, -1.450293268630592e-09,  3.882305173974386e-12, -9.689448193107341e-15,
  2.259632383834603e-17, -4.885781907204089e-20,  9.545782645743190e-23, -1.585996717355367e-25,  1.755297624188423e-28,  1.093418650791534e-31,  4.931632930548410e-02,
 -2.211696375473505e-04,  7.308083300155442e-07, -2.092695689835184e-09,  5.423676176052412e-12, -1.285246533883362e-14,  2.755731185915616e-17, -5.151323145244458e-20,
  7.430477307491276e-23, -3.658276442675245e-26, -2.783947294642042e-28,  1.487949427390269e-30,  6.886112317336131e-02, -3.071358131558996e-04,  1.001851037819274e-06,
 -2.800040309089791e-09,  6.959084151143025e-12, -1.535067477849319e-14,  2.886565886125912e-17, -4.008297242065791e-20,  8.759767162039152e-24,  2.024402837266130e-25,
 -9.780558215768808e-28,  3.177473086697049e-30,  9.164862014027186e-02, -4.061296295247140e-04,  1.304435712867373e-06, -3.538754802686226e-09,  8.333741607819734e-12,
 -1.661524699441421e-14,  2.485821172424823e-17, -1.110007486576276e-20, -1.029724741172358e-22,  5.299868039524770e-25, -1.733278281811527e-27,  4.359010864805631e-30,
  1.176706502034617e-01, -5.175222166052163e-04,  1.632192665064126e-06, -4.270681261498267e-09,  9.381550649412670e-12, -1.609802301174962e-14,  1.427723469114548e-17,
  3.622286583128221e-20, -2.500809858202662e-22,  8.707922733571774e-25, -2.218023391161623e-27,  3.950476912800628e-30,  1.469168494044653e-01, -6.405738045806553e-04,
  1.977797546351264e-06, -4.953660332927083e-09,  9.932449458268908e-12, -1.332379586236295e-14, -3.467068927838278e-18,  9.905182076194985e-20, -4.072613372523103e-22,
  1.106691449710267e-24, -2.032905271066045e-27,  9.894874239683208e-31,  1.793741924532646e-01, -7.744248966435529e-04,  2.332965001616897e-06, -5.542288373050623e-09,
  9.821229611861161e-12, -7.948273838176029e-15, -2.804242345953093e-17,  1.702826521049981e-19, -5.352855729640341e-22,  1.094197060255370e-24, -8.238460530405798e-28,
 -4.827605818680359e-30,  2.150264284448583e-01, -9.180861199327728e-04,  2.688450169863671e-06, -5.988887840543554e-09,  8.897930688157443e-12,  1.800940263759825e-16,
 -5.797472126416875e-17,  2.383703530254246e-19, -5.848356090786516e-22,  6.971367572543633e-25,  1.554734925497390e-27, -1.258584789481962e-29,  2.538534034086842e-01,
 -1.070426712896670e-03,  3.034062383820303e-06, -6.244738235923751e-09,  7.039873861978162e-12,  1.095728886117111e-14, -9.049613191449084e-17,  2.878371517979209e-19,
 -5.041922295076692e-22, -1.671484813882794e-25,  4.863350829815060e-27, -1.979284902187121e-29,  2.958302499998541e-01, -1.230161631501394e-03,  3.358696734576600e-06,
 -6.261621814366448e-09,  4.165312525747029e-12,  2.396415804018608e-14, -1.215027175969270e-16,  3.006580723064245e-19, -2.509323858181337e-22, -1.473713758814385e-24,
  8.341039480028240e-27, -2.250443942541425e-29,  3.409264206012732e-01, -1.395837298198777e-03,  3.650390831286134e-06, -5.993744238463928e-09,  2.485384116545577e-13,
  3.841622822067168e-14, -1.456710005285802e-16,  2.586873034166532e-19,  1.929546815159320e-22, -3.039114651778598e-24,  1.068317994385277e-26, -1.621233427717380e-29,
  3.891045353593870e-01, -1.565816083810672e-03,  3.896416161661365e-06, -5.400093866682266e-09, -4.663936115691249e-12,  5.313131523100704e-14, -1.567885946628369e-16,
  1.472008255614849e-19,  8.042345004220994e-22, -4.490932605927915e-24,  1.021770437218869e-26,  2.357436797554066e-30,  4.403190111280748e-01, -1.738259713720267e-03,
  4.083416010646063e-06, -4.447302199561926e-09, -1.043682322550552e-11,  6.652608678581371e-14, -1.483544774038620e-16, -4.053494963698206e-20,  1.503084179245082e-21,
 -5.280497222981679e-24,  5.350431325609976e-27,  3.269441218591113e-29,  4.945144308655072e-01, -1.911111940023801e-03,  4.197604967898219e-06, -3.113058562537494e-09,
 -1.683030017915390e-11,  7.665572424724608e-14, -1.144949283895581e-16, -2.980302728617177e-19,  2.144253541798273e-21, -4.764043624590939e-24, -4.703900614632113e-27,
  6.787555136597886e-29,  5.516236056769359e-01, -2.082081039606955e-03,  4.225048650038997e-06, -1.390109023790399e-09, -2.348685335836979e-11,  8.131365637062541e-14,
 -5.121456372791279e-17, -6.004377925550781e-19,  2.521554593704072e-21, -2.372875738243786e-24, -1.900046331915537e-26,  9.319816657867469e-29,  6.115652734593073e-01,
 -2.248623009864024e-03,  4.152046289679011e-06,  7.091749962818639e-10, -2.992338046109894e-11,  7.821017977187980e-14,  4.205123715730782e-17, -9.008150467473754e-19,
  2.393654961445104e-21,  2.124269770453606e-24, -3.402618814500181e-26,  8.800752568701859e-29,  6.742413691583954e-01, -2.407926772235515e-03,  3.965643039214284e-06,
  3.147749969349979e-09, -3.553226837400960e-11,  6.524819271418137e-14,  1.607072187164199e-16, -1.129707601981056e-18,  1.538465186531362e-21,  8.299664639908960e-24,
 -4.343906577414320e-26,  3.269940584660261e-29,  7.395337924121719e-01, -2.556903301300294e-03,  3.654302648585135e-06,  5.858591131683717e-09, -3.959640255615766e-11,
  4.090891640920745e-14,  2.933568270277450e-16, -1.200555411420901e-18, -1.609154995846765e-22,  1.477745823481191e-23, -3.906336878237131e-26, -7.837894872313322e-29,
  8.073005896340633e-01, -2.692181425749258e-03,  3.208773562049564e-06,  8.739526780863065e-09, -4.132433558939518e-11,  4.746894828355560e-15,  4.207055179301360e-16,
 -1.023659642203340e-18, -2.605968133486741e-21,  1.914418947905171e-23, -1.379256878778687e-26, -2.208000926380017e-28,  8.773714608186913e-01, -2.810114156829465e-03,
  2.623180630137488e-06,  1.164889853765073e-08, -3.991282312977015e-11, -4.203288455671963e-14,  5.156974709107282e-16, -5.308113585534678e-19, -5.373627422332175e-21,
  1.829333430788252e-23,  3.346116263630143e-26, -3.291316154099609e-28,  9.495424989256529e-01, -2.906800850695374e-03,  1.896367578912361e-06,  1.440311231268431e-08,
 -3.464399933457103e-11, -9.598745177210107e-14,  5.457921241828376e-16,  2.896074913100467e-19, -7.659323715870749e-21,  9.438222111734796e-24,  9.192981952041980e-26,
 -3.060059270860142e-28,  1.023570075453084e+00, -2.978132350452802e-03,  1.033497494811816e-06,  1.677763834044066e-08, -2.502253728873417e-11, -1.509761426048858e-13,
  4.783692665069494e-16,  1.352102419158333e-18, -8.350110640340809e-21, -8.138492168146279e-24,  1.355569682302745e-25, -6.729906131533406e-29,  1.099163805685807e+00,
 -3.019868483488769e-03,  4.788307707704966e-08,  1.851359598303972e-08, -1.095256927111811e-11, -1.980536033599383e-13,  2.899758943907420e-16,  2.441165112831334e-18,
 -6.315978975298115e-21, -3.097702462188179e-23,  1.274757311974543e-25,  3.743052086092650e-28,  1.175978569934766e+00, -3.027759809955242e-03, -1.037043969992929e-06,
  1.933262179592270e-08,  7.057295676163687e-12, -2.260309966768246e-13, -2.083754114110117e-17,  3.209200459308537e-18, -9.673696706163147e-22, -5.010996901487328e-23,
  3.792332324267435e-26,  8.237776418945365e-28,  1.253605645513784e+00, -2.997728030230795e-03, -2.185815500011739e-06,  1.896304125936344e-08,  2.769217975315592e-11,
 -2.230719202799695e-13, -4.193651165015657e-16,  3.236408504994705e-18,  7.007445542306122e-21, -5.244768114721634e-23, -1.249358657411582e-25,  9.088743944699270e-28,
  1.331563135350224e+00, -2.926121314001742e-03, -3.349401876685151e-06,  1.718001621564164e-08,  4.869270273957524e-11, -1.796153285781375e-13, -8.247551646063123e-16,
  2.179300630775435e-18,  1.506274556120866e-20, -2.682897519498258e-23, -2.869837979834484e-25,  2.908270318505206e-28,  1.409286084470136e+00, -2.810060801228882e-03,
 -4.464622135707452e-06,  1.386062288585597e-08,  6.687590829906601e-11, -9.258660206253258e-14, -1.113340587700596e-15,  2.018249007659335e-21,  1.900500221247280e-20,
  2.551260834587631e-23, -3.179626740972374e-25, -9.196806797573775e-28,  1.486116978773413e+00, -2.647890630284503e-03, -5.455272599876715e-06,  9.050782785680693e-09,
  7.844008510319220e-11,  2.987011568546773e-14, -1.146182103385858e-15, -2.788905144864454e-18,  1.468382313437737e-20,  8.169328632207513e-23, -1.149124426355362e-25,
 -1.859151795844139e-27,  1.561297741029102e+00, -2.439733079503893e-03, -6.235980190684154e-06,  3.033700041710771e-09,  7.967337268274588e-11,  1.650485874863853e-13,
 -8.267784997668975e-16, -5.086429119664548e-18,  1.197151366011148e-21,  1.010175484146284e-22,  2.597296017397220e-25, -1.338122741614077e-27,  1.633964878917687e+00,
 -2.188128959092367e-03, -6.719867905820144e-06, -3.621156096577503e-09,  6.810194100234435e-11,  2.768311885071151e-13, -1.777572398963477e-16, -5.532033281921602e-18,
 -1.605691864316627e-20,  5.225865768188557e-23,  5.174825026769819e-25,  7.768582376584511e-28,  1.703150060433838e+00, -1.898707615404082e-03, -6.830843290693602e-06,
 -1.006122342715784e-08,  4.390210636733772e-11,  3.246285950247453e-13,  6.040284519362068e-16, -3.351574135447258e-18, -2.606681233493801e-20, -4.592269851313218e-23,
  3.441039500205831e-25,  2.529023768579404e-27,  1.767788979670435e+00, -1.580779784046161e-03, -6.520396051726524e-06, -1.524518910796162e-08,  1.106025822499108e-11,
  2.808844670935294e-13,  1.179346325089970e-15,  7.055230175371067e-19, -1.951600195336582e-20, -1.154024872142626e-22, -1.892485137528552e-25,  1.528067601846590e-27,
  1.826741706957875e+00, -1.247686062656628e-03, -5.786974072923112e-06, -1.815667406260467e-08, -2.257310379025661e-11,  1.515304128245241e-13,  1.231122792543118e-15,
  4.257319940138066e-18,  7.147067153277150e-22, -8.347031464079568e-23, -5.192404334341653e-25, -1.333436097543417e-27,  1.878827443634909e+00, -9.166826132049645e-04,
 -4.693382752669103e-06, -1.812438188271596e-08, -4.718983233266965e-11, -1.431966730744420e-14,  7.068331811976994e-16,  4.803827782840024e-18,  1.774974410950967e-20,
  2.042831050622598e-23, -2.375792903357276e-25, -2.073516284832568e-27,  1.922875308627077e+00, -6.081382354388626e-04, -3.375039045359092e-06, -1.516280532602921e-08,
 -5.498565596047000e-11, -1.410262490433605e-13, -5.690128122614350e-17,  2.123454577488631e-18,  1.629541584155303e-20,  7.655086281855412e-23,  2.298515056120727e-25,
  9.318967013607609e-29,  1.957790181147443e+00, -3.438964868225050e-04, -2.031084564878066e-06, -1.017083111329857e-08, -4.469152469740865e-11, -1.707769392059518e-13,
 -5.342820120533062e-16, -1.061232683382402e-18,  1.616695910289194e-21,  3.267513420705570e-23,  2.248571228867738e-25,  1.125132534212770e-27,  1.982628989462519e+00,
 -1.448501043635391e-04, -8.934998659181247e-07, -4.809765981806141e-09, -2.370175657721387e-11, -1.087353380415516e-13, -4.657849835156213e-16, -1.848848962094559e-18,
 -6.647851684558303e-21, -2.043094105730297e-23, -4.382473481591076e-26,  2.545838357342934e-29,  1.996681952085069e+00, -2.803306093701508e-05, -1.771766433289549e-07,
 -9.920394872832043e-10, -5.185689374442433e-12, -2.589204911421047e-14, -1.249404380216451e-16, -5.864829576790536e-19, -2.688067354439635e-21, -1.205368249317733e-23,
 -5.292046099397761e-26, -2.274215967180350e-28,  4.005150436373875e-04, -1.803965045469110e-06,  6.092845909678669e-09, -1.828955985394768e-11,  5.145389670197479e-14,
 -1.389422647126023e-16,  3.645673375664120e-19, -9.370153714842233e-22,  2.368230617390523e-24, -5.914850383521388e-27,  1.458983736340105e-29, -3.578929390633033e-32,
  3.604547644879771e-03, -1.622168471517284e-05,  5.468246521449841e-08, -1.635822141661089e-10,  4.577386883559146e-13, -1.226519198666565e-15,  3.184433570708516e-18,
 -8.072109222136780e-21,  2.004359117216771e-23, -4.896956786723405e-26,  1.175407917735014e-28, -2.790702926664116e-31,  1.001213647508186e-02, -4.498225333548111e-05,
  1.510440666651436e-07, -4.487149237659418e-10,  1.241941873897587e-12, -3.275222618434488e-15,  8.317691932138319e-18, -2.046866731344059e-20,  4.887942587026626e-23,
 -1.135352166566899e-25,  2.551268093990170e-28, -5.566771558562860e-31,  1.962228829563266e-02, -8.793496498187216e-05,  2.935383400135045e-07, -8.628206589010235e-10,
  2.348044839531059e-12, -6.038608917420704e-15,  1.479495761615458e-17, -3.462553650186772e-20,  7.707357935860491e-23, -1.620965918959665e-25,  3.141802161143254e-28,
 -5.435675347540529e-31,  3.243341085151187e-02, -1.448513367668349e-04,  4.796963903939133e-07, -1.389697690935033e-09,  3.693830280005476e-12, -9.163212699697514e-15,
  2.127022137848199e-17, -4.589315882013182e-20,  8.987558511975145e-23, -1.515033561975371e-25,  1.787910425756732e-28,  4.133833618762800e-32,  4.844318670092897e-02,
 -2.154221643651152e-04,  7.062082870970238e-07, -2.007937816326201e-09,  5.173125175286866e-12, -1.220813090455950e-14,  2.614801732861168e-17, -4.915857582578889e-20,
  7.280247770946053e-23, -4.648003770362530e-26, -2.181609660207698e-28,  1.255558166039312e-30,  6.764839937611064e-02, -2.992535370076603e-04,  9.689086156308123e-07,
 -2.691113810753287e-09,  6.658907696834898e-12, -1.467132869857380e-14,  2.774830333336886e-17, -3.969333835942736e-20,  1.537605491387817e-23,  1.659988355019193e-25,
 -8.467954367204492e-28,  2.795876444210327e-30,  9.004470681533831e-02, -3.958617623197144e-04,  1.262759833063181e-06, -3.408041073522668e-09,  8.007375612523953e-12,
 -1.602273472641164e-14,  2.450405298695469e-17, -1.410293439601445e-20, -8.509575022102196e-23,  4.643750818206287e-25, -1.550153514406585e-27,  3.968332588886086e-30,
  1.156263554183154e-01, -5.046671405498696e-04,  1.581834555304204e-06, -4.123133188338080e-09,  9.063094326164802e-12, -1.574407442686550e-14,  1.518403125947976e-17,
  2.870506537819586e-20, -2.202878744525411e-22,  7.855115227470690e-25, -2.046985172325007e-27,  3.817360582836486e-30,  1.443858262560273e-01, -6.249865185565402e-04,
  1.919298331667738e-06, -4.796876553046142e-09,  9.665358637288510e-12, -1.337516050769513e-14, -8.701929667753114e-19,  8.664131198403661e-20, -3.688723461448595e-22,
  1.026386644127802e-24, -1.979095446626570e-27,  1.434655507703906e-30,  1.763134028479341e-01, -7.560245474091129e-04,  2.267395019217673e-06, -5.386455403664017e-09,
  9.655910304698001e-12, -8.565976462603830e-15, -2.350844297947307e-17,  1.537770188660294e-19, -4.965353343430892e-22,  1.057376841717214e-24, -1.008103062706037e-27,
 -3.583023489554964e-30,  2.113966474289302e-01, -8.968635651593684e-04,  2.617437597209602e-06, -5.846565501985663e-09,  8.888148430017743e-12, -1.133298018390956e-15,
 -5.155850535307734e-17,  2.200681194511395e-19, -5.587473125290696e-22,  7.488432362911782e-25,  1.044858094759954e-27, -1.062660472406342e-29,  2.496197696794534e-01,
 -1.046452030513874e-03,  2.959808209843085e-06, -6.130462387519730e-09,  7.237943941018756e-12,  8.880267559934804e-15, -8.266321639403127e-17,  2.716426019476695e-19,
 -5.069121615450470e-22,  1.059108865190162e-26,  4.038916980407352e-27, -1.769420259639610e-29,  2.909628683845686e-01, -1.203591447096573e-03,  3.283972453703596e-06,
 -6.191298142877198e-09,  4.616112037618402e-12,  2.114815979160624e-14, -1.132042370572285e-16,  2.918418512371997e-19, -2.982163489158805e-22, -1.159562632199336e-24,
  7.374726484894386e-27, -2.137871072303139e-29,  3.354010223081018e-01, -1.366921746498671e-03,  3.578514506264830e-06, -5.983808508356840e-09,  9.824918263190791e-13,
  3.500764268655156e-14, -1.383571802342493e-16,  2.631923756632992e-19,  9.106257473103925e-23, -2.626478593340554e-24,  9.939365670471736e-27, -1.748538878476656e-29,
  3.829032015894562e-01, -1.534905148175156e-03,  3.831201705737919e-06, -5.466418834637087e-09, -3.638590816423473e-12,  4.942060998555862e-14, -1.523304163097083e-16,
  1.704285449788640e-19,  6.499289185095831e-22, -4.081645611779957e-24,  1.021149843209322e-26, -2.469769687770920e-30,  4.334309650583899e-01, -1.705808595095329e-03,
  4.029089728965759e-06, -4.603840941865354e-09, -9.141971147774226e-12,  6.295722063057585e-14, -1.488443423002965e-16,  4.566143977366799e-21,  1.317162107435764e-21,
 -5.040240298303037e-24,  6.601517800957602e-27,  2.433388215695938e-29,  4.869369018819920e-01, -1.877684989400093e-03,  4.158682658060988e-06, -3.370230450703761e-09,
 -1.532530101461613e-11,  7.381530178701703e-14, -1.219051593637136e-16, -2.321888936798927e-19,  1.970054676434750e-21, -4.895348728986683e-24, -1.932307337053670e-27,
  5.813809609267861e-29,  5.433627677920434e-01, -2.048353640928747e-03,  4.206166039287997e-06, -1.752960829482418e-09, -2.187418674976384e-11,  7.989179370535306e-14,
 -6.691100730181984e-17, -5.212535885630457e-19,  2.423423059446710e-21, -3.052652150783138e-24, -1.503480061553614e-26,  8.682946259601843e-29,  6.026372567243385e-01,
 -2.215380619112465e-03,  4.157735518397859e-06,  2.429609532576380e-10, -2.835108261838668e-11,  7.892545252357841e-14,  1.791044129159592e-17, -8.232495355299729e-19,
  2.446575078342661e-21,  8.419416319071005e-25, -3.006480344235802e-26,  9.150526939263346e-29,  6.646733380750952e-01, -2.376060100214481e-03,  4.000048654579523e-06,
  2.589872297101864e-09, -3.419126708511154e-11,  6.873141146605818e-14,  1.298071832239968e-16, -1.076028287940042e-18,  1.806377603558774e-21,  6.596730894902648e-24,
 -4.157080101681416e-26,  5.148637999102801e-29,  7.293650781822985e-01, -2.527398373348680e-03,  3.720832695303490e-06,  5.231965221145171e-09, -3.871054241019358e-11,
  4.754599238903176e-14,  2.597469748546174e-16, -1.197500596068372e-18,  3.422088247508897e-22,  1.315607606708222e-23, -4.176060388453707e-26, -4.473471243228860e-29,
  7.965838526574923e-01, -2.666102969456205e-03,  3.309685630196200e-06,  8.079635607941402e-09, -4.113079604195433e-11,  1.449108698490239e-14,  3.909783165269788e-16,
 -1.096148407993368e-18, -1.928951333038964e-21,  1.840897579344110e-23, -2.269730808805262e-26, -1.836471039348589e-28,  8.661738449924578e-01, -2.788580480493926e-03,
  2.759110203539310e-06,  1.100423518051466e-08, -4.063101511679435e-11, -2.985331186007483e-14,  4.985280501290046e-16, -6.920002379407297e-19, -4.694427544156010e-21,
  1.934644946718733e-23,  1.931869053143360e-26, -3.121249379884218e-28,  9.379467185508541e-01, -2.890948125106182e-03,  2.065818062779243e-06,  1.383416430702047e-08,
 -3.643224314532692e-11, -8.281849012690459e-14,  5.505257406791922e-16,  5.062827035810679e-20, -7.256699223908061e-21,  1.283579507017612e-23,  7.772080288108770e-26,
 -3.373181660314334e-28,  1.011675347205674e+00, -2.969066075353413e-03,  1.232329401551414e-06,  1.635375768021688e-08, -2.792434200853957e-11, -1.390714012746321e-13,
  5.124506583570864e-16,  1.081250128558552e-18, -8.546464596424984e-21, -2.803350421558486e-24,  1.305300317290535e-25, -1.592489765971194e-28,  1.087086500314927e+00,
 -3.018600043834945e-03,  2.688653541858228e-07,  1.830706724288536e-08, -1.483863283619989e-11, -1.902977834732584e-13,  3.553385038040993e-16,  2.222225236556735e-18,
 -7.335721786817026e-21, -2.558402949781906e-23,  1.412849469336056e-25,  2.523373009583063e-28,  1.163852409527679e+00, -3.035126619876858e-03, -8.045241932526544e-07,
  1.940937686254426e-08,  2.538928091592378e-12, -2.254579589718387e-13,  6.831798809620128e-17,  3.149743965692205e-18, -2.735441479847448e-21, -4.788539471323534e-23,
  7.281806360353281e-26,  7.569394741818693e-28,  1.241581211718470e+00, -3.014297138444988e-03, -1.955749469275246e-06,  1.936990901987688e-08,  2.313755732667780e-11,
 -2.320256880270035e-13, -3.258966039278551e-16,  3.429552449909515e-18,  5.039288542413868e-21, -5.661564332460941e-23, -8.280624800914655e-26,  9.988646651198096e-28,
  1.319806383674799e+00, -2.952078923717411e-03, -3.138689153496717e-06,  1.792930724083035e-08,  4.490767500162986e-11, -1.986237115708900e-13, -7.571474628130793e-16,
  2.643669221473775e-18,  1.389407347139029e-20, -3.797396108492990e-23, -2.683432680109206e-25,  5.545031991677860e-28,  1.397975486201318e+00, -2.845094428327668e-03,
 -4.291940380737688e-06,  1.491437303177957e-08,  6.475733753519815e-11, -1.192366169360961e-13, -1.104649699158985e-15,  6.223441452100086e-19,  1.968544293384190e-20,
  1.205944954675328e-23, -3.527424734540540e-25, -6.517500019563980e-28,  1.475438849918633e+00, -2.691077002242350e-03, -5.339118155645626e-06,  1.030908318373086e-08,
  7.875636428967135e-11,  1.480451526768128e-15, -1.217258227360271e-15, -2.273015630332968e-18,  1.752218125482106e-20,  7.544570789439434e-23, -1.976700239057956e-25,
 -1.886899879436850e-27,  1.551439294505455e+00, -2.489453388640546e-03, -6.191821838676142e-06,  4.333755358259223e-09,  8.276441845435587e-11,  1.435046211461008e-13,
 -9.681018943257122e-16, -4.988052045995127e-18,  5.005409550363987e-21,  1.100987711843466e-22,  1.911353815997515e-25, -1.776456430165728e-27,  1.625104596690655e+00,
 -2.242042775091791e-03, -6.756602181267468e-06, -2.487517531698740e-09,  7.358306421346773e-11,  2.706500724299081e-13, -3.395360143491672e-16, -6.011699307011582e-18,
 -1.379592346663169e-20,  7.351452391710068e-23,  5.419536238463855e-25,  3.160183619262493e-28,  1.695445189341800e+00, -1.953824860693771e-03, -6.947146654623483e-06,
 -9.306095118351005e-09,  5.053155047071974e-11,  3.379034642146034e-13,  4.982781249805304e-16, -4.209286602256983e-18, -2.744503078952377e-20, -2.988780356403122e-23,
  4.585516582628542e-25,  2.653470032052296e-27,  1.761360380385703e+00, -1.633671276183089e-03, -6.702086155737876e-06, -1.502174019671995e-08,  1.696220962712180e-11,
  3.093513772378915e-13,  1.189723640581576e-15,  1.322038033320545e-20, -2.378890604354863e-20, -1.214464960907082e-22, -1.083382418816739e-25,  2.161167168726549e-27,
  1.821656982863832e+00, -1.294859274521671e-03, -6.006915858530242e-06, -1.849195293388110e-08, -1.923736941874822e-11,  1.825074810728972e-13,  1.350166970764065e-15,
  4.227991728112535e-18, -2.677692855377627e-21, -1.053537212315632e-22, -5.731938960780477e-25, -1.094520811625993e-27,  1.875084223463257e+00, -9.551124967369195e-04,
 -4.915411896728151e-06, -1.888074174114903e-08, -4.729535629658902e-11,  4.323207643087217e-15,  8.493886544714316e-16,  5.381565976381540e-18,  1.829093560833518e-20,
  8.970037906887425e-24, -3.386202055091541e-25, -2.524366761863073e-27,  1.920387581289803e+00, -6.358815332929884e-04, -3.562364592059306e-06, -1.606519291187761e-08,
 -5.781470568802485e-11, -1.416168648749336e-13,  1.028276491317216e-17,  2.690779738657030e-18,  1.921712448532282e-20,  8.575928010644647e-23,  2.287209254263907e-25,
 -1.610137832532326e-28,  1.956381307354405e+00, -3.606457834867510e-04, -2.157539921515647e-06, -1.091392650568477e-08, -4.823766298108909e-11, -1.839492842693067e-13,
 -5.630824540855991e-16, -9.888410273957713e-19,  2.967406063699715e-21,  4.272334012319591e-23,  2.791831290699957e-25,  1.348904813026153e-27,  1.982034918180536e+00,
 -1.522355882488152e-04, -9.535662082826879e-07, -5.207017167093266e-09, -2.599257208636418e-11, -1.205601211680005e-13, -5.206439590159352e-16, -2.073683615466426e-18,
 -7.414501698898504e-21, -2.214497712077432e-23, -4.142505972619701e-26,  8.764460331502080e-29,  1.996566907575466e+00, -2.949954292940428e-05, -1.895965755451961e-07,
 -1.079321930938619e-09, -5.734898196053837e-12, -2.909781401223347e-14, -1.426344797517321e-16, -6.798729918959440e-19, -3.162642736496640e-21, -1.438489384009943e-23,
 -6.401223750593718e-26, -2.785540121031692e-28,  3.933952984672105e-04, -1.756086389752065e-06,  5.878220579544230e-09, -1.748806164206143e-11,  4.876046585487719e-14,
 -1.304991150535247e-16,  3.393606488487159e-19, -8.645293205382407e-22,  2.165432032345338e-24, -5.361566351413610e-27,  1.310279524928681e-29, -3.188469469443869e-32,
  3.540523566561472e-03, -1.579195427252054e-05,  5.276262530008594e-08, -1.564505612858959e-10,  4.339546286743861e-13, -1.152734141108771e-15,  2.967135351013652e-18,
 -7.458036841731652e-21,  1.836243822423354e-23, -4.450463064798958e-26,  1.059195668220687e-28, -2.497501671178188e-31,  9.834590534902106e-03, -4.379510621913660e-05,
  1.457765869619688e-07, -4.293572348617472e-10,  1.178388142340360e-12, -3.082302443663486e-15,  7.765866546964464e-18, -1.896799934386699e-20,  4.497009154851561e-23,
 -1.038041546713715e-25,  2.318089117275211e-28, -5.041347234289270e-31,  1.927518036447907e-02, -8.562744404015410e-05,  2.834059805345446e-07, -8.261991509598020e-10,
  2.230746338075995e-12, -5.694890723246737e-15,  1.385911131536406e-17, -3.225017031163573e-20,  7.145863871290698e-23, -1.499977530761597e-25,  2.910066974832639e-28,
 -5.099388738872515e-31,  3.186157642995845e-02, -1.410794801610398e-04,  4.633686667547692e-07, -1.332035215238200e-09,  3.515568451847433e-12, -8.667827488052702e-15,
  2.002466711366037e-17, -4.310302323635960e-20,  8.455047634417858e-23, -1.443322753344264e-25,  1.793662361813429e-28, -1.317487927987615e-32,  4.759264673507924e-02,
 -2.098674903306123e-04,  6.826017051334094e-07, -1.927087480725519e-09,  4.935127943465461e-12, -1.159683412011021e-14,  2.480392976555528e-17, -4.685724889111701e-20,
  7.098487314703701e-23, -5.416279793916935e-26, -1.674380256825585e-28,  1.054898644785847e-30,  6.646668576919353e-02, -2.916296523898441e-04,  9.372449381426160e-07,
 -2.586882893219963e-09,  6.372051001119137e-12, -1.401864548654172e-14,  2.664463147295023e-17, -3.911199214333091e-20,  2.077102267463782e-23,  1.344841470149055e-25,
 -7.314240875146559e-28,  2.454612684079727e-30,  8.848120795525022e-02, -3.859211157682182e-04,  1.222621576360163e-06, -3.282454887595651e-09,  7.692768379006001e-12,
 -1.543966871946265e-14,  2.407347775078016e-17, -1.657015063506666e-20, -6.945328349518696e-23,  4.057509205542358e-25, -1.383739630936071e-27,  3.599688590303376e-30,
  1.136326862997192e-01, -4.922079331398738e-04,  1.533216687860582e-06, -3.980622671780660e-09,  8.751918100326342e-12, -1.537078376327005e-14,  1.589322453387042e-17,
  2.209283106496001e-20, -1.934432350775876e-22,  7.069442451829686e-25, -1.882598410869950e-27,  3.650060983930890e-30,  1.419162280771792e-01, -6.098597733338123e-04,
  1.862654858375622e-06, -4.644371174002551e-09,  9.397836332733199e-12, -1.336823390181967e-14,  1.395955579393467e-18,  7.541344682444329e-20, -3.333312053825471e-22,
  9.485888504750377e-25, -1.908433211088489e-27,  1.759150115394592e-30,  1.733251772984556e-01, -7.381413239194539e-04,  2.203678772842092e-06, -5.233360617930242e-09,
  9.479288384375509e-12, -9.080270600476156e-15, -1.941946893354897e-17,  1.384888657705507e-19, -4.592306513099294e-22,  1.014220395136528e-24, -1.142127432657165e-27,
 -2.540291147336955e-30,  2.078506312411101e-01, -8.762022840985758e-04,  2.548131113312846e-06, -5.704601628059007e-09,  8.853597207673101e-12, -2.298754513154061e-15,
 -4.564281169565521e-17,  2.026267228220689e-19, -5.311445028980121e-22,  7.818146759986775e-25,  6.164112872804929e-28, -8.883093852050554e-30,  2.454808553699138e-01,
 -1.023065845498590e-03,  2.886943022604961e-06, -6.013339681412963e-09,  7.396316737965000e-12,  6.985790716389845e-15, -7.528404921024524e-17,  2.554572067854191e-19,
 -5.038050333871116e-22,  1.571748380683393e-25,  3.304877816887319e-27, -1.568902177843201e-29,  2.862005774305592e-01, -1.177615562995478e-03,  3.210133509899095e-06,
 -6.114201504574456e-09,  5.012562384396544e-12,  1.852820203257652e-14, -1.051721463418285e-16,  2.816861353684359e-19, -3.348740749139731e-22, -8.830081905561411e-25,
  6.462665862452163e-27, -2.005219300343253e-29,  3.299901372307315e-01, -1.338580533967262e-03,  3.506825650861352e-06, -5.962665323645572e-09,  1.650037218006263e-12,
  3.177574762004168e-14, -1.309606739114771e-16,  2.646687386340500e-19,  3.478071844522167e-24, -2.244524781042818e-24,  9.153563028212222e-27, -1.814105522379951e-29,
  3.768244634764203e-01, -1.504518838493013e-03,  3.765287353694041e-06, -5.516925965914679e-09, -2.686339804720092e-12,  4.582416116817850e-14, -1.472887783123993e-16,
  1.889537895524754e-19,  5.103047160746371e-22, -3.676559285103982e-24,  1.001480200263904e-26, -6.318028221050695e-30,  4.266718428358220e-01, -1.673799253810442e-03,
  3.973006931800706e-06, -4.740233290921080e-09, -7.918515110839363e-12,  5.939108771078448e-14, -1.481533046161821e-16,  4.386507538729816e-20,  1.140704039733629e-21,
 -4.757008246716851e-24,  7.506377667129407e-27,  1.695989122082974e-29,  4.794924389711028e-01, -1.844581356523098e-03,  4.116816861191195e-06, -3.603785867343591e-09,
 -1.387874269771227e-11,  7.081852296028938e-14, -1.275504357208186e-16, -1.719769470561727e-19,  1.793021781159847e-21, -4.924282764483133e-24,  4.169803680370996e-28,
  4.871912715201341e-29,  5.352365104196061e-01, -2.014794283668398e-03,  4.183083020175743e-06, -2.090257188454977e-09, -2.029354687704175e-11,  7.811944591168937e-14,
 -8.043772005999691e-17, -4.455711011324703e-19,  2.303603851235913e-21, -3.579780441502177e-24, -1.137645469085882e-26,  7.930683943398508e-29,  5.938422657527109e-01,
 -2.182114664253836e-03,  4.157981491327364e-06, -1.980126189097759e-10, -2.677009638110304e-11,  7.908755798981460e-14, -4.041532511280659e-18, -7.446983758208330e-19,
  2.456212017289639e-21, -2.797959082927197e-25, -2.601904434347951e-26,  9.192965565050735e-29,  6.552332822926202e-01, -2.343944591611130e-03,  4.027890643840838e-06,
  2.053968194566435e-09, -3.278789091663918e-11,  7.149197829479371e-14,  1.005210888200537e-16, -1.014740704629543e-18,  2.014516900924047e-21,  4.983758531528634e-24,
 -3.897291543371333e-26,  6.589337243469324e-29,  7.193154008745225e-01, -2.497391032309177e-03,  3.779932512328261e-06,  4.620531238967230e-09, -3.769999100979710e-11,
  5.337922302475442e-14,  2.264391503247671e-16, -1.179297702531077e-18,  7.853694186292809e-22,  1.145544295322519e-23, -4.305112751463920e-26, -1.454759364984788e-29,
  7.859729940409801e-01, -2.639248824195449e-03,  3.402703887883171e-06,  7.424360727867465e-09, -4.074965904462436e-11,  2.349989134100397e-14,  3.595202827762035e-16,
 -1.147461638202366e-18, -1.284415537796918e-21,  1.735069613185219e-23, -2.993834744207071e-26, -1.454579881148186e-28,  8.550644894987556e-01, -2.765990488400481e-03,
  2.887242832133517e-06,  1.035000560437148e-08, -4.111008905980129e-11, -1.813747757224643e-14,  4.771545526090924e-16, -8.309556802383305e-19, -3.987293152809948e-21,
  1.985150543807860e-23,  6.120687182757990e-27, -2.865413687939034e-28,  9.264170163858474e-01, -2.873767571506903e-03,  2.228278204531615e-06,  1.323871535940301e-08,
 -3.795650567074190e-11, -6.961465378054525e-14,  5.487659060810253e-16, -1.736220833489127e-19, -6.742283608523426e-21,  1.564195059289241e-23,  6.246921759743950e-26,
 -3.535018046453606e-28,  9.998200320641506e-01, -2.958430262191582e-03,  1.425804161133072e-06,  1.588539475619384e-08, -3.058048958273918e-11, -1.264402470368048e-13,
  5.388887718320421e-16,  8.071410491704130e-19, -8.555314512163098e-21,  2.253504929691548e-24,  1.217396316877024e-25, -2.378991907431634e-28,  1.075017787246891e+00,
 -3.015574704021078e-03,  4.870016133936045e-07,  1.803968550139899e-08, -1.855440781558990e-11, -1.810503292067449e-13,  4.141438375870513e-16,  1.973855973197006e-18,
 -8.152681012060232e-21, -1.974739292608097e-23,  1.496346901112551e-25,  1.271917803900300e-28,  1.151700506297762e+00, -3.040630814714267e-03, -5.715163660244190e-07,
  1.941404531264714e-08, -1.946748952316890e-12, -2.227714758180827e-13,  1.550305632537858e-16,  3.035253601584355e-18, -4.399098294097282e-21, -4.433312695083483e-23,
  1.040877487689707e-25,  6.598871823281148e-28,  1.229494211702831e+00, -3.029007440427343e-03, -1.721243779129061e-06,  1.970259381069751e-08,  1.842669271241727e-11,
 -2.386785588001751e-13, -2.279219924301130e-16,  3.557646823547023e-18,  2.952252481840279e-21, -5.903246405660234e-23, -3.771296411570239e-26,  1.043020117863246e-27,
  1.307949228419406e+00, -2.976315923504257e-03, -2.919360548740823e-06,  1.861508898144326e-08,  4.075973524743244e-11, -2.158580728169529e-13, -6.771201660647117e-16,
  3.064387134211391e-18,  1.234035870542901e-20, -4.814594162320155e-23, -2.384758814191797e-25,  7.986477410067635e-28,  1.386527595550387e+00, -2.878696638035854e-03,
 -4.106834542879885e-06,  1.592997931996880e-08,  6.210926997025535e-11, -1.454676170262091e-13, -1.078359432499181e-15,  1.256450655926993e-18,  1.985951635268962e-20,
 -2.533196233639404e-24, -3.745674813602624e-25, -3.331537815974676e-28,  1.464589929741790e+00, -2.733273697928627e-03, -5.207852767382361e-06,  1.156781411226806e-08,
  7.848901403870784e-11, -2.843166791642858e-14, -1.272656232826160e-15, -1.670536831169599e-18,  2.007600736630921e-20,  6.589216749661205e-23, -2.794807103611035e-25,
 -1.814540443308534e-27,  1.541382773225384e+00, -2.538757221479942e-03, -6.131780895279835e-06,  5.679637274807645e-09,  8.539096278232998e-11,  1.186160009139300e-13,
 -1.104919475323084e-15, -4.763146742788704e-18,  9.086627797020101e-21,  1.160588531918514e-22,  1.039379071231510e-25, -2.178316364151136e-27,  1.616028159698360e+00,
 -2.296194570566094e-03, -6.779211381101237e-06, -1.267385343752223e-09,  7.890069558982817e-11,  2.604339865293167e-13, -5.136163678354323e-16, -6.406622901929625e-18,
 -1.075729566612909e-20,  9.530968032735523e-23,  5.436247027109234e-25, -2.575435285191016e-28,  1.687518048375662e+00, -2.009834464286273e-03, -7.053743760000593e-06,
 -8.442917871187271e-09,  5.739914321060949e-11,  3.483477157286265e-13,  3.679875383302269e-16, -5.100973934245077e-18, -2.816261210752785e-20, -9.203491243371299e-24,
  5.755650298564992e-25,  2.639284232039569e-27,  1.754717327396342e+00, -1.688003914949825e-03, -6.880509472167752e-06, -1.469929869644551e-08,  2.343433902603725e-11,
  3.378191011013858e-13,  1.178774285602562e-15, -8.186162738802222e-19, -2.821425315094527e-20, -1.236784036822935e-22,  1.765475446891424e-27,  2.850188153368452e-27,
  1.816380022716833e+00, -1.343807158646271e-03, -6.230539813700165e-06, -1.876874900004995e-08, -1.525365613447041e-11,  2.163187461402549e-13,  1.466748893859165e-15,
  4.077108652477736e-18, -6.893790812879929e-21, -1.291386899952795e-22, -6.131082914539938e-25, -6.894436343186382e-28,  1.871183673806217e+00, -9.953549178247387e-04,
 -5.146514567835485e-06, -1.963561570056292e-08, -4.699249074599472e-11,  2.658308092770555e-14,  1.008295450352991e-15,  5.969203014538046e-18,  1.834202776465941e-20,
 -6.934125548285882e-24, -4.600176281565291e-25, -2.994769069384940e-27,  1.917785813884120e+00, -6.651675199273155e-04, -3.760790469361213e-06, -1.701284658897836e-08,
 -6.063810096993707e-11, -1.403935720251467e-13,  9.471047906405591e-17,  3.356871180269883e-18,  2.246654457924959e-20,  9.466741833727552e-23,  2.140118528091019e-25,
 -5.286506456066582e-28,  1.954903355225337e+00, -3.784433763947134e-04, -2.293261665433675e-06, -1.171590446012445e-08, -5.205396937124130e-11, -1.977832824531888e-13,
 -5.891933266356051e-16, -8.669997313465200e-19,  4.721414055657475e-21,  5.514968969786776e-23,  3.439621867140475e-25,  1.599789979823793e-27,  1.981410312806475e+00,
 -1.601213124809872e-04, -1.018627525210792e-06, -5.642887092954736e-09, -2.853357390339608e-11, -1.337798925689658e-13, -5.821508750772608e-16, -2.324014020334839e-18,
 -8.240399695791247e-21, -2.370047681504386e-23, -3.568824889885264e-26,  1.786609766655110e-28,  1.996445791567998e+00, -3.106972834882785e-05, -2.031188141824555e-07,
 -1.175928632125058e-09, -6.352689903678910e-12, -3.276141174732769e-14, -1.631693056878815e-16, -7.898824459042688e-19, -3.729700757599068e-21, -1.720818664401050e-23,
 -7.761384157241061e-26, -3.419584632199887e-28,  3.864636938108613e-04, -1.709886984751706e-06,  5.672960126451080e-09, -1.672833961219970e-11,  4.623000908076340e-14,
 -1.226372859280695e-16,  3.160956302223553e-19, -7.982252851095544e-22,  1.981521121843101e-24, -4.864468175837506e-27,  1.177718426167514e-29, -2.844160217459893e-32,
  3.478188225593273e-03, -1.537724658876861e-05,  5.092612974649096e-08, -1.496879253697854e-10,  4.115954804888283e-13, -1.083963846177426e-15,  2.766301540372389e-18,
 -6.895276805247760e-21,  1.683395740371673e-23, -4.047974973949543e-26,  9.551374964535727e-29, -2.237572619696533e-31,  9.661710350673012e-03, -4.264918676933157e-05,
  1.407354234022518e-07, -4.109862439786907e-10,  1.118563707993942e-12, -2.902135672483464e-15,  7.254359889974565e-18, -1.758700056837388e-20,  4.139482927302115e-23,
 -9.496115190079283e-26,  2.106856569951993e-28, -4.568369170732716e-31,  1.893714313821164e-02, -8.339925553244498e-05,  2.737020414566528e-07, -7.914006222210775e-10,
  2.120102881475488e-12, -5.372854624746177e-15,  1.298732399460791e-17, -3.004768931493311e-20,  6.626292505856835e-23, -1.387965820065727e-25,  2.692882907400775e-28,
 -4.774810892631193e-31,  3.130457250612521e-02, -1.374355252901781e-04,  4.477161014532522e-07, -1.277147265142079e-09,  3.346921624423056e-12, -8.201417110215493e-15,
  1.885488981185712e-17, -4.047916063334374e-20,  7.948339410870806e-23, -1.371827252756162e-25,  1.777954684443254e-28, -5.656609873245098e-32,  4.676395381450149e-02,
 -2.044978519530642e-04,  6.599428773007706e-07, -1.849949024251402e-09,  4.709039250725171e-12, -1.101702900575992e-14,  2.352342618499549e-17, -4.461813575335783e-20,
  6.892515879387127e-23, -5.998483786503154e-26, -1.249247634029325e-28,  8.817321620392468e-31,  6.531496889460087e-02, -2.842541511501562e-04,  9.068049195469789e-07,
 -2.487138686819999e-09,  6.097984503377069e-12, -1.339223657580374e-14,  2.555948987784945e-17, -3.837529745776300e-20,  2.511101117367560e-23,  1.072950304630396e-25,
 -6.302505945705176e-28,  2.149906421111650e-30,  8.695683889416556e-02, -3.762956318240893e-04,  1.183960534536885e-06, -3.161809710808708e-09,  7.389713816139952e-12,
 -1.486771084459918e-14,  2.358051998868660e-17, -1.856932206396927e-20, -5.580531621271823e-23,  3.534656695302127e-25, -1.233039392794018e-27,  3.254181091923940e-30,
  1.116880868369467e-01, -4.801309122314612e-04,  1.486279322897573e-06, -3.843030384777542e-09,  8.448363388344667e-12, -1.498259967005770e-14,  1.642888540193785e-17,
  1.629562465494185e-20, -1.693105042982682e-22,  6.347975501618629e-25, -1.726128634678698e-27,  3.459030070126696e-30,  1.395062420713671e-01, -5.951789283760883e-04,
  1.807815781347999e-06, -4.496142193127259e-09,  9.130971624432665e-12, -1.331056634447058e-14,  3.363229332250517e-18,  6.527865820563434e-20, -3.005367509237293e-22,
  8.738722434536947e-25, -1.825765016820199e-27,  1.983519903298322e-30,  1.704074767493867e-01, -7.207605306400446e-04,  2.141782385636786e-06, -5.083168881096584e-09,
  9.293327952465756e-12, -9.501432757338986e-15, -1.574209111203647e-17,  1.243686562204074e-19, -4.235655366090611e-22,  9.665664471957134e-25, -1.234276473625746e-27,
 -1.675848817305671e-30,  2.043861620475041e-01, -8.560886517631344e-04,  2.480524134323134e-06, -5.563369496897952e-09,  8.797117584899944e-12, -3.327993875492351e-15,
 -4.020295537446438e-17,  1.860844464057216e-19, -5.026452752188292e-22,  7.991211566245355e-25,  2.601114331584411e-28, -7.345317781506969e-30,  2.414343289158616e-01,
 -1.000256919831769e-03,  2.815497292023116e-06, -5.893976658238351e-09,  7.518534367721218e-12,  5.262991505454716e-15, -6.835592719797066e-17,  2.394501757825440e-19,
 -4.959284375165078e-22,  2.761280986966870e-25,  2.656525239465923e-27, -1.380278308071442e-29,  2.815410145962696e-01, -1.152226585886464e-03,  3.137256089473289e-06,
 -6.031170479070273e-09,  5.358517597672380e-12,  1.609747852629383e-14, -9.743939114504376e-17,  2.705097432809589e-19, -3.622180691064338e-22, -6.417271029508284e-25,
  5.611965477938681e-27, -1.860096585357084e-29,  3.246914718386222e-01, -1.310811640683638e-03,  3.435452496249147e-06, -5.931348862316055e-09,  2.254721634613938e-12,
  2.872156054487668e-14, -1.235600436794806e-16,  2.635562895453714e-19, -7.092739429785663e-23, -1.894424592920774e-24,  8.350330499708300e-27, -1.829593224330682e-29,
  3.708662124924503e-01, -1.474662014380297e-03,  3.698855980272004e-06, -5.552765771070940e-09, -1.804768313330269e-12,  4.235444467639248e-14, -1.417888054480749e-16,
  2.032425556894148e-19,  3.850836196636685e-22, -3.282462291004386e-24,  9.668396295011931e-27, -9.292492712217472e-30,  4.200398507504907e-01, -1.642244794368444e-03,
  3.915402528492624e-06, -4.857619660770718e-09, -6.766130010088290e-12,  5.585411571978084e-14, -1.464393710014675e-16,  7.768685864186848e-20,  9.750182873690519e-22,
 -4.443779370264673e-24,  8.108547458661707e-27,  1.057236831764306e-29,  4.721797035381761e-01, -1.811823471817329e-03,  4.072285268738967e-06, -3.814682635271043e-09,
 -1.249334157315143e-11,  6.770584823014535e-14, -1.315891202508745e-16, -1.174293850087868e-19,  1.616540133456775e-21, -4.867392524542059e-24,  2.362729021096155e-27,
  3.982402772698810e-29,  5.272440961166549e-01, -1.981435353657155e-03,  4.156102961246639e-06, -2.402563811456856e-09, -1.875143103333719e-11,  7.604743652037472e-14,
 -9.190165746244083e-17, -3.739988742051983e-19,  2.167360024756001e-21, -3.967434787978284e-24, -8.066297988145014e-27,  7.106996914525771e-29,  5.851803096292869e-01,
 -2.148867478250841e-03,  4.153087572377869e-06, -6.136923518128074e-10, -2.519095832835489e-11,  7.874920792481431e-14, -2.379560468322739e-17, -6.664537329512266e-19,
  2.428376616988274e-21, -1.240116660995594e-24, -2.201248700998863e-26,  8.981068352040584e-29,  6.459220938317947e-01, -2.311631684821392e-03,  4.049438207878868e-06,
  1.540922208670711e-09, -3.133618940927737e-11,  7.357097120997258e-14,  7.303571354987774e-17, -9.477005148273093e-19,  2.166601126720005e-21,  3.486141118934775e-24,
 -3.583316324203825e-26,  7.616810175980916e-29,  7.093866524583814e-01, -2.466939958109338e-03,  3.831795844282612e-06,  4.026156164088499e-09, -3.658071954977379e-11,
  5.842072764972298e-14,  1.938302826179262e-16, -1.147900667372938e-18,  1.166687781756061e-21,  9.728608867103633e-24, -4.309974356683990e-26,  1.164934210156659e-29,
  7.754709906608147e-01, -2.611681868973563e-03,  3.487901247858297e-06,  6.776583980130939e-09, -4.019600037799274e-11,  3.173875516335106e-14,  3.269081236930594e-16,
 -1.178811907303881e-18, -6.827867001604636e-22,  1.603632737539176e-23, -3.550575090559970e-26, -1.078121554450709e-28,  8.440474942133150e-01, -2.742406950985439e-03,
  3.007486353381086e-06,  9.689956230912838e-09, -4.136027783426448e-11, -6.978726041247070e-15,  4.522091192340853e-16, -9.470914703035612e-19, -3.271188994988200e-21,
  1.985321424881442e-23, -5.801530702587831e-27, -2.544859806729131e-28,  9.149585899844980e-01, -2.855316312878034e-03,  2.383455331058472e-06,  1.262098643012631e-08,
 -3.921761243525892e-11, -5.652645235186329e-14,  5.409718604366539e-16, -3.799136703750437e-19, -6.137960228443143e-21,  1.782805841048719e-23,  4.682154400344547e-26,
 -3.555353216673910e-28,  9.880103191814645e-01, -2.946269835435204e-03,  1.613412016568858e-06,  1.537658632299656e-08, -3.297829006528402e-11, -1.132665451052804e-13,
  5.576747122896590e-16,  5.355871546798093e-19, -8.389240347056156e-21,  6.893994917766567e-24,  1.098255991664595e-25, -3.009364382425071e-28,  1.062964643989532e+00,
 -3.010818104605551e-03,  7.015789224360185e-07,  1.771440521996370e-08, -2.207169816695408e-11, -1.704777569384369e-13,  4.656608194056473e-16,  1.702759624851736e-18,
 -8.754833300322394e-21, -1.368645340556358e-23,  1.525216829109107e-25,  5.000268810311882e-30,  1.139530313052334e+00, -3.044271938140164e-03, -3.388810062735605e-07,
  1.934748464396725e-08, -6.358175537512872e-12, -2.180482488280558e-13,  2.378129852531247e-16,  2.869804911632496e-18, -5.913458372444804e-21, -3.962306563505011e-23,
  1.305318986415822e-25,  5.387096903102308e-28,  1.217352146033097e+00, -3.041827018650568e-03, -1.483202088542802e-06,  1.995896915003715e-08,  1.360653580939944e-11,
 -2.429446137786329e-13, -1.273063106309453e-16,  3.617915036878701e-18,  8.110186994211405e-22, -5.962071937186465e-23,  8.273740135408038e-27,  1.039404864138626e-27,
  1.295998684915484e+00, -2.998766530667897e-03, -2.692211791265992e-06,  1.923185444369239e-08,  3.628723856777337e-11, -2.310363655612473e-13, -5.860621196609244e-16,
  3.429778182133176e-18,  1.044446581918943e-20, -5.691739073575973e-23, -1.985646118002518e-25,  1.008785139674750e-27,  1.374948333870999e+00, -2.910770011832116e-03,
 -3.909812828952054e-06,  1.689905989136063e-08,  5.894433139460724e-11, -1.708544522208091e-13, -1.034316212961988e-15,  1.887581792501756e-18,  1.949602543949607e-20,
 -1.770702720948250e-23, -3.815504438593262e-25,  1.988815888603753e-29,  1.453574418528803e+00, -2.774359970050114e-03, -5.061528233538447e-06,  1.281741515612964e-08,
  7.761153859520811e-11, -5.946201216005995e-14, -1.310096879263677e-15, -9.924619323559602e-19,  2.222805206450527e-20,  5.316094906719371e-23, -3.557789588027519e-25,
 -1.635897695238366e-27,  1.531130100513345e+00, -2.587515448998222e-03, -6.055354218541838e-06,  7.063385720143151e-09,  8.748748559220141e-11,  9.053425795626873e-14,
 -1.233584060712980e-15, -4.404916159142084e-18,  1.331552646693320e-20,  1.181955610759055e-22,  4.773866333629658e-28, -2.510057032316899e-27,  1.606734848526635e+00,
 -2.350467243919401e-03, -6.786675989776251e-06,  3.596381897872250e-11,  8.397139013666430e-11,  2.459189896947858e-13, -6.972755241737598e-16, -6.691794663461041e-18,
 -6.939193767289592e-21,  1.166373099260773e-22,  5.178846925074938e-25, -9.259998847947100e-28,  1.679365231699583e+00, -2.066653529499566e-03, -7.149317129937228e-06,
 -7.468366485286408e-09,  6.444231852004021e-11,  3.553635117017981e-13,  2.125265926367968e-16, -6.002810477153271e-18, -2.805190244322117e-20,  1.609965234347718e-23,
  6.882101848069692e-25,  2.449017980894087e-27,  1.747854116126587e+00, -1.743746659499101e-03, -7.054423446056593e-06, -1.426877077555020e-08,  3.047122555100196e-11,
  3.657284989013558e-13,  1.142545276238538e-15, -1.792439728331123e-18, -3.263328225906037e-20, -1.208910130675248e-22,  1.427676962378783e-25,  3.558322635933700e-27,
  1.810903673612289e+00, -1.394556184680870e-03, -6.457080081919199e-06, -1.897624554935452e-08, -1.056616227511039e-11,  2.528612339629484e-13,  1.577086576110001e-15,
  3.777340368587208e-18, -1.199007888168950e-20, -1.541070913567360e-22, -6.309027836839222e-25, -8.360570436392240e-29,  1.867118399614306e+00, -1.037482276643010e-03,
 -5.386631273346103e-06, -2.038186942646357e-08, -4.620495875331206e-11,  5.285378456177726e-14,  1.183585982948660e-15,  6.548336521473439e-18,  1.772817725727683e-20,
 -2.810746928176667e-23, -6.019967774978732e-25, -3.453609708873056e-27,  1.915063654615392e+00, -6.960871663130451e-04, -3.970858054896003e-06, -1.800536221366117e-08,
 -6.341519508290222e-11, -1.369081659741912e-13,  1.992917003083693e-16,  4.131927612225065e-18,  2.602180922368652e-20,  1.026237518978784e-22,  1.800863077628722e-25,
 -1.039730641427047e-27,  1.953351978732954e+00, -3.973662974738187e-04, -2.438982747493618e-06, -1.258118952558246e-08, -5.615291139860684e-11, -2.121962286376300e-13,
 -6.110359032903030e-16, -6.813504862036861e-19,  6.972136754029141e-21,  7.039500687311907e-23,  4.202930919218344e-25,  1.872773323662707e-27,  1.980753089425392e+00,
 -1.685491607847109e-04, -1.089172208920355e-06, -6.121610853851973e-09, -3.135431620518541e-11, -1.485629773719361e-13, -6.510450989584247e-16, -2.601616380617024e-18,
 -9.117103709117693e-21, -2.493566439535190e-23, -2.512212000674100e-26,  3.091843828317883e-28,  1.996318170876125e+00, -3.275290258634413e-05, -2.178621489045671e-07,
 -1.283034039105344e-09, -7.048942435498249e-12, -3.695695677111838e-14, -1.870544994567701e-16, -9.197746856648463e-19, -4.408901304405999e-21, -2.063561381577785e-23,
 -9.433081095739553e-26, -4.207333379588021e-28,  3.797136593899536e-04, -1.665293873246937e-06,  5.476578506098093e-09, -1.600787671618986e-11,  4.385135229417278e-14,
 -1.153121879388016e-16,  2.946073515133950e-19, -7.375300151044808e-22,  1.814586687997250e-24, -4.417487686165172e-27,  1.059395746350922e-29, -2.540414719156179e-32,
  3.417482836941345e-03, -1.497691224175419e-05,  4.916868390013897e-08, -1.432722892050185e-10,  3.905647864207083e-13, -1.019829871249919e-15,  2.580561473955318e-18,
 -6.379187973439345e-21,  1.544314755684477e-23, -3.684912096796860e-26,  8.618550076985886e-29, -2.007115146371256e-31,  9.493334559204581e-03, -4.154273082310367e-05,
  1.359090853722698e-07, -3.935442714482420e-10,  1.062222913991497e-12, -2.733793685208377e-15,  6.779966200056656e-18, -1.631547570354927e-20,  3.812319477025152e-23,
 -8.692289271450906e-26,  1.915370310499103e-28, -4.143045055622165e-31,  1.860786600578707e-02, -8.124705782078790e-05,  2.644052718696750e-07, -7.583219791885471e-10,
  2.015695817576918e-12, -5.071019809359426e-15,  1.217493790345947e-17, -2.800518417759746e-20,  6.145515677118397e-23, -1.284359968381881e-25,  2.489667179225170e-28,
 -4.464893109667300e-31,  3.076189806837678e-02, -1.339142014929048e-04,  4.327063044146309e-07, -1.224884539361327e-09,  3.187328115237076e-12, -7.762217855056508e-15,
  1.775634919622156e-17, -3.801334221070701e-20,  7.467213046495931e-23, -1.301313769935417e-25,  1.745223360085921e-28, -9.086522612917872e-32,  4.595638268304164e-02,
 -1.993058421778302e-04,  6.381883837517627e-07, -1.776336866639511e-09,  4.494244378448960e-12, -1.046721126554708e-14,  2.230466576715484e-17, -4.244797323246709e-20,
  6.668469069009123e-23, -6.425149313354978e-26, -8.949608588402652e-29,  7.322846912910935e-31,  6.419227446123138e-02, -2.771174559404294e-04,  8.775359299104191e-07,
 -2.391680726698468e-09,  5.836187498057921e-12, -1.279160871766771e-14,  2.449677832095083e-17, -3.751462863588789e-20,  2.854189631418115e-23,  8.389465842308546e-26,
 -5.417471872316737e-28,  1.878109752850482e-30,  8.547036224598954e-02, -3.669737268117932e-04,  1.146718516957046e-06, -3.045922554750667e-09,  7.097975814609440e-12,
 -1.430820802492716e-14,  2.303742487248824e-17, -2.016074076197850e-20, -4.393471482476251e-23,  3.069112708674859e-25, -1.097026637471492e-27,  2.932055311643900e-30,
  1.097910548012006e-01, -4.684228677855479e-04,  1.440964182443301e-06, -3.710232218859186e-09,  8.152688209735927e-12, -1.458342267052475e-14,  1.681265401131025e-17,
  1.123030032431234e-20, -1.476644692757327e-22,  5.687364529948090e-25, -1.578431004262381e-27,  3.252524992512201e-30,  1.371541131832160e-01, -5.809297535268529e-04,
  1.754729879190676e-06, -4.352171349831940e-09,  8.865710029679833e-12, -1.320897338338829e-14,  5.061021207363810e-18,  5.615091132472239e-20, -2.703704280581014e-22,
  8.026343393126269e-25, -1.735098752232692e-27,  2.125372829262916e-30,  1.675583203735979e-01, -7.038677504458170e-04,  2.081670184276486e-06, -4.936015233942603e-09,
  9.099795483156822e-12, -9.838954880645636e-15, -1.244436374486652e-17,  1.113616417964587e-19, -3.896735806885092e-22,  9.159396741751907e-25, -1.291908056301365e-27,
 -9.678729864686164e-31,  2.010010763815244e-01, -8.365091129989040e-04,  2.414605862117722e-06, -5.423198780048592e-09,  8.721321757202892e-12, -4.232131357236923e-15,
 -3.521344033759257e-17,  1.704614920385332e-19, -4.737637721334909e-22,  8.034710180826392e-25, -3.282812864801826e-29, -6.000901850818499e-30,  2.374779041479292e-01,
 -9.780137999020086e-04,  2.745494542413697e-06, -5.772924918415852e-09,  7.607922621945256e-12,  3.701121124055694e-15, -6.187186432020433e-17,  2.237588676674934e-19,
 -4.842166895895948e-22,  3.707681623105451e-25,  2.088228759923302e-27, -1.205225280507528e-29,  2.769818480701046e-01, -1.127416552181537e-03,  3.065406681144868e-06,
 -5.942983110479542e-09,  5.657688376221165e-12,  1.384849479540317e-14, -9.003056531489314e-17,  2.585908802028304e-19, -3.814728475986430e-22, -4.331744832638486e-25,
  4.826696073043071e-27, -1.708726456779847e-29,  3.195027426553817e-01, -1.283612069552345e-03,  3.364511204333414e-06, -5.890836485115091e-09,  2.800094596060788e-12,
  2.584435718606478e-14, -1.162220451784213e-16,  2.602583165114468e-19, -1.333080836805389e-22, -1.576466249165205e-24,  7.549353635386232e-27, -1.805480357160613e-29,
  3.650263235107608e-01, -1.445338127004889e-03,  3.632076893622698e-06, -5.575048286989468e-09, -9.912410362376896e-13,  3.902108876684243e-14, -1.359427338095123e-16,
  2.137483304707089e-19,  2.737711987298625e-22, -2.904605890276424e-24,  9.208346894306617e-27, -1.150155353498911e-29,  4.135331463465582e-01, -1.611156496610039e-03,
  3.856497791408278e-06, -4.957131238217978e-09, -5.683999348844173e-12,  5.236905370717610e-14, -1.438509294346444e-16,  1.063912337379005e-19,  8.209771968700581e-22,
 -4.111800482945628e-24,  8.450835578510412e-27,  5.139720703038117e-30,  4.649972716361551e-01, -1.779431590829882e-03,  4.025353843546159e-06, -4.003915771766013e-09,
 -1.117104280177320e-11,  6.451393730517655e-14, -1.341791262175414e-16, -6.848220019274868e-20,  1.443414846739418e-21, -4.740311890645011e-24,  3.931373779355186e-27,
  3.159724445321751e-29,  5.193846627054045e-01, -1.948306838622971e-03,  4.125521851852695e-06, -2.690542379088634e-09, -1.725334699419884e-11,  7.372383624296392e-14,
 -1.014245296851527e-16, -3.069849010787025e-19,  2.019455429335438e-21, -4.230056086888078e-24, -5.127263817194223e-27,  6.249408464265502e-29,  5.766512329610167e-01,
 -2.115678967379030e-03,  4.143356789164428e-06, -1.004185028512521e-09, -2.362315144711025e-11,  7.796291883138266e-14, -4.137627509591569e-17, -5.896222579576216e-19,
  2.368826096959287e-21, -2.042672220668124e-24, -1.814551489636677e-26,  8.566877715642507e-29,  6.367404633289880e-01, -2.279170625933445e-03,  4.064969841234247e-06,
  1.051400892317138e-09, -2.984934985255112e-11,  7.501334162947436e-14,  4.748766981704177e-17, -8.766312029897965e-19,  2.267130277079884e-21,  2.122016357114784e-24,
 -3.232575740843536e-26,  8.267177510394157e-29,  6.995804934194028e-01, -2.436102195427214e-03,  3.876637315926588e-06,  3.450453874318138e-09, -3.536836603457343e-11,
  6.269149030037229e-14,  1.622620269144656e-16, -1.105294295952085e-18,  1.486071598052317e-21,  8.021638638058914e-24, -4.208907319737749e-26,  3.357444547886751e-29,
  7.650805692570297e-01, -2.583464265315152e-03,  3.565383737266430e-06,  6.138941203127279e-09, -3.948545140313500e-11,  3.918652378911193e-14,  2.936802856414326e-16,
 -1.191706896276516e-18, -1.320885095244639e-22,  1.453193016362105e-23, -3.945332251413540e-26, -7.202246808625018e-29,  8.331267067361393e-01, -2.717893199077023e-03,
  3.119792520522463e-06,  9.027655649405745e-09, -4.139352850705311e-11,  3.544899732113519e-15,  4.243320678682297e-16, -1.040400134965584e-18, -2.563254069736253e-21,
  1.940767768440055e-23, -1.620982849111599e-26, -2.180691870944057e-28,  9.035764040461588e-01, -2.835653611428148e-03,  2.531107244206040e-06,  1.198516181771823e-08,
 -4.021928202502921e-11, -4.369236835876643e-14,  5.276833573273630e-16, -5.657284541215140e-19, -5.466189693532354e-21,  1.939030718381446e-23,  3.136808916127020e-26,
 -3.449679820875148e-28,  9.762522101678796e-01, -2.932633600671467e-03,  1.794692748921636e-06,  1.483154279880854e-08, -3.510872002148732e-11, -9.973247124319019e-14,
  5.689559735254005e-16,  2.719234468979778e-19, -8.065310475568404e-21,  1.100736400697030e-23,  9.550670765313678e-26, -3.470852192228047e-28,  1.050933934316561e+00,
 -3.004361440380371e-03,  9.119223965924931e-07,  1.733460446519069e-08, -2.536579823924837e-11, -1.587618407125239e-13,  5.093502396180339e-16,  1.415897395208013e-18,
 -9.137990235854786e-21, -7.615444367757925e-24,  1.501998874946420e-25, -1.087316974003470e-28,  1.127349270736700e+00, -3.046056365635756e-03, -1.074644090325681e-07,
  1.921120314300723e-08, -1.065567264903398e-11, -2.113991466862557e-13,  3.153112948610920e-16,  2.658803072953185e-18, -7.240552727554646e-21, -3.396740314513897e-23,
  1.512445500061665e-25,  4.006181100891185e-28,  1.205162628343632e+00, -3.052731274045197e-03, -1.242549018310737e-06,  2.013767104730816e-08,  8.725302206495361e-12,
 -2.447833918737777e-13, -2.596305003746628e-17,  3.609678804196459e-18, -1.318447215858075e-21, -5.838660969198175e-23,  5.306489565674925e-26,  9.891002171307768e-28,
  1.283962018490339e+00, -3.019371581831452e-03, -2.458100831769734e-06,  1.977475352347894e-08,  3.153382204419454e-11, -2.439136296720569e-13, -4.856676572306214e-16,
  3.729773749147076e-18,  8.263649471489868e-21, -6.392034036014134e-23, -1.503900435226682e-25,  1.172406747806562e-27,  1.363244003428266e+00, -2.941221595097966e-03,
 -3.701482535197529e-06,  1.781350296251342e-08,  5.528364895380419e-11, -1.949740103778538e-13, -9.728464927597055e-16,  2.498317948388304e-18,  1.858504854234277e-20,
 -3.284364121082874e-23, -3.725990788183490e-25,  3.876636937060819e-28,  1.442396997990055e+00, -2.814215951174787e-03, -4.900313345024397e-06,  1.404796950486274e-08,
  7.610604673051726e-11, -9.115576109335390e-14, -1.327660315038326e-15, -2.534265556045490e-19,  2.386901775523311e-20,  3.756627998605934e-23, -4.218874331641248e-25,
 -1.352240776451327e-27,  1.520683723630381e+00, -2.635595316679261e-03, -5.962140361717643e-06,  8.476021359038887e-09,  8.899238573446780e-11,  5.950026396537556e-14,
 -1.350317931135413e-15, -3.910955702282041e-18,  1.754358923567074e-20,  1.159300549472878e-22, -1.154176426831314e-25, -2.738168571120072e-27,  1.597224428198378e+00,
 -2.404735717784574e-03, -6.778023984296461e-06,  1.417879745985286e-09,  8.870713411240772e-11,  2.269148625408451e-13, -8.870953116624314e-16, -6.842760037075731e-18,
 -2.379120045959999e-21,  1.363254294209926e-22,  4.611762473198189e-25, -1.659195429346950e-27,  1.670983686371565e+00, -2.124188478157756e-03, -7.232515788072141e-06,
 -6.380213055352947e-09,  7.158645950905887e-11,  3.583465005309682e-13,  3.200685025766769e-17, -6.885679960268366e-18, -2.695172850515648e-20,  4.568189949250074e-23,
  7.880012322174391e-25,  2.050359157134533e-27,  1.740765186732824e+00, -1.800858094397987e-03, -7.222477302636848e-06, -1.372124396593786e-08,  3.805531439535133e-11,
  3.924253497293138e-13,  1.077092683115106e-15, -2.904917340783985e-18, -3.684297676060481e-20, -1.118458169800994e-22,  3.144155019665491e-25,  4.233217705288781e-27,
  1.805220689863965e+00, -1.447126161233448e-03, -6.685635733830039e-06, -1.910275471453227e-08, -5.122116267413891e-12,  2.919318417412027e-13,  1.676611822122961e-15,
  3.300027745188309e-18, -1.799101992306177e-20, -1.791881599649797e-22, -6.170611408634934e-25,  7.527986205963232e-28,  1.862880717761513e+00, -1.081566133631799e-03,
 -5.635609326456813e-06, -2.111108528504125e-08, -4.484864409154562e-11,  8.352308569030690e-14,  1.374694618726708e-15,  7.094496109349100e-18,  1.624510840234311e-20,
 -5.535066148520746e-23, -7.630904702144566e-25, -3.854550825448358e-27,  1.912214379190308e+00, -7.287357432812240e-04, -4.193099666118014e-06, -1.904160969215376e-08,
 -6.609565622765803e-11, -1.306392816620417e-13,  3.272081836025714e-16,  5.025026556072039e-18,  2.983320987939732e-20,  1.087238414986098e-22,  1.199147129609431e-25,
 -1.727248511168856e-27,  1.951722511654178e+00, -4.174976578881131e-04, -2.595490348385021e-06, -1.351439029707796e-08, -6.054488922347894e-11, -2.270623511269062e-13,
 -6.265851309233017e-16, -4.142837623905882e-19,  9.829585544898654e-21,  8.893818470465554e-23,  5.089401146435056e-25,  2.157282654611560e-27,  1.980060988439607e+00,
 -1.775651356078550e-04, -1.165742424226206e-06, -6.647924323518833e-09, -3.448790096555502e-11, -1.650960059800161e-13, -7.281109863650502e-16, -2.907891078667551e-18,
 -1.002915146926069e-20, -2.561870323554451e-23, -7.689960029604808e-27,  4.934445414697117e-28,  1.996183573177903e+00, -3.455936052776872e-05, -2.339604621926766e-07,
 -1.401983202358166e-09, -7.835146103960912e-12, -4.177196502468863e-14, -2.149004679291106e-16, -1.073511690546007e-18, -5.224409025621845e-21, -2.480640017102258e-23,
 -1.149220688467956e-25, -5.187830421808168e-28,  3.731389091653687e-04, -1.622237868525703e-06,  5.288618834796967e-09, -1.532432776665649e-11,  4.161417487960414e-14,
 -1.084830041146097e-16,  2.747461091536077e-19, -6.819280658730084e-22,  1.662922843955099e-24, -4.015271798456326e-27,  9.536350555782529e-30, -2.272427656606148e-32,
  3.358351146183067e-03, -1.459033513538938e-05,  4.748624829820107e-08, -1.371831200901927e-10,  3.707733392364784e-13, -9.599851629945542e-16,  2.408667958805358e-18,
 -5.905583893125574e-21,  1.417656112377704e-23, -3.357213480482174e-26,  7.781255379197858e-29, -1.802841807229801e-31,  9.329308674399996e-03, -4.047406343921014e-05,
  1.312867514308716e-07, -3.769774236177897e-10,  1.009137929042750e-12, -2.576421482178444e-15,  6.339751984028354e-18, -1.514415735119295e-20,  3.512758964936793e-23,
 -7.961445695282168e-26,  1.741628653983876e-28, -3.761144445063536e-31,  1.828705139037662e-02, -7.916767443768079e-05,  2.554956187527988e-07, -7.268665958231612e-10,
  1.917135021320527e-12, -4.788013024233115e-15,  1.141764304425914e-17, -2.611071417238883e-20,  5.700606226669536e-23, -1.188614867465649e-25,  2.299721527369364e-28,
 -4.171972676112400e-31,  3.023307268061664e-02, -1.305104902121463e-04,  4.183086244031636e-07, -1.175106447179103e-09,  3.036260444961633e-12, -7.348572223629978e-15,
  1.672473401563884e-17, -3.569745072981321e-20,  7.011201596360574e-23, -1.232388580294165e-25,  1.699074333414863e-28, -1.178248081204085e-31,  4.516923703191764e-02,
 -1.942843925661286e-04,  6.172969735741191e-07, -1.706075024896722e-09,  4.290158237967797e-12, -9.945922834746972e-15,  2.114564495640707e-17, -4.035170226010132e-20,
  6.431460396605238e-23, -6.722629400219271e-26, -6.018389126262612e-29,  6.031838515928788e-31,  6.309766566033388e-02, -2.702104009705021e-04,  8.493876952312035e-07,
 -2.300316795573579e-09,  5.586150012025132e-12, -1.221618510062398e-14,  2.345958062318697e-17, -3.655698971164058e-20,  3.119128990371013e-23,  6.380414590179120e-26,
 -4.645434678494845e-28,  1.635718186159474e-30,  8.402058604209327e-02, -3.579442738636105e-04,  1.110839505340005e-06, -2.934614408859519e-09,  6.817294132707770e-12,
 -1.376223279235562e-14,  2.245484343733925e-17, -2.139809284595994e-20, -3.364549637986629e-23,  2.655207169362389e-25, -9.746799842357243e-28,  2.632873448556443e-30,
  1.079401398809160e-01, -4.570710499651867e-04,  1.397214500112330e-06, -3.582100533885806e-09,  7.865077582771732e-12, -1.417666105841361e-14,  1.706394146583956e-17,
  6.820720182889894e-21, -1.282925100489174e-22,  5.083984539845251e-25, -1.440039814312674e-27,  3.036920359562480e-30,  1.348581424601721e-01, -5.670984272771703e-04,
  1.703346236029854e-06, -4.212426308222036e-09,  8.602867616253376e-12, -1.306959360318615e-14,  6.516370197630676e-18,  4.794816462449118e-20, -2.427020778790432e-22,
  7.351270218033461e-25, -1.639727820922082e-27,  2.199616309858246e-30,  1.647757844320830e-01, -6.874488576139411e-04,  2.023305038396902e-06, -4.792007931244420e-09,
  8.900275152214557e-12, -1.010158104916777e-14, -9.495926008941609e-18,  9.940962244073757e-20, -3.576385570103558e-22,  8.635890783832334e-25, -1.321462287489586e-27,
 -3.964992859464058e-31,  1.976932648003556e-01, -8.174502141671218e-04,  2.350361786058159e-06, -5.284379098962384e-09,  8.628605770685423e-12, -5.021665288603786e-15,
 -3.064842103738102e-17,  1.557631022570346e-19, -4.449228269140759e-22,  7.972324828919887e-25, -2.706169692290486e-28, -4.836145003590844e-30,  2.336093410469178e-01,
 -9.563248694918558e-04,  2.676951991102539e-06, -5.650684559149327e-09,  7.667594287413964e-12,  2.289641316813528e-15, -5.582142943338806e-17,  2.084926090488339e-19,
 -4.694888946562452e-22,  4.441745015882138e-25,  1.593778128959290e-27, -1.044729918906847e-29,  2.725207789009190e-01, -1.103177002731348e-03,  2.994642788287035e-06,
 -5.850359300353566e-09,  5.913630235196132e-12,  1.177325524495163e-14, -8.296300756916396e-17,  2.461700589955632e-19, -3.937690055903967e-22, -2.546936708242529e-25,
  4.108464467961718e-27, -1.556112824977191e-29,  3.144216799786719e-01, -1.256977940132180e-03,  3.294106548694617e-06, -5.842048959639999e-09,  3.289676008477049e-12,
  2.314194245987926e-14, -1.090026596172727e-16,  2.551411484803490e-19, -1.848155371970449e-22, -1.290239181414493e-24,  6.765974939357233e-27, -1.751029392083096e-29,
  3.593026602254927e-01, -1.416549325620726e-03,  3.565106340336070e-06, -5.584839987209506e-09, -2.429560203924232e-13,  3.583117844878729e-14, -1.298503498449338e-16,
  2.209060235677925e-19,  1.757087949484591e-22, -2.546894076341077e-24,  8.665958958702581e-27, -1.305260727599427e-29,  4.071498455035696e-01, -1.580543924238534e-03,
  3.796500511453538e-06, -5.039882696292933e-09, -4.670886431904838e-12,  4.895521307576718e-14, -1.405259628926341e-16,  1.303597049023857e-19,  6.790786478242094e-22,
 -3.770641296861771e-24,  8.574118632309468e-27,  6.069844266247044e-31,  4.579436424749037e-01, -1.747423889640643e-03,  3.976276445042296e-06, -4.172505756262096e-09,
 -9.913096054017325e-12,  6.127569111294523e-14, -1.354754010764170e-16, -2.499041121908720e-20,  1.275908631214516e-21, -4.557506419365125e-24,  5.154509592458467e-27,
  2.413021096873783e-29,  5.116572327406793e-01, -1.915436391565747e-03,  4.091627243633908e-06, -2.954935167717078e-09, -1.580387126046743e-11,  7.119366096120545e-14,
 -1.091385357469959e-16, -2.448331957383073e-19,  1.864121332715064e-21, -4.382691724565111e-24, -2.567222188158404e-27,  5.388872358561919e-29,  5.682547255665378e-01,
 -2.082586621318426e-03,  4.129090012068125e-06, -1.369740799331447e-09, -2.207511667715662e-11,  7.678026805069038e-14, -5.683647564584407e-17, -5.151292047618307e-19,
  2.283119396228467e-21, -2.694679004332343e-24, -1.449620193167862e-26,  7.999475893893398e-29,  6.276888889378153e-01, -2.246608404602136e-03,  4.074770801303520e-06,
  5.858671560376407e-10, -2.833963154303012e-11,  7.586675740611991e-14,  2.396741721882366e-17, -8.031031186839522e-19,  2.321135932676421e-21,  9.028960722061598e-25,
 -2.860723167842570e-26,  8.584076601071555e-29,  6.898983596150927e-01, -2.404932998695483e-03,  3.914689432546531e-06,  2.894791823476069e-09, -3.407807128762053e-11,
  6.622002899042147e-14,  1.320206616181003e-16, -1.053441244421881e-18,  1.744953025052253e-21,  6.373111285493075e-24, -4.020919490478032e-26,  5.116440803826830e-29,
  7.548042098142786e-01, -2.554657204286815e-03,  3.635287500974410e-06,  5.513815436015599e-09, -3.863394090736114e-11,  4.583443185360326e-14,  2.603297592337836e-16,
 -1.187873516608968e-18,  3.619816258440822e-22,  1.290034114260448e-23, -4.188637234068788e-26, -3.911575342892038e-29,  8.223057208384457e-01, -2.692512781548059e-03,
  3.224154714144766e-06,  8.366469643122338e-09, -4.122319562396556e-11,  1.337066683955422e-14,  3.941565630368609e-16, -1.111388676350212e-18, -1.878458430986906e-21,
  1.857868946853169e-23, -2.495697543811376e-26, -1.792962874793481e-28,  8.922751826624850e-01, -2.814840467321980e-03,  2.671041511362051e-06,  1.133534489247448e-08,
 -4.096786784449522e-11, -3.123716535778473e-14,  5.095006040568073e-16, -7.292649171687585e-19, -4.749162457920380e-21,  2.034700187230774e-23,  1.662137359157310e-26,
 -3.237591775219121e-28,  9.645515043709018e-01, -2.917573840960020e-03,  1.969237411045213e-06,  1.425459007061168e-08, -3.696635236750719e-11, -8.601493400460740e-14,
  5.730212234532666e-16,  2.088058517305393e-20, -7.604052162130323e-21,  1.451243076066664e-23,  7.953560103574617e-26, -3.760696238883957e-28,  1.038932386690214e+00,
 -2.996241136628709e-03,  1.117399937617333e-06,  1.690402687358405e-08, -2.841575143629152e-11, -1.460949485395515e-13,  5.448685359149938e-16,  1.120243538468482e-18,
 -9.305436838983075e-21, -1.733848496239470e-24,  1.431461631490658e-25, -2.094191759106513e-28,  1.115164781383145e+00, -3.045997160031795e-03,  1.219089605434249e-07,
  1.900732450979142e-08, -1.480209065813106e-11, -2.029655869562067e-13,  3.863386933218646e-16,  2.408739687353190e-18, -8.350625144267152e-21, -2.760801504390776e-23,
  1.656516839430623e-25,  2.533969263805821e-28,  1.192933355786058e+00, -3.061703056819753e-03, -1.000220909803251e-06,  2.023811093775198e-08,  3.831557167834491e-12,
 -2.442003459451651e-13,  7.420471068881837e-17,  3.534351185447612e-18, -3.371887584875309e-21, -5.541807862146524e-23,  9.468325297354194e-26,  8.960589034727632e-28,
  1.271846717046192e+00, -3.038078997801809e-03, -2.217939478774694e-06,  2.023967120224206e-08,  2.654759360522270e-11, -2.542887333240853e-13, -3.778854961322729e-16,
  3.956334542209068e-18,  5.867003739790618e-21, -6.886824615930908e-23, -9.622116316170664e-26,  1.279967673458253e-27,  1.351421267981497e+00, -2.969963674564342e-03,
 -3.482545993633982e-06,  1.866560189034933e-08,  5.115669408287422e-11, -2.174168822437464e-13, -8.947655211289177e-16,  3.071284914188920e-18,  1.713949710016975e-20,
 -4.729901688500289e-23, -3.475398674757962e-25,  7.483839928330684e-28,  1.431062825845388e+00, -2.852723604364353e-03, -4.724497304140883e-06,  1.524934921676519e-08,
  7.396416919548508e-11, -1.230173192171760e-13, -1.323883494533932e-15,  5.286530075757670e-19,  2.490425167458742e-20,  1.960598719090710e-23, -4.733631237431437e-25,
 -9.730142464611631e-28,  1.510046626573184e+00, -2.682861305798383e-03, -5.851851368824644e-06,  9.907622716486969e-09,  8.984978874663144e-11,  2.584580867918420e-14,
 -1.451345479390024e-15, -3.283914312996332e-18,  2.160456711060210e-20,  1.088653839872253e-22, -2.385056356668264e-25, -2.832490659972658e-27,  1.587497179210767e+00,
 -2.458867386019380e-03, -6.752347703988421e-06,  2.872278258947030e-09,  9.301698434228671e-11,  2.033214630265628e-13, -1.078996154552705e-15, -6.836964251708143e-18,
  2.841023599697871e-21,  1.530899473502370e-22,  3.715404115093203e-25, -2.414764116167115e-27,  1.662370755517396e+00, -2.182334838546652e-03, -7.301969584020541e-06,
 -5.177519809605910e-09,  7.874495802162498e-11,  3.567053602701156e-13, -1.725749862854049e-16, -7.715572392904770e-18, -2.471957644665512e-20,  7.883827936683437e-23,
  8.652365911732520e-25,  1.421256771349110e-27,  1.733445167314825e+00, -1.859285576019466e-03, -7.383215451110574e-06, -1.304819644918803e-08,  4.615503131780213e-11,
  4.171626732587858e-13,  9.786635036865006e-16, -4.145513295917067e-18, -4.059651365349168e-20, -9.536517011555036e-23,  5.138039761758247e-25,  4.806799526796321e-27,
  1.799323761874147e+00, -1.501529114454407e-03, -6.915160673689366e-06, -1.913578301046733e-08,  1.126029743819246e-12,  3.332081503652921e-13,  1.759949354351431e-15,
  2.616421480105254e-18, -2.487538496033713e-20, -2.029069204392665e-22, -5.609669452733333e-25,  1.838860288212555e-27,  1.858462661995866e+00, -1.127676400227307e-03,
 -5.893186700733083e-06, -2.181343872428101e-08, -4.283187037040100e-11,  1.189561894182216e-13,  1.580274809919039e-15,  7.576229003246581e-18,  1.366131583887887e-20,
 -8.935974323943506e-23, -9.394017534717233e-25, -4.133036206877910e-27,  1.909230873821447e+00, -7.632127114479384e-04, -4.428028869735455e-06, -2.011956597169830e-08,
 -6.861794215864787e-11, -1.209863537049434e-13,  4.818682867470961e-16,  6.043076764818384e-18,  3.381306263247587e-20,  1.117525848799895e-22,  2.498744291161031e-26,
 -2.625003646000037e-27,  1.950009942372411e+00, -4.389270900793722e-04, -2.763627858314166e-06, -1.452025883304872e-08, -6.523725949689262e-11, -2.422009462311671e-13,
 -6.332709765386606e-16, -4.438896140971612e-20,  1.342143039449745e-20,  1.112771733681813e-22,  6.100316371075838e-25,  2.434464714775240e-27,  1.979331557193992e+00,
 -1.872198133328680e-04, -1.248940470740430e-06, -7.227123903155867e-09, -3.797135386399339e-11, -1.835848396445004e-13, -8.141638023538931e-16, -3.243593143676245e-18,
 -1.095110582818980e-20, -2.542249418003522e-23,  1.936818383885137e-26,  7.502800777158727e-28,  1.996041482722910e+00, -3.650053594494379e-05, -2.515649406495261e-07,
 -1.534319855234063e-09, -8.724697495787732e-12, -4.731002566772277e-14, -2.474401764436271e-16, -1.255915113646201e-18, -6.205991028299735e-21, -2.989384522754721e-23,
 -1.403398101884618e-25, -6.410264553114144e-28,  3.667334267090489e-04, -1.580653329122874e-06,  5.108651406648813e-09, -1.467550636577195e-11,  3.950893777001009e-14,
 -1.021123431755662e-16,  2.563758958591700e-19, -6.309556231792592e-22,  1.525004833979080e-24, -3.653097807240091e-27,  8.589558586441488e-30, -2.036085030403512e-32,
  3.300739300175675e-03, -1.421693052746647e-05,  4.587502153026466e-08, -1.314012586984521e-10,  3.521385826920944e-13, -9.041112413709375e-16,  2.249485211356640e-18,
 -5.470685958396445e-21,  1.302212781437608e-23, -3.061279702244662e-26,  7.028607325571694e-29, -1.621927806752915e-31,  9.169484740794468e-03, -3.944159372173700e-05,
  1.268582255410787e-07, -3.612353190742347e-10,  9.590973383253325e-13, -2.429231451082467e-15,  5.931031266434483e-18, -1.406461961747071e-20,  3.238297286097394e-23,
 -7.296857527293036e-26,  1.583803831415350e-28, -3.418992575622360e-31,  1.797441410736969e-02, -7.715808480580085e-05,  2.469541520341223e-07, -6.969438738748116e-10,
  1.824056824846354e-12, -4.522560548425911e-15,  1.071145093709723e-17, -2.435324442289270e-20,  5.288827971778553e-23, -1.100215267317053e-25,  2.122254090688874e-28,
 -3.898003981918901e-31,  2.971763550104245e-02, -1.272196114933512e-04,  4.044940477096439e-07, -1.127680577892906e-09,  2.893223267861942e-12, -6.958923478430281e-15,
  1.575595790064068e-17, -3.352355065870301e-20,  6.579644024326164e-23, -1.165528453829851e-25,  1.642393016166683e-28, -1.389764994005333e-31,  4.440184817924092e-02,
 -1.894267563962370e-04,  5.972294524367176e-07, -1.638996646814720e-09,  4.096224410767126e-12, -9.451755217724201e-15,  2.004424338498664e-17, -3.833277204734804e-20,
  6.185720889154883e-23, -6.913691025716661e-26, -3.616079820482204e-29,  4.913949271741503e-31,  6.203024155634775e-02, -2.635242135536080e-04,  8.223121995505982e-07,
 -2.212862739671556e-09,  5.347374289562772e-12, -1.166532352893046e-14,  2.245027914459675e-17, -3.552556669848629e-20,  3.317051379800063e-23,  4.659638179916495e-26,
 -3.974201231539185e-28,  1.419366452071402e-30,  8.260636193852902e-02, -3.491965857378879e-04,  1.076269603884412e-06, -2.827710584655300e-09,  6.547389516161907e-12,
 -1.323061940239099e-14,  2.184200829478574e-17, -2.232911173775224e-20, -2.476136102291280e-23,  2.287672988673639e-25, -8.650099151300848e-28,  2.355642407437934e-30,
  1.061339418653787e-01, -4.460631568924819e-04,  1.354975056793231e-06, -3.458505250151348e-09,  7.585652849754815e-12, -1.376528208666420e-14,  1.720012027396907e-17,
  2.997337773316443e-21, -1.109953782814966e-22,  4.534047960769366e-25, -1.311245471466523e-27,  2.816965147542901e-30,  1.326166854238224e-01, -5.536715336801069e-04,
  1.653614398425613e-06, -4.076862623005695e-09,  8.343143985992494e-12, -1.289794374045599e-14,  7.754077632672664e-18,  4.059266253084772e-20, -2.173946936412053e-22,
  6.714828128758305e-25, -1.542344937734895e-27,  2.218681995313121e-30,  1.620580010870051e-01, -6.714900282428718e-04,  1.966648665012927e-06, -4.651231240986996e-09,
  8.696183407033590e-12, -1.029734650025606e-14, -6.868077798437629e-18,  8.845238872548985e-20, -3.275037067225008e-22,  8.105229291278281e-25, -1.328550989251167e-27,
  5.603967556508064e-32,  1.944606714224555e-01, -7.988986309799762e-04,  2.287774143249346e-06, -5.147163384359985e-09,  8.521161912092431e-12, -5.706473397597888e-15,
 -2.648208219259439e-17,  1.419822908433081e-19, -4.164657805452890e-22,  7.824576431399158e-25, -4.608486063582893e-28, -3.836872413046153e-30,  2.298264462971423e-01,
 -9.351783978191621e-04,  2.609881146168096e-06, -5.527707544584062e-09,  7.700454122344748e-12,  1.018298048353354e-15, -5.019148088810744e-17,  1.937362402592954e-19,
 -4.524578573966171e-22,  4.991711620234974e-25,  1.166650734317218e-27, -8.992501802580598e-30,  2.681555428408557e-01, -1.079499051960029e-03,  2.925013611439582e-06,
 -5.753963361688807e-09,  6.129735141290079e-12,  9.863424963560322e-15, -7.624781432986687e-17,  2.334531520036315e-19, -4.001408427212210e-22, -1.036045529553673e-25,
  3.456912904699383e-27, -1.406209769161826e-29,  3.094460312356647e-01, -1.230904577036521e-03,  3.224332589937164e-06, -5.785851155790155e-09,  3.726929250215082e-12,
  2.061089667383104e-14, -1.019481238634619e-16,  2.485346122638777e-19, -2.265764185821308e-22, -1.034797090999489e-24,  6.011725192525437e-27, -1.674312173528841e-29,
  3.536930801537537e-01, -1.388296559927678e-03,  3.498088042572901e-06, -5.583161506445638e-09,  4.430074122388546e-13,  3.278954748321994e-14, -1.235995770693297e-16,
  2.251274513748237e-19,  9.011861593163509e-23, -2.212072138844234e-24,  8.067892110328877e-27, -1.404900397812498e-29,  4.008880290867076e-01, -1.550415031769714e-03,
  3.735605234353330e-06, -5.106966007347426e-09, -3.725200578680799e-12,  4.562872331548993e-14, -1.365915987543914e-16,  1.499845068663482e-19,  5.495048095272564e-22,
 -3.428290113581231e-24,  8.516471462241080e-27, -3.097173212577203e-30,  4.510172465437451e-01, -1.715816562728279e-03,  3.925294587999564e-06, -4.321487999301646e-09,
 -8.720129800067904e-12,  5.802034826550361e-14, -1.356278956171910e-16,  1.325528881267706e-20,  1.115787028379442e-21, -4.332111196053414e-24,  6.066738519801044e-27,
  1.746952131762947e-29,  5.040607227080489e-01, -1.882849401879052e-03,  4.054697370714606e-06, -3.196550650194216e-09, -1.440671235567296e-11,  6.849866642989017e-14,
 -1.151825731714151e-16, -1.877210741545620e-19,  1.705044739152943e-21, -4.440450511362556e-24, -3.818397089060272e-28,  4.549955674007944e-29,  5.599903320975437e-01,
 -2.049625537011243e-03,  4.110584333130213e-06, -1.710736694727377e-09, -2.055427811079752e-11,  7.525127151363517e-14, -7.025259804585728e-17, -4.437266590873088e-19,
  2.176504545844957e-21, -3.206056546784505e-24, -1.112195107335077e-26,  7.323545845668181e-29,  6.187676854479601e-01, -2.213989709464818e-03,  4.079130755319975e-06,
  1.445954918168869e-10, -2.681832217597629e-11,  7.618054832047778e-14,  2.523753621187706e-18, -7.285201400620902e-19,  2.333956157975117e-21, -1.655708809734510e-25,
 -2.481390335055191e-26,  8.615237836829324e-29,  6.803414697034845e-01, -2.373485700739370e-03,  3.946199675335907e-06,  2.360300129821258e-09, -3.272434148453396e-11,
  6.904107937225056e-14,  1.033383506797839e-16, -9.942375878339638e-19,  1.946016051102805e-21,  4.814002865718458e-24, -3.764886643343742e-26,  6.453601690895158e-29,
  7.446441499062489e-01, -2.525320677752197e-03,  3.697775747406903e-06,  4.903334080975084e-09, -3.765745868187908e-11,  5.168494698178976e-14,  2.272989629107812e-16,
 -1.169185699231672e-18,  7.959024777465111e-22,  1.119936570445029e-23, -4.294906869265203e-26, -9.832915882503709e-30,  8.115878762406022e-01, -2.666329142391531e-03,
  3.320605383453277e-06,  7.709541105210178e-09, -4.086373784998167e-11,  2.245081599542396e-14,  3.622952189915403e-16, -1.161005426149395e-18, -1.229390363257732e-21,
  1.743421878094494e-23, -3.198003440455402e-26, -1.399814530000027e-28,  8.810594031547241e-01, -2.792939225135994e-03,  2.803114250665690e-06,  1.067551820643693e-08,
 -4.147207084524555e-11, -1.927067611490857e-14,  4.870644353655743e-16, -8.694173102225475e-19, -4.008062548785648e-21,  2.073513962883376e-23,  3.001688423969873e-27,
 -2.941153236898695e-28,  9.529137857931447e-01, -2.901145902085177e-03,  2.136689372016683e-06,  1.365011297345160e-08, -3.854921857546368e-11, -7.228240113111916e-14,
  5.702819943620996e-16, -2.135085865112886e-19, -7.028372881786086e-21,  1.735808850902917e-23,  6.265681775102701e-26, -3.885131446656408e-28,  1.026966574050197e+00,
 -2.986498490319938e-03,  1.317426254502751e-06,  1.642672022639742e-08, -3.120451524849768e-11, -1.326753689492587e-13,  5.720649022550810e-16,  8.225563432590972e-19,
 -9.267250431540609e-21,  3.781641725140253e-24,  1.320149794039863e-25, -2.935988954951762e-28,  1.102984181756562e+00, -3.044113868062667e-03,  3.484435898885992e-07,
  1.873854272763981e-08, -1.876337787465530e-11, -1.929151897824156e-13,  4.499021407882930e-16,  2.126915477164061e-18, -9.222957199593897e-21, -2.080284293923849e-23,
  1.735241274162457e-25,  1.048464141275565e-28,  1.180672079103589e+00, -3.068732722979406e-03, -7.571565164932382e-07,  2.026047396435396e-08, -1.026695447227759e-12,
 -2.412458990581202e-13,  1.713616634268654e-16,  3.395335953241791e-18, -5.289585347119831e-21, -5.087791277446776e-23,  1.313820982238310e-25,  7.667277170943837e-28,
  1.259660461919214e+00, -3.054844178000719e-03, -1.972684178347536e-06,  2.062329175631860e-08,  2.138019921994239e-11, -2.620097563807719e-13, -2.648570783452079e-16,
  4.103779052074757e-18,  3.332212874478781e-21, -7.157267453601900e-23, -3.866745752141194e-26,  1.325633603979044e-27,  1.339487130332186e+00, -2.996914516906384e-03,
 -3.253794920421080e-06,  1.944818585285851e-08,  4.660089166961395e-11, -2.377989941693085e-13, -8.013657567982537e-16,  3.589892050264981e-18,  1.519535877844527e-20,
 -6.044160788494612e-23, -3.071728718671920e-25,  1.079878581210047e-27,  1.419577526563229e+00, -2.889767693951728e-03, -4.534491319144362e-06,  1.641137346874289e-08,
  7.118775745353662e-11, -1.545223223127447e-13, -1.297844499377139e-15,  1.333151666922749e-18,  2.526009948326966e-20, -5.512301746761889e-26, -5.063595746260274e-25,
 -5.158189386959257e-28,  1.499222339245859e+00, -2.729176084875563e-03, -5.724323470694615e-06,  1.134743229964159e-08,  9.001135294146116e-11, -1.000820648701552e-14,
 -1.533041593419498e-15, -2.531946582688770e-18,  2.532199916026538e-20,  9.683905589444133e-23, -3.623545146984819e-25, -2.769629379440913e-27,  1.577553926510643e+00,
 -2.512722698089910e-03, -6.708821277152264e-06,  4.391609594629015e-09,  9.680902334960407e-11,  1.751437980140883e-13, -1.268310670773970e-15, -6.655224310409024e-18,
  8.592177073158899e-21,  1.656089930622183e-22,  2.491247613243330e-25, -3.139714542978531e-27,  1.653524222108967e+00, -2.240977157182080e-03, -7.356305813675382e-06,
 -3.860827685852705e-09,  8.581969835993924e-11,  3.498846063503085e-13, -3.992104475968132e-16, -8.454399952137925e-18, -2.124549239644802e-20,  1.144605989135371e-22,
  9.095718035476289e-25,  5.554555159588189e-28,  1.725888920470318e+00, -1.918964416717689e-03, -7.535083578531858e-06, -1.224173588865741e-08,  5.472299042061823e-11,
  4.391078878696252e-13,  8.439164932509060e-16, -5.495143664173839e-18, -4.360752757197559e-20, -7.045182633018120e-23,  7.347168105414855e-25,  5.197132990168761e-27,
  1.793205549645111e+00, -1.557768089644870e-03, -7.144454555583228e-06, -1.906213505443497e-08,  8.218020577283171e-12,  3.762292030923305e-13,  1.820937000446813e-15,
  1.699384511753469e-18, -3.256104202766312e-20, -2.233517088681349e-22, -4.515347071206788e-25,  3.175455150580761e-27,  1.853855991394658e+00, -1.175880394597630e-03,
 -6.158974439690207e-06, -2.247758200778069e-08, -4.005605602408650e-11,  1.594745565147462e-13,  1.797992098068786e-15,  7.954309327545685e-18,  9.723780496115570e-21,
 -1.306121771681978e-22, -1.123749872244354e-24, -4.204108484126636e-27,  1.906105618840480e+00, -7.996215251748805e-04, -4.676128636833013e-06, -2.123612272912241e-08,
 -7.090766746665679e-11, -1.072650546954250e-13,  6.668274690049076e-16,  7.189412630799423e-18,  3.782345897884094e-20,  1.101253019185427e-22, -1.146427458190161e-25,
 -3.763734723014336e-27,  1.948208886883454e+00, -4.617512034133468e-04, -2.944296267729442e-06, -1.560363242208892e-08, -7.023309697275472e-11, -2.573619572972978e-13,
 -6.278640225742205e-16,  4.541159551003227e-19,  1.789313122991123e-20,  1.378952518849131e-22,  7.226187899231908e-25,  2.673512708720679e-27,  1.978562130673929e+00,
 -1.975688533571821e-04, -1.339435898682190e-06, -7.865132411127173e-09, -4.184601465658455e-11, -2.042550560028288e-13, -9.100266249282213e-16, -3.608452182785060e-18,
 -1.184355241325139e-20, -2.389132520792820e-23,  5.976603260494107e-26,  1.104441907920396e-27,  1.995891335483962e+00, -3.858915000950707e-05, -2.708466533455290e-07,
 -1.681819654438617e-09, -9.733252409825735e-12, -5.369405277964624e-14, -2.855559251492335e-16, -1.472866771096375e-18, -7.390394129461345e-21, -3.611401884834740e-23,
 -1.717796174676775e-25, -7.936547892583233e-28,  };
  constexpr double w[16128] = {  7.388247293339276e-02, -2.295499544842064e-04,  7.480613220489151e-07, -2.527748180396700e-09,  8.752390973435472e-12,
 -3.075105194498142e-14,  1.088463759211708e-16, -3.862978558271751e-19,  1.370516372631620e-21, -4.852262606010927e-24,  1.712697987505398e-26, -6.024047312245151e-29,
  7.358472328549459e-02, -3.261090329306077e-04,  1.683140540554563e-06, -8.751889325948033e-09,  4.427582463794530e-11, -2.174437530147702e-13,  1.040710913625833e-15,
 -4.873670824809866e-18,  2.240282412375655e-20, -1.013261254815197e-22,  4.517785300172047e-25, -1.988627285194124e-27,  7.299432075025068e-02, -5.163975216561338e-04,
  3.899549891237674e-06, -2.717890930096005e-08,  1.771092208044155e-10, -1.096726137845132e-12,  6.522022161773100e-15, -3.750950187528408e-17,  2.096764971481165e-19,
 -1.143516143374630e-21,  6.102282603108312e-24, -3.193790123062910e-26,  7.212126953271969e-02, -7.948795147204882e-04,  8.059087638055359e-06, -7.154945901924731e-08,
  5.799871098808519e-10, -4.394021133060454e-12,  3.155355832577173e-14, -2.168118820474118e-16,  1.435200255718832e-18, -9.199074589952479e-21,  5.731743722576878e-23,
 -3.482432985724282e-25,  7.098011392323551e-02, -1.153551706401253e-03,  1.508044186365703e-05, -1.665592811723318e-07,  1.644525950737906e-09, -1.494112480732459e-11,
  1.271280824184579e-13, -1.025051716651936e-15,  7.898669607332652e-18, -5.853171737241973e-20,  4.191391551832645e-22, -2.911378101864120e-24,  6.958941448664532e-02,
 -1.582282308654261e-03,  2.605778174775149e-05, -3.517767685113358e-07,  4.162384944621479e-09, -4.467565737584973e-11,  4.441529541561805e-13, -4.147503534269941e-15,
  3.673969233394403e-17, -3.110100673565903e-19,  2.530236754642970e-21, -1.987072436337561e-23,  6.797109790904866e-02, -2.069228766141541e-03,  4.216369982348460e-05,
 -6.853979884176853e-07,  9.590745085564414e-09, -1.201544981959156e-10,  1.380286234239212e-12, -1.477185513350112e-14,  1.489440902794295e-16, -1.426783560467989e-18,
  1.306844206146886e-20, -1.150241491992892e-22,  6.614971667810164e-02, -2.601308864120158e-03,  6.454476746493072e-05, -1.246893942344900e-06,  2.040050573367417e-08,
 -2.953003177394228e-10,  3.883240544102907e-12, -4.721439518217803e-14,  5.374235391774707e-16, -5.780092868645538e-18,  5.915776089198234e-20, -5.793548229849207e-22,
  6.415165800327539e-02, -3.164697808163280e-03,  9.421829461155497e-05, -2.137697788004572e-06,  4.048516802258949e-08, -6.710739221563381e-10,  1.001966509473630e-11,
 -1.373564485702861e-13,  1.752437690210700e-15, -2.101841088667625e-17,  2.388227815499863e-19, -2.586277995530944e-21,  6.200434168113785e-02, -3.745323995450278e-03,
  1.319783910486200e-04, -3.479308169724980e-06,  7.558422074419641e-08, -1.423181475486996e-09,  2.395055784135319e-11, -3.676912801187766e-13,  5.224784723085236e-15,
 -6.946302145401523e-17,  8.712451952180869e-19, -1.037579444556455e-20,  5.973544416569455e-02, -4.329338329584834e-03,  1.783182130854233e-04, -5.408512308643626e-06,
  1.336525062250998e-07, -2.837645567130762e-09,  5.346657577999627e-11, -9.135702054274507e-13,  1.437517251582553e-14, -2.106985477965667e-16,  2.902089060355722e-18,
 -3.782003759701841e-20,  5.737218134369299e-02, -4.903535707825741e-03,  2.333735229028381e-04, -8.069809061825782e-06,  2.250923085363837e-07, -5.352111522556500e-09,
  1.122098420319732e-10, -2.121810841302714e-12,  3.677510450364568e-14, -5.912750264192290e-16,  8.900941793137761e-18, -1.263585272850014e-19,  5.494067604149794e-02,
 -5.455712257879728e-03,  2.968906106478957e-04, -1.160548279535922e-05,  3.627624683370600e-07, -9.598352153571637e-09,  2.226244353133943e-10, -4.633966383642705e-12,
  8.802815717915419e-14, -1.545315793051795e-15,  2.531276487280483e-17, -3.897915694653046e-19,  5.246542879781525e-02, -5.974947485600317e-03,  3.682194679716747e-04,
 -1.614409261046253e-05,  5.616911987098704e-07, -1.643900282845921e-08,  4.195259723195350e-10, -9.564605524349979e-12,  1.982118826636720e-13, -3.782500325216064e-15,
  6.713854250715800e-17, -1.117038300919037e-18,  4.996890262885216e-02, -6.451806182380640e-03,  4.463310762843154e-04, -2.178835861801083e-05,  8.384461837585078e-07,
 -2.698966308984756e-08,  7.539679670702169e-10, -1.873822440405398e-11,  4.217586569569624e-13, -8.712864255329467e-15,  1.669224653161629e-16, -2.989408160711787e-18,
  4.747122502942174e-02, -6.878460258044356e-03,  5.298559629382797e-04, -2.860352431790958e-05,  1.210153938356151e-06, -4.261671321065242e-08,  1.296836107324366e-09,
 -3.497578037624589e-11,  8.514252449298842e-13, -1.896576395407250e-14,  3.907112407963618e-16, -7.504960715469235e-18,  4.499000381557852e-02, -7.248735238450618e-03,
  6.171399066167142e-04, -3.660724659366091e-05,  1.693205041768003e-06, -6.490196208483938e-08,  2.141368491611374e-09, -6.240346462113169e-11,  1.636371888726633e-12,
 -3.915485955102778e-14,  8.642567683957768e-16, -1.774477946940892e-17,  4.254024798902230e-02, -7.558089747656367e-03,  7.063118992563775e-04, -4.576192419862823e-05,
  2.301726262387909e-06, -9.556776891084511e-08,  3.403640750208507e-09, -1.067342495624400e-10,  3.003260969449349e-12, -7.691204961552025e-14,  1.812687823063206e-15,
 -3.965115680280473e-17,  4.013438079390814e-02, -7.803538762510369e-03,  7.953591955428565e-04, -5.597014700780904e-05,  3.045938251291284e-06, -1.363604475127931e-07,
  5.220031268933397e-09, -1.754510452263874e-10,  5.277726416057288e-12, -1.441522494420747e-13,  3.615552219151696e-15, -8.399081192693787e-17,  3.778232959077436e-02,
 -7.983532782249208e-03,  8.822044516986874e-04, -6.707366504362171e-05,  3.930542943035099e-06, -1.888951241565094e-07,  7.740840572723658e-09, -2.778047044168838e-10,
  8.901758577076384e-12, -2.584349256786790e-13,  6.875899483764707e-15, -1.691119006640818e-16,  3.549167600690944e-02, -8.097805393585946e-03,  9.647804862565135e-04,
 -7.885597429655742e-05,  4.953294501961371e-06, -2.544710683112754e-07,  1.111959881296128e-08, -4.245369437931514e-10,  1.444087859789243e-11, -4.441653628601099e-13,
  1.249658663829638e-14, -3.244338471880729e-16,  3.326784985692149e-02, -8.147201198484220e-03,  1.041098980143155e-03, -9.104832916686693e-05,  6.103900364801741e-06,
 -3.338719958002829e-07,  1.549813661792092e-08, -6.272528626421871e-10,  2.257396733632921e-11, -7.332509186087205e-13,  2.174953113847868e-14, -5.943098337274701e-16,
  3.111435132016697e-02, -8.133494911825020e-03,  1.109310360437387e-03, -1.033387461615586e-04,  7.363375775970653e-06, -4.271701014311902e-07,  2.098815772842531e-08,
 -8.974028970872846e-10,  3.405883195814504e-11, -1.164731122405260e-12,  3.631542983972003e-14, -1.041484917212524e-15,  2.903298754617287e-02, -8.059210845250875e-03,
  1.167753078419948e-03, -1.153833788555999e-04,  8.703939294120336e-06, -5.335549070972201e-07,  2.765074418434258e-08, -1.244888539082535e-09,  4.966849221878590e-11,
 -1.782879903243764e-12,  5.826476867330721e-14, -1.748906845507658e-15,  2.702411197273776e-02, -7.927450175875886e-03,  1.214991411939804e-03, -1.268195292279968e-04,
  1.008949252886817e-05, -6.512079682336026e-07,  3.547583510462935e-08, -1.676374204150158e-09,  7.009692451005786e-11, -2.633375600776098e-12,  8.994878364748194e-14,
 -2.818266062850287e-15,  2.508685694822796e-02, -7.741731530855420e-03,  1.249841730788687e-03, -1.372795156838325e-04,  1.147667991951822e-05, -7.772419523143875e-07,
  4.436413772426320e-08, -2.193459309739121e-09,  9.583838224858057e-11, -3.757375181426418e-12,  1.337744791293665e-13, -4.363531582306467e-15,  2.321935255485342e-02,
 -7.505848640472614e-03,  1.271387821404441e-03, -1.464046365635439e-04,  1.281647865312703e-05, -9.077178111812557e-07,  5.411406440712979e-08, -2.790927255748681e-09,
  1.270507221175740e-10, -5.183708164736148e-12,  1.918529616499455e-13, -6.498102755653419e-15,  2.141892668614255e-02, -7.223747222440523e-03,  1.278986355565253e-03,
 -1.538585378965920e-04,  1.405622908307976e-05, -1.037747229909775e-06,  6.441608940061301e-08, -3.455328412337722e-09,  1.634193112041267e-10, -6.919878718380321e-12,
  2.655352009854524e-13, -9.315143478832029e-15,  1.968228334005531e-02, -6.899421918680293e-03,  1.272263907062554e-03, -1.593394010435873e-04,  1.514198537716838e-05,
 -1.161679970448367e-06,  7.485637950231042e-08, -4.164161344996516e-09,  2.040427472555991e-10, -8.943047840161042e-12,  3.548809590916953e-13, -1.286219568497910e-14,
  1.800565769338472e-02, -6.536833039117869e-03,  1.251107084841014e-03, -1.625904945538598e-04,  1.602104641296048e-05, -1.273367958919963e-06,  8.493071892360923e-08,
 -4.885883765495999e-09,  2.473635057108764e-10, -1.119255112282008e-11,  4.581390649652328e-13, -1.711307779740443e-14,  1.638494780394579e-02, -6.139842074153676e-03,
  1.215647384039684e-03, -1.634087710028456e-04,  1.664451866797097e-05, -1.366490800521084e-06,  9.406870974235203e-08, -5.580911696950123e-09,  2.911647772376780e-10,
 -1.356567620382299e-11,  5.713422798316324e-13, -2.194195342945922e-14,  1.481582375320650e-02, -5.712164397913302e-03,  1.166242285645903e-03, -1.616513219882223e-04,
  1.696976541500351e-05, -1.434921547799063e-06,  1.016671058375858e-07, -6.203658481591655e-09,  3.326488158259121e-10, -1.591828625298822e-11,  6.881290580938810e-13,
 -2.710575932096106e-14,  1.329381572179911e-02, -5.257337265300729e-03,  1.103453989902995e-03, -1.572396239838639e-04,  1.696260846378058e-05, -1.473107522480388e-06,
  1.071300645510367e-07, -6.705537113681190e-09,  3.686024719395829e-10, -1.807139169138951e-11,  7.998908285027504e-13, -3.224135545815994e-14,  1.181438292444597e-02,
 -4.778701068330337e-03,  1.028026975243937e-03, -1.501616085898954e-04,  1.659916797996120e-05, -1.476439108394030e-06,  1.099132067072395e-07, -7.038716947270698e-09,
  3.956433988849378e-10, -1.982397226892499e-11,  8.963044951748006e-13, -3.688241618624161e-14,  1.037296556721698e-02, -4.279391821712177e-03,  9.408653569933953e-04,
 -1.404716700081074e-04,  1.586725031888148e-05, -1.441579780769981e-06,  1.095677711971843e-07, -7.160307980430492e-09,  4.105274779599108e-10, -2.097134129613764e-11,
  9.662490275716152e-13, -4.049815975770637e-14,  8.965022083623765e-03, -3.762342959631267e-03,  8.430107981758087e-04, -1.282887800157841e-04,  1.476722112911340e-05,
 -1.366733098525885e-06,  1.057809102801448e-07, -7.036560485201818e-09,  4.104864320786827e-10, -2.132729093928156e-11,  9.990317131542017e-13, -4.255188247107444e-14,
  7.586053933035588e-03, -3.230294725489594e-03,  7.356215160643569e-04, -1.137929183247543e-04,  1.331232927878341e-05, -1.251826680316573e-06,  9.840832976566185e-08,
 -6.646628769912699e-09,  3.935564782192913e-10, -2.074736247527068e-11,  9.857780582078615e-13, -4.257270076005115e-14,  6.231620381794744e-03, -2.685809756445303e-03,
  6.199527567874435e-04, -9.722004912365265e-05,  1.152847507140654e-05, -1.098598930753346e-06,  8.749602557675882e-08, -5.985463467699782e-09,  3.588558801523328e-10,
 -1.915004156352865e-11,  9.207855046766413e-13, -4.022995635287647e-14,  4.897346667090508e-03, -2.131294191662421e-03,  4.973390558049652e-04, -7.885589826101404e-05,
  9.453443954933323e-06, -9.105811408798312e-07,  7.328876433177458e-08, -5.065468445595460e-09,  3.067723673114318e-10, -1.653263163881376e-11,  8.026193964553894e-13,
 -3.539747507130218e-14,  3.578935481478805e-03, -1.569026823480392e-03,  3.691791599124903e-04, -5.902889340160420e-05,  7.135663365055673e-06, -6.929760018778663e-07,
  5.622419247492345e-08, -3.916684900971960e-09,  2.390308790768492e-10, -1.297908546601661e-11,  6.347495197289401e-13, -2.819512012102454e-14,  2.272252324287996e-03,
 -1.001225896653977e-03,  2.369307529392696e-04, -3.810364837238061e-05,  4.632685474794376e-06, -4.524529012730742e-07,  3.691373345776256e-08, -2.585489776419178e-09,
  1.586304372385185e-10, -8.658322560736908e-12,  4.255969333886354e-13, -1.899853640547855e-14,  9.748212733830707e-04, -4.307432514773652e-04,  1.022550665229680e-04,
 -1.649783995174286e-05,  2.012236835940026e-06, -1.971439882284485e-07,  1.613377551160536e-08, -1.133446573702725e-09,  6.974718290710085e-11, -3.817926103983573e-12,
  1.881992007555165e-13, -8.424297723309524e-15,  7.297605328817980e-02, -2.236844610074847e-04,  7.185487276522474e-07, -2.392491747875651e-09,  8.162641885315745e-12,
 -2.826373601886554e-14,  9.861868034184261e-17, -3.451090263925593e-19,  1.207553730806289e-21, -4.217344528510377e-24,  1.468640330824872e-26, -5.097043588725610e-29,
  7.230656883582412e-02, -3.130522781916931e-04,  1.582229107537080e-06, -8.076955027073438e-09,  4.016607151353359e-11, -1.940264857973574e-13,  9.137601281204275e-16,
 -4.211820679031079e-18,  1.906034064618029e-20, -8.488934538002820e-23,  3.727699345928896e-25, -1.616307535677565e-27,  7.098912374438611e-02, -4.864591499528688e-04,
  3.589708230703118e-06, -2.451247715411407e-08,  1.566586747582726e-10, -9.520790276067446e-13,  5.559823076125907e-15, -3.141402556278062e-17,  1.725849304448811e-19,
 -9.253559450143370e-22,  4.856193328590144e-24, -2.500095488641202e-26,  6.906547335127396e-02, -7.336898526267995e-04,  7.253400697458983e-06, -6.293353725227671e-08,
  4.992133897023592e-10, -3.704685730544716e-12,  2.607899932703950e-14, -1.757699602926780e-16,  1.141859773141209e-18, -7.185710295466162e-21,  4.397434768843805e-23,
 -2.624977395172813e-25,  6.659513851805589e-02, -1.040477385854595e-03,  1.323025534864248e-05, -1.424809393926499e-07,  1.374029127501103e-09, -1.220774384093718e-11,
  1.016701605382114e-13, -8.030076720001734e-16,  6.064799333865836e-18, -4.407263728101662e-20,  3.096335140118810e-22, -2.110932499881364e-24,  6.365198806341023e-02,
 -1.389637501751672e-03,  2.220833724146017e-05, -2.917847591759609e-07,  3.366707072045852e-09, -3.528638411298020e-11,  3.429290033221542e-13, -3.133032129047954e-15,
  2.717240528089478e-17, -2.253429188327354e-19,  1.796947935873751e-21, -1.383868971366488e-23,  6.032016777465566e-02, -1.762381190218044e-03,  3.478580167275487e-05,
 -5.495024061077184e-07,  7.488015707350827e-09, -9.149647432070161e-11,  1.026345250180387e-12, -1.073571419715716e-14,  1.058848759233574e-16, -9.928341587618373e-19,
  8.906471656921548e-21, -7.681764980779223e-23,  5.668971445437396e-02, -2.139670751375597e-03,  5.136084426176263e-05, -9.630869854537067e-07,  1.532867805927919e-08,
 -2.162003536265196e-10,  2.773709742692825e-12, -3.293508017782447e-14,  3.664292545895996e-16, -3.854927058482212e-18,  3.861707271772973e-20, -3.703792671422604e-22,
  5.285219545592557e-02, -2.503490183379305e-03,  7.204859477950920e-05, -1.585443258446502e-06,  2.918689091044252e-08, -4.710552719788622e-10,  6.856983837820809e-12,
 -9.174313054886452e-14,  1.143417449328600e-15, -1.340721775816610e-17,  1.490349457976784e-19, -1.579890256519096e-21,  4.889668076160800e-02, -2.837921171988042e-03,
  9.663583931714570e-05, -2.469626057977505e-06,  5.212344649091471e-08, -9.551100866300958e-10,  1.566320381571035e-11, -2.345851323614252e-13,  3.254960337122750e-15,
 -4.229067313561449e-17,  5.187476317033770e-19, -6.045630065478827e-21,  4.490629337082182e-02, -3.129947656653996e-03,  1.245780090567793e-04, -3.662219569001790e-06,
  8.790117500258108e-08, -1.815708239647920e-09,  3.332904547591598e-11, -5.554200874781444e-13,  8.531948321483821e-15, -1.221841999210384e-16,  1.645521322392864e-18,
 -2.098185409593706e-20,  4.095550505071043e-02, -3.369949194705468e-03,  1.550363185035747e-04, -5.196385266752217e-06,  1.407801153438465e-07, -3.256481374541087e-09,
  6.650773863253792e-11, -1.226453936040029e-12,  2.075012120323711e-14, -3.259460104906429e-16,  4.797422073989096e-18, -6.663291102525231e-20,  3.710825980509616e-02,
 -3.551880431539918e-03,  1.869474047014765e-04, -7.085701735739659e-06,  2.151653983391350e-07, -5.539235507005386e-09,  1.251668944029077e-10, -2.541039060599865e-12,
  4.712353049798918e-14, -8.082734360332966e-16,  1.294593652436936e-17, -1.950647182643726e-19,  3.341692731676987e-02, -3.673166020615529e-03,  2.191141124699490e-04,
 -9.319818801698525e-06,  3.151356554800636e-07, -8.976776328138315e-09,  2.232486342183731e-10, -4.965327299625269e-12,  1.004777250755016e-13, -1.873877611924851e-15,
  3.252986055619232e-17, -5.296950534935148e-19,  2.992202139403649e-02, -3.734363939694708e-03,  2.503045471490338e-04, -1.186264659462217e-05,  4.439082321856482e-07,
 -1.391481384445471e-08,  3.789744299730024e-10, -9.192033810605382e-12,  2.021018746526858e-13, -4.081741242163354e-15,  7.650645757537811e-17, -1.341417135095242e-18,
  2.665256928119822e-02, -3.738663737894519e-03,  2.793470913754473e-04, -1.465337496401516e-05,  6.033163203705259e-07, -2.070290443528603e-08,  6.145685639794808e-10,
 -1.618510725188304e-11,  3.850702234736426e-13, -8.389829903741490e-15,  1.691767127976520e-16, -3.182921548090354e-18,  2.362698849106725e-02, -3.691289962637926e-03,
  3.052113211934220e-04, -1.761016640275323e-05,  7.933775305634152e-07, -2.965657000955211e-08,  9.552214025216230e-10, -2.720052491240254e-11,  6.975440149523145e-13,
 -1.633529791183042e-14,  3.531326457706720e-16, -7.105628306344982e-18,  2.085431763720950e-02, -3.598876355644396e-03,  3.270680202156242e-04, -2.063597646800738e-05,
  1.012022309425060e-06, -4.101477671350130e-08,  1.427218151567921e-09, -4.376734785408782e-11,  1.205272209654342e-12, -3.023064602279263e-14,  6.982748139144290e-16,
 -1.497899996441606e-17,  1.833565352786195e-02, -3.468865709240525e-03,  3.443250929718827e-04, -2.362569437022533e-05,  1.255026659522082e-06, -5.489835894776714e-08,
  2.055305048873483e-09, -6.761576002883564e-11,  1.992291333764022e-12, -5.333836834235035e-14,  1.312140773083112e-15, -2.991485196640448e-17,  1.606566427353224e-02,
 -3.308976168105746e-03,  3.566395209921594e-04, -2.647369243164429e-05,  1.516162298844678e-06, -7.127538315657325e-08,  2.859523552552882e-09, -1.005454349525146e-10,
  3.158780059873850e-12, -8.996959752615485e-14,  2.349821120404845e-15, -5.676610874945530e-17,  1.403407276038588e-02, -3.126759706858149e-03,  3.639081612627674e-04,
 -2.908092086484357e-05,  1.787545328164151e-06, -8.993874601287358e-08,  3.851877987986458e-09, -1.442374761978167e-10,  4.815228912416787e-12, -1.454420399268038e-13,
  4.020702740251425e-15, -1.026211937404718e-16,  1.222703231030335e-02, -2.929264482278052e-03,  3.662419356689203e-04, -3.136085098403724e-05,  2.060137733039634e-06,
 -1.104996412764166e-07,  5.033280720307047e-09, -2.000245673907499e-10,  7.072561899277895e-12, -2.258351475472165e-13,  6.588479842524118e-15, -1.771597172390006e-16,
  1.062834325111728e-02, -2.722801078271483e-03,  3.639287729966288e-04, -3.324380768860158e-05,  2.324338870339476e-06, -1.323982651845468e-07,  6.391221076369988e-09,
 -2.686444079768608e-10,  1.002854352683089e-11, -3.375001041576818e-13,  1.036068675971420e-14, -2.926877271666144e-16,  9.220483037181319e-03, -2.512804004603878e-03,
  3.573906601524699e-04, -3.467949048703685e-05,  2.570598237817816e-06, -1.549307228313183e-07,  7.898527434149854e-09, -3.500085659215019e-10,  1.375159933215053e-11,
 -4.863190115454979e-13,  1.566475692070330e-14, -4.636520638906861e-16,  7.985442090646239e-03, -2.303774287821474e-03,  3.471395429527544e-04, -3.563771860104383e-05,
  2.789985647056277e-06, -1.772889954004972e-07,  9.513451279514272e-09, -4.430207687803033e-10,  1.826390362432969e-11, -6.767569555832096e-13,  2.280944347551840e-14,
 -7.054633822560461e-16,  6.905372159236628e-03, -2.099286304157249e-03,  3.337358266422528e-04, -3.610762042459921e-05,  2.974667939782972e-06, -1.986093669645921e-07,
  1.118112570939618e-08, -5.454747295002831e-10,  2.352607456461054e-11, -9.108032904570449e-13,  3.203320956763629e-14, -1.032548153823824e-15,  5.963063857544696e-03,
 -1.902041603055119e-03,  3.177520851090434e-04, -3.609560668174361e-05,  3.118259166183434e-06, -2.180240595797721e-07,  1.283627232229119e-08, -6.540524860143837e-10,
  2.942593616160599e-11, -1.186942902275706e-12,  4.344446180002605e-14, -1.455698302071435e-15,  5.142275763360234e-03, -1.713953712131455e-03,  2.997434745506658e-04,
 -3.562251953997222e-05,  3.216030141353090e-06, -2.347109819510786e-07,  1.440688053643600e-08, -7.644316212379477e-10,  3.577350733816606e-11, -1.499323214905016e-12,
  5.696157213942440e-14, -1.978971277961387e-15,  4.427939791701202e-03, -1.536250172051567e-03,  2.802253842957957e-04, -3.472034618162546e-05,  3.264980544249848e-06,
 -2.479373135528827e-07,  1.581848407460414e-08, -8.714959361496928e-10,  4.230369692161545e-11, -1.837280474731531e-12,  7.226274287220107e-14, -2.596575051407501e-15,
  3.806267439120277e-03, -1.369580784592544e-03,  2.596581102821637e-04, -3.342884000828732e-05,  3.263790212950990e-06, -2.570938904983467e-07,  1.699862049376889e-08,
 -9.696315423872213e-10,  4.868723533528443e-11, -2.185357094309022e-12,  8.875626560009668e-14, -3.290304854286276e-15,  3.264779694775029e-03, -1.214123856120303e-03,
  2.384378235379794e-04, -3.179232243769037e-05,  3.212675069829929e-06, -2.617187746914608e-07,  1.788107896310977e-08, -1.053080842456088e-09,  5.454932271353750e-11,
 -2.523884422367536e-12,  1.055802577144349e-13, -4.028138233756279e-15,  2.792280643820255e-03, -1.069684800656473e-03,  2.168928108042731e-04, -2.985685839648257e-05,
  3.113177163595293e-06, -2.615097436272451e-07,  1.840960725367822e-08, -1.116321617035606e-09,  5.949449315646550e-11, -2.830131386851801e-12,  1.216375863830723e-13,
 -4.764514756552222e-15,  2.378791582148592e-03, -9.357836691326054e-04,  1.952838504647643e-04, -2.766792110963006e-05,  2.967918302555635e-06, -2.563265644285024e-07,
  1.854084386316764e-08, -1.154437697965845e-09,  6.313543374756795e-11, -3.079941315658824e-12,  1.356668830953883e-13, -5.442624449084635e-15,  2.015459206904348e-03,
 -8.117299269210616e-04,  1.738076087774309e-04, -2.526859468397284e-05,  2.780343714923706e-06, -2.461847154608190e-07,  1.824634685285958e-08, -1.163450947117160e-09,
  6.512305077872791e-11, -3.249709608791496e-12,  1.463451001570398e-13, -5.998730812144033e-15,  1.694448397856545e-03, -6.966841113463002e-04,  1.526020537026654e-04,
 -2.269831053356039e-05,  2.554477256482090e-06, -2.312426650422137e-07,  1.751369100698197e-08, -1.140590418276389e-09,  6.517497787964670e-11, -3.318504470726083e-12,
  1.524119003310090e-13, -6.368209924764396e-15,  1.408827405974620e-03, -5.897069093731051e-04,  1.317530468452501e-04, -1.999207704582741e-05,  2.294703949962835e-06,
 -2.117849373482270e-07,  1.634668742770503e-08, -1.084482340728743e-09,  6.309994662833542e-11, -3.270108419166368e-12,  1.528021918410012e-13, -6.492660211874860e-15,
  1.152450984637059e-03, -4.897967719412855e-04,  1.113014574009726e-04, -1.718014002030436e-05,  2.005589930816176e-06, -1.882030545039278e-07,  1.476483803842871e-08,
 -9.952526565632560e-10,  5.881592175722778e-11, -3.094761994062428e-12,  1.467709975103749e-13, -6.327191382714780e-15,  9.198451614922265e-04, -3.959175081951908e-04,
  9.125032531558833e-05, -1.428800222054118e-05,  1.691744802745187e-06, -1.609761237377133e-07,  1.280217028125976e-08, -8.745412546153851e-10,  5.236055020428545e-11,
 -2.790420962764443e-12,  1.339949298712555e-13, -5.846886150901303e-15,  7.060960236204931e-04, -3.070174945565757e-04,  7.157178033120926e-05, -1.133673250102427e-05,
  1.357727489880524e-06, -1.306524379617194e-07,  1.050560841454066e-08, -7.254332048258561e-10,  4.389319844156208e-11, -2.363389318495572e-12,  1.146368379006763e-13,
 -5.051472275221247e-15,  5.067446776641876e-04, -2.220425404145844e-04,  5.221366016401076e-05, -8.343516383217341e-06,  1.007995357520906e-06, -9.783317767334604e-08,
  7.933042913131622e-09, -5.523176659805215e-10,  3.368862064434086e-11, -1.828257721468226e-12,  8.936447920397462e-14, -3.967449566214721e-15,  3.176981138465953e-04,
 -1.399480967417593e-04,  3.310676814205909e-05, -5.322551902013005e-06,  6.469115188826498e-07, -6.316055868470164e-08,  5.151376447010147e-09, -3.606976052907474e-10,
  2.212353520327880e-11, -1.207179350164298e-12,  5.932107373212398e-14, -2.647316822511766e-15,  1.353405321344284e-04, -5.979395723201090e-05,  1.419222714714198e-05,
 -2.289380556475508e-06,  2.791869690815423e-07, -2.734798066740813e-08,  2.237711959191274e-09, -1.571797350702583e-10,  9.670533270180394e-12, -5.292738948894538e-13,
  2.608560353502326e-14, -1.167476483179168e-15,  7.209263347326636e-02, -2.180487326929515e-04,  6.906041940065576e-07, -2.266286285351402e-09,  7.620274926829930e-12,
 -2.600861414735528e-14,  8.947457105072250e-17, -3.087873606146463e-19,  1.065784914482938e-21, -3.672360921780207e-24,  1.261918522001093e-26, -4.322141523196137e-29,
  7.107907658465304e-02, -3.007715013742808e-04,  1.489037285669842e-06, -7.464189469100077e-09,  3.649563639995896e-11, -1.734452164899447e-13,  8.039284999982802e-16,
 -3.648041722114003e-18,  1.625643170207248e-20, -7.130823443821492e-23,  3.084586356766339e-25, -1.317709268101655e-27,  6.909891783454371e-02, -4.588768733488902e-04,
  3.309992059217022e-06, -2.215130920839744e-08,  1.388833040974397e-10, -8.286038113227462e-13,  4.752795711006177e-15, -2.638887234239154e-17,  1.425189131008882e-19,
 -7.514327840156551e-22,  3.878911415731741e-24, -1.964762062223748e-26,  6.624216994537913e-02, -6.785530889904360e-04,  6.543783401202071e-06, -5.550646771022660e-08,
  4.310003558973126e-10, -3.133946913017484e-12,  2.163240014254854e-14, -1.430512947041027e-16,  9.122379041679286e-19, -5.637618452766831e-21,  3.389332384560453e-23,
 -1.988240542095368e-25,  6.263458871226973e-02, -9.411184230683241e-04,  1.164474323860843e-05, -1.223244025294428e-07,  1.152561283026100e-09, -1.001692511174887e-11,
  8.168050004656567e-14, -6.321000509612138e-16,  4.680420848590184e-18, -3.336274272210310e-20,  2.300156299626575e-22, -1.539467983109059e-24,  5.842782139952853e-02,
 -1.225111599165527e-03,  1.900820608774663e-05, -2.431442381490077e-07,  2.736654338884637e-09, -2.801755920366658e-11,  2.662501969366605e-13, -2.380549324942638e-15,
  2.021944209887477e-17, -1.643126464236775e-19,  1.284611905018722e-21, -9.703730123555461e-24,  5.378815606291139e-02, -1.508565012335619e-03,  2.885430636500136e-05,
 -4.430909520745465e-07,  5.881907566249928e-09, -7.011923021462110e-11,  7.682628762896476e-13, -7.856620110285226e-15,  7.581662804232846e-17, -6.960187533228679e-19,
  6.116658472472604e-21, -5.170784305839347e-23,  4.888509110496062e-02, -1.771149363046918e-03,  4.114357474104119e-05, -7.490945225962126e-07,  1.160200466873401e-08,
 -1.594908093863493e-10,  1.996779052136604e-12, -2.316086264533175e-14,  2.519296287021945e-16, -2.593057399801404e-18,  2.543056533908749e-20, -2.389174909178735e-22,
  4.388085055096910e-02, -1.995925831577727e-03,  5.554106557444939e-05, -1.185684681640205e-06,  2.122300349661193e-08, -3.335867297524388e-10,  4.735344551052454e-12,
 -6.184929137709651e-14,  7.531770823753132e-16, -8.635677807492173e-18,  9.392998185718570e-20, -9.749070718696772e-22,  3.892173387902337e-02, -2.170528285418461e-03,
  7.143433726242410e-05, -1.770081911645586e-06,  3.630371650727907e-08, -6.475193491041829e-10,  1.034996114941071e-11, -1.512495618550455e-13,  2.049647039515121e-15,
 -2.602960113315118e-17,  3.123030334342924e-19, -3.562336828568958e-21,  3.413186373927193e-02, -2.287702681933289e-03,  8.799908484086000e-05, -2.507633477943009e-06,
  5.847000716529494e-08, -1.175231973487113e-09,  2.101941410236599e-11, -3.416834810217986e-13,  5.124707662088964e-15, -7.171574980181081e-17,  9.444952061016878e-19,
 -1.178484386319985e-20,  2.960954275819874e-02, -2.345232276278979e-03,  1.042973056973910e-04, -3.388667165326081e-06,  8.917691840281855e-08, -2.006999292682124e-09,
  3.993321505796904e-11, -7.182273619810226e-13,  1.186308233606689e-14, -1.820767134687163e-16,  2.620432884588738e-18, -3.561267267691496e-20,  2.542610898470773e-02,
 -2.345357858965008e-03,  1.193882676436475e-04, -4.387552708365825e-06,  1.294360082632699e-07, -3.242309826345964e-09,  7.138050401590611e-11, -1.413404542868383e-12,
  2.559022340368451e-14, -4.288864281642555e-16,  6.717262111446122e-18, -9.904000181856460e-20,  2.162693043782039e-02, -2.293851522008160e-03,  1.324326373658178e-04,
 -5.464267838337613e-06,  1.795610574531833e-07, -4.978199557200125e-09,  1.206487637358785e-10, -2.617777772635756e-12,  5.172678492068661e-14, -9.427819613112974e-16,
  1.600673050347904e-17, -2.550914144014191e-19,  1.823402456531905e-02, -2.198917922335110e-03,  1.427741212311477e-04, -6.568214725885582e-06,  2.389876105943322e-07,
 -7.294357013777712e-09,  1.936727748220479e-10, -4.584296504950294e-12,  9.845407063655900e-14, -1.943873187351872e-15,  3.564523110198282e-17, -6.118502101885854e-19,
  1.524973011832672e-02, -2.070083134612930e-03,  1.499893102425655e-04, -7.643576334592431e-06,  3.062092881672888e-07, -1.023742523570045e-08,  2.964222954443952e-10,
 -7.622048772926873e-12,  1.772140039351332e-13, -3.776246197565336e-15,  7.452661139898518e-17, -1.373259877424298e-18,  1.266088303712616e-02, -1.917196890567415e-03,
  1.539033268627000e-04, -8.635247387720526e-06,  3.788499892440063e-07, -1.380751152064810e-08,  4.340815635035902e-10, -1.207620366014840e-11,  3.028173409159664e-13,
 -6.939478459911836e-15,  1.469038756105912e-16, -2.896535280390606e-18,  1.044303093966795e-02, -1.749629805199346e-03,  1.545748248135275e-04, -9.494357437381291e-06,
  4.538628873313344e-07, -1.794975995766897e-08,  6.101369282548104e-10, -1.829344049444337e-11,  4.929357381956651e-13, -1.210689250781191e-14,  2.740216964950978e-16,
 -5.763562344419207e-18,  8.564336238636229e-03, -1.575702696212538e-03,  1.522579356367731e-04, -1.018259200613024e-05,  5.278221967512162e-07, -2.255295809077299e-08,
  8.255308017204454e-10, -2.657556383099973e-11,  7.668259586590330e-13, -2.011856053923327e-14,  4.853226549763741e-16, -1.085664021972246e-17,  6.988941681079774e-03,
 -1.402347369514450e-03,  1.473505716825735e-04, -1.067483428220480e-05,  5.972580401409524e-07, -2.745577697028105e-08,  1.078046117050410e-09, -3.712740418855084e-11,
  1.143275668359339e-12, -3.193838278040468e-14,  8.186577756906697e-16, -1.942050027834408e-17,  5.679685823227679e-03, -1.234971153906709e-03,  1.403383109597466e-04,
 -1.096000155427229e-05,  6.589810903199217e-07, -3.245975706339460e-08,  1.362051788802978e-09, -5.000748173551594e-11,  1.637942228010693e-12, -4.856955061657324e-14,
  1.318917201032312e-15, -3.308521047011213e-17,  4.600148246695728e-03, -1.077481949347247e-03,  1.317414719276452e-04, -1.104025692944932e-05,  7.103511793736211e-07,
 -3.734692953975175e-08,  1.668674517852810e-09, -6.509047614235628e-11,  2.260431610891832e-12, -7.093086612586321e-14,  2.034652941875640e-15, -5.382164635506997e-17,
  3.716070436271218e-03, -9.324253299918309e-04,  1.220706205436481e-04, -1.092898668333240e-05,  7.494593059264558e-07, -4.189927155830108e-08,  1.986382803691173e-09,
 -8.204903045933316e-11,  3.011582596655392e-12, -9.970599993533795e-14,  3.012600268698364e-15, -8.380569388107432e-17,  2.996238610311462e-03, -8.011877843811682e-04,
  1.117932596398805e-04, -1.064802959030999e-05,  7.752107929876797e-07, -4.591713097552715e-08,  2.301895301392268e-09, -1.003591591436250e-10,  3.881443395022523e-12,
 -1.351863219536054e-13,  4.290464835981394e-15, -1.251806019173298e-16,  2.412933212107394e-03, -6.842275648114073e-04,  1.013122833501900e-04, -1.022463804920300e-05,
  7.873143997049165e-07, -4.923424524438429e-08,  2.601274444659781e-09, -1.193293521500390e-10,  4.848342088296203e-12, -1.771329329369947e-13,  5.888823364100439e-15,
 -1.797276020508141e-16,  1.942051623794462e-03, -5.813041943101661e-04,  9.095518363974708e-05, -9.688570655856375e-06,  7.861949102823617e-07, -5.172782750025786e-08,
  2.871046621064452e-09, -1.381493934337435e-10,  5.879277383385367e-12, -2.246833045796015e-13,  7.803357128276729e-15, -2.484789106478157e-16,  1.563001566873444e-03,
 -4.916873941437939e-04,  8.097203600486361e-05, -9.069596891384005e-06,  7.728537405188694e-07, -5.332316234323883e-08,  3.099202213969778e-09, -1.559518553508533e-10,
  6.931634503799677e-12, -2.763222550114321e-13,  9.998787418336214e-15, -3.313284985659380e-16,  1.258447548973703e-03, -4.143347244503256e-04,  7.153990055453343e-05,
 -8.395568247233248e-06,  7.487035842112164e-07, -5.399303201913905e-08,  3.275965186405344e-09, -1.718777497722014e-10,  7.956014826264995e-12, -3.299270781301194e-13,
  1.240575281218962e-14, -4.267084345755596e-16,  1.013975438013954e-03, -3.480339171337451e-04,  6.277131545106794e-05, -7.691099142628370e-06,  7.154002889398134e-07,
 -5.375293750043034e-08,  3.394271162486348e-09, -1.851380223547680e-10,  8.899803555726567e-12, -3.828848055481967e-13,  1.492147538647019e-14, -5.313979219402502e-16,
  8.177234199101255e-04, -2.915105762591124e-04,  5.472487474116243e-05, -6.976817893152914e-06,  6.746896935960740e-07, -5.265342935650061e-08,  3.449943340850271e-09,
 -1.950641782850959e-10,  9.711016316221816e-12, -4.322684512494551e-13,  1.741449081329979e-14, -6.405173665293965e-16,  6.600127729913726e-04, -2.435048109436552e-04,
  4.741632990313189e-05, -6.269096194754131e-06,  6.282807367816783e-07, -5.077093487225581e-08,  3.441597687299560e-09, -2.011437847429521e-10,  1.034196959780038e-11,
 -4.750509139440885e-13,  1.973309115243966e-14, -7.477335619402653e-16,  5.329997747186786e-04, -2.028218031381217e-04,  4.082912549430084e-05, -5.580142113259292e-06,
  5.777500595130083e-07, -4.819832401721153e-08,  3.370337273400170e-09, -2.030392968182736e-10,  1.075239791479559e-11, -5.083313039474696e-13,  2.171657926064257e-14,
 -8.456697828896324e-16,  4.303607601480735e-04, -1.683616997683802e-04,  3.492370390095123e-05, -4.918339942394271e-06,  5.244783940783788e-07, -4.503618165096262e-08,
  3.239308969993942e-09, -2.005910746871913e-10,  1.091176557235967e-11, -5.295490167114955e-13,  2.320806104624760e-14, -9.264828884878752e-16,  3.470156360591243e-04,
 -1.391339277468636e-04,  2.964525634823066e-05, -4.288733014655562e-06,  4.696156009660873e-07, -4.138542813448834e-08,  3.053195754252079e-09, -1.938072542854889e-10,
  1.080066214901886e-11, -5.366651181042793e-13,  2.406735684435450e-14, -9.825445220369976e-16,  2.788906022107193e-04, -1.142603643151903e-04,  2.492984684309032e-05,
 -3.693565773098821e-06,  4.140692726435548e-07, -3.734161919796779e-08,  2.817708282356856e-09, -1.828441589097335e-10,  1.041130075143564e-11, -5.282971535653328e-13,
  2.418269193938151e-14, -1.007149235708420e-15,  2.227179724003361e-04, -9.297097596613167e-05,  2.070899911234042e-05, -3.132823822259393e-06,  3.585111266617922e-07,
 -3.299099905615664e-08,  2.539124312725537e-09, -1.679812273387525e-10,  9.747237786445564e-12, -5.038007866599298e-13,  2.348008074396222e-14, -9.951702867946948e-16,
  1.758693783778543e-04, -7.459471338906238e-05,  1.691292913872905e-05, -2.604731734303899e-06,  3.033956231595316e-07, -2.840819659965368e-08,  2.223907821838645e-09,
 -1.495941341754089e-10,  8.822493515832479e-12, -4.632983528192843e-13,  2.192967686757045e-14, -9.435928307717540e-16,  1.362179001876828e-04, -5.854770343212278e-05,
  1.347264592553748e-05, -2.106186190410010e-06,  2.489860248551095e-07, -2.365534418265790e-08,  1.878424084900918e-09, -1.281290933988312e-10,  7.660274257617926e-12,
 -4.076595577932753e-13,  1.954874651427133e-14, -8.518713616660825e-16,  1.020245059352364e-04, -4.432015759804774e-05,  1.032114923579475e-05, -1.633116106059508e-06,
  1.953842067587572e-07, -1.878235423331315e-08,  1.508754490832818e-09, -1.040804809184858e-10,  6.291487192600699e-12, -3.384427811881758e-13,  1.640127482583195e-14,
 -7.220798902294794e-16,  7.184446253441599e-05, -3.146296968724029e-05,  7.393949121678895e-06, -1.180773367093356e-06,  1.425618881921968e-07, -1.382811297331301e-08,
  1.120607569032735e-09, -7.797315399410148e-11,  4.753213593779956e-12, -2.578071435287299e-13,  1.259451114171048e-14, -5.588466813425594e-16,  4.445086276458665e-05,
 -1.957510675611629e-05,  4.629226878343538e-06, -7.439840614964802e-07,  9.039438872739204e-08, -8.822615004735919e-09,  7.193359771535101e-10, -5.035138393028861e-11,
  3.087343361583546e-12, -1.684096843829125e-13,  8.273165405710287e-15, -3.690957091849699e-16,  1.879710306407526e-05, -8.303367725891216e-06,  1.970480642609735e-06,
 -3.178063011932199e-07,  3.874918114067757e-08, -3.795037646748305e-09,  3.104697254212206e-10, -2.180403146287899e-11,  1.341271873165884e-12, -7.339627324392468e-14,
  3.616783932621892e-15, -1.618449554255674e-16,  7.123131884684269e-02, -2.126306469571991e-04,  6.641235093619544e-07, -2.148409461795965e-09,  7.120895622608458e-12,
 -2.396124188132836e-14,  8.128679538991143e-17, -2.767037019340382e-19,  9.422257242104349e-22, -3.203634113943980e-24,  1.086441814032889e-26, -3.672880021565198e-29,
  6.989926157244143e-02, -2.892078143644137e-04,  1.402859422674514e-06, -6.906995899917037e-09,  3.321169518740664e-11, -1.553201808353312e-13,  7.086966361186906e-16,
 -3.166637023131628e-18,  1.389813773988413e-20, -6.005497452436450e-23,  2.559527378861666e-25, -1.077467688920909e-27,  6.731473843450715e-02, -4.334236438812185e-04,
  3.056981678417467e-06, -2.005579756731842e-08,  1.233946099718568e-10, -7.229119924192116e-13,  4.073893096983308e-15, -2.223275896235443e-17,  1.180637620560023e-19,
 -6.122685773243454e-22,  3.109478387022773e-24, -1.549950895886644e-26,  6.362859907889225e-02, -6.287544869919355e-04,  5.917101209892491e-06, -4.908498968696764e-08,
  3.732050382076371e-10, -2.659714473843608e-12,  1.800690659815879e-14, -1.168614873611799e-16,  7.317168997005489e-19, -4.441855282481108e-21,  2.624044851709240e-23,
 -1.513042247367185e-25,  5.904755760352016e-02, -8.535331142273115e-04,  1.028121440028203e-05, -1.053853453640996e-07,  9.704754773205673e-10, -8.253103748925078e-12,
  6.590990034939464e-14, -4.998922763902122e-16,  3.629856794876267e-18, -2.538619032623752e-20,  1.717958470597646e-22, -1.129047092253532e-24,  5.381402477656849e-02,
 -1.084012942337708e-03,  1.633576819589252e-05, -2.035148020491427e-07,  2.235160011182856e-09, -2.235943630364864e-11,  2.078300133023280e-13, -1.819032761536811e-15,
  1.513470071472181e-17, -1.205505436760326e-19,  9.242352831736235e-22, -6.849448280428872e-24,  4.818401590544671e-02, -1.297499473048703e-03,  2.405865140878676e-05,
 -3.592678365156596e-07,  4.647411663487014e-09, -5.406816068874759e-11,  5.787890450601087e-13, -5.788291418640953e-15,  5.466567791250454e-17, -4.914617058938652e-19,
  4.232017461074011e-21, -3.507296243305830e-23,  4.240601526498301e-02, -1.475028097999064e-03,  3.317083809349520e-05, -5.865823189457582e-07,  8.843252667699025e-09,
 -1.185188982780641e-10,  1.448394739368311e-12, -1.641526219130918e-14,  1.746100069034572e-16, -1.758764195515354e-18,  1.688987550070159e-20, -1.554651524418174e-22,
  3.670322055762577e-02, -1.603207185025542e-03,  4.314859416961122e-05, -8.938588595074583e-07,  1.556042193663016e-08, -2.382596016973131e-10,  3.298972828519806e-12,
 -4.207299563943680e-14,  5.007154020686582e-16, -5.614942817669624e-18,  5.977187990887458e-20, -6.075157453002091e-22,  3.126078924736593e-02, -1.675046095920770e-03,
  5.329123066149415e-05, -1.280646046747964e-06,  2.552920688549336e-08, -4.433152887123247e-10,  6.907905432786598e-12, -9.851954378841954e-14,  1.304152282202819e-15,
 -1.619137521816621e-17,  1.900480605871241e-19, -2.122100173120926e-21,  2.621876166673755e-02, -1.689795738424726e-03,  6.282558953434328e-05, -1.735688773793308e-06,
  3.932161079491333e-08, -7.691886984872145e-10,  1.340666417909588e-11, -2.126165594803436e-13,  3.114054969314786e-15, -4.259053261123092e-17,  5.485988436222790e-19,
 -6.699148205850723e-21,  2.167044196500295e-02, -1.651997118689892e-03,  7.102136156584201e-05, -2.237020226048714e-06,  5.719036945472515e-08, -1.252432257773001e-09,
  2.428032615023215e-11, -4.259707933890341e-13,  6.869564727164629e-15, -1.030299967027675e-16,  1.450048232381017e-18, -1.928440055800063e-20,  1.766532934749432e-02,
 -1.570031853924938e-03,  7.729195592649237e-05, -2.754222828093976e-06,  7.893935143005196e-08, -1.924151219500906e-09,  4.127400727857280e-11, -7.971798832163799e-13,
  1.409200435932842e-14, -2.307893516713621e-16,  3.534813789583461e-18, -5.100144522879706e-20,  1.421528880474923e-02, -1.454490731666730e-03,  8.126250422042875e-05,
 -3.252395159358264e-06,  1.038637385767566e-07, -2.802590471502420e-09,  6.619042167234716e-11, -1.401074247246519e-12,  2.703405513123194e-14, -4.815465993672070e-16,
  7.996261749238428e-18, -1.247199805601160e-19,  1.130253844171425e-02, -1.316634522346309e-03,  8.279669512682836e-05, -3.696939149545032e-06,  1.307823104970343e-07,
 -3.886511497968030e-09,  1.005931999657716e-10, -2.323577715030442e-12,  4.874218825226770e-14, -9.407724573809846e-16,  1.687664487447754e-17, -2.835927599105941e-19,
  8.888157314017471e-03, -1.167139441258204e-03,  8.198421833179304e-05, -4.058141840435994e-06,  1.581605248453949e-07, -5.151130139732511e-09,  1.454645365559061e-10,
 -3.651676674140394e-12,  8.296273553870403e-14, -1.728858820088328e-15,  3.339191530937869e-17, -6.025692246472953e-19,  6.920099104495613e-03, -1.015224765511635e-03,
  7.909812568169625e-05, -4.314674462810980e-06,  1.842999700475520e-07, -6.547888948107760e-09,  2.008905588997499e-10, -5.459342889652892e-12,  1.338404547697773e-13,
 -3.001017750285788e-15,  6.220393554055663e-17, -1.201693400350556e-18,  5.340043330061190e-03, -8.681744786471700e-04,  7.453517579744702e-05, -4.455481186011049e-06,
  2.075545208770532e-07, -8.008425643446012e-09,  2.658528430034565e-10, -7.791692038861708e-12,  2.054029225859766e-13, -4.939165611116502e-15,  1.095235073358212e-16,
 -2.258364233162378e-18,  4.088752013118047e-03, -7.312022490212645e-04,  6.875230031381088e-05, -4.479948496030294e-06,  2.265300709783262e-07, -9.452070789290428e-09,
  3.381859421583557e-10, -1.065065575314900e-11,  3.008850461023434e-13, -7.734277909805462e-15,  1.829180913356916e-16, -4.014151923945400e-18,  3.109876103456210e-03,
 -6.075742258057696e-04,  6.220970839039729e-05, -4.396609658542335e-06,  2.402326038888165e-07, -1.079539005555785e-08,  4.147236217979927e-10, -1.398558078070234e-11,
  4.220065840143075e-13, -1.155994308927766e-14,  2.907298224940164e-16, -6.770947415501166e-18,  2.352349464121167e-03, -4.988944942523510e-04,  5.532719142668149e-05,
 -4.220867861321556e-06,  2.481446827278915e-07, -1.196190811090816e-08,  4.916123900595421e-10, -1.769131787029628e-11,  5.683505407358926e-13, -1.654049097104062e-14,
  4.410856576299186e-16, -1.087188669053579e-17,  1.771618095541342e-03, -4.054667959274596e-04,  4.845615620181086e-05, -3.972293948611868e-06,  2.502277942125234e-07,
 -1.289027280761959e-08,  5.647334821353557e-10, -2.161475196448125e-11,  7.369867968507070e-13, -2.271927428864624e-14,  6.405876377469139e-16, -1.666498005013131e-17,
  1.329991979958610e-03, -3.266652805304410e-04,  4.186666498862983e-05, -3.671994924953033e-06,  2.468625499274749e-07, -1.353963749123525e-08,  6.301540585176330e-10,
 -2.556884337239069e-11,  9.224414490115176e-13, -3.003362980264821e-14,  8.928772922777169e-16, -2.445138072360058e-17,  9.963965215172236e-04, -2.612695376945448e-04,
  3.574668847189204e-05, -3.340408445072717e-06,  2.387476111525473e-07, -1.389175432611451e-08,  6.845288843253702e-10, -2.935165373455922e-11,  1.117040087285418e-12,
 -3.830230281893360e-14,  1.197338816465954e-15, -3.442475679336299e-17,  7.457604640463168e-04, -2.077399413371398e-04,  3.020987860065832e-05, -2.995711165309376e-06,
  2.267807076876729e-07, -1.394996623147542e-08,  7.253922262482904e-10, -3.276694256112051e-11,  1.311573854644827e-12, -4.722881066653072e-14,  1.548213861104446e-15,
 -4.661189899125971e-17,  5.582244357005905e-04, -1.644256800310874e-04,  2.530819332627121e-05, -2.652878292665972e-06,  2.119424091299129e-07, -1.373579763202071e-08,
  7.513085482715406e-10, -3.564290013659896e-11,  1.496172928157891e-12, -5.642098846114200e-14,  1.934339015636219e-15, -6.082622441700435e-17,  4.183009939753779e-04,
 -1.297088983309869e-04,  2.104630796138856e-05, -2.323322604107624e-06,  1.951974588104472e-07, -1.328410067496167e-08,  7.618808754448690e-10, -3.784631736040421e-11,
  1.661238777652549e-12, -6.542371599841734e-14,  2.339600411565592e-15, -7.664454927614018e-17,  3.140704002008333e-04, -1.020945634994813e-04,  1.739560235527801e-05,
 -2.014980474646818e-06,  1.774216622076808e-07, -1.263772382866077e-08,  7.576401053770130e-10, -3.929068072955221e-11,  1.798289110205395e-12, -7.375942125727385e-14,
  2.744060331571985e-15, -9.341360720486287e-17,  2.364595149837383e-04, -8.025807642515004e-05,  1.430637463557906e-05, -1.732694163390235e-06,  1.593562056175338e-07,
 -1.184250015691759e-08,  7.398530419227529e-10, -3.993795983615887e-11,  1.900602089837464e-12, -8.096991930071061e-14,  3.125585524358245e-15, -1.102872947373230e-16,
  1.786245887877260e-04, -6.306250802309344e-05,  1.171765509290087e-05, -1.478751432154341e-06,  1.415868105151076e-07, -1.094309066316733e-08,  7.102909497937174e-10,
 -3.979492179556514e-11,  1.963596595946922e-12, -8.665355661867653e-14,  3.461726137121610e-15, -1.262899804766832e-16,  1.354411414576197e-04, -4.955577387968837e-05,
  9.564518263950166e-06, -1.253472041716858e-06,  1.245425633394983e-07, -9.979943821174736e-09,  6.709960300369016e-10, -3.890548461405605e-11,  1.984938476359608e-12,
 -9.049317848625645e-14,  3.731572285800330e-15, -1.403968112150175e-16,  1.030937046889583e-04, -3.895590260096100e-05,  7.783118174304218e-06, -1.055764529066077e-06,
  1.085083751940881e-07, -8.987401355008604e-09,  6.240737129815588e-10, -3.734087058093373e-11,  1.964407050604478e-12, -9.227258175430395e-14,  3.917349362547958e-15,
 -1.516197037446451e-16,  7.875297129375061e-05, -3.063035955483852e-05,  6.313835234321404e-06, -8.836082741758209e-07,  9.364535291794531e-08, -7.992819669766543e-09,
  5.715274209025541e-10, -3.518920966580840e-11,  1.903584650363978e-12, -9.188128839681673e-14,  4.005586848935413e-15, -1.590878664040667e-16,  6.032611946598037e-05,
 -2.407346247582287e-05,  5.102969618460914e-06, -7.344411730984786e-07,  8.001438809897087e-08, -7.016489371754589e-09,  5.151420723054224e-10, -3.254589714658916e-11,
  1.805443240379615e-12, -8.930923266668056e-14,  3.987786011300066e-15, -1.621138594158831e-16,  4.626639408708119e-05, -1.888439344686991e-05,  4.103389431056824e-06,
 -6.054510108387487e-07,  6.759955888246556e-08, -6.072110018415956e-09,  4.564146140047172e-10, -2.950556376272543e-11,  1.673898775948480e-12, -8.463405714537866e-14,
  3.860597772095147e-15, -1.602395818139478e-16,  3.542944729097538e-05, -1.474718377669125e-05,  3.274478149844962e-06, -4.937794295868505e-07,  5.632918824183821e-08,
 -5.167594854482236e-09,  3.965247986710502e-10, -2.615608055851264e-11,  1.513390775180236e-12, -7.800412421595981e-14,  3.625587777009973e-15, -1.532602546052514e-16,
  2.696581405265376e-05, -1.141327422390474e-05,  2.581649641553641e-06, -3.966526548950197e-07,  4.609344286564445e-08, -4.306021893373639e-09,  3.363370665679111e-10,
 -2.257466457932507e-11,  1.328526864570607e-12, -6.962018403126984e-14,  3.288703877356317e-15, -1.412276808542965e-16,  2.024082805689007e-05, -8.686759235629447e-06,
  1.995625673995784e-06, -3.114545438524295e-07,  3.675812736143860e-08, -3.486598004451379e-09,  2.764241366139755e-10, -1.882590651646235e-11,  1.123814178670833e-12,
 -5.971809026029460e-14,  2.859572116345620e-15, -1.244363163155974e-16,  1.477505366158075e-05, -6.412135972594509e-06,  1.491608189341030e-06, -2.357565890720218e-07,
  2.817484118348691e-08, -2.705551640486564e-09,  2.171040637006736e-10, -1.496140887497382e-11,  9.034844605459206e-13, -4.855422887301624e-14,  2.350736498219327e-15,
 -1.033968230565574e-16,  1.019983571115315e-05, -4.464237050428234e-06,  1.048430591220846e-06, -1.673176328857764e-07,  2.018799223670539e-08, -1.956914322182996e-09,
  1.584846181876936e-10, -1.102069833381279e-11,  6.714097537184831e-13, -3.639463734805008e-14,  1.776935447838903e-15, -7.880200497466244e-17,  6.223952436834044e-06,
 -2.740035719798115e-06,  6.477521267625652e-07, -1.040662180327086e-07,  1.263962743704324e-08, -1.233215111306793e-09,  1.005135240299048e-10, -7.033281850912646e-12,
  4.311100851768762e-13, -2.350875914969228e-14,  1.154506752103812e-15, -5.149072231031997e-17,  2.611674886593039e-06, -1.153491229346718e-06,  2.736871924720529e-07,
 -4.413318787900090e-08,  5.380043852791477e-09, -5.268178368645728e-10,  4.309090268144835e-11, -3.025701328614892e-12,  1.860929909889723e-13, -1.018151000583988e-14,
  5.016337866567267e-16, -2.244350474429180e-17,  7.039126164330202e-02, -2.074188813981200e-04,  6.390107236829785e-07, -2.038205506811774e-09,  6.660569218655898e-12,
 -2.210002779100337e-14,  7.394445096240866e-17, -2.483169581837471e-19,  8.343431707283534e-22, -2.799704937587156e-24,  9.371730784926626e-27, -3.127655767961747e-29,
  6.876436358347247e-02, -2.783076714338022e-04,  1.323064196580271e-06, -6.399565132573476e-09,  3.026844833196307e-11, -1.393271251939380e-13,  6.259457162511196e-16,
 -2.754601400889875e-18,  1.190957172726679e-20, -5.070495439101273e-23,  2.129593704916864e-25, -8.835749502307494e-28,  6.562847730226788e-02, -4.098979707358990e-04,
  2.827697515994890e-06, -1.819204159772099e-08,  1.098658035422080e-10, -6.322013866837336e-13,  3.501118537474387e-15, -1.878465251456772e-17,  9.810585204182751e-20,
 -5.005204367456826e-22,  2.501407249304046e-24, -1.227252413530699e-26,  6.120466245739126e-02, -5.836761405952347e-04,  5.362226737738484e-06, -4.351684912763502e-08,
  3.240804371674578e-10, -2.264309107845617e-12,  1.503992705277342e-14, -9.581481354748034e-17,  5.892024520721057e-19, -3.514152143608297e-21,  2.040390534263253e-23,
 -1.156678347595151e-25,  5.579027208981262e-02, -7.760899353057460e-04,  9.104574799250289e-06, -9.109682101458044e-08,  8.201624393471322e-10, -6.826903710467761e-12,
  5.341062384338980e-14, -3.971244282532481e-16,  2.828545727813916e-18, -1.941366071573359e-20,  1.289861516215722e-22, -8.325799871135341e-25,  4.972469378422283e-02,
 -9.625198515001174e-04,  1.409424152469558e-05, -1.710751228910700e-07,  1.833991627010327e-09, -1.793175267576982e-11,  1.630726717926637e-13, -1.397574703235482e-15,
  1.139358955472576e-17, -8.897241149266972e-20,  6.690871950787911e-22, -4.865860530214189e-24,  4.335333419334551e-02, -1.121088561890009e-03,  2.016020627037219e-05,
 -2.928571613585488e-07,  3.692786220387998e-09, -4.193966893214470e-11,  4.387638645703245e-13, -4.292197213018641e-15,  3.968153548614884e-17, -3.494504710451026e-19,
  2.949219476900075e-21, -2.396679621286841e-23,  3.699522888669072e-02, -1.235580589945345e-03,  2.690829687280236e-05, -4.623102130695303e-07,  6.786290446271238e-09,
 -8.869571567439038e-11,  1.058331731063689e-12, -1.172269971473085e-14,  1.219688870132618e-16, -1.202517951494073e-18,  1.131043523816397e-20, -1.020212039504118e-22,
  3.091836671099756e-02, -1.297027291935474e-03,  3.377175098710962e-05, -6.790819842767308e-07,  1.150018277939063e-08, -1.715816793901634e-10,  2.317871292037248e-12,
 -2.887054244151858e-14,  3.358629843078087e-16, -3.684356410525358e-18,  3.839218967832839e-20, -3.821968610830184e-22,  2.532491869371262e-02, -1.303862966389565e-03,
  4.010850033617149e-05, -9.349607533778084e-07,  1.811962000975616e-08, -3.064026383050092e-10,  4.655480163750096e-12, -6.481084923423909e-14,  8.382184980646952e-16,
 -1.017556412091318e-17,  1.168649799713680e-19, -1.277621191242560e-21,  2.034656557668704e-02, -1.260873475811523e-03,  4.531608440078544e-05, -1.213969186974133e-06,
  2.672591418201419e-08, -5.088859622191464e-10,  8.645150232034137e-12, -1.337804767860614e-13,  1.913700566754477e-15, -2.558392247310259e-17,  3.223499231336898e-19,
 -3.852936848694769e-21,  1.604846953194961e-02, -1.177363869940964e-03,  4.893325617375053e-05, -1.494350529864463e-06,  3.711807139373328e-08, -7.910548299309275e-10,
  1.494423216134348e-11, -2.557697026819053e-13,  4.027756401486924e-15, -5.903698595354106e-17,  8.126243146756502e-19, -1.057669699020769e-20,  1.243940760239060e-02,
 -1.065036704129474e-03,  5.070513526217604e-05, -1.751998009924689e-06,  4.878809112432652e-08, -1.157270869017315e-09,  2.418891422256868e-11, -4.557441371488453e-13,
  7.866440027658487e-15, -1.259003576879604e-16,  1.885854692787948e-18, -2.662869463554576e-20,  9.485244577589416e-03, -9.360136301238348e-04,  5.060194121179582e-05,
 -1.964442408507712e-06,  6.096449126733488e-08, -1.601076995903130e-09,  3.685028378937557e-11, -7.609801310283263e-13,  1.433844531669930e-14, -2.496158324809627e-16,
  4.054053146703369e-18, -6.188777140148458e-20,  7.123165409225981e-03, -8.012947314132842e-04,  4.879473710034284e-05, -2.114399376509772e-06,  7.271787580228769e-08,
 -2.103921874939020e-09,  5.308225539690212e-11, -1.196492717025159e-12,  2.451515621930235e-14, -4.625416589563168e-16,  8.117314975931789e-18, -1.335300128525436e-19,
  5.274704380708286e-03, -6.697871623530918e-04,  4.560118592166829e-05, -2.192090468263537e-06,  8.310362583375544e-08, -2.636384685386643e-09,  7.260348951625203e-11,
 -1.779228216592250e-12,  3.949616891724536e-14, -8.048523581457187e-16,  1.521251509242320e-17, -2.688215924055838e-19,  3.856370731470801e-03, -5.478920323829831e-04,
  4.141825171919675e-05, -2.195969830642772e-06,  9.130690107580806e-08, -3.161802825567795e-09,  9.465226663907128e-11, -2.512323268181808e-12,  6.020960267437867e-14,
 -1.320784426762549e-15,  2.680258545269555e-17, -5.072676276351770e-19,  2.787388845551522e-03, -4.395423328197648e-04,  3.665746943733314e-05, -2.131940438865117e-06,
  9.675686718044480e-08, -3.641506857488973e-09,  1.180357653731909e-10, -3.381010104642805e-12,  8.718198842635637e-14, -2.052145895347771e-15,  4.457556611351580e-17,
 -9.009488408870502e-19,  1.994627457015989e-03, -3.465412214795651e-04,  3.169370720479192e-05, -2.011483384781767e-06,  9.918842257869518e-08, -4.040440456475874e-09,
  1.412692388983885e-10, -4.351504333274135e-12,  1.203315155197713e-13, -3.029901834781171e-15,  7.023989492056277e-17, -1.511860802691714e-18,  1.415142673079052e-03,
 -2.690504988521743e-04,  2.683250486844011e-05, -1.849277003523214e-06,  9.864552454507773e-08, -4.331916213819284e-09,  1.627756685040305e-10, -5.373489317723653e-12,
  1.588419169025062e-13, -4.265496345151865e-15,  1.052316204894006e-16, -2.405527636209808e-18,  9.969172482111959e-04, -2.061076894685081e-04,  2.229592776242526e-05,
 -1.660854200609977e-06,  9.543479541954458e-08, -4.500594755652414e-09,  1.811012929178411e-10, -6.385855529754258e-12,  2.011589211731371e-13, -5.744020450301866e-15,
  1.503817009401553e-16, -3.641082694814880e-18,  6.983894216483737e-04, -1.560903556846707e-04,  1.822344072782943e-05, -1.460694823972471e-06,  9.004739728439877e-08,
 -4.543314955955931e-09,  1.951012839077542e-10, -7.324500203621534e-12,  2.451212555030279e-13, -7.421151026563089e-15,  2.056150617408560e-16, -5.259159428839272e-18,
  4.872846695480172e-04, -1.170854850915398e-04,  1.468278585645059e-05, -1.260951895453344e-06,  8.306984857694435e-08, -4.467947708268041e-09,  2.040615030896269e-10,
 -8.130522385089132e-12,  2.882037739815215e-13, -9.224974720377702e-15,  2.697571740529581e-16, -7.269921089698986e-18,  3.391429856938492e-04, -8.715270408671852e-05,
  1.168587848419745e-05, -1.070830552316953e-06,  7.510155990191726e-08, -4.290837100358486e-09,  2.077412720159109e-10, -8.757177074406739e-12,  3.278229505524235e-13,
 -1.106262579975607e-14,  3.405048944743456e-16, -9.643979413589151e-18,  2.358092100396490e-04, -6.449020553684854e-05,  9.205718030296229e-06, -8.965139614162017e-07,
  6.669075527637768e-08, -4.033559409809845e-09,  2.063415742306195e-10, -9.174408758276641e-12,  3.616429063745874e-13, -1.283049921346314e-14,  4.145812586463230e-16,
 -1.230858836281329e-17,  1.640458911016222e-04, -4.752247914337178e-05,  7.191657846343056e-06, -7.414705148246956e-07,  5.829363844578911e-08, -3.719686989115925e-09,
  2.004175764659835e-10, -9.370469126271875e-12,  3.878254029988028e-13, -1.442601490111209e-14,  4.880506398707267e-16, -1.515041284524147e-17,  1.143461354429660e-04,
 -3.493169080167412e-05,  5.581665140482038e-06, -6.069707265142898e-07,  5.025601958450339e-08, -3.372061536047917e-09,  1.907611592808889e-10, -9.350803488651543e-12,
  4.051859138787248e-13, -1.575870845122648e-14,  5.567347429214232e-16, -1.802469224194665e-17,  7.996833923784833e-05, -2.565271212595830e-05,  4.311198177449276e-06,
 -4.926708529703245e-07,  4.281303087609636e-08, -3.010846283897610e-09,  1.782785655068802e-10, -9.134886310761132e-12,  4.132425652099605e-13, -1.675879294004899e-14,
  6.166513753883807e-16, -2.076920203894748e-17,  5.618150021292411e-05, -1.884776937099314e-05,  3.318967295727810e-06, -3.971636563125343e-07,  3.610107686594113e-08,
 -2.652411033443580e-09,  1.638825510676625e-10, -8.751917239879491e-12,  4.121677285237212e-13, -1.738208875423554e-14,  6.644001704568816e-16, -2.322047104442708e-17,
  3.969321169906468e-05, -1.387215048654286e-05,  2.550167327105427e-06, -3.184401396193882e-07,  3.017630785369138e-08, -2.308949290165880e-09,  1.484104625363866e-10,
 -8.236269484188613e-12,  4.026679504994286e-13, -1.761108671370130e-14,  6.974389209194041e-16, -2.522945363175330e-17,  2.822685461801615e-05, -1.023834978369853e-05,
  1.957857223876504e-06, -2.542411119330549e-07,  2.503500709645994e-08, -1.988644461556724e-09,  1.325719771656331e-10, -7.623389028487564e-12,  3.858246666214694e-13,
 -1.745265452024723e-14,  7.142229959080023e-16, -2.667426621127869e-17,  2.021538783175871e-05, -7.582855337704127e-06,  1.503109368252481e-06, -2.023011753891787e-07,
  2.063274043010460e-08, -1.696182127042808e-09,  1.169243854248806e-10, -6.946572521965258e-12,  3.629266989126446e-13, -1.693336981782353e-14,  7.142095552472772e-16,
 -2.746846558753937e-17,  1.458323653928857e-05, -5.637551240734207e-06,  1.154430956873113e-06, -1.605008815603435e-07,  1.690050594393141e-08, -1.433427686012191e-09,
  1.018698297453832e-10, -6.234786816553841e-12,  3.353186097168635e-13, -1.609362778819685e-14,  6.977510208285350e-16, -2.756437956408141e-17,  1.059299991814998e-05,
 -4.206285263189421e-06,  8.868239979413398e-07, -1.269478492252099e-07,  1.375721675035259e-08, -1.200132135323480e-09,  8.766763904603073e-11, -5.511486518693686e-12,
  3.042797514336105e-13, -1.498157797393708e-14,  6.659150339273260e-16, -2.695192497456476e-17,  7.738848960123952e-06, -3.146345693097635e-06,  6.807276690626420e-07,
 -1.000074281454746e-07,  1.111858600587229e-08, -9.945766879651093e-10,  7.445522005995613e-11, -4.794257596600251e-12,  2.709399533880669e-13, -1.364769077138978e-14,
  6.202708717705156e-16, -2.565398747870332e-17,  5.672986562306516e-06, -2.354205236751909e-06,  5.209893570697298e-07, -7.830049592868857e-08,  8.902893854630753e-09,
 -8.141090512471732e-10,  6.227219586891608e-11, -4.095060533964798e-12,  2.362308498484037e-13, -1.214044095496064e-14,  5.626773451750841e-16, -2.371972988880544e-17,
  4.155198765745315e-06, -1.754765808099294e-06,  3.959405333760137e-07, -6.068195784738043e-08,  7.034279762915045e-09, -6.555557833882888e-10,  5.108403701239665e-11,
 -3.420847697326054e-12,  2.008674863421694e-13, -1.050330378563610e-14,  4.950978814921508e-16, -2.121717806242077e-17,  3.018352081778547e-06, -1.293359810282351e-06,
  2.966072276022566e-07, -4.620956393707298e-08,  5.444207161029806e-09, -5.155156642804247e-10,  4.080291648487485e-11, -2.774364726534456e-12,  1.653528968132552e-13,
 -8.773035780898514e-15,  4.194579805727283e-16, -1.822619942001242e-17,  2.144797183206820e-06, -9.298542242837169e-07,  2.160568155503373e-07, -3.410930505587553e-08,
  4.071664093207755e-09, -3.905501984023058e-10,  3.130473285462757e-11, -2.154995975765166e-12,  1.299982718344863e-13, -6.979073608063155e-15,  3.375508607398922e-16,
 -1.483264950201038e-17,  1.450165126194711e-06, -6.343174895889950e-07,  1.488678428920099e-07, -2.374110226620029e-08,  2.862549980295405e-09, -2.772921319922926e-10,
  2.244215048558451e-11, -1.559567677248983e-12,  9.495257305974700e-14, -5.143830629276462e-15,  2.509904465743745e-16, -1.112412409066037e-17,  8.721408833574802e-07,
 -3.838280551746099e-07,  9.070495754961647e-08, -1.456703109548586e-08,  1.768624536559063e-09, -1.724973783975611e-10,  1.405442584573708e-11, -9.830925967199454e-13,
  6.023865892216808e-14, -3.283752702245099e-15,  1.612106494350214e-16, -7.187634934233477e-18,  3.630092381695810e-07, -1.603033119004877e-07,  3.802791081771776e-08,
 -6.130999322464594e-09,  7.472566372733265e-10, -7.315821125305095e-11,  5.982844907234041e-12, -4.200188426921809e-13,  2.582821371773963e-14, -1.412860480226228e-15,
  6.959814934667841e-17, -3.113341299523667e-18,  6.957165789981515e-02, -2.024028507752606e-04,  6.151773922381384e-07, -1.935078291061995e-09,  6.235767354426039e-12,
 -2.040586908872648e-14,  6.735071052131678e-17, -2.231608633856015e-19,  7.399827065585328e-22, -2.450951116759220e-24,  8.099364535087739e-27, -2.668786010481553e-29,
  6.767182690833008e-02, -2.680223105709154e-04,  1.249085804287774e-06, -5.936771536133132e-09,  2.762610098093644e-11, -1.251885387622632e-13,  5.538892453853266e-16,
 -2.401130200200507e-18,  1.022860162475457e-20, -4.291552198930606e-23,  1.776545955313757e-25, -7.266140045230009e-28,  6.403278694226718e-02, -3.881206572533353e-04,
  2.619537196057526e-06, -1.653094815850450e-08,  9.802120584909324e-11, -5.541474184305141e-13,  3.016522669197191e-15, -1.591526237746601e-17,  8.176523979101783e-20,
 -4.104770338495873e-22,  2.019098919468428e-24, -9.752433895276835e-27,  5.895256630665668e-02, -5.427823042820742e-04,  4.869702951595415e-06, -3.867511479483169e-08,
  2.821970642219112e-10, -1.933525579827288e-12,  1.260312431002059e-14, -7.883640632465297e-17,  4.762352403455169e-19, -2.791329190858849e-21,  1.593254642406458e-23,
 -8.881709183266989e-26,  5.282496399621174e-02, -7.074128425858041e-04,  8.085858486881956e-06, -7.900048367012536e-08,  6.955924803344325e-10, -5.668866395509447e-12,
  4.345996672860561e-14, -3.168649220984104e-16,  2.214327166552188e-18, -1.491850344772160e-20,  9.733759009571609e-23, -6.172237528791775e-25,  4.608779051403646e-02,
 -8.575046173620681e-04,  1.220622245980150e-05, -1.444002903807348e-07,  1.511525320363765e-09, -1.444917919640824e-11,  1.285979258675574e-13, -1.079454041094716e-15,
  8.624841184816498e-18, -6.604648416153311e-20,  4.872940686980173e-22, -3.478309113784263e-24,  3.917062453169512e-02, -9.729198415851551e-04,  1.697449522461944e-05,
 -2.399492022377836e-07,  2.950256515629803e-09, -3.271888441285821e-11,  3.346195602954610e-13, -3.202817383436289e-15,  2.899299490055880e-17, -2.501584196806359e-19,
  2.069657622490808e-21, -1.649580273230776e-23,  3.245074254532631e-02, -1.040785609015800e-03,  2.195770253090430e-05, -3.666449644123215e-07,  5.241908984229734e-09,
 -6.683062488312100e-11,  7.788052964758025e-13, -8.433113281135518e-15,  8.584447113395247e-17, -8.286227537820405e-19,  7.634966144804236e-21, -6.750132267352589e-23,
  2.622309072088166e-02, -1.056563617662016e-03,  2.662262989386855e-05, -5.197640936026756e-07,  8.565152574248015e-09, -1.245515109630583e-10,  1.641959711168097e-12,
 -1.997877307944345e-14,  2.272430372335386e-16, -2.439077394722340e-18,  2.488414657456013e-20, -2.426794145955631e-22,  2.068653591481347e-02, -1.023373689895109e-03,
  3.044433037580496e-05, -6.885670157404218e-07,  1.297622903319276e-08, -2.137253139951355e-10,  3.167074910027211e-12, -4.304639153105149e-14,  5.440437150398996e-16,
 -6.458934592677440e-18,  7.259543147195317e-20, -7.771682258656996e-22,  1.594519542104194e-02, -9.500519905956310e-04,  3.301159196312515e-05, -8.576622165985117e-07,
  1.835206822044102e-08, -3.402022829465007e-10,  5.634163966873198e-12, -8.508768401713612e-14,  1.188967987362320e-15, -1.553948822878669e-17,  1.915489482147600e-19,
 -2.241323922431347e-21,  1.202118949298880e-02, -8.486174319567793e-04,  3.409933985743573e-05, -1.009738893142376e-06,  2.437119187104391e-08, -5.055276822037245e-10,
  9.307558809055483e-12, -1.554237196669688e-13,  2.390287145831879e-15, -3.424438696329013e-17,  4.610536210800416e-19, -5.873477561425313e-21,  8.874040710029507e-03,
 -7.317949226357638e-04,  3.369246069618286e-05, -1.128885410602549e-06,  3.054534968626815e-08, -7.051409972095635e-10,  1.436273892304156e-11, -2.639996539635745e-13,
  4.449764073447274e-15, -6.960270379128876e-17,  1.019696933760277e-18, -1.409191418602656e-20,  6.422078824101445e-03, -6.110629527937455e-04,  3.196240743088355e-05,
 -1.203538136917731e-06,  3.629752610144910e-08, -9.278151501771818e-10,  2.081117378978456e-11, -4.192864267667889e-13,  7.714970098284908e-15, -1.312693215911008e-16,
  2.085281529884715e-18, -3.115738944491129e-20,  4.562219850226997e-03, -4.954476874707868e-04,  2.921081822192659e-05, -1.228294459923511e-06,  4.106571144993511e-08,
 -1.156723341643291e-09,  2.844789244158915e-11, -6.257142144003203e-13,  1.252196660960727e-14, -2.309519261183714e-16,  3.964969973961383e-18, -6.384994368315716e-20,
  3.185887756614611e-03, -3.910607734584961e-04,  2.579994285039388e-05, -1.204253605955253e-06,  4.440360478079200e-08, -1.371987484813301e-09,  3.684331515160963e-11,
 -8.813375968874866e-13,  1.911489294323587e-14, -3.808849327061043e-16,  7.044642497510323e-18, -1.218983243737687e-19,  2.190208745275835e-03, -3.012257275712455e-04,
  2.208808026813926e-05, -1.138019376310307e-06,  4.605202795415627e-08, -1.554063422355430e-09,  4.538840300190622e-11, -1.176524331395841e-12,  2.756046647463143e-14,
 -5.914161584805532e-16,  1.174873807363465e-17, -2.178190127887111e-19,  1.484657689379509e-03, -2.269724122404079e-04,  1.838204848861470e-05, -1.039835574174073e-06,
  4.596608264815424e-08, -1.687061146861397e-09,  5.338515582598863e-11, -1.494244198172867e-12,  3.768239671682915e-14, -8.681400873876666e-16,  1.846936412309145e-17,
 -3.658582753231011e-19,  9.939705086587090e-04, -1.676859924044711e-04,  1.491120324491501e-05, -9.214451553778364e-07,  4.429754006906894e-08, -1.761169187595768e-09,
  6.015994400199271e-11, -1.812070919383261e-12,  4.903904270911989e-14, -1.209308926323109e-15,  2.747458450765863e-17, -5.799269098139817e-19,  6.583853577341096e-04,
 -1.217471942087803e-04,  1.182129309544494e-05, -7.941855705963583e-07,  4.134394745342240e-08, -1.773689230948158e-09,  6.517081803684256e-11, -2.105478791184774e-12,
  6.095679223639581e-14, -1.604326364321051e-15,  3.881638941179829e-17, -8.707435506026879e-19,  4.322434701960358e-04, -8.706569376367596e-05,  9.182770609385798e-06,
 -6.676367140623702e-07,  3.748198540430965e-08, -1.728630096947670e-09,  6.808359448306803e-11, -2.351627563384407e-12,  7.261537964506624e-14, -2.033910494254824e-15,
  5.226399987555481e-17, -1.242749322832453e-18,  2.817896173514602e-04, -6.146714310701795e-05,  7.007113407834482e-06, -5.489190815921849e-07,  3.310225842580660e-08,
 -1.635188670634926e-09,  6.880268351211451e-11, -2.532724175843949e-12,  8.316596842895673e-14, -2.472062264756440e-15,  6.728469773654419e-17, -1.691576009860905e-18,
  1.827661107499975e-04, -4.293620580294155e-05,  5.265518802779753e-06, -4.425681056738391e-07,  2.855782877460035e-08, -1.505650020888748e-09,  6.745629868377871e-11,
 -2.638239936170069e-12,  9.185405452150958e-14, -2.889459646608811e-15,  8.308271767868855e-17, -2.202825882752748e-18,  1.181623669254301e-04, -2.974122796153258e-05,
  3.906066257880352e-06, -3.508164606549822e-07,  2.413221013833868e-08, -1.353249118113260e-09,  6.434691390932885e-11, -2.665642416192803e-12,  9.811974904454278e-14,
 -3.257507190177272e-15,  9.869090336258052e-17, -2.752633367862825e-18,  7.629909751422058e-05, -2.047424270136514e-05,  2.867291864254722e-06, -2.740952882296193e-07,
  2.002664154790303e-08, -1.190402910813241e-09,  5.988364334511747e-11, -2.619716023324808e-12,  1.016565480632689e-13, -3.552136318054197e-15,  1.130955692911169e-16,
 -3.310017871396939e-18,  4.930106022307101e-05, -1.403824147093080e-05,  2.087605876207047e-06, -2.115943817121644e-07,  1.636261505108770e-08, -1.027525540740013e-09,
  5.451325120118308e-11, -2.510857648771926e-12,  1.024222988369774e-13, -3.756593240864000e-15,  1.253671971112754e-16, -3.840565878964074e-18,  3.193851847853620e-05,
 -9.607052669027554e-06,  1.510934579723999e-06, -1.617729501705343e-07,  1.319407909865595e-08, -8.724550110609289e-10,  4.866236240865538e-11, -2.352874914696626e-12,
  1.006080751350543e-13, -3.862785508443771e-15,  1.347702450986662e-16, -4.310659507067429e-18,  2.078220986180020e-05, -6.575367729666823e-06,  1.089419501771670e-06,
 -1.227650446620019e-07,  1.052398580029343e-08, -7.303910642071674e-10,  4.269754671907006e-11, -2.160789161162283e-12,  9.657866784112970e-14, -3.871149646791098e-15,
  1.408331873949077e-16, -4.691390177616948e-18,  1.360628024522938e-05, -4.509521096135452e-06,  7.840982862167393e-07, -9.266481770805852e-08,  8.321112659435509e-09,
 -6.041832826283582e-10,  3.690441371288053e-11, -1.949008376984639e-12,  9.080112101567245e-14, -3.789325374886946e-15,  1.433714084999221e-16, -4.961455752383502e-18,
  8.977287892077574e-06, -3.104405023062130e-06,  5.643760911415144e-07, -6.970265064078082e-08,  6.534653349583302e-09, -4.948041678779823e-10,  3.148295021363154e-11,
 -1.730057301297231e-12,  8.377590855934676e-14, -3.630102842214642e-15,  1.424667505247356e-16, -5.108653829990036e-18,  5.977300794311031e-06, -2.148446569643311e-06,
  4.068974751354570e-07, -5.233539420206064e-08,  5.105460977962288e-09, -4.018725984105409e-10,  2.655439903203363e-11, -1.513891048266773e-12,  7.598078595096502e-14,
 -3.409137362890388e-15,  1.384153704729599e-16, -5.129936024515381e-18,  4.020587238836959e-06, -1.496576567995174e-06,  2.942254770940346e-07, -3.927647602407452e-08,
  3.973822448952073e-09, -3.241373274975271e-10,  2.217470816517099e-11, -1.307707320321939e-12,  6.783206424792661e-14, -3.142837966717061e-15,  1.316588966429907e-16,
 -5.030275532435990e-18,  2.733974523213574e-06, -1.050154261431593e-06,  2.135663953095222e-07, -2.948859857361005e-08,  3.084218612676327e-09, -2.598727616647935e-10,
  1.835036824776903e-11, -1.116117757310100e-12,  5.966353735882137e-14, -2.846689087337271e-15,  1.227131001057672e-16, -4.820765440158470e-18,  1.879630579392238e-06,
 -7.424901080275575e-07,  1.556575388134843e-07, -2.215645438319002e-08,  2.387762654639963e-09, -2.071721323941049e-10,  1.505369743920247e-11, -9.415312963505131e-13,
  5.172029607000975e-14, -2.534112477633506e-15,  1.121048337496731e-16, -4.516400577667206e-18,  1.305646344519056e-06, -5.286406677074886e-07,  1.138574775600889e-07,
 -1.665140383892577e-08,  1.843023493143838e-09, -1.641442023469812e-10,  1.223587995320199e-11, -7.846244471599344e-13,  4.416326646748187e-14, -2.215854786359501e-15,
  1.003234913094887e-16, -4.133930888410971e-18,  9.145981801517324e-07, -3.783399060870007e-07,  8.343426430176950e-08, -1.249544383173749e-08,  1.415836595136003e-09,
 -1.290302705716452e-10,  9.837069242350308e-12, -6.448083806769819e-13,  3.708018473936627e-14, -1.899810083335864e-15,  8.778904076749454e-17, -3.690055101424497e-18,
  6.436204627818465e-07, -2.711668660294999e-07,  6.102608456653024e-08, -9.328380845854277e-09,  1.078557743798706e-09, -1.002613782743033e-10,  7.793547710452838e-12,
 -5.206383826585525e-13,  3.049938073327777e-14, -1.591154450670690e-15,  7.483556860327075e-17, -3.200093592616333e-18,  4.517895100301017e-07, -1.932722728077720e-07,
  4.424187272920863e-08, -6.879846650406137e-09,  8.090716167697387e-10, -7.647426590103518e-11,  6.042315741391023e-12, -4.101406235401487e-13,  2.440374009133274e-14,
 -1.292670819882231e-15,  6.170746866882001e-17, -2.677169319350173e-18,  3.121243815901511e-07, -1.351724035923499e-07,  3.137014143514913e-08, -4.946425048173527e-09,
  5.897482491573630e-10, -5.650118034349701e-11,  4.523636948640097e-12, -3.110519325802532e-13,  1.874322931817779e-14, -1.005163270165136e-15,  4.856478122579605e-17,
 -2.131850558300538e-18,  2.064888129258244e-07, -9.026255401966960e-08,  2.116843770975403e-08, -3.373431493637417e-09,  4.064529523801117e-10, -3.934470541819476e-11,
  3.182079219031521e-12, -2.209810570733377e-13,  1.344523753073816e-14, -7.278902449789964e-16,  3.549444655316196e-17, -1.572172376125072e-18,  1.223083065513963e-07,
 -5.380961321624641e-08,  1.271126744383639e-08, -2.040614274621735e-09,  2.476615940838665e-10, -2.414576713674634e-11,  1.966572394111200e-12, -1.375094678555966e-13,
  8.422827484448829e-15, -4.589872054068403e-16,  2.252550044014972e-17, -1.003970058165236e-18,  5.047683307617796e-08, -2.228662163315375e-08,  5.285929903884943e-09,
 -8.520508967617796e-10,  1.038291817714785e-10, -1.016316082563849e-11,  8.309798411849774e-13, -5.832699663082036e-14,  3.586034264412252e-15, -1.961280501478537e-16,
  9.659611158665455e-18, -4.320276887670289e-19,  6.877174462338724e-02, -1.975726497232874e-04,  5.925418973360137e-07, -1.838485204492558e-09,  5.843321505130989e-12,
 -1.886183765732907e-14,  6.142088689241358e-17, -2.008328624055951e-19,  6.573079046770356e-22, -2.149274937593768e-24,  7.012618999022495e-27, -2.281760697156731e-29,
  6.661928220759911e-02, -2.583072605757565e-04,  1.180416305845668e-06, -5.514084026204304e-09,  2.525000312933343e-11, -1.126663700084520e-13,  4.910171822508369e-16,
 -2.097222932212670e-18,  8.804211704567154e-21, -3.640932364700842e-23,  1.485828320988705e-25, -5.991745480761964e-28,  6.252099711726251e-02, -3.679320009077944e-04,
  2.430222456858979e-06, -1.504748526983753e-08,  8.762759915821039e-11, -4.868158563247599e-13,  2.605411103845063e-15, -1.352042378123861e-17,  6.834407867997611e-20,
 -3.376788984593851e-22,  1.635181406005292e-24, -7.777002034444525e-27,  5.685651764701929e-02, -5.056071643675022e-04,  4.431467622316066e-06, -3.445361207396509e-08,
  2.463810227884474e-10, -1.655906197529804e-12,  1.059478623311138e-14, -6.508893810158070e-17,  3.863359682421390e-19, -2.225793807827038e-21,  1.249205801628605e-23,
 -6.849329573725411e-26,  5.011893851821960e-02, -6.463370596488788e-04,  7.201063775165517e-06, -6.872422941179117e-08,  5.919662640786330e-10, -4.724757442188753e-12,
  3.550409345490899e-14, -2.538981275056400e-16,  1.741259884537240e-18, -1.151827483842833e-20,  7.381757919622578e-23, -4.599334130985817e-25,  4.284264996423597e-02,
 -7.663958388398621e-04,  1.060950535847205e-05, -1.223698044074854e-07,  1.251109362050110e-09, -1.169640763429001e-11,  1.019048798563181e-13, -8.380201435866356e-16,
  6.564026142106805e-18, -4.930323971334642e-20,  3.569681972093257e-22, -2.501505751772578e-24,  3.553337167462503e-02, -8.478860136019854e-04,  1.435806939966738e-05,
 -1.975724814654546e-07,  2.369432014422307e-09, -2.566710623363541e-11,  2.566818677436967e-13, -2.404474075655350e-15,  2.131766077775032e-17, -1.802552917158153e-19,
  1.462279892370875e-21, -1.143327685279338e-23,  2.861294514799081e-02, -8.813925093948806e-04,  1.802016103270764e-05, -2.925267904671263e-07,  4.074577989240394e-09,
 -5.068800158834907e-11,  5.770407644561148e-13, -6.109792096629638e-15,  6.086338548316882e-17, -5.753076328252024e-19,  5.194049045905456e-21, -4.501884777139897e-23,
  2.238635211388767e-02, -8.663778287666245e-04,  2.113196081969954e-05, -4.006851685931298e-07,  6.426806700752112e-09, -9.111038390706863e-11,  1.172416122450344e-12,
 -1.393890914448726e-14,  1.550458816212631e-16, -1.628625934310230e-18,  1.627125007531029e-20, -1.554818360999183e-22,  1.703240539333709e-02, -8.096406601548835e-04,
  2.329852303884223e-05, -5.113905112386665e-07,  9.373514864556296e-09, -1.504081947622060e-10,  2.174190712960882e-12, -2.885760946343965e-14,  3.564756655616393e-16,
 -4.139652084412105e-18,  4.554199670060356e-20, -4.775068069920274e-22,  1.261441160343016e-02, -7.226083825084033e-04,  2.427866854921881e-05, -6.118533619605470e-07,
  1.272744720792502e-08, -2.297409513298916e-10,  3.709788181227767e-12, -5.468631460598436e-14,  7.465801675689004e-16, -9.540811699978585e-18,  1.150738875892875e-19,
 -1.318332090020428e-21,  9.104005577075499e-03, -6.183575257190226e-04,  2.402407638280786e-05, -6.898847580106217e-07,  1.618221336392830e-08, -3.267487036079971e-10,
  5.863932060177490e-12, -9.555102179590839e-14,  1.435303111597581e-15, -2.010091438596359e-17,  2.647441524410507e-19, -3.301440273191342e-21,  6.410600764138605e-03,
 -5.090949319858649e-04,  2.266723464788558e-05, -7.365042642527656e-07,  1.936510423153366e-08, -4.351100031899318e-10,  8.637350812693931e-12, -1.548988889682240e-13,
  2.549751615792751e-15, -3.898212977133275e-17,  5.586128148857610e-19, -7.556170085652158e-21,  4.410035692954094e-03, -4.045125206239563e-04,  2.047025088273078e-05,
 -7.476308284461473e-07,  2.191251170844855e-08, -5.451810013882526e-10,  1.191792645397212e-11, -2.342699725462215e-13,  4.209739128635424e-15, -7.001051946516356e-17,
  1.087848535177586e-18, -1.590978084549236e-20,  2.968174081940918e-03, -3.110931880727606e-04,  1.775580954877459e-05, -7.244535570810716e-07,  2.354461673562574e-08,
 -6.456448285305654e-10,  1.547784364769071e-11, -3.322002956100357e-13,  6.493346731866347e-15, -1.170715902459565e-16,  1.966200990907549e-18, -3.099586008585472e-20,
  1.957569810026830e-03, -2.321980231603138e-04,  1.484150911090687e-05, -6.725620776104272e-07,  2.411715829714859e-08, -7.257151406075903e-10,  1.900230507957001e-11,
 -4.436857441407544e-13,  9.401354522746950e-15, -1.831698995409171e-16,  3.314988069735148e-18, -5.616675205004896e-20,  1.267219610369139e-03, -1.686466220797854e-04,
  1.199210172096023e-05, -6.002815652262420e-07,  2.363765704455007e-08, -7.772366265360133e-10,  2.214406848852674e-11, -5.605039591326591e-13,  1.283268683773022e-14,
 -2.693552862455933e-16,  5.237690790312630e-18, -9.511586916057919e-20,  8.066175385699494e-04, -1.194992259580670e-04,  9.395120501801905e-06, -5.167928536018526e-07,
  2.224634711026011e-08, -7.960895060082765e-10,  2.458859663981225e-11, -6.724108685044101e-13,  1.658155009347551e-14, -3.738410798011401e-16,  7.788727355342592e-18,
 -1.511928336420819e-19,  5.058079935570684e-04, -8.281837999999476e-05,  7.157722819958875e-06, -4.305330929525610e-07,  2.017260598696977e-08, -7.825826175451339e-10,
  2.611120346443001e-11, -7.689199785281039e-13,  2.036063450934798e-14, -4.916477198061528e-16,  1.094489790892571e-17, -2.265146303105959e-19,  3.130916578910853e-04,
 -5.628157970456050e-05,  5.318206388800994e-06, -3.481597734200978e-07,  1.768240716314015e-08, -7.408696415169099e-10,  2.661129748171445e-11, -8.411729233228905e-13,
  2.384605285237265e-14, -6.149733471248952e-16,  1.458921963516936e-17, -3.210920570606390e-19,  1.917043644848925e-04, -3.760029374415200e-05,  3.864651213229712e-06,
 -2.741314642999633e-07,  1.503099650605341e-08, -6.776986659208953e-10,  2.611738734690402e-11, -8.833993848170794e-13,  2.673234818015702e-14, -7.342654672904825e-16,
  1.851429347874134e-17, -4.322441705356996e-19,  1.163621008344286e-04, -2.475803066925815e-05,  2.754464604082058e-06, -2.107912516959369e-07,  1.242976152081863e-08,
 -6.009224833123493e-10,  2.476589707975784e-11, -8.936310940397966e-13,  2.878296765058085e-14, -8.397386831585779e-16,  2.244664252946556e-17, -5.545265386627172e-19,
  7.017572664040897e-05, -1.610879473821897e-05,  1.930925150535341e-06, -1.587622767503744e-07,  1.003004657014579e-08, -5.181548836116874e-10,  2.276345328710226e-11,
 -8.735912009313183e-13,  2.986393375442677e-14, -9.229473425091222e-16,  2.608687934507456e-17, -6.802594141150627e-19,  4.214644780027905e-05, -1.038389652401731e-05,
  1.335080286548032e-06, -1.174665547436959e-07,  7.921750982678588e-09, -4.358158653257907e-10,  2.034448077401639e-11, -8.279179084806698e-13,  2.995455659526405e-14,
 -9.780269444098366e-16,  2.915576003873782e-17, -8.005615373855948e-19,  2.526707374403210e-05, -6.648724578891608e-06,  9.129895118306414e-07, -8.562615469171771e-08,
  6.141945217166796e-09, -3.586425946540231e-10,  1.773411482522523e-11, -7.630214425259017e-13,  2.913612415279382e-14, -1.002347919032198e-15,  3.143493268259138e-17,
 -9.066453490978872e-19,  1.515649627368938e-05, -4.239581145593578e-06,  6.191969833874171e-07, -6.166728923302466e-08,  4.688322216888183e-09, -2.896116689588479e-10,
  1.512235743103338e-11, -6.858935564804118e-13,  2.756495390144456e-14, -9.965157200583316e-16,  3.279361220676674e-17, -9.910652779265877e-19,  9.118420507310106e-06,
 -2.699146727110628e-06,  4.176016654323402e-07, -4.400085041972148e-08,  3.533305545786373e-09, -2.301474972040851e-10,  1.265103200658042e-11, -6.031155409602952e-13,
  2.543858376071111e-14, -9.638265028377257e-16,  3.319716690177363e-17, -1.048647988567440e-18,  5.514765211798108e-06, -1.720027103218293e-06,  2.808005877138555e-07,
 -3.118795458035038e-08,  2.636197359927069e-09, -1.804780063705062e-10,  1.041180144853632e-11, -5.201946107186085e-13,  2.296327378516802e-14, -9.093947136312673e-16,
  3.269869595695494e-17, -1.076946152724703e-18,  3.360435645531015e-06, -1.099748741263399e-06,  1.887206646662517e-07, -2.201607648779058e-08,  1.952224388936212e-09,
 -1.400230719525296e-10,  8.451829144409949e-12, -4.412472774476668e-13,  2.032843635673868e-14, -8.391918728958097e-16,  3.141842774670010e-17, -1.076196067528239e-18,
  2.067485021354966e-06, -7.071017650235126e-07,  1.270693712549330e-07, -1.551508225064083e-08,  1.438404824012394e-09, -1.077409418417166e-10,  6.783411662618078e-12,
 -3.689709924612123e-13,  1.769045877750062e-14, -7.591915228258927e-16,  2.951736761055646e-17, -1.048875947242580e-18,  1.286762946645476e-06, -4.581320521157264e-07,
  8.589757668692613e-08, -1.093864318818565e-08,  1.056752688334755e-09, -8.239678011008427e-11,  5.394577797938745e-12, -3.048097781542475e-13,  1.516569462099771e-14,
 -6.747368198532788e-16,  2.717119514739020e-17, -9.990267511077888e-19,  8.114688819651667e-07, -2.996278186292005e-07,  5.840181870330188e-08, -7.729773947429439e-09,
  7.755492845061355e-10, -6.274653954638441e-11,  4.258680234209432e-12, -2.492183892848380e-13,  1.283071303324565e-14, -5.901669856157514e-16,  2.454867778090355e-17,
 -9.315062657842821e-19,  5.191533135443221e-07, -1.980798658119425e-07,  3.999283467889049e-08, -5.482491356310411e-09,  5.693835298927636e-10, -4.764659095805011e-11,
  3.341999813939595e-12, -2.019489349707541e-13,  1.072724897975655e-14, -5.086780471864518e-16,  2.179670684351088e-17, -8.513138293502447e-19,  3.371752037921459e-07,
 -1.324640908114289e-07,  2.760572041338950e-08, -3.906196811782562e-09,  4.185206148074930e-10, -3.610677121582978e-11,  2.609130294041473e-12, -1.623105654551409e-13,
  8.869431449669709e-15, -4.323597026790191e-16,  1.903216613811233e-17, -7.630694706524350e-19,  2.222694543657647e-07, -8.960391265831089e-08,  1.920718143020722e-08,
 -2.795672564687809e-09,  3.079885576500200e-10, -2.730509624607734e-11,  2.026364854783668e-12, -1.293776090813861e-13,  7.251426071218017e-15, -3.623410567503814e-16,
  1.633957202480947e-17, -6.706774031646908e-19,  1.485113511352945e-07, -6.122911875234770e-08,  1.345302773235217e-08, -2.007342799372093e-09,  2.266221439684126e-10,
 -2.057949610065290e-11,  1.563509508312969e-12, -1.021399666267055e-13,  5.854307533568802e-15, -2.989854948199386e-16,  1.377283356054711e-17, -5.771625459688501e-19,
  1.002393308545205e-07, -4.212791363454884e-08,  9.454921026263081e-09, -1.441289112382668e-09,  1.661911728055994e-10, -1.540787469466527e-11,  1.194582660884247e-12,
 -7.960077992773406e-14,  4.651579458909238e-15, -2.420905103908677e-16,  1.135943192169241e-17, -4.846446882985530e-19,  6.789043379595907e-08, -2.899263184757033e-08,
  6.623861216763006e-09, -1.028039347274326e-09,  1.206653013481127e-10, -1.138392474472119e-11,  8.978012259332269e-13, -6.083158082112891e-14,  3.613197846327023e-15,
 -1.910651979118101e-16,  9.105599355499012e-18, -3.944066161263804e-19,  4.554160205872864e-08, -1.970042374943007e-08,  4.566169043021668e-09, -7.190674246694634e-10,
  8.562373104871429e-11, -8.193034761930486e-12,  6.551589898479856e-13, -4.499620956429347e-14,  2.708220144887117e-15, -1.450724698256746e-16,  7.001495099780639e-18,
 -3.070154577509455e-19,  2.944846470242349e-08, -1.286416065837625e-08,  3.014629126734863e-09, -4.800475935973732e-10,  5.779541229775130e-11, -5.590437628282809e-12,
  4.518076273366130e-13, -3.135361670254456e-14,  1.906330271554979e-15, -1.031334686275206e-16,  5.025798582624686e-18, -2.224658460658522e-19,  1.716681337087100e-08,
 -7.549893053025576e-09,  1.782777014388918e-09, -2.860840506169571e-10,  3.470700715766202e-11, -3.382422053826815e-12,  2.753772324793319e-13, -1.924798235632991e-14,
  1.178550816342106e-15, -6.419956134539952e-17,  3.149562600994620e-18, -1.403280571229759e-19,  7.021794824826915e-09, -3.099739307285309e-09,  7.350498299957642e-10,
 -1.184604790767776e-10,  1.443244841274086e-11, -1.412416399048330e-12,  1.154619322557838e-13, -8.102768982911828e-15,  4.980752611893411e-16, -2.723567511461146e-17,
  1.341149472285958e-18, -5.997215618538900e-20,  6.799079717665638e-02, -1.929190006099226e-04,  5.710288392524828e-07, -1.747931731663120e-09,  5.480382263189447e-12,
 -1.745290899373393e-14,  5.608078371077723e-17, -1.809847573750073e-19,  5.847503368661524e-22, -1.887846980745571e-24,  6.082592487308473e-27, -1.954644027352571e-29,
  6.560453023114339e-02, -2.491219053512322e-04,  1.116598958876796e-06, -5.127489716843803e-09,  2.310992289035596e-11, -1.015559598603811e-13,  4.360500686887101e-16,
 -1.835362484729168e-18,  7.594397039374326e-21, -3.096119549497595e-23,  1.245788220807948e-25, -4.954061088094872e-28,  6.108704176452637e-02, -3.491893843474203e-04,
  2.257754248636172e-06, -1.372006117202859e-08,  7.848714751613954e-11, -4.285925172851140e-13,  2.255716136637770e-15, -1.151593249264492e-17,  5.728696237388840e-20,
 -2.786309335350011e-22,  1.328525350083501e-24, -6.222860178658693e-27,  5.490246539829979e-02, -4.717446113261958e-04,  4.040627075309573e-06, -3.076324052838163e-08,
  2.156649435875457e-10, -1.422174951601354e-12,  8.933983371262347e-15, -5.391740371940928e-17,  3.145201431821792e-19, -1.781530370085217e-21,  9.833515935747042e-24,
 -5.304133412863414e-26,  4.764380247001915e-02, -5.918731900327430e-04,  6.430227070932566e-06, -5.996474158443071e-08,  5.054472426680017e-10, -3.952036282308532e-12,
  2.911653815021625e-14, -2.042798079180732e-16,  1.375211377775412e-18, -8.933731884233914e-21,  5.624939726967920e-23, -3.444438468271564e-25,  3.993797661708828e-02,
 -6.870701979825830e-04,  9.253864206949983e-06, -1.040981668717359e-07,  1.039853802308631e-09, -9.510076341390696e-12,  8.113263819705718e-14, -6.538158923125496e-16,
  5.021644768451529e-18, -3.700486774275445e-20,  2.629799594596011e-22, -1.809601622989941e-24,  3.235740225418036e-02, -7.418973996674221e-04,  1.219874966296163e-05,
 -1.634551698387724e-07,  1.912614526272749e-09, -2.024317552879320e-11,  1.980064882204670e-13, -1.815762621872701e-15,  1.577038387378890e-17, -1.307126310899152e-19,
  1.039956678178104e-21, -7.978347240995993e-24,  2.535493453432230e-02, -7.502366524378954e-04,  1.486983246916018e-05, -2.347455991582506e-07,  3.186511867510908e-09,
 -3.868962520344759e-11,  4.303847257158428e-13, -4.457021137607296e-15,  4.345915829938153e-17, -4.023664333901913e-19,  3.560212379419725e-21, -3.025770910335974e-23,
  1.923079716251485e-02, -7.149361140777637e-04,  1.688519194482954e-05, -3.110283561209465e-07,  4.857048402895804e-09, -6.714521853226777e-11,  8.435967041329576e-13,
 -9.802179895836721e-15,  1.066495399042364e-16, -1.096571414901473e-18,  1.073063674169707e-20, -1.004883067068678e-22,  1.413107309944892e-02, -6.454611005610086e-04,
  1.797091027281048e-05, -3.828976211161512e-07,  6.827827868116712e-09, -1.067608374295563e-10,  1.505762055208027e-12, -1.952061331831369e-14,  2.357335329846777e-16,
 -2.678206602651328e-18,  2.884498188903114e-20, -2.962607257571825e-22,  1.007039951217864e-02, -5.546063074256801e-04,  1.802099039466427e-05, -4.406110126720622e-07,
  8.911661365119663e-09, -1.566692070885084e-10,  2.467136219815373e-12, -3.550521875357353e-14,  4.736507291392171e-16, -5.919431604845757e-18,  6.986943935484826e-20,
 -7.838314631544419e-22,  6.968146112553444e-03, -4.553289643898683e-04,  1.710578884232146e-05, -4.764267375498141e-07,  1.086210396119557e-08, -2.135314564585506e-10,
  3.735808257911907e-12, -5.940973060647810e-14,  8.717678738878707e-16, -1.193611355024787e-17,  1.538071511281044e-19, -1.877753833228309e-21,  4.687570696504798e-03,
 -3.584368435417445e-04,  1.543388172091075e-05, -4.863410632950907e-07,  1.242721860154437e-08, -2.717969385981937e-10,  5.258846121014430e-12, -9.202457722302269e-14,
  1.479490844562590e-15, -2.211057225014543e-17,  3.099455239322065e-19, -4.103986276451600e-21,  3.070126443014176e-03, -2.714143521160144e-04,  1.328730976391266e-05,
 -4.707021307806259e-07,  1.340765242302452e-08, -3.247023979791950e-10,  6.918206227656363e-12, -1.326891917453068e-13,  2.328701659457782e-15, -3.785517733968356e-17,
  5.753835494289150e-19, -8.237107154823220e-21,  1.960730964433752e-03, -1.982807422593028e-04,  1.095417961063912e-05, -4.336448933573502e-07,  1.369957748842552e-08,
 -3.657270340435020e-10,  8.546155200624509e-12, -1.789894692145976e-13,  3.417221265224616e-15, -6.022759507834444e-17,  9.895453473463606e-19, -1.527115598396478e-20,
  1.223113692648739e-03, -1.401498947725877e-04,  8.677082486987505e-06, -3.817051462665903e-07,  1.330995009196651e-08, -3.900279999735782e-10,  9.957378426433512e-12,
 -2.269245691654080e-13,  4.697494501574856e-15, -8.948656760752320e-17,  1.584658131212445e-18, -2.628930165708964e-20,  7.466122636301241e-04, -9.611113611886961e-05,
  6.625703717650334e-06, -3.221642074170405e-07,  1.234275271819040e-08, -3.953994916809913e-10,  1.098809517547010e-11, -2.715616970295147e-13,  6.076088775915885e-15,
 -1.247382024860647e-16,  2.374096133201260e-18, -4.222691572820210e-20,  4.468418333933589e-04, -6.412294870120289e-05,  4.892495457052883e-06, -2.616251587672788e-07,
  1.096480202776971e-08, -3.825040033911026e-10,  1.152977985965008e-11, -3.080062176122120e-13,  7.426185882527905e-15, -1.638266328669699e-16,  3.342184260230190e-18,
 -6.356967106158973e-20,  2.627555009825751e-04, -4.173515747607653e-05,  3.504468831904623e-06, -2.051143435933952e-07,  9.364457146087865e-09, -3.544022470934684e-10,
  1.154761364083087e-11, -3.323909581529816e-13,  8.610428518689136e-15, -2.035549055363765e-16,  4.439493316190853e-18, -9.007277152953402e-20,  1.521439185094957e-04,
 -2.657291308234916e-05,  2.442585125687005e-06, -1.557631632771917e-07,  7.715500108312262e-09, -3.156288058304753e-10,  1.107993626468825e-11, -3.425894865679683e-13,
  9.507532752374447e-15, -2.402065111424570e-16,  5.586326544551883e-18, -1.206041230760367e-19,  8.695251967519290e-05, -1.659743960713325e-05,  1.661701891318171e-06,
 -1.149501573414164e-07,  6.153594289085279e-09, -2.711469966685201e-10,  1.022160736291961e-11, -3.384739509510398e-13,  1.003482578854844e-14, -2.702273191299462e-16,
  6.684397485652169e-18, -1.531881991668514e-19,  4.917064555697580e-05, -1.019869532858606e-05,  1.106817935631258e-06, -8.270790004090238e-08,  4.766997318346285e-09,
 -2.254688372456098e-10,  9.098544154310334e-12, -3.217056209144030e-13,  1.016070943934289e-14, -2.908724162998790e-16,  7.633800501936791e-18, -1.852648112913443e-19,
  2.758317152455094e-05, -6.183129823781664e-06,  7.240515331381848e-07, -5.820900598325906e-08,  3.598894177078756e-09, -1.820999078143617e-10,  7.841618475151579e-12,
 -2.951894753295397e-13,  9.904877175297639e-15, -3.006438133902190e-16,  8.350573810753054e-18, -2.141039128901415e-19,  1.539063849832554e-05, -3.709468622032508e-06,
  4.666495654709110e-07, -4.020224097959210e-08,  2.656739523012955e-09, -1.433332723267095e-10,  6.566140697608491e-12, -2.623933081158206e-13,  9.328096339246707e-15,
 -2.994267803090546e-16,  8.780172371258346e-18, -2.372657786930453e-19,  8.565179871021157e-06, -2.208772638106147e-06,  2.972373869193580e-07, -2.733600039137511e-08,
  1.924075551885140e-09, -1.103202616856553e-10,  5.359869127872991e-12, -2.267199679435285e-13,  8.515967767792657e-15, -2.883339160141823e-16,  8.903830640262604e-18,
 -2.529861720719715e-19,  4.767613766810610e-06, -1.309282167446733e-06,  1.877026679782143e-07, -1.835880498424889e-08,  1.371551664823675e-09, -8.330524303729518e-11,
  4.279399738798892e-12, -1.910554450226978e-13,  7.561679247789674e-15, -2.693455146348452e-16,  8.737236923638106e-18, -2.603985932967258e-19,  2.661825616342384e-06,
 -7.749370249946796e-07,  1.178819004954244e-07, -1.221697151312195e-08,  9.654326241546713e-10, -6.191706162773444e-11,  3.352829259122267e-12, -1.575344004281933e-13,
  6.551707422661949e-15, -2.448690755861728e-16,  8.323128466615980e-18, -2.595625289651683e-19,  1.494851417728787e-06, -4.593528800407366e-07,  7.385311239858607e-08,
 -8.080740467164544e-09,  6.731671268415309e-10, -4.544075926766529e-11,  2.585921947611222e-12, -1.274993986409425e-13,  5.556545735033972e-15, -2.173300779065633e-16,
  7.720643314933859e-18, -2.513231900261733e-19,  8.467591809238329e-07, -2.734890349338981e-07,  4.629505547921199e-08, -5.328734919867127e-09,  4.663799245087797e-10,
 -3.302964222043505e-11,  1.969319947634046e-12, -1.015946606301511e-13,  4.626702031145546e-15, -1.888670171991126e-16,  6.994367545814545e-18, -2.370653202164485e-19,
  4.850900788381891e-07, -1.640065949408930e-07,  2.911962577405182e-08, -3.513472080275216e-09,  3.219813464531697e-10, -2.384736998383359e-11,  1.485121286747638e-12,
 -7.992829071473034e-14,  3.792953880084402e-15, -1.611573749021794e-16,  6.205282875697750e-18, -2.184340757503566e-19,  2.817509406737167e-07, -9.932149625397366e-08,
  1.842794100516697e-08, -2.322476663640170e-09,  2.221052110652337e-10, -1.714798193858584e-11,  1.111987393838418e-12, -6.224883499717493e-14,  3.069313842752891e-15,
 -1.353638198789564e-16,  5.404734181944189e-18, -1.970839618688343e-19,  1.662843108338708e-07, -6.088313298310670e-08,  1.176079358913371e-08, -1.542774904715309e-09,
  1.534458090159359e-10, -1.230960978408236e-11,  8.285919146121883e-13, -4.810146661791412e-14,  2.457200079166784e-15, -1.121687520353479e-16,  4.631532262665966e-18,
 -1.744928312069590e-19,  9.990117071398174e-08, -3.784935229843527e-08,  7.584298292366075e-09, -1.031911045168195e-09,  1.063815710419075e-10, -8.838342912432501e-12,
  6.156119117065988e-13, -3.694772615149589e-14,  1.949675707395499e-15, -9.185966644999973e-17,  3.911631934439059e-18, -1.518527682058412e-19,  6.117373623727075e-08,
 -2.389525411958453e-08,  4.948898818297803e-09, -6.959298303246391e-10,  7.411065588486935e-11, -6.355777895112619e-12,  4.566250368229246e-13, -2.824637308256932e-14,
  1.535078718337736e-15, -7.443280684560624e-17,  3.259531118065539e-18, -1.300305217996490e-19,  3.819556071607712e-08, -1.532759993751322e-08,  3.269209667552996e-09,
 -4.734744540301032e-10,  5.190553404309076e-11, -4.579741744124804e-12,  3.382876495412906e-13, -2.150069791217373e-14,  1.199761544273225e-15, -5.969241100735765e-17,
  2.680543639937499e-18, -1.095796684971747e-19,  2.429663557583662e-08, -9.981916882436786e-09,  2.184706922645868e-09, -3.247186551913616e-10,  3.651974671167720e-11,
 -3.303975719199214e-12,  2.501033848732457e-13, -1.628068644898038e-14,  9.299321130307534e-16, -4.733305457510304e-17,  2.173278622850935e-18, -9.078402789345189e-20,
  1.570121498921841e-08, -6.581611790819333e-09,  1.472877739747001e-09, -2.238721831014447e-10,  2.574043889850510e-11, -2.379776985940493e-12,  1.840028362226481e-13,
 -1.222842273055638e-14,  7.127353759032549e-16, -3.700069210037192e-17,  1.731895557517712e-18, -7.371440805204584e-20,  1.024409391406165e-08, -4.366741606389866e-09,
  9.956257934489170e-10, -1.542067767864152e-10,  1.806329986866657e-11, -1.700770384388450e-12,  1.338729807507415e-13, -9.053607270082474e-15,  5.367658306606151e-16,
 -2.833320860445554e-17,  1.347919074005933e-18, -5.828572508622959e-20,  6.663252362277168e-09, -2.878949510786689e-09,  6.663913159832291e-10, -1.047998143751872e-10,
  1.246251847586258e-11, -1.190936134681237e-12,  9.511195226918292e-14, -6.524124500155941e-15,  3.921944618108536e-16, -2.098392874002221e-17,  1.011555628907394e-18,
 -4.430680035153816e-20,  4.206783265107204e-09, -1.836375817051135e-09,  4.300000457782553e-10, -6.841785167770025e-11,  8.230622783538474e-12, -7.955097239995402e-13,
  6.424224189384941e-14, -4.454814690544151e-15,  2.706590213375275e-16, -1.463234025006639e-17,  7.125516839444201e-19, -3.151953403555586e-20,  2.411594509553016e-09,
 -1.060218871492582e-09,  2.502482790896757e-10, -4.014064362517160e-11,  4.867722457041824e-12, -4.741951308410746e-13,  3.859056959195938e-14, -2.696284119548556e-15,
  1.650287165485178e-16, -8.986229675913699e-18,  4.406901873393880e-19, -1.962768946133978e-20,  9.772188452680940e-10, -4.313116705467870e-10,  1.022573172957390e-10,
 -1.647634021435201e-11,  2.006952217014481e-12, -1.963678152938560e-13,  1.604936976786600e-14, -1.126070068912423e-15,  6.920555745584455e-17, -3.783549776068806e-18,
  1.862752108450152e-19, -8.328094081464278e-21,  6.722812686291252e-02, -1.884332060167545e-04,  5.505684885171645e-07, -1.662966637270564e-09,  5.144383665291811e-12,
 -1.616572776513083e-14,  5.126528692358995e-17, -1.633148196250566e-19,  5.209678309118094e-22, -1.660895336591817e-24,  5.285158794589174e-27, -1.677594251703074e-29,
  6.462552717910436e-02, -2.404290980432277e-04,  1.057222403233903e-06, -4.773428286336014e-09,  2.117943078316348e-11, -9.168097520159445e-14,  3.879012647269274e-16,
 -1.609254724300338e-18,  6.564478153149447e-21, -2.638781560760709e-23,  1.047068744577818e-25, -4.106748273134094e-28,  5.972539487405795e-02, -3.317651976702173e-04,
  2.100374646984120e-06, -1.253000618070944e-08,  7.043158345063903e-11, -3.781264481904396e-13,  1.957496770508031e-15, -9.833497168907499e-18,  4.815031824357494e-20,
 -2.305838478435420e-22,  1.082757592247129e-24, -4.995818230117291e-27,  5.307787903755174e-02, -4.408396578894518e-04,  3.691269770383810e-06, -2.752899307433461e-08,
  1.892489517045385e-10, -1.224794949013921e-12,  7.556075364162281e-15, -4.480734454185523e-17,  2.569368782796582e-19, -1.431162450102235e-21,  7.770711513289263e-24,
 -4.124249893033810e-26,  4.537482249390001e-02, -5.431779691356596e-04,  5.756682645160373e-06, -5.247380247814023e-08,  4.329556727410891e-10, -3.317186967385818e-12,
  2.396738130745717e-14, -1.650126204824737e-16,  1.090693115752463e-18, -6.959900490300891e-21,  4.306201964881810e-23, -2.592095251141328e-25,  3.733022726714052e-02,
 -6.177669536907263e-04,  8.098561969739030e-06, -8.888223400918860e-08,  8.677301276937306e-10, -7.765578918210129e-12,  6.488883988853410e-14, -5.125539430888225e-16,
  3.861080344346527e-18, -2.792087208030964e-20,  1.948040981238986e-22, -1.316554250081256e-24,  2.957326594709244e-02, -6.516621933192143e-04,  1.040832962504602e-05,
 -1.358503581388032e-07,  1.551431682465719e-09, -1.604816745558042e-11,  1.535763450336440e-13, -1.379011987494055e-15,  1.173596754388243e-17, -9.537184829860568e-20,
  7.443343986591303e-22, -5.604210358482691e-24,  2.257521501430531e-02, -6.417344119683478e-04,  1.233496372547410e-05, -1.894302934376249e-07,  2.506661923695706e-09,
 -2.971326505830006e-11,  3.230620703599677e-13, -3.273014806274583e-15,  3.124585998485098e-17, -2.834167773155298e-19,  2.458215596477645e-21, -2.048990847688910e-23,
  1.661931663953816e-02, -5.935581728779305e-04,  1.357813659031939e-05, -2.430455847672693e-07,  3.696224311641190e-09, -4.984050080091162e-11,  6.115240552461977e-13,
 -6.946118858435027e-15,  7.393984988876806e-17, -7.443274133474285e-19,  7.135562061849483e-21, -6.549864238697310e-23,  1.181008599384611e-02, -5.183661187431770e-04,
  1.396703528739754e-05, -2.889421633225404e-07,  5.013775690877732e-09, -7.641077685890736e-11,  1.051750265380409e-12, -1.332033184005589e-14,  1.572852328692214e-16,
 -1.748565982902582e-18,  1.844017484931525e-20, -1.855583124360402e-22,  8.109956227182441e-03, -4.293825377887117e-04,  1.349534271132748e-05, -3.201838989582563e-07,
  6.297945310557450e-09, -1.078541379595002e-10,  1.656636811983054e-12, -2.327956144406976e-14,  3.035180420075299e-16, -3.710148768400552e-18,  4.286306224433233e-20,
 -4.709465692564594e-22,  5.388094274984985e-03, -3.386921568981132e-04,  1.230486011264014e-05, -3.324401777309067e-07,  7.368076929040413e-09, -1.410396918554044e-10,
  2.405902432917556e-12, -3.734581362439538e-14,  5.354045967839956e-16, -7.167924080656210e-18,  9.037882850307345e-20, -1.080358489920212e-21,  3.468082128803829e-03,
 -2.553025246268647e-04,  1.063144830704308e-05, -3.249240082620691e-07,  8.069504398360061e-09, -1.718129931958855e-10,  3.240516842317648e-12, -5.533765080335587e-14,
  8.690289324470037e-16, -1.269657208855198e-17,  1.741223777699360e-19, -2.257071905397269e-21,  2.165857319980652e-03, -1.845033391698191e-04,  8.737818638300148e-06,
 -3.002371353711511e-07,  8.311736666349911e-09, -1.959447933831830e-10,  4.069278922693778e-12, -7.615778431793848e-14,  1.305452255474328e-15, -2.074453661800926e-17,
  3.084536374689458e-19, -4.322691804845754e-21,  1.314527446697926e-03, -1.282271156944484e-04,  6.856147704527110e-06, -2.633286737256099e-07,  8.086424607728736e-09,
 -2.101627683329371e-10,  4.787098926381357e-12, -9.783735015796569e-14,  1.824471061445570e-15, -3.143467293446630e-17,  5.052692237596977e-19, -7.633589669156297e-21,
  7.767617708384151e-04, -8.595286374137803e-05,  5.153775030745705e-06, -2.200549571202239e-07,  7.461080638009618e-09, -2.129009584844370e-10,  5.299309188391587e-12,
 -1.178718865350313e-13,  2.383715281271537e-15, -4.439815254537564e-17,  7.692798887668685e-19, -1.249585702976177e-20,  4.477450659181972e-04, -5.573147207381590e-05,
  3.723871024776979e-06, -1.758529393878643e-07,  6.554071807850952e-09, -2.045329082070861e-10,  5.543599027910656e-12, -1.337605541173669e-13,  2.924618676370108e-15,
 -5.871965674565396e-17,  1.093805166270648e-18, -1.905386887664986e-20,  2.522977761140173e-04, -3.505510520532621e-05,  2.594878964383320e-06, -1.348649357144041e-07,
  5.501936019007520e-09, -1.870730169299983e-10,  5.502328020737921e-12, -1.435707091138924e-13,  3.384045444204902e-15, -7.304041839991975e-17,  1.458914286774522e-18,
 -2.718693847630379e-20,  1.392898859790442e-04, -2.145232631937717e-05,  1.749490981861837e-06, -9.960954818727515e-08,  4.430069233409301e-09, -1.635215665382503e-10,
  5.202170142487684e-12, -1.463410439570326e-13,  3.707956901224009e-15, -8.580597731010713e-17,  1.833154190491311e-18, -3.645631775929478e-20,  7.552698339332616e-05,
 -1.281012874249461e-05,  1.144983115122545e-06, -7.109946464546173e-08,  3.433771586998701e-09, -1.371131108362337e-10,  4.702938236605360e-12, -1.422083055863768e-13,
  3.862683926508633e-15, -9.558644606777389e-17,  2.178817976113446e-18, -4.613343739616465e-20,  4.032570482140270e-05, -7.486897459505233e-06,  7.298122282177405e-07,
 -4.921592716863148e-08,  2.571366694142639e-09, -1.106954134595431e-10,  4.080738926681344e-12, -1.322530760249098e-13,  3.840469166929065e-15, -1.013683473599210e-16,
  2.459317250509600e-18, -5.531244904377718e-20,  2.125915437141853e-05, -4.296032804999394e-06,  4.545668296162964e-07, -3.315404847798398e-08,  1.867036267888136e-09,
 -8.636243285488241e-11,  3.411267309205362e-12, -1.181544096406812e-13,  3.658271692400214e-15, -1.027314448088424e-16,  2.646410706458078e-18, -6.307826536460143e-20,
  1.109797799749778e-05, -2.427927547721948e-06,  2.776072259836426e-07, -2.181164306569155e-08,  1.319185593018501e-09, -6.535212010589319e-11,  2.757487259357785e-12,
 -1.017849555844785e-13,  3.351190794164744e-15, -9.987122158240080e-17,  2.725172515414004e-18, -6.868058967493974e-20,  5.754175336660917e-06, -1.355901835805712e-06,
  1.668035920123903e-07, -1.406385217735596e-08,  9.103284453850822e-10, -4.814254778827729e-11,  2.163414610829931e-12, -8.486364731788981e-14,  2.963277321072721e-15,
 -9.348296345377107e-17,  2.695522173141206e-18, -7.166405477151804e-20,  2.972502021273802e-06, -7.507597351110817e-07,  9.895520055034122e-08, -8.919499460090081e-09,
  6.157580341697078e-10, -3.465198416691766e-11,  1.653471928483975e-12, -6.873355395017907e-14,  2.538625015557632e-15, -8.456271627231890e-17,  2.570380217507492e-18,
 -7.192306989381438e-20,  1.534833535824427e-06, -4.135590473445921e-07,  5.816538234673034e-08, -5.584216012766767e-09,  4.097557602701692e-10, -2.445957118475786e-11,
  1.235603155821125e-12, -5.427711213057314e-14,  2.114773568576281e-15, -7.419204531298087e-17,  2.371509875470718e-18, -6.967723451035074e-20,  7.947495652505802e-07,
 -2.274259124738669e-07,  3.399589338974834e-08, -3.463668860062295e-09,  2.692290342673746e-10, -1.699314258316112e-11,  9.060795272053105e-13, -4.194099170049394e-14,
  1.719220031360751e-15, -6.336050575936072e-17,  2.124528520329343e-18, -6.538700492738377e-20,  4.140693114999762e-07, -1.252896715542014e-07,  1.982732929646356e-08,
 -2.136092140892779e-09,  1.752927629013711e-10, -1.166178186408176e-11,  6.543562316495660e-13, -3.182580497373268e-14,  1.368775676640674e-15, -5.285399806306281e-17,
  1.854418895371275e-18, -5.964157242164823e-20,  2.177846675822628e-07, -6.938368579795421e-08,  1.157970763395742e-08, -1.314449394954438e-09,  1.134967721618460e-10,
 -7.933212123954399e-12,  4.670235036442471e-13, -2.379799767291669e-14,  1.070904580191875e-15, -4.321159435977824e-17,  1.582360827595018e-18, -5.305022739828998e-20,
  1.160110077544107e-07, -3.875455967232656e-08,  6.795211152219732e-09, -8.098232483596114e-10,  7.332626190835226e-11, -5.367793120109370e-12,  3.305181367313738e-13,
 -1.759380201654172e-14,  8.260470972806121e-16, -3.473616662129853e-17,  1.324122780495814e-18, -4.615882052689954e-20,  6.278128799266688e-08, -2.190277064696932e-08,
  4.019596489097635e-09, -5.011440161011273e-10,  4.742294541467775e-11, -3.624003398536070e-12,  2.326753519931798e-13, -1.289981388867617e-14,  6.301123417582522e-16,
 -2.753733802575565e-17,  1.089807676239438e-18, -3.940027593789234e-20,  3.461417888730454e-08, -1.256209788163662e-08,  2.403934372239409e-09, -3.124242968329228e-10,
  3.079244303469360e-11, -2.448418020717392e-12,  1.633963780598674e-13, -9.406490500583565e-15,  4.766303407400648e-16, -2.158667372304039e-17,  8.845213957001404e-19,
 -3.307739728675269e-20,  1.949119479297094e-08, -7.330260213624144e-09,  1.457261983573517e-09, -1.967186954747118e-10,  2.012436207070978e-11, -1.659451225450722e-12,
  1.147434141279198e-13, -6.837927019839545e-15,  3.583456183972211e-16, -1.677072967876038e-17,  7.095026654136688e-19, -2.736985934213271e-20,  1.123063678567599e-08,
 -4.360420431669034e-09,  8.972004149038808e-10, -1.253484613163476e-10,  1.326360332742707e-11, -1.130433372961797e-12,  8.072410961723015e-14, -4.964159083063977e-15,
  2.682403302576618e-16, -1.293413411678957e-17,  5.633452397797085e-19, -2.235535250038321e-20,  6.628361731377632e-09, -2.647145368039410e-09,  5.616541467859246e-10,
 -8.091818639000756e-11,  8.825258600339053e-12, -7.747680724653828e-13,  5.694954742796531e-14, -3.602360475953269e-15,  2.000858612059161e-16, -9.910202362478887e-18,
  4.430796094952438e-19, -1.803602481375308e-20,  4.006299745131203e-09, -1.639830440177672e-09,  3.574440446800655e-10, -5.291128458116415e-11,  5.926856829363330e-12,
 -5.341075551014788e-13,  4.027629725071179e-14, -2.612067694760321e-15,  1.486579076311604e-16, -7.539955920478240e-18,  3.450075100905606e-19, -1.436399923733036e-20,
  2.474218175307516e-09, -1.034291040696888e-09,  2.307582743256530e-10, -3.496753543392172e-11,  4.008440665559086e-12, -3.695037523128988e-13,  2.848796497359035e-14,
 -1.887963773537955e-15,  1.097411966694806e-16, -5.681993163019902e-18,  2.652727415229220e-19, -1.126253265002145e-20,  1.552467218236820e-09, -6.604924612711722e-10,
  1.502706556530990e-10, -2.322432438065829e-11,  2.714635439871408e-12, -2.550669658037990e-13,  2.003627756504065e-14, -1.352332393353658e-15,  8.002145965339801e-17,
 -4.215984174226482e-18,  2.002027184376511e-19, -8.641601520130432e-21,  9.777399618845981e-10, -4.219136095213832e-10,  9.752291608001032e-11, -1.531512112306713e-11,
  1.818679441169604e-12, -1.735566642483386e-13,  1.384216374756786e-14, -9.482465640973106e-16,  5.693047196266055e-17, -3.042204429471346e-18,  1.464749410067470e-19,
 -6.408121876141860e-21,  6.019985265987629e-10, -2.625931618890809e-10,  6.143657768349326e-11, -9.766986706963495e-12,  1.173979509458173e-12, -1.133748109924716e-13,
  9.148346675126859e-15, -6.338847902365617e-16,  3.848309078591865e-17, -2.078911014191842e-18,  1.011628224966833e-19, -4.471727538168863e-21,  3.390917434530171e-10,
 -1.490188038240257e-10,  3.515827771515168e-11, -5.637012498973965e-12,  6.832822367126768e-13, -6.653404958768371e-14,  5.412327037741310e-15, -3.779967888480254e-16,
  2.312625424382710e-17, -1.258781345762734e-18,  6.170733948369483e-20, -2.747307997101663e-21,  1.360597140538812e-10, -6.004109202598195e-11,  1.423181586160380e-11,
 -2.292626261403306e-12,  2.792005482895342e-13, -2.731222646018419e-14,  2.231790736153977e-15, -1.565564086294780e-16,  9.619614438637905e-18, -5.258098721462906e-19,
  2.588202593726403e-20, -1.156922648663986e-21,  6.648307869278240e-02, -1.841071053800196e-04,  5.310962926979597e-07, -1.583177686692665e-09,  4.833011887441261e-12,
 -1.498840466289764e-14,  4.691715954475100e-17, -1.475611234829490e-19,  4.648096275696123e-22, -1.463531815384271e-24,  4.600133840910028e-27, -1.442477322592667e-29,
  6.368037151805514e-02, -2.321948187130739e-04,  1.001915577348506e-06, -4.448735430598982e-09,  1.943537684762313e-11, -8.288916699781143e-14,  3.456457725829660e-16,
 -1.413616510131036e-18,  5.685747862195444e-21, -2.253950907826669e-23,  8.821340179712820e-26, -3.412989345145689e-28,  5.843101410556020e-02, -3.155450420209890e-04,
  1.956534461380610e-06, -1.146113907922363e-08,  6.331741968011820e-11, -3.342838507905456e-13,  1.702539468291674e-15, -8.417555917591000e-18,  4.057869437392560e-20,
 -1.913673145044492e-22,  8.851430856447978e-25, -4.023681382458479e-27,  5.137155881408945e-02, -4.125812154042795e-04,  3.378312178471809e-06, -2.468753435655689e-08,
  1.664694949108566e-10, -1.057620870355945e-12,  6.409239985242150e-15, -3.735310030943853e-17,  2.105987605825236e-19, -1.153790192094074e-21,  6.163719146323671e-24,
 -3.219518134444519e-26,  4.329038938462905e-02, -4.995303331438054e-04,  5.166468527085851e-06, -4.604751098030837e-08,  3.720092982981792e-10, -2.793690268404845e-12,
  1.980023844141258e-14, -1.338079899702465e-16,  8.685771320104445e-19, -5.445545704567136e-21,  3.311549538089788e-23, -1.959894933186960e-25,  3.498229970438121e-02,
 -5.570200597571652e-04,  7.110413309450707e-06, -7.616106926066540e-08,  7.268978003862640e-10, -6.367380888167070e-12,  5.212608565361063e-14, -4.036843052565925e-16,
  2.983267860707498e-18, -2.117471758174078e-20,  1.450728473447971e-22, -9.631584731989229e-25,  2.712339097286472e-02, -5.745175384195840e-04,  8.917085567175942e-06,
 -1.134072978593299e-07,  1.264405627931529e-09, -1.278622428651867e-11,  1.197439057139033e-13, -1.053098814505093e-15,  8.783958223409056e-18, -7.000282072111717e-20,
  5.360526941909114e-22, -3.961800414275815e-24,  2.019214636499022e-02, -5.515081182273136e-04,  1.028411311315974e-05, -1.536857929023579e-07,  1.983054575940444e-09,
 -2.295531363113429e-11,  2.440076807215326e-13, -2.419051247062262e-15,  2.261505502964016e-17, -2.010105613568123e-19,  1.709404631862146e-21, -1.397694755901909e-23,
  1.444518828671788e-02, -4.956647817511751e-04,  1.098594569626882e-05, -1.911446641584693e-07,  2.831709740823790e-09, -3.725337382122110e-11,  4.464918218021739e-13,
 -4.958873078344090e-15,  5.165524385920603e-17, -5.092112102091693e-19,  4.783262797390961e-21, -4.304524210668205e-23,  9.939917144972815e-03, -4.192431377055945e-04,
  1.093473988748626e-05, -2.196932693089137e-07,  3.710479569439853e-09, -5.512910247684145e-11,  7.407108960559633e-13, -9.166594545472473e-15,  1.058554350508286e-16,
 -1.151759452221376e-18,  1.189545398790397e-20, -1.172961598226283e-22,  6.586236281858549e-03, -3.352265106323158e-04,  1.019299133277932e-05, -2.347165292587867e-07,
  4.490845839819971e-09, -7.493178131213589e-11,  1.122849299702125e-12, -1.540982844231133e-14,  1.963939488197609e-16, -2.348515087834189e-18,  2.656072656216968e-20,
 -2.858566253775976e-22,  4.207508334047564e-03, -2.544019186841722e-04,  8.939095907503175e-06, -2.343035273312899e-07,  5.049077169800805e-09, -9.412581643704672e-11,
  1.565771076365337e-12, -2.372738049247605e-14,  3.323923315641975e-16, -4.351840337665482e-18,  5.369881538744057e-20, -6.285804632616965e-22,  2.595067001633239e-03,
 -1.838884907715396e-04,  7.406009732595354e-06, -2.195516340590076e-07,  5.300071705068736e-09, -1.098703202016693e-10,  2.020237968979422e-12, -3.367074518650660e-14,
  5.165597270236872e-16, -7.378783203408624e-18,  9.901043987802702e-20, -1.256565955443872e-21,  1.547669488538547e-03, -1.270180242701958e-04,  5.818970504743920e-06,
 -1.939423393448332e-07,  5.218492751029281e-09, -1.197638999700861e-10,  2.424473399776369e-12, -4.427940569338924e-14,  7.413944132652046e-16, -1.151741372595914e-17,
  1.675427124550472e-19, -2.298613302686249e-21,  8.940343622817019e-04, -8.410127879616839e-05,  4.351727755657765e-06, -1.621544051970431e-07,  4.840296434089810e-09,
 -1.224693572660152e-10,  2.719305374644056e-12, -5.423491867496824e-14,  9.878979254517104e-16, -1.663979139682722e-17,  2.616673186307989e-19, -3.870244613102402e-21,
  5.011753819479571e-04, -5.353960235228093e-05,  3.108518724690947e-06, -1.288156083018211e-07,  4.246537473011802e-09, -1.179914327324391e-10,  2.863343122496144e-12,
 -6.216003621283523e-14,  1.228031126245233e-15, -2.236323693398885e-17,  3.791336442887348e-19, -6.029879705186208e-21,  2.731954506387254e-04, -3.286829004918116e-05,
  2.128180561869863e-06, -9.758968194138594e-08,  3.537856675634477e-09, -1.075422254818332e-10,  2.842601784954367e-12, -6.695968098089851e-14,  1.430587570832380e-15,
 -2.808950988451709e-17,  5.120782942285711e-19, -8.735960163579179e-21,  1.451349300974257e-04, -1.951678781979578e-05,  1.401193927548313e-06, -7.076482331492913e-08,
  2.809646333294484e-09, -9.309843708434590e-11,  2.671598389206921e-12, -6.808017497321517e-14,  1.568587186081559e-15, -3.312081605324664e-17,  6.476607182961515e-19,
 -1.182360873073867e-20,  7.532367746920855e-05, -1.124320821757776e-05,  8.902160554905304e-07, -4.929234115065081e-08,  2.135059588339194e-09, -7.684866025946839e-11,
  2.386602844504920e-12, -6.560154879668522e-14,  1.625581336806146e-15, -3.681755517506443e-17,  7.703829109575294e-19, -1.501541000524746e-20,  3.828949486960528e-05,
 -6.303446956708199e-06,  5.476297013007495e-07, -3.310262770468217e-08,  1.558289740080039e-09, -6.072107270050306e-11,  2.034502841922376e-12, -6.015057471364028e-14,
  1.598775780650675e-15, -3.874387857927854e-17,  8.654323249367889e-19, -1.796852775025686e-20,  1.911725254495445e-05, -3.450405419474640e-06,  3.273292866568885e-07,
 -2.151059189845028e-08,  1.096486784384334e-09, -4.610270141998317e-11,  1.661532797234926e-12, -5.268949390480578e-14,  1.498272030342968e-15, -3.875318653952322e-17,
  9.219419715364818e-19, -2.034538443883521e-20,  9.402847206874182e-06, -1.850179838163657e-06,  1.907803775880260e-07, -1.357553135953149e-08,  7.466652632507451e-10,
 -3.376582409858700e-11,  1.305069953490609e-12, -4.426746188429988e-14,  1.343222862955251e-15, -3.699198296027979e-17,  9.351162971333429e-19, -2.188525345362094e-20,
  4.570366136127419e-06, -9.752372605395795e-07,  1.088218683110182e-07, -8.352400592241275e-09,  4.939532052179361e-10, -2.394887379077622e-11,  9.897843214066199e-13,
 -3.581284643538148e-14,  1.156599566858230e-15, -3.383221212170400e-17,  9.066667195314516e-19, -2.245424772509911e-20,  2.202651013437265e-06, -5.071238556556801e-07,
  6.097550650669807e-08, -5.029004279679477e-09,  3.186955830313160e-10, -1.651424517895140e-11,  7.276912194757149e-13, -2.800968811399340e-14,  9.603229944296430e-16,
 -2.976427840649694e-17,  8.436560607648233e-19, -2.206060280020330e-20,  1.056230864306060e-06, -2.611153418472759e-07,  3.369104880345821e-08, -2.974856658664167e-09,
  2.013322540736528e-10, -1.111538939018752e-11,  5.206943291482830e-13, -2.126280077172491e-14,  7.719219538461199e-16, -2.528817243609531e-17,  7.563533992912789e-19,
 -2.083550075474712e-20,  5.057868045536280e-07, -1.336348412701760e-07,  1.842861975973048e-08, -1.735754627218435e-09,  1.250360701225948e-10, -7.332030420300805e-12,
  3.640713141804617e-13, -1.572922009206221e-14,  6.030771042905196e-16, -2.083079909428545e-17,  6.558750028085682e-19, -1.899060584988613e-20,  2.427720494778404e-07,
 -6.824466354718761e-08,  1.001885549481033e-08, -1.002985304053247e-09,  7.664676661869812e-11, -4.758909537157619e-12,  2.497469864766719e-13, -1.138410436725850e-14,
  4.597601431940686e-16, -1.670165832372388e-17,  5.522488948469356e-19, -1.676808101727788e-20,  1.172502975542125e-07, -3.491380581282016e-08,  5.435441098817857e-09,
 -5.762883707697137e-10,  4.656335166294147e-11, -3.051563123394231e-12,  1.687562303493591e-13, -8.093096900144677e-15,  3.433594197676302e-16, -1.308451236677416e-17,
  4.532343626820816e-19, -1.439697481017800e-20,  5.719904103537810e-08, -1.796509546004011e-08,  2.954515237937099e-09, -3.305764519804732e-10,  2.814679413877374e-11,
 -1.940883002275539e-12,  1.127661014032402e-13, -5.673456832510008e-15,  2.521713330461334e-16, -1.005413912684115e-17,  3.639184526840997e-19, -1.206410002885795e-20,
  2.829343093116341e-08, -9.334077345005452e-09,  1.615439594588757e-09, -1.900674288691963e-10,  1.699631124384186e-11, -1.229217477670473e-12,  7.480417960230207e-14,
 -3.936797664364633e-15,  1.828059101073176e-16, -7.605226408017988e-18,  2.869061287669792e-19, -9.901156535685489e-21,  1.424358241308243e-08, -4.915595952879724e-09,
  8.918849239424443e-10, -1.099515910646698e-10,  1.029108590950167e-11, -7.780901908171573e-13,  4.944208619219351e-14, -2.713741408951421e-15,  1.312715783402572e-16,
 -5.682853747664915e-18,  2.228461894797073e-19, -7.985222952432626e-21,  7.323360393792116e-09, -2.633297859883355e-09,  4.989986189705281e-10, -6.422465609835526e-11,
  6.270161727246351e-12, -4.939804017908916e-13,  3.267162822585996e-14, -1.864546829587600e-15,  9.368166954996697e-17, -4.208158162279203e-18,  1.710606792858505e-19,
 -6.347663004062607e-21,  3.857663074165444e-09, -1.439595982666247e-09,  2.838306066265334e-10, -3.800071177263664e-11,  3.856287574000053e-12, -3.155034819412657e-13,
  2.164982721274974e-14, -1.280655176536963e-15,  6.663199839615170e-17, -3.096668822983276e-18,  1.301202505970843e-19, -4.986555926669092e-21,  2.087298874354545e-09,
 -8.052900266103420e-10,  1.645656165797152e-10, -2.283525035997159e-11,  2.400183382839220e-12, -2.032341436371986e-13,  1.442116015556370e-14, -8.813824786077785e-16,
  4.734125197583138e-17, -2.269462804654398e-18,  9.828815286431842e-20, -3.879027674072321e-21,  1.162113986776835e-09, -4.617648875762550e-10,  9.743596190505343e-11,
 -1.396067385766627e-11,  1.514403972471852e-12, -1.322502473823349e-13,  9.671317907058122e-15, -6.087147189939763e-16,  3.364605172855848e-17, -1.658630670020646e-18,
  7.381677921924849e-20, -2.991437790025637e-21,  6.660589782713312e-10, -2.715621040306868e-10,  5.894076564880057e-11, -8.687421856910155e-12,  9.690224224565529e-13,
 -8.696555605638336e-14,  6.531651734206719e-15, -4.219483618391432e-16,  2.392270710812655e-17, -1.208881195087620e-18,  5.511626186274263e-20, -2.286701416214913e-21,
  3.923574292766448e-10, -1.635411638728776e-10,  3.637066354185399e-11, -5.493680145855795e-12,  6.277695642496799e-13, -5.769000930970758e-14,  4.434386082704226e-15,
 -2.930151998303460e-16,  1.698339533737131e-17, -8.768941630541569e-19,  4.082848327958527e-20, -1.728882546734026e-21,  2.363480477383832e-10, -1.003489171409694e-10,
  2.277908470774171e-11, -3.512501971028616e-12,  4.096479180266434e-13, -3.840607515928670e-14,  3.010455242504043e-15, -2.027643562334514e-16,  1.197377870874874e-17,
 -6.295982884342889e-19,  2.983987807311548e-20, -1.285606848294640e-21,  1.439081068321719e-10, -6.201657719301968e-11,  1.431349780725718e-11, -2.244445787772708e-12,
  2.661355980014156e-13, -2.536058001307892e-14,  2.019795860164016e-15, -1.381737111036340e-16,  8.284468614148372e-18, -4.421187020019697e-19,  2.125979323597429e-20,
 -9.289395491752635e-22,  8.630527181160445e-11, -3.761704860960976e-11,  8.793180275783422e-12, -1.396667947981192e-12,  1.677301237837718e-13, -1.618423608965230e-14,
  1.304822467942301e-15, -9.033598474558188e-17,  5.479873762495153e-18, -2.957979119526509e-19,  1.438291877472713e-20, -6.352978123993097e-22,  4.772511976379078e-11,
 -2.096503049146162e-11,  4.944063499927298e-12, -7.923273503630720e-13,  9.599676911467043e-14, -9.343387917264668e-15,  7.597173633521664e-16, -5.303561490818934e-17,
  3.243397738997186e-18, -1.764674268399076e-19,  8.647175865675154e-21, -3.848330365403058e-22,  1.895256475359627e-11, -8.361878228520709e-12,  1.981622542069951e-12,
 -3.191517639156822e-13,  3.885829921377612e-14, -3.800397809586685e-15,  3.104781584361633e-16, -2.177486085912483e-17,  1.337674786004548e-18, -7.310235174468696e-20,
  3.597592903040475e-21, -1.607795690407527e-22,  6.575502931677345e-02, -1.799330353799104e-04,  5.125524316629435e-07, -1.508187836418101e-09,  4.544177728149043e-12,
 -1.391034006299974e-14,  4.298600835005979e-17, -1.334959010572264e-19,  4.152872327785024e-22, -1.291608324104313e-24,  4.010595259661177e-27, -1.242555239306996e-29,
  6.276729208923153e-02, -2.243878701010185e-04,  9.503432656151728e-07, -4.150594042774799e-09,  1.785744557089785e-11, -7.504881005302972e-14,  3.084944319264694e-16,
 -1.244002633601340e-18,  4.934381591103918e-21, -1.929373768426942e-23,  7.448971821163251e-26, -2.843441746694950e-28,  5.719929110396948e-02, -3.004261727425344e-04,
  1.824865616128695e-06, -1.049940324343641e-08,  5.702199330478904e-11, -2.961105994187910e-13,  1.484038262631596e-15, -7.222763620624120e-18,  3.428631863660461e-20,
 -1.592621137528836e-22,  7.257404254968694e-25, -3.250902507657931e-27,  4.977347256584170e-02, -3.866959949191160e-04,  3.097370940872466e-06, -2.218522650444066e-08,
  1.467743570559120e-10, -9.156249718620559e-13,  5.451780969872210e-15, -3.123357679160366e-17,  1.731789077504966e-19, -9.333907837044886e-22,  4.906928709460842e-24,
 -2.522929954414685e-26,  4.137156939452895e-02, -4.603117636892224e-04,  4.647847739113814e-06, -4.051775271872774e-08,  3.205995689245210e-10, -2.360475656694529e-12,
  1.641499546644049e-14, -1.089104616612491e-16,  6.944396545576462e-19, -4.278522769007925e-21,  2.557835184844170e-23, -1.488697356019235e-25,  3.286246473949265e-02,
 -5.036040235327914e-04,  6.262270324004439e-06, -6.548517061896786e-08,  6.111977890328999e-10, -5.241871536647595e-12,  4.205236083506528e-14, -3.193743299138125e-16,
  2.315966156062464e-18, -1.613835277736288e-20,  1.085974696799170e-22, -7.084210505245845e-25,  2.495983636165586e-02, -5.082989539912700e-04,  7.669621743534157e-06,
 -9.507594012943682e-08,  1.035186037627877e-09, -1.023663759804006e-11,  9.384113807792068e-14, -8.085138625818049e-16,  6.611198134785443e-18, -5.168043469880526e-20,
  3.883782002241742e-22, -2.818173726867708e-24,  1.813969754356214e-02, -4.761056740229677e-04,  8.616077458447693e-06, -1.253332231989520e-07,  1.577419621874620e-09,
 -1.783639723218144e-11,  1.854054718783780e-13, -1.799070662361863e-15,  1.647434673480993e-17, -1.435199641398560e-19,  1.196907299182965e-21, -9.602011586301724e-24,
  1.262479451174980e-02, -4.162349989043279e-04,  8.941231267072371e-06, -1.512596754216900e-07,  2.183451561140557e-09, -2.803267051410396e-11,  3.282723396531212e-13,
 -3.565695923264386e-15,  3.635512129899701e-17, -3.510246316631300e-19,  3.231560730661827e-21, -2.851626366943426e-23,  8.422525497324997e-03, -3.413791729146682e-04,
  8.621147376695206e-06, -1.682612053217881e-07,  2.766705146739858e-09, -4.008450607462310e-11,  5.258367161580289e-13, -6.360029920671526e-15,  7.184296317145350e-17,
 -7.651930916289469e-19,  7.741165600059384e-21, -7.481226442881024e-23,  5.392165118873569e-03, -2.638325265415293e-04,  7.762429991697277e-06, -1.735227433399760e-07,
  3.230108119601299e-09, -5.252229626610279e-11,  7.679791715839770e-13, -1.029523770294263e-14,  1.282818983752241e-16, -1.500941153282455e-18,  1.662019898077449e-20,
 -1.752396431074428e-22,  3.316884783252434e-03, -1.928932174236494e-04,  6.556086853576665e-06, -1.667426366114372e-07,  3.494179620491707e-09, -6.344895587743368e-11,
  1.029433144360801e-12, -1.523162324100964e-14,  2.085329084054475e-16, -2.670364692888303e-18,  3.225086204771561e-20, -3.697347018044486e-22,  1.963158087616222e-03,
 -1.338886243558524e-04,  5.215414779263953e-06, -1.499851826992031e-07,  3.519860611311875e-09, -7.105067863226882e-11,  1.273822765990634e-12, -2.072319449005647e-14,
  3.106210548296577e-16, -4.338675338330957e-18,  5.696780663047128e-20, -7.079343300795982e-22,  1.119748733003905e-03, -8.851947616915537e-05,  3.922788990972209e-06,
 -1.268249621467884e-07,  3.317045992128412e-09, -7.411487822188210e-11,  1.462651344164119e-12, -2.607049310356332e-14,  4.264161538655266e-16, -6.476453155986842e-18,
  9.217770330690356e-20, -1.238152869812304e-21,  6.165725807242325e-04, -5.591974799989122e-05,  2.799929721680191e-06, -1.012172726011388e-07,  2.936889533603654e-09,
 -7.234548163265000e-11,  1.565927756695821e-12, -3.047889099565087e-14,  5.423147390454811e-16, -8.930368971215068e-18,  1.373967870511110e-19, -1.989598309018649e-21,
  3.283848276329974e-04, -3.385727597049601e-05,  1.903175955909141e-06, -7.653630386128846e-08,  2.453068414888565e-09, -6.636722412275793e-11,  1.570189685930446e-12,
 -3.326859094162195e-14,  6.420752403189754e-16, -1.143211068040714e-17,  1.896370106788446e-19, -2.953076903326122e-21,  1.695262690952697e-04, -1.970705942475528e-05,
  1.236226617074785e-06, -5.503907907488255e-08,  1.940602418101297e-09, -5.745490411405677e-11,  1.480963597751729e-12, -3.405487718102546e-14,  7.109185161093771e-16,
 -1.365043804801791e-17,  2.435327933134818e-19, -4.068612760538175e-21,  8.502611947432312e-05, -1.106144739912050e-05,  7.700291165817628e-07, -3.778107987938402e-08,
  1.459672106018437e-09, -4.712833532230178e-11,  1.319330195591396e-12, -3.283130096214112e-14,  7.393548244150623e-16, -1.527118647505640e-17,  2.923235063241071e-19,
 -5.227620785744657e-21,  4.153608510576364e-05, -6.006086421918552e-06,  4.615522783963823e-07, -2.484764076666322e-08,  1.047951098728865e-09, -3.677446459300184e-11,
  1.114682390824213e-12, -2.993442364627855e-14,  7.253210397160869e-16, -1.607616897738908e-17,  3.294202252992879e-19, -6.291954567298004e-21,  1.981736970104814e-05,
 -3.165011836315817e-06,  2.671657570343808e-07, -1.571542599529354e-08,  7.208971839888431e-10, -2.740581014299214e-11,  8.967982104442154e-13, -2.591877449698201e-14,
  6.740069454725587e-16, -1.599232882751377e-17,  3.500051497567848e-19, -7.124734287952613e-21,  9.261862945090653e-06, -1.624179733244234e-06,  1.498879616090504e-07,
 -9.595044569396056e-09,  4.770342713507005e-10, -1.958406706445811e-11,  6.898308644437450e-13, -2.139923521151597e-14,  5.957338839637699e-16, -1.509637203729242e-17,
  3.520969510082472e-19, -7.622401457575278e-21,  4.253669159824012e-06, -8.145221225581751e-07,  8.181001435802684e-08, -5.677199600141077e-09,  3.048563186522255e-10,
 -1.347346245099742e-11,  5.094080675989069e-13, -1.691636452418056e-14,  5.029087156267192e-16, -1.357901619206528e-17,  3.367621648286066e-19, -7.736951773971871e-21,
  1.926280922125424e-06, -4.006696450342513e-07,  4.360960215610907e-08, -3.268272456135841e-09,  1.889171501034504e-10, -8.960909844923619e-12,  3.626241156601271e-13,
 -1.285701413697488e-14,  4.071719839688813e-16, -1.168700339946909e-17,  3.075117274163282e-19, -7.481796138550119e-21,  8.632531915815462e-07, -1.940715335700309e-07,
  2.279472772733989e-08, -1.838139606747783e-09,  1.139934723311362e-10, -5.785429846010711e-12,  2.498817631534547e-13, -9.434468564931708e-15,  3.174941996279838e-16,
 -9.664729643941105e-18,  2.692053665604798e-19, -6.921477952405179e-21,  3.843102586337655e-07, -9.293477597351054e-08,  1.173176883635976e-08, -1.014248204052217e-09,
  6.726131227157261e-11, -3.641493970644515e-12,  1.673972269156680e-13, -6.712470020809012e-15,  2.394405819275566e-16, -7.711737424072985e-18,  2.268828855526137e-19,
 -6.151036957858104e-21,  1.706463708874487e-07, -4.418280618527644e-08,  5.970718107467097e-09, -5.514334270318691e-10,  3.897738366331931e-11, -2.244234468019775e-12,
  1.094901380363760e-13, -4.650513812108941e-15,  1.753944321705757e-16, -5.962477534481119e-18,  1.848563814747740e-19, -5.272966086645577e-21,  7.589313871855228e-08,
 -2.094427138958424e-08,  3.018083513136490e-09, -2.967186326005431e-10,  2.228140371315642e-11, -1.360237880331205e-12,  7.022882642029381e-14, -3.151063852789525e-15,
  1.253298893712981e-16, -4.485975188517163e-18,  1.462187540277145e-19, -4.378415774494141e-21,  3.395279116034351e-08, -9.943530235712352e-09,  1.522033535513966e-09,
 -1.587269481143937e-10,  1.262119094563312e-11, -8.144264745247056e-13,  4.436941855598320e-14, -2.097218572867845e-15,  8.773697079087224e-17, -3.298260435491789e-18,
  1.127516607652985e-19, -3.536080495248420e-21,  1.534725198158580e-08, -4.749364537024534e-09,  7.692612229458847e-10, -8.479624287988957e-11,  7.116068942598456e-12,
 -4.838546151082486e-13,  2.773271730836472e-14, -1.377039433897837e-15,  6.043060051791760e-17, -2.379785346174005e-18,  8.511173841868305e-20, -2.788907083948742e-21,
  7.040323298373534e-09, -2.292504125328243e-09,  3.914222395093061e-10, -4.544430000045052e-11,  4.011449573073571e-12, -2.864967939241741e-13,  1.722382442731675e-14,
 -8.958237098544320e-16,  4.112461461265079e-17, -1.692019548093757e-18,  6.314766882750924e-20, -2.156611358069884e-21,  3.291997556302101e-09, -1.123294108122105e-09,
  2.014037520414231e-10, -2.453993363410713e-11,  2.270784423104820e-12, -1.697972369645466e-13,  1.067400711195648e-14, -5.797888271917302e-16,  2.776377246789395e-17,
 -1.190175199875213e-18,  4.622863266906434e-20, -1.641275275558808e-21,  1.575629804002217e-09, -5.610945021111393e-10,  1.052409981768086e-10, -1.340864096947650e-11,
  1.296175038006934e-12, -1.011382854249614e-13,  6.627030548473645e-15, -3.747859165325042e-16,  1.866561237504724e-17, -8.313215273699113e-19,  3.351381614295106e-20,
 -1.233657261518299e-21,  7.749233530186498e-10, -2.868434718895317e-10,  5.606548885516461e-11, -7.441989862203113e-12,  7.488766763396509e-13, -6.076951283191254e-14,
  4.136920225628383e-15, -2.428262391343950e-16,  1.253961066729724e-17, -5.785325190700899e-19,  2.413794792580305e-20, -9.186971679989391e-22,  3.929378016839314e-10,
 -1.505893770713878e-10,  3.055352512113666e-11, -4.209427062483819e-12,  4.393597960622156e-13, -3.694952270390871e-14,  2.604533236439794e-15, -1.581586195489790e-16,
  8.442023163167005e-18, -4.022402679118962e-19,  1.731785612488377e-20, -6.795544822502322e-22,  2.059384100800360e-10, -8.139431145919218e-11,  1.707567796375615e-11,
 -2.432514857619689e-12,  2.623789797098674e-13, -2.278674628193723e-14,  1.657425674991684e-15, -1.037741659501515e-16,  5.706897780265578e-18, -2.799420341879753e-19,
  1.239898115644089e-20, -5.001340322415558e-22,  1.116921961946454e-10, -4.535114661264722e-11,  9.798838062412373e-12, -1.437765700461977e-12,  1.596628924908303e-13,
 -1.426710330628947e-14,  1.067035179637890e-15, -6.864860174840288e-17,  3.876576332922353e-18, -1.951349887831152e-19,  8.863216596064603e-21, -3.663788330356627e-22,
  6.263275007781585e-11, -2.602661090403192e-11,  5.768681754873036e-12, -8.683983742240739e-13,  9.890314305068817e-14, -9.059357034867741e-15,  6.941492320767175e-16,
 -4.572655006980816e-17,  2.642395819720555e-18, -1.360351200172649e-19,  6.315855398934080e-21, -2.667081282381954e-22,  3.615470228627708e-11, -1.531762442271981e-11,
  3.468794846995614e-12, -5.336013970529075e-13,  6.208472589482491e-14, -5.807240732460496e-15,  4.541742556160264e-16, -3.052302616682972e-17,  1.798614028800897e-18,
 -9.437691807644266e-20,  4.463946343667898e-21, -1.919444876396588e-22,  2.124915701789506e-11, -9.144386273986468e-12,  2.107231151139856e-12, -3.299058148868629e-13,
  3.905778111733690e-14, -3.716220194867614e-15,  2.955309362384686e-16, -2.018785517099175e-17,  1.208689625800111e-18, -6.441548501363431e-20,  3.093337009938690e-21,
 -1.349861558638244e-22,  1.239701513520749e-11, -5.398904263287402e-12,  1.260852441574496e-12, -2.000804997167618e-13,  2.400605231293332e-14, -2.314235747874631e-15,
  1.864151509432645e-16, -1.289478145454306e-17,  7.815491012289169e-19, -4.215240187600012e-20,  2.047974718794468e-21, -9.038885461098291e-23,  6.723779386354162e-12,
 -2.952419176033010e-12,  6.959196144066010e-13, -1.114729107567756e-13,  1.349934718276414e-14, -1.313273911754132e-15,  1.067337306401259e-16, -7.447664088009795e-18,
  4.552602268544968e-19, -2.475912305049955e-20,  1.212719382169501e-21, -5.394836256440926e-23,  2.641278452824070e-12, -1.165101800399691e-12,  2.760469625055897e-13,
 -4.444872031446017e-14,  5.410606882476393e-15, -5.290447293971733e-16,  4.321124652852095e-17, -3.029876583315836e-18,  1.860909948147832e-19, -1.016747015804800e-20,
  5.002669237257954e-22, -2.235273019997658e-23,  6.504338510942395e-02, -1.759037937121540e-04,  4.948814160276490e-07, -1.437651837826522e-09,  4.275992382706861e-12,
 -1.292207068971532e-14,  3.942739632153729e-17, -1.209207520211866e-19,  3.715499817545275e-22, -1.141597902455276e-24,  3.502325514752025e-27, -1.072234004188533e-29,
  6.188463736601341e-02, -2.169796067831022e-04,  9.022021911387550e-07, -3.876491976425602e-09,  1.642777619879553e-11, -6.804570766459015e-14,  2.757725059408539e-16,
 -1.096664148195324e-18,  4.290557312044972e-21, -1.654991198773156e-23,  6.304278623971803e-26, -2.374650539787075e-28,  5.602600762668263e-02, -2.863161470348972e-04,
  1.704157541493509e-06, -9.632560456683744e-09,  5.144018824130213e-11, -2.628016544593889e-13,  1.296337607293520e-15, -6.212001807491320e-18,  2.904270536304962e-20,
 -1.329017760563797e-22,  5.967614860187586e-25, -2.634584354890491e-27,  4.827461502687987e-02, -3.629433426335071e-04,  2.844656490769615e-06, -1.997651412672426e-08,
  1.297025566778281e-10, -7.946802412630821e-13,  4.650031468977760e-15, -2.619367179076763e-17,  1.428578279053764e-19, -7.576299583823732e-22,  3.920287946273744e-24,
 -1.984461654992572e-26,  3.960172710334820e-02, -4.249900846494051e-04,  4.190920960046676e-06, -3.574542397281486e-08,  2.770950442510308e-10, -2.000734152323999e-12,
  1.365479313034347e-14, -8.896748847739015e-17,  5.573533061667882e-19, -3.375267761478737e-21,  1.984104333599285e-23, -1.135838162621821e-25,  3.094349272389800e-02,
 -4.564905292149820e-04,  5.531833298983950e-06, -5.649276553007815e-08,  5.157696911651883e-10, -4.332058412708258e-12,  3.406573354305002e-14, -2.537781034331801e-16,
  1.806205610120407e-18, -1.235920708734034e-20,  8.170228740615176e-23, -5.237860142492326e-25,  2.304250667622638e-02, -4.512388557741797e-04,  6.621708484039755e-06,
 -8.003574466194800e-08,  8.512580763445646e-10, -8.233822462701245e-12,  7.390492181703086e-14, -6.239519411389436e-16,  5.002825393560038e-18, -3.836873698102721e-20,
  2.830312858456004e-22, -2.016801245845554e-24,  1.636417862674933e-02, -4.127896123817528e-04,  7.252477849710029e-06, -1.027226775192905e-07,  1.261397452539073e-09,
 -1.393604546396351e-11,  1.416966537259783e-13, -1.346086447698682e-15,  1.207643574149526e-17, -1.031382309482655e-19,  8.436842011328818e-22, -6.642048007349197e-24,
  1.109220405769151e-02, -3.514117023165657e-04,  7.318524204781882e-06, -1.204133321384854e-07,  1.694129432330743e-09, -2.123158981799075e-11,  2.429847981040752e-13,
 -2.581838215977168e-15,  2.577120154207074e-17, -2.437727653436137e-19,  2.199856872675103e-21, -1.903866424864201e-23,  7.183146664061674e-03, -2.797907442069343e-04,
  6.843227109950665e-06, -1.297779327275251e-07,  2.078033176554752e-09, -2.936507679142587e-11,  3.761917741587462e-13, -4.447940614286213e-15,  4.915775548506380e-17,
 -5.126264248424227e-19,  5.080805507496676e-21, -4.813259758494661e-23,  4.448988911380473e-03, -2.092573712413298e-04,  5.958577660008786e-06, -1.293333982948979e-07,
  2.342828640690354e-09, -3.713181630347058e-11,  5.298939556992483e-13, -6.940159330724901e-15,  8.456221337062145e-17, -9.682405768168194e-19,  1.049914668128581e-20,
 -1.084693147687754e-22,  2.638761645672521e-03, -1.475861418608482e-04,  4.852722608090202e-06, -1.197777095722140e-07,  2.441269313226335e-09, -4.318698552997328e-11,
  6.835247165749768e-13, -9.876422909124596e-15,  1.321670925191513e-16, -1.655611549409468e-18,  1.957358734108729e-20, -2.198018620372103e-22,  1.500873084351112e-03,
 -9.850530137878817e-05,  3.711492235737796e-06, -1.035532387092391e-07,  2.362809511544829e-09, -4.644870573045831e-11,  8.120651714103845e-13, -1.289711708241187e-14,
  1.888982414780158e-16, -2.580291819491530e-18,  3.315641961162210e-20, -4.034950850451605e-22,  8.199362052076582e-04, -6.242391735026733e-05,  2.675971360717302e-06,
 -8.392628817399391e-08,  2.133796367657990e-09, -4.642141368117540e-11,  8.931774719262684e-13, -1.553854817272922e-14,  2.482968211477660e-16, -3.687320452390404e-18,
  5.135164289022679e-20, -6.753761137200079e-22,  4.309978482004851e-04, -3.767791337822657e-05,  1.825414810504478e-06, -6.401868854725692e-08,  1.805676233948901e-09,
 -4.330610047179765e-11,  9.138178593446885e-13, -1.735863370398210e-14,  3.017237007255429e-16, -4.857712880693108e-18,  7.312504421809383e-20, -1.036753094661293e-21,
  2.184137819260480e-04, -2.172737006540684e-05,  1.182290483948328e-06, -4.613778579850156e-08,  1.437673840633764e-09, -3.787278741209570e-11,  8.735762139326902e-13,
 -1.806466803088043e-14,  3.405955826450036e-16, -5.929247799848993e-18,  9.623662629236353e-20, -1.467344657352101e-21,  1.069387833170526e-04, -1.200750324524351e-05,
  7.296048757845336e-07, -3.153421922066151e-08,  1.081277458841236e-09, -3.117815354378810e-11,  7.836561038854920e-13, -1.759057038724556e-14,  3.587934933104432e-16,
 -6.736818783742404e-18,  1.176175106280612e-19, -1.924259205929787e-21,  5.070789904378922e-05, -6.379509978527723e-06,  4.305018595640028e-07, -2.051670115271958e-08,
  7.712062689652077e-10, -2.425942662369037e-11,  6.624447515421343e-13, -1.609644676000966e-14,  3.542715302792429e-16, -7.157329859115526e-18,  1.341083553445848e-19,
 -2.349117218246998e-21,  2.334724627730954e-05, -3.269010353450553e-06,  2.437427767292880e-07, -1.275463237477091e-08,  5.236724063412702e-10, -1.791296678291550e-11,
  5.298657058183840e-13, -1.389986705161082e-14,  3.292903576229433e-16, -7.141432650232677e-18,  1.432913354679201e-19, -2.681717039122876e-21,  1.046776960190496e-05,
 -1.621069355615120e-06,  1.329052124981081e-07, -7.605446287928878e-09,  3.398756286921015e-10, -1.260282246935749e-11,  4.026832763575379e-13, -1.137469283131261e-14,
  2.893448357076735e-16, -6.720840021463063e-18,  1.440958204671879e-19, -2.875383028752960e-21,  4.584355571163381e-06, -7.806821428790473e-07,  7.005541044642864e-08,
 -4.366963536702883e-09,  2.116888268229719e-10, -8.483206015930977e-12,  2.919753448313364e-13, -8.858088569951639e-15,  2.413714458700123e-16, -5.991279723479594e-18,
  1.369673767410929e-19, -2.908250797296594e-21,  1.967736766212971e-06, -3.664749097188883e-07,  3.583680872354734e-08, -2.424298418460242e-09,  1.270523371802806e-10,
 -5.486019690345671e-12,  2.028352949847150e-13, -6.592552596675132e-15,  1.919730615812620e-16, -5.080788042997554e-18,  1.235891200310957e-19, -2.786691655977250e-21,
  8.307931829662609e-07, -1.683480185662552e-07,  1.786383770396634e-08, -1.306647773435685e-09,  7.379307282800822e-11, -3.423083854487765e-12,  1.355884272839104e-13,
 -4.709254610510531e-15,  1.462016952904835e-16, -4.116529307925086e-18,  1.063193508146304e-19, -2.540598555214794e-21,  3.463719871873198e-07, -7.598942088035044e-08,
  8.714148196490086e-09, -6.867177595574114e-10,  4.165785681570339e-11, -2.069900862286323e-12,  8.759811052098394e-14, -3.242984782979254e-15,  1.070844580416568e-16,
 -3.200495950262319e-18,  8.757950347440988e-20, -2.213366790239501e-21,  1.431908464523712e-07, -3.385011916095405e-08,  4.178369547142113e-09, -3.535062009599115e-10,
  2.296091315187129e-11, -1.218477517812259e-12,  5.494390251669752e-14, -2.162632968648272e-15,  7.577082101513711e-17, -2.398367060371261e-18,  6.938453321029951e-20,
 -1.850707434960246e-21,  5.895440049752008e-08, -1.494861732550984e-08,  1.978458066843901e-09, -1.790757093194287e-10,  1.241415569188313e-11, -7.015215051540939e-13,
  3.361285347511568e-14, -1.403005683951214e-15,  5.203014584916457e-17, -1.740135323102345e-18,  5.310424225021462e-20, -1.491779169498491e-21,  2.428565125157332e-08,
 -6.575558623106140e-09,  9.295350372624293e-10, -8.969842035917885e-11,  6.615522148036213e-12, -3.969089846003526e-13,  2.015143438219370e-14, -8.896257199072012e-16,
  3.483330883770696e-17, -1.228014432234087e-18,  3.944210767612865e-20, -1.164354302547661e-21,  1.005783494688540e-08, -2.895250691012697e-09,  4.354804962012615e-10,
 -4.464625784724066e-11,  3.491901845719223e-12, -2.217587538268811e-13,  1.189628091252977e-14, -5.539743626707816e-16,  2.284310411422631e-17, -8.467993006524982e-19,
  2.855797326533422e-20, -8.839339465434252e-22,  4.208563759668708e-09, -1.282475414370663e-09,  2.044694898506022e-10, -2.219326908468137e-11,  1.834747527499270e-12,
 -1.229564076060002e-13,  6.949163695292900e-15, -3.403968648162186e-16,  1.474283234409653e-17, -5.732222668885144e-19,  2.024899355553112e-20, -6.556079314654203e-22,
  1.788251285765995e-09, -5.744330222074802e-10,  9.670770293650928e-11, -1.107371606920513e-11,  9.644557868978976e-13, -6.799030161259209e-14,  4.036270252783569e-15,
 -2.073804726898138e-16,  9.408182281994518e-18, -3.826698171698968e-19,  1.412342858553438e-20, -4.771653590548480e-22,  7.754940254996097e-10, -2.614989693309631e-10,
  4.630953227958891e-11, -5.574209926668507e-12,  5.097201606974827e-13, -3.767769116980741e-14,  2.342237870111350e-15, -1.258552429656048e-16,  5.963765074767418e-18,
 -2.530639057102206e-19,  9.732812722976715e-21, -3.422548404711023e-22,  3.449230747074648e-10, -1.215902239748677e-10,  2.256317577743897e-11, -2.844510173468053e-12,
  2.721486263501137e-13, -2.102346896946173e-14,  1.364214106493657e-15, -7.642715783871338e-17,  3.771635279095642e-18, -1.664933958374059e-19,  6.654343944443714e-21,
 -2.429096740232572e-22,  1.580803630790651e-10, -5.801767739203775e-11,  1.123743222187014e-11, -1.478260020091971e-12,  1.474522123780058e-13, -1.186340911273188e-14,
  8.009219644180052e-16, -4.663407591366732e-17,  2.389401494544296e-18, -1.094030280633702e-19,  4.530998626685395e-21, -1.712208156065165e-22,  7.496301745618974e-11,
 -2.852804433690085e-11,  5.744687902503615e-12, -7.855504097649690e-13,  8.139282118050240e-14, -6.796294676456782e-15,  4.757483389018778e-16, -2.869527592621054e-17,
  1.521663246128851e-18, -7.204333826432632e-20,  3.082603912961493e-21, -1.202390056197312e-22,  3.690430329545203e-11, -1.450425618889625e-11,  3.024381772049401e-12,
 -4.282316603440345e-13,  4.591647915276659e-14, -3.964630277768448e-15,  2.867500695047373e-16, -1.785567840904450e-17,  9.767248409073458e-19, -4.766404792806769e-20,
  2.100501930230944e-21, -8.431490978713755e-23,  1.889952696414266e-11, -7.640604112238301e-12,  1.643047848483239e-12, -2.399386093129871e-13,  2.652099816347649e-14,
 -2.359088269965348e-15,  1.756555034179296e-16, -1.125231982880767e-17,  6.327587125681790e-19, -3.172161147063153e-20,  1.435129848618641e-21, -5.909654396350179e-23,
  1.006794322853039e-11, -4.170171083856580e-12,  9.210182363037882e-13, -1.381536272529719e-13,  1.567945674741731e-14, -1.431301218016689e-15,  1.093043313967369e-16,
 -7.176994609183019e-18,  4.134283084901139e-19, -2.121872394708548e-20,  9.822070158047404e-22, -4.135697373930004e-23,  5.558649971449339e-12, -2.349683370839997e-12,
  5.307659434869941e-13, -8.144091810033113e-14,  9.452108655750940e-15, -8.819742522113134e-16,  6.881403251408536e-17, -4.613998260331286e-18,  2.712751275102600e-19,
 -1.420320371607006e-20,  6.703687429537180e-22, -2.876551822435961e-23,  3.148233057205565e-12, -1.352806975105400e-12,  3.112257527802335e-13, -4.864411568371649e-14,
  5.749565593768749e-15, -5.461739535909060e-16,  4.336618714129597e-17, -2.957838096226548e-18,  1.768284444817418e-19, -9.410174317832694e-21,  4.512542015922909e-22,
 -1.966471800507983e-23,  1.784345109413480e-12, -7.764060097101605e-13,  1.811437103259608e-13, -2.871675842055192e-14,  3.442137934771077e-15, -3.315127174833881e-16,
  2.667891546006941e-17, -1.843762501447390e-18,  1.116505828277469e-19, -6.016589567565938e-21,  2.920689590320962e-22, -1.288008345789079e-23,  9.482819987753777e-13,
 -4.162067032372725e-13,  9.805562707723438e-14, -1.569864893130989e-14,  1.900146892897621e-15, -1.847629036472474e-16,  1.500895272945396e-17, -1.046796908179016e-18,
  6.395878150818142e-20, -3.476788674320672e-21,  1.702198877806883e-22, -7.569026796222234e-24,  3.682778362863666e-13, -1.624186708884116e-13,  3.847277516902163e-14,
 -6.193358222915241e-15,  7.537191728147027e-16, -7.368068368686353e-17,  6.016682121748698e-18, -4.217797352616656e-19,  2.589930831396772e-20, -1.414748707959170e-21,
  6.959424561336042e-23, -3.108916632219415e-24,  6.434758039219127e-02, -1.720126059153576e-04,  4.780317241288920e-07, -1.371253205159775e-09,  4.026746081595188e-12,
 -1.201513605573552e-14,  3.620207888491997e-17, -1.096625709132676e-19,  3.328645101972279e-22, -1.010495964299384e-24,  3.063355039890161e-27, -9.268592790534140e-30,
  6.103086573533264e-02, -2.099436936575885e-04,  8.572175807631973e-07, -3.624185431123005e-09,  1.513063812023670e-11, -6.178066562909610e-14,  2.469018664223371e-16,
 -9.684320859873070e-19,  3.737742767960421e-21, -1.422524488393394e-23,  5.347214184579178e-26, -1.987812433948869e-28,  5.490729672447543e-02, -2.731316466357330e-04,
  1.593336943563930e-06, -8.849932589193856e-09,  4.648171193024367e-11, -2.336760276436381e-13,  1.134725002781021e-15, -5.354797080178108e-18,  2.466138128433351e-20,
 -1.111966370779648e-22,  4.920839408716675e-25, -2.141478712084501e-27,  4.686688620652638e-02, -3.411108540102780e-04,  2.616884259803028e-06, -1.802259879989453e-08,
  1.148681187493430e-10, -6.913881463991884e-13,  3.976714946982808e-15, -2.202997968987030e-17,  1.182073638159880e-19, -6.169749472600007e-22,  3.142863979243310e-24,
 -1.566606357572819e-26,  3.796620738368164e-02, -3.931060569627256e-04,  3.787311959957325e-06, -3.161502697619512e-08,  2.401656918635319e-10, -1.701003834899658e-12,
  1.139616874564995e-14, -7.293242807920790e-17,  4.490019185977463e-19, -2.673218290752601e-21,  1.545451298272550e-23, -8.703813320833734e-26,  2.920193621322987e-02,
 -4.148135338714188e-04,  4.900712408611490e-06, -4.889146161610517e-08,  4.367608186908818e-10, -3.593608644451472e-12,  2.770648747839158e-14, -2.025101472107830e-16,
  1.414940003319390e-18, -9.509356273289430e-21,  6.176855878939098e-23, -3.892436048421348e-25,  2.133772700906633e-02, -4.018872789596593e-04,  5.737862694048855e-06,
 -6.764228518588418e-08,  7.029920334109743e-10, -6.652864243798859e-12,  5.848250930512229e-14, -4.839393917167844e-16,  3.805618595744095e-18, -2.864163339046012e-20,
  2.074308234906140e-22, -1.451792342756928e-24,  1.482171078635322e-02, -3.593774209094977e-04,  6.132267396970164e-06, -8.459738397264810e-08,  1.013842746602832e-09,
 -1.094715376105994e-11,  1.089016160718137e-13, -1.013066490448860e-15,  8.906500946510364e-18, -7.458608883231484e-20,  5.985757801670402e-22, -4.625375533874417e-24,
  9.795112672103239e-03, -2.982128744267980e-04,  6.023150825146306e-06, -9.641046413574243e-08,  1.322407668105960e-09, -1.618180354812441e-11,  1.810317376146977e-13,
 -1.882103512243982e-15,  1.839617665394312e-17, -1.705086059505220e-19,  1.508605850371005e-21, -1.280742008122285e-23,  6.164355088238250e-03, -2.307506888519350e-04,
  5.467482733943522e-06, -1.007766118841552e-07,  1.571780832640929e-09, -2.166897361745461e-11,  2.711551323553441e-13, -3.134741089405368e-15,  3.390244367407556e-17,
 -3.462153069206781e-19,  3.362439764946813e-21, -3.123046030583916e-23,  3.698297844828989e-03, -1.672117618157408e-04,  4.609051572944970e-06, -9.715920371827997e-08,
  1.713080063253058e-09, -2.647000311512704e-11,  3.687411959096949e-13, -4.719322109531118e-15,  5.623990161579736e-17, -6.302845072090596e-19,  6.693890225847088e-21,
 -6.777319913944361e-23,  2.117815199009464e-03, -1.139099533747728e-04,  3.623898099365527e-06, -8.682208303093737e-08,  1.721430313229548e-09, -2.967305816048281e-11,
  4.582123776106626e-13, -6.466695303741758e-15,  8.460012799080612e-17, -1.036840528857500e-18,  1.200131741046159e-20, -1.320269899178119e-22,  1.159187922457358e-03,
 -7.320552020065435e-05,  2.668148975347802e-06, -7.223265376602585e-08,  1.602677039925214e-09, -3.068698855153484e-11,  5.232494128035035e-13, -8.113789955065433e-15,
  1.161387855266966e-16, -1.551628468188792e-18,  1.951486490389610e-20, -2.325912699709415e-22,  6.074127376447124e-04, -4.452788310405140e-05,  1.846466531692948e-06,
 -5.618148507455987e-08,  1.388656281082348e-09, -2.941806472923229e-11,  5.519010657129741e-13, -9.372204343315022e-15,  1.463259750277888e-16, -2.124900195898635e-18,
  2.895852303862271e-20, -3.729481466776727e-22,  3.052428445999578e-04, -2.571517876181525e-05,  1.205404979240391e-06, -4.101273904887911e-08,  1.124521018008956e-09,
 -2.625935398036026e-11,  5.402189003933695e-13, -1.001567689198247e-14,  1.700756744852483e-16, -2.677287197093762e-18,  3.943496527986432e-20, -5.474379329071211e-22,
  1.473990268231399e-04, -1.414355018370847e-05,  7.449261017531874e-07, -2.820761264172155e-08,  8.545213626327550e-10, -2.191858794711089e-11,  4.929078704433220e-13,
 -9.948304777848395e-15,  1.832416687747689e-16, -3.118990775469263e-18,  4.953454334992201e-20, -7.395178731693337e-22,  6.854602886119020e-05, -7.431696629809037e-06,
  4.373224108099444e-07, -1.834709828694442e-08,  6.117568785039509e-10, -1.717875291064590e-11,  4.210248656400740e-13, -9.225050776628282e-15,  1.838430551759148e-16,
 -3.375455161299704e-18,  5.766972430786906e-20, -9.239204378387341e-22,  3.077238908522837e-05, -3.742467506664158e-06,  2.447549843230764e-07, -1.132799346491159e-08,
  4.142283354772711e-10, -1.269364187755965e-11,  3.380757979899034e-13, -8.020592788724310e-15,  1.725138899767665e-16, -3.408837350246410e-18,  6.251715993226349e-20,
 -1.072585646069037e-21,  1.337187597054639e-05, -1.812169739446908e-06,  1.310594065509297e-07, -6.664602917740589e-09,  2.663292193742792e-10, -8.878891964742686e-12,
  2.562649056176231e-13, -6.566047950207656e-15,  1.520656633551927e-16, -3.226597789585110e-18,  6.338730329868798e-20, -1.162280171747203e-21,  5.640940366255130e-06,
 -8.466576998447370e-07,  6.739488072233884e-08, -3.750768431914748e-09,  1.632512448481173e-10, -5.903222876484114e-12,  1.841386627929033e-13, -5.082778955774547e-15,
  1.264541094669541e-16, -2.874982646161394e-18,  6.037618284630436e-20, -1.180864840132624e-21,  2.317584684691269e-06, -3.830573528453923e-07,  3.341084300889469e-08,
 -2.027370643768199e-09,  9.579373838004442e-11, -3.746209194999290e-12,  1.259561610411453e-13, -3.736410380006749e-15,  9.963271179267151e-17, -2.421943703832427e-18,
  5.426111766881281e-20, -1.129825277007760e-21,  9.306108619119302e-07, -1.684763355580411e-07,  1.603270734474527e-08, -1.056870210801280e-09,  5.403837129527630e-11,
 -2.278928556172018e-12,  8.237412860643170e-14, -2.619709710935973e-15,  7.470249818196613e-17, -1.937466851645543e-18,  4.621461825673029e-20, -1.022482684427542e-21,
  3.666093188179781e-07, -7.232834117506476e-08,  7.478771246970394e-09, -5.336687744102618e-10,  2.943486222769230e-11, -1.334839653976489e-12,  5.173569997349753e-14,
 -1.759669673598055e-15,  5.353858793802069e-17, -1.478355660914182e-18,  3.746864292624567e-20, -8.791465734405514e-22,  1.422754869445498e-07, -3.044095276820801e-08,
  3.406424195860414e-09, -2.622137040476618e-10,  1.555262513518913e-11, -7.562761669877213e-13,  3.134807420834195e-14, -1.137567559139586e-15,  3.684504665422779e-17,
 -1.080864375360085e-18,  2.904812364556633e-20, -7.214072913936581e-22,  5.463495790984656e-08, -1.261793734970284e-08,  1.522140601753380e-09, -1.259608508595474e-10,
  8.009355003616703e-12, -4.164406277623197e-13,  1.841252448508533e-14, -7.111166659653880e-16,  2.446287015949421e-17, -7.607313971129128e-19,  2.163383580466181e-20,
 -5.675452379621856e-22,  2.085834466257117e-08, -5.176240811014260e-09,  6.705695865647779e-10, -5.945232948396263e-11,  4.040162034620498e-12, -2.239716710454116e-13,
  1.053486602788646e-14, -4.319516483913934e-16,  1.574505581256253e-17, -5.178805703845713e-19,  1.555111573738972e-20, -4.300757504712111e-22,  7.956792592003691e-09,
 -2.112340046063418e-09,  2.927600084037209e-10, -2.771422453766379e-11,  2.006529655915193e-12, -1.182556416613944e-13,  5.901435829309533e-15, -2.562328473321125e-16,
  9.872725240453794e-18, -3.426770297887280e-19,  1.084155847976452e-20, -3.154087894730099e-22,  3.048873132897566e-09, -8.621170399752354e-10,  1.273492326561604e-10,
 -1.282826262955847e-11,  9.863963895548118e-13, -6.162104392282255e-14,  3.253572439645735e-15, -1.492001985247560e-16,  6.061524757159517e-18, -2.214922508882475e-19,
  7.366301968639499e-21, -2.249452139652725e-22,  1.179976710915389e-09, -3.538651764089865e-10,  5.550248396338807e-11, -5.928755041233442e-12,  4.826041864914267e-13,
 -3.186092749311903e-14,  1.774786439402253e-15, -8.572544292279400e-17,  3.662770931190541e-18, -1.405531001437326e-19,  4.902117086840361e-21, -1.567693311027444e-22,
  4.638723406451939e-10, -1.469116454130500e-10,  2.437406081012198e-11, -2.751277226241783e-12,  2.363073994212981e-13, -1.643559567473804e-14,  9.630498404342539e-16,
 -4.885917760450529e-17,  2.189603509601164e-18, -8.800937890870513e-20,  3.211038403733136e-21, -1.072830965615160e-22,  1.862958427428562e-10, -6.204748721512429e-11,
  1.084747154777366e-11, -1.289246457492203e-12,  1.164468022890897e-13, -8.505191471002818e-15,  5.226312951068591e-16, -2.776874440520238e-17,  1.301594819823145e-18,
 -5.465113782097238e-20,  2.080453656678129e-21, -7.243671026635475e-23,  7.686949710127876e-11, -2.681134793388920e-11,  4.920033845116728e-12, -6.134593631822505e-13,
  5.806513920447517e-14, -4.438939517374900e-15,  2.851404871941062e-16, -1.581825917407560e-17,  7.732215621655776e-19, -3.381880203706325e-20,  1.339590173341750e-21,
 -4.847726335922695e-23,  3.276597143992199e-11, -1.191844090424557e-11,  2.286643632566927e-12, -2.979850862180094e-13,  2.945120457018519e-14, -2.348441135624544e-15,
  1.571780246582887e-16, -9.075028617468258e-18,  4.611956200397856e-19, -2.094987463279842e-20,  8.609991514797744e-22, -3.229428434288055e-23,  1.450062128338186e-11,
 -5.477843120749556e-12,  1.094387526236482e-12, -1.484801922829648e-13,  1.526667887446028e-14, -1.265269910234988e-15,  8.792911349916622e-17, -5.266252343822577e-18,
  2.773543365476512e-19, -1.304433425687521e-20,  5.545503960964179e-22, -2.149564540363860e-23,  6.690842570374022e-12, -2.614153983843828e-12,  5.416195293025205e-13,
 -7.620239486287771e-14,  8.119821333589177e-15, -6.968474847981276e-16,  5.010354770893752e-17, -3.102016434685239e-18,  1.687385565143519e-19, -8.189869451687210e-21,
  3.590215248863353e-22, -1.433783305009730e-23,  3.228363883238239e-12, -1.299172834681049e-12,  2.779816328765968e-13, -4.039192692190589e-14,  4.442766357996268e-15,
 -3.933047071432304e-16,  2.914900423296249e-17, -1.858819454728231e-18,  1.040691154218480e-19, -5.194953150376055e-21,  2.340522146161092e-22, -9.599177688048653e-24,
  1.630239684948160e-12, -6.729500345006460e-13,  1.480703873143455e-13, -2.212740501975408e-14,  2.502048051046428e-15, -2.275777637101843e-16,  1.731853191812009e-17,
 -1.133268084741607e-18,  6.506502802660464e-20, -3.328620042424043e-21,  1.535976776018805e-22, -6.447753697769124e-24,  8.591731055581971e-13, -3.623080515426362e-13,
  8.162390408546952e-14, -1.249101802295188e-14,  1.445916445569608e-15, -1.345722195826842e-16,  1.047344795501227e-17, -7.005385522275020e-19,  4.108990789062024e-20,
 -2.146397744971225e-21,  1.010796598088704e-22, -4.327903708841118e-24,  4.681011010423887e-13, -2.008297949543869e-13,  4.612218043130135e-14, -7.196174135935828e-15,
  8.490914562400088e-16, -8.052200909457644e-17,  6.382883210928371e-18, -4.346508011476103e-19,  2.594400424820169e-20, -1.378540185117342e-21,  6.600815421323196e-23,
 -2.872351666000854e-24,  2.573768082481441e-13, -1.118871116029339e-13,  2.607756538989052e-14, -4.129787802198987e-15,  4.945097144206262e-16, -4.757839825893644e-17,
  3.825170738466348e-18, -2.641015795613233e-19,  1.597793887471527e-20, -8.602291148545856e-22,  4.172181492038313e-23, -1.838321197884232e-24,  1.338879704691095e-13,
 -5.873681917833932e-14,  1.383074155341779e-14, -2.213114479363930e-15,  2.677315892731007e-16, -2.601967741625061e-17,  2.112597146082545e-18, -1.472694320649007e-19,
  8.993712716521901e-21, -4.886641837782548e-22,  2.391335784419690e-23, -1.062853731497577e-24,  5.137596743248619e-14, -2.265310502358763e-14,  5.364633106605397e-15,
 -8.633866566729186e-16,  1.050465057380313e-16, -1.026643619609808e-17,  8.381438791072898e-19, -5.874139194861913e-20,  3.606162780136057e-21, -1.969412747034710e-22,
  9.685737227614188e-24, -4.325857870272012e-25,  6.366707578344460e-02, -1.682530949626394e-04,  4.619554734172557e-07, -1.308701504867470e-09,  3.794889225653324e-12,
 -1.118196193520673e-14,  3.327534549616204e-17, -9.957007783222459e-20,  2.985974724406494e-22, -8.957381340593491e-25,  2.683586566046379e-27, -8.025503106248998e-30,
  6.020453669283859e-02, -2.032558902382723e-04,  8.151401399049985e-07, -3.391667149895262e-09,  1.395215274700126e-11, -5.616735718028439e-14,  2.213861367229408e-16,
 -8.566217626492617e-19,  3.262116586493329e-21, -1.225142786308565e-23,  4.545163688599642e-26, -1.667810412599312e-28,  5.383960832665213e-02, -2.607974506467633e-04,
  1.491450428211507e-06, -8.142183100698249e-09,  4.206882635442807e-11, -2.081562312913625e-13,  9.952632408818963e-16, -4.626060083087160e-18,  2.099102417051907e-20,
 -9.327498477602462e-23,  4.068787582667112e-25, -1.745724992714732e-27,  4.554298598615515e-02, -3.210106387760823e-04,  2.411200339983030e-06, -1.629034765691807e-08,
  1.019469284392251e-10, -6.029413108477178e-13,  3.409658826839569e-15, -1.857974494439020e-17,  9.810237300698443e-20, -5.040295318478592e-22,  2.528088321489345e-24,
 -1.241122808085091e-26,  3.645206633750749e-02, -3.642622498194995e-04,  3.429911188343134e-06, -2.803034212069888e-08,  2.087233134830079e-10, -1.450462324547622e-12,
  9.541555299433885e-15, -5.999193646301136e-17,  3.630285805154604e-19, -2.125319296097101e-21,  1.208634974554755e-23, -6.697833735066183e-26,  2.761753852420414e-02,
 -3.778410625843557e-04,  4.353684103692233e-06, -4.244397637669606e-08,  3.711040694007109e-10, -2.991879995743639e-12,  2.262184702299512e-14, -1.622641886544727e-16,
  1.113237506831056e-18, -7.349914575001013e-21,  4.692016830161464e-23, -2.906919048060351e-25,  1.981710009664488e-02, -3.590496320610580e-04,  4.989486628964575e-06,
 -5.738698092564357e-08,  5.829402516613009e-10, -5.399024968889661e-12,  4.649284715967984e-14, -3.771728984327552e-16,  2.909658725043117e-18, -2.149402955476131e-20,
  1.528625247086211e-22, -1.051042976061283e-24,  1.347625646389694e-02, -3.141199536304989e-04,  5.207637548649085e-06, -6.999453211941404e-08,  8.188949122864383e-10,
 -8.644024572709953e-12,  8.415298255435180e-14, -7.667697146043407e-16,  6.607451556246408e-18, -5.426835080800286e-20,  4.273632481431107e-22, -3.242017738230832e-24,
  8.691781597545408e-03, -2.543188221944431e-04,  4.983214852422924e-06, -7.762175422624141e-08,  1.038271755890674e-09, -1.240818920677353e-11,  1.357285928630287e-13,
 -1.381011999278270e-15,  1.322067222239485e-17, -1.200963293102633e-19,  1.041992956427143e-21, -8.679129603373460e-24,  5.321735896495774e-03, -1.914513592665671e-04,
  4.395821652030404e-06, -7.876934410205319e-08,  1.196956875267846e-09, -1.610258311163805e-11,  1.968675440954515e-13, -2.225794186838182e-15,  2.356128561543392e-17,
 -2.356702995046362e-19,  2.243211869733263e-21, -2.043093805271616e-23,  3.096419980000837e-03, -1.345743527374299e-04,  3.591569672346355e-06, -7.354580533082061e-08,
  1.262442799821858e-09, -1.902179618280813e-11,  2.587217437619704e-13, -3.236332881993630e-15,  3.772741661018486e-17, -4.139153446381211e-19,  4.306242549605767e-21,
 -4.273412921382002e-23,  1.714165383513088e-03, -8.865950532296211e-05,  2.729485818844668e-06, -6.348584884501764e-08,  1.224719523071779e-09, -2.057429481431463e-11,
  3.100344622336169e-13, -4.274349518528915e-15,  5.467576240011432e-17, -6.557068954736825e-19,  7.431847552900916e-21, -8.010609874898184e-23,  9.041256253721968e-04,
 -5.493413382616492e-05,  1.936976708621833e-06, -5.088772160041335e-08,  1.098084563842544e-09, -2.048196274034988e-11,  3.406643132240751e-13, -5.158417969867028e-15,
  7.216850661917239e-17, -9.431586631898986e-19,  1.161170943758905e-20, -1.355605458791038e-22,  4.550545594529756e-04, -3.211559460487333e-05,  1.288292318920409e-06,
 -3.803073253956973e-08,  9.139564215254893e-10, -1.885580400356455e-11,  3.449587412796883e-13, -5.718765827593742e-15,  8.724621393068779e-17, -1.239039542892246e-18,
  1.652569583089982e-20, -2.084264387008929e-22,  2.189360706001585e-04, -1.777045027166157e-05,  8.059206571479331e-07, -2.660278096780330e-08,  7.091075624521452e-10,
 -1.612361051314304e-11,  3.234091988229781e-13, -5.852583962378629e-15,  9.709740736763724e-17, -1.494583437914493e-18,  2.154206271630042e-20, -2.928275904224031e-22,
  1.008888161723916e-04, -9.335243322006315e-06,  4.758518467967723e-07, -1.748348589035113e-08,  5.149140444260821e-10, -1.286033303648751e-11,  2.819645607590961e-13,
 -5.554485536847676e-15,  9.995351762087305e-17, -1.663529400482864e-18,  2.585180901187381e-20, -3.779137164347263e-22,  4.462652388840832e-05, -4.670316966945291e-06,
  2.661123031656836e-07, -1.083573060508301e-08,  3.513167726128983e-10, -9.607131785406101e-12,  2.295828261256786e-13, -4.910201457942042e-15,  9.560622261253268e-17,
 -1.716492746845178e-18,  2.869805709381285e-20, -4.502264117858837e-22,  1.899449154786951e-05, -2.232269444883006e-06,  1.414507382375068e-07, -6.356904165610596e-09,
  2.261019405135665e-10, -6.749110049849751e-12,  1.753072269168970e-13, -4.060467257454919e-15,  8.534541143244773e-17, -1.649329228284978e-18,  2.960517168543491e-20,
 -4.974669039643117e-22,  7.800514065149171e-06, -1.022753176985148e-06,  7.172450264379396e-08, -3.543625184692490e-09,  1.378060692729714e-10, -4.476888103661480e-12,
  1.260617103276557e-13, -3.154415590294934e-15,  7.141015771737186e-17, -1.482311740133067e-18,  2.850892593765657e-20, -5.121151308872264e-22,  3.100135199006704e-06,
 -4.507547011811000e-07,  3.482466734978124e-08, -1.884387865655156e-09,  7.986314338592627e-11, -2.815635593745891e-12,  8.572639204214558e-14, -2.311960790800474e-15,
  5.624745664603341e-17, -1.251523213974158e-18,  2.574035506111929e-20, -4.933831802557593e-22,  1.196282467238946e-06, -1.918090949038629e-07,  1.625455932914736e-08,
 -9.598081308497190e-10,  4.419259754876231e-11, -1.686114507695965e-12,  5.536765599307385e-14, -1.605614348740649e-15,  4.188949915039451e-17, -9.970473757024055e-19,
  2.188728584147887e-20, -4.468376692592296e-22,  4.498391196706874e-07, -7.911871463301999e-08,  7.323781360397045e-09, -4.702642076355796e-10,  2.345093083859557e-11,
 -9.656295905906416e-13,  3.411333852928733e-14, -1.061273513208930e-15,  2.962785673144246e-17, -7.528515039211456e-19,  1.760584090894038e-20, -3.821304448123514e-22,
  1.654907451573940e-07, -3.176957800454206e-08,  3.199447758556675e-09, -2.226323453906244e-10,  1.198795405012316e-11, -5.312826805466447e-13,  2.014202573258080e-14,
 -6.706946789773490e-16,  1.999279893506509e-17, -5.412561107149265e-19,  1.345827179693593e-20, -3.099890194354689e-22,  5.982180162868629e-08, -1.247488112331543e-08,
  1.361497239371794e-09, -1.023230448982089e-10,  5.931535402706314e-12, -2.821619647493774e-13,  1.145135145156522e-14, -4.071849494372539e-16,  1.293227147490242e-17,
 -3.722511431539897e-19,  9.822421775453230e-21, -2.396468296946960e-22,  2.134755286916816e-08, -4.813503980913938e-09,  5.671608552051295e-10, -4.588389040005482e-11,
  2.854912235792952e-12, -1.453753733644290e-13,  6.299945126101536e-15, -2.386525388990281e-16,  8.057980801274535e-18, -2.461014412150766e-19,  6.877518627831091e-21,
 -1.774011780631119e-22,  7.558419716846817e-09, -1.834567984858245e-09,  2.324966532020139e-10, -2.018035278010562e-11,  1.343683895690544e-12, -7.304073627296173e-14,
  3.371225099747724e-15, -1.357285797344051e-16,  4.861027175706806e-18, -1.571856424578295e-19,  4.642793749399923e-21, -1.263646937578246e-22,  2.669649003876539e-09,
 -6.944502969394328e-10,  9.430811592954654e-11, -8.753403785993240e-12,  6.218195588891381e-13, -3.598195289441326e-14,  1.764198856187497e-15, -7.530376745705167e-17,
  2.854033027742768e-18, -9.749429866590247e-20,  3.037219300999404e-21, -8.704858222028520e-23,  9.460392428693683e-10, -2.626056451724099e-10,  3.807381660723704e-11,
 -3.766303765962812e-12,  2.845658013673681e-13, -1.747869189758698e-14,  9.079089480186110e-16, -4.098193571333990e-17,  1.639726927289767e-18, -5.903735301379024e-20,
  1.935514664211602e-21, -5.829072956182979e-23,  3.383896691090385e-10, -9.980738430523588e-11,  1.539150470024006e-11, -1.617165449752860e-12,  1.295483670557099e-13,
 -8.421334757559644e-15,  4.621411330583474e-16, -2.200178902445771e-17,  9.270011212173041e-19, -3.509334529604454e-20,  1.207989602724362e-21, -3.814310836740066e-23,
  1.229428546752564e-10, -3.836661249290550e-11,  6.269491922241264e-12, -6.972413511619132e-13,  5.902856490090986e-14, -4.048617111973856e-15,  2.340467882301114e-16,
 -1.171982998998549e-17,  5.186109069585455e-19, -2.059098136230663e-20,  7.423828569608725e-22, -2.451945773345275e-23,  4.566249456009681e-11, -1.501320620449833e-11,
  2.589714486003829e-12, -3.037628594596093e-13,  2.708698469781567e-14, -1.953989087804200e-15,  1.186336288308742e-16, -6.230273235310150e-18,  2.887503169375526e-19,
 -1.199201026085940e-20,  4.516898783702162e-22, -1.556594317277559e-23,  1.744982255225366e-11, -6.019057291721741e-12,  1.091724655086762e-12, -1.345665282855426e-13,
  1.259512138173738e-14, -9.524555460474254e-16,  6.054062128943075e-17, -3.324372430998092e-18,  1.608990456579363e-19, -6.970056625071186e-21,  2.735288534510578e-22,
 -9.809552842613146e-24,  6.904625448241036e-12, -2.488052064678450e-12,  4.726273773598451e-13, -6.098762416473315e-14,  5.970080177275977e-15, -4.716330904762419e-16,
  3.128123239364418e-17, -1.790298842555687e-18,  9.021167016022412e-20, -4.064146602976464e-21,  1.656941233413891e-22, -6.166735904695581e-24,  2.845651045258943e-12,
 -1.066689344339390e-12,  2.113481057070707e-13, -2.843949621240934e-14,  2.900709628452121e-15, -2.385303885955753e-16,  1.645098323152909e-17, -9.780396359632085e-19,
  5.114226644827368e-20, -2.388628909185117e-21,  1.008643732028633e-22, -3.884262330060145e-24,  1.227920311610929e-12, -4.767767906601151e-13,  9.812003416404278e-14,
 -1.371275467475778e-14,  1.451629478236810e-15, -1.237867725649537e-16,  8.845242495681367e-18, -5.443367444685839e-19,  2.943717815511652e-20, -1.420662565402483e-21,
  6.193525808217700e-23, -2.460247972521513e-24,  5.569441715471081e-13, -2.230456657018167e-13,  4.747376326896476e-14, -6.861936045743215e-15,  7.508690085690879e-16,
 -6.613851144578989e-17,  4.877789230850344e-18, -3.095782404878965e-19,  1.725233841402250e-20, -8.573499350003456e-22,  3.845876892137529e-23, -1.570656835995188e-24,
  2.660072793836949e-13, -1.094105701070471e-13,  2.397872493151142e-14, -3.569176538864790e-15,  4.020161891557873e-16, -3.642743447673125e-17,  2.761876961318432e-18,
 -1.800796502257442e-19,  1.030296191073493e-20, -5.252958798093191e-22,  2.415968914312920e-23, -1.010941519228646e-24,  1.335428803628755e-13, -5.617142712064032e-14,
  1.261931209247427e-14, -1.925718032213905e-15,  2.222975606806649e-16, -2.063341900304885e-17,  1.601621559542215e-18, -1.068531915590861e-19,  6.251819691858807e-21,
 -3.257821651357977e-22,  1.530579701804771e-23, -6.538467292907404e-25,  6.986248448792930e-14, -2.992353574655235e-14,  6.859520779991270e-15, -1.068267524935377e-15,
  1.258169887428798e-16, -1.191031365915342e-17,  9.424719566083201e-19, -6.406998928124305e-20,  3.817978186527755e-21, -2.025431035155119e-22,  9.683137374105436e-24,
 -4.207235429969715e-25,  3.720821627195730e-14, -1.615949298126760e-14,  3.762206234449699e-15, -5.951509521783788e-16,  7.118758992326139e-17, -6.841933656754425e-18,
  5.495030871491777e-19, -3.790108565027543e-20,  2.290729676324667e-21, -1.232113205507840e-22,  5.970267419642609e-24, -2.628195729962854e-25,  1.892559196477562e-14,
 -8.298608506351169e-15,  1.952991625852585e-15, -3.123315771487085e-16,  3.776340355368432e-17, -3.668065370502989e-18,  2.976598738118024e-19, -2.073909014192455e-20,
  1.265886212297183e-21, -6.874637299046113e-23,  3.362547553929938e-24, -1.493810248383797e-25,  7.170934548009511e-15, -3.161166139338163e-15,  7.484286137585664e-16,
 -1.204215810230426e-16,  1.464770493763023e-17, -1.431191822750638e-18,  1.168122501893053e-19, -8.184787048653916e-21,  5.023466770997062e-22, -2.742784836989145e-23,
  1.348609425210869e-24, -6.021799214724818e-26,  6.300135666503262e-02, -1.646192533569675e-04,  4.466081226406184e-07, -1.249729928972152e-09,  3.579015701326007e-12,
 -1.041575853286856e-14,  3.061645105099591e-17, -9.051085758831358e-20,  2.682009637421017e-22, -7.951317440299463e-25,  2.354485508367308e-27, -6.960646369392115e-30,
  5.940430285480214e-02, -1.968938576951229e-04,  7.757433836665515e-07, -3.177138743487423e-09,  1.288005473569347e-11, -5.113051433027864e-14,  1.987982718416525e-16,
 -7.589538253785131e-19,  2.852096866453032e-21, -1.057195916390336e-23,  3.871495000750382e-26, -1.402457345152055e-28,  5.281967867264634e-02, -2.492455374679724e-04,
  1.397649542082171e-06, -7.501131765929150e-09,  3.813445251341586e-11, -1.857513601603191e-13,  8.746542872511743e-16, -4.005076828979430e-18,  1.790847434606299e-20,
 -7.843729052406741e-23,  3.373245000168198e-25, -1.427139470904232e-27,  4.429632254474192e-02, -3.024761316163354e-04,  2.225119065976038e-06, -1.475139192160934e-08,
  9.066604612819341e-11, -5.270136489358836e-13,  2.930781222311660e-15, -1.571229288246348e-17,  8.165324140312892e-20, -4.130334691974410e-22,  2.040229670374191e-24,
 -9.866585691001129e-27,  3.504784295274852e-02, -3.381137706025447e-04,  3.112666013815541e-06, -2.491094926856482e-08,  1.818744745338571e-10, -1.240377074635116e-12,
  8.013548946079579e-15, -4.951137105811436e-17,  2.945531559074612e-19, -1.696020447113513e-21,  9.489339658631980e-24, -5.175368981347736e-26,  2.617274421796339e-02,
 -3.449523237049436e-04,  3.878099238659209e-06, -3.695698851803541e-08,  3.163475095346286e-10, -2.499683098178830e-12,  1.853984694848073e-14, -1.305355265010480e-16,
  8.795527141387845e-19, -5.705948743391089e-21,  3.580575084950057e-23, -2.181369191422198e-25,  1.845658544863924e-02, -3.217375840843706e-04,  4.353428776798300e-06,
 -4.886656437590425e-08,  4.853140959063995e-10, -4.400080326306595e-12,  3.712712476030202e-14, -2.953491407607814e-16,  2.235632444732381e-18, -1.621328697875181e-20,
  1.132530287670575e-22, -7.651420134968348e-25,  1.229807725461385e-02, -2.756083119118769e-04,  4.440948522126364e-06, -5.817241377116452e-08,  6.645883310443371e-10,
 -6.859788852975660e-12,  6.537186806006029e-14, -5.835507248421838e-16,  4.929955808094633e-18, -3.971995425538491e-20,  3.069981905072312e-22, -2.286799852868106e-24,
  7.748713696296998e-03, -2.179143101637436e-04,  4.143777844332029e-06, -6.283006194728051e-08,  8.197818052721656e-10, -9.570641809813190e-12,  1.023864543760997e-13,
 -1.019773713063033e-15,  9.563678490082949e-18, -8.516229636550223e-20,  7.247243165842652e-22, -5.923672368827528e-24,  4.620706477296164e-03, -1.597630496673168e-04,
  3.555646831554968e-06, -6.195748352008857e-08,  9.175144917423522e-10, -1.204769238981530e-11,  1.439392935646032e-13, -1.591879480157744e-15,  1.649670567945712e-17,
 -1.616508570045336e-19,  1.508277319250273e-21, -1.347318908201571e-23,  2.610447446718094e-03, -1.090554743850535e-04,  2.818674334687075e-06, -5.608135560395077e-08,
  9.374107676920024e-10, -1.377612487805032e-11,  1.829834836641328e-13, -2.237587238279356e-15,  2.552139354399413e-17, -2.741568348359545e-19,  2.794508409058093e-21,
 -2.718628213373209e-23,  1.398806350708232e-03, -6.956665061143490e-05,  2.072856064809010e-06, -4.681533399291252e-08,  8.788838524494736e-10, -1.439186046459312e-11,
  2.116710282395086e-13, -2.851292556438665e-15,  3.566772204846090e-17, -4.186331670166725e-19,  4.646833213869754e-21, -4.908221730833663e-23,  7.118972286449199e-04,
 -4.161072431261791e-05,  1.419537342170870e-06, -3.619604196039381e-08,  7.597318102892957e-10, -1.380672164974984e-11,  2.240330391612000e-13, -3.313146971628887e-15,
  4.531177412818406e-17, -5.793402201932889e-19,  6.982888769545233e-21, -7.986112263676794e-23,  3.446310719700944e-04, -2.341212234582739e-05,  9.085394591235944e-07,
 -2.602378532546016e-08,  6.081311241805380e-10, -1.221987951437789e-11,  2.180291153432683e-13, -3.529019939982667e-15,  5.261522617787813e-17, -7.308331173738327e-19,
  9.540570720385091e-21, -1.178504264210295e-22,  1.589703165457680e-04, -1.242916221677806e-05,  5.453477974511673e-07, -1.746509478509103e-08,  4.526032888644105e-10,
 -1.002149363046050e-11,  1.960017958448361e-13, -3.462373827790919e-15,  5.612619649148437e-17, -8.448326103903270e-19,  1.191653493788869e-20, -1.586266218898063e-22,
  7.000740019862649e-05, -6.244976534283117e-06,  3.080547167355071e-07, -1.098185329566967e-08,  3.144380296200145e-10, -7.646989914249170e-12,  1.634692808550886e-13,
 -3.143168784189604e-15,  5.526092441282946e-17, -8.993118504632720e-19,  1.367584016359226e-20, -1.957640671680877e-22,  2.949738477790110e-05, -2.978842399669926e-06,
  1.643247933650120e-07, -6.493613110408805e-09,  2.047081077953491e-10, -5.451300959898256e-12,  1.270191404149620e-13, -2.651705111849379e-15,  5.044518609887309e-17,
 -8.856183552339759e-19,  1.448948582171951e-20, -2.225993984280330e-22,  1.192045991236930e-05, -1.353240236363301e-06,  8.306611849683708e-08, -3.624263562994216e-09,
  1.253731260771860e-10, -3.645085762973745e-12,  9.233343071388275e-14, -2.087834873185697e-15,  4.288122774706300e-17, -8.104417308800792e-19,  1.423747883214258e-20,
 -2.343031067568064e-22,  4.632907415104487e-06, -5.874369905073347e-07,  3.993601523813847e-08, -1.916592123904018e-09,  7.251967583509845e-11, -2.295480725222425e-12,
  6.305327216338511e-14, -1.540708678789033e-15,  3.409072412530286e-17, -6.922219998502794e-19,  1.303276439666138e-20, -2.293342587424301e-22,  1.736919887456542e-06,
 -2.445347675472207e-07,  1.833029654555998e-08, -9.641135811550176e-10,  3.977858052866604e-11, -1.367084316949599e-12,  4.062037294604972e-14, -1.070174919689492e-15,
  2.545707182194936e-17, -5.542718124624542e-19,  1.116326701194074e-20, -2.096748478425212e-22,  6.302745915319110e-07, -9.798297592756296e-08,  8.064363409249403e-09,
 -4.632379349398790e-10,  2.077838354707717e-11, -7.732636639058758e-13,  2.479388491321696e-14, -7.027386986125520e-16,  1.793472846200276e-17, -4.179067120489887e-19,
  8.987444155094001e-21, -1.798712415189174e-22,  2.221857803241120e-07, -3.794455725323726e-08,  3.415098988771615e-09, -2.135208506527879e-10,  1.038137458363177e-11,
 -4.172544851195660e-13,  1.440300598300303e-14, -4.382185594420522e-16,  1.197444623779171e-17, -2.980444116737519e-19,  6.831908365891691e-21, -1.454421110901596e-22,
  7.640399140004652e-08, -1.426365098571211e-08,  1.398383062791218e-09, -9.484819711304308e-11,  4.984142109548686e-12, -2.157930858380592e-13,  8.000112726596072e-15,
 -2.607192042370491e-16,  7.612315529957281e-18, -2.020001382811349e-19,  4.926397746698195e-21, -1.113649426811173e-22,  2.574418687741483e-08, -5.229209656116923e-09,
  5.563261853872892e-10, -4.080242027577774e-11,  2.310702922239611e-12, -1.074890901607306e-13,  4.269695575631499e-15, -1.487157287538525e-16,  4.630051862442625e-18,
 -1.307338064673548e-19,  3.385975372341901e-21, -8.113538821134001e-23,  8.541534229234858e-09, -1.879170240618907e-09,  2.161469188485148e-10, -1.708678956996458e-11,
  1.039840177035138e-12, -5.183524824754930e-14,  2.200832642644261e-15, -8.174450456276430e-17,  2.708080270601230e-18, -8.120263456484823e-20,  2.229288759032995e-21,
 -5.652200540652510e-23,  2.805439337144219e-09, -6.655605431207790e-10,  8.246568224250974e-11, -7.003973366757746e-12,  4.567108132577421e-13, -2.433254934536088e-14,
  1.101573950556922e-15, -4.353131344110450e-17,  1.531236474059315e-18, -4.865980697322220e-20,  1.413260526013808e-21, -3.784323964630850e-23,  9.174315126831083e-10,
 -2.336877944014066e-10,  3.107755921371949e-11, -2.826672642078881e-12,  1.969191924343732e-13, -1.118270850657625e-14,  5.384473792381401e-16, -2.258506206182798e-17,
  8.416459834595554e-19, -2.828497388152451e-20,  8.673289777079507e-22, -2.448049259823822e-23,  3.005613767920431e-10, -8.184898843846706e-11,  1.164042730860379e-11,
 -1.130146846720839e-12,  8.386119730644409e-14, -5.062024621707420e-15,  2.585588429057206e-16, -1.148314262218839e-17,  4.522986650585624e-19, -1.603933192551944e-20,
  5.181656441252165e-22, -1.538466698513004e-23,  9.929447670359077e-11, -2.878570369642634e-11,  4.361969675585170e-12, -4.505449872052573e-13,  3.550091225960458e-14,
 -2.271205607644235e-15,  1.227307403607862e-16, -5.756564734161905e-18,  2.390691677096655e-19, -8.924943786915788e-21,  3.030887680734173e-22, -9.445730178935700e-24,
  3.330726203483899e-11, -1.023573436467121e-11,  1.646478197385256e-12, -1.803083588956759e-13,  1.503863547938603e-14, -1.016665153173038e-15,  5.795693745794414e-17,
 -2.863210894343735e-18,  1.250521274250400e-19, -4.902554667653912e-21,  1.745977799748793e-22, -5.698444625354823e-24,  1.142541648581300e-11, -3.706236325562526e-12,
  6.304468771467284e-13, -7.294256014773610e-14,  6.418399706653368e-15, -4.570763448541451e-16,  2.740650636740113e-17, -1.422017115813698e-18,  6.513842703239852e-20,
 -2.674738920268575e-21,  9.964475794200833e-23, -3.397546616837834e-24,  4.037160451944002e-12, -1.376454281341699e-12,  2.466385238216855e-13, -3.003859130006764e-14,
  2.778935457652304e-15, -2.077812412087021e-16,  1.306310035426238e-17, -7.097331343937500e-19,  3.399911534289353e-20, -1.458196085336982e-21,  5.667336462503715e-23,
 -2.013511338231756e-24,  1.480060687685201e-12, -5.281066031968606e-13,  9.927985263114606e-14, -1.267995103383264e-14,  1.228854999649868e-15, -9.613790402189575e-17,
  6.316425927326341e-18, -3.582079240857617e-19,  1.789021039883933e-20, -7.990639845722677e-22,  3.230654221986585e-23, -1.192680872774442e-24,  5.668630275213397e-13,
 -2.107629921249606e-13,  4.139779008658119e-14, -5.522752015016900e-15,  5.585721635792928e-16, -4.555763159964930e-17,  3.117135556982022e-18, -1.838948707091865e-19,
  9.544268805738848e-21, -4.425452995188308e-22,  1.855608885974207e-23, -7.097297201321162e-25,  2.282311656042074e-13, -8.803780423379148e-14,  1.799040650447870e-14,
 -2.496628829264311e-15,  2.624801991654167e-16, -2.223339163396915e-17,  1.578391176639663e-18, -9.652247601536062e-20,  5.187923900061398e-21, -2.488876119275385e-22,
  1.078799826992440e-23, -4.261387190672624e-25,  9.708266299941286e-14, -3.868162227756296e-14,  8.187522562558494e-15, -1.176899917973053e-15,  1.280851813680015e-16,
 -1.122253599605936e-17,  8.234269139052611e-19, -5.199980777110046e-20,  2.883841273629498e-21, -1.426378276415984e-22,  6.369193239648502e-24, -2.589672346048511e-25,
  4.375578264215775e-14, -1.792859679618623e-14,  3.912904775363267e-15, -5.799985605914052e-16,  6.506111162607595e-17, -5.871771117006487e-18,  4.434597119199355e-19,
 -2.880521067841612e-20,  1.641994819723681e-21, -8.341853812111292e-23,  3.823341908902028e-24, -1.594475180099547e-25,  2.087943426601534e-14, -8.758845781750834e-15,
  1.961908892139352e-15, -2.984996977655026e-16,  3.435704659771590e-17, -3.179889354954951e-18,  2.461459805299793e-19, -1.637741368646234e-20,  9.557007719444211e-22,
 -4.967438627180457e-23,  2.327995154524892e-24, -9.921015125738507e-26,  1.046813577429507e-14, -4.475862684913820e-15,  1.024026162283230e-15, -1.591644955334881e-16,
  1.870972845575068e-17, -1.767795780436509e-18,  1.396299547035531e-19, -9.475173514103073e-21,  5.636497789304064e-22, -2.985089770836266e-23,  1.424755152606437e-24,
 -6.180544280229306e-26,  5.391884837544525e-15, -2.339288203747862e-15,  5.440014229630523e-16, -8.595714877921329e-17,  1.026983343393782e-17, -9.859444898509331e-19,
  7.909876793900575e-20, -5.449906770776820e-21,  3.290493086146096e-22, -1.768068894803557e-23,  8.558846786617704e-25, -3.764128455684777e-26,  2.678469549927068e-15,
 -1.173865597281850e-15,  2.760967050301172e-16, -4.412873673052072e-17,  5.332417302893989e-18, -5.176568107420170e-19,  4.198384139242386e-20, -2.923573264892809e-21,
  1.783556174602944e-22, -9.680886847081823e-24,  4.732736433405028e-25, -2.101472282148116e-26,  1.001455306889004e-15, -4.413704445900387e-16,  1.044703156238416e-16,
 -1.680471955422563e-17,  2.043531561192132e-18, -1.996161624270536e-19,  1.628823208438964e-20, -1.140991492441244e-21,  7.001157307373616e-23, -3.821652129914204e-24,
  1.878626890787577e-25, -8.386440187738003e-27,  6.234993175588286e-02, -1.611054174969410e-04,  4.319482016104449e-07, -1.194093119811768e-09,  3.377848102517715e-12,
 -9.710431355034343e-15,  2.819812402179169e-17, -8.236882816214159e-20,  2.412001993852383e-22, -7.067986025619755e-25,  2.068824229296684e-27, -6.046876138770618e-30,
  5.862890270116999e-02, -1.908369859798855e-04,  7.388212782789042e-07, -2.978986561158156e-09,  1.190348657272048e-11, -4.660439238035721e-14,  1.787701516790760e-16,
 -6.734889527302974e-19,  2.497956273993978e-21, -9.139989995167897e-24,  3.304405454021133e-26, -1.181901525542815e-28,  5.184450310992659e-02, -2.384142980016697e-04,
  1.311177865527741e-06, -6.919597189950979e-09,  3.462058275612003e-11, -1.660431250223947e-13,  7.701285088163501e-16, -3.474699359871268e-18,  1.531320512260493e-20,
 -6.612049266971866e-23,  2.803874061654612e-25, -1.169916211471475e-27,  4.312093260756932e-02, -2.853593616890314e-04,  2.056470457662860e-06, -1.338138006825460e-08,
  8.079499478136139e-11, -4.616721682322319e-13,  2.525289900178475e-15, -1.332235704493181e-17,  6.815411155628506e-20, -3.394840973762623e-22,  1.651766186871855e-24,
 -7.870046662441038e-27,  3.374336473125465e-02, -3.143605179469171e-04,  2.830408529222599e-06, -2.218942122357817e-08,  1.588831674000658e-10, -1.063676519820208e-12,
  6.750509103502396e-15, -4.099355158777786e-17,  2.398135490668727e-19, -1.358346024575827e-21,  7.478793995480635e-24, -4.014973647551616e-26,  2.485229243851524e-02,
 -3.156190671160607e-04,  3.463409995965951e-06, -3.227238951606204e-08,  2.705230224678094e-10, -2.095586611166341e-12,  1.524987838093690e-14, -1.054177799484895e-16,
  6.977622917822596e-19, -4.448705611965294e-21,  2.744678832595201e-23, -1.644573296716828e-25,  1.723575403656595e-02, -2.891301304988083e-04,  3.810865582472467e-06,
 -4.175981081782727e-08,  4.055927471756645e-10, -3.600692212108099e-12,  2.977703772615585e-14, -2.323352842737903e-16,  1.725986636699235e-18, -1.229117170200234e-20,
  8.434401717800899e-23, -5.600188935059991e-25,  1.126252020027972e-02, -2.427021309531165e-04,  3.802414264210535e-06, -4.855657258045374e-08,  5.418451271904163e-10,
 -5.470351481719819e-12,  5.104192570392613e-14, -4.464845174339176e-16,  3.698798357201457e-18, -2.923947852169541e-20,  2.218500837435673e-22, -1.622964336483747e-24,
  6.938878469857059e-03, -1.875706754809942e-04,  3.462606907061245e-06, -5.112046429776304e-08,  6.507962660449840e-10, -7.424073352146121e-12,  7.769353897265715e-14,
 -7.576675060675025e-16,  6.962373646539383e-18, -6.078747310360720e-20,  5.074745991599551e-22, -4.071178247897696e-24,  4.034165490477232e-03, -1.340594344279910e-04,
  2.892855976218387e-06, -4.903133207098980e-08,  7.077825927977078e-10, -9.073356625626281e-12,  1.059590884764775e-13, -1.146520455950492e-15,  1.163403165725644e-17,
 -1.117043737393785e-19,  1.021860511382428e-21, -8.954246280989351e-24,  2.215396345314200e-03, -8.896249791932200e-05,  2.227315733263353e-06, -4.306810400185123e-08,
  7.011703365535474e-10, -1.005246768427564e-11,  1.304221300320807e-13, -1.559384906830458e-15,  1.740525411987379e-17, -1.831022371467314e-19,  1.828918011015110e-21,
 -1.744529050864891e-23,  1.150458235197095e-03, -5.501208999029589e-05,  1.586771430001836e-06, -3.480486143917290e-08,  6.359927794330991e-10, -1.015355581239410e-11,
  1.457815411512654e-13, -1.919023647988444e-15,  2.347991299718377e-17, -2.697544554545811e-19,  2.932890800130253e-21, -3.036166911353191e-23,  5.656823112817763e-04,
 -3.180442216929762e-05,  1.049873383484557e-06, -2.598609187358419e-08,  5.306226064166473e-10, -9.396800091535452e-12,  1.487770804229499e-13, -2.149162895291553e-15,
  2.873705690020082e-17, -3.595102383519344e-19,  4.242881580295877e-21, -4.754226116042143e-23,  2.637525787603049e-04, -1.724441767818291e-05,  6.474062699354422e-07,
 -1.799501876596728e-08,  4.089456559259401e-10, -8.004583080322755e-12,  1.393045589318828e-13, -2.201719798036178e-15,  3.208363086268853e-17, -4.359209055765207e-19,
  5.570479333864502e-21, -6.739972518980702e-23,  1.168075103155931e-04, -8.795318409831228e-06,  3.733483030986906e-07, -1.160093534810857e-08,  2.923017904404697e-10,
 -6.302978504901615e-12,  1.202120422769459e-13, -2.073088888175171e-15,  3.283811145596428e-17, -4.834055700721169e-19,  6.673255374716721e-21, -8.699577645581361e-23,
  4.922874766307470e-05, -4.232514311233605e-06,  2.020281360262462e-07, -6.987876277249545e-09,  1.945204389378231e-10, -4.606527718289822e-12,  9.601550412563961e-14,
 -1.802086512600252e-15,  3.095589562871424e-17, -4.926248464104435e-19,  7.331008146478356e-21, -1.027636199911785e-22,  1.978659797406740e-05, -1.927579949779073e-06,
  1.029302578898520e-07, -3.947162511233500e-09,  1.209834956018593e-10, -3.137293184381331e-12,  7.127650803840765e-14, -1.452448289323362e-15,  2.699644998895138e-17,
 -4.634568454027278e-19,  7.420214954545529e-21, -1.116309849363798e-22,  7.602828629705527e-06, -8.334211714610547e-07,  4.954675995982920e-08, -2.098501259994485e-09,
  7.059604389520190e-11, -1.999014287270278e-12,  4.937908507195829e-14, -1.089992855380652e-15,  2.187494507652264e-17, -4.043115800198016e-19,  6.951314094682844e-21,
 -1.120338025188277e-22,  2.800315858286228e-06, -3.432396209140643e-07,  2.261480136915844e-08, -1.054045584781092e-09,  3.879957796961256e-11, -1.196472631620593e-12,
  3.205679187625517e-14, -7.648426878223508e-16,  1.653973017544611e-17, -3.285005094623753e-19,  6.054076468523033e-21, -1.043513501907652e-22,  9.917072378842790e-07,
 -1.351284966634654e-07,  9.824671165101185e-09, -5.021618102005349e-10,  2.016606314865141e-11, -6.754727980905412e-13,  1.958398823437985e-14, -5.039621732071049e-16,
  1.172003557202265e-17, -2.496729358364431e-19,  4.923632751737513e-21, -9.061095709271141e-23,  3.388247942366766e-07, -5.104610326563538e-08,  4.078792884822126e-09,
 -2.278544658464858e-10,  9.953942001405992e-12, -3.612358960985322e-13,  1.130753257030800e-14, -3.131851989264560e-16,  7.817449973851285e-18, -1.783011817156686e-19,
  3.756005532211491e-21, -7.368119218365833e-23,  1.121035831883199e-07, -1.857917545490450e-08,  1.625143536075276e-09, -9.890152738925751e-11,  4.686820332803011e-12,
 -1.838227839340238e-13,  6.198411103308223e-15, -1.843960771587324e-16,  4.930763326102100e-18, -1.201898412950689e-19,  2.699967577925141e-21, -5.636631989411007e-23,
  3.606895294074490e-08, -6.544415873636698e-09,  6.242976735197642e-10, -4.125785646229703e-11,  2.115023586974809e-12, -8.943073223150217e-14,  3.241128425953570e-15,
 -1.033493032744481e-16,  2.954834580228392e-18, -7.683637493427566e-20,  1.837529834382252e-21, -4.075849390495342e-23,  1.133773919627160e-08, -2.241790015836133e-09,
  2.323684064867886e-10, -1.662402733028734e-11,  9.193522021514416e-13, -4.180511989346042e-14,  1.624751085331781e-15, -5.541564499086469e-17,  1.690736770079497e-18,
 -4.681603249694127e-20,  1.189831558595305e-21, -2.799445381683596e-23,  3.499534915999855e-09, -7.507204408423975e-10,  8.424803274718626e-11, -6.504515941323852e-12,
  3.869905675808111e-13, -1.887732417909035e-14,  7.849673136075408e-16, -2.857650372071063e-17,  9.285542692212893e-19, -2.732728096802684e-20,  7.367795232264168e-22,
 -1.835638390404932e-23,  1.066617021880161e-09, -2.471681265036184e-10,  2.992470675381014e-11, -2.485611098269035e-12,  1.586535423411535e-13, -8.280959762848359e-15,
  3.675605399482257e-16, -1.425117918623089e-17,  4.921679355563427e-19, -1.536493860194826e-20,  4.386528754471710e-22, -1.155222755048069e-23,  3.229686213149181e-10,
 -8.050231920465814e-11,  1.047763802788691e-11, -9.333741023970515e-13,  6.373438997210203e-14, -3.550310040733299e-15,  1.678043145652621e-16, -6.913654173417550e-18,
  2.532261349870119e-19, -8.369044137324604e-21,  2.525091632348847e-22, -7.016371847715192e-24,  9.779580438865125e-11, -2.610943278495636e-11,  3.640188829116920e-12,
 -3.466763156118378e-13,  2.525123620205278e-14, -1.497166231910507e-15,  7.516332998272927e-17, -3.282978320826984e-18,  1.272438076090788e-19, -4.442526361866900e-21,
  1.413706299983968e-22, -4.136526595811938e-24,  2.982285134755690e-11, -8.492299534070269e-12,  1.263738399314340e-12, -1.282480795792536e-13,  9.934520694218399e-15,
 -6.251950243664010e-16,  3.325145435815994e-17, -1.535862778853994e-18,  6.284410610578326e-20, -2.312629292801938e-21,  7.745077627893912e-23, -2.381444449925446e-24,
  9.227744329707655e-12, -2.790840607469395e-12,  4.416464377425295e-13, -4.759959153971753e-14,  3.909148085042212e-15, -2.603522587603496e-16,  1.462903435845719e-17,
 -7.126851540672433e-19,  3.070904967699169e-20, -1.188269840254141e-21,  4.178547103030797e-23, -1.347140393478547e-24,  2.919859234731113e-12, -9.339332012866975e-13,
  1.565754427375890e-13, -1.785968541318568e-14,  1.549954641693004e-15, -1.089110317164746e-16,  6.446384448791462e-18, -3.303149834863981e-19,  1.494840996625116e-20,
 -6.066503457195331e-22,  2.234435508607119e-23, -7.535165764967171e-25,  9.524727453761685e-13, -3.208135625630609e-13,  5.675935567284382e-14, -6.827033008829120e-15,
  6.239585820024306e-16, -4.610732492879049e-17,  2.865874669270856e-18, -1.539961068361938e-19,  7.298544437227164e-21, -3.098006037612083e-22,  1.192011004434868e-23,
 -4.194008076556879e-25,  3.229204157348869e-13, -1.140382715068651e-13,  2.120613190091088e-14, -2.679479801585236e-15,  2.569718795131002e-16, -1.990055372983822e-17,
  1.294680146737118e-18, -7.272421280410190e-20,  3.598651483498871e-21, -1.592975637587507e-22,  6.384677091996051e-24, -2.337295836816498e-25,  1.146908127833452e-13,
 -4.227875822369749e-14,  8.228912465895404e-15, -1.087918624188730e-15,  1.090659477764744e-16, -8.819581151929725e-18,  5.984530734734968e-19, -3.502199125208088e-20,
  1.803502806577776e-21, -8.299219409176652e-23,  3.454377693477548e-24, -1.311842139079082e-25,  4.298662744307243e-14, -1.646733740087722e-14,  3.340150604042974e-15,
 -4.601195652501492e-16,  4.802593570064761e-17, -4.039544724386743e-18,  2.848242625410447e-19, -1.730271218417157e-20,  9.240350770564300e-22, -4.405450636861683e-23,
  1.898017822950636e-24, -7.453596391368303e-26,  1.710743905017854e-14, -6.779612283036493e-15,  1.426627936312149e-15, -2.038751862751057e-16,  2.206186678255049e-17,
 -1.922283148909291e-18,  1.402821244878498e-19, -8.812477902125315e-21,  4.862432134481010e-22, -2.393138554755171e-23,  1.063485143316047e-24, -4.303991707425703e-26,
  7.258632036685769e-15, -2.962207876786414e-15,  6.436554631040849e-16, -9.498762355544343e-17,  1.060922828628394e-17, -9.534555964347339e-19,  7.171410887205242e-20,
 -4.639712781977950e-21,  2.634579287240875e-22, -1.333429800933444e-23,  6.089281125617444e-25, -2.530495702471480e-26,  3.284820073884795e-15, -1.374057160570092e-15,
  3.068137189289742e-16, -4.653448302291994e-17,  5.339563137963614e-18, -4.927116895947551e-19,  3.802763080724186e-20, -2.522974068501396e-21,  1.468200321041619e-22,
 -7.610724964273913e-24,  3.557451910785676e-25, -1.512208909229459e-26,  1.575109753957117e-15, -6.722207337459536e-16,  1.534796165427532e-16, -2.380598232500459e-17,
  2.792685209386005e-18, -2.633427193874094e-19,  2.075987054871337e-20, -1.406088491883956e-21,  8.349044362230684e-23, -4.413761599497016e-24,  2.102990543508442e-25,
 -9.107357906625687e-27,  7.833065595783001e-16, -3.394715764104219e-16,  7.884839058775151e-17, -1.244354069792906e-17,  1.484916368689907e-18, -1.423897562771184e-19,
  1.141027281417923e-20, -7.852865072135366e-22,  4.736150799927435e-23, -2.542153301725106e-24,  1.229328866067244e-25, -5.401081509923832e-27,  3.795600383888908e-16,
 -1.662555448038253e-16,  3.907991034123984e-17, -6.242310946454319e-18,  7.538457755957288e-19, -7.313741400367251e-20,  5.928224714243590e-21, -4.125789391471483e-22,
  2.515569196829705e-23, -1.364667289744154e-24,  6.667941417598326e-26, -2.959219176333686e-27,  1.399383391296537e-16, -6.166014741495065e-17,  1.459070884516268e-17,
 -2.346360372240638e-18,  2.852497160721478e-19, -2.785616709399486e-20,  2.272391251458184e-21, -1.591391142778323e-22,  9.762289026954152e-24, -5.327484678581753e-25,
  2.618199570963112e-26, -1.168512174564688e-27,  6.171233178397399e-02, -1.577062441039161e-04,  4.179370657092768e-07, -1.141565217589880e-09,  3.190224622499303e-12,
 -9.060503077405896e-15,  2.599614025400181e-17, -7.504207234968485e-20,  2.171830811410090e-22, -6.291270817058433e-25,  1.820470342323157e-27, -5.261420045547651e-30,
  5.787715397413769e-02, -1.850662387155628e-04,  7.041861533462219e-07, -2.795760615411529e-09,  1.101282151263700e-11, -4.253146357598291e-14,  1.609838413098265e-16,
 -5.985737149480343e-19,  2.191506965817044e-21, -7.916583663871754e-24,  2.826001370161645e-26, -9.981580729537825e-29,  5.091131184395855e-02, -2.282478449653548e-04,
  1.231359851707539e-06, -6.391262628629984e-09,  3.147694759353939e-11, -1.486742917090208e-13,  6.793542672427293e-16, -3.020694373314096e-18,  1.312293356127010e-20,
 -5.587003091756676e-23,  2.336515216645973e-25, -9.616369981774650e-28,  4.201141182954059e-02, -2.695286089920131e-04,  1.903355843361817e-06, -1.215935725591880e-08,
  7.213863323874901e-11, -4.053059302410176e-13,  2.181046794663962e-15, -1.132486414001397e-17,  5.704301274603792e-20, -2.798491458656023e-22,  1.341419660810635e-24,
 -6.298083400273026e-27,  3.252958174920226e-02, -2.927406871844378e-04,  2.578713716266696e-06, -1.980905134082447e-08,  1.391410829617183e-10, -9.146141710785393e-13,
  5.703167220661844e-15, -3.404747427094372e-17,  1.958977625169975e-19, -1.091739765465393e-21,  5.916124679542068e-24, -3.126889083552071e-26,  2.364287786655190e-02,
 -2.893903404821386e-04,  3.100790223409946e-06, -2.826038918005082e-08,  2.320446118537024e-10, -1.762627537914080e-12,  1.258813416317017e-14, -8.545333403872918e-17,
  5.557430214063999e-19, -3.482952233172586e-21,  2.113110506051933e-23, -1.245518487183422e-25,  1.613718245500950e-02, -2.605425868547214e-04,  3.346428293549569e-06,
 -3.580971292245939e-08,  3.402290569241097e-10, -2.958253507909589e-12,  2.398274938440515e-14, -1.835776008126129e-16,  1.338728726538456e-18, -9.363164273571363e-21,
  6.313225892869315e-23, -4.120388280767853e-25,  1.034905763122669e-02, -2.144740531226090e-04,  3.268346633857230e-06, -4.069976989605787e-08,  4.437407410163706e-10,
 -4.382903885048531e-12,  4.005062371204483e-14, -3.433827616800604e-16,  2.790075594618365e-18, -2.164498852716622e-20,  1.612484912652087e-22, -1.158734973735243e-24,
  6.240348138653513e-03, -1.621572463550013e-04,  2.907047394177471e-06, -4.180104803898246e-08,  5.193648743021397e-10, -5.790718932072195e-12,  5.929503598465878e-14,
 -5.662928667413593e-16,  5.099986685506861e-18, -4.366643324911599e-20,  3.576897036345970e-22, -2.816956466306061e-24,  3.540741740853659e-03, -1.130905187815288e-04,
  2.366858176248142e-06, -3.903057996691984e-08,  5.493479511228367e-10, -6.876952377739548e-12,  7.851609212815107e-14, -8.313956117769899e-16,  8.262390561357132e-18,
 -7.774794011753161e-20,  6.974433662553645e-22, -5.996136333712316e-24,  1.892160640901523e-03, -7.303476688890788e-05,  1.771689114280066e-06, -3.330148934148080e-08,
  5.281867580346826e-10, -7.388973242260292e-12,  9.365854463727295e-14, -1.095140867338808e-15,  1.196415926507902e-17, -1.232800499730962e-19,  1.206876613199179e-21,
 -1.128907445759256e-23,  9.533783742807588e-04, -4.382984508010724e-05,  1.224036357780998e-06, -2.608029581561353e-08,  4.639603551424397e-10, -7.222911322422778e-12,
  1.012554222526271e-13, -1.302782126089557e-15,  1.559356286315870e-17, -1.753892222239043e-19,  1.868109541033364e-21, -1.895658203459311e-23,  4.534740539993201e-04,
 -2.452155534324462e-05,  7.833548815085870e-07, -1.882434579279185e-08,  3.740090537283356e-10, -6.455237296232229e-12,  9.974083398115061e-14, -1.407598454620180e-15,
  1.840430746434455e-17, -2.253187029454177e-19,  2.604082949287656e-21, -2.859231866559164e-23,  2.039081500478106e-04, -1.282877816599732e-05,  4.659776019233960e-07,
 -1.257001322923819e-08,  2.778368036226494e-10, -5.298132483770374e-12,  8.994663474022953e-14, -1.388334142688024e-15,  1.977575749933111e-17, -2.628610472627381e-19,
  3.288434638405457e-21, -3.897719995974334e-23,  8.681892414020267e-05, -6.294522855556889e-06,  2.584966626582286e-07, -7.793615461442503e-09,  1.909429440353967e-10,
 -4.010112767291905e-12,  7.458885703413084e-14, -1.255858545789360e-15,  1.944059823585187e-17, -2.799048238458848e-19,  3.781992317200956e-21, -4.828931778608172e-23,
  3.506645613645643e-05, -2.905063871140882e-06,  1.341703951483607e-07, -4.502723065486437e-09,  1.218621610536983e-10, -2.810282884253172e-12,  5.711666207157733e-14,
 -1.046464102588086e-15,  1.756443810610152e-17, -2.733458963962218e-19,  3.980957189017823e-21, -5.464905936778434e-23,  1.346403318958133e-05, -1.264921152192918e-06,
  6.537523498448673e-08, -2.432699009927166e-09,  7.249568972938026e-11, -1.830644141479002e-12,  4.055285448828496e-14, -8.066416079233123e-16,  1.464894303959655e-17,
 -2.459198341383351e-19,  3.853102062045002e-21, -5.676551304689598e-23,  4.925979262152118e-06, -5.212394736155667e-07,  3.000592461368507e-08, -1.233525282232397e-09,
  4.035265173310019e-11, -1.112799100803287e-12,  2.680422640940210e-14, -5.775837085763790e-16,  1.132610947127657e-17, -2.047182032800929e-19,  3.444605111442528e-21,
 -5.436907382583047e-23,  1.721890757218034e-06, -2.039411859211720e-07,  1.301916960893338e-08, -5.892163333115814e-10,  2.109725584389163e-11, -6.337439472560945e-13,
  1.656061615764987e-14, -3.857759991618823e-16,  8.152735563454934e-18, -1.583737865477069e-19,  2.856876966116862e-21, -4.823210726856222e-23,  5.767970666244297e-07,
 -7.603158329999531e-08,  5.360100785906784e-09, -2.661725894992595e-10,  1.040195076539197e-11, -3.395260935684695e-13,  9.603979126344712e-15, -2.413685315264783e-16,
  5.487069710986052e-18, -1.143579396726123e-19,  2.207923240166421e-21, -3.980876805448816e-23,  1.857873324274029e-07, -2.711155617949055e-08,  2.102395401827181e-09,
 -1.141839615703752e-10,  4.856977031394994e-12, -1.718499764162079e-13,  5.250544677574396e-15, -1.420847447215365e-16,  3.468212695173407e-18, -7.741682590720592e-20,
  1.597209942878058e-21, -3.070714642441209e-23,  5.776090854180964e-08, -9.284953389982960e-09,  7.889961042996969e-10, -4.672072829240218e-11,  2.157325254640943e-12,
 -8.254608159617366e-14,  2.718331965301911e-15, -7.905186577725480e-17,  2.068158413841174e-18, -4.936080481195904e-20,  1.086485366110487e-21, -2.223937294095069e-23,
  1.740685024594737e-08, -3.067805207295670e-09,  2.846237841502529e-10, -1.831998360445371e-11,  9.158588391964992e-13, -3.780834458468336e-14,  1.339130547907208e-15,
 -4.176888710719317e-17,  1.169101412331599e-18, -2.978397442274954e-20,  6.983015142422152e-22, -1.519492727780733e-23,  5.108907847403709e-09, -9.827441866961558e-10,
  9.919495936393866e-11, -6.919235987626095e-12,  3.735238967395614e-13, -1.659724175706761e-14,  6.309183172388889e-16, -2.106537656027913e-17,  6.296520856626079e-19,
 -1.709290255661341e-20,  4.261745209750497e-22, -9.842934490631820e-24,  1.468033908260138e-09, -3.068751862213641e-10,  3.358179728767323e-11, -2.530997665785531e-12,
  1.471516415812157e-13, -7.021193062802504e-15,  2.858302794734862e-16, -1.019527613881057e-17,  3.248242207167791e-19, -9.379538592440766e-21,  2.482774580690459e-22,
 -6.076596628622996e-24,  4.153944568875765e-10, -9.396222923123748e-11,  1.110942273863841e-11, -9.019880321570987e-13,  5.632876317673587e-14, -2.879082468485939e-15,
  1.252407163564770e-16, -4.762478064195542e-18,  1.614203675441191e-19, -4.948959475808882e-21,  1.388346471675176e-22, -3.594866182467045e-24,  1.164839234234743e-10,
 -2.839268739537405e-11,  3.614475623529618e-12, -3.151839021729000e-13,  2.108474728193819e-14, -1.151568974740880e-15,  5.340421494201854e-17, -2.160356674232611e-18,
  7.774048165446305e-20, -2.525758922321669e-21,  7.495660743928808e-23, -2.049719402890976e-24,  3.259628377344907e-11, -8.526073630282359e-12,  1.164611261419787e-12,
 -1.087353783926222e-13,  7.770229775568744e-15, -4.523055255099931e-16,  2.230834842577914e-17, -9.578541370356069e-19,  3.651663741067172e-20, -1.254710345468469e-21,
  3.931460031629485e-23, -1.133257604480097e-24,  9.171320061560243e-12, -2.563562736432812e-12,  3.744001390156221e-13, -3.730957911054391e-14,  2.839743642807580e-15,
 -1.757036714789451e-16,  9.193214026019032e-18, -4.179693128920617e-19,  1.684306957284580e-20, -6.107216057532114e-22,  2.016261869799599e-23, -6.114288280115686e-25,
  2.615511718811830e-12, -7.779955676199324e-13,  1.210481386014724e-13, -1.283245468869718e-14,  1.037154660647810e-15, -6.801637058642964e-17,  3.765187574691188e-18,
 -1.808026322356536e-19,  7.682723453313389e-21, -2.932919922123244e-22,  1.017960082752118e-23, -3.240570194776911e-25,  7.625130774789377e-13, -2.403425437208096e-13,
  3.968981962935329e-14, -4.460756804029967e-15,  3.816165634094042e-16, -2.644577779894344e-17,  1.544456390362797e-18, -7.811843206964909e-20,  3.491144902922415e-21,
 -1.399689677347537e-22,  5.095017868459733e-24, -1.698711697169717e-25,  2.292789261368079e-13, -7.624917522350195e-14,  1.331276956753962e-14, -1.580566199622390e-15,
  1.426415075931746e-16, -1.041216477998519e-17,  6.395574671248991e-19, -3.397412818208742e-20,  1.592388958784800e-21, -6.686832961432037e-23,  2.546172283923266e-24,
 -8.868526912111013e-26,  7.175392554884588e-14, -2.506653808807668e-14,  4.608493020108813e-15, -5.757997994928413e-16,  5.462088460857801e-17, -4.185358252382268e-18,
  2.695054424448526e-19, -1.498861482659875e-20,  7.345723063010528e-22, -3.221406823488567e-23,  1.279501833042188e-24, -4.643091804193408e-26,  2.358261657361665e-14,
 -8.615309693264959e-15,  1.660866465028049e-15, -2.175087830269651e-16,  2.160521290140738e-17, -1.731496522076584e-18,  1.164731387518761e-19, -6.758875058007518e-21,
  3.452237957818506e-22, -1.576085515653699e-23,  6.509910814237799e-25, -2.453896517006580e-26,  8.209036322665483e-15, -3.121875507420637e-15,  6.282932638833919e-16,
 -8.588086392625580e-17,  8.896264418601320e-18, -7.427818913865150e-19,  5.199924244773791e-20, -3.137030602241584e-21,  1.664058717670577e-22, -7.881960773529868e-24,
  3.374371555410046e-25, -1.317027973583523e-26,  3.049043518347042e-15, -1.201458149969144e-15,  2.512667580730123e-16, -3.568787300982455e-17,  3.838724002937874e-18,
 -3.325213479190248e-19,  2.412874372071496e-20, -1.507416556942649e-21,  8.272997440771405e-23, -4.050610317567230e-24,  1.790994412843536e-25, -7.212969488556012e-27,
  1.214894118115271e-15, -4.936823892439840e-16,  1.067733581826879e-16, -1.568398665389076e-17,  1.743784107182515e-18, -1.560196361620213e-19,  1.168441293555755e-20,
 -7.527849382618640e-22,  4.257178479216437e-23, -2.146166369091611e-24,  9.763200453762646e-26, -4.042197377612933e-27,  5.201690179826658e-16, -2.169350088609756e-16,
  4.827907996434216e-17, -7.298210206299172e-18,  8.347000937924773e-19, -7.677775464913469e-20,  5.907406840699878e-21, -3.907538610595857e-22,  2.267284905300477e-23,
 -1.171962426430564e-24,  5.462974191864490e-26, -2.316017986878236e-27,  2.380509274948671e-16, -1.013950058367488e-16,  2.309976261534440e-17, -3.575124546496508e-18,
  4.184956683751139e-19, -3.938002033096679e-20,  3.098051672867535e-21, -2.094162287906855e-22,  1.241058443110407e-23, -6.548559571524164e-25,  3.114431173656222e-26,
 -1.346365158239371e-27,  1.140967672801634e-16, -4.939078554166980e-17,  1.145718971314749e-17, -1.805793793568054e-18,  2.152153508385019e-19, -2.061147216523326e-20,
  1.649675717029957e-21, -1.134009359401299e-22,  6.831461388904510e-24, -3.662712696917217e-25,  1.769274998510366e-26, -7.765120921514694e-28,  5.385919510761593e-17,
 -2.357799117582883e-17,  5.538659799147610e-18, -8.841256441849466e-19,  1.067018008851370e-19, -1.034557658378544e-20,  8.380531222267995e-22, -5.828971388114551e-23,
  3.551937691413939e-24, -1.925777963969336e-25,  9.404324588288508e-27, -4.171343625945230e-28,  1.956595254202488e-17, -8.619078233619793e-18,  2.038966742259181e-18,
 -3.277960416222301e-19,  3.983914241461041e-20, -3.889406639601592e-21,  3.171934153080956e-22, -2.220746757094796e-23,  1.361936463013571e-24, -7.430405774369268e-26,
  3.650734421803557e-27, -1.628921835230364e-28,  6.108810824881531e-02, -1.544166885228045e-04,  4.045386726190667e-07, -1.091938105690013e-09,  3.015087410898906e-12,
 -8.461044949396970e-15,  2.398895305040520e-17, -6.844097724258484e-20,  1.957913452764705e-22, -5.607319274234709e-25,  1.604211096652620e-27, -4.585138254396898e-30,
  5.714794766529682e-02, -1.795640138225743e-04,  6.716668508221817e-07, -2.626156141601051e-09,  1.019951066299230e-11, -3.886130340821983e-14,  1.451642349486738e-16,
 -5.327955812240663e-19,  1.925842024967890e-21, -6.869304724206968e-24,  2.421561294883386e-26, -8.447384660892291e-29,  5.001754828204930e-02, -2.186954053969408e-04,
  1.157591155123015e-06, -5.910561402310511e-09,  2.865989343208811e-11, -1.333390860379467e-13,  6.003639269559033e-16, -2.631217426781190e-18,  1.127012551080179e-20,
 -4.731787769082392e-23,  1.951870274554324e-25, -7.925140576912942e-28,  4.096285388755792e-02, -2.548663877929369e-04,  1.764110290007404e-06, -1.106724820531770e-08,
  6.453130889665184e-11, -3.565686456279068e-13,  1.888062133585581e-15, -9.650843546885298e-18,  4.787104121712061e-20, -2.313479109188573e-22,  1.092678823438368e-24,
 -5.056196272811645e-27,  3.139842458827379e-02, -2.730253089994331e-04,  2.353782233019204e-06, -1.772200718794545e-08,  1.221438525725510e-10, -7.885044897622263e-13,
  4.832002325306984e-15, -2.836447598511404e-17,  1.605428811946808e-19, -8.804724027781214e-22,  4.696888665367046e-24, -2.444478700358222e-26,  2.253286706103053e-02,
 -2.658799776852748e-04,  2.782829535186260e-06, -2.481405965933937e-08,  1.996293196362059e-10, -1.487325350724803e-12,  1.042666776162882e-14, -6.952274962309897e-17,
  4.443371764937741e-19, -2.737909890000592e-21,  1.633778390091264e-23, -9.474733709540718e-26,  1.514595838749308e-02, -2.354017861228430e-04,  2.947518009825646e-06,
 -3.080975945849524e-08,  2.864272498609704e-10, -2.439803623786237e-12,  1.939493333875057e-14, -1.456774538485732e-16,  1.043055835273675e-18, -7.166375090273978e-21,
  4.748759076691177e-23, -3.047098260590444e-25,  9.540523803944011e-03, -1.901665097534236e-04,  2.819816449111182e-06, -3.425205294339624e-08,  3.649652609981428e-10,
 -3.527654452805285e-12,  3.157704687819515e-14, -2.654163211725268e-16,  2.115634448384825e-18, -1.611026127036050e-20,  1.178619637690282e-22, -8.321130626081806e-25,
  5.635243465093756e-03, -1.407743752864063e-04,  2.451708462941389e-06, -3.434548135379411e-08,  4.165864379859019e-10, -4.540830400266883e-12,  4.550567412821066e-14,
 -4.257092620662581e-16,  3.758213083430108e-18, -3.156231618572622e-20,  2.537284783289687e-22, -1.961961601344448e-24,  3.123481033152186e-03, -9.588952356807468e-05,
  1.947001082399572e-06, -3.124634884044965e-08,  4.289112554446733e-10, -5.244444040742616e-12,  5.855338631563572e-14, -6.068746060715582e-16,  5.907917743151852e-18,
 -5.449349968563339e-20,  4.794502362906658e-22, -4.044901630383237e-24,  1.626026642169390e-03, -6.032654520152680e-05,  1.418269340828809e-06, -2.592030301776906e-08,
  4.006088889122265e-10, -5.469663349777318e-12,  6.774854526608011e-14, -7.748721272646818e-16,  8.287245939083065e-18, -8.365602198546058e-20,  8.028090964583598e-22,
 -7.365317326093862e-24,  7.958261694019585e-04, -3.517338988917198e-05,  9.512419842094873e-07, -1.969201686100551e-08,  3.411171309992229e-10, -5.179485895764961e-12,
  7.090831599917737e-14, -8.918784743518795e-16,  1.044509558411903e-17, -1.150344055135582e-19,  1.200517621674601e-21, -1.194318815366659e-23,  3.666225323681818e-04,
 -1.906558336205054e-05,  5.894945215319171e-07, -1.375526926250545e-08,  2.659642433812776e-10, -4.474693205082070e-12,  6.748401156894403e-14, -9.305692394334669e-16,
  1.189936743985800e-17, -1.425851631306163e-19,  1.613990473073284e-21, -1.736718921886313e-23,  1.591903155798868e-04, -9.636098265071407e-06,  3.386596995929365e-07,
 -8.867069249610637e-09,  1.906481260051485e-10, -3.542297244132092e-12,  5.867346392911038e-14, -8.845469621994730e-16,  1.231780930127327e-17, -1.601950705279191e-19,
  1.962192647090548e-21, -2.278599465965110e-23,  6.525047967112431e-05, -4.554224675590989e-06,  1.809423248282902e-07, -5.293683325695489e-09,  1.261210177257240e-10,
 -2.580012821915117e-12,  4.680567927509667e-14, -7.694955315243532e-16,  1.164197520413234e-17, -1.639594134359382e-19,  2.168556898363111e-21, -2.712123489332665e-23,
  2.529243761224499e-05, -2.018517840041790e-06,  9.019825602536745e-08, -2.937019801111003e-09,  7.728443784236695e-11, -1.735681989893336e-12,  3.439974734099005e-14,
 -6.152794386181814e-16,  1.009143740256364e-17, -1.535906216563213e-19,  2.189244817921871e-21, -2.943302411567787e-23,  9.290027458898666e-06, -8.414436015367287e-07,
  4.208660574526900e-08, -1.519611544673249e-09,  4.402859168471920e-11, -1.082663119050293e-12,  2.338544886567922e-14, -4.540681388520205e-16,  8.057101470293548e-18,
 -1.322706820757556e-19,  2.028164075856435e-21, -2.926140042175339e-23,  3.240889615653719e-06, -3.309143213043146e-07,  1.844282600312515e-08, -7.358184816496046e-10,
  2.340561226177891e-11, -6.285739725425392e-13,  1.476355815020857e-14, -3.105463027353900e-16,  5.950174155477107e-18, -1.051739705518337e-19,  1.731891257347765e-21,
 -2.677075955491260e-23,  1.076640426915591e-06, -1.231710406901126e-07,  7.616700158487018e-09, -3.346668985288318e-10,  1.165456003070662e-11, -3.410012089661500e-13,
  8.690239135515395e-15, -1.976377961073024e-16,  4.081562105375712e-18, -7.754565238089465e-20,  1.369122960717554e-21, -2.263929744326214e-23,  3.416072985695023e-07,
 -4.354255633672014e-08,  2.975582410209009e-09, -1.435261671733810e-10,  5.457333935986003e-12, -1.735591652503371e-13,  4.789127488855176e-15, -1.175359846030960e-16,
  2.611659015311186e-18, -5.324587060585363e-20,  1.006398137543291e-21, -1.777578269874983e-23,  1.038709609230184e-07, -1.467475647139446e-08,  1.103998087963721e-09,
 -5.827775185781636e-11,  2.413163460019516e-12, -8.322840773511617e-14,  2.481580141699625e-15, -6.560130289989149e-17,  1.565676722121009e-18, -3.419900916951726e-20,
  6.909385255343078e-22, -1.301700112948334e-23,  3.038227646089173e-08, -4.734482218095568e-09,  3.906794142345051e-10, -2.250263942862497e-11,  1.012152593280698e-12,
 -3.777264440134844e-14,  1.214535588752919e-15, -3.451981575457058e-17,  8.834178232964429e-19, -2.064103253827720e-20,  4.450923212514196e-22, -8.931320537211173e-24,
  8.585419228182139e-09, -1.468888301721646e-09,  1.324817023294920e-10, -8.301957514846981e-12,  4.046055045295000e-13, -1.630222549488697e-14,  5.641417215223532e-16,
 -1.720784174146944e-17,  4.714072573532753e-19, -1.176322564147056e-20,  2.703257662506690e-22, -5.769349460992148e-24,  2.355052032420343e-09, -4.404434459470687e-10,
  4.327005690248936e-11, -2.941548000257774e-12,  1.549466721017487e-13, -6.725383859039627e-15,  2.499734312829776e-16, -8.167894313022295e-18,  2.391151488087813e-19,
 -6.362141276747580e-21,  1.555771862886845e-22, -3.526374609223597e-24,  6.304726951478946e-10, -1.283422265073271e-10,  1.368787932076478e-11, -1.006579719046973e-12,
  5.716386313641124e-14, -2.666865253382181e-15,  1.062490990537385e-16, -3.711935092414464e-18,  1.159206522369401e-19, -3.283257885685777e-21,  8.529998785967125e-23,
 -2.050332979511486e-24,  1.657112450494396e-10, -3.656477889282311e-11,  4.219405588151216e-12, -3.346894344930119e-13,  2.043993282155377e-14, -1.022603416756233e-15,
  4.357783885793577e-17, -1.624625264786139e-18,  5.402379026971117e-20, -1.626036143233296e-21,  4.480910957306785e-23, -1.140395532463499e-24,  4.304573383070950e-11,
 -1.025336916952532e-11,  1.275932672599826e-12, -1.088517683262184e-13,  7.130296124239939e-15, -3.816409670844383e-16,  1.735796816856325e-17, -6.891514941998595e-19,
  2.435495147818120e-20, -7.775841199605879e-22,  2.268963347617000e-23, -6.103973869310048e-25,  1.113173874212933e-11, -2.850687577423157e-12,  3.812578626228627e-13,
 -3.487803858372003e-14,  2.443942262314451e-15, -1.396001052599190e-16,  6.761133328661375e-18, -2.852535039809190e-19,  1.069213005729698e-20, -3.614129993155621e-22,
  1.114629016701721e-23, -3.164061610316688e-25,  2.888722072607415e-12, -7.920616352099471e-13,  1.134595243907982e-13, -1.109596944561851e-14,  8.293777311117175e-16,
 -5.042741755870038e-17,  2.594396456015234e-18, -1.160515538156798e-19,  4.603671222429039e-21, -1.644095930949073e-22,  5.348629997547608e-24, -1.599044558836719e-25,
  7.587493252664529e-13, -2.218265204384029e-13,  3.391317582383744e-14, -3.534214899242687e-15,  2.809610902184042e-16, -1.813361383917557e-17,  9.884744028045250e-19,
 -4.676478526368939e-20,  1.958753121725568e-21, -7.374250084412725e-23,  2.525184646811270e-24, -7.934477648514181e-26,  2.035831589237290e-13, -6.319493847572978e-14,
  1.027335706760011e-14, -1.137041971073350e-15,  9.583789696121428e-17, -6.546710717772036e-18,  3.770584133283161e-19, -1.881712136845402e-20,  8.300893889122974e-22,
 -3.286449087374387e-23,  1.181817829609457e-24, -3.894085376609281e-26,  5.634474088328198e-14, -1.849021417164642e-14,  3.184038954423112e-15, -3.729399214437137e-16,
  3.321693558743189e-17, -2.394000562388432e-18,  1.452487624636030e-19, -7.624383140634590e-21,  3.532607769880659e-22, -1.466949563498036e-23,  5.525631849015307e-25,
 -1.904570883637448e-26,  1.624764209318865e-14, -5.611810926459502e-15,  1.019517886166613e-15, -1.258965474411683e-16,  1.180716803865918e-17, -8.947792278434902e-19,
  5.700316171973514e-20, -3.137537811107049e-21,  1.522300721054395e-22, -6.611290901938774e-24,  2.601277891424123e-25, -9.353853602551321e-27,  4.930977445665585e-15,
 -1.784412471889747e-15,  3.405647773375201e-16, -4.416050169984629e-17,  4.344270203143614e-18, -3.449087308650186e-19,  2.299100053629836e-20, -1.322449224851928e-21,
  6.697255342569005e-23, -3.032368627975287e-24,  1.242490954682583e-25, -4.647323094632932e-27,  1.590400433874936e-15, -6.001940176538745e-16,  1.198028330090369e-16,
 -1.624276071184031e-17,  1.669217934885451e-18, -1.382948407327465e-19,  9.609071119402514e-21, -5.754959286211837e-22,  3.031293709885489e-23, -1.426011416866002e-24,
  6.064583903894036e-26, -2.351880769668588e-27,  5.499323921602507e-16, -2.153970017028283e-16,  4.475494520348714e-17, -6.315625336586546e-18,  6.750461727797650e-19,
 -5.811541744191079e-20,  4.191886416561267e-21, -2.603685891489069e-22,  1.420936300355411e-23, -6.919300901136100e-25,  3.043246479074733e-26, -1.219360209599673e-27,
  2.052500043582336e-16, -8.302954602169212e-17,  1.786943646785264e-17, -2.611992582359590e-18,  2.890138710733314e-19, -2.573771423807946e-20,  1.918756494955638e-21,
 -1.230733289764152e-22,  6.930296352898144e-24, -3.479249827008746e-25,  1.576377924712968e-26, -6.501112538790829e-28,  8.294138680616983e-17, -3.448023239587139e-17,
  7.646715535027497e-18, -1.151878391141805e-18,  1.312875058025885e-19, -1.203561451070334e-20,  9.230170185457784e-22, -6.086065253817522e-23,  3.520464566986164e-24,
 -1.814292281803992e-25,  8.432578742592513e-27, -3.564929364726897e-28,  3.614553282725117e-17, -1.536368384278320e-17,  3.492065718017774e-18, -5.392109461912724e-19,
  6.297500820346915e-20, -5.912707629818056e-21,  4.641495041987897e-22, -3.130865370220049e-23,  1.851641825126581e-24, -9.750941922089283e-26,  4.628499779814211e-27,
 -1.997152813605447e-28,  1.666597074617280e-17, -7.205672475902700e-18,  1.669232699258832e-18, -2.627322680127271e-19,  3.127043447028226e-20, -2.990873233678761e-21,
  2.390728118725730e-22, -1.641366407012577e-23,  9.875849281042455e-25, -5.288713227254734e-26,  2.551778011148331e-27, -1.118693748496011e-28,  7.653427371693579e-18,
 -3.348424881308242e-18,  7.860384808307938e-19, -1.253878490272192e-19,  1.512234286820241e-20, -1.465256027420190e-21,  1.186173544309064e-22, -8.245046611033930e-24,
  5.021086525326487e-25, -2.720672997524416e-26,  1.327828460407012e-27, -5.886289176587883e-29,  2.737378259949004e-18, -1.205541546188025e-18,  2.851044626135960e-19,
 -4.582134254126060e-20,  5.567303849160132e-21, -5.433638038597393e-22,  4.430021950139579e-23, -3.100681954548114e-24,  1.901050561944376e-25, -1.036883968339562e-26,
  5.093083922972948e-28, -2.271884594465514e-29,  6.047683226727972e-02, -1.512319847278872e-04,  3.917193790317670e-07, -1.045019831768059e-09,  2.851472217886319e-12,
 -7.907616482019004e-15,  2.215737159240967e-17, -6.248663511726006e-20,  1.767130384405531e-22, -5.004204827169936e-25,  1.415607385675714e-27, -4.001913967243521e-30,
  5.644024253200604e-02, -1.743140181079263e-04,  6.411070812963624e-07, -2.468997435164572e-09,  9.455950675104116e-12, -3.554963923239715e-14,  1.310728511243776e-16,
 -4.749454422006694e-19,  1.695122753340545e-21, -5.971072627396998e-24,  2.078944674359425e-26, -7.163568230730152e-29,  4.916084966072339e-02, -2.097107853228342e-04,
  1.089330233484028e-06, -5.472578822244600e-09,  2.613143558047947e-11, -1.197752098219557e-13,  5.314931317064371e-16, -2.296387281595074e-18,  9.699204234317107e-21,
 -4.016522523371353e-23,  1.634478418881135e-25, -6.548088162993829e-28,  3.997079707522964e-02, -2.412677073032145e-04,  1.637270713315987e-06, -1.008942507065798e-08,
  5.783204580552463e-11, -3.143321405647323e-13,  1.638090398669223e-15, -8.244207635618076e-18,  4.027844883450009e-20, -1.917838828952969e-22,  8.926856692074313e-25,
 -4.071822702404863e-27,  3.034268236851601e-02, -2.550136432419669e-04,  2.152343240557305e-06, -1.588782528240200e-08,  1.074719932042125e-10, -6.815144166993031e-13,
  4.105201920801985e-15, -2.369999907401543e-17,  1.319836146683079e-19, -7.124597019548058e-22,  3.742044814432814e-24, -1.918055702175303e-26,  2.151206033877909e-02,
 -2.447562926647367e-04,  2.503285900174383e-06, -2.184500029991577e-08,  1.722354683848526e-10, -1.258925003429978e-12,  8.665130393074381e-15, -5.676259151362589e-17,
  3.565959576889348e-19, -2.160728129038693e-21,  1.268395017924764e-23, -7.238567148541284e-26,  1.424927528704114e-02, -2.132261530938446e-04,  2.603765933693759e-06,
 -2.659332296892186e-08,  2.419740916974181e-10, -2.019727054519465e-12,  1.574693857909416e-14, -1.160855973972555e-16,  8.162556294725410e-19, -5.510189117344449e-21,
  3.589070793437067e-23, -2.264580664472451e-25,  8.822505071666258e-03, -1.691579126733987e-04,  2.441627021310612e-06, -2.893825269648309e-08,  3.014260749027666e-10,
 -2.851840126820960e-12,  2.501210017482499e-14, -2.061527128839794e-16,  1.612385054303791e-18, -1.205419953934413e-20,  8.662150719842348e-23, -6.009451439143730e-25,
  5.108914374373388e-03, -1.227025148872842e-04,  2.076739739646750e-06, -2.835111285853565e-08,  3.357917036546285e-10, -3.579126656071736e-12,  3.511172378379170e-14,
 -3.218247851884943e-16,  2.785598009383659e-18, -2.295096028012405e-20,  1.811028578471067e-22, -1.375223463727990e-24,  2.768855017418866e-03, -8.170417848157688e-05,
  1.609991464314632e-06, -2.515194126492686e-08,  3.368019664151239e-10, -4.023398080014371e-12,  4.393722684548674e-14, -4.458303255722417e-16,  4.252361431782210e-18,
 -3.845484594782812e-20,  3.319010180405445e-22, -2.748219351501522e-24,  1.405586381221292e-03, -5.012337387596215e-05,  1.142341418262156e-06, -2.030423405569363e-08,
  3.058616855098962e-10, -4.076664509739455e-12,  4.935283324265690e-14, -5.522513955245770e-16,  5.783197638425059e-18, -5.720191963507625e-20,  5.382033497559853e-22,
 -4.843749805234886e-24,  6.689772060317953e-04, -2.842319860326794e-05,  7.445444179877219e-07, -1.497825317323418e-08,  2.527027183377331e-10, -3.743106949619330e-12,
  5.005311916227991e-14, -6.155662996599596e-16,  7.054907153092027e-18, -7.609174580181264e-20,  7.781970429856766e-22, -7.591054998144535e-24,  2.988405438562511e-04,
 -1.494380868610643e-05,  4.472731460063404e-07, -1.013593466757520e-08,  1.907597704196622e-10, -3.129051964512666e-12,  4.606818333323886e-14, -6.208146994114492e-16,
  7.764970833456527e-18, -9.108109486003695e-20,  1.009918535315920e-21, -1.065144483317317e-23,  1.254572693684405e-04, -7.305509686699348e-06,  2.484457905696361e-07,
 -6.314639421518905e-09,  1.320870693561029e-10, -2.391632737336571e-12,  3.865515893914556e-14, -5.692679003940332e-16,  7.751051658648382e-18, -9.864032355065808e-20,
  1.183122681840143e-21, -1.346207216209021e-23,  4.957005691996705e-05, -3.330036560813903e-06,  1.280023070725403e-07, -3.634147102065866e-09,  8.420533709924831e-11,
 -1.678038183206575e-12,  2.969512782472548e-14, -4.767387594414312e-16,  7.050152206079092e-18, -9.713178532476902e-20,  1.257658039259636e-21, -1.540813274442224e-23,
  1.846485834424775e-05, -1.419260801818231e-06,  6.135852291887545e-08, -1.938581553239788e-09,  4.960020653969259e-11, -1.084893429653153e-12,  2.096890081769793e-14,
 -3.661681033785836e-16,  5.868995768154220e-18, -8.736552560194376e-20,  1.218862237359867e-21, -1.604979125907567e-23,  6.497111314305826e-06, -5.671833716418793e-07,
  2.745157232753717e-08, -9.617354245423607e-10,  2.709176535308438e-11, -6.487414756758110e-13,  1.366382190626289e-14, -2.589877108227721e-16,  4.490405856150439e-18,
 -7.209158272651299e-20,  1.081839951500420e-21, -1.528581818096339e-23,  2.164264799293452e-06, -2.131682773949341e-07,  1.150021026506360e-08, -4.452586733299945e-10,
  1.377099205098049e-11, -3.601482966950160e-13,  8.248178957478784e-15, -1.693614479616829e-16,  3.170698641039187e-18, -5.480714859166246e-20,  8.832430314474638e-22,
 -1.337054530775380e-23,  6.842632808660238e-07, -7.558447546388667e-08,  4.526614892005803e-09, -1.930677145710221e-10,  6.538516347671991e-12, -1.863276961161944e-13,
  4.630626220445512e-15, -1.028101009217050e-16,  2.074731514367260e-18, -3.855028959325760e-20,  6.661536091684299e-22, -1.078838262141214e-23,  2.059312807043147e-07,
 -2.537093107721156e-08,  1.680159831127296e-09, -7.870253477872613e-11,  2.911162078797672e-12, -9.019557294038120e-14,  2.427597893169208e-15, -5.817470619058220e-17,
  1.263362367208846e-18, -2.519454075308929e-20,  4.661484802703338e-22, -8.065224785268123e-24,  5.918980236327638e-08, -8.091938962454506e-09,  5.903905862261893e-10,
 -3.028326364704978e-11,  1.220437343556560e-12, -4.102245789777850e-14,  1.193466131987789e-15, -3.081572754083540e-17,  7.190116029513473e-19, -1.536652551597660e-20,
  3.039838378582654e-22, -5.611358805408442e-24,  1.630920592217692e-08, -2.462418327497820e-09,  1.972380507834421e-10, -1.104694576709096e-11,  4.838859323198557e-13,
 -1.760847215814908e-14,  5.526994526988574e-16, -1.535012047949878e-17,  3.842003810374037e-19, -8.786525596721759e-21,  1.855855525211011e-22, -3.650152035179915e-24,
  4.326482381829057e-09, -7.181800862915852e-10,  6.294039905988534e-11, -3.838500847470665e-12,  1.823136095417524e-13, -7.167441634818755e-15,  2.422687119009993e-16,
 -7.225012992468350e-18,  1.936784246875770e-19, -4.732810560565186e-21,  1.065843925185324e-22, -2.230659942441784e-24,  1.110325875211922e-09, -2.017677493291865e-10,
  1.928331553255738e-11, -1.277041146516870e-12,  6.561353681882103e-14, -2.780979413348495e-15,  1.010366040690044e-16, -3.229904540969231e-18,  9.258375111596598e-20,
 -2.413799504169156e-21,  5.787745456871404e-23, -1.287171994846662e-24,  2.771677900390675e-10, -5.490898940681928e-11,  5.704274011308686e-12, -4.091017496612911e-13,
  2.268404623725375e-14, -1.034345583177963e-15,  4.031452167091387e-17, -1.379038043830924e-18,  4.219992164628423e-20, -1.172028416836897e-21,  2.987773550460922e-23,
 -7.051118519082105e-25,  6.771184557037693e-11, -1.456472491771532e-11,  1.639422569543721e-12, -1.269814820977018e-13,  7.580250356101350e-15, -3.710470438184568e-16,
  1.548393310053762e-17, -5.657265758971151e-19,  1.844980612834035e-20, -5.449808407210424e-22,  1.474792721832343e-23, -3.688007308559381e-25,  1.629970153397717e-11,
 -3.791514215803483e-12,  4.609290116215684e-13, -3.844977573551120e-14,  2.464995425220544e-15, -1.292372485326525e-16,  5.762372467926928e-18, -2.244427161784694e-19,
  7.786833127086648e-21, -2.442174319737019e-22,  7.004325012920960e-24, -1.853130188223283e-25,  3.895643288891588e-12, -9.760424804279474e-13,  1.277334600000446e-13,
 -1.144283996831701e-14,  7.858135975511373e-16, -4.402479009018810e-17,  2.092803113309791e-18, -8.672206210853141e-20,  3.194659463869456e-21, -1.061889535151750e-22,
  3.222241260159399e-24, -9.004406603625932e-26,  9.321652047444767e-13, -2.505452544129052e-13,  3.517902715949546e-14, -3.374383921436693e-15,  2.475560019938460e-16,
 -1.478354211936255e-17,  7.475181742031487e-19, -3.288330633451892e-20,  1.283560969719311e-21, -4.512944295544890e-23,  1.446154377105515e-24, -4.260751499994861e-26,
  2.253658947019188e-13, -6.471486408680756e-14,  9.715387008847813e-15, -9.947242456386225e-16,  7.773851131429310e-17, -4.935340125466164e-18,  2.647844249327122e-19,
 -1.233611267280201e-20,  5.090915286075812e-22, -1.889305615739263e-23,  6.380357407755093e-25, -1.978037853113075e-26,  5.559733157533512e-14, -1.698517852692131e-14,
  2.716537412539345e-15, -2.959129030957412e-16,  2.456010287124070e-17, -1.652907993728471e-18,  9.383987166182870e-20, -4.618444985080969e-21,  2.010161873512137e-22,
 -7.855716609817768e-24,  2.789595810119977e-25, -9.080429932693566e-27,  1.414364083116210e-14, -4.577244290966184e-15,  7.769445597547793e-16, -8.972758098022843e-17,
  7.883254609460387e-18, -5.606895904276896e-19,  3.358561283604157e-20, -1.741291100259787e-21,  7.971918446302409e-23, -3.272275287830355e-24,  1.218827107804504e-25,
 -4.155676324401777e-27,  3.751387384732079e-15, -1.280349783359003e-15,  2.297270270618333e-16, -2.802283615547231e-17,  2.597011011513008e-18, -1.945517473944239e-19,
  1.225661297317896e-20, -6.673738659539374e-22,  3.204347595686530e-23, -1.377615543264678e-24,  5.367453129793662e-26, -1.911835995810408e-27,  1.049112475638030e-15,
 -3.758852694195661e-16,  7.098851152390772e-17, -9.109822428739193e-18,  8.871516229254286e-19, -6.974642768743067e-20,  4.605169797676027e-21, -2.624624894711334e-22,
  1.317381682422995e-23, -5.913497021392516e-25,  2.402809218514671e-26, -8.914787410046074e-28,  3.127805442331109e-16, -1.170860961413588e-16,  2.316992268744754e-17,
 -3.114561236168618e-18,  3.174093104644515e-19, -2.608474307356670e-20,  1.798221145864455e-21, -1.068786206440974e-22,  5.588127375452801e-24, -2.610058000795175e-25,
  1.102332014896870e-26, -4.246284218371301e-28,  1.004300668404484e-16, -3.908687368450296e-17,  8.065908602392929e-18, -1.130493322076827e-18,  1.200303218003696e-19,
 -1.026678773720629e-20,  7.359047949990141e-22, -4.543101099473805e-23,  2.464739304194834e-24, -1.193354637074293e-25,  5.219524751531237e-27, -2.080131163774342e-28,
  3.501838034678449e-17, -1.409842053589339e-17,  3.018491225584618e-18, -4.389338521187184e-19,  4.832153266486550e-20, -4.281986476226128e-21,  3.176948515344140e-22,
 -2.028295066487330e-23,  1.136989964372057e-24, -5.683124471697159e-26,  2.563986948042977e-27, -1.053068821847945e-28,  1.332156145523909e-17, -5.519300351471383e-18,
  1.219479578770626e-18, -1.830172671184631e-19,  2.078383179432018e-20, -1.898573791700334e-21,  1.451005151097705e-22, -9.535409921916029e-24,  5.497802909390069e-25,
 -2.824390472570964e-26,  1.308720232851708e-27, -5.516314044617022e-29,  5.515442481054457e-18, -2.339159265438301e-18,  5.303747925875387e-19, -8.169439491728811e-20,
  9.518173025332450e-21, -8.915566149088274e-22,  6.982727531686929e-23, -4.699636682896576e-24,  2.773430697402800e-25, -1.457452883835974e-26,  6.904023454126264e-28,
 -2.973140001160280e-29,  2.441594122615964e-18, -1.054282095694567e-18,  2.438790185993241e-19, -3.833033908827181e-20,  4.555590108981709e-21, -4.351151249767270e-22,
  3.473339295958333e-23, -2.381492370587802e-24,  1.431068637445456e-25, -7.654094711092297e-27,  3.688583122028014e-28, -1.615164880623079e-29,  1.089186215573916e-18,
 -4.762223211649483e-19,  1.117125956542879e-19, -1.780737638998815e-20,  2.146117973321384e-21, -2.077993234291262e-22,  1.681054597346815e-23, -1.167714846658023e-24,
  7.106547218185055e-26, -3.848235154646998e-27,  1.876974890063322e-28, -8.315661940653320e-30,  3.832209179756617e-19, -1.687249836887526e-19,  3.989040639265767e-20,
 -6.409101837574163e-21,  7.784664396272447e-22, -7.595440607196183e-23,  6.190668189987161e-24, -4.331721194665824e-25,  2.655038771190113e-26, -1.447716717241236e-27,
  7.109069768308555e-29, -3.170292470546730e-30,  5.987809349627685e-02, -1.481476268818818e-04,  3.794477553511416e-07, -1.000633185292377e-09,  2.698499170911578e-12,
 -7.396212342477054e-15,  2.048428094071502e-17, -5.710946671681603e-20,  1.596761105607431e-22, -4.471642473087403e-25,  1.250872128482563e-27, -3.498151433183810e-30,
  5.575306009028555e-02, -1.693011542628707e-04,  6.123639621347763e-07, -2.323223661333454e-09,  8.775369054481017e-12, -3.255753594275109e-14,  1.185025878231940e-16,
 -4.239863220500735e-19,  1.494403269424594e-21, -5.199227931542126e-24,  1.788115998575835e-26, -6.086963782259474e-29,  4.833902968716178e-02, -2.012518971494927e-04,
  1.026091040570203e-06, -5.072968066778457e-09,  2.385845727837831e-11, -1.077571807643691e-13,  4.713308373078053e-16, -2.007940341629924e-18,  8.364314349576699e-21,
 -3.416879916070568e-23,  1.371917251947049e-25, -5.423842464691735e-28,  3.903117737572739e-02, -2.286385679698593e-04,  1.521548740632545e-06, -9.212345354229863e-09,
  5.192057334937760e-11, -2.776485194030529e-13,  1.424306572509582e-15, -7.059208865676761e-18,  3.397602524529139e-20, -1.594162494743140e-22,  7.313922806712708e-25,
 -3.289042075757207e-27,  2.935589775865132e-02, -2.385292827578630e-04,  1.971573592916786e-06, -1.427217984584878e-08,  9.477557130920433e-11, -5.904982233871078e-13,
  3.497071559931631e-15, -1.985958451182682e-17,  1.088376992446158e-19, -5.783813402735436e-22,  2.991531051187288e-24, -1.510414066835781e-26,  2.057149122734593e-02,
 -2.257335601770603e-04,  2.256884789944401e-06, -1.927987954472016e-08,  1.490142333891799e-10, -1.068813175553744e-12,  7.224502605428845e-15, -4.650408545679000e-17,
  2.872235614677980e-19, -1.711763478770859e-21,  9.886858069754502e-24, -5.553382889344362e-26,  1.343609886918638e-02, -1.936096300297859e-04,  2.306606169362292e-06,
 -2.302541410890951e-08,  2.051100447034081e-10, -1.678027555596230e-12,  1.283427127961181e-14, -9.288058612106407e-17,  6.414966205522823e-19, -4.255672043776149e-21,
  2.725212532422556e-23, -1.691158779121924e-25,  8.182850434169659e-03, -1.509360769691768e-04,  2.121523208087385e-06, -2.454097672831469e-08,  2.499531359070393e-10,
 -2.315364932846070e-12,  1.990141943751787e-14, -1.608793877133680e-16,  1.234914449321710e-18, -9.065675634211294e-21,  6.400093086826428e-23, -4.363903040822637e-25,
  4.649299594529631e-03, -1.073632723571611e-04,  1.766540521774783e-06, -2.350821203788856e-08,  2.719550762595523e-10, -2.835221926352356e-12,  2.723368917217036e-14,
 -2.446176327682729e-16,  2.076380181550507e-18, -1.678686728579853e-20,  1.300468855158580e-22, -9.699582619259389e-25,  2.466008332929963e-03, -6.994569314425526e-05,
  1.338020341019804e-06, -2.035354254097485e-08,  2.659421517851852e-10, -3.104520173026928e-12,  3.316790176397549e-14, -3.295616762575047e-16,  3.080417500023718e-18,
 -2.731645434905267e-20,  2.313236661364071e-22, -1.880258083993729e-24,  1.221937004465346e-03, -4.188185445291544e-05,  9.255576893409526e-07, -1.600326150338868e-08,
  2.350210806840856e-10, -3.058604859512882e-12,  3.619846134927085e-14, -3.963664020890005e-16,  4.065015606418799e-18, -3.940394430098584e-20,  3.635565909902607e-22,
 -3.210228827846588e-24,  5.661488125092934e-04, -2.312235708140918e-05,  5.867908406853847e-07, -1.147406917906510e-08,  1.885790580483299e-10, -2.725483285360634e-12,
  3.560537581724514e-14, -4.282282912585738e-16,  4.803732146572113e-18, -5.074925751372217e-20,  5.087020086715990e-22, -4.866359828464923e-24,  2.455187877010010e-04,
 -1.180465501130483e-05,  3.420692736134398e-07, -7.529794975353450e-09,  1.379602891555034e-10, -2.206703275728714e-12,  3.172183851327666e-14, -4.178350332498577e-16,
  5.112752845558824e-18, -5.871480486400607e-20,  6.378238432784634e-22, -6.594429810707307e-24,  9.977676127627408e-05, -5.588451161431092e-06,  1.839215983939343e-07,
 -4.538455428398595e-09,  9.237258420311741e-11, -1.630136320765678e-12,  2.571325653410932e-14, -3.699631437508445e-16,  4.925990682101331e-18, -6.135120036357510e-20,
  7.206695284453984e-22, -8.035753415391572e-24,  3.805101596366956e-05, -2.459873158150528e-06,  9.148280052309970e-08, -2.520743482323009e-09,  5.680936913658727e-11,
 -1.102960095218438e-12,  1.904145981671074e-14, -2.985609156922731e-16,  4.316153162192612e-18, -5.817811301092659e-20,  7.375176500163049e-22, -8.852205351603158e-24,
  1.363929604196929e-05, -1.009440542088585e-06,  4.222102641198120e-08, -1.294356024155021e-09,  3.220287597523372e-11, -6.860510328850543e-13,  1.293252872015043e-14,
 -2.205014990860800e-16,  3.454082506542458e-18, -5.029304972200136e-20,  6.868162014038778e-22, -8.858519522637878e-24,  4.603746444686782e-06, -3.872466130974462e-07,
  1.813500820135054e-08, -6.164496443297455e-10,  1.688360061364119e-11, -3.937214199074933e-13,  8.086404565659776e-15, -1.496282966320862e-16,  2.535065565866640e-18,
 -3.980363686972877e-20,  5.846017310645081e-22, -8.089812562751045e-24,  1.466400892976266e-06, -1.392780899018309e-07,  7.272308462410954e-09, -2.732181125800060e-10,
  8.215798982011096e-12, -2.092372973193416e-13,  4.672580909720030e-15, -9.365623248246997e-17,  1.713240141351267e-18, -2.896070439522334e-20,  4.567600508380336e-22,
 -6.771594480440318e-24,  4.418595452954384e-07, -4.710868063910009e-08,  2.731701481619158e-09, -1.130841100198955e-10,  3.724072774286961e-12, -1.033537653018417e-13,
  2.504689930847956e-15, -5.428642378283209e-17,  1.070467411575614e-18, -1.945190667844010e-20,  3.289728950967176e-22, -5.217872965871855e-24,  1.263087678738765e-07,
 -1.503451820470103e-08,  9.645895713378704e-10, -4.387087291831923e-11,  1.578405855507029e-12, -4.763635855260587e-14,  1.250461924485929e-15, -2.925731343027159e-17,
  6.209318032255038e-19, -1.211161217645896e-20,  2.193442432841276e-22, -3.717282181551080e-24,  3.436436972265809e-08, -4.543982018655876e-09,  3.214180236953272e-10,
 -1.601597729744902e-11,  6.280688295115901e-13, -2.057125865123868e-14,  5.838708817207797e-16, -1.472312991728102e-17,  3.358036765075494e-19, -7.021104188713889e-21,
  1.359827750914217e-22, -2.459258879782209e-24,  8.931419371027531e-09, -1.305868366280040e-09,  1.014943842085179e-10, -5.525840421968449e-12,  2.356541850501559e-13,
 -8.359953917818494e-15,  2.561057597307031e-16, -6.949095898789120e-18,  1.700789084064359e-19, -3.806594324200876e-21,  7.874233258730203e-23, -1.517803354971236e-24,
  2.226949977619476e-09, -3.584541670470886e-10,  3.051184031985403e-11, -1.810298498959198e-12,  8.376793001109502e-14, -3.212421426228768e-15,  1.060349285797644e-16,
 -3.090963089439757e-18,  8.106188901647510e-20, -1.939436293369068e-21,  4.279384371924727e-23, -8.780976619845508e-25,  5.352728700242780e-10, -9.445476653227685e-11,
  8.777572305229716e-12, -5.660458026369188e-13,  2.835721057787317e-14, -1.173261095724332e-15,  4.165331953463852e-17, -1.302371445825638e-18,  3.654395773817947e-20,
 -9.333535996369652e-22,  2.193913206523583e-23, -4.786245502122622e-25,  1.247085871643723e-10, -2.402782620139305e-11,  2.430133003938256e-12, -1.698940549174833e-13,
  9.193967386910161e-15, -4.095906003168813e-16,  1.561229331739106e-17, -5.227339832819922e-19,  1.566965288958223e-20, -4.266224187512887e-22,  1.066842591097055e-23,
 -2.471338450166029e-25,  2.833797687151611e-11, -5.938002159783681e-12,  6.515992176081805e-13, -4.925704370055802e-14,  2.872881773937762e-15, -1.375301239517439e-16,
  5.617903572608860e-18, -2.010844889019489e-19,  6.429357343843782e-21, -1.863199943474384e-22,  4.949801010208256e-24, -1.215880008646025e-25,  6.324538710315978e-12,
 -1.435675948258721e-12,  1.704022942686367e-13, -1.389156217942995e-14,  8.711795257357698e-16, -4.472019199250466e-17,  1.953892308913623e-18, -7.463078979724576e-20,
  2.540917745640713e-21, -7.825368187702842e-23,  2.205229854881336e-24, -5.735933891033127e-26,  1.397263807522659e-12, -3.422661016881891e-13,  4.380201815273973e-14,
 -3.840351079045326e-15,  2.583297216122910e-16, -1.418801811844933e-17,  6.616831049326814e-19, -2.691858643439467e-20,  9.741593925367469e-22, -3.182949089951040e-23,
  9.499435777547017e-25, -2.612289372801504e-26,  3.082506199862091e-13, -8.115781159286850e-14,  1.116260808091542e-14, -1.049558536081211e-15,  7.553344863911202e-17,
 -4.428044163818217e-18,  2.199473174717126e-19, -9.510702061331968e-21,  3.651339786638344e-22, -1.263386021579915e-23,  3.986186390255502e-25, -1.156957192816730e-26,
  6.856221196845401e-14, -1.932412348029354e-14,  2.846941937441255e-15, -2.862070698654046e-16,  2.197615118484529e-17, -1.371661164535600e-18,  7.239365992059713e-20,
 -3.319814494116372e-21,  1.349251543640792e-22, -4.933793772085145e-24,  1.642527882394052e-25, -5.022216136012168e-27,  1.553766475404167e-14, -4.668606698110873e-15,
  7.341338656265005e-16, -7.865949602201100e-17,  6.425121245264056e-18, -4.257983247989154e-19,  2.381656330767591e-20, -1.155433443110012e-21,  4.959602495708292e-23,
 -1.912344130874381e-24,  6.703056115485789e-26, -2.154640947952716e-27,  3.628490061774357e-15, -1.157310386851850e-15,  1.935188827668976e-16, -2.202351713236188e-17,
  1.907612613027081e-18, -1.338246945549936e-19,  7.910378914567993e-21, -4.048915090986006e-22,  1.830784750989287e-23, -7.425164554980438e-25,  2.733669416681324e-26,
 -9.216355859858469e-28,  8.837186840372641e-16, -2.978682162450663e-16,  5.275388168919675e-17, -6.353335256642902e-18,  5.815281985083537e-19, -4.304387222067128e-20,
  2.680381861995325e-21, -1.443147605863553e-22,  6.854172572565363e-24, -2.915872999366460e-25,  1.124548570241415e-26, -3.966208517520681e-28,  2.272660069293771e-16,
 -8.057785748528164e-17,  1.505063013021819e-17, -1.910515545773933e-18,  1.840939080326799e-19, -1.432534546787791e-20,  9.365092806450241e-22, -5.286343610080187e-23,
  2.628784240686293e-24, -1.169421008219810e-25,  4.710331650175158e-27, -1.732900075169189e-28,  6.248323257270301e-17, -2.319091681647883e-17,  4.547645779330385e-18,
 -6.058292712234934e-19,  6.120147802960327e-20, -4.986887291085755e-21,  3.409582229098568e-22, -2.010372728197584e-23,  1.043011110474367e-24, -4.835205197938556e-26,
  2.027310842687399e-27, -7.754678599127314e-29,  1.858141635513680e-17, -7.183318912943938e-18,  1.471653482020274e-18, -2.047862823919206e-19,  2.159119319007888e-20,
 -1.834251706881775e-21,  1.306091741070412e-22, -8.011623688100604e-24,  4.319579141422133e-25, -2.078862094242856e-26,  9.039683121224594e-28, -3.582301506286257e-29,
  6.036633243403775e-18, -2.418082134380966e-18,  5.148756867790063e-19, -7.446167014363456e-20,  8.153547631367127e-21, -7.187641012427917e-22,  5.305821695638546e-23,
 -3.370864156392689e-24,  1.880612654408317e-25, -9.356762138727800e-27,  4.202530967500584e-28, -1.718589161945124e-29,  2.156099953699555e-18, -8.900986219661136e-19,
  1.958928623427547e-19, -2.928381000138523e-20,  3.312732459567918e-21, -3.014788651660658e-22,  2.295690258060900e-23, -1.503298858455728e-24,  8.637791938891329e-26,
 -4.422733258862513e-27,  2.042719431135713e-28, -8.583261735419842e-30,  8.459993444631740e-19, -3.579552353415144e-19,  8.095122968008453e-20, -1.243661424403349e-20,
  1.445284339929930e-21, -1.350410650672429e-22,  1.055088548430254e-23, -7.084433021003344e-25,  4.171237719057019e-26, -2.187147674819358e-27,  1.033832399658951e-28,
 -4.442807258173635e-30,  3.588201025430326e-19, -1.547267183849160e-19,  3.573720718714606e-20, -5.608195941529415e-21,  6.655339873184990e-22, -6.347313968967586e-23,
  5.059525890095100e-24, -3.464221176341518e-25,  2.078871226056180e-26, -1.110422488404613e-27,  5.344381486364507e-29, -2.337305208749980e-30,  1.552508956450212e-19,
 -6.783424694127450e-20,  1.590058657290267e-20, -2.532676456647876e-21,  3.050046112575245e-22, -2.951049940354509e-23,  2.385620007128619e-24, -1.655964171436599e-25,
  1.007105905965254e-26, -5.449893751544308e-28,  2.656453654980038e-29, -1.176158838369601e-30,  5.368536408594938e-20, -2.363000898932934e-20,  5.584889314602600e-21,
 -8.970208798039977e-22,  1.089194215287364e-22, -1.062380954196868e-23,  8.656232859474640e-25, -6.055059142617580e-26,  3.710203203465134e-27, -2.022468662232839e-28,
  9.928526387680072e-30, -4.426371960268280e-31,  5.929149912632990e-02, -1.451593523115499e-04,  3.676944166125633e-07, -9.586144145116359e-10,  2.555364549358327e-12,
 -6.923215528427121e-15,  1.895439786116741e-17, -5.224803407597741e-20,  1.444429490998011e-22, -4.000748874278490e-25,  1.106768744409209e-27, -3.062361699299444e-30,
  5.508548003736707e-02, -1.645114189043064e-04,  5.853067154097792e-07, -2.187876376135387e-09,  8.151724566796609e-12, -2.985069761533984e-14,  1.072732799168893e-16,
 -3.790272003797867e-19,  1.319485530364807e-21, -4.534769780382406e-24,  1.540760867765968e-26, -5.182233121360988e-29,  4.755006296025897e-02, -1.932803416822994e-04,
  9.674366558780792e-07, -4.707877869471163e-09,  2.181203067880071e-11, -9.709076311170448e-14,  4.186780882230166e-16, -1.758949342749399e-18,  7.227525408932798e-21,
 -2.913000584969156e-23,  1.154177427374437e-25, -4.503589502948960e-28,  3.814028714134748e-02, -2.168946585097745e-04,  1.415807561223948e-06, -8.424247707281331e-09,
  4.669403940766802e-11, -2.457193062754631e-13,  1.241045897509883e-15, -6.058424720367314e-18,  2.873055111553526e-20, -1.328608855651910e-22,  6.009200299582979e-25,
 -2.664606065357897e-27,  2.843227636610872e-02, -2.234168485325607e-04,  1.809030432350630e-06, -1.284587246056005e-08,  8.376181770177814e-11, -5.128662138758762e-13,
  2.986789706460980e-15, -1.668807065105227e-17,  9.001883395979518e-20, -4.710212555456961e-22,  2.399525162921580e-24, -1.193577940077224e-26,  1.970325702650280e-02,
 -2.085649497187431e-04,  2.039155535194419e-06, -1.705766590378906e-08,  1.292715148161876e-10, -9.100662103568869e-13,  6.042318007093128e-15, -3.822711488055047e-17,
  2.321667375513871e-19, -1.361147001086804e-21,  7.736741918696018e-24, -4.277937278846756e-26,  1.269689164760408e-02, -1.762086567163853e-04,  2.048936158763108e-06,
 -1.999624614459983e-08,  1.744304793819046e-10, -1.399027654017690e-12,  1.049939336399873e-14, -7.460731082699819e-17,  5.062440940543878e-19, -3.301042052496695e-21,
  2.078646128779861e-23, -1.268879696202888e-25,  7.611276928893791e-03, -1.350772289747621e-04,  1.849578911645774e-06, -2.088768842091754e-08,  2.080791633340223e-10,
 -1.887605672747089e-12,  1.590429130092125e-14, -1.261251207686781e-16,  9.503503367262239e-19, -6.852131481373893e-21,  4.753265046297209e-23, -3.185949404335007e-25,
  4.246423555465081e-03, -9.428946043034754e-05,  1.508787400531280e-06, -1.957725408863610e-08,  2.212684885363168e-10, -2.256821187517979e-12,  2.123046505324378e-14,
 -1.869166602821664e-16,  1.556237806350925e-18, -1.234820228043932e-20,  9.393358967213692e-23, -6.882669058663839e-25,  2.206183252803160e-03, -6.015061686606567e-05,
  1.117391280673501e-06, -1.655488846397569e-08,  2.111185300826366e-10, -2.408933060339159e-12,  2.518421773734773e-14, -2.450869456316192e-16,  2.245391906634460e-18,
 -1.952915779797985e-20,  1.622918288354527e-22, -1.295163203139734e-24,  1.068086745141025e-03, -3.518598387767506e-05,  7.542050897271050e-07, -1.268862300329698e-08,
  1.817084047090087e-10, -2.309538629333815e-12,  2.672659116654073e-14, -2.864307605695980e-16,  2.877414169930016e-18, -2.733972283072022e-20,  2.473994935810486e-22,
 -2.143700018140836e-24,  4.822433175964786e-04, -1.893135230022843e-05,  4.655467469296408e-07, -8.850236706113818e-09,  1.417265492120236e-10, -1.999026108621205e-12,
  2.551814716898393e-14, -3.001971400779463e-16,  3.296664301744848e-18, -3.411965001790335e-20,  3.352671845843044e-22, -3.145776659298674e-24,  2.032498821011793e-04,
 -9.395109703691930e-06,  2.636233712267676e-07, -5.637806158938160e-09,  1.005796728636348e-10, -1.569074152848361e-12,  2.202727690308958e-14, -2.836394644108195e-16,
  3.395934625708469e-18, -3.818775102949214e-20,  4.064777858633043e-22, -4.120304715349579e-24,  8.005323841210680e-05, -4.312075126009486e-06,  1.373517187898696e-07,
 -3.291011699937375e-09,  6.518603265964746e-11, -1.121371154377003e-12,  1.726508821651833e-14, -2.427316105206618e-16,  3.160925536961051e-18, -3.853350096025659e-20,
  4.433492275106818e-22, -4.845055432624500e-24,  2.950346336840897e-05, -1.835082523956036e-06,  6.603291509313211e-08, -1.766021561050570e-09,  3.871611437944639e-11,
 -7.324233935186520e-13,  1.233709780675877e-14, -1.889450556833108e-16,  2.670521751506470e-18, -3.522149665232913e-20,  4.371990429736857e-22, -5.141558554483764e-24,
  1.018981661041885e-05, -7.259850491453918e-07,  2.937682552158435e-08, -8.739083246546421e-10,  2.114364968865873e-11, -4.387695809698677e-13,  8.067528787992679e-15,
 -1.343169223390829e-16,  2.056496964401930e-18, -2.929136079887975e-20,  3.915849900814521e-22, -4.947511164652567e-24,  3.303842644129151e-06, -2.677001962174970e-07,
  1.212920979570695e-08, -4.000378289062302e-10,  1.065284567480349e-11, -2.419344140467703e-13,  4.845649128386785e-15, -8.753568923584107e-17,  1.449284857833859e-18,
 -2.225593327493248e-20,  3.199376135012791e-22, -4.336292634050025e-24,  1.007661408607042e-06, -9.226186213342112e-08,  4.661855673480332e-09, -1.699416065123163e-10,
  4.968405785190877e-12, -1.232191305978426e-13,  2.683123780580812e-15, -5.249896069142203e-17,  9.383865387475804e-19, -1.551280558404172e-20,  2.394498223903193e-22,
 -3.476642973613963e-24,  2.897844845072303e-07, -2.980834550307294e-08,  1.673308579411620e-09, -6.722407457425247e-11,  2.152558690642874e-12, -5.817689739733728e-14,
  1.374762879771624e-15, -2.908672039474509e-17,  5.604337313039457e-19, -9.959300488207672e-21,  1.648434857499940e-22, -2.560653066120723e-24,  7.879242151411776e-08,
 -9.057325513589655e-09,  5.628340452869333e-10, -2.485035085447867e-11,  8.695257224529114e-13, -2.555986643582085e-14,  6.543262232995434e-16, -1.494630418961416e-17,
  3.099786706710485e-19, -5.913503478180418e-21,  1.048221029287764e-22, -1.739953258903630e-24,  2.031934659833001e-08, -2.597508293079905e-09,  1.780738997552182e-10,
 -8.617888027551862e-12,  3.287865613699233e-13, -1.049173653026028e-14,  2.904775942032405e-16, -7.152625868553202e-18,  1.594505754043060e-19, -3.261244178419447e-21,
  6.183369860193174e-23, -1.095493936849699e-24,  4.988010306737934e-09, -7.058816453284609e-10,  5.321404563261121e-11, -2.815526209798671e-12,  1.168709030220822e-13,
 -4.041048532437521e-15,  1.208028562478659e-16, -3.201841416068497e-18,  7.661812553139749e-20, -1.677962981052420e-21,  3.398914798940629e-23, -6.419956997587492e-25,
  1.170445238277547e-09, -1.825806736503527e-10,  1.508837151527586e-11, -8.706054005975905e-13,  3.923637428396913e-14, -1.467367181641514e-15,  4.728634166575084e-17,
 -1.347070250710835e-18,  3.455464524509273e-20, -8.092908716616574e-22,  1.749301216348938e-23, -3.518634939855810e-25,  2.637929666208096e-10, -4.517481434410421e-11,
  4.079990546756773e-12, -2.561027894776378e-13,  1.250535281705763e-14, -5.049131007841537e-16,  1.751139387853503e-17, -5.353837166802862e-19,  1.470192414036580e-20,
 -3.677629832443088e-22,  8.472478540462288e-24, -1.812770353585932e-25,  5.741789542593117e-11, -1.075234748852441e-11,  1.058153079344648e-12, -7.208017866270588e-14,
  3.805400495936957e-15, -1.655732306796411e-16,  6.169949595797228e-18, -2.021432766776539e-19,  5.934089381773025e-21, -1.583347233244831e-22,  3.882986896521202e-24,
 -8.826941014761882e-26,  1.214570355714871e-11, -2.477618592505411e-12,  2.648981847288318e-13, -1.953382326345581e-14,  1.112619667396380e-15, -5.206933958998619e-17,
  2.081213788099988e-18, -7.295331440460523e-20,  2.286083023514626e-21, -6.497530472996480e-23,  1.694040217582636e-24, -4.086420660276743e-26,  2.514659624249931e-12,
 -5.566689275881612e-13,  6.446902995920857e-14, -5.133431070213679e-15,  3.147636280465854e-16, -1.581275566917031e-17,  6.767123283590687e-19, -2.533741595796377e-20,
  8.462317985809312e-22, -2.558276089370275e-23,  7.081229256040294e-25, -1.810207940615484e-26,  5.137001527029379e-13, -1.229363114340236e-13,  1.537554742864914e-14,
 -1.318579879422708e-15,  8.683582427631525e-17, -4.673082525719267e-18,  2.137126024811911e-19, -8.531904863762413e-21,  3.032000090951547e-22, -9.734308151261343e-24,
  2.856285111505429e-25, -7.726754215225978e-27,  1.044811209727861e-13, -2.692678949372381e-14,  3.625570283110416e-15, -3.339561871910446e-16,  2.356331473576489e-17,
 -1.355354163936790e-18,  6.610168257691273e-20, -2.808326864885160e-21,  1.059978620917060e-22, -3.607790473569372e-24,  1.120360166909523e-25, -3.202141602125295e-27,
  2.137158473341032e-14, -5.908018985093255e-15,  8.536109988554709e-16, -8.420891635713863e-17,  6.349237437447659e-18, -3.894039621332540e-19,  2.020758938111091e-20,
 -9.116929446065594e-22,  3.647478153714088e-23, -1.313635537338162e-24,  4.309392770164555e-26, -1.299031165423326e-27,  4.445618861695156e-15, -1.312864385464692e-15,
  2.028478240295697e-16, -2.136544533649625e-17,  1.716562668940656e-18, -1.119576612356483e-19,  6.166588580266527e-21, -2.947533477021876e-22,  1.247175556776365e-23,
 -4.742640755769331e-25,  1.640194917536492e-26, -5.204259356176511e-28,  9.518801297705771e-16, -2.990224469117697e-16,  4.922601132728691e-17, -5.517346057330438e-18,
  4.708866386602339e-19, -3.256588029895155e-20,  1.898613811801742e-21, -9.589458339477326e-23,  4.280573241450358e-24, -1.714601239868914e-25,  6.236904335620512e-27,
 -2.078364217798648e-28,  2.125302879346477e-16, -7.070381142299726e-17,  1.235280758468118e-17, -1.467974042773738e-18,  1.326369880854886e-19, -9.695395265829115e-21,
  5.964749359338206e-22, -3.174113037635236e-23,  1.490561596105038e-24, -6.271999810012548e-26,  2.393369804528973e-27, -8.355142622673978e-29,  5.015914880121115e-17,
 -1.758916397576585e-17,  3.247568449434564e-18, -4.075732112190007e-19,  3.884031802296402e-20, -2.990109302723626e-21,  1.934565330602575e-22, -1.081092523614491e-23,
  5.324022238850876e-25, -2.346218935513974e-26,  9.364641131367154e-28, -3.414965770500267e-29,  1.268695053130316e-17, -4.666574344253120e-18,  9.063834524422631e-19,
 -1.196105324070174e-19,  1.197238151637258e-20, -9.668688633747343e-22,  6.553610132499785e-23, -3.831927451860451e-24,  1.972000049446770e-25, -9.070303178948366e-27,
  3.774185209087475e-28, -1.433085648683411e-29,  3.485110697149240e-18, -1.337749013566663e-18,  2.719823784792047e-19, -3.756202513194914e-20,  3.931118961400103e-21,
 -3.315753226783223e-22,  2.344639036736577e-23, -1.428552755668099e-24,  7.652133166329586e-26, -3.659492816997045e-27,  1.581568581771890e-28, -6.230525360867849e-30,
  1.051981725571267e-18, -4.191360348635744e-19,  8.872798344134371e-20, -1.275785094846885e-20,  1.389099812681838e-21, -1.217820231303288e-22,  8.941914575189012e-24,
 -5.651596493045683e-25,  3.137261755386879e-26, -1.553337701412338e-27,  6.943927580092252e-29, -2.826753146554095e-30,  3.517999668308918e-19, -1.446802705452516e-19,
  3.170862637622839e-20, -4.720381245311041e-21,  5.318185252948767e-22, -4.820682042051992e-23,  3.656699400235676e-24, -2.385589864481422e-25,  1.365768194967676e-26,
 -6.968460130414575e-28,  3.207547598310215e-29, -1.343333090269868e-30,  1.304832697433986e-19, -5.507175155406608e-20,  1.242013167696904e-20, -1.902855936037232e-21,
  2.205364866990417e-22, -2.055162228336174e-23,  1.601600697792463e-24, -1.072723842629825e-25,  6.300823379135290e-27, -3.296031067760893e-28,  1.554442076580294e-29,
 -6.665383194605582e-31,  5.290792732463723e-20, -2.278125160051143e-20,  5.253275539106979e-21, -8.230514269913419e-22,  9.751693291997566e-23, -9.285860755335910e-24,
  7.390644771078052e-25, -5.052853958506699e-26,  3.027858213886222e-27, -1.615068078904761e-28,  7.762686271739527e-30, -3.390474354261458e-31,  2.216614956788405e-20,
 -9.678220346186034e-21,  2.266797242247142e-21, -3.607691125715754e-22,  4.341210515696398e-23, -4.197038306829500e-24,  3.390295561577623e-25, -2.351610531736121e-26,
  1.429144105515501e-27, -7.728290960137591e-29,  3.764438190911091e-30, -1.665616375294917e-31,  7.526054806409021e-21, -3.311675727560766e-21,  7.824455572653522e-22,
 -1.256305827180534e-22,  1.524938378172459e-23, -1.486905450814624e-24,  1.211129267873394e-25, -8.469172883951862e-27,  5.187808644501296e-28, -2.827055269641803e-29,
  1.387414125360039e-30, -6.183593825352023e-32,  5.871667294063918e-02, -1.422631257765263e-04,  3.564318680394690e-07, -9.188120678435274e-10,  2.421333439703919e-12,
 -6.485356022515411e-15,  1.755405756730978e-17, -4.784801518091452e-20,  1.308057080507236e-22, -3.583839642502126e-25,  9.805262233204009e-28, -2.684820149523232e-30,
  5.443663606215663e-02, -1.599318104598139e-04,  5.598155064597285e-07, -2.062088534717499e-09,  7.579620601554662e-12, -2.739886747674334e-14,  9.722792855166535e-17,
 -3.393010623281395e-19,  1.166799227163380e-21, -3.961731736373430e-24,  1.329975436204278e-26, -4.420379372710540e-29,  4.679207096692462e-02, -1.857610378128514e-04,
  9.129737203338139e-07, -4.373890231589085e-09,  1.996683992975340e-11, -8.760829929931108e-14,  3.725139215081422e-16, -1.543593731088280e-18,  6.257384589781197e-21,
 -2.488630130078051e-23,  9.731716290813454e-26, -3.748389880184791e-28,  3.729473863645597e-02, -2.059602243893641e-04,  1.319042130742810e-06, -7.714895704035159e-09,
  4.206428253898773e-11, -2.178702048967083e-13,  1.083594042164919e-15, -5.211155732228885e-18,  2.435339358326885e-20, -1.110137923230095e-22,  4.950707789146294e-25,
 -2.164951136080346e-27,  2.756660834028401e-02, -2.095391787556482e-04,  1.662594801404261e-06, -1.158400040629038e-08,  7.418509252668707e-11, -4.464799748769855e-13,
  2.557429351622780e-15, -1.406123201964285e-17,  7.467027071593475e-20, -3.847717451442026e-22,  1.930932818862326e-24, -9.464266979626440e-27,  1.890037521242263e-02,
 -1.930366454060364e-04,  1.846297529594713e-06, -1.512740245558316e-08,  1.124378019255406e-10, -7.770986033469781e-13,  5.069008387353297e-15, -3.152556787382764e-17,
  1.883103594681594e-19, -1.086276895776525e-21,  6.077279770432460e-24, -3.308544687169888e-26,  1.202338457012811e-02, -1.607315831392014e-04,  1.824845657871773e-06,
 -1.741619036955299e-08,  1.488095861120889e-10, -1.170384018817963e-12,  8.620404603914541e-15, -6.015874395433889e-17,  4.011185350378857e-19, -2.571364787345180e-21,
  1.592464808569829e-23, -9.564056091344745e-26,  7.099050093647651e-03, -1.212293493326765e-04,  1.617720472202801e-06, -1.784084119989221e-08,  1.738748666279142e-10,
 -1.545059713203314e-12,  1.276392671178317e-14, -9.931954958818942e-17,  7.347681328900238e-19, -5.204209784153953e-21,  3.547985396409186e-23, -2.338105385545257e-25,
  3.891999101540036e-03, -8.310194333794136e-05,  1.293697672523326e-06, -1.637204835655871e-08,  1.808308792713604e-10, -1.804852886526721e-12,  1.663201086313490e-14,
 -1.435598022462341e-16,  1.172620387797505e-18, -9.133432408580695e-21,  6.823675313013557e-23, -4.912632141989425e-25,  1.982277371635824e-03, -5.195215626245151e-05,
  9.375104394459820e-07, -1.353177610441183e-08,  1.684675838420673e-10, -1.879349147611309e-12,  1.923035306388680e-14, -1.833338808400487e-16,  1.646645380009758e-18,
 -1.404916008146263e-20,  1.145934072772780e-22, -8.980352320967451e-25,  9.385111730090242e-04, -2.971526926507127e-05,  6.179671940243408e-07, -1.011851387230562e-08,
  1.413325377272090e-10, -1.754781896136449e-12,  1.986026688864110e-14, -2.083616838493703e-16,  2.050694792235220e-18, -1.910232757527566e-20,  1.695661465001752e-22,
 -1.442042761727689e-24,  4.133447113136991e-04, -1.559607576057101e-05,  3.717307641754824e-07, -6.871837517975199e-09,  1.072466437467432e-10, -1.476584784667665e-12,
  1.842187238260824e-14, -2.120170852775237e-16,  2.279722673182381e-18, -2.311881023940219e-20,  2.227286413875634e-22, -2.050110380330721e-24,  1.694946418625138e-04,
 -7.531590698102146e-06,  2.046759205870672e-07, -4.253354242444711e-09,  7.389989676983342e-11, -1.124608949430792e-12,  1.542055177049900e-14, -1.941511515736275e-16,
  2.274819656915878e-18, -2.505256224360301e-20,  2.613304214171024e-22, -2.597533034731126e-24,  6.477540392423547e-05, -3.355068241586059e-06,  1.034444078422256e-07,
 -2.407061345579104e-09,  4.640576214002804e-11, -7.783059506322668e-13,  1.169833579310305e-14, -1.607324476301337e-16,  2.047422776257071e-18, -2.443357894473021e-20,
  2.753892605551235e-22, -2.949969870640895e-24,  2.309896304243434e-05, -1.382074492118671e-06,  4.812158867986781e-08, -1.249302822734161e-09,  2.664536420011800e-11,
 -4.912230375289510e-13,  8.074132222406191e-15, -1.207989058228493e-16,  1.669449865158756e-18, -2.154691488615284e-20,  2.619172729775650e-22, -3.018304695229152e-24,
  7.696807412370656e-06, -5.277713988085969e-07,  2.066100828758408e-08, -5.964494094897012e-10,  1.403449352758553e-11, -2.837190365574152e-13,  5.088753547292623e-15,
 -8.273813617637053e-17,  1.238284602715561e-18, -1.725472909302985e-20,  2.258328210712424e-22, -2.795276090721775e-24,  2.400359285415407e-06, -1.873012324176083e-07,
  8.210151262877503e-09, -2.627308148992441e-10,  6.802819093253276e-12, -1.504706695655110e-13,  2.939139125433794e-15, -5.183888765203104e-17,  8.387742014286303e-19,
 -1.259861676036389e-20,  1.772764090447154e-22, -2.353446988261172e-24,  7.019749046303797e-07, -6.193962363317288e-08,  3.028300379580169e-09, -1.071081375916911e-10,
  3.044470905009327e-12, -7.352725996972747e-14,  1.561220765857818e-15, -2.982054919744405e-17,  5.208452446512818e-19, -8.420695586258410e-21,  1.272126327804008e-22,
 -1.808968248970332e-24,  1.929381618126218e-07, -1.914115853677222e-08,  1.039998296499777e-09, -4.054302994186360e-11,  1.262212406874073e-12, -3.321990981956445e-14,
  7.654462944374413e-16, -1.580901499316343e-17,  2.976305301353707e-19, -5.172436649657618e-21,  8.378787738076098e-23, -1.274687982146814e-24,  4.996872321251557e-08,
 -5.544899018033021e-09,  3.336534528750874e-10, -1.429866127865737e-11,  4.865211728607851e-13, -1.392821137875859e-14,  3.476994641090881e-16, -7.753421524190837e-18,
  1.571295408289521e-19, -2.931610004591398e-21,  5.086040871492183e-23, -8.268615033305750e-25,  1.223149774457274e-08, -1.510932581327442e-09,  1.003613759536104e-10,
 -4.716156399012957e-12,  1.750191517598246e-13, -5.440477302596618e-15,  1.469126786916202e-16, -3.532123643135974e-18,  7.695389806453967e-20, -1.539527135378924e-21,
  2.857310213290026e-23, -4.958757945228511e-25,  2.839834801641731e-09, -3.887779212321251e-10,  2.841783702903987e-11, -1.460762145007895e-12,  5.900605069414424e-14,
 -1.988191570113419e-15,  5.798753128178645e-17, -1.501081029761357e-18,  3.511432779477933e-20, -7.523903948187901e-22,  1.492224028458866e-23, -2.761592366627389e-25,
  6.279332667438156e-10, -9.487586059499902e-11,  7.608778483393185e-12, -4.268195718175228e-13,  1.872955627862534e-14, -6.829110868473709e-16,  2.148051357399263e-17,
 -5.978891449594466e-19,  1.499853009699467e-20, -3.438033728706418e-22,  7.278674613606797e-24, -1.434964887935471e-25,  1.328600426689456e-10, -2.206738073478217e-11,
  1.936071698535736e-12, -1.182452205787638e-13,  5.625831267645910e-15, -2.215976640277976e-16,  7.505836143285339e-18, -2.243329423743389e-19,  6.027376993143386e-21,
 -1.476350731651406e-22,  3.332808975479155e-24, -6.992181954515488e-26,  2.704614755632836e-11, -4.919493992324087e-12,  4.708356136842569e-13, -3.123647563209742e-14,
  1.608181585864305e-15, -6.831456427043175e-17,  2.487931509057463e-18, -7.973500644717887e-20,  2.291594050765393e-21, -5.990764596792410e-23,  1.440441488903716e-24,
 -3.212533292966887e-26,  5.330555771752439e-12, -1.057865274150350e-12,  1.101371359835595e-13, -7.918587173962336e-15,  4.402756683070225e-16, -2.013445285739222e-17,
  7.871740718102060e-19, -2.701297049448222e-20,  8.293457470017328e-22, -2.311119405980105e-23,  5.911768675312759e-25, -1.400010161474129e-26,  1.024517566579286e-12,
 -2.210146430567316e-13,  2.496020959030580e-14, -1.940226694538520e-15,  1.162620108675977e-16, -5.713381617074129e-18,  2.393913996156706e-19, -8.782907346109302e-21,
  2.876472065007723e-22, -8.533177714894175e-24,  2.319209626626045e-25, -5.824937725665907e-27,  1.936016217446029e-13, -4.523242749676300e-14,  5.525163910517492e-15,
 -4.632031687447298e-16,  2.984868455559606e-17, -1.573170417931426e-18,  7.051858927728358e-20, -2.761516782948875e-21,  9.632985891817545e-23, -3.037710211115785e-24,
  8.760161816041166e-26, -2.330383451396919e-27,  3.630620924510119e-14, -9.152293391425833e-15,  1.205573844893178e-15, -1.087224776464937e-16,  7.516924547339093e-18,
 -4.240101943800880e-19,  2.029451363735113e-20, -8.467524318042346e-22,  3.140706706369590e-23, -1.051120955102762e-24,  3.211386666696365e-26, -9.035132095165463e-28,
  6.827813568677549e-15, -1.849953566344186e-15,  2.619570158902992e-16, -2.534300547914477e-17,  1.875277921942980e-18, -1.129523486253391e-19,  5.760370443989900e-21,
 -2.555627159388895e-22,  1.006025688750583e-23, -3.566949855887826e-25,  1.152570395137909e-26, -3.423884000457785e-28,  1.302807467596363e-15, -3.778729984699509e-16,
  5.732874118777125e-17, -5.932153636106541e-18,  4.685186429910150e-19, -3.005773174826546e-20,  1.629444984825077e-21, -7.669887670100665e-23,  3.197587492532566e-24,
 -1.198658035316496e-25,  4.088405444685182e-27, -1.279974732578702e-28,  2.554820105559074e-16, -7.899249527208125e-17,  1.279427472274895e-17, -1.411436572129664e-18,
  1.186267831723418e-19, -8.083424751975412e-21,  4.645790902496334e-22, -2.314309806688620e-23,  1.019381160919237e-24, -4.030853695327322e-26,  1.448051183423428e-27,
 -4.767582554657617e-29,  5.221267707368865e-17, -1.713314660248404e-17,  2.951134012958974e-18, -3.458570356813686e-19,  3.083064452450528e-20, -2.224426390228384e-21,
  1.351360174225407e-22, -7.104153622984757e-24,  3.297062113028196e-25, -1.371633545364039e-26,  5.176736243915541e-28, -1.788027177980623e-29,  1.128632985559216e-17,
 -3.912153505782745e-18,  7.136099086203131e-19, -8.849682830784663e-20,  8.336275180290202e-21, -6.346058713882989e-22,  4.061519191452882e-23, -2.246010319088627e-24,
  1.094919109460363e-25, -4.778008627719146e-27,  1.889044330000544e-28, -6.825712263411369e-30,  2.620040968400080e-18, -9.546011918808591e-19,  1.835549220653197e-19,
 -2.398336910782151e-20,  2.377510369876438e-21, -1.902125229449980e-22,  1.277650383451418e-23, -7.405189370555630e-25,  3.778648881696602e-26, -1.723774819846270e-27,
  7.115811878274514e-29, -2.681214717602616e-30,  6.630548294753837e-19, -2.526047402210621e-19,  5.094611819919354e-20, -6.979997763881669e-21,  7.248426060533939e-22,
 -6.067786027715665e-23,  4.259382525166341e-24, -2.576857237287470e-25,  1.370875482582095e-26, -6.512568998907868e-28,  2.796573904373332e-29, -1.094871655500205e-30,
  1.854285373915523e-19, -7.346048773376245e-20,  1.545565247943119e-20, -2.208755957866529e-21,  2.390604427903256e-22, -2.083697737794244e-23,  1.521372930478006e-24,
 -9.563260803222552e-26,  5.280677149103391e-27, -2.601241942430975e-28,  1.157085622262442e-29, -4.687762416734225e-31,  5.789352540365218e-20, -2.371290852662192e-20,
  5.174056536693559e-21, -7.668561986641802e-22,  8.602482453962826e-23, -7.765028030137077e-24,  5.866129962040493e-25, -3.811886419610648e-26,  2.173981448929051e-27,
 -1.105100513119894e-28,  5.068436094399286e-30, -2.115302273409153e-31,  2.024299662899705e-20, -8.521096849500647e-21,  1.916113595088023e-21, -2.927040218233920e-22,
  3.382637953186426e-23, -3.143443275573083e-24,  2.443052165599386e-25, -1.632000558126034e-26,  9.561323371172382e-28, -4.989234844066525e-29,  2.347317085094274e-30,
 -1.004179141246625e-31,  7.828733352887112e-21, -3.365711111044148e-21,  7.747886993972093e-22, -1.211800557307556e-22,  1.433336701804543e-23, -1.362611801745324e-24,
  1.082763163146216e-25, -7.391095204758101e-27,  4.422298705677046e-28, -2.355391142964004e-29,  1.130479159864572e-30, -4.930705866873739e-32,  3.170383386201817e-21,
 -1.383213259221423e-21,  3.236974005269901e-22, -5.147376287203678e-23,  6.188745606764606e-24, -5.978299427767258e-25,  4.825294888228165e-26, -3.344353300199249e-27,
  2.030916690435071e-28, -1.097431999835059e-29,  5.341717658949440e-31, -2.361845739525963e-32,  1.055837089416915e-21, -4.644554658685212e-22,  1.096982432618933e-22,
 -1.760709811325550e-23,  2.136449175673555e-24, -2.082445305374358e-25,  1.695638542791790e-26, -1.185329329226678e-27,  7.258385100839836e-29, -3.954131899338654e-30,
  1.939931950569693e-31, -8.643466525192998e-33,  5.815325443468455e-02, -1.394551249200221e-04,  3.456343638244572e-07, -8.810859464342669e-10,  2.295733168647880e-12,
 -6.079674236820878e-15,  1.627102718504708e-17, -4.386131705210131e-20,  1.185823090228651e-22, -3.214257763402518e-25,  8.697679265936199e-28, -2.357282934832694e-30,
  5.380571200637749e-02, -1.555502458392967e-04,  5.357804064123222e-07, -1.945074794561285e-09,  7.054229679056501e-12, -2.517531140662423e-14,  8.822949454166191e-17,
 -3.041464552434611e-19,  1.033302063219994e-21, -3.466669660647401e-24,  1.150014583683012e-26, -3.777554339542703e-29,  4.606330947512890e-02, -1.786618938808524e-04,
  8.623475670146481e-07, -4.067966660723222e-09,  1.830068993481246e-11, -7.916478770883036e-14,  3.319670959064724e-16, -1.356971740832621e-18,  5.427747423932631e-21,
 -2.130430678384864e-23,  8.223478613085986e-26, -3.127093170308924e-28,  3.649143180826078e-02, -1.957670830748931e-04,  1.230362204344917e-06, -7.075361481417996e-09,
  3.795556203912211e-11, -1.935303949314666e-13,  9.480174022599447e-16, -4.492147885347901e-18,  2.069153552023259e-20, -9.299168994474556e-23,  4.089526755082651e-25,
 -1.763941769097650e-27,  2.675420037688806e-02, -1.967749316471836e-04,  1.530424336795238e-06, -1.046526999798446e-08,  6.583872820249489e-11, -3.895685222747791e-13,
  2.195186494411415e-15, -1.187928278667380e-17,  6.211396148109438e-20, -3.152591553460256e-22,  1.558774068897495e-24, -7.529522217806115e-27,  1.815666137983279e-02,
 -1.789629370920886e-04,  1.675070463995921e-06, -1.344641173388714e-08,  9.804426358258598e-11, -6.653885869932604e-13,  4.265095299929252e-15, -2.608112081066059e-17,
  1.532506092051324e-19, -8.699783056651810e-22,  4.791466862146308e-24, -2.568744932129738e-26,  1.140838702371260e-02, -1.469300274992209e-04,  1.629399548503183e-06,
 -1.521180509704991e-08,  1.273415113243215e-10, -9.823385356485212e-13,  7.102575690014784e-15, -4.868890066378007e-17,  3.190687088569899e-19, -2.011205052290067e-21,
  1.225229154772384e-23, -7.240979968096769e-26,  6.638724122305477e-03, -1.090988968312198e-04,  1.419354067335006e-06, -1.529030857321168e-08,  1.458247889020484e-10,
 -1.269603715242381e-12,  1.028583244326467e-14, -7.854961628005817e-17,  5.706629531516167e-19, -3.971270559250533e-21,  2.661317068911791e-23, -1.724609215955816e-25,
  3.579112206983233e-03, -7.349164323805298e-05,  1.113468348594335e-06, -1.374713672511109e-08,  1.484206005752497e-10, -1.449966500600697e-12,  1.309176455595794e-14,
 -1.108095740410214e-16,  8.881481808228692e-19, -6.791939147807287e-21,  4.984536130803079e-23, -3.526605425788356e-25,  1.788501619125306e-03, -4.505847675814154e-05,
  7.901383493504117e-07, -1.111355814945412e-08,  1.351089830873821e-10, -1.473904103935457e-12,  1.476455370670075e-14, -1.379207900323601e-16,  1.214669673713295e-18,
 -1.016831922740286e-20,  8.142032319663540e-23, -6.266823640458170e-25,  8.288195196649081e-04, -2.522128627388774e-05,  5.090335692693451e-07, -8.113918478546460e-09,
  1.105665875924355e-10, -1.341321221109429e-12,  1.485012943875740e-14, -1.525481403318280e-16,  1.471206077156030e-18, -1.343790136040998e-20,  1.170329486923935e-22,
 -9.769973112060773e-25,  3.564242495409896e-04, -1.292500455058784e-05,  2.986624814870804e-07, -5.370002032901350e-09,  8.169489336590915e-11, -1.098165762512959e-12,
  1.339289828745307e-14, -1.508251570177329e-16,  1.588204837043806e-18, -1.578405562317067e-20,  1.491162575989341e-22, -1.346663492900930e-24,  1.423461167748830e-04,
 -6.079830938143322e-06,  1.600482383260034e-07, -3.232495260501592e-09,  5.470753682068319e-11, -8.122911383700192e-13,  1.088103882894479e-14, -1.339739868199351e-16,
  1.536435499288474e-18, -1.657407249814712e-20,  1.694565683711625e-22, -1.651853199280930e-24,  5.284368109448989e-05, -2.631520562775172e-06,  7.854647507519286e-08,
 -1.775250158653276e-09,  3.331777367436154e-11, -5.448911083910208e-13,  7.996641399753013e-15, -1.073931137031055e-16,  1.338323717614771e-18, -1.563716768557840e-20,
  1.726751264745689e-22, -1.813321655087625e-24,  1.825499058287017e-05, -1.050504332265581e-06,  3.539490823758592e-08, -8.920939279593516e-10,  1.851312443380719e-11,
 -3.326459620241771e-13,  5.336102963192710e-15, -7.799972157024729e-17,  1.054164605844123e-18, -1.331598419285180e-20,  1.585297854953773e-22, -1.790365883553304e-24,
  5.875838367801696e-06, -3.876872700823188e-07,  1.468319393377071e-08, -4.113707160545788e-10,  9.414678217810417e-12, -1.854284392336851e-13,  3.244616563871187e-15,
 -5.152366524120659e-17,  7.538463742928821e-19, -1.027754253906413e-20,  1.317047890093543e-22, -1.597185038085402e-24,  1.764888595937598e-06, -1.325867954385693e-07,
  5.622328510856546e-09, -1.745722415447913e-10,  4.395288426299345e-12, -9.469092917055901e-14,  1.803933967917401e-15, -3.106629996865920e-17,  4.912818789998854e-19,
 -7.218130367526296e-21,  9.942391359349332e-23, -1.292923062920285e-24,  4.955658190723541e-07, -4.212613319474083e-08,  1.992637230057519e-09, -6.837841105360567e-11,
  1.889647083725766e-12, -4.444279080416226e-14,  9.202031235465404e-16, -1.715899142085172e-17,  2.928621882410475e-19, -4.630735710631325e-21,  6.847103205343399e-23,
 -9.536269365083758e-25,  1.303576901641905e-07, -1.246860080213255e-08,  6.555934319525792e-10, -2.479781039083699e-11,  7.505747103786420e-13, -1.923618150877907e-14,
  4.321840582617404e-16, -8.713250234488392e-18,  1.602862993136881e-19, -2.724136232862132e-21,  4.318769400562058e-23, -6.434703889251755e-25,  3.220310473406188e-08,
 -3.448227442366344e-09,  2.008720672571293e-10, -8.354150388464834e-12,  2.763886530432720e-13, -7.705455549997754e-15,  1.875661977506027e-16, -4.082944357736582e-18,
  8.085134909830729e-20, -1.475217316480765e-21,  2.504850088833063e-23, -3.988320142757364e-25,  7.492812268945495e-09, -8.939854251516946e-10,  5.751806635362300e-11,
 -2.623957729815739e-12,  9.470424444181742e-14, -2.867368633884909e-15,  7.551207310291315e-17, -1.772460561319416e-18,  3.773719931768764e-20, -7.384026394009225e-22,
  1.341408398933252e-23, -2.280228350412170e-25,  1.647606780105565e-09, -2.180956137083803e-10,  1.545183221015332e-11, -7.714504321481379e-13,  3.031808788874652e-14,
 -9.953109781093083e-16,  2.831783514016674e-17, -7.158392557222600e-19,  1.636774235869044e-20, -3.430870616658261e-22,  6.661618880230845e-24, -1.207794463766319e-25,
  3.437545568564790e-10, -5.027932505808798e-11,  3.911506024592901e-12, -2.132469275803854e-13,  9.108847294438612e-15, -3.237311421614921e-16,  9.937053870499802e-18,
 -2.701921662779826e-19,  6.627302031425818e-21, -1.486588073886805e-22,  3.082110841370163e-24, -5.954603279031515e-26,  6.836611022661689e-11, -1.100679474890250e-11,
  9.376465985607344e-13, -5.569838326350595e-14,  2.581217286915035e-15, -9.915961617879876e-17,  3.279328849964573e-18, -9.579093343297335e-20,  2.517615508017825e-21,
 -6.037085710270064e-23,  1.335183305965459e-24, -2.746194348582331e-26,  1.303079394387911e-11, -2.300736070987268e-12,  2.140408293491760e-13, -1.382373120211180e-14,
  6.937781607508024e-16, -2.876326601867914e-17,  1.023436707248975e-18, -3.207590749911585e-20,  9.022860498286422e-22, -2.310472994778939e-23,  5.445442158583045e-25,
 -1.191222168661693e-26,  2.395262423407392e-12, -4.621283112733953e-13,  4.682540937733466e-14, -3.280874952696738e-15,  1.779899911223851e-16, -7.950956628156202e-18,
  3.039409534571960e-19, -1.020745904247585e-20,  3.069445705151966e-22, -8.383926708137842e-24,  2.103482586956748e-25, -4.889102863433766e-27,  4.276863807741410e-13,
 -8.984685526054548e-14,  9.888757782789260e-15, -7.500019178154277e-16,  4.389826374762998e-17, -2.109325764538235e-18,  8.649686096713907e-20, -3.108392208597072e-21,
  9.979215460366982e-23, -2.903967302548450e-24,  7.747260015760444e-26, -1.911156022719586e-27,  7.479955022337308e-14, -1.704874416270152e-14,  2.032620929371834e-15,
 -1.664888638237268e-16,  1.049236730825500e-17, -5.413283672229916e-19,  2.377358412937307e-20, -9.128170059546052e-22,  3.124308715091679e-23, -9.673521688009413e-25,
  2.740709979322717e-26, -7.167175767356258e-28,  1.293619975035186e-14, -3.187386941499925e-15,  4.104723814778948e-16, -3.622102678365431e-17,  2.452533179852519e-18,
 -1.355959709309534e-19,  6.366224557813948e-21, -2.607382014961552e-22,  9.499696974090108e-24, -3.124913426551158e-25,  9.389259331870828e-27, -2.599377099929053e-28,
  2.236381034854821e-15, -5.934387137793811e-16,  8.230069033437033e-17, -7.803548473962489e-18,  5.663609357802054e-19, -3.348415868819562e-20,  1.677316279664248e-21,
 -7.314193210725303e-23,  2.831700927046113e-24, -9.879894305779906e-26,  3.143196969984155e-27, -9.198104475698561e-29,  3.912078448456091e-16, -1.113613039887276e-16,
  1.657845756916598e-17, -1.684264049892678e-18,  1.306882587396403e-19, -8.242544398361980e-21,  4.395523019656487e-22, -2.036481550522413e-23,  8.361303442731070e-25,
 -3.088388219297187e-26,  1.038453866600435e-27, -3.206561319883634e-29,  7.019151980155475e-17, -2.134569209699758e-17,  3.399324456281972e-18, -3.688752339313737e-19,
  3.051285532070961e-20, -2.047492463924051e-21,  1.159444712120639e-22, -5.693776715639196e-24,  2.473528917590575e-25, -9.651170154441414e-27,  3.422625756804581e-28,
 -1.112896581509211e-29,  1.311117680863945e-17, -4.240899334128739e-18,  7.197233184254080e-19, -8.313225172869055e-20,  7.307187269364173e-21, -5.201010661728432e-22,
  3.118502542664026e-23, -1.618779209371388e-24,  7.421443162826077e-26, -3.051136212437424e-27,  1.138437262406335e-28, -3.888876230588085e-30,  2.590770470455203e-18,
 -8.871613142053548e-19,  1.597815818521767e-19, -1.956913940572947e-20,  1.821182722983173e-21, -1.370233375844075e-22,  8.670785209417961e-24, -4.742705922987975e-25,
  2.287700691889047e-26, -9.881383923729044e-28,  3.868214235085361e-29, -1.384391697933002e-30,  5.506939127114157e-19, -1.986423202973051e-19,  3.779379953717486e-20,
 -4.886909977762882e-21,  4.795568383971068e-22, -3.799164655417812e-23,  2.527734065402573e-24, -1.451649060095589e-25,  7.341740898527325e-27, -3.320516504983436e-28,
  1.359353074136947e-29, -5.080942516332376e-31,  1.280442681443609e-19, -4.839466957541695e-20,  9.677829478971366e-21, -1.314835341749319e-21,  1.354258991170617e-22,
 -1.124700811030609e-23,  7.834503013948653e-25, -4.704580798029900e-26,  2.484842333920740e-27, -1.172260338750892e-28,  4.999949137135306e-30, -1.944774013968057e-31,
  3.307897865180632e-20, -1.302597422044999e-20,  2.722801813034314e-21, -3.866054825129195e-22,  4.158011170431293e-23, -3.602046467668692e-24,  2.614381683374340e-25,
 -1.633952957371880e-26,  8.972282547485413e-28, -4.395930202137921e-29,  1.945209496955970e-30, -7.841044475479914e-32,  9.613403574560159e-21, -3.920693551863644e-21,
  8.514722198335730e-22, -1.256092145771887e-22,  1.402632069118168e-23, -1.260463528526680e-24,  9.481216539831822e-26, -6.135294144280367e-27,  3.484906499309426e-28,
 -1.764542423983829e-29,  8.062182873034320e-31, -3.352393251710497e-32,  3.159944344634338e-21, -1.326394754904182e-21,  2.973359063142666e-22, -4.527973962454744e-23,
  5.216831361461080e-24, -4.833568042216983e-25,  3.745787732442928e-26, -2.495264348351837e-27,  1.457931706423739e-28, -7.587735376249267e-30,  3.560771240873271e-31,
 -1.519547677488085e-32,  1.162736835556419e-21, -4.990595241745674e-22,  1.146742242134236e-22, -1.790269147199767e-23,  2.113753114113905e-24, -2.005932655640879e-25,
  1.591244048086844e-26, -1.084407576557400e-27,  6.477886790221264e-29, -3.444851434295518e-30,  1.650867690419525e-31, -7.189890556287715e-33,  4.543002834386986e-22,
 -1.980490711068336e-22,  4.630566079772440e-23, -7.356804568085414e-24,  8.837309712962731e-25, -8.529383541036696e-26,  6.878530972804964e-27, -4.763491891669544e-28,
  2.890389633394519e-29, -1.560638448933549e-30,  7.590583893139525e-32, -3.353707640485124e-33,  1.482377039778331e-22, -6.518782393188935e-23,  1.539091898485629e-23,
 -2.469407194606183e-24,  2.995288471163169e-25, -2.918523161121592e-26,  2.375576428752572e-27, -1.660060263240555e-28,  1.016194605736520e-29, -5.534049466607410e-31,
  2.714165328965592e-32, -1.208923848436544e-33,  5.760089799184275e-02, -1.367317268007323e-04,  3.352777778726150e-07, -8.453061561742001e-10,  2.177947424522204e-12,
 -5.703488650050040e-15,  1.509434234855296e-17, -4.024530743582323e-20,  1.076130116065045e-22, -2.886228154577233e-25,  7.724517652086588e-28, -2.072751857035489e-30,
  5.319193834313577e-02, -1.513554849607646e-04,  5.131004641498373e-07, -1.836122947958577e-09,  6.571227557767332e-12, -2.315637254611690e-14,  8.015816613894159e-17,
 -2.729919599279984e-19,  9.163967757824935e-22, -3.038240558492129e-24,  9.960872107740141e-27, -3.234100259154084e-29,  4.536215716749643e-02, -1.719535155375724e-04,
  8.152379523219499e-07, -3.787401676827966e-09,  1.679408717882591e-11, -7.163457979485806e-14,  2.962925941608768e-16, -1.194946204741100e-18,  4.716830599680059e-21,
 -1.827430216314067e-23,  6.963839840067604e-26, -2.614710866978241e-28,  3.572752574072376e-02, -1.862537652199481e-04,  1.148977761194945e-06, -6.497842594963176e-09,
  3.430266408201184e-11, -1.722155024212730e-13,  8.310254579024733e-16, -3.880570567911853e-18,  1.762049636788798e-20, -7.808576484969473e-23,  3.386926690103002e-25,
 -1.441159416576841e-27,  2.599081660330596e-02, -1.850165358706923e-04,  1.410913472408749e-06, -9.471427967206039e-09,  5.854837810404609e-11, -3.406609533943355e-13,
  1.888769632950795e-15, -1.006181068038753e-17,  5.181147029042360e-20, -2.590602312858537e-22,  1.262230478082292e-24, -6.009746502872446e-27,  1.746662519121589e-02,
 -1.661821095538733e-04,  1.522703976583080e-06, -1.197884268665919e-08,  8.570370852337082e-11, -5.712630713757702e-13,  3.599023322032188e-15, -2.164332085416956e-17,
  1.251252466107899e-19, -6.991466405830435e-22,  3.791352906990439e-24, -2.001904916868853e-26,  1.084562821292810e-02, -1.345917960661323e-04,  1.458463111939881e-06,
 -1.332269690861833e-08,  1.092946230497552e-10, -8.271461043110607e-13,  5.871984539318039e-15, -3.954846524791681e-17,  2.547696654988983e-19, -1.579359769966586e-21,
  9.466160147664462e-24, -5.505995695396899e-26,  6.223929694456013e-03, -9.844018098499988e-05,  1.249073095681141e-06, -1.314754810945854e-08,  1.227332934493912e-10,
 -1.047197996630495e-12,  8.321990792422668e-15, -6.238437400293419e-17,  4.451608070464638e-19, -3.044344002194359e-21,  2.005761917983538e-23, -1.278382232472130e-25,
  3.301970566592678e-03, -6.520548665668997e-05,  9.618466579310698e-07, -1.158832998680927e-08,  1.223276647215272e-10, -1.169997509206677e-12,  1.035280611775848e-14,
 -8.594460923564474e-17,  6.760772805619200e-19, -5.077133507782928e-21,  3.660790191069805e-23, -2.545767530717461e-25,  1.620114373392913e-03, -3.923619257220094e-05,
  6.688322963035883e-07, -9.169624204215152e-09,  1.088829317173943e-10, -1.161820987557630e-12,  1.139609994070050e-14, -1.043299877994190e-16,  9.011432752689424e-19,
 -7.402982977893212e-21,  5.820261499952472e-23, -4.400606935335901e-25,  7.355021735650872e-04, -2.151033153311165e-05,  4.214546453138668e-07, -6.541461874302675e-09,
  8.698392338560706e-11, -1.031271070769117e-12,  1.117114111958518e-14, -1.123841663032277e-16,  1.062277327606721e-18, -9.515847662076193e-21,  8.132489423162276e-23,
 -6.665415914307070e-25,  3.091240157134125e-04, -1.077280626374807e-05,  2.413932606161638e-07, -4.222464796445955e-09,  6.263139575578597e-11, -8.221570889868912e-13,
  9.803467927805195e-15, -1.080497634809777e-16,  1.114440683370146e-18, -1.085607692388570e-20,  1.005881987938966e-22, -8.914209615766055e-25,  1.203613839161168e-04,
 -4.940872801780816e-06,  1.260168092459262e-07, -2.474134484625730e-09,  4.079584340606592e-11, -5.911135577537447e-13,  7.736954720254581e-15, -9.317662008589904e-17,
  1.046070467115824e-18, -1.105491969422785e-20,  1.108008447185825e-22, -1.059405070010536e-24,  4.345120504241112e-05, -2.080063566296107e-06,  6.011353156003334e-08,
 -1.319862275635684e-09,  2.411854307595445e-11, -3.846925159370964e-13,  5.513245266544796e-15, -7.238262590872288e-17,  8.826040381346382e-19, -1.009818811989523e-20,
  1.092666069710874e-22, -1.125031932576951e-24,  1.455798782608937e-05, -8.055938459785680e-07,  2.626815900678987e-08, -6.428282616762472e-10,  1.298193501626353e-11,
 -2.273782605971437e-13,  3.560217453532904e-15, -5.085179521668605e-17,  6.721772637192102e-19, -8.311065531777476e-21,  9.691823617462305e-23, -1.072799815629570e-24,
  4.532031731580149e-06, -2.876633335657686e-07,  1.054064588267954e-08, -2.866189444346907e-10,  6.380721085214375e-12, -1.224523423692939e-13,  2.090578314268943e-15,
 -3.242698642517998e-17,  4.638639169637109e-19, -6.188149051020794e-21,  7.765146495138728e-23, -9.227002573274283e-25,  1.312746814282315e-06, -9.492211220378831e-08,
  3.893795741622347e-09, -1.173124616355061e-10,  2.872209557994897e-12, -6.027350302576970e-14,  1.119995763610415e-15, -1.883445710116564e-17,  2.911255911215160e-19,
 -4.184311254541846e-21,  5.642356085680096e-23, -7.187892477140966e-25,  3.543922001016150e-07, -2.901371210902303e-08,  1.327652679340918e-09, -4.420106257016991e-11,
  1.187605585443494e-12, -2.720133754510041e-14,  5.492328891969540e-16, -9.998637246607062e-18,  1.667673902171198e-19, -2.579084667802861e-21,  3.732647751618047e-23,
 -5.091885766823829e-25,  8.934197586127996e-08, -8.235942630295429e-09,  4.190006827217879e-10, -1.537641206197159e-11,  4.524638780090062e-13, -1.129175861176314e-14,
  2.473686117286985e-16, -4.868332962289963e-18,  8.750740661638932e-20, -1.454446288160643e-21,  2.256732816875572e-23, -3.293065867631350e-25,  2.108171362296012e-08,
 -2.177369247471488e-09,  1.227674624156697e-10, -4.954395001582806e-12,  1.593607154870663e-13, -4.326300745574228e-15,  1.026834975046354e-16, -2.181894922985549e-18,
  4.221674990444979e-20, -7.532924354266525e-22,  1.251792361252946e-23, -1.952033551076582e-25,  4.669073491449920e-09, -5.378247669274883e-10,  3.350786566260927e-11,
 -1.483701565095482e-12,  5.207290075703429e-14, -1.535462288572261e-15,  3.943138217755910e-17, -9.035477497193963e-19,  1.879801713064239e-20, -3.597284995790717e-22,
  6.396092924550211e-24, -1.064901733109865e-25,  9.737365162572331e-10, -1.245669872634462e-10,  8.551329611413439e-12, -4.145642444262814e-13,  1.584802851133728e-14,
 -5.068215483944168e-16,  1.406432274901881e-17, -3.471403186471813e-19,  7.757493855316932e-21, -1.590551085486997e-22,  3.023183923734441e-24, -5.369383249281844e-26,
  1.919559573561534e-10, -2.716462380944621e-11,  2.049190371323396e-12, -1.085414002416666e-13,  4.511921885860366e-15, -1.562682864331859e-16,  4.680064276253610e-18,
 -1.242880872064976e-19,  2.980295144087203e-21, -6.540941087266125e-23,  1.327858229405718e-24, -2.513698313995406e-26,  3.593084657110450e-11, -5.603935087029342e-12,
  4.633223481681192e-13, -2.675885853716453e-14,  1.207512592883793e-15, -4.522865497291143e-17,  1.460065379764014e-18, -4.167339196069239e-20,  1.071180117881635e-21,
 -2.514154370407337e-23,  5.446500951270217e-25, -1.098042356506431e-26,  6.419990588879091e-12, -1.099598293121922e-12,  9.938610348453839e-14, -6.246050873086189e-15,
  3.054654565792521e-16, -1.235592686934129e-17,  4.294031923485957e-19, -1.315740833602802e-20,  3.621598285070181e-22, -9.081627635894144e-24,  2.097563006897041e-25,
 -4.499734194784280e-27,  1.101762876782392e-12, -2.065164337966800e-13,  2.035393495110511e-14, -1.389129938380420e-15,  7.350103166394281e-17, -3.205969274677075e-18,
  1.197885678605772e-19, -3.935763685380739e-21,  1.158824696905106e-22, -3.101565035765641e-24,  7.630445910652520e-26, -1.740215594857358e-27,  1.829197502362010e-13,
 -3.739421316251294e-14,  4.008618577519420e-15, -2.964851452576634e-16,  1.694266609081049e-17, -7.956664675484684e-19,  3.191945523849485e-20, -1.123141967186633e-21,
  3.533309594715427e-23, -1.008271820608754e-24,  2.639515219588563e-26, -6.393486869118081e-28,  2.962708811290388e-14, -6.582849642086363e-15,  7.655439203046377e-16,
 -6.122858542040179e-17,  3.771831729210176e-18, -1.904009983406222e-19,  8.188729013461937e-21, -3.081555568629539e-22,  1.034491414978201e-23, -3.143701399206530e-25,
  8.747391143197884e-27, -2.247946224197008e-28,  4.726889006780293e-15, -1.137508069742687e-15,  1.431198446808039e-16, -1.234997560784704e-17,  8.184891167453776e-19,
 -4.433199853317136e-20,  2.040687439646376e-21, -8.200637225232066e-23,  2.933600179076753e-24, -9.481027167217013e-26,  2.800487210832206e-27, -7.626164071758461e-29,
  7.511784314353370e-16, -1.950716929684588e-16,  2.647789534225610e-17, -2.459011458624227e-18,  1.749456573192692e-19, -1.014682677315951e-20,  4.990050744108602e-22,
 -2.137724958762104e-23,  8.135868594320641e-25, -2.792139282987260e-26,  8.742284327164778e-28, -2.519150348702208e-29,  1.204153684513252e-16, -3.361587141295798e-17,
  4.907254780144908e-18, -4.891631689503067e-19,  3.726777463103706e-20, -2.309461735813209e-21,  1.210867745298356e-22, -5.519124863007019e-24,  2.230578233642274e-25,
 -8.114534784683893e-27,  2.688607750636288e-28, -8.184729870094216e-30,  1.975027066713530e-17, -5.903160466661017e-18,  9.236876635352717e-19, -9.853208932998325e-20,
  8.016856291331810e-21, -5.294513935672552e-22,  2.952473380578001e-23, -1.428582092572180e-24,  6.118062337473603e-26, -2.354396086986051e-27,  8.238728646413431e-29,
 -2.644558947740383e-30,  3.367268543336884e-18, -1.072885968337863e-18,  1.792810266461921e-19, -2.039706215748468e-20,  1.766813312271373e-21, -1.239912774849935e-22,
  7.333776117218823e-24, -3.757103720203410e-25,  1.700722732517749e-26, -6.906717122556938e-28,  2.546593929667457e-29, -8.599840554013935e-31,  6.071104187899380e-19,
 -2.052494413558530e-19,  3.647723030060763e-20, -4.409548756668735e-21,  4.052051770978417e-22, -3.011606559877888e-23,  1.883326412149182e-24, -1.018431470816954e-25,
  4.858593577843435e-27, -2.076319935632831e-28,  8.044587867053869e-30, -2.850503527186655e-31,  1.178867007286385e-19, -4.207618020418644e-20,  7.916861763756633e-21,
 -1.012532929053420e-21,  9.830856979510227e-23, -7.708389212894182e-24,  5.077845427330288e-25, -2.888196963416228e-26,  1.447172673155899e-27, -6.486586190323026e-29,
  2.632444653083765e-30, -9.757008167715212e-32,  2.511549107747111e-20, -9.412916210107218e-21,  1.865571534909774e-21, -2.512219575931873e-22,  2.565316943440273e-23,
 -2.112731495789249e-24,  1.459835279205490e-25, -8.697882080809885e-27,  4.559350966108548e-28, -2.135241626598174e-29,  9.042948965268270e-31, -3.493335170756621e-32,
  5.975842393983942e-21, -2.338183177233851e-21,  4.853903154097672e-22, -6.844999415895647e-23,  7.312964627702463e-24, -6.294262197880466e-25,  4.539838664023531e-26,
 -2.820163602303641e-27,  1.539522917107722e-28, -7.500059482377613e-30,  3.300579116757260e-31, -1.323393791353964e-32,  1.611592161044532e-21, -6.542644330229220e-22,
  1.413829409552073e-22, -2.075360778117069e-23,  2.306267917623944e-24, -2.062764214951646e-25,  1.544539613070178e-26, -9.950579397071590e-28,  5.627857852465328e-29,
 -2.837803236071321e-30,  1.291392138077391e-31, -5.349030730556526e-33,  4.965104026127591e-22, -2.077852394543723e-22,  4.642506178289497e-23, -7.046505675266796e-24,
  8.092281394872451e-25, -7.474190397725889e-26,  5.774467353269234e-27, -3.835291313253158e-28,  2.234456681659576e-29, -1.159681624939863e-30,  5.427504074249810e-32,
 -2.310145229850106e-33,  1.733763275151477e-22, -7.428479742227679e-23,  1.703609081733751e-23, -2.654465569121226e-24,  3.128119202872778e-25, -2.963033949682447e-26,
  2.346232262322053e-27, -1.596113263660561e-28,  9.518406344525329e-30, -5.053396284369563e-31,  2.417846393302437e-32, -1.051393030602251e-33,  6.522763714270624e-23,
 -2.841140093895510e-23,  6.636540346351378e-24, -1.053372598004665e-24,  1.264166637639965e-25, -1.218996526151706e-26,  9.821802195124140e-28, -6.795820954410530e-29,
  4.120066326703620e-30, -2.222754808986107e-31,  1.080228791162482e-32, -4.769003396255525e-34,  2.082897009022614e-23, -9.156504677374931e-24,  2.161040977108269e-24,
 -3.465963002174174e-25,  4.202462900367602e-26, -4.093217950771638e-27,  3.330505556832600e-28, -2.326524075696620e-29,  1.423660007313667e-30, -7.750349494057424e-32,
  3.799850425543420e-33, -1.691938498239480e-34,  5.705927211087874e-02, -1.340894954148459e-04,  3.253394853769997e-07, -8.113522487987797e-10,  2.067410988421195e-12,
 -5.354367120212166e-15,  1.401416384787162e-17, -3.696214830890258e-20,  9.775746663650217e-23, -2.594734206669636e-25,  6.868198153620723e-28, -1.825279256293634e-30,
  5.259458894316107e-02, -1.473370623064234e-04,  4.916828750417704e-07, -1.734586340927217e-09,  6.126735627505551e-12, -2.132108654866141e-14,  7.290902660547555e-17,
 -2.453430896242243e-19,  8.138619413633900e-22, -2.666855453876289e-24,  8.641894417451828e-27, -2.773777979211609e-29,  4.468710537852426e-02, -1.656089456374004e-04,
  7.713553069255704e-07, -3.529782525821345e-09,  1.542988130438627e-11, -6.490859259843521e-14,  2.648520464855040e-16, -1.054017725647422e-18,  4.106442633925595e-21,
 -1.570580898185729e-23,  5.909457228694325e-26, -2.191143212252970e-28,  3.500041332373949e-02, -1.773647641563008e-04,  1.074186455574516e-06, -5.975506621924554e-09,
  3.104931760982332e-11, -1.535135543702912e-13,  7.298588117280998e-16, -3.359196496401604e-18,  1.503872803960145e-20, -6.572553951447916e-23,  2.812148864385687e-25,
 -1.180600567775553e-27,  2.527262706634183e-02, -1.741684337402417e-04,  1.302659869186093e-06, -8.586789239311623e-09,  5.216657647506663e-11, -2.985321816925925e-13,
  1.628915028442074e-15, -8.543812375603513e-18,  4.333381697526577e-20, -2.134863399659249e-22,  1.025180057815072e-24, -4.811920639433327e-27,  1.682538142719410e-02,
 -1.545529896012862e-04,  1.386823044988486e-06, -1.069449050745029e-08,  7.509536897148070e-11, -4.917284656383244e-13,  3.045481776336304e-15, -1.801439166260356e-17,
  1.024860531433676e-19, -5.637429367110268e-22,  3.010552145474381e-24, -1.565896119722563e-26,  1.032962428548818e-02, -1.235350618035476e-04,  1.308560929429110e-06,
 -1.169902982382097e-08,  9.407582868423731e-11, -6.986355483200263e-13,  4.870711639700621e-15, -3.223695611177494e-17,  2.041823475361710e-19, -1.245063677276806e-21,
  7.343311558989683e-24, -4.204449083610121e-26,  5.849200042742559e-03, -8.904681914529477e-05,  1.102427360198937e-06, -1.134108140121310e-08,  1.036530323033000e-10,
 -8.669176573842286e-13,  6.759227755337111e-15, -4.974829375521557e-17,  3.487458622527363e-19, -2.344193571487466e-21,  1.518710535279572e-23, -9.521778466215505e-26,
  3.055702188298493e-03, -5.803537468571902e-05,  8.337995515596836e-07, -9.805563171143854e-09,  1.012294186214462e-10, -9.481221542832402e-13,  8.223657001987776e-15,
 -6.697249427672452e-17,  5.171646040453421e-19, -3.814574903593907e-21,  2.702747855778399e-23, -1.847719268110274e-25,  1.473213627039847e-03, -3.429773412973536e-05,
  5.685283232890907e-07, -7.599465740196027e-09,  8.816080675334383e-11, -9.203420092826544e-13,  8.841504275593348e-15, -7.934351823847062e-17,  6.722593868728857e-19,
 -5.420661851577117e-21,  4.185210573369346e-23, -3.108972088420610e-25,  6.557384188747564e-04, -1.843050284801523e-05,  3.506713420623206e-07, -5.301159937297673e-09,
  6.880327456887626e-11, -7.973790003315302e-13,  8.452949416340849e-15, -8.329779716654589e-17,  7.718181580476812e-19, -6.781954662424509e-21,  5.688601198126221e-23,
 -4.578253553393412e-25,  2.695966770853292e-04, -9.028474200876514e-06,  1.962324375910909e-07, -3.340084375528561e-09,  4.831541900083035e-11, -6.194839028711099e-13,
  7.223712513134243e-15, -7.793496903703318e-17,  7.874897671386786e-19, -7.520385899001212e-21,  6.835244252787416e-23, -5.945118639211094e-25,  1.024406859583442e-04,
 -4.041237401792952e-06,  9.988387275481738e-08, -1.906713584760872e-09,  3.063720982699395e-11, -4.332906619997715e-13,  5.542427787465877e-15, -6.529819398491901e-17,
  7.177765143052205e-19, -7.432489139265383e-21,  7.303778650745651e-23, -6.850733671336575e-25,  3.600100327306343e-05, -1.656489685719950e-06,  4.635820185642652e-08,
 -9.889628047046926e-10,  1.759887909502721e-11, -2.738116788377822e-13,  3.832782993011960e-15, -4.920051613620410e-17,  5.871044164362556e-19, -6.578667147815452e-21,
  6.976150289483037e-23, -7.043433495371298e-25,  1.171161269738154e-05, -6.230909343548446e-07,  1.966422961712402e-08, -4.672989743750082e-10,  9.184969153382686e-12,
 -1.568404822494224e-13,  2.397366296127399e-15, -3.346464601817208e-17,  4.326979808394096e-19, -5.237480361690084e-21,  5.983242778436794e-23, -6.492080423300395e-25,
  3.530471071840192e-06, -2.155301545051080e-07,  7.641003628371961e-09, -2.016746358078319e-10,  4.367735985986427e-12, -8.168282358847613e-14,  1.360797388703534e-15,
 -2.061962350159519e-17,  2.884174858596203e-19, -3.765327431329202e-21,  4.627150406917807e-23, -5.387971416249068e-25,  9.874364426142106e-07, -6.870444957703277e-08,
  2.726280737319583e-09, -7.970240019813851e-11,  1.897723996062011e-12, -3.879429207757627e-14,  7.031900876328085e-16, -1.154821948664859e-17,  1.744880332131241e-19,
 -2.453551471725587e-21,  3.239194960412435e-23, -4.042694364134886e-25,  2.566273763564655e-07, -2.022823793251150e-08,  8.953809654191959e-10, -2.892073083753304e-11,
  7.555046160027695e-13, -1.685273835225975e-14,  3.318503747104605e-16, -5.898291093229170e-18,  9.614334820164148e-20, -1.454337741587975e-21,  2.060318695960432e-23,
 -2.753012957461763e-25,  6.208711095268437e-08, -5.514211494311738e-09,  2.713984253558024e-10, -9.662319936519427e-12,  2.764064420530339e-13, -6.717033868213979e-15,
  1.434821960215213e-16, -2.756546458206166e-18,  4.841580839939593e-20, -7.869918839010107e-22,  1.195126448613935e-23, -1.708029491469246e-25,  1.401348879947476e-08,
 -1.395493426220634e-09,  7.614094608966991e-11, -2.981247582969654e-12,  9.322417963851515e-14, -2.464335416543673e-15,  5.702915002626428e-17, -1.182862262635633e-18,
  2.236221595855539e-20, -3.902095911788804e-22,  6.346068346965491e-24, -9.691743362519622e-26,  2.958431968642761e-09, -3.288537501524783e-10,  1.983473665811617e-11,
 -8.523069995764431e-13,  2.908422732657846e-14, -8.351315371953778e-16,  2.091186907180827e-17, -4.677585012816605e-19,  9.508787476908337e-21, -1.779526636955321e-22,
  3.096675252502179e-24, -5.049496086870375e-26,  5.859852105312801e-10, -7.241055633826618e-11,  4.814927059883522e-12, -2.266078507805340e-13,  8.424948411350938e-15,
 -2.624240888118467e-16,  7.101884317757885e-18, -1.711359218702606e-19,  3.737285166159974e-21, -7.494665263124103e-23,  1.394352467916449e-24, -2.425731240381654e-26,
  1.092983965135289e-10, -1.495689734723406e-11,  1.093649070818207e-12, -5.626475733905506e-14,  2.275529490612828e-15, -7.678741898673092e-17,  2.243365714748778e-18,
 -5.817946264564237e-20,  1.363642964853023e-21, -2.927849743524326e-23,  5.819125950868429e-25, -1.079250668000374e-26,  1.928111539138683e-11, -2.911435747323546e-12,
  2.335166939453223e-13, -1.310776106877943e-14,  5.757897975872757e-16, -2.102246854909309e-17,  6.622913637005896e-19, -1.846673967014811e-20,  4.641379955638805e-22,
 -1.066076187713121e-23,  2.261781386757488e-25, -4.468804508546043e-27,  3.233536965453260e-12, -5.369144795144153e-13,  4.712410597198360e-14, -2.880675952316298e-15,
  1.372324021256193e-16, -5.414114927804129e-18,  1.837213650155297e-19, -5.502210201925702e-21,  1.481580048555003e-22, -3.637434659565793e-24,  8.231345539691014e-26,
 -1.731268389711145e-27,  5.186691488074176e-13, -9.438856651480265e-14,  9.043777247225400e-15, -6.009343129969716e-16,  3.099863857324915e-17, -1.319742035684548e-18,
  4.818185887425869e-20, -1.548266644966400e-21,  4.462242807185294e-23, -1.169961700776692e-24,  2.821656050310324e-26, -6.312639317805364e-28,  8.014489914720422e-14,
 -1.593218595953903e-14,  1.662487868858117e-15, -1.198473081476573e-16,  6.683419596047203e-18, -3.066316895372206e-19,  1.202928009956314e-20, -4.142902621936105e-22,
  1.276703612849252e-23, -3.571467066960647e-25,  9.171708708670504e-27, -2.180731516938660e-28,  1.203025316521323e-14, -2.603800026374935e-15,  2.951748905743513e-16,
 -2.303950236977711e-17,  1.386622723935620e-18, -6.845424376611590e-20,  2.881849891552868e-21, -1.062458127390518e-22,  3.496940090243827e-24, -1.042624477270010e-25,
  2.848217499064542e-27, -7.190492122591582e-29,  1.771468538756112e-15, -4.160360670175837e-16,  5.110715927392403e-17, -4.309979504335845e-18,  2.794310225757457e-19,
 -1.481935672999330e-20,  6.685058366099830e-22, -2.634692213035164e-23,  9.250119661413476e-25, -2.935981046812752e-26,  8.522159338399660e-28, -2.281903382774140e-29,
  2.588061624503742e-16, -6.572196682943476e-17,  8.724907946442937e-18, -7.931438954418478e-19,  5.528184850765188e-20, -3.143796590644440e-21,  1.517074074016555e-22,
 -6.381755205743448e-24,  2.386521964722419e-25, -8.052644347322997e-27,  2.480362493217449e-28, -7.035169673728002e-30,  3.800669720460391e-17, -1.039739284157331e-17,
  1.487299749265148e-18, -1.453722295778946e-19,  1.086807369968777e-20, -6.613586669939638e-22,  3.407442055822578e-23, -1.527168072946149e-24,  6.072675305985230e-26,
 -2.174785979588604e-27,  7.097406094870819e-29, -2.129216733659277e-30,  5.694237776062896e-18, -1.671508970132227e-18,  2.568061061749948e-19, -2.691173676061248e-20,
  2.152419650331023e-21, -1.398242878247914e-22,  7.674310344047553e-24, -3.656824468386643e-25,  1.543094215811288e-26, -5.854070251502537e-28,  2.020439466715273e-29,
 -6.399567998352412e-31,  8.849941917982149e-19, -2.775674049911843e-19,  4.563838181820833e-20, -5.111139167785699e-21,  4.360372081004937e-22, -3.015375844640307e-23,
  1.758422292225901e-24, -8.886099430129140e-26,  3.969719528626782e-27, -1.591699320811034e-28,  5.796906817178641e-30, -1.934449789654848e-31,  1.453313120373182e-19,
 -4.847654396087675e-20,  8.495971749304194e-21, -1.013099507977115e-21,  9.187235531439636e-23, -6.741485730583356e-24,  4.164119110199042e-25, -2.225127631135609e-26,
  1.049388129078310e-27, -4.434968194450618e-29,  1.699927865417222e-30, -5.961272737962020e-32,  2.572046387675476e-20, -9.078411042573894e-21,  1.688287153273234e-21,
 -2.134552701304364e-22,  2.049457144044027e-23, -1.589714885911636e-24,  1.036338274255141e-25, -5.835379233257644e-27,  2.895546248051760e-28, -1.285687246141053e-29,
  5.170374509941961e-31, -1.899586948099875e-32,  5.007225684594256e-21, -1.859997778182645e-21,  3.651677569616181e-22, -4.871725633838217e-23,  4.929700678738763e-24,
 -4.024406070934829e-25,  2.757177836977832e-26, -1.629299150050775e-27,  8.472967653181486e-29, -3.937665859520771e-30,  1.655276289575553e-31, -6.348639618020874e-33,
  1.093942783301936e-21, -4.251330876725665e-22,  8.761293679251014e-23, -1.226619064658591e-23,  1.301270549388800e-24, -1.112369044464560e-25,  7.970201040388554e-27,
 -4.919508558693508e-28,  2.668967512795453e-29, -1.292467037314226e-30,  5.654927822065702e-32, -2.254732498176982e-33,  2.728943207519850e-22, -1.102498439902123e-22,
  2.369866783515952e-23, -3.460469735939560e-24,  3.825768041350326e-25, -3.404789498112399e-26,  2.537107220075832e-27, -1.626875442872243e-28,  9.159690143094848e-30,
 -4.598489274377130e-31,  2.083759124315299e-32, -8.595761901671346e-34,  7.855829363935406e-23, -3.277068112501301e-23,  7.296162195823652e-24, -1.103544711771591e-24,
  1.262971866386592e-25, -1.162611291058707e-26,  8.953103236653792e-28, -5.927821348148130e-29,  3.443077668787346e-30, -1.781696132308451e-31,  8.314870364946100e-33,
 -3.529371025323616e-34,  2.596111267101491e-23, -1.110254546845380e-23,  2.540941274287802e-24, -3.950958746776411e-25,  4.646507203778081e-26, -4.392590272291825e-27,
  3.471525846295646e-28, -2.357237475125576e-29,  1.403197137025015e-30, -7.436637667232991e-32,  3.552090892786689e-33, -1.542080547067249e-34,  9.384888606178986e-24,
 -4.084118729665103e-24,  9.530375273935216e-25, -1.511159498760223e-25,  1.811755567463201e-26, -1.745318397137909e-27,  1.404918817312501e-28, -9.711828603125820e-30,
  5.882655941129198e-31, -3.170895070183379e-32,  1.539705849720401e-33, -6.791921906959732e-35,  2.929142013534754e-24, -1.287210264354065e-24,  3.036758238396182e-25,
 -4.868510584081320e-26,  5.900685566008138e-27, -5.745032891859507e-28,  4.672722961118569e-29, -3.262894092183281e-30,  1.995908593143606e-31, -1.086170359404105e-32,
  5.323395942575811e-34, -2.369496853142270e-35,  5.652805868151761e-02, -1.315251701256149e-04,  3.157982542134442e-07, -7.791124428822639e-10,  1.963605006131458e-12,
 -5.030101424067842e-15,  1.302165168238644e-17, -3.397821694054913e-20,  8.889217960645274e-23, -2.335412863332943e-25,  6.113557670494642e-28, -1.609806070039749e-30,
  5.201297810207736e-02, -1.434852247801141e-04,  4.714422353646504e-07, -1.639877155196953e-09,  5.717270466300010e-12, -1.965084864627434e-14,  6.639005940488569e-17,
 -2.207712155241538e-19,  7.237941543275320e-22, -2.344392652738912e-24,  7.509683960349615e-27, -2.383143789013340e-29,  4.403674881517813e-02, -1.596034322815095e-04,
  7.304374374965721e-07, -3.292954206332473e-09,  1.419295801353624e-11, -5.889195112422620e-14,  2.370973832098394e-16, -9.312200986934948e-19,  3.581357401062315e-21,
 -1.352403804041714e-23,  5.024944193120540e-26, -1.840179979275370e-28,  3.430769873479710e-02, -1.690498787272965e-04,  1.005362789495863e-06, -5.502359001423777e-09,
  2.814686602056136e-11, -1.370733639897640e-13,  6.421978625510710e-16, -2.913741764754253e-18,  1.286316485089699e-20, -5.545055851439428e-23,  2.340692067892639e-25,
 -9.696826381711474e-28,  2.459616274391721e-02, -1.641455717228594e-04,  1.204436023304876e-06, -7.797843665799479e-09,  4.656827576751882e-11, -2.621590752573700e-13,
  1.408000559904520e-15, -7.272580134172201e-18,  3.633812763173357e-20, -1.764187076828955e-22,  8.350938524806032e-25, -3.864744216675204e-27,  1.622857373892257e-02,
 -1.439520372964851e-04,  1.265386184599693e-06, -9.567834912101282e-09,  6.595269725061019e-11, -4.243371026157261e-13,  2.584099797948598e-15, -1.503759575334654e-17,
  8.420257075748764e-20, -4.560466853916734e-22,  2.398752544959958e-24, -1.229247775442279e-26,  9.855566662115409e-03, -1.136035613071023e-04,  1.176762517831228e-06,
 -1.029954096834632e-08,  8.120262220953614e-11, -5.918712379130337e-13,  4.053196426947699e-15, -2.636701696348010e-17,  1.642298864785379e-19, -9.852425166989059e-22,
  5.719075075907073e-24, -3.223814779906204e-26,  5.509827816572797e-03, -8.074484125934185e-05,  9.757402182741552e-07, -9.812977551317004e-09,  8.783026579007394e-11,
 -7.202245326425354e-13,  5.510617635594718e-15, -3.982916695609634e-17,  2.743500195285188e-19, -1.812911084857733e-21,  1.155128366430568e-23, -7.125388070388416e-26,
  2.836193315699131e-03, -5.180948541261594e-05,  7.252581292982682e-07, -8.327473857408672e-09,  8.409791187405611e-11, -7.715068808205132e-13,  6.560872749145975e-15,
 -5.242669497869157e-17,  3.974875484905159e-19, -2.880158052497957e-21,  2.005653119331104e-23, -1.348176671584667e-25,  1.344573683668161e-03, -3.009162975430181e-05,
  4.852261292203448e-07, -6.325332048658962e-09,  7.170781455120750e-11, -7.325438295893664e-13,  6.893878696877425e-15, -6.065540386098028e-17,  5.042193059079576e-19,
 -3.991328049495293e-21,  3.026831375342075e-23, -2.209482696555530e-25,  5.872491689514007e-04, -1.586201744316035e-05,  2.931699204139847e-07, -4.317611064179444e-09,
  5.470900363478468e-11, -6.199161967115537e-13,  6.432598404394812e-15, -6.210345408224023e-17,  5.641935177946990e-19, -4.863810899965711e-21,  4.004763067023416e-23,
 -3.165436461601603e-25,  2.363860373813064e-04, -7.606680858482453e-06,  1.604094483413495e-07, -2.657429112840410e-09,  3.749639533880267e-11, -4.696858750153939e-13,
  5.357113642754835e-15, -5.658660874757449e-17,  5.602536862472337e-19, -5.246076761822025e-21,  4.678002847289206e-23, -3.993987335668172e-25,  8.773992005614361e-05,
 -3.325969904135802e-06,  7.968032860068672e-08, -1.479195330037288e-09,  2.316591659835906e-11, -3.198455530403715e-13,  3.999120063772941e-15, -4.610073812348019e-17,
  4.962545992495932e-19, -5.035830731146258e-21,  4.852642592246553e-23, -4.465841870722295e-25,  3.004786207965815e-05, -1.328693292272494e-06,  3.601442094585092e-08,
 -7.466254777241208e-10,  1.294103543511445e-11, -1.964342702881553e-13,  2.686102474578772e-15, -3.371924216068345e-17,  3.938274359395346e-19, -4.322539310876813e-21,
  4.492761218242738e-23, -4.448697904230404e-25,  9.501598415318493e-06, -4.859286982535188e-07,  1.484420344024356e-08, -3.426002926003317e-10,  6.555032533769945e-12,
 -1.091421670992618e-13,  1.628855115874211e-15, -2.222385216205855e-17,  2.811251393023563e-19, -3.331654972697330e-21,  3.729025458148947e-23, -3.966704988977034e-25,
  2.776806176531568e-06, -1.630080165980680e-07,  5.591553545017881e-09, -1.432646546996532e-10,  3.018807095778680e-12, -5.502250216530223e-14,  8.945821150324544e-16,
 -1.324364008540661e-17,  1.811574876629552e-19, -2.314716420733795e-21,  2.785980140656249e-23, -3.179330149277488e-25,  7.508396257876404e-07, -5.025725095082006e-08,
  1.929124298648763e-09, -5.472849447504389e-11,  1.267356900371586e-12, -2.524044975817697e-14,  4.463315722487195e-16, -7.158899844187506e-18,  1.057451349174925e-19,
 -1.454838710905431e-21,  1.880614389255639e-23, -2.299652650520939e-25,  1.881021149090167e-07, -1.427094812716849e-08,  6.109999500258094e-10, -1.914682728874833e-11,
  4.863270202610084e-13, -1.056572781276970e-14,  2.029095614166525e-16, -3.521382004732477e-18,  5.609915686285278e-20, -8.300820154117180e-22,  1.151155940658513e-23,
 -1.506764546048469e-25,  4.373236895761217e-08, -3.740745772553559e-09,  1.780936386453885e-10, -6.150839618020093e-12,  1.710542879654745e-13, -4.047800027578879e-15,
  8.431134105031702e-17, -1.581235817825200e-18,  2.713869314455265e-20, -4.314353995777484e-22,  6.412598792933132e-24, -8.976144146227548e-26,  9.454601833101627e-09,
 -9.074219308333853e-10,  4.790232865237697e-11, -1.819544951985938e-12,  5.531033235091460e-14, -1.423630789829873e-15,  3.212167900542181e-17, -6.503307892217952e-19,
  1.201273326890990e-20, -2.049877070868816e-22,  3.262661837783894e-24, -4.879899264318809e-26,  1.905291086605112e-09, -2.042877532045059e-10,  1.192545523605144e-11,
 -4.972139836815835e-13,  1.649494831442125e-14, -4.611911064300491e-16,  1.125964785769256e-17, -2.458383005714346e-19,  4.882871230285575e-21, -8.936209074191114e-23,
  1.521876698317696e-24, -2.430379100999589e-26,  3.589358903837433e-10, -4.282264967787204e-11,  2.757297299549768e-12, -1.259502753595782e-13,  4.553297258605948e-15,
 -1.381207997434523e-16,  3.644892689763664e-18, -8.574128104041727e-20,  1.829636043403851e-21, -3.588351064993426e-23,  6.534095517826473e-25, -1.113356686206276e-26,
  6.343396359388377e-11, -8.389608651565547e-12,  5.943949362643514e-13, -2.969313931292445e-14,  1.168107336553877e-15, -3.839769063583169e-17,  1.094136545351592e-18,
 -2.770565090412360e-20,  6.346607308947328e-22, -1.332914744727087e-23,  2.593329385642889e-25, -4.711689067778153e-27,  1.056055712375694e-11, -1.542967390291105e-12,
  1.200055987461980e-13, -6.544696050957025e-15,  2.797768157917173e-16, -9.954545268462583e-18,  3.059834233894468e-19, -8.333107974852222e-21,  2.047563804548124e-22,
 -4.601674784867486e-24,  9.559715571396706e-26, -1.850794009625856e-27,  1.664465313338831e-12, -2.677655149240697e-13,  2.281012637019717e-14, -1.355738284506650e-15,
  6.289178484517456e-17, -2.419302001431807e-18,  8.013928343180027e-20, -2.345235230104053e-21,  6.176341524112165e-23, -1.484271368017425e-24,  3.290210309322414e-26,
 -6.783493626055316e-28,  2.498402439217193e-13, -4.411228803878695e-14,  4.106688552073310e-15, -2.655536037393591e-16,  1.334929209891613e-17, -5.545347757751375e-19,
  1.977513064913836e-20, -6.212962326835310e-22,  1.752275151307786e-23, -4.499463250754740e-25,  1.063523787463737e-26, -2.333476492846018e-28,  3.596748443508406e-14,
 -6.947901024897017e-15,  7.052980651627032e-16, -4.953148470543489e-17,  2.694295069116327e-18, -1.207126519365093e-19,  4.629227274660142e-21, -1.559933830846435e-22,
  4.707455234181182e-24, -1.290529020462094e-25,  3.250121819605365e-27, -7.583449595489561e-29,  5.007705301071676e-15, -1.055002335588469e-15,  1.165103819213186e-16,
 -8.870006708024885e-18,  5.212862601890303e-19, -2.515603130278747e-20,  1.036216364394942e-21, -3.741139138407192e-23,  1.206802003373635e-24, -3.528955258008844e-26,
  9.461325285670332e-28, -2.345711317312189e-29,  6.809470071641292e-16, -1.559525816367937e-16,  1.869203271532999e-17, -1.539625634543047e-18,  9.759512104566974e-20,
 -5.065386332899217e-21,  2.238204054072279e-22, -8.647394092794132e-24,  2.978413612882452e-25, -9.280467105283988e-27,  2.646184301079190e-28, -6.964428310115856e-30,
  9.148035406772320e-17, -2.269896942482012e-17,  2.945192650505172e-18, -2.619043335649968e-19,  1.787338763715839e-20, -9.960638710508147e-22,  4.714068581443421e-23,
 -1.946289177853940e-24,  7.148396766760061e-26, -2.370468666600682e-27,  7.179940219985867e-29, -2.003730557772755e-30,  1.230515698714577e-17, -3.296182986318010e-18,
  4.616950032169149e-19, -4.422020490138990e-20,  3.242040996784067e-21, -1.936255000830176e-22,  9.797756453385115e-24, -4.315685993580436e-25,  1.687641943663924e-26,
 -5.947142263458584e-28,  1.910825181484905e-29, -5.646803900527614e-31,  1.682958752126310e-18, -4.848123137413636e-19,  7.308306475883173e-20, -7.518809882310269e-21,
  5.907774557652466e-22, -3.772768583001872e-23,  2.036923901997445e-24, -9.553415094671702e-26,  3.970189961762708e-27, -1.484127807961761e-28,  5.049753301993397e-30,
 -1.577606563502721e-31,  2.381667767096173e-19, -7.347546746811628e-20,  1.187910049145362e-20, -1.308705844567654e-21,  1.098915092003060e-22, -7.484240389656176e-24,
  4.300670451900345e-25, -2.142693140039296e-26,  9.441936332470230e-28, -3.736105985700232e-29,  1.343397357671791e-30, -4.427994780540038e-32,  3.556263513921817e-20,
 -1.169577831875425e-20,  2.020072227173383e-21, -2.374665670145712e-22,  2.123886428286539e-23, -1.537825140431712e-24,  9.377435183479397e-26, -4.949050051739466e-27,
  2.306194883564736e-28, -9.634312646993175e-30,  3.651736123709330e-31, -1.266819789929015e-32,  5.723540343577990e-21, -1.996602344807578e-21,  3.667647868756802e-22,
 -4.581461629310110e-23,  4.347595534574766e-24, -3.334359836591252e-25,  2.150040420269288e-26, -1.197924990762635e-27,  5.883872509987921e-29, -2.586960763617602e-30,
  1.030482739072743e-31, -3.751334241271060e-33,  1.015405814673148e-21, -3.736477753528154e-22,  7.262860985579182e-23, -9.594540447793995e-24,  9.616280287302463e-25,
 -7.777977387042986e-26,  5.281319162954403e-27, -3.094016321173525e-28,  1.595615158270556e-29, -7.355696050398492e-31,  3.068060331077901e-32, -1.167886642323406e-33,
  2.030617861011142e-22, -7.834793438473165e-23,  1.602191865619832e-23, -2.226042838622250e-24,  2.343984928911043e-25, -1.989294219909434e-26,  1.415416814927197e-27,
 -8.677654353264722e-29,  4.677212287350039e-30, -2.250714761305626e-31,  9.787583835706847e-33, -3.879568414547394e-34,  4.670240165875845e-23, -1.877031446382320e-23,
  4.012143982088325e-24, -5.825888261701791e-25,  6.405871192051309e-26, -5.670901256107174e-27,  4.204124157473544e-28, -2.682490179672361e-29,  1.503080467696970e-30,
 -7.511080567740708e-32,  3.388334099638932e-33, -1.391689666151834e-34,  1.252139172458129e-23, -5.205476193163720e-24,  1.154626933754268e-24, -1.739858420055141e-25,
  1.983946973209607e-26, -1.819818228223587e-27,  1.396597840563587e-28, -9.216043193827930e-30,  5.335735102326056e-31, -2.752480222203649e-32,  1.280656750220826e-33,
 -5.420091412280845e-35,  3.904781184296824e-24, -1.666597961784793e-24,  3.805801527831998e-25, -5.904682453793668e-26,  6.929185088399356e-27, -6.536760852367771e-28,
  5.155553862487414e-29, -3.493801582882463e-30,  2.075774359240541e-31, -1.098071289063137e-32,  5.235468558434242e-34, -2.268937196596722e-35,  1.353290124221976e-24,
 -5.883605204345372e-25,  1.371482941319576e-25, -2.172319038630558e-26,  2.601677734439583e-27, -2.503686631354690e-28,  2.013352396057248e-29, -1.390416606419513e-30,
  8.414043972467951e-32, -4.531190991089349e-33,  2.198259127675645e-34, -9.688501943406052e-36,  4.122815268574240e-25, -1.811100699293157e-25,  4.270929913004926e-26,
 -6.844236259385771e-27,  8.291814417716701e-28, -8.069762377454075e-29,  6.560890403039607e-30, -4.579560785870441e-31,  2.800226866199258e-32, -1.523301363465037e-33,
  7.463035404943221e-35, -3.320669420588356e-36,  5.600695230461793e-02, -1.290356549256216e-04,  3.066341452458285e-07, -7.484829165657320e-10,  1.866052740312821e-12,
 -4.728684633605767e-15,  1.210885424268526e-17, -3.126360239663946e-20,  8.090832279709325e-23, -2.104465381707451e-25,  5.447488715302429e-28, -1.422027559819489e-30,
  5.144645780480651e-02, -1.397908752201596e-04,  4.522998727070681e-07, -1.551460446515669e-09,  5.339699601243414e-12, -1.812912507009632e-14,  6.052043905576743e-17,
 -1.989041874065060e-19,  6.445596098405200e-22, -2.063960382926654e-24,  6.536106686424353e-27, -2.051045099172888e-29,  4.340977715508650e-02, -1.539142216490244e-04,
  6.922466201271543e-07, -3.074989053162731e-09,  1.306997542452315e-11, -5.350199006836240e-14,  2.125571531565392e-16, -8.240338746667834e-19,  3.128802705319675e-21,
 -1.166702469592899e-23,  4.281338721351766e-26, -1.548713984661257e-28,  3.364717738562684e-02, -1.612636367410499e-04,  9.419487510122108e-07, -5.073130382319572e-09,
  2.555315064990559e-11, -1.225949012262654e-13,  5.660881082803441e-16, -2.532333229241445e-18,  1.102567919233877e-20, -4.688812993867643e-23,  1.952982273206627e-25,
 -7.984823037604349e-28,  2.395827616874936e-02, -1.548721003489679e-04,  1.115165192550577e-06, -7.092927616734816e-09,  4.164717518305156e-11, -2.306848959452036e-13,
  1.219737126704085e-15, -6.205248672699369e-18,  3.054949170667273e-20, -1.461821489030804e-22,  6.822017345410319e-25, -3.113368956949056e-27,  1.567230911543772e-02,
 -1.342708885508632e-04,  1.156634098957961e-06, -8.577253894379782e-09,  5.805354541609398e-11, -3.670813962716678e-13,  2.198427889838934e-15, -1.258828613652437e-17,
  6.938916242067980e-20, -3.700978021288440e-22,  1.917672966200921e-24, -9.683540528012477e-27,  9.419227889541885e-03, -1.046626185275235e-04,  1.060589302603039e-06,
 -9.089953777523505e-09,  7.028109978975312e-11, -5.028912467321206e-13,  3.383462221984731e-15, -2.163764085921205e-17,  1.325585654589851e-19, -7.825150042959551e-22,
  4.471271948333906e-24, -2.481838008993184e-26,  5.201746848823273e-03, -7.338710247124119e-05,  8.659631271361707e-07, -8.516105446215389e-09,  7.466287310984858e-11,
 -6.004175216884810e-13,  4.509100254383508e-15, -3.201081680119476e-17,  2.166982448656032e-19, -1.407966775391475e-21,  8.824572152740808e-24, -5.356481911009529e-26,
  2.639957430719200e-03, -4.638538397507383e-05,  6.329190570888139e-07, -7.097267408263683e-09,  7.013052094250219e-11, -6.303145333808879e-13,  5.256452477363337e-15,
 -4.122212905399588e-17,  3.069186922000953e-19, -2.185098309476699e-21,  1.495776585731300e-23, -9.887611885388245e-26,  1.231516195493648e-03, -2.649498993425540e-05,
  4.157502332938600e-07, -5.286770669567701e-09,  5.858279081779988e-11, -5.857725604423180e-13,  5.401378542841310e-15, -4.660349470442278e-17,  3.801684889498034e-19,
 -2.954853056857916e-21,  2.201346571449117e-23, -1.579306855821771e-25,  5.281835106489603e-04, -1.370991313065249e-05,  2.462271472082091e-07, -3.533621978455622e-09,
  4.372354796335203e-11, -4.845118469551849e-13,  4.922193340155063e-15, -4.656698073255808e-17,  4.148614347659419e-19, -3.509444383005003e-21,  2.837021752475343e-23,
 -2.202689908474096e-25,  2.083374119512086e-04, -6.441433920572311e-06,  1.318311998860154e-07, -2.126155222368266e-09,  2.926982061271045e-11, -3.582647673196722e-13,
  3.997678981566631e-15, -4.135087677930021e-17,  4.012299803121485e-19, -3.684456737054236e-21,  3.223913409032484e-23, -2.702329714467383e-25,  7.560680176327449e-05,
 -2.753681861408147e-06,  6.395858096685466e-08, -1.154909715994862e-09,  1.763284692953603e-11, -2.377170747396849e-13,  2.905831169818139e-15, -3.278194567642377e-17,
  3.456327974818321e-19, -3.437752732414297e-21,  3.248958023711019e-23, -2.934067697130295e-25,  2.525717865238049e-05, -1.073173305122496e-06,  2.817813487855145e-08,
 -5.677928294850331e-10,  9.587331364648252e-12, -1.420056670559147e-13,  1.897272198527049e-15, -2.329470053329513e-17,  2.663404274047608e-19, -2.863827031614278e-21,
  2.917971473950579e-23, -2.834080701935054e-25,  7.771667852081657e-06, -3.819899931091137e-07,  1.129659254012889e-08, -2.532530984609072e-10,  4.717529039417329e-12,
 -7.660162840772149e-14,  1.116370666809058e-15, -1.489000926381270e-17,  1.842973731331652e-19, -2.138758921782374e-21,  2.345715277700215e-23, -2.446536102397174e-25,
  2.204408646908712e-06, -1.244078127278406e-07,  4.129328901196532e-09, -1.027160161147428e-10,  2.106104888418565e-12, -3.741726348538793e-14,  5.937796918730944e-16,
 -8.589491498424354e-18,  1.149152717241137e-19, -1.437245351978220e-21,  1.694453767097208e-23, -1.895310312182362e-25,  5.769577099653350e-07, -3.714139980767522e-08,
  1.379104321734035e-09, -3.796908545573822e-11,  8.552193419798766e-13, -1.659516246365444e-14,  2.863132771723708e-16, -4.485597530002167e-18,  6.477997325663657e-20,
 -8.720907584716572e-22,  1.103899586770450e-23, -1.322692684277293e-25,  1.395067174084100e-07, -1.018420889552231e-08,  4.217256002601522e-10, -1.282171610114106e-11,
  3.166660902354843e-13, -6.700956869066780e-15,  1.255164781486324e-16, -2.127006431231201e-18,  3.312019653635081e-20, -4.794092516026403e-22,  6.508679041286924e-24,
 -8.345828815663389e-26,  3.120980982000576e-08, -2.570216723292467e-09,  1.183521082905092e-10, -3.965132672461540e-12,  1.071989142706643e-13, -2.470245149487920e-15,
  5.017264264599347e-17, -9.186220735371447e-19,  1.540694683453986e-20, -2.395545893896636e-22,  3.485094241571336e-24, -4.778162072403359e-26,  6.471760939598738e-09,
 -5.984166745171714e-10,  3.055845749519255e-11, -1.125962781728679e-12,  3.327050141276752e-14, -8.337959542481247e-16,  1.834256900032696e-17, -3.624887204557985e-19,
  6.542300872405639e-21, -1.091747495968040e-22,  1.700619858945704e-24, -2.491098950727088e-26,  1.246676317704507e-09, -1.288798251685390e-10,  7.279871571860808e-12,
 -2.944598472549618e-13,  9.495895653712216e-15, -2.585038627890276e-16,  6.153089017359078e-18, -1.311279451011335e-19,  2.544649582069513e-21, -4.553985103266169e-23,
  7.589985602077126e-25, -1.187043293906755e-26,  2.236959756640667e-10, -2.575406894467293e-11,  1.605272951384487e-12, -7.115482216859020e-14,  2.500909100008791e-15,
 -7.387097633247255e-17,  1.900687949379921e-18, -4.364310184751571e-20,  9.099476501811005e-22, -1.745220700514675e-23,  3.110160962566683e-25, -5.190193822164033e-27,
  3.751103236026070e-11, -4.792249184895389e-12,  3.288623284730557e-13, -1.594781514744357e-14,  6.101205676474131e-16, -1.953329724166824e-17,  5.427900849359663e-19,
 -1.341828801335019e-20,  3.003719847663276e-22, -6.169979148214100e-24,  1.175004015892314e-25, -2.091071456258343e-27,  5.901708106394487e-12, -8.338531854244781e-13,
  6.286179136397425e-14, -3.329731784440264e-15,  1.384841366429288e-16, -4.800629814780140e-18,  1.439449072648208e-19, -3.828183562463460e-21,  9.194387015595510e-23,
 -2.021481741608065e-24,  4.111504550941626e-26, -7.798741695689805e-28,  8.753685585268227e-13, -1.363482536274120e-13,  1.126809621828900e-14, -6.509183577689501e-16,
  2.939384763731571e-17, -1.102178108133047e-18,  3.563011599785675e-20, -1.018634749788398e-21,  2.623160882643470e-23, -6.169210624522760e-25,  1.339338471615473e-26,
 -2.706299456410839e-28,  1.231109328288679e-13, -2.107502565381658e-14,  1.905330779047790e-15, -1.198448594433854e-16,  5.868762052396000e-18, -2.377881922841385e-19,
  8.280185334283136e-21, -2.542790755054573e-22,  7.016057184520088e-24, -1.763929965281951e-25,  4.085240181850253e-27, -8.788677619481727e-29,  1.653065553059184e-14,
 -3.100740185338594e-15,  3.060312493785798e-16, -2.092638254183203e-17,  1.109832396798082e-18, -4.853771724265826e-20,  1.818896106794983e-21, -5.995006324092271e-23,
  1.771027942857383e-24, -4.756648285567896e-26,  1.174456360689837e-27, -2.688441059520295e-29,  2.136731684735358e-15, -4.378427807856614e-16,  4.707533421258572e-17,
 -3.493628325297967e-18,  2.003914510989847e-19, -9.448676421182101e-21,  3.806571853431287e-22, -1.345334338784765e-23,  4.251658348138996e-25, -1.218955346432596e-26,
  3.206347351076536e-28, -7.804282092484959e-30,  2.684932241641057e-16, -5.991749823878099e-17,  7.002251786686454e-18, -5.629890957079346e-19,  3.487297338281906e-20,
 -1.770453990845376e-21,  7.659139456469454e-23, -2.899588273329496e-24,  9.793528998396468e-26, -2.994561111969466e-27,  8.384470286052607e-29, -2.168224102678009e-30,
  3.317999175971468e-17, -8.038012047991825e-18,  1.018607257290230e-18, -8.855152961721707e-20,  5.913426486610807e-21, -3.227690486113867e-22,  1.497395120201216e-23,
 -6.064830159558833e-25,  2.186753841160931e-26, -7.123473551908346e-28,  2.120854842077435e-29, -5.821282799531292e-31,  4.087853211502837e-18, -1.071344827047527e-18,
  1.468344290179226e-19, -1.377169760154599e-20,  9.895657647284867e-22, -5.796942760657736e-23,  2.879398353723038e-24, -1.245859259996385e-25,  4.788808103849661e-27,
 -1.659770035861845e-28,  5.248074956145008e-30, -1.527078681874355e-31,  5.101265146565026e-19, -1.440988630248359e-19,  2.129772867989575e-20, -2.149651586862053e-21,
  1.658282978032428e-22, -1.040443679477192e-23,  5.522667939087355e-25, -2.548136161537727e-26,  1.042369832694355e-27, -3.837681276468955e-29,  1.286709422647310e-30,
 -3.963172207356670e-32,  6.566676331539378e-20, -1.991172736057783e-20,  3.163141726550393e-21, -3.425761762321489e-22,  2.829581448333890e-23, -1.896766216116731e-24,
  1.073408816371360e-25, -5.269791270848879e-27,  2.289426525830156e-28, -8.935762499781306e-30,  3.170779164176046e-31, -1.031852544511417e-32,  8.901465622840782e-21,
 -2.884368860519838e-21,  4.906238807122975e-22, -5.681995391019834e-23,  5.009118075918683e-24, -3.576773079378030e-25,  2.151990666296699e-26, -1.121135242692523e-27,
  5.159522303204671e-29, -2.129602902903620e-30,  7.978455830145809e-32, -2.736859290317115e-33,  1.299989366139165e-21, -4.479038535250844e-22,  8.122095698400559e-23,
 -1.001799376458168e-23,  9.390577427208878e-25, -7.117117104133298e-26,  4.536981229672556e-27, -2.500073101066264e-28,  1.214941675648309e-29, -5.287002882572002e-31,
  2.085156461078502e-32, -7.518192099661185e-34,  2.096002093505244e-22, -7.636303544268983e-23,  1.468772087294905e-23, -1.920289590100562e-24,  1.905351493522448e-25,
 -1.526171701614312e-26,  1.026577916450793e-27, -5.959711933546550e-29,  3.046625590471265e-30, -1.392618892534212e-31,  5.761206939036391e-33, -2.175787903880463e-34,
  3.824746023894168e-23, -1.464457938652625e-23,  2.970356877443538e-24, -4.093666471594525e-25,  4.276735277187617e-26, -3.601991887648936e-27,  2.544040425298465e-28,
 -1.548623754886030e-29,  8.289705821837003e-31, -3.962611691890577e-32,  1.712150643953648e-33, -6.744563652328810e-35,  8.082529820802586e-24, -3.230590708651610e-24,
  6.864242471188775e-25, -9.908392048915102e-26,  1.083197578227512e-26, -9.535548888475440e-28,  7.030913239876445e-29, -4.462669922357487e-30,  2.487912420509732e-31,
 -1.237156783148772e-32,  5.554544684071325e-34, -2.271000074549458e-35,  2.011428309211197e-24, -8.331570057880754e-25,  1.840660511909732e-25, -2.762600065735385e-26,
  3.137945898305635e-27, -2.867499125414657e-28,  2.192591341302189e-29, -1.441760204801300e-30,  8.318693152019104e-32, -4.277066091504392e-33,  1.983637513506690e-34,
 -8.369368641806153e-36,  5.901107396153640e-25, -2.513296968095432e-25,  5.725833359965497e-26, -8.862756885652139e-27,  1.037659982579232e-27, -9.767045698835029e-29,
  7.686570781128622e-30, -5.198061592679025e-31,  3.082037821693460e-32, -1.627162741089692e-33,  7.743294036758571e-35, -3.349583375722380e-36,  1.956036422902414e-25,
 -8.495441944135226e-26,  1.978055838178450e-26, -3.129502491619755e-27,  3.743839855268906e-28, -3.598881942997052e-29,  2.890973874381956e-30, -1.994431742925841e-31,
  1.205707257478869e-32, -6.486718589398791e-34,  3.143978270391922e-35, -1.384389725384846e-36,  5.808268467620448e-26, -2.550509960936847e-26,  6.011973614008635e-27,
 -9.630023168389647e-28,  1.166168745664601e-28, -1.134449589079779e-29,  9.219418495607468e-31, -6.432572764020455e-32,  3.931679531485345e-33, -2.137955128038382e-34,
  1.047031865627557e-35, -4.656995987760086e-37,  5.549565965375314e-02, -1.266180084637757e-04,  2.978284207253012e-07, -7.193671647702919e-10,  1.774315749655641e-12,
 -4.448290990604384e-15,  1.126861065651618e-17, -2.879166718289296e-20,  7.370984406751431e-23, -1.898581403657395e-25,  4.858632706702794e-28, -1.258282310920143e-30,
  5.089441520564375e-02, -1.362455209944189e-04,  4.341832438515514e-07, -1.468848846751730e-09,  4.991202651139553e-12, -1.674120250647184e-14,  5.522906414197027e-17,
 -1.794183750933962e-19,  5.747534795959805e-22, -1.819699899651942e-24,  5.697508288444289e-27, -1.768211386773517e-29,  4.280496742911886e-02, -1.485203726896216e-04,
  6.565670347025345e-07, -2.874160236365376e-09,  1.204913729727747e-11, -4.866655662059567e-14,  1.908250478246482e-16, -7.303147507404003e-19,  2.738041741225386e-21,
 -1.008331276156463e-23,  3.654879904217899e-26, -1.306120284361966e-28,  3.301681803339820e-02, -1.539647881995209e-04,  8.834457032212358e-07, -4.683180387208128e-09,
  2.323157005992962e-11, -1.098212891723217e-13,  4.998788877047193e-16, -2.205077455725573e-18,  9.470250292975068e-21, -3.973577328348321e-23,  1.633336920949512e-25,
 -6.591499779807029e-28,  2.335610689082696e-02, -1.462802518953696e-04,  1.033900933346726e-06, -6.461949006959770e-09,  3.731269160997025e-11, -2.033903822300439e-13,
  1.058921250723355e-15, -5.306855883792805e-18,  2.574681619786403e-20, -1.214479473648815e-22,  5.588593769890943e-25, -2.515455042719716e-27,  1.515310141520932e-02,
 -1.254142732975887e-04,  1.059046888109722e-06, -7.704378920083938e-09,  5.121223631767455e-11, -3.183096814011348e-13,  1.875140166376749e-15, -1.056699954112515e-17,
  5.734952478869175e-20, -3.012781405812181e-22,  1.538073764027338e-24, -7.654375057834660e-27,  9.016882022836344e-03, -9.659584214765942e-05,  9.579386835917527e-07,
 -8.041704433878851e-09,  6.098860274673176e-11, -4.285039153022346e-13,  2.832993806721713e-15, -1.781400486750289e-17,  1.073605050603716e-19, -6.237326613775993e-22,
  3.508851741595648e-24, -1.918117727693676e-26,  4.921434138607305e-03, -6.684873810533595e-05,  7.705594684842211e-07, -7.411977635405143e-09,  6.366796563501992e-11,
 -5.022156775400819e-13,  3.702718540486929e-15, -2.582369227104505e-17,  1.718354060470606e-19, -1.097975065197930e-21,  6.770418334159306e-24, -4.044647944046952e-26,
  2.464028928193173e-03, -4.164454026803174e-05,  5.540895477065321e-07, -6.069548344186114e-09,  5.869772872191969e-11, -5.169692491831427e-13,  4.228683181783476e-15,
 -3.255187636205472e-17,  2.380526298475805e-19, -1.665535758434938e-21,  1.120937029177713e-23, -7.288059970091327e-26,  1.131807821894358e-03, -2.340766526117115e-05,
  3.575679833663589e-07, -4.436546363235512e-09,  4.806468231808241e-11, -4.705160949587134e-13,  4.251941726025371e-15, -3.598287386203824e-17,  2.881001667861994e-19,
 -2.199093552905094e-21,  1.609730734529237e-23, -1.135218069534102e-25,  4.770308060626949e-04, -1.189851385638755e-05,  2.077210081528911e-07, -2.905566316572150e-09,
  3.511630814200545e-11, -3.806349260421818e-13,  3.786640866866149e-15, -3.511148564711966e-17,  3.068090678310654e-19, -2.547227862696970e-21,  2.022043450184176e-23,
 -1.542361758417591e-25,  1.845299497190394e-04, -5.481390928653681e-06,  1.089066554054393e-07, -1.710316526438382e-09,  2.297719318180207e-11, -2.748777239099644e-13,
  3.001313447443637e-15, -3.040641492922651e-17,  2.891948136196339e-19, -2.604810521570637e-21,  2.236877419672254e-23, -1.841089599740754e-25,  6.553396232778159e-05,
 -2.292990920342432e-06,  5.164699701924565e-08, -9.073206730173221e-10,  1.350756014275606e-11, -1.778480260306478e-13,  2.125826946532391e-15, -2.347427524874943e-17,
  2.424550831729162e-19, -2.364046393797525e-21,  2.191575700629471e-23, -1.942447328772037e-25,  2.137559927509963e-05, -8.725953373393795e-07,  2.219872833102121e-08,
 -4.348479753851463e-10,  7.154331592815311e-12, -1.034228404643077e-13,  1.350317069077781e-15, -1.621843375216509e-17,  1.815560986312339e-19, -1.912776890376057e-21,
  1.910832364947395e-23, -1.820650872582679e-25,  6.406875256571075e-06, -3.025978682464161e-07,  8.664236297337349e-09, -1.887037617042372e-10,  3.422819144705336e-12,
 -5.421051126616888e-14,  7.716192109029126e-16, -1.006248838241931e-17,  1.218812513304177e-19, -1.385232865876322e-21,  1.488924297846748e-23, -1.522812319240640e-25,
  1.765779876888746e-06, -9.578291110687919e-08,  3.076528826178296e-09, -7.430567672444221e-11,  1.482746256381409e-12, -2.568059259051448e-14,  3.978235190216338e-16,
 -5.623992217003561e-18,  7.359895407686643e-20, -9.011344826929965e-22,  1.040777654570601e-23, -1.141169725162273e-25,  4.478700929052130e-07, -2.772145677161786e-08,
  9.957256444731236e-10, -2.660628171177431e-11,  5.829557036083241e-13, -1.102278260492417e-14,  1.855656386782612e-16, -2.839965225862740e-18,  4.010377395042488e-20,
 -5.283437296163675e-22,  6.549522972511850e-24, -7.690353852502752e-26,  1.046524386460506e-07, -7.348927807616323e-09,  2.943219483721292e-10, -8.681820604874609e-12,
  2.085041482258192e-13, -4.297786751915760e-15,  7.852408407041190e-17, -1.299458622432672e-18,  1.977886561777285e-20, -2.800895353743328e-22,  3.722962757682983e-24,
 -4.676935420230288e-26,  2.255792755264773e-08, -1.787937505219771e-09,  7.962149201393206e-11, -2.587600463322163e-12,  6.800932237896899e-14, -1.526146774506772e-15,
  3.022741710876405e-17, -5.403188586795864e-19,  8.856008349450984e-21, -1.346814620890148e-22,  1.917917846777457e-24, -2.575648043903885e-26,  4.492738080921770e-09,
 -4.000731759180121e-10,  1.975954851549199e-11, -7.061909662284899e-13,  2.028307919229562e-14, -4.949239156952828e-16,  1.061546426247979e-17, -2.047743969263864e-19,
  3.611155103230114e-21, -5.893190292969647e-23,  8.984285595016719e-25, -1.288900054506985e-26,  8.284432330270544e-10, -8.253842544665329e-11,  4.510286561500201e-12,
 -1.769628270654812e-13,  5.546976513372396e-15, -1.470154213113251e-16,  3.411561023532005e-18, -7.096089454585562e-20,  1.345390625696214e-21, -2.354447792168689e-23,
  3.840203295988216e-25, -5.881714473063488e-27,  1.417866399733672e-10, -1.574509657230525e-11,  9.497686047766331e-13, -4.084409222483568e-14,  1.395494122323678e-15,
 -4.013277396523839e-17,  1.006720478449012e-18, -2.256216444928891e-20,  4.595992247157330e-22, -8.619687390083105e-24,  1.503289139887926e-25, -2.456817136197908e-27,
  2.259204466753665e-11, -2.786548068064185e-12,  1.851537399385603e-13, -8.713958473228513e-15,  3.241391836737615e-16, -1.010550763038790e-17,  2.738066990968621e-19,
 -6.607310033929655e-21,  1.445201509069864e-22, -2.903169963799012e-24,  5.411125436085841e-26, -9.431675058326283e-28,  3.363923192582306e-12, -4.593550768232450e-13,
  3.355223800710212e-14, -1.725606621011079e-15,  6.980544331097909e-17, -2.357115723233316e-18,  6.893144241998857e-20, -1.789890839756690e-21,  4.201341695307659e-23,
 -9.035254077791889e-25,  1.798928032458140e-26, -3.342655127014854e-28,  4.702025987931871e-13, -7.086791809006170e-14,  5.679052613103788e-15, -3.187251080318089e-16,
  1.400619726181783e-17, -5.117935250051278e-19,  1.614222387324123e-20, -4.507417016043555e-22,  1.134765429388275e-23, -2.611257677080591e-25,  5.551136506150146e-27,
 -1.099126939898144e-28,  6.204063861719882e-14, -1.029031304300221e-14,  9.029692166686352e-16, -5.522310930553448e-17,  2.633329426141383e-18, -1.040344266157154e-19,
  3.536347532600248e-21, -1.061198047327930e-22,  2.863822889229342e-24, -7.047894521621980e-26,  1.598991940098502e-27, -3.372153348872295e-29,  7.779136715673807e-15,
 -1.415877097500869e-15,  1.357860650916322e-16, -9.036248886547786e-18,  4.670480921420793e-19, -1.993094377496431e-20,  7.295819555811941e-22, -2.351237570440566e-23,
  6.797576997102337e-25, -1.788124486321211e-26,  4.327310421892867e-28, -9.715474232423995e-30,  9.344676988659685e-16, -1.861040775322953e-16,  1.946797970465544e-17,
 -1.407632091188289e-18,  7.876410982653903e-20, -3.627038706225554e-21,  1.428537114789662e-22, -4.940427919475175e-24,  1.529090050156216e-25, -4.296698390110010e-27,
  1.108498264645837e-28, -2.648035649784691e-30,  1.085919186574877e-16, -2.359471466487677e-17,  2.686737579851977e-18, -2.107321389231258e-19,  1.274853431134978e-20,
 -6.327776523218384e-22,  2.678887808227114e-23, -9.933323657952010e-25,  3.288701939301324e-26, -9.864178813467055e-28,  2.711046730699575e-29, -6.886159427719843e-31,
  1.235034063102892e-17, -2.918714074782051e-18,  3.609865591634653e-19, -3.065930557205277e-20,  2.002303459466950e-21, -1.069842142183457e-22,  4.862736684927605e-24,
 -1.931202803697241e-25,  6.832737820702524e-27, -2.185589701363340e-28,  6.393587612624094e-30, -1.725335671206221e-31,  1.393809286231385e-18, -3.570996731508487e-19,
  4.785454003707473e-20, -4.392230425923658e-21,  3.091239276028134e-22, -1.775198063964980e-23,  8.650745419440857e-25, -3.674884365566952e-26,  1.387780481684765e-27,
 -4.728623745882363e-29,  1.470742238522751e-30, -4.212073896096980e-32,  1.586459738181014e-19, -4.390760182772363e-20,  6.357967320900969e-21, -6.291535856712726e-22,
  4.761951715517848e-23, -2.933650145193340e-24,  1.530063424545771e-25, -6.941309772422779e-27,  2.793620811478050e-28, -1.012493811198394e-29,  3.343620047609270e-31,
 -1.014897328528598e-32,  1.855975047996829e-20, -5.527066528904938e-21,  8.620904423282027e-22, -9.172184192887835e-23,  7.447336592695332e-24, -4.910631177166072e-25,
  2.735286629144569e-26, -1.322512336186686e-27,  5.661623855790381e-29, -2.178607157630045e-30,  7.625319983763021e-32, -2.448855535873241e-33,  2.280602014546432e-21,
 -7.275631882490157e-22,  1.217927245794467e-22, -1.388674915085393e-23,  1.205922813164153e-24, -8.486838816328349e-26,  5.035262829751319e-27, -2.588135902475439e-28,
  1.175694244428213e-29, -4.792217111651000e-31,  1.773764792179872e-32, -6.013872522357191e-34,  3.015954383183533e-22, -1.025642443389903e-22,  1.834770322739733e-23,
 -2.233159665587045e-24,  2.066526345295759e-25, -1.546883021315539e-26,  9.743551992252933e-28, -5.307439400127602e-29,  2.550623132942217e-30, -1.098061658913472e-31,
  4.285894545114569e-33, -1.529895015628793e-34,  4.407426639990335e-23, -1.588884297618528e-23,  3.022295730470504e-24, -3.908436213331773e-25,  3.837125956446037e-26,
 -3.042168387250315e-27,  2.026166056770516e-28, -1.165095816500034e-29,  5.901368806975291e-31, -2.673627391800904e-32,  1.096600034896320e-33, -4.107241256650553e-35,
  7.315324889214898e-24, -2.778278172390775e-24,  5.586513906121105e-25, -7.633526151984824e-26,  7.908753560839066e-27, -6.607506467009518e-28,  4.630588996872845e-29,
 -2.797637179485781e-30,  1.486722266341176e-31, -7.057080055901005e-33,  3.028595486829394e-34, -1.185260714628038e-35,  1.415440034053906e-24, -5.624332101649940e-25,
  1.187471707442948e-25, -1.703330495564627e-26,  1.850709133408685e-27, -1.619545195332448e-28,  1.187300882945312e-29, -7.494270892801077e-31,  4.155629822674943e-32,
 -2.055759638607764e-33,  9.183695929477834e-35, -3.736674830194020e-36,  3.258034715357148e-25, -1.344263519222283e-25,  2.957209455572028e-26, -4.419630115908695e-27,
  4.999378218516655e-28, -4.550188588630185e-29,  3.465730829434357e-30, -2.270369527882653e-31,  1.305206181934505e-32, -6.687178279229607e-34,  3.090884064491188e-35,
 -1.299837013301451e-36,  8.963276192663179e-26, -3.808811825228336e-26,  8.655560239993946e-27, -1.336402057689610e-27,  1.560839501168194e-28, -1.465651962238685e-29,
  1.150790328357091e-30, -7.764841716019217e-32,  4.593967350479080e-33, -2.420304279701807e-34,  1.149431392198454e-35, -4.962459864420150e-37,  2.834340262204531e-26,
 -1.229668953229045e-26,  2.859660174410164e-27, -4.518798474201091e-28,  5.399408064487901e-29, -5.184305515496007e-30,  4.159826829929021e-31, -2.866636282773787e-32,
  1.731138078053185e-33, -9.303900924171270e-35,  4.504878772615216e-36, -1.981707881368830e-37,  8.190657162384427e-27, -3.595191819204196e-27,  8.470571536188953e-28,
 -1.356191798889717e-28,  1.641554439707833e-29, -1.596182782640985e-30,  1.296607188535229e-31, -9.042764331458604e-33,  5.524721517427744e-34, -3.002968424584338e-35,
  1.470063272034867e-36, -6.535975265813187e-38,  5.499389887526662e-02, -1.242694347752746e-04,  2.893634600490231e-07, -6.916754144469901e-10,  1.687990448069790e-12,
 -4.187257984196963e-15,  1.049446460093108e-17, -2.653866526082345e-20,  6.721182802854959e-23, -1.714874379023782e-25,  4.337117632272554e-28, -1.115461056551333e-30,
  5.035627030470703e-02, -1.328412271681874e-04,  4.170253926602717e-07, -1.391597849466706e-09,  4.669237145269106e-12, -1.547397022730374e-14,  5.045329597961526e-17,
 -1.620319031988074e-19,  5.131657581286310e-22, -1.606621829278254e-24,  4.973961726463418e-27, -1.526921704143780e-29,  4.222117710607384e-02, -1.434025911283071e-04,
  6.232024965869942e-07, -2.688918631474862e-09,  1.111999760355539e-11, -4.432256606498881e-14,  1.715502550174476e-16, -6.482341097600574e-19,  2.400029745774406e-21,
 -8.730077205098185e-24,  3.126027993891460e-26, -1.103764790085805e-28,  3.241474679619381e-02, -1.471158590404424e-04,  8.294073428266318e-07, -4.328415223183738e-09,
  2.115028562473103e-11, -9.853213552175307e-14,  4.421730129314083e-16, -1.923710908223796e-18,  8.150696108946080e-21, -3.374733703095295e-23,  1.369156048284169e-25,
 -5.454582250201548e-28,  2.278705112153662e-02, -1.383093693552077e-04,  9.598096647691466e-07, -5.896156465593036e-09,  3.348745367477954e-11, -1.796701660895356e-13,
  9.212361336559548e-16, -4.548804848948413e-18,  2.175175931402018e-20, -1.011588975515416e-22,  4.590661389035381e-25, -2.038206940953545e-27,  1.466782258645700e-02,
 -1.172982470818440e-04,  9.713082857982267e-07, -6.933564496455446e-09,  4.527314109048721e-11, -2.766590663172380e-13,  1.603407238149857e-15, -8.894105619408919e-18,
  4.753431393497433e-20, -2.459963950564371e-22,  1.237537130259323e-24, -6.070576147659201e-27,  8.645237093787639e-03, -8.930237373112129e-05,  8.670218431049623e-07,
 -7.130916053852341e-09,  5.305996250067404e-11, -3.661291726996476e-13,  2.379107509127751e-15, -1.471221868863489e-17,  8.724155439123474e-20, -4.989078504656200e-22,
  2.763670325382790e-24, -1.488103448828715e-26,  4.665828307519434e-03, -6.102345277240644e-05,  6.874113936961636e-07, -6.469051461351095e-09,  5.445679921239898e-11,
 -4.214405733648210e-13,  3.051048593827107e-15, -2.090841740748949e-17,  1.367825889043809e-19, -8.596658409856190e-22,  5.216121670391304e-24, -3.067345676552059e-26,
  2.305876461456315e-03, -3.748794787055164e-05,  4.865658008390459e-07, -5.207880649074693e-09,  4.930362446085220e-11, -4.256099419140763e-13,  3.415446796935449e-15,
 -2.581290893178189e-17,  1.854467034715200e-19, -1.275295950907632e-21,  8.440032484233623e-24, -5.398242572540610e-26,  1.043578628373703e-03, -2.074768281579791e-05,
  3.086501632615675e-07, -3.737574198676915e-09,  3.959830631126578e-11, -3.795869069886243e-13,  3.362421102435147e-15, -2.791522784930592e-17,  2.194120513873598e-19,
 -1.645049528355584e-21,  1.183368740578896e-23, -8.204756797687669e-26,  4.325522240773268e-04, -1.036720940526458e-05,  1.759892861219767e-07, -2.399984529166744e-09,
  2.833816398709381e-11, -3.005230446331993e-13,  2.928224646989403e-15, -2.661706983218874e-17,  2.281676679077003e-19, -1.859495597712837e-21,  1.449739686024504e-23,
 -1.086579759429111e-25,  1.642252111864979e-04, -4.686376833542089e-06,  9.041917793742078e-08, -1.383019865831134e-09,  1.813605025420138e-11, -2.120978713516957e-13,
  2.266540987669638e-15, -2.249455695372721e-17,  2.097482050475641e-19, -1.853380955314890e-21,  1.562279869467872e-23, -1.262810681145975e-25,  5.712424612960478e-05,
 -1.919945647880485e-06,  4.194689978622422e-08, -7.170919693159379e-10,  1.041177650176319e-11, -1.339117964928872e-13,  1.565488763905446e-15, -1.692363023547044e-17,
  1.712644058441412e-19, -1.637302689387923e-21,  1.489119131682183e-23, -1.295552300178141e-25,  1.820990266675945e-05, -7.140787194055914e-07,  1.760441800380581e-08,
 -3.353088650664644e-10,  5.376308421961633e-12, -7.586683382539596e-14,  9.681535307314564e-16, -1.137724956142937e-17,  1.247188496278274e-19, -1.287647855119556e-21,
  1.261374891175564e-23, -1.179188199845018e-25,  5.321983494035560e-06, -2.414870597647506e-07,  6.695618307989718e-09, -1.416945637112955e-10,  2.503071974190010e-12,
 -3.867419526363769e-14,  5.377248097225967e-16, -6.857183392298541e-18,  8.129229175841955e-20, -9.049830506055736e-22,  9.534237699728786e-24, -9.563434277136905e-26,
  1.426747316050596e-06, -7.436995775685088e-08,  2.311800012126168e-09, -5.422097941126920e-11,  1.053114780850027e-12, -1.778368420588064e-14,  2.689676822267119e-16,
 -3.716427441909058e-18,  4.758020373131907e-20, -5.703794749820581e-22,  6.454376898295421e-24, -6.938067094473278e-26,  3.510973925020197e-07, -2.088949606701118e-08,
  7.258547539217178e-10, -1.882529409745946e-11,  4.012757362197508e-13, -7.394338867126436e-15,  1.214791503452368e-16, -1.816364289630760e-18,  2.508272633138959e-20,
 -3.234168265031693e-22,  3.926678173098232e-24, -4.518680485396222e-26,  7.937828194268786e-08, -5.360290438532908e-09,  2.076207003919753e-10, -5.942198785554260e-12,
  1.387805571689217e-13, -2.786687393298777e-15,  4.966805512202704e-17, -8.027227384691408e-19,  1.194417676846804e-20, -1.654892148320116e-22,  2.153781280633583e-24,
 -2.650962367145784e-26,  1.650681496827089e-08, -1.258758894326279e-09,  5.420682179755825e-11, -1.708838516788213e-12,  4.366377868016566e-14, -9.542134345894781e-16,
  1.843105074235104e-17, -3.216637787715645e-19,  5.152554565592341e-21, -7.664759146958267e-23,  1.068455536883234e-24, -1.405548271875383e-26,  3.161827043775087e-09,
 -2.710481114185368e-10,  1.294581114656159e-11, -4.487443565104705e-13,  1.252787258737177e-14, -2.976363376687250e-16,  6.224323118186727e-18, -1.172032491170357e-19,
  2.019550732404645e-21, -3.223165404898621e-23,  4.809220763282498e-25, -6.757296367781575e-27,  5.588730659271883e-10, -5.363916206987071e-11,  2.834967539263647e-12,
 -1.078820971975106e-13,  3.286671823407127e-15, -8.480440052111512e-17,  1.918491508763967e-18, -3.894765122839933e-20,  7.214421022092915e-22, -1.234568380596324e-23,
  1.970574990371641e-25, -2.955724372244482e-27,  9.136341842685538e-11, -9.781319199151009e-12,  5.708495165278283e-13, -2.381286123326162e-14,  7.907886517019513e-16,
 -2.214039292426291e-17,  5.414208853366283e-19, -1.184259608228646e-20,  2.356785413051316e-22, -4.322052530652121e-24,  7.376337588316476e-26, -1.180546060944050e-27,
  1.385285158497929e-11, -1.648740969626258e-12,  1.060388573439858e-13, -4.842173092931944e-15,  1.750968076761688e-16, -5.315046710849668e-18,  1.404004150108386e-19,
 -3.306871388622653e-21,  7.066760307147811e-23, -1.388179952443475e-24,  2.532121882374248e-26, -4.322385763055993e-28,  1.954918510964388e-12, -2.578527375678575e-13,
  1.824102081874604e-14, -9.106192295570735e-16,  3.582083840544909e-17, -1.177964505038766e-18,  3.359155375381590e-20, -8.514976242555727e-22,  1.953052754505684e-23,
 -4.107844338453025e-25,  8.005265713590705e-27, -1.456988195706908e-28,  2.578748638422878e-13, -3.758443660299929e-14,  2.919184140470020e-15, -1.591141464151034e-16,
  6.802292340282487e-18, -2.421561146799542e-19,  7.450174315974800e-21, -2.031434515325563e-22,  4.998841067115480e-24, -1.125314359391380e-25,  2.342091828332910e-27,
 -4.543391913006521e-29,  3.196506770079451e-14, -5.133526774456539e-15,  4.369967031965205e-16, -2.597409995276650e-17,  1.205657916096278e-18, -4.642853211488157e-20,
  1.540159750221096e-21, -4.515062873528622e-23,  1.191447014553545e-24, -2.869549464229116e-26,  6.376133372834477e-28, -1.317904784733003e-29,  3.747472900178004e-15,
 -6.613604220798560e-16,  6.159534380045803e-17, -3.987261097405804e-18,  2.007585583413384e-19, -8.356414551982906e-21,  2.986992479150562e-22, -9.409341080486455e-24,
  2.661399521628459e-25, -6.854894100907067e-27,  1.625514907639287e-28, -3.578572969781249e-30,  4.188172638756231e-16, -8.100423669990692e-17,  8.239290719760381e-18,
 -5.801058337715090e-19,  3.164999619299120e-20, -1.422787266559376e-21,  5.476229965353123e-23, -1.852551168196884e-24,  5.613426277599111e-26, -1.545466993694912e-27,
  3.909327434860920e-29, -9.162798171024818e-31,  4.505007729767137e-17, -9.522744810010192e-18,  1.055857834704421e-18, -8.074123953357505e-20,  4.767957136788767e-21,
 -2.312626311699125e-22,  9.576792278954091e-24, -3.476643933054173e-25,  1.127832565525704e-26, -3.317113437073421e-28,  8.945711274611366e-30, -2.231095776311464e-31,
  4.718239552736959e-18, -1.086860393678328e-18,  1.311002203862735e-19, -1.087121352974153e-20,  6.939309721933046e-22, -3.627515722238008e-23,  1.614616260528287e-24,
 -6.284597739303990e-26,  2.180910049121932e-27, -6.847174621546595e-29,  1.967300935716616e-30, -5.217412364894404e-32,  4.878833154777533e-19, -1.220925115597584e-19,
  1.598578207374813e-20, -1.434842218220084e-21,  9.884881725934442e-23, -5.561531523258972e-24,  2.657481621520368e-25, -1.107802666904801e-26,  4.108177977513681e-28,
 -1.375492882803068e-29,  4.206498627830232e-31, -1.185215504126679e-32,  5.064015499180872e-20, -1.372048530548805e-20,  1.945017439153776e-21, -1.885653008978778e-22,
  1.399413650816817e-23, -8.459986320262167e-25,  4.333055721590822e-26, -1.931750969396602e-27,  7.645092344670760e-29, -2.726308661088698e-30,  8.863631326711429e-32,
 -2.650131569155262e-33,  5.380104764110329e-21, -1.572235792925784e-21,  2.405997451652147e-22, -2.512989283586105e-23,  2.004454149298839e-24, -1.299297650684888e-25,
  7.119263036756248e-27, -3.388135045827260e-28,  1.428506207989508e-29, -5.416715026762814e-31,  1.869186274992732e-32, -5.921241017697056e-34,  5.984696065785345e-22,
 -1.878275826967857e-22,  3.092033770328808e-23, -3.468577422955140e-24,  2.965154951121971e-25, -2.055438749023512e-26,  1.201867188922351e-27, -6.091581020943068e-29,
  2.730021036089764e-30, -1.098359088489487e-31,  4.014542806531733e-33, -1.344685213189588e-34,  7.152256995899332e-23, -2.399019450757749e-23,  4.230817802711473e-24,
 -5.078151263719947e-25,  4.636276744590063e-26, -3.425606453967810e-27,  2.130855094457773e-28, -1.146766491288383e-29,  5.447243581606903e-31, -2.318864634435697e-32,
  8.953167650815352e-34, -3.162654389381124e-35,  9.448439357941758e-24, -3.368333099411946e-24,  6.332383701117909e-25, -8.095293292116966e-26,  7.859376884332416e-27,
 -6.164301486626077e-28,  4.063119796401097e-29, -2.313078905297076e-30,  1.160324129663825e-31, -5.208008305721072e-33,  2.116911590347500e-34, -7.860115703810198e-36,
  1.421838411506405e-24, -5.353516279770492e-25,  1.066628643776313e-25, -1.444313443536151e-26,  1.483269687222511e-27, -1.228715174731212e-28,  8.540408020246892e-30,
 -5.119021377053082e-31,  2.699594692217588e-32, -1.271984934157093e-33,  5.419963775207228e-35, -2.106585038847203e-36,  2.509918556887682e-25, -9.910939260310302e-26,
  2.078419174347763e-26, -2.961441043569882e-27,  3.196782392448802e-28, -2.779891894728432e-29,  2.025569883048978e-30, -1.271036158060109e-31,  7.008018826188201e-33,
 -3.447824887274343e-34,  1.532096016349329e-35, -6.202011818424330e-37,  5.323877074954126e-26, -2.187491585670658e-26,  4.790393461317670e-27, -7.127109007688320e-28,
  8.026557724723819e-29, -7.274217316441427e-30,  5.517666410482962e-31, -3.600151862180891e-32,  2.061700384352774e-33, -1.052369062551743e-34,  4.846643930283507e-36,
 -2.031125715965939e-37,  1.368799493633923e-26, -5.802376235058860e-27,  1.315066646046734e-27, -2.025014246932471e-28,  2.358919024825172e-29, -2.209437846223646e-30,
  1.730523687537151e-31, -1.164873467554951e-32,  6.875948413065641e-34, -3.614481609433044e-35,  1.712861013783810e-36, -7.379587555357881e-38,  4.117998577345387e-27,
 -1.784505187521931e-27,  4.144602828534613e-28, -6.540769180000916e-29,  7.805483327457317e-30, -7.485246782331977e-31,  5.998848809854475e-32, -4.129123257051511e-33,
  2.490719550566622e-34, -1.337152608723152e-35,  6.467497205165621e-37, -2.842138767760797e-38,  1.156196004931166e-27, -5.072808309259515e-28,  1.194618917785505e-28,
 -1.911725871416026e-29,  2.312862613166951e-30, -2.247868628634187e-31,  1.825133993190044e-32, -1.272301437711943e-33,  7.769734014527730e-35, -4.221413632906382e-36,
  2.065660254169015e-37, -9.180234034210816e-39,  5.450139902410236e-02, -1.219872746583339e-04,  2.812226822170679e-07, -6.653240921209629e-10,  1.606705002473857e-12,
 -3.944070374316838e-15,  9.780588109336936e-18, -2.448340898151539e-20,  6.133907172309163e-23, -1.550826732311521e-25,  3.874331960894061e-28, -9.909327187481497e-31,
  4.983147380338677e-02, -1.295705737916956e-04,  4.007644613911143e-07, -1.319301609111214e-09,  4.371508411556127e-12, -1.431573033753139e-14,  4.613787225619481e-17,
 -1.464988900636586e-19,  4.587524924668875e-22, -1.420469877472168e-24,  4.348646994470607e-27, -1.320733890109221e-29,  4.165733780674084e-02, -1.385430805575170e-04,
  5.919744480199609e-07, -2.517872597544350e-09,  1.027329179863413e-11, -4.041477009644071e-14,  1.544293331945782e-16, -5.762295369513634e-19,  2.107131669797254e-21,
 -7.571598746201272e-24,  2.678677474607813e-26, -9.346142708890875e-29,  3.183923284682210e-02, -1.406827574624259e-04,  7.794335753040164e-07, -4.005216998753166e-09,
  1.928154915160697e-11, -8.853796307095196e-14,  3.917852513259533e-16, -1.681315308306206e-18,  7.028851233280365e-21, -2.872198640374893e-23,  1.150288639083947e-25,
 -4.524523587059642e-28,  2.224873499955988e-02, -1.309050644633368e-04,  8.921557767180059e-07, -5.387945072875546e-09,  3.010522300121401e-11, -1.590134854020401e-13,
  8.030912007677322e-16, -3.907640279099503e-18,  1.842004482852958e-20, -8.447125224351997e-23,  3.780965812882235e-25, -1.656137225812824e-27,  1.421366042687562e-02,
 -1.098486849427916e-04,  8.922756870625073e-07, -6.251450527613600e-09,  4.010546047072416e-11, -2.410016817613312e-13,  1.374401525578315e-15, -7.505646560885951e-18,
  3.950866300081664e-20, -2.014499185907909e-22,  9.988122800671933e-25, -4.830139318546060e-27,  8.301377664604067e-03, -8.269458768063338e-05,  7.863126414742461e-07,
 -6.337569555306152e-09,  4.627656016252949e-11, -3.136742959104177e-13,  2.003694519363633e-15, -1.218774195003734e-17,  7.112243925944687e-20, -4.004233037836378e-22,
  2.184513599703807e-24, -1.158793282350244e-26,  4.432261529059315e-03, -5.582047953808908e-05,  6.147448425150199e-07, -5.661385100513767e-09,  4.671525900332002e-11,
 -3.547732484866261e-13,  2.522511497866135e-15, -1.698877237132155e-17,  1.092862494069550e-19, -6.757071697617747e-22,  4.035002507136179e-24, -2.336028728167436e-26,
  2.163332038545947e-03, -3.383260831343028e-05,  4.285372617398971e-07, -4.482900701539827e-09,  4.155588291664545e-11, -3.516819828637182e-13,  2.769302526430106e-15,
 -2.055240537334244e-17,  1.450808929262608e-19, -9.808205910413677e-22,  6.384135347305587e-24, -4.017525061086452e-26,  9.652567234823601e-04, -1.844766408134461e-05,
  2.673636925550149e-07, -3.160602754650871e-09,  3.275411701904146e-11, -3.075265444809750e-13,  2.670800915306168e-15, -2.175685666543569e-17,  1.679066539887454e-19,
 -1.236749789565924e-21,  8.744368037787705e-24, -5.961623541793486e-26,  3.937271256015659e-04, -9.067219580572236e-06,  1.497233008430262e-07, -1.991078493020804e-09,
  2.297412487470139e-11, -2.384220070138062e-13,  2.275849083814193e-15, -2.028358073990673e-17,  1.706057684405765e-19, -1.365063487698824e-21,  1.045425873242693e-23,
 -7.700358796618252e-26,  1.468278633437755e-04, -4.024779554944783e-06,  7.543303572420909e-08, -1.124024403776048e-09,  1.439071804728969e-11, -1.645582026684673e-13,
  1.721430875636498e-15, -1.673964416362207e-17,  1.530527941253222e-19, -1.326977545341354e-21,  1.098139671216509e-23, -8.718713421708090e-26,  5.006486049069814e-05,
 -1.616149900951688e-06,  3.425914269664892e-08, -5.700386657808186e-10,  8.073858681910436e-12, -1.014577270766737e-13,  1.160251748843582e-15, -1.228159248962891e-17,
  1.217975483245837e-19, -1.141852193418629e-21,  1.019012419487598e-23, -8.703699051560912e-26,  1.561169718233512e-05, -5.879834669857315e-07,  1.405057705693251e-08,
 -2.602648654739911e-10,  4.067685892704700e-12, -5.604250815167667e-14,  6.991354279800934e-16, -8.039873367315495e-18,  8.631940710996818e-20, -8.734807499948405e-22,
  8.391788862966493e-24, -7.698229014246309e-26,  4.453285405124464e-06, -1.940971498376329e-07,  5.212158403549939e-09, -1.071924432610345e-10,  1.844490344454992e-12,
 -2.780652271299040e-14,  3.777254989676481e-16, -4.711010734342070e-18,  5.467083046729203e-20, -5.962316040620975e-22,  6.157671833991049e-24, -6.058376145794315e-26,
  1.162506918637605e-06, -5.821663383227783e-08,  1.751556448719184e-09, -3.989831013816924e-11,  7.543791914005471e-13, -1.242245854783930e-14,  1.834601594184457e-16,
 -2.477990348282413e-18,  3.104078492333732e-20, -3.643730829715054e-22,  4.040292506199163e-24, -4.258341459724079e-26,  2.778628326865095e-07, -1.588741504515406e-08,
  5.340629600314434e-10, -1.344535558074442e-11,  2.788511924512084e-13, -5.008201965393837e-15,  8.030317946287696e-17, -1.173197784792305e-18,  1.584501393382764e-20,
 -1.999794221771520e-22,  2.378285150256087e-24, -2.682527636424157e-26,  6.085563878584179e-08, -3.950652054855381e-09,  1.479886798984208e-10, -4.109742669695137e-12,
  9.334841645836255e-14, -1.826141148370852e-15,  3.175369544849249e-17, -5.012471329152041e-19,  7.291788044667446e-21, -9.885624427119084e-23,  1.259834053721584e-24,
 -1.519428274606144e-26,  1.222425111591939e-08, -8.965602244117841e-10,  3.733292821897626e-11, -1.141615128850147e-12,  2.835988529921942e-14, -6.035977412362656e-16,
  1.137045998892168e-17, -1.937584102134880e-19,  3.033481528173059e-21, -4.414187937115177e-23,  6.023809082652622e-25, -7.762808084472129e-27,  2.254937500431257e-09,
 -1.860184946803880e-10,  8.590646245516747e-12, -2.888006157847439e-13,  7.836798889914936e-15, -1.812827076293175e-16,  3.696394124885989e-18, -6.794374658153311e-20,
  1.143993157770957e-21, -1.785621585667668e-23,  2.607685310100746e-25, -3.588641145105005e-27,  3.825874297162870e-10, -3.535810388192754e-11,  1.807125061637396e-12,
 -6.669095786138465e-14,  1.974607684233689e-15, -4.960026005895120e-17,  1.093878413517152e-18, -2.167416376897002e-20,  3.922404326260401e-22, -6.563557870123533e-24,
  1.025252382155636e-25, -1.505996856536102e-27,  5.982641278171076e-11, -6.172015665654930e-12,  3.484104048151715e-13, -1.409576160064278e-14,  4.549238570683807e-16,
 -1.239886327934950e-17,  2.955591639119799e-19, -6.309206880903681e-21,  1.226604217312156e-22, -2.199462438100027e-24,  3.673270231216190e-26, -5.756963897456986e-28,
  8.644417911746783e-12, -9.922569735471785e-13,  6.175107831497981e-14, -2.735362957250152e-15,  9.613944738127578e-17, -2.841022383634266e-18,  7.315823173596783e-20,
 -1.681663449167125e-21,  3.510790499324261e-23, -6.743393247682128e-25,  1.203677778749550e-26, -2.012137353256453e-28,  1.157866311663880e-12, -1.474325770005726e-13,
  1.009739181914064e-14, -4.891479563520486e-16,  1.870647537987325e-17, -5.989784769953413e-19,  1.665328439303261e-20, -4.120357657280744e-22,  9.233746840380665e-24,
 -1.899212079589640e-25,  3.622219640373896e-27, -6.456707644965573e-29,  1.443473866521397e-13, -2.033160803246121e-14,  1.529886514771467e-15, -8.095842267021003e-17,
  3.366092492229484e-18, -1.167144635580819e-19,  3.501899971262413e-21, -9.322388493659989e-23,  2.241836806357669e-24, -4.936248879840000e-26,  1.005673241781801e-27,
 -1.911079035854771e-29,  1.683297118583861e-14, -2.615751059585115e-15,  2.159020295170107e-16, -1.246678861436400e-17,  5.631000053645249e-19, -2.113014243517389e-20,
  6.838600439811515e-22, -1.958003252765754e-23,  5.051093390131452e-25, -1.190300126506971e-26,  2.589813922155571e-28, -5.245374760441202e-30,  1.847588579860061e-15,
 -3.159343967557985e-16,  2.855884195652168e-17, -1.797442921927035e-18,  8.812551096877077e-20, -3.576581972651483e-21,  1.247975973140248e-22, -3.841506507689636e-24,
  1.062729091490175e-25, -2.679444253963882e-27,  6.224370867752681e-29, -1.343330829099931e-30,  1.923362286737571e-16, -3.609961069101524e-17,  3.568050220133742e-18,
 -2.444923010012676e-19,  1.300030963460410e-20, -5.702662838224262e-22,  2.144138189155912e-23, -7.092517092554701e-25,  2.103300622501407e-26, -5.671857052994955e-28,
  1.406303917795087e-29, -3.233090464988683e-31,  1.916915003993623e-17, -3.938839879712220e-18,  4.249629598668840e-19, -3.166421411121791e-20,  1.824244480598889e-21,
 -8.642292164625250e-23,  3.499142965814366e-24, -1.243146166278177e-25,  3.949957819495332e-27, -1.138749296098399e-28,  3.012380577842320e-30, -7.374488119660431e-32,
  1.850156491488010e-18, -4.150681314545254e-19,  4.879400797705506e-20, -3.947898424216957e-21,  2.461627521721393e-22, -1.258306918058181e-23,  5.481889519033641e-25,
 -2.090249334590639e-26,  7.111515106154061e-28, -2.190564350961509e-29,  6.179139738290827e-31, -1.609920816225541e-32,  1.753569178957188e-19, -4.282630721831288e-20,
  5.474430955184128e-21, -4.801992306321175e-22,  3.236214321901467e-23, -1.782861985758509e-24,  8.348881754631771e-26, -3.413518288351306e-27,  1.242484157894921e-28,
 -4.085994303538329e-30,  1.228097385260929e-31, -3.402881529986494e-33,  1.659704518766017e-20, -4.398405346778367e-21,  6.099414188820222e-22, -5.789195119227046e-23,
  4.209917552383083e-24, -2.495926606879529e-25,  1.254673955360107e-26, -5.493863310952676e-28,  2.136941902772120e-29, -7.494472727847518e-31,  2.397664297051022e-32,
 -7.058330591542471e-34,  1.600374705233250e-21, -4.585495561054655e-22,  6.879316406100465e-23, -7.048609238023009e-24,  5.519434262655146e-25, -3.514875281394915e-26,
  1.893388383579082e-27, -8.864427665741098e-29,  3.678927357944802e-30, -1.373950453016572e-31,  4.672132829485028e-33, -1.459249630148683e-34,  1.609603160813433e-22,
 -4.965721339991310e-23,  8.032889908060605e-24, -8.859278380187687e-25,  7.450437681036915e-26, -5.083897292786894e-27,  2.927969278498636e-28, -1.462527671767982e-29,
  6.463029795121056e-31, -2.565246526247890e-32,  9.254251619004734e-34, -3.060903482752463e-35,  1.735081013070742e-23, -5.735982301208790e-24,  9.965351414631857e-25,
 -1.178754970731875e-25,  1.061090514889862e-26, -7.734098134551559e-28,  4.748252892912358e-29, -2.523316321555784e-30,  1.184101002337431e-31, -4.981848670637594e-33,
  1.901835343721568e-34, -6.645172186688375e-36,  2.066640022518903e-24, -7.280881891065027e-25,  1.351959616936879e-25, -1.707501906756716e-26,  1.638382940802538e-27,
 -1.270540874618440e-28,  8.283599494853596e-30, -4.666333600214322e-31,  2.317150167741606e-32, -1.029892400730247e-33,  4.146831325334726e-35, -1.525755477663319e-36,
  2.810571215934426e-25, -1.048562844194093e-25,  2.068898614532147e-26, -2.774737250208262e-27,  2.823171655635341e-28, -2.317720868260850e-29,  1.597049028796010e-30,
 -9.492702427803301e-32,  4.965847236534076e-33, -2.321622848138797e-34,  9.818349218160010e-36, -3.788545891805943e-37,  4.509782085450872e-26, -1.768905618959762e-26,
  3.682993980148637e-27, -5.210540744960841e-28,  5.585840451129999e-29, -4.824985465822067e-30,  3.493068899775317e-31, -2.178247650480692e-32,  1.193791800982530e-33,
 -5.839201261165134e-35,  2.580217340575215e-36, -1.038852814295231e-37,  8.781295049127306e-27, -3.592033244778613e-27,  7.828145557544002e-28, -1.159068459155993e-28,
  1.299227882273120e-29, -1.172102196958955e-30,  8.851629830362011e-32, -5.750983826499154e-33,  3.279923160543041e-34, -1.667570082978194e-35,  7.650570509301148e-37,
 -3.194381243895996e-38,  2.102360843412857e-27, -8.888766524668129e-28,  2.008809524068899e-28, -3.084451311392226e-29,  3.583025264960161e-30, -3.346886364055642e-31,
  2.614546612968532e-32, -1.755474945153898e-33,  1.033670600424979e-34, -5.420817379684643e-36,  2.562975011351489e-37, -1.101776350171274e-38,  6.000059578921212e-28,
 -2.596856776541543e-28,  6.023018750410973e-29, -9.492051886700033e-30,  1.131208460764430e-30, -1.083367879785063e-31,  8.671242914697284e-33, -5.961172684795454e-34,
  3.591498546951638e-35, -1.925861372082257e-36,  9.304416563177218e-38, -4.084355216622136e-39,  1.633833726988620e-28, -7.165202532865808e-29,  1.686508671821674e-29,
 -2.697500584685007e-30,  3.261857460920345e-31, -3.168613948078519e-32,  2.571467460931667e-33, -1.791715188544301e-34,  1.093660704354113e-35, -5.939318616207575e-37,
  2.904989240286786e-38, -1.290480369108995e-39,  5.401789953292729e-02, -1.197689976465255e-04,  2.733904743912126e-07, -6.402353386109881e-10,  1.530116532558667e-12,
 -3.717345936837188e-15,  9.121714094773203e-18, -2.260697860768522e-20,  5.602484216986107e-23, -1.404243468417531e-25,  3.462727657690913e-28, -8.824858481143346e-31,
  4.931950512313455e-02, -1.264266169033511e-04,  3.853432496534567e-07, -1.251589193013286e-09,  4.095943011605410e-12, -1.325603225921836e-14,  4.223396979515202e-17,
 -1.326045334024343e-19,  4.106114990177086e-22, -1.257607118238153e-24,  3.807338679829884e-27, -1.144263655985215e-29,  4.111244958293003e-02, -1.339254086714846e-04,
  5.627201767575525e-07, -2.359770267909242e-09,  9.500790883680989e-12, -3.689470449862540e-14,  1.391993527141768e-16, -5.129635500572849e-19,  1.852889488616895e-21,
 -6.578021389489537e-24,  2.299523517798532e-26, -7.929260016319659e-29,  3.128867558845655e-02, -1.346344260307140e-04,  7.331651772231200e-07, -3.710382959235191e-09,
  1.760113254087645e-11, -7.967554725350101e-14,  3.477080173700110e-16, -1.472085418933193e-18,  6.073099102542603e-21, -2.449544278727094e-23,  9.685347497457580e-26,
 -3.761792590963378e-28,  2.173899100040213e-02, -1.240184860690893e-04,  8.302888817711532e-07, -4.930692468983104e-09,  2.710916533238542e-11, -1.409883657507879e-13,
  7.014923081143264e-16, -3.364072120372143e-18,  1.563462314296622e-20, -7.070961302508434e-23,  3.122178533470379e-25, -1.349373521518664e-27,  1.378808191963397e-02,
 -1.029999954095935e-04,  8.209549600669337e-07, -5.646600176244501e-09,  3.559897126911839e-11, -2.104015143643982e-13,  1.180905714394994e-15, -6.350090835728696e-18,
  3.292719082227772e-20, -1.654439921586377e-22,  8.085768485908648e-25, -3.855361161794712e-27,  7.982715823157491e-03, -7.669616303058414e-05,  7.145054889066369e-07,
 -5.644831227610449e-09,  4.045759386317271e-11, -2.694362705291254e-13,  1.692248205396655e-15, -1.012655211939245e-17,  5.816448497978300e-20, -3.224466940269831e-22,
  1.732734071535814e-24, -9.056368261378600e-27,  4.218402516787866e-03, -5.116207939201422e-05,  5.510689655140318e-07, -4.967570221910533e-09,  4.018861712002173e-11,
 -2.995674318125610e-13,  2.092340149687307e-15, -1.385157404923544e-17,  8.763425787381280e-20, -5.331324494469156e-22,  3.133710333989610e-24, -1.786410172797168e-26,
  2.034532782128669e-03, -3.060869828257061e-05,  3.785108927400629e-07, -3.870851143337582e-09,  3.514284198558598e-11, -2.916306638111700e-13,  2.253855544585590e-15,
 -1.642874481161624e-17,  1.139715682489095e-19, -7.575983615724871e-22,  4.850689900075902e-24, -3.003848877447829e-26,  8.955156690259595e-04, -1.645200015233303e-05,
  2.323886279290903e-07, -2.682455111137235e-09,  2.719820546078060e-11, -2.501693227937353e-13,  2.130590947841700e-15, -1.703352160430117e-17,  1.290947759551506e-19,
 -9.343173416641031e-22,  6.494109751012974e-24, -4.354281536465209e-26,  3.597108655638747e-04, -7.959100015527001e-06,  1.278876274640835e-07, -1.658854864136298e-09,
  1.870889095089555e-11, -1.900426796336149e-13,  1.777491659167124e-15, -1.553595730471905e-17,  1.282395913799282e-19, -1.007570544540457e-21,  7.581134668896141e-24,
 -5.488680013232110e-26,  1.318554615543489e-04, -3.471590462348819e-06,  6.322450208305722e-08, -9.180074229356977e-10,  1.147741529971581e-11, -1.283562287266929e-13,
  1.314670460872369e-15, -1.252849275544813e-17,  1.123431385326251e-19, -9.558715828991560e-22,  7.767208600040779e-24, -6.058201812593710e-26,  4.410799298273907e-05,
 -1.367387461771975e-06,  2.813140654143768e-08, -4.556866522362650e-10,  6.297434558070457e-12, -7.733322518227831e-14,  8.652730287160331e-16, -8.970037162057407e-18,
  8.718952189352886e-20, -8.017104386935943e-22,  7.021428338081334e-24, -5.888639776829157e-26,  1.346624912327778e-05, -4.870447734630958e-07,  1.128366522621236e-08,
 -2.033082944920397e-10,  3.097891575697479e-12, -4.167941769926377e-14,  5.083889375002449e-16, -5.722086265629750e-18,  6.017971893888305e-20, -5.969579669496333e-22,
  5.625548848660828e-24, -5.064789984224255e-26,  3.752801050376150e-06, -1.570826933863035e-07,  4.086048861602819e-09, -8.167861776551826e-11,  1.369272762650213e-12,
 -2.014457484349039e-14,  2.673938552600633e-16, -3.262204696587244e-18,  3.706445832978963e-20, -3.960492594198273e-22,  4.010217882274602e-24, -3.870596986510438e-26,
  9.548996261702302e-07, -4.593154727741321e-08,  1.337713328309612e-09, -2.959832042607901e-11,  5.448728206089126e-13, -8.750865840176124e-15,  1.262135193686395e-16,
 -1.666704758168734e-18,  2.043075778757016e-20, -2.348723356078382e-22,  2.552288842510516e-24, -2.637873055482044e-26,  2.219341693068458e-07, -1.219142458776639e-08,
  3.964939853843147e-10, -9.690550671109504e-12,  1.955692057284582e-13, -3.423873205161403e-15,  5.358855589002801e-17, -7.650708359532139e-19,  1.010705849236580e-20,
 -1.248741308673051e-22,  1.454839832175114e-24, -1.608553307879240e-26,  4.714100732926245e-08, -2.941148112611802e-09,  1.065501083334569e-10, -2.871280207907684e-12,
  6.343313614565412e-14, -1.209074874537011e-15,  2.051292030813243e-17, -3.162988512499885e-19,  4.498975732791100e-21, -5.968723343182994e-23,  7.449165514466714e-25,
 -8.803943528479475e-27,  9.158365968416157e-09, -6.458099910391343e-10,  2.600114702292172e-11, -7.712700507453863e-13,  1.862841183712792e-14, -3.861577060380139e-16,
  7.094974958533894e-18, -1.180578510140644e-19,  1.806621190658178e-21, -2.571820397654014e-23,  3.435999054672021e-25, -4.337977972185252e-27,  1.629046918611121e-09,
 -1.292713122891470e-10,  5.771735055567478e-12, -1.881763258917808e-13,  4.963280795741834e-15, -1.117906398047375e-16,  2.222581115974996e-18, -3.988132044451591e-20,
  6.561760148628119e-22, -1.001711930665570e-23,  1.431859100442639e-25, -1.930052253952210e-27,  2.656698905085886e-10, -2.363223083257876e-11,  1.167772329420144e-12,
 -4.179022119761411e-14,  1.202473596531685e-15, -2.940429911254669e-17,  6.321745086295953e-19, -1.222540857029756e-20,  2.161556255499294e-22, -3.536969325452242e-24,
  5.406813484079333e-26, -7.777891023914156e-28,  3.979430785611660e-11, -3.954200754252270e-12,  2.158523816445440e-13, -8.468319058104716e-15,  2.655866459527812e-16,
 -7.045927199793890e-18,  1.637163731796895e-19, -3.410550851101921e-21,  6.477355290971389e-23, -1.135640719169262e-24,  1.855894165732435e-26, -2.848283606169404e-28,
  5.487437635122987e-12, -6.071655095429313e-13,  3.655124312542881e-14, -1.570280251081330e-15,  5.363472122023198e-17, -1.542806636877675e-18,  3.872444330715767e-20,
 -8.686652320569419e-22,  1.771535715242265e-23, -3.326929742833452e-25,  5.810887238990762e-27, -9.512042308068672e-29,  6.986585468635408e-13, -8.583103222621480e-14,
  5.689025221331530e-15, -2.673589727612948e-16,  9.938191038170417e-18, -3.097946425112461e-19,  8.396321688382995e-21, -2.027446035197095e-22,  4.438682481684258e-24,
 -8.926854309309471e-26,  1.666079672075348e-27, -2.908350677297621e-29,  8.243761047796402e-14, -1.121456025499304e-14,  8.171760055743273e-16, -4.196901983628823e-17,
  1.696648722640268e-18, -5.728600623059680e-20,  1.675898668049453e-21, -4.354913622178623e-23,  1.023280634933467e-24, -2.203482839680007e-26,  4.393763705618200e-28,
 -8.177947424384616e-30,  9.057119320197947e-15, -1.360909290016584e-15,  1.088608849707649e-16, -6.104247522143767e-18,  2.682037197889170e-19, -9.804178687448454e-21,
  3.094905394006601e-22, -8.652457765909153e-24,  2.181616151370190e-25, -5.029138811354235e-27,  1.071250991596319e-28, -2.125697891597479e-30,  9.319992984848257e-16,
 -1.543068928504770e-16,  1.353070571948972e-17, -8.276021934900864e-19,  3.949500647161515e-20, -1.562342570545093e-21,  5.319858861253357e-23, -1.599702438460054e-24,
  4.327259579065724e-26, -1.067717955981494e-27,  2.429202838949340e-29, -5.138314494715332e-31,  9.048818043906791e-17, -1.646860949302238e-17,  1.580750275840372e-18,
 -1.053624771011586e-19,  5.457530700734861e-21, -2.335060944283455e-22,  8.573199577011586e-24, -2.772033599393206e-25,  8.042695249653032e-27, -2.123660669529910e-28,
  5.159706164536674e-30, -1.163205130454488e-31,  8.365285057775892e-18, -1.669520623248732e-18,  1.751545599358521e-19, -1.270903339197408e-20,  7.139662289031112e-22,
 -3.302104928397816e-23,  1.306630811007802e-24, -4.541071643353564e-26,  1.412700612128309e-27, -3.990715060873358e-29,  1.035171809889229e-30, -2.486638488186765e-32,
  7.446944008159653e-19, -1.625689215413490e-19,  1.861179472849260e-20, -1.468367948332317e-21,  8.938376510199524e-23, -4.465442574793310e-24,  1.903177833037168e-25,
 -7.105725693228808e-27,  2.369134442352096e-28, -7.156939802403457e-30,  1.981272601811979e-31, -5.069353940781093e-33,  6.472894274017867e-20, -1.541422723098032e-20,
  1.922217973375108e-21, -1.646644453763433e-22,  1.084907041892850e-23, -5.848974973150025e-25,  2.682820316377410e-26, -1.075296804793460e-27,  3.839832250605704e-29,
 -1.239713122319262e-30,  3.660518123363157e-32, -9.970477313655734e-34,  5.586980913331892e-21, -1.446933684709871e-21,  1.961272526296696e-22, -1.821158619662272e-23,
  1.296840728742438e-24, -7.535501212526821e-26,  3.715655155059488e-27, -1.597117564584826e-28,  6.102562104387835e-30, -2.103802981015058e-31,  6.620051212301992e-33,
 -1.917962304174589e-34,  4.887358985271991e-22, -1.371822577701185e-22,  2.016007763109673e-23, -2.024853428426466e-24,  1.555512250903387e-25, -9.725543680282292e-27,
  5.147376692653834e-28, -2.369385102187085e-29,  9.674342771437240e-31, -3.556681426693358e-32,  1.191254280736377e-33, -3.666657352156903e-35,  4.439693986399156e-23,
 -1.345237481554101e-23,  2.136743546042077e-24, -2.315157457149008e-25,  1.914052466785168e-26, -1.284833476612939e-27,  7.284005861290404e-29, -3.583618391579239e-30,
  1.560674418720043e-31, -6.107922966147291e-33,  2.173752760646273e-34, -7.096360898695394e-36,  4.309033001433169e-24, -1.402902502533503e-24,  2.399290489243272e-25,
 -2.794848102923631e-26,  2.478932160253966e-27, -1.781309099460733e-28,  1.078732623572939e-29, -5.657494216694556e-31,  2.621343480362974e-32, -1.089449772921691e-33,
  4.110161480742552e-35, -1.419868230704193e-36,  4.615880382715672e-25, -1.605972020620610e-25,  2.943410321553223e-26, -3.670288003239605e-27,  3.478462488794042e-28,
 -2.665544642456877e-29,  1.718033767449525e-30, -9.571642834311415e-32,  4.702592556394646e-33, -2.068774723933645e-34,  8.247706292984336e-36, -3.005763725801164e-37,
  5.654858774516029e-26, -2.089205478246901e-26,  4.079844591806129e-27, -5.416488083533318e-28,  5.457055946180842e-29, -4.437665642485433e-30,  3.029922548577075e-31,
 -1.785115839244419e-32,  9.259145458936949e-34, -4.293404868752683e-35,  1.801385825437470e-36, -6.898040133959339e-38,  8.216737512601226e-27, -3.199978446402554e-27,
  6.611807647415617e-28, -9.283653508929472e-29,  9.879472045887220e-30, -8.473359586511019e-31,  6.092401539285794e-32, -3.774120045349934e-33,  2.055256298416710e-34,
 -9.991198142949696e-36,  4.388749048819735e-37, -1.756928950594234e-38,  1.462852429284191e-27, -5.955374390558722e-28,  1.291152413038234e-28, -1.901933257717102e-29,
  2.121274157013822e-30, -1.904455745369331e-31,  1.431507592191900e-32, -9.258656289218875e-34,  5.257428393891451e-35, -2.661728289186219e-36,  1.216205106592986e-37,
 -5.058226878461395e-39,  3.248895959255969e-28, -1.369797989259160e-28,  3.086181484191238e-29, -4.724254489450659e-30,  5.471533530279572e-31, -5.096155658970778e-32,
  3.969916117417276e-33, -2.658296802344328e-34,  1.561186108370715e-35, -8.166566675394405e-37,  3.851753435938885e-38, -1.651906313858822e-39,  8.768848469211659e-29,
 -3.790165014165296e-29,  8.777773148040036e-30, -1.381305075307175e-30,  1.643782570962233e-31, -1.572051660694681e-32,  1.256549154786437e-33, -8.626912976051352e-35,
  5.190904418897960e-36, -2.780055987484055e-37,  1.341515956622641e-38, -5.882016035119788e-40,  2.311387443292144e-29, -1.013178907484402e-29,  2.383490478185937e-30,
 -3.810229814468716e-31,  4.604920643711496e-32, -4.470936096545394e-33,  3.626495384810092e-34, -2.525557273722699e-35,  1.540842336568303e-36, -8.363820253722177e-38,
  4.088933794369277e-39, -1.815598827355150e-40,  5.354314971225696e-02, -1.176121945300928e-04,  2.658521260174009e-07, -6.163365663573450e-10,  1.457908580089806e-12,
 -3.505822734895295e-15,  8.513076474003324e-18, -2.089246906932189e-20,  5.120978732554894e-23, -1.273213185219192e-25,  3.095645779429343e-28, -7.882844481048404e-31,
  4.881987057345717e-02, -1.234028528884126e-04,  3.707088158952559e-07, -1.188121233100491e-09,  3.840665271829120e-12, -1.228552814222941e-14,  3.869839463178162e-17,
 -1.201609112855128e-19,  3.679618273635703e-22, -1.114920961728941e-24,  3.337981520860020e-27, -9.930041257874838e-30,  4.058557570435511e-02, -1.295343869395821e-04,
  5.352912338815490e-07, -2.213484016146842e-09,  8.795174957882370e-12, -3.371978836720580e-14,  1.256320947767478e-16, -4.572891062314822e-19,  1.631829991085632e-21,
 -5.724338020041564e-24,  1.977550649096713e-26, -6.740001544060289e-29,  3.076159314085724e-02, -1.289425337159782e-04,  6.902791359306544e-07, -3.441073144227543e-09,
  1.608784296148066e-11, -7.180400407488772e-14,  3.090829538017090e-16, -1.291139113757178e-18,  5.257186439387022e-21, -2.093299483864338e-23,  8.172531703404485e-26,
 -3.134762529311651e-28,  2.125583708028253e-02, -1.176056830747046e-04,  7.736328776755686e-07, -4.518620254354282e-09,  2.445040895932973e-11, -1.252286124899587e-13,
  6.139364543367013e-16, -2.902194066654551e-18,  1.330026958012275e-20, -5.933176370301396e-23,  2.584722026007363e-25, -1.102372134806352e-27,  1.338880133635036e-02,
 -9.669401971467009e-05,  7.564792221686794e-07, -5.109199356290123e-09,  3.166054912430592e-11, -1.840796311170325e-13,  1.017001823953785e-15, -5.385791466847014e-18,
  2.751470482175765e-20, -1.362541747243556e-22,  6.565062216521702e-25, -3.086834222522356e-27,  7.686949264943964e-03, -7.124046222284629e-05,  6.504805087106124e-07,
 -5.038505591067174e-09,  3.545308414588895e-11, -2.320247785557469e-13,  1.433108393653253e-15, -8.438383268812452e-18,  4.771357608503453e-20, -2.604952230723756e-22,
  1.379051056533415e-24, -7.102953876908737e-27,  4.022208620984883e-03, -4.698147798317746e-05,  4.951270065724363e-07, -4.369881110290105e-09,  3.466958023562872e-11,
 -2.537054173925514e-13,  1.741034880312397e-15, -1.133162745416791e-17,  7.052037462189296e-20, -4.221987816037544e-22,  2.443145729708738e-24, -1.371599434583481e-26,
  1.917872912159761e-03, -2.775727807391195e-05,  3.352510257239428e-07, -3.352436847345828e-09,  2.981592128553203e-11, -2.426699910373851e-13,  1.841062555398991e-15,
 -1.318302425348496e-17,  8.989384434886808e-20, -5.876385849687845e-22,  3.701676569502621e-24, -2.256108973727888e-26,  8.332319844417075e-04, -1.471461404164744e-05,
  2.026536584896477e-07, -2.284686766680253e-09,  2.266981568534021e-11, -2.043209718690407e-13,  1.706767126310029e-15, -1.339404245444660e-17,  9.970743521039566e-20,
 -7.091868446551618e-22,  4.846597376488015e-24, -3.196422302267809e-26,  3.298014160528404e-04, -7.010809718756689e-06,  1.096591176470038e-07, -1.387741557668872e-09,
  1.530166138255148e-11, -1.521707817282379e-13,  1.394874639106217e-15, -1.195854270724615e-17,  9.688947147772205e-20, -7.476522877743840e-22,  5.527758653232029e-24,
 -3.934305777920093e-26,  1.189150866176395e-04, -3.006921472419598e-06,  5.323077378829720e-08, -7.533037942429517e-10,  9.199368967219849e-12, -1.006372530869430e-13,
  1.009428310215149e-15, -9.428984230642729e-18,  8.293607403531696e-20, -6.926306116241515e-22,  5.527258545096921e-24, -4.235851964210036e-26,  3.905618543718784e-05,
 -1.162606884510733e-06,  2.322011503405062e-08, -3.662527453085444e-10,  4.939614442777817e-12, -5.929017625903982e-14,  6.491930015505639e-16, -6.592245198987641e-18,
  6.281531655288193e-20, -5.665955240230599e-22,  4.870669524745751e-24, -4.011525906707129e-26,  1.168426842118782e-05, -4.057509243113471e-07,  9.115862358714297e-09,
 -1.597985960198630e-10,  2.374384575392952e-12, -3.120150031858287e-14,  3.721863885489748e-16, -4.100768793604932e-18,  4.225421945966946e-20, -4.109430352519690e-22,
  3.799171427204738e-24, -3.357445673640575e-26,  3.184127591315937e-06, -1.279709332940947e-07,  3.225110286550893e-09, -6.267350734270650e-11,  1.023797647362478e-12,
 -1.470134257646289e-14,  1.907163993852263e-16, -2.276358824317990e-18,  2.532560564465731e-20, -2.651846773698690e-22,  2.632972883419009e-24, -2.493365306731584e-26,
  7.905203293308560e-07, -3.651466036385878e-08,  1.029558468522045e-09, -2.213054284680216e-11,  3.967177140334070e-13, -6.215037299681358e-15,  8.755597214310371e-17,
 -1.130570740763260e-18,  1.356369237168373e-20, -1.527278435613652e-22,  1.626687694114870e-24, -1.648840744179569e-26,  1.788446607862056e-07, -9.436208261255501e-09,
  2.969301960254877e-10, -7.046059074106884e-12,  1.383904275608860e-13, -2.362048615924472e-15,  3.609142445655606e-17, -5.035941300162712e-19,  6.508180859155695e-21,
 -7.872530344072947e-23,  8.986095221492000e-25, -9.740448478986234e-27,  3.688513665865449e-08, -2.210992734618128e-09,  7.746540939503576e-11, -2.025795188355186e-12,
  4.353371793379161e-14, -8.085700638945608e-16,  1.338605705468358e-17, -2.016421441291442e-19,  2.804633971344552e-21, -3.641540991105778e-23,  4.451128603070478e-25,
 -5.155639187159088e-27,  6.938976723571281e-09, -4.702868383020860e-10,  1.830652888833135e-11, -5.267653192530328e-13,  1.237074616242222e-14, -2.497821503965263e-16,
  4.476482007307904e-18, -7.274057143319676e-20,  1.088114429061623e-21, -1.515463977646187e-23,  1.982359325946507e-25, -2.452078043158320e-27,  1.191711512305530e-09,
 -9.093270047446980e-11,  3.924757243839523e-12, -1.240929812404949e-13,  3.181416991584681e-15, -6.977353201861018e-17,  1.352670655564146e-18, -2.369548755790182e-20,
  3.809913759681467e-22, -5.688738216223456e-24,  7.959511787253569e-26, -1.050919936251632e-27,  1.870581956421113e-10, -1.600877427790079e-11,  7.647034367285514e-13,
 -2.653467197481403e-14,  7.419719745687102e-16, -1.766246617821230e-17,  3.701867954672039e-19, -6.987249056013378e-21,  1.207008137084222e-22, -1.931351397675560e-24,
  2.889341291210995e-26, -4.070568279352525e-28,  2.687698513228715e-11, -2.571089873386974e-12,  1.356905630689001e-13, -5.161487367579624e-15,  1.572919599199833e-16,
 -4.061660007286133e-18,  9.198837794816954e-20, -1.870063082560378e-21,  3.469482922908480e-23, -5.947477007771454e-25,  9.510769225040413e-27, -1.429322249863620e-28,
  3.542126389192714e-12, -3.775941891538189e-13,  2.198203134852905e-14, -9.157217497951406e-16,  3.039167404054876e-17, -8.508775959013890e-19,  2.081564071452397e-20,
 -4.556364445937539e-22,  9.076570532266716e-24, -1.666528342426871e-25,  2.848115258777777e-27, -4.565127700833198e-29,  4.293141538540758e-13, -5.085715668154074e-14,
  3.261132097206047e-15, -1.486415807994020e-16,  5.369434711126759e-18, -1.629196787265423e-19,  4.303850759970560e-21, -1.014126719875463e-22,  2.168770906368646e-24,
 -4.264476750555289e-26,  7.787906821162135e-28, -1.331220547718763e-29,  4.801691494222619e-14, -6.304870476396794e-15,  4.447054104221484e-16, -2.215936751565253e-17,
  8.707789341950944e-19, -2.862389256946213e-20,  8.163316643644135e-22, -2.070304726328662e-23,  4.752498652595331e-25, -1.000686080999213e-26,  1.952697351624250e-28,
 -3.559377633704637e-30,  4.977541234504258e-15, -7.227129788585968e-16,  5.599894898931712e-17, -3.048143934369992e-18,  1.302359117904450e-19, -4.636462758089926e-21,
  1.427210832295142e-22, -3.895204351460169e-24,  9.597272575536150e-26, -2.163840499422497e-27,  4.511605501668976e-29, -8.769405718637700e-31,  4.808879133893647e-16,
 -7.703314804917118e-17,  6.548855602055787e-18, -3.890967205550453e-19,  1.806695700587430e-20, -6.963695150305513e-22,  2.313223034560317e-23, -6.793286195855024e-25,
  1.796366372726960e-26, -4.336662520013592e-28,  9.660972148689261e-30, -2.002410837880269e-31,  4.360366784000698e-17, -7.689108006787226e-18,  7.162990766811302e-19,
 -4.641748358186835e-20,  2.341091042811792e-21, -9.766168552926284e-23,  3.500099894020738e-24, -1.105855440371473e-25,  3.138109746862633e-27, -8.111177621358665e-29,
  1.930586140672617e-30, -4.266760146088270e-32,  3.743489129109076e-18, -7.250656848717829e-19,  7.392010644320501e-20, -5.220064616028731e-21,  2.858046105382391e-22,
 -1.289878115234711e-23,  4.986040257600930e-25, -1.694476296228808e-26,  5.159280687116413e-28, -1.427592398506523e-29,  3.629971953243910e-31, -8.553531771605458e-33,
  3.076714328780849e-19, -6.530134643619342e-20,  7.275486882240771e-21, -5.593445886212013e-22,  3.322172449538534e-23, -1.621223979738361e-24,  6.756469792460847e-26,
 -2.468966689538551e-27,  8.063632230777529e-29, -2.388026990696230e-30,  6.485399196178541e-32, -1.628996359093499e-33,  2.454150753868320e-20, -5.693434329572001e-21,
  6.921080969385398e-22, -5.786120901242728e-23,  3.724652710463239e-24, -1.963948637419151e-25,  8.818835263226112e-27, -3.463328699237392e-28,  1.212741796030784e-29,
 -3.842250329189105e-31,  1.114061321103669e-32, -2.981713003048428e-34,  1.932235945599158e-21, -4.885921124300461e-22,  6.468215058087553e-23, -5.871629815683474e-24,
  4.091582322305413e-25, -2.328710249586544e-26,  1.125672266750071e-27, -4.747141047307148e-29,  1.780922952125905e-30, -6.032135748920925e-32,  1.866100717973367e-33,
 -5.318467787651117e-35,  1.533011500475540e-22, -4.211511513513027e-23,  6.057774443709798e-24, -5.959806561814990e-25,  4.488476909219922e-26, -2.753486609194674e-27,
  1.430978227405869e-28, -6.472502043246308e-30,  2.598587186397328e-31, -9.399616145514877e-33,  3.099354064167412e-34, -9.396889451280408e-36,  1.256639014587008e-23,
 -3.736464146512632e-24,  5.822730834425419e-25, -6.193408371052767e-26,  5.030228531939067e-27, -3.319497547931853e-28,  1.851311872856891e-29, -8.965812368906259e-31,
  3.845886053229836e-32, -1.483321769057110e-33,  5.205187552904629e-35, -1.676366186218926e-36,  1.096344871731558e-24, -3.512372894453300e-25,  5.908666207973977e-26,
 -6.773180048172473e-27,  5.915327022442774e-28, -4.187838547350943e-29,  2.500052793016104e-30, -1.293242656044703e-31,  5.913207324470303e-33, -2.426384953751193e-34,
  9.041964905007503e-36, -3.086736913447848e-37,  1.053635582485030e-25, -3.617605226416969e-26,  6.539698622811896e-27, -8.045726923117000e-28,  7.526750968881970e-29,
 -5.695979489763690e-30,  3.627269032227596e-31, -1.997539486608734e-32,  9.704938678367620e-34, -4.223683465214833e-35,  1.666483483843310e-36, -6.012832610753385e-38,
  1.159042912283775e-26, -4.237896597888078e-27,  8.185822357888780e-28, -1.075154781582432e-28,  1.071993694423146e-29, -8.630346588287936e-31,  5.835846878107392e-32,
 -3.406367294043595e-33,  1.751040857979195e-34, -8.049488289884788e-36,  3.349254935853528e-37, -1.272263986652630e-38,  1.519246389605698e-27, -5.871706898407061e-28,
  1.203369494788632e-28, -1.676125271085623e-29,  1.769829021194422e-30, -1.506530026882222e-31,  1.075353980568858e-32, -6.615050323047680e-34,  3.578060567998059e-35,
 -1.728099421681175e-36,  7.543309039358041e-38, -3.001563456795986e-39,  2.462771470465114e-28, -9.974967715215767e-29,  2.150674166348338e-29, -3.150711936857726e-30,
  3.495346638743605e-31, -3.121902647334199e-32,  2.334933168211465e-33, -1.502925557210376e-34,  8.494654969495270e-36, -4.281445205652421e-37,  1.947853579045330e-38,
 -8.067534108781661e-40,  5.053653516828361e-29, -2.124338385592648e-29,  4.770468768599339e-30, -7.278670838546774e-31,  8.403139789368800e-32, -7.802456401332235e-33,
  6.059971369232473e-34, -4.046109017023136e-35,  2.369610250837147e-36, -1.236208517684168e-37,  5.815418375312029e-39, -2.487824803614609e-40,  1.285691528946290e-29,
 -5.549250311408758e-30,  1.283145168057888e-30, -2.016026392963431e-31,  2.395413161707956e-32, -2.287446217564478e-33,  1.825708373976318e-34, -1.251685326714692e-35,
  7.521253621040094e-37, -4.022789364198127e-38,  1.938717806658437e-39, -8.490030814058363e-41,  3.273806061998923e-30, -1.434324350745218e-30,  3.372320603776134e-31,
 -5.387886918289967e-32,  6.507953090950895e-33, -6.315104018616556e-34,  5.119580608837440e-35, -3.563488003082113e-36,  2.172964930224924e-37, -1.178911394296309e-38,
  5.760682090298360e-40, -2.556683288469195e-41,  };
  int offset = -42;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 42;
    if (std::isnan(t)) {
      fill_n(rr+offset, 42, 0.5);
      fill_n(ww+offset, 42, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 42; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=42; ++j) {
        const int boxof = it*504+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
