/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import java.util.Arrays;
import org.apache.tools.ant.Project;
import org.aspectj.internal.tools.ant.taskdefs.AntBuilder;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Builder;
import org.aspectj.internal.tools.build.Util;

public class TestBuildModule {
    private static final String SYNTAX = "java {classname} <[product|module]dir>";

    public static void main(String[] args) {
        if (null == args || 1 > args.length || !Util.canReadDir(new File(args[0]))) {
            System.err.println(SYNTAX);
            return;
        }
        File dir = new File(args[0]);
        if (Util.canReadDir(new File(dir, "dist"))) {
            TestBuildModule.createProduct(args);
        } else if (Util.canReadFile(new File(dir, ".classpath"))) {
            TestBuildModule.createModule(args);
        } else {
            System.err.println(SYNTAX);
        }
    }

    static void createModule(String[] args) {
        File jarDir;
        File moduleDir = new File(args[0]);
        File baseDir = moduleDir.getParentFile();
        if (null == baseDir) {
            baseDir = new File(".");
        }
        if (!Util.canReadDir(jarDir = new File(baseDir, "aj-build-jars")) && !jarDir.mkdirs()) {
            System.err.println("createModule unable to create " + jarDir);
            return;
        }
        BuildSpec buildSpec = new BuildSpec();
        buildSpec.moduleDir = moduleDir;
        buildSpec.jarDir = jarDir;
        buildSpec.verbose = true;
        buildSpec.failonerror = true;
        buildSpec.trimTesting = true;
        buildSpec.rebuild = true;
        File tempDir = null;
        Project project = new Project();
        project.setProperty("verbose", "true");
        project.setName("TestBuildModule.createModule" + Arrays.asList(args));
        Builder builder = AntBuilder.getBuilder("", project, tempDir);
        builder.build(buildSpec);
    }

    static void createProduct(String[] args) {
        throw new Error("unimplemented");
    }
}

