/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.ArgListExpr;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.CodeGenUtil;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;

public class MergedBinding
extends Binding {
    private final SetterStore.MultiAttributeSetter mMultiAttributeSetter;

    public MergedBinding(ExprModel model, SetterStore.MultiAttributeSetter multiAttributeSetter, BindingTarget target, Iterable<Binding> bindings) {
        super(target, MergedBinding.createMergedName(bindings), MergedBinding.createArgListExpr(model, bindings));
        this.mMultiAttributeSetter = multiAttributeSetter;
    }

    private static Expr createArgListExpr(ExprModel model, Iterable<Binding> bindings) {
        Expr expr = model.argListExpr(Iterables.transform(bindings, new Function<Binding, Expr>(){

            @Override
            public Expr apply(Binding input) {
                return input.getExpr();
            }
        }));
        expr.setBindingExpression(true);
        return expr;
    }

    private static String createMergedName(Iterable<Binding> bindings) {
        return Iterables.toString(Iterables.transform(bindings, new Function<Binding, String>(){

            @Override
            public String apply(Binding input) {
                return input.getName();
            }
        }));
    }

    @Override
    public int getMinApi() {
        return 1;
    }

    @Override
    public String toJavaCode(String targetViewName) {
        ArgListExpr args = (ArgListExpr)this.getExpr();
        String[] expressions = Iterables.toArray(Iterables.transform(args.getChildren(), new Function<Expr, String>(){

            @Override
            public String apply(Expr input) {
                return CodeGenUtil.Companion.toCode(input, false).generate();
            }
        }), String.class);
        L.d("merged binding arg: %s", args.getUniqueKey());
        return this.mMultiAttributeSetter.toJava(targetViewName, expressions);
    }
}

