/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _joystick_h
#define _joystick_h

#ifdef joystick_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

EXTERN void joystick_setPort (char * name);

EXTERN void joystick_calibrate(void);

EXTERN void joystick_getPosition(double *x1, double *y1,
	double *x2, double *y2, int *switches);

/**
 *  This procedure should be called just before you call joystick_getPosition().
 *  It processes any pending input from the Workstation Gameport.
 */
EXTERN int joystick_processInput(void);

#undef EXTERN
#endif
